// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package greengrass

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateConnectorDefinitionRequest
type UpdateConnectorDefinitionInput struct {
	_ struct{} `type:"structure"`

	// ConnectorDefinitionId is a required field
	ConnectorDefinitionId *string `location:"uri" locationName:"ConnectorDefinitionId" type:"string" required:"true"`

	Name *string `type:"string"`
}

// String returns the string representation
func (s UpdateConnectorDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateConnectorDefinitionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateConnectorDefinitionInput"}

	if s.ConnectorDefinitionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ConnectorDefinitionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateConnectorDefinitionInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ConnectorDefinitionId != nil {
		v := *s.ConnectorDefinitionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "ConnectorDefinitionId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateConnectorDefinitionResponse
type UpdateConnectorDefinitionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateConnectorDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateConnectorDefinitionOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opUpdateConnectorDefinition = "UpdateConnectorDefinition"

// UpdateConnectorDefinitionRequest returns a request value for making API operation for
// AWS Greengrass.
//
// Updates a connector definition.
//
//    // Example sending a request using UpdateConnectorDefinitionRequest.
//    req := client.UpdateConnectorDefinitionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateConnectorDefinition
func (c *Client) UpdateConnectorDefinitionRequest(input *UpdateConnectorDefinitionInput) UpdateConnectorDefinitionRequest {
	op := &aws.Operation{
		Name:       opUpdateConnectorDefinition,
		HTTPMethod: "PUT",
		HTTPPath:   "/greengrass/definition/connectors/{ConnectorDefinitionId}",
	}

	if input == nil {
		input = &UpdateConnectorDefinitionInput{}
	}

	req := c.newRequest(op, input, &UpdateConnectorDefinitionOutput{})
	return UpdateConnectorDefinitionRequest{Request: req, Input: input, Copy: c.UpdateConnectorDefinitionRequest}
}

// UpdateConnectorDefinitionRequest is the request type for the
// UpdateConnectorDefinition API operation.
type UpdateConnectorDefinitionRequest struct {
	*aws.Request
	Input *UpdateConnectorDefinitionInput
	Copy  func(*UpdateConnectorDefinitionInput) UpdateConnectorDefinitionRequest
}

// Send marshals and sends the UpdateConnectorDefinition API request.
func (r UpdateConnectorDefinitionRequest) Send(ctx context.Context) (*UpdateConnectorDefinitionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateConnectorDefinitionResponse{
		UpdateConnectorDefinitionOutput: r.Request.Data.(*UpdateConnectorDefinitionOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateConnectorDefinitionResponse is the response type for the
// UpdateConnectorDefinition API operation.
type UpdateConnectorDefinitionResponse struct {
	*UpdateConnectorDefinitionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateConnectorDefinition request.
func (r *UpdateConnectorDefinitionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
