// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package guardduty

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeleteFilterRequest
type DeleteFilterInput struct {
	_ struct{} `type:"structure"`

	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" type:"string" required:"true"`

	// FilterName is a required field
	FilterName *string `location:"uri" locationName:"filterName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteFilterInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFilterInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteFilterInput"}

	if s.DetectorId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DetectorId"))
	}

	if s.FilterName == nil {
		invalidParams.Add(aws.NewErrParamRequired("FilterName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteFilterInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	if s.DetectorId != nil {
		v := *s.DetectorId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "detectorId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FilterName != nil {
		v := *s.FilterName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "filterName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeleteFilterResponse
type DeleteFilterOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteFilterOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteFilterOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteFilter = "DeleteFilter"

// DeleteFilterRequest returns a request value for making API operation for
// Amazon GuardDuty.
//
// Deletes the filter specified by the filter name.
//
//    // Example sending a request using DeleteFilterRequest.
//    req := client.DeleteFilterRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeleteFilter
func (c *Client) DeleteFilterRequest(input *DeleteFilterInput) DeleteFilterRequest {
	op := &aws.Operation{
		Name:       opDeleteFilter,
		HTTPMethod: "DELETE",
		HTTPPath:   "/detector/{detectorId}/filter/{filterName}",
	}

	if input == nil {
		input = &DeleteFilterInput{}
	}

	req := c.newRequest(op, input, &DeleteFilterOutput{})
	return DeleteFilterRequest{Request: req, Input: input, Copy: c.DeleteFilterRequest}
}

// DeleteFilterRequest is the request type for the
// DeleteFilter API operation.
type DeleteFilterRequest struct {
	*aws.Request
	Input *DeleteFilterInput
	Copy  func(*DeleteFilterInput) DeleteFilterRequest
}

// Send marshals and sends the DeleteFilter API request.
func (r DeleteFilterRequest) Send(ctx context.Context) (*DeleteFilterResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteFilterResponse{
		DeleteFilterOutput: r.Request.Data.(*DeleteFilterOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteFilterResponse is the response type for the
// DeleteFilter API operation.
type DeleteFilterResponse struct {
	*DeleteFilterOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteFilter request.
func (r *DeleteFilterResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
