// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package guardduty

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// UpdateFilter request object.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateFilterRequest
type UpdateFilterInput struct {
	_ struct{} `type:"structure"`

	// Specifies the action that is to be applied to the findings that match the
	// filter.
	Action FilterAction `locationName:"action" type:"string" enum:"true"`

	// The description of the filter.
	Description *string `locationName:"description" type:"string"`

	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" type:"string" required:"true"`

	// FilterName is a required field
	FilterName *string `location:"uri" locationName:"filterName" type:"string" required:"true"`

	// Represents the criteria to be used in the filter for querying findings.
	FindingCriteria *FindingCriteria `locationName:"findingCriteria" type:"structure"`

	// Specifies the position of the filter in the list of current filters. Also
	// specifies the order in which this filter is applied to the findings.
	Rank *int64 `locationName:"rank" type:"integer"`
}

// String returns the string representation
func (s UpdateFilterInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFilterInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateFilterInput"}

	if s.DetectorId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DetectorId"))
	}

	if s.FilterName == nil {
		invalidParams.Add(aws.NewErrParamRequired("FilterName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateFilterInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	if len(s.Action) > 0 {
		v := s.Action

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "action", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FindingCriteria != nil {
		v := s.FindingCriteria

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "findingCriteria", v, metadata)
	}
	if s.Rank != nil {
		v := *s.Rank

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "rank", protocol.Int64Value(v), metadata)
	}
	if s.DetectorId != nil {
		v := *s.DetectorId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "detectorId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FilterName != nil {
		v := *s.FilterName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "filterName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// UpdateFilter response object.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateFilterResponse
type UpdateFilterOutput struct {
	_ struct{} `type:"structure"`

	// The name of the filter.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s UpdateFilterOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateFilterOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opUpdateFilter = "UpdateFilter"

// UpdateFilterRequest returns a request value for making API operation for
// Amazon GuardDuty.
//
// Updates the filter specified by the filter name.
//
//    // Example sending a request using UpdateFilterRequest.
//    req := client.UpdateFilterRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateFilter
func (c *Client) UpdateFilterRequest(input *UpdateFilterInput) UpdateFilterRequest {
	op := &aws.Operation{
		Name:       opUpdateFilter,
		HTTPMethod: "POST",
		HTTPPath:   "/detector/{detectorId}/filter/{filterName}",
	}

	if input == nil {
		input = &UpdateFilterInput{}
	}

	req := c.newRequest(op, input, &UpdateFilterOutput{})
	return UpdateFilterRequest{Request: req, Input: input, Copy: c.UpdateFilterRequest}
}

// UpdateFilterRequest is the request type for the
// UpdateFilter API operation.
type UpdateFilterRequest struct {
	*aws.Request
	Input *UpdateFilterInput
	Copy  func(*UpdateFilterInput) UpdateFilterRequest
}

// Send marshals and sends the UpdateFilter API request.
func (r UpdateFilterRequest) Send(ctx context.Context) (*UpdateFilterResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateFilterResponse{
		UpdateFilterOutput: r.Request.Data.(*UpdateFilterOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateFilterResponse is the response type for the
// UpdateFilter API operation.
type UpdateFilterResponse struct {
	*UpdateFilterOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateFilter request.
func (r *UpdateFilterResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
