// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iam

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/query"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateSigningCertificateRequest
type UpdateSigningCertificateInput struct {
	_ struct{} `type:"structure"`

	// The ID of the signing certificate you want to update.
	//
	// This parameter allows (through its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters that can consist of any upper or lowercased letter
	// or digit.
	//
	// CertificateId is a required field
	CertificateId *string `min:"24" type:"string" required:"true"`

	// The status you want to assign to the certificate. Active means that the certificate
	// can be used for API calls to AWS Inactive means that the certificate cannot
	// be used.
	//
	// Status is a required field
	Status StatusType `type:"string" required:"true" enum:"true"`

	// The name of the IAM user the signing certificate belongs to.
	//
	// This parameter allows (through its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: _+=,.@-
	UserName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateSigningCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSigningCertificateInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateSigningCertificateInput"}

	if s.CertificateId == nil {
		invalidParams.Add(aws.NewErrParamRequired("CertificateId"))
	}
	if s.CertificateId != nil && len(*s.CertificateId) < 24 {
		invalidParams.Add(aws.NewErrParamMinLen("CertificateId", 24))
	}
	if len(s.Status) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Status"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateSigningCertificateOutput
type UpdateSigningCertificateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateSigningCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateSigningCertificate = "UpdateSigningCertificate"

// UpdateSigningCertificateRequest returns a request value for making API operation for
// AWS Identity and Access Management.
//
// Changes the status of the specified user signing certificate from active
// to disabled, or vice versa. This operation can be used to disable an IAM
// user's signing certificate as part of a certificate rotation work flow.
//
// If the UserName field is not specified, the user name is determined implicitly
// based on the AWS access key ID used to sign the request. This operation works
// for access keys under the AWS account. Consequently, you can use this operation
// to manage AWS account root user credentials even if the AWS account has no
// associated users.
//
//    // Example sending a request using UpdateSigningCertificateRequest.
//    req := client.UpdateSigningCertificateRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateSigningCertificate
func (c *Client) UpdateSigningCertificateRequest(input *UpdateSigningCertificateInput) UpdateSigningCertificateRequest {
	op := &aws.Operation{
		Name:       opUpdateSigningCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateSigningCertificateInput{}
	}

	req := c.newRequest(op, input, &UpdateSigningCertificateOutput{})
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return UpdateSigningCertificateRequest{Request: req, Input: input, Copy: c.UpdateSigningCertificateRequest}
}

// UpdateSigningCertificateRequest is the request type for the
// UpdateSigningCertificate API operation.
type UpdateSigningCertificateRequest struct {
	*aws.Request
	Input *UpdateSigningCertificateInput
	Copy  func(*UpdateSigningCertificateInput) UpdateSigningCertificateRequest
}

// Send marshals and sends the UpdateSigningCertificate API request.
func (r UpdateSigningCertificateRequest) Send(ctx context.Context) (*UpdateSigningCertificateResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateSigningCertificateResponse{
		UpdateSigningCertificateOutput: r.Request.Data.(*UpdateSigningCertificateOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateSigningCertificateResponse is the response type for the
// UpdateSigningCertificate API operation.
type UpdateSigningCertificateResponse struct {
	*UpdateSigningCertificateOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateSigningCertificate request.
func (r *UpdateSigningCertificateResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
