// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iam

import (
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

var _ aws.Config
var _ = awsutil.Prettify

// Contains information about an AWS access key.
//
// This data type is used as a response element in the CreateAccessKey and ListAccessKeys
// operations.
//
// The SecretAccessKey value is returned only in response to CreateAccessKey.
// You can get a secret access key only when you first create an access key;
// you cannot recover the secret access key later. If you lose a secret access
// key, you must create a new access key.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/AccessKey
type AccessKey struct {
	_ struct{} `type:"structure"`

	// The ID for this access key.
	//
	// AccessKeyId is a required field
	AccessKeyId *string `min:"16" type:"string" required:"true"`

	// The date when the access key was created.
	CreateDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The secret key used to sign requests.
	//
	// SecretAccessKey is a required field
	SecretAccessKey *string `type:"string" required:"true"`

	// The status of the access key. Active means that the key is valid for API
	// calls, while Inactive means it is not.
	//
	// Status is a required field
	Status StatusType `type:"string" required:"true" enum:"true"`

	// The name of the IAM user that the access key is associated with.
	//
	// UserName is a required field
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AccessKey) String() string {
	return awsutil.Prettify(s)
}

// Contains information about the last time an AWS access key was used since
// IAM began tracking this information on April 22, 2015.
//
// This data type is used as a response element in the GetAccessKeyLastUsed
// operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/AccessKeyLastUsed
type AccessKeyLastUsed struct {
	_ struct{} `type:"structure"`

	// The date and time, in ISO 8601 date-time format (http://www.iso.org/iso/iso8601),
	// when the access key was most recently used. This field is null in the following
	// situations:
	//
	//    * The user does not have an access key.
	//
	//    * An access key exists but has not been used since IAM began tracking
	//    this information.
	//
	//    * There is no sign-in data associated with the user
	//
	// LastUsedDate is a required field
	LastUsedDate *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The AWS region where this access key was most recently used. The value for
	// this field is "N/A" in the following situations:
	//
	//    * The user does not have an access key.
	//
	//    * An access key exists but has not been used since IAM began tracking
	//    this information.
	//
	//    * There is no sign-in data associated with the user
	//
	// For more information about AWS regions, see Regions and Endpoints (https://docs.aws.amazon.com/general/latest/gr/rande.html)
	// in the Amazon Web Services General Reference.
	//
	// Region is a required field
	Region *string `type:"string" required:"true"`

	// The name of the AWS service with which this access key was most recently
	// used. The value of this field is "N/A" in the following situations:
	//
	//    * The user does not have an access key.
	//
	//    * An access key exists but has not been used since IAM started tracking
	//    this information.
	//
	//    * There is no sign-in data associated with the user
	//
	// ServiceName is a required field
	ServiceName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AccessKeyLastUsed) String() string {
	return awsutil.Prettify(s)
}

// Contains information about an AWS access key, without its secret key.
//
// This data type is used as a response element in the ListAccessKeys operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/AccessKeyMetadata
type AccessKeyMetadata struct {
	_ struct{} `type:"structure"`

	// The ID for this access key.
	AccessKeyId *string `min:"16" type:"string"`

	// The date when the access key was created.
	CreateDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The status of the access key. Active means that the key is valid for API
	// calls; Inactive means it is not.
	Status StatusType `type:"string" enum:"true"`

	// The name of the IAM user that the key is associated with.
	UserName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s AccessKeyMetadata) String() string {
	return awsutil.Prettify(s)
}

// Contains information about an attached permissions boundary.
//
// An attached permissions boundary is a managed policy that has been attached
// to a user or role to set the permissions boundary.
//
// For more information about permissions boundaries, see Permissions Boundaries
// for IAM Identities (https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html)
// in the IAM User Guide.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/AttachedPermissionsBoundary
type AttachedPermissionsBoundary struct {
	_ struct{} `type:"structure"`

	// The ARN of the policy used to set the permissions boundary for the user or
	// role.
	PermissionsBoundaryArn *string `min:"20" type:"string"`

	// The permissions boundary usage type that indicates what type of IAM resource
	// is used as the permissions boundary for an entity. This data type can only
	// have a value of Policy.
	PermissionsBoundaryType PermissionsBoundaryAttachmentType `type:"string" enum:"true"`
}

// String returns the string representation
func (s AttachedPermissionsBoundary) String() string {
	return awsutil.Prettify(s)
}

// Contains information about an attached policy.
//
// An attached policy is a managed policy that has been attached to a user,
// group, or role. This data type is used as a response element in the ListAttachedGroupPolicies,
// ListAttachedRolePolicies, ListAttachedUserPolicies, and GetAccountAuthorizationDetails
// operations.
//
// For more information about managed policies, refer to Managed Policies and
// Inline Policies (https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the Using IAM guide.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/AttachedPolicy
type AttachedPolicy struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN). ARNs are unique identifiers for AWS resources.
	//
	// For more information about ARNs, go to Amazon Resource Names (ARNs) and AWS
	// Service Namespaces (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	PolicyArn *string `min:"20" type:"string"`

	// The friendly name of the attached policy.
	PolicyName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s AttachedPolicy) String() string {
	return awsutil.Prettify(s)
}

// Contains information about a condition context key. It includes the name
// of the key and specifies the value (or values, if the context key supports
// multiple values) to use in the simulation. This information is used when
// evaluating the Condition elements of the input policies.
//
// This data type is used as an input parameter to SimulateCustomPolicy and
// SimulateCustomPolicy .
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ContextEntry
type ContextEntry struct {
	_ struct{} `type:"structure"`

	// The full name of a condition context key, including the service prefix. For
	// example, aws:SourceIp or s3:VersionId.
	ContextKeyName *string `min:"5" type:"string"`

	// The data type of the value (or values) specified in the ContextKeyValues
	// parameter.
	ContextKeyType ContextKeyTypeEnum `type:"string" enum:"true"`

	// The value (or values, if the condition context key supports multiple values)
	// to provide to the simulation when the key is referenced by a Condition element
	// in an input policy.
	ContextKeyValues []string `type:"list"`
}

// String returns the string representation
func (s ContextEntry) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContextEntry) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ContextEntry"}
	if s.ContextKeyName != nil && len(*s.ContextKeyName) < 5 {
		invalidParams.Add(aws.NewErrParamMinLen("ContextKeyName", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The reason that the service-linked role deletion failed.
//
// This data type is used as a response element in the GetServiceLinkedRoleDeletionStatus
// operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeletionTaskFailureReasonType
type DeletionTaskFailureReasonType struct {
	_ struct{} `type:"structure"`

	// A short description of the reason that the service-linked role deletion failed.
	Reason *string `type:"string"`

	// A list of objects that contains details about the service-linked role deletion
	// failure, if that information is returned by the service. If the service-linked
	// role has active sessions or if any resources that were used by the role have
	// not been deleted from the linked service, the role can't be deleted. This
	// parameter includes a list of the resources that are associated with the role
	// and the region in which the resources are being used.
	RoleUsageList []RoleUsageType `type:"list"`
}

// String returns the string representation
func (s DeletionTaskFailureReasonType) String() string {
	return awsutil.Prettify(s)
}

// An object that contains details about when the IAM entities (users or roles)
// were last used in an attempt to access the specified AWS service.
//
// This data type is a response element in the GetServiceLastAccessedDetailsWithEntities
// operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/EntityDetails
type EntityDetails struct {
	_ struct{} `type:"structure"`

	// The EntityInfo object that contains details about the entity (user or role).
	//
	// EntityInfo is a required field
	EntityInfo *EntityInfo `type:"structure" required:"true"`

	// The date and time, in ISO 8601 date-time format (http://www.iso.org/iso/iso8601),
	// when the authenticated entity last attempted to access AWS. AWS does not
	// report unauthenticated requests.
	//
	// This field is null if no IAM entities attempted to access the service within
	// the reporting period (https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period).
	LastAuthenticated *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s EntityDetails) String() string {
	return awsutil.Prettify(s)
}

// Contains details about the specified entity (user or role).
//
// This data type is an element of the EntityDetails object.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/EntityInfo
type EntityInfo struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN). ARNs are unique identifiers for AWS resources.
	//
	// For more information about ARNs, go to Amazon Resource Names (ARNs) and AWS
	// Service Namespaces (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	//
	// Arn is a required field
	Arn *string `min:"20" type:"string" required:"true"`

	// The identifier of the entity (user or role).
	//
	// Id is a required field
	Id *string `min:"16" type:"string" required:"true"`

	// The name of the entity (user or role).
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The path to the entity (user or role). For more information about paths,
	// see IAM Identifiers (https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	Path *string `min:"1" type:"string"`

	// The type of entity (user or role).
	//
	// Type is a required field
	Type PolicyOwnerEntityType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s EntityInfo) String() string {
	return awsutil.Prettify(s)
}

// Contains information about the reason that the operation failed.
//
// This data type is used as a response element in the GetServiceLastAccessedDetails
// operation and the GetServiceLastAccessedDetailsWithEntities operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ErrorDetails
type ErrorDetails struct {
	_ struct{} `type:"structure"`

	// The error code associated with the operation failure.
	//
	// Code is a required field
	Code *string `type:"string" required:"true"`

	// Detailed information about the reason that the operation failed.
	//
	// Message is a required field
	Message *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ErrorDetails) String() string {
	return awsutil.Prettify(s)
}

// Contains the results of a simulation.
//
// This data type is used by the return parameter of SimulateCustomPolicy and
// SimulatePrincipalPolicy .
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/EvaluationResult
type EvaluationResult struct {
	_ struct{} `type:"structure"`

	// The name of the API operation tested on the indicated resource.
	//
	// EvalActionName is a required field
	EvalActionName *string `min:"3" type:"string" required:"true"`

	// The result of the simulation.
	//
	// EvalDecision is a required field
	EvalDecision PolicyEvaluationDecisionType `type:"string" required:"true" enum:"true"`

	// Additional details about the results of the evaluation decision. When there
	// are both IAM policies and resource policies, this parameter explains how
	// each set of policies contributes to the final evaluation decision. When simulating
	// cross-account access to a resource, both the resource-based policy and the
	// caller's IAM policy must grant access. See How IAM Roles Differ from Resource-based
	// Policies (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_compare-resource-policies.html)
	EvalDecisionDetails map[string]PolicyEvaluationDecisionType `type:"map"`

	// The ARN of the resource that the indicated API operation was tested on.
	EvalResourceName *string `min:"1" type:"string"`

	// A list of the statements in the input policies that determine the result
	// for this scenario. Remember that even if multiple statements allow the operation
	// on the resource, if only one statement denies that operation, then the explicit
	// deny overrides any allow. Inaddition, the deny statement is the only entry
	// included in the result.
	MatchedStatements []Statement `type:"list"`

	// A list of context keys that are required by the included input policies but
	// that were not provided by one of the input parameters. This list is used
	// when the resource in a simulation is "*", either explicitly, or when the
	// ResourceArns parameter blank. If you include a list of resources, then any
	// missing context values are instead included under the ResourceSpecificResults
	// section. To discover the context keys used by a set of policies, you can
	// call GetContextKeysForCustomPolicy or GetContextKeysForPrincipalPolicy.
	MissingContextValues []string `type:"list"`

	// A structure that details how AWS Organizations and its service control policies
	// affect the results of the simulation. Only applies if the simulated user's
	// account is part of an organization.
	OrganizationsDecisionDetail *OrganizationsDecisionDetail `type:"structure"`

	// The individual results of the simulation of the API operation specified in
	// EvalActionName on each resource.
	ResourceSpecificResults []ResourceSpecificResult `type:"list"`
}

// String returns the string representation
func (s EvaluationResult) String() string {
	return awsutil.Prettify(s)
}

// Contains information about an IAM group entity.
//
// This data type is used as a response element in the following operations:
//
//    * CreateGroup
//
//    * GetGroup
//
//    * ListGroups
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/Group
type Group struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) specifying the group. For more information
	// about ARNs and how to use them in policies, see IAM Identifiers (https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	//
	// Arn is a required field
	Arn *string `min:"20" type:"string" required:"true"`

	// The date and time, in ISO 8601 date-time format (http://www.iso.org/iso/iso8601),
	// when the group was created.
	//
	// CreateDate is a required field
	CreateDate *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The stable and unique string identifying the group. For more information
	// about IDs, see IAM Identifiers (https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	//
	// GroupId is a required field
	GroupId *string `min:"16" type:"string" required:"true"`

	// The friendly name that identifies the group.
	//
	// GroupName is a required field
	GroupName *string `min:"1" type:"string" required:"true"`

	// The path to the group. For more information about paths, see IAM Identifiers
	// (https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	//
	// Path is a required field
	Path *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s Group) String() string {
	return awsutil.Prettify(s)
}

// Contains information about an IAM group, including all of the group's policies.
//
// This data type is used as a response element in the GetAccountAuthorizationDetails
// operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GroupDetail
type GroupDetail struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN). ARNs are unique identifiers for AWS resources.
	//
	// For more information about ARNs, go to Amazon Resource Names (ARNs) and AWS
	// Service Namespaces (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	Arn *string `min:"20" type:"string"`

	// A list of the managed policies attached to the group.
	AttachedManagedPolicies []AttachedPolicy `type:"list"`

	// The date and time, in ISO 8601 date-time format (http://www.iso.org/iso/iso8601),
	// when the group was created.
	CreateDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The stable and unique string identifying the group. For more information
	// about IDs, see IAM Identifiers (https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	GroupId *string `min:"16" type:"string"`

	// The friendly name that identifies the group.
	GroupName *string `min:"1" type:"string"`

	// A list of the inline policies embedded in the group.
	GroupPolicyList []PolicyDetail `type:"list"`

	// The path to the group. For more information about paths, see IAM Identifiers
	// (https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	Path *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GroupDetail) String() string {
	return awsutil.Prettify(s)
}

// Contains information about an instance profile.
//
// This data type is used as a response element in the following operations:
//
//    * CreateInstanceProfile
//
//    * GetInstanceProfile
//
//    * ListInstanceProfiles
//
//    * ListInstanceProfilesForRole
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/InstanceProfile
type InstanceProfile struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) specifying the instance profile. For more
	// information about ARNs and how to use them in policies, see IAM Identifiers
	// (https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	//
	// Arn is a required field
	Arn *string `min:"20" type:"string" required:"true"`

	// The date when the instance profile was created.
	//
	// CreateDate is a required field
	CreateDate *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The stable and unique string identifying the instance profile. For more information
	// about IDs, see IAM Identifiers (https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	//
	// InstanceProfileId is a required field
	InstanceProfileId *string `min:"16" type:"string" required:"true"`

	// The name identifying the instance profile.
	//
	// InstanceProfileName is a required field
	InstanceProfileName *string `min:"1" type:"string" required:"true"`

	// The path to the instance profile. For more information about paths, see IAM
	// Identifiers (https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	//
	// Path is a required field
	Path *string `min:"1" type:"string" required:"true"`

	// The role associated with the instance profile.
	//
	// Roles is a required field
	Roles []Role `type:"list" required:"true"`
}

// String returns the string representation
func (s InstanceProfile) String() string {
	return awsutil.Prettify(s)
}

// Contains details about the permissions policies that are attached to the
// specified identity (user, group, or role).
//
// This data type is used as a response element in the ListPoliciesGrantingServiceAccess
// operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListPoliciesGrantingServiceAccessEntry
type ListPoliciesGrantingServiceAccessEntry struct {
	_ struct{} `type:"structure"`

	// The PoliciesGrantingServiceAccess object that contains details about the
	// policy.
	Policies []PolicyGrantingServiceAccess `type:"list"`

	// The namespace of the service that was accessed.
	//
	// To learn the service namespace of a service, go to Actions, Resources, and
	// Condition Keys for AWS Services (https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_actions-resources-contextkeys.html)
	// in the IAM User Guide. Choose the name of the service to view details for
	// that service. In the first paragraph, find the service prefix. For example,
	// (service prefix: a4b). For more information about service namespaces, see
	// AWS Service Namespaces (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces)
	// in the AWS General Reference.
	ServiceNamespace *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListPoliciesGrantingServiceAccessEntry) String() string {
	return awsutil.Prettify(s)
}

// Contains the user name and password create date for a user.
//
// This data type is used as a response element in the CreateLoginProfile and
// GetLoginProfile operations.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/LoginProfile
type LoginProfile struct {
	_ struct{} `type:"structure"`

	// The date when the password for the user was created.
	//
	// CreateDate is a required field
	CreateDate *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// Specifies whether the user is required to set a new password on next sign-in.
	PasswordResetRequired *bool `type:"boolean"`

	// The name of the user, which can be used for signing in to the AWS Management
	// Console.
	//
	// UserName is a required field
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s LoginProfile) String() string {
	return awsutil.Prettify(s)
}

// Contains information about an MFA device.
//
// This data type is used as a response element in the ListMFADevices operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/MFADevice
type MFADevice struct {
	_ struct{} `type:"structure"`

	// The date when the MFA device was enabled for the user.
	//
	// EnableDate is a required field
	EnableDate *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The serial number that uniquely identifies the MFA device. For virtual MFA
	// devices, the serial number is the device ARN.
	//
	// SerialNumber is a required field
	SerialNumber *string `min:"9" type:"string" required:"true"`

	// The user with whom the MFA device is associated.
	//
	// UserName is a required field
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s MFADevice) String() string {
	return awsutil.Prettify(s)
}

// Contains information about a managed policy, including the policy's ARN,
// versions, and the number of principal entities (users, groups, and roles)
// that the policy is attached to.
//
// This data type is used as a response element in the GetAccountAuthorizationDetails
// operation.
//
// For more information about managed policies, see Managed Policies and Inline
// Policies (https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the Using IAM guide.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ManagedPolicyDetail
type ManagedPolicyDetail struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN). ARNs are unique identifiers for AWS resources.
	//
	// For more information about ARNs, go to Amazon Resource Names (ARNs) and AWS
	// Service Namespaces (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	Arn *string `min:"20" type:"string"`

	// The number of principal entities (users, groups, and roles) that the policy
	// is attached to.
	AttachmentCount *int64 `type:"integer"`

	// The date and time, in ISO 8601 date-time format (http://www.iso.org/iso/iso8601),
	// when the policy was created.
	CreateDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The identifier for the version of the policy that is set as the default (operative)
	// version.
	//
	// For more information about policy versions, see Versioning for Managed Policies
	// (https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html)
	// in the Using IAM guide.
	DefaultVersionId *string `type:"string"`

	// A friendly description of the policy.
	Description *string `type:"string"`

	// Specifies whether the policy can be attached to an IAM user, group, or role.
	IsAttachable *bool `type:"boolean"`

	// The path to the policy.
	//
	// For more information about paths, see IAM Identifiers (https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	Path *string `type:"string"`

	// The number of entities (users and roles) for which the policy is used as
	// the permissions boundary.
	//
	// For more information about permissions boundaries, see Permissions Boundaries
	// for IAM Identities (https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html)
	// in the IAM User Guide.
	PermissionsBoundaryUsageCount *int64 `type:"integer"`

	// The stable and unique string identifying the policy.
	//
	// For more information about IDs, see IAM Identifiers (https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	PolicyId *string `min:"16" type:"string"`

	// The friendly name (not ARN) identifying the policy.
	PolicyName *string `min:"1" type:"string"`

	// A list containing information about the versions of the policy.
	PolicyVersionList []PolicyVersion `type:"list"`

	// The date and time, in ISO 8601 date-time format (http://www.iso.org/iso/iso8601),
	// when the policy was last updated.
	//
	// When a policy has only one version, this field contains the date and time
	// when the policy was created. When a policy has more than one version, this
	// field contains the date and time when the most recent policy version was
	// created.
	UpdateDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s ManagedPolicyDetail) String() string {
	return awsutil.Prettify(s)
}

// Contains the Amazon Resource Name (ARN) for an IAM OpenID Connect provider.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/OpenIDConnectProviderListEntry
type OpenIDConnectProviderListEntry struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN). ARNs are unique identifiers for AWS resources.
	//
	// For more information about ARNs, go to Amazon Resource Names (ARNs) and AWS
	// Service Namespaces (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	Arn *string `min:"20" type:"string"`
}

// String returns the string representation
func (s OpenIDConnectProviderListEntry) String() string {
	return awsutil.Prettify(s)
}

// Contains information about AWS Organizations's effect on a policy simulation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/OrganizationsDecisionDetail
type OrganizationsDecisionDetail struct {
	_ struct{} `type:"structure"`

	// Specifies whether the simulated operation is allowed by the AWS Organizations
	// service control policies that impact the simulated user's account.
	AllowedByOrganizations *bool `type:"boolean"`
}

// String returns the string representation
func (s OrganizationsDecisionDetail) String() string {
	return awsutil.Prettify(s)
}

// Contains information about the account password policy.
//
// This data type is used as a response element in the GetAccountPasswordPolicy
// operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/PasswordPolicy
type PasswordPolicy struct {
	_ struct{} `type:"structure"`

	// Specifies whether IAM users are allowed to change their own password.
	AllowUsersToChangePassword *bool `type:"boolean"`

	// Indicates whether passwords in the account expire. Returns true if MaxPasswordAge
	// contains a value greater than 0. Returns false if MaxPasswordAge is 0 or
	// not present.
	ExpirePasswords *bool `type:"boolean"`

	// Specifies whether IAM users are prevented from setting a new password after
	// their password has expired.
	HardExpiry *bool `type:"boolean"`

	// The number of days that an IAM user password is valid.
	MaxPasswordAge *int64 `min:"1" type:"integer"`

	// Minimum length to require for IAM user passwords.
	MinimumPasswordLength *int64 `min:"6" type:"integer"`

	// Specifies the number of previous passwords that IAM users are prevented from
	// reusing.
	PasswordReusePrevention *int64 `min:"1" type:"integer"`

	// Specifies whether to require lowercase characters for IAM user passwords.
	RequireLowercaseCharacters *bool `type:"boolean"`

	// Specifies whether to require numbers for IAM user passwords.
	RequireNumbers *bool `type:"boolean"`

	// Specifies whether to require symbols for IAM user passwords.
	RequireSymbols *bool `type:"boolean"`

	// Specifies whether to require uppercase characters for IAM user passwords.
	RequireUppercaseCharacters *bool `type:"boolean"`
}

// String returns the string representation
func (s PasswordPolicy) String() string {
	return awsutil.Prettify(s)
}

// Contains information about a managed policy.
//
// This data type is used as a response element in the CreatePolicy, GetPolicy,
// and ListPolicies operations.
//
// For more information about managed policies, refer to Managed Policies and
// Inline Policies (https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the Using IAM guide.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/Policy
type Policy struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN). ARNs are unique identifiers for AWS resources.
	//
	// For more information about ARNs, go to Amazon Resource Names (ARNs) and AWS
	// Service Namespaces (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	Arn *string `min:"20" type:"string"`

	// The number of entities (users, groups, and roles) that the policy is attached
	// to.
	AttachmentCount *int64 `type:"integer"`

	// The date and time, in ISO 8601 date-time format (http://www.iso.org/iso/iso8601),
	// when the policy was created.
	CreateDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The identifier for the version of the policy that is set as the default version.
	DefaultVersionId *string `type:"string"`

	// A friendly description of the policy.
	//
	// This element is included in the response to the GetPolicy operation. It is
	// not included in the response to the ListPolicies operation.
	Description *string `type:"string"`

	// Specifies whether the policy can be attached to an IAM user, group, or role.
	IsAttachable *bool `type:"boolean"`

	// The path to the policy.
	//
	// For more information about paths, see IAM Identifiers (https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	Path *string `type:"string"`

	// The number of entities (users and roles) for which the policy is used to
	// set the permissions boundary.
	//
	// For more information about permissions boundaries, see Permissions Boundaries
	// for IAM Identities (https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html)
	// in the IAM User Guide.
	PermissionsBoundaryUsageCount *int64 `type:"integer"`

	// The stable and unique string identifying the policy.
	//
	// For more information about IDs, see IAM Identifiers (https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	PolicyId *string `min:"16" type:"string"`

	// The friendly name (not ARN) identifying the policy.
	PolicyName *string `min:"1" type:"string"`

	// The date and time, in ISO 8601 date-time format (http://www.iso.org/iso/iso8601),
	// when the policy was last updated.
	//
	// When a policy has only one version, this field contains the date and time
	// when the policy was created. When a policy has more than one version, this
	// field contains the date and time when the most recent policy version was
	// created.
	UpdateDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s Policy) String() string {
	return awsutil.Prettify(s)
}

// Contains information about an IAM policy, including the policy document.
//
// This data type is used as a response element in the GetAccountAuthorizationDetails
// operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/PolicyDetail
type PolicyDetail struct {
	_ struct{} `type:"structure"`

	// The policy document.
	PolicyDocument *string `min:"1" type:"string"`

	// The name of the policy.
	PolicyName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s PolicyDetail) String() string {
	return awsutil.Prettify(s)
}

// Contains details about the permissions policies that are attached to the
// specified identity (user, group, or role).
//
// This data type is an element of the ListPoliciesGrantingServiceAccessEntry
// object.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/PolicyGrantingServiceAccess
type PolicyGrantingServiceAccess struct {
	_ struct{} `type:"structure"`

	// The name of the entity (user or role) to which the inline policy is attached.
	//
	// This field is null for managed policies. For more information about these
	// policy types, see Managed Policies and Inline Policies (https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_managed-vs-inline.html)
	// in the IAM User Guide.
	EntityName *string `min:"1" type:"string"`

	// The type of entity (user or role) that used the policy to access the service
	// to which the inline policy is attached.
	//
	// This field is null for managed policies. For more information about these
	// policy types, see Managed Policies and Inline Policies (https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_managed-vs-inline.html)
	// in the IAM User Guide.
	EntityType PolicyOwnerEntityType `type:"string" enum:"true"`

	// The Amazon Resource Name (ARN). ARNs are unique identifiers for AWS resources.
	//
	// For more information about ARNs, go to Amazon Resource Names (ARNs) and AWS
	// Service Namespaces (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	PolicyArn *string `min:"20" type:"string"`

	// The policy name.
	//
	// PolicyName is a required field
	PolicyName *string `min:"1" type:"string" required:"true"`

	// The policy type. For more information about these policy types, see Managed
	// Policies and Inline Policies (https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_managed-vs-inline.html)
	// in the IAM User Guide.
	//
	// PolicyType is a required field
	PolicyType PolicyType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s PolicyGrantingServiceAccess) String() string {
	return awsutil.Prettify(s)
}

// Contains information about a group that a managed policy is attached to.
//
// This data type is used as a response element in the ListEntitiesForPolicy
// operation.
//
// For more information about managed policies, refer to Managed Policies and
// Inline Policies (https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the Using IAM guide.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/PolicyGroup
type PolicyGroup struct {
	_ struct{} `type:"structure"`

	// The stable and unique string identifying the group. For more information
	// about IDs, see IAM Identifiers (https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html)
	// in the IAM User Guide.
	GroupId *string `min:"16" type:"string"`

	// The name (friendly name, not ARN) identifying the group.
	GroupName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s PolicyGroup) String() string {
	return awsutil.Prettify(s)
}

// Contains information about a role that a managed policy is attached to.
//
// This data type is used as a response element in the ListEntitiesForPolicy
// operation.
//
// For more information about managed policies, refer to Managed Policies and
// Inline Policies (https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the Using IAM guide.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/PolicyRole
type PolicyRole struct {
	_ struct{} `type:"structure"`

	// The stable and unique string identifying the role. For more information about
	// IDs, see IAM Identifiers (https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html)
	// in the IAM User Guide.
	RoleId *string `min:"16" type:"string"`

	// The name (friendly name, not ARN) identifying the role.
	RoleName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s PolicyRole) String() string {
	return awsutil.Prettify(s)
}

// Contains information about a user that a managed policy is attached to.
//
// This data type is used as a response element in the ListEntitiesForPolicy
// operation.
//
// For more information about managed policies, refer to Managed Policies and
// Inline Policies (https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the Using IAM guide.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/PolicyUser
type PolicyUser struct {
	_ struct{} `type:"structure"`

	// The stable and unique string identifying the user. For more information about
	// IDs, see IAM Identifiers (https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html)
	// in the IAM User Guide.
	UserId *string `min:"16" type:"string"`

	// The name (friendly name, not ARN) identifying the user.
	UserName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s PolicyUser) String() string {
	return awsutil.Prettify(s)
}

// Contains information about a version of a managed policy.
//
// This data type is used as a response element in the CreatePolicyVersion,
// GetPolicyVersion, ListPolicyVersions, and GetAccountAuthorizationDetails
// operations.
//
// For more information about managed policies, refer to Managed Policies and
// Inline Policies (https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the Using IAM guide.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/PolicyVersion
type PolicyVersion struct {
	_ struct{} `type:"structure"`

	// The date and time, in ISO 8601 date-time format (http://www.iso.org/iso/iso8601),
	// when the policy version was created.
	CreateDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The policy document.
	//
	// The policy document is returned in the response to the GetPolicyVersion and
	// GetAccountAuthorizationDetails operations. It is not returned in the response
	// to the CreatePolicyVersion or ListPolicyVersions operations.
	//
	// The policy document returned in this structure is URL-encoded compliant with
	// RFC 3986 (https://tools.ietf.org/html/rfc3986). You can use a URL decoding
	// method to convert the policy back to plain JSON text. For example, if you
	// use Java, you can use the decode method of the java.net.URLDecoder utility
	// class in the Java SDK. Other languages and SDKs provide similar functionality.
	Document *string `min:"1" type:"string"`

	// Specifies whether the policy version is set as the policy's default version.
	IsDefaultVersion *bool `type:"boolean"`

	// The identifier for the policy version.
	//
	// Policy version identifiers always begin with v (always lowercase). When a
	// policy is created, the first policy version is v1.
	VersionId *string `type:"string"`
}

// String returns the string representation
func (s PolicyVersion) String() string {
	return awsutil.Prettify(s)
}

// Contains the row and column of a location of a Statement element in a policy
// document.
//
// This data type is used as a member of the Statement type.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/Position
type Position struct {
	_ struct{} `type:"structure"`

	// The column in the line containing the specified position in the document.
	Column *int64 `type:"integer"`

	// The line containing the specified position in the document.
	Line *int64 `type:"integer"`
}

// String returns the string representation
func (s Position) String() string {
	return awsutil.Prettify(s)
}

// Contains the result of the simulation of a single API operation call on a
// single resource.
//
// This data type is used by a member of the EvaluationResult data type.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ResourceSpecificResult
type ResourceSpecificResult struct {
	_ struct{} `type:"structure"`

	// Additional details about the results of the evaluation decision. When there
	// are both IAM policies and resource policies, this parameter explains how
	// each set of policies contributes to the final evaluation decision. When simulating
	// cross-account access to a resource, both the resource-based policy and the
	// caller's IAM policy must grant access.
	EvalDecisionDetails map[string]PolicyEvaluationDecisionType `type:"map"`

	// The result of the simulation of the simulated API operation on the resource
	// specified in EvalResourceName.
	//
	// EvalResourceDecision is a required field
	EvalResourceDecision PolicyEvaluationDecisionType `type:"string" required:"true" enum:"true"`

	// The name of the simulated resource, in Amazon Resource Name (ARN) format.
	//
	// EvalResourceName is a required field
	EvalResourceName *string `min:"1" type:"string" required:"true"`

	// A list of the statements in the input policies that determine the result
	// for this part of the simulation. Remember that even if multiple statements
	// allow the operation on the resource, if any statement denies that operation,
	// then the explicit deny overrides any allow. In addition, the deny statement
	// is the only entry included in the result.
	MatchedStatements []Statement `type:"list"`

	// A list of context keys that are required by the included input policies but
	// that were not provided by one of the input parameters. This list is used
	// when a list of ARNs is included in the ResourceArns parameter instead of
	// "*". If you do not specify individual resources, by setting ResourceArns
	// to "*" or by not including the ResourceArns parameter, then any missing context
	// values are instead included under the EvaluationResults section. To discover
	// the context keys used by a set of policies, you can call GetContextKeysForCustomPolicy
	// or GetContextKeysForPrincipalPolicy.
	MissingContextValues []string `type:"list"`
}

// String returns the string representation
func (s ResourceSpecificResult) String() string {
	return awsutil.Prettify(s)
}

// Contains information about an IAM role. This structure is returned as a response
// element in several API operations that interact with roles.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/Role
type Role struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) specifying the role. For more information
	// about ARNs and how to use them in policies, see IAM Identifiers (https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the IAM User Guide guide.
	//
	// Arn is a required field
	Arn *string `min:"20" type:"string" required:"true"`

	// The policy that grants an entity permission to assume the role.
	AssumeRolePolicyDocument *string `min:"1" type:"string"`

	// The date and time, in ISO 8601 date-time format (http://www.iso.org/iso/iso8601),
	// when the role was created.
	//
	// CreateDate is a required field
	CreateDate *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// A description of the role that you provide.
	Description *string `type:"string"`

	// The maximum session duration (in seconds) for the specified role. Anyone
	// who uses the AWS CLI, or API to assume the role can specify the duration
	// using the optional DurationSeconds API parameter or duration-seconds CLI
	// parameter.
	MaxSessionDuration *int64 `min:"3600" type:"integer"`

	// The path to the role. For more information about paths, see IAM Identifiers
	// (https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	//
	// Path is a required field
	Path *string `min:"1" type:"string" required:"true"`

	// The ARN of the policy used to set the permissions boundary for the role.
	//
	// For more information about permissions boundaries, see Permissions Boundaries
	// for IAM Identities (https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html)
	// in the IAM User Guide.
	PermissionsBoundary *AttachedPermissionsBoundary `type:"structure"`

	// The stable and unique string identifying the role. For more information about
	// IDs, see IAM Identifiers (https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	//
	// RoleId is a required field
	RoleId *string `min:"16" type:"string" required:"true"`

	// The friendly name that identifies the role.
	//
	// RoleName is a required field
	RoleName *string `min:"1" type:"string" required:"true"`

	// A list of tags that are attached to the specified role. For more information
	// about tagging, see Tagging IAM Identities (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html)
	// in the IAM User Guide.
	Tags []Tag `type:"list"`
}

// String returns the string representation
func (s Role) String() string {
	return awsutil.Prettify(s)
}

// Contains information about an IAM role, including all of the role's policies.
//
// This data type is used as a response element in the GetAccountAuthorizationDetails
// operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/RoleDetail
type RoleDetail struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN). ARNs are unique identifiers for AWS resources.
	//
	// For more information about ARNs, go to Amazon Resource Names (ARNs) and AWS
	// Service Namespaces (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	Arn *string `min:"20" type:"string"`

	// The trust policy that grants permission to assume the role.
	AssumeRolePolicyDocument *string `min:"1" type:"string"`

	// A list of managed policies attached to the role. These policies are the role's
	// access (permissions) policies.
	AttachedManagedPolicies []AttachedPolicy `type:"list"`

	// The date and time, in ISO 8601 date-time format (http://www.iso.org/iso/iso8601),
	// when the role was created.
	CreateDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// A list of instance profiles that contain this role.
	InstanceProfileList []InstanceProfile `type:"list"`

	// The path to the role. For more information about paths, see IAM Identifiers
	// (https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	Path *string `min:"1" type:"string"`

	// The ARN of the policy used to set the permissions boundary for the role.
	//
	// For more information about permissions boundaries, see Permissions Boundaries
	// for IAM Identities (https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html)
	// in the IAM User Guide.
	PermissionsBoundary *AttachedPermissionsBoundary `type:"structure"`

	// The stable and unique string identifying the role. For more information about
	// IDs, see IAM Identifiers (https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	RoleId *string `min:"16" type:"string"`

	// The friendly name that identifies the role.
	RoleName *string `min:"1" type:"string"`

	// A list of inline policies embedded in the role. These policies are the role's
	// access (permissions) policies.
	RolePolicyList []PolicyDetail `type:"list"`

	// A list of tags that are attached to the specified role. For more information
	// about tagging, see Tagging IAM Identities (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html)
	// in the IAM User Guide.
	Tags []Tag `type:"list"`
}

// String returns the string representation
func (s RoleDetail) String() string {
	return awsutil.Prettify(s)
}

// An object that contains details about how a service-linked role is used,
// if that information is returned by the service.
//
// This data type is used as a response element in the GetServiceLinkedRoleDeletionStatus
// operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/RoleUsageType
type RoleUsageType struct {
	_ struct{} `type:"structure"`

	// The name of the region where the service-linked role is being used.
	Region *string `min:"1" type:"string"`

	// The name of the resource that is using the service-linked role.
	Resources []string `type:"list"`
}

// String returns the string representation
func (s RoleUsageType) String() string {
	return awsutil.Prettify(s)
}

// Contains the list of SAML providers for this account.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/SAMLProviderListEntry
type SAMLProviderListEntry struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the SAML provider.
	Arn *string `min:"20" type:"string"`

	// The date and time when the SAML provider was created.
	CreateDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The expiration date and time for the SAML provider.
	ValidUntil *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s SAMLProviderListEntry) String() string {
	return awsutil.Prettify(s)
}

// Contains information about an SSH public key.
//
// This data type is used as a response element in the GetSSHPublicKey and UploadSSHPublicKey
// operations.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/SSHPublicKey
type SSHPublicKey struct {
	_ struct{} `type:"structure"`

	// The MD5 message digest of the SSH public key.
	//
	// Fingerprint is a required field
	Fingerprint *string `min:"48" type:"string" required:"true"`

	// The SSH public key.
	//
	// SSHPublicKeyBody is a required field
	SSHPublicKeyBody *string `min:"1" type:"string" required:"true"`

	// The unique identifier for the SSH public key.
	//
	// SSHPublicKeyId is a required field
	SSHPublicKeyId *string `min:"20" type:"string" required:"true"`

	// The status of the SSH public key. Active means that the key can be used for
	// authentication with an AWS CodeCommit repository. Inactive means that the
	// key cannot be used.
	//
	// Status is a required field
	Status StatusType `type:"string" required:"true" enum:"true"`

	// The date and time, in ISO 8601 date-time format (http://www.iso.org/iso/iso8601),
	// when the SSH public key was uploaded.
	UploadDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The name of the IAM user associated with the SSH public key.
	//
	// UserName is a required field
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s SSHPublicKey) String() string {
	return awsutil.Prettify(s)
}

// Contains information about an SSH public key, without the key's body or fingerprint.
//
// This data type is used as a response element in the ListSSHPublicKeys operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/SSHPublicKeyMetadata
type SSHPublicKeyMetadata struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the SSH public key.
	//
	// SSHPublicKeyId is a required field
	SSHPublicKeyId *string `min:"20" type:"string" required:"true"`

	// The status of the SSH public key. Active means that the key can be used for
	// authentication with an AWS CodeCommit repository. Inactive means that the
	// key cannot be used.
	//
	// Status is a required field
	Status StatusType `type:"string" required:"true" enum:"true"`

	// The date and time, in ISO 8601 date-time format (http://www.iso.org/iso/iso8601),
	// when the SSH public key was uploaded.
	//
	// UploadDate is a required field
	UploadDate *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The name of the IAM user associated with the SSH public key.
	//
	// UserName is a required field
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s SSHPublicKeyMetadata) String() string {
	return awsutil.Prettify(s)
}

// Contains information about a server certificate.
//
// This data type is used as a response element in the GetServerCertificate
// operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ServerCertificate
type ServerCertificate struct {
	_ struct{} `type:"structure"`

	// The contents of the public key certificate.
	//
	// CertificateBody is a required field
	CertificateBody *string `min:"1" type:"string" required:"true"`

	// The contents of the public key certificate chain.
	CertificateChain *string `min:"1" type:"string"`

	// The meta information of the server certificate, such as its name, path, ID,
	// and ARN.
	//
	// ServerCertificateMetadata is a required field
	ServerCertificateMetadata *ServerCertificateMetadata `type:"structure" required:"true"`
}

// String returns the string representation
func (s ServerCertificate) String() string {
	return awsutil.Prettify(s)
}

// Contains information about a server certificate without its certificate body,
// certificate chain, and private key.
//
// This data type is used as a response element in the UploadServerCertificate
// and ListServerCertificates operations.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ServerCertificateMetadata
type ServerCertificateMetadata struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) specifying the server certificate. For more
	// information about ARNs and how to use them in policies, see IAM Identifiers
	// (https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	//
	// Arn is a required field
	Arn *string `min:"20" type:"string" required:"true"`

	// The date on which the certificate is set to expire.
	Expiration *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The path to the server certificate. For more information about paths, see
	// IAM Identifiers (https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	//
	// Path is a required field
	Path *string `min:"1" type:"string" required:"true"`

	// The stable and unique string identifying the server certificate. For more
	// information about IDs, see IAM Identifiers (https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	//
	// ServerCertificateId is a required field
	ServerCertificateId *string `min:"16" type:"string" required:"true"`

	// The name that identifies the server certificate.
	//
	// ServerCertificateName is a required field
	ServerCertificateName *string `min:"1" type:"string" required:"true"`

	// The date when the server certificate was uploaded.
	UploadDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s ServerCertificateMetadata) String() string {
	return awsutil.Prettify(s)
}

// Contains details about the most recent attempt to access the service.
//
// This data type is used as a response element in the GetServiceLastAccessedDetails
// operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ServiceLastAccessed
type ServiceLastAccessed struct {
	_ struct{} `type:"structure"`

	// The date and time, in ISO 8601 date-time format (http://www.iso.org/iso/iso8601),
	// when an authenticated entity most recently attempted to access the service.
	// AWS does not report unauthenticated requests.
	//
	// This field is null if no IAM entities attempted to access the service within
	// the reporting period (https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period).
	LastAuthenticated *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The ARN of the authenticated entity (user or role) that last attempted to
	// access the service. AWS does not report unauthenticated requests.
	//
	// This field is null if no IAM entities attempted to access the service within
	// the reporting period (https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period).
	LastAuthenticatedEntity *string `min:"20" type:"string"`

	// The name of the service in which access was attempted.
	//
	// ServiceName is a required field
	ServiceName *string `type:"string" required:"true"`

	// The namespace of the service in which access was attempted.
	//
	// To learn the service namespace of a service, go to Actions, Resources, and
	// Condition Keys for AWS Services (https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_actions-resources-contextkeys.html)
	// in the IAM User Guide. Choose the name of the service to view details for
	// that service. In the first paragraph, find the service prefix. For example,
	// (service prefix: a4b). For more information about service namespaces, see
	// AWS Service Namespaces (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces)
	// in the AWS General Reference.
	//
	// ServiceNamespace is a required field
	ServiceNamespace *string `min:"1" type:"string" required:"true"`

	// The total number of authenticated entities that have attempted to access
	// the service.
	//
	// This field is null if no IAM entities attempted to access the service within
	// the reporting period (https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#service-last-accessed-reporting-period).
	TotalAuthenticatedEntities *int64 `type:"integer"`
}

// String returns the string representation
func (s ServiceLastAccessed) String() string {
	return awsutil.Prettify(s)
}

// Contains the details of a service-specific credential.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ServiceSpecificCredential
type ServiceSpecificCredential struct {
	_ struct{} `type:"structure"`

	// The date and time, in ISO 8601 date-time format (http://www.iso.org/iso/iso8601),
	// when the service-specific credential were created.
	//
	// CreateDate is a required field
	CreateDate *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The name of the service associated with the service-specific credential.
	//
	// ServiceName is a required field
	ServiceName *string `type:"string" required:"true"`

	// The generated password for the service-specific credential.
	//
	// ServicePassword is a required field
	ServicePassword *string `type:"string" required:"true"`

	// The unique identifier for the service-specific credential.
	//
	// ServiceSpecificCredentialId is a required field
	ServiceSpecificCredentialId *string `min:"20" type:"string" required:"true"`

	// The generated user name for the service-specific credential. This value is
	// generated by combining the IAM user's name combined with the ID number of
	// the AWS account, as in jane-at-123456789012, for example. This value cannot
	// be configured by the user.
	//
	// ServiceUserName is a required field
	ServiceUserName *string `min:"17" type:"string" required:"true"`

	// The status of the service-specific credential. Active means that the key
	// is valid for API calls, while Inactive means it is not.
	//
	// Status is a required field
	Status StatusType `type:"string" required:"true" enum:"true"`

	// The name of the IAM user associated with the service-specific credential.
	//
	// UserName is a required field
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ServiceSpecificCredential) String() string {
	return awsutil.Prettify(s)
}

// Contains additional details about a service-specific credential.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ServiceSpecificCredentialMetadata
type ServiceSpecificCredentialMetadata struct {
	_ struct{} `type:"structure"`

	// The date and time, in ISO 8601 date-time format (http://www.iso.org/iso/iso8601),
	// when the service-specific credential were created.
	//
	// CreateDate is a required field
	CreateDate *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The name of the service associated with the service-specific credential.
	//
	// ServiceName is a required field
	ServiceName *string `type:"string" required:"true"`

	// The unique identifier for the service-specific credential.
	//
	// ServiceSpecificCredentialId is a required field
	ServiceSpecificCredentialId *string `min:"20" type:"string" required:"true"`

	// The generated user name for the service-specific credential.
	//
	// ServiceUserName is a required field
	ServiceUserName *string `min:"17" type:"string" required:"true"`

	// The status of the service-specific credential. Active means that the key
	// is valid for API calls, while Inactive means it is not.
	//
	// Status is a required field
	Status StatusType `type:"string" required:"true" enum:"true"`

	// The name of the IAM user associated with the service-specific credential.
	//
	// UserName is a required field
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ServiceSpecificCredentialMetadata) String() string {
	return awsutil.Prettify(s)
}

// Contains information about an X.509 signing certificate.
//
// This data type is used as a response element in the UploadSigningCertificate
// and ListSigningCertificates operations.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/SigningCertificate
type SigningCertificate struct {
	_ struct{} `type:"structure"`

	// The contents of the signing certificate.
	//
	// CertificateBody is a required field
	CertificateBody *string `min:"1" type:"string" required:"true"`

	// The ID for the signing certificate.
	//
	// CertificateId is a required field
	CertificateId *string `min:"24" type:"string" required:"true"`

	// The status of the signing certificate. Active means that the key is valid
	// for API calls, while Inactive means it is not.
	//
	// Status is a required field
	Status StatusType `type:"string" required:"true" enum:"true"`

	// The date when the signing certificate was uploaded.
	UploadDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The name of the user the signing certificate is associated with.
	//
	// UserName is a required field
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s SigningCertificate) String() string {
	return awsutil.Prettify(s)
}

// Contains a reference to a Statement element in a policy document that determines
// the result of the simulation.
//
// This data type is used by the MatchedStatements member of the EvaluationResult
// type.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/Statement
type Statement struct {
	_ struct{} `type:"structure"`

	// The row and column of the end of a Statement in an IAM policy.
	EndPosition *Position `type:"structure"`

	// The identifier of the policy that was provided as an input.
	SourcePolicyId *string `type:"string"`

	// The type of the policy.
	SourcePolicyType PolicySourceType `type:"string" enum:"true"`

	// The row and column of the beginning of the Statement in an IAM policy.
	StartPosition *Position `type:"structure"`
}

// String returns the string representation
func (s Statement) String() string {
	return awsutil.Prettify(s)
}

// A structure that represents user-provided metadata that can be associated
// with a resource such as an IAM user or role. For more information about tagging,
// see Tagging IAM Identities (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html)
// in the IAM User Guide.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/Tag
type Tag struct {
	_ struct{} `type:"structure"`

	// The key name that can be used to look up or retrieve the associated value.
	// For example, Department or Cost Center are common choices.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The value associated with this tag. For example, tags with a key name of
	// Department could have values such as Human Resources, Accounting, and Support.
	// Tags with a key name of Cost Center might have values that consist of the
	// number associated with the different cost centers in your company. Typically,
	// many resources have tags with the same key name but with different values.
	//
	// AWS always interprets the tag Value as a single string. If you need to store
	// an array, you can store comma-separated values in the string. However, you
	// must interpret the value in your code.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Tag"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains information about an IAM user entity.
//
// This data type is used as a response element in the following operations:
//
//    * CreateUser
//
//    * GetUser
//
//    * ListUsers
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/User
type User struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that identifies the user. For more information
	// about ARNs and how to use ARNs in policies, see IAM Identifiers (https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	//
	// Arn is a required field
	Arn *string `min:"20" type:"string" required:"true"`

	// The date and time, in ISO 8601 date-time format (http://www.iso.org/iso/iso8601),
	// when the user was created.
	//
	// CreateDate is a required field
	CreateDate *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The date and time, in ISO 8601 date-time format (http://www.iso.org/iso/iso8601),
	// when the user's password was last used to sign in to an AWS website. For
	// a list of AWS websites that capture a user's last sign-in time, see the Credential
	// Reports (https://docs.aws.amazon.com/IAM/latest/UserGuide/credential-reports.html)
	// topic in the Using IAM guide. If a password is used more than once in a five-minute
	// span, only the first use is returned in this field. If the field is null
	// (no value), then it indicates that they never signed in with a password.
	// This can be because:
	//
	//    * The user never had a password.
	//
	//    * A password exists but has not been used since IAM started tracking this
	//    information on October 20, 2014.
	//
	// A null valuedoes not mean that the user never had a password. Also, if the
	// user does not currently have a password, but had one in the past, then this
	// field contains the date and time the most recent password was used.
	//
	// This value is returned only in the GetUser and ListUsers operations.
	PasswordLastUsed *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The path to the user. For more information about paths, see IAM Identifiers
	// (https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	//
	// Path is a required field
	Path *string `min:"1" type:"string" required:"true"`

	// The ARN of the policy used to set the permissions boundary for the user.
	//
	// For more information about permissions boundaries, see Permissions Boundaries
	// for IAM Identities (https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html)
	// in the IAM User Guide.
	PermissionsBoundary *AttachedPermissionsBoundary `type:"structure"`

	// A list of tags that are associated with the specified user. For more information
	// about tagging, see Tagging IAM Identities (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html)
	// in the IAM User Guide.
	Tags []Tag `type:"list"`

	// The stable and unique string identifying the user. For more information about
	// IDs, see IAM Identifiers (https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	//
	// UserId is a required field
	UserId *string `min:"16" type:"string" required:"true"`

	// The friendly name identifying the user.
	//
	// UserName is a required field
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s User) String() string {
	return awsutil.Prettify(s)
}

// Contains information about an IAM user, including all the user's policies
// and all the IAM groups the user is in.
//
// This data type is used as a response element in the GetAccountAuthorizationDetails
// operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UserDetail
type UserDetail struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN). ARNs are unique identifiers for AWS resources.
	//
	// For more information about ARNs, go to Amazon Resource Names (ARNs) and AWS
	// Service Namespaces (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	Arn *string `min:"20" type:"string"`

	// A list of the managed policies attached to the user.
	AttachedManagedPolicies []AttachedPolicy `type:"list"`

	// The date and time, in ISO 8601 date-time format (http://www.iso.org/iso/iso8601),
	// when the user was created.
	CreateDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// A list of IAM groups that the user is in.
	GroupList []string `type:"list"`

	// The path to the user. For more information about paths, see IAM Identifiers
	// (https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	Path *string `min:"1" type:"string"`

	// The ARN of the policy used to set the permissions boundary for the user.
	//
	// For more information about permissions boundaries, see Permissions Boundaries
	// for IAM Identities (https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html)
	// in the IAM User Guide.
	PermissionsBoundary *AttachedPermissionsBoundary `type:"structure"`

	// A list of tags that are associated with the specified user. For more information
	// about tagging, see Tagging IAM Identities (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html)
	// in the IAM User Guide.
	Tags []Tag `type:"list"`

	// The stable and unique string identifying the user. For more information about
	// IDs, see IAM Identifiers (https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	UserId *string `min:"16" type:"string"`

	// The friendly name identifying the user.
	UserName *string `min:"1" type:"string"`

	// A list of the inline policies embedded in the user.
	UserPolicyList []PolicyDetail `type:"list"`
}

// String returns the string representation
func (s UserDetail) String() string {
	return awsutil.Prettify(s)
}

// Contains information about a virtual MFA device.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/VirtualMFADevice
type VirtualMFADevice struct {
	_ struct{} `type:"structure"`

	// The base32 seed defined as specified in RFC3548 (https://tools.ietf.org/html/rfc3548.txt).
	// The Base32StringSeed is base64-encoded.
	//
	// Base32StringSeed is automatically base64 encoded/decoded by the SDK.
	Base32StringSeed []byte `type:"blob"`

	// The date and time on which the virtual MFA device was enabled.
	EnableDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// A QR code PNG image that encodes otpauth://totp/$virtualMFADeviceName@$AccountName?secret=$Base32String
	// where $virtualMFADeviceName is one of the create call arguments. AccountName
	// is the user name if set (otherwise, the account ID otherwise), and Base32String
	// is the seed in base32 format. The Base32String value is base64-encoded.
	//
	// QRCodePNG is automatically base64 encoded/decoded by the SDK.
	QRCodePNG []byte `type:"blob"`

	// The serial number associated with VirtualMFADevice.
	//
	// SerialNumber is a required field
	SerialNumber *string `min:"9" type:"string" required:"true"`

	// The IAM user associated with this virtual MFA device.
	User *User `type:"structure"`
}

// String returns the string representation
func (s VirtualMFADevice) String() string {
	return awsutil.Prettify(s)
}
