// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iotanalytics

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/DeletePipelineRequest
type DeletePipelineInput struct {
	_ struct{} `type:"structure"`

	// The name of the pipeline to delete.
	//
	// PipelineName is a required field
	PipelineName *string `location:"uri" locationName:"pipelineName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeletePipelineInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePipelineInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeletePipelineInput"}

	if s.PipelineName == nil {
		invalidParams.Add(aws.NewErrParamRequired("PipelineName"))
	}
	if s.PipelineName != nil && len(*s.PipelineName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PipelineName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeletePipelineInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.PipelineName != nil {
		v := *s.PipelineName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "pipelineName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/DeletePipelineOutput
type DeletePipelineOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeletePipelineOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeletePipelineOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeletePipeline = "DeletePipeline"

// DeletePipelineRequest returns a request value for making API operation for
// AWS IoT Analytics.
//
// Deletes the specified pipeline.
//
//    // Example sending a request using DeletePipelineRequest.
//    req := client.DeletePipelineRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/DeletePipeline
func (c *Client) DeletePipelineRequest(input *DeletePipelineInput) DeletePipelineRequest {
	op := &aws.Operation{
		Name:       opDeletePipeline,
		HTTPMethod: "DELETE",
		HTTPPath:   "/pipelines/{pipelineName}",
	}

	if input == nil {
		input = &DeletePipelineInput{}
	}

	req := c.newRequest(op, input, &DeletePipelineOutput{})
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeletePipelineRequest{Request: req, Input: input, Copy: c.DeletePipelineRequest}
}

// DeletePipelineRequest is the request type for the
// DeletePipeline API operation.
type DeletePipelineRequest struct {
	*aws.Request
	Input *DeletePipelineInput
	Copy  func(*DeletePipelineInput) DeletePipelineRequest
}

// Send marshals and sends the DeletePipeline API request.
func (r DeletePipelineRequest) Send(ctx context.Context) (*DeletePipelineResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeletePipelineResponse{
		DeletePipelineOutput: r.Request.Data.(*DeletePipelineOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeletePipelineResponse is the response type for the
// DeletePipeline API operation.
type DeletePipelineResponse struct {
	*DeletePipelineOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeletePipeline request.
func (r *DeletePipelineResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
