// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kinesis

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/UpdateShardCountInput
type UpdateShardCountInput struct {
	_ struct{} `type:"structure"`

	// The scaling type. Uniform scaling creates shards of equal size.
	//
	// ScalingType is a required field
	ScalingType ScalingType `type:"string" required:"true" enum:"true"`

	// The name of the stream.
	//
	// StreamName is a required field
	StreamName *string `min:"1" type:"string" required:"true"`

	// The new number of shards.
	//
	// TargetShardCount is a required field
	TargetShardCount *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s UpdateShardCountInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateShardCountInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateShardCountInput"}
	if len(s.ScalingType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("ScalingType"))
	}

	if s.StreamName == nil {
		invalidParams.Add(aws.NewErrParamRequired("StreamName"))
	}
	if s.StreamName != nil && len(*s.StreamName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("StreamName", 1))
	}

	if s.TargetShardCount == nil {
		invalidParams.Add(aws.NewErrParamRequired("TargetShardCount"))
	}
	if s.TargetShardCount != nil && *s.TargetShardCount < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("TargetShardCount", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/UpdateShardCountOutput
type UpdateShardCountOutput struct {
	_ struct{} `type:"structure"`

	// The current number of shards.
	CurrentShardCount *int64 `min:"1" type:"integer"`

	// The name of the stream.
	StreamName *string `min:"1" type:"string"`

	// The updated number of shards.
	TargetShardCount *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s UpdateShardCountOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateShardCount = "UpdateShardCount"

// UpdateShardCountRequest returns a request value for making API operation for
// Amazon Kinesis.
//
// Updates the shard count of the specified stream to the specified number of
// shards.
//
// Updating the shard count is an asynchronous operation. Upon receiving the
// request, Kinesis Data Streams returns immediately and sets the status of
// the stream to UPDATING. After the update is complete, Kinesis Data Streams
// sets the status of the stream back to ACTIVE. Depending on the size of the
// stream, the scaling action could take a few minutes to complete. You can
// continue to read and write data to your stream while its status is UPDATING.
//
// To update the shard count, Kinesis Data Streams performs splits or merges
// on individual shards. This can cause short-lived shards to be created, in
// addition to the final shards. We recommend that you double or halve the shard
// count, as this results in the fewest number of splits or merges.
//
// This operation has the following default limits. By default, you cannot do
// the following:
//
//    * Scale more than twice per rolling 24-hour period per stream
//
//    * Scale up to more than double your current shard count for a stream
//
//    * Scale down below half your current shard count for a stream
//
//    * Scale up to more than 500 shards in a stream
//
//    * Scale a stream with more than 500 shards down unless the result is less
//    than 500 shards
//
//    * Scale up to more than the shard limit for your account
//
// For the default limits for an AWS account, see Streams Limits (http://docs.aws.amazon.com/kinesis/latest/dev/service-sizes-and-limits.html)
// in the Amazon Kinesis Data Streams Developer Guide. To request an increase
// in the call rate limit, the shard limit for this API, or your overall shard
// limit, use the limits form (https://console.aws.amazon.com/support/v1#/case/create?issueType=service-limit-increase&limitType=service-code-kinesis).
//
//    // Example sending a request using UpdateShardCountRequest.
//    req := client.UpdateShardCountRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/UpdateShardCount
func (c *Client) UpdateShardCountRequest(input *UpdateShardCountInput) UpdateShardCountRequest {
	op := &aws.Operation{
		Name:       opUpdateShardCount,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateShardCountInput{}
	}

	req := c.newRequest(op, input, &UpdateShardCountOutput{})
	return UpdateShardCountRequest{Request: req, Input: input, Copy: c.UpdateShardCountRequest}
}

// UpdateShardCountRequest is the request type for the
// UpdateShardCount API operation.
type UpdateShardCountRequest struct {
	*aws.Request
	Input *UpdateShardCountInput
	Copy  func(*UpdateShardCountInput) UpdateShardCountRequest
}

// Send marshals and sends the UpdateShardCount API request.
func (r UpdateShardCountRequest) Send(ctx context.Context) (*UpdateShardCountResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateShardCountResponse{
		UpdateShardCountOutput: r.Request.Data.(*UpdateShardCountOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateShardCountResponse is the response type for the
// UpdateShardCount API operation.
type UpdateShardCountResponse struct {
	*UpdateShardCountOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateShardCount request.
func (r *UpdateShardCountResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
