// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kinesisanalytics

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

var _ aws.Config
var _ = awsutil.Prettify

//
// This documentation is for version 1 of the Amazon Kinesis Data Analytics
// API, which only supports SQL applications. Version 2 of the API supports
// SQL and Java applications. For more information about version 2, see Amazon
// Kinesis Data Analytics API V2 Documentation (/kinesisanalytics/latest/apiv2/Welcome.html).
//
// Provides a description of the application, including the application Amazon
// Resource Name (ARN), status, latest version, and input and output configuration.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/ApplicationDetail
type ApplicationDetail struct {
	_ struct{} `type:"structure"`

	// ARN of the application.
	//
	// ApplicationARN is a required field
	ApplicationARN *string `min:"1" type:"string" required:"true"`

	// Returns the application code that you provided to perform data analysis on
	// any of the in-application streams in your application.
	ApplicationCode *string `type:"string"`

	// Description of the application.
	ApplicationDescription *string `type:"string"`

	// Name of the application.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// Status of the application.
	//
	// ApplicationStatus is a required field
	ApplicationStatus ApplicationStatus `type:"string" required:"true" enum:"true"`

	// Provides the current application version.
	//
	// ApplicationVersionId is a required field
	ApplicationVersionId *int64 `min:"1" type:"long" required:"true"`

	// Describes the CloudWatch log streams that are configured to receive application
	// messages. For more information about using CloudWatch log streams with Amazon
	// Kinesis Analytics applications, see Working with Amazon CloudWatch Logs (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/cloudwatch-logs.html).
	CloudWatchLoggingOptionDescriptions []CloudWatchLoggingOptionDescription `type:"list"`

	// Time stamp when the application version was created.
	CreateTimestamp *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Describes the application input configuration. For more information, see
	// Configuring Application Input (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html).
	InputDescriptions []InputDescription `type:"list"`

	// Time stamp when the application was last updated.
	LastUpdateTimestamp *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Describes the application output configuration. For more information, see
	// Configuring Application Output (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-output.html).
	OutputDescriptions []OutputDescription `type:"list"`

	// Describes reference data sources configured for the application. For more
	// information, see Configuring Application Input (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html).
	ReferenceDataSourceDescriptions []ReferenceDataSourceDescription `type:"list"`
}

// String returns the string representation
func (s ApplicationDetail) String() string {
	return awsutil.Prettify(s)
}

//
// This documentation is for version 1 of the Amazon Kinesis Data Analytics
// API, which only supports SQL applications. Version 2 of the API supports
// SQL and Java applications. For more information about version 2, see Amazon
// Kinesis Data Analytics API V2 Documentation (/kinesisanalytics/latest/apiv2/Welcome.html).
//
// Provides application summary information, including the application Amazon
// Resource Name (ARN), name, and status.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/ApplicationSummary
type ApplicationSummary struct {
	_ struct{} `type:"structure"`

	// ARN of the application.
	//
	// ApplicationARN is a required field
	ApplicationARN *string `min:"1" type:"string" required:"true"`

	// Name of the application.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// Status of the application.
	//
	// ApplicationStatus is a required field
	ApplicationStatus ApplicationStatus `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s ApplicationSummary) String() string {
	return awsutil.Prettify(s)
}

// Describes updates to apply to an existing Amazon Kinesis Analytics application.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/ApplicationUpdate
type ApplicationUpdate struct {
	_ struct{} `type:"structure"`

	// Describes application code updates.
	ApplicationCodeUpdate *string `type:"string"`

	// Describes application CloudWatch logging option updates.
	CloudWatchLoggingOptionUpdates []CloudWatchLoggingOptionUpdate `type:"list"`

	// Describes application input configuration updates.
	InputUpdates []InputUpdate `type:"list"`

	// Describes application output configuration updates.
	OutputUpdates []OutputUpdate `type:"list"`

	// Describes application reference data source updates.
	ReferenceDataSourceUpdates []ReferenceDataSourceUpdate `type:"list"`
}

// String returns the string representation
func (s ApplicationUpdate) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ApplicationUpdate) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ApplicationUpdate"}
	if s.CloudWatchLoggingOptionUpdates != nil {
		for i, v := range s.CloudWatchLoggingOptionUpdates {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CloudWatchLoggingOptionUpdates", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.InputUpdates != nil {
		for i, v := range s.InputUpdates {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InputUpdates", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.OutputUpdates != nil {
		for i, v := range s.OutputUpdates {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "OutputUpdates", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.ReferenceDataSourceUpdates != nil {
		for i, v := range s.ReferenceDataSourceUpdates {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ReferenceDataSourceUpdates", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides additional mapping information when the record format uses delimiters,
// such as CSV. For example, the following sample records use CSV format, where
// the records use the '\n' as the row delimiter and a comma (",") as the column
// delimiter:
//
// "name1", "address1"
//
// "name2", "address2"
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/CSVMappingParameters
type CSVMappingParameters struct {
	_ struct{} `type:"structure"`

	// Column delimiter. For example, in a CSV format, a comma (",") is the typical
	// column delimiter.
	//
	// RecordColumnDelimiter is a required field
	RecordColumnDelimiter *string `min:"1" type:"string" required:"true"`

	// Row delimiter. For example, in a CSV format, '\n' is the typical row delimiter.
	//
	// RecordRowDelimiter is a required field
	RecordRowDelimiter *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CSVMappingParameters) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CSVMappingParameters) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CSVMappingParameters"}

	if s.RecordColumnDelimiter == nil {
		invalidParams.Add(aws.NewErrParamRequired("RecordColumnDelimiter"))
	}
	if s.RecordColumnDelimiter != nil && len(*s.RecordColumnDelimiter) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RecordColumnDelimiter", 1))
	}

	if s.RecordRowDelimiter == nil {
		invalidParams.Add(aws.NewErrParamRequired("RecordRowDelimiter"))
	}
	if s.RecordRowDelimiter != nil && len(*s.RecordRowDelimiter) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RecordRowDelimiter", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides a description of CloudWatch logging options, including the log stream
// Amazon Resource Name (ARN) and the role ARN.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/CloudWatchLoggingOption
type CloudWatchLoggingOption struct {
	_ struct{} `type:"structure"`

	// ARN of the CloudWatch log to receive application messages.
	//
	// LogStreamARN is a required field
	LogStreamARN *string `min:"1" type:"string" required:"true"`

	// IAM ARN of the role to use to send application messages. Note: To write application
	// messages to CloudWatch, the IAM role that is used must have the PutLogEvents
	// policy action enabled.
	//
	// RoleARN is a required field
	RoleARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CloudWatchLoggingOption) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CloudWatchLoggingOption) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CloudWatchLoggingOption"}

	if s.LogStreamARN == nil {
		invalidParams.Add(aws.NewErrParamRequired("LogStreamARN"))
	}
	if s.LogStreamARN != nil && len(*s.LogStreamARN) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LogStreamARN", 1))
	}

	if s.RoleARN == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleARN"))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Description of the CloudWatch logging option.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/CloudWatchLoggingOptionDescription
type CloudWatchLoggingOptionDescription struct {
	_ struct{} `type:"structure"`

	// ID of the CloudWatch logging option description.
	CloudWatchLoggingOptionId *string `min:"1" type:"string"`

	// ARN of the CloudWatch log to receive application messages.
	//
	// LogStreamARN is a required field
	LogStreamARN *string `min:"1" type:"string" required:"true"`

	// IAM ARN of the role to use to send application messages. Note: To write application
	// messages to CloudWatch, the IAM role used must have the PutLogEvents policy
	// action enabled.
	//
	// RoleARN is a required field
	RoleARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CloudWatchLoggingOptionDescription) String() string {
	return awsutil.Prettify(s)
}

// Describes CloudWatch logging option updates.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/CloudWatchLoggingOptionUpdate
type CloudWatchLoggingOptionUpdate struct {
	_ struct{} `type:"structure"`

	// ID of the CloudWatch logging option to update
	//
	// CloudWatchLoggingOptionId is a required field
	CloudWatchLoggingOptionId *string `min:"1" type:"string" required:"true"`

	// ARN of the CloudWatch log to receive application messages.
	LogStreamARNUpdate *string `min:"1" type:"string"`

	// IAM ARN of the role to use to send application messages. Note: To write application
	// messages to CloudWatch, the IAM role used must have the PutLogEvents policy
	// action enabled.
	RoleARNUpdate *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CloudWatchLoggingOptionUpdate) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CloudWatchLoggingOptionUpdate) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CloudWatchLoggingOptionUpdate"}

	if s.CloudWatchLoggingOptionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("CloudWatchLoggingOptionId"))
	}
	if s.CloudWatchLoggingOptionId != nil && len(*s.CloudWatchLoggingOptionId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("CloudWatchLoggingOptionId", 1))
	}
	if s.LogStreamARNUpdate != nil && len(*s.LogStreamARNUpdate) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LogStreamARNUpdate", 1))
	}
	if s.RoleARNUpdate != nil && len(*s.RoleARNUpdate) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleARNUpdate", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes the data format when records are written to the destination. For
// more information, see Configuring Application Output (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-output.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/DestinationSchema
type DestinationSchema struct {
	_ struct{} `type:"structure"`

	// Specifies the format of the records on the output stream.
	//
	// RecordFormatType is a required field
	RecordFormatType RecordFormatType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s DestinationSchema) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DestinationSchema) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DestinationSchema"}
	if len(s.RecordFormatType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("RecordFormatType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// When you configure the application input, you specify the streaming source,
// the in-application stream name that is created, and the mapping between the
// two. For more information, see Configuring Application Input (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/Input
type Input struct {
	_ struct{} `type:"structure"`

	// Describes the number of in-application streams to create.
	//
	// Data from your source is routed to these in-application input streams.
	//
	// (see Configuring Application Input (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html).
	InputParallelism *InputParallelism `type:"structure"`

	// The InputProcessingConfiguration (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputProcessingConfiguration.html)
	// for the input. An input processor transforms records as they are received
	// from the stream, before the application's SQL code executes. Currently, the
	// only input processing configuration available is InputLambdaProcessor (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputLambdaProcessor.html).
	InputProcessingConfiguration *InputProcessingConfiguration `type:"structure"`

	// Describes the format of the data in the streaming source, and how each data
	// element maps to corresponding columns in the in-application stream that is
	// being created.
	//
	// Also used to describe the format of the reference data source.
	//
	// InputSchema is a required field
	InputSchema *SourceSchema `type:"structure" required:"true"`

	// If the streaming source is an Amazon Kinesis Firehose delivery stream, identifies
	// the delivery stream's ARN and an IAM role that enables Amazon Kinesis Analytics
	// to access the stream on your behalf.
	//
	// Note: Either KinesisStreamsInput or KinesisFirehoseInput is required.
	KinesisFirehoseInput *KinesisFirehoseInput `type:"structure"`

	// If the streaming source is an Amazon Kinesis stream, identifies the stream's
	// Amazon Resource Name (ARN) and an IAM role that enables Amazon Kinesis Analytics
	// to access the stream on your behalf.
	//
	// Note: Either KinesisStreamsInput or KinesisFirehoseInput is required.
	KinesisStreamsInput *KinesisStreamsInput `type:"structure"`

	// Name prefix to use when creating an in-application stream. Suppose that you
	// specify a prefix "MyInApplicationStream." Amazon Kinesis Analytics then creates
	// one or more (as per the InputParallelism count you specified) in-application
	// streams with names "MyInApplicationStream_001," "MyInApplicationStream_002,"
	// and so on.
	//
	// NamePrefix is a required field
	NamePrefix *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s Input) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Input) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Input"}

	if s.InputSchema == nil {
		invalidParams.Add(aws.NewErrParamRequired("InputSchema"))
	}

	if s.NamePrefix == nil {
		invalidParams.Add(aws.NewErrParamRequired("NamePrefix"))
	}
	if s.NamePrefix != nil && len(*s.NamePrefix) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NamePrefix", 1))
	}
	if s.InputParallelism != nil {
		if err := s.InputParallelism.Validate(); err != nil {
			invalidParams.AddNested("InputParallelism", err.(aws.ErrInvalidParams))
		}
	}
	if s.InputProcessingConfiguration != nil {
		if err := s.InputProcessingConfiguration.Validate(); err != nil {
			invalidParams.AddNested("InputProcessingConfiguration", err.(aws.ErrInvalidParams))
		}
	}
	if s.InputSchema != nil {
		if err := s.InputSchema.Validate(); err != nil {
			invalidParams.AddNested("InputSchema", err.(aws.ErrInvalidParams))
		}
	}
	if s.KinesisFirehoseInput != nil {
		if err := s.KinesisFirehoseInput.Validate(); err != nil {
			invalidParams.AddNested("KinesisFirehoseInput", err.(aws.ErrInvalidParams))
		}
	}
	if s.KinesisStreamsInput != nil {
		if err := s.KinesisStreamsInput.Validate(); err != nil {
			invalidParams.AddNested("KinesisStreamsInput", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// When you start your application, you provide this configuration, which identifies
// the input source and the point in the input source at which you want the
// application to start processing records.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/InputConfiguration
type InputConfiguration struct {
	_ struct{} `type:"structure"`

	// Input source ID. You can get this ID by calling the DescribeApplication (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html)
	// operation.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// Point at which you want the application to start processing records from
	// the streaming source.
	//
	// InputStartingPositionConfiguration is a required field
	InputStartingPositionConfiguration *InputStartingPositionConfiguration `type:"structure" required:"true"`
}

// String returns the string representation
func (s InputConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InputConfiguration"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Id", 1))
	}

	if s.InputStartingPositionConfiguration == nil {
		invalidParams.Add(aws.NewErrParamRequired("InputStartingPositionConfiguration"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes the application input configuration. For more information, see
// Configuring Application Input (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/InputDescription
type InputDescription struct {
	_ struct{} `type:"structure"`

	// Returns the in-application stream names that are mapped to the stream source.
	InAppStreamNames []string `type:"list"`

	// Input ID associated with the application input. This is the ID that Amazon
	// Kinesis Analytics assigns to each input configuration you add to your application.
	InputId *string `min:"1" type:"string"`

	// Describes the configured parallelism (number of in-application streams mapped
	// to the streaming source).
	InputParallelism *InputParallelism `type:"structure"`

	// The description of the preprocessor that executes on records in this input
	// before the application's code is run.
	InputProcessingConfigurationDescription *InputProcessingConfigurationDescription `type:"structure"`

	// Describes the format of the data in the streaming source, and how each data
	// element maps to corresponding columns in the in-application stream that is
	// being created.
	InputSchema *SourceSchema `type:"structure"`

	// Point at which the application is configured to read from the input stream.
	InputStartingPositionConfiguration *InputStartingPositionConfiguration `type:"structure"`

	// If an Amazon Kinesis Firehose delivery stream is configured as a streaming
	// source, provides the delivery stream's ARN and an IAM role that enables Amazon
	// Kinesis Analytics to access the stream on your behalf.
	KinesisFirehoseInputDescription *KinesisFirehoseInputDescription `type:"structure"`

	// If an Amazon Kinesis stream is configured as streaming source, provides Amazon
	// Kinesis stream's Amazon Resource Name (ARN) and an IAM role that enables
	// Amazon Kinesis Analytics to access the stream on your behalf.
	KinesisStreamsInputDescription *KinesisStreamsInputDescription `type:"structure"`

	// In-application name prefix.
	NamePrefix *string `min:"1" type:"string"`
}

// String returns the string representation
func (s InputDescription) String() string {
	return awsutil.Prettify(s)
}

// An object that contains the Amazon Resource Name (ARN) of the AWS Lambda
// (https://docs.aws.amazon.com/lambda/) function that is used to preprocess
// records in the stream, and the ARN of the IAM role that is used to access
// the AWS Lambda function.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/InputLambdaProcessor
type InputLambdaProcessor struct {
	_ struct{} `type:"structure"`

	// The ARN of the AWS Lambda (https://docs.aws.amazon.com/lambda/) function
	// that operates on records in the stream.
	//
	// To specify an earlier version of the Lambda function than the latest, include
	// the Lambda function version in the Lambda function ARN. For more information
	// about Lambda ARNs, see Example ARNs: AWS Lambda (/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-lambda)
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// The ARN of the IAM role that is used to access the AWS Lambda function.
	//
	// RoleARN is a required field
	RoleARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s InputLambdaProcessor) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputLambdaProcessor) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InputLambdaProcessor"}

	if s.ResourceARN == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceARN", 1))
	}

	if s.RoleARN == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleARN"))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// An object that contains the Amazon Resource Name (ARN) of the AWS Lambda
// (https://docs.aws.amazon.com/lambda/) function that is used to preprocess
// records in the stream, and the ARN of the IAM role that is used to access
// the AWS Lambda expression.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/InputLambdaProcessorDescription
type InputLambdaProcessorDescription struct {
	_ struct{} `type:"structure"`

	// The ARN of the AWS Lambda (https://docs.aws.amazon.com/lambda/) function
	// that is used to preprocess the records in the stream.
	ResourceARN *string `min:"1" type:"string"`

	// The ARN of the IAM role that is used to access the AWS Lambda function.
	RoleARN *string `min:"1" type:"string"`
}

// String returns the string representation
func (s InputLambdaProcessorDescription) String() string {
	return awsutil.Prettify(s)
}

// Represents an update to the InputLambdaProcessor (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputLambdaProcessor.html)
// that is used to preprocess the records in the stream.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/InputLambdaProcessorUpdate
type InputLambdaProcessorUpdate struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the new AWS Lambda (https://docs.aws.amazon.com/ambda/)
	// function that is used to preprocess the records in the stream.
	//
	// To specify an earlier version of the Lambda function than the latest, include
	// the Lambda function version in the Lambda function ARN. For more information
	// about Lambda ARNs, see Example ARNs: AWS Lambda (/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-lambda)
	ResourceARNUpdate *string `min:"1" type:"string"`

	// The ARN of the new IAM role that is used to access the AWS Lambda function.
	RoleARNUpdate *string `min:"1" type:"string"`
}

// String returns the string representation
func (s InputLambdaProcessorUpdate) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputLambdaProcessorUpdate) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InputLambdaProcessorUpdate"}
	if s.ResourceARNUpdate != nil && len(*s.ResourceARNUpdate) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceARNUpdate", 1))
	}
	if s.RoleARNUpdate != nil && len(*s.RoleARNUpdate) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleARNUpdate", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes the number of in-application streams to create for a given streaming
// source. For information about parallelism, see Configuring Application Input
// (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/InputParallelism
type InputParallelism struct {
	_ struct{} `type:"structure"`

	// Number of in-application streams to create. For more information, see Limits
	// (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/limits.html).
	Count *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s InputParallelism) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputParallelism) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InputParallelism"}
	if s.Count != nil && *s.Count < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Count", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides updates to the parallelism count.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/InputParallelismUpdate
type InputParallelismUpdate struct {
	_ struct{} `type:"structure"`

	// Number of in-application streams to create for the specified streaming source.
	CountUpdate *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s InputParallelismUpdate) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputParallelismUpdate) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InputParallelismUpdate"}
	if s.CountUpdate != nil && *s.CountUpdate < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("CountUpdate", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides a description of a processor that is used to preprocess the records
// in the stream before being processed by your application code. Currently,
// the only input processor available is AWS Lambda (https://docs.aws.amazon.com/lambda/).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/InputProcessingConfiguration
type InputProcessingConfiguration struct {
	_ struct{} `type:"structure"`

	// The InputLambdaProcessor (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputLambdaProcessor.html)
	// that is used to preprocess the records in the stream before being processed
	// by your application code.
	//
	// InputLambdaProcessor is a required field
	InputLambdaProcessor *InputLambdaProcessor `type:"structure" required:"true"`
}

// String returns the string representation
func (s InputProcessingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputProcessingConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InputProcessingConfiguration"}

	if s.InputLambdaProcessor == nil {
		invalidParams.Add(aws.NewErrParamRequired("InputLambdaProcessor"))
	}
	if s.InputLambdaProcessor != nil {
		if err := s.InputLambdaProcessor.Validate(); err != nil {
			invalidParams.AddNested("InputLambdaProcessor", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides configuration information about an input processor. Currently, the
// only input processor available is AWS Lambda (https://docs.aws.amazon.com/lambda/).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/InputProcessingConfigurationDescription
type InputProcessingConfigurationDescription struct {
	_ struct{} `type:"structure"`

	// Provides configuration information about the associated InputLambdaProcessorDescription
	// (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputLambdaProcessorDescription.html).
	InputLambdaProcessorDescription *InputLambdaProcessorDescription `type:"structure"`
}

// String returns the string representation
func (s InputProcessingConfigurationDescription) String() string {
	return awsutil.Prettify(s)
}

// Describes updates to an InputProcessingConfiguration (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputProcessingConfiguration.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/InputProcessingConfigurationUpdate
type InputProcessingConfigurationUpdate struct {
	_ struct{} `type:"structure"`

	// Provides update information for an InputLambdaProcessor (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputLambdaProcessor.html).
	//
	// InputLambdaProcessorUpdate is a required field
	InputLambdaProcessorUpdate *InputLambdaProcessorUpdate `type:"structure" required:"true"`
}

// String returns the string representation
func (s InputProcessingConfigurationUpdate) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputProcessingConfigurationUpdate) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InputProcessingConfigurationUpdate"}

	if s.InputLambdaProcessorUpdate == nil {
		invalidParams.Add(aws.NewErrParamRequired("InputLambdaProcessorUpdate"))
	}
	if s.InputLambdaProcessorUpdate != nil {
		if err := s.InputLambdaProcessorUpdate.Validate(); err != nil {
			invalidParams.AddNested("InputLambdaProcessorUpdate", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes updates for the application's input schema.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/InputSchemaUpdate
type InputSchemaUpdate struct {
	_ struct{} `type:"structure"`

	// A list of RecordColumn objects. Each object describes the mapping of the
	// streaming source element to the corresponding column in the in-application
	// stream.
	RecordColumnUpdates []RecordColumn `min:"1" type:"list"`

	// Specifies the encoding of the records in the streaming source. For example,
	// UTF-8.
	RecordEncodingUpdate *string `type:"string"`

	// Specifies the format of the records on the streaming source.
	RecordFormatUpdate *RecordFormat `type:"structure"`
}

// String returns the string representation
func (s InputSchemaUpdate) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputSchemaUpdate) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InputSchemaUpdate"}
	if s.RecordColumnUpdates != nil && len(s.RecordColumnUpdates) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RecordColumnUpdates", 1))
	}
	if s.RecordColumnUpdates != nil {
		for i, v := range s.RecordColumnUpdates {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RecordColumnUpdates", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.RecordFormatUpdate != nil {
		if err := s.RecordFormatUpdate.Validate(); err != nil {
			invalidParams.AddNested("RecordFormatUpdate", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes the point at which the application reads from the streaming source.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/InputStartingPositionConfiguration
type InputStartingPositionConfiguration struct {
	_ struct{} `type:"structure"`

	// The starting position on the stream.
	//
	//    * NOW - Start reading just after the most recent record in the stream,
	//    start at the request time stamp that the customer issued.
	//
	//    * TRIM_HORIZON - Start reading at the last untrimmed record in the stream,
	//    which is the oldest record available in the stream. This option is not
	//    available for an Amazon Kinesis Firehose delivery stream.
	//
	//    * LAST_STOPPED_POINT - Resume reading from where the application last
	//    stopped reading.
	InputStartingPosition InputStartingPosition `type:"string" enum:"true"`
}

// String returns the string representation
func (s InputStartingPositionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Describes updates to a specific input configuration (identified by the InputId
// of an application).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/InputUpdate
type InputUpdate struct {
	_ struct{} `type:"structure"`

	// Input ID of the application input to be updated.
	//
	// InputId is a required field
	InputId *string `min:"1" type:"string" required:"true"`

	// Describes the parallelism updates (the number in-application streams Amazon
	// Kinesis Analytics creates for the specific streaming source).
	InputParallelismUpdate *InputParallelismUpdate `type:"structure"`

	// Describes updates for an input processing configuration.
	InputProcessingConfigurationUpdate *InputProcessingConfigurationUpdate `type:"structure"`

	// Describes the data format on the streaming source, and how record elements
	// on the streaming source map to columns of the in-application stream that
	// is created.
	InputSchemaUpdate *InputSchemaUpdate `type:"structure"`

	// If an Amazon Kinesis Firehose delivery stream is the streaming source to
	// be updated, provides an updated stream ARN and IAM role ARN.
	KinesisFirehoseInputUpdate *KinesisFirehoseInputUpdate `type:"structure"`

	// If an Amazon Kinesis stream is the streaming source to be updated, provides
	// an updated stream Amazon Resource Name (ARN) and IAM role ARN.
	KinesisStreamsInputUpdate *KinesisStreamsInputUpdate `type:"structure"`

	// Name prefix for in-application streams that Amazon Kinesis Analytics creates
	// for the specific streaming source.
	NamePrefixUpdate *string `min:"1" type:"string"`
}

// String returns the string representation
func (s InputUpdate) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputUpdate) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InputUpdate"}

	if s.InputId == nil {
		invalidParams.Add(aws.NewErrParamRequired("InputId"))
	}
	if s.InputId != nil && len(*s.InputId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("InputId", 1))
	}
	if s.NamePrefixUpdate != nil && len(*s.NamePrefixUpdate) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NamePrefixUpdate", 1))
	}
	if s.InputParallelismUpdate != nil {
		if err := s.InputParallelismUpdate.Validate(); err != nil {
			invalidParams.AddNested("InputParallelismUpdate", err.(aws.ErrInvalidParams))
		}
	}
	if s.InputProcessingConfigurationUpdate != nil {
		if err := s.InputProcessingConfigurationUpdate.Validate(); err != nil {
			invalidParams.AddNested("InputProcessingConfigurationUpdate", err.(aws.ErrInvalidParams))
		}
	}
	if s.InputSchemaUpdate != nil {
		if err := s.InputSchemaUpdate.Validate(); err != nil {
			invalidParams.AddNested("InputSchemaUpdate", err.(aws.ErrInvalidParams))
		}
	}
	if s.KinesisFirehoseInputUpdate != nil {
		if err := s.KinesisFirehoseInputUpdate.Validate(); err != nil {
			invalidParams.AddNested("KinesisFirehoseInputUpdate", err.(aws.ErrInvalidParams))
		}
	}
	if s.KinesisStreamsInputUpdate != nil {
		if err := s.KinesisStreamsInputUpdate.Validate(); err != nil {
			invalidParams.AddNested("KinesisStreamsInputUpdate", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides additional mapping information when JSON is the record format on
// the streaming source.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/JSONMappingParameters
type JSONMappingParameters struct {
	_ struct{} `type:"structure"`

	// Path to the top-level parent that contains the records.
	//
	// RecordRowPath is a required field
	RecordRowPath *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s JSONMappingParameters) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *JSONMappingParameters) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "JSONMappingParameters"}

	if s.RecordRowPath == nil {
		invalidParams.Add(aws.NewErrParamRequired("RecordRowPath"))
	}
	if s.RecordRowPath != nil && len(*s.RecordRowPath) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RecordRowPath", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Identifies an Amazon Kinesis Firehose delivery stream as the streaming source.
// You provide the delivery stream's Amazon Resource Name (ARN) and an IAM role
// ARN that enables Amazon Kinesis Analytics to access the stream on your behalf.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/KinesisFirehoseInput
type KinesisFirehoseInput struct {
	_ struct{} `type:"structure"`

	// ARN of the input delivery stream.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// ARN of the IAM role that Amazon Kinesis Analytics can assume to access the
	// stream on your behalf. You need to make sure that the role has the necessary
	// permissions to access the stream.
	//
	// RoleARN is a required field
	RoleARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s KinesisFirehoseInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KinesisFirehoseInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "KinesisFirehoseInput"}

	if s.ResourceARN == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceARN", 1))
	}

	if s.RoleARN == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleARN"))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes the Amazon Kinesis Firehose delivery stream that is configured
// as the streaming source in the application input configuration.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/KinesisFirehoseInputDescription
type KinesisFirehoseInputDescription struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the Amazon Kinesis Firehose delivery stream.
	ResourceARN *string `min:"1" type:"string"`

	// ARN of the IAM role that Amazon Kinesis Analytics assumes to access the stream.
	RoleARN *string `min:"1" type:"string"`
}

// String returns the string representation
func (s KinesisFirehoseInputDescription) String() string {
	return awsutil.Prettify(s)
}

// When updating application input configuration, provides information about
// an Amazon Kinesis Firehose delivery stream as the streaming source.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/KinesisFirehoseInputUpdate
type KinesisFirehoseInputUpdate struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the input Amazon Kinesis Firehose delivery
	// stream to read.
	ResourceARNUpdate *string `min:"1" type:"string"`

	// ARN of the IAM role that Amazon Kinesis Analytics can assume to access the
	// stream on your behalf. You need to grant the necessary permissions to this
	// role.
	RoleARNUpdate *string `min:"1" type:"string"`
}

// String returns the string representation
func (s KinesisFirehoseInputUpdate) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KinesisFirehoseInputUpdate) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "KinesisFirehoseInputUpdate"}
	if s.ResourceARNUpdate != nil && len(*s.ResourceARNUpdate) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceARNUpdate", 1))
	}
	if s.RoleARNUpdate != nil && len(*s.RoleARNUpdate) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleARNUpdate", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// When configuring application output, identifies an Amazon Kinesis Firehose
// delivery stream as the destination. You provide the stream Amazon Resource
// Name (ARN) and an IAM role that enables Amazon Kinesis Analytics to write
// to the stream on your behalf.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/KinesisFirehoseOutput
type KinesisFirehoseOutput struct {
	_ struct{} `type:"structure"`

	// ARN of the destination Amazon Kinesis Firehose delivery stream to write to.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// ARN of the IAM role that Amazon Kinesis Analytics can assume to write to
	// the destination stream on your behalf. You need to grant the necessary permissions
	// to this role.
	//
	// RoleARN is a required field
	RoleARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s KinesisFirehoseOutput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KinesisFirehoseOutput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "KinesisFirehoseOutput"}

	if s.ResourceARN == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceARN", 1))
	}

	if s.RoleARN == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleARN"))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// For an application output, describes the Amazon Kinesis Firehose delivery
// stream configured as its destination.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/KinesisFirehoseOutputDescription
type KinesisFirehoseOutputDescription struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the Amazon Kinesis Firehose delivery stream.
	ResourceARN *string `min:"1" type:"string"`

	// ARN of the IAM role that Amazon Kinesis Analytics can assume to access the
	// stream.
	RoleARN *string `min:"1" type:"string"`
}

// String returns the string representation
func (s KinesisFirehoseOutputDescription) String() string {
	return awsutil.Prettify(s)
}

// When updating an output configuration using the UpdateApplication (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_UpdateApplication.html)
// operation, provides information about an Amazon Kinesis Firehose delivery
// stream configured as the destination.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/KinesisFirehoseOutputUpdate
type KinesisFirehoseOutputUpdate struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the Amazon Kinesis Firehose delivery stream
	// to write to.
	ResourceARNUpdate *string `min:"1" type:"string"`

	// ARN of the IAM role that Amazon Kinesis Analytics can assume to access the
	// stream on your behalf. You need to grant the necessary permissions to this
	// role.
	RoleARNUpdate *string `min:"1" type:"string"`
}

// String returns the string representation
func (s KinesisFirehoseOutputUpdate) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KinesisFirehoseOutputUpdate) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "KinesisFirehoseOutputUpdate"}
	if s.ResourceARNUpdate != nil && len(*s.ResourceARNUpdate) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceARNUpdate", 1))
	}
	if s.RoleARNUpdate != nil && len(*s.RoleARNUpdate) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleARNUpdate", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Identifies an Amazon Kinesis stream as the streaming source. You provide
// the stream's Amazon Resource Name (ARN) and an IAM role ARN that enables
// Amazon Kinesis Analytics to access the stream on your behalf.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/KinesisStreamsInput
type KinesisStreamsInput struct {
	_ struct{} `type:"structure"`

	// ARN of the input Amazon Kinesis stream to read.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// ARN of the IAM role that Amazon Kinesis Analytics can assume to access the
	// stream on your behalf. You need to grant the necessary permissions to this
	// role.
	//
	// RoleARN is a required field
	RoleARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s KinesisStreamsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KinesisStreamsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "KinesisStreamsInput"}

	if s.ResourceARN == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceARN", 1))
	}

	if s.RoleARN == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleARN"))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes the Amazon Kinesis stream that is configured as the streaming source
// in the application input configuration.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/KinesisStreamsInputDescription
type KinesisStreamsInputDescription struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the Amazon Kinesis stream.
	ResourceARN *string `min:"1" type:"string"`

	// ARN of the IAM role that Amazon Kinesis Analytics can assume to access the
	// stream.
	RoleARN *string `min:"1" type:"string"`
}

// String returns the string representation
func (s KinesisStreamsInputDescription) String() string {
	return awsutil.Prettify(s)
}

// When updating application input configuration, provides information about
// an Amazon Kinesis stream as the streaming source.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/KinesisStreamsInputUpdate
type KinesisStreamsInputUpdate struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the input Amazon Kinesis stream to read.
	ResourceARNUpdate *string `min:"1" type:"string"`

	// ARN of the IAM role that Amazon Kinesis Analytics can assume to access the
	// stream on your behalf. You need to grant the necessary permissions to this
	// role.
	RoleARNUpdate *string `min:"1" type:"string"`
}

// String returns the string representation
func (s KinesisStreamsInputUpdate) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KinesisStreamsInputUpdate) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "KinesisStreamsInputUpdate"}
	if s.ResourceARNUpdate != nil && len(*s.ResourceARNUpdate) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceARNUpdate", 1))
	}
	if s.RoleARNUpdate != nil && len(*s.RoleARNUpdate) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleARNUpdate", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// When configuring application output, identifies an Amazon Kinesis stream
// as the destination. You provide the stream Amazon Resource Name (ARN) and
// also an IAM role ARN that Amazon Kinesis Analytics can use to write to the
// stream on your behalf.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/KinesisStreamsOutput
type KinesisStreamsOutput struct {
	_ struct{} `type:"structure"`

	// ARN of the destination Amazon Kinesis stream to write to.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// ARN of the IAM role that Amazon Kinesis Analytics can assume to write to
	// the destination stream on your behalf. You need to grant the necessary permissions
	// to this role.
	//
	// RoleARN is a required field
	RoleARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s KinesisStreamsOutput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KinesisStreamsOutput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "KinesisStreamsOutput"}

	if s.ResourceARN == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceARN", 1))
	}

	if s.RoleARN == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleARN"))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// For an application output, describes the Amazon Kinesis stream configured
// as its destination.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/KinesisStreamsOutputDescription
type KinesisStreamsOutputDescription struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the Amazon Kinesis stream.
	ResourceARN *string `min:"1" type:"string"`

	// ARN of the IAM role that Amazon Kinesis Analytics can assume to access the
	// stream.
	RoleARN *string `min:"1" type:"string"`
}

// String returns the string representation
func (s KinesisStreamsOutputDescription) String() string {
	return awsutil.Prettify(s)
}

// When updating an output configuration using the UpdateApplication (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_UpdateApplication.html)
// operation, provides information about an Amazon Kinesis stream configured
// as the destination.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/KinesisStreamsOutputUpdate
type KinesisStreamsOutputUpdate struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the Amazon Kinesis stream where you want to
	// write the output.
	ResourceARNUpdate *string `min:"1" type:"string"`

	// ARN of the IAM role that Amazon Kinesis Analytics can assume to access the
	// stream on your behalf. You need to grant the necessary permissions to this
	// role.
	RoleARNUpdate *string `min:"1" type:"string"`
}

// String returns the string representation
func (s KinesisStreamsOutputUpdate) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KinesisStreamsOutputUpdate) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "KinesisStreamsOutputUpdate"}
	if s.ResourceARNUpdate != nil && len(*s.ResourceARNUpdate) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceARNUpdate", 1))
	}
	if s.RoleARNUpdate != nil && len(*s.RoleARNUpdate) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleARNUpdate", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// When configuring application output, identifies an AWS Lambda function as
// the destination. You provide the function Amazon Resource Name (ARN) and
// also an IAM role ARN that Amazon Kinesis Analytics can use to write to the
// function on your behalf.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/LambdaOutput
type LambdaOutput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the destination Lambda function to write to.
	//
	// To specify an earlier version of the Lambda function than the latest, include
	// the Lambda function version in the Lambda function ARN. For more information
	// about Lambda ARNs, see Example ARNs: AWS Lambda (/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-lambda)
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// ARN of the IAM role that Amazon Kinesis Analytics can assume to write to
	// the destination function on your behalf. You need to grant the necessary
	// permissions to this role.
	//
	// RoleARN is a required field
	RoleARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s LambdaOutput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LambdaOutput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LambdaOutput"}

	if s.ResourceARN == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceARN", 1))
	}

	if s.RoleARN == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleARN"))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// For an application output, describes the AWS Lambda function configured as
// its destination.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/LambdaOutputDescription
type LambdaOutputDescription struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the destination Lambda function.
	ResourceARN *string `min:"1" type:"string"`

	// ARN of the IAM role that Amazon Kinesis Analytics can assume to write to
	// the destination function.
	RoleARN *string `min:"1" type:"string"`
}

// String returns the string representation
func (s LambdaOutputDescription) String() string {
	return awsutil.Prettify(s)
}

// When updating an output configuration using the UpdateApplication (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_UpdateApplication.html)
// operation, provides information about an AWS Lambda function configured as
// the destination.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/LambdaOutputUpdate
type LambdaOutputUpdate struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the destination Lambda function.
	//
	// To specify an earlier version of the Lambda function than the latest, include
	// the Lambda function version in the Lambda function ARN. For more information
	// about Lambda ARNs, see Example ARNs: AWS Lambda (/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-lambda)
	ResourceARNUpdate *string `min:"1" type:"string"`

	// ARN of the IAM role that Amazon Kinesis Analytics can assume to write to
	// the destination function on your behalf. You need to grant the necessary
	// permissions to this role.
	RoleARNUpdate *string `min:"1" type:"string"`
}

// String returns the string representation
func (s LambdaOutputUpdate) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LambdaOutputUpdate) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LambdaOutputUpdate"}
	if s.ResourceARNUpdate != nil && len(*s.ResourceARNUpdate) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceARNUpdate", 1))
	}
	if s.RoleARNUpdate != nil && len(*s.RoleARNUpdate) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleARNUpdate", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// When configuring application input at the time of creating or updating an
// application, provides additional mapping information specific to the record
// format (such as JSON, CSV, or record fields delimited by some delimiter)
// on the streaming source.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/MappingParameters
type MappingParameters struct {
	_ struct{} `type:"structure"`

	// Provides additional mapping information when the record format uses delimiters
	// (for example, CSV).
	CSVMappingParameters *CSVMappingParameters `type:"structure"`

	// Provides additional mapping information when JSON is the record format on
	// the streaming source.
	JSONMappingParameters *JSONMappingParameters `type:"structure"`
}

// String returns the string representation
func (s MappingParameters) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MappingParameters) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "MappingParameters"}
	if s.CSVMappingParameters != nil {
		if err := s.CSVMappingParameters.Validate(); err != nil {
			invalidParams.AddNested("CSVMappingParameters", err.(aws.ErrInvalidParams))
		}
	}
	if s.JSONMappingParameters != nil {
		if err := s.JSONMappingParameters.Validate(); err != nil {
			invalidParams.AddNested("JSONMappingParameters", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes application output configuration in which you identify an in-application
// stream and a destination where you want the in-application stream data to
// be written. The destination can be an Amazon Kinesis stream or an Amazon
// Kinesis Firehose delivery stream.
//
// For limits on how many destinations an application can write and other limitations,
// see Limits (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/limits.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/Output
type Output struct {
	_ struct{} `type:"structure"`

	// Describes the data format when records are written to the destination. For
	// more information, see Configuring Application Output (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-output.html).
	//
	// DestinationSchema is a required field
	DestinationSchema *DestinationSchema `type:"structure" required:"true"`

	// Identifies an Amazon Kinesis Firehose delivery stream as the destination.
	KinesisFirehoseOutput *KinesisFirehoseOutput `type:"structure"`

	// Identifies an Amazon Kinesis stream as the destination.
	KinesisStreamsOutput *KinesisStreamsOutput `type:"structure"`

	// Identifies an AWS Lambda function as the destination.
	LambdaOutput *LambdaOutput `type:"structure"`

	// Name of the in-application stream.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s Output) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Output) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Output"}

	if s.DestinationSchema == nil {
		invalidParams.Add(aws.NewErrParamRequired("DestinationSchema"))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if s.DestinationSchema != nil {
		if err := s.DestinationSchema.Validate(); err != nil {
			invalidParams.AddNested("DestinationSchema", err.(aws.ErrInvalidParams))
		}
	}
	if s.KinesisFirehoseOutput != nil {
		if err := s.KinesisFirehoseOutput.Validate(); err != nil {
			invalidParams.AddNested("KinesisFirehoseOutput", err.(aws.ErrInvalidParams))
		}
	}
	if s.KinesisStreamsOutput != nil {
		if err := s.KinesisStreamsOutput.Validate(); err != nil {
			invalidParams.AddNested("KinesisStreamsOutput", err.(aws.ErrInvalidParams))
		}
	}
	if s.LambdaOutput != nil {
		if err := s.LambdaOutput.Validate(); err != nil {
			invalidParams.AddNested("LambdaOutput", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes the application output configuration, which includes the in-application
// stream name and the destination where the stream data is written. The destination
// can be an Amazon Kinesis stream or an Amazon Kinesis Firehose delivery stream.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/OutputDescription
type OutputDescription struct {
	_ struct{} `type:"structure"`

	// Data format used for writing data to the destination.
	DestinationSchema *DestinationSchema `type:"structure"`

	// Describes the Amazon Kinesis Firehose delivery stream configured as the destination
	// where output is written.
	KinesisFirehoseOutputDescription *KinesisFirehoseOutputDescription `type:"structure"`

	// Describes Amazon Kinesis stream configured as the destination where output
	// is written.
	KinesisStreamsOutputDescription *KinesisStreamsOutputDescription `type:"structure"`

	// Describes the AWS Lambda function configured as the destination where output
	// is written.
	LambdaOutputDescription *LambdaOutputDescription `type:"structure"`

	// Name of the in-application stream configured as output.
	Name *string `min:"1" type:"string"`

	// A unique identifier for the output configuration.
	OutputId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s OutputDescription) String() string {
	return awsutil.Prettify(s)
}

// Describes updates to the output configuration identified by the OutputId.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/OutputUpdate
type OutputUpdate struct {
	_ struct{} `type:"structure"`

	// Describes the data format when records are written to the destination. For
	// more information, see Configuring Application Output (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-output.html).
	DestinationSchemaUpdate *DestinationSchema `type:"structure"`

	// Describes an Amazon Kinesis Firehose delivery stream as the destination for
	// the output.
	KinesisFirehoseOutputUpdate *KinesisFirehoseOutputUpdate `type:"structure"`

	// Describes an Amazon Kinesis stream as the destination for the output.
	KinesisStreamsOutputUpdate *KinesisStreamsOutputUpdate `type:"structure"`

	// Describes an AWS Lambda function as the destination for the output.
	LambdaOutputUpdate *LambdaOutputUpdate `type:"structure"`

	// If you want to specify a different in-application stream for this output
	// configuration, use this field to specify the new in-application stream name.
	NameUpdate *string `min:"1" type:"string"`

	// Identifies the specific output configuration that you want to update.
	//
	// OutputId is a required field
	OutputId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s OutputUpdate) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OutputUpdate) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "OutputUpdate"}
	if s.NameUpdate != nil && len(*s.NameUpdate) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NameUpdate", 1))
	}

	if s.OutputId == nil {
		invalidParams.Add(aws.NewErrParamRequired("OutputId"))
	}
	if s.OutputId != nil && len(*s.OutputId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("OutputId", 1))
	}
	if s.DestinationSchemaUpdate != nil {
		if err := s.DestinationSchemaUpdate.Validate(); err != nil {
			invalidParams.AddNested("DestinationSchemaUpdate", err.(aws.ErrInvalidParams))
		}
	}
	if s.KinesisFirehoseOutputUpdate != nil {
		if err := s.KinesisFirehoseOutputUpdate.Validate(); err != nil {
			invalidParams.AddNested("KinesisFirehoseOutputUpdate", err.(aws.ErrInvalidParams))
		}
	}
	if s.KinesisStreamsOutputUpdate != nil {
		if err := s.KinesisStreamsOutputUpdate.Validate(); err != nil {
			invalidParams.AddNested("KinesisStreamsOutputUpdate", err.(aws.ErrInvalidParams))
		}
	}
	if s.LambdaOutputUpdate != nil {
		if err := s.LambdaOutputUpdate.Validate(); err != nil {
			invalidParams.AddNested("LambdaOutputUpdate", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes the mapping of each data element in the streaming source to the
// corresponding column in the in-application stream.
//
// Also used to describe the format of the reference data source.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/RecordColumn
type RecordColumn struct {
	_ struct{} `type:"structure"`

	// Reference to the data element in the streaming input or the reference data
	// source. This element is required if the RecordFormatType (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_RecordFormat.html#analytics-Type-RecordFormat-RecordFormatTypel)
	// is JSON.
	Mapping *string `type:"string"`

	// Name of the column created in the in-application input stream or reference
	// table.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// Type of column created in the in-application input stream or reference table.
	//
	// SqlType is a required field
	SqlType *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RecordColumn) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RecordColumn) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RecordColumn"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if s.SqlType == nil {
		invalidParams.Add(aws.NewErrParamRequired("SqlType"))
	}
	if s.SqlType != nil && len(*s.SqlType) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SqlType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes the record format and relevant mapping information that should
// be applied to schematize the records on the stream.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/RecordFormat
type RecordFormat struct {
	_ struct{} `type:"structure"`

	// When configuring application input at the time of creating or updating an
	// application, provides additional mapping information specific to the record
	// format (such as JSON, CSV, or record fields delimited by some delimiter)
	// on the streaming source.
	MappingParameters *MappingParameters `type:"structure"`

	// The type of record format.
	//
	// RecordFormatType is a required field
	RecordFormatType RecordFormatType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s RecordFormat) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RecordFormat) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RecordFormat"}
	if len(s.RecordFormatType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("RecordFormatType"))
	}
	if s.MappingParameters != nil {
		if err := s.MappingParameters.Validate(); err != nil {
			invalidParams.AddNested("MappingParameters", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes the reference data source by providing the source information (S3
// bucket name and object key name), the resulting in-application table name
// that is created, and the necessary schema to map the data elements in the
// Amazon S3 object to the in-application table.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/ReferenceDataSource
type ReferenceDataSource struct {
	_ struct{} `type:"structure"`

	// Describes the format of the data in the streaming source, and how each data
	// element maps to corresponding columns created in the in-application stream.
	//
	// ReferenceSchema is a required field
	ReferenceSchema *SourceSchema `type:"structure" required:"true"`

	// Identifies the S3 bucket and object that contains the reference data. Also
	// identifies the IAM role Amazon Kinesis Analytics can assume to read this
	// object on your behalf. An Amazon Kinesis Analytics application loads reference
	// data only once. If the data changes, you call the UpdateApplication operation
	// to trigger reloading of data into your application.
	S3ReferenceDataSource *S3ReferenceDataSource `type:"structure"`

	// Name of the in-application table to create.
	//
	// TableName is a required field
	TableName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ReferenceDataSource) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReferenceDataSource) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ReferenceDataSource"}

	if s.ReferenceSchema == nil {
		invalidParams.Add(aws.NewErrParamRequired("ReferenceSchema"))
	}

	if s.TableName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TableName", 1))
	}
	if s.ReferenceSchema != nil {
		if err := s.ReferenceSchema.Validate(); err != nil {
			invalidParams.AddNested("ReferenceSchema", err.(aws.ErrInvalidParams))
		}
	}
	if s.S3ReferenceDataSource != nil {
		if err := s.S3ReferenceDataSource.Validate(); err != nil {
			invalidParams.AddNested("S3ReferenceDataSource", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes the reference data source configured for an application.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/ReferenceDataSourceDescription
type ReferenceDataSourceDescription struct {
	_ struct{} `type:"structure"`

	// ID of the reference data source. This is the ID that Amazon Kinesis Analytics
	// assigns when you add the reference data source to your application using
	// the AddApplicationReferenceDataSource (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_AddApplicationReferenceDataSource.html)
	// operation.
	//
	// ReferenceId is a required field
	ReferenceId *string `min:"1" type:"string" required:"true"`

	// Describes the format of the data in the streaming source, and how each data
	// element maps to corresponding columns created in the in-application stream.
	ReferenceSchema *SourceSchema `type:"structure"`

	// Provides the S3 bucket name, the object key name that contains the reference
	// data. It also provides the Amazon Resource Name (ARN) of the IAM role that
	// Amazon Kinesis Analytics can assume to read the Amazon S3 object and populate
	// the in-application reference table.
	//
	// S3ReferenceDataSourceDescription is a required field
	S3ReferenceDataSourceDescription *S3ReferenceDataSourceDescription `type:"structure" required:"true"`

	// The in-application table name created by the specific reference data source
	// configuration.
	//
	// TableName is a required field
	TableName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ReferenceDataSourceDescription) String() string {
	return awsutil.Prettify(s)
}

// When you update a reference data source configuration for an application,
// this object provides all the updated values (such as the source bucket name
// and object key name), the in-application table name that is created, and
// updated mapping information that maps the data in the Amazon S3 object to
// the in-application reference table that is created.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/ReferenceDataSourceUpdate
type ReferenceDataSourceUpdate struct {
	_ struct{} `type:"structure"`

	// ID of the reference data source being updated. You can use the DescribeApplication
	// (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html)
	// operation to get this value.
	//
	// ReferenceId is a required field
	ReferenceId *string `min:"1" type:"string" required:"true"`

	// Describes the format of the data in the streaming source, and how each data
	// element maps to corresponding columns created in the in-application stream.
	ReferenceSchemaUpdate *SourceSchema `type:"structure"`

	// Describes the S3 bucket name, object key name, and IAM role that Amazon Kinesis
	// Analytics can assume to read the Amazon S3 object on your behalf and populate
	// the in-application reference table.
	S3ReferenceDataSourceUpdate *S3ReferenceDataSourceUpdate `type:"structure"`

	// In-application table name that is created by this update.
	TableNameUpdate *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ReferenceDataSourceUpdate) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReferenceDataSourceUpdate) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ReferenceDataSourceUpdate"}

	if s.ReferenceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ReferenceId"))
	}
	if s.ReferenceId != nil && len(*s.ReferenceId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ReferenceId", 1))
	}
	if s.TableNameUpdate != nil && len(*s.TableNameUpdate) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TableNameUpdate", 1))
	}
	if s.ReferenceSchemaUpdate != nil {
		if err := s.ReferenceSchemaUpdate.Validate(); err != nil {
			invalidParams.AddNested("ReferenceSchemaUpdate", err.(aws.ErrInvalidParams))
		}
	}
	if s.S3ReferenceDataSourceUpdate != nil {
		if err := s.S3ReferenceDataSourceUpdate.Validate(); err != nil {
			invalidParams.AddNested("S3ReferenceDataSourceUpdate", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides a description of an Amazon S3 data source, including the Amazon
// Resource Name (ARN) of the S3 bucket, the ARN of the IAM role that is used
// to access the bucket, and the name of the Amazon S3 object that contains
// the data.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/S3Configuration
type S3Configuration struct {
	_ struct{} `type:"structure"`

	// ARN of the S3 bucket that contains the data.
	//
	// BucketARN is a required field
	BucketARN *string `min:"1" type:"string" required:"true"`

	// The name of the object that contains the data.
	//
	// FileKey is a required field
	FileKey *string `min:"1" type:"string" required:"true"`

	// IAM ARN of the role used to access the data.
	//
	// RoleARN is a required field
	RoleARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s S3Configuration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Configuration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "S3Configuration"}

	if s.BucketARN == nil {
		invalidParams.Add(aws.NewErrParamRequired("BucketARN"))
	}
	if s.BucketARN != nil && len(*s.BucketARN) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("BucketARN", 1))
	}

	if s.FileKey == nil {
		invalidParams.Add(aws.NewErrParamRequired("FileKey"))
	}
	if s.FileKey != nil && len(*s.FileKey) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FileKey", 1))
	}

	if s.RoleARN == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleARN"))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Identifies the S3 bucket and object that contains the reference data. Also
// identifies the IAM role Amazon Kinesis Analytics can assume to read this
// object on your behalf.
//
// An Amazon Kinesis Analytics application loads reference data only once. If
// the data changes, you call the UpdateApplication (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_UpdateApplication.html)
// operation to trigger reloading of data into your application.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/S3ReferenceDataSource
type S3ReferenceDataSource struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the S3 bucket.
	//
	// BucketARN is a required field
	BucketARN *string `min:"1" type:"string" required:"true"`

	// Object key name containing reference data.
	//
	// FileKey is a required field
	FileKey *string `min:"1" type:"string" required:"true"`

	// ARN of the IAM role that the service can assume to read data on your behalf.
	// This role must have permission for the s3:GetObject action on the object
	// and trust policy that allows Amazon Kinesis Analytics service principal to
	// assume this role.
	//
	// ReferenceRoleARN is a required field
	ReferenceRoleARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s S3ReferenceDataSource) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3ReferenceDataSource) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "S3ReferenceDataSource"}

	if s.BucketARN == nil {
		invalidParams.Add(aws.NewErrParamRequired("BucketARN"))
	}
	if s.BucketARN != nil && len(*s.BucketARN) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("BucketARN", 1))
	}

	if s.FileKey == nil {
		invalidParams.Add(aws.NewErrParamRequired("FileKey"))
	}
	if s.FileKey != nil && len(*s.FileKey) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FileKey", 1))
	}

	if s.ReferenceRoleARN == nil {
		invalidParams.Add(aws.NewErrParamRequired("ReferenceRoleARN"))
	}
	if s.ReferenceRoleARN != nil && len(*s.ReferenceRoleARN) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ReferenceRoleARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides the bucket name and object key name that stores the reference data.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/S3ReferenceDataSourceDescription
type S3ReferenceDataSourceDescription struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the S3 bucket.
	//
	// BucketARN is a required field
	BucketARN *string `min:"1" type:"string" required:"true"`

	// Amazon S3 object key name.
	//
	// FileKey is a required field
	FileKey *string `min:"1" type:"string" required:"true"`

	// ARN of the IAM role that Amazon Kinesis Analytics can assume to read the
	// Amazon S3 object on your behalf to populate the in-application reference
	// table.
	//
	// ReferenceRoleARN is a required field
	ReferenceRoleARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s S3ReferenceDataSourceDescription) String() string {
	return awsutil.Prettify(s)
}

// Describes the S3 bucket name, object key name, and IAM role that Amazon Kinesis
// Analytics can assume to read the Amazon S3 object on your behalf and populate
// the in-application reference table.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/S3ReferenceDataSourceUpdate
type S3ReferenceDataSourceUpdate struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the S3 bucket.
	BucketARNUpdate *string `min:"1" type:"string"`

	// Object key name.
	FileKeyUpdate *string `min:"1" type:"string"`

	// ARN of the IAM role that Amazon Kinesis Analytics can assume to read the
	// Amazon S3 object and populate the in-application.
	ReferenceRoleARNUpdate *string `min:"1" type:"string"`
}

// String returns the string representation
func (s S3ReferenceDataSourceUpdate) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3ReferenceDataSourceUpdate) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "S3ReferenceDataSourceUpdate"}
	if s.BucketARNUpdate != nil && len(*s.BucketARNUpdate) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("BucketARNUpdate", 1))
	}
	if s.FileKeyUpdate != nil && len(*s.FileKeyUpdate) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FileKeyUpdate", 1))
	}
	if s.ReferenceRoleARNUpdate != nil && len(*s.ReferenceRoleARNUpdate) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ReferenceRoleARNUpdate", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes the format of the data in the streaming source, and how each data
// element maps to corresponding columns created in the in-application stream.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/SourceSchema
type SourceSchema struct {
	_ struct{} `type:"structure"`

	// A list of RecordColumn objects.
	//
	// RecordColumns is a required field
	RecordColumns []RecordColumn `min:"1" type:"list" required:"true"`

	// Specifies the encoding of the records in the streaming source. For example,
	// UTF-8.
	RecordEncoding *string `type:"string"`

	// Specifies the format of the records on the streaming source.
	//
	// RecordFormat is a required field
	RecordFormat *RecordFormat `type:"structure" required:"true"`
}

// String returns the string representation
func (s SourceSchema) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SourceSchema) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SourceSchema"}

	if s.RecordColumns == nil {
		invalidParams.Add(aws.NewErrParamRequired("RecordColumns"))
	}
	if s.RecordColumns != nil && len(s.RecordColumns) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RecordColumns", 1))
	}

	if s.RecordFormat == nil {
		invalidParams.Add(aws.NewErrParamRequired("RecordFormat"))
	}
	if s.RecordColumns != nil {
		for i, v := range s.RecordColumns {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RecordColumns", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.RecordFormat != nil {
		if err := s.RecordFormat.Validate(); err != nil {
			invalidParams.AddNested("RecordFormat", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A key-value pair (the value is optional) that you can define and assign to
// AWS resources. If you specify a tag that already exists, the tag value is
// replaced with the value that you specify in the request. Note that the maximum
// number of application tags includes system tags. The maximum number of user-defined
// application tags is 50. For more information, see Using Cost Allocation Tags
// (https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html)
// in the AWS Billing and Cost Management Guide.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/Tag
type Tag struct {
	_ struct{} `type:"structure"`

	// The key of the key-value tag.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The value of the key-value tag. The value is optional.
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Tag"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}
