// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kms

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/CreateAliasRequest
type CreateAliasInput struct {
	_ struct{} `type:"structure"`

	// Specifies the alias name. This value must begin with alias/ followed by a
	// name, such as alias/ExampleAlias. The alias name cannot begin with alias/aws/.
	// The alias/aws/ prefix is reserved for AWS managed CMKs.
	//
	// AliasName is a required field
	AliasName *string `min:"1" type:"string" required:"true"`

	// Identifies the CMK to which the alias refers. Specify the key ID or the Amazon
	// Resource Name (ARN) of the CMK. You cannot specify another alias. For help
	// finding the key ID and ARN, see Finding the Key ID and ARN (https://docs.aws.amazon.com/kms/latest/developerguide/viewing-keys.html#find-cmk-id-arn)
	// in the AWS Key Management Service Developer Guide.
	//
	// TargetKeyId is a required field
	TargetKeyId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateAliasInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAliasInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateAliasInput"}

	if s.AliasName == nil {
		invalidParams.Add(aws.NewErrParamRequired("AliasName"))
	}
	if s.AliasName != nil && len(*s.AliasName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AliasName", 1))
	}

	if s.TargetKeyId == nil {
		invalidParams.Add(aws.NewErrParamRequired("TargetKeyId"))
	}
	if s.TargetKeyId != nil && len(*s.TargetKeyId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TargetKeyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/CreateAliasOutput
type CreateAliasOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateAliasOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateAlias = "CreateAlias"

// CreateAliasRequest returns a request value for making API operation for
// AWS Key Management Service.
//
// Creates a display name for a customer managed customer master key (CMK).
// You can use an alias to identify a CMK in selected operations, such as Encrypt
// and GenerateDataKey.
//
// Each CMK can have multiple aliases, but each alias points to only one CMK.
// The alias name must be unique in the AWS account and region. To simplify
// code that runs in multiple regions, use the same alias name, but point it
// to a different CMK in each region.
//
// Because an alias is not a property of a CMK, you can delete and change the
// aliases of a CMK without affecting the CMK. Also, aliases do not appear in
// the response from the DescribeKey operation. To get the aliases of all CMKs,
// use the ListAliases operation.
//
// The alias name must begin with alias/ followed by a name, such as alias/ExampleAlias.
// It can contain only alphanumeric characters, forward slashes (/), underscores
// (_), and dashes (-). The alias name cannot begin with alias/aws/. The alias/aws/
// prefix is reserved for AWS managed CMKs (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk).
//
// The alias and the CMK it is mapped to must be in the same AWS account and
// the same region. You cannot perform this operation on an alias in a different
// AWS account.
//
// To map an existing alias to a different CMK, call UpdateAlias.
//
// The result of this operation varies with the key state of the CMK. For details,
// see How Key State Affects Use of a Customer Master Key (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
// in the AWS Key Management Service Developer Guide.
//
//    // Example sending a request using CreateAliasRequest.
//    req := client.CreateAliasRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/CreateAlias
func (c *Client) CreateAliasRequest(input *CreateAliasInput) CreateAliasRequest {
	op := &aws.Operation{
		Name:       opCreateAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAliasInput{}
	}

	req := c.newRequest(op, input, &CreateAliasOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return CreateAliasRequest{Request: req, Input: input, Copy: c.CreateAliasRequest}
}

// CreateAliasRequest is the request type for the
// CreateAlias API operation.
type CreateAliasRequest struct {
	*aws.Request
	Input *CreateAliasInput
	Copy  func(*CreateAliasInput) CreateAliasRequest
}

// Send marshals and sends the CreateAlias API request.
func (r CreateAliasRequest) Send(ctx context.Context) (*CreateAliasResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateAliasResponse{
		CreateAliasOutput: r.Request.Data.(*CreateAliasOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateAliasResponse is the response type for the
// CreateAlias API operation.
type CreateAliasResponse struct {
	*CreateAliasOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateAlias request.
func (r *CreateAliasResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
