// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package migrationhub

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/DeleteProgressUpdateStreamRequest
type DeleteProgressUpdateStreamInput struct {
	_ struct{} `type:"structure"`

	// Optional boolean flag to indicate whether any effect should take place. Used
	// to test if the caller has permission to make the call.
	DryRun *bool `type:"boolean"`

	// The name of the ProgressUpdateStream.
	//
	// ProgressUpdateStreamName is a required field
	ProgressUpdateStreamName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteProgressUpdateStreamInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteProgressUpdateStreamInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteProgressUpdateStreamInput"}

	if s.ProgressUpdateStreamName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProgressUpdateStreamName"))
	}
	if s.ProgressUpdateStreamName != nil && len(*s.ProgressUpdateStreamName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ProgressUpdateStreamName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/DeleteProgressUpdateStreamResult
type DeleteProgressUpdateStreamOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteProgressUpdateStreamOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteProgressUpdateStream = "DeleteProgressUpdateStream"

// DeleteProgressUpdateStreamRequest returns a request value for making API operation for
// AWS Migration Hub.
//
// Deletes a progress update stream, including all of its tasks, which was previously
// created as an AWS resource used for access control. This API has the following
// traits:
//
//    * The only parameter needed for DeleteProgressUpdateStream is the stream
//    name (same as a CreateProgressUpdateStream call).
//
//    * The call will return, and a background process will asynchronously delete
//    the stream and all of its resources (tasks, associated resources, resource
//    attributes, created artifacts).
//
//    * If the stream takes time to be deleted, it might still show up on a
//    ListProgressUpdateStreams call.
//
//    * CreateProgressUpdateStream, ImportMigrationTask, NotifyMigrationTaskState,
//    and all Associate[*] APIs realted to the tasks belonging to the stream
//    will throw "InvalidInputException" if the stream of the same name is in
//    the process of being deleted.
//
//    * Once the stream and all of its resources are deleted, CreateProgressUpdateStream
//    for a stream of the same name will succeed, and that stream will be an
//    entirely new logical resource (without any resources associated with the
//    old stream).
//
//    // Example sending a request using DeleteProgressUpdateStreamRequest.
//    req := client.DeleteProgressUpdateStreamRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/AWSMigrationHub-2017-05-31/DeleteProgressUpdateStream
func (c *Client) DeleteProgressUpdateStreamRequest(input *DeleteProgressUpdateStreamInput) DeleteProgressUpdateStreamRequest {
	op := &aws.Operation{
		Name:       opDeleteProgressUpdateStream,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteProgressUpdateStreamInput{}
	}

	req := c.newRequest(op, input, &DeleteProgressUpdateStreamOutput{})
	return DeleteProgressUpdateStreamRequest{Request: req, Input: input, Copy: c.DeleteProgressUpdateStreamRequest}
}

// DeleteProgressUpdateStreamRequest is the request type for the
// DeleteProgressUpdateStream API operation.
type DeleteProgressUpdateStreamRequest struct {
	*aws.Request
	Input *DeleteProgressUpdateStreamInput
	Copy  func(*DeleteProgressUpdateStreamInput) DeleteProgressUpdateStreamRequest
}

// Send marshals and sends the DeleteProgressUpdateStream API request.
func (r DeleteProgressUpdateStreamRequest) Send(ctx context.Context) (*DeleteProgressUpdateStreamResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteProgressUpdateStreamResponse{
		DeleteProgressUpdateStreamOutput: r.Request.Data.(*DeleteProgressUpdateStreamOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteProgressUpdateStreamResponse is the response type for the
// DeleteProgressUpdateStream API operation.
type DeleteProgressUpdateStreamResponse struct {
	*DeleteProgressUpdateStreamOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteProgressUpdateStream request.
func (r *DeleteProgressUpdateStreamResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
