// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package opsworks

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/StartInstanceRequest
type StartInstanceInput struct {
	_ struct{} `type:"structure"`

	// The instance ID.
	//
	// InstanceId is a required field
	InstanceId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s StartInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartInstanceInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StartInstanceInput"}

	if s.InstanceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/StartInstanceOutput
type StartInstanceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StartInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

const opStartInstance = "StartInstance"

// StartInstanceRequest returns a request value for making API operation for
// AWS OpsWorks.
//
// Starts a specified instance. For more information, see Starting, Stopping,
// and Rebooting Instances (http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-starting.html).
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
//    // Example sending a request using StartInstanceRequest.
//    req := client.StartInstanceRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/StartInstance
func (c *Client) StartInstanceRequest(input *StartInstanceInput) StartInstanceRequest {
	op := &aws.Operation{
		Name:       opStartInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartInstanceInput{}
	}

	req := c.newRequest(op, input, &StartInstanceOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return StartInstanceRequest{Request: req, Input: input, Copy: c.StartInstanceRequest}
}

// StartInstanceRequest is the request type for the
// StartInstance API operation.
type StartInstanceRequest struct {
	*aws.Request
	Input *StartInstanceInput
	Copy  func(*StartInstanceInput) StartInstanceRequest
}

// Send marshals and sends the StartInstance API request.
func (r StartInstanceRequest) Send(ctx context.Context) (*StartInstanceResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StartInstanceResponse{
		StartInstanceOutput: r.Request.Data.(*StartInstanceOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StartInstanceResponse is the response type for the
// StartInstance API operation.
type StartInstanceResponse struct {
	*StartInstanceOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StartInstance request.
func (r *StartInstanceResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
