// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package pinpointemail

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// A request to add a custom domain for tracking open and click events to a
// configuration set.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/PutConfigurationSetTrackingOptionsRequest
type PutConfigurationSetTrackingOptionsInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration set that you want to add a custom tracking
	// domain to.
	//
	// ConfigurationSetName is a required field
	ConfigurationSetName *string `location:"uri" locationName:"ConfigurationSetName" type:"string" required:"true"`

	// The domain that you want to use to track open and click events.
	CustomRedirectDomain *string `type:"string"`
}

// String returns the string representation
func (s PutConfigurationSetTrackingOptionsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutConfigurationSetTrackingOptionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutConfigurationSetTrackingOptionsInput"}

	if s.ConfigurationSetName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ConfigurationSetName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutConfigurationSetTrackingOptionsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	if s.CustomRedirectDomain != nil {
		v := *s.CustomRedirectDomain

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CustomRedirectDomain", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ConfigurationSetName != nil {
		v := *s.ConfigurationSetName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "ConfigurationSetName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An HTTP 200 response if the request succeeds, or an error message if the
// request fails.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/PutConfigurationSetTrackingOptionsResponse
type PutConfigurationSetTrackingOptionsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutConfigurationSetTrackingOptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutConfigurationSetTrackingOptionsOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opPutConfigurationSetTrackingOptions = "PutConfigurationSetTrackingOptions"

// PutConfigurationSetTrackingOptionsRequest returns a request value for making API operation for
// Amazon Pinpoint Email Service.
//
// Specify a custom domain to use for open and click tracking elements in email
// that you send using Amazon Pinpoint.
//
//    // Example sending a request using PutConfigurationSetTrackingOptionsRequest.
//    req := client.PutConfigurationSetTrackingOptionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/PutConfigurationSetTrackingOptions
func (c *Client) PutConfigurationSetTrackingOptionsRequest(input *PutConfigurationSetTrackingOptionsInput) PutConfigurationSetTrackingOptionsRequest {
	op := &aws.Operation{
		Name:       opPutConfigurationSetTrackingOptions,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/email/configuration-sets/{ConfigurationSetName}/tracking-options",
	}

	if input == nil {
		input = &PutConfigurationSetTrackingOptionsInput{}
	}

	req := c.newRequest(op, input, &PutConfigurationSetTrackingOptionsOutput{})
	return PutConfigurationSetTrackingOptionsRequest{Request: req, Input: input, Copy: c.PutConfigurationSetTrackingOptionsRequest}
}

// PutConfigurationSetTrackingOptionsRequest is the request type for the
// PutConfigurationSetTrackingOptions API operation.
type PutConfigurationSetTrackingOptionsRequest struct {
	*aws.Request
	Input *PutConfigurationSetTrackingOptionsInput
	Copy  func(*PutConfigurationSetTrackingOptionsInput) PutConfigurationSetTrackingOptionsRequest
}

// Send marshals and sends the PutConfigurationSetTrackingOptions API request.
func (r PutConfigurationSetTrackingOptionsRequest) Send(ctx context.Context) (*PutConfigurationSetTrackingOptionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutConfigurationSetTrackingOptionsResponse{
		PutConfigurationSetTrackingOptionsOutput: r.Request.Data.(*PutConfigurationSetTrackingOptionsOutput),
		response:                                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutConfigurationSetTrackingOptionsResponse is the response type for the
// PutConfigurationSetTrackingOptions API operation.
type PutConfigurationSetTrackingOptionsResponse struct {
	*PutConfigurationSetTrackingOptionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutConfigurationSetTrackingOptions request.
func (r *PutConfigurationSetTrackingOptionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
