// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package route53

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// A complex type that contains information about the traffic policy that you
// want to create.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/CreateTrafficPolicyRequest
type CreateTrafficPolicyInput struct {
	_ struct{} `locationName:"CreateTrafficPolicyRequest" type:"structure" xmlURI:"https://route53.amazonaws.com/doc/2013-04-01/"`

	// (Optional) Any comments that you want to include about the traffic policy.
	Comment *string `type:"string"`

	// The definition of this traffic policy in JSON format. For more information,
	// see Traffic Policy Document Format (https://docs.aws.amazon.com/Route53/latest/APIReference/api-policies-traffic-policy-document-format.html).
	//
	// Document is a required field
	Document *string `type:"string" required:"true"`

	// The name of the traffic policy.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateTrafficPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTrafficPolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateTrafficPolicyInput"}

	if s.Document == nil {
		invalidParams.Add(aws.NewErrParamRequired("Document"))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateTrafficPolicyInput) MarshalFields(e protocol.FieldEncoder) error {

	e.SetFields(protocol.BodyTarget, "CreateTrafficPolicyRequest", protocol.FieldMarshalerFunc(func(e protocol.FieldEncoder) error {
		if s.Comment != nil {
			v := *s.Comment

			metadata := protocol.Metadata{}
			e.SetValue(protocol.BodyTarget, "Comment", protocol.StringValue(v), metadata)
		}
		if s.Document != nil {
			v := *s.Document

			metadata := protocol.Metadata{}
			e.SetValue(protocol.BodyTarget, "Document", protocol.StringValue(v), metadata)
		}
		if s.Name != nil {
			v := *s.Name

			metadata := protocol.Metadata{}
			e.SetValue(protocol.BodyTarget, "Name", protocol.StringValue(v), metadata)
		}
		return nil
	}), protocol.Metadata{XMLNamespaceURI: "https://route53.amazonaws.com/doc/2013-04-01/"})
	return nil
}

// A complex type that contains the response information for the CreateTrafficPolicy
// request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/CreateTrafficPolicyResponse
type CreateTrafficPolicyOutput struct {
	_ struct{} `type:"structure"`

	// A unique URL that represents a new traffic policy.
	//
	// Location is a required field
	Location *string `location:"header" locationName:"Location" type:"string" required:"true"`

	// A complex type that contains settings for the new traffic policy.
	//
	// TrafficPolicy is a required field
	TrafficPolicy *TrafficPolicy `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateTrafficPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateTrafficPolicyOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.TrafficPolicy != nil {
		v := s.TrafficPolicy

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "TrafficPolicy", v, metadata)
	}
	if s.Location != nil {
		v := *s.Location

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "Location", protocol.StringValue(v), metadata)
	}
	return nil
}

const opCreateTrafficPolicy = "CreateTrafficPolicy"

// CreateTrafficPolicyRequest returns a request value for making API operation for
// Amazon Route 53.
//
// Creates a traffic policy, which you use to create multiple DNS resource record
// sets for one domain name (such as example.com) or one subdomain name (such
// as www.example.com).
//
//    // Example sending a request using CreateTrafficPolicyRequest.
//    req := client.CreateTrafficPolicyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/CreateTrafficPolicy
func (c *Client) CreateTrafficPolicyRequest(input *CreateTrafficPolicyInput) CreateTrafficPolicyRequest {
	op := &aws.Operation{
		Name:       opCreateTrafficPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/2013-04-01/trafficpolicy",
	}

	if input == nil {
		input = &CreateTrafficPolicyInput{}
	}

	req := c.newRequest(op, input, &CreateTrafficPolicyOutput{})
	return CreateTrafficPolicyRequest{Request: req, Input: input, Copy: c.CreateTrafficPolicyRequest}
}

// CreateTrafficPolicyRequest is the request type for the
// CreateTrafficPolicy API operation.
type CreateTrafficPolicyRequest struct {
	*aws.Request
	Input *CreateTrafficPolicyInput
	Copy  func(*CreateTrafficPolicyInput) CreateTrafficPolicyRequest
}

// Send marshals and sends the CreateTrafficPolicy API request.
func (r CreateTrafficPolicyRequest) Send(ctx context.Context) (*CreateTrafficPolicyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateTrafficPolicyResponse{
		CreateTrafficPolicyOutput: r.Request.Data.(*CreateTrafficPolicyOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateTrafficPolicyResponse is the response type for the
// CreateTrafficPolicy API operation.
type CreateTrafficPolicyResponse struct {
	*CreateTrafficPolicyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateTrafficPolicy request.
func (r *CreateTrafficPolicyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
