// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sagemaker

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateTransformJobRequest
type CreateTransformJobInput struct {
	_ struct{} `type:"structure"`

	// Specifies the number of records to include in a mini-batch for an HTTP inference
	// request. A record is a single unit of input data that inference can be made
	// on. For example, a single line in a CSV file is a record.
	//
	// To enable the batch strategy, you must set SplitType to Line, RecordIO, or
	// TFRecord.
	//
	// To use only one record when making an HTTP invocation request to a container,
	// set BatchStrategy to SingleRecord and SplitType to Line.
	//
	// To fit as many records in a mini-batch as can fit within the MaxPayloadInMB
	// limit, set BatchStrategy to MultiRecord and SplitType to Line.
	BatchStrategy BatchStrategy `type:"string" enum:"true"`

	// The environment variables to set in the Docker container. We support up to
	// 16 key and values entries in the map.
	Environment map[string]string `type:"map"`

	// The maximum number of parallel requests that can be sent to each instance
	// in a transform job. If MaxConcurrentTransforms is set to 0 or left unset,
	// Amazon SageMaker checks the optional execution-parameters to determine the
	// optimal settings for your chosen algorithm. If the execution-parameters endpoint
	// is not enabled, the default value is 1. For more information on execution-parameters,
	// see How Containers Serve Requests (http://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-batch-code.html#your-algorithms-batch-code-how-containe-serves-requests).
	// For built-in algorithms, you don't need to set a value for MaxConcurrentTransforms.
	MaxConcurrentTransforms *int64 `type:"integer"`

	// The maximum allowed size of the payload, in MB. A payload is the data portion
	// of a record (without metadata). The value in MaxPayloadInMB must be greater
	// than, or equal to, the size of a single record. To estimate the size of a
	// record in MB, divide the size of your dataset by the number of records. To
	// ensure that the records fit within the maximum payload size, we recommend
	// using a slightly larger value. The default value is 6 MB.
	//
	// For cases where the payload might be arbitrarily large and is transmitted
	// using HTTP chunked encoding, set the value to 0. This feature works only
	// in supported algorithms. Currently, Amazon SageMaker built-in algorithms
	// do not support HTTP chunked encoding.
	MaxPayloadInMB *int64 `type:"integer"`

	// The name of the model that you want to use for the transform job. ModelName
	// must be the name of an existing Amazon SageMaker model within an AWS Region
	// in an AWS account.
	//
	// ModelName is a required field
	ModelName *string `type:"string" required:"true"`

	// (Optional) An array of key-value pairs. For more information, see Using Cost
	// Allocation Tags (https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what)
	// in the AWS Billing and Cost Management User Guide.
	Tags []Tag `type:"list"`

	// Describes the input source and the way the transform job consumes it.
	//
	// TransformInput is a required field
	TransformInput *TransformInput `type:"structure" required:"true"`

	// The name of the transform job. The name must be unique within an AWS Region
	// in an AWS account.
	//
	// TransformJobName is a required field
	TransformJobName *string `min:"1" type:"string" required:"true"`

	// Describes the results of the transform job.
	//
	// TransformOutput is a required field
	TransformOutput *TransformOutput `type:"structure" required:"true"`

	// Describes the resources, including ML instance types and ML instance count,
	// to use for the transform job.
	//
	// TransformResources is a required field
	TransformResources *TransformResources `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateTransformJobInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTransformJobInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateTransformJobInput"}

	if s.ModelName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ModelName"))
	}

	if s.TransformInput == nil {
		invalidParams.Add(aws.NewErrParamRequired("TransformInput"))
	}

	if s.TransformJobName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TransformJobName"))
	}
	if s.TransformJobName != nil && len(*s.TransformJobName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TransformJobName", 1))
	}

	if s.TransformOutput == nil {
		invalidParams.Add(aws.NewErrParamRequired("TransformOutput"))
	}

	if s.TransformResources == nil {
		invalidParams.Add(aws.NewErrParamRequired("TransformResources"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.TransformInput != nil {
		if err := s.TransformInput.Validate(); err != nil {
			invalidParams.AddNested("TransformInput", err.(aws.ErrInvalidParams))
		}
	}
	if s.TransformOutput != nil {
		if err := s.TransformOutput.Validate(); err != nil {
			invalidParams.AddNested("TransformOutput", err.(aws.ErrInvalidParams))
		}
	}
	if s.TransformResources != nil {
		if err := s.TransformResources.Validate(); err != nil {
			invalidParams.AddNested("TransformResources", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateTransformJobResponse
type CreateTransformJobOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the transform job.
	//
	// TransformJobArn is a required field
	TransformJobArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateTransformJobOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateTransformJob = "CreateTransformJob"

// CreateTransformJobRequest returns a request value for making API operation for
// Amazon SageMaker Service.
//
// Starts a transform job. A transform job uses a trained model to get inferences
// on a dataset and saves these results to an Amazon S3 location that you specify.
//
// To perform batch transformations, you create a transform job and use the
// data that you have readily available.
//
// In the request body, you provide the following:
//
//    * TransformJobName - Identifies the transform job. The name must be unique
//    within an AWS Region in an AWS account.
//
//    * ModelName - Identifies the model to use. ModelName must be the name
//    of an existing Amazon SageMaker model in the same AWS Region and AWS account.
//    For information on creating a model, see CreateModel.
//
//    * TransformInput - Describes the dataset to be transformed and the Amazon
//    S3 location where it is stored.
//
//    * TransformOutput - Identifies the Amazon S3 location where you want Amazon
//    SageMaker to save the results from the transform job.
//
//    * TransformResources - Identifies the ML compute instances for the transform
//    job.
//
// For more information about how batch transformation works Amazon SageMaker,
// see How It Works (https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform.html).
//
//    // Example sending a request using CreateTransformJobRequest.
//    req := client.CreateTransformJobRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateTransformJob
func (c *Client) CreateTransformJobRequest(input *CreateTransformJobInput) CreateTransformJobRequest {
	op := &aws.Operation{
		Name:       opCreateTransformJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTransformJobInput{}
	}

	req := c.newRequest(op, input, &CreateTransformJobOutput{})
	return CreateTransformJobRequest{Request: req, Input: input, Copy: c.CreateTransformJobRequest}
}

// CreateTransformJobRequest is the request type for the
// CreateTransformJob API operation.
type CreateTransformJobRequest struct {
	*aws.Request
	Input *CreateTransformJobInput
	Copy  func(*CreateTransformJobInput) CreateTransformJobRequest
}

// Send marshals and sends the CreateTransformJob API request.
func (r CreateTransformJobRequest) Send(ctx context.Context) (*CreateTransformJobResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateTransformJobResponse{
		CreateTransformJobOutput: r.Request.Data.(*CreateTransformJobOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateTransformJobResponse is the response type for the
// CreateTransformJob API operation.
type CreateTransformJobResponse struct {
	*CreateTransformJobOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateTransformJob request.
func (r *CreateTransformJobResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
