// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sagemaker

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/GetSearchSuggestionsRequest
type GetSearchSuggestionsInput struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon SageMaker resource to Search for. The only valid Resource
	// value is TrainingJob.
	//
	// Resource is a required field
	Resource ResourceType `type:"string" required:"true" enum:"true"`

	// Limits the property names that are included in the response.
	SuggestionQuery *SuggestionQuery `type:"structure"`
}

// String returns the string representation
func (s GetSearchSuggestionsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSearchSuggestionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetSearchSuggestionsInput"}
	if len(s.Resource) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Resource"))
	}
	if s.SuggestionQuery != nil {
		if err := s.SuggestionQuery.Validate(); err != nil {
			invalidParams.AddNested("SuggestionQuery", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/GetSearchSuggestionsResponse
type GetSearchSuggestionsOutput struct {
	_ struct{} `type:"structure"`

	// A list of property names for a Resource that match a SuggestionQuery.
	PropertyNameSuggestions []PropertyNameSuggestion `type:"list"`
}

// String returns the string representation
func (s GetSearchSuggestionsOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetSearchSuggestions = "GetSearchSuggestions"

// GetSearchSuggestionsRequest returns a request value for making API operation for
// Amazon SageMaker Service.
//
// An auto-complete API for the search functionality in the Amazon SageMaker
// console. It returns suggestions of possible matches for the property name
// to use in Search queries. Provides suggestions for HyperParameters, Tags,
// and Metrics.
//
//    // Example sending a request using GetSearchSuggestionsRequest.
//    req := client.GetSearchSuggestionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/GetSearchSuggestions
func (c *Client) GetSearchSuggestionsRequest(input *GetSearchSuggestionsInput) GetSearchSuggestionsRequest {
	op := &aws.Operation{
		Name:       opGetSearchSuggestions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetSearchSuggestionsInput{}
	}

	req := c.newRequest(op, input, &GetSearchSuggestionsOutput{})
	return GetSearchSuggestionsRequest{Request: req, Input: input, Copy: c.GetSearchSuggestionsRequest}
}

// GetSearchSuggestionsRequest is the request type for the
// GetSearchSuggestions API operation.
type GetSearchSuggestionsRequest struct {
	*aws.Request
	Input *GetSearchSuggestionsInput
	Copy  func(*GetSearchSuggestionsInput) GetSearchSuggestionsRequest
}

// Send marshals and sends the GetSearchSuggestions API request.
func (r GetSearchSuggestionsRequest) Send(ctx context.Context) (*GetSearchSuggestionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetSearchSuggestionsResponse{
		GetSearchSuggestionsOutput: r.Request.Data.(*GetSearchSuggestionsOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetSearchSuggestionsResponse is the response type for the
// GetSearchSuggestions API operation.
type GetSearchSuggestionsResponse struct {
	*GetSearchSuggestionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetSearchSuggestions request.
func (r *GetSearchSuggestionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
