// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package securityhub

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetInsightResultsRequest
type GetInsightResultsInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the insight whose results you want to see.
	//
	// InsightArn is a required field
	InsightArn *string `location:"uri" locationName:"InsightArn" type:"string" required:"true"`
}

// String returns the string representation
func (s GetInsightResultsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetInsightResultsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetInsightResultsInput"}

	if s.InsightArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("InsightArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetInsightResultsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	if s.InsightArn != nil {
		v := *s.InsightArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "InsightArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetInsightResultsResponse
type GetInsightResultsOutput struct {
	_ struct{} `type:"structure"`

	// The insight results returned by the operation.
	//
	// InsightResults is a required field
	InsightResults *InsightResults `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetInsightResultsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetInsightResultsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.InsightResults != nil {
		v := s.InsightResults

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "InsightResults", v, metadata)
	}
	return nil
}

const opGetInsightResults = "GetInsightResults"

// GetInsightResultsRequest returns a request value for making API operation for
// AWS SecurityHub.
//
// Lists the results of the Security Hub insight specified by the insight ARN.
//
//    // Example sending a request using GetInsightResultsRequest.
//    req := client.GetInsightResultsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetInsightResults
func (c *Client) GetInsightResultsRequest(input *GetInsightResultsInput) GetInsightResultsRequest {
	op := &aws.Operation{
		Name:       opGetInsightResults,
		HTTPMethod: "GET",
		HTTPPath:   "/insights/results/{InsightArn+}",
	}

	if input == nil {
		input = &GetInsightResultsInput{}
	}

	req := c.newRequest(op, input, &GetInsightResultsOutput{})
	return GetInsightResultsRequest{Request: req, Input: input, Copy: c.GetInsightResultsRequest}
}

// GetInsightResultsRequest is the request type for the
// GetInsightResults API operation.
type GetInsightResultsRequest struct {
	*aws.Request
	Input *GetInsightResultsInput
	Copy  func(*GetInsightResultsInput) GetInsightResultsRequest
}

// Send marshals and sends the GetInsightResults API request.
func (r GetInsightResultsRequest) Send(ctx context.Context) (*GetInsightResultsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetInsightResultsResponse{
		GetInsightResultsOutput: r.Request.Data.(*GetInsightResultsOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetInsightResultsResponse is the response type for the
// GetInsightResults API operation.
type GetInsightResultsResponse struct {
	*GetInsightResultsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetInsightResults request.
func (r *GetInsightResultsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
