// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package support

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/DescribeSeverityLevelsRequest
type DescribeSeverityLevelsInput struct {
	_ struct{} `type:"structure"`

	// The ISO 639-1 code for the language in which AWS provides support. AWS Support
	// currently supports English ("en") and Japanese ("ja"). Language parameters
	// must be passed explicitly for operations that take them.
	Language *string `locationName:"language" type:"string"`
}

// String returns the string representation
func (s DescribeSeverityLevelsInput) String() string {
	return awsutil.Prettify(s)
}

// The list of severity levels returned by the DescribeSeverityLevels operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/DescribeSeverityLevelsResponse
type DescribeSeverityLevelsOutput struct {
	_ struct{} `type:"structure"`

	// The available severity levels for the support case. Available severity levels
	// are defined by your service level agreement with AWS.
	SeverityLevels []SeverityLevel `locationName:"severityLevels" type:"list"`
}

// String returns the string representation
func (s DescribeSeverityLevelsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeSeverityLevels = "DescribeSeverityLevels"

// DescribeSeverityLevelsRequest returns a request value for making API operation for
// AWS Support.
//
// Returns the list of severity levels that you can assign to an AWS Support
// case. The severity level for a case is also a field in the CaseDetails data
// type included in any CreateCase request.
//
//    // Example sending a request using DescribeSeverityLevelsRequest.
//    req := client.DescribeSeverityLevelsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/DescribeSeverityLevels
func (c *Client) DescribeSeverityLevelsRequest(input *DescribeSeverityLevelsInput) DescribeSeverityLevelsRequest {
	op := &aws.Operation{
		Name:       opDescribeSeverityLevels,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSeverityLevelsInput{}
	}

	req := c.newRequest(op, input, &DescribeSeverityLevelsOutput{})
	return DescribeSeverityLevelsRequest{Request: req, Input: input, Copy: c.DescribeSeverityLevelsRequest}
}

// DescribeSeverityLevelsRequest is the request type for the
// DescribeSeverityLevels API operation.
type DescribeSeverityLevelsRequest struct {
	*aws.Request
	Input *DescribeSeverityLevelsInput
	Copy  func(*DescribeSeverityLevelsInput) DescribeSeverityLevelsRequest
}

// Send marshals and sends the DescribeSeverityLevels API request.
func (r DescribeSeverityLevelsRequest) Send(ctx context.Context) (*DescribeSeverityLevelsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeSeverityLevelsResponse{
		DescribeSeverityLevelsOutput: r.Request.Data.(*DescribeSeverityLevelsOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeSeverityLevelsResponse is the response type for the
// DescribeSeverityLevels API operation.
type DescribeSeverityLevelsResponse struct {
	*DescribeSeverityLevelsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeSeverityLevels request.
func (r *DescribeSeverityLevelsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
