// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package transcribe

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/StartTranscriptionJobRequest
type StartTranscriptionJobInput struct {
	_ struct{} `type:"structure"`

	// The language code for the language used in the input media file.
	//
	// LanguageCode is a required field
	LanguageCode LanguageCode `type:"string" required:"true" enum:"true"`

	// An object that describes the input media for a transcription job.
	//
	// Media is a required field
	Media *Media `type:"structure" required:"true"`

	// The format of the input media file.
	//
	// MediaFormat is a required field
	MediaFormat MediaFormat `type:"string" required:"true" enum:"true"`

	// The sample rate, in Hertz, of the audio track in the input media file.
	MediaSampleRateHertz *int64 `min:"8000" type:"integer"`

	// The location where the transcription is stored.
	//
	// If you set the OutputBucketName, Amazon Transcribe puts the transcription
	// in the specified S3 bucket. When you call the GetTranscriptionJob operation,
	// the operation returns this location in the TranscriptFileUri field. The S3
	// bucket must have permissions that allow Amazon Transcribe to put files in
	// the bucket. For more information, see Permissions Required for IAM User Roles
	// (https://docs.aws.amazon.com/transcribe/latest/dg/access-control-managing-permissions.html#auth-role-iam-user).
	//
	// Amazon Transcribe uses the default Amazon S3 key for server-side encryption
	// of transcripts that are placed in your S3 bucket. You can't specify your
	// own encryption key.
	//
	// If you don't set the OutputBucketName, Amazon Transcribe generates a pre-signed
	// URL, a shareable URL that provides secure access to your transcription, and
	// returns it in the TranscriptFileUri field. Use this URL to download the transcription.
	OutputBucketName *string `type:"string"`

	// A Settings object that provides optional settings for a transcription job.
	Settings *Settings `type:"structure"`

	// The name of the job. Note that you can't use the strings "." or ".." by themselves
	// as the job name. The name must also be unique within an AWS account.
	//
	// TranscriptionJobName is a required field
	TranscriptionJobName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StartTranscriptionJobInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartTranscriptionJobInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StartTranscriptionJobInput"}
	if len(s.LanguageCode) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("LanguageCode"))
	}

	if s.Media == nil {
		invalidParams.Add(aws.NewErrParamRequired("Media"))
	}
	if len(s.MediaFormat) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("MediaFormat"))
	}
	if s.MediaSampleRateHertz != nil && *s.MediaSampleRateHertz < 8000 {
		invalidParams.Add(aws.NewErrParamMinValue("MediaSampleRateHertz", 8000))
	}

	if s.TranscriptionJobName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TranscriptionJobName"))
	}
	if s.TranscriptionJobName != nil && len(*s.TranscriptionJobName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TranscriptionJobName", 1))
	}
	if s.Media != nil {
		if err := s.Media.Validate(); err != nil {
			invalidParams.AddNested("Media", err.(aws.ErrInvalidParams))
		}
	}
	if s.Settings != nil {
		if err := s.Settings.Validate(); err != nil {
			invalidParams.AddNested("Settings", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/StartTranscriptionJobResponse
type StartTranscriptionJobOutput struct {
	_ struct{} `type:"structure"`

	// An object containing details of the asynchronous transcription job.
	TranscriptionJob *TranscriptionJob `type:"structure"`
}

// String returns the string representation
func (s StartTranscriptionJobOutput) String() string {
	return awsutil.Prettify(s)
}

const opStartTranscriptionJob = "StartTranscriptionJob"

// StartTranscriptionJobRequest returns a request value for making API operation for
// Amazon Transcribe Service.
//
// Starts an asynchronous job to transcribe speech to text.
//
//    // Example sending a request using StartTranscriptionJobRequest.
//    req := client.StartTranscriptionJobRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/StartTranscriptionJob
func (c *Client) StartTranscriptionJobRequest(input *StartTranscriptionJobInput) StartTranscriptionJobRequest {
	op := &aws.Operation{
		Name:       opStartTranscriptionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartTranscriptionJobInput{}
	}

	req := c.newRequest(op, input, &StartTranscriptionJobOutput{})
	return StartTranscriptionJobRequest{Request: req, Input: input, Copy: c.StartTranscriptionJobRequest}
}

// StartTranscriptionJobRequest is the request type for the
// StartTranscriptionJob API operation.
type StartTranscriptionJobRequest struct {
	*aws.Request
	Input *StartTranscriptionJobInput
	Copy  func(*StartTranscriptionJobInput) StartTranscriptionJobRequest
}

// Send marshals and sends the StartTranscriptionJob API request.
func (r StartTranscriptionJobRequest) Send(ctx context.Context) (*StartTranscriptionJobResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StartTranscriptionJobResponse{
		StartTranscriptionJobOutput: r.Request.Data.(*StartTranscriptionJobOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StartTranscriptionJobResponse is the response type for the
// StartTranscriptionJob API operation.
type StartTranscriptionJobResponse struct {
	*StartTranscriptionJobOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StartTranscriptionJob request.
func (r *StartTranscriptionJobResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
