// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package workdocs

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/UpdateDocumentVersionRequest
type UpdateDocumentVersionInput struct {
	_ struct{} `type:"structure"`

	// Amazon WorkDocs authentication token. Do not set this field when using administrative
	// API actions, as in accessing the API using AWS credentials.
	AuthenticationToken *string `location:"header" locationName:"Authentication" min:"1" type:"string"`

	// The ID of the document.
	//
	// DocumentId is a required field
	DocumentId *string `location:"uri" locationName:"DocumentId" min:"1" type:"string" required:"true"`

	// The version ID of the document.
	//
	// VersionId is a required field
	VersionId *string `location:"uri" locationName:"VersionId" min:"1" type:"string" required:"true"`

	// The status of the version.
	VersionStatus DocumentVersionStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s UpdateDocumentVersionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDocumentVersionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateDocumentVersionInput"}
	if s.AuthenticationToken != nil && len(*s.AuthenticationToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AuthenticationToken", 1))
	}

	if s.DocumentId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DocumentId"))
	}
	if s.DocumentId != nil && len(*s.DocumentId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DocumentId", 1))
	}

	if s.VersionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("VersionId"))
	}
	if s.VersionId != nil && len(*s.VersionId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("VersionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateDocumentVersionInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	if len(s.VersionStatus) > 0 {
		v := s.VersionStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VersionStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.AuthenticationToken != nil {
		v := *s.AuthenticationToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "Authentication", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DocumentId != nil {
		v := *s.DocumentId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "DocumentId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VersionId != nil {
		v := *s.VersionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "VersionId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/UpdateDocumentVersionOutput
type UpdateDocumentVersionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateDocumentVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateDocumentVersionOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opUpdateDocumentVersion = "UpdateDocumentVersion"

// UpdateDocumentVersionRequest returns a request value for making API operation for
// Amazon WorkDocs.
//
// Changes the status of the document version to ACTIVE.
//
// Amazon WorkDocs also sets its document container to ACTIVE. This is the last
// step in a document upload, after the client uploads the document to an S3-presigned
// URL returned by InitiateDocumentVersionUpload.
//
//    // Example sending a request using UpdateDocumentVersionRequest.
//    req := client.UpdateDocumentVersionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/UpdateDocumentVersion
func (c *Client) UpdateDocumentVersionRequest(input *UpdateDocumentVersionInput) UpdateDocumentVersionRequest {
	op := &aws.Operation{
		Name:       opUpdateDocumentVersion,
		HTTPMethod: "PATCH",
		HTTPPath:   "/api/v1/documents/{DocumentId}/versions/{VersionId}",
	}

	if input == nil {
		input = &UpdateDocumentVersionInput{}
	}

	req := c.newRequest(op, input, &UpdateDocumentVersionOutput{})
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return UpdateDocumentVersionRequest{Request: req, Input: input, Copy: c.UpdateDocumentVersionRequest}
}

// UpdateDocumentVersionRequest is the request type for the
// UpdateDocumentVersion API operation.
type UpdateDocumentVersionRequest struct {
	*aws.Request
	Input *UpdateDocumentVersionInput
	Copy  func(*UpdateDocumentVersionInput) UpdateDocumentVersionRequest
}

// Send marshals and sends the UpdateDocumentVersion API request.
func (r UpdateDocumentVersionRequest) Send(ctx context.Context) (*UpdateDocumentVersionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateDocumentVersionResponse{
		UpdateDocumentVersionOutput: r.Request.Data.(*UpdateDocumentVersionOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateDocumentVersionResponse is the response type for the
// UpdateDocumentVersion API operation.
type UpdateDocumentVersionResponse struct {
	*UpdateDocumentVersionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateDocumentVersion request.
func (r *UpdateDocumentVersionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
