// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package workspaces

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateIpGroupRequest
type CreateIpGroupInput struct {
	_ struct{} `type:"structure"`

	// The description of the group.
	GroupDesc *string `type:"string"`

	// The name of the group.
	//
	// GroupName is a required field
	GroupName *string `type:"string" required:"true"`

	// The tags. Each WorkSpaces resource can have a maximum of 50 tags.
	Tags []Tag `type:"list"`

	// The rules to add to the group.
	UserRules []IpRuleItem `type:"list"`
}

// String returns the string representation
func (s CreateIpGroupInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateIpGroupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateIpGroupInput"}

	if s.GroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("GroupName"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateIpGroupResult
type CreateIpGroupOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the group.
	GroupId *string `type:"string"`
}

// String returns the string representation
func (s CreateIpGroupOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateIpGroup = "CreateIpGroup"

// CreateIpGroupRequest returns a request value for making API operation for
// Amazon WorkSpaces.
//
// Creates an IP access control group.
//
// An IP access control group provides you with the ability to control the IP
// addresses from which users are allowed to access their WorkSpaces. To specify
// the CIDR address ranges, add rules to your IP access control group and then
// associate the group with your directory. You can add rules when you create
// the group or at any time using AuthorizeIpRules.
//
// There is a default IP access control group associated with your directory.
// If you don't associate an IP access control group with your directory, the
// default group is used. The default group includes a default rule that allows
// users to access their WorkSpaces from anywhere. You cannot modify the default
// IP access control group for your directory.
//
//    // Example sending a request using CreateIpGroupRequest.
//    req := client.CreateIpGroupRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateIpGroup
func (c *Client) CreateIpGroupRequest(input *CreateIpGroupInput) CreateIpGroupRequest {
	op := &aws.Operation{
		Name:       opCreateIpGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateIpGroupInput{}
	}

	req := c.newRequest(op, input, &CreateIpGroupOutput{})
	return CreateIpGroupRequest{Request: req, Input: input, Copy: c.CreateIpGroupRequest}
}

// CreateIpGroupRequest is the request type for the
// CreateIpGroup API operation.
type CreateIpGroupRequest struct {
	*aws.Request
	Input *CreateIpGroupInput
	Copy  func(*CreateIpGroupInput) CreateIpGroupRequest
}

// Send marshals and sends the CreateIpGroup API request.
func (r CreateIpGroupRequest) Send(ctx context.Context) (*CreateIpGroupResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateIpGroupResponse{
		CreateIpGroupOutput: r.Request.Data.(*CreateIpGroupOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateIpGroupResponse is the response type for the
// CreateIpGroup API operation.
type CreateIpGroupResponse struct {
	*CreateIpGroupOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateIpGroup request.
func (r *CreateIpGroupResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
