// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package workspaces

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

var _ aws.Config
var _ = awsutil.Prettify

// Describes a modification to the configuration of bring your own license (BYOL)
// for the specified account.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/AccountModification
type AccountModification struct {
	_ struct{} `type:"structure"`

	// The IP address range, specified as an IPv4 CIDR block, for the management
	// network interface used for the account.
	DedicatedTenancyManagementCidrRange *string `type:"string"`

	// The status of BYOL (whether BYOL is being enabled or disabled).
	DedicatedTenancySupport DedicatedTenancySupportResultEnum `type:"string" enum:"true"`

	// The error code that is returned if the configuration of BYOL cannot be modified.
	ErrorCode *string `type:"string"`

	// The text of the error message that is returned if the configuration of BYOL
	// cannot be modified.
	ErrorMessage *string `type:"string"`

	// The state of the modification to the configuration of BYOL.
	ModificationState DedicatedTenancyModificationStateEnum `type:"string" enum:"true"`

	// The timestamp when the modification of the BYOL configuration was started.
	StartTime *time.Time `type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s AccountModification) String() string {
	return awsutil.Prettify(s)
}

// Describes the compute type.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ComputeType
type ComputeType struct {
	_ struct{} `type:"structure"`

	// The compute type.
	Name Compute `type:"string" enum:"true"`
}

// String returns the string representation
func (s ComputeType) String() string {
	return awsutil.Prettify(s)
}

// Describes the default values used to create a WorkSpace.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DefaultWorkspaceCreationProperties
type DefaultWorkspaceCreationProperties struct {
	_ struct{} `type:"structure"`

	// The identifier of any security groups to apply to WorkSpaces when they are
	// created.
	CustomSecurityGroupId *string `type:"string"`

	// The organizational unit (OU) in the directory for the WorkSpace machine accounts.
	DefaultOu *string `type:"string"`

	// The public IP address to attach to all WorkSpaces that are created or rebuilt.
	EnableInternetAccess *bool `type:"boolean"`

	// Specifies whether the directory is enabled for Amazon WorkDocs.
	EnableWorkDocs *bool `type:"boolean"`

	// Specifies whether the WorkSpace user is an administrator on the WorkSpace.
	UserEnabledAsLocalAdministrator *bool `type:"boolean"`
}

// String returns the string representation
func (s DefaultWorkspaceCreationProperties) String() string {
	return awsutil.Prettify(s)
}

// Describes a WorkSpace that cannot be created.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/FailedCreateWorkspaceRequest
type FailedCreateWorkspaceRequest struct {
	_ struct{} `type:"structure"`

	// The error code that is returned if the WorkSpace cannot be created.
	ErrorCode *string `type:"string"`

	// The text of the error message that is returned if the WorkSpace cannot be
	// created.
	ErrorMessage *string `type:"string"`

	// Information about the WorkSpace.
	WorkspaceRequest *WorkspaceRequest `type:"structure"`
}

// String returns the string representation
func (s FailedCreateWorkspaceRequest) String() string {
	return awsutil.Prettify(s)
}

// Describes a WorkSpace that could not be rebooted. (RebootWorkspaces), rebuilt
// (RebuildWorkspaces), terminated (TerminateWorkspaces), started (StartWorkspaces),
// or stopped (StopWorkspaces).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/FailedWorkspaceChangeRequest
type FailedWorkspaceChangeRequest struct {
	_ struct{} `type:"structure"`

	// The error code that is returned if the WorkSpace cannot be rebooted.
	ErrorCode *string `type:"string"`

	// The text of the error message that is returned if the WorkSpace cannot be
	// rebooted.
	ErrorMessage *string `type:"string"`

	// The identifier of the WorkSpace.
	WorkspaceId *string `type:"string"`
}

// String returns the string representation
func (s FailedWorkspaceChangeRequest) String() string {
	return awsutil.Prettify(s)
}

// Describes a rule for an IP access control group.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/IpRuleItem
type IpRuleItem struct {
	_ struct{} `type:"structure"`

	// The IP address range, in CIDR notation.
	IpRule *string `locationName:"ipRule" type:"string"`

	// The description.
	RuleDesc *string `locationName:"ruleDesc" type:"string"`
}

// String returns the string representation
func (s IpRuleItem) String() string {
	return awsutil.Prettify(s)
}

// Describes a WorkSpace modification.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModificationState
type ModificationState struct {
	_ struct{} `type:"structure"`

	// The resource.
	Resource ModificationResourceEnum `type:"string" enum:"true"`

	// The modification state.
	State ModificationStateEnum `type:"string" enum:"true"`
}

// String returns the string representation
func (s ModificationState) String() string {
	return awsutil.Prettify(s)
}

// The operating system that the image is running.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/OperatingSystem
type OperatingSystem struct {
	_ struct{} `type:"structure"`

	// The operating system.
	Type OperatingSystemType `type:"string" enum:"true"`
}

// String returns the string representation
func (s OperatingSystem) String() string {
	return awsutil.Prettify(s)
}

// Describes an Amazon WorkSpaces client.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ClientProperties
type Properties struct {
	_ struct{} `type:"structure"`

	// Specifies whether users can cache their credentials on the Amazon WorkSpaces
	// client. When enabled, users can choose to reconnect to their WorkSpaces without
	// re-entering their credentials.
	ReconnectEnabled ReconnectEnum `type:"string" enum:"true"`
}

// String returns the string representation
func (s Properties) String() string {
	return awsutil.Prettify(s)
}

// Information about the Amazon WorkSpaces client.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ClientPropertiesResult
type PropertiesResult struct {
	_ struct{} `type:"structure"`

	// Information about the Amazon WorkSpaces client.
	ClientProperties *Properties `type:"structure"`

	// The resource identifier, in the form of a directory ID.
	ResourceId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s PropertiesResult) String() string {
	return awsutil.Prettify(s)
}

// Describes the information used to reboot a WorkSpace.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RebootRequest
type RebootRequest struct {
	_ struct{} `type:"structure"`

	// The identifier of the WorkSpace.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RebootRequest) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RebootRequest) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RebootRequest"}

	if s.WorkspaceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("WorkspaceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes the information used to rebuild a WorkSpace.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RebuildRequest
type RebuildRequest struct {
	_ struct{} `type:"structure"`

	// The identifier of the WorkSpace.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RebuildRequest) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RebuildRequest) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RebuildRequest"}

	if s.WorkspaceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("WorkspaceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes the root volume for a WorkSpace bundle.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RootStorage
type RootStorage struct {
	_ struct{} `type:"structure"`

	// The size of the root volume.
	Capacity *string `min:"1" type:"string"`
}

// String returns the string representation
func (s RootStorage) String() string {
	return awsutil.Prettify(s)
}

// Information used to start a WorkSpace.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/StartRequest
type StartRequest struct {
	_ struct{} `type:"structure"`

	// The identifier of the WorkSpace.
	WorkspaceId *string `type:"string"`
}

// String returns the string representation
func (s StartRequest) String() string {
	return awsutil.Prettify(s)
}

// Describes the information used to stop a WorkSpace.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/StopRequest
type StopRequest struct {
	_ struct{} `type:"structure"`

	// The identifier of the WorkSpace.
	WorkspaceId *string `type:"string"`
}

// String returns the string representation
func (s StopRequest) String() string {
	return awsutil.Prettify(s)
}

// Describes a tag.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/Tag
type Tag struct {
	_ struct{} `type:"structure"`

	// The key of the tag.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The value of the tag.
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Tag"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes the information used to terminate a WorkSpace.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/TerminateRequest
type TerminateRequest struct {
	_ struct{} `type:"structure"`

	// The identifier of the WorkSpace.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s TerminateRequest) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TerminateRequest) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TerminateRequest"}

	if s.WorkspaceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("WorkspaceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes the user storage for a WorkSpace bundle.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/UserStorage
type UserStorage struct {
	_ struct{} `type:"structure"`

	// The size of the user storage.
	Capacity *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UserStorage) String() string {
	return awsutil.Prettify(s)
}

// Describes a WorkSpace.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/Workspace
type Workspace struct {
	_ struct{} `type:"structure"`

	// The identifier of the bundle used to create the WorkSpace.
	BundleId *string `type:"string"`

	// The name of the WorkSpace, as seen by the operating system.
	ComputerName *string `type:"string"`

	// The identifier of the AWS Directory Service directory for the WorkSpace.
	DirectoryId *string `type:"string"`

	// The error code that is returned if the WorkSpace cannot be created.
	ErrorCode *string `type:"string"`

	// The text of the error message that is returned if the WorkSpace cannot be
	// created.
	ErrorMessage *string `type:"string"`

	// The IP address of the WorkSpace.
	IpAddress *string `type:"string"`

	// The modification states of the WorkSpace.
	ModificationStates []ModificationState `type:"list"`

	// Indicates whether the data stored on the root volume is encrypted.
	RootVolumeEncryptionEnabled *bool `type:"boolean"`

	// The operational state of the WorkSpace.
	State WorkspaceState `type:"string" enum:"true"`

	// The identifier of the subnet for the WorkSpace.
	SubnetId *string `type:"string"`

	// The user for the WorkSpace.
	UserName *string `min:"1" type:"string"`

	// Indicates whether the data stored on the user volume is encrypted.
	UserVolumeEncryptionEnabled *bool `type:"boolean"`

	// The KMS key used to encrypt data stored on your WorkSpace.
	VolumeEncryptionKey *string `type:"string"`

	// The identifier of the WorkSpace.
	WorkspaceId *string `type:"string"`

	// The properties of the WorkSpace.
	WorkspaceProperties *WorkspaceProperties `type:"structure"`
}

// String returns the string representation
func (s Workspace) String() string {
	return awsutil.Prettify(s)
}

// Describes a WorkSpace bundle.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/WorkspaceBundle
type WorkspaceBundle struct {
	_ struct{} `type:"structure"`

	// The bundle identifier.
	BundleId *string `type:"string"`

	// The compute type. For more information, see Amazon WorkSpaces Bundles (http://aws.amazon.com/workspaces/details/#Amazon_WorkSpaces_Bundles).
	ComputeType *ComputeType `type:"structure"`

	// A description.
	Description *string `type:"string"`

	// The name of the bundle.
	Name *string `min:"1" type:"string"`

	// The owner of the bundle. This is the account identifier of the owner, or
	// AMAZON if the bundle is provided by AWS.
	Owner *string `type:"string"`

	// The size of the root volume.
	RootStorage *RootStorage `type:"structure"`

	// The size of the user storage.
	UserStorage *UserStorage `type:"structure"`
}

// String returns the string representation
func (s WorkspaceBundle) String() string {
	return awsutil.Prettify(s)
}

// Describes the connection status of a WorkSpace.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/WorkspaceConnectionStatus
type WorkspaceConnectionStatus struct {
	_ struct{} `type:"structure"`

	// The connection state of the WorkSpace. The connection state is unknown if
	// the WorkSpace is stopped.
	ConnectionState ConnectionState `type:"string" enum:"true"`

	// The timestamp of the connection status check.
	ConnectionStateCheckTimestamp *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The timestamp of the last known user connection.
	LastKnownUserConnectionTimestamp *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The identifier of the WorkSpace.
	WorkspaceId *string `type:"string"`
}

// String returns the string representation
func (s WorkspaceConnectionStatus) String() string {
	return awsutil.Prettify(s)
}

// Describes an AWS Directory Service directory that is used with Amazon WorkSpaces.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/WorkspaceDirectory
type WorkspaceDirectory struct {
	_ struct{} `type:"structure"`

	// The directory alias.
	Alias *string `type:"string"`

	// The user name for the service account.
	CustomerUserName *string `min:"1" type:"string"`

	// The directory identifier.
	DirectoryId *string `type:"string"`

	// The name of the directory.
	DirectoryName *string `type:"string"`

	// The directory type.
	DirectoryType WorkspaceDirectoryType `type:"string" enum:"true"`

	// The IP addresses of the DNS servers for the directory.
	DnsIpAddresses []string `type:"list"`

	// The identifier of the IAM role. This is the role that allows Amazon WorkSpaces
	// to make calls to other services, such as Amazon EC2, on your behalf.
	IamRoleId *string `type:"string"`

	// The identifiers of the IP access control groups associated with the directory.
	IpGroupIds []string `locationName:"ipGroupIds" type:"list"`

	// The registration code for the directory. This is the code that users enter
	// in their Amazon WorkSpaces client application to connect to the directory.
	RegistrationCode *string `min:"1" type:"string"`

	// The state of the directory's registration with Amazon WorkSpaces
	State WorkspaceDirectoryState `type:"string" enum:"true"`

	// The identifiers of the subnets used with the directory.
	SubnetIds []string `type:"list"`

	// The default creation properties for all WorkSpaces in the directory.
	WorkspaceCreationProperties *DefaultWorkspaceCreationProperties `type:"structure"`

	// The identifier of the security group that is assigned to new WorkSpaces.
	WorkspaceSecurityGroupId *string `type:"string"`
}

// String returns the string representation
func (s WorkspaceDirectory) String() string {
	return awsutil.Prettify(s)
}

// Describes a WorkSpace image.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/WorkspaceImage
type WorkspaceImage struct {
	_ struct{} `type:"structure"`

	// The description of the image.
	Description *string `min:"1" type:"string"`

	// The error code that is returned for the image.
	ErrorCode *string `type:"string"`

	// The text of the error message that is returned for the image.
	ErrorMessage *string `type:"string"`

	// The identifier of the image.
	ImageId *string `type:"string"`

	// The name of the image.
	Name *string `min:"1" type:"string"`

	// The operating system that the image is running.
	OperatingSystem *OperatingSystem `type:"structure"`

	// Specifies whether the image is running on dedicated hardware. When bring
	// your own license (BYOL) is enabled, this value is set to DEDICATED.
	RequiredTenancy WorkspaceImageRequiredTenancy `type:"string" enum:"true"`

	// The status of the image.
	State WorkspaceImageState `type:"string" enum:"true"`
}

// String returns the string representation
func (s WorkspaceImage) String() string {
	return awsutil.Prettify(s)
}

// Describes a WorkSpace.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/WorkspaceProperties
type WorkspaceProperties struct {
	_ struct{} `type:"structure"`

	// The compute type. For more information, see Amazon WorkSpaces Bundles (http://aws.amazon.com/workspaces/details/#Amazon_WorkSpaces_Bundles).
	ComputeTypeName Compute `type:"string" enum:"true"`

	// The size of the root volume.
	RootVolumeSizeGib *int64 `type:"integer"`

	// The running mode. For more information, see Manage the WorkSpace Running
	// Mode (https://docs.aws.amazon.com/workspaces/latest/adminguide/running-mode.html).
	RunningMode RunningMode `type:"string" enum:"true"`

	// The time after a user logs off when WorkSpaces are automatically stopped.
	// Configured in 60 minute intervals.
	RunningModeAutoStopTimeoutInMinutes *int64 `type:"integer"`

	// The size of the user storage.
	UserVolumeSizeGib *int64 `type:"integer"`
}

// String returns the string representation
func (s WorkspaceProperties) String() string {
	return awsutil.Prettify(s)
}

// Describes the information used to create a WorkSpace.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/WorkspaceRequest
type WorkspaceRequest struct {
	_ struct{} `type:"structure"`

	// The identifier of the bundle for the WorkSpace. You can use DescribeWorkspaceBundles
	// to list the available bundles.
	//
	// BundleId is a required field
	BundleId *string `type:"string" required:"true"`

	// The identifier of the AWS Directory Service directory for the WorkSpace.
	// You can use DescribeWorkspaceDirectories to list the available directories.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`

	// Indicates whether the data stored on the root volume is encrypted.
	RootVolumeEncryptionEnabled *bool `type:"boolean"`

	// The tags for the WorkSpace.
	Tags []Tag `type:"list"`

	// The username of the user for the WorkSpace. This username must exist in the
	// AWS Directory Service directory for the WorkSpace.
	//
	// UserName is a required field
	UserName *string `min:"1" type:"string" required:"true"`

	// Indicates whether the data stored on the user volume is encrypted.
	UserVolumeEncryptionEnabled *bool `type:"boolean"`

	// The KMS key used to encrypt data stored on your WorkSpace.
	VolumeEncryptionKey *string `type:"string"`

	// The WorkSpace properties.
	WorkspaceProperties *WorkspaceProperties `type:"structure"`
}

// String returns the string representation
func (s WorkspaceRequest) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WorkspaceRequest) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "WorkspaceRequest"}

	if s.BundleId == nil {
		invalidParams.Add(aws.NewErrParamRequired("BundleId"))
	}

	if s.DirectoryId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DirectoryId"))
	}

	if s.UserName == nil {
		invalidParams.Add(aws.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("UserName", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes an IP access control group.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/WorkspacesIpGroup
type WorkspacesIpGroup struct {
	_ struct{} `type:"structure"`

	// The description of the group.
	GroupDesc *string `locationName:"groupDesc" type:"string"`

	// The identifier of the group.
	GroupId *string `locationName:"groupId" type:"string"`

	// The name of the group.
	GroupName *string `locationName:"groupName" type:"string"`

	// The rules.
	UserRules []IpRuleItem `locationName:"userRules" type:"list"`
}

// String returns the string representation
func (s WorkspacesIpGroup) String() string {
	return awsutil.Prettify(s)
}
