// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package xray

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetSamplingRulesRequest
type GetSamplingRulesInput struct {
	_ struct{} `type:"structure"`

	// Pagination token. Not used.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetSamplingRulesInput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetSamplingRulesInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetSamplingRulesResult
type GetSamplingRulesOutput struct {
	_ struct{} `type:"structure"`

	// Pagination token. Not used.
	NextToken *string `type:"string"`

	// Rule definitions and metadata.
	SamplingRuleRecords []SamplingRuleRecord `type:"list"`
}

// String returns the string representation
func (s GetSamplingRulesOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetSamplingRulesOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.SamplingRuleRecords) > 0 {
		v := s.SamplingRuleRecords

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "SamplingRuleRecords", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opGetSamplingRules = "GetSamplingRules"

// GetSamplingRulesRequest returns a request value for making API operation for
// AWS X-Ray.
//
// Retrieves all sampling rules.
//
//    // Example sending a request using GetSamplingRulesRequest.
//    req := client.GetSamplingRulesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetSamplingRules
func (c *Client) GetSamplingRulesRequest(input *GetSamplingRulesInput) GetSamplingRulesRequest {
	op := &aws.Operation{
		Name:       opGetSamplingRules,
		HTTPMethod: "POST",
		HTTPPath:   "/GetSamplingRules",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetSamplingRulesInput{}
	}

	req := c.newRequest(op, input, &GetSamplingRulesOutput{})
	return GetSamplingRulesRequest{Request: req, Input: input, Copy: c.GetSamplingRulesRequest}
}

// GetSamplingRulesRequest is the request type for the
// GetSamplingRules API operation.
type GetSamplingRulesRequest struct {
	*aws.Request
	Input *GetSamplingRulesInput
	Copy  func(*GetSamplingRulesInput) GetSamplingRulesRequest
}

// Send marshals and sends the GetSamplingRules API request.
func (r GetSamplingRulesRequest) Send(ctx context.Context) (*GetSamplingRulesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetSamplingRulesResponse{
		GetSamplingRulesOutput: r.Request.Data.(*GetSamplingRulesOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewGetSamplingRulesRequestPaginator returns a paginator for GetSamplingRules.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.GetSamplingRulesRequest(input)
//   p := xray.NewGetSamplingRulesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewGetSamplingRulesPaginator(req GetSamplingRulesRequest) GetSamplingRulesPaginator {
	return GetSamplingRulesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *GetSamplingRulesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// GetSamplingRulesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type GetSamplingRulesPaginator struct {
	aws.Pager
}

func (p *GetSamplingRulesPaginator) CurrentPage() *GetSamplingRulesOutput {
	return p.Pager.CurrentPage().(*GetSamplingRulesOutput)
}

// GetSamplingRulesResponse is the response type for the
// GetSamplingRules API operation.
type GetSamplingRulesResponse struct {
	*GetSamplingRulesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetSamplingRules request.
func (r *GetSamplingRulesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
