// Code generated by running "go generate" in golang.org/x/text. DO NOT EDIT.

//go:build !go1.10
// +build !go1.10

package runenames

// UnicodeVersion is the Unicode version from which the tables in this package are derived.
const UnicodeVersion = "9.0.0"

type entry uint64

func (e entry) startRune() int32 {
	return int32((e >> 43) & 0x1fffff)
}

func (e entry) numRunes() int {
	return int((e >> 27) & 0xffff)
}

func (e entry) index() int {
	return int((e >> 11) & 0xffff)
}

func (e entry) base() int {
	return int((e >> 5) & 0x3f)
}

func (e entry) direct() bool {
	const bit = 1 << 4
	return e&bit == bit
}

var entries = []entry{ // 659 elements
	// Entry 0 - 1F
	0x000000010009e930, 0x00010002f8000000, 0x0003f8010809e930, 0x00050016c002f800,
	0x001bd0003019b800, 0x001c20003819e800, 0x001c6000081a2000, 0x001c7000a01a2800,
	0x001d180c681ac800, 0x0029880130273000, 0x002ac80038286000, 0x002b080138289800,
	0x002c48001029d000, 0x002c68001829e000, 0x002c8801b829f800, 0x002e8000d82bb000,
	0x002f8000282c8800, 0x00300000e82cb000, 0x0030f007802d9800, 0x00387801e0351800,
	0x003a68032836f800, 0x003e0001d83a2000, 0x00400001703bf800, 0x00418000783d6800,
	0x00420000e03de000, 0x0042f000083ec000, 0x00450000a83ec800, 0x0045b000403f7000,
	0x0046a005803fb000, 0x004c280040453000, 0x004c780010457000, 0x004c9800b0458000,
	// Entry 20 - 3F
	0x004d500038463000, 0x004d900008466800, 0x004db00020467000, 0x004de00048469000,
	0x004e38001046d800, 0x004e58002046e800, 0x004eb80008470800, 0x004ee00010471000,
	0x004ef80028472000, 0x004f3000b0474800, 0x005008001847f800, 0x0050280030481000,
	0x0050780010484000, 0x00509800b0485000, 0x0051500038490000, 0x0051900010493800,
	0x0051a80010494800, 0x0051c00010495800, 0x0051e00008496800, 0x0051f00028497000,
	0x0052380010499800, 0x005258001849a800, 0x005288000849c000, 0x0052c8002049c800,
	0x0052f0000849e800, 0x005330008049f000, 0x00540800184a7000, 0x00542800484a8800,
	0x00547800184ad000, 0x00549800b04ae800, 0x00555000284b9800, 0x00557800104bc020,
	// Entry 40 - 5F
	0x00559000104bd020, 0x0055a800284be020, 0x0055e000504c0820, 0x00563800184c5820,
	0x00565800184c7020, 0x00568000084c8820, 0x00570000204c9020, 0x00573000604cb020,
	0x0057c800084d1020, 0x00580800184d1820, 0x00582800404d3020, 0x00587800104d7020,
	0x00589800b04d8020, 0x00595000384e3020, 0x00599000104e6820, 0x0059a800284e7820,
	0x0059e000484ea020, 0x005a3800104ee820, 0x005a5800184ef820, 0x005ab000104f1020,
	0x005ae000104f2020, 0x005af800284f3020, 0x005b3000904f5820, 0x005c1000104fe820,
	0x005c2800304ff820, 0x005c700018502820, 0x005c900020504020, 0x005cc80010506020,
	0x005ce00008507020, 0x005cf00010507820, 0x005d180010508820, 0x005d400018509820,
	// Entry 60 - 7F
	0x005d70006050b020, 0x005df00028511020, 0x005e300018513820, 0x005e500020515020,
	0x005e800008517020, 0x005eb80008517820, 0x005f3000a8518020, 0x0060000020522820,
	0x0060280040524820, 0x0060700018528820, 0x00609000b852a020, 0x0061500080535820,
	0x0061e8004053d820, 0x0062300018541820, 0x0062500020543020, 0x0062a80010545020,
	0x0062c00018546020, 0x0063000020547820, 0x0063300050549820, 0x0063c0006054e820,
	0x0064280040554820, 0x0064700018558820, 0x00649000b855a020, 0x0065500050565820,
	0x0065a8002856a820, 0x0065e0004856d020, 0x0066300018571820, 0x0066500020573020,
	0x0066a80010575020, 0x0066f00008576020, 0x0067000020576820, 0x0067300050578820,
	// Entry 80 - 9F
	0x006788001057d820, 0x006808001857e820, 0x0068280040580020, 0x0068700018584020,
	0x0068900148585820, 0x0069e8004059a020, 0x006a30001859e020, 0x006a50003059f820,
	0x006aa000805a2820, 0x006b3000d05aa820, 0x006c1000105b7820, 0x006c2800905b8820,
	0x006cd000c05c1820, 0x006d9800485cd820, 0x006de800085d2020, 0x006e0000385d2820,
	0x006e5000085d6020, 0x006e7800305d6820, 0x006eb000085d9820, 0x006ec000405da020,
	0x006f3000505de020, 0x006f9000185e3020, 0x00700801d05e4820, 0x0071f800e8601820,
	0x0074080010610020, 0x0074200008611020, 0x0074380010611820, 0x0074500008612820,
	0x0074680008613020, 0x0074a00020613820, 0x0074c80038615820, 0x0075080018619020,
	// Entry A0 - BF
	0x007528000861a820, 0x007538000861b020, 0x007550001061b820, 0x007568006861c820,
	0x0075d80018623020, 0x0076000028624820, 0x0076300008627020, 0x0076400030627820,
	0x007680005062a820, 0x0076e0002062f820, 0x0078000240631820, 0x007a480120655820,
	0x007b880138667820, 0x007cc8012067b020, 0x007df0007868d020, 0x007e700068694820,
	0x008000063069b020, 0x00863800086fe020, 0x00866800086fe820, 0x0086800bc86ff020,
	0x00925000207bb820, 0x00928000387bd820, 0x0092c000087c1020, 0x0092d000207c1820,
	0x00930001487c3820, 0x00945000207d8020, 0x00948001087da020, 0x00959000207ea820,
	0x0095c000387ec820, 0x00960000087f0020, 0x00961000207f0820, 0x00964000787f2820,
	// Entry C0 - DF
	0x0096c001c87fa020, 0x0098900020816820, 0x0098c00218818820, 0x009ae8010083a020,
	0x009c0000d084a020, 0x009d0002b0857020, 0x009fc00030882020, 0x00a00014e8885020,
	0x00b50002c89d3820, 0x00b8000068a00020, 0x00b8700038a06820, 0x00b90000b8a0a020,
	0x00ba0000a0a15820, 0x00bb000068a1f820, 0x00bb700018a26020, 0x00bb900010a27820,
	0x00bc000188a28820, 0x00bd880168a41040, 0x00bf000050a57840, 0x00bf800050a5c840,
	0x00c0000078a61840, 0x00c0800050a69040, 0x00c10002c0a6e040, 0x00c4000158a9a040,
	0x00c5800230aaf840, 0x00c80000f8ad2840, 0x00c9000060ae2040, 0x00c9800060ae8040,
	0x00ca000008aee040, 0x00ca200150aee840, 0x00cb800028b03840, 0x00cc000160b06040,
	// Entry E0 - FF
	0x00cd8000d0b1c040, 0x00ce800058b29040, 0x00cef001f0b2e840, 0x00d0f00208b4d840,
	0x00d30000e8b6e040, 0x00d3f80058b7c840, 0x00d4800050b82040, 0x00d5000070b87040,
	0x00d5800078b8e040, 0x00d8000260b95840, 0x00da800168bbb840, 0x00dc0003a0bd2040,
	0x00dfe001e0c0c040, 0x00e1d80078c2a040, 0x00e26801e0c31840, 0x00e6000040c4f840,
	0x00e6800138c53840, 0x00e7c00010c67040, 0x00e80007b0c68040, 0x00efd808d8ce3040,
	0x00f8c00030d70840, 0x00f9000130d73840, 0x00fa400030d86840, 0x00fa800040d89840,
	0x00fac80008d8d840, 0x00fad80008d8e040, 0x00fae80008d8e840, 0x00faf800f8d8f040,
	0x00fc0001a8d9e840, 0x00fdb00078db9040, 0x00fe300070dc0840, 0x00feb00030dc7840,
	// Entry 100 - 11F
	0x00fee80098dca840, 0x00ff900018dd4040, 0x00ffb00048dd5840, 0x0100000328dda040,
	0x0103300060e0c840, 0x0103a000d8e12840, 0x0104800068e20040, 0x01050000f8e26840,
	0x0106800108e36040, 0x0108000460e46840, 0x010c800588e8c840, 0x0112080df0ee5060,
	0x0120000138fc4060, 0x0122000058fd7860, 0x01230038a0fdd060, 0x015bb00101367060,
	0x015cc00111377060, 0x015de80061388060, 0x015e50004138e060, 0x015f600009392060,
	0x015f680019392880, 0x0160000179394080, 0x01618001793ab880, 0x01630004a13c3080,
	0x0167c8016940d080, 0x0169380009423880, 0x0169680009424080, 0x01698001c1424880,
	0x016b780011440880, 0x016bf800c1441880, 0x016d00003944d880, 0x016d400039451080,
	// Entry 120 - 13F
	0x016d800039454880, 0x016dc00039458080, 0x016e00003945b880, 0x016e40003945f080,
	0x016e800039462880, 0x016ec00039466080, 0x016f000329469880, 0x01740000d149c080,
	0x0174d802c94a9080, 0x01780006b14d5880, 0x017f800061540880, 0x0180000201546880,
	0x01820802b1566880, 0x0184c80339591880, 0x01882801495c5080, 0x01898802f15d9880,
	0x018c800159608880, 0x018e00012161e080, 0x018f800179630080, 0x01910006f9647880,
	0x01980008016b7080, 0x01a000cdb0000370, 0x026e000201737080, 0x0270028eb00439f0,
	0x0500002469757080, 0x05248001b999d880, 0x05268004299b9080, 0x052aa806b99fb8a0,
	0x05320005c1a670a0, 0x0538000579ac30a0, 0x053d800041b1a8a0, 0x053fb801a9b1e8a0,
	// Entry 140 - 15F
	0x0541800051b390a0, 0x05420001c1b3e0a0, 0x0544000231b5a0a0, 0x0546700061b7d0a0,
	0x05470000f1b830a0, 0x05480002a1b920a0, 0x054af800f1bbc0a0, 0x054c000271bcb0a0,
	0x054e780059bf20a0, 0x054ef00109bf78a0, 0x05500001b9c080a0, 0x0552000071c238a0,
	0x0552800051c2a8a0, 0x0552e00339c2f8a0, 0x0556d800e1c630a0, 0x0558080031c710a0,
	0x0558480031c740a0, 0x0558880031c770a0, 0x0559000039c7a0a0, 0x0559400039c7d8a0,
	0x05598001b1c810a0, 0x055b8003f1c9c0a0, 0x055f800051cdb0a0, 0x0560015d2004b230,
	0x06bd8000b9ce00a0, 0x06be580189ceb8a0, 0x06c0001c0005b410, 0x06dc000400081390,
	0x06e00020000539f0, 0x070000c80008f1b0, 0x07c8000b71d040a0, 0x07d3800351dbb0a0,
	// Entry 160 - 17F
	0x07d8000039df00a0, 0x07d8980029df38a0, 0x07d8e800d1df60a0, 0x07d9c00029e030a0,
	0x07d9f00009e058a0, 0x07da000011e060a0, 0x07da180011e070a0, 0x07da3003e1e080a0,
	0x07de9805a1e460a0, 0x07e43805c9ea00c0, 0x07ea800201efc8c0, 0x07ec9001b1f1c8c0,
	0x07ef800071f378c0, 0x07f00000d1f3e8c0, 0x07f1000199f4b8c0, 0x07f2a00099f650c0,
	0x07f3400021f6e8c0, 0x07f3800029f708c0, 0x07f3b00439f730c0, 0x07f7f80009fb68c0,
	0x07f80805f1fb70c0, 0x07fe1000320160c0, 0x07fe5000320190c0, 0x07fe90003201c0c0,
	0x07fed0001a01f0c0, 0x07ff00003a0208c0, 0x07ff40003a0240c0, 0x07ffc8002a0278c0,
	0x080000006202a0c0, 0x08006800d20300c0, 0x080140009a03d0c0, 0x0801e000120468c0,
	// Entry 180 - 19F
	0x0801f8007a0478c0, 0x080280007204f0c0, 0x08040003da0560c0, 0x080800001a0938c0,
	0x080838016a0950c0, 0x0809b802c20ab8c0, 0x080c8000620d78c0, 0x080d00000a0dd8c0,
	0x080e8001720de0c0, 0x08140000ea0f50c0, 0x081500018a1038c0, 0x08170000e211c0c0,
	0x081800012212a0c0, 0x08198000da13c0c0, 0x081a80015a1498c0, 0x081c0000f215f0c0,
	0x081cf8012a16e0c0, 0x081e4000721808c0, 0x08200004f21878c0, 0x08250000521d68c0,
	0x08258001221db8c0, 0x0826c001221ed8c0, 0x08280001421ff8c0, 0x08298001a22138c0,
	0x082b78000a22d8c0, 0x08300009ba22e0c0, 0x083a0000b22c98c0, 0x083b0000422d48c0,
	0x08400000322d88c0, 0x084040000a2db8c0, 0x08405001622dc0c0, 0x0841b800122f20c0,
	// Entry 1A0 - 1BF
	0x0841e0000a2f30c0, 0x0841f800ba2f38c0, 0x0842b802422ff0c0, 0x084538004a3230c0,
	0x084700009a3278c0, 0x0847a000123310c0, 0x0847d8010a3320c0, 0x0848f800da3428c0,
	0x0849f8000a3500c0, 0x084c0001523508c0, 0x084d5000723658e0, 0x084de000a236c8e0,
	0x084e9001923768e0, 0x085028001238f8e0, 0x08506000423908e0, 0x0850a8001a3948e0,
	0x0850c800da3960e0, 0x0851c0001a3a38e0, 0x0851f8004a3a50e0, 0x085280004a3a98e0,
	0x08530002023ae0e0, 0x085600013a3ce0e0, 0x08575800623e18e0, 0x08580001b23e78e0,
	0x0859c800ea4028e0, 0x085ac000da4110e0, 0x085bc000d241e8e0, 0x085cc8002242b8e0,
	0x085d48003a42d8e0, 0x086000024a4310e0, 0x086400019a4558e0, 0x086600019a46f0e0,
	// Entry 1C0 - 1DF
	0x0867d000324888e0, 0x08730000fa48b8e0, 0x088000027249b0e0, 0x08829000f24c20e0,
	0x0883f8021a4d10e0, 0x08868000ca4f28e0, 0x08878000524ff0e0, 0x08880001aa5040e0,
	0x0889b0007251e8e0, 0x088a80013a5258e0, 0x088c0002725390e0, 0x088e8000825600e0,
	0x088f0800a25680e0, 0x08900000925720e0, 0x089098016257b0e0, 0x089400003a5910e0,
	0x089440000a5948e0, 0x08945000225950e0, 0x089478007a5970e0, 0x0894f8005a59e8e0,
	0x08958001da5a40e0, 0x08978000525c18e0, 0x08980000225c68e0, 0x08982800425c88e0,
	0x08987800125cc8e0, 0x08989800b25cd8e0, 0x089950003a5d88e0, 0x08999000125dc0e0,
	0x0899a8002a5dd0e0, 0x0899e0004a5df8e0, 0x089a3800125e40e0, 0x089a58001a5e50e0,
	// Entry 1E0 - 1FF
	0x089a80000a5e68e0, 0x089ab8000a5e70e0, 0x089ae8003a5e78e0, 0x089b30003a5eb0e0,
	0x089b80002a5ee8e0, 0x08a00002d25f10e0, 0x08a2d8000a61e0e0, 0x08a2e8000a61e8e0,
	0x08a400024261f0e0, 0x08a68000526430e0, 0x08ac0001b26480e0, 0x08adc001326630e0,
	0x08b000022a6760e0, 0x08b28000526988e0, 0x08b300006a69d8e0, 0x08b40001c26a40e0,
	0x08b60000526c00e0, 0x08b80000d26c50e0, 0x08b8e8007a6d20e0, 0x08b98000826d98e0,
	0x08c500029a6e18e0, 0x08c7f8000a70b0e0, 0x08d60001ca70b8e0, 0x08e000004a7280e0,
	0x08e050016a72c8e0, 0x08e1c000727430e0, 0x08e28000ea74a0e0, 0x08e38001027588e0,
	0x08e49000b27688e0, 0x08e54800727738e0, 0x090000155a77a8e0, 0x091558077a8d0100,
	// Entry 200 - 21F
	0x092000037a947900, 0x092380002a97f100, 0x0924000622981900, 0x098000217a9e3900,
	0x0a2000123abfb100, 0x0b400009c2d1e900, 0x0b49c0080adba920, 0x0b520000fae3b120,
	0x0b53000052e4a920, 0x0b53700012e4f920, 0x0b568000f2e50920, 0x0b57800032e5f920,
	0x0b58000232e62920, 0x0b5a800052e85920, 0x0b5ad8003ae8a920, 0x0b5b1800aae8e120,
	0x0b5be8009ae98920, 0x0b7800022aea2120, 0x0b7a80017aec4920, 0x0b7c78008aedc120,
	0x0b7f00000aee4920, 0x0b8000bf68095a50, 0x0c4000179aee5120, 0x0d8000001305e920,
	0x0de000035b05f920, 0x0de380006b095120, 0x0de400004b09b920, 0x0de48000530a0120,
	0x0de4e000430a5120, 0x0e800007b30a9120, 0x0e8800013b124120, 0x0e89480603137920,
	// Entry 220 - 23F
	0x0e90000233197920, 0x0e980002bb1ba920, 0x0e9b0000931e6120, 0x0ea00002ab1ef120,
	0x0ea2b0023b219920, 0x0ea4f0001323d120, 0x0ea510000b23e120, 0x0ea528001323e920,
	0x0ea548002323f920, 0x0ea5700063241920, 0x0ea5d8000b247920, 0x0ea5e8003b248120,
	0x0ea628020b24b920, 0x0ea838002326c120, 0x0ea868004326e120, 0x0ea8b0003b272120,
	0x0ea8f000e3275920, 0x0ea9d80023283920, 0x0eaa00002b285920, 0x0eaa30000b288120,
	0x0eaa50003b288920, 0x0eaa90023b28c120, 0x0eacc8086b2af940, 0x0eb5400923336140,
	0x0ebe7015f33c8140, 0x0ed4d8002b527140, 0x0ed508007b529940, 0x0f0000003b531140,
	0x0f0040008b534940, 0x0f00d8003b53d140, 0x0f01180013540940, 0x0f0130002b541940,
	// Entry 240 - 25F
	0x0f4000062b544140, 0x0f463800835a6940, 0x0f4800025b5ae940, 0x0f4a8000535d4140,
	0x0f4af000135d9140, 0x0f700000235da140, 0x0f702800db5dc140, 0x0f710800135e9940,
	0x0f7120000b5ea940, 0x0f7138000b5eb140, 0x0f714800535eb940, 0x0f71a000235f0940,
	0x0f71c8000b5f2940, 0x0f71d8000b5f3140, 0x0f7210000b5f3940, 0x0f7238000b5f4140,
	0x0f7248000b5f4940, 0x0f7258000b5f5140, 0x0f7268001b5f5940, 0x0f728800135f7140,
	0x0f72a0000b5f8140, 0x0f72b8000b5f8940, 0x0f72c8000b5f9140, 0x0f72d8000b5f9940,
	0x0f72e8000b5fa140, 0x0f72f8000b5fa940, 0x0f730800135fb140, 0x0f7320000b5fc140,
	0x0f733800235fc940, 0x0f7360003b5fe940, 0x0f73a00023602140, 0x0f73c80023604140,
	// Entry 260 - 27F
	0x0f73f0000b606140, 0x0f74000053606940, 0x0f7458008b60b940, 0x0f7508001b614140,
	0x0f7528002b615940, 0x0f7558008b618140, 0x0f77800013620940, 0x0f80000163621940,
	0x0f8180000b637940, 0x0f8188031b638160, 0x0f8500007b669960, 0x0f8588007b671160,
	0x0f8608007b678960, 0x0f8688012b680160, 0x0f8800006b692960, 0x0f888000fb699160,
	0x0f898001e36a8960, 0x0f8b8001eb6c6960, 0x0f8f3000eb6e5160, 0x0f908001636f3960,
	0x0f9200004b709960, 0x0f9280001370e160, 0x0f98001e9b70f160, 0x0fb700006b8f8960,
	0x0fb780003b8ff160, 0x0fb80003a3902960, 0x0fbc0002ab93c960, 0x0fc0000063967160,
	0x0fc08001c396d160, 0x0fc2800053989160, 0x0fc300014398e160, 0x0fc48000f39a2160,
	// Entry 280 - 29F
	0x0fc880007b9b1160, 0x0fc90000439b8960, 0x0fc980000b9bc960, 0x0fc99800639bd160,
	0x0fca0000639c3160, 0x0fca80007b9c9160, 0x0fcc0000939d0960, 0x0fce00000b9d9960,
	0x10000536b800db70, 0x15380081a801b370, 0x15ba0006f0028b70, 0x15c100b410036370,
	0x17c00010f39da160, 0x700008000bae9160, 0x7001000303ae9960, 0x7008000653b19960,
	0x700e500133b7e980, 0x780007fff006b2d0, 0x800007fff00762d0,
} // Size: 5296 bytes

var index = []uint16{ // 30500 elements
	// Entry 0 - 3F
	0x0000, 0x0005, 0x0015, 0x0023, 0x002e, 0x0039, 0x0045, 0x004e,
	0x0058, 0x0068, 0x0079, 0x0081, 0x008a, 0x008f, 0x009b, 0x00a4,
	0x00ab, 0x00b5, 0x00be, 0x00c7, 0x00d2, 0x00dc, 0x00e6, 0x00ef,
	0x00fa, 0x0105, 0x010f, 0x0114, 0x011d, 0x012b, 0x0136, 0x0147,
	0x0154, 0x0161, 0x0177, 0x018d, 0x01a3, 0x01b9, 0x01cf, 0x01e5,
	0x01fb, 0x0211, 0x0227, 0x023d, 0x0253, 0x0269, 0x027f, 0x0295,
	0x02ab, 0x02c1, 0x02d7, 0x02ed, 0x0303, 0x0319, 0x032f, 0x0345,
	0x035b, 0x0371, 0x0387, 0x039d, 0x03b0, 0x03bf, 0x03d3, 0x03e4,
	// Entry 40 - 7F
	0x03ec, 0x03f8, 0x040c, 0x0420, 0x0434, 0x0448, 0x045c, 0x0470,
	0x0484, 0x0498, 0x04ac, 0x04c0, 0x04d4, 0x04e8, 0x04fc, 0x0510,
	0x0524, 0x0538, 0x054c, 0x0560, 0x0574, 0x0588, 0x059c, 0x05b0,
	0x05c4, 0x05d8, 0x05ec, 0x0600, 0x0612, 0x061f, 0x0632, 0x0637,
	0x0645, 0x065e, 0x0667, 0x0671, 0x067e, 0x0686, 0x0690, 0x069c,
	0x06a5, 0x06b3, 0x06cd, 0x06f6, 0x06fe, 0x0709, 0x0718, 0x071e,
	0x0729, 0x0738, 0x0747, 0x0758, 0x0764, 0x076e, 0x077a, 0x0784,
	0x078b, 0x079a, 0x07b5, 0x07df, 0x07fa, 0x0812, 0x0830, 0x0846,
	// Entry 80 - BF
	0x0867, 0x0888, 0x08ae, 0x08cf, 0x08f4, 0x091a, 0x0931, 0x0954,
	0x0975, 0x0996, 0x09bc, 0x09e1, 0x0a02, 0x0a23, 0x0a49, 0x0a6e,
	0x0a86, 0x0aa7, 0x0ac8, 0x0ae9, 0x0b0f, 0x0b30, 0x0b55, 0x0b68,
	0x0b8a, 0x0bab, 0x0bcc, 0x0bf2, 0x0c17, 0x0c38, 0x0c52, 0x0c6c,
	0x0c8b, 0x0caa, 0x0cce, 0x0ced, 0x0d10, 0x0d34, 0x0d49, 0x0d6a,
	0x0d89, 0x0da8, 0x0dcc, 0x0def, 0x0e0e, 0x0e2d, 0x0e51, 0x0e74,
	0x0e8a, 0x0ea9, 0x0ec8, 0x0ee7, 0x0f0b, 0x0f2a, 0x0f4d, 0x0f5a,
	0x0f7a, 0x0f99, 0x0fb8, 0x0fdc, 0x0fff, 0x101e, 0x1036, 0x1059,
	// Entry C0 - FF
	0x107b, 0x109b, 0x10bc, 0x10db, 0x10fd, 0x111d, 0x113e, 0x115d,
	0x1183, 0x11a7, 0x11cc, 0x11ef, 0x1210, 0x122f, 0x1250, 0x126f,
	0x1291, 0x12b1, 0x12d3, 0x12f3, 0x1314, 0x1333, 0x1358, 0x137b,
	0x139d, 0x13bd, 0x13de, 0x13fd, 0x1423, 0x1447, 0x1468, 0x1487,
	0x14ac, 0x14cf, 0x14f2, 0x1513, 0x1539, 0x155d, 0x157f, 0x159f,
	0x15c0, 0x15df, 0x1601, 0x1621, 0x1642, 0x1661, 0x1683, 0x16a3,
	0x16c8, 0x16e4, 0x16fd, 0x1714, 0x173a, 0x175e, 0x1781, 0x17a2,
	0x17b8, 0x17d9, 0x17f8, 0x181b, 0x183c, 0x185d, 0x187c, 0x18a2,
	// Entry 100 - 13F
	0x18c6, 0x18e8, 0x1908, 0x1929, 0x1948, 0x196b, 0x198c, 0x19ad,
	0x19cc, 0x19f7, 0x1a0f, 0x1a25, 0x1a47, 0x1a67, 0x1a88, 0x1aa7,
	0x1acf, 0x1af5, 0x1b0e, 0x1b25, 0x1b46, 0x1b65, 0x1b88, 0x1ba9,
	0x1bca, 0x1be9, 0x1c0a, 0x1c29, 0x1c4f, 0x1c73, 0x1c96, 0x1cb7,
	0x1cd8, 0x1cf7, 0x1d1a, 0x1d3b, 0x1d5c, 0x1d7b, 0x1d9d, 0x1dbd,
	0x1dde, 0x1dfd, 0x1e1f, 0x1e3f, 0x1e60, 0x1e7f, 0x1ea5, 0x1ec9,
	0x1ef1, 0x1f17, 0x1f39, 0x1f59, 0x1f7f, 0x1fa3, 0x1fc9, 0x1fed,
	0x2012, 0x2033, 0x2052, 0x2077, 0x209a, 0x20bb, 0x20da, 0x20f3,
	// Entry 140 - 17F
	0x2113, 0x2133, 0x2155, 0x2175, 0x2192, 0x21ad, 0x21c8, 0x21e8,
	0x2206, 0x2224, 0x2244, 0x2266, 0x2286, 0x22a5, 0x22c4, 0x22de,
	0x22f9, 0x2319, 0x2337, 0x2357, 0x2371, 0x2386, 0x239f, 0x23c1,
	0x23e1, 0x23ff, 0x241c, 0x2441, 0x245e, 0x2483, 0x24ab, 0x24d3,
	0x24f3, 0x2511, 0x2528, 0x253d, 0x255d, 0x257b, 0x258a, 0x25a7,
	0x25c2, 0x25da, 0x25f8, 0x261e, 0x263e, 0x265c, 0x2686, 0x26a6,
	0x26c4, 0x26e0, 0x2700, 0x2720, 0x273e, 0x2760, 0x2780, 0x2798,
	0x27b9, 0x27d8, 0x27f8, 0x2814, 0x2832, 0x284e, 0x287c, 0x288d,
	// Entry 180 - 1BF
	0x28a6, 0x28c0, 0x28db, 0x28f7, 0x2919, 0x294e, 0x296e, 0x2985,
	0x29af, 0x29c4, 0x29db, 0x2a05, 0x2a1a, 0x2a3b, 0x2a5a, 0x2a7b,
	0x2a9a, 0x2abb, 0x2ada, 0x2afb, 0x2b1a, 0x2b4a, 0x2b78, 0x2ba7,
	0x2bd4, 0x2c03, 0x2c30, 0x2c5f, 0x2c8c, 0x2ca7, 0x2cd7, 0x2d05,
	0x2d35, 0x2d63, 0x2d86, 0x2da7, 0x2dc9, 0x2de9, 0x2e0a, 0x2e29,
	0x2e4a, 0x2e69, 0x2e8b, 0x2eab, 0x2ed8, 0x2f03, 0x2f26, 0x2f47,
	0x2f66, 0x2f7d, 0x2fa7, 0x2fbc, 0x2fdd, 0x2ffc, 0x3016, 0x302f,
	0x3050, 0x306f, 0x309f, 0x30cd, 0x30ef, 0x310f, 0x313b, 0x3165,
	// Entry 1C0 - 1FF
	0x318d, 0x31b3, 0x31dd, 0x3205, 0x322d, 0x3253, 0x327d, 0x32a5,
	0x32cd, 0x32f3, 0x331d, 0x3345, 0x336d, 0x3393, 0x33bd, 0x33e5,
	0x340d, 0x3433, 0x345d, 0x3485, 0x34ad, 0x34d3, 0x34fd, 0x3525,
	0x354c, 0x3571, 0x3598, 0x35bd, 0x35d6, 0x35ed, 0x360e, 0x362d,
	0x3657, 0x3675, 0x368c, 0x36a1, 0x36c1, 0x36df, 0x3704, 0x3727,
	0x374a, 0x376b, 0x379b, 0x37c9, 0x37f5, 0x381f, 0x3844, 0x3867,
	0x3897, 0x38c5, 0x38e7, 0x3907, 0x3925, 0x3943, 0x3961, 0x397d,
	0x399a, 0x39b7, 0x39d9, 0x39fb, 0x3a1b, 0x3a3a, 0x3a65, 0x3a89,
	// Entry 200 - 23F
	0x3aad, 0x3ace, 0x3aed, 0x3b0f, 0x3b29, 0x3b46, 0x3b68, 0x3b88,
	0x3baa, 0x3bca, 0x3bf5, 0x3c18, 0x3c3a, 0x3c5a, 0x3c7c, 0x3c9c,
	0x3cb7, 0x3ccf, 0x3cee, 0x3d0c, 0x3d25, 0x3d43, 0x3d61, 0x3d7f,
	0x3d9c, 0x3db4, 0x3dd6, 0x3def, 0x3e11, 0x3e3d, 0x3e66, 0x3e8e,
	0x3eac, 0x3ec7, 0x3ee3, 0x3efb, 0x3f17, 0x3f32, 0x3f50, 0x3f71,
	0x3f91, 0x3fa8, 0x3fc4, 0x3fea, 0x4008, 0x4030, 0x4047, 0x4062,
	0x408b, 0x40a9, 0x40cc, 0x40f4, 0x4110, 0x412b, 0x4148, 0x4167,
	0x417d, 0x4198, 0x41c1, 0x41e6, 0x4208, 0x4226, 0x4248, 0x4273,
	// Entry 240 - 27F
	0x428f, 0x42b4, 0x42d2, 0x42e8, 0x4319, 0x433e, 0x435e, 0x4379,
	0x43a1, 0x43b9, 0x43d3, 0x43f1, 0x440c, 0x4427, 0x4442, 0x445e,
	0x4486, 0x44a4, 0x44ba, 0x44da, 0x44f3, 0x451b, 0x453d, 0x4555,
	0x4570, 0x458c, 0x45ac, 0x45d2, 0x45ee, 0x4614, 0x462f, 0x464b,
	0x4669, 0x468e, 0x46bc, 0x46d9, 0x46f8, 0x471f, 0x473c, 0x475b,
	0x4782, 0x47a1, 0x47be, 0x47db, 0x47fb, 0x481b, 0x4844, 0x4876,
	0x488d, 0x48ae, 0x48c5, 0x48dc, 0x48fa, 0x4922, 0x494a, 0x4961,
	0x4978, 0x498d, 0x49a9, 0x49c5, 0x49df, 0x49fd, 0x4a1c, 0x4a3a,
	// Entry 280 - 2BF
	0x4a56, 0x4a7b, 0x4a99, 0x4ab8, 0x4ad4, 0x4af2, 0x4b13, 0x4b18,
	0x4b35, 0x4b4b, 0x4b67, 0x4b83, 0x4ba4, 0x4bbe, 0x4bde, 0x4bfe,
	0x4c1e, 0x4c43, 0x4c6a, 0x4c90, 0x4ca7, 0x4cc0, 0x4cd9, 0x4cf3,
	0x4cf8, 0x4d01, 0x4d0b, 0x4d11, 0x4d1c, 0x4d2f, 0x4d4a, 0x4d66,
	0x4d81, 0x4d98, 0x4daf, 0x4dc6, 0x4df1, 0x4e14, 0x4e31, 0x4e4d,
	0x4e69, 0x4e8b, 0x4eb2, 0x4eda, 0x4ef1, 0x4f0c, 0x4f2d, 0x4f4f,
	0x4f6f, 0x4f91, 0x4fb4, 0x4fcc, 0x4fef, 0x5019, 0x5043, 0x505c,
	0x5078, 0x5097, 0x50b4, 0x50d2, 0x50ee, 0x5103, 0x511d, 0x513b,
	// Entry 2C0 - 2FF
	0x5151, 0x5167, 0x5182, 0x5191, 0x51a1, 0x51b3, 0x51c2, 0x51d5,
	0x51e8, 0x51fc, 0x5210, 0x522d, 0x523c, 0x5259, 0x527d, 0x529a,
	0x52af, 0x52c7, 0x52e3, 0x52f8, 0x5316, 0x5331, 0x534d, 0x5369,
	0x5382, 0x539c, 0x53b6, 0x53c4, 0x53e2, 0x53f9, 0x5412, 0x542b,
	0x5445, 0x5465, 0x5483, 0x5496, 0x54af, 0x54c3, 0x54d8, 0x54e9,
	0x54f9, 0x5516, 0x552c, 0x5550, 0x5565, 0x5586, 0x559b, 0x55b9,
	0x55ce, 0x55e4, 0x55f6, 0x560f, 0x5626, 0x5644, 0x5661, 0x5680,
	0x569e, 0x56bd, 0x56dc, 0x56f2, 0x5709, 0x571a, 0x5732, 0x574b,
	// Entry 300 - 33F
	0x5764, 0x577d, 0x5798, 0x57af, 0x57ce, 0x57eb, 0x5801, 0x581c,
	0x5840, 0x585a, 0x5873, 0x588d, 0x58ac, 0x58cc, 0x58e9, 0x5902,
	0x5921, 0x593f, 0x5950, 0x5961, 0x597f, 0x599e, 0x59ce, 0x59ed,
	0x5a06, 0x5a1e, 0x5a39, 0x5a4f, 0x5a6b, 0x5a81, 0x5a98, 0x5ab5,
	0x5acb, 0x5aea, 0x5b11, 0x5b2f, 0x5b4d, 0x5b6b, 0x5b89, 0x5ba7,
	0x5bc5, 0x5be3, 0x5c01, 0x5c1f, 0x5c3d, 0x5c5b, 0x5c79, 0x5c97,
	0x5cb0, 0x5cc7, 0x5ce9, 0x5d09, 0x5d1b, 0x5d33, 0x5d5a, 0x5d7f,
	0x5d92, 0x5dba, 0x5de0, 0x5e0f, 0x5e22, 0x5e3a, 0x5e45, 0x5e5a,
	// Entry 340 - 37F
	0x5e7f, 0x5e8f, 0x5eb6, 0x5ed9, 0x5efd, 0x5f24, 0x5f4b, 0x5f70,
	0x5fa0, 0x5fba, 0x5fd3, 0x5fed, 0x6007, 0x6023, 0x603c, 0x6054,
	0x606e, 0x6087, 0x60a1, 0x60bb, 0x60d2, 0x60e9, 0x6100, 0x611c,
	0x6133, 0x614b, 0x6165, 0x617d, 0x6199, 0x61b1, 0x61c9, 0x61e1,
	0x61fb, 0x6223, 0x624e, 0x6271, 0x6296, 0x62b7, 0x62d9, 0x630c,
	0x6324, 0x633b, 0x6353, 0x636b, 0x6385, 0x639c, 0x63b2, 0x63ca,
	0x63e1, 0x63f9, 0x6411, 0x6426, 0x643b, 0x6450, 0x646a, 0x647f,
	0x6495, 0x64b3, 0x64cb, 0x64e1, 0x64fb, 0x6511, 0x6527, 0x653d,
	// Entry 380 - 3BF
	0x6555, 0x657b, 0x65a4, 0x65c9, 0x65ee, 0x6611, 0x6629, 0x663a,
	0x664c, 0x666a, 0x6692, 0x66be, 0x66ce, 0x66dd, 0x66ed, 0x6707,
	0x6727, 0x673a, 0x6753, 0x6767, 0x6781, 0x6793, 0x67ab, 0x67bd,
	0x67d5, 0x67ef, 0x6807, 0x6820, 0x6837, 0x6851, 0x6869, 0x6883,
	0x689b, 0x68b7, 0x68d1, 0x68ec, 0x6905, 0x691e, 0x6935, 0x6947,
	0x6957, 0x6970, 0x6980, 0x699a, 0x69b5, 0x69d9, 0x69f1, 0x6a07,
	0x6a28, 0x6a40, 0x6a56, 0x6a72, 0x6a9c, 0x6ac4, 0x6af5, 0x6b1a,
	0x6b34, 0x6b4f, 0x6b6a, 0x6b8e, 0x6ba9, 0x6bd9, 0x6bf3, 0x6c0d,
	// Entry 3C0 - 3FF
	0x6c28, 0x6c43, 0x6c5f, 0x6c7a, 0x6c9e, 0x6cbd, 0x6cd9, 0x6cf2,
	0x6d0c, 0x6d26, 0x6d41, 0x6d5b, 0x6d75, 0x6d90, 0x6daa, 0x6dc3,
	0x6de2, 0x6dfc, 0x6e16, 0x6e30, 0x6e4a, 0x6e63, 0x6e7d, 0x6e97,
	0x6eb1, 0x6ecb, 0x6ee4, 0x6efe, 0x6f18, 0x6f33, 0x6f4e, 0x6f69,
	0x6f86, 0x6fa7, 0x6fc3, 0x6fe4, 0x6ffd, 0x7017, 0x7031, 0x7048,
	0x7060, 0x7078, 0x7091, 0x70a9, 0x70c1, 0x70da, 0x70f2, 0x7109,
	0x7126, 0x713e, 0x7156, 0x716e, 0x7186, 0x719d, 0x71b5, 0x71cd,
	0x71e5, 0x71fd, 0x7214, 0x722c, 0x7244, 0x725d, 0x7276, 0x728f,
	// Entry 400 - 43F
	0x72aa, 0x72c9, 0x72e3, 0x7302, 0x7319, 0x7331, 0x7349, 0x736c,
	0x7384, 0x739d, 0x73b6, 0x73d8, 0x73f1, 0x741f, 0x7437, 0x744f,
	0x7468, 0x7481, 0x749b, 0x74b4, 0x74d6, 0x74f3, 0x750d, 0x752a,
	0x7545, 0x7560, 0x7579, 0x759b, 0x75bb, 0x75dd, 0x75fd, 0x7628,
	0x7651, 0x7670, 0x768d, 0x76b5, 0x76db, 0x76f6, 0x770f, 0x772a,
	0x7743, 0x775f, 0x7779, 0x7798, 0x77b5, 0x77ed, 0x7823, 0x783d,
	0x7855, 0x7878, 0x7899, 0x78c1, 0x78e7, 0x7901, 0x7919, 0x7936,
	0x7951, 0x7968, 0x7980, 0x79a1, 0x79c2, 0x79e3, 0x79fe, 0x7a27,
	// Entry 440 - 47F
	0x7a47, 0x7a70, 0x7a97, 0x7abc, 0x7adf, 0x7b03, 0x7b25, 0x7b4c,
	0x7b71, 0x7b98, 0x7bbd, 0x7be9, 0x7c13, 0x7c3d, 0x7c65, 0x7c8e,
	0x7cb5, 0x7cde, 0x7d05, 0x7d34, 0x7d61, 0x7d87, 0x7dab, 0x7dcd,
	0x7ded, 0x7e16, 0x7e3d, 0x7e5d, 0x7e7b, 0x7ea6, 0x7ecf, 0x7ef3,
	0x7f15, 0x7f3e, 0x7f65, 0x7f8e, 0x7fb5, 0x7fd7, 0x7ff7, 0x8025,
	0x8051, 0x807a, 0x80a1, 0x80c1, 0x80df, 0x8109, 0x8131, 0x8161,
	0x818f, 0x81ab, 0x81c5, 0x81ea, 0x820d, 0x8241, 0x8273, 0x828b,
	0x82b1, 0x82d5, 0x82f9, 0x831b, 0x833f, 0x8361, 0x8385, 0x83a7,
	// Entry 480 - 4BF
	0x83cb, 0x83ed, 0x8413, 0x8437, 0x845b, 0x847d, 0x849b, 0x84bf,
	0x84e1, 0x8509, 0x852f, 0x854d, 0x8569, 0x858e, 0x85b1, 0x85ce,
	0x85e9, 0x8615, 0x863f, 0x8669, 0x8691, 0x86ba, 0x86e1, 0x8706,
	0x8729, 0x874e, 0x8771, 0x8799, 0x87bf, 0x87e7, 0x880d, 0x882d,
	0x884b, 0x887a, 0x88a7, 0x88cf, 0x88f5, 0x891a, 0x893d, 0x8965,
	0x898b, 0x89b6, 0x89df, 0x8a09, 0x8a31, 0x8a5b, 0x8a83, 0x8aae,
	0x8ad7, 0x8b07, 0x8b35, 0x8b59, 0x8b7b, 0x8ba1, 0x8bc5, 0x8be4,
	0x8c01, 0x8c21, 0x8c3f, 0x8c5f, 0x8c7d, 0x8c9e, 0x8cbd, 0x8cdd,
	// Entry 4C0 - 4FF
	0x8cfb, 0x8d1b, 0x8d39, 0x8d59, 0x8d77, 0x8d97, 0x8db5, 0x8dd8,
	0x8df9, 0x8e1d, 0x8e3f, 0x8e5a, 0x8e73, 0x8e8e, 0x8ea7, 0x8ec2,
	0x8edb, 0x8ef5, 0x8f0d, 0x8f27, 0x8f3f, 0x8f5f, 0x8f7d, 0x8fa8,
	0x8fd1, 0x8ffc, 0x9025, 0x904e, 0x9075, 0x90a0, 0x90c9, 0x90f2,
	0x9119, 0x9136, 0x9151, 0x916d, 0x9187, 0x91b0, 0x91d7, 0x91f2,
	0x920d, 0x9228, 0x9242, 0x925d, 0x9277, 0x9291, 0x92ab, 0x92c5,
	0x92e0, 0x92fb, 0x9317, 0x9332, 0x934c, 0x9367, 0x9381, 0x939b,
	0x93b7, 0x93d3, 0x93ee, 0x9408, 0x9423, 0x943e, 0x9458, 0x9473,
	// Entry 500 - 53F
	0x948e, 0x94aa, 0x94c4, 0x94df, 0x94fa, 0x9516, 0x9531, 0x954b,
	0x9567, 0x9583, 0x959e, 0x95b8, 0x95d3, 0x95fa, 0x960d, 0x9623,
	0x963c, 0x964a, 0x9660, 0x967a, 0x9693, 0x96ac, 0x96c5, 0x96dd,
	0x96f6, 0x970e, 0x9726, 0x973e, 0x9756, 0x976f, 0x9788, 0x97a2,
	0x97bb, 0x97d3, 0x97ec, 0x9804, 0x981c, 0x9836, 0x9850, 0x9869,
	0x9881, 0x989a, 0x98b3, 0x98cb, 0x98e4, 0x98fd, 0x9917, 0x992f,
	0x9948, 0x9961, 0x997b, 0x9994, 0x99ac, 0x99c6, 0x99e0, 0x99f9,
	0x9a11, 0x9a2a, 0x9a4a, 0x9a5c, 0x9a6b, 0x9a8e, 0x9ab0, 0x9ac2,
	// Entry 540 - 57F
	0x9ad7, 0x9aea, 0x9b02, 0x9b1b, 0x9b34, 0x9b48, 0x9b5b, 0x9b6e,
	0x9b82, 0x9b95, 0x9ba8, 0x9bbc, 0x9bd7, 0x9bee, 0x9c07, 0x9c23,
	0x9c36, 0x9c50, 0x9c63, 0x9c79, 0x9c8d, 0x9ca8, 0x9cbb, 0x9cce,
	0x9cea, 0x9d06, 0x9d17, 0x9d29, 0x9d3b, 0x9d4e, 0x9d67, 0x9d79,
	0x9d91, 0x9da9, 0x9dc2, 0x9dd4, 0x9de6, 0x9df8, 0x9e0a, 0x9e1d,
	0x9e2f, 0x9e4f, 0x9e62, 0x9e7e, 0x9e90, 0x9ea8, 0x9eb9, 0x9ed1,
	0x9ee6, 0x9efa, 0x9f16, 0x9f2b, 0x9f40, 0x9f5e, 0x9f77, 0x9f89,
	0x9f9a, 0x9fad, 0x9fc0, 0x9fd0, 0x9fe1, 0x9ff4, 0xa005, 0xa016,
	// Entry 580 - 5BF
	0xa027, 0xa03e, 0xa04f, 0xa062, 0xa079, 0xa08a, 0xa0a1, 0xa0b2,
	0xa0c6, 0xa0d8, 0xa0ee, 0xa0fe, 0xa117, 0xa12a, 0xa13b, 0xa14d,
	0xa15f, 0xa170, 0xa192, 0xa1b1, 0xa1d3, 0xa1ec, 0xa208, 0xa21a,
	0xa22b, 0xa241, 0xa252, 0xa264, 0xa27c, 0xa292, 0xa2aa, 0xa2b4,
	0xa2cf, 0xa2f1, 0xa2fd, 0xa309, 0xa31e, 0xa336, 0xa347, 0xa36f,
	0xa38a, 0xa3a8, 0xa3c5, 0xa3da, 0xa3ef, 0xa420, 0xa436, 0xa448,
	0xa45a, 0xa46c, 0xa47c, 0xa48e, 0xa4b0, 0xa4c4, 0xa4de, 0xa4f1,
	0xa514, 0xa537, 0xa559, 0xa57c, 0xa59e, 0xa5b0, 0xa5c1, 0xa5da,
	// Entry 5C0 - 5FF
	0xa5eb, 0xa5fd, 0xa60f, 0xa620, 0xa632, 0xa643, 0xa655, 0xa666,
	0xa678, 0xa68a, 0xa69d, 0xa6ae, 0xa6bf, 0xa6d0, 0xa6e1, 0xa6f2,
	0xa705, 0xa72c, 0xa755, 0xa77c, 0xa7a7, 0xa7d4, 0xa7e2, 0xa7f3,
	0xa804, 0xa815, 0xa826, 0xa838, 0xa84a, 0xa85b, 0xa86c, 0xa886,
	0xa897, 0xa8a6, 0xa8b5, 0xa8c4, 0xa8d0, 0xa8dc, 0xa8e8, 0xa8f5,
	0xa901, 0xa914, 0xa926, 0xa938, 0xa94d, 0xa962, 0xa979, 0xa988,
	0xa9a7, 0xa9cf, 0xa9ea, 0xa9ff, 0xaa19, 0xaa30, 0xaa47, 0xaa5d,
	0xaa73, 0xaa8b, 0xaaa2, 0xaab9, 0xaacf, 0xaae7, 0xaaff, 0xab16,
	// Entry 600 - 63F
	0xab29, 0xab41, 0xab5b, 0xab73, 0xab8c, 0xaba5, 0xabc3, 0xabdb,
	0xac03, 0xac2b, 0xac43, 0xac60, 0xac7c, 0xac9c, 0xacb8, 0xacca,
	0xacde, 0xacf0, 0xad0b, 0xad3c, 0xad4d, 0xad60, 0xad73, 0xad95,
	0xadc3, 0xadd5, 0xade7, 0xae0e, 0xae21, 0xae36, 0xae48, 0xae63,
	0xae83, 0xaeb1, 0xaec4, 0xaed8, 0xaee9, 0xaf1a, 0xaf40, 0xaf52,
	0xaf70, 0xaf8b, 0xafab, 0xafcf, 0xaffd, 0xb022, 0xb033, 0xb059,
	0xb088, 0xb0b0, 0xb0ed, 0xb112, 0xb139, 0xb160, 0xb187, 0xb1a0,
	0xb1c6, 0xb1e6, 0xb1f7, 0xb21e, 0xb231, 0xb251, 0xb278, 0xb28b,
	// Entry 640 - 67F
	0xb2a2, 0xb2bd, 0xb2dd, 0xb2ed, 0xb314, 0xb325, 0xb340, 0xb353,
	0xb378, 0xb38a, 0xb3b1, 0xb3cf, 0xb3ef, 0xb416, 0xb43d, 0xb45e,
	0xb477, 0xb48a, 0xb4a6, 0xb4ce, 0xb4eb, 0xb50d, 0xb52d, 0xb543,
	0xb56a, 0xb588, 0xb5a3, 0xb5bb, 0xb5cb, 0xb5da, 0xb5ea, 0xb602,
	0xb627, 0xb637, 0xb64e, 0xb669, 0xb687, 0xb6a7, 0xb6b6, 0xb6dd,
	0xb6f5, 0xb71e, 0xb72e, 0xb73e, 0xb777, 0xb7b0, 0xb7d3, 0xb7ed,
	0xb803, 0xb81f, 0xb835, 0xb847, 0xb862, 0xb880, 0xb8aa, 0xb8d0,
	0xb8f4, 0xb909, 0xb920, 0xb930, 0xb940, 0xb955, 0xb96b, 0xb981,
	// Entry 680 - 6BF
	0xb99d, 0xb9ba, 0xb9e5, 0xb9fa, 0xba1b, 0xba3c, 0xba5c, 0xba7b,
	0xba9a, 0xbabb, 0xbadb, 0xbafb, 0xbb1a, 0xbb3b, 0xbb5c, 0xbb7c,
	0xbb9e, 0xbbbe, 0xbbe0, 0xbbfc, 0xbc1f, 0xbc40, 0xbc57, 0xbc73,
	0xbc8d, 0xbca5, 0xbcbb, 0xbcd2, 0xbcea, 0xbd03, 0xbd27, 0xbd4a,
	0xbd5c, 0xbd72, 0xbd8b, 0xbda5, 0xbdbd, 0xbdd0, 0xbdef, 0xbe01,
	0xbe14, 0xbe30, 0xbe44, 0xbe65, 0xbe75, 0xbe86, 0xbe98, 0xbeaa,
	0xbebc, 0xbed7, 0xbee9, 0xbefe, 0xbf10, 0xbf24, 0xbf35, 0xbf46,
	0xbf5b, 0xbf76, 0xbf85, 0xbf95, 0xbfae, 0xbfc1, 0xbfd3, 0xbfe5,
	// Entry 6C0 - 6FF
	0xbff7, 0xc008, 0xc023, 0xc03f, 0xc05c, 0xc06f, 0xc082, 0xc096,
	0xc0a9, 0xc0bc, 0xc0d0, 0xc0e2, 0xc0f4, 0xc112, 0xc12d, 0xc13f,
	0xc151, 0xc16a, 0xc17c, 0xc18e, 0xc19a, 0xc1ad, 0xc1bd, 0xc1cc,
	0xc1ea, 0xc208, 0xc21f, 0xc236, 0xc24f, 0xc268, 0xc274, 0xc282,
	0xc29d, 0xc2b8, 0xc2d0, 0xc304, 0xc339, 0xc371, 0xc3bc, 0xc3ef,
	0xc41c, 0xc43a, 0xc45f, 0xc497, 0xc4d5, 0xc502, 0xc51f, 0xc546,
	0xc56b, 0xc5a5, 0xc5d5, 0xc5fa, 0xc632, 0xc654, 0xc67d, 0xc6b7,
	0xc6d8, 0xc6f9, 0xc71f, 0xc740, 0xc75f, 0xc779, 0xc7a9, 0xc7cb,
	// Entry 700 - 73F
	0xc7fc, 0xc830, 0xc86b, 0xc8a7, 0xc8e2, 0xc916, 0xc953, 0xc992,
	0xc9d4, 0xca18, 0xca5b, 0xca97, 0xcad5, 0xcb18, 0xcb5d, 0xcb9a,
	0xcbd8, 0xcbfa, 0xcc1f, 0xcc30, 0xcc47, 0xcc5a, 0xcc6b, 0xcc7c,
	0xcc93, 0xcca6, 0xccb9, 0xcccc, 0xccdf, 0xccf2, 0xcd06, 0xcd18,
	0xcd2b, 0xcd3e, 0xcd55, 0xcd68, 0xcd7e, 0xcd94, 0xcdaa, 0xcdbb,
	0xcdd1, 0xcde7, 0xcdfe, 0xce10, 0xce22, 0xce34, 0xce48, 0xce59,
	0xce6d, 0xce81, 0xce95, 0xcea5, 0xceb5, 0xcec7, 0xcedb, 0xceee,
	0xcf01, 0xcf0f, 0xcf1f, 0xcf2d, 0xcf3d, 0xcf4b, 0xcf5b, 0xcf69,
	// Entry 740 - 77F
	0xcf79, 0xcf87, 0xcf97, 0xcfa3, 0xcfb4, 0xcfc2, 0xcfcf, 0xcfdc,
	0xcfeb, 0xcff9, 0xd007, 0xd014, 0xd023, 0xd032, 0xd040, 0xd04c,
	0xd059, 0xd065, 0xd071, 0xd07d, 0xd08a, 0xd096, 0xd0ab, 0xd0b7,
	0xd0c4, 0xd0d1, 0xd0de, 0xd0eb, 0xd0f9, 0xd106, 0xd113, 0xd121,
	0xd12e, 0xd13c, 0xd149, 0xd156, 0xd163, 0xd177, 0xd184, 0xd192,
	0xd19f, 0xd1ac, 0xd1b9, 0xd1c6, 0xd1db, 0xd1ed, 0xd200, 0xd212,
	0xd22f, 0xd24b, 0xd26a, 0xd28c, 0xd2a8, 0xd2c3, 0xd2e1, 0xd300,
	0xd31e, 0xd336, 0xd34d, 0xd361, 0xd376, 0xd37f, 0xd393, 0xd3a1,
	// Entry 780 - 7BF
	0xd3b6, 0xd3ca, 0xd3e0, 0xd3f6, 0xd409, 0xd41d, 0xd431, 0xd444,
	0xd458, 0xd46c, 0xd481, 0xd497, 0xd4ab, 0xd4bf, 0xd4d7, 0xd4ea,
	0xd4fd, 0xd515, 0xd529, 0xd53e, 0xd553, 0xd568, 0xd579, 0xd58f,
	0xd5a7, 0xd5bc, 0xd5e4, 0xd601, 0xd61c, 0xd632, 0xd652, 0xd66e,
	0xd685, 0xd6a4, 0xd6bf, 0xd6d5, 0xd6f6, 0xd712, 0xd72d, 0xd743,
	0xd75e, 0xd779, 0xd78f, 0xd7a5, 0xd7bf, 0xd7d5, 0xd7f2, 0xd80e,
	0xd829, 0xd842, 0xd85e, 0xd87e, 0xd899, 0xd8bc, 0xd8d7, 0xd8f2,
	0xd90c, 0xd926, 0xd943, 0xd965, 0xd981, 0xd995, 0xd9a6, 0xd9b7,
	// Entry 7C0 - 7FF
	0xd9c8, 0xd9d9, 0xd9ef, 0xda00, 0xda11, 0xda23, 0xda36, 0xda47,
	0xda58, 0xda69, 0xda7a, 0xda8b, 0xda9c, 0xdaad, 0xdabf, 0xdad0,
	0xdae1, 0xdaf3, 0xdb04, 0xdb1b, 0xdb2d, 0xdb3f, 0xdb57, 0xdb70,
	0xdb87, 0xdb9a, 0xdbbe, 0xdbe0, 0xdc06, 0xdc2b, 0xdc60, 0xdc80,
	0xdca1, 0xdcc9, 0xdcfe, 0xdd31, 0xdd4c, 0xdd6d, 0xdd87, 0xdd9d,
	0xddc4, 0xddeb, 0xde11, 0xde2b, 0xde53, 0xde7a, 0xde9a, 0xdec1,
	0xdee8, 0xdf0e, 0xdf35, 0xdf6f, 0xdf88, 0xdfa1, 0xdfbb, 0xdfd8,
	0xdfed, 0xe002, 0xe017, 0xe038, 0xe058, 0xe07b, 0xe09a, 0xe0b8,
	// Entry 800 - 83F
	0xe0d4, 0xe0ee, 0xe10a, 0xe12b, 0xe147, 0xe162, 0xe17b, 0xe18d,
	0xe19f, 0xe1b1, 0xe1c6, 0xe1db, 0xe1f0, 0xe209, 0xe223, 0xe239,
	0xe252, 0xe26c, 0xe282, 0xe296, 0xe2aa, 0xe2be, 0xe2d3, 0xe2e9,
	0xe304, 0xe31f, 0xe33a, 0xe356, 0xe371, 0xe38d, 0xe3b0, 0xe3dc,
	0xe401, 0xe416, 0xe436, 0xe45a, 0xe475, 0xe48d, 0xe4a4, 0xe4bd,
	0xe4d0, 0xe4e4, 0xe4f7, 0xe50b, 0xe51e, 0xe532, 0xe54d, 0xe568,
	0xe582, 0xe59b, 0xe5ae, 0xe5c2, 0xe5dc, 0xe5f5, 0xe608, 0xe61c,
	0xe630, 0xe645, 0xe659, 0xe66e, 0xe683, 0xe697, 0xe6ac, 0xe6c0,
	// Entry 840 - 87F
	0xe6d5, 0xe6ea, 0xe6ff, 0xe715, 0xe72a, 0xe740, 0xe755, 0xe769,
	0xe77e, 0xe792, 0xe7a7, 0xe7bb, 0xe7d1, 0xe7e5, 0xe7fa, 0xe80e,
	0xe823, 0xe837, 0xe84b, 0xe85f, 0xe874, 0xe888, 0xe89d, 0xe8b3,
	0xe8c7, 0xe8dc, 0xe8f1, 0xe905, 0xe919, 0xe931, 0xe94a, 0xe95f,
	0xe977, 0xe98f, 0xe9a6, 0xe9be, 0xe9d5, 0xe9ed, 0xea0c, 0xea2c,
	0xea4a, 0xea67, 0xea7e, 0xea96, 0xeab4, 0xead1, 0xeae8, 0xeb00,
	0xeb16, 0xeb3b, 0xeb53, 0xeb60, 0xeb7d, 0xeb9c, 0xebb3, 0xebca,
	0xebed, 0xec05, 0xec1e, 0xec32, 0xec48, 0xec5e, 0xec72, 0xec89,
	// Entry 880 - 8BF
	0xec9e, 0xecb2, 0xecc7, 0xece3, 0xecff, 0xed1e, 0xed3e, 0xed4e,
	0xed65, 0xed7a, 0xed8e, 0xeda2, 0xedb8, 0xedcd, 0xede2, 0xedf6,
	0xee0c, 0xee22, 0xee37, 0xee53, 0xee73, 0xee8d, 0xeea1, 0xeeb6,
	0xeeca, 0xeede, 0xeef3, 0xef10, 0xef25, 0xef3f, 0xef54, 0xef69,
	0xef87, 0xef9d, 0xefb2, 0xefbe, 0xefd6, 0xefeb, 0xefff, 0xf00f,
	0xf020, 0xf030, 0xf041, 0xf051, 0xf062, 0xf07a, 0xf092, 0xf0a2,
	0xf0b3, 0xf0c3, 0xf0d4, 0xf0e5, 0xf0f7, 0xf108, 0xf11a, 0xf12c,
	0xf13d, 0xf14f, 0xf160, 0xf172, 0xf184, 0xf196, 0xf1a9, 0xf1bb,
	// Entry 8C0 - 8FF
	0xf1ce, 0xf1e0, 0xf1f1, 0xf203, 0xf214, 0xf226, 0xf237, 0xf248,
	0xf25a, 0xf26b, 0xf27d, 0xf28e, 0xf29f, 0xf2b0, 0xf2c1, 0xf2d3,
	0xf2e5, 0xf2f6, 0xf307, 0xf319, 0xf32e, 0xf343, 0xf357, 0xf36c,
	0xf380, 0xf395, 0xf3b1, 0xf3ce, 0xf3e2, 0xf3f7, 0xf40b, 0xf420,
	0xf433, 0xf44b, 0xf461, 0xf473, 0xf485, 0xf497, 0xf4b0, 0xf4c9,
	0xf4e5, 0xf502, 0xf514, 0xf525, 0xf536, 0xf549, 0xf55b, 0xf56d,
	0xf57e, 0xf591, 0xf5a4, 0xf5b6, 0xf5dc, 0xf601, 0xf613, 0xf625,
	0xf643, 0xf661, 0xf681, 0xf6a0, 0xf6d8, 0xf6fc, 0xf70a, 0xf71c,
	// Entry 900 - 93F
	0xf734, 0xf747, 0xf75c, 0xf76d, 0xf77f, 0xf790, 0xf7a2, 0xf7b3,
	0xf7c5, 0xf7d7, 0xf7e9, 0xf7fb, 0xf80d, 0xf81f, 0xf832, 0xf844,
	0xf857, 0xf86a, 0xf87c, 0xf88f, 0xf8a1, 0xf8b4, 0xf8c7, 0xf8da,
	0xf8ee, 0xf901, 0xf915, 0xf928, 0xf93a, 0xf94d, 0xf95f, 0xf972,
	0xf984, 0xf996, 0xf9a9, 0xf9bb, 0xf9ce, 0xf9e0, 0xf9f2, 0xfa04,
	0xfa16, 0xfa29, 0xfa3b, 0xfa4e, 0xfa60, 0xfa72, 0xfa85, 0xfa9b,
	0xfab0, 0xfac6, 0xfadb, 0xfaf1, 0xfb07, 0xfb1d, 0xfb33, 0xfb49,
	0xfb5d, 0xfb70, 0xfb84, 0xfb98, 0xfbaa, 0xfbbd, 0xfbcf, 0xfbe2,
	// Entry 940 - 97F
	0xfbf4, 0xfc06, 0xfc1a, 0xfc2d, 0xfc40, 0xfc52, 0xfc66, 0xfc7a,
	0xfc8d, 0xfc9b, 0xfca9, 0xfcb5, 0xfcc1, 0xfcd2, 0xfce6, 0xfcff,
	0xfd15, 0xfd2a, 0xfd3b, 0xfd4d, 0xfd5e, 0xfd70, 0xfd81, 0xfd93,
	0xfdac, 0xfdc5, 0xfddc, 0xfded, 0xfdff, 0xfe16, 0xfe27, 0xfe39,
	0xfe4b, 0xfe5e, 0xfe70, 0xfe83, 0xfe96, 0xfea8, 0xfebb, 0xfecd,
	0xfee0, 0xfef3, 0xff06, 0xff1a, 0xff2d, 0xff41, 0xff54, 0xff66,
	0xff79, 0xff8b, 0xff9e, 0xffb0, 0xffc2, 0xffd5, 0xffe7, 0xfffa,
	0x000c, 0x001e, 0x0030, 0x0042, 0x0055, 0x0067, 0x007a, 0x008d,
	// Entry 980 - 9BF
	0x009f, 0x00b1, 0x00c4, 0x00da, 0x00f0, 0x0105, 0x011b, 0x0130,
	0x0146, 0x0163, 0x0181, 0x019d, 0x01b2, 0x01c8, 0x01e4, 0x01f9,
	0x020f, 0x0223, 0x022e, 0x0248, 0x0262, 0x027f, 0x029d, 0x02b0,
	0x02c2, 0x02d4, 0x02e8, 0x02fb, 0x030e, 0x0320, 0x0334, 0x0348,
	0x035b, 0x0375, 0x0388, 0x039b, 0x03b1, 0x03c4, 0x03d6, 0x03e4,
	0x03f3, 0x0401, 0x0410, 0x041e, 0x042d, 0x0443, 0x0459, 0x0467,
	0x0476, 0x0484, 0x0493, 0x04a2, 0x04b2, 0x04c1, 0x04d1, 0x04e1,
	0x04f0, 0x0500, 0x050f, 0x051f, 0x052f, 0x053f, 0x0550, 0x0560,
	// Entry 9C0 - 9FF
	0x0571, 0x0581, 0x0590, 0x05a0, 0x05af, 0x05bf, 0x05ce, 0x05dd,
	0x05ed, 0x05fc, 0x060c, 0x061b, 0x062a, 0x0639, 0x0648, 0x0658,
	0x0667, 0x0677, 0x0687, 0x0696, 0x06a5, 0x06b5, 0x06c8, 0x06db,
	0x06ed, 0x0700, 0x0712, 0x0725, 0x073f, 0x075a, 0x076c, 0x077f,
	0x0791, 0x07a4, 0x07b5, 0x07c9, 0x07dd, 0x07ed, 0x07fd, 0x080d,
	0x0824, 0x083b, 0x0855, 0x0870, 0x0880, 0x088f, 0x089e, 0x08af,
	0x08bf, 0x08cf, 0x08de, 0x08ef, 0x0900, 0x0910, 0x091c, 0x092b,
	0x0945, 0x095c, 0x0979, 0x0995, 0x09ae, 0x09cd, 0x09e0, 0x09f2,
	// Entry A00 - A3F
	0x0a00, 0x0a0f, 0x0a1d, 0x0a2c, 0x0a3a, 0x0a49, 0x0a57, 0x0a66,
	0x0a75, 0x0a83, 0x0a92, 0x0aa1, 0x0ab0, 0x0ac0, 0x0acf, 0x0ade,
	0x0aee, 0x0afe, 0x0b0e, 0x0b1d, 0x0b2c, 0x0b3d, 0x0b4c, 0x0b5b,
	0x0b6a, 0x0b79, 0x0b89, 0x0b98, 0x0ba8, 0x0bb9, 0x0bc8, 0x0bd8,
	0x0be8, 0x0bf7, 0x0c06, 0x0c19, 0x0c2b, 0x0c3e, 0x0c50, 0x0c63,
	0x0c75, 0x0c88, 0x0c9b, 0x0cad, 0x0cc0, 0x0cd3, 0x0ce4, 0x0cec,
	0x0d00, 0x0d10, 0x0d1f, 0x0d2e, 0x0d3f, 0x0d4f, 0x0d5f, 0x0d6e,
	0x0d7f, 0x0d90, 0x0da0, 0x0db0, 0x0dc8, 0x0de1, 0x0def, 0x0dff,
	// Entry A40 - A7F
	0x0e0e, 0x0e1e, 0x0e2f, 0x0e42, 0x0e52, 0x0e63, 0x0e8a, 0x0ea1,
	0x0eb5, 0x0ec8, 0x0ed7, 0x0ee7, 0x0ef6, 0x0f06, 0x0f15, 0x0f25,
	0x0f3c, 0x0f53, 0x0f62, 0x0f72, 0x0f82, 0x0f91, 0x0fa1, 0x0fb1,
	0x0fc1, 0x0fd2, 0x0fe2, 0x0ff3, 0x1004, 0x1014, 0x1025, 0x1035,
	0x1046, 0x1057, 0x1068, 0x107a, 0x108b, 0x109d, 0x10ae, 0x10be,
	0x10cf, 0x10df, 0x10f0, 0x1100, 0x1110, 0x1121, 0x1131, 0x1142,
	0x1152, 0x1162, 0x1172, 0x1183, 0x1193, 0x11a4, 0x11b6, 0x11c6,
	0x11d7, 0x11e8, 0x11f8, 0x1208, 0x121c, 0x1230, 0x1243, 0x1257,
	// Entry A80 - ABF
	0x126a, 0x127e, 0x1299, 0x12b5, 0x12c8, 0x12dc, 0x12f0, 0x1303,
	0x1317, 0x132b, 0x133d, 0x134f, 0x1364, 0x1375, 0x1386, 0x1398,
	0x13b0, 0x13c8, 0x13e3, 0x13ff, 0x1410, 0x1420, 0x1430, 0x1442,
	0x1453, 0x1464, 0x1474, 0x1486, 0x1498, 0x14a9, 0x14da, 0x150a,
	0x153a, 0x156c, 0x159d, 0x15ce, 0x1601, 0x1612, 0x1632, 0x164a,
	0x165f, 0x1673, 0x1683, 0x1694, 0x16a4, 0x16b5, 0x16c5, 0x16d6,
	0x16ee, 0x1706, 0x1716, 0x1727, 0x1738, 0x1748, 0x1759, 0x176a,
	0x177b, 0x178d, 0x179e, 0x17b0, 0x17c2, 0x17d3, 0x17e5, 0x17f6,
	// Entry AC0 - AFF
	0x1808, 0x181a, 0x182c, 0x183f, 0x1851, 0x1864, 0x1876, 0x1887,
	0x1899, 0x18aa, 0x18bc, 0x18cd, 0x18de, 0x18f0, 0x1901, 0x1913,
	0x1924, 0x1935, 0x1946, 0x1958, 0x1969, 0x197b, 0x198c, 0x199e,
	0x19b0, 0x19c1, 0x19d2, 0x19e4, 0x19f9, 0x1a0e, 0x1a22, 0x1a37,
	0x1a4b, 0x1a60, 0x1a7c, 0x1a99, 0x1aad, 0x1ac2, 0x1ad7, 0x1aeb,
	0x1b00, 0x1b15, 0x1b28, 0x1b3b, 0x1b51, 0x1b62, 0x1b7b, 0x1b94,
	0x1bb0, 0x1bcd, 0x1bdf, 0x1bf0, 0x1c01, 0x1c14, 0x1c26, 0x1c38,
	0x1c49, 0x1c5c, 0x1c6f, 0x1c81, 0x1c99, 0x1cb1, 0x1ccb, 0x1ce2,
	// Entry B00 - B3F
	0x1cf8, 0x1d0a, 0x1d1d, 0x1d2f, 0x1d42, 0x1d54, 0x1d67, 0x1d81,
	0x1d9b, 0x1dad, 0x1dc0, 0x1dd3, 0x1de5, 0x1df8, 0x1e0b, 0x1e1e,
	0x1e32, 0x1e45, 0x1e59, 0x1e6d, 0x1e80, 0x1e94, 0x1ea7, 0x1ebb,
	0x1ecf, 0x1ee3, 0x1ef8, 0x1f0c, 0x1f21, 0x1f35, 0x1f48, 0x1f5c,
	0x1f6f, 0x1f83, 0x1f96, 0x1fab, 0x1fbe, 0x1fd2, 0x1fe5, 0x1ff9,
	0x200c, 0x201f, 0x2032, 0x2046, 0x2059, 0x206d, 0x2082, 0x2095,
	0x20a9, 0x20bd, 0x20d0, 0x20e3, 0x20f8, 0x210f, 0x2126, 0x213c,
	0x2153, 0x2169, 0x2180, 0x219e, 0x21bd, 0x21d3, 0x21ea, 0x2201,
	// Entry B40 - B7F
	0x2217, 0x222e, 0x2245, 0x225a, 0x2273, 0x2286, 0x229f, 0x22b8,
	0x22d3, 0x22eb, 0x231a, 0x2339, 0x235c, 0x237c, 0x2398, 0x23bb,
	0x23d7, 0x23f2, 0x240d, 0x2428, 0x2446, 0x2465, 0x2479, 0x248c,
	0x249f, 0x24b4, 0x24c8, 0x24dc, 0x24ef, 0x2504, 0x2519, 0x252d,
	0x2541, 0x255d, 0x257a, 0x2598, 0x25b3, 0x25d4, 0x25f4, 0x2611,
	0x2634, 0x2647, 0x2661, 0x267a, 0x2694, 0x26ad, 0x26c7, 0x26e0,
	0x26f7, 0x270d, 0x2722, 0x2738, 0x274e, 0x2765, 0x277a, 0x2790,
	0x27a5, 0x27bb, 0x27d2, 0x27ea, 0x2801, 0x2819, 0x282e, 0x2844,
	// Entry B80 - BBF
	0x285a, 0x286f, 0x2885, 0x289b, 0x28bc, 0x28de, 0x28ff, 0x2921,
	0x2942, 0x2960, 0x2981, 0x29a3, 0x29c4, 0x29e6, 0x2a07, 0x2a32,
	0x2a50, 0x2a72, 0x2a95, 0x2ab7, 0x2ada, 0x2afa, 0x2b19, 0x2b3a,
	0x2b5c, 0x2b7d, 0x2b9f, 0x2bbd, 0x2bdb, 0x2bfc, 0x2c1e, 0x2c3f,
	0x2c61, 0x2c77, 0x2c92, 0x2ca8, 0x2cbe, 0x2cdc, 0x2cf2, 0x2d10,
	0x2d30, 0x2d4e, 0x2d64, 0x2d84, 0x2d9a, 0x2db0, 0x2dcd, 0x2df0,
	0x2e12, 0x2e33, 0x2e53, 0x2e75, 0x2e96, 0x2eb5, 0x2ecf, 0x2eee,
	0x2f0b, 0x2f34, 0x2f62, 0x2f8c, 0x2faa, 0x2fc1, 0x2fd7, 0x2fed,
	// Entry BC0 - BFF
	0x3005, 0x301c, 0x3033, 0x3049, 0x3061, 0x3079, 0x3090, 0x30b4,
	0x30d7, 0x30f5, 0x310a, 0x3121, 0x3139, 0x3151, 0x3168, 0x3182,
	0x3198, 0x31af, 0x31c7, 0x31df, 0x31f3, 0x320a, 0x3220, 0x3237,
	0x324e, 0x3265, 0x3282, 0x329c, 0x32b1, 0x32c6, 0x32db, 0x32f3,
	0x330c, 0x3324, 0x3338, 0x3350, 0x3365, 0x337d, 0x3391, 0x33a8,
	0x33bd, 0x33d7, 0x33eb, 0x3400, 0x3415, 0x3426, 0x343c, 0x344d,
	0x3463, 0x3479, 0x348f, 0x34a4, 0x34b9, 0x34d0, 0x34e4, 0x34fc,
	0x3514, 0x3529, 0x3544, 0x355a, 0x3570, 0x3585, 0x359b, 0x35b1,
	// Entry C00 - C3F
	0x35c8, 0x35dd, 0x35f3, 0x3609, 0x3622, 0x3637, 0x364d, 0x3662,
	0x3680, 0x369f, 0x36b9, 0x36d0, 0x36e8, 0x36fd, 0x3713, 0x3729,
	0x3744, 0x375e, 0x3775, 0x378c, 0x37a2, 0x37b1, 0x37bf, 0x37cd,
	0x37dd, 0x37ec, 0x37fb, 0x3809, 0x3819, 0x3829, 0x3838, 0x3851,
	0x3866, 0x3873, 0x3886, 0x3898, 0x38a6, 0x38b3, 0x38c4, 0x38d2,
	0x38df, 0x38ec, 0x38ff, 0x3911, 0x391e, 0x392b, 0x3938, 0x394b,
	0x395c, 0x396e, 0x3980, 0x398d, 0x399a, 0x39ac, 0x39be, 0x39cb,
	0x39dd, 0x39ef, 0x39fb, 0x3a0c, 0x3a18, 0x3a28, 0x3a3e, 0x3a4f,
	// Entry C40 - C7F
	0x3a60, 0x3a70, 0x3a81, 0x3a91, 0x3aa2, 0x3ab2, 0x3ac3, 0x3ad9,
	0x3aee, 0x3b04, 0x3b14, 0x3b25, 0x3b35, 0x3b46, 0x3b57, 0x3b60,
	0x3b6f, 0x3b7f, 0x3b8e, 0x3ba1, 0x3bb6, 0x3bc3, 0x3bd1, 0x3bde,
	0x3beb, 0x3bfa, 0x3c08, 0x3c16, 0x3c23, 0x3c32, 0x3c41, 0x3c4f,
	0x3c58, 0x3c61, 0x3c73, 0x3c86, 0x3c99, 0x3cbe, 0x3ce8, 0x3d13,
	0x3d37, 0x3d5b, 0x3d82, 0x3da4, 0x3dbb, 0x3dd5, 0x3df3, 0x3e13,
	0x3e35, 0x3e46, 0x3e5c, 0x3e73, 0x3e8f, 0x3eb0, 0x3ecb, 0x3ef5,
	0x3f0c, 0x3f2c, 0x3f4c, 0x3f7b, 0x3f9e, 0x3fc4, 0x3fdf, 0x3ffb,
	// Entry C80 - CBF
	0x4016, 0x4030, 0x404b, 0x406a, 0x407c, 0x408d, 0x409e, 0x40b1,
	0x40c3, 0x40d5, 0x40e6, 0x40f9, 0x410c, 0x411e, 0x4134, 0x414a,
	0x4162, 0x4179, 0x4190, 0x41a6, 0x41be, 0x41d6, 0x41ed, 0x4204,
	0x421c, 0x423b, 0x4266, 0x4288, 0x429c, 0x42b2, 0x42cd, 0x42e8,
	0x4303, 0x431e, 0x4334, 0x434a, 0x435b, 0x436d, 0x437e, 0x4390,
	0x43a2, 0x43b3, 0x43c5, 0x43d6, 0x43e8, 0x43fa, 0x440d, 0x441f,
	0x4432, 0x4444, 0x4455, 0x4467, 0x4478, 0x448a, 0x449b, 0x44ac,
	0x44be, 0x44cf, 0x44e1, 0x44f2, 0x4504, 0x4517, 0x4529, 0x453c,
	// Entry CC0 - CFF
	0x454d, 0x455f, 0x4570, 0x4581, 0x4592, 0x45a3, 0x45b4, 0x45c6,
	0x45d8, 0x45e9, 0x45fa, 0x460a, 0x461d, 0x4639, 0x464b, 0x465d,
	0x4672, 0x4686, 0x469b, 0x46af, 0x46c4, 0x46e0, 0x46fd, 0x4719,
	0x4736, 0x474a, 0x475f, 0x4773, 0x4788, 0x47a3, 0x47b9, 0x47d6,
	0x47f4, 0x480f, 0x4824, 0x4838, 0x484b, 0x4861, 0x4878, 0x4890,
	0x48a5, 0x48c1, 0x48dd, 0x48fb, 0x491d, 0x493c, 0x4964, 0x497f,
	0x499b, 0x49b6, 0x49d2, 0x49ee, 0x4a09, 0x4a25, 0x4a40, 0x4a5c,
	0x4a78, 0x4a95, 0x4ab1, 0x4ace, 0x4aea, 0x4b05, 0x4b21, 0x4b3c,
	// Entry D00 - D3F
	0x4b58, 0x4b73, 0x4b8e, 0x4baa, 0x4bc5, 0x4be1, 0x4bfc, 0x4c18,
	0x4c35, 0x4c51, 0x4c6e, 0x4c89, 0x4ca5, 0x4cc0, 0x4cdb, 0x4cf6,
	0x4d11, 0x4d2c, 0x4d48, 0x4d64, 0x4d7f, 0x4d9a, 0x4db4, 0x4dd1,
	0x4df7, 0x4e1d, 0x4e43, 0x4e54, 0x4e72, 0x4e96, 0x4eba, 0x4edd,
	0x4f01, 0x4f17, 0x4f2d, 0x4f46, 0x4f66, 0x4f7c, 0x4f91, 0x4fb2,
	0x4fd3, 0x4ff4, 0x5013, 0x502d, 0x5051, 0x5074, 0x508b, 0x50bb,
	0x50eb, 0x5103, 0x511a, 0x513c, 0x515d, 0x517d, 0x519e, 0x51af,
	0x51c1, 0x51d2, 0x51e4, 0x51f6, 0x5207, 0x5219, 0x522a, 0x523c,
	// Entry D40 - D7F
	0x524e, 0x5261, 0x5273, 0x5286, 0x5298, 0x52ab, 0x52bd, 0x52ce,
	0x52e0, 0x52f1, 0x5303, 0x5314, 0x5325, 0x5337, 0x5348, 0x535a,
	0x536b, 0x537c, 0x538d, 0x539e, 0x53af, 0x53c0, 0x53d1, 0x53e3,
	0x53f3, 0x5408, 0x5418, 0x5429, 0x5439, 0x544a, 0x545a, 0x546e,
	0x547e, 0x548f, 0x54a9, 0x54be, 0x54d2, 0x54e7, 0x54fb, 0x5510,
	0x5524, 0x5539, 0x5552, 0x556a, 0x5584, 0x5599, 0x55af, 0x55c3,
	0x55d6, 0x55e7, 0x5607, 0x5627, 0x5647, 0x5667, 0x567e, 0x5690,
	0x56a1, 0x56b2, 0x56c5, 0x56d7, 0x56e9, 0x56fa, 0x570d, 0x5720,
	// Entry D80 - DBF
	0x5732, 0x574d, 0x5761, 0x5778, 0x5790, 0x57ad, 0x57c4, 0x57d6,
	0x57e8, 0x5800, 0x5819, 0x5831, 0x584a, 0x5866, 0x5883, 0x589f,
	0x58bc, 0x58d2, 0x58e8, 0x58fe, 0x5914, 0x5938, 0x595c, 0x5980,
	0x599d, 0x59bd, 0x59df, 0x5a02, 0x5a26, 0x5a4a, 0x5a71, 0x5a98,
	0x5abd, 0x5ae2, 0x5b07, 0x5b2c, 0x5b51, 0x5b75, 0x5b99, 0x5bbe,
	0x5bdd, 0x5bf8, 0x5c12, 0x5c2d, 0x5c43, 0x5c5a, 0x5c70, 0x5c86,
	0x5c9c, 0x5cb3, 0x5cc9, 0x5cdf, 0x5cf6, 0x5d0c, 0x5d22, 0x5d39,
	0x5d4f, 0x5d74, 0x5d8e, 0x5da7, 0x5dc6, 0x5de5, 0x5dfd, 0x5e15,
	// Entry DC0 - DFF
	0x5e2d, 0x5e45, 0x5e65, 0x5e85, 0x5eac, 0x5ecb, 0x5eec, 0x5f03,
	0x5f19, 0x5f2f, 0x5f47, 0x5f5e, 0x5f75, 0x5f8b, 0x5fa3, 0x5fbb,
	0x5fd2, 0x5fec, 0x6006, 0x6020, 0x603b, 0x6052, 0x6071, 0x608b,
	0x60a6, 0x60c1, 0x60dc, 0x60f6, 0x6111, 0x612c, 0x6147, 0x6161,
	0x617c, 0x6197, 0x61b2, 0x61cd, 0x61e7, 0x6202, 0x621e, 0x6239,
	0x6254, 0x626f, 0x6289, 0x62a5, 0x62c1, 0x62dd, 0x62f8, 0x6314,
	0x6330, 0x634b, 0x6366, 0x6381, 0x639d, 0x63b8, 0x63d4, 0x63ef,
	0x6409, 0x6424, 0x643e, 0x6459, 0x6474, 0x648e, 0x64a9, 0x64bb,
	// Entry E00 - E3F
	0x64ce, 0x64e1, 0x64f4, 0x6506, 0x6519, 0x652c, 0x653f, 0x6551,
	0x6564, 0x6577, 0x658a, 0x659d, 0x65af, 0x65c2, 0x65d6, 0x65e9,
	0x65fc, 0x660f, 0x6621, 0x6635, 0x6649, 0x665d, 0x6670, 0x6684,
	0x6698, 0x66ab, 0x66be, 0x66d1, 0x66e5, 0x66f8, 0x670c, 0x671f,
	0x6731, 0x6744, 0x6756, 0x6769, 0x677c, 0x678e, 0x67a0, 0x67b5,
	0x67cf, 0x67e2, 0x67fe, 0x681a, 0x682d, 0x6846, 0x6861, 0x6877,
	0x6892, 0x68a7, 0x68bd, 0x68d8, 0x68ed, 0x6902, 0x6917, 0x6931,
	0x6945, 0x695e, 0x6973, 0x6988, 0x69a2, 0x69b9, 0x69d0, 0x69e7,
	// Entry E40 - E7F
	0x69fe, 0x6a13, 0x6a2f, 0x6a49, 0x6a65, 0x6a80, 0x6a9d, 0x6ab8,
	0x6ad2, 0x6aed, 0x6b0a, 0x6b25, 0x6b42, 0x6b5e, 0x6b79, 0x6b95,
	0x6baf, 0x6bd0, 0x6bf1, 0x6c11, 0x6c30, 0x6c50, 0x6c6b, 0x6c88,
	0x6ca5, 0x6cc2, 0x6cdf, 0x6d01, 0x6d1c, 0x6d36, 0x6d51, 0x6d6b,
	0x6d85, 0x6d9f, 0x6dc0, 0x6dde, 0x6df8, 0x6e12, 0x6e2e, 0x6e4a,
	0x6e66, 0x6e82, 0x6e9c, 0x6eb8, 0x6ed9, 0x6ef8, 0x6f1c, 0x6f33,
	0x6f4f, 0x6f6b, 0x6f86, 0x6fa1, 0x6fbb, 0x6fd8, 0x6ff2, 0x700d,
	0x702a, 0x7047, 0x7064, 0x707c, 0x7097, 0x70b4, 0x70d6, 0x70f6,
	// Entry E80 - EBF
	0x711b, 0x713a, 0x7157, 0x7176, 0x7198, 0x71b5, 0x71d4, 0x71ee,
	0x7209, 0x7226, 0x7240, 0x725b, 0x7276, 0x7292, 0x72a8, 0x72bf,
	0x72d1, 0x72e4, 0x72f7, 0x730b, 0x731e, 0x7330, 0x7344, 0x7357,
	0x7369, 0x737c, 0x7390, 0x73a3, 0x73b6, 0x73c8, 0x73dc, 0x73ef,
	0x7402, 0x7415, 0x7428, 0x743b, 0x744d, 0x7461, 0x7475, 0x748a,
	0x74a0, 0x74b5, 0x74ca, 0x74e0, 0x74f6, 0x750c, 0x7521, 0x7535,
	0x754a, 0x755e, 0x7572, 0x7588, 0x759f, 0x75b6, 0x75cb, 0x75e0,
	0x75f4, 0x7609, 0x7621, 0x7636, 0x764a, 0x765f, 0x7675, 0x768a,
	// Entry EC0 - EFF
	0x76a1, 0x76b7, 0x76cc, 0x76e1, 0x76f6, 0x770c, 0x7721, 0x7735,
	0x774a, 0x775e, 0x7772, 0x7787, 0x779f, 0x77b5, 0x77ce, 0x77e6,
	0x77fe, 0x7819, 0x782e, 0x7843, 0x785a, 0x786f, 0x7885, 0x789c,
	0x78b8, 0x78d4, 0x78ea, 0x7906, 0x7922, 0x7939, 0x794f, 0x796c,
	0x7988, 0x79a4, 0x79bf, 0x79dd, 0x79fb, 0x7a17, 0x7a2d, 0x7a43,
	0x7a5e, 0x7a73, 0x7a8d, 0x7aa3, 0x7ab9, 0x7ad1, 0x7ae9, 0x7b01,
	0x7b19, 0x7b2f, 0x7b4c, 0x7b6f, 0x7b8c, 0x7ba9, 0x7bc4, 0x7be2,
	0x7c00, 0x7c1e, 0x7c3b, 0x7c5d, 0x7c79, 0x7c96, 0x7cb9, 0x7cd4,
	// Entry F00 - F3F
	0x7cf7, 0x7d18, 0x7d39, 0x7d5b, 0x7d7f, 0x7d9f, 0x7dbd, 0x7ddb,
	0x7dfd, 0x7e1a, 0x7e36, 0x7e52, 0x7e6d, 0x7e8d, 0x7eab, 0x7ec9,
	0x7ee5, 0x7f03, 0x7f1f, 0x7f3d, 0x7f59, 0x7f77, 0x7f93, 0x7faf,
	0x7fca, 0x7fe5, 0x7ffd, 0x801a, 0x803c, 0x8057, 0x8075, 0x808e,
	0x80ac, 0x80cd, 0x80eb, 0x810b, 0x8127, 0x8143, 0x815f, 0x817b,
	0x8197, 0x81b4, 0x81d1, 0x81f0, 0x820f, 0x822c, 0x8247, 0x825b,
	0x826f, 0x8283, 0x8298, 0x82ad, 0x82c1, 0x82d5, 0x82ea, 0x82fe,
	0x8312, 0x8326, 0x833b, 0x8350, 0x8364, 0x8378, 0x838d, 0x83a2,
	// Entry F40 - F7F
	0x83b7, 0x83cc, 0x83e2, 0x83f8, 0x840d, 0x8422, 0x8438, 0x844c,
	0x8460, 0x8474, 0x8489, 0x849e, 0x84b2, 0x84c6, 0x84db, 0x84f0,
	0x8505, 0x851a, 0x8530, 0x8546, 0x855b, 0x8570, 0x8586, 0x859a,
	0x85ae, 0x85c2, 0x85d7, 0x85ec, 0x8600, 0x8614, 0x8629, 0x863d,
	0x8651, 0x8665, 0x867a, 0x868f, 0x86a3, 0x86b7, 0x86cc, 0x86e1,
	0x86f6, 0x870b, 0x8721, 0x8737, 0x874c, 0x8761, 0x8777, 0x878b,
	0x879f, 0x87b3, 0x87c8, 0x87dd, 0x87f1, 0x8805, 0x881a, 0x882f,
	0x8844, 0x885a, 0x8870, 0x8885, 0x889a, 0x88af, 0x88c4, 0x88da,
	// Entry F80 - FBF
	0x88f0, 0x8905, 0x891a, 0x8930, 0x8946, 0x895d, 0x8974, 0x898a,
	0x899e, 0x89b2, 0x89c6, 0x89db, 0x89f0, 0x8a04, 0x8a18, 0x8a2d,
	0x8a41, 0x8a55, 0x8a69, 0x8a7e, 0x8a93, 0x8aa7, 0x8abb, 0x8ad0,
	0x8ae4, 0x8af8, 0x8b0c, 0x8b21, 0x8b36, 0x8b4a, 0x8b5e, 0x8b73,
	0x8b87, 0x8b9b, 0x8baf, 0x8bc4, 0x8bd9, 0x8bed, 0x8c01, 0x8c16,
	0x8c2a, 0x8c3e, 0x8c52, 0x8c67, 0x8c7c, 0x8c90, 0x8ca4, 0x8cb9,
	0x8cce, 0x8ce3, 0x8cf9, 0x8d0f, 0x8d24, 0x8d38, 0x8d4c, 0x8d60,
	0x8d75, 0x8d8a, 0x8d9e, 0x8db2, 0x8dc7, 0x8ddc, 0x8df1, 0x8e06,
	// Entry FC0 - FFF
	0x8e1c, 0x8e32, 0x8e47, 0x8e5c, 0x8e72, 0x8e8d, 0x8ea8, 0x8ec3,
	0x8edf, 0x8efb, 0x8f16, 0x8f31, 0x8f4d, 0x8f61, 0x8f75, 0x8f89,
	0x8f9e, 0x8fb3, 0x8fc7, 0x8fdb, 0x8ff0, 0x9005, 0x901a, 0x9030,
	0x9046, 0x905b, 0x9070, 0x9085, 0x909a, 0x90b0, 0x90c6, 0x90db,
	0x90f0, 0x9106, 0x911c, 0x9133, 0x914a, 0x9160, 0x9174, 0x9188,
	0x919c, 0x91b1, 0x91c6, 0x91da, 0x91ee, 0x9203, 0x9221, 0x923f,
	0x925d, 0x927c, 0x929b, 0x92b9, 0x92d7, 0x92eb, 0x92ff, 0x9313,
	0x9328, 0x933d, 0x9351, 0x9365, 0x937a, 0x938f, 0x93a4, 0x93b9,
	// Entry 1000 - 103F
	0x93cf, 0x93e5, 0x93fa, 0x940f, 0x9425, 0x9439, 0x944d, 0x9461,
	0x9476, 0x948b, 0x949f, 0x94b3, 0x94c8, 0x94dc, 0x94f0, 0x9504,
	0x9519, 0x952e, 0x9542, 0x9556, 0x956b, 0x9580, 0x9595, 0x95aa,
	0x95c0, 0x95d6, 0x95eb, 0x9600, 0x9616, 0x962a, 0x963e, 0x9652,
	0x9667, 0x967c, 0x9690, 0x96a4, 0x96b9, 0x96cd, 0x96e1, 0x96f5,
	0x970a, 0x971f, 0x9733, 0x9747, 0x975c, 0x9771, 0x9786, 0x979c,
	0x97b2, 0x97c7, 0x97dc, 0x97f1, 0x9806, 0x981c, 0x9832, 0x9847,
	0x985c, 0x9873, 0x9888, 0x989d, 0x98b2, 0x98c8, 0x98de, 0x98f3,
	// Entry 1040 - 107F
	0x9908, 0x991e, 0x9933, 0x9948, 0x995d, 0x9973, 0x9989, 0x999e,
	0x99b3, 0x99c9, 0x99de, 0x99f3, 0x9a08, 0x9a1e, 0x9a34, 0x9a49,
	0x9a5e, 0x9a74, 0x9a89, 0x9a9e, 0x9ab3, 0x9ac9, 0x9adf, 0x9af4,
	0x9b09, 0x9b1f, 0x9b34, 0x9b49, 0x9b5e, 0x9b74, 0x9b8a, 0x9b9f,
	0x9bb4, 0x9bca, 0x9bde, 0x9bf2, 0x9c06, 0x9c1b, 0x9c30, 0x9c44,
	0x9c58, 0x9c6d, 0x9c81, 0x9c95, 0x9ca9, 0x9cbe, 0x9cd3, 0x9ce7,
	0x9cfb, 0x9d10, 0x9d25, 0x9d3a, 0x9d4f, 0x9d82, 0x9da6, 0x9dc8,
	0x9ddd, 0x9def, 0x9e01, 0x9e0f, 0x9e21, 0x9e2f, 0x9e45, 0x9e5b,
	// Entry 1080 - 10BF
	0x9e77, 0x9e89, 0x9e9b, 0x9eaf, 0x9ec2, 0x9ed5, 0x9ee7, 0x9efb,
	0x9f0f, 0x9f22, 0x9f35, 0x9f4b, 0x9f61, 0x9f76, 0x9f8b, 0x9fa0,
	0x9fb7, 0x9fcd, 0x9fe3, 0x9ffa, 0xa016, 0xa035, 0xa04a, 0xa060,
	0xa075, 0xa094, 0xa0a9, 0xa0bf, 0xa0d4, 0xa0f3, 0xa108, 0xa11e,
	0xa133, 0xa152, 0xa167, 0xa17d, 0xa192, 0xa1ab, 0xa1c4, 0xa1de,
	0xa1fe, 0xa217, 0xa230, 0xa24a, 0xa263, 0xa282, 0xa29a, 0xa2ab,
	0xa2bc, 0xa2cd, 0xa2de, 0xa2ef, 0xa300, 0xa312, 0xa324, 0xa336,
	0xa348, 0xa35a, 0xa36c, 0xa37e, 0xa390, 0xa3a2, 0xa3b4, 0xa3c6,
	// Entry 10C0 - 10FF
	0xa3d8, 0xa3ea, 0xa3fc, 0xa40e, 0xa420, 0xa432, 0xa444, 0xa456,
	0xa468, 0xa47a, 0xa48c, 0xa49e, 0xa4b0, 0xa4c2, 0xa4d5, 0xa4e8,
	0xa4fa, 0xa50c, 0xa51e, 0xa530, 0xa542, 0xa555, 0xa568, 0xa57b,
	0xa58e, 0xa5a1, 0xa5b4, 0xa5c6, 0xa5d7, 0xa5e9, 0xa5fb, 0xa60d,
	0xa61f, 0xa631, 0xa643, 0xa655, 0xa667, 0xa679, 0xa68b, 0xa69d,
	0xa6af, 0xa6c1, 0xa6d3, 0xa6e6, 0xa6f9, 0xa70c, 0xa71f, 0xa732,
	0xa745, 0xa758, 0xa76b, 0xa77e, 0xa791, 0xa7a4, 0xa7b7, 0xa7ca,
	0xa7dc, 0xa7ee, 0xa800, 0xa812, 0xa824, 0xa836, 0xa848, 0xa85a,
	// Entry 1100 - 113F
	0xa86c, 0xa87e, 0xa890, 0xa8a2, 0xa8b4, 0xa8cc, 0xa8e4, 0xa8fc,
	0xa914, 0xa92c, 0xa944, 0xa95d, 0xa971, 0xa987, 0xa99b, 0xa9b0,
	0xa9c4, 0xa9d9, 0xa9f5, 0xaa12, 0xaa2e, 0xaa42, 0xaa57, 0xaa6c,
	0xaa8b, 0xaaa0, 0xaabf, 0xaad5, 0xaaf5, 0xab0a, 0xab29, 0xab3f,
	0xab5f, 0xab7d, 0xab92, 0xabb1, 0xabc7, 0xabe7, 0xac05, 0xac1a,
	0xac35, 0xac54, 0xac72, 0xac90, 0xacb9, 0xacdf, 0xad07, 0xad24,
	0xad49, 0xad7f, 0xada2, 0xadd2, 0xadef, 0xae11, 0xae26, 0xae3b,
	0xae50, 0xae65, 0xae7a, 0xae91, 0xaea6, 0xaebc, 0xaed1, 0xaee7,
	// Entry 1140 - 117F
	0xaf04, 0xaf22, 0xaf3f, 0xaf54, 0xaf6a, 0xaf80, 0xafa0, 0xafb6,
	0xafd6, 0xafed, 0xb00e, 0xb024, 0xb044, 0xb05b, 0xb07c, 0xb092,
	0xb0b2, 0xb0c9, 0xb0ea, 0xb108, 0xb11c, 0xb13a, 0xb156, 0xb16b,
	0xb182, 0xb197, 0xb1ad, 0xb1c2, 0xb1d8, 0xb1f5, 0xb213, 0xb230,
	0xb245, 0xb25b, 0xb271, 0xb291, 0xb2a7, 0xb2c7, 0xb2de, 0xb2ff,
	0xb315, 0xb335, 0xb34c, 0xb36d, 0xb383, 0xb3a3, 0xb3ba, 0xb3db,
	0xb3fa, 0xb40e, 0xb424, 0xb43a, 0xb450, 0xb466, 0xb47b, 0xb492,
	0xb4a7, 0xb4bd, 0xb4d2, 0xb4e8, 0xb505, 0xb51a, 0xb530, 0xb546,
	// Entry 1180 - 11BF
	0xb566, 0xb57c, 0xb59c, 0xb5b3, 0xb5d4, 0xb5ea, 0xb60a, 0xb621,
	0xb642, 0xb658, 0xb678, 0xb68f, 0xb6b0, 0xb6cf, 0xb6e3, 0xb6f8,
	0xb71b, 0xb73e, 0xb761, 0xb784, 0xb799, 0xb7b0, 0xb7c5, 0xb7db,
	0xb7f0, 0xb806, 0xb823, 0xb838, 0xb84e, 0xb864, 0xb884, 0xb89a,
	0xb8ba, 0xb8d1, 0xb8f2, 0xb908, 0xb928, 0xb93f, 0xb960, 0xb976,
	0xb996, 0xb9ad, 0xb9ce, 0xb9ed, 0xba01, 0xba1d, 0xba32, 0xba49,
	0xba5e, 0xba74, 0xba89, 0xba9f, 0xbabc, 0xbad1, 0xbae7, 0xbafd,
	0xbb1d, 0xbb33, 0xbb53, 0xbb6a, 0xbb8b, 0xbba1, 0xbbc1, 0xbbd8,
	// Entry 11C0 - 11FF
	0xbbf9, 0xbc0f, 0xbc2f, 0xbc46, 0xbc67, 0xbc86, 0xbc9a, 0xbcb8,
	0xbccd, 0xbcec, 0xbd07, 0xbd1c, 0xbd33, 0xbd48, 0xbd5e, 0xbd73,
	0xbd89, 0xbda6, 0xbdbb, 0xbdd1, 0xbde7, 0xbe07, 0xbe1d, 0xbe3d,
	0xbe54, 0xbe75, 0xbe94, 0xbea8, 0xbec5, 0xbeda, 0xbeef, 0xbf06,
	0xbf1b, 0xbf31, 0xbf46, 0xbf5c, 0xbf79, 0xbf8e, 0xbfa4, 0xbfba,
	0xbfda, 0xbff0, 0xc010, 0xc027, 0xc048, 0xc05e, 0xc07e, 0xc095,
	0xc0b6, 0xc0cc, 0xc0ec, 0xc103, 0xc124, 0xc138, 0xc156, 0xc171,
	0xc186, 0xc19d, 0xc1b2, 0xc1c8, 0xc1dd, 0xc1f3, 0xc210, 0xc225,
	// Entry 1200 - 123F
	0xc23b, 0xc251, 0xc271, 0xc287, 0xc2a7, 0xc2be, 0xc2df, 0xc2f5,
	0xc315, 0xc32c, 0xc34d, 0xc363, 0xc383, 0xc39a, 0xc3bb, 0xc3da,
	0xc3ee, 0xc40d, 0xc422, 0xc440, 0xc460, 0xc47e, 0xc49c, 0xc4bb,
	0xc4da, 0xc4f9, 0xc518, 0xc52e, 0xc544, 0xc55b, 0xc571, 0xc588,
	0xc59e, 0xc5b5, 0xc5cc, 0xc5ed, 0xc604, 0xc625, 0xc63d, 0xc65f,
	0xc676, 0xc697, 0xc6af, 0xc6d1, 0xc6e8, 0xc709, 0xc721, 0xc743,
	0xc758, 0xc76d, 0xc784, 0xc799, 0xc7af, 0xc7c4, 0xc7da, 0xc7f7,
	0xc80c, 0xc822, 0xc838, 0xc858, 0xc86e, 0xc88e, 0xc8a5, 0xc8c6,
	// Entry 1240 - 127F
	0xc8dc, 0xc8fc, 0xc913, 0xc934, 0xc94a, 0xc96a, 0xc981, 0xc9a2,
	0xc9c1, 0xc9d5, 0xc9f4, 0xca12, 0xca2e, 0xca43, 0xca5f, 0xca7e,
	0xca95, 0xcaaa, 0xcac0, 0xcad5, 0xcaeb, 0xcb0a, 0xcb1f, 0xcb35,
	0xcb54, 0xcb6b, 0xcb8c, 0xcba0, 0xcbbe, 0xcbd9, 0xcbee, 0xcc05,
	0xcc1a, 0xcc30, 0xcc45, 0xcc5b, 0xcc70, 0xcc86, 0xcc9d, 0xccbe,
	0xccd2, 0xcce8, 0xcd05, 0xcd1b, 0xcd38, 0xcd4f, 0xcd6d, 0xcd83,
	0xcd9a, 0xcdb0, 0xcdc7, 0xcddf, 0xce01, 0xce16, 0xce2d, 0xce44,
	0xce5b, 0xce72, 0xce88, 0xce9e, 0xceb4, 0xceca, 0xcee0, 0xcefd,
	// Entry 1280 - 12BF
	0xcf1a, 0xcf38, 0xcf55, 0xcf73, 0xcf90, 0xcfae, 0xcfca, 0xcfe6,
	0xcffb, 0xd012, 0xd027, 0xd03d, 0xd052, 0xd068, 0xd07d, 0xd093,
	0xd0a7, 0xd0be, 0xd0d5, 0xd0ec, 0xd103, 0xd122, 0xd141, 0xd160,
	0xd17f, 0xd197, 0xd1ad, 0xd1c4, 0xd1da, 0xd1f1, 0xd207, 0xd21e,
	0xd233, 0xd249, 0xd266, 0xd283, 0xd2a0, 0xd2bd, 0xd2de, 0xd2ff,
	0xd320, 0xd341, 0xd361, 0xd377, 0xd38e, 0xd3a4, 0xd3bb, 0xd3d1,
	0xd3e8, 0xd3fd, 0xd41b, 0xd439, 0xd458, 0xd476, 0xd495, 0xd4b3,
	0xd4d2, 0xd4ef, 0xd50b, 0xd529, 0xd547, 0xd565, 0xd583, 0xd5a2,
	// Entry 12C0 - 12FF
	0xd5c1, 0xd5e0, 0xd5ff, 0xd61e, 0xd63d, 0xd65c, 0xd67b, 0xd69a,
	0xd6b9, 0xd6d8, 0xd6f7, 0xd713, 0xd72f, 0xd74b, 0xd767, 0xd785,
	0xd7a3, 0xd7c1, 0xd7e0, 0xd7fe, 0xd81c, 0xd839, 0xd856, 0xd873,
	0xd891, 0xd8ae, 0xd8cb, 0xd8e8, 0xd905, 0xd922, 0xd940, 0xd95d,
	0xd97a, 0xd998, 0xd9b6, 0xd9d4, 0xd9f3, 0xda11, 0xda2f, 0xda4d,
	0xda6b, 0xda89, 0xdaa8, 0xdac6, 0xdae4, 0xdb02, 0xdb20, 0xdb3e,
	0xdb5d, 0xdb7b, 0xdb99, 0xdbb6, 0xdbd3, 0xdbf0, 0xdc0e, 0xdc2b,
	0xdc48, 0xdc64, 0xdc81, 0xdc9e, 0xdcbb, 0xdcd9, 0xdcf6, 0xdd13,
	// Entry 1300 - 133F
	0xdd31, 0xdd4f, 0xdd6d, 0xdd8c, 0xddaa, 0xddc8, 0xdde6, 0xde04,
	0xde22, 0xde41, 0xde5f, 0xde7d, 0xde9a, 0xdeb7, 0xded4, 0xdef1,
	0xdf0f, 0xdf2c, 0xdf49, 0xdf66, 0xdf83, 0xdfa0, 0xdfbe, 0xdfdb,
	0xdff8, 0xe015, 0xe032, 0xe04f, 0xe06d, 0xe08a, 0xe0a7, 0xe0c4,
	0xe0e0, 0xe0fd, 0xe11a, 0xe138, 0xe155, 0xe171, 0xe18e, 0xe1ac,
	0xe1ca, 0xe1e8, 0xe207, 0xe225, 0xe243, 0xe260, 0xe27d, 0xe29a,
	0xe2b8, 0xe2d5, 0xe2f2, 0xe310, 0xe32e, 0xe34c, 0xe36b, 0xe389,
	0xe3a7, 0xe3c5, 0xe3e3, 0xe401, 0xe420, 0xe43e, 0xe45c, 0xe47b,
	// Entry 1340 - 137F
	0xe49a, 0xe4b9, 0xe4d9, 0xe4f8, 0xe517, 0xe535, 0xe553, 0xe571,
	0xe590, 0xe5ae, 0xe5cc, 0xe5e9, 0xe606, 0xe623, 0xe641, 0xe65e,
	0xe67b, 0xe697, 0xe6bb, 0xe6d9, 0xe6f7, 0xe715, 0xe734, 0xe752,
	0xe770, 0xe78d, 0xe7aa, 0xe7c7, 0xe7e5, 0xe802, 0xe81f, 0xe83d,
	0xe85b, 0xe879, 0xe898, 0xe8b6, 0xe8d4, 0xe8f1, 0xe90f, 0xe92d,
	0xe94b, 0xe96a, 0xe988, 0xe9a6, 0xe9c4, 0xe9e2, 0xea00, 0xea1f,
	0xea3d, 0xea5b, 0xea7a, 0xea99, 0xeab8, 0xead8, 0xeaf7, 0xeb16,
	0xeb31, 0xeb4d, 0xeb63, 0xeb7a, 0xeb91, 0xeba9, 0xebc0, 0xebd8,
	// Entry 1380 - 13BF
	0xebef, 0xec07, 0xec2a, 0xec4c, 0xec6f, 0xec91, 0xecb4, 0xecd6,
	0xecf9, 0xed1f, 0xed3d, 0xed4d, 0xed5f, 0xed70, 0xed82, 0xed93,
	0xeda4, 0xedb5, 0xedc6, 0xedd8, 0xede9, 0xedfb, 0xee0c, 0xee1d,
	0xee31, 0xee44, 0xee55, 0xee66, 0xee76, 0xee85, 0xee99, 0xeead,
	0xeec1, 0xeed0, 0xeee5, 0xeef6, 0xef0e, 0xef20, 0xef32, 0xef4d,
	0xef68, 0xef76, 0xef8c, 0xef9b, 0xefa9, 0xefb7, 0xefd8, 0xefe8,
	0xeffc, 0xf00d, 0xf01e, 0xf02f, 0xf04d, 0xf06a, 0xf078, 0xf087,
	0xf096, 0xf0b3, 0xf0c5, 0xf0d5, 0xf0e8, 0xf0f6, 0xf106, 0xf11e,
	// Entry 13C0 - 13FF
	0xf12e, 0xf147, 0xf15c, 0xf170, 0xf191, 0xf1b1, 0xf1cf, 0xf1ed,
	0xf202, 0xf21c, 0xf22a, 0xf23e, 0xf24e, 0xf26c, 0xf288, 0xf29d,
	0xf2b9, 0xf2d1, 0xf2e6, 0xf30a, 0xf327, 0xf335, 0xf343, 0xf35f,
	0xf37c, 0xf38a, 0xf3af, 0xf3d0, 0xf3e5, 0xf3f8, 0xf40f, 0xf428,
	0xf447, 0xf465, 0xf484, 0xf499, 0xf4ac, 0xf4bc, 0xf4d5, 0xf4f1,
	0xf501, 0xf511, 0xf525, 0xf536, 0xf548, 0xf559, 0xf574, 0xf58e,
	0xf5a7, 0xf5b5, 0xf5c3, 0xf5db, 0xf5f5, 0xf60c, 0xf61f, 0xf634,
	0xf649, 0xf657, 0xf666, 0xf675, 0xf692, 0xf6af, 0xf6cc, 0xf6e9,
	// Entry 1400 - 143F
	0xf708, 0xf718, 0xf728, 0xf738, 0xf749, 0xf75a, 0xf76c, 0xf77d,
	0xf78e, 0xf79f, 0xf7b0, 0xf7c1, 0xf7d2, 0xf7e3, 0xf7f4, 0xf805,
	0xf816, 0xf827, 0xf83b, 0xf84f, 0xf862, 0xf872, 0xf882, 0xf892,
	0xf8a3, 0xf8b4, 0xf8c6, 0xf8d7, 0xf8e8, 0xf8f9, 0xf90a, 0xf91b,
	0xf92c, 0xf93d, 0xf94e, 0xf95f, 0xf970, 0xf981, 0xf992, 0xf9a6,
	0xf9ba, 0xf9cf, 0xf9ec, 0xfa09, 0xfa17, 0xfa25, 0xfa33, 0xfa42,
	0xfa51, 0xfa61, 0xfa70, 0xfa7f, 0xfa8e, 0xfa9d, 0xfaac, 0xfabb,
	0xfaca, 0xfad9, 0xfae8, 0xfaf7, 0xfb06, 0xfb15, 0xfb27, 0xfb39,
	// Entry 1440 - 147F
	0xfb4a, 0xfb5b, 0xfb6c, 0xfb7e, 0xfb90, 0xfba3, 0xfbb5, 0xfbc7,
	0xfbd9, 0xfbeb, 0xfbfd, 0xfc0f, 0xfc21, 0xfc33, 0xfc45, 0xfc57,
	0xfc6c, 0xfc81, 0xfc90, 0xfca0, 0xfcaf, 0xfcbf, 0xfccf, 0xfcde,
	0xfcee, 0xfcfd, 0xfd0d, 0xfd1d, 0xfd2c, 0xfd3d, 0xfd4c, 0xfd5d,
	0xfd6d, 0xfd7c, 0xfd8c, 0xfd9b, 0xfdab, 0xfdba, 0xfdc9, 0xfdd9,
	0xfde8, 0xfdf8, 0xfe07, 0xfe16, 0xfe25, 0xfe34, 0xfe43, 0xfe53,
	0xfe63, 0xfe72, 0xfe81, 0xfe90, 0xfe9f, 0xfeba, 0xfed5, 0xfeef,
	0xff0a, 0xff24, 0xff3f, 0xff5a, 0xff76, 0xff90, 0xffab, 0xffc5,
	// Entry 1480 - 14BF
	0xffe0, 0xfffa, 0x0015, 0x0039, 0x005d, 0x0078, 0x008f, 0x00a6,
	0x00b9, 0x00cb, 0x00de, 0x00f0, 0x0103, 0x0115, 0x0128, 0x013b,
	0x014e, 0x0161, 0x0174, 0x0186, 0x0199, 0x01ac, 0x01bf, 0x01d2,
	0x01e4, 0x01f6, 0x020e, 0x0224, 0x0236, 0x0247, 0x0257, 0x026d,
	0x027f, 0x028f, 0x02a7, 0x02b8, 0x02c8, 0x02dd, 0x02ec, 0x0301,
	0x031b, 0x032d, 0x033e, 0x0354, 0x0366, 0x0380, 0x0398, 0x03ab,
	0x03bb, 0x03ca, 0x03d9, 0x03ea, 0x03fa, 0x040a, 0x0419, 0x042a,
	0x043b, 0x044b, 0x0465, 0x0480, 0x049a, 0x04b4, 0x04cf, 0x04ea,
	// Entry 14C0 - 14FF
	0x050a, 0x0529, 0x0548, 0x0568, 0x0577, 0x0589, 0x0598, 0x05ab,
	0x05ba, 0x05cd, 0x05e7, 0x060e, 0x0624, 0x063e, 0x064e, 0x0673,
	0x0698, 0x06bf, 0x06d8, 0x06ec, 0x06ff, 0x0712, 0x0727, 0x073b,
	0x074f, 0x0762, 0x0777, 0x078c, 0x07a0, 0x07b2, 0x07c4, 0x07d6,
	0x07e8, 0x07fa, 0x080d, 0x0820, 0x0833, 0x0846, 0x085a, 0x086d,
	0x0880, 0x0893, 0x08a6, 0x08b9, 0x08cc, 0x08df, 0x08f3, 0x0906,
	0x0919, 0x092d, 0x0940, 0x0953, 0x0966, 0x0979, 0x098c, 0x099f,
	0x09b3, 0x09c7, 0x09da, 0x09ee, 0x0a02, 0x0a16, 0x0a2a, 0x0a3e,
	// Entry 1500 - 153F
	0x0a63, 0x0a7a, 0x0a91, 0x0aa8, 0x0abf, 0x0ad7, 0x0aef, 0x0b08,
	0x0b20, 0x0b38, 0x0b50, 0x0b68, 0x0b80, 0x0b98, 0x0bb0, 0x0bc9,
	0x0be1, 0x0bfa, 0x0c12, 0x0c2a, 0x0c42, 0x0c5b, 0x0c74, 0x0c8d,
	0x0ca6, 0x0cbf, 0x0cd6, 0x0ced, 0x0d05, 0x0d1d, 0x0d34, 0x0d4d,
	0x0d65, 0x0d7d, 0x0d95, 0x0dad, 0x0dc6, 0x0dde, 0x0df6, 0x0e0e,
	0x0e26, 0x0e3f, 0x0e58, 0x0e71, 0x0e89, 0x0ea2, 0x0ebb, 0x0ed4,
	0x0eed, 0x0f07, 0x0f21, 0x0f3b, 0x0f56, 0x0f7c, 0x0fa1, 0x0fc1,
	0x0fe2, 0x100c, 0x102c, 0x1052, 0x106d, 0x1088, 0x10a4, 0x10c1,
	// Entry 1540 - 157F
	0x10dd, 0x10fa, 0x1118, 0x1135, 0x1152, 0x116e, 0x118a, 0x11a6,
	0x11c3, 0x11e0, 0x11fd, 0x1219, 0x1235, 0x1256, 0x1278, 0x129c,
	0x12c0, 0x12e3, 0x1307, 0x132b, 0x1350, 0x1373, 0x1397, 0x13bb,
	0x13df, 0x1403, 0x1426, 0x1446, 0x1467, 0x148b, 0x14ac, 0x14d0,
	0x14e5, 0x14fa, 0x1510, 0x1526, 0x153c, 0x1552, 0x1569, 0x157f,
	0x1595, 0x15ac, 0x15c2, 0x15d8, 0x15ee, 0x1604, 0x161a, 0x1630,
	0x1647, 0x165e, 0x1676, 0x168c, 0x16a2, 0x16b8, 0x16ce, 0x16ec,
	0x1703, 0x1722, 0x1738, 0x1756, 0x176d, 0x178c, 0x17a3, 0x17b9,
	// Entry 1580 - 15BF
	0x17d0, 0x17e6, 0x17fd, 0x1813, 0x182f, 0x184b, 0x1867, 0x1883,
	0x189f, 0x18bb, 0x18d7, 0x18f4, 0x1910, 0x192c, 0x194f, 0x1972,
	0x198f, 0x19af, 0x19cf, 0x19e6, 0x19fd, 0x1a15, 0x1a2d, 0x1a45,
	0x1a5d, 0x1a75, 0x1a93, 0x1ab1, 0x1ace, 0x1aec, 0x1b0f, 0x1b2d,
	0x1b4b, 0x1b68, 0x1b86, 0x1ba6, 0x1bc6, 0x1be9, 0x1c03, 0x1c12,
	0x1c22, 0x1c31, 0x1c41, 0x1c51, 0x1c60, 0x1c70, 0x1c7f, 0x1c8f,
	0x1c9f, 0x1cae, 0x1cbe, 0x1ccd, 0x1cdd, 0x1cec, 0x1cfb, 0x1d0b,
	0x1d1a, 0x1d2a, 0x1d39, 0x1d48, 0x1d57, 0x1d66, 0x1d75, 0x1d85,
	// Entry 15C0 - 15FF
	0x1d95, 0x1da4, 0x1db3, 0x1dc4, 0x1dd4, 0x1de6, 0x1df8, 0x1e0a,
	0x1e1d, 0x1e30, 0x1e43, 0x1e56, 0x1e68, 0x1e7a, 0x1e93, 0x1eac,
	0x1ec5, 0x1eda, 0x1ef0, 0x1f0b, 0x1f20, 0x1f35, 0x1f4a, 0x1f5f,
	0x1f74, 0x1f89, 0x1f9d, 0x1fb1, 0x1fc0, 0x1fce, 0x1fe4, 0x1ff7,
	0x2007, 0x2016, 0x2025, 0x2036, 0x2046, 0x2056, 0x2065, 0x2076,
	0x2087, 0x2097, 0x20a7, 0x20b7, 0x20c8, 0x20d9, 0x20e9, 0x20f9,
	0x2109, 0x211a, 0x212a, 0x213a, 0x214b, 0x215b, 0x216b, 0x217b,
	0x218b, 0x219b, 0x21ac, 0x21be, 0x21ce, 0x21dd, 0x21ec, 0x21fc,
	// Entry 1600 - 163F
	0x220c, 0x221b, 0x222b, 0x223a, 0x224a, 0x2259, 0x226a, 0x227a,
	0x228e, 0x22a2, 0x22b6, 0x22ca, 0x22de, 0x22f8, 0x2311, 0x232b,
	0x2345, 0x2360, 0x2379, 0x2392, 0x23ac, 0x23c7, 0x23e1, 0x23fb,
	0x2415, 0x242e, 0x2447, 0x2461, 0x247c, 0x2496, 0x24af, 0x24c9,
	0x24e2, 0x24fc, 0x2517, 0x2531, 0x254a, 0x2564, 0x257d, 0x2597,
	0x25b1, 0x25cb, 0x25e4, 0x25fd, 0x2616, 0x2630, 0x264a, 0x2664,
	0x267d, 0x2696, 0x26af, 0x26ca, 0x26e5, 0x26ff, 0x2719, 0x2734,
	0x274e, 0x2774, 0x278d, 0x27a6, 0x27be, 0x27d7, 0x27ef, 0x2808,
	// Entry 1640 - 167F
	0x2820, 0x2839, 0x2852, 0x286b, 0x2885, 0x289e, 0x28b7, 0x28d1,
	0x28eb, 0x2904, 0x291e, 0x2939, 0x2953, 0x296d, 0x2987, 0x29a1,
	0x29bb, 0x29d2, 0x29e9, 0x29ff, 0x2a14, 0x2a29, 0x2a40, 0x2a56,
	0x2a6c, 0x2a81, 0x2a98, 0x2aaf, 0x2ac5, 0x2adf, 0x2af3, 0x2b08,
	0x2b1f, 0x2b35, 0x2b4a, 0x2b5f, 0x2b75, 0x2b8b, 0x2ba6, 0x2bc0,
	0x2bda, 0x2bf5, 0x2c0a, 0x2c24, 0x2c3d, 0x2c56, 0x2c70, 0x2c8a,
	0x2ca0, 0x2cb5, 0x2cc9, 0x2cdd, 0x2cf2, 0x2d07, 0x2d21, 0x2d3a,
	0x2d53, 0x2d6d, 0x2d81, 0x2d9a, 0x2db2, 0x2dca, 0x2de3, 0x2dfc,
	// Entry 1680 - 16BF
	0x2e0e, 0x2e20, 0x2e33, 0x2e47, 0x2e59, 0x2e6b, 0x2e7d, 0x2e90,
	0x2ea2, 0x2eb4, 0x2ec6, 0x2ed9, 0x2eeb, 0x2efd, 0x2f10, 0x2f24,
	0x2f36, 0x2f48, 0x2f5a, 0x2f6c, 0x2f7e, 0x2f8f, 0x2fa1, 0x2fb6,
	0x2fcb, 0x2fe0, 0x2ff5, 0x300b, 0x301b, 0x3032, 0x3049, 0x3061,
	0x3079, 0x308f, 0x30a6, 0x30bd, 0x30d0, 0x30e7, 0x30ff, 0x3115,
	0x312b, 0x3142, 0x3155, 0x3169, 0x3183, 0x3195, 0x31ae, 0x31c2,
	0x31d9, 0x31f1, 0x3207, 0x321e, 0x3230, 0x3242, 0x3259, 0x3271,
	0x3288, 0x329e, 0x32b4, 0x32cb, 0x32dd, 0x32f3, 0x330a, 0x331c,
	// Entry 16C0 - 16FF
	0x332f, 0x3341, 0x3354, 0x3366, 0x337e, 0x3396, 0x33ad, 0x33c4,
	0x33d7, 0x33e8, 0x33fe, 0x340f, 0x3421, 0x3432, 0x3444, 0x3456,
	0x3468, 0x347b, 0x3493, 0x34b4, 0x34d5, 0x34f8, 0x3512, 0x3533,
	0x3551, 0x357d, 0x3597, 0x35b1, 0x35cb, 0x35de, 0x35f3, 0x360e,
	0x3624, 0x363f, 0x3654, 0x366a, 0x3680, 0x3697, 0x36ac, 0x36c2,
	0x36d7, 0x36f3, 0x3709, 0x371e, 0x3734, 0x374a, 0x3760, 0x377b,
	0x3797, 0x37ad, 0x37c1, 0x37d5, 0x37ef, 0x3809, 0x3823, 0x3838,
	0x384d, 0x386a, 0x388e, 0x38a6, 0x38bd, 0x38d4, 0x38ed, 0x3905,
	// Entry 1700 - 173F
	0x391d, 0x3934, 0x394d, 0x3966, 0x397e, 0x3996, 0x39ad, 0x39c4,
	0x39dd, 0x39f5, 0x3a0d, 0x3a24, 0x3a3d, 0x3a56, 0x3a6e, 0x3a81,
	0x3a98, 0x3aab, 0x3abd, 0x3ace, 0x3ae2, 0x3b05, 0x3b1c, 0x3b2e,
	0x3b43, 0x3b58, 0x3b70, 0x3b82, 0x3b95, 0x3bb8, 0x3bd0, 0x3be2,
	0x3bfb, 0x3c0f, 0x3c22, 0x3c3d, 0x3c56, 0x3c76, 0x3ca1, 0x3ccd,
	0x3ce8, 0x3d0a, 0x3d25, 0x3d42, 0x3d59, 0x3d71, 0x3d84, 0x3d98,
	0x3dab, 0x3dc0, 0x3ddc, 0x3df1, 0x3e0d, 0x3e22, 0x3e3e, 0x3e55,
	0x3e73, 0x3e8b, 0x3eaa, 0x3ebf, 0x3ed5, 0x3eea, 0x3f06, 0x3f18,
	// Entry 1740 - 177F
	0x3f34, 0x3f46, 0x3f5d, 0x3f70, 0x3f82, 0x3f99, 0x3fab, 0x3fc2,
	0x3fd5, 0x3fed, 0x400f, 0x4031, 0x4053, 0x406c, 0x407e, 0x4095,
	0x40a7, 0x40be, 0x40d0, 0x40e2, 0x40fa, 0x410c, 0x4126, 0x4138,
	0x414a, 0x415c, 0x416e, 0x4180, 0x4197, 0x41ae, 0x41c0, 0x41d2,
	0x41e7, 0x4201, 0x4218, 0x4234, 0x424c, 0x4269, 0x4284, 0x42a6,
	0x42c2, 0x42e5, 0x42ff, 0x431e, 0x433f, 0x4365, 0x437e, 0x439e,
	0x43b0, 0x43c9, 0x43e3, 0x43fd, 0x4415, 0x442d, 0x4446, 0x4462,
	0x4475, 0x4487, 0x4499, 0x44ad, 0x44c0, 0x44d3, 0x44e5, 0x44f9,
	// Entry 1780 - 17BF
	0x450d, 0x4520, 0x452e, 0x453d, 0x454b, 0x4563, 0x4576, 0x458c,
	0x459d, 0x45b9, 0x45d5, 0x45f1, 0x460d, 0x4630, 0x464c, 0x4669,
	0x4686, 0x46a3, 0x46c4, 0x46eb, 0x4712, 0x473a, 0x4762, 0x478b,
	0x47c0, 0x47f5, 0x481c, 0x4842, 0x486d, 0x4898, 0x48c5, 0x48f2,
	0x491d, 0x4948, 0x4975, 0x49a2, 0x49cd, 0x49e4, 0x49fc, 0x4a14,
	0x4a26, 0x4a38, 0x4a4a, 0x4a5d, 0x4a6f, 0x4a81, 0x4a94, 0x4aa7,
	0x4aba, 0x4acd, 0x4ae1, 0x4af4, 0x4b07, 0x4b1a, 0x4b2e, 0x4b41,
	0x4b54, 0x4b67, 0x4b7a, 0x4b8d, 0x4ba0, 0x4bb3, 0x4bc6, 0x4bd9,
	// Entry 17C0 - 17FF
	0x4bec, 0x4bff, 0x4c12, 0x4c25, 0x4c38, 0x4c4b, 0x4c6d, 0x4c8e,
	0x4cae, 0x4ccb, 0x4ce7, 0x4d06, 0x4d23, 0x4d3f, 0x4d5e, 0x4d74,
	0x4d89, 0x4dad, 0x4dd1, 0x4de5, 0x4df9, 0x4e0d, 0x4e20, 0x4e33,
	0x4e48, 0x4e5c, 0x4e70, 0x4e83, 0x4e98, 0x4ead, 0x4ec1, 0x4ed3,
	0x4ee7, 0x4efb, 0x4f0f, 0x4f27, 0x4f3f, 0x4f4d, 0x4f66, 0x4f75,
	0x4f8f, 0x4fa9, 0x4fb8, 0x4fcc, 0x4fdb, 0x4ff5, 0x5004, 0x501e,
	0x502d, 0x5047, 0x505d, 0x506c, 0x5086, 0x5095, 0x50a4, 0x50b3,
	0x50cd, 0x50dc, 0x50f6, 0x510e, 0x5126, 0x5135, 0x514f, 0x5169,
	// Entry 1800 - 183F
	0x5178, 0x5192, 0x51a2, 0x51b1, 0x51cb, 0x51db, 0x51ea, 0x51fa,
	0x520a, 0x5218, 0x5226, 0x5236, 0x5248, 0x5261, 0x5274, 0x5286,
	0x529d, 0x52af, 0x52c6, 0x52d8, 0x52fc, 0x5313, 0x5329, 0x5337,
	0x5347, 0x5362, 0x537f, 0x5397, 0x53b2, 0x53c2, 0x53d3, 0x53e4,
	0x53f4, 0x5405, 0x5416, 0x5426, 0x5437, 0x5447, 0x5458, 0x5468,
	0x5479, 0x5489, 0x5499, 0x54a9, 0x54ba, 0x54cb, 0x54db, 0x54ec,
	0x54fc, 0x550d, 0x551d, 0x552e, 0x553f, 0x5551, 0x5562, 0x5572,
	0x5582, 0x5592, 0x55a2, 0x55b3, 0x55c3, 0x55d3, 0x55e4, 0x55f4,
	// Entry 1840 - 187F
	0x5603, 0x561d, 0x5637, 0x564b, 0x565e, 0x5671, 0x5685, 0x5698,
	0x56ac, 0x56bf, 0x56d6, 0x56ed, 0x5704, 0x571b, 0x5732, 0x5749,
	0x5760, 0x577d, 0x5797, 0x57a6, 0x57b7, 0x57d0, 0x57f5, 0x580e,
	0x582e, 0x5847, 0x5858, 0x5868, 0x5878, 0x588a, 0x589b, 0x58ac,
	0x58bc, 0x58ce, 0x58e0, 0x58f1, 0x5902, 0x5914, 0x5925, 0x5938,
	0x594a, 0x595c, 0x5970, 0x5983, 0x5996, 0x59a8, 0x59bc, 0x59d0,
	0x59e3, 0x59f5, 0x5a07, 0x5a19, 0x5a2c, 0x5a3e, 0x5a51, 0x5a64,
	0x5a77, 0x5a8a, 0x5a9d, 0x5aaf, 0x5ac1, 0x5ad3, 0x5ae6, 0x5af8,
	// Entry 1880 - 18BF
	0x5b0a, 0x5b1c, 0x5b2e, 0x5b41, 0x5b53, 0x5b65, 0x5b77, 0x5b8a,
	0x5b9c, 0x5baf, 0x5bc1, 0x5bd4, 0x5be6, 0x5bf8, 0x5c0a, 0x5c1d,
	0x5c36, 0x5c52, 0x5c60, 0x5c71, 0x5c7e, 0x5c99, 0x5cbb, 0x5cdb,
	0x5cff, 0x5d1d, 0x5d3a, 0x5d57, 0x5d7c, 0x5da0, 0x5dbe, 0x5de0,
	0x5e01, 0x5e25, 0x5e48, 0x5e69, 0x5e90, 0x5eb6, 0x5edc, 0x5f02,
	0x5f15, 0x5f25, 0x5f37, 0x5f4b, 0x5f70, 0x5fa4, 0x5fcd, 0x5ffe,
	0x6015, 0x6050, 0x6069, 0x6082, 0x609d, 0x60b1, 0x60ca, 0x60e5,
	0x6115, 0x6140, 0x615a, 0x6173, 0x6195, 0x61b0, 0x61d4, 0x61f7,
	// Entry 18C0 - 18FF
	0x621c, 0x623c, 0x625c, 0x627b, 0x62a4, 0x62b5, 0x62d6, 0x62ee,
	0x630d, 0x632f, 0x6346, 0x6365, 0x637c, 0x6392, 0x63a8, 0x63bd,
	0x63d9, 0x63f5, 0x6412, 0x642e, 0x6451, 0x646d, 0x6489, 0x64a7,
	0x64c3, 0x64e3, 0x64fe, 0x651a, 0x6536, 0x655e, 0x657a, 0x659f,
	0x65bb, 0x65dc, 0x65f9, 0x661b, 0x6644, 0x6660, 0x667d, 0x669a,
	0x66ba, 0x66d6, 0x66fb, 0x671e, 0x673a, 0x6756, 0x6773, 0x679c,
	0x67c0, 0x67dc, 0x67f8, 0x6814, 0x6832, 0x6857, 0x6867, 0x6887,
	0x68a7, 0x68c4, 0x68e2, 0x6900, 0x6920, 0x6939, 0x6953, 0x696c,
	// Entry 1900 - 193F
	0x698c, 0x69a5, 0x69be, 0x69e0, 0x69f9, 0x6a12, 0x6a2b, 0x6a44,
	0x6a5d, 0x6a76, 0x6a8f, 0x6aa8, 0x6aca, 0x6ae3, 0x6afd, 0x6b16,
	0x6b2f, 0x6b48, 0x6b61, 0x6b7a, 0x6b91, 0x6baf, 0x6bca, 0x6be9,
	0x6c00, 0x6c17, 0x6c2e, 0x6c49, 0x6c65, 0x6c88, 0x6c9f, 0x6cbd,
	0x6cd4, 0x6ceb, 0x6d04, 0x6d1b, 0x6d37, 0x6d57, 0x6d7a, 0x6d91,
	0x6da8, 0x6dbf, 0x6ddf, 0x6dfd, 0x6e14, 0x6e2d, 0x6e47, 0x6e68,
	0x6e83, 0x6ea2, 0x6ebb, 0x6ed9, 0x6ef7, 0x6f15, 0x6f33, 0x6f54,
	0x6f76, 0x6f96, 0x6fb6, 0x6fd6, 0x6feb, 0x7011, 0x7037, 0x705d,
	// Entry 1940 - 197F
	0x7083, 0x70a9, 0x70cf, 0x70f5, 0x7128, 0x714e, 0x7174, 0x719a,
	0x71b5, 0x71d0, 0x71ec, 0x7214, 0x723c, 0x725f, 0x727f, 0x72a7,
	0x72cd, 0x72f3, 0x7319, 0x733f, 0x7365, 0x738b, 0x73b1, 0x73d7,
	0x73fd, 0x7423, 0x7449, 0x746f, 0x7497, 0x74bd, 0x74e3, 0x7509,
	0x7531, 0x755d, 0x7584, 0x75ac, 0x75d9, 0x760f, 0x763b, 0x7663,
	0x7690, 0x76ba, 0x76e2, 0x770c, 0x772e, 0x7745, 0x7766, 0x777f,
	0x77a4, 0x77bb, 0x77e6, 0x7804, 0x7822, 0x7845, 0x785f, 0x787e,
	0x78a9, 0x78d2, 0x78fd, 0x7926, 0x7945, 0x7966, 0x7992, 0x79b8,
	// Entry 1980 - 19BF
	0x79e3, 0x7a02, 0x7a20, 0x7a39, 0x7a5a, 0x7a73, 0x7a9c, 0x7ab7,
	0x7ad4, 0x7af3, 0x7b14, 0x7b32, 0x7b49, 0x7b74, 0x7b95, 0x7bae,
	0x7bc9, 0x7be6, 0x7c03, 0x7c18, 0x7c31, 0x7c47, 0x7c5d, 0x7c73,
	0x7c89, 0x7ca4, 0x7cbf, 0x7ce3, 0x7cf9, 0x7d0f, 0x7d30, 0x7d46,
	0x7d5c, 0x7d6e, 0x7d80, 0x7d92, 0x7dc5, 0x7de4, 0x7e03, 0x7e22,
	0x7e48, 0x7e6e, 0x7e8e, 0x7eac, 0x7ed2, 0x7ef0, 0x7f0e, 0x7f34,
	0x7f5a, 0x7f78, 0x7f9e, 0x7fc4, 0x7fea, 0x8008, 0x802b, 0x8049,
	0x806b, 0x8089, 0x80aa, 0x80cc, 0x80ea, 0x8121, 0x8160, 0x817e,
	// Entry 19C0 - 19FF
	0x819e, 0x81dd, 0x81fb, 0x8228, 0x8255, 0x8282, 0x8299, 0x82b0,
	0x82d5, 0x82f4, 0x8312, 0x8344, 0x836a, 0x838e, 0x83b3, 0x83d6,
	0x83fb, 0x841e, 0x8444, 0x8468, 0x8495, 0x84c0, 0x84e5, 0x8508,
	0x852d, 0x8550, 0x8576, 0x859a, 0x85bd, 0x85de, 0x860a, 0x8634,
	0x8660, 0x868a, 0x86b6, 0x86e0, 0x870c, 0x8736, 0x875d, 0x8782,
	0x87af, 0x87da, 0x87ff, 0x8822, 0x8844, 0x8864, 0x8889, 0x88ac,
	0x88d1, 0x88f4, 0x8919, 0x893c, 0x895f, 0x8980, 0x89a7, 0x89cc,
	0x89f3, 0x8a18, 0x8a47, 0x8a74, 0x8a95, 0x8ab4, 0x8ad9, 0x8afc,
	// Entry 1A00 - 1A3F
	0x8b22, 0x8b46, 0x8b6b, 0x8b8e, 0x8bbe, 0x8bec, 0x8c12, 0x8c36,
	0x8c62, 0x8c8c, 0x8cad, 0x8ccc, 0x8cf1, 0x8d14, 0x8d39, 0x8d5c,
	0x8d81, 0x8da4, 0x8dc9, 0x8dec, 0x8e12, 0x8e36, 0x8e62, 0x8e8c,
	0x8eb7, 0x8ee0, 0x8f0f, 0x8f3c, 0x8f68, 0x8f92, 0x8fbe, 0x8fe8,
	0x9009, 0x9028, 0x904d, 0x9070, 0x9095, 0x90b8, 0x90dd, 0x9100,
	0x9130, 0x915e, 0x9184, 0x91a8, 0x91cd, 0x91f0, 0x9215, 0x9238,
	0x9267, 0x9294, 0x92c3, 0x92f0, 0x9323, 0x9354, 0x9379, 0x939c,
	0x93c1, 0x93e4, 0x940a, 0x942e, 0x945a, 0x9484, 0x94af, 0x94d8,
	// Entry 1A40 - 1A7F
	0x94ff, 0x9524, 0x9550, 0x957a, 0x95a5, 0x95ce, 0x95fe, 0x962c,
	0x964d, 0x966c, 0x9691, 0x96b4, 0x96d5, 0x96f4, 0x9715, 0x9734,
	0x9759, 0x977c, 0x97a1, 0x97c4, 0x97e9, 0x980c, 0x9831, 0x9854,
	0x9879, 0x989c, 0x98c1, 0x98e4, 0x990a, 0x992e, 0x9953, 0x9976,
	0x999c, 0x99c0, 0x99e4, 0x9a07, 0x9a2b, 0x9a4f, 0x9a78, 0x9aa0,
	0x9ace, 0x9af8, 0x9b14, 0x9b2c, 0x9b51, 0x9b74, 0x9b9a, 0x9bbe,
	0x9bee, 0x9c1c, 0x9c4c, 0x9c7a, 0x9caf, 0x9ce2, 0x9d12, 0x9d40,
	0x9d74, 0x9da6, 0x9dd1, 0x9dfa, 0x9e25, 0x9e4e, 0x9e7e, 0x9eac,
	// Entry 1A80 - 1ABF
	0x9ed7, 0x9f00, 0x9f2f, 0x9f5c, 0x9f81, 0x9fa4, 0x9fca, 0x9fee,
	0xa00f, 0xa02e, 0xa05e, 0xa08c, 0xa0bc, 0xa0ea, 0xa11f, 0xa152,
	0xa182, 0xa1b0, 0xa1e4, 0xa216, 0xa23c, 0xa260, 0xa285, 0xa2a8,
	0xa2cd, 0xa2f0, 0xa316, 0xa33a, 0xa36a, 0xa398, 0xa3c8, 0xa3f6,
	0xa42b, 0xa45e, 0xa48e, 0xa4bc, 0xa4f0, 0xa522, 0xa54c, 0xa574,
	0xa59e, 0xa5c6, 0xa5f5, 0xa622, 0xa64c, 0xa674, 0xa6a2, 0xa6ce,
	0xa6f3, 0xa716, 0xa73c, 0xa760, 0xa78a, 0xa7b2, 0xa7dc, 0xa804,
	0xa833, 0xa860, 0xa88a, 0xa8b2, 0xa8e0, 0xa90c, 0xa92d, 0xa94c,
	// Entry 1AC0 - 1AFF
	0xa971, 0xa994, 0xa9ba, 0xa9de, 0xa9ff, 0xaa1e, 0xaa42, 0xaa64,
	0xaa87, 0xaaa8, 0xaac8, 0xaae6, 0xab09, 0xab2c, 0xab59, 0xab86,
	0xabb2, 0xabde, 0xac11, 0xac44, 0xac69, 0xac8e, 0xacbd, 0xacec,
	0xad1a, 0xad48, 0xad7d, 0xadb2, 0xadd7, 0xadfc, 0xae2b, 0xae5a,
	0xae88, 0xaeb6, 0xaedd, 0xaf04, 0xaf35, 0xaf66, 0xaf96, 0xafc6,
	0xafe7, 0xb008, 0xb033, 0xb05e, 0xb088, 0xb0b2, 0xb0e3, 0xb114,
	0xb137, 0xb15a, 0xb187, 0xb1b4, 0xb1e0, 0xb20c, 0xb23f, 0xb272,
	0xb294, 0xb2b6, 0xb2e2, 0xb30e, 0xb339, 0xb364, 0xb396, 0xb3c8,
	// Entry 1B00 - 1B3F
	0xb3ec, 0xb410, 0xb43e, 0xb46c, 0xb499, 0xb4c6, 0xb4fa, 0xb52e,
	0xb553, 0xb578, 0xb5a7, 0xb5d6, 0xb604, 0xb632, 0xb659, 0xb680,
	0xb6b1, 0xb6e2, 0xb712, 0xb742, 0xb767, 0xb78c, 0xb7bb, 0xb7ea,
	0xb818, 0xb846, 0xb87b, 0xb8b0, 0xb8d7, 0xb908, 0xb938, 0xb96f,
	0xb992, 0xb9b5, 0xb9e2, 0xba0f, 0xba3b, 0xba67, 0xba9a, 0xbacd,
	0xbaf2, 0xbb17, 0xbb46, 0xbb75, 0xbba3, 0xbbd1, 0xbc06, 0xbc3b,
	0xbc5e, 0xbc80, 0xbca5, 0xbcc9, 0xbcea, 0xbd0a, 0xbd2c, 0xbd4d,
	0xbd72, 0xbd96, 0xbdbb, 0xbddf, 0xbe02, 0xbe24, 0xbe59, 0xbe8e,
	// Entry 1B40 - 1B7F
	0xbecd, 0xbf0c, 0xbf4a, 0xbf88, 0xbfcd, 0xc012, 0xc04a, 0xc082,
	0xc0c4, 0xc106, 0xc147, 0xc188, 0xc1d0, 0xc218, 0xc24b, 0xc27e,
	0xc2bb, 0xc2f8, 0xc334, 0xc370, 0xc3b3, 0xc3f6, 0xc42c, 0xc462,
	0xc4a2, 0xc4e2, 0xc521, 0xc560, 0xc5a6, 0xc5ec, 0xc621, 0xc656,
	0xc695, 0xc6d4, 0xc712, 0xc750, 0xc795, 0xc7da, 0xc812, 0xc84a,
	0xc88c, 0xc8ce, 0xc90f, 0xc950, 0xc998, 0xc9e0, 0xca04, 0xca28,
	0xca5d, 0xca88, 0xcabc, 0xcae5, 0xcb20, 0xcb46, 0xcb6c, 0xcb91,
	0xcbb5, 0xcbe3, 0xcbf0, 0xcc04, 0xcc0f, 0xcc20, 0xcc3f, 0xcc72,
	// Entry 1B80 - 1BBF
	0xcc9b, 0xcccd, 0xccf4, 0xcd2d, 0xcd54, 0xcd7a, 0xcd9d, 0xcdbf,
	0xcdeb, 0xce00, 0xce14, 0xce2f, 0xce52, 0xce75, 0xcea5, 0xced4,
	0xcefc, 0xcf32, 0xcf57, 0xcf7c, 0xcfa0, 0xcfc3, 0xcfd8, 0xcfec,
	0xd007, 0xd02d, 0xd053, 0xd086, 0xd0b8, 0xd0d9, 0xd0fa, 0xd125,
	0xd15e, 0xd186, 0xd1ae, 0xd1d5, 0xd1fb, 0xd21e, 0xd237, 0xd24f,
	0xd25a, 0xd28f, 0xd2ba, 0xd2ee, 0xd317, 0xd352, 0xd379, 0xd39f,
	0xd3c4, 0xd3e8, 0xd416, 0xd420, 0xd42b, 0xd432, 0xd439, 0xd441,
	0xd449, 0xd45b, 0xd46c, 0xd47c, 0xd488, 0xd499, 0xd4a3, 0xd4ad,
	// Entry 1BC0 - 1BFF
	0xd4bd, 0xd4d2, 0xd4e3, 0xd4f5, 0xd507, 0xd50d, 0xd520, 0xd52b,
	0xd532, 0xd539, 0xd547, 0xd55b, 0xd56a, 0xd584, 0xd59f, 0xd5ba,
	0xd5df, 0xd5f9, 0xd614, 0xd62f, 0xd654, 0xd65a, 0xd667, 0xd66d,
	0xd67e, 0xd68c, 0xd69a, 0xd6ad, 0xd6be, 0xd6cc, 0xd6df, 0xd6f6,
	0xd70d, 0xd727, 0xd73d, 0xd753, 0xd768, 0xd776, 0xd78b, 0xd790,
	0xd79c, 0xd7a8, 0xd7b6, 0xd7cb, 0xd7e0, 0xd7e5, 0xd80e, 0xd838,
	0xd846, 0xd85d, 0xd868, 0xd870, 0xd878, 0xd885, 0xd89a, 0xd8a2,
	0xd8af, 0xd8bd, 0xd8db, 0xd8fa, 0xd90e, 0xd927, 0xd940, 0xd950,
	// Entry 1C00 - 1C3F
	0xd965, 0xd97b, 0xd992, 0xd99e, 0xd9b0, 0xd9b8, 0xd9d8, 0xd9ed,
	0xd9f7, 0xda08, 0xda1f, 0xda34, 0xda43, 0xda57, 0xda6b, 0xda7e,
	0xda8b, 0xda97, 0xda9f, 0xdab1, 0xdaca, 0xdad5, 0xdae9, 0xdaf8,
	0xdb0b, 0xdb19, 0xdb2e, 0xdb43, 0xdb57, 0xdb6e, 0xdb88, 0xdba3,
	0xdbbe, 0xdbda, 0xdbef, 0xdc03, 0xdc13, 0xdc33, 0xdc43, 0xdc53,
	0xdc62, 0xdc73, 0xdc84, 0xdc94, 0xdca9, 0xdcba, 0xdcd1, 0xdced,
	0xdd0a, 0xdd2a, 0xdd38, 0xdd45, 0xdd52, 0xdd61, 0xdd6f, 0xdd7d,
	0xdd8a, 0xdd99, 0xdda8, 0xddb6, 0xddc9, 0xddd8, 0xdded, 0xde07,
	// Entry 1C40 - 1C7F
	0xde22, 0xde40, 0xde5e, 0xde7c, 0xde9a, 0xdebc, 0xdeda, 0xdef8,
	0xdf16, 0xdf34, 0xdf52, 0xdf70, 0xdf8e, 0xdfac, 0xdfbe, 0xdfc8,
	0xdfd5, 0xdfe6, 0xdfef, 0xdff8, 0xe002, 0xe00d, 0xe017, 0xe01f,
	0xe02e, 0xe037, 0xe040, 0xe048, 0xe053, 0xe05f, 0xe070, 0xe079,
	0xe085, 0xe091, 0xe09d, 0xe0a6, 0xe0b9, 0xe0c6, 0xe0d0, 0xe0e1,
	0xe0f2, 0xe102, 0xe10c, 0xe116, 0xe11f, 0xe13b, 0xe158, 0xe17c,
	0xe1a1, 0xe1c4, 0xe1e3, 0xe1fd, 0xe218, 0xe22e, 0xe24e, 0xe272,
	0xe28c, 0xe2a5, 0xe2bf, 0xe2d9, 0xe2f4, 0xe318, 0xe338, 0xe352,
	// Entry 1C80 - 1CBF
	0xe36c, 0xe398, 0xe3b9, 0xe3e1, 0xe3f9, 0xe412, 0xe42d, 0xe44e,
	0xe473, 0xe4a3, 0xe4d2, 0xe4ec, 0xe507, 0xe51f, 0xe529, 0xe541,
	0xe558, 0xe566, 0xe578, 0xe57f, 0xe587, 0xe595, 0xe59c, 0xe5ad,
	0xe5bb, 0xe5cb, 0xe5e1, 0xe5f8, 0xe607, 0xe622, 0xe632, 0xe648,
	0xe658, 0xe666, 0xe674, 0xe68b, 0xe696, 0xe6af, 0xe6bf, 0xe6d6,
	0xe6ed, 0xe6fd, 0xe713, 0xe72a, 0xe73b, 0xe743, 0xe74f, 0xe75d,
	0xe76c, 0xe774, 0xe78b, 0xe795, 0xe79d, 0xe7ae, 0xe7c4, 0xe7e2,
	0xe7ed, 0xe7fa, 0xe80a, 0xe820, 0xe830, 0xe83e, 0xe84e, 0xe85e,
	// Entry 1CC0 - 1CFF
	0xe86e, 0xe87e, 0xe88c, 0xe897, 0xe8a1, 0xe8ad, 0xe8b9, 0xe8cb,
	0xe8dc, 0xe8ea, 0xe900, 0xe919, 0xe934, 0xe94c, 0xe969, 0xe984,
	0xe99f, 0xe9bc, 0xe9d7, 0xe9f5, 0xea11, 0xea2d, 0xea49, 0xea65,
	0xea72, 0xea82, 0xea8a, 0xea96, 0xeaa4, 0xeabf, 0xeada, 0xeaf3,
	0xeb0c, 0xeb25, 0xeb3f, 0xeb58, 0xeb72, 0xeb8e, 0xeba9, 0xebc2,
	0xebdd, 0xebf7, 0xec14, 0xec30, 0xec4d, 0xec63, 0xec74, 0xec85,
	0xec98, 0xecaa, 0xecbc, 0xeccd, 0xece0, 0xecf3, 0xed05, 0xed16,
	0xed2a, 0xed3e, 0xed51, 0xed6a, 0xed84, 0xed9e, 0xedb5, 0xedcc,
	// Entry 1D00 - 1D3F
	0xede5, 0xedfd, 0xee15, 0xee2c, 0xee45, 0xee5e, 0xee76, 0xee8d,
	0xeea7, 0xeec1, 0xeeda, 0xeef9, 0xef19, 0xef39, 0xef57, 0xef72,
	0xef8c, 0xefae, 0xefcb, 0xefe6, 0xf004, 0xf020, 0xf042, 0xf05d,
	0xf06d, 0xf07f, 0xf08e, 0xf09b, 0xf0ab, 0xf0ba, 0xf0ca, 0xf0d7,
	0xf0e7, 0xf0f7, 0xf107, 0xf117, 0xf132, 0xf14e, 0xf162, 0xf177,
	0xf191, 0xf1a9, 0xf1c4, 0xf1de, 0xf1f7, 0xf211, 0xf229, 0xf23f,
	0xf258, 0xf270, 0xf287, 0xf2a0, 0xf2ba, 0xf2d3, 0xf2ed, 0xf302,
	0xf31e, 0xf334, 0xf354, 0xf375, 0xf397, 0xf3ba, 0xf3e0, 0xf405,
	// Entry 1D40 - 1D7F
	0xf427, 0xf445, 0xf461, 0xf494, 0xf4b3, 0xf4ce, 0xf4f1, 0xf516,
	0xf53a, 0xf55d, 0xf581, 0xf5a7, 0xf5cd, 0xf5f2, 0xf617, 0xf641,
	0xf666, 0xf67d, 0xf692, 0xf6aa, 0xf6c1, 0xf6ea, 0xf713, 0xf735,
	0xf758, 0xf77b, 0xf791, 0xf7a5, 0xf7bc, 0xf7d2, 0xf7e9, 0xf7fd,
	0xf814, 0xf82b, 0xf842, 0xf859, 0xf86f, 0xf886, 0xf89e, 0xf8b7,
	0xf8d7, 0xf8f9, 0xf90f, 0xf923, 0xf93a, 0xf950, 0xf966, 0xf97d,
	0xf992, 0xf9a5, 0xf9bb, 0xf9d0, 0xf9ec, 0xfa0b, 0xfa3e, 0xfa6f,
	0xfa89, 0xfaaf, 0xfacf, 0xfae9, 0xfb03, 0xfb16, 0xfb33, 0xfb5d,
	// Entry 1D80 - 1DBF
	0xfb74, 0xfb98, 0xfbbd, 0xfbe2, 0xfc0d, 0xfc39, 0xfc65, 0xfc80,
	0xfc9c, 0xfcb8, 0xfcbf, 0xfcc9, 0xfcdd, 0xfce9, 0xfcfd, 0xfd06,
	0xfd0f, 0xfd14, 0xfd1e, 0xfd2f, 0xfd3f, 0xfd51, 0xfd6b, 0xfd83,
	0xfd8f, 0xfd9c, 0xfdab, 0xfdba, 0xfdc4, 0xfdd6, 0xfdde, 0xfdec,
	0xfdf5, 0xfe06, 0xfe13, 0xfe22, 0xfe2d, 0xfe36, 0xfe41, 0xfe50,
	0xfe58, 0xfe63, 0xfe68, 0xfe76, 0xfe85, 0xfe8c, 0xfe9b, 0xfea6,
	0xfeb5, 0xfec0, 0xfeca, 0xfed6, 0xfedb, 0xfee3, 0xfef2, 0xff01,
	0xff11, 0xff21, 0xff30, 0xff42, 0xff5c, 0xff7a, 0xff83, 0xff8a,
	// Entry 1DC0 - 1DFF
	0xff8f, 0xff99, 0xffa2, 0xffa8, 0xffbc, 0xffc6, 0xffd4, 0xffe2,
	0xfff1, 0xfffa, 0x0008, 0x0011, 0x001c, 0x0033, 0x004e, 0x0064,
	0x008b, 0x00b6, 0x00c5, 0x00d8, 0x00f0, 0x00fc, 0x0108, 0x0115,
	0x0130, 0x0142, 0x0156, 0x016c, 0x0192, 0x01b4, 0x01c0, 0x01cc,
	0x01dc, 0x01e9, 0x01f7, 0x0200, 0x020e, 0x0219, 0x0227, 0x023d,
	0x0248, 0x025b, 0x0267, 0x0273, 0x0283, 0x0299, 0x02ae, 0x02c6,
	0x02dd, 0x02f7, 0x0311, 0x032e, 0x033c, 0x034d, 0x0354, 0x0365,
	0x0372, 0x0382, 0x03a0, 0x03c1, 0x03db, 0x03f8, 0x041b, 0x0441,
	// Entry 1E00 - 1E3F
	0x045a, 0x0473, 0x0495, 0x04b7, 0x04bf, 0x04c7, 0x04db, 0x04ef,
	0x0508, 0x0521, 0x0531, 0x0541, 0x054a, 0x0555, 0x0564, 0x0575,
	0x058a, 0x05a1, 0x05c1, 0x05e3, 0x05fe, 0x061b, 0x0623, 0x063a,
	0x0648, 0x0657, 0x0669, 0x0684, 0x06a2, 0x06ac, 0x06b6, 0x06c2,
	0x06cf, 0x06dc, 0x06f2, 0x0706, 0x071b, 0x0734, 0x0742, 0x074e,
	0x075a, 0x0767, 0x0774, 0x0788, 0x0792, 0x079b, 0x07a4, 0x07ab,
	0x07b4, 0x07ba, 0x07be, 0x07c4, 0x07e7, 0x0811, 0x081f, 0x0827,
	0x0835, 0x0867, 0x087e, 0x0895, 0x08a7, 0x08c2, 0x08e0, 0x0907,
	// Entry 1E40 - 1E7F
	0x0912, 0x091a, 0x0922, 0x093c, 0x0947, 0x094a, 0x094e, 0x0951,
	0x0965, 0x0973, 0x0984, 0x0994, 0x09a6, 0x09b1, 0x09c1, 0x09cd,
	0x09da, 0x09e8, 0x09ee, 0x0a13, 0x0a39, 0x0a50, 0x0a68, 0x0a7d,
	0x0a8d, 0x0a9e, 0x0aab, 0x0aba, 0x0acd, 0x0ad9, 0x0ae2, 0x0af7,
	0x0b09, 0x0b1e, 0x0b31, 0x0b47, 0x0b69, 0x0b8b, 0x0ba0, 0x0bb8,
	0x0bcc, 0x0be0, 0x0bf9, 0x0c12, 0x0c31, 0x0c53, 0x0c72, 0x0c94,
	0x0cb3, 0x0cd5, 0x0cf3, 0x0d11, 0x0d27, 0x0d4a, 0x0d6c, 0x0d98,
	0x0da9, 0x0dc4, 0x0dde, 0x0dfa, 0x0e20, 0x0e58, 0x0e96, 0x0eaf,
	// Entry 1E80 - 1EBF
	0x0ec6, 0x0ee3, 0x0efb, 0x0f21, 0x0f45, 0x0f7b, 0x0fb7, 0x0fcc,
	0x0fe7, 0x1000, 0x100d, 0x101b, 0x1020, 0x102c, 0x103a, 0x1044,
	0x104f, 0x1058, 0x1064, 0x1071, 0x107b, 0x1086, 0x1097, 0x10a7,
	0x10b5, 0x10c2, 0x10d3, 0x10e1, 0x10e4, 0x10eb, 0x10f1, 0x1103,
	0x1115, 0x1124, 0x113a, 0x1149, 0x114e, 0x1157, 0x1166, 0x1176,
	0x1188, 0x119b, 0x11ac, 0x11c0, 0x11c5, 0x11ca, 0x11f2, 0x11fc,
	0x120e, 0x1222, 0x122a, 0x1245, 0x1261, 0x1272, 0x127e, 0x128a,
	0x129c, 0x12a4, 0x12b0, 0x12c0, 0x12cd, 0x12d2, 0x12dd, 0x12e8,
	// Entry 1EC0 - 1EFF
	0x1304, 0x1325, 0x1345, 0x1366, 0x1388, 0x13a6, 0x13c7, 0x13e9,
	0x1409, 0x1428, 0x144b, 0x146b, 0x148f, 0x14b3, 0x14da, 0x14fe,
	0x1523, 0x154d, 0x1578, 0x159e, 0x15c6, 0x15e7, 0x160c, 0x162c,
	0x164f, 0x1671, 0x1699, 0x16be, 0x16dd, 0x1700, 0x171e, 0x173f,
	0x1763, 0x178d, 0x17b1, 0x17d5, 0x17fb, 0x181d, 0x1842, 0x1863,
	0x1883, 0x18a4, 0x18c4, 0x18eb, 0x190e, 0x1932, 0x1955, 0x197b,
	0x19a0, 0x19c5, 0x19ea, 0x1a16, 0x1a35, 0x1a54, 0x1a6f, 0x1a90,
	0x1ab8, 0x1adc, 0x1aff, 0x1b25, 0x1b49, 0x1b63, 0x1b7c, 0x1b97,
	// Entry 1F00 - 1F3F
	0x1bbb, 0x1be1, 0x1c04, 0x1c28, 0x1c43, 0x1c51, 0x1c78, 0x1c8b,
	0x1c96, 0x1cb3, 0x1cc3, 0x1cde, 0x1cfc, 0x1d0b, 0x1d1d, 0x1d43,
	0x1d4f, 0x1d65, 0x1d70, 0x1d91, 0x1da6, 0x1dc8, 0x1dd3, 0x1de4,
	0x1df5, 0x1e16, 0x1e37, 0x1e56, 0x1e73, 0x1e91, 0x1ea9, 0x1ec3,
	0x1edf, 0x1eec, 0x1ef5, 0x1f08, 0x1f1b, 0x1f36, 0x1f50, 0x1f6b,
	0x1f87, 0x1fa2, 0x1fbe, 0x1fde, 0x1ffb, 0x201b, 0x203c, 0x205a,
	0x207b, 0x2098, 0x20b7, 0x20d4, 0x20eb, 0x2109, 0x2129, 0x2147,
	0x2159, 0x2172, 0x21a1, 0x21d0, 0x21dd, 0x21ed, 0x21ff, 0x2214,
	// Entry 1F40 - 1F7F
	0x2241, 0x2256, 0x226c, 0x2283, 0x2299, 0x22af, 0x22c5, 0x22db,
	0x2308, 0x2338, 0x2363, 0x2399, 0x23cd, 0x23fa, 0x2432, 0x2468,
	0x2490, 0x24c4, 0x24f6, 0x2520, 0x2548, 0x2574, 0x25a3, 0x25ae,
	0x25bb, 0x25c7, 0x25de, 0x25ec, 0x2604, 0x261c, 0x2639, 0x2656,
	0x2670, 0x2680, 0x2692, 0x26a4, 0x26b0, 0x26b4, 0x26c3, 0x26d5,
	0x26e6, 0x26fa, 0x2714, 0x2731, 0x2740, 0x2758, 0x2764, 0x276c,
	0x2776, 0x278d, 0x27a4, 0x27c8, 0x27eb, 0x280c, 0x282f, 0x2865,
	0x289a, 0x28d0, 0x28db, 0x28e4, 0x28ef, 0x290a, 0x292d, 0x2951,
	// Entry 1F80 - 1FBF
	0x2972, 0x2995, 0x29a8, 0x29bd, 0x29d4, 0x29e0, 0x29f3, 0x2a02,
	0x2a14, 0x2a23, 0x2a3e, 0x2a56, 0x2a6c, 0x2a8a, 0x2a9c, 0x2ab2,
	0x2ac1, 0x2ad5, 0x2af5, 0x2b09, 0x2b27, 0x2b3b, 0x2b55, 0x2b69,
	0x2b7c, 0x2b97, 0x2bb4, 0x2bd1, 0x2bf0, 0x2c0e, 0x2c2d, 0x2c48,
	0x2c6c, 0x2c7d, 0x2c95, 0x2caa, 0x2cbb, 0x2cd4, 0x2cee, 0x2d09,
	0x2d22, 0x2d32, 0x2d43, 0x2d4f, 0x2d57, 0x2d69, 0x2d83, 0x2da1,
	0x2da9, 0x2db2, 0x2dba, 0x2dcb, 0x2dda, 0x2de5, 0x2e03, 0x2e16,
	0x2e1e, 0x2e39, 0x2e4d, 0x2e5e, 0x2e6f, 0x2e82, 0x2e94, 0x2ea6,
	// Entry 1FC0 - 1FFF
	0x2eb7, 0x2eca, 0x2edd, 0x2eef, 0x2f01, 0x2f16, 0x2f2b, 0x2f42,
	0x2f59, 0x2f6f, 0x2f85, 0x2f9d, 0x2fb4, 0x2fcb, 0x2fe0, 0x2ff7,
	0x300e, 0x3027, 0x303f, 0x3057, 0x306e, 0x3087, 0x30a0, 0x30b8,
	0x30d0, 0x30eb, 0x3106, 0x3123, 0x3140, 0x315c, 0x3178, 0x3196,
	0x31b3, 0x31d0, 0x31eb, 0x31fe, 0x3211, 0x3226, 0x323a, 0x324e,
	0x3261, 0x3276, 0x328b, 0x329f, 0x32b3, 0x32ca, 0x32e1, 0x32fa,
	0x3313, 0x332b, 0x3343, 0x335d, 0x3376, 0x338f, 0x33a6, 0x33c8,
	0x33ea, 0x340c, 0x342e, 0x3450, 0x3472, 0x3494, 0x34b6, 0x34d8,
	// Entry 2000 - 203F
	0x34fa, 0x351c, 0x353e, 0x3560, 0x3582, 0x35a4, 0x35c6, 0x35e8,
	0x360a, 0x362c, 0x364e, 0x3670, 0x3692, 0x36b4, 0x36d6, 0x36f8,
	0x371a, 0x3738, 0x3756, 0x3774, 0x3792, 0x37b0, 0x37ce, 0x37ec,
	0x380a, 0x3828, 0x3846, 0x3864, 0x3882, 0x38a0, 0x38be, 0x38dc,
	0x38fa, 0x3918, 0x3936, 0x3954, 0x3972, 0x3990, 0x39ae, 0x39cc,
	0x39ea, 0x3a08, 0x3a26, 0x3a42, 0x3a5e, 0x3a7a, 0x3a96, 0x3ab2,
	0x3ace, 0x3aea, 0x3b06, 0x3b22, 0x3b3e, 0x3b5a, 0x3b76, 0x3b92,
	0x3bae, 0x3bca, 0x3be6, 0x3c02, 0x3c1e, 0x3c3a, 0x3c56, 0x3c72,
	// Entry 2040 - 207F
	0x3c8e, 0x3caa, 0x3cc6, 0x3ce2, 0x3cfe, 0x3d10, 0x3d2e, 0x3d4c,
	0x3d6c, 0x3d8c, 0x3dab, 0x3dca, 0x3deb, 0x3e0b, 0x3e2b, 0x3e49,
	0x3e61, 0x3e79, 0x3e93, 0x3eac, 0x3ec5, 0x3edd, 0x3ef7, 0x3f11,
	0x3f2a, 0x3f43, 0x3f5e, 0x3f7b, 0x3f98, 0x3fb3, 0x3fce, 0x3ff7,
	0x4020, 0x4047, 0x406e, 0x409a, 0x40c6, 0x40f0, 0x411a, 0x413b,
	0x4162, 0x4189, 0x41aa, 0x41ca, 0x41f0, 0x4216, 0x4236, 0x4255,
	0x427a, 0x429f, 0x42be, 0x42dc, 0x4300, 0x4324, 0x4342, 0x4367,
	0x4392, 0x43bc, 0x43e6, 0x4411, 0x443b, 0x4465, 0x448a, 0x44ae,
	// Entry 2080 - 20BF
	0x44d8, 0x4501, 0x452a, 0x4554, 0x457d, 0x45a6, 0x45ca, 0x45f0,
	0x461c, 0x4648, 0x4674, 0x46a0, 0x46cc, 0x46f8, 0x471e, 0x4742,
	0x476c, 0x4796, 0x47c0, 0x47ea, 0x4814, 0x483e, 0x4862, 0x488c,
	0x48bc, 0x48ec, 0x491c, 0x494b, 0x497a, 0x49aa, 0x49d9, 0x4a08,
	0x4a37, 0x4a66, 0x4a95, 0x4ac4, 0x4af4, 0x4b24, 0x4b4e, 0x4b77,
	0x4ba0, 0x4bc7, 0x4bee, 0x4c0c, 0x4c28, 0x4c51, 0x4c7a, 0x4c9c,
	0x4cc4, 0x4cec, 0x4d0d, 0x4d34, 0x4d5b, 0x4d7b, 0x4da1, 0x4dc7,
	0x4de6, 0x4e13, 0x4e40, 0x4e66, 0x4e92, 0x4ebe, 0x4ee3, 0x4f11,
	// Entry 20C0 - 20FF
	0x4f3f, 0x4f66, 0x4f92, 0x4fbe, 0x4fe3, 0x5015, 0x5047, 0x5072,
	0x5097, 0x50bb, 0x50dd, 0x5100, 0x5135, 0x516a, 0x518b, 0x51a2,
	0x51b7, 0x51cf, 0x51e6, 0x51fd, 0x5212, 0x522a, 0x5241, 0x5268,
	0x528c, 0x52b3, 0x52d7, 0x52e7, 0x52fd, 0x5314, 0x532d, 0x533d,
	0x5355, 0x536f, 0x5388, 0x5392, 0x53aa, 0x53c3, 0x53da, 0x53e9,
	0x5401, 0x5417, 0x542c, 0x543c, 0x5447, 0x5453, 0x545d, 0x5473,
	0x5489, 0x549c, 0x54b0, 0x54c3, 0x54f5, 0x5518, 0x554a, 0x557d,
	0x5591, 0x55b4, 0x55e7, 0x55f3, 0x55ff, 0x5620, 0x564a, 0x5665,
	// Entry 2100 - 213F
	0x567e, 0x56a4, 0x56ce, 0x56f8, 0x571c, 0x572e, 0x5740, 0x574f,
	0x575e, 0x5776, 0x578e, 0x57a1, 0x57b4, 0x57ce, 0x57e8, 0x5808,
	0x5828, 0x5845, 0x5862, 0x5885, 0x58a8, 0x58c4, 0x58e0, 0x58fc,
	0x5918, 0x593a, 0x595c, 0x5978, 0x5994, 0x59b6, 0x59d8, 0x59f3,
	0x5a0e, 0x5a1b, 0x5a28, 0x5a54, 0x5a5b, 0x5a62, 0x5a6e, 0x5a7b,
	0x5a94, 0x5a9c, 0x5aa8, 0x5ac3, 0x5adf, 0x5afb, 0x5b17, 0x5b3d,
	0x5b6a, 0x5b80, 0x5b97, 0x5ba5, 0x5bb9, 0x5bd8, 0x5bf7, 0x5c17,
	0x5c38, 0x5c59, 0x5c79, 0x5c8a, 0x5c9b, 0x5cb5, 0x5cce, 0x5ce7,
	// Entry 2140 - 217F
	0x5d01, 0x5d0d, 0x5d28, 0x5d44, 0x5d6e, 0x5d99, 0x5dc2, 0x5de5,
	0x5e0e, 0x5e38, 0x5e44, 0x5e69, 0x5e8e, 0x5eb4, 0x5eda, 0x5eff,
	0x5f24, 0x5f4a, 0x5f70, 0x5f83, 0x5f97, 0x5faa, 0x5fbd, 0x5fd0,
	0x5fe9, 0x6002, 0x6016, 0x6029, 0x602e, 0x6036, 0x603d, 0x6042,
	0x604c, 0x6056, 0x605f, 0x606b, 0x606e, 0x607c, 0x608b, 0x6096,
	0x60a0, 0x60af, 0x60be, 0x60c8, 0x60dd, 0x60ee, 0x60f5, 0x610d,
	0x6119, 0x612a, 0x613b, 0x6143, 0x6167, 0x6180, 0x619a, 0x61b3,
	0x61ca, 0x61e4, 0x61fd, 0x6211, 0x621d, 0x622d, 0x623b, 0x6243,
	// Entry 2180 - 21BF
	0x6247, 0x6255, 0x625c, 0x626d, 0x627f, 0x6290, 0x629c, 0x62a6,
	0x62b7, 0x62c3, 0x62cb, 0x62dd, 0x62ed, 0x62fd, 0x6310, 0x6320,
	0x6331, 0x6345, 0x6356, 0x6365, 0x6378, 0x638a, 0x639c, 0x63af,
	0x63c1, 0x63d2, 0x63d9, 0x63e4, 0x63e9, 0x63f2, 0x63f9, 0x63ff,
	0x6405, 0x640c, 0x6411, 0x6416, 0x641c, 0x6422, 0x6428, 0x642b,
	0x6430, 0x6435, 0x643d, 0x6448, 0x6451, 0x6459, 0x645f, 0x646f,
	0x6480, 0x6490, 0x64a2, 0x64b4, 0x64c4, 0x64d4, 0x64e5, 0x64f5,
	0x6507, 0x6519, 0x6529, 0x6539, 0x6549, 0x655b, 0x656a, 0x657a,
	// Entry 21C0 - 21FF
	0x658a, 0x659c, 0x65ab, 0x65b6, 0x65c2, 0x65cd, 0x65e0, 0x65f6,
	0x6605, 0x6617, 0x6627, 0x6638, 0x6649, 0x6663, 0x6687, 0x66ab,
	0x66cf, 0x66f3, 0x6717, 0x673b, 0x675f, 0x6785, 0x67a5, 0x67ba,
	0x67d9, 0x67ed, 0x67fe, 0x6808, 0x6812, 0x681c, 0x6826, 0x6830,
	0x683a, 0x6855, 0x686f, 0x6890, 0x68b0, 0x68c1, 0x68d1, 0x68e8,
	0x68fd, 0x6913, 0x6929, 0x6933, 0x693d, 0x694c, 0x6952, 0x6960,
	0x6974, 0x697a, 0x6981, 0x6987, 0x698b, 0x699a, 0x69a5, 0x69b1,
	0x69c4, 0x69e0, 0x69fb, 0x6a07, 0x6a18, 0x6a2b, 0x6a3c, 0x6a5c,
	// Entry 2200 - 223F
	0x6a70, 0x6a85, 0x6aae, 0x6acc, 0x6aec, 0x6aff, 0x6b12, 0x6b2b,
	0x6b3a, 0x6b48, 0x6b64, 0x6b6a, 0x6b75, 0x6b7b, 0x6b80, 0x6b86,
	0x6b8a, 0x6b8f, 0x6b95, 0x6ba6, 0x6bad, 0x6bb8, 0x6bc0, 0x6bce,
	0x6bd9, 0x6be1, 0x6bec, 0x6bfe, 0x6c11, 0x6c23, 0x6c36, 0x6c4a,
	0x6c5a, 0x6c5e, 0x6c6b, 0x6c81, 0x6c99, 0x6cb1, 0x6cc8, 0x6cd6,
	0x6ce2, 0x6ceb, 0x6cef, 0x6cfa, 0x6d11, 0x6d27, 0x6d2d, 0x6d35,
	0x6d57, 0x6d75, 0x6d93, 0x6da8, 0x6dbd, 0x6dcc, 0x6dee, 0x6dff,
	0x6e0e, 0x6e3e, 0x6e49, 0x6e60, 0x6e77, 0x6e95, 0x6ec0, 0x6ec9,
	// Entry 2240 - 227F
	0x6eea, 0x6f0a, 0x6f1c, 0x6f31, 0x6f3e, 0x6f44, 0x6f4a, 0x6f57,
	0x6f67, 0x6f78, 0x6f91, 0x6f99, 0x6fab, 0x6fb3, 0x6fbf, 0x6fc4,
	0x6fcc, 0x6fdf, 0x6fe4, 0x6fed, 0x6ffd, 0x7001, 0x7015, 0x702f,
	0x7038, 0x704b, 0x7079, 0x708e, 0x70a2, 0x70b0, 0x70c4, 0x70d2,
	0x70e8, 0x70ff, 0x7109, 0x7111, 0x7119, 0x7124, 0x712f, 0x713b,
	0x7147, 0x7159, 0x715f, 0x7171, 0x717a, 0x7183, 0x718d, 0x719d,
	0x71ad, 0x71c3, 0x71cb, 0x71d9, 0x71ed, 0x71fe, 0x720f, 0x7226,
	0x7231, 0x724b, 0x725f, 0x726c, 0x7279, 0x7296, 0x72b2, 0x72d4,
	// Entry 2280 - 22BF
	0x72ed, 0x7304, 0x731b, 0x7323, 0x733d, 0x734f, 0x7365, 0x737c,
	0x738f, 0x73a8, 0x73b5, 0x73c8, 0x73d6, 0x73ea, 0x73ff, 0x7417,
	0x7432, 0x7448, 0x746c, 0x7496, 0x74af, 0x74c7, 0x74df, 0x7503,
	0x7521, 0x7546, 0x7554, 0x7562, 0x7588, 0x75ae, 0x75d5, 0x75de,
	0x75f8, 0x760f, 0x7616, 0x7623, 0x763a, 0x7662, 0x7690, 0x769a,
	0x76af, 0x76ca, 0x76f0, 0x7716, 0x7737, 0x7758, 0x7774, 0x7790,
	0x77af, 0x77ca, 0x77e7, 0x77f9, 0x780c, 0x781e, 0x784f, 0x7879,
	0x78aa, 0x78d4, 0x7902, 0x7930, 0x7953, 0x7972, 0x7997, 0x79a8,
	// Entry 22C0 - 22FF
	0x79c8, 0x79d4, 0x79ef, 0x7a0f, 0x7a30, 0x7a5a, 0x7a85, 0x7ab0,
	0x7adc, 0x7b0d, 0x7b3f, 0x7b69, 0x7b94, 0x7bbe, 0x7be9, 0x7c0b,
	0x7c2e, 0x7c50, 0x7c72, 0x7c96, 0x7cb9, 0x7cdc, 0x7cfe, 0x7d22,
	0x7d46, 0x7d69, 0x7d8c, 0x7db0, 0x7dd4, 0x7dfa, 0x7e1f, 0x7e44,
	0x7e68, 0x7e8e, 0x7eb4, 0x7ed9, 0x7efe, 0x7f2b, 0x7f58, 0x7f87,
	0x7fb5, 0x7fe3, 0x8010, 0x803f, 0x806e, 0x809c, 0x80ca, 0x80ec,
	0x80fb, 0x810b, 0x811e, 0x8134, 0x814a, 0x8160, 0x817f, 0x81a2,
	0x81c2, 0x81e8, 0x820f, 0x823c, 0x8252, 0x827a, 0x82a5, 0x82bf,
	// Entry 2300 - 233F
	0x82f0, 0x831f, 0x833b, 0x8367, 0x838a, 0x83ac, 0x83d7, 0x8403,
	0x8434, 0x8465, 0x8498, 0x84a2, 0x84d5, 0x84f9, 0x8519, 0x8539,
	0x8559, 0x8579, 0x859f, 0x85c5, 0x85eb, 0x860b, 0x8632, 0x864f,
	0x8672, 0x8690, 0x86a1, 0x86b8, 0x86e6, 0x86f3, 0x86fe, 0x870b,
	0x8726, 0x8742, 0x8754, 0x8774, 0x878e, 0x87b1, 0x87cd, 0x87da,
	0x87f7, 0x880a, 0x881c, 0x883a, 0x8846, 0x8860, 0x887b, 0x8895,
	0x88a4, 0x88b4, 0x88c3, 0x88d0, 0x88df, 0x88fe, 0x8911, 0x891e,
	0x892d, 0x893b, 0x8954, 0x8976, 0x8991, 0x89c0, 0x89f0, 0x8a10,
	// Entry 2340 - 237F
	0x8a31, 0x8a57, 0x8a7e, 0x8a9d, 0x8abd, 0x8ae3, 0x8b0a, 0x8b38,
	0x8b67, 0x8b8e, 0x8bb6, 0x8bcd, 0x8be6, 0x8c07, 0x8c24, 0x8c41,
	0x8c55, 0x8c6a, 0x8c7f, 0x8c9a, 0x8cb6, 0x8cd2, 0x8cef, 0x8d0d,
	0x8d31, 0x8d56, 0x8d74, 0x8d89, 0x8d9f, 0x8db5, 0x8dcc, 0x8de2,
	0x8df9, 0x8e10, 0x8e28, 0x8e3e, 0x8e55, 0x8e6c, 0x8e84, 0x8e9b,
	0x8eb3, 0x8ecb, 0x8ee4, 0x8efa, 0x8f11, 0x8f28, 0x8f40, 0x8f57,
	0x8f6f, 0x8f87, 0x8fa0, 0x8fb7, 0x8fcf, 0x8fe7, 0x9000, 0x9018,
	0x9031, 0x904a, 0x9064, 0x907a, 0x9091, 0x90a8, 0x90c0, 0x90d7,
	// Entry 2380 - 23BF
	0x90ef, 0x9107, 0x9120, 0x9137, 0x914f, 0x9167, 0x9180, 0x9198,
	0x91b1, 0x91ca, 0x91e4, 0x91fb, 0x9213, 0x922b, 0x9244, 0x925c,
	0x9275, 0x928e, 0x92a8, 0x92c0, 0x92d9, 0x92f2, 0x930c, 0x9325,
	0x933f, 0x9359, 0x9374, 0x938a, 0x93a1, 0x93b8, 0x93d0, 0x93e7,
	0x93ff, 0x9417, 0x9430, 0x9447, 0x945f, 0x9477, 0x9490, 0x94a8,
	0x94c1, 0x94da, 0x94f4, 0x950b, 0x9523, 0x953b, 0x9554, 0x956c,
	0x9585, 0x959e, 0x95b8, 0x95d0, 0x95e9, 0x9602, 0x961c, 0x9635,
	0x964f, 0x9669, 0x9684, 0x969b, 0x96b3, 0x96cb, 0x96e4, 0x96fc,
	// Entry 23C0 - 23FF
	0x9715, 0x972e, 0x9748, 0x9760, 0x9779, 0x9792, 0x97ac, 0x97c5,
	0x97df, 0x97f9, 0x9814, 0x982c, 0x9845, 0x985e, 0x9878, 0x9891,
	0x98ab, 0x98c5, 0x98e0, 0x98f9, 0x9913, 0x992d, 0x9948, 0x9962,
	0x997d, 0x9998, 0x99b4, 0x99ca, 0x99e1, 0x99f8, 0x9a10, 0x9a27,
	0x9a3f, 0x9a57, 0x9a70, 0x9a87, 0x9a9f, 0x9ab7, 0x9ad0, 0x9ae8,
	0x9b01, 0x9b1a, 0x9b34, 0x9b4b, 0x9b63, 0x9b7b, 0x9b94, 0x9bac,
	0x9bc5, 0x9bde, 0x9bf8, 0x9c10, 0x9c29, 0x9c42, 0x9c5c, 0x9c75,
	0x9c8f, 0x9ca9, 0x9cc4, 0x9cdb, 0x9cf3, 0x9d0b, 0x9d24, 0x9d3c,
	// Entry 2400 - 243F
	0x9d55, 0x9d6e, 0x9d88, 0x9da0, 0x9db9, 0x9dd2, 0x9dec, 0x9e05,
	0x9e1f, 0x9e39, 0x9e54, 0x9e6c, 0x9e85, 0x9e9e, 0x9eb8, 0x9ed1,
	0x9eeb, 0x9f05, 0x9f20, 0x9f39, 0x9f53, 0x9f6d, 0x9f88, 0x9fa2,
	0x9fbd, 0x9fd8, 0x9ff4, 0xa00b, 0xa023, 0xa03b, 0xa054, 0xa06c,
	0xa085, 0xa09e, 0xa0b8, 0xa0d0, 0xa0e9, 0xa102, 0xa11c, 0xa135,
	0xa14f, 0xa169, 0xa184, 0xa19c, 0xa1b5, 0xa1ce, 0xa1e8, 0xa201,
	0xa21b, 0xa235, 0xa250, 0xa269, 0xa283, 0xa29d, 0xa2b8, 0xa2d2,
	0xa2ed, 0xa308, 0xa324, 0xa33c, 0xa355, 0xa36e, 0xa388, 0xa3a1,
	// Entry 2440 - 247F
	0xa3bb, 0xa3d5, 0xa3f0, 0xa409, 0xa423, 0xa43d, 0xa458, 0xa472,
	0xa48d, 0xa4a8, 0xa4c4, 0xa4dd, 0xa4f7, 0xa511, 0xa52c, 0xa546,
	0xa561, 0xa57c, 0xa598, 0xa5b2, 0xa5cd, 0xa5e8, 0xa604, 0xa61f,
	0xa63b, 0xa657, 0xa674, 0xa6a4, 0xa6db, 0xa706, 0xa732, 0xa75e,
	0xa782, 0xa7a1, 0xa7c1, 0xa7e7, 0xa80b, 0xa81f, 0xa835, 0xa850,
	0xa86c, 0xa887, 0xa8a3, 0xa8ca, 0xa8eb, 0xa8ff, 0xa915, 0xa944,
	0xa97a, 0xa99f, 0xa9d9, 0xaa1a, 0xaa2e, 0xaa43, 0xaa5e, 0xaa7a,
	0xaa9a, 0xaabb, 0xaae4, 0xab0e, 0xab2d, 0xab4c, 0xab66, 0xab80,
	// Entry 2480 - 24BF
	0xab9a, 0xabb4, 0xabd9, 0xabfe, 0xac23, 0xac48, 0xac71, 0xac9a,
	0xacc4, 0xacee, 0xad18, 0xad41, 0xad6b, 0xad95, 0xadb7, 0xade5,
	0xae15, 0xae44, 0xae74, 0xae92, 0xaeb3, 0xaece, 0xaeec, 0xaf0e,
	0xaf33, 0xaf5b, 0xaf86, 0xafa7, 0xafc4, 0xaff0, 0xb01c, 0xb048,
	0xb068, 0xb087, 0xb0a1, 0xb0c6, 0xb0f0, 0xb114, 0xb138, 0xb15c,
	0xb180, 0xb1a2, 0xb1c7, 0xb1ed, 0xb210, 0xb235, 0xb25b, 0xb281,
	0xb2a9, 0xb2d0, 0xb2f8, 0xb31d, 0xb344, 0xb36b, 0xb393, 0xb3bb,
	0xb3e5, 0xb40e, 0xb438, 0xb45f, 0xb488, 0xb4cd, 0xb512, 0xb559,
	// Entry 24C0 - 24FF
	0xb5a2, 0xb5e6, 0xb62e, 0xb672, 0xb6ba, 0xb6e8, 0xb718, 0xb747,
	0xb778, 0xb7bf, 0xb806, 0xb82a, 0xb84c, 0xb871, 0xb895, 0xb8ba,
	0xb8e0, 0xb8ff, 0xb920, 0xb943, 0xb960, 0xb97e, 0xb99c, 0xb9aa,
	0xb9b9, 0xb9c5, 0xb9d3, 0xb9f0, 0xb9ff, 0xba14, 0xba2c, 0xba45,
	0xba5b, 0xba72, 0xba8f, 0xbaad, 0xbacc, 0xbaec, 0xbb0d, 0xbb2f,
	0xbb5a, 0xbb89, 0xbbb7, 0xbbe3, 0xbbfe, 0xbc1a, 0xbc34, 0xbc52,
	0xbc76, 0xbc98, 0xbcb9, 0xbcdb, 0xbce7, 0xbcfb, 0xbd16, 0xbd35,
	0xbd52, 0xbd65, 0xbd70, 0xbd8c, 0xbda6, 0xbdb2, 0xbdc0, 0xbdd3,
	// Entry 2500 - 253F
	0xbdef, 0xbe07, 0xbe21, 0xbe63, 0xbea4, 0xbee8, 0xbf2b, 0xbf6d,
	0xbfae, 0xbff2, 0xc035, 0xc047, 0xc05d, 0xc07e, 0xc09e, 0xc0bd,
	0xc0d7, 0xc0eb, 0xc0fb, 0xc112, 0xc127, 0xc16c, 0xc186, 0xc1b1,
	0xc1c8, 0xc1dc, 0xc1ea, 0xc1fb, 0xc20f, 0xc234, 0xc263, 0xc280,
	0xc29e, 0xc2ae, 0xc2c2, 0xc2d0, 0xc2e2, 0xc2f9, 0xc30f, 0xc31c,
	0xc33a, 0xc35c, 0xc37d, 0xc39f, 0xc3ba, 0xc3d6, 0xc3e2, 0xc3fc,
	0xc417, 0xc426, 0xc435, 0xc446, 0xc458, 0xc470, 0xc489, 0xc49c,
	0xc4ad, 0xc4cf, 0xc4e4, 0xc501, 0xc50d, 0xc51c, 0xc53c, 0xc56d,
	// Entry 2540 - 257F
	0xc58e, 0xc59a, 0xc5a7, 0xc5d2, 0xc5fe, 0xc61b, 0xc628, 0xc644,
	0xc660, 0xc679, 0xc692, 0xc6ac, 0xc6c6, 0xc6df, 0xc6f8, 0xc704,
	0xc71c, 0xc730, 0xc756, 0xc761, 0xc774, 0xc77f, 0xc78a, 0xc7ac,
	0xc7cf, 0xc7d3, 0xc7d7, 0xc7f1, 0xc80c, 0xc828, 0xc845, 0xc863,
	0xc885, 0xc8a0, 0xc8b8, 0xc8cf, 0xc8e3, 0xc8f1, 0xc908, 0xc923,
	0xc937, 0xc952, 0xc96d, 0xc981, 0xc99a, 0xc9cc, 0xc9ff, 0xca26,
	0xca46, 0xca62, 0xca89, 0xcaa1, 0xcabb, 0xcace, 0xcae3, 0xcaf9,
	0xcafd, 0xcb19, 0xcb36, 0xcb4e, 0xcb6a, 0xcb8b, 0xcbb1, 0xcbcb,
	// Entry 2580 - 25BF
	0xcbe3, 0xcbfd, 0xcc19, 0xcc36, 0xcc51, 0xcc6a, 0xcc86, 0xcca1,
	0xccbe, 0xccdc, 0xccf3, 0xcd15, 0xcd36, 0xcd5b, 0xcd68, 0xcd8f,
	0xcdb7, 0xcde9, 0xce0d, 0xce22, 0xce37, 0xce4d, 0xce6c, 0xce7c,
	0xce96, 0xceb7, 0xced0, 0xcee5, 0xcefa, 0xcf0c, 0xcf25, 0xcf42,
	0xcf57, 0xcf6f, 0xcf87, 0xcfa9, 0xcfcb, 0xcfed, 0xd01d, 0xd035,
	0xd054, 0xd06e, 0xd081, 0xd0ab, 0xd0c5, 0xd0de, 0xd0f0, 0xd101,
	0xd11d, 0xd138, 0xd148, 0xd159, 0xd17b, 0xd197, 0xd1b2, 0xd1d2,
	0xd1f1, 0xd210, 0xd229, 0xd249, 0xd260, 0xd27e, 0xd29d, 0xd2be,
	// Entry 25C0 - 25FF
	0xd2de, 0xd2f8, 0xd310, 0xd341, 0xd372, 0xd38f, 0xd3ae, 0xd3c3,
	0xd3db, 0xd3ef, 0xd415, 0xd434, 0xd44f, 0xd46a, 0xd48a, 0xd49c,
	0xd4b8, 0xd4d6, 0xd508, 0xd527, 0xd543, 0xd562, 0xd584, 0xd5a9,
	0xd5c6, 0xd5e6, 0xd613, 0xd643, 0xd66f, 0xd69e, 0xd6d0, 0xd704,
	0xd71c, 0xd737, 0xd75d, 0xd786, 0xd7a3, 0xd7c3, 0xd7f7, 0xd82b,
	0xd84b, 0xd86e, 0xd898, 0xd8c2, 0xd8f6, 0xd92a, 0xd96e, 0xd9b2,
	0xd9cf, 0xd9ef, 0xda1c, 0xda4c, 0xda6d, 0xda91, 0xdaba, 0xdae6,
	0xdafa, 0xdb11, 0xdb3a, 0xdb66, 0xdb7d, 0xdb97, 0xdbbc, 0xdbde,
	// Entry 2600 - 263F
	0xdbfb, 0xdc14, 0xdc30, 0xdc5d, 0xdc8d, 0xdc99, 0xdca4, 0xdcbc,
	0xdcd3, 0xdcef, 0xdd15, 0xdd3b, 0xdd62, 0xdd89, 0xdda3, 0xddbd,
	0xddd8, 0xddf3, 0xde11, 0xde2f, 0xde51, 0xde73, 0xde82, 0xde91,
	0xdea0, 0xdeb1, 0xdecc, 0xdee9, 0xdf0e, 0xdf35, 0xdf59, 0xdf7f,
	0xdf9a, 0xdfb7, 0xdfd5, 0xdff5, 0xe014, 0xe035, 0xe051, 0xe06f,
	0xe08c, 0xe0aa, 0xe0b7, 0xe0c6, 0xe0df, 0xe0fa, 0xe10f, 0xe124,
	0xe137, 0xe14e, 0xe164, 0xe192, 0xe1ae, 0xe1c4, 0xe1dc, 0xe1e3,
	0xe1ed, 0xe1fc, 0xe20b, 0xe218, 0xe22c, 0xe24f, 0xe271, 0xe293,
	// Entry 2640 - 267F
	0xe2bc, 0xe2e9, 0xe305, 0xe320, 0xe343, 0xe353, 0xe361, 0xe377,
	0xe396, 0xe3c2, 0xe3e1, 0xe400, 0xe41b, 0xe43a, 0xe456, 0xe479,
	0xe4a3, 0xe4b8, 0xe4cf, 0xe4e9, 0xe512, 0xe53e, 0xe55c, 0xe57e,
	0xe595, 0xe5a7, 0xe5bf, 0xe5d5, 0xe5eb, 0xe601, 0xe617, 0xe62d,
	0xe642, 0xe655, 0xe66a, 0xe680, 0xe696, 0xe6ac, 0xe6c2, 0xe6d8,
	0xe6eb, 0xe70e, 0xe72f, 0xe751, 0xe771, 0xe78b, 0xe7a8, 0xe7d3,
	0xe7fd, 0xe819, 0xe836, 0xe851, 0xe86f, 0xe87c, 0xe88e, 0xe8a0,
	0xe8b7, 0xe8ce, 0xe8dc, 0xe8ea, 0xe8f7, 0xe904, 0xe91c, 0xe92e,
	// Entry 2680 - 26BF
	0xe942, 0xe956, 0xe96a, 0xe97e, 0xe991, 0xe9a4, 0xe9b7, 0xe9cf,
	0xe9e7, 0xe9fd, 0xea13, 0xea2f, 0xea45, 0xea61, 0xea7e, 0xeaad,
	0xeae3, 0xeb06, 0xeb2c, 0xeb4c, 0xeb7a, 0xebaf, 0xebd3, 0xec0c,
	0xec4c, 0xec65, 0xec86, 0xeca7, 0xecd3, 0xed00, 0xed25, 0xed46,
	0xed5f, 0xed79, 0xeda6, 0xedd4, 0xedf8, 0xee1d, 0xee49, 0xee76,
	0xee9c, 0xeeb5, 0xeed2, 0xeee3, 0xeef3, 0xef03, 0xef20, 0xef3d,
	0xef4f, 0xef6a, 0xef89, 0xef95, 0xefaa, 0xefce, 0xeff6, 0xf01e,
	0xf04a, 0xf077, 0xf0aa, 0xf0c9, 0xf0e6, 0xf106, 0xf125, 0xf145,
	// Entry 26C0 - 26FF
	0xf162, 0xf182, 0xf1a2, 0xf1c2, 0xf1e2, 0xf208, 0xf22c, 0xf253,
	0xf279, 0xf2a4, 0xf2d3, 0xf2f9, 0xf31d, 0xf344, 0xf36a, 0xf391,
	0xf3b8, 0xf3df, 0xf406, 0xf443, 0xf47e, 0xf4bc, 0xf4f9, 0xf50b,
	0xf51b, 0xf560, 0xf5aa, 0xf5ef, 0xf639, 0xf660, 0xf685, 0xf6ad,
	0xf6d4, 0xf6f7, 0xf718, 0xf73c, 0xf75f, 0xf791, 0xf7c4, 0xf7f5,
	0xf825, 0xf830, 0xf83c, 0xf848, 0xf855, 0xf87e, 0xf894, 0xf8c7,
	0xf8fa, 0xf92e, 0xf962, 0xf987, 0xf9aa, 0xf9d0, 0xf9f5, 0xfa2c,
	0xfa64, 0xfa99, 0xfacf, 0xfb04, 0xfb3a, 0xfb71, 0xfba9, 0xfbd3,
	// Entry 2700 - 273F
	0xfbfe, 0xfc26, 0xfc4f, 0xfc77, 0xfca0, 0xfcca, 0xfcf5, 0xfd0b,
	0xfd22, 0xfd36, 0xfd4b, 0xfd5f, 0xfd74, 0xfd8a, 0xfda1, 0xfdd1,
	0xfdf0, 0xfe07, 0xfe10, 0xfe1e, 0xfe32, 0xfe47, 0xfe5c, 0xfe74,
	0xfe81, 0xfeaa, 0xfed5, 0xff00, 0xff2c, 0xff41, 0xff59, 0xff76,
	0xff9b, 0xffb2, 0xffd1, 0xffea, 0xfffa, 0x002d, 0x005e, 0x0092,
	0x00c5, 0x00e2, 0x0100, 0x011e, 0x013f, 0x015e, 0x017d, 0x019e,
	0x01bd, 0x01dd, 0x01fb, 0x0221, 0x023c, 0x025c, 0x027a, 0x029b,
	0x02bc, 0x02db, 0x02f8, 0x0318, 0x0337, 0x0356, 0x0376, 0x0393,
	// Entry 2740 - 277F
	0x03b2, 0x03d0, 0x03ed, 0x0409, 0x0427, 0x0444, 0x0464, 0x0481,
	0x049f, 0x04bd, 0x04db, 0x04ff, 0x051b, 0x053e, 0x056b, 0x0587,
	0x05b2, 0x05d3, 0x05fc, 0x061a, 0x063b, 0x065c, 0x0682, 0x06ac,
	0x06c7, 0x06e3, 0x06ff, 0x071e, 0x073b, 0x0758, 0x0777, 0x0794,
	0x07b2, 0x07ce, 0x07f2, 0x080b, 0x0829, 0x0845, 0x0864, 0x0883,
	0x08a0, 0x08bb, 0x08d9, 0x08f6, 0x0913, 0x0931, 0x094c, 0x0969,
	0x0985, 0x09a0, 0x09ba, 0x09d6, 0x09f1, 0x0a0f, 0x0a2a, 0x0a46,
	0x0a62, 0x0a7e, 0x0aa0, 0x0aba, 0x0adb, 0x0b06, 0x0b20, 0x0b49,
	// Entry 2780 - 27BF
	0x0b68, 0x0b8f, 0x0bab, 0x0bca, 0x0be9, 0x0c0d, 0x0c35, 0x0c5b,
	0x0c7f, 0x0ca7, 0x0cc9, 0x0ce9, 0x0d09, 0x0d32, 0x0d57, 0x0d7a,
	0x0d9f, 0x0dc2, 0x0de7, 0x0e0a, 0x0e24, 0x0e44, 0x0e61, 0x0e82,
	0x0ea6, 0x0ec6, 0x0ee4, 0x0f02, 0x0f1d, 0x0f36, 0x0f55, 0x0f74,
	0x0f99, 0x0fc2, 0x0fe5, 0x1003, 0x101c, 0x1042, 0x1068, 0x1082,
	0x109a, 0x10b4, 0x10cc, 0x10e7, 0x1100, 0x111b, 0x1134, 0x114d,
	0x1164, 0x117d, 0x1194, 0x11ae, 0x11c6, 0x11e0, 0x11f8, 0x1214,
	0x122e, 0x1249, 0x1262, 0x127c, 0x1294, 0x12af, 0x12c8, 0x12e0,
	// Entry 27C0 - 27FF
	0x12f6, 0x130e, 0x1324, 0x133d, 0x1354, 0x136b, 0x1380, 0x1398,
	0x13ae, 0x13c6, 0x13dc, 0x13f6, 0x140e, 0x1427, 0x143e, 0x1456,
	0x146c, 0x1484, 0x149a, 0x14b3, 0x14ca, 0x14e3, 0x14fa, 0x1513,
	0x152a, 0x154e, 0x1570, 0x1594, 0x15b6, 0x15dd, 0x1602, 0x1626,
	0x1648, 0x166a, 0x168a, 0x16b0, 0x16d4, 0x16f8, 0x171a, 0x1735,
	0x174e, 0x1770, 0x1790, 0x17b5, 0x17d8, 0x17fc, 0x181e, 0x1841,
	0x1862, 0x1886, 0x18a8, 0x18cd, 0x18f0, 0x1913, 0x1934, 0x1955,
	0x1974, 0x1998, 0x19ba, 0x19de, 0x1a00, 0x1a27, 0x1a4c, 0x1a70,
	// Entry 2800 - 283F
	0x1a92, 0x1ab8, 0x1adc, 0x1b02, 0x1b26, 0x1b4a, 0x1b6c, 0x1b90,
	0x1bb2, 0x1bd6, 0x1bf8, 0x1c09, 0x1c1c, 0x1c2f, 0x1c44, 0x1c58,
	0x1c6c, 0x1c84, 0x1cac, 0x1cd2, 0x1cfc, 0x1d24, 0x1d3d, 0x1d5c,
	0x1d7b, 0x1d9e, 0x1dbf, 0x1dda, 0x1e00, 0x1e28, 0x1e47, 0x1e5f,
	0x1e6f, 0x1e8b, 0x1ea3, 0x1ebc, 0x1ed5, 0x1eee, 0x1f06, 0x1f1f,
	0x1f38, 0x1f51, 0x1f69, 0x1f82, 0x1f9b, 0x1fb4, 0x1fcd, 0x1fe5,
	0x1ffe, 0x2018, 0x2031, 0x204a, 0x2063, 0x207b, 0x2095, 0x20af,
	0x20c9, 0x20e2, 0x20fc, 0x2116, 0x212f, 0x2148, 0x2161, 0x217b,
	// Entry 2840 - 287F
	0x2194, 0x21ae, 0x21c7, 0x21df, 0x21f8, 0x2210, 0x2229, 0x2242,
	0x225a, 0x2273, 0x2285, 0x2298, 0x22ac, 0x22bf, 0x22d4, 0x22f6,
	0x2309, 0x231c, 0x2330, 0x2344, 0x2359, 0x236c, 0x237f, 0x2392,
	0x23ac, 0x23c1, 0x23d4, 0x23f6, 0x2410, 0x2424, 0x2437, 0x244b,
	0x2466, 0x2479, 0x2493, 0x24a5, 0x24b9, 0x24d5, 0x24f0, 0x2503,
	0x2516, 0x2529, 0x2544, 0x255f, 0x2572, 0x2584, 0x2597, 0x25ab,
	0x25bf, 0x25da, 0x25f3, 0x2606, 0x261a, 0x262e, 0x2641, 0x2655,
	0x2669, 0x267d, 0x2690, 0x26a3, 0x26b6, 0x26c9, 0x26e7, 0x26fb,
	// Entry 2880 - 28BF
	0x270d, 0x271f, 0x274a, 0x2761, 0x277a, 0x278f, 0x27a4, 0x27b9,
	0x27ce, 0x27e4, 0x27f9, 0x280e, 0x2823, 0x2838, 0x284e, 0x286a,
	0x287f, 0x2894, 0x28aa, 0x28bf, 0x28d5, 0x28eb, 0x2901, 0x2916,
	0x292c, 0x2942, 0x2959, 0x296f, 0x2984, 0x2999, 0x29ae, 0x29c4,
	0x29da, 0x29ef, 0x2a04, 0x2a19, 0x2a2e, 0x2a43, 0x2a59, 0x2a6f,
	0x2a84, 0x2a99, 0x2aae, 0x2ac3, 0x2ad8, 0x2aee, 0x2b04, 0x2b19,
	0x2b2e, 0x2b44, 0x2b5a, 0x2b70, 0x2b87, 0x2b9e, 0x2bb4, 0x2bca,
	0x2bdf, 0x2bf4, 0x2c09, 0x2c1f, 0x2c35, 0x2c4a, 0x2c5f, 0x2c74,
	// Entry 28C0 - 28FF
	0x2c89, 0x2c9e, 0x2cb4, 0x2cca, 0x2cdf, 0x2cf4, 0x2d09, 0x2d1e,
	0x2d33, 0x2d49, 0x2d5f, 0x2d74, 0x2d89, 0x2d9e, 0x2db3, 0x2dc8,
	0x2dde, 0x2df4, 0x2e09, 0x2e1e, 0x2e3a, 0x2e56, 0x2e73, 0x2e8f,
	0x2eac, 0x2ec8, 0x2ee4, 0x2f00, 0x2f1c, 0x2f38, 0x2f53, 0x2f6f,
	0x2f8b, 0x2fa7, 0x2fc3, 0x2fdf, 0x2ffc, 0x3019, 0x3036, 0x3055,
	0x3073, 0x3092, 0x30ad, 0x30c9, 0x30e8, 0x310e, 0x312b, 0x3147,
	0x316b, 0x318f, 0x31b0, 0x31da, 0x31f9, 0x321f, 0x3238, 0x3252,
	0x3272, 0x3293, 0x32ae, 0x32d0, 0x32eb, 0x3305, 0x3320, 0x332d,
	// Entry 2900 - 293F
	0x3349, 0x3366, 0x3377, 0x3382, 0x3394, 0x33af, 0x33bb, 0x33c8,
	0x33d8, 0x33e6, 0x3401, 0x3416, 0x342a, 0x3435, 0x344a, 0x345f,
	0x347a, 0x3496, 0x34aa, 0x34be, 0x34da, 0x34f7, 0x350c, 0x3522,
	0x353a, 0x3553, 0x356a, 0x3582, 0x3599, 0x35b1, 0x35d2, 0x35f3,
	0x360f, 0x361c, 0x3632, 0x3640, 0x364a, 0x3663, 0x366f, 0x3679,
	0x3685, 0x3695, 0x36ab, 0x36c2, 0x36cf, 0x36e4, 0x36ef, 0x36fc,
	0x3712, 0x3723, 0x3737, 0x3740, 0x374d, 0x375b, 0x377f, 0x3794,
	0x37aa, 0x37bc, 0x37cd, 0x37e3, 0x37f9, 0x3811, 0x3823, 0x3832,
	// Entry 2940 - 297F
	0x3843, 0x3858, 0x386d, 0x3883, 0x3893, 0x38a8, 0x38bd, 0x38d1,
	0x38e5, 0x38fb, 0x3910, 0x3921, 0x3933, 0x3948, 0x395d, 0x3972,
	0x3987, 0x3997, 0x39a6, 0x39b7, 0x39c6, 0x39d6, 0x39e7, 0x39f9,
	0x3a0d, 0x3a22, 0x3a37, 0x3a47, 0x3a5a, 0x3a6d, 0x3a93, 0x3aa2,
	0x3ab1, 0x3ac1, 0x3ada, 0x3ae9, 0x3aff, 0x3b15, 0x3b27, 0x3b37,
	0x3b54, 0x3b67, 0x3b7a, 0x3b8f, 0x3ba3, 0x3bb3, 0x3bc4, 0x3bd3,
	0x3be2, 0x3bf1, 0x3c06, 0x3c1b, 0x3c2b, 0x3c3d, 0x3c52, 0x3c67,
	0x3c7e, 0x3c8f, 0x3ca2, 0x3cb6, 0x3cca, 0x3ce6, 0x3d01, 0x3d11,
	// Entry 2980 - 29BF
	0x3d30, 0x3d4e, 0x3d5e, 0x3d7b, 0x3d96, 0x3daa, 0x3dbe, 0x3dce,
	0x3deb, 0x3dff, 0x3e13, 0x3e30, 0x3e4d, 0x3e62, 0x3e77, 0x3e87,
	0x3e97, 0x3ebe, 0x3edb, 0x3ef8, 0x3f14, 0x3f27, 0x3f3a, 0x3f4f,
	0x3f6b, 0x3f7b, 0x3f99, 0x3fa9, 0x3fba, 0x3fd7, 0x3ff4, 0x4011,
	0x402d, 0x404a, 0x4067, 0x4084, 0x40a1, 0x40bf, 0x40dd, 0x40fc,
	0x411b, 0x412d, 0x414c, 0x416b, 0x417d, 0x4190, 0x41a2, 0x41b6,
	0x41cb, 0x41de, 0x41f0, 0x4202, 0x4214, 0x4227, 0x423b, 0x424f,
	0x4266, 0x427a, 0x428c, 0x42a0, 0x42b7, 0x42cb, 0x42df, 0x42f2,
	// Entry 29C0 - 29FF
	0x4306, 0x4323, 0x4342, 0x4354, 0x436d, 0x4380, 0x4394, 0x43aa,
	0x43be, 0x43d2, 0x43ea, 0x43fe, 0x4414, 0x4425, 0x443d, 0x4453,
	0x4465, 0x4479, 0x448d, 0x44a0, 0x44b3, 0x44c7, 0x44da, 0x44ef,
	0x4504, 0x451b, 0x452f, 0x4542, 0x4558, 0x456d, 0x457f, 0x459a,
	0x45b5, 0x45cf, 0x45e7, 0x45fb, 0x460d, 0x4621, 0x4637, 0x464a,
	0x465e, 0x4674, 0x4687, 0x469a, 0x46af, 0x46c1, 0x46d6, 0x46eb,
	0x46fd, 0x4712, 0x4724, 0x4736, 0x4748, 0x475b, 0x476e, 0x4781,
	0x4794, 0x47a8, 0x47bd, 0x47d2, 0x47e8, 0x47fa, 0x480d, 0x4821,
	// Entry 2A00 - 2A3F
	0x4835, 0x4848, 0x485b, 0x4870, 0x4887, 0x48a5, 0x48b9, 0x48cc,
	0x48de, 0x48f0, 0x4907, 0x491a, 0x492e, 0x4941, 0x4955, 0x4968,
	0x497a, 0x498e, 0x49aa, 0x49c1, 0x49db, 0x49ef, 0x4a02, 0x4a15,
	0x4a27, 0x4a3b, 0x4a4f, 0x4a63, 0x4a78, 0x4a8c, 0x4aa0, 0x4ab3,
	0x4ac7, 0x4adc, 0x4aef, 0x4b02, 0x4b14, 0x4b26, 0x4b3a, 0x4b50,
	0x4b62, 0x4b74, 0x4b87, 0x4b99, 0x4bad, 0x4bc0, 0x4bd7, 0x4bea,
	0x4bff, 0x4c14, 0x4c29, 0x4c3e, 0x4c51, 0x4c68, 0x4c7c, 0x4c90,
	0x4ca4, 0x4cb9, 0x4ccd, 0x4cea, 0x4d00, 0x4d13, 0x4d25, 0x4d38,
	// Entry 2A40 - 2A7F
	0x4d4d, 0x4d62, 0x4d75, 0x4d87, 0x4d9c, 0x4db0, 0x4dc2, 0x4dd4,
	0x4de7, 0x4dfa, 0x4e0d, 0x4e22, 0x4e38, 0x4e4b, 0x4e5e, 0x4e71,
	0x4e8b, 0x4ea1, 0x4eb4, 0x4ec7, 0x4eda, 0x4eee, 0x4f02, 0x4f22,
	0x4f35, 0x4f48, 0x4f5c, 0x4f6f, 0x4f85, 0x4fa2, 0x4fb5, 0x4fc9,
	0x4fdc, 0x4fef, 0x5001, 0x5013, 0x5026, 0x503d, 0x5051, 0x5064,
	0x5077, 0x508a, 0x509e, 0x50bd, 0x50d4, 0x50e8, 0x50fb, 0x510e,
	0x5121, 0x5134, 0x5148, 0x515b, 0x5170, 0x5185, 0x5199, 0x51b2,
	0x51c5, 0x51da, 0x51ed, 0x51ff, 0x5212, 0x5225, 0x5239, 0x524e,
	// Entry 2A80 - 2ABF
	0x5263, 0x5277, 0x52a6, 0x52d6, 0x5310, 0x534b, 0x537a, 0x53af,
	0x53e4, 0x5418, 0x5452, 0x548d, 0x54c7, 0x54f1, 0x5502, 0x5513,
	0x5528, 0x5532, 0x5555, 0x556f, 0x5587, 0x559e, 0x55b0, 0x55c3,
	0x55dc, 0x55f6, 0x5609, 0x561d, 0x5636, 0x5650, 0x566d, 0x568b,
	0x5696, 0x569f, 0x56ba, 0x56d6, 0x56f3, 0x5711, 0x5732, 0x5754,
	0x576d, 0x5787, 0x5790, 0x57b4, 0x57cf, 0x57ee, 0x57fe, 0x5812,
	0x5826, 0x583c, 0x5851, 0x5866, 0x587a, 0x5890, 0x58a6, 0x58bb,
	0x58d6, 0x58f2, 0x5911, 0x592f, 0x594a, 0x5965, 0x596e, 0x5987,
	// Entry 2AC0 - 2AFF
	0x59b2, 0x59d6, 0x5a0c, 0x5a30, 0x5a43, 0x5a73, 0x5a87, 0x5a9e,
	0x5ab5, 0x5ad8, 0x5ae1, 0x5af6, 0x5b15, 0x5b30, 0x5b47, 0x5b58,
	0x5b6f, 0x5b80, 0x5b97, 0x5ba8, 0x5bbf, 0x5bd0, 0x5be7, 0x5bf8,
	0x5c0a, 0x5c1c, 0x5c2e, 0x5c40, 0x5c52, 0x5c64, 0x5c76, 0x5c88,
	0x5c9a, 0x5cac, 0x5cbe, 0x5cd0, 0x5ce2, 0x5cf4, 0x5d06, 0x5d18,
	0x5d2a, 0x5d3c, 0x5d4e, 0x5d60, 0x5d72, 0x5d84, 0x5d96, 0x5da8,
	0x5dc0, 0x5dd2, 0x5de4, 0x5df6, 0x5e08, 0x5e1a, 0x5e2c, 0x5e3e,
	0x5e50, 0x5e62, 0x5e74, 0x5e86, 0x5e98, 0x5eaa, 0x5ebc, 0x5ece,
	// Entry 2B00 - 2B3F
	0x5ee0, 0x5ef2, 0x5f04, 0x5f16, 0x5f28, 0x5f3a, 0x5f4c, 0x5f5e,
	0x5f70, 0x5f82, 0x5f94, 0x5fa6, 0x5fb8, 0x5fca, 0x5fdc, 0x5fee,
	0x6006, 0x6018, 0x6030, 0x6042, 0x605a, 0x606c, 0x607e, 0x6090,
	0x60a2, 0x60b4, 0x60c6, 0x60de, 0x60f0, 0x6102, 0x6114, 0x6126,
	0x6137, 0x6149, 0x6161, 0x6179, 0x61a6, 0x61d8, 0x61fb, 0x6223,
	0x623a, 0x6258, 0x626d, 0x628c, 0x62a3, 0x62b4, 0x62cb, 0x62dc,
	0x62f3, 0x6304, 0x631b, 0x632c, 0x6343, 0x6354, 0x6366, 0x6378,
	0x638a, 0x639c, 0x63ae, 0x63c0, 0x63d2, 0x63e4, 0x63f6, 0x6408,
	// Entry 2B40 - 2B7F
	0x641a, 0x642c, 0x643e, 0x6450, 0x6462, 0x6474, 0x6486, 0x6498,
	0x64aa, 0x64bc, 0x64ce, 0x64e0, 0x64f2, 0x6504, 0x651c, 0x652e,
	0x6540, 0x6552, 0x6564, 0x6576, 0x6588, 0x659a, 0x65ac, 0x65be,
	0x65d0, 0x65e2, 0x65f4, 0x6606, 0x6618, 0x662a, 0x663c, 0x664e,
	0x6660, 0x6672, 0x6684, 0x6696, 0x66a8, 0x66ba, 0x66cc, 0x66de,
	0x66f0, 0x6702, 0x6714, 0x6726, 0x6738, 0x674a, 0x6762, 0x6774,
	0x678c, 0x679e, 0x67b6, 0x67c8, 0x67da, 0x67ec, 0x67fe, 0x6810,
	0x6822, 0x683a, 0x684c, 0x685e, 0x6870, 0x6882, 0x6893, 0x68a5,
	// Entry 2B80 - 2BBF
	0x68bd, 0x68d5, 0x68e7, 0x68f9, 0x690b, 0x691d, 0x6930, 0x6956,
	0x696d, 0x698b, 0x69a0, 0x69b1, 0x69c2, 0x69d3, 0x69e4, 0x69f5,
	0x6a06, 0x6a17, 0x6a28, 0x6a39, 0x6a4a, 0x6a5b, 0x6a6c, 0x6a7d,
	0x6a8e, 0x6aa0, 0x6ab2, 0x6ac4, 0x6ad5, 0x6ae6, 0x6af7, 0x6b08,
	0x6b19, 0x6b2a, 0x6b3b, 0x6b4d, 0x6b5f, 0x6b71, 0x6b83, 0x6b95,
	0x6ba7, 0x6bb9, 0x6bcc, 0x6bdf, 0x6bf1, 0x6c02, 0x6c13, 0x6c25,
	0x6c36, 0x6c48, 0x6c5a, 0x6c6c, 0x6c80, 0x6c99, 0x6cb2, 0x6cc5,
	0x6cde, 0x6cf7, 0x6d0b, 0x6d24, 0x6d37, 0x6d51, 0x6d6a, 0x6d83,
	// Entry 2BC0 - 2BFF
	0x6d9b, 0x6db6, 0x6dd1, 0x6dea, 0x6dfd, 0x6e10, 0x6e28, 0x6e40,
	0x6e52, 0x6e69, 0x6e7c, 0x6e8f, 0x6ea7, 0x6ebc, 0x6ed1, 0x6ee6,
	0x6efb, 0x6f0e, 0x6f1d, 0x6f2d, 0x6f3d, 0x6f4e, 0x6f5e, 0x6f6d,
	0x6f7e, 0x6f8e, 0x6f9d, 0x6fad, 0x6fbe, 0x6fce, 0x6fde, 0x6fed,
	0x6ffe, 0x700e, 0x701e, 0x702e, 0x703e, 0x704e, 0x705d, 0x706a,
	0x7082, 0x709c, 0x70b4, 0x70cf, 0x70ee, 0x7108, 0x7126, 0x7141,
	0x7160, 0x7179, 0x7191, 0x71ac, 0x71c7, 0x71e1, 0x71fb, 0x721a,
	0x7239, 0x7252, 0x726d, 0x7288, 0x72a8, 0x72c1, 0x72d9, 0x72f2,
	// Entry 2C00 - 2C3F
	0x730a, 0x7322, 0x7337, 0x734f, 0x7365, 0x7380, 0x739e, 0x73bb,
	0x73d3, 0x73ec, 0x73ff, 0x7413, 0x7425, 0x7439, 0x744c, 0x745e,
	0x7471, 0x7485, 0x74a8, 0x74cb, 0x74ea, 0x7509, 0x752a, 0x754a,
	0x7569, 0x758b, 0x75ad, 0x75ce, 0x75f0, 0x7611, 0x7633, 0x7655,
	0x7676, 0x7695, 0x76a7, 0x76b9, 0x76cb, 0x76dd, 0x76ef, 0x7702,
	0x7714, 0x7727, 0x7739, 0x774c, 0x775f, 0x7772, 0x7784, 0x7797,
	0x77ab, 0x77bf, 0x77d1, 0x77e3, 0x77f6, 0x780a, 0x7821, 0x7838,
	0x784f, 0x7866, 0x7878, 0x788a, 0x789c, 0x78a8, 0x78b5, 0x78c2,
	// Entry 2C40 - 2C7F
	0x78d0, 0x78dd, 0x78eb, 0x78f9, 0x7906, 0x7915, 0x7924, 0x7932,
	0x7941, 0x7950, 0x795e, 0x796d, 0x7979, 0x7985, 0x7991, 0x799d,
	0x79aa, 0x79b6, 0x79c3, 0x79d0, 0x79dd, 0x79eb, 0x79f8, 0x7a05,
	0x7a12, 0x7a1f, 0x7a2c, 0x7a3a, 0x7a48, 0x7a57, 0x7a67, 0x7a74,
	0x7a80, 0x7a98, 0x7ab0, 0x7ac8, 0x7ae0, 0x7af8, 0x7b10, 0x7b28,
	0x7b40, 0x7b58, 0x7b70, 0x7b88, 0x7ba0, 0x7bb8, 0x7bd0, 0x7be8,
	0x7c00, 0x7c1b, 0x7c35, 0x7c50, 0x7c6a, 0x7c84, 0x7c9e, 0x7cb7,
	0x7cd1, 0x7ceb, 0x7d07, 0x7d23, 0x7d3f, 0x7d5b, 0x7d75, 0x7d92,
	// Entry 2C80 - 2CBF
	0x7dae, 0x7dcb, 0x7de7, 0x7e03, 0x7e1f, 0x7e3a, 0x7e56, 0x7e72,
	0x7e90, 0x7eae, 0x7ecc, 0x7eea, 0x7f06, 0x7f22, 0x7f46, 0x7f69,
	0x7f84, 0x7f9f, 0x7fbc, 0x7fd8, 0x7ff4, 0x800f, 0x802c, 0x8049,
	0x8065, 0x8080, 0x809c, 0x80b8, 0x80d5, 0x80f1, 0x810e, 0x812b,
	0x8146, 0x8163, 0x817f, 0x819e, 0x81ba, 0x81d9, 0x81fa, 0x8220,
	0x823d, 0x825e, 0x827a, 0x8297, 0x82b8, 0x82da, 0x82fa, 0x831a,
	0x833a, 0x8356, 0x8372, 0x838f, 0x83a9, 0x83c7, 0x83df, 0x83f5,
	0x8417, 0x843c, 0x8461, 0x8485, 0x84a9, 0x84cd, 0x84f3, 0x8518,
	// Entry 2CC0 - 2CFF
	0x8528, 0x8541, 0x855a, 0x8575, 0x858f, 0x85a9, 0x85c2, 0x85dd,
	0x85f8, 0x8612, 0x8627, 0x8640, 0x8659, 0x8674, 0x868e, 0x86a8,
	0x86bd, 0x86d1, 0x86e6, 0x86fa, 0x870e, 0x8722, 0x8735, 0x8749,
	0x875d, 0x8773, 0x8789, 0x879f, 0x87b5, 0x87c9, 0x87e0, 0x87f6,
	0x880d, 0x8823, 0x8839, 0x884f, 0x8864, 0x887a, 0x8890, 0x88a8,
	0x88c0, 0x88d8, 0x88f0, 0x8906, 0x8925, 0x8943, 0x8959, 0x896f,
	0x8984, 0x8999, 0x89b0, 0x89c6, 0x89dc, 0x89f1, 0x8a08, 0x8a1f,
	0x8a35, 0x8a4a, 0x8a60, 0x8a76, 0x8a8d, 0x8aa3, 0x8aba, 0x8ad1,
	// Entry 2D00 - 2D3F
	0x8ae6, 0x8afd, 0x8b13, 0x8b2c, 0x8b42, 0x8b5b, 0x8b76, 0x8b96,
	0x8bad, 0x8bc5, 0x8bdb, 0x8bf3, 0x8c0d, 0x8c28, 0x8c3f, 0x8c5a,
	0x8c70, 0x8c86, 0x8c9c, 0x8cb5, 0x8ccb, 0x8ce3, 0x8cf8, 0x8d0e,
	0x8d25, 0x8d3f, 0x8d59, 0x8d70, 0x8d8b, 0x8da7, 0x8dc1, 0x8ddb,
	0x8df2, 0x8e0b, 0x8e26, 0x8e41, 0x8e5b, 0x8e6f, 0x8e87, 0x8e9f,
	0x8eb9, 0x8ed2, 0x8eeb, 0x8f03, 0x8f1d, 0x8f37, 0x8f50, 0x8f64,
	0x8f8c, 0x8fb5, 0x8fdb, 0x9001, 0x9025, 0x904a, 0x906f, 0x9096,
	0x90c0, 0x90e8, 0x9111, 0x913a, 0x9143, 0x914d, 0x9156, 0x916c,
	// Entry 2D40 - 2D7F
	0x917e, 0x9190, 0x91a2, 0x91b4, 0x91c6, 0x91d9, 0x91ec, 0x91ff,
	0x9212, 0x9225, 0x9238, 0x924b, 0x925e, 0x9271, 0x9284, 0x9297,
	0x92aa, 0x92bd, 0x92d0, 0x92e3, 0x92f6, 0x9309, 0x931c, 0x932f,
	0x9342, 0x9355, 0x9368, 0x937b, 0x938e, 0x93a1, 0x93b4, 0x93c7,
	0x93da, 0x93ed, 0x9400, 0x9413, 0x9426, 0x9439, 0x944c, 0x945f,
	0x9472, 0x9485, 0x9498, 0x94ab, 0x94be, 0x94d1, 0x94e4, 0x94f1,
	0x94fe, 0x950a, 0x9515, 0x9522, 0x952d, 0x9537, 0x9546, 0x9552,
	0x955d, 0x9568, 0x9574, 0x9582, 0x9590, 0x959c, 0x95a8, 0x95b3,
	// Entry 2D80 - 2DBF
	0x95bf, 0x95cc, 0x95da, 0x95e5, 0x95f6, 0x9608, 0x9618, 0x9625,
	0x9635, 0x9645, 0x9653, 0x965f, 0x966c, 0x9678, 0x9686, 0x9695,
	0x96a3, 0x96af, 0x96bb, 0x96c7, 0x96d2, 0x96dd, 0x96e7, 0x96f2,
	0x96fe, 0x970a, 0x9719, 0x9725, 0x9733, 0x9743, 0x9750, 0x975b,
	0x9766, 0x9775, 0x9782, 0x9791, 0x979d, 0x97ad, 0x97b8, 0x97c5,
	0x97d2, 0x97de, 0x97ea, 0x97f6, 0x9803, 0x9810, 0x981a, 0x9826,
	0x9832, 0x983d, 0x984b, 0x9857, 0x9863, 0x9870, 0x987e, 0x988c,
	0x9897, 0x98a7, 0x98b2, 0x98c0, 0x98ce, 0x98da, 0x98e6, 0x98f1,
	// Entry 2DC0 - 2DFF
	0x98ff, 0x990a, 0x9916, 0x9924, 0x992f, 0x993e, 0x994a, 0x9974,
	0x999d, 0x99c6, 0x99f1, 0x9a1b, 0x9a45, 0x9a6e, 0x9a99, 0x9ac4,
	0x9aee, 0x9b17, 0x9b43, 0x9b6f, 0x9b9d, 0x9bcb, 0x9bf8, 0x9c25,
	0x9c54, 0x9c82, 0x9cb0, 0x9cdc, 0x9d0c, 0x9d3c, 0x9d6e, 0x9d9f,
	0x9da9, 0x9db2, 0x9dbb, 0x9dc5, 0x9dce, 0x9dd7, 0x9de0, 0x9df1,
	0x9e00, 0x9e09, 0x9e1f, 0x9e35, 0x9e4c, 0x9e61, 0x9e73, 0x9e81,
	0x9e8a, 0x9e95, 0x9e9e, 0x9ea7, 0x9eb0, 0x9eb9, 0x9ec2, 0x9ecc,
	0x9ed7, 0x9ee0, 0x9ee9, 0x9ef4, 0x9eff, 0x9f08, 0x9f11, 0x9f1a,
	// Entry 2E00 - 2E3F
	0x9f24, 0x9f2e, 0x9f38, 0x9f42, 0x9f4d, 0x9f56, 0x9f5f, 0x9f68,
	0x9f71, 0x9f7a, 0x9f85, 0x9f8e, 0x9f97, 0x9fa0, 0x9fb1, 0x9fc2,
	0x9fd2, 0x9fe3, 0x9ff2, 0xa001, 0xa00f, 0xa01e, 0xa02d, 0xa044,
	0xa04d, 0xa057, 0xa061, 0xa06b, 0xa075, 0xa086, 0xa09f, 0xa0a8,
	0xa0b1, 0xa0bc, 0xa0c5, 0xa0ce, 0xa0d7, 0xa0e2, 0xa0eb, 0xa0f4,
	0xa102, 0xa10b, 0xa114, 0xa11f, 0xa128, 0xa131, 0xa13f, 0xa14b,
	0xa157, 0xa160, 0xa169, 0xa172, 0xa17b, 0xa18b, 0xa194, 0xa19d,
	0xa1a6, 0xa1af, 0xa1b8, 0xa1c1, 0xa1ca, 0xa1db, 0xa1e4, 0xa1ed,
	// Entry 2E40 - 2E7F
	0xa1f6, 0xa200, 0xa209, 0xa218, 0xa222, 0xa22c, 0xa235, 0xa23e,
	0xa248, 0xa251, 0xa25a, 0xa263, 0xa26c, 0xa27b, 0xa28a, 0xa2b2,
	0xa2da, 0xa304, 0xa32d, 0xa356, 0xa37e, 0xa3a8, 0xa3d2, 0xa3fb,
	0xa423, 0xa44e, 0xa479, 0xa4a6, 0xa4d3, 0xa4ff, 0xa52b, 0xa559,
	0xa586, 0xa5b3, 0xa5de, 0xa60d, 0xa63c, 0xa66d, 0xa69d, 0xa6cd,
	0xa6fc, 0xa72d, 0xa75e, 0xa78e, 0xa7b9, 0xa7e8, 0xa7f2, 0xa812,
	0xa832, 0xa85a, 0xa875, 0xa889, 0xa89e, 0xa8b3, 0xa8d0, 0xa8e9,
	0xa8fe, 0xa910, 0xa927, 0xa93e, 0xa95b, 0xa96f, 0xa986, 0xa99c,
	// Entry 2E80 - 2EBF
	0xa9bc, 0xa9d1, 0xa9eb, 0xaa06, 0xaa18, 0xaa34, 0xaa47, 0xaa5d,
	0xaa76, 0xaa90, 0xaab0, 0xaace, 0xaaec, 0xab02, 0xab17, 0xab2b,
	0xab43, 0xab58, 0xab7b, 0xab92, 0xaba9, 0xabc1, 0xabd9, 0xabee,
	0xac03, 0xac1c, 0xac37, 0xac56, 0xac71, 0xac88, 0xac9d, 0xacb4,
	0xaccd, 0xacee, 0xad15, 0xad2d, 0xad4d, 0xad63, 0xad7c, 0xad98,
	0xadb4, 0xadcb, 0xade2, 0xadfa, 0xae1a, 0xae37, 0xae55, 0xae63,
	0xae71, 0xae7e, 0xae8c, 0xae9b, 0xaeaa, 0xaeb8, 0xaec7, 0xaed5,
	0xaee3, 0xaef0, 0xaefe, 0xaf0d, 0xaf1b, 0xaf2a, 0xaf38, 0xaf46,
	// Entry 2EC0 - 2EFF
	0xaf53, 0xaf61, 0xaf6f, 0xaf7c, 0xaf8a, 0xaf99, 0xafa8, 0xafb6,
	0xafc5, 0xafd5, 0xafe5, 0xaff4, 0xb004, 0xb013, 0xb022, 0xb030,
	0xb03f, 0xb04f, 0xb05e, 0xb06e, 0xb07d, 0xb08c, 0xb09a, 0xb0a9,
	0xb0b8, 0xb0c6, 0xb0d5, 0xb0e4, 0xb0f3, 0xb101, 0xb110, 0xb120,
	0xb12f, 0xb13e, 0xb14d, 0xb15b, 0xb16a, 0xb17a, 0xb189, 0xb198,
	0xb1a7, 0xb1b5, 0xb1c4, 0xb1d4, 0xb1e3, 0xb1f3, 0xb202, 0xb211,
	0xb21f, 0xb22e, 0xb23e, 0xb24d, 0xb25d, 0xb26c, 0xb27b, 0xb289,
	0xb298, 0xb2a7, 0xb2b6, 0xb2c4, 0xb2d3, 0xb2e3, 0xb2f2, 0xb301,
	// Entry 2F00 - 2F3F
	0xb310, 0xb31e, 0xb32d, 0xb33d, 0xb34c, 0xb35c, 0xb36c, 0xb37b,
	0xb38b, 0xb39c, 0xb3ad, 0xb3bd, 0xb3ce, 0xb3de, 0xb3ee, 0xb3fd,
	0xb40d, 0xb41e, 0xb42e, 0xb43f, 0xb44f, 0xb45f, 0xb46e, 0xb47e,
	0xb48e, 0xb49d, 0xb4ad, 0xb4bd, 0xb4cd, 0xb4dc, 0xb4ec, 0xb4fd,
	0xb50d, 0xb51d, 0xb52d, 0xb53c, 0xb54c, 0xb55c, 0xb56c, 0xb57b,
	0xb58b, 0xb59c, 0xb5ac, 0xb5bd, 0xb5cd, 0xb5dd, 0xb5ec, 0xb5fc,
	0xb60c, 0xb61c, 0xb62b, 0xb63b, 0xb64b, 0xb65b, 0xb66a, 0xb67a,
	0xb68b, 0xb69b, 0xb6ab, 0xb6bb, 0xb6ca, 0xb6da, 0xb6eb, 0xb6fb,
	// Entry 2F40 - 2F7F
	0xb70b, 0xb71b, 0xb72a, 0xb73a, 0xb74b, 0xb75b, 0xb76c, 0xb77c,
	0xb78c, 0xb79b, 0xb7ab, 0xb7bc, 0xb7cc, 0xb7dd, 0xb7ed, 0xb7fd,
	0xb80c, 0xb81c, 0xb82c, 0xb83c, 0xb84b, 0xb85b, 0xb86c, 0xb87c,
	0xb88c, 0xb89b, 0xb8ab, 0xb8bc, 0xb8cc, 0xb8db, 0xb8ea, 0xb8f8,
	0xb907, 0xb917, 0xb926, 0xb936, 0xb945, 0xb954, 0xb962, 0xb971,
	0xb981, 0xb991, 0xb9a0, 0xb9b0, 0xb9bf, 0xb9ce, 0xb9dc, 0xb9eb,
	0xb9fa, 0xba08, 0xba17, 0xba26, 0xba34, 0xba43, 0xba53, 0xba62,
	0xba71, 0xba80, 0xba8e, 0xba9d, 0xbaac, 0xbabb, 0xbac9, 0xbad8,
	// Entry 2F80 - 2FBF
	0xbae7, 0xbaf6, 0xbb04, 0xbb13, 0xbb22, 0xbb30, 0xbb3f, 0xbb4e,
	0xbb5d, 0xbb6b, 0xbb7a, 0xbb8a, 0xbb99, 0xbba8, 0xbbb7, 0xbbc5,
	0xbbd4, 0xbbe3, 0xbbf2, 0xbc00, 0xbc0f, 0xbc1f, 0xbc2f, 0xbc3e,
	0xbc4e, 0xbc5d, 0xbc6c, 0xbc7a, 0xbc89, 0xbc98, 0xbca7, 0xbcb5,
	0xbcc4, 0xbcd3, 0xbce2, 0xbcf1, 0xbd00, 0xbd0e, 0xbd1d, 0xbd2d,
	0xbd3c, 0xbd4b, 0xbd5a, 0xbd68, 0xbd77, 0xbd87, 0xbd96, 0xbda5,
	0xbdb4, 0xbdc2, 0xbdd1, 0xbde1, 0xbdf0, 0xbe00, 0xbe0f, 0xbe1e,
	0xbe2c, 0xbe3b, 0xbe4b, 0xbe5a, 0xbe69, 0xbe78, 0xbe86, 0xbe95,
	// Entry 2FC0 - 2FFF
	0xbea4, 0xbeb2, 0xbec1, 0xbed0, 0xbedf, 0xbeed, 0xbefc, 0xbf0c,
	0xbf1b, 0xbf2a, 0xbf39, 0xbf47, 0xbf56, 0xbf66, 0xbf75, 0xbf85,
	0xbf94, 0xbfa3, 0xbfb1, 0xbfc0, 0xbfd0, 0xbfe0, 0xbfef, 0xbfff,
	0xc00e, 0xc01d, 0xc02b, 0xc03a, 0xc049, 0xc057, 0xc066, 0xc075,
	0xc084, 0xc092, 0xc0a1, 0xc0b1, 0xc0c0, 0xc0d0, 0xc0e0, 0xc0ef,
	0xc0ff, 0xc110, 0xc120, 0xc131, 0xc141, 0xc151, 0xc160, 0xc170,
	0xc181, 0xc191, 0xc1a2, 0xc1b2, 0xc1c2, 0xc1d1, 0xc1e1, 0xc1f1,
	0xc200, 0xc210, 0xc220, 0xc230, 0xc23f, 0xc24f, 0xc260, 0xc270,
	// Entry 3000 - 303F
	0xc280, 0xc290, 0xc29f, 0xc2af, 0xc2c0, 0xc2d0, 0xc2e0, 0xc2f0,
	0xc2ff, 0xc30f, 0xc31f, 0xc32f, 0xc33e, 0xc34e, 0xc35e, 0xc36d,
	0xc37d, 0xc38d, 0xc39d, 0xc3ac, 0xc3bc, 0xc3cd, 0xc3dd, 0xc3ed,
	0xc3fd, 0xc40c, 0xc41c, 0xc42d, 0xc43e, 0xc44e, 0xc45f, 0xc46f,
	0xc47f, 0xc48e, 0xc49e, 0xc4af, 0xc4bf, 0xc4cf, 0xc4df, 0xc4ef,
	0xc4ff, 0xc50e, 0xc51e, 0xc52e, 0xc53d, 0xc54c, 0xc55a, 0xc569,
	0xc579, 0xc588, 0xc598, 0xc5a7, 0xc5b5, 0xc5c4, 0xc5d4, 0xc5e3,
	0xc5f3, 0xc602, 0xc611, 0xc61f, 0xc62e, 0xc63d, 0xc64b, 0xc65a,
	// Entry 3040 - 307F
	0xc669, 0xc678, 0xc686, 0xc695, 0xc6a5, 0xc6b4, 0xc6c4, 0xc6d4,
	0xc6e3, 0xc6f3, 0xc704, 0xc714, 0xc725, 0xc735, 0xc745, 0xc754,
	0xc764, 0xc775, 0xc785, 0xc796, 0xc7a6, 0xc7b5, 0xc7c5, 0xc7d5,
	0xc7e4, 0xc7f4, 0xc804, 0xc814, 0xc823, 0xc833, 0xc844, 0xc854,
	0xc864, 0xc874, 0xc883, 0xc893, 0xc8a4, 0xc8b4, 0xc8c3, 0xc8d2,
	0xc8e0, 0xc8ef, 0xc8ff, 0xc90f, 0xc91e, 0xc92e, 0xc93d, 0xc94c,
	0xc95a, 0xc969, 0xc979, 0xc989, 0xc998, 0xc9a8, 0xc9b7, 0xc9c6,
	0xc9d4, 0xc9e3, 0xc9f2, 0xca00, 0xca0f, 0xca1e, 0xca2d, 0xca3b,
	// Entry 3080 - 30BF
	0xca4a, 0xca5a, 0xca69, 0xca78, 0xca87, 0xca95, 0xcaa4, 0xcab4,
	0xcac3, 0xcad2, 0xcae1, 0xcaef, 0xcafe, 0xcb0e, 0xcb1e, 0xcb2d,
	0xcb3d, 0xcb4c, 0xcb5b, 0xcb69, 0xcb78, 0xcb88, 0xcb98, 0xcba7,
	0xcbb7, 0xcbc6, 0xcbd5, 0xcbe3, 0xcbf2, 0xcc01, 0xcc10, 0xcc1e,
	0xcc2d, 0xcc3c, 0xcc4b, 0xcc59, 0xcc68, 0xcc78, 0xcc87, 0xcc96,
	0xcca5, 0xccb3, 0xccc2, 0xccd2, 0xcce1, 0xccf1, 0xcd00, 0xcd0f,
	0xcd1d, 0xcd2c, 0xcd3c, 0xcd4b, 0xcd5b, 0xcd6a, 0xcd79, 0xcd87,
	0xcd96, 0xcda5, 0xcdb4, 0xcdc2, 0xcdd1, 0xcde0, 0xcdef, 0xcdfd,
	// Entry 30C0 - 30FF
	0xce0c, 0xce1c, 0xce2b, 0xce3b, 0xce4b, 0xce5a, 0xce6b, 0xce7b,
	0xce8c, 0xce9c, 0xceac, 0xcebb, 0xcecb, 0xcedc, 0xceed, 0xcefd,
	0xcf0e, 0xcf1e, 0xcf2e, 0xcf3d, 0xcf4d, 0xcf5d, 0xcf6d, 0xcf7c,
	0xcf8c, 0xcf9c, 0xcfac, 0xcfbb, 0xcfcb, 0xcfdc, 0xcfec, 0xcffd,
	0xd00d, 0xd01d, 0xd02d, 0xd03c, 0xd04c, 0xd05d, 0xd06d, 0xd07e,
	0xd08e, 0xd09e, 0xd0ad, 0xd0bd, 0xd0cd, 0xd0dc, 0xd0ec, 0xd0fc,
	0xd10c, 0xd11b, 0xd12b, 0xd13c, 0xd14c, 0xd15c, 0xd16c, 0xd17b,
	0xd18b, 0xd19c, 0xd1ad, 0xd1bd, 0xd1ce, 0xd1de, 0xd1ee, 0xd1fd,
	// Entry 3100 - 313F
	0xd20d, 0xd21e, 0xd22f, 0xd23f, 0xd250, 0xd260, 0xd270, 0xd27f,
	0xd28f, 0xd29f, 0xd2ae, 0xd2be, 0xd2cf, 0xd2df, 0xd2f0, 0xd300,
	0xd310, 0xd31f, 0xd32f, 0xd340, 0xd351, 0xd361, 0xd371, 0xd381,
	0xd390, 0xd3a0, 0xd3b0, 0xd3bf, 0xd3cf, 0xd3de, 0xd3ee, 0xd3fd,
	0xd40c, 0xd41b, 0xd429, 0xd438, 0xd448, 0xd458, 0xd467, 0xd477,
	0xd486, 0xd495, 0xd4a3, 0xd4b2, 0xd4c1, 0xd4cf, 0xd4de, 0xd4ed,
	0xd4fc, 0xd50a, 0xd519, 0xd529, 0xd538, 0xd548, 0xd557, 0xd565,
	0xd574, 0xd583, 0xd591, 0xd5a0, 0xd5af, 0xd5be, 0xd5cc, 0xd5db,
	// Entry 3140 - 317F
	0xd5eb, 0xd5fa, 0xd60a, 0xd619, 0xd628, 0xd636, 0xd645, 0xd655,
	0xd664, 0xd674, 0xd683, 0xd692, 0xd6a0, 0xd6af, 0xd6be, 0xd6cc,
	0xd6db, 0xd6ea, 0xd6f9, 0xd707, 0xd716, 0xd726, 0xd735, 0xd744,
	0xd753, 0xd761, 0xd770, 0xd780, 0xd78f, 0xd79e, 0xd7ad, 0xd7bb,
	0xd7ca, 0xd7da, 0xd7ea, 0xd7f9, 0xd809, 0xd818, 0xd827, 0xd835,
	0xd844, 0xd854, 0xd863, 0xd873, 0xd882, 0xd891, 0xd89f, 0xd8ae,
	0xd8bd, 0xd8cb, 0xd8da, 0xd8e9, 0xd8f8, 0xd906, 0xd915, 0xd925,
	0xd934, 0xd943, 0xd952, 0xd960, 0xd96f, 0xd97f, 0xd98e, 0xd99e,
	// Entry 3180 - 31BF
	0xd9ae, 0xd9bd, 0xd9cd, 0xd9de, 0xd9ef, 0xd9ff, 0xda10, 0xda20,
	0xda30, 0xda3f, 0xda4f, 0xda5f, 0xda6e, 0xda7e, 0xda8e, 0xda9d,
	0xdaad, 0xdabd, 0xdacc, 0xdadc, 0xdaed, 0xdafd, 0xdb0d, 0xdb1d,
	0xdb2c, 0xdb3c, 0xdb4d, 0xdb5d, 0xdb6d, 0xdb7d, 0xdb8c, 0xdb9c,
	0xdbad, 0xdbbd, 0xdbce, 0xdbde, 0xdbee, 0xdbfd, 0xdc0d, 0xdc1e,
	0xdc2e, 0xdc3e, 0xdc4e, 0xdc5e, 0xdc6d, 0xdc7d, 0xdc8c, 0xdc9c,
	0xdcad, 0xdcbd, 0xdccd, 0xdcdd, 0xdcec, 0xdcfc, 0xdd0d, 0xdd1d,
	0xdd2c, 0xdd3b, 0xdd49, 0xdd58, 0xdd68, 0xdd77, 0xdd87, 0xdd96,
	// Entry 31C0 - 31FF
	0xdda5, 0xddb3, 0xddc2, 0xddd2, 0xdde1, 0xddf1, 0xde00, 0xde0f,
	0xde1d, 0xde2c, 0xde3b, 0xde49, 0xde58, 0xde67, 0xde76, 0xde84,
	0xde93, 0xdea3, 0xdeb2, 0xdec1, 0xded0, 0xdede, 0xdeed, 0xdefd,
	0xdf0c, 0xdf1c, 0xdf2c, 0xdf3b, 0xdf4b, 0xdf5c, 0xdf6c, 0xdf7d,
	0xdf8d, 0xdf9d, 0xdfac, 0xdfbc, 0xdfcc, 0xdfdc, 0xdfeb, 0xdffb,
	0xe00b, 0xe01a, 0xe02a, 0xe03a, 0xe04a, 0xe059, 0xe069, 0xe079,
	0xe089, 0xe098, 0xe0a8, 0xe0b9, 0xe0c9, 0xe0d9, 0xe0e9, 0xe0f8,
	0xe108, 0xe119, 0xe129, 0xe13a, 0xe14a, 0xe15a, 0xe169, 0xe179,
	// Entry 3200 - 323F
	0xe189, 0xe199, 0xe1a8, 0xe1b8, 0xe1c8, 0xe1d8, 0xe1e7, 0xe1f7,
	0xe208, 0xe218, 0xe228, 0xe238, 0xe247, 0xe257, 0xe268, 0xe278,
	0xe288, 0xe298, 0xe2a7, 0xe2b7, 0xe2c8, 0xe2d9, 0xe2e9, 0xe2fa,
	0xe30a, 0xe31a, 0xe329, 0xe339, 0xe349, 0xe359, 0xe368, 0xe378,
	0xe388, 0xe397, 0xe3a7, 0xe3b8, 0xe3c8, 0xe3d8, 0xe3e8, 0xe3f7,
	0xe407, 0xe418, 0xe428, 0xe438, 0xe447, 0xe458, 0xe468, 0xe478,
	0xe488, 0xe497, 0xe4a7, 0xe4b7, 0xe4c7, 0xe4d6, 0xe4e6, 0xe4f6,
	0xe506, 0xe515, 0xe525, 0xe536, 0xe546, 0xe556, 0xe566, 0xe575,
	// Entry 3240 - 327F
	0xe585, 0xe596, 0xe5a6, 0xe5b6, 0xe5c6, 0xe5d5, 0xe5e5, 0xe5f5,
	0xe604, 0xe614, 0xe624, 0xe634, 0xe643, 0xe653, 0xe663, 0xe673,
	0xe682, 0xe692, 0xe6a3, 0xe6b3, 0xe6c3, 0xe6d3, 0xe6e2, 0xe6f2,
	0xe703, 0xe713, 0xe723, 0xe733, 0xe742, 0xe752, 0xe763, 0xe773,
	0xe784, 0xe794, 0xe7a4, 0xe7b3, 0xe7c3, 0xe7d3, 0xe7e3, 0xe7f2,
	0xe802, 0xe812, 0xe822, 0xe831, 0xe841, 0xe852, 0xe862, 0xe872,
	0xe882, 0xe891, 0xe8a1, 0xe8b2, 0xe8c2, 0xe8d1, 0xe8e0, 0xe8ee,
	0xe8fd, 0xe90d, 0xe91c, 0xe92c, 0xe93b, 0xe94a, 0xe958, 0xe967,
	// Entry 3280 - 32BF
	0xe976, 0xe984, 0xe993, 0xe9a2, 0xe9b1, 0xe9bf, 0xe9ce, 0xe9de,
	0xe9ed, 0xe9fc, 0xea0b, 0xea19, 0xea28, 0xea38, 0xea47, 0xea56,
	0xea65, 0xea73, 0xea82, 0xea92, 0xeaa2, 0xeab1, 0xeac1, 0xead1,
	0xeae1, 0xeaf0, 0xeb00, 0xeb0f, 0xeb1e, 0xeb2c, 0xeb3b, 0xeb4a,
	0xeb59, 0xeb67, 0xeb76, 0xeb86, 0xeb95, 0xeba4, 0xebb3, 0xebc1,
	0xebd0, 0xebe0, 0xebef, 0xebfe, 0xec0d, 0xec1b, 0xec2a, 0xec3a,
	0xec4a, 0xec59, 0xec69, 0xec79, 0xec89, 0xec98, 0xeca8, 0xecb7,
	0xecc6, 0xecd4, 0xece3, 0xecf2, 0xed01, 0xed0f, 0xed1e, 0xed2e,
	// Entry 32C0 - 32FF
	0xed3d, 0xed4c, 0xed5b, 0xed69, 0xed78, 0xed88, 0xed97, 0xeda7,
	0xedb7, 0xedc6, 0xedd6, 0xede7, 0xedf8, 0xee08, 0xee19, 0xee2a,
	0xee3a, 0xee4b, 0xee5b, 0xee6b, 0xee7a, 0xee8a, 0xee9a, 0xeeaa,
	0xeeb9, 0xeec9, 0xeeda, 0xeeea, 0xeefa, 0xef0a, 0xef19, 0xef29,
	0xef39, 0xef49, 0xef58, 0xef68, 0xef79, 0xef8a, 0xef9a, 0xefab,
	0xefbc, 0xefcc, 0xefdc, 0xefec, 0xeffb, 0xf00b, 0xf01b, 0xf02a,
	0xf03a, 0xf04b, 0xf05b, 0xf06b, 0xf07b, 0xf08a, 0xf09a, 0xf0ab,
	0xf0bb, 0xf0cb, 0xf0db, 0xf0ea, 0xf0fa, 0xf10b, 0xf11c, 0xf12c,
	// Entry 3300 - 333F
	0xf13d, 0xf14e, 0xf15e, 0xf16f, 0xf17f, 0xf18f, 0xf19e, 0xf1ae,
	0xf1be, 0xf1ce, 0xf1dd, 0xf1ed, 0xf1fc, 0xf20b, 0xf219, 0xf228,
	0xf238, 0xf248, 0xf257, 0xf267, 0xf277, 0xf286, 0xf295, 0xf2a4,
	0xf2b2, 0xf2c1, 0xf2d0, 0xf2df, 0xf2ed, 0xf2fc, 0xf30c, 0xf31b,
	0xf32a, 0xf339, 0xf347, 0xf356, 0xf366, 0xf376, 0xf385, 0xf395,
	0xf3a5, 0xf3b5, 0xf3c4, 0xf3d4, 0xf3e3, 0xf3f2, 0xf400, 0xf40f,
	0xf41e, 0xf42d, 0xf43b, 0xf44a, 0xf45a, 0xf469, 0xf478, 0xf487,
	0xf495, 0xf4a4, 0xf4b4, 0xf4c3, 0xf4d1, 0xf4de, 0xf4ec, 0xf4fb,
	// Entry 3340 - 337F
	0xf509, 0xf517, 0xf526, 0xf534, 0xf541, 0xf550, 0xf55e, 0xf56d,
	0xf57b, 0xf588, 0xf596, 0xf5a5, 0xf5b3, 0xf5c0, 0xf5ce, 0xf5dc,
	0xf5eb, 0xf5f9, 0xf608, 0xf617, 0xf624, 0xf631, 0xf640, 0xf64e,
	0xf65c, 0xf66a, 0xf678, 0xf686, 0xf694, 0xf6a2, 0xf6af, 0xf6bc,
	0xf6cb, 0xf6d9, 0xf6e7, 0xf6f6, 0xf703, 0xf710, 0xf71f, 0xf72d,
	0xf73a, 0xf749, 0xf757, 0xf766, 0xf775, 0xf783, 0xf792, 0xf7a0,
	0xf7b0, 0xf7bf, 0xf7cc, 0xf7da, 0xf7e8, 0xf7f7, 0xf805, 0xf813,
	0xf822, 0xf830, 0xf83e, 0xf84d, 0xf85b, 0xf869, 0xf878, 0xf887,
	// Entry 3380 - 33BF
	0xf896, 0xf8a6, 0xf8b4, 0xf8c2, 0xf8d0, 0xf8de, 0xf8ed, 0xf8fb,
	0xf90a, 0xf918, 0xf926, 0xf935, 0xf943, 0xf951, 0xf960, 0xf96e,
	0xf97d, 0xf98a, 0xf998, 0xf9a5, 0xf9b3, 0xf9c0, 0xf9cd, 0xf9da,
	0xf9e8, 0xf9f6, 0xfa04, 0xfa1b, 0xfa31, 0xfa49, 0xfa60, 0xfa77,
	0xfa8f, 0xfaa5, 0xfabf, 0xface, 0xfade, 0xfaee, 0xfafe, 0xfb0f,
	0xfb1f, 0xfb30, 0xfb40, 0xfb51, 0xfb62, 0xfb74, 0xfb85, 0xfb95,
	0xfba5, 0xfbb5, 0xfbc6, 0xfbd7, 0xfbe9, 0xfbf9, 0xfc09, 0xfc19,
	0xfc2a, 0xfc3a, 0xfc4b, 0xfc5b, 0xfc6c, 0xfc7c, 0xfc8c, 0xfc9d,
	// Entry 33C0 - 33FF
	0xfcad, 0xfcbd, 0xfccf, 0xfcdf, 0xfcef, 0xfcff, 0xfd10, 0xfd1e,
	0xfd2d, 0xfd3c, 0xfd4c, 0xfd5b, 0xfd6b, 0xfd7a, 0xfd8a, 0xfd99,
	0xfda9, 0xfdb9, 0xfdca, 0xfdda, 0xfde9, 0xfdf8, 0xfe07, 0xfe17,
	0xfe27, 0xfe38, 0xfe47, 0xfe56, 0xfe65, 0xfe75, 0xfe84, 0xfe94,
	0xfea3, 0xfeb3, 0xfec2, 0xfed1, 0xfee1, 0xfef0, 0xfeff, 0xff10,
	0xff1f, 0xff2e, 0xff3d, 0xff4d, 0xff5b, 0xff6a, 0xff7b, 0xff8a,
	0xff9a, 0xffa9, 0xffb9, 0xffc8, 0xffd8, 0xffe7, 0xfff7, 0x0007,
	0x0018, 0x0029, 0x0039, 0x0048, 0x0057, 0x0066, 0x0076, 0x0086,
	// Entry 3400 - 343F
	0x0097, 0x00a6, 0x00b5, 0x00c4, 0x00d4, 0x00e3, 0x00f3, 0x0102,
	0x0112, 0x0121, 0x0130, 0x0140, 0x014f, 0x015e, 0x016e, 0x017f,
	0x018e, 0x019d, 0x01ac, 0x01bc, 0x01cb, 0x01db, 0x01eb, 0x01fb,
	0x020c, 0x021c, 0x022d, 0x023d, 0x024e, 0x025f, 0x0271, 0x0282,
	0x0292, 0x02a2, 0x02b2, 0x02c3, 0x02d4, 0x02e6, 0x02f6, 0x0306,
	0x0316, 0x0327, 0x0337, 0x0348, 0x0358, 0x0369, 0x0379, 0x0389,
	0x039a, 0x03aa, 0x03ba, 0x03cc, 0x03dc, 0x03ec, 0x03fc, 0x040d,
	0x041b, 0x042a, 0x0439, 0x0449, 0x0458, 0x0468, 0x0477, 0x0487,
	// Entry 3440 - 347F
	0x0496, 0x04a6, 0x04b6, 0x04c7, 0x04d7, 0x04e6, 0x04f5, 0x0504,
	0x0514, 0x0524, 0x0535, 0x0544, 0x0553, 0x0562, 0x0572, 0x0581,
	0x0591, 0x05a0, 0x05b0, 0x05bf, 0x05ce, 0x05de, 0x05ed, 0x05fc,
	0x060d, 0x061c, 0x062b, 0x063a, 0x064a, 0x0658, 0x0667, 0x0678,
	0x0687, 0x0697, 0x06a6, 0x06b6, 0x06c5, 0x06d5, 0x06e4, 0x06f4,
	0x0704, 0x0715, 0x0725, 0x0736, 0x0745, 0x0754, 0x0763, 0x0773,
	0x0783, 0x0794, 0x07a3, 0x07b2, 0x07c1, 0x07d1, 0x07e0, 0x07f0,
	0x07ff, 0x080f, 0x081e, 0x082d, 0x083d, 0x084c, 0x085b, 0x086c,
	// Entry 3480 - 34BF
	0x087b, 0x088a, 0x0899, 0x08a9, 0x08b7, 0x08c6, 0x08d7, 0x08e6,
	0x08f6, 0x0905, 0x0915, 0x0924, 0x0934, 0x0943, 0x0953, 0x0963,
	0x0974, 0x0985, 0x0995, 0x09a6, 0x09b5, 0x09c4, 0x09d3, 0x09e3,
	0x09f3, 0x0a04, 0x0a13, 0x0a22, 0x0a31, 0x0a41, 0x0a50, 0x0a60,
	0x0a6f, 0x0a7f, 0x0a8e, 0x0a9d, 0x0aad, 0x0abc, 0x0acb, 0x0adc,
	0x0aee, 0x0afd, 0x0b0d, 0x0b1c, 0x0b2b, 0x0b3b, 0x0b4a, 0x0b61,
	0x0b6a, 0x0b77, 0x0b88, 0x0b9d, 0x0bb2, 0x0bc8, 0x0bd8, 0x0be8,
	0x0bf7, 0x0c05, 0x0c14, 0x0c22, 0x0c30, 0x0c3f, 0x0c4f, 0x0c5e,
	// Entry 34C0 - 34FF
	0x0c6d, 0x0c7c, 0x0c8b, 0x0c99, 0x0ca6, 0x0cb3, 0x0cc2, 0x0cd0,
	0x0cde, 0x0ceb, 0x0cfa, 0x0d09, 0x0d17, 0x0d2c, 0x0d41, 0x0d5f,
	0x0d7b, 0x0d98, 0x0db3, 0x0dd7, 0x0df9, 0x0e15, 0x0e2f, 0x0e4c,
	0x0e67, 0x0e8b, 0x0ead, 0x0ed0, 0x0ef1, 0x0f14, 0x0f35, 0x0f5f,
	0x0f87, 0x0fab, 0x0fcd, 0x0ff0, 0x1011, 0x1033, 0x1053, 0x107c,
	0x10a3, 0x10c6, 0x10e7, 0x1119, 0x1149, 0x1163, 0x117b, 0x119f,
	0x11c1, 0x11e0, 0x11fd, 0x121c, 0x1239, 0x1258, 0x1275, 0x1298,
	0x12b9, 0x12dc, 0x12fd, 0x1327, 0x134f, 0x136c, 0x1384, 0x13a8,
	// Entry 3500 - 353F
	0x13d0, 0x13f9, 0x140a, 0x1430, 0x144b, 0x1467, 0x1482, 0x14a5,
	0x14c3, 0x14e6, 0x1505, 0x151e, 0x1538, 0x1547, 0x1557, 0x1572,
	0x158b, 0x15a7, 0x15c1, 0x15dd, 0x15f7, 0x1613, 0x162d, 0x1649,
	0x1663, 0x168e, 0x16b7, 0x16d2, 0x16eb, 0x1707, 0x1721, 0x173d,
	0x1757, 0x1773, 0x178d, 0x17a8, 0x17c1, 0x17dd, 0x17f7, 0x1817,
	0x1835, 0x1856, 0x1875, 0x1897, 0x18b9, 0x18d5, 0x18f9, 0x1907,
	0x1916, 0x1924, 0x1933, 0x1942, 0x1952, 0x1962, 0x1970, 0x1980,
	0x198e, 0x199d, 0x19ac, 0x19bc, 0x19cd, 0x19df, 0x19f1, 0x1a01,
	// Entry 3540 - 357F
	0x1a12, 0x1a24, 0x1a32, 0x1a42, 0x1a51, 0x1a62, 0x1a71, 0x1a83,
	0x1a94, 0x1aa5, 0x1ab5, 0x1ac6, 0x1ad5, 0x1ae7, 0x1af7, 0x1b07,
	0x1b17, 0x1b26, 0x1b37, 0x1b48, 0x1b59, 0x1b6a, 0x1b7b, 0x1b8b,
	0x1b9b, 0x1bab, 0x1bbb, 0x1bca, 0x1bd9, 0x1be8, 0x1bf7, 0x1c08,
	0x1c18, 0x1c28, 0x1c3c, 0x1c4d, 0x1c5d, 0x1c6d, 0x1c7e, 0x1c8d,
	0x1c9d, 0x1cac, 0x1cbb, 0x1cca, 0x1cd9, 0x1ce9, 0x1cf8, 0x1d09,
	0x1d19, 0x1d29, 0x1d38, 0x1d47, 0x1d56, 0x1d65, 0x1d76, 0x1d86,
	0x1d96, 0x1da6, 0x1db7, 0x1dc9, 0x1ddc, 0x1dee, 0x1e01, 0x1e1d,
	// Entry 3580 - 35BF
	0x1e3b, 0x1e48, 0x1e57, 0x1e62, 0x1e6d, 0x1e7c, 0x1e8f, 0x1eb4,
	0x1eda, 0x1f00, 0x1f27, 0x1f4a, 0x1f6e, 0x1f91, 0x1fb5, 0x1fdf,
	0x2003, 0x2026, 0x2049, 0x2072, 0x20a6, 0x20d4, 0x2101, 0x212e,
	0x2161, 0x218e, 0x21b5, 0x21db, 0x2201, 0x222d, 0x224d, 0x2266,
	0x2288, 0x22b0, 0x22cf, 0x22f0, 0x2317, 0x2347, 0x2374, 0x2398,
	0x23bb, 0x23e2, 0x2407, 0x242d, 0x2451, 0x246a, 0x2481, 0x2498,
	0x24ad, 0x24ca, 0x24e5, 0x2503, 0x251f, 0x2548, 0x256f, 0x258b,
	0x25a7, 0x25be, 0x25d3, 0x25ea, 0x25ff, 0x2616, 0x262b, 0x2642,
	// Entry 35C0 - 35FF
	0x2657, 0x2682, 0x26ab, 0x26c2, 0x26d7, 0x26ff, 0x2725, 0x2747,
	0x2767, 0x2792, 0x27bb, 0x27f1, 0x2825, 0x2842, 0x285d, 0x2884,
	0x28a9, 0x28d8, 0x2905, 0x2925, 0x2943, 0x295a, 0x296f, 0x29a3,
	0x29d5, 0x29f9, 0x2a1b, 0x2a44, 0x2a6b, 0x2a9f, 0x2ad1, 0x2afc,
	0x2b25, 0x2b43, 0x2b5f, 0x2b7f, 0x2b9d, 0x2bc8, 0x2bf1, 0x2c08,
	0x2c1d, 0x2c3e, 0x2c5d, 0x2c83, 0x2ca7, 0x2cdf, 0x2d15, 0x2d2e,
	0x2d45, 0x2d5c, 0x2d71, 0x2d88, 0x2d9d, 0x2db5, 0x2dcb, 0x2ddd,
	0x2df3, 0x2e09, 0x2e1f, 0x2e35, 0x2e4b, 0x2e69, 0x2e7f, 0x2e94,
	// Entry 3600 - 363F
	0x2eb2, 0x2ece, 0x2eec, 0x2f08, 0x2f26, 0x2f4b, 0x2f6e, 0x2f8b,
	0x2fa6, 0x2fc4, 0x2fe0, 0x2ffe, 0x301a, 0x3038, 0x3054, 0x3079,
	0x308e, 0x30af, 0x30cc, 0x30e7, 0x3104, 0x3135, 0x3151, 0x3176,
	0x3199, 0x31b8, 0x31d5, 0x31fb, 0x3221, 0x3245, 0x3267, 0x3289,
	0x32a9, 0x32c8, 0x32e5, 0x3304, 0x3321, 0x3340, 0x335d, 0x3387,
	0x33af, 0x33d9, 0x3401, 0x342b, 0x3453, 0x347d, 0x34a5, 0x34cf,
	0x34f7, 0x3517, 0x353b, 0x3558, 0x3578, 0x359c, 0x35b9, 0x35d6,
	0x35fe, 0x3616, 0x362f, 0x3646, 0x3660, 0x3678, 0x369a, 0x36bf,
	// Entry 3640 - 367F
	0x36e0, 0x3703, 0x3725, 0x3747, 0x3769, 0x3788, 0x37a9, 0x37be,
	0x37d3, 0x37ed, 0x3802, 0x3817, 0x382c, 0x3845, 0x385b, 0x3872,
	0x3888, 0x389f, 0x38b9, 0x38cf, 0x38e6, 0x38fc, 0x3913, 0x392a,
	0x3942, 0x3959, 0x3971, 0x3987, 0x399e, 0x39b4, 0x39cb, 0x39e1,
	0x39f7, 0x3a0e, 0x3a24, 0x3a3b, 0x3a51, 0x3a67, 0x3a7d, 0x3a94,
	0x3aaa, 0x3ac0, 0x3ad9, 0x3af2, 0x3b0b, 0x3b24, 0x3b3e, 0x3b58,
	0x3b72, 0x3b8c, 0x3ba6, 0x3bc6, 0x3be3, 0x3c06, 0x3c28, 0x3c47,
	0x3c6c, 0x3c84, 0x3ca0, 0x3cb6, 0x3ccf, 0x3ce1, 0x3cf4, 0x3d06,
	// Entry 3680 - 36BF
	0x3d19, 0x3d2b, 0x3d3e, 0x3d50, 0x3d63, 0x3d75, 0x3d88, 0x3d9a,
	0x3dac, 0x3dbe, 0x3dd1, 0x3de3, 0x3df5, 0x3e08, 0x3e1c, 0x3e2f,
	0x3e41, 0x3e54, 0x3e66, 0x3e7d, 0x3e8f, 0x3ea1, 0x3eb3, 0x3ec6,
	0x3ed8, 0x3eea, 0x3efb, 0x3f0c, 0x3f1d, 0x3f2e, 0x3f3f, 0x3f51,
	0x3f63, 0x3f75, 0x3f88, 0x3f9a, 0x3fb6, 0x3fd2, 0x3fe5, 0x3ff9,
	0x400c, 0x401f, 0x403b, 0x4058, 0x4071, 0x408d, 0x40a9, 0x40c6,
	0x40e1, 0x40fa, 0x4113, 0x4125, 0x413e, 0x4156, 0x416d, 0x4180,
	0x4194, 0x41a7, 0x41bb, 0x41ce, 0x41e2, 0x41fd, 0x4219, 0x4234,
	// Entry 36C0 - 36FF
	0x4250, 0x4263, 0x4277, 0x428b, 0x429e, 0x42b2, 0x42c6, 0x42da,
	0x42ef, 0x4303, 0x4318, 0x432d, 0x4341, 0x4356, 0x436a, 0x437f,
	0x4394, 0x43a9, 0x43bf, 0x43d4, 0x43ea, 0x43ff, 0x4413, 0x4428,
	0x443c, 0x4451, 0x4465, 0x4479, 0x448e, 0x44a2, 0x44b7, 0x44cb,
	0x44df, 0x44f3, 0x4507, 0x451b, 0x4530, 0x4545, 0x4559, 0x456d,
	0x4582, 0x45a1, 0x45b9, 0x45d0, 0x45e8, 0x45ff, 0x4617, 0x4636,
	0x4656, 0x4675, 0x4695, 0x46ac, 0x46c4, 0x46dc, 0x46f3, 0x470b,
	0x4723, 0x4739, 0x4754, 0x4764, 0x477b, 0x4790, 0x47a4, 0x47b8,
	// Entry 3700 - 373F
	0x47ce, 0x47e3, 0x47f8, 0x480c, 0x4822, 0x4838, 0x484d, 0x486c,
	0x488a, 0x48a8, 0x48c8, 0x48e7, 0x4906, 0x4924, 0x4944, 0x4964,
	0x4983, 0x49a0, 0x49bd, 0x49db, 0x49f9, 0x4a17, 0x4a35, 0x4a53,
	0x4a75, 0x4a98, 0x4aba, 0x4ae3, 0x4b02, 0x4b23, 0x4b47, 0x4b5f,
	0x4b74, 0x4b84, 0x4b99, 0x4bb0, 0x4bc2, 0x4bd5, 0x4be7, 0x4bf9,
	0x4c0d, 0x4c20, 0x4c33, 0x4c45, 0x4c59, 0x4c6d, 0x4c80, 0x4c92,
	0x4ca5, 0x4cb7, 0x4cca, 0x4cdc, 0x4cef, 0x4d01, 0x4d14, 0x4d26,
	0x4d39, 0x4d4b, 0x4d5d, 0x4d70, 0x4d82, 0x4d94, 0x4da6, 0x4db8,
	// Entry 3740 - 377F
	0x4dca, 0x4ddc, 0x4dee, 0x4e01, 0x4e13, 0x4e25, 0x4e37, 0x4e48,
	0x4e5a, 0x4e6b, 0x4e7d, 0x4e8e, 0x4e9e, 0x4eae, 0x4ebf, 0x4ecf,
	0x4ee3, 0x4ef6, 0x4f10, 0x4f21, 0x4f33, 0x4f43, 0x4f53, 0x4f64,
	0x4f74, 0x4f84, 0x4f94, 0x4fa4, 0x4fb4, 0x4fc4, 0x4fd4, 0x4fe4,
	0x4ff5, 0x5005, 0x5015, 0x5025, 0x5035, 0x5045, 0x5055, 0x5066,
	0x5078, 0x5089, 0x509b, 0x50aa, 0x50bd, 0x50d0, 0x50e3, 0x50f7,
	0x510a, 0x511e, 0x5132, 0x5146, 0x515e, 0x5175, 0x518c, 0x51a3,
	0x51b0, 0x51c3, 0x51df, 0x51fb, 0x5216, 0x5232, 0x524e, 0x526f,
	// Entry 3780 - 37BF
	0x528b, 0x52ac, 0x52c7, 0x52e2, 0x5302, 0x5325, 0x533f, 0x535a,
	0x5377, 0x5393, 0x53af, 0x53c9, 0x53eb, 0x5408, 0x5423, 0x5442,
	0x545d, 0x5478, 0x5498, 0x54b4, 0x54d1, 0x54eb, 0x550b, 0x5522,
	0x5535, 0x5548, 0x555d, 0x556e, 0x5584, 0x5595, 0x55a7, 0x55b8,
	0x55d0, 0x55e9, 0x560a, 0x561b, 0x562d, 0x563e, 0x5650, 0x5668,
	0x5680, 0x5692, 0x56aa, 0x56bd, 0x56cf, 0x56e7, 0x56f9, 0x5712,
	0x572e, 0x5741, 0x5754, 0x5771, 0x5784, 0x57a1, 0x57b9, 0x57cb,
	0x57e3, 0x57f5, 0x5811, 0x5823, 0x5835, 0x584d, 0x585f, 0x5877,
	// Entry 37C0 - 37FF
	0x5889, 0x589b, 0x58ad, 0x58c5, 0x58d7, 0x58e9, 0x5901, 0x591d,
	0x592f, 0x5941, 0x5959, 0x5973, 0x598d, 0x59a5, 0x59c3, 0x59db,
	0x59fa, 0x5a14, 0x5a32, 0x5a4b, 0x5a68, 0x5a87, 0x5aa4, 0x5ab4,
	0x5acb, 0x5ae3, 0x5af6, 0x5b09, 0x5b1c, 0x5b2f, 0x5b44, 0x5b58,
	0x5b6c, 0x5b7e, 0x5b95, 0x5baa, 0x5bc6, 0x5bda, 0x5bed, 0x5bff,
	0x5c11, 0x5c25, 0x5c38, 0x5c4b, 0x5c5d, 0x5c71, 0x5c85, 0x5c98,
	0x5cb3, 0x5cca, 0x5ce1, 0x5cf8, 0x5d0f, 0x5d26, 0x5d3d, 0x5d52,
	0x5d7c, 0x5d98, 0x5db3, 0x5dce, 0x5dea, 0x5e05, 0x5e21, 0x5e3d,
	// Entry 3800 - 383F
	0x5e5a, 0x5e76, 0x5e92, 0x5ead, 0x5ec8, 0x5ee5, 0x5f01, 0x5f1d,
	0x5f38, 0x5f55, 0x5f72, 0x5f8e, 0x5faa, 0x5fc5, 0x5fe1, 0x5ffc,
	0x6018, 0x6025, 0x6032, 0x603f, 0x604c, 0x605a, 0x6067, 0x6075,
	0x6084, 0x6092, 0x60a1, 0x60b1, 0x60c0, 0x60cf, 0x60df, 0x60ed,
	0x60fc, 0x610c, 0x611b, 0x612b, 0x6139, 0x6148, 0x6156, 0x6165,
	0x6174, 0x6182, 0x6191, 0x619f, 0x61ae, 0x61bd, 0x61cb, 0x61da,
	0x61e9, 0x61f7, 0x6206, 0x6214, 0x6222, 0x6230, 0x623e, 0x624d,
	0x625b, 0x6269, 0x627b, 0x628c, 0x629e, 0x62b0, 0x62c1, 0x62d3,
	// Entry 3840 - 387F
	0x62e4, 0x62f6, 0x6308, 0x631a, 0x6330, 0x6346, 0x635c, 0x6372,
	0x6385, 0x6398, 0x63ac, 0x63c8, 0x63dc, 0x63ef, 0x6402, 0x6415,
	0x6428, 0x643b, 0x644e, 0x6462, 0x647d, 0x6498, 0x64a7, 0x64b5,
	0x64c3, 0x64d3, 0x64e2, 0x64f1, 0x64ff, 0x650f, 0x651f, 0x652e,
	0x6545, 0x655b, 0x6578, 0x6595, 0x65ad, 0x65c5, 0x65de, 0x65f6,
	0x660f, 0x6628, 0x6641, 0x665b, 0x6674, 0x668e, 0x66a7, 0x66bf,
	0x66d7, 0x66ef, 0x6708, 0x6720, 0x674c, 0x6764, 0x677c, 0x6794,
	0x67af, 0x67c9, 0x67e3, 0x6803, 0x681b, 0x6833, 0x684a, 0x6865,
	// Entry 3880 - 38BF
	0x6882, 0x689f, 0x68be, 0x68dd, 0x68f3, 0x690a, 0x6921, 0x6939,
	0x6951, 0x696a, 0x6980, 0x6997, 0x69ae, 0x69c6, 0x69dc, 0x69f3,
	0x6a0a, 0x6a22, 0x6a38, 0x6a4f, 0x6a66, 0x6a7e, 0x6a94, 0x6aab,
	0x6ac1, 0x6ad8, 0x6aef, 0x6b07, 0x6b1d, 0x6b34, 0x6b4a, 0x6b61,
	0x6b77, 0x6b8e, 0x6ba5, 0x6bbd, 0x6bd3, 0x6bea, 0x6c00, 0x6c17,
	0x6c2d, 0x6c44, 0x6c5a, 0x6c71, 0x6c87, 0x6c9e, 0x6cb4, 0x6ccb,
	0x6ce1, 0x6cf8, 0x6d0d, 0x6d23, 0x6d34, 0x6d45, 0x6d55, 0x6d66,
	0x6d76, 0x6d86, 0x6d96, 0x6da7, 0x6db8, 0x6dca, 0x6ddb, 0x6ded,
	// Entry 38C0 - 38FF
	0x6dfe, 0x6e0f, 0x6e20, 0x6e34, 0x6e4b, 0x6e60, 0x6e76, 0x6e89,
	0x6e9e, 0x6eb1, 0x6ec7, 0x6ede, 0x6ef3, 0x6f08, 0x6f1f, 0x6f36,
	0x6f4d, 0x6f65, 0x6f7c, 0x6f94, 0x6fab, 0x6fc2, 0x6fd9, 0x6ff3,
	0x700d, 0x7028, 0x7042, 0x705d, 0x7072, 0x708b, 0x709c, 0x70c1,
	0x70e2, 0x7101, 0x7114, 0x712a, 0x7140, 0x7157, 0x716e, 0x7184,
	0x719a, 0x71b0, 0x71c6, 0x71dd, 0x71f4, 0x720a, 0x7220, 0x7235,
	0x724a, 0x7260, 0x7276, 0x728b, 0x72a0, 0x72b7, 0x72ce, 0x72e5,
	0x72fd, 0x7315, 0x732c, 0x7343, 0x7358, 0x736d, 0x7382, 0x7398,
	// Entry 3900 - 393F
	0x73ae, 0x73c3, 0x73d8, 0x73f7, 0x741a, 0x743a, 0x7455, 0x7477,
	0x7491, 0x74be, 0x74e7, 0x7514, 0x7539, 0x755f, 0x7585, 0x75ad,
	0x75cd, 0x75f9, 0x761e, 0x763c, 0x7664, 0x7697, 0x76b9, 0x76e7,
	0x7703, 0x772e, 0x7751, 0x776c, 0x7792, 0x77bf, 0x77da, 0x77ff,
	0x781e, 0x7847, 0x7874, 0x7889, 0x78a5, 0x78c8, 0x78de, 0x7908,
	0x7932, 0x795a, 0x7981, 0x79bb, 0x79ed, 0x7a16, 0x7a38, 0x7a52,
	0x7a7e, 0x7aa7, 0x7acd, 0x7ae9, 0x7b06, 0x7b20, 0x7b35, 0x7b56,
	0x7b76, 0x7b8d, 0x7ba4, 0x7bbb, 0x7bd2, 0x7be9, 0x7c00, 0x7c18,
	// Entry 3940 - 397F
	0x7c30, 0x7c48, 0x7c60, 0x7c78, 0x7c90, 0x7ca8, 0x7cc0, 0x7cd8,
	0x7cf0, 0x7d08, 0x7d20, 0x7d38, 0x7d50, 0x7d68, 0x7d80, 0x7d98,
	0x7db0, 0x7dc8, 0x7de0, 0x7df8, 0x7e10, 0x7e28, 0x7e40, 0x7e58,
	0x7e71, 0x7e8a, 0x7ea2, 0x7eba, 0x7ed2, 0x7eea, 0x7f02, 0x7f1b,
	0x7f34, 0x7f4d, 0x7f66, 0x7f7f, 0x7f98, 0x7fb0, 0x7fc7, 0x7fdf,
	0x7ff7, 0x800f, 0x8027, 0x803f, 0x8057, 0x806f, 0x8087, 0x809f,
	0x80b7, 0x80cf, 0x80e7, 0x80ff, 0x8117, 0x8130, 0x8149, 0x8162,
	0x817b, 0x8194, 0x81ad, 0x81c6, 0x81df, 0x81f8, 0x8211, 0x822a,
	// Entry 3980 - 39BF
	0x8243, 0x825c, 0x8274, 0x828c, 0x82a4, 0x82bc, 0x82d4, 0x82ec,
	0x8304, 0x831b, 0x8332, 0x8349, 0x8360, 0x8376, 0x838c, 0x83a4,
	0x83bb, 0x83d3, 0x83eb, 0x8403, 0x841a, 0x8432, 0x8449, 0x845f,
	0x8474, 0x848c, 0x84a5, 0x84bc, 0x84d4, 0x84eb, 0x8501, 0x8518,
	0x852f, 0x8547, 0x855f, 0x8577, 0x8595, 0x85b3, 0x85d1, 0x85ee,
	0x860b, 0x8629, 0x8648, 0x8664, 0x8680, 0x869c, 0x86b8, 0x86d5,
	0x86f3, 0x870f, 0x872e, 0x874a, 0x875f, 0x8774, 0x878a, 0x87a1,
	0x87b7, 0x87cd, 0x87e5, 0x87fc, 0x8813, 0x8829, 0x8841, 0x8859,
	// Entry 39C0 - 39FF
	0x8870, 0x8886, 0x889c, 0x88b1, 0x88c7, 0x88dd, 0x88f3, 0x8909,
	0x891f, 0x8934, 0x8949, 0x895f, 0x8974, 0x8989, 0x89a0, 0x89b6,
	0x89cc, 0x89e1, 0x89f7, 0x8a0c, 0x8a21, 0x8a35, 0x8a4d, 0x8a65,
	0x8a81, 0x8a9f, 0x8abb, 0x8add, 0x8afa, 0x8b16, 0x8b39, 0x8b56,
	0x8b75, 0x8b94, 0x8bb6, 0x8bd9, 0x8bfc, 0x8c1e, 0x8c41, 0x8c65,
	0x8c84, 0x8cac, 0x8cca, 0x8ce6, 0x8d07, 0x8d22, 0x8d43, 0x8d5f,
	0x8d7c, 0x8da0, 0x8dbc, 0x8dd7, 0x8df9, 0x8e15, 0x8e33, 0x8e4e,
	0x8e71, 0x8e92, 0x8eb3, 0x8ed0, 0x8eeb, 0x8f08, 0x8f25, 0x8f40,
	// Entry 3A00 - 3A3F
	0x8f5e, 0x8f84, 0x8fa3, 0x8fc2, 0x8fde, 0x8fff, 0x901a, 0x9037,
	0x9057, 0x9077, 0x9097, 0x90b7, 0x90d7, 0x90f7, 0x9117, 0x9137,
	0x9157, 0x9177, 0x9197, 0x91b7, 0x91d7, 0x91f7, 0x9217, 0x9237,
	0x9257, 0x9277, 0x9297, 0x92b7, 0x92d7, 0x92f7, 0x9317, 0x9337,
	0x9357, 0x9377, 0x9397, 0x93b7, 0x93d7, 0x93f7, 0x9417, 0x9437,
	0x9457, 0x9477, 0x9497, 0x94b7, 0x94d7, 0x94f7, 0x9517, 0x9537,
	0x9557, 0x9577, 0x9597, 0x95b7, 0x95d7, 0x95f7, 0x9617, 0x9637,
	0x9657, 0x9677, 0x9697, 0x96b7, 0x96d7, 0x96f7, 0x9717, 0x9737,
	// Entry 3A40 - 3A7F
	0x9757, 0x9777, 0x9797, 0x97b7, 0x97d7, 0x97f7, 0x9817, 0x9837,
	0x9857, 0x9877, 0x9897, 0x98b7, 0x98d7, 0x98f7, 0x9917, 0x9937,
	0x9957, 0x9977, 0x9997, 0x99b7, 0x99d7, 0x99f7, 0x9a17, 0x9a37,
	0x9a57, 0x9a77, 0x9a97, 0x9ab7, 0x9ad7, 0x9af7, 0x9b17, 0x9b37,
	0x9b57, 0x9b77, 0x9b97, 0x9bb7, 0x9bd7, 0x9bf7, 0x9c17, 0x9c37,
	0x9c57, 0x9c77, 0x9c97, 0x9cb7, 0x9cd7, 0x9cf7, 0x9d17, 0x9d37,
	0x9d57, 0x9d77, 0x9d97, 0x9db7, 0x9dd7, 0x9df7, 0x9e17, 0x9e37,
	0x9e57, 0x9e77, 0x9e97, 0x9eb7, 0x9ed7, 0x9ef7, 0x9f17, 0x9f37,
	// Entry 3A80 - 3ABF
	0x9f57, 0x9f77, 0x9f97, 0x9fb7, 0x9fd7, 0x9ff7, 0xa017, 0xa037,
	0xa057, 0xa077, 0xa097, 0xa0b7, 0xa0d7, 0xa0f7, 0xa117, 0xa137,
	0xa157, 0xa177, 0xa197, 0xa1b7, 0xa1d7, 0xa1f7, 0xa217, 0xa237,
	0xa257, 0xa277, 0xa297, 0xa2b7, 0xa2d7, 0xa2f7, 0xa317, 0xa337,
	0xa357, 0xa377, 0xa397, 0xa3b7, 0xa3d7, 0xa3f7, 0xa417, 0xa437,
	0xa457, 0xa477, 0xa497, 0xa4b7, 0xa4d7, 0xa4f7, 0xa517, 0xa537,
	0xa557, 0xa577, 0xa597, 0xa5b7, 0xa5d7, 0xa5f7, 0xa617, 0xa637,
	0xa657, 0xa677, 0xa697, 0xa6b7, 0xa6d7, 0xa6f7, 0xa717, 0xa737,
	// Entry 3AC0 - 3AFF
	0xa757, 0xa777, 0xa797, 0xa7b7, 0xa7d7, 0xa7f7, 0xa817, 0xa837,
	0xa857, 0xa877, 0xa897, 0xa8b7, 0xa8d7, 0xa8f7, 0xa917, 0xa937,
	0xa957, 0xa977, 0xa997, 0xa9b7, 0xa9d7, 0xa9f7, 0xaa17, 0xaa37,
	0xaa57, 0xaa77, 0xaa97, 0xaab7, 0xaad7, 0xaaf7, 0xab17, 0xab37,
	0xab57, 0xab77, 0xab97, 0xabb7, 0xabd7, 0xabf7, 0xac17, 0xac37,
	0xac57, 0xac77, 0xac97, 0xacb7, 0xacd7, 0xacf7, 0xad17, 0xad37,
	0xad57, 0xad77, 0xad97, 0xadb7, 0xadd7, 0xadf7, 0xae17, 0xae37,
	0xae57, 0xae77, 0xae97, 0xaeb7, 0xaed7, 0xaef7, 0xaf17, 0xaf37,
	// Entry 3B00 - 3B3F
	0xaf57, 0xaf77, 0xaf97, 0xafb7, 0xafd7, 0xaff7, 0xb017, 0xb037,
	0xb057, 0xb077, 0xb097, 0xb0b7, 0xb0d7, 0xb0f7, 0xb117, 0xb137,
	0xb157, 0xb177, 0xb197, 0xb1b7, 0xb1d7, 0xb1f7, 0xb217, 0xb237,
	0xb257, 0xb277, 0xb297, 0xb2b7, 0xb2d7, 0xb2f7, 0xb317, 0xb337,
	0xb357, 0xb377, 0xb397, 0xb3b7, 0xb3d7, 0xb3f7, 0xb417, 0xb437,
	0xb457, 0xb477, 0xb497, 0xb4b7, 0xb4d7, 0xb4f7, 0xb517, 0xb537,
	0xb557, 0xb577, 0xb597, 0xb5b7, 0xb5d7, 0xb5f7, 0xb617, 0xb637,
	0xb657, 0xb677, 0xb697, 0xb6b7, 0xb6d7, 0xb6f7, 0xb717, 0xb737,
	// Entry 3B40 - 3B7F
	0xb757, 0xb777, 0xb797, 0xb7b7, 0xb7d7, 0xb7f7, 0xb817, 0xb837,
	0xb857, 0xb877, 0xb897, 0xb8b7, 0xb8d7, 0xb8f7, 0xb917, 0xb937,
	0xb957, 0xb977, 0xb997, 0xb9b7, 0xb9d7, 0xb9f7, 0xba17, 0xba37,
	0xba57, 0xba77, 0xba97, 0xbab7, 0xbad7, 0xbaf7, 0xbb17, 0xbb37,
	0xbb57, 0xbb77, 0xbb97, 0xbbb7, 0xbbd7, 0xbbf7, 0xbc17, 0xbc37,
	0xbc57, 0xbc77, 0xbc97, 0xbcb7, 0xbcd7, 0xbcf7, 0xbd17, 0xbd37,
	0xbd57, 0xbd77, 0xbd97, 0xbdb7, 0xbdd7, 0xbdf7, 0xbe17, 0xbe37,
	0xbe57, 0xbe77, 0xbe97, 0xbeb7, 0xbed7, 0xbef7, 0xbf17, 0xbf37,
	// Entry 3B80 - 3BBF
	0xbf57, 0xbf77, 0xbf97, 0xbfb7, 0xbfd7, 0xbff7, 0xc017, 0xc037,
	0xc057, 0xc077, 0xc097, 0xc0b7, 0xc0d7, 0xc0f7, 0xc117, 0xc137,
	0xc157, 0xc177, 0xc197, 0xc1b7, 0xc1d7, 0xc1f7, 0xc217, 0xc237,
	0xc257, 0xc277, 0xc297, 0xc2b7, 0xc2d7, 0xc2f7, 0xc317, 0xc337,
	0xc357, 0xc377, 0xc397, 0xc3b7, 0xc3d7, 0xc3f7, 0xc417, 0xc437,
	0xc457, 0xc477, 0xc497, 0xc4b7, 0xc4d7, 0xc4f7, 0xc517, 0xc537,
	0xc557, 0xc577, 0xc597, 0xc5b7, 0xc5d7, 0xc5f7, 0xc617, 0xc637,
	0xc657, 0xc677, 0xc697, 0xc6b7, 0xc6d7, 0xc6f7, 0xc717, 0xc737,
	// Entry 3BC0 - 3BFF
	0xc757, 0xc777, 0xc797, 0xc7b7, 0xc7d7, 0xc7f7, 0xc817, 0xc837,
	0xc857, 0xc877, 0xc897, 0xc8b7, 0xc8d7, 0xc8f7, 0xc917, 0xc937,
	0xc957, 0xc977, 0xc997, 0xc9b7, 0xc9d7, 0xc9f7, 0xca17, 0xca37,
	0xca57, 0xca77, 0xca97, 0xcab7, 0xcad7, 0xcaf7, 0xcb17, 0xcb37,
	0xcb57, 0xcb6e, 0xcb85, 0xcb9c, 0xcbb4, 0xcbcc, 0xcbe9, 0xcc00,
	0xcc1f, 0xcc3e, 0xcc5d, 0xcc7c, 0xcc9b, 0xccb7, 0xccd8, 0xccfd,
	0xcd1b, 0xcd32, 0xcd4a, 0xcd5f, 0xcd75, 0xcd8d, 0xcda9, 0xcdc0,
	0xcdd6, 0xcdf9, 0xce19, 0xce38, 0xce63, 0xce8d, 0xceaa, 0xcec8,
	// Entry 3C00 - 3C3F
	0xcee5, 0xcf02, 0xcf21, 0xcf40, 0xcf5b, 0xcf78, 0xcf97, 0xcfb4,
	0xcfd1, 0xcff4, 0xd011, 0xd030, 0xd04d, 0xd06a, 0xd08a, 0xd0ac,
	0xd0c8, 0xd0e7, 0xd104, 0xd122, 0xd140, 0xd15d, 0xd179, 0xd194,
	0xd1af, 0xd1c9, 0xd1e3, 0xd209, 0xd22c, 0xd24c, 0xd269, 0xd288,
	0xd2a6, 0xd2c5, 0xd2e1, 0xd2ff, 0xd31c, 0xd33d, 0xd35b, 0xd37b,
	0xd39a, 0xd3bc, 0xd3db, 0xd3fc, 0xd41c, 0xd43d, 0xd45b, 0xd47b,
	0xd49a, 0xd4ba, 0xd4d7, 0xd4f6, 0xd514, 0xd533, 0xd54f, 0xd56d,
	0xd58a, 0xd5ab, 0xd5c9, 0xd5e9, 0xd608, 0xd628, 0xd645, 0xd664,
	// Entry 3C40 - 3C7F
	0xd682, 0xd6a2, 0xd6bf, 0xd6de, 0xd6fc, 0xd71d, 0xd73b, 0xd75b,
	0xd77a, 0xd79d, 0xd7bd, 0xd7df, 0xd800, 0xd822, 0xd841, 0xd862,
	0xd880, 0xd89f, 0xd8bb, 0xd8db, 0xd8f8, 0xd917, 0xd933, 0xd953,
	0xd970, 0xd991, 0xd9af, 0xd9cf, 0xd9ee, 0xda0d, 0xda29, 0xda47,
	0xda64, 0xda84, 0xdaa1, 0xdac0, 0xdade, 0xdaff, 0xdb1d, 0xdb3d,
	0xdb5c, 0xdb83, 0xdba7, 0xdbc8, 0xdbe6, 0xdc06, 0xdc25, 0xdc53,
	0xdc7e, 0xdca2, 0xdcc3, 0xdce6, 0xdd08, 0xdd33, 0xdd5b, 0xdd85,
	0xddae, 0xddd4, 0xddf7, 0xde2e, 0xde62, 0xde79, 0xde90, 0xdeac,
	// Entry 3C80 - 3CBF
	0xdec8, 0xdee6, 0xdf04, 0xdf35, 0xdf66, 0xdf83, 0xdfa0, 0xdfc7,
	0xdfee, 0xe015, 0xe027, 0xe044, 0xe061, 0xe07f, 0xe09a, 0xe0b7,
	0xe0d3, 0xe0f0, 0xe10a, 0xe128, 0xe143, 0xe161, 0xe17c, 0xe1aa,
	0xe1c8, 0xe1e3, 0xe209, 0xe22c, 0xe252, 0xe275, 0xe292, 0xe2ac,
	0xe2c8, 0xe2e3, 0xe320, 0xe35c, 0xe398, 0xe3d1, 0xe40b, 0xe442,
	0xe47d, 0xe4b5, 0xe4ee, 0xe524, 0xe55e, 0xe595, 0xe5cf, 0xe606,
	0xe63f, 0xe675, 0xe6ad, 0xe700, 0xe750, 0xe7a2, 0xe7c7, 0xe7e9,
	0xe80d, 0xe830, 0xe86c, 0xe8a7, 0xe8e3, 0xe927, 0xe962, 0xe98d,
	// Entry 3CC0 - 3CFF
	0xe9b7, 0xe9e2, 0xea0d, 0xea40, 0xea6a, 0xea95, 0xeabf, 0xeaea,
	0xeb15, 0xeb48, 0xeb72, 0xeb9e, 0xebca, 0xebfe, 0xec29, 0xec54,
	0xec80, 0xecab, 0xecd6, 0xed02, 0xed2d, 0xed59, 0xed85, 0xedb0,
	0xeddc, 0xee08, 0xee32, 0xee5d, 0xee88, 0xeeb2, 0xeedd, 0xef08,
	0xef32, 0xef5d, 0xef88, 0xefb3, 0xefde, 0xf00b, 0xf038, 0xf063,
	0xf08d, 0xf0b8, 0xf0e3, 0xf116, 0xf140, 0xf16a, 0xf195, 0xf1c8,
	0xf1f2, 0xf21d, 0xf248, 0xf272, 0xf29d, 0xf2c7, 0xf2f2, 0xf325,
	0xf34f, 0xf37a, 0xf3a4, 0xf3cf, 0xf3fa, 0xf42d, 0xf457, 0xf483,
	// Entry 3D00 - 3D3F
	0xf4ae, 0xf4da, 0xf506, 0xf53a, 0xf565, 0xf591, 0xf5bc, 0xf5e8,
	0xf614, 0xf648, 0xf673, 0xf69e, 0xf6c9, 0xf6fc, 0xf726, 0xf751,
	0xf77b, 0xf7a6, 0xf7d1, 0xf804, 0xf82e, 0xf866, 0xf89d, 0xf8dd,
	0xf90f, 0xf941, 0xf970, 0xf99f, 0xf9ce, 0xfa08, 0xfa40, 0xfa79,
	0xfab2, 0xfaeb, 0xfb2c, 0xfb64, 0xfb8b, 0xfbb3, 0xfbdb, 0xfc03,
	0xfc33, 0xfc5a, 0xfc81, 0xfca9, 0xfcd1, 0xfcf9, 0xfd29, 0xfd50,
	0xfd78, 0xfda1, 0xfdca, 0xfdf3, 0xfe24, 0xfe4c, 0xfe7c, 0xfea3,
	0xfed3, 0xfefa, 0xff22, 0xff49, 0xff71, 0xffa1, 0xffc8, 0xfff0,
	// Entry 3D40 - 3D7F
	0x0020, 0x0047, 0x0070, 0x0099, 0x00c1, 0x00ea, 0x0113, 0x013c,
	0x016d, 0x0195, 0x01d2, 0x01f9, 0x0221, 0x0249, 0x0271, 0x02a1,
	0x02c8, 0x0303, 0x033d, 0x0378, 0x03b3, 0x03ed, 0x0417, 0x0440,
	0x046a, 0x0494, 0x04bd, 0x04e7, 0x0510, 0x053a, 0x0564, 0x058d,
	0x05b8, 0x05e2, 0x060d, 0x0637, 0x0661, 0x068c, 0x06b7, 0x06e2,
	0x070c, 0x0737, 0x0762, 0x078b, 0x07b5, 0x07df, 0x0809, 0x0832,
	0x085c, 0x0886, 0x08af, 0x08d9, 0x0903, 0x092d, 0x0959, 0x0985,
	0x09af, 0x09d8, 0x0a02, 0x0a2c, 0x0a55, 0x0a7f, 0x0aa9, 0x0ad2,
	// Entry 3D80 - 3DBF
	0x0afc, 0x0b25, 0x0b4f, 0x0b79, 0x0ba2, 0x0bcc, 0x0bf6, 0x0c1f,
	0x0c4a, 0x0c74, 0x0c9f, 0x0cca, 0x0cf5, 0x0d1f, 0x0d4a, 0x0d75,
	0x0d9f, 0x0dc9, 0x0df3, 0x0e29, 0x0e53, 0x0e7c, 0x0ea6, 0x0ed0,
	0x0ef9, 0x0f33, 0x0f6c, 0x0f95, 0x0fbd, 0x0fe6, 0x100e, 0x1038,
	0x1061, 0x108b, 0x10b4, 0x10df, 0x1109, 0x1131, 0x115a, 0x1183,
	0x11ad, 0x11d6, 0x11ff, 0x1227, 0x1254, 0x1281, 0x12ae, 0x12e1,
	0x130b, 0x133e, 0x1368, 0x139d, 0x13c9, 0x13fd, 0x1428, 0x145d,
	0x1489, 0x14bc, 0x14e6, 0x151a, 0x1545, 0x1579, 0x15a4, 0x15d7,
	// Entry 3DC0 - 3DFF
	0x1601, 0x1634, 0x165e, 0x168b, 0x16b7, 0x16e4, 0x1711, 0x173d,
	0x1768, 0x1792, 0x17bc, 0x17ec, 0x1813, 0x1843, 0x186a, 0x189c,
	0x18c5, 0x18f6, 0x191e, 0x1950, 0x1979, 0x19a9, 0x19d0, 0x1a01,
	0x1a29, 0x1a5a, 0x1a82, 0x1ab2, 0x1ad9, 0x1b09, 0x1b30, 0x1b5a,
	0x1b83, 0x1bad, 0x1bd7, 0x1c00, 0x1c28, 0x1c4f, 0x1c76, 0x1ca2,
	0x1ccd, 0x1cf9, 0x1d25, 0x1d4f, 0x1d7a, 0x1da4, 0x1dce, 0x1df7,
	0x1e21, 0x1e4c, 0x1e76, 0x1ea1, 0x1eca, 0x1ef3, 0x1f20, 0x1f50,
	0x1f67, 0x1f7f, 0x1fb3, 0x1fe4, 0x2017, 0x204a, 0x207e, 0x20b2,
	// Entry 3E00 - 3E3F
	0x20e5, 0x2119, 0x214b, 0x217f, 0x21b0, 0x21ea, 0x221e, 0x2252,
	0x228d, 0x22bf, 0x22f3, 0x2328, 0x235b, 0x2390, 0x23c0, 0x23f2,
	0x2424, 0x2457, 0x248c, 0x24bf, 0x24f3, 0x2529, 0x255d, 0x2593,
	0x25cc, 0x25fe, 0x2632, 0x2663, 0x2696, 0x26ca, 0x26fb, 0x272d,
	0x275f, 0x2793, 0x27cd, 0x2801, 0x2834, 0x2870, 0x28a2, 0x28d6,
	0x2907, 0x2939, 0x296a, 0x299a, 0x29d3, 0x2a07, 0x2a39, 0x2a6b,
	0x2a9f, 0x2ad0, 0x2b03, 0x2b37, 0x2b6b, 0x2b9c, 0x2bd0, 0x2c05,
	0x2c3a, 0x2c6f, 0x2ca4, 0x2cd8, 0x2d0c, 0x2d40, 0x2d7a, 0x2dad,
	// Entry 3E40 - 3E7F
	0x2de2, 0x2e1d, 0x2e4f, 0x2e8a, 0x2ebc, 0x2ef0, 0x2f21, 0x2f52,
	0x2f8c, 0x2fbd, 0x2ff7, 0x3028, 0x3062, 0x3094, 0x30ce, 0x3109,
	0x3144, 0x3174, 0x31a6, 0x31d6, 0x3207, 0x3238, 0x3268, 0x3299,
	0x32ca, 0x32fc, 0x332d, 0x335e, 0x3391, 0x33c4, 0x33f5, 0x3426,
	0x345a, 0x348c, 0x34c0, 0x34f2, 0x3524, 0x3556, 0x3587, 0x35b8,
	0x35ea, 0x361b, 0x364b, 0x367f, 0x36b3, 0x36e7, 0x3719, 0x374b,
	0x3788, 0x37c4, 0x37e7, 0x380a, 0x3830, 0x3853, 0x3877, 0x389b,
	0x38c1, 0x38e4, 0x390f, 0x392e, 0x3937, 0x3964, 0x3978, 0x398c,
	// Entry 3E80 - 3EBF
	0x39a0, 0x39b4, 0x39c8, 0x39dc, 0x39f0, 0x3a04, 0x3a18, 0x3a2d,
	0x3a42, 0x3a57, 0x3a6c, 0x3a81, 0x3a96, 0x3aab, 0x3acf, 0x3aff,
	0x3b33, 0x3b57, 0x3b7f, 0x3bae, 0x3bda, 0x3c16, 0x3c53, 0x3c85,
	0x3ca1, 0x3cbe, 0x3cde, 0x3cff, 0x3d19, 0x3d34, 0x3d4f, 0x3d71,
	0x3d94, 0x3db3, 0x3dd3, 0x3df3, 0x3e14, 0x3e35, 0x3e57, 0x3e7a,
	0x3ea7, 0x3ecd, 0x3ef3, 0x3f1a, 0x3f46, 0x3f75, 0x3fa5, 0x3fd6,
	0x4008, 0x4042, 0x407d, 0x40b9, 0x40f6, 0x412e, 0x4167, 0x4198,
	0x41ca, 0x41fc, 0x422f, 0x4267, 0x42a0, 0x42aa, 0x42ba, 0x42ec,
	// Entry 3EC0 - 3EFF
	0x431f, 0x432e, 0x4341, 0x434e, 0x4362, 0x4371, 0x4384, 0x4391,
	0x439c, 0x43b3, 0x43c2, 0x43d1, 0x43dc, 0x43ef, 0x4405, 0x4412,
	0x4428, 0x443f, 0x4457, 0x4470, 0x4491, 0x44b3, 0x44c4, 0x44d3,
	0x44e1, 0x44f0, 0x4502, 0x4516, 0x452d, 0x453e, 0x4553, 0x4564,
	0x4576, 0x4589, 0x45a6, 0x45c8, 0x45e5, 0x45f9, 0x4616, 0x4630,
	0x4648, 0x4662, 0x467a, 0x4694, 0x46ac, 0x46c7, 0x46e0, 0x46fa,
	0x4712, 0x4733, 0x4764, 0x4792, 0x47c3, 0x47f1, 0x4821, 0x484e,
	0x487f, 0x48ad, 0x48dd, 0x490a, 0x4939, 0x4967, 0x4987, 0x49a4,
	// Entry 3F00 - 3F3F
	0x49c3, 0x49df, 0x49fd, 0x4a1a, 0x4a41, 0x4a65, 0x4a84, 0x4aa0,
	0x4abe, 0x4adb, 0x4afb, 0x4b18, 0x4b37, 0x4b55, 0x4b75, 0x4b92,
	0x4bb1, 0x4bcf, 0x4bee, 0x4c0a, 0x4c28, 0x4c45, 0x4c65, 0x4c82,
	0x4ca1, 0x4cbf, 0x4cde, 0x4cfa, 0x4d1a, 0x4d37, 0x4d56, 0x4d72,
	0x4d92, 0x4daf, 0x4dcf, 0x4dec, 0x4e0b, 0x4e29, 0x4e4a, 0x4e68,
	0x4e88, 0x4ea7, 0x4ec6, 0x4ee2, 0x4f00, 0x4f1d, 0x4f3c, 0x4f58,
	0x4f76, 0x4f93, 0x4fb2, 0x4fce, 0x4fec, 0x5009, 0x5028, 0x5044,
	0x5062, 0x507f, 0x509e, 0x50ba, 0x50d8, 0x50f5, 0x5116, 0x5134,
	// Entry 3F40 - 3F7F
	0x5154, 0x5173, 0x5192, 0x51ae, 0x51cc, 0x51e9, 0x5208, 0x5224,
	0x5242, 0x525f, 0x527e, 0x529a, 0x52b8, 0x52d5, 0x52f4, 0x5310,
	0x532e, 0x534b, 0x536b, 0x5388, 0x53a7, 0x53c5, 0x53e5, 0x5402,
	0x5421, 0x543f, 0x545e, 0x547a, 0x5498, 0x54b5, 0x54d4, 0x54f0,
	0x5518, 0x553d, 0x555c, 0x5578, 0x5596, 0x55b3, 0x55ef, 0x5628,
	0x5664, 0x569d, 0x56d9, 0x5712, 0x573d, 0x5765, 0x577e, 0x5798,
	0x57b0, 0x57c5, 0x57da, 0x57f0, 0x5803, 0x5817, 0x5831, 0x584c,
	0x585e, 0x5871, 0x5880, 0x5896, 0x58a9, 0x58ba, 0x58ce, 0x58e1,
	// Entry 3F80 - 3FBF
	0x58f4, 0x5909, 0x591d, 0x5931, 0x5944, 0x5959, 0x596e, 0x5982,
	0x5991, 0x59a4, 0x59bc, 0x59d1, 0x59ec, 0x5a03, 0x5a1a, 0x5a3a,
	0x5a5a, 0x5a7a, 0x5a9a, 0x5aba, 0x5ada, 0x5afa, 0x5b1a, 0x5b3a,
	0x5b5a, 0x5b7a, 0x5b9a, 0x5bba, 0x5bda, 0x5bfa, 0x5c1a, 0x5c3a,
	0x5c5a, 0x5c7a, 0x5c9a, 0x5cba, 0x5cda, 0x5cfa, 0x5d1a, 0x5d3a,
	0x5d5a, 0x5d77, 0x5d90, 0x5dae, 0x5dc9, 0x5ddb, 0x5df1, 0x5e0f,
	0x5e2d, 0x5e4b, 0x5e69, 0x5e87, 0x5ea5, 0x5ec3, 0x5ee1, 0x5eff,
	0x5f1d, 0x5f3b, 0x5f59, 0x5f77, 0x5f95, 0x5fb3, 0x5fd1, 0x5fef,
	// Entry 3FC0 - 3FFF
	0x600d, 0x602b, 0x6049, 0x6067, 0x6085, 0x60a3, 0x60c1, 0x60df,
	0x60fd, 0x6119, 0x6130, 0x614d, 0x615c, 0x617c, 0x619d, 0x61bc,
	0x61d9, 0x61f7, 0x6212, 0x622f, 0x624b, 0x626c, 0x628d, 0x62ae,
	0x62cf, 0x62f0, 0x6312, 0x6334, 0x6356, 0x6378, 0x63a8, 0x63c3,
	0x63de, 0x63f9, 0x6414, 0x642f, 0x644b, 0x6467, 0x6483, 0x649f,
	0x64bb, 0x64d7, 0x64f3, 0x650f, 0x652b, 0x6547, 0x6563, 0x657f,
	0x659b, 0x65b7, 0x65d3, 0x65ef, 0x660b, 0x6627, 0x6643, 0x665f,
	0x667b, 0x6697, 0x66b3, 0x66cf, 0x66eb, 0x6707, 0x6723, 0x673f,
	// Entry 4000 - 403F
	0x675b, 0x6777, 0x6793, 0x67af, 0x67cb, 0x67e7, 0x6803, 0x681f,
	0x683b, 0x6857, 0x6873, 0x688e, 0x68b2, 0x68db, 0x68f2, 0x6910,
	0x6933, 0x6956, 0x6973, 0x6996, 0x69b9, 0x69d7, 0x69fa, 0x6a17,
	0x6a3b, 0x6a5e, 0x6a81, 0x6aa3, 0x6ac8, 0x6aed, 0x6b10, 0x6b2d,
	0x6b4a, 0x6b6c, 0x6b8e, 0x6baa, 0x6bcb, 0x6be8, 0x6c05, 0x6c27,
	0x6c46, 0x6c65, 0x6c84, 0x6ca3, 0x6cc0, 0x6cd9, 0x6cf3, 0x6d0d,
	0x6d28, 0x6d42, 0x6d5b, 0x6d76, 0x6d90, 0x6da9, 0x6dc3, 0x6dde,
	0x6df8, 0x6e12, 0x6e2b, 0x6e46, 0x6e60, 0x6e7a, 0x6e94, 0x6eae,
	// Entry 4040 - 407F
	0x6ec8, 0x6ee1, 0x6ef4, 0x6f08, 0x6f1a, 0x6f2a, 0x6f3e, 0x6f50,
	0x6f62, 0x6f80, 0x6f99, 0x6fb0, 0x6fca, 0x6fe3, 0x6ff9, 0x700f,
	0x702c, 0x704c, 0x706d, 0x7089, 0x709e, 0x70b6, 0x70ce, 0x70e6,
	0x70fe, 0x7116, 0x712f, 0x7148, 0x7161, 0x717a, 0x7193, 0x71ac,
	0x71c5, 0x71de, 0x71f7, 0x7210, 0x7229, 0x7242, 0x725b, 0x7274,
	0x728d, 0x72a6, 0x72bf, 0x72d8, 0x72f1, 0x730a, 0x7323, 0x733c,
	0x7355, 0x736e, 0x7387, 0x73a0, 0x73b9, 0x73d2, 0x73eb, 0x7404,
	0x741d, 0x7436, 0x744f, 0x7468, 0x7481, 0x749a, 0x74b3, 0x74cc,
	// Entry 4080 - 40BF
	0x74e5, 0x74fe, 0x7517, 0x7530, 0x7549, 0x7562, 0x757b, 0x7594,
	0x75ad, 0x75c6, 0x75df, 0x75f8, 0x7611, 0x762a, 0x7643, 0x765c,
	0x7675, 0x768e, 0x76a7, 0x76c0, 0x76da, 0x76f4, 0x770e, 0x7728,
	0x7742, 0x775c, 0x7776, 0x7790, 0x77aa, 0x77c4, 0x77de, 0x77f2,
	0x7806, 0x781a, 0x782e, 0x7842, 0x7856, 0x786a, 0x787e, 0x7892,
	0x78a6, 0x78ba, 0x78ce, 0x78e2, 0x78f6, 0x7910, 0x792c, 0x7947,
	0x7963, 0x797f, 0x799f, 0x79ba, 0x79d5, 0x79f5, 0x7a14, 0x7a2f,
	0x7a4b, 0x7a66, 0x7a82, 0x7a9e, 0x7abb, 0x7ad7, 0x7af3, 0x7b11,
	// Entry 40C0 - 40FF
	0x7b2c, 0x7b49, 0x7b63, 0x7b7e, 0x7b94, 0x7bb0, 0x7bcb, 0x7be8,
	0x7c03, 0x7c19, 0x7c34, 0x7c4a, 0x7c60, 0x7c7b, 0x7c91, 0x7ca7,
	0x7cbd, 0x7cd9, 0x7cef, 0x7d05, 0x7d21, 0x7d37, 0x7d4d, 0x7d6b,
	0x7d88, 0x7d9e, 0x7db4, 0x7dca, 0x7de0, 0x7df6, 0x7e0c, 0x7e22,
	0x7e38, 0x7e4e, 0x7e6a, 0x7e80, 0x7e9b, 0x7eb1, 0x7ec7, 0x7edd,
	0x7ef3, 0x7f09, 0x7f1f, 0x7f35, 0x7f4b, 0x7f61, 0x7f77, 0x7f8d,
	0x7faa, 0x7fca, 0x7fe8, 0x8004, 0x8020, 0x8036, 0x8052, 0x8068,
	0x807e, 0x80a4, 0x80c2, 0x80e6, 0x8102, 0x8118, 0x812e, 0x814a,
	// Entry 4100 - 413F
	0x8160, 0x8176, 0x818c, 0x81a2, 0x81b8, 0x81d3, 0x81e9, 0x81ff,
	0x8215, 0x822b, 0x8241, 0x825e, 0x827b, 0x8298, 0x82b5, 0x82d2,
	0x82ef, 0x830c, 0x8329, 0x8346, 0x8363, 0x8380, 0x839d, 0x83ba,
	0x83d7, 0x83f4, 0x8411, 0x842e, 0x844b, 0x8468, 0x8485, 0x84a2,
	0x84bf, 0x84dc, 0x84f9, 0x8516, 0x8533, 0x8550, 0x856d, 0x858a,
	0x85a4, 0x85bd, 0x85ce, 0x85df, 0x85f0, 0x8603, 0x8615, 0x8627,
	0x8638, 0x864b, 0x865e, 0x8670, 0x8681, 0x8695, 0x86a9, 0x86bc,
	0x86cf, 0x86e2, 0x86f7, 0x870b, 0x871f, 0x8738, 0x8751, 0x876c,
	// Entry 4140 - 417F
	0x8786, 0x87a0, 0x87b9, 0x87d4, 0x87ef, 0x8809, 0x8823, 0x883d,
	0x8859, 0x8874, 0x888f, 0x88a9, 0x88c5, 0x88e1, 0x88fc, 0x8916,
	0x8933, 0x8950, 0x896c, 0x8988, 0x89a4, 0x89c2, 0x89df, 0x89fc,
	0x8a13, 0x8a2e, 0x8a4a, 0x8a65, 0x8a81, 0x8aa1, 0x8ac4, 0x8ae1,
	0x8afd, 0x8b1f, 0x8b3e, 0x8b60, 0x8b7b, 0x8b97, 0x8bba, 0x8bde,
	0x8c03, 0x8c26, 0x8c48, 0x8c6c, 0x8c96, 0x8cc1, 0x8cec, 0x8d18,
	0x8d3b, 0x8d5d, 0x8d81, 0x8dab, 0x8dd6, 0x8e01, 0x8e2c, 0x8e59,
	0x8e78, 0x8e9d, 0x8eba, 0x8ed9, 0x8ef8, 0x8f15, 0x8f3b, 0x8f63,
	// Entry 4180 - 41BF
	0x8f83, 0x8fa2, 0x8fd0, 0x8fef, 0x900d, 0x902a, 0x904a, 0x906b,
	0x909b, 0x90bc, 0x90db, 0x9100, 0x9127, 0x914f, 0x9177, 0x919d,
	0x91c4, 0x91e8, 0x920e, 0x9235, 0x9257, 0x927b, 0x928e, 0x92b0,
	0x92c5, 0x92de, 0x92ed, 0x92fe, 0x9310, 0x931f, 0x9333, 0x9349,
	0x935e, 0x9373, 0x9386, 0x939d, 0x93ad, 0x93be, 0x93cf, 0x93e0,
	0x93f1, 0x9402, 0x941a, 0x9429, 0x943f, 0x9452, 0x9466, 0x9472,
	0x9484, 0x9494, 0x94a7, 0x94b9, 0x94d3, 0x94e5, 0x94f8, 0x950c,
	0x9521, 0x9535, 0x9542, 0x9556, 0x956a, 0x9587, 0x95a5, 0x95c5,
	// Entry 41C0 - 41FF
	0x95df, 0x95f7, 0x960f, 0x9628, 0x9643, 0x965b, 0x9673, 0x9689,
	0x96a2, 0x96b9, 0x96d4, 0x96ee, 0x9704, 0x971a, 0x9736, 0x9758,
	0x9771, 0x9788, 0x97a0, 0x97b9, 0x97d3, 0x97ea, 0x9801, 0x9818,
	0x9834, 0x984a, 0x9860, 0x9878, 0x988f, 0x98a7, 0x98bd, 0x98da,
	0x98f1, 0x990b, 0x9925, 0x993c, 0x9956, 0x996e, 0x9987, 0x99a2,
	0x99be, 0x99da, 0x9a05, 0x9a14, 0x9a23, 0x9a32, 0x9a42, 0x9a51,
	0x9a60, 0x9a6f, 0x9a7e, 0x9a8d, 0x9a9d, 0x9aac, 0x9abb, 0x9aca,
	0x9ad9, 0x9ae8, 0x9af7, 0x9b07, 0x9b17, 0x9b26, 0x9b35, 0x9b45,
	// Entry 4200 - 423F
	0x9b54, 0x9b63, 0x9b72, 0x9b82, 0x9b92, 0x9ba2, 0x9bb1, 0x9bc0,
	0x9bcf, 0x9bdf, 0x9bee, 0x9bfd, 0x9c0e, 0x9c1d, 0x9c2d, 0x9c3d,
	0x9c4c, 0x9c5b, 0x9c6a, 0x9c79, 0x9c89, 0x9c98, 0x9ca8, 0x9cb9,
	0x9cc8, 0x9cda, 0x9ce9, 0x9cf9, 0x9d08, 0x9d17, 0x9d28, 0x9d37,
	0x9d47, 0x9d56, 0x9d65, 0x9d77, 0x9d86, 0x9d96, 0x9da6, 0x9db6,
	0x9dc5, 0x9dd5, 0x9de5, 0x9df6, 0x9e06, 0x9e16, 0x9e28, 0x9e38,
	0x9e4a, 0x9e5a, 0x9e6a, 0x9e7b, 0x9e8c, 0x9e9d, 0x9eae, 0x9ebe,
	0x9ed0, 0x9eeb, 0x9f01, 0x9f17, 0x9f2f, 0x9f46, 0x9f5d, 0x9f73,
	// Entry 4240 - 427F
	0x9f8b, 0x9fa3, 0x9fba, 0x9fd1, 0x9feb, 0xa005, 0xa01e, 0xa037,
	0xa050, 0xa06b, 0xa085, 0xa09f, 0xa0be, 0xa0dd, 0xa0fe, 0xa11e,
	0xa13e, 0xa15d, 0xa17e, 0xa19f, 0xa1bf, 0xa1d2, 0xa1e6, 0xa1fa,
	0xa20e, 0xa221, 0xa235, 0xa249, 0xa25d, 0xa272, 0xa285, 0xa299,
	0xa2ad, 0xa2c1, 0xa2d5, 0xa2ea, 0xa2fd, 0xa311, 0xa326, 0xa33a,
	0xa34e, 0xa362, 0xa376, 0xa389, 0xa39e, 0xa3b3, 0xa3c8, 0xa3dc,
	0xa3f1, 0xa406, 0xa41a, 0xa42e, 0xa443, 0xa459, 0xa470, 0xa486,
	0xa49e, 0xa4b0, 0xa4c5, 0xa4d7, 0xa4e9, 0xa4fd, 0xa513, 0xa525,
	// Entry 4280 - 42BF
	0xa537, 0xa54b, 0xa55c, 0xa56f, 0xa582, 0xa595, 0xa5a9, 0xa5ba,
	0xa5cc, 0xa5e2, 0xa5f6, 0xa609, 0xa61c, 0xa62f, 0xa642, 0xa655,
	0xa668, 0xa67b, 0xa68e, 0xa6a8, 0xa6bc, 0xa6d1, 0xa6e6, 0xa6fb,
	0xa70e, 0xa724, 0xa73b, 0xa751, 0xa768, 0xa77b, 0xa791, 0xa7a6,
	0xa7bd, 0xa7d4, 0xa7ea, 0xa800, 0xa815, 0xa82a, 0xa83f, 0xa852,
	0xa869, 0xa880, 0xa899, 0xa8ae, 0xa8c4, 0xa8d7, 0xa8eb, 0xa8ff,
	0xa913, 0xa929, 0xa93e, 0xa953, 0xa969, 0xa97e, 0xa992, 0xa9a6,
	0xa9ba, 0xa9ce, 0xa9ec, 0xaa0b, 0xaa2b, 0xaa4c, 0xaa6b, 0xaa7f,
	// Entry 42C0 - 42FF
	0xaa93, 0xaaa8, 0xaabb, 0xaad0, 0xaae2, 0xaaf4, 0xab08, 0xab1c,
	0xab2f, 0xab42, 0xab55, 0xab69, 0xab7e, 0xab91, 0xaba5, 0xabb8,
	0xabca, 0xabdf, 0xabf2, 0xac04, 0xac18, 0xac2c, 0xac41, 0xac57,
	0xac6c, 0xac7e, 0xac8f, 0xaca0, 0xacb3, 0xacc8, 0xacda, 0xacec,
	0xacfe, 0xad11, 0xad24, 0xad37, 0xad4a, 0xad5d, 0xad70, 0xad83,
	0xad96, 0xada9, 0xadbc, 0xadcf, 0xade2, 0xadf5, 0xae09, 0xae1c,
	0xae2f, 0xae42, 0xae55, 0xae68, 0xae7b, 0xae8e, 0xaea1, 0xaeb4,
	0xaec7, 0xaeda, 0xaeed, 0xaf00, 0xaf13, 0xaf26, 0xaf39, 0xaf4d,
	// Entry 4300 - 433F
	0xaf61, 0xaf74, 0xaf8f, 0xafac, 0xafc9, 0xafe6, 0xb000, 0xb01c,
	0xb031, 0xb049, 0xb061, 0xb077, 0xb08d, 0xb0a3, 0xb0bc, 0xb0d6,
	0xb0f3, 0xb110, 0xb12d, 0xb14b, 0xb168, 0xb186, 0xb1a4, 0xb1c2,
	0xb1e0, 0xb1ff, 0xb21d, 0xb23c, 0xb255, 0xb26e, 0xb287, 0xb2a1,
	0xb2b9, 0xb2d3, 0xb2ed, 0xb307, 0xb321, 0xb33c, 0xb356, 0xb370,
	0xb38a, 0xb3a3, 0xb3bd, 0xb3d7, 0xb3f2, 0xb40b, 0xb425, 0xb43f,
	0xb45a, 0xb473, 0xb48c, 0xb4a5, 0xb4be, 0xb4d8, 0xb4f1, 0xb50a,
	0xb525, 0xb540, 0xb55b, 0xb577, 0xb592, 0xb5ae, 0xb5ca, 0xb5e6,
	// Entry 4340 - 437F
	0xb602, 0xb61f, 0xb63b, 0xb658, 0xb66f, 0xb686, 0xb69d, 0xb6b5,
	0xb6cb, 0xb6e3, 0xb6fb, 0xb713, 0xb72b, 0xb744, 0xb75c, 0xb774,
	0xb78c, 0xb7a3, 0xb7bb, 0xb7d3, 0xb7ec, 0xb803, 0xb81b, 0xb833,
	0xb84c, 0xb863, 0xb87a, 0xb891, 0xb8a8, 0xb8c0, 0xb8d7, 0xb8ee,
	0xb901, 0xb913, 0xb926, 0xb938, 0xb94c, 0xb95d, 0xb970, 0xb985,
	0xb997, 0xb9aa, 0xb9bc, 0xb9cf, 0xb9e1, 0xb9f3, 0xba06, 0xba18,
	0xba2e, 0xba42, 0xba54, 0xba68, 0xba7b, 0xba8e, 0xba9f, 0xbab1,
	0xbac3, 0xbad5, 0xbae6, 0xbaf9, 0xbb0b, 0xbb1c, 0xbb2f, 0xbb41,
	// Entry 4380 - 43BF
	0xbb53, 0xbb65, 0xbb77, 0xbb88, 0xbb9a, 0xbbad, 0xbbbf, 0xbbd1,
	0xbbe3, 0xbbf4, 0xbc06, 0xbc18, 0xbc2c, 0xbc3e, 0xbc50, 0xbc62,
	0xbc75, 0xbc86, 0xbc97, 0xbca8, 0xbcb9, 0xbccb, 0xbcde, 0xbcef,
	0xbd00, 0xbd14, 0xbd26, 0xbd39, 0xbd4a, 0xbd5b, 0xbd6e, 0xbd81,
	0xbd94, 0xbda7, 0xbdba, 0xbdcc, 0xbddd, 0xbdee, 0xbdfe, 0xbe0e,
	0xbe1e, 0xbe2e, 0xbe3e, 0xbe4f, 0xbe60, 0xbe71, 0xbe83, 0xbe94,
	0xbea5, 0xbeb8, 0xbeca, 0xbedc, 0xbeed, 0xbf00, 0xbf13, 0xbf25,
	0xbf3b, 0xbf52, 0xbf6a, 0xbf81, 0xbf99, 0xbfb1, 0xbfcb, 0xbfe1,
	// Entry 43C0 - 43FF
	0xbff9, 0xc010, 0xc028, 0xc03e, 0xc055, 0xc06e, 0xc086, 0xc09d,
	0xc0b4, 0xc0cb, 0xc0e1, 0xc0f9, 0xc110, 0xc129, 0xc140, 0xc158,
	0xc16f, 0xc188, 0xc1a0, 0xc1ba, 0xc1d3, 0xc1eb, 0xc201, 0xc218,
	0xc230, 0xc248, 0xc25f, 0xc277, 0xc28b, 0xc2a0, 0xc2b6, 0xc2cb,
	0xc2e1, 0xc2f7, 0xc30f, 0xc323, 0xc339, 0xc34e, 0xc364, 0xc378,
	0xc38d, 0xc3a4, 0xc3ba, 0xc3cf, 0xc3e4, 0xc3f9, 0xc40d, 0xc423,
	0xc438, 0xc44f, 0xc464, 0xc47a, 0xc48f, 0xc4a6, 0xc4bc, 0xc4d4,
	0xc4eb, 0xc501, 0xc515, 0xc52a, 0xc540, 0xc556, 0xc56b, 0xc581,
	// Entry 4400 - 443F
	0xc591, 0xc5a2, 0xc5b3, 0xc5c5, 0xc5d6, 0xc5e8, 0xc5fa, 0xc60b,
	0xc61b, 0xc62c, 0xc63d, 0xc64f, 0xc660, 0xc670, 0xc681, 0xc692,
	0xc6a3, 0xc6b5, 0xc6c6, 0xc6d7, 0xc6e8, 0xc6fa, 0xc70a, 0xc71b,
	0xc72c, 0xc73d, 0xc74f, 0xc760, 0xc772, 0xc783, 0xc795, 0xc7a5,
	0xc7b6, 0xc7c7, 0xc7d7, 0xc7e8, 0xc7fa, 0xc80c, 0xc821, 0xc833,
	0xc850, 0xc86d, 0xc88a, 0xc8a7, 0xc8c3, 0xc8e1, 0xc8fe, 0xc91c,
	0xc939, 0xc956, 0xc974, 0xc991, 0xc9ae, 0xc9cb, 0xc9e8, 0xca06,
	0xca24, 0xca42, 0xca5f, 0xca7d, 0xca9a, 0xcab8, 0xcad6, 0xcaf3,
	// Entry 4440 - 447F
	0xcb10, 0xcb2e, 0xcb4b, 0xcb69, 0xcb86, 0xcba3, 0xcbc1, 0xcbe0,
	0xcbfe, 0xcc1c, 0xcc38, 0xcc56, 0xcc73, 0xcc91, 0xccaf, 0xcccc,
	0xcceb, 0xcd08, 0xcd26, 0xcd44, 0xcd62, 0xcd80, 0xcd9d, 0xcdbb,
	0xcdd9, 0xcdf7, 0xce15, 0xce32, 0xce52, 0xce65, 0xce78, 0xce8b,
	0xce9e, 0xceb1, 0xcec4, 0xced7, 0xceea, 0xcefd, 0xcf10, 0xcf23,
	0xcf36, 0xcf49, 0xcf5c, 0xcf6f, 0xcf82, 0xcf96, 0xcfaa, 0xcfbd,
	0xcfd1, 0xcfe5, 0xcff8, 0xd00c, 0xd01f, 0xd032, 0xd045, 0xd058,
	0xd06b, 0xd07e, 0xd091, 0xd0a4, 0xd0b7, 0xd0ca, 0xd0dd, 0xd0f0,
	// Entry 4480 - 44BF
	0xd103, 0xd116, 0xd129, 0xd13c, 0xd14f, 0xd162, 0xd175, 0xd188,
	0xd19b, 0xd1ae, 0xd1c1, 0xd1d4, 0xd1e7, 0xd1fa, 0xd20d, 0xd220,
	0xd233, 0xd246, 0xd259, 0xd26c, 0xd27f, 0xd292, 0xd2a5, 0xd2b8,
	0xd2cb, 0xd2de, 0xd2f1, 0xd304, 0xd317, 0xd32a, 0xd33d, 0xd350,
	0xd363, 0xd376, 0xd389, 0xd39c, 0xd3b2, 0xd3c5, 0xd3d8, 0xd3eb,
	0xd3fe, 0xd411, 0xd425, 0xd439, 0xd44c, 0xd45f, 0xd472, 0xd485,
	0xd498, 0xd4ab, 0xd4bd, 0xd4cf, 0xd4e1, 0xd4f3, 0xd505, 0xd517,
	0xd529, 0xd53b, 0xd54e, 0xd561, 0xd574, 0xd586, 0xd598, 0xd5aa,
	// Entry 44C0 - 44FF
	0xd5bd, 0xd5d0, 0xd5e3, 0xd5f5, 0xd607, 0xd619, 0xd62b, 0xd63d,
	0xd64f, 0xd661, 0xd673, 0xd685, 0xd697, 0xd6a9, 0xd6bb, 0xd6cd,
	0xd6df, 0xd6f1, 0xd703, 0xd715, 0xd727, 0xd739, 0xd74b, 0xd75d,
	0xd76f, 0xd781, 0xd793, 0xd7a5, 0xd7b7, 0xd7c9, 0xd7db, 0xd7ed,
	0xd7ff, 0xd811, 0xd823, 0xd835, 0xd847, 0xd859, 0xd86b, 0xd87d,
	0xd88f, 0xd8a1, 0xd8b3, 0xd8c5, 0xd8d7, 0xd8e9, 0xd8fb, 0xd90d,
	0xd91f, 0xd931, 0xd943, 0xd955, 0xd967, 0xd979, 0xd98b, 0xd99d,
	0xd9af, 0xd9c1, 0xd9d3, 0xd9e5, 0xd9f7, 0xda0d, 0xda23, 0xda39,
	// Entry 4500 - 453F
	0xda4f, 0xda65, 0xda7b, 0xda91, 0xdaa7, 0xdabd, 0xdad3, 0xdae9,
	0xdaff, 0xdb15, 0xdb2b, 0xdb41, 0xdb57, 0xdb6d, 0xdb83, 0xdb99,
	0xdbab, 0xdbbd, 0xdbcf, 0xdbe1, 0xdbf3, 0xdc05, 0xdc17, 0xdc29,
	0xdc3b, 0xdc4d, 0xdc5f, 0xdc71, 0xdc83, 0xdc95, 0xdca7, 0xdcb9,
	0xdccb, 0xdcdd, 0xdcef, 0xdd01, 0xdd13, 0xdd25, 0xdd37, 0xdd49,
	0xdd5b, 0xdd6d, 0xdd7f, 0xdd91, 0xdda3, 0xddb5, 0xddc7, 0xddd9,
	0xddeb, 0xddfd, 0xde0f, 0xde21, 0xde33, 0xde45, 0xde57, 0xde69,
	0xde7b, 0xde8d, 0xde9f, 0xdeb1, 0xdec3, 0xded5, 0xdee7, 0xdef9,
	// Entry 4540 - 457F
	0xdf0b, 0xdf1d, 0xdf2f, 0xdf41, 0xdf53, 0xdf65, 0xdf77, 0xdf89,
	0xdf9b, 0xdfad, 0xdfbf, 0xdfd1, 0xdfe3, 0xdff5, 0xe007, 0xe019,
	0xe02b, 0xe03d, 0xe04f, 0xe061, 0xe073, 0xe085, 0xe097, 0xe0a9,
	0xe0bb, 0xe0cd, 0xe0df, 0xe0f1, 0xe103, 0xe115, 0xe127, 0xe139,
	0xe14b, 0xe15d, 0xe16f, 0xe181, 0xe193, 0xe1a5, 0xe1b7, 0xe1c9,
	0xe1db, 0xe1ed, 0xe1ff, 0xe211, 0xe223, 0xe235, 0xe247, 0xe259,
	0xe26b, 0xe27d, 0xe28f, 0xe2a1, 0xe2b3, 0xe2c5, 0xe2d7, 0xe2e9,
	0xe2fb, 0xe30d, 0xe31f, 0xe331, 0xe343, 0xe355, 0xe367, 0xe379,
	// Entry 4580 - 45BF
	0xe38b, 0xe39d, 0xe3af, 0xe3c1, 0xe3d3, 0xe3e5, 0xe3f7, 0xe409,
	0xe41b, 0xe42d, 0xe43f, 0xe451, 0xe463, 0xe475, 0xe487, 0xe499,
	0xe4ab, 0xe4bd, 0xe4cf, 0xe4e1, 0xe4f5, 0xe509, 0xe51d, 0xe531,
	0xe545, 0xe559, 0xe56d, 0xe581, 0xe595, 0xe5ac, 0xe5c3, 0xe5da,
	0xe5f1, 0xe605, 0xe619, 0xe62d, 0xe645, 0xe65b, 0xe670, 0xe685,
	0xe69c, 0xe6b1, 0xe6c3, 0xe6d5, 0xe6e7, 0xe6f9, 0xe70b, 0xe71d,
	0xe72f, 0xe741, 0xe753, 0xe765, 0xe777, 0xe789, 0xe79b, 0xe7ae,
	0xe7c1, 0xe7d4, 0xe7e7, 0xe7fa, 0xe80d, 0xe820, 0xe833, 0xe846,
	// Entry 45C0 - 45FF
	0xe859, 0xe86c, 0xe87f, 0xe892, 0xe8a5, 0xe8b8, 0xe8cb, 0xe8de,
	0xe8f1, 0xe904, 0xe917, 0xe92a, 0xe93d, 0xe950, 0xe963, 0xe976,
	0xe989, 0xe99c, 0xe9af, 0xe9c2, 0xe9d5, 0xe9e8, 0xe9fb, 0xea0e,
	0xea21, 0xea34, 0xea47, 0xea5a, 0xea6d, 0xea80, 0xea93, 0xeaa6,
	0xeab9, 0xeacc, 0xeadf, 0xeaf2, 0xeb05, 0xeb18, 0xeb2b, 0xeb3e,
	0xeb51, 0xeb6e, 0xeb8a, 0xeba7, 0xebc5, 0xebdf, 0xebfa, 0xec17,
	0xec33, 0xec4f, 0xec6b, 0xec87, 0xeca5, 0xecc0, 0xecdb, 0xecf9,
	0xed15, 0xed2f, 0xed4c, 0xed68, 0xed84, 0xeda0, 0xedbb, 0xedd8,
	// Entry 4600 - 463F
	0xedf3, 0xee0e, 0xee2b, 0xee46, 0xee64, 0xee87, 0xeeab, 0xeecf,
	0xeee5, 0xeefa, 0xef10, 0xef27, 0xef3a, 0xef4e, 0xef64, 0xef79,
	0xef8e, 0xefa3, 0xefb8, 0xefcf, 0xefe3, 0xeffd, 0xf011, 0xf028,
	0xf03d, 0xf050, 0xf066, 0xf07b, 0xf090, 0xf0a5, 0xf0b9, 0xf0d8,
	0xf0f8, 0xf10c, 0xf120, 0xf136, 0xf14b, 0xf160, 0xf174, 0xf18b,
	0xf1a7, 0xf1bd, 0xf1d8, 0xf1ed, 0xf203, 0xf21a, 0xf233, 0xf246,
	0xf25a, 0xf270, 0xf285, 0xf29a, 0xf2b5, 0xf2ca, 0xf2e5, 0xf2fa,
	0xf317, 0xf32e, 0xf348, 0xf35c, 0xf376, 0xf38a, 0xf3a1, 0xf3b6,
	// Entry 4640 - 467F
	0xf3c9, 0xf3df, 0xf3f4, 0xf409, 0xf424, 0xf439, 0xf44d, 0xf461,
	0xf475, 0xf48b, 0xf4a0, 0xf4bf, 0xf4d4, 0xf4e8, 0xf4ff, 0xf51b,
	0xf52e, 0xf540, 0xf553, 0xf56c, 0xf57c, 0xf58d, 0xf59f, 0xf5b1,
	0xf5c3, 0xf5d5, 0xf5e7, 0xf5fb, 0xf60c, 0xf61d, 0xf631, 0xf642,
	0xf652, 0xf665, 0xf677, 0xf689, 0xf69a, 0xf6ab, 0xf6bd, 0xf6ce,
	0xf6e2, 0xf6fb, 0xf710, 0xf725, 0xf73b, 0xf751, 0xf765, 0xf77a,
	0xf78f, 0xf7a4, 0xf7b9, 0xf7ce, 0xf7e3, 0xf7f9, 0xf80e, 0xf823,
	0xf839, 0xf84e, 0xf862, 0xf878, 0xf88d, 0xf8a3, 0xf8b9, 0xf8ce,
	// Entry 4680 - 46BF
	0xf8e3, 0xf8f8, 0xf910, 0xf92d, 0xf942, 0xf959, 0xf972, 0xf981,
	0xf990, 0xf99f, 0xf9ae, 0xf9bd, 0xf9cc, 0xf9db, 0xf9ea, 0xf9f9,
	0xfa08, 0xfa17, 0xfa26, 0xfa35, 0xfa44, 0xfa54, 0xfa63, 0xfa72,
	0xfa81, 0xfa90, 0xfa9f, 0xfaaf, 0xfabf, 0xfacf, 0xfadf, 0xfaef,
	0xfafe, 0xfb14, 0xfb32, 0xfb50, 0xfb6e, 0xfb8c, 0xfbab, 0xfbca,
	0xfbe9, 0xfc0a, 0xfc29, 0xfc48, 0xfc67, 0xfc88, 0xfca7, 0xfcc8,
	0xfce7, 0xfd08, 0xfd27, 0xfd47, 0xfd67, 0xfd86, 0xfda7, 0xfdc6,
	0xfde5, 0xfe04, 0xfe23, 0xfe44, 0xfe63, 0xfe84, 0xfea3, 0xfec2,
	// Entry 46C0 - 46FF
	0xfee3, 0xff06, 0xff1f, 0xff38, 0xff51, 0xff6a, 0xff84, 0xff9e,
	0xffb8, 0xffd2, 0xffec, 0x0006, 0x0020, 0x003a, 0x0054, 0x006f,
	0x008a, 0x00a4, 0x00c6, 0x00e0, 0x00fa, 0x0114, 0x012e, 0x0148,
	0x0162, 0x017c, 0x01a5, 0x01c7, 0x01e4, 0x0201, 0x021c, 0x0237,
	0x0254, 0x0270, 0x028c, 0x02a7, 0x02c4, 0x02e1, 0x02fd, 0x0318,
	0x0336, 0x0354, 0x0371, 0x038e, 0x03ab, 0x03ca, 0x03ed, 0x0410,
	0x0435, 0x0459, 0x047d, 0x04a0, 0x04c5, 0x04ea, 0x050e, 0x0532,
	0x0556, 0x057c, 0x05a1, 0x05c6, 0x05ea, 0x0610, 0x0636, 0x065b,
	// Entry 4700 - 473F
	0x067f, 0x06a6, 0x06cd, 0x06f3, 0x0719, 0x073f, 0x0767, 0x078e,
	0x07b5, 0x07e1, 0x080d, 0x083b, 0x0868, 0x0895, 0x08c1, 0x08ef,
	0x091d, 0x094a, 0x096f, 0x0995, 0x09bd, 0x09e4, 0x0a0b, 0x0a31,
	0x0a59, 0x0a81, 0x0aa8, 0x0ace, 0x0ae1, 0x0af8, 0x0b0f, 0x0b2e,
	0x0b45, 0x0b5c, 0x0b78, 0x0b99, 0x0bb1, 0x0bc8, 0x0bdc, 0x0bf1,
	0x0c05, 0x0c1a, 0x0c2e, 0x0c43, 0x0c57, 0x0c6c, 0x0c81, 0x0c97,
	0x0cac, 0x0cc2, 0x0cd7, 0x0ceb, 0x0d00, 0x0d14, 0x0d29, 0x0d3d,
	0x0d51, 0x0d66, 0x0d7a, 0x0d8f, 0x0da3, 0x0db7, 0x0dcb, 0x0ddf,
	// Entry 4740 - 477F
	0x0df3, 0x0e08, 0x0e1d, 0x0e31, 0x0e45, 0x0e59, 0x0e6e, 0x0e85,
	0x0e9e, 0x0eb3, 0x0ecc, 0x0edd, 0x0ef1, 0x0f05, 0x0f1b, 0x0f30,
	0x0f45, 0x0f5d, 0x0f7a, 0x0f98, 0x0fb2, 0x0fd5, 0x0ff2, 0x1015,
	0x1034, 0x1050, 0x106c, 0x108f, 0x10ab, 0x10c6, 0x10e5, 0x1102,
	0x111e, 0x113b, 0x1157, 0x1174, 0x1191, 0x11ae, 0x11ca, 0x11e6,
	0x1203, 0x121f, 0x123d, 0x125b, 0x127a, 0x1295, 0x12b2, 0x12ce,
	0x12ed, 0x130b, 0x132a, 0x1348, 0x1365, 0x1382, 0x13a2, 0x13bf,
	0x13dc, 0x13fa, 0x1416, 0x1434, 0x1457, 0x1473, 0x148f, 0x14ab,
	// Entry 4780 - 47BF
	0x14c8, 0x14e4, 0x1500, 0x151d, 0x1539, 0x1555, 0x1571, 0x158e,
	0x15aa, 0x15c7, 0x15e4, 0x1600, 0x161d, 0x1639, 0x1656, 0x1672,
	0x168e, 0x16ab, 0x16c7, 0x16e5, 0x1701, 0x171e, 0x173b, 0x1757,
	0x1774, 0x1790, 0x17ac, 0x17c8, 0x17e7, 0x17fe, 0x1814, 0x182b,
	0x1842, 0x185a, 0x1872, 0x1886, 0x189b, 0x18ad, 0x18c4, 0x18dc,
	0x18f3, 0x190b, 0x1921, 0x1937, 0x194d, 0x1963, 0x1979, 0x1990,
	0x19a8, 0x19c1, 0x19da, 0x19ef, 0x1a04, 0x1a1c, 0x1a32, 0x1a49,
	0x1a5d, 0x1a71, 0x1a88, 0x1a9e, 0x1ab4, 0x1acb, 0x1ae1, 0x1af7,
	// Entry 47C0 - 47FF
	0x1b0e, 0x1b23, 0x1b45, 0x1b67, 0x1b7c, 0x1b92, 0x1ba7, 0x1bbf,
	0x1bdc, 0x1bf7, 0x1c15, 0x1c41, 0x1c66, 0x1c80, 0x1c9f, 0x1cc1,
	0x1cd1, 0x1ce2, 0x1cf3, 0x1d05, 0x1d16, 0x1d28, 0x1d39, 0x1d4b,
	0x1d5b, 0x1d6c, 0x1d7c, 0x1d8d, 0x1d9d, 0x1dae, 0x1dbe, 0x1dcf,
	0x1de0, 0x1df1, 0x1e03, 0x1e15, 0x1e26, 0x1e38, 0x1e4a, 0x1e5b,
	0x1e6c, 0x1e7d, 0x1e8f, 0x1ea0, 0x1eb2, 0x1ec4, 0x1ed5, 0x1ee6,
	0x1ef7, 0x1f09, 0x1f1b, 0x1f2e, 0x1f41, 0x1f52, 0x1f64, 0x1f76,
	0x1f87, 0x1f99, 0x1fab, 0x1fbc, 0x1fcd, 0x1fde, 0x1fef, 0x2000,
	// Entry 4800 - 483F
	0x2011, 0x2023, 0x2035, 0x2048, 0x205b, 0x206c, 0x2085, 0x20ab,
	0x20d2, 0x20f9, 0x2120, 0x2149, 0x2172, 0x2195, 0x21b7, 0x21da,
	0x21fe, 0x221e, 0x223f, 0x2262, 0x2284, 0x22a6, 0x22c8, 0x22ea,
	0x230e, 0x232f, 0x2350, 0x2374, 0x2396, 0x23b6, 0x23d9, 0x23fb,
	0x241d, 0x243f, 0x2460, 0x2481, 0x24a2, 0x24c5, 0x24e7, 0x2508,
	0x252c, 0x2555, 0x257f, 0x25a1, 0x25c2, 0x25e4, 0x2607, 0x2626,
	0x2650, 0x2672, 0x2693, 0x26b4, 0x26d5, 0x26f6, 0x2719, 0x273e,
	0x275e, 0x2781, 0x27a0, 0x27c2, 0x27e3, 0x2803, 0x2823, 0x2843,
	// Entry 4840 - 487F
	0x2865, 0x2886, 0x28a6, 0x28c9, 0x28f1, 0x291a, 0x2936, 0x2951,
	0x296d, 0x298a, 0x29a3, 0x29c7, 0x29e3, 0x29fe, 0x2a19, 0x2a34,
	0x2a51, 0x2a70, 0x2a8a, 0x2aa7, 0x2ac0, 0x2adc, 0x2af7, 0x2b11,
	0x2b2d, 0x2b50, 0x2b74, 0x2b96, 0x2bb0, 0x2bca, 0x2be6, 0x2c01,
	0x2c1b, 0x2c38, 0x2c5a, 0x2c74, 0x2c8f, 0x2cab, 0x2cc5, 0x2ce0,
	0x2cfb, 0x2d15, 0x2d30, 0x2d4c, 0x2d67, 0x2d83, 0x2d9f, 0x2dbc,
	0x2dd7, 0x2df3, 0x2e0f, 0x2e2c, 0x2e47, 0x2e63, 0x2e7f, 0x2e9a,
	0x2eb6, 0x2ed1, 0x2eed, 0x2f09, 0x2f26, 0x2f42, 0x2f5f, 0x2f7b,
	// Entry 4880 - 48BF
	0x2f98, 0x2fb3, 0x2fcf, 0x2feb, 0x3007, 0x3022, 0x303d, 0x3059,
	0x3076, 0x3092, 0x30af, 0x30cb, 0x30e8, 0x3104, 0x3121, 0x313e,
	0x315a, 0x3178, 0x3193, 0x31ae, 0x31c9, 0x31e4, 0x3200, 0x321b,
	0x3237, 0x3252, 0x326e, 0x3289, 0x32a5, 0x32c0, 0x32dc, 0x32f8,
	0x3313, 0x332f, 0x334b, 0x3368, 0x3384, 0x33a1, 0x33bc, 0x33d8,
	0x33f4, 0x3411, 0x342c, 0x3449, 0x3467, 0x3486, 0x34a5, 0x34c5,
	0x34e4, 0x3504, 0x3524, 0x3543, 0x3563, 0x3581, 0x35a5, 0x35c4,
	0x35e3, 0x3602, 0x3622, 0x3641, 0x365f, 0x367e, 0x369d, 0x36bc,
	// Entry 48C0 - 48FF
	0x36db, 0x36fb, 0x371a, 0x373a, 0x3759, 0x3778, 0x3798, 0x37b6,
	0x37d5, 0x37ff, 0x3828, 0x3848, 0x3867, 0x3887, 0x38a6, 0x38cb,
	0x38ea, 0x390a, 0x3929, 0x3949, 0x3969, 0x3989, 0x39a7, 0x39c6,
	0x39f0, 0x3a19, 0x3a38, 0x3a57, 0x3a77, 0x3aa3, 0x3ac2, 0x3ade,
	0x3afb, 0x3b18, 0x3b36, 0x3b53, 0x3b71, 0x3b8f, 0x3bac, 0x3bca,
	0x3be6, 0x3c08, 0x3c25, 0x3c42, 0x3c5f, 0x3c7d, 0x3c9a, 0x3cb6,
	0x3cd3, 0x3cf0, 0x3d0d, 0x3d2a, 0x3d48, 0x3d65, 0x3d83, 0x3da0,
	0x3dbd, 0x3ddb, 0x3df7, 0x3e14, 0x3e3c, 0x3e63, 0x3e81, 0x3e9e,
	// Entry 4900 - 493F
	0x3ebc, 0x3ed9, 0x3efc, 0x3f19, 0x3f37, 0x3f54, 0x3f72, 0x3f90,
	0x3fae, 0x3fca, 0x3fe7, 0x400f, 0x4036, 0x4053, 0x4070, 0x408e,
	0x40b8, 0x40d5, 0x40ed, 0x4106, 0x411e, 0x4138, 0x4158, 0x4179,
	0x4187, 0x4195, 0x41a5, 0x41b4, 0x41c3, 0x41d1, 0x41e1, 0x41f1,
	0x4200, 0x420f, 0x4221, 0x4233, 0x4244, 0x4255, 0x4266, 0x4279,
	0x428b, 0x429d, 0x42b4, 0x42cb, 0x42e4, 0x42fc, 0x4314, 0x432b,
	0x4344, 0x435d, 0x4375, 0x438b, 0x43a4, 0x43bb, 0x43d3, 0x43ea,
	0x43fe, 0x4411, 0x4428, 0x443f, 0x444e, 0x445e, 0x446d, 0x447d,
	// Entry 4940 - 497F
	0x448c, 0x449c, 0x44b3, 0x44cb, 0x44e2, 0x44fa, 0x4509, 0x4519,
	0x4528, 0x4538, 0x4548, 0x4559, 0x4569, 0x457a, 0x458b, 0x459b,
	0x45ac, 0x45bc, 0x45cd, 0x45de, 0x45ef, 0x4601, 0x4612, 0x4624,
	0x4635, 0x4645, 0x4656, 0x4666, 0x4677, 0x4687, 0x4697, 0x46a8,
	0x46b8, 0x46c9, 0x46d9, 0x46e9, 0x46f9, 0x4709, 0x4719, 0x472a,
	0x473b, 0x474b, 0x475b, 0x476c, 0x4788, 0x47a3, 0x47bf, 0x47d3,
	0x47f3, 0x4806, 0x481a, 0x482d, 0x4841, 0x485c, 0x4878, 0x4893,
	0x48af, 0x48c2, 0x48d6, 0x48e9, 0x48fd, 0x490a, 0x4916, 0x4929,
	// Entry 4980 - 49BF
	0x493f, 0x495c, 0x4973, 0x4992, 0x49aa, 0x49bb, 0x49cc, 0x49df,
	0x49f1, 0x4a03, 0x4a14, 0x4a27, 0x4a3a, 0x4a4c, 0x4a5d, 0x4a71,
	0x4a85, 0x4a98, 0x4aab, 0x4abe, 0x4ad3, 0x4ae7, 0x4afb, 0x4b14,
	0x4b2e, 0x4b3f, 0x4b4f, 0x4b5f, 0x4b71, 0x4b82, 0x4b93, 0x4ba3,
	0x4bb5, 0x4bc7, 0x4bd8, 0x4bec, 0x4c03, 0x4c17, 0x4c2a, 0x4c39,
	0x4c49, 0x4c58, 0x4c68, 0x4c77, 0x4c87, 0x4c96, 0x4ca6, 0x4cb5,
	0x4cc5, 0x4cd5, 0x4ce6, 0x4cf6, 0x4d07, 0x4d18, 0x4d28, 0x4d39,
	0x4d49, 0x4d5a, 0x4d6b, 0x4d7c, 0x4d8e, 0x4d9f, 0x4db2, 0x4dc4,
	// Entry 49C0 - 49FF
	0x4dd5, 0x4de6, 0x4df6, 0x4e07, 0x4e17, 0x4e28, 0x4e38, 0x4e48,
	0x4e59, 0x4e69, 0x4e7a, 0x4e8a, 0x4e9a, 0x4eaa, 0x4eba, 0x4eca,
	0x4edb, 0x4eec, 0x4efc, 0x4f0c, 0x4f20, 0x4f33, 0x4f47, 0x4f5a,
	0x4f6e, 0x4f81, 0x4f95, 0x4fa8, 0x4fbc, 0x4fce, 0x4fdf, 0x4ff7,
	0x500e, 0x5020, 0x5033, 0x504d, 0x5059, 0x506c, 0x5083, 0x509a,
	0x50b1, 0x50c8, 0x50df, 0x50f6, 0x510d, 0x5125, 0x513c, 0x5153,
	0x516a, 0x5181, 0x5198, 0x51af, 0x51c6, 0x51dd, 0x51f4, 0x520c,
	0x5222, 0x5239, 0x524f, 0x5265, 0x527b, 0x5291, 0x52a8, 0x52bf,
	// Entry 4A00 - 4A3F
	0x52d5, 0x52eb, 0x5303, 0x531a, 0x5331, 0x5347, 0x535f, 0x5377,
	0x538e, 0x53a5, 0x53b9, 0x53cc, 0x53dc, 0x53eb, 0x53fa, 0x5409,
	0x541a, 0x542c, 0x543d, 0x544f, 0x5461, 0x5472, 0x5484, 0x5495,
	0x54a7, 0x54b9, 0x54cb, 0x54de, 0x54f0, 0x5503, 0x5515, 0x5526,
	0x5538, 0x5549, 0x555b, 0x556c, 0x557d, 0x558f, 0x55a0, 0x55b2,
	0x55c3, 0x55d5, 0x55e6, 0x55f7, 0x5608, 0x5619, 0x562a, 0x563b,
	0x564e, 0x5661, 0x5675, 0x5688, 0x569c, 0x56af, 0x56c3, 0x56d6,
	0x56ea, 0x56fe, 0x570b, 0x5719, 0x5726, 0x5734, 0x5745, 0x5755,
	// Entry 4A40 - 4A7F
	0x5765, 0x5777, 0x5788, 0x5799, 0x57a9, 0x57bb, 0x57cd, 0x57de,
	0x57f1, 0x57fd, 0x5810, 0x5824, 0x5835, 0x5846, 0x5857, 0x5868,
	0x5879, 0x588b, 0x589e, 0x58b0, 0x58c3, 0x58d5, 0x58e8, 0x58fa,
	0x590d, 0x5920, 0x5933, 0x5947, 0x595a, 0x596e, 0x5981, 0x5993,
	0x59a6, 0x59b8, 0x59cb, 0x59dd, 0x59ef, 0x5a02, 0x5a14, 0x5a27,
	0x5a39, 0x5a4b, 0x5a5d, 0x5a6f, 0x5a81, 0x5a93, 0x5aa6, 0x5ab9,
	0x5ad3, 0x5ae8, 0x5afe, 0x5b16, 0x5b2b, 0x5b3f, 0x5b4f, 0x5b60,
	0x5b70, 0x5b81, 0x5b91, 0x5ba2, 0x5bba, 0x5bd3, 0x5beb, 0x5c04,
	// Entry 4A80 - 4ABF
	0x5c14, 0x5c25, 0x5c35, 0x5c46, 0x5c57, 0x5c69, 0x5c7a, 0x5c8c,
	0x5c9e, 0x5caf, 0x5cc1, 0x5cd2, 0x5ce4, 0x5cf6, 0x5d08, 0x5d1b,
	0x5d2d, 0x5d40, 0x5d52, 0x5d63, 0x5d75, 0x5d86, 0x5d98, 0x5da9,
	0x5dba, 0x5dcc, 0x5ddd, 0x5def, 0x5e00, 0x5e11, 0x5e22, 0x5e33,
	0x5e45, 0x5e56, 0x5e68, 0x5e7a, 0x5e8b, 0x5e9c, 0x5eb1, 0x5ec5,
	0x5eda, 0x5eee, 0x5f03, 0x5f1f, 0x5f3c, 0x5f58, 0x5f75, 0x5f89,
	0x5f9e, 0x5fb2, 0x5fc7, 0x5fda, 0x5fef, 0x6007, 0x601f, 0x6029,
	0x6036, 0x604a, 0x6063, 0x6074, 0x6087, 0x6099, 0x60b4, 0x60d2,
	// Entry 4AC0 - 4AFF
	0x60e4, 0x60f6, 0x6107, 0x6118, 0x612b, 0x613d, 0x614f, 0x6160,
	0x6173, 0x6186, 0x6198, 0x61a4, 0x61b8, 0x61ca, 0x61e3, 0x61f9,
	0x620f, 0x6228, 0x6241, 0x625c, 0x6276, 0x6290, 0x62a9, 0x62c4,
	0x62df, 0x62f9, 0x6313, 0x6330, 0x634d, 0x6369, 0x6385, 0x63a1,
	0x63bf, 0x63dc, 0x63f9, 0x641b, 0x643e, 0x644d, 0x645d, 0x646c,
	0x647b, 0x648a, 0x649a, 0x64a9, 0x64b9, 0x64c9, 0x64da, 0x64ea,
	0x64fb, 0x650c, 0x651d, 0x652d, 0x653e, 0x654e, 0x655f, 0x6570,
	0x6581, 0x6593, 0x65a4, 0x65b6, 0x65c7, 0x65d7, 0x65e8, 0x65f8,
	// Entry 4B00 - 4B3F
	0x660a, 0x661b, 0x662b, 0x663b, 0x664c, 0x665c, 0x666d, 0x667e,
	0x668e, 0x669e, 0x66ae, 0x66be, 0x66ce, 0x66de, 0x66ee, 0x66ff,
	0x6713, 0x6726, 0x673a, 0x674d, 0x6760, 0x6774, 0x6787, 0x679b,
	0x67af, 0x67c1, 0x67d2, 0x67e4, 0x67f0, 0x6803, 0x6818, 0x682b,
	0x6845, 0x685d, 0x686e, 0x687e, 0x688e, 0x689e, 0x68ae, 0x68bf,
	0x68d1, 0x68e2, 0x68f4, 0x6905, 0x6917, 0x6928, 0x693a, 0x694c,
	0x695e, 0x6971, 0x6983, 0x6996, 0x69a9, 0x69bb, 0x69cc, 0x69de,
	0x69ef, 0x6a01, 0x6a12, 0x6a23, 0x6a35, 0x6a46, 0x6a58, 0x6a69,
	// Entry 4B40 - 4B7F
	0x6a7a, 0x6a8b, 0x6a9c, 0x6aad, 0x6abe, 0x6acf, 0x6ae1, 0x6af3,
	0x6b07, 0x6b19, 0x6b2c, 0x6b3e, 0x6b51, 0x6b63, 0x6b76, 0x6b88,
	0x6b9b, 0x6bad, 0x6bc0, 0x6bd3, 0x6be7, 0x6bfa, 0x6c0e, 0x6c22,
	0x6c36, 0x6c49, 0x6c5d, 0x6c70, 0x6c84, 0x6c98, 0x6cac, 0x6cc0,
	0x6cd5, 0x6ce9, 0x6cfe, 0x6d12, 0x6d27, 0x6d3b, 0x6d4e, 0x6d62,
	0x6d75, 0x6d89, 0x6d9c, 0x6daf, 0x6dc3, 0x6dd6, 0x6dea, 0x6dfe,
	0x6e11, 0x6e24, 0x6e37, 0x6e4a, 0x6e5d, 0x6e71, 0x6e84, 0x6e97,
	0x6eae, 0x6ec5, 0x6edb, 0x6ef2, 0x6f08, 0x6f1f, 0x6f35, 0x6f4c,
	// Entry 4B80 - 4BBF
	0x6f62, 0x6f79, 0x6f8d, 0x6fa2, 0x6fb6, 0x6fc9, 0x6fdc, 0x6ff1,
	0x7005, 0x7019, 0x702c, 0x7041, 0x7056, 0x706a, 0x708f, 0x70a7,
	0x70bc, 0x70d0, 0x70e0, 0x70f1, 0x7101, 0x7112, 0x7122, 0x7133,
	0x714b, 0x7163, 0x7174, 0x7185, 0x7196, 0x71a7, 0x71b8, 0x71ca,
	0x71db, 0x71ed, 0x71ff, 0x7210, 0x7222, 0x7233, 0x7245, 0x7257,
	0x7269, 0x727c, 0x728e, 0x72a1, 0x72b3, 0x72c4, 0x72d6, 0x72e7,
	0x72f9, 0x730a, 0x731b, 0x732d, 0x733e, 0x7350, 0x7361, 0x7372,
	0x7383, 0x7394, 0x73a6, 0x73b7, 0x73c9, 0x73db, 0x73ec, 0x73fd,
	// Entry 4BC0 - 4BFF
	0x740f, 0x7424, 0x7439, 0x744d, 0x7462, 0x7476, 0x748b, 0x74a7,
	0x74c4, 0x74d9, 0x74ee, 0x7503, 0x7518, 0x752b, 0x7535, 0x754b,
	0x755d, 0x757a, 0x759e, 0x75b7, 0x75d0, 0x75ec, 0x7609, 0x7625,
	0x7640, 0x765b, 0x7678, 0x7694, 0x76b0, 0x76cb, 0x76e5, 0x7700,
	0x771b, 0x7736, 0x7751, 0x775e, 0x776c, 0x7779, 0x7787, 0x7794,
	0x77a2, 0x77b7, 0x77cd, 0x77e2, 0x77f8, 0x7805, 0x7813, 0x7820,
	0x782e, 0x783c, 0x784b, 0x7859, 0x7868, 0x7877, 0x7887, 0x7895,
	0x78a4, 0x78b2, 0x78c1, 0x78d0, 0x78e0, 0x78ef, 0x78ff, 0x790e,
	// Entry 4C00 - 4C3F
	0x791e, 0x792d, 0x793b, 0x794a, 0x7958, 0x7967, 0x7975, 0x7984,
	0x7992, 0x79a1, 0x79af, 0x79be, 0x79cc, 0x79db, 0x79e9, 0x79f7,
	0x7a06, 0x7a14, 0x7a23, 0x7a31, 0x7a40, 0x7a4f, 0x7a5d, 0x7a6b,
	0x7a7d, 0x7a8e, 0x7aa0, 0x7ab1, 0x7ac3, 0x7adc, 0x7af6, 0x7b0f,
	0x7b29, 0x7b3a, 0x7b4c, 0x7b5d, 0x7b6f, 0x7b7f, 0x7b94, 0x7ba6,
	0x7bb7, 0x7bc6, 0x7bd8, 0x7bf0, 0x7bf7, 0x7c02, 0x7c0c, 0x7c1d,
	0x7c27, 0x7c36, 0x7c4c, 0x7c5b, 0x7c69, 0x7c77, 0x7c87, 0x7c96,
	0x7ca5, 0x7cb3, 0x7cc3, 0x7cd3, 0x7ce2, 0x7cf7, 0x7d0a, 0x7d16,
	// Entry 4C40 - 4C7F
	0x7d26, 0x7d37, 0x7d47, 0x7d58, 0x7d68, 0x7d79, 0x7d91, 0x7daa,
	0x7dc2, 0x7ddb, 0x7deb, 0x7dfc, 0x7e0c, 0x7e1d, 0x7e2e, 0x7e40,
	0x7e51, 0x7e63, 0x7e75, 0x7e86, 0x7e98, 0x7ea9, 0x7ebb, 0x7ecd,
	0x7edf, 0x7ef2, 0x7f04, 0x7f17, 0x7f29, 0x7f3a, 0x7f4c, 0x7f5d,
	0x7f6f, 0x7f80, 0x7f91, 0x7fa3, 0x7fb4, 0x7fc6, 0x7fd7, 0x7fe8,
	0x7ff9, 0x800a, 0x801b, 0x802d, 0x803f, 0x8050, 0x8061, 0x8076,
	0x808a, 0x809f, 0x80b3, 0x80c8, 0x80e4, 0x8101, 0x811d, 0x813a,
	0x814e, 0x8168, 0x817d, 0x8191, 0x81ab, 0x81c0, 0x81d8, 0x81ed,
	// Entry 4C80 - 4CBF
	0x8201, 0x8214, 0x8226, 0x823b, 0x8248, 0x8261, 0x826b, 0x827d,
	0x828e, 0x829f, 0x82b2, 0x82c4, 0x82d6, 0x82e7, 0x82fa, 0x830d,
	0x831f, 0x832f, 0x8340, 0x8350, 0x8361, 0x8371, 0x8382, 0x839a,
	0x83b3, 0x83cb, 0x83e4, 0x83f4, 0x8405, 0x8415, 0x8426, 0x8437,
	0x8449, 0x845a, 0x846c, 0x847e, 0x848f, 0x84a1, 0x84b2, 0x84c4,
	0x84d6, 0x84e8, 0x84fb, 0x850d, 0x8520, 0x8532, 0x8543, 0x8555,
	0x8566, 0x8578, 0x8589, 0x859a, 0x85ac, 0x85bd, 0x85cf, 0x85e0,
	0x85f1, 0x8602, 0x8613, 0x8624, 0x8636, 0x8648, 0x8659, 0x866a,
	// Entry 4CC0 - 4CFF
	0x867f, 0x8693, 0x86a8, 0x86bc, 0x86d1, 0x86ed, 0x870a, 0x871e,
	0x8733, 0x8747, 0x875c, 0x8774, 0x8789, 0x879d, 0x87b0, 0x87c2,
	0x87d6, 0x87e3, 0x87f7, 0x880c, 0x8821, 0x883a, 0x8853, 0x886c,
	0x8884, 0x88bc, 0x88f2, 0x8925, 0x895f, 0x8999, 0x89b9, 0x89e3,
	0x8a0d, 0x8a37, 0x8a64, 0x8a90, 0x8aba, 0x8aee, 0x8b23, 0x8b4a,
	0x8b6f, 0x8b95, 0x8baf, 0x8bcd, 0x8bec, 0x8bf9, 0x8c07, 0x8c14,
	0x8c22, 0x8c2f, 0x8c3d, 0x8c52, 0x8c68, 0x8c7d, 0x8c93, 0x8ca0,
	0x8cae, 0x8cbb, 0x8cc9, 0x8cd7, 0x8ce6, 0x8cf4, 0x8d03, 0x8d12,
	// Entry 4D00 - 4D3F
	0x8d20, 0x8d2f, 0x8d3d, 0x8d4c, 0x8d5b, 0x8d6a, 0x8d7a, 0x8d89,
	0x8d99, 0x8da8, 0x8db6, 0x8dc5, 0x8dd3, 0x8de2, 0x8df0, 0x8dfe,
	0x8e0d, 0x8e1b, 0x8e2a, 0x8e38, 0x8e46, 0x8e54, 0x8e62, 0x8e70,
	0x8e7f, 0x8e8e, 0x8e9c, 0x8eaa, 0x8eb9, 0x8ecb, 0x8edc, 0x8eee,
	0x8eff, 0x8f11, 0x8f2a, 0x8f44, 0x8f5d, 0x8f77, 0x8f88, 0x8f9a,
	0x8fab, 0x8fbd, 0x8fcf, 0x8fe0, 0x8ff0, 0x9005, 0x900f, 0x9020,
	0x9036, 0x9044, 0x9053, 0x9061, 0x906f, 0x907f, 0x908e, 0x909d,
	0x90ab, 0x90bb, 0x90cb, 0x90da, 0x90f7, 0x910e, 0x9132, 0x9156,
	// Entry 4D40 - 4D7F
	0x917a, 0x919f, 0x91cb, 0x91e3, 0x9210, 0x9225, 0x9248, 0x9272,
	0x92a3, 0x92b1, 0x92c0, 0x92ce, 0x92dd, 0x92eb, 0x92fa, 0x9308,
	0x9317, 0x9325, 0x9334, 0x9343, 0x9353, 0x9362, 0x9372, 0x9382,
	0x9391, 0x93a1, 0x93b0, 0x93c0, 0x93d0, 0x93e0, 0x93f1, 0x9401,
	0x9412, 0x9422, 0x9431, 0x9441, 0x9450, 0x9460, 0x946f, 0x947e,
	0x948e, 0x949d, 0x94ad, 0x94bc, 0x94cb, 0x94da, 0x94e9, 0x94f8,
	0x9508, 0x9517, 0x9526, 0x9536, 0x9549, 0x955b, 0x956e, 0x9580,
	0x9593, 0x95a5, 0x95b8, 0x95ca, 0x95dd, 0x95ef, 0x9602, 0x9613,
	// Entry 4D80 - 4DBF
	0x9623, 0x9633, 0x9642, 0x9651, 0x9662, 0x9672, 0x9682, 0x9691,
	0x96a2, 0x96b3, 0x96c3, 0x96d1, 0x96e0, 0x96ef, 0x96fd, 0x970b,
	0x9723, 0x9731, 0x9740, 0x974e, 0x975c, 0x976a, 0x9779, 0x9788,
	0x9796, 0x97a4, 0x97b2, 0x97c1, 0x97cf, 0x97dc, 0x97ea, 0x97f9,
	0x9807, 0x981f, 0x982e, 0x983d, 0x984c, 0x9869, 0x9886, 0x98ac,
	0x98bd, 0x98cf, 0x98e0, 0x98f2, 0x9903, 0x9915, 0x9926, 0x9938,
	0x9949, 0x995b, 0x996d, 0x997d, 0x998c, 0x999a, 0x99a8, 0x99b8,
	0x99c7, 0x99d6, 0x99e4, 0x99f4, 0x9a04, 0x9a13, 0x9a22, 0x9a34,
	// Entry 4DC0 - 4DFF
	0x9a4b, 0x9a5c, 0x9a6b, 0x9a79, 0x9a98, 0x9ab4, 0x9ad1, 0x9aee,
	0x9b0b, 0x9b28, 0x9b45, 0x9b62, 0x9b7e, 0x9b9a, 0x9bb8, 0x9bd5,
	0x9bf2, 0x9c10, 0x9c2e, 0x9c4b, 0x9c69, 0x9c87, 0x9ca5, 0x9cc4,
	0x9ce1, 0x9cfe, 0x9d1b, 0x9d38, 0x9d55, 0x9d74, 0x9d93, 0x9db2,
	0x9dd0, 0x9def, 0x9e0d, 0x9e2c, 0x9e49, 0x9e63, 0x9e7e, 0x9e99,
	0x9eb4, 0x9ecf, 0x9eea, 0x9f05, 0x9f1f, 0x9f39, 0x9f55, 0x9f70,
	0x9f8b, 0x9fa7, 0x9fc3, 0x9fde, 0x9ffa, 0xa016, 0xa032, 0xa04f,
	0xa06a, 0xa085, 0xa0a0, 0xa0bb, 0xa0d6, 0xa0f3, 0xa110, 0xa12d,
	// Entry 4E00 - 4E3F
	0xa149, 0xa166, 0xa182, 0xa19f, 0xa1b5, 0xa1ca, 0xa1df, 0xa1f6,
	0xa20c, 0xa222, 0xa237, 0xa24e, 0xa265, 0xa27b, 0xa291, 0xa2aa,
	0xa2c3, 0xa2db, 0xa2f3, 0xa30b, 0xa325, 0xa33e, 0xa357, 0xa365,
	0xa37a, 0xa38f, 0xa3a4, 0xa3b9, 0xa3ce, 0xa3e3, 0xa3f8, 0xa40e,
	0xa423, 0xa438, 0xa44e, 0xa463, 0xa478, 0xa48d, 0xa4a2, 0xa4b8,
	0xa4cd, 0xa4e3, 0xa4f8, 0xa50d, 0xa523, 0xa537, 0xa54b, 0xa55f,
	0xa573, 0xa587, 0xa59c, 0xa5b1, 0xa5cb, 0xa5e5, 0xa5ff, 0xa619,
	0xa633, 0xa64d, 0xa667, 0xa682, 0xa69c, 0xa6b8, 0xa6cf, 0xa6ee,
	// Entry 4E40 - 4E7F
	0xa710, 0xa72d, 0xa752, 0xa76e, 0xa785, 0xa7a7, 0xa7c4, 0xa7de,
	0xa7fe, 0xa823, 0xa843, 0xa864, 0xa880, 0xa898, 0xa8bf, 0xa8e1,
	0xa8ff, 0xa911, 0xa924, 0xa936, 0xa949, 0xa95b, 0xa96e, 0xa988,
	0xa9a3, 0xa9bd, 0xa9cf, 0xa9e2, 0xa9f4, 0xaa07, 0xaa1a, 0xaa2e,
	0xaa41, 0xaa55, 0xaa69, 0xaa7c, 0xaa90, 0xaaa3, 0xaab7, 0xaacb,
	0xaadf, 0xaaf4, 0xab08, 0xab1d, 0xab31, 0xab44, 0xab58, 0xab6b,
	0xab7f, 0xab92, 0xaba5, 0xabb9, 0xabcc, 0xabe0, 0xabf3, 0xac06,
	0xac19, 0xac2c, 0xac3f, 0xac53, 0xac67, 0xac7a, 0xac8d, 0xaca4,
	// Entry 4E80 - 4EBF
	0xacba, 0xacd1, 0xace7, 0xacfe, 0xad1c, 0xad3b, 0xad59, 0xad6f,
	0xad86, 0xad9c, 0xadb3, 0xadcd, 0xade4, 0xadfa, 0xae0f, 0xae26,
	0xae35, 0xae4b, 0xae63, 0xae79, 0xae8f, 0xaea3, 0xaeb6, 0xaec9,
	0xaede, 0xaef2, 0xaf06, 0xaf19, 0xaf2e, 0xaf43, 0xaf57, 0xaf6b,
	0xaf7f, 0xaf95, 0xafaa, 0xafbf, 0xafd3, 0xafe9, 0xafff, 0xb014,
	0xb028, 0xb03f, 0xb056, 0xb06c, 0xb082, 0xb098, 0xb0b0, 0xb0c7,
	0xb0de, 0xb0fa, 0xb10b, 0xb11c, 0xb12d, 0xb13f, 0xb150, 0xb162,
	0xb173, 0xb185, 0xb196, 0xb1a8, 0xb1b9, 0xb1cb, 0xb1dc, 0xb1ed,
	// Entry 4EC0 - 4EFF
	0xb1fe, 0xb210, 0xb221, 0xb232, 0xb244, 0xb257, 0xb269, 0xb27a,
	0xb28c, 0xb29d, 0xb2ae, 0xb2bf, 0xb2d0, 0xb2e1, 0xb2f3, 0xb304,
	0xb315, 0xb325, 0xb340, 0xb35c, 0xb377, 0xb393, 0xb3ae, 0xb3ca,
	0xb3e5, 0xb401, 0xb41c, 0xb438, 0xb453, 0xb46e, 0xb489, 0xb4a5,
	0xb4c0, 0xb4db, 0xb4f7, 0xb514, 0xb530, 0xb54b, 0xb567, 0xb582,
	0xb59d, 0xb5b8, 0xb5d3, 0xb5ef, 0xb60a, 0xb625, 0xb63f, 0xb654,
	0xb668, 0xb67c, 0xb690, 0xb6a4, 0xb6b9, 0xb6d1, 0xb6e1, 0xb6f9,
	0xb713, 0xb733, 0xb74c, 0xb766, 0xb787, 0xb7a2, 0xb7bc, 0xb7cd,
	// Entry 4F00 - 4F3F
	0xb7de, 0xb7fa, 0xb81b, 0xb836, 0xb857, 0xb871, 0xb891, 0xb8ad,
	0xb8ca, 0xb8e7, 0xb90e, 0xb924, 0xb936, 0xb954, 0xb976, 0xb999,
	0xb9b6, 0xb9d3, 0xb9e4, 0xb9f5, 0xba12, 0xba39, 0xba4a, 0xba64,
	0xba80, 0xba9c, 0xbab6, 0xbad2, 0xbaec, 0xbb07, 0xbb22, 0xbb35,
	0xbb49, 0xbb5c, 0xbb79, 0xbb8a, 0xbba3, 0xbbc0, 0xbbf1, 0xbc14,
	0xbc28, 0xbc3b, 0xbc4e, 0xbc6b, 0xbc7f, 0xbc93, 0xbca5, 0xbcc1,
	0xbcdd, 0xbd1a, 0xbd3e, 0xbd81, 0xbd94, 0xbda9, 0xbdba, 0xbdcc,
	0xbddf, 0xbdf4, 0xbe06, 0xbe21, 0xbe35, 0xbe47, 0xbe5b, 0xbe6c,
	// Entry 4F40 - 4F7F
	0xbe85, 0xbea0, 0xbec0, 0xbed1, 0xbeed, 0xbf09, 0xbf26, 0xbf3a,
	0xbf59, 0xbf6b, 0xbf7e, 0xbf8f, 0xbfa1, 0xbfcc, 0xbff0, 0xc015,
	0xc037, 0xc059, 0xc085, 0xc0a7, 0xc0cb, 0xc0ee, 0xc110, 0xc132,
	0xc15c, 0xc17f, 0xc1a1, 0xc1c3, 0xc1f0, 0xc213, 0xc235, 0xc261,
	0xc283, 0xc2a7, 0xc2d3, 0xc2f6, 0xc308, 0xc31a, 0xc32e, 0xc342,
	0xc353, 0xc365, 0xc377, 0xc393, 0xc3a6, 0xc3b8, 0xc3dd, 0xc3f0,
	0xc401, 0xc41a, 0xc430, 0xc449, 0xc45b, 0xc478, 0xc48b, 0xc49d,
	0xc4b1, 0xc4c3, 0xc4d5, 0xc4e8, 0xc500, 0xc51d, 0xc530, 0xc543,
	// Entry 4F80 - 4FBF
	0xc553, 0xc56d, 0xc591, 0xc5a2, 0xc5cb, 0xc5e6, 0xc600, 0xc61b,
	0xc636, 0xc64f, 0xc662, 0xc675, 0xc686, 0xc697, 0xc6b3, 0xc6d4,
	0xc6ee, 0xc70b, 0xc728, 0xc741, 0xc754, 0xc768, 0xc77b, 0xc78e,
	0xc7a9, 0xc7cd, 0xc7fb, 0xc817, 0xc834, 0xc857, 0xc87f, 0xc89b,
	0xc8bc, 0xc8de, 0xc8fe, 0xc926, 0xc943, 0xc95f, 0xc986, 0xc9a2,
	0xc9be, 0xc9da, 0xc9f6, 0xca07, 0xca1d, 0xca2f, 0xca59, 0xca7b,
	0xca9e, 0xcac8, 0xcae3, 0xcaff, 0xcb25, 0xcb41, 0xcb65, 0xcb81,
	0xcba5, 0xcbc0, 0xcbdb, 0xcc01, 0xcc1d, 0xcc38, 0xcc5b, 0xcc76,
	// Entry 4FC0 - 4FFF
	0xcca1, 0xccc3, 0xccdf, 0xccfa, 0xcd16, 0xcd39, 0xcd5e, 0xcd8b,
	0xcda7, 0xcdcb, 0xcdee, 0xce0b, 0xce2c, 0xce59, 0xce75, 0xce94,
	0xceb0, 0xced5, 0xcef9, 0xcf14, 0xcf37, 0xcf52, 0xcf6e, 0xcf93,
	0xcfae, 0xcfca, 0xcfe6, 0xd002, 0xd027, 0xd044, 0xd060, 0xd07d,
	0xd097, 0xd0b2, 0xd0d5, 0xd0f0, 0xd103, 0xd124, 0xd136, 0xd15e,
	0xd170, 0xd19c, 0xd1b0, 0xd1c2, 0xd1d4, 0xd1e7, 0xd1ff, 0xd21c,
	0xd23d, 0xd24f, 0xd262, 0xd277, 0xd28d, 0xd2ad, 0xd2be, 0xd2d7,
	0xd2f0, 0xd30d, 0xd31f, 0xd33a, 0xd359, 0xd36d, 0xd380, 0xd398,
	// Entry 5000 - 503F
	0xd3ab, 0xd3cf, 0xd3f2, 0xd40f, 0xd434, 0xd450, 0xd464, 0xd477,
	0xd498, 0xd4b5, 0xd4d3, 0xd4eb, 0xd4fc, 0xd519, 0xd52b, 0xd547,
	0xd572, 0xd58e, 0xd5b4, 0xd5cb, 0xd5dd, 0xd600, 0xd61c, 0xd63d,
	0xd64f, 0xd661, 0xd67d, 0xd68f, 0xd6a2, 0xd6b6, 0xd6cb, 0xd6dc,
	0xd6f2, 0xd708, 0xd71a, 0xd72b, 0xd746, 0xd762, 0xd77d, 0xd799,
	0xd7b4, 0xd7cf, 0xd7ea, 0xd805, 0xd81e, 0xd82f, 0xd842, 0xd85e,
	0xd87b, 0xd89b, 0xd8b9, 0xd8d5, 0xd8e8, 0xd8f8, 0xd90a, 0xd91b,
	0xd92e, 0xd94f, 0xd974, 0xd985, 0xd997, 0xd9ad, 0xd9c2, 0xd9f7,
	// Entry 5040 - 507F
	0xda0e, 0xda1f, 0xda40, 0xda52, 0xda63, 0xda7f, 0xda9c, 0xdab9,
	0xdad2, 0xdae5, 0xdaf6, 0xdb07, 0xdb19, 0xdb2a, 0xdb43, 0xdb5d,
	0xdb80, 0xdb9c, 0xdbb7, 0xdbd4, 0xdbef, 0xdc09, 0xdc26, 0xdc42,
	0xdc5c, 0xdc77, 0xdc98, 0xdcb3, 0xdcdf, 0xdcf9, 0xdd15, 0xdd3a,
	0xdd64, 0xdd7e, 0xdd9a, 0xddb5, 0xddcf, 0xddea, 0xde04, 0xde1f,
	0xde39, 0xde53, 0xde6d, 0xde8f, 0xdeb1, 0xded3, 0xdeed, 0xdf12,
	0xdf2c, 0xdf47, 0xdf61, 0xdf7b, 0xdf95, 0xdfb0, 0xdfcb, 0xdfe6,
	0xe002, 0xe01d, 0xe038, 0xe055, 0xe070, 0xe089, 0xe0a3, 0xe0bd,
	// Entry 5080 - 50BF
	0xe0e2, 0xe0fd, 0xe117, 0xe129, 0xe148, 0xe15a, 0xe16d, 0xe180,
	0xe193, 0xe1a6, 0xe1c3, 0xe1d5, 0xe1f6, 0xe208, 0xe224, 0xe243,
	0xe256, 0xe269, 0xe27e, 0xe2b4, 0xe2f6, 0xe30a, 0xe31b, 0xe336,
	0xe34f, 0xe369, 0xe37b, 0xe38d, 0xe3a1, 0xe3b4, 0xe3c9, 0xe3ea,
	0xe3fb, 0xe435, 0xe447, 0xe459, 0xe478, 0xe48a, 0xe49c, 0xe4b3,
	0xe4c5, 0xe4d7, 0xe4f6, 0xe50b, 0xe520, 0xe531, 0xe545, 0xe561,
	0xe58d, 0xe5b2, 0xe5d7, 0xe5f4, 0xe611, 0xe639, 0xe657, 0xe674,
	0xe692, 0xe6af, 0xe6cc, 0xe6ea, 0xe708, 0xe72f, 0xe74c, 0xe76a,
	// Entry 50C0 - 50FF
	0xe791, 0xe7b4, 0xe7d1, 0xe7f6, 0xe81b, 0xe838, 0xe856, 0xe874,
	0xe892, 0xe8bf, 0xe8df, 0xe8fe, 0xe91b, 0xe939, 0xe956, 0xe97b,
	0xe99a, 0xe9b7, 0xe9de, 0xea13, 0xea42, 0xea61, 0xea8a, 0xeaa8,
	0xeac6, 0xeae5, 0xeb19, 0xeb35, 0xeb58, 0xeb82, 0xeba8, 0xebc5,
	0xebe3, 0xebff, 0xec13, 0xec31, 0xec58, 0xec71, 0xec9e, 0xecb3,
	0xecc5, 0xece1, 0xecf3, 0xed0f, 0xed33, 0xed44, 0xed56, 0xed6b,
	0xed7e, 0xed8f, 0xedaa, 0xedbc, 0xedd7, 0xedf3, 0xee10, 0xee32,
	0xee54, 0xee79, 0xee94, 0xeeb1, 0xeece, 0xeef4, 0xef0f, 0xef33,
	// Entry 5100 - 513F
	0xef51, 0xef74, 0xef8f, 0xefaa, 0xefce, 0xeff3, 0xf010, 0xf027,
	0xf046, 0xf065, 0xf07f, 0xf099, 0xf0ab, 0xf0bf, 0xf0de, 0xf101,
	0xf11d, 0xf12f, 0xf141, 0xf153, 0xf16e, 0xf196, 0xf1a7, 0xf1c3,
	0xf1d9, 0xf1eb, 0xf1fd, 0xf20f, 0xf222, 0xf236, 0xf247, 0xf259,
	0xf26a, 0xf27c, 0xf28d, 0xf2a6, 0xf2b8, 0xf2cf, 0xf2e4, 0xf2f9,
	0xf30c, 0xf327, 0xf344, 0xf360, 0xf37d, 0xf3aa, 0xf3cb, 0xf3df,
	0xf3fb, 0xf41f, 0xf43c, 0xf455, 0xf466, 0xf478, 0xf48b, 0xf4a7,
	0xf4c9, 0xf4ea, 0xf4fe, 0xf518, 0xf52a, 0xf53d, 0xf54e, 0xf567,
	// Entry 5140 - 517F
	0xf581, 0xf59a, 0xf5ab, 0xf5c4, 0xf5d6, 0xf5e8, 0xf60a, 0xf635,
	0xf64a, 0xf668, 0xf687, 0xf6af, 0xf6ce, 0xf6fb, 0xf719, 0xf738,
	0xf757, 0xf780, 0xf7a8, 0xf7d9, 0xf800, 0xf81f, 0xf833, 0xf844,
	0xf857, 0xf869, 0xf88b, 0xf8ae, 0xf8d0, 0xf90b, 0xf92d, 0xf944,
	0xf95f, 0xf97e, 0xf9ae, 0xf9c2, 0xf9e7, 0xfa08, 0xfa2a, 0xfa4c,
	0xfa73, 0xfa96, 0xfab7, 0xfad8, 0xfafc, 0xfb1d, 0xfb41, 0xfb67,
	0xfb78, 0xfb8a, 0xfb9c, 0xfbae, 0xfbc2, 0xfbd3, 0xfbec, 0xfc06,
	0xfc20, 0xfc3a, 0xfc53, 0xfc6c, 0xfc86, 0xfc9f, 0xfcb9, 0xfcd6,
	// Entry 5180 - 51BF
	0xfcea, 0xfd08, 0xfd25, 0xfd42, 0xfd65, 0xfd76, 0xfd88, 0xfd99,
	0xfdaa, 0xfdbb, 0xfdd5, 0xfde7, 0xfe01, 0xfe1c, 0xfe38, 0xfe53,
	0xfe6f, 0xfe8b, 0xfea7, 0xfec2, 0xfede, 0xfefa, 0xff17, 0xff33,
	0xff4e, 0xff69, 0xff84, 0xff9f, 0xffbb, 0xffd6, 0xffed, 0xffff,
	0x0022, 0x0037, 0x0049, 0x005b, 0x006e, 0x0089, 0x00a6, 0x00c4,
	0x00e0, 0x00fe, 0x011b, 0x0136, 0x0158, 0x016b, 0x017f, 0x0193,
	0x01a5, 0x01ba, 0x01ef, 0x0224, 0x0238, 0x024b, 0x025f, 0x0274,
	0x028b, 0x029e, 0x02b9, 0x02d5, 0x02e8, 0x0303, 0x0320, 0x033f,
	// Entry 51C0 - 51FF
	0x035c, 0x0379, 0x0396, 0x03b8, 0x03d8, 0x03f5, 0x0412, 0x042f,
	0x0444, 0x0457, 0x046f, 0x0499, 0x04ad, 0x04bf, 0x04e3, 0x04f6,
	0x050b, 0x051c, 0x0532, 0x0544, 0x0557, 0x0579, 0x058c, 0x05a0,
	0x05b1, 0x05ca, 0x05dc, 0x05ef, 0x0603, 0x0615, 0x062a, 0x063c,
	0x064f, 0x0660, 0x067a, 0x0694, 0x06ae, 0x06c4, 0x06d6, 0x070b,
	0x0725, 0x0737, 0x0752, 0x076e, 0x078a, 0x07a6, 0x07c3, 0x07de,
	0x07f1, 0x0803, 0x0814, 0x082a, 0x083b, 0x0851, 0x0863, 0x0875,
	0x0892, 0x08ad, 0x08e2, 0x08f3, 0x0906, 0x0918, 0x092a, 0x093c,
	// Entry 5200 - 523F
	0x0962, 0x0972, 0x0986, 0x099a, 0x09c9, 0x09ed, 0x0a1f, 0x0a30,
	0x0a41, 0x0a52, 0x0a6a, 0x0a85, 0x0a9f, 0x0ac6, 0x0af2, 0x0b08,
	0x0b21, 0x0b44, 0x0b57, 0x0b68, 0x0b85, 0x0ba7, 0x0bc3, 0x0bdc,
	0x0bf0, 0x0c03, 0x0c23, 0x0c3f, 0x0c50, 0x0c66, 0x0c77, 0x0c94,
	0x0cad, 0x0cbf, 0x0ce1, 0x0d03, 0x0d1e, 0x0d39, 0x0d55, 0x0d70,
	0x0d94, 0x0db7, 0x0dc9, 0x0ddb, 0x0dee, 0x0e00, 0x0e1a, 0x0e39,
	0x0e55, 0x0e71, 0x0e8c, 0x0ea8, 0x0eca, 0x0ee6, 0x0f01, 0x0f1c,
	0x0f38, 0x0f53, 0x0f6f, 0x0f8a, 0x0fa6, 0x0fc2, 0x0fdd, 0x0ff9,
	// Entry 5240 - 527F
	0x1016, 0x1031, 0x1054, 0x106f, 0x108d, 0x10a1, 0x10bd, 0x10cf,
	0x10e9, 0x1104, 0x1120, 0x113d, 0x1150, 0x1163, 0x1178, 0x118c,
	0x119e, 0x11bd, 0x11cf, 0x11e0, 0x11f6, 0x1219, 0x122b, 0x123e,
	0x1250, 0x1261, 0x127a, 0x128c, 0x129e, 0x12ba, 0x12cc, 0x12df,
	0x12f0, 0x1302, 0x131c, 0x1330, 0x1342, 0x135c, 0x1377, 0x1391,
	0x13ae, 0x13da, 0x13ed, 0x1409, 0x1425, 0x1442, 0x145f, 0x148a,
	0x14a7, 0x14ba, 0x14cc, 0x14df, 0x14fc, 0x1518, 0x1534, 0x154f,
	0x1574, 0x158f, 0x15a9, 0x15c5, 0x15df, 0x15fa, 0x1617, 0x163b,
	// Entry 5280 - 52BF
	0x1661, 0x167d, 0x1690, 0x16ad, 0x16bf, 0x16d1, 0x16e4, 0x1703,
	0x1721, 0x174b, 0x1768, 0x177b, 0x179c, 0x17ae, 0x17c8, 0x17da,
	0x17f8, 0x1818, 0x1837, 0x1856, 0x1874, 0x1894, 0x18b4, 0x18d3,
	0x18f4, 0x1914, 0x1934, 0x1953, 0x1974, 0x1995, 0x19b5, 0x19d2,
	0x19ef, 0x1a0b, 0x1a29, 0x1a47, 0x1a64, 0x1a84, 0x1aa4, 0x1ac6,
	0x1ae7, 0x1b08, 0x1b28, 0x1b4a, 0x1b6c, 0x1b8d, 0x1bad, 0x1bcd,
	0x1bef, 0x1c10, 0x1c31, 0x1c51, 0x1c73, 0x1ca2, 0x1cc3, 0x1ce4,
	0x1d04, 0x1d26, 0x1d48, 0x1d69, 0x1d89, 0x1da9, 0x1dcb, 0x1dfa,
	// Entry 52C0 - 52FF
	0x1e1b, 0x1e3c, 0x1e6c, 0x1e9b, 0x1eba, 0x1ed9, 0x1efa, 0x1f28,
	0x1f48, 0x1f68, 0x1f97, 0x1fc6, 0x1ff4, 0x2023, 0x2053, 0x2083,
	0x20af, 0x20de, 0x210e, 0x213e, 0x216c, 0x219b, 0x21ca, 0x21fa,
	0x222a, 0x225b, 0x227e, 0x22a3, 0x22c7, 0x22eb, 0x230e, 0x232d,
	0x234c, 0x236d, 0x238d, 0x23ba, 0x23da, 0x2407, 0x2427, 0x2447,
	0x2467, 0x2487, 0x24ac, 0x24d2, 0x24f9, 0x2528, 0x2558, 0x257d,
	0x25a3, 0x25d0, 0x25ff, 0x2625, 0x2648, 0x2670, 0x2699, 0x26bd,
	0x26e1, 0x270b, 0x2735, 0x275e, 0x2789, 0x27b4, 0x27de, 0x2812,
	// Entry 5300 - 533F
	0x283b, 0x2864, 0x2890, 0x28bd, 0x28dd, 0x28f9, 0x2915, 0x2937,
	0x2956, 0x2974, 0x2992, 0x29b5, 0x29d1, 0x29ed, 0x2a09, 0x2a27,
	0x2a43, 0x2a61, 0x2a7d, 0x2aa1, 0x2abd, 0x2ad9, 0x2af7, 0x2b12,
	0x2b2d, 0x2b4f, 0x2b6c, 0x2b87, 0x2ba2, 0x2bc3, 0x2be2, 0x2bfe,
	0x2c1d, 0x2c48, 0x2c68, 0x2c84, 0x2caa, 0x2cd0, 0x2ced, 0x2d09,
	0x2d24, 0x2d3f, 0x2d5a, 0x2d76, 0x2d96, 0x2db1, 0x2dcc, 0x2de2,
	0x2e03, 0x2e28, 0x2e4c, 0x2e76, 0x2e9a, 0x2ebf, 0x2ee3, 0x2f08,
	0x2f2c, 0x2f48, 0x2f67, 0x2f88, 0x2fb3, 0x2fdc, 0x2ff9, 0x3014,
	// Entry 5340 - 537F
	0x3038, 0x305c, 0x307e, 0x30a9, 0x30c5, 0x30eb, 0x3107, 0x3124,
	0x313f, 0x3162, 0x3185, 0x31a2, 0x31bf, 0x31e9, 0x3207, 0x3233,
	0x3254, 0x327b, 0x3296, 0x32c3, 0x32dd, 0x32f7, 0x3314, 0x332e,
	0x3353, 0x3369, 0x337f, 0x3395, 0x33ab, 0x33c1, 0x33d7, 0x33ed,
	0x3415, 0x342b, 0x344e, 0x3464, 0x347a, 0x3490, 0x34a6, 0x34bc,
	0x34d2, 0x34e8, 0x34fe, 0x3514, 0x352a, 0x3540, 0x3556, 0x356c,
	0x3582, 0x3598, 0x35ae, 0x35c4, 0x35da, 0x35f0, 0x360f, 0x362f,
	0x3658, 0x368a, 0x36b1, 0x36c7, 0x36dd, 0x36f3, 0x3709, 0x371f,
	// Entry 5380 - 53BF
	0x3735, 0x374b, 0x3761, 0x3777, 0x378d, 0x37a3, 0x37c3, 0x37e3,
	0x380e, 0x382e, 0x384d, 0x386d, 0x388c, 0x38ab, 0x38ca, 0x38ec,
	0x3902, 0x3918, 0x3938, 0x3957, 0x3977, 0x399c, 0x39bb, 0x39ed,
	0x3a17, 0x3a36, 0x3a58, 0x3a6e, 0x3a84, 0x3aa5, 0x3ac2, 0x3ade,
	0x3afa, 0x3b28, 0x3b45, 0x3b5f, 0x3b85, 0x3bac, 0x3bd0, 0x3bf0,
	0x3c0f, 0x3c2d, 0x3c4e, 0x3c71, 0x3c91, 0x3cb9, 0x3cd6, 0x3cfa,
	0x3d1b, 0x3d3b, 0x3d56, 0x3d7a, 0x3d97, 0x3daf, 0x3dca, 0x3de6,
	0x3e02, 0x3e1d, 0x3e42, 0x3e66, 0x3e82, 0x3e9e, 0x3ec0, 0x3ee3,
	// Entry 53C0 - 53FF
	0x3efe, 0x3f19, 0x3f37, 0x3f57, 0x3f73, 0x3f85, 0x3fa7, 0x3fcf,
	0x3fe7, 0x3fff, 0x4017, 0x402f, 0x4047, 0x4060, 0x4078, 0x4091,
	0x40aa, 0x40c2, 0x40da, 0x40f2, 0x410a, 0x4122, 0x413a, 0x4152,
	0x416a, 0x4183, 0x419b, 0x41b3, 0x41cb, 0x41e4, 0x41fc, 0x4214,
	0x422c, 0x4244, 0x425c, 0x4274, 0x428c, 0x42a4, 0x42bc, 0x42d4,
	0x42ec, 0x4304, 0x431c, 0x4334, 0x434c, 0x4365, 0x437d, 0x4395,
	0x43ad, 0x43c5, 0x43dd, 0x43f5, 0x440d, 0x4425, 0x443e, 0x4456,
	0x446e, 0x4487, 0x449f, 0x44b8, 0x44d0, 0x44e8, 0x4501, 0x4519,
	// Entry 5400 - 543F
	0x4531, 0x4549, 0x4561, 0x4579, 0x4591, 0x45a9, 0x45c1, 0x45d9,
	0x45f1, 0x4609, 0x4621, 0x4639, 0x4651, 0x4669, 0x4681, 0x4699,
	0x46b1, 0x46c9, 0x46e1, 0x46f9, 0x4711, 0x4729, 0x4741, 0x4759,
	0x4771, 0x4789, 0x47a1, 0x47b9, 0x47d1, 0x47ea, 0x4802, 0x481a,
	0x4832, 0x484a, 0x4862, 0x487a, 0x4893, 0x48ac, 0x48c5, 0x48dd,
	0x48f5, 0x490d, 0x4925, 0x493d, 0x4955, 0x496d, 0x4985, 0x499e,
	0x49b6, 0x49ce, 0x49e6, 0x49fe, 0x4a16, 0x4a2e, 0x4a46, 0x4a5e,
	0x4a76, 0x4a8e, 0x4aa6, 0x4abe, 0x4ad6, 0x4aee, 0x4b06, 0x4b1e,
	// Entry 5440 - 547F
	0x4b36, 0x4b4e, 0x4b66, 0x4b7e, 0x4b96, 0x4bae, 0x4bc7, 0x4bdf,
	0x4bf7, 0x4c0f, 0x4c27, 0x4c3f, 0x4c57, 0x4c6f, 0x4c87, 0x4c9f,
	0x4cb7, 0x4ccf, 0x4ce7, 0x4cff, 0x4d17, 0x4d2f, 0x4d47, 0x4d5f,
	0x4d77, 0x4d8f, 0x4da8, 0x4dc0, 0x4dd8, 0x4df0, 0x4e08, 0x4e21,
	0x4e39, 0x4e51, 0x4e69, 0x4e82, 0x4e9a, 0x4eb2, 0x4eca, 0x4ee2,
	0x4efa, 0x4f12, 0x4f2a, 0x4f42, 0x4f5a, 0x4f72, 0x4f8a, 0x4fa2,
	0x4fbb, 0x4fd3, 0x4feb, 0x5004, 0x501c, 0x5034, 0x504d, 0x5066,
	0x507f, 0x5098, 0x50b1, 0x50ca, 0x50e3, 0x50fc, 0x5115, 0x512d,
	// Entry 5480 - 54BF
	0x5145, 0x515e, 0x5176, 0x518e, 0x51a7, 0x51bf, 0x51d7, 0x51ef,
	0x5207, 0x521f, 0x5237, 0x524f, 0x5267, 0x527f, 0x5297, 0x52af,
	0x52c7, 0x52df, 0x52f8, 0x5311, 0x532a, 0x5343, 0x535c, 0x5375,
	0x538e, 0x53a7, 0x53bf, 0x53d7, 0x53ef, 0x5407, 0x541f, 0x5437,
	0x544f, 0x5467, 0x5480, 0x5498, 0x54b1, 0x54c9, 0x54e1, 0x54f9,
	0x5511, 0x5529, 0x5541, 0x5559, 0x5572, 0x558a, 0x55a3, 0x55bb,
	0x55d3, 0x55eb, 0x5604, 0x561c, 0x5634, 0x564c, 0x5664, 0x567c,
	0x5694, 0x56ac, 0x56c4, 0x56dd, 0x56f5, 0x570d, 0x5725, 0x573d,
	// Entry 54C0 - 54FF
	0x5755, 0x576d, 0x5786, 0x579e, 0x57b6, 0x57ce, 0x57e6, 0x57ff,
	0x5817, 0x582f, 0x5847, 0x585f, 0x5877, 0x588f, 0x58a7, 0x58bf,
	0x58d7, 0x58ef, 0x5907, 0x591f, 0x5938, 0x5950, 0x5968, 0x5980,
	0x5998, 0x59b0, 0x59c8, 0x59e0, 0x59f8, 0x5a11, 0x5a29, 0x5a41,
	0x5a59, 0x5a71, 0x5a89, 0x5aa1, 0x5ab9, 0x5ad1, 0x5ae9, 0x5b01,
	0x5b1a, 0x5b32, 0x5b4a, 0x5b62, 0x5b7a, 0x5b92, 0x5baa, 0x5bc3,
	0x5bdb, 0x5bf4, 0x5c0c, 0x5c24, 0x5c3c, 0x5c54, 0x5c6c, 0x5c84,
	0x5c9c, 0x5cb5, 0x5ccd, 0x5ce6, 0x5cfe, 0x5d17, 0x5d2f, 0x5d47,
	// Entry 5500 - 553F
	0x5d5f, 0x5d77, 0x5d90, 0x5da9, 0x5dc2, 0x5dda, 0x5df2, 0x5e0a,
	0x5e22, 0x5e3a, 0x5e52, 0x5e6a, 0x5e82, 0x5e9b, 0x5eb3, 0x5ecc,
	0x5ee5, 0x5efd, 0x5f15, 0x5f2d, 0x5f45, 0x5f5e, 0x5f76, 0x5f8e,
	0x5fa6, 0x5fbe, 0x5fd6, 0x5fee, 0x6006, 0x601e, 0x6036, 0x604f,
	0x6067, 0x607f, 0x6097, 0x60af, 0x60c7, 0x60df, 0x60f8, 0x6110,
	0x6128, 0x6140, 0x6158, 0x6170, 0x6188, 0x61a0, 0x61b8, 0x61d0,
	0x61e8, 0x6201, 0x6219, 0x6232, 0x624a, 0x6262, 0x627a, 0x6292,
	0x62aa, 0x62c2, 0x62db, 0x62f3, 0x630b, 0x6324, 0x633c, 0x6354,
	// Entry 5540 - 557F
	0x636c, 0x6384, 0x639c, 0x63b4, 0x63cc, 0x63e4, 0x63fc, 0x6414,
	0x642c, 0x6444, 0x645c, 0x6474, 0x648c, 0x64a5, 0x64bd, 0x64d5,
	0x64ed, 0x6505, 0x651d, 0x6535, 0x654d, 0x6566, 0x657e, 0x6596,
	0x65ae, 0x65c6, 0x65df, 0x65f7, 0x6610, 0x6628, 0x6641, 0x6659,
	0x6671, 0x6689, 0x66a1, 0x66b9, 0x66d1, 0x66e9, 0x6701, 0x6719,
	0x6731, 0x6749, 0x6761, 0x6779, 0x6791, 0x67aa, 0x67c2, 0x67da,
	0x67f2, 0x680a, 0x6823, 0x683b, 0x6853, 0x686b, 0x6884, 0x689d,
	0x68b5, 0x68cd, 0x68e6, 0x68fe, 0x6916, 0x692e, 0x6946, 0x695e,
	// Entry 5580 - 55BF
	0x6976, 0x698e, 0x69a7, 0x69bf, 0x69d7, 0x69f0, 0x6a09, 0x6a22,
	0x6a3b, 0x6a54, 0x6a6d, 0x6a86, 0x6a9f, 0x6ab7, 0x6acf, 0x6ae7,
	0x6b00, 0x6b18, 0x6b31, 0x6b49, 0x6b62, 0x6b7a, 0x6b92, 0x6baa,
	0x6bc2, 0x6bda, 0x6bf3, 0x6c0b, 0x6c23, 0x6c3c, 0x6c54, 0x6c6c,
	0x6c84, 0x6c9c, 0x6cb5, 0x6ccd, 0x6ce5, 0x6cfd, 0x6d16, 0x6d2e,
	0x6d46, 0x6d5f, 0x6d78, 0x6d90, 0x6da8, 0x6dc0, 0x6dd8, 0x6df0,
	0x6e08, 0x6e20, 0x6e39, 0x6e51, 0x6e69, 0x6e81, 0x6e99, 0x6eb1,
	0x6ec9, 0x6ee1, 0x6ef9, 0x6f11, 0x6f29, 0x6f41, 0x6f59, 0x6f71,
	// Entry 55C0 - 55FF
	0x6f89, 0x6fa1, 0x6fb9, 0x6fd1, 0x6fe9, 0x7001, 0x7019, 0x7031,
	0x7049, 0x7062, 0x707b, 0x7093, 0x70ab, 0x70c3, 0x70db, 0x70f3,
	0x710b, 0x7123, 0x713c, 0x7154, 0x716c, 0x7184, 0x719c, 0x71b4,
	0x71cc, 0x71e4, 0x71fc, 0x7215, 0x722d, 0x7246, 0x725e, 0x7277,
	0x728f, 0x72a7, 0x72c0, 0x72d8, 0x72f0, 0x7308, 0x7320, 0x7338,
	0x7351, 0x736a, 0x7383, 0x739c, 0x73b5, 0x73cf, 0x73e8, 0x7401,
	0x741a, 0x7433, 0x744c, 0x7465, 0x747e, 0x7497, 0x74b0, 0x74c9,
	0x74e2, 0x74fb, 0x7515, 0x752e, 0x7547, 0x7560, 0x7579, 0x7592,
	// Entry 5600 - 563F
	0x75ab, 0x75c4, 0x75dd, 0x75f6, 0x760f, 0x7628, 0x7641, 0x765a,
	0x7674, 0x768d, 0x76a7, 0x76c0, 0x76d9, 0x76f2, 0x770b, 0x7724,
	0x773d, 0x7756, 0x7770, 0x7789, 0x77a2, 0x77bb, 0x77d4, 0x77ee,
	0x7806, 0x781f, 0x7837, 0x784f, 0x7867, 0x787f, 0x7898, 0x78b0,
	0x78c9, 0x78e2, 0x78fb, 0x7914, 0x792d, 0x7946, 0x795e, 0x7976,
	0x798e, 0x79a6, 0x79bf, 0x79d8, 0x79f1, 0x7a09, 0x7a21, 0x7a39,
	0x7a51, 0x7a69, 0x7a81, 0x7a99, 0x7ab1, 0x7ac9, 0x7ae2, 0x7afa,
	0x7b13, 0x7b2b, 0x7b43, 0x7b5b, 0x7b73, 0x7b8c, 0x7ba4, 0x7bbd,
	// Entry 5640 - 567F
	0x7bd5, 0x7bed, 0x7c05, 0x7c1d, 0x7c36, 0x7c4e, 0x7c67, 0x7c7f,
	0x7c97, 0x7caf, 0x7cc8, 0x7ce0, 0x7cf8, 0x7d10, 0x7d29, 0x7d42,
	0x7d5b, 0x7d74, 0x7d8c, 0x7da4, 0x7dbc, 0x7dd4, 0x7dec, 0x7e04,
	0x7e1c, 0x7e34, 0x7e4c, 0x7e64, 0x7e7c, 0x7e94, 0x7eac, 0x7ec4,
	0x7edd, 0x7ef6, 0x7f0e, 0x7f26, 0x7f3f, 0x7f57, 0x7f6f, 0x7f88,
	0x7fa0, 0x7fb8, 0x7fd0, 0x7fe8, 0x8000, 0x8018, 0x8030, 0x8048,
	0x8060, 0x8078, 0x8090, 0x80a8, 0x80c0, 0x80d8, 0x80f0, 0x8108,
	0x8120, 0x8139, 0x8151, 0x816a, 0x8183, 0x819b, 0x81b3, 0x81cb,
	// Entry 5680 - 56BF
	0x81e3, 0x81fb, 0x8213, 0x822b, 0x8244, 0x825c, 0x8274, 0x828c,
	0x82a4, 0x82bc, 0x82d4, 0x82ed, 0x8305, 0x831d, 0x8335, 0x834d,
	0x8365, 0x837d, 0x8395, 0x83ad, 0x83c5, 0x83dd, 0x83f5, 0x840d,
	0x8425, 0x843d, 0x8455, 0x846e, 0x8486, 0x849e, 0x84b6, 0x84ce,
	0x84e7, 0x84ff, 0x8517, 0x852f, 0x8547, 0x855f, 0x8577, 0x858f,
	0x85a7, 0x85c0, 0x85d9, 0x85f1, 0x8609, 0x8621, 0x863a, 0x8652,
	0x866a, 0x8682, 0x869a, 0x86b2, 0x86ca, 0x86e2, 0x86fa, 0x8712,
	0x872b, 0x8744, 0x875c, 0x8774, 0x878c, 0x87a4, 0x87bc, 0x87d4,
	// Entry 56C0 - 56FF
	0x87ec, 0x8804, 0x881c, 0x8835, 0x884d, 0x8865, 0x887d, 0x8895,
	0x88ad, 0x88c5, 0x88dd, 0x88f5, 0x890d, 0x8925, 0x893d, 0x8955,
	0x896d, 0x8985, 0x899e, 0x89b6, 0x89ce, 0x89e6, 0x89fe, 0x8a17,
	0x8a2f, 0x8a48, 0x8a60, 0x8a79, 0x8a91, 0x8aa9, 0x8ac2, 0x8ada,
	0x8af2, 0x8b0a, 0x8b22, 0x8b3a, 0x8b53, 0x8b6b, 0x8b83, 0x8b9b,
	0x8bb3, 0x8bcb, 0x8be3, 0x8bfb, 0x8c13, 0x8c2b, 0x8c43, 0x8c5b,
	0x8c73, 0x8c8b, 0x8ca3, 0x8cbb, 0x8cd3, 0x8cec, 0x8d04, 0x8d1d,
	0x8d35, 0x8d4d, 0x8d65, 0x8d7d, 0x8d95, 0x8dad, 0x8dc5, 0x8ddd,
	// Entry 5700 - 573F
	0x8df5, 0x8e0e, 0x8e27, 0x8e3f, 0x8e57, 0x8e6f, 0x8e87, 0x8e9f,
	0x8eb7, 0x8ecf, 0x8ee7, 0x8eff, 0x8f17, 0x8f2f, 0x8f47, 0x8f5f,
	0x8f77, 0x8f8f, 0x8fa7, 0x8fbf, 0x8fd8, 0x8ff0, 0x9008, 0x9020,
	0x9038, 0x9050, 0x9068, 0x9081, 0x9099, 0x90b1, 0x90c9, 0x90e2,
	0x90fa, 0x9112, 0x912a, 0x9142, 0x915a, 0x9172, 0x918a, 0x91a2,
	0x91ba, 0x91d2, 0x91ea, 0x9203, 0x921c, 0x9235, 0x924e, 0x9267,
	0x9280, 0x9299, 0x92b2, 0x92cb, 0x92e3, 0x92fc, 0x9314, 0x932c,
	0x9344, 0x935c, 0x9374, 0x938d, 0x93a6, 0x93be, 0x93d6, 0x93ee,
	// Entry 5740 - 577F
	0x9406, 0x941f, 0x9438, 0x9451, 0x9469, 0x9482, 0x949b, 0x94b3,
	0x94cb, 0x94e3, 0x94fb, 0x9513, 0x952b, 0x9543, 0x955b, 0x9574,
	0x958d, 0x95a6, 0x95bf, 0x95d8, 0x95f1, 0x960a, 0x9623, 0x963c,
	0x9655, 0x966e, 0x9687, 0x969f, 0x96b7, 0x96cf, 0x96e8, 0x9700,
	0x9718, 0x9730, 0x9748, 0x9760, 0x9779, 0x9791, 0x97aa, 0x97c2,
	0x97db, 0x97f3, 0x980c, 0x9824, 0x983c, 0x9855, 0x986d, 0x9885,
	0x989d, 0x98b5, 0x98ce, 0x98e6, 0x98fe, 0x9916, 0x992f, 0x9947,
	0x995f, 0x9977, 0x9990, 0x99a8, 0x99c0, 0x99d8, 0x99f0, 0x9a08,
	// Entry 5780 - 57BF
	0x9a20, 0x9a39, 0x9a51, 0x9a6a, 0x9a82, 0x9a9a, 0x9ab2, 0x9aca,
	0x9ae3, 0x9afb, 0x9b13, 0x9b2b, 0x9b44, 0x9b5c, 0x9b75, 0x9b8d,
	0x9ba5, 0x9bbd, 0x9bd5, 0x9bed, 0x9c05, 0x9c1e, 0x9c36, 0x9c4e,
	0x9c66, 0x9c7e, 0x9c96, 0x9caf, 0x9cc8, 0x9ce0, 0x9cf8, 0x9d11,
	0x9d29, 0x9d41, 0x9d5a, 0x9d72, 0x9d8b, 0x9da3, 0x9dbb, 0x9dd3,
	0x9deb, 0x9e03, 0x9e1b, 0x9e33, 0x9e4b, 0x9e63, 0x9e7c, 0x9e95,
	0x9eae, 0x9ec7, 0x9edf, 0x9ef8, 0x9f11, 0x9f29, 0x9f42, 0x9f5a,
	0x9f73, 0x9f8b, 0x9fa3, 0x9fbb, 0x9fd3, 0x9feb, 0xa003, 0xa01b,
	// Entry 57C0 - 57FF
	0xa033, 0xa04b, 0xa063, 0xa07c, 0xa095, 0xa0ae, 0xa0c7, 0xa0e0,
	0xa0f9, 0xa112, 0xa12b, 0xa144, 0xa15c, 0xa175, 0xa18e, 0xa1a7,
	0xa1c0, 0xa1d9, 0xa1f2, 0xa20b, 0xa224, 0xa23d, 0xa256, 0xa26f,
	0xa288, 0xa2a1, 0xa2ba, 0xa2d3, 0xa2ed, 0xa307, 0xa320, 0xa339,
	0xa352, 0xa36b, 0xa384, 0xa39d, 0xa3b6, 0xa3cf, 0xa3e8, 0xa401,
	0xa41a, 0xa433, 0xa44c, 0xa465, 0xa47e, 0xa497, 0xa4b0, 0xa4c9,
	0xa4e2, 0xa4fb, 0xa514, 0xa52d, 0xa546, 0xa55f, 0xa578, 0xa591,
	0xa5aa, 0xa5c3, 0xa5dc, 0xa5f5, 0xa60e, 0xa627, 0xa640, 0xa659,
	// Entry 5800 - 583F
	0xa672, 0xa68c, 0xa6a5, 0xa6be, 0xa6d7, 0xa6f0, 0xa709, 0xa722,
	0xa73b, 0xa754, 0xa76d, 0xa786, 0xa79f, 0xa7b8, 0xa7d1, 0xa7ea,
	0xa803, 0xa81c, 0xa836, 0xa84f, 0xa868, 0xa881, 0xa89a, 0xa8b3,
	0xa8cc, 0xa8e5, 0xa8fe, 0xa917, 0xa930, 0xa949, 0xa962, 0xa97b,
	0xa995, 0xa9ae, 0xa9c7, 0xa9e1, 0xa9fa, 0xaa13, 0xaa2c, 0xaa45,
	0xaa5f, 0xaa78, 0xaa92, 0xaaac, 0xaac5, 0xaade, 0xaaf7, 0xab10,
	0xab29, 0xab42, 0xab5b, 0xab74, 0xab8d, 0xaba6, 0xabbf, 0xabd8,
	0xabf1, 0xac0a, 0xac23, 0xac3c, 0xac55, 0xac6e, 0xac87, 0xaca0,
	// Entry 5840 - 587F
	0xacba, 0xacd4, 0xacee, 0xad07, 0xad20, 0xad39, 0xad52, 0xad6b,
	0xad84, 0xad9d, 0xadb6, 0xadcf, 0xade8, 0xae01, 0xae1a, 0xae33,
	0xae4c, 0xae65, 0xae7e, 0xae97, 0xaeb0, 0xaec9, 0xaee2, 0xaefb,
	0xaf14, 0xaf2d, 0xaf46, 0xaf5f, 0xaf78, 0xaf91, 0xafaa, 0xafc3,
	0xafdc, 0xaff5, 0xb00f, 0xb028, 0xb042, 0xb05b, 0xb074, 0xb08e,
	0xb0a7, 0xb0c1, 0xb0da, 0xb0f4, 0xb10d, 0xb126, 0xb140, 0xb15a,
	0xb174, 0xb18d, 0xb1a7, 0xb1c1, 0xb1da, 0xb1f3, 0xb20d, 0xb227,
	0xb241, 0xb25a, 0xb273, 0xb28c, 0xb2a6, 0xb2c0, 0xb2d9, 0xb2f2,
	// Entry 5880 - 58BF
	0xb30b, 0xb324, 0xb33d, 0xb357, 0xb370, 0xb389, 0xb3a2, 0xb3bb,
	0xb3d4, 0xb3ed, 0xb406, 0xb41f, 0xb438, 0xb451, 0xb46b, 0xb484,
	0xb49d, 0xb4b6, 0xb4cf, 0xb4e8, 0xb501, 0xb51a, 0xb533, 0xb54c,
	0xb565, 0xb57f, 0xb598, 0xb5b1, 0xb5ca, 0xb5e3, 0xb5fc, 0xb615,
	0xb62e, 0xb647, 0xb660, 0xb679, 0xb692, 0xb6ab, 0xb6c4, 0xb6dd,
	0xb6f6, 0xb70f, 0xb728, 0xb741, 0xb75a, 0xb773, 0xb78c, 0xb7a5,
	0xb7be, 0xb7d7, 0xb7f0, 0xb809, 0xb822, 0xb83b, 0xb854, 0xb86d,
	0xb886, 0xb89f, 0xb8b8, 0xb8d1, 0xb8ea, 0xb903, 0xb91c, 0xb935,
	// Entry 58C0 - 58FF
	0xb94e, 0xb967, 0xb980, 0xb999, 0xb9b2, 0xb9cb, 0xb9e4, 0xb9fd,
	0xba16, 0xba2f, 0xba48, 0xba61, 0xba7a, 0xba93, 0xbaac, 0xbac5,
	0xbade, 0xbaf7, 0xbb10, 0xbb29, 0xbb42, 0xbb5b, 0xbb74, 0xbb8d,
	0xbba6, 0xbbbf, 0xbbd8, 0xbbf1, 0xbc0a, 0xbc24, 0xbc3e, 0xbc57,
	0xbc70, 0xbc89, 0xbca2, 0xbcbb, 0xbcd5, 0xbcee, 0xbd07, 0xbd21,
	0xbd3a, 0xbd53, 0xbd6c, 0xbd85, 0xbd9e, 0xbdb7, 0xbdd1, 0xbdea,
	0xbe04, 0xbe1d, 0xbe36, 0xbe4f, 0xbe68, 0xbe81, 0xbe9a, 0xbeb3,
	0xbecc, 0xbee5, 0xbefe, 0xbf17, 0xbf31, 0xbf4a, 0xbf63, 0xbf7c,
	// Entry 5900 - 593F
	0xbf95, 0xbfae, 0xbfc7, 0xbfe0, 0xbff9, 0xc012, 0xc02b, 0xc044,
	0xc05d, 0xc076, 0xc08f, 0xc0a8, 0xc0c1, 0xc0da, 0xc0f3, 0xc10c,
	0xc125, 0xc13e, 0xc157, 0xc170, 0xc189, 0xc1a2, 0xc1bb, 0xc1d4,
	0xc1ed, 0xc206, 0xc21f, 0xc238, 0xc251, 0xc26a, 0xc283, 0xc29c,
	0xc2b5, 0xc2ce, 0xc2e7, 0xc300, 0xc319, 0xc333, 0xc34c, 0xc365,
	0xc37e, 0xc397, 0xc3b0, 0xc3c9, 0xc3e2, 0xc3fb, 0xc414, 0xc42d,
	0xc446, 0xc45f, 0xc478, 0xc491, 0xc4aa, 0xc4c3, 0xc4dc, 0xc4f5,
	0xc50e, 0xc527, 0xc540, 0xc559, 0xc573, 0xc58c, 0xc5a5, 0xc5be,
	// Entry 5940 - 597F
	0xc5d7, 0xc5f0, 0xc60a, 0xc623, 0xc63c, 0xc655, 0xc66e, 0xc687,
	0xc6a1, 0xc6ba, 0xc6d3, 0xc6ec, 0xc705, 0xc71e, 0xc737, 0xc750,
	0xc769, 0xc782, 0xc79b, 0xc7b5, 0xc7ce, 0xc7e7, 0xc800, 0xc819,
	0xc832, 0xc84b, 0xc864, 0xc87d, 0xc896, 0xc8af, 0xc8c8, 0xc8e1,
	0xc8fa, 0xc913, 0xc92c, 0xc945, 0xc95e, 0xc977, 0xc990, 0xc9a9,
	0xc9c3, 0xc9dc, 0xc9f5, 0xca0f, 0xca29, 0xca43, 0xca5c, 0xca75,
	0xca8e, 0xcaa7, 0xcac1, 0xcadb, 0xcaf5, 0xcb0e, 0xcb27, 0xcb40,
	0xcb59, 0xcb72, 0xcb8b, 0xcba4, 0xcbbd, 0xcbd6, 0xcbef, 0xcc08,
	// Entry 5980 - 59BF
	0xcc21, 0xcc3a, 0xcc53, 0xcc6c, 0xcc85, 0xcc9e, 0xccb7, 0xccd0,
	0xcce9, 0xcd02, 0xcd1b, 0xcd34, 0xcd4e, 0xcd67, 0xcd80, 0xcd99,
	0xcdb2, 0xcdcb, 0xcde5, 0xcdfe, 0xce17, 0xce30, 0xce49, 0xce63,
	0xce7c, 0xce95, 0xceae, 0xcec8, 0xcee1, 0xcefa, 0xcf13, 0xcf2c,
	0xcf45, 0xcf5e, 0xcf77, 0xcf90, 0xcfa9, 0xcfc2, 0xcfdc, 0xcff5,
	0xd017, 0xd031, 0xd04a, 0xd063, 0xd07c, 0xd096, 0xd0af, 0xd0c8,
	0xd0e1, 0xd0fa, 0xd113, 0xd12c, 0xd14b, 0xd164, 0xd17d, 0xd196,
	0xd1af, 0xd1c8, 0xd1e1, 0xd1fa, 0xd213, 0xd22c, 0xd245, 0xd25e,
	// Entry 59C0 - 59FF
	0xd277, 0xd290, 0xd2a9, 0xd2c2, 0xd2db, 0xd308, 0xd334, 0xd34d,
	0xd366, 0xd37f, 0xd398, 0xd3b1, 0xd3ca, 0xd3e3, 0xd3fc, 0xd415,
	0xd42e, 0xd447, 0xd460, 0xd479, 0xd492, 0xd4ab, 0xd4c4, 0xd4dd,
	0xd4f6, 0xd50f, 0xd528, 0xd541, 0xd55a, 0xd573, 0xd58c, 0xd5a5,
	0xd5be, 0xd5d7, 0xd5f0, 0xd609, 0xd622, 0xd63b, 0xd654, 0xd66d,
	0xd686, 0xd69f, 0xd6b8, 0xd6d1, 0xd6ea, 0xd703, 0xd71c, 0xd736,
	0xd74f, 0xd768, 0xd781, 0xd79a, 0xd7b3, 0xd7cc, 0xd7e5, 0xd7ff,
	0xd818, 0xd831, 0xd84a, 0xd863, 0xd87c, 0xd895, 0xd8ae, 0xd8c7,
	// Entry 5A00 - 5A3F
	0xd8e0, 0xd8f9, 0xd912, 0xd92b, 0xd944, 0xd95d, 0xd976, 0xd98f,
	0xd9a8, 0xd9c1, 0xd9da, 0xd9f3, 0xda0c, 0xda25, 0xda3e, 0xda57,
	0xda70, 0xda89, 0xdaa2, 0xdabb, 0xdad4, 0xdaed, 0xdb06, 0xdb1f,
	0xdb38, 0xdb51, 0xdb6a, 0xdb83, 0xdb9c, 0xdbb5, 0xdbce, 0xdbe7,
	0xdc00, 0xdc19, 0xdc32, 0xdc4b, 0xdc64, 0xdc7d, 0xdc96, 0xdcaf,
	0xdcc8, 0xdce1, 0xdcfa, 0xdd13, 0xdd2c, 0xdd45, 0xdd5e, 0xdd77,
	0xdd90, 0xdda9, 0xddc2, 0xdddb, 0xddf4, 0xde0d, 0xde26, 0xde3f,
	0xde58, 0xde71, 0xde8a, 0xdea3, 0xdebc, 0xded5, 0xdef4, 0xdf12,
	// Entry 5A40 - 5A7F
	0xdf3b, 0xdf61, 0xdf7e, 0xdf9d, 0xdfbb, 0xdfd8, 0xdffa, 0xe025,
	0xe04d, 0xe06c, 0xe08a, 0xe0a5, 0xe0c2, 0xe0de, 0xe0fd, 0xe119,
	0xe135, 0xe154, 0xe16f, 0xe187, 0xe1a6, 0xe1c0, 0xe1dc, 0xe1fa,
	0xe216, 0xe231, 0xe24f, 0xe26b, 0xe28c, 0xe2aa, 0xe2c8, 0xe2e9,
	0xe307, 0xe320, 0xe33b, 0xe35c, 0xe378, 0xe391, 0xe3b1, 0xe3d2,
	0xe3ea, 0xe407, 0xe420, 0xe438, 0xe452, 0xe46c, 0xe487, 0xe4a5,
	0xe4c0, 0xe4d8, 0xe4f9, 0xe512, 0xe52e, 0xe547, 0xe562, 0xe57b,
	0xe593, 0xe5ac, 0xe5c4, 0xe5e2, 0xe5fd, 0xe616, 0xe639, 0xe65d,
	// Entry 5A80 - 5ABF
	0xe678, 0xe694, 0xe6b0, 0xe6ca, 0xe6e4, 0xe6fd, 0xe718, 0xe731,
	0xe74c, 0xe764, 0xe77d, 0xe798, 0xe7b1, 0xe7c9, 0xe7e1, 0xe7fa,
	0xe812, 0xe829, 0xe841, 0xe859, 0xe872, 0xe88d, 0xe8ae, 0xe8c7,
	0xe8e2, 0xe900, 0xe91f, 0xe939, 0xe954, 0xe970, 0xe988, 0xe9a3,
	0xe9c5, 0xe9e8, 0xea09, 0xea26, 0xea46, 0xea5e, 0xea7b, 0xea99,
	0xeab7, 0xead7, 0xeaf8, 0xeb16, 0xeb31, 0xeb4e, 0xeb6a, 0xeb85,
	0xeb9f, 0xebb8, 0xebd9, 0xebf7, 0xec11, 0xec2d, 0xec46, 0xec5f,
	0xec7a, 0xec9b, 0xecb6, 0xecce, 0xece9, 0xed06, 0xed22, 0xed3e,
	// Entry 5AC0 - 5AFF
	0xed5e, 0xed77, 0xed91, 0xeda9, 0xedc4, 0xede4, 0xee01, 0xee19,
	0xee34, 0xee4d, 0xee64, 0xee7c, 0xee95, 0xeeb6, 0xeece, 0xeee6,
	0xef03, 0xef1d, 0xef3b, 0xef55, 0xef70, 0xef8d, 0xefa7, 0xefcd,
	0xefea, 0xf004, 0xf020, 0xf03b, 0xf061, 0xf080, 0xf099, 0xf0b4,
	0xf0d2, 0xf0ec, 0xf105, 0xf121, 0xf13a, 0xf153, 0xf16e, 0xf186,
	0xf19f, 0xf1b9, 0xf1d5, 0xf1ef, 0xf20c, 0xf226, 0xf247, 0xf260,
	0xf27d, 0xf29c, 0xf2b5, 0xf2d0, 0xf2e8, 0xf305, 0xf321, 0xf33e,
	0xf35a, 0xf374, 0xf38c, 0xf3a6, 0xf3be, 0xf3d8, 0xf3f1, 0xf40e,
	// Entry 5B00 - 5B3F
	0xf429, 0xf440, 0xf45a, 0xf472, 0xf48e, 0xf4ad, 0xf4c8, 0xf4e0,
	0xf4f9, 0xf513, 0xf52e, 0xf545, 0xf55d, 0xf576, 0xf58f, 0xf5a7,
	0xf5c3, 0xf5dc, 0xf5f5, 0xf616, 0xf62f, 0xf648, 0xf665, 0xf67d,
	0xf696, 0xf6b0, 0xf6cb, 0xf6e3, 0xf6fe, 0xf719, 0xf735, 0xf74f,
	0xf768, 0xf788, 0xf7a2, 0xf7bc, 0xf7d5, 0xf7ee, 0xf807, 0xf823,
	0xf843, 0xf85c, 0xf874, 0xf88c, 0xf8a4, 0xf8bc, 0xf8d4, 0xf8ed,
	0xf905, 0xf91d, 0xf936, 0xf950, 0xf969, 0xf983, 0xf99d, 0xf9ba,
	0xf9d3, 0xf9ed, 0xfa07, 0xfa20, 0xfa3a, 0xfa59, 0xfa72, 0xfa8d,
	// Entry 5B40 - 5B7F
	0xfaa6, 0xfabe, 0xfad6, 0xfaf2, 0xfb0b, 0xfb23, 0xfb3d, 0xfb57,
	0xfb73, 0xfb8c, 0xfba7, 0xfbbf, 0xfbdb, 0xfbfb, 0xfc17, 0xfc2e,
	0xfc47, 0xfc62, 0xfc80, 0xfc99, 0xfcb5, 0xfcd0, 0xfce9, 0xfd02,
	0xfd1d, 0xfd36, 0xfd51, 0xfd69, 0xfd81, 0xfd9c, 0xfdb5, 0xfdcf,
	0xfde8, 0xfe03, 0xfe1b, 0xfe35, 0xfe4e, 0xfe67, 0xfe81, 0xfe9e,
	0xfeb9, 0xfed4, 0xfeed, 0xff05, 0xff20, 0xff39, 0xff51, 0xff6c,
	0xff86, 0xffa2, 0xffbb, 0xffd3, 0xffec, 0x0005, 0x001f, 0x0038,
	0x0050, 0x006b, 0x0086, 0x009f, 0x00b8, 0x00d0, 0x00e9, 0x0102,
	// Entry 5B80 - 5BBF
	0x011e, 0x0138, 0x0151, 0x016c, 0x0186, 0x01a0, 0x01bb, 0x01d2,
	0x01ee, 0x0206, 0x021e, 0x0236, 0x024e, 0x0268, 0x0282, 0x0298,
	0x02b0, 0x02c7, 0x02e0, 0x02fa, 0x0313, 0x032a, 0x0342, 0x035b,
	0x0373, 0x038a, 0x03a3, 0x03bb, 0x03d4, 0x03ec, 0x0409, 0x0420,
	0x0439, 0x0458, 0x0470, 0x0488, 0x04a1, 0x04ba, 0x04d4, 0x04ec,
	0x0504, 0x051d, 0x0535, 0x054d, 0x0565, 0x0580, 0x0599, 0x05b2,
	0x05ca, 0x05e3, 0x05fd, 0x0615, 0x062d, 0x064a, 0x0663, 0x067b,
	0x0694, 0x06ac, 0x06c7, 0x06e0, 0x06f9, 0x0714, 0x072d, 0x0747,
	// Entry 5BC0 - 5BFF
	0x0762, 0x077c, 0x0795, 0x07ad, 0x07c9, 0x07e2, 0x07fc, 0x0819,
	0x0835, 0x084d, 0x0866, 0x0882, 0x089b, 0x08ba, 0x08d2, 0x08ea,
	0x090c, 0x0930, 0x0949, 0x0963, 0x097c, 0x0996, 0x09ad, 0x09c7,
	0x09e1, 0x09fb, 0x0a16, 0x0a30, 0x0a49, 0x0a62, 0x0a79, 0x0a92,
	0x0aae, 0x0acb, 0x0ae7, 0x0b01, 0x0b1a, 0x0b33, 0x0b4c, 0x0b65,
	0x0b7d, 0x0b96, 0x0bae, 0x0bce, 0x0be6, 0x0c00, 0x0c1a, 0x0c34,
	0x0c4d, 0x0c68, 0x0c80, 0x0c9a, 0x0cb4, 0x0ccc, 0x0ce4, 0x0d00,
	0x0d19, 0x0d30, 0x0d49, 0x0d62, 0x0d7b, 0x0d97, 0x0db7, 0x0dd0,
	// Entry 5C00 - 5C3F
	0x0de9, 0x0e02, 0x0e1b, 0x0e33, 0x0e4c, 0x0e67, 0x0e80, 0x0e98,
	0x0eb1, 0x0ecb, 0x0ee3, 0x0efc, 0x0f15, 0x0f30, 0x0f4a, 0x0f68,
	0x0f84, 0x0f9c, 0x0fb5, 0x0fcb, 0x0fe3, 0x0ff9, 0x100f, 0x1027,
	0x1045, 0x105d, 0x1075, 0x1097, 0x10b0, 0x10c9, 0x10e3, 0x10fd,
	0x111e, 0x113c, 0x1154, 0x116c, 0x1185, 0x119e, 0x11bd, 0x11d5,
	0x11ed, 0x1205, 0x121d, 0x1234, 0x124b, 0x1264, 0x127c, 0x1297,
	0x12af, 0x12c7, 0x12e0, 0x12fe, 0x1315, 0x132c, 0x1344, 0x135b,
	0x1373, 0x138a, 0x13a2, 0x13ba, 0x13d1, 0x13e9, 0x1401, 0x1419,
	// Entry 5C40 - 5C7F
	0x1432, 0x1449, 0x145f, 0x1476, 0x148d, 0x14a5, 0x14bd, 0x14d5,
	0x14ec, 0x1504, 0x151d, 0x1537, 0x154f, 0x1568, 0x1582, 0x1598,
	0x15b0, 0x15c9, 0x15e0, 0x15f9, 0x1612, 0x162a, 0x1643, 0x165a,
	0x1674, 0x168c, 0x16a4, 0x16bb, 0x16d4, 0x16ed, 0x1706, 0x171e,
	0x1736, 0x174d, 0x1764, 0x177d, 0x1795, 0x17b1, 0x17ca, 0x17e2,
	0x17fb, 0x1813, 0x182a, 0x1841, 0x1859, 0x1870, 0x1889, 0x18a1,
	0x18b8, 0x18cf, 0x18e8, 0x1900, 0x1918, 0x1932, 0x194b, 0x1958,
	0x1966, 0x1973, 0x1981, 0x198e, 0x199b, 0x19a7, 0x19b5, 0x19c4,
	// Entry 5C80 - 5CBF
	0x19d2, 0x19e0, 0x19ee, 0x19fe, 0x1a0b, 0x1a1a, 0x1a28, 0x1a35,
	0x1a42, 0x1a4e, 0x1a5b, 0x1a69, 0x1a78, 0x1a85, 0x1a92, 0x1a9e,
	0x1aab, 0x1ab9, 0x1ac6, 0x1ad4, 0x1ae1, 0x1aef, 0x1afd, 0x1b0a,
	0x1b17, 0x1b26, 0x1b34, 0x1b42, 0x1b4f, 0x1b5e, 0x1b6d, 0x1b7b,
	0x1b84, 0x1b94, 0x1ba9, 0x1bbc, 0x1bcf, 0x1be2, 0x1bf6, 0x1c0a,
	0x1c1e, 0x1c33, 0x1c48, 0x1c5b, 0x1c70, 0x1c83, 0x1c96, 0x1caa,
	0x1cbd, 0x1cd0, 0x1ce4, 0x1cf7, 0x1d0a, 0x1d1d, 0x1d32, 0x1d45,
	0x1d5b, 0x1d6d, 0x1d7f, 0x1d92, 0x1da4, 0x1db7, 0x1dc9, 0x1ddb,
	// Entry 5CC0 - 5CFF
	0x1df8, 0x1e14, 0x1e30, 0x1e50, 0x1e71, 0x1e84, 0x1e9b, 0x1eb2,
	0x1ec8, 0x1ede, 0x1ef5, 0x1f0c, 0x1f22, 0x1f38, 0x1f4e, 0x1f64,
	0x1f7b, 0x1f92, 0x1fa9, 0x1fc0, 0x1fd7, 0x1fee, 0x2005, 0x201c,
	0x2032, 0x2048, 0x205f, 0x2076, 0x208c, 0x20a2, 0x20b8, 0x20ce,
	0x20e5, 0x20fc, 0x2116, 0x2132, 0x214c, 0x2166, 0x2181, 0x219b,
	0x21b6, 0x21d1, 0x21eb, 0x2206, 0x2220, 0x223b, 0x2257, 0x2272,
	0x228e, 0x22aa, 0x22c4, 0x22dd, 0x22f7, 0x2311, 0x232a, 0x2342,
	0x235b, 0x2375, 0x238f, 0x23a8, 0x23c2, 0x23dc, 0x23fc, 0x2417,
	// Entry 5D00 - 5D3F
	0x2432, 0x244c, 0x2469, 0x2484, 0x249f, 0x24bb, 0x24d5, 0x24f0,
	0x250a, 0x2522, 0x2538, 0x2556, 0x256d, 0x2583, 0x2599, 0x25b1,
	0x25c8, 0x25df, 0x25f5, 0x260d, 0x2625, 0x263c, 0x2654, 0x2670,
	0x2691, 0x26ad, 0x26d1, 0x26f1, 0x270e, 0x2727, 0x273d, 0x2752,
	0x2773, 0x278d, 0x27a3, 0x27b9, 0x27cf, 0x27e5, 0x27f9, 0x2816,
	0x2832, 0x2847, 0x285c, 0x2871, 0x2899, 0x28ba, 0x28d4, 0x28f3,
	0x2911, 0x292f, 0x294c, 0x2967, 0x2981, 0x299c, 0x29b8, 0x29d2,
	0x29ed, 0x2a08, 0x2a23, 0x2a3e, 0x2a59, 0x2a74, 0x2a8e, 0x2aa8,
	// Entry 5D40 - 5D7F
	0x2ac2, 0x2adc, 0x2af7, 0x2b11, 0x2b2b, 0x2b39, 0x2b47, 0x2b58,
	0x2b67, 0x2b75, 0x2b84, 0x2b9a, 0x2ba8, 0x2bb6, 0x2bc5, 0x2bd3,
	0x2be1, 0x2bf3, 0x2c04, 0x2c13, 0x2c22, 0x2c30, 0x2c3f, 0x2c51,
	0x2c67, 0x2c76, 0x2c86, 0x2c94, 0x2ca3, 0x2cb2, 0x2cc2, 0x2cd2,
	0x2ce2, 0x2cf3, 0x2d04, 0x2d12, 0x2d20, 0x2d31, 0x2d3f, 0x2d4e,
	0x2d5d, 0x2d6d, 0x2d84, 0x2d92, 0x2da0, 0x2daf, 0x2dbf, 0x2dcf,
	0x2ddf, 0x2dee, 0x2dfe, 0x2e0e, 0x2e1e, 0x2e31, 0x2e44, 0x2e5d,
	0x2e6c, 0x2e7b, 0x2e8a, 0x2e9a, 0x2ea9, 0x2eb8, 0x2eca, 0x2ed8,
	// Entry 5D80 - 5DBF
	0x2ee6, 0x2ef5, 0x2f04, 0x2f14, 0x2f2b, 0x2f3b, 0x2f4c, 0x2f5a,
	0x2f68, 0x2f77, 0x2f8f, 0x2fa3, 0x2fbd, 0x2fda, 0x2feb, 0x2ffd,
	0x3010, 0x3022, 0x3035, 0x3046, 0x3058, 0x306a, 0x307b, 0x308c,
	0x309e, 0x30b1, 0x30c4, 0x30d5, 0x30e7, 0x30fa, 0x310e, 0x3120,
	0x3132, 0x3144, 0x3156, 0x3169, 0x317a, 0x318c, 0x319f, 0x31b3,
	0x31c5, 0x31d8, 0x31eb, 0x31fc, 0x320e, 0x3220, 0x3233, 0x3246,
	0x3261, 0x3273, 0x328d, 0x329f, 0x32b1, 0x32c3, 0x32d5, 0x32e6,
	0x32f8, 0x3307, 0x331a, 0x3329, 0x3338, 0x334a, 0x335c, 0x336e,
	// Entry 5DC0 - 5DFF
	0x3380, 0x3392, 0x33a4, 0x33b6, 0x33d1, 0x33ec, 0x3407, 0x3422,
	0x343d, 0x3458, 0x346d, 0x3481, 0x3495, 0x34a9, 0x34bd, 0x34d1,
	0x34e5, 0x34f9, 0x350d, 0x3521, 0x3535, 0x3549, 0x355d, 0x3571,
	0x3585, 0x3599, 0x35ad, 0x35c1, 0x35d5, 0x35e9, 0x35fd, 0x3611,
	0x3625, 0x3639, 0x364d, 0x3661, 0x3675, 0x3689, 0x369d, 0x36b1,
	0x36c5, 0x36d9, 0x36ed, 0x3701, 0x3715, 0x3729, 0x373d, 0x3751,
	0x3765, 0x3779, 0x378d, 0x37a1, 0x37b5, 0x37c9, 0x37dd, 0x37f1,
	0x3805, 0x3819, 0x382d, 0x3841, 0x3855, 0x3869, 0x387d, 0x3891,
	// Entry 5E00 - 5E3F
	0x38a5, 0x38b9, 0x38cd, 0x38e1, 0x38f5, 0x3909, 0x391d, 0x3931,
	0x3945, 0x3959, 0x396d, 0x3981, 0x3995, 0x39a9, 0x39bd, 0x39d1,
	0x39e5, 0x39f9, 0x3a0d, 0x3a21, 0x3a35, 0x3a49, 0x3a5d, 0x3a71,
	0x3a85, 0x3a99, 0x3aad, 0x3ac1, 0x3ad5, 0x3ae9, 0x3afd, 0x3b11,
	0x3b25, 0x3b39, 0x3b4d, 0x3b61, 0x3b75, 0x3b89, 0x3b9d, 0x3bb1,
	0x3bc5, 0x3bd9, 0x3bed, 0x3c01, 0x3c15, 0x3c29, 0x3c3d, 0x3c51,
	0x3c65, 0x3c79, 0x3c8d, 0x3ca1, 0x3cb5, 0x3cc9, 0x3cdd, 0x3cf1,
	0x3d05, 0x3d19, 0x3d2d, 0x3d41, 0x3d55, 0x3d69, 0x3d7d, 0x3d91,
	// Entry 5E40 - 5E7F
	0x3da5, 0x3db9, 0x3dcd, 0x3de1, 0x3df5, 0x3e09, 0x3e1d, 0x3e31,
	0x3e45, 0x3e59, 0x3e6d, 0x3e81, 0x3e95, 0x3ea9, 0x3ebd, 0x3ed1,
	0x3ee5, 0x3ef9, 0x3f0d, 0x3f21, 0x3f35, 0x3f49, 0x3f5d, 0x3f71,
	0x3f85, 0x3f99, 0x3fad, 0x3fc1, 0x3fd5, 0x3fe9, 0x3ffd, 0x4011,
	0x4025, 0x4039, 0x404d, 0x4061, 0x4075, 0x4089, 0x409d, 0x40b1,
	0x40c5, 0x40d9, 0x40ed, 0x4101, 0x4115, 0x4129, 0x413d, 0x4151,
	0x4165, 0x4179, 0x418d, 0x41a1, 0x41b5, 0x41c9, 0x41dd, 0x41f1,
	0x4205, 0x4219, 0x422d, 0x4241, 0x4255, 0x4269, 0x427d, 0x4291,
	// Entry 5E80 - 5EBF
	0x42a5, 0x42b9, 0x42cd, 0x42e1, 0x42f5, 0x4309, 0x431d, 0x4331,
	0x4345, 0x4359, 0x436d, 0x4381, 0x4395, 0x43a9, 0x43bd, 0x43d1,
	0x43e5, 0x43f9, 0x440d, 0x4421, 0x4435, 0x4449, 0x445d, 0x4471,
	0x4485, 0x4499, 0x44ad, 0x44c1, 0x44d5, 0x44e9, 0x44fd, 0x4511,
	0x4525, 0x4539, 0x454d, 0x4561, 0x4575, 0x4589, 0x459d, 0x45b1,
	0x45c5, 0x45d9, 0x45ed, 0x4601, 0x4615, 0x4629, 0x463d, 0x4651,
	0x4665, 0x4679, 0x468d, 0x46a1, 0x46b5, 0x46c9, 0x46dd, 0x46f1,
	0x4705, 0x4719, 0x472d, 0x4741, 0x4755, 0x4769, 0x477d, 0x4791,
	// Entry 5EC0 - 5EFF
	0x47a5, 0x47b9, 0x47cd, 0x47e1, 0x47f5, 0x4809, 0x481d, 0x4831,
	0x4845, 0x4859, 0x486d, 0x4881, 0x4895, 0x48a9, 0x48bd, 0x48d1,
	0x48e5, 0x48f9, 0x490d, 0x4921, 0x4935, 0x4949, 0x495d, 0x4971,
	0x4985, 0x4999, 0x49ad, 0x49c1, 0x49d5, 0x49e9, 0x49fd, 0x4a11,
	0x4a25, 0x4a39, 0x4a4d, 0x4a61, 0x4a75, 0x4a89, 0x4a9d, 0x4ab1,
	0x4ac5, 0x4ad9, 0x4aed, 0x4b01, 0x4b15, 0x4b29, 0x4b3d, 0x4b51,
	0x4b65, 0x4b79, 0x4b8d, 0x4ba1, 0x4bb5, 0x4bc9, 0x4bdd, 0x4bf1,
	0x4c05, 0x4c19, 0x4c2d, 0x4c41, 0x4c55, 0x4c69, 0x4c7d, 0x4c91,
	// Entry 5F00 - 5F3F
	0x4ca5, 0x4cb9, 0x4ccd, 0x4ce1, 0x4cf5, 0x4d09, 0x4d1d, 0x4d31,
	0x4d45, 0x4d59, 0x4d6d, 0x4d81, 0x4d95, 0x4da9, 0x4dbd, 0x4dd1,
	0x4de5, 0x4df9, 0x4e0d, 0x4e21, 0x4e35, 0x4e49, 0x4e5d, 0x4e71,
	0x4e85, 0x4e99, 0x4ead, 0x4ec1, 0x4ed5, 0x4ee9, 0x4efd, 0x4f11,
	0x4f25, 0x4f39, 0x4f4d, 0x4f61, 0x4f75, 0x4f89, 0x4f9d, 0x4fb1,
	0x4fc5, 0x4fd9, 0x4fed, 0x5001, 0x5015, 0x5029, 0x503d, 0x5051,
	0x5065, 0x5079, 0x508d, 0x50a1, 0x50b5, 0x50c9, 0x50dd, 0x50f1,
	0x5105, 0x5119, 0x512d, 0x5141, 0x5155, 0x5169, 0x517d, 0x5191,
	// Entry 5F40 - 5F7F
	0x51a5, 0x51b9, 0x51cd, 0x51e1, 0x51f5, 0x5209, 0x521d, 0x5231,
	0x5245, 0x5259, 0x526d, 0x5281, 0x5295, 0x52a9, 0x52bd, 0x52d1,
	0x52e5, 0x52f9, 0x530d, 0x5321, 0x5335, 0x5349, 0x535d, 0x5371,
	0x5385, 0x5399, 0x53ad, 0x53c1, 0x53d5, 0x53e9, 0x53fd, 0x5411,
	0x5425, 0x5439, 0x544d, 0x5461, 0x5475, 0x5489, 0x549d, 0x54b1,
	0x54c5, 0x54d9, 0x54ed, 0x5501, 0x5515, 0x5529, 0x553d, 0x5551,
	0x5565, 0x5579, 0x558d, 0x55a1, 0x55b5, 0x55c9, 0x55dd, 0x55f1,
	0x5605, 0x5619, 0x562d, 0x5641, 0x5655, 0x5669, 0x567d, 0x5691,
	// Entry 5F80 - 5FBF
	0x56a5, 0x56b9, 0x56cd, 0x56e1, 0x56f5, 0x5709, 0x571d, 0x5731,
	0x5745, 0x5759, 0x576d, 0x5781, 0x5795, 0x57a9, 0x57bd, 0x57d1,
	0x57e5, 0x57f9, 0x580d, 0x5821, 0x5835, 0x5849, 0x585d, 0x5871,
	0x5885, 0x5899, 0x58ad, 0x58c1, 0x58d5, 0x58e9, 0x58fd, 0x5911,
	0x5925, 0x5939, 0x594d, 0x5961, 0x5975, 0x5989, 0x599d, 0x59b1,
	0x59c5, 0x59d9, 0x59ed, 0x5a01, 0x5a15, 0x5a29, 0x5a3d, 0x5a51,
	0x5a65, 0x5a79, 0x5a8d, 0x5aa1, 0x5ab5, 0x5ac9, 0x5add, 0x5af1,
	0x5b05, 0x5b19, 0x5b2d, 0x5b41, 0x5b55, 0x5b69, 0x5b7d, 0x5b91,
	// Entry 5FC0 - 5FFF
	0x5ba5, 0x5bb9, 0x5bcd, 0x5be1, 0x5bf5, 0x5c09, 0x5c1d, 0x5c31,
	0x5c45, 0x5c59, 0x5c6d, 0x5c81, 0x5c95, 0x5ca9, 0x5cbd, 0x5cd1,
	0x5ce5, 0x5cf9, 0x5d0d, 0x5d21, 0x5d35, 0x5d49, 0x5d5d, 0x5d71,
	0x5d85, 0x5d99, 0x5dad, 0x5dc1, 0x5dd5, 0x5de9, 0x5dfd, 0x5e11,
	0x5e25, 0x5e39, 0x5e4d, 0x5e61, 0x5e75, 0x5e89, 0x5e9d, 0x5eb1,
	0x5ec5, 0x5ed9, 0x5eed, 0x5f01, 0x5f15, 0x5f29, 0x5f3d, 0x5f51,
	0x5f65, 0x5f79, 0x5f8d, 0x5fa1, 0x5fb5, 0x5fc9, 0x5fdd, 0x5ff1,
	0x6005, 0x6019, 0x602d, 0x6041, 0x6055, 0x6069, 0x607d, 0x6091,
	// Entry 6000 - 603F
	0x60a5, 0x60b9, 0x60cd, 0x60e1, 0x60f5, 0x6109, 0x611d, 0x6131,
	0x6145, 0x6159, 0x616d, 0x6181, 0x6195, 0x61a9, 0x61bd, 0x61d1,
	0x61e5, 0x61f9, 0x620d, 0x6221, 0x6235, 0x6249, 0x625d, 0x6271,
	0x6285, 0x6299, 0x62ad, 0x62c1, 0x62d5, 0x62e9, 0x62fd, 0x6311,
	0x6325, 0x6339, 0x634d, 0x6361, 0x6375, 0x6389, 0x639d, 0x63b1,
	0x63c5, 0x63d9, 0x63ed, 0x6401, 0x6415, 0x6429, 0x643d, 0x6451,
	0x6465, 0x6479, 0x648d, 0x64a1, 0x64b5, 0x64c9, 0x64dd, 0x64f1,
	0x6505, 0x6519, 0x652d, 0x6541, 0x6555, 0x6569, 0x657d, 0x6591,
	// Entry 6040 - 607F
	0x65a5, 0x65b9, 0x65cd, 0x65e1, 0x65f5, 0x6609, 0x661d, 0x6631,
	0x6645, 0x6659, 0x666d, 0x6681, 0x6695, 0x66a9, 0x66bd, 0x66d1,
	0x66e5, 0x66f9, 0x670d, 0x6721, 0x6735, 0x6749, 0x675d, 0x6771,
	0x6785, 0x6799, 0x67ad, 0x67c1, 0x67d5, 0x67e9, 0x67fd, 0x6811,
	0x6825, 0x6839, 0x684d, 0x6861, 0x6875, 0x6889, 0x689d, 0x68b1,
	0x68c5, 0x68d9, 0x68ed, 0x6901, 0x6915, 0x6929, 0x693d, 0x6951,
	0x6965, 0x6979, 0x698d, 0x69a1, 0x69b5, 0x69c9, 0x69dd, 0x69f1,
	0x6a05, 0x6a19, 0x6a2d, 0x6a41, 0x6a55, 0x6a69, 0x6a7d, 0x6a91,
	// Entry 6080 - 60BF
	0x6aa5, 0x6ab9, 0x6acd, 0x6ae1, 0x6af5, 0x6b09, 0x6b1d, 0x6b31,
	0x6b45, 0x6b59, 0x6b6d, 0x6b81, 0x6b95, 0x6ba9, 0x6bbd, 0x6bd1,
	0x6be5, 0x6bf9, 0x6c0d, 0x6c21, 0x6c35, 0x6c49, 0x6c5d, 0x6c71,
	0x6c85, 0x6c99, 0x6cad, 0x6cc1, 0x6cd5, 0x6ce9, 0x6cfd, 0x6d11,
	0x6d25, 0x6d39, 0x6d4d, 0x6d61, 0x6d75, 0x6d89, 0x6d9d, 0x6db1,
	0x6dc5, 0x6dd9, 0x6ded, 0x6e01, 0x6e15, 0x6e29, 0x6e3d, 0x6e51,
	0x6e65, 0x6e79, 0x6e8d, 0x6ea1, 0x6eb5, 0x6ec9, 0x6edd, 0x6ef1,
	0x6f05, 0x6f19, 0x6f2d, 0x6f41, 0x6f55, 0x6f69, 0x6f82, 0x6f9c,
	// Entry 60C0 - 60FF
	0x6fad, 0x6fbe, 0x6fcf, 0x6fe0, 0x6ff1, 0x7002, 0x7013, 0x7024,
	0x7035, 0x7046, 0x7057, 0x7068, 0x707b, 0x708e, 0x70a1, 0x70b4,
	0x70c7, 0x70d9, 0x70f1, 0x7103, 0x7115, 0x712c, 0x713e, 0x7150,
	0x7162, 0x7173, 0x7184, 0x7195, 0x71a6, 0x71b9, 0x71cc, 0x71df,
	0x71f2, 0x720c, 0x7226, 0x7240, 0x726c, 0x7286, 0x72a6, 0x72b9,
	0x72cc, 0x72df, 0x72f2, 0x7307, 0x731c, 0x7331, 0x7346, 0x7362,
	0x7375, 0x738a, 0x739d, 0x73b2, 0x73c5, 0x73da, 0x73ed, 0x7402,
	0x7413, 0x7425, 0x7438, 0x744b, 0x745e, 0x7473, 0x7488, 0x749b,
	// Entry 6100 - 613F
	0x74b0, 0x74c1, 0x74d9, 0x74eb, 0x74fc, 0x750f, 0x7520, 0x7531,
	0x7543, 0x755a, 0x756c, 0x757e, 0x7596, 0x75b0, 0x75c8, 0x75de,
	0x75f0, 0x7601, 0x7613, 0x7625, 0x7638, 0x764e, 0x7668, 0x767a,
	0x7691, 0x76a4, 0x76b6, 0x76c8, 0x76da, 0x76ec, 0x76fe, 0x7711,
	0x7724, 0x773b, 0x7752, 0x7769, 0x7780, 0x7799, 0x77b2, 0x77ca,
	0x77e2, 0x77fa, 0x7813, 0x7838, 0x785c, 0x7882, 0x78a4, 0x78c6,
	0x78e9, 0x7907, 0x7933, 0x7952, 0x796e, 0x798c, 0x79aa, 0x79ce,
	0x79e7, 0x7a06, 0x7a1f, 0x7a3d, 0x7a54, 0x7a6e, 0x7a86, 0x7a9e,
	// Entry 6140 - 617F
	0x7aba, 0x7ad2, 0x7af0, 0x7b08, 0x7b25, 0x7b3b, 0x7b54, 0x7b6b,
	0x7b82, 0x7b9d, 0x7bb5, 0x7bcf, 0x7bed, 0x7c01, 0x7c27, 0x7c46,
	0x7c69, 0x7c83, 0x7c9b, 0x7cb9, 0x7cd8, 0x7cfc, 0x7d26, 0x7d4a,
	0x7d75, 0x7d9a, 0x7dbb, 0x7ddd, 0x7e01, 0x7e23, 0x7e4b, 0x7e6c,
	0x7e96, 0x7ebe, 0x7edd, 0x7eff, 0x7f22, 0x7f4b, 0x7f6b, 0x7f89,
	0x7fb1, 0x7fd9, 0x7ff8, 0x8019, 0x8037, 0x805d, 0x8086, 0x80b1,
	0x80d2, 0x80f3, 0x811c, 0x8144, 0x816d, 0x8197, 0x81b8, 0x81d7,
	0x81f5, 0x821d, 0x823d, 0x8262, 0x8281, 0x82aa, 0x82d7, 0x8302,
	// Entry 6180 - 61BF
	0x8320, 0x833e, 0x835a, 0x8377, 0x8397, 0x83b9, 0x83df, 0x8407,
	0x8429, 0x8453, 0x847b, 0x849c, 0x84be, 0x84df, 0x8509, 0x8529,
	0x8556, 0x8583, 0x85a3, 0x85c0, 0x85e0, 0x8606, 0x862c, 0x8651,
	0x8676, 0x8697, 0x86ba, 0x86dc, 0x86fc, 0x871d, 0x8745, 0x876d,
	0x8792, 0x87bc, 0x87e4, 0x8803, 0x882a, 0x885b, 0x887b, 0x88a3,
	0x88c3, 0x88e3, 0x8907, 0x892a, 0x894d, 0x8973, 0x8992, 0x89b5,
	0x89d5, 0x89fd, 0x8a25, 0x8a50, 0x8a70, 0x8a98, 0x8abd, 0x8ae0,
	0x8b04, 0x8b22, 0x8b47, 0x8b68, 0x8b8b, 0x8bb0, 0x8bd9, 0x8c01,
	// Entry 61C0 - 61FF
	0x8c28, 0x8c53, 0x8c7f, 0x8ca6, 0x8cce, 0x8cf5, 0x8d1b, 0x8d48,
	0x8d6e, 0x8d96, 0x8dbe, 0x8de3, 0x8e0c, 0x8e2e, 0x8e50, 0x8e72,
	0x8e93, 0x8eb3, 0x8ed6, 0x8efd, 0x8f26, 0x8f4b, 0x8f6f, 0x8f94,
	0x8fb1, 0x8fcf, 0x8fee, 0x900f, 0x902f, 0x905b, 0x9086, 0x90b3,
	0x90e3, 0x9112, 0x9139, 0x916f, 0x91a2, 0x91c3, 0x9200, 0x923c,
	0x9271, 0x9293, 0x92b1, 0x92d4, 0x92f4, 0x931c, 0x9343, 0x9366,
	0x938b, 0x93ae, 0x93d2, 0x93fa, 0x9423, 0x9451, 0x9484, 0x94b4,
	0x94e9, 0x9517, 0x9542, 0x9572, 0x95aa, 0x95d9, 0x9608, 0x9638,
	// Entry 6200 - 623F
	0x966c, 0x969a, 0x96c7, 0x96f2, 0x971f, 0x9751, 0x9789, 0x97b5,
	0x97e2, 0x9811, 0x9832, 0x9855, 0x988c, 0x98b8, 0x98e6, 0x9910,
	0x993c, 0x996f, 0x999b, 0x99c7, 0x99f8, 0x9a28, 0x9a5f, 0x9a98,
	0x9acc, 0x9b01, 0x9b27, 0x9b4b, 0x9b70, 0x9b95, 0x9bcb, 0x9bff,
	0x9c2a, 0x9c55, 0x9c82, 0x9cb3, 0x9cef, 0x9d24, 0x9d5c, 0x9d8d,
	0x9dc9, 0x9dfe, 0x9e36, 0x9e5c, 0x9e82, 0x9eae, 0x9edb, 0x9f02,
	0x9f2b, 0x9f54, 0x9f85, 0x9fb7, 0x9feb, 0xa013, 0xa043, 0xa074,
	0xa0a7, 0xa0cb, 0xa0f0, 0xa10f, 0xa132, 0xa156, 0xa179, 0xa19c,
	// Entry 6240 - 627F
	0xa1bf, 0xa1e2, 0xa205, 0xa230, 0xa259, 0xa284, 0xa2ad, 0xa2d1,
	0xa2f9, 0xa316, 0xa333, 0xa34f, 0xa373, 0xa390, 0xa3ac, 0xa3cb,
	0xa3eb, 0xa405, 0xa41d, 0xa433, 0xa447, 0xa45a, 0xa47a, 0xa49a,
	0xa4ba, 0xa4d0, 0xa4ec, 0xa506, 0xa51c, 0xa530, 0xa546, 0xa563,
	0xa580, 0xa59f, 0xa5bd, 0xa5db, 0xa5f8, 0xa61b, 0xa63f, 0xa654,
	0xa675, 0xa697, 0xa6ac, 0xa6c1, 0xa6e2, 0xa704, 0xa71e, 0xa738,
	0xa75c, 0xa777, 0xa791, 0xa7a7, 0xa7bf, 0xa7d8, 0xa7f3, 0xa80a,
	0xa823, 0xa844, 0xa864, 0xa87e, 0xa895, 0xa8af, 0xa8ca, 0xa8ea,
	// Entry 6280 - 62BF
	0xa90b, 0xa924, 0xa93d, 0xa955, 0xa970, 0xa98a, 0xa9a7, 0xa9c8,
	0xa9e8, 0xaa15, 0xaa2e, 0xaa4a, 0xaa6a, 0xaa8e, 0xaab2, 0xaadb,
	0xab04, 0xab2f, 0xab5a, 0xab86, 0xabb2, 0xabdd, 0xac08, 0xac37,
	0xac66, 0xac88, 0xacaa, 0xacdb, 0xad0c, 0xad2f, 0xad4b, 0xad68,
	0xad84, 0xada9, 0xadce, 0xade2, 0xadfb, 0xae13, 0xae2e, 0xae48,
	0xae65, 0xae86, 0xaea6, 0xaed3, 0xaef0, 0xaf1a, 0xaf3c, 0xaf5e,
	0xaf80, 0xafa1, 0xafc2, 0xafe3, 0xb00c, 0xb02b, 0xb04a, 0xb069,
	0xb088, 0xb0a7, 0xb0c0, 0xb0d7, 0xb0ef, 0xb105, 0xb11e, 0xb135,
	// Entry 62C0 - 62FF
	0xb150, 0xb169, 0xb188, 0xb1a9, 0xb1c8, 0xb1ee, 0xb20e, 0xb237,
	0xb25f, 0xb27d, 0xb299, 0xb2b7, 0xb2d4, 0xb2f0, 0xb30d, 0xb32b,
	0xb348, 0xb36e, 0xb394, 0xb3ae, 0xb3c3, 0xb3d3, 0xb3e7, 0xb3fb,
	0xb40f, 0xb427, 0xb441, 0xb460, 0xb482, 0xb493, 0xb4a6, 0xb4c2,
	0xb4db, 0xb4f1, 0xb511, 0xb531, 0xb551, 0xb571, 0xb591, 0xb5b1,
	0xb5d1, 0xb5f1, 0xb611, 0xb632, 0xb653, 0xb66d, 0xb687, 0xb6a3,
	0xb6be, 0xb6df, 0xb6fe, 0xb71f, 0xb746, 0xb75f, 0xb77b, 0xb799,
	0xb7b4, 0xb7d1, 0xb7f0, 0xb803, 0xb81a, 0xb82f, 0xb843, 0xb858,
	// Entry 6300 - 633F
	0xb877, 0xb896, 0xb8ab, 0xb8c6, 0xb8e5, 0xb904, 0xb91d, 0xb936,
	0xb958, 0xb97c, 0xb996, 0xb9b4, 0xb9ce, 0xb9ec, 0xba23, 0xba5c,
	0xbaa0, 0xbad9, 0xbb14, 0xbb5c, 0xbba4, 0xbbec, 0xbc00, 0xbc1f,
	0xbc3e, 0xbc55, 0xbc69, 0xbc7f, 0xbc94, 0xbcac, 0xbcc3, 0xbcda,
	0xbcf2, 0xbd11, 0xbd30, 0xbd51, 0xbd6e, 0xbd8a, 0xbdac, 0xbdcc,
	0xbdf1, 0xbe11, 0xbe30, 0xbe5c, 0xbe86, 0xbeb1, 0xbeda, 0xbef9,
	0xbf16, 0xbf33, 0xbf50, 0xbf6d, 0xbf8a, 0xbfa7, 0xbfc4, 0xbfe1,
	0xbffe, 0xc01c, 0xc03a, 0xc058, 0xc076, 0xc094, 0xc0b2, 0xc0d0,
	// Entry 6340 - 637F
	0xc0ee, 0xc10c, 0xc12a, 0xc148, 0xc166, 0xc184, 0xc1a2, 0xc1c0,
	0xc1de, 0xc1fc, 0xc21a, 0xc238, 0xc256, 0xc27a, 0xc29e, 0xc2c2,
	0xc2e6, 0xc30a, 0xc32e, 0xc353, 0xc378, 0xc39d, 0xc3c2, 0xc3e7,
	0xc40c, 0xc431, 0xc456, 0xc47b, 0xc4a0, 0xc4c5, 0xc4ea, 0xc50f,
	0xc534, 0xc559, 0xc57e, 0xc5a3, 0xc5c8, 0xc5ed, 0xc612, 0xc637,
	0xc65c, 0xc681, 0xc6a6, 0xc6cb, 0xc6f0, 0xc715, 0xc73a, 0xc75f,
	0xc784, 0xc7a9, 0xc7c8, 0xc7e9, 0xc80a, 0xc81e, 0xc830, 0xc849,
	0xc85f, 0xc878, 0xc890, 0xc8a0, 0xc8b4, 0xc8cd, 0xc8e0, 0xc8f5,
	// Entry 6380 - 63BF
	0xc910, 0xc929, 0xc93d, 0xc955, 0xc970, 0xc999, 0xc9b1, 0xc9cb,
	0xc9e1, 0xc9fa, 0xca0d, 0xca22, 0xca3c, 0xca51, 0xca68, 0xca7d,
	0xca92, 0xcaaa, 0xcabc, 0xcacd, 0xcae5, 0xcafc, 0xcb10, 0xcb24,
	0xcb3e, 0xcb5b, 0xcb70, 0xcb84, 0xcb9b, 0xcbb0, 0xcbc7, 0xcbdd,
	0xcbf1, 0xcc07, 0xcc1e, 0xcc38, 0xcc4e, 0xcc69, 0xcc81, 0xcc94,
	0xccab, 0xccc4, 0xccd9, 0xcced, 0xcd01, 0xcd22, 0xcd39, 0xcd4e,
	0xcd64, 0xcd77, 0xcd91, 0xcdab, 0xcdc4, 0xcdde, 0xcdf3, 0xce0d,
	0xce28, 0xce3b, 0xce4e, 0xce63, 0xce76, 0xce8d, 0xcea4, 0xceb9,
	// Entry 63C0 - 63FF
	0xced1, 0xcee8, 0xcefe, 0xcf14, 0xcf2c, 0xcf41, 0xcf56, 0xcf6f,
	0xcf87, 0xcfa1, 0xcfbb, 0xcfd2, 0xcfe9, 0xd004, 0xd01f, 0xd03c,
	0xd058, 0xd074, 0xd08f, 0xd0ac, 0xd0c9, 0xd0e5, 0xd100, 0xd11b,
	0xd138, 0xd154, 0xd170, 0xd18b, 0xd1a8, 0xd1c5, 0xd1e1, 0xd1fc,
	0xd217, 0xd232, 0xd24d, 0xd268, 0xd283, 0xd29e, 0xd2b9, 0xd2d4,
	0xd2ef, 0xd30a, 0xd325, 0xd340, 0xd35b, 0xd376, 0xd391, 0xd3ac,
	0xd3c7, 0xd3e2, 0xd3fd, 0xd418, 0xd433, 0xd44e, 0xd469, 0xd484,
	0xd49f, 0xd4b8, 0xd4d1, 0xd4ea, 0xd503, 0xd51c, 0xd535, 0xd54e,
	// Entry 6400 - 643F
	0xd567, 0xd580, 0xd599, 0xd5b2, 0xd5cb, 0xd5e4, 0xd5fd, 0xd616,
	0xd62f, 0xd648, 0xd661, 0xd67a, 0xd693, 0xd6ac, 0xd6c5, 0xd6de,
	0xd6f7, 0xd710, 0xd729, 0xd746, 0xd763, 0xd780, 0xd79d, 0xd7ba,
	0xd7d7, 0xd7f4, 0xd811, 0xd82e, 0xd84b, 0xd868, 0xd885, 0xd8a2,
	0xd8bf, 0xd8dc, 0xd8f9, 0xd916, 0xd933, 0xd950, 0xd96d, 0xd98a,
	0xd9a7, 0xd9c4, 0xd9e1, 0xd9fe, 0xda1b, 0xda36, 0xda51, 0xda6c,
	0xda87, 0xdaa2, 0xdabd, 0xdad8, 0xdaf3, 0xdb0e, 0xdb29, 0xdb44,
	0xdb5f, 0xdb7a, 0xdb95, 0xdbb0, 0xdbcb, 0xdbe6, 0xdc01, 0xdc1c,
	// Entry 6440 - 647F
	0xdc37, 0xdc52, 0xdc6d, 0xdc88, 0xdca3, 0xdcbe, 0xdce0, 0xdd02,
	0xdd24, 0xdd46, 0xdd68, 0xdd8a, 0xddac, 0xddce, 0xddf0, 0xde12,
	0xde34, 0xde56, 0xde78, 0xde9a, 0xdebc, 0xdede, 0xdf00, 0xdf22,
	0xdf44, 0xdf66, 0xdf88, 0xdfaa, 0xdfcc, 0xdfee, 0xe010, 0xe032,
	0xe052, 0xe072, 0xe092, 0xe0b2, 0xe0d2, 0xe0f2, 0xe112, 0xe132,
	0xe152, 0xe172, 0xe192, 0xe1b2, 0xe1d2, 0xe1f2, 0xe212, 0xe232,
	0xe252, 0xe272, 0xe292, 0xe2b2, 0xe2d2, 0xe2f2, 0xe312, 0xe332,
	0xe352, 0xe372, 0xe38f, 0xe3ac, 0xe3c9, 0xe3e6, 0xe403, 0xe420,
	// Entry 6480 - 64BF
	0xe43d, 0xe45a, 0xe477, 0xe494, 0xe4b1, 0xe4ce, 0xe4eb, 0xe508,
	0xe525, 0xe542, 0xe55f, 0xe57c, 0xe597, 0xe5b2, 0xe5cd, 0xe5e8,
	0xe603, 0xe61e, 0xe639, 0xe654, 0xe66f, 0xe68a, 0xe6a5, 0xe6c0,
	0xe6db, 0xe6f6, 0xe711, 0xe72c, 0xe747, 0xe762, 0xe77d, 0xe798,
	0xe7b3, 0xe7ce, 0xe7e9, 0xe80b, 0xe82d, 0xe84f, 0xe871, 0xe893,
	0xe8b5, 0xe8d7, 0xe8f9, 0xe91b, 0xe93d, 0xe95f, 0xe981, 0xe9a3,
	0xe9c5, 0xe9e7, 0xea09, 0xea2b, 0xea4d, 0xea6f, 0xea91, 0xeab3,
	0xead5, 0xeaf7, 0xeb19, 0xeb3b, 0xeb5d, 0xeb7d, 0xeb9d, 0xebbd,
	// Entry 64C0 - 64FF
	0xebdd, 0xebfd, 0xec1d, 0xec3d, 0xec5d, 0xec7d, 0xec9d, 0xecbd,
	0xecdd, 0xecfd, 0xed1d, 0xed3d, 0xed5d, 0xed7d, 0xed9d, 0xedbd,
	0xeddd, 0xedfd, 0xee1d, 0xee3d, 0xee5d, 0xee7d, 0xee9d, 0xeebb,
	0xeed9, 0xeef7, 0xef15, 0xef33, 0xef51, 0xef6f, 0xef8d, 0xefab,
	0xefc9, 0xefe7, 0xf005, 0xf023, 0xf041, 0xf05f, 0xf07d, 0xf09b,
	0xf0b9, 0xf0d7, 0xf0f5, 0xf113, 0xf12f, 0xf14b, 0xf167, 0xf183,
	0xf19f, 0xf1bb, 0xf1d7, 0xf1f3, 0xf20f, 0xf22b, 0xf247, 0xf263,
	0xf27f, 0xf29b, 0xf2b7, 0xf2d3, 0xf2ef, 0xf30b, 0xf327, 0xf343,
	// Entry 6500 - 653F
	0xf35f, 0xf37b, 0xf397, 0xf3b3, 0xf3cf, 0xf3eb, 0xf40f, 0xf433,
	0xf457, 0xf47b, 0xf49f, 0xf4c3, 0xf4e7, 0xf50b, 0xf52f, 0xf553,
	0xf577, 0xf59b, 0xf5bf, 0xf5e3, 0xf607, 0xf62b, 0xf64f, 0xf673,
	0xf697, 0xf6b9, 0xf6db, 0xf6fd, 0xf71f, 0xf741, 0xf763, 0xf785,
	0xf7a7, 0xf7c9, 0xf7eb, 0xf80d, 0xf82f, 0xf851, 0xf873, 0xf895,
	0xf8b7, 0xf8d9, 0xf8fb, 0xf91d, 0xf93f, 0xf961, 0xf983, 0xf9a5,
	0xf9c7, 0xf9e9, 0xfa0b, 0xfa2e, 0xfa51, 0xfa74, 0xfa97, 0xfaba,
	0xfadd, 0xfb00, 0xfb23, 0xfb46, 0xfb69, 0xfb8c, 0xfbaf, 0xfbd2,
	// Entry 6540 - 657F
	0xfbf5, 0xfc18, 0xfc3b, 0xfc5e, 0xfc81, 0xfca4, 0xfcc7, 0xfcea,
	0xfd0d, 0xfd30, 0xfd53, 0xfd76, 0xfd99, 0xfdba, 0xfddb, 0xfdfc,
	0xfe1d, 0xfe3e, 0xfe5f, 0xfe80, 0xfea1, 0xfec2, 0xfee3, 0xff04,
	0xff25, 0xff46, 0xff67, 0xff88, 0xffa9, 0xffca, 0xffeb, 0x000c,
	0x002d, 0x004e, 0x006f, 0x0090, 0x00b1, 0x00d2, 0x00f3, 0x0114,
	0x0135, 0x0156, 0x0177, 0x0198, 0x01b9, 0x01da, 0x01fb, 0x021c,
	0x023d, 0x025e, 0x027f, 0x02a0, 0x02c1, 0x02e2, 0x0303, 0x0324,
	0x0345, 0x0366, 0x0387, 0x03a8, 0x03c9, 0x03ea, 0x040b, 0x042c,
	// Entry 6580 - 65BF
	0x044d, 0x046c, 0x048b, 0x04aa, 0x04c9, 0x04e8, 0x0507, 0x0526,
	0x0545, 0x0564, 0x0583, 0x05a2, 0x05c1, 0x05e0, 0x05ff, 0x061e,
	0x063d, 0x065c, 0x067b, 0x069a, 0x06b9, 0x06d8, 0x06f7, 0x0716,
	0x0735, 0x0754, 0x0773, 0x0799, 0x07bf, 0x07e5, 0x080b, 0x0831,
	0x0857, 0x087d, 0x08a3, 0x08c9, 0x08ef, 0x0915, 0x093b, 0x0961,
	0x0987, 0x09ad, 0x09d3, 0x09f9, 0x0a1f, 0x0a45, 0x0a6b, 0x0a91,
	0x0ab7, 0x0add, 0x0b03, 0x0b29, 0x0b4f, 0x0b73, 0x0b97, 0x0bbb,
	0x0bdf, 0x0c03, 0x0c27, 0x0c4b, 0x0c6f, 0x0c93, 0x0cb7, 0x0cdb,
	// Entry 65C0 - 65FF
	0x0cff, 0x0d23, 0x0d47, 0x0d6b, 0x0d8f, 0x0db3, 0x0dd7, 0x0dfb,
	0x0e1f, 0x0e43, 0x0e67, 0x0e8b, 0x0eaf, 0x0ed3, 0x0ef7, 0x0f1f,
	0x0f47, 0x0f6f, 0x0f97, 0x0fbf, 0x0fe7, 0x100f, 0x1037, 0x105f,
	0x1087, 0x10af, 0x10d7, 0x10ff, 0x1127, 0x114f, 0x1177, 0x119f,
	0x11c7, 0x11ef, 0x1217, 0x123f, 0x1267, 0x128f, 0x12b7, 0x12df,
	0x1307, 0x132d, 0x1353, 0x1379, 0x139f, 0x13c5, 0x13eb, 0x1411,
	0x1437, 0x145d, 0x1483, 0x14a9, 0x14cf, 0x14f5, 0x151b, 0x1541,
	0x1567, 0x158d, 0x15b3, 0x15d9, 0x15ff, 0x1625, 0x164b, 0x1671,
	// Entry 6600 - 663F
	0x1697, 0x16bd, 0x16e3, 0x1710, 0x173d, 0x176a, 0x1797, 0x17c4,
	0x17f1, 0x181e, 0x184b, 0x1878, 0x18a5, 0x18d2, 0x18ff, 0x192c,
	0x1959, 0x1986, 0x19b3, 0x19e0, 0x1a0d, 0x1a3a, 0x1a67, 0x1a94,
	0x1ac1, 0x1aee, 0x1b1b, 0x1b48, 0x1b75, 0x1ba0, 0x1bcb, 0x1bf6,
	0x1c21, 0x1c4c, 0x1c77, 0x1ca2, 0x1ccd, 0x1cf8, 0x1d23, 0x1d4e,
	0x1d79, 0x1da4, 0x1dcf, 0x1dfa, 0x1e25, 0x1e50, 0x1e7b, 0x1ea6,
	0x1ed1, 0x1efc, 0x1f27, 0x1f52, 0x1f7d, 0x1fa8, 0x1fd3, 0x1ff3,
	0x2013, 0x2033, 0x2053, 0x2073, 0x2093, 0x20b3, 0x20d3, 0x20f3,
	// Entry 6640 - 667F
	0x2113, 0x2133, 0x2153, 0x2173, 0x2193, 0x21b3, 0x21d3, 0x21f3,
	0x2213, 0x2233, 0x2253, 0x2273, 0x2293, 0x22b3, 0x22d3, 0x22f3,
	0x2313, 0x2331, 0x234f, 0x236d, 0x238b, 0x23a9, 0x23c7, 0x23e5,
	0x2403, 0x2421, 0x243f, 0x245d, 0x247b, 0x2499, 0x24b7, 0x24d5,
	0x24f3, 0x2511, 0x252f, 0x254d, 0x256b, 0x2589, 0x25a7, 0x25c5,
	0x25e3, 0x2601, 0x261f, 0x2642, 0x2665, 0x2684, 0x26a2, 0x26c1,
	0x26e0, 0x2701, 0x271f, 0x273c, 0x275b, 0x2779, 0x2798, 0x27b7,
	0x27d3, 0x27ef, 0x280b, 0x282c, 0x2848, 0x2865, 0x288b, 0x28aa,
	// Entry 6680 - 66BF
	0x28c7, 0x28e8, 0x2905, 0x2922, 0x293f, 0x295e, 0x2975, 0x2992,
	0x29ae, 0x29cb, 0x29e8, 0x2a07, 0x2a23, 0x2a3e, 0x2a5b, 0x2a77,
	0x2a94, 0x2ab1, 0x2acb, 0x2ae5, 0x2aff, 0x2b1e, 0x2b38, 0x2b53,
	0x2b76, 0x2b93, 0x2bae, 0x2bcd, 0x2be8, 0x2c03, 0x2c1e, 0x2c3b,
	0x2c61, 0x2c81, 0x2c9f, 0x2cbd, 0x2cd9, 0x2cf5, 0x2d10, 0x2d31,
	0x2d51, 0x2d72, 0x2d93, 0x2db6, 0x2dd6, 0x2df5, 0x2e16, 0x2e36,
	0x2e57, 0x2e78, 0x2e96, 0x2eb4, 0x2ed2, 0x2ef5, 0x2f13, 0x2f32,
	0x2f5a, 0x2f7b, 0x2f9a, 0x2fbd, 0x2fdc, 0x2ffb, 0x301a, 0x303b,
	// Entry 66C0 - 66FF
	0x3054, 0x3073, 0x3091, 0x30b0, 0x30cf, 0x30f0, 0x310e, 0x312b,
	0x314a, 0x3168, 0x3187, 0x31a6, 0x31c2, 0x31de, 0x31fa, 0x321b,
	0x3237, 0x3254, 0x3279, 0x3298, 0x32b5, 0x32d6, 0x32f3, 0x3310,
	0x332d, 0x334c, 0x3374, 0x3396, 0x33b6, 0x33d6, 0x33f4, 0x3412,
	0x342f, 0x3455, 0x347a, 0x34a0, 0x34c6, 0x34ee, 0x3513, 0x3537,
	0x355d, 0x3582, 0x35a8, 0x35ce, 0x35f1, 0x3614, 0x3637, 0x365f,
	0x3682, 0x36a6, 0x36d3, 0x36f9, 0x371d, 0x3745, 0x3769, 0x378d,
	0x37b1, 0x37d7, 0x37f5, 0x3819, 0x383c, 0x3860, 0x3884, 0x38aa,
	// Entry 6700 - 673F
	0x38cd, 0x38ef, 0x3913, 0x3936, 0x395a, 0x397e, 0x399f, 0x39c0,
	0x39e1, 0x3a07, 0x3a28, 0x3a4a, 0x3a74, 0x3a98, 0x3aba, 0x3ae0,
	0x3b02, 0x3b24, 0x3b46, 0x3b6a, 0x3b97, 0x3bbe, 0x3be3, 0x3c08,
	0x3c2b, 0x3c4e, 0x3c70, 0x3c9a, 0x3cc3, 0x3ced, 0x3d17, 0x3d43,
	0x3d6c, 0x3d94, 0x3dbe, 0x3de7, 0x3e11, 0x3e3b, 0x3e62, 0x3e89,
	0x3eb0, 0x3edc, 0x3f03, 0x3f2b, 0x3f5c, 0x3f86, 0x3fae, 0x3fda,
	0x4002, 0x402a, 0x4052, 0x407c, 0x409e, 0x40c6, 0x40ed, 0x4115,
	0x413d, 0x4167, 0x418e, 0x41b4, 0x41dc, 0x4203, 0x422b, 0x4253,
	// Entry 6740 - 677F
	0x4278, 0x429d, 0x42c2, 0x42ec, 0x4311, 0x4337, 0x4365, 0x438d,
	0x43b3, 0x43dd, 0x4403, 0x4429, 0x444f, 0x4477, 0x44a8, 0x44d3,
	0x44fc, 0x4525, 0x454c, 0x4573, 0x4599, 0x45ca, 0x45fa, 0x462b,
	0x465c, 0x468f, 0x46bf, 0x46ee, 0x471f, 0x474f, 0x4780, 0x47b1,
	0x47df, 0x480d, 0x483b, 0x486e, 0x489c, 0x48cb, 0x4903, 0x4934,
	0x4963, 0x4996, 0x49c5, 0x49f4, 0x4a23, 0x4a54, 0x4a7d, 0x4aac,
	0x4ada, 0x4b09, 0x4b38, 0x4b69, 0x4b97, 0x4bc4, 0x4bf3, 0x4c21,
	0x4c50, 0x4c7f, 0x4cab, 0x4cd7, 0x4d03, 0x4d34, 0x4d60, 0x4d8d,
	// Entry 6780 - 67BF
	0x4dc2, 0x4df1, 0x4e1e, 0x4e4f, 0x4e7c, 0x4ea9, 0x4ed6, 0x4f05,
	0x4f3d, 0x4f6f, 0x4f9f, 0x4fcf, 0x4ffd, 0x502b, 0x5058, 0x5079,
	0x5098, 0x50b4, 0x50cf, 0x50ea, 0x5107, 0x5123, 0x513f, 0x515a,
	0x5177, 0x5194, 0x51b0, 0x51d5, 0x51f9, 0x521d, 0x5243, 0x5268,
	0x528d, 0x52b1, 0x52d7, 0x52fd, 0x5322, 0x5344, 0x5365, 0x5386,
	0x53a9, 0x53cb, 0x53ed, 0x540e, 0x5431, 0x5454, 0x5476, 0x549d,
	0x54c3, 0x54e9, 0x5511, 0x5538, 0x555f, 0x5585, 0x55ad, 0x55d5,
	0x55fc, 0x561d, 0x563d, 0x565d, 0x567f, 0x56a0, 0x56c1, 0x56e1,
	// Entry 67C0 - 67FF
	0x5703, 0x5725, 0x5746, 0x5761, 0x577e, 0x5798, 0x57b3, 0x57cf,
	0x57eb, 0x580b, 0x582d, 0x5859, 0x5883, 0x58a5, 0x58c7, 0x58ed,
	0x5910, 0x5932, 0x5956, 0x597d, 0x59af, 0x59d8, 0x5a04, 0x5a30,
	0x5a5c, 0x5a93, 0x5acb, 0x5afe, 0x5b31, 0x5b5b, 0x5b87, 0x5bb3,
	0x5bdf, 0x5c07, 0x5c31, 0x5c67, 0x5c9d, 0x5cca, 0x5d05, 0x5d3c,
	0x5d78, 0x5daf, 0x5de9, 0x5e18, 0x5e48, 0x5e77, 0x5ea6, 0x5edf,
	0x5f16, 0x5f57, 0x5f93, 0x5fc5, 0x5ff7, 0x6035, 0x606a, 0x60a4,
	0x60e5, 0x6117, 0x6149, 0x617c, 0x61b3, 0x61e9, 0x621e, 0x6251,
	// Entry 6800 - 683F
	0x628a, 0x62bd, 0x62ec, 0x6322, 0x635d, 0x638f, 0x63c5, 0x63e7,
	0x640e, 0x6437, 0x6463, 0x6495, 0x64c1, 0x64f2, 0x651f, 0x6548,
	0x6576, 0x65a9, 0x65e1, 0x660f, 0x6642, 0x6679, 0x66a1, 0x66ce,
	0x66fd, 0x6726, 0x6756, 0x6791, 0x67ca, 0x67df, 0x6809, 0x6823,
	0x6843, 0x6868, 0x6888, 0x68ab, 0x68d7, 0x68f9, 0x6926, 0x6958,
	0x697a, 0x698f, 0x69af, 0x69cd, 0x69f0, 0x6a0e, 0x6a23, 0x6a3c,
	0x6a50, 0x6a74, 0x6a93, 0x6ab5, 0x6ad2, 0x6af9, 0x6b1b, 0x6b39,
	0x6b52, 0x6b69, 0x6b7e, 0x6b9e, 0x6bbc, 0x6bdf, 0x6bfa, 0x6c23,
	// Entry 6840 - 687F
	0x6c39, 0x6c55, 0x6c7b, 0x6c9c, 0x6cc0, 0x6cdf, 0x6d0f, 0x6d3f,
	0x6d55, 0x6d7c, 0x6da5, 0x6dcd, 0x6df5, 0x6e12, 0x6e3e, 0x6e6f,
	0x6ea1, 0x6ec2, 0x6ef3, 0x6f22, 0x6f52, 0x6f71, 0x6f9c, 0x6fbd,
	0x6fdc, 0x6ffc, 0x7027, 0x7048, 0x7072, 0x7094, 0x70b7, 0x70df,
	0x7108, 0x7141, 0x7176, 0x7198, 0x71bc, 0x71df, 0x7202, 0x722b,
	0x7256, 0x7280, 0x729b, 0x72c5, 0x72f4, 0x7325, 0x7344, 0x737c,
	0x73b5, 0x73d2, 0x73fb, 0x741c, 0x743f, 0x7460, 0x7482, 0x74a3,
	0x74ce, 0x74ff, 0x751f, 0x753f, 0x755f, 0x7586, 0x75af, 0x75dd,
	// Entry 6880 - 68BF
	0x7608, 0x7632, 0x765f, 0x7685, 0x76ad, 0x76d9, 0x7701, 0x7722,
	0x773f, 0x775e, 0x777f, 0x77aa, 0x77d4, 0x77f6, 0x781f, 0x7842,
	0x786a, 0x7894, 0x78c3, 0x78ea, 0x7913, 0x7940, 0x796c, 0x7995,
	0x79c4, 0x79f6, 0x7a2d, 0x7a63, 0x7a98, 0x7aca, 0x7aed, 0x7b13,
	0x7b3a, 0x7b6f, 0x7ba5, 0x7bd6, 0x7c07, 0x7c37, 0x7c69, 0x7ca1,
	0x7cd5, 0x7cfb, 0x7d25, 0x7d59, 0x7d8d, 0x7dc0, 0x7de8, 0x7e08,
	0x7e2d, 0x7e54, 0x7e7c, 0x7e9e, 0x7ec6, 0x7eec, 0x7f11, 0x7f33,
	0x7f4e, 0x7f6e, 0x7f97, 0x7fc1, 0x7fe6, 0x8009, 0x8039, 0x8068,
	// Entry 68C0 - 68FF
	0x8097, 0x80c4, 0x80f0, 0x811f, 0x814d, 0x8182, 0x8197, 0x81b1,
	0x81c9, 0x81e3, 0x81fc, 0x8214, 0x822e, 0x8247, 0x8260, 0x827b,
	0x8295, 0x82ad, 0x82c7, 0x82e0, 0x82f6, 0x830e, 0x8325, 0x8340,
	0x835b, 0x837b, 0x839b, 0x83bd, 0x83df, 0x83fd, 0x841b, 0x8439,
	0x8459, 0x8479, 0x8495, 0x84ba, 0x84e2, 0x850a, 0x8532, 0x855c,
	0x8590, 0x85c4, 0x85f4, 0x8621, 0x864f, 0x8683, 0x86b8, 0x86ec,
	0x8722, 0x8752, 0x8780, 0x87b0, 0x87e1, 0x881d, 0x8841, 0x8878,
	0x88a8, 0x88d9, 0x8915, 0x893e, 0x8968, 0x8991, 0x89bc, 0x89e8,
	// Entry 6900 - 693F
	0x8a13, 0x8a41, 0x8a6b, 0x8a96, 0x8ac0, 0x8ae8, 0x8b11, 0x8b39,
	0x8b64, 0x8b90, 0x8bbb, 0x8be5, 0x8c10, 0x8c3a, 0x8c70, 0x8ca6,
	0x8ce1, 0x8d18, 0x8d4f, 0x8d8b, 0x8daf, 0x8ddd, 0x8e0b, 0x8e39,
	0x8e61, 0x8e8a, 0x8eb2, 0x8edc, 0x8f07, 0x8f33, 0x8f5e, 0x8f8b,
	0x8fbb, 0x8fec, 0x901c, 0x904e, 0x9081, 0x90b5, 0x90e8, 0x911d,
	0x9152, 0x9188, 0x91bd, 0x91f4, 0x9225, 0x9254, 0x9285, 0x92b7,
	0x92f4, 0x9319, 0x9351, 0x9382, 0x93bd, 0x93fa, 0x941e, 0x944a,
	0x9477, 0x94a3, 0x94c8, 0x94f1, 0x951b, 0x9544, 0x9570, 0x959d,
	// Entry 6940 - 697F
	0x95c9, 0x95f4, 0x9620, 0x964b, 0x9683, 0x96bb, 0x96f8, 0x972f,
	0x9766, 0x97a2, 0x97c7, 0x97f9, 0x982c, 0x985e, 0x9892, 0x98c8,
	0x98ff, 0x9935, 0x996d, 0x99ac, 0x99ec, 0x9a15, 0x9a3f, 0x9a68,
	0x9a91, 0x9abb, 0x9ae4, 0x9b14, 0x9b4a, 0x9b81, 0x9bb7, 0x9bed,
	0x9c24, 0x9c5a, 0x9c8c, 0x9cbd, 0x9cef, 0x9d14, 0x9d39, 0x9d61,
	0x9d87, 0x9dbe, 0x9df4, 0x9e2a, 0x9e60, 0x9e98, 0x9ed0, 0x9f0d,
	0x9f3f, 0x9f70, 0x9fa1, 0x9fd2, 0xa005, 0xa038, 0xa070, 0xa0a7,
	0xa0df, 0xa116, 0xa151, 0xa18c, 0xa1cd, 0xa20e, 0xa24f, 0xa290,
	// Entry 6980 - 69BF
	0xa2d1, 0xa312, 0xa353, 0xa394, 0xa3ce, 0xa408, 0xa43e, 0xa474,
	0xa4af, 0xa4e8, 0xa521, 0xa560, 0xa59f, 0xa5e5, 0xa62b, 0xa66a,
	0xa6a9, 0xa6e8, 0xa727, 0xa75f, 0xa797, 0xa7cb, 0xa7ff, 0xa838,
	0xa863, 0xa88f, 0xa8ba, 0xa8e7, 0xa915, 0xa93f, 0xa969, 0xa993,
	0xa9bd, 0xa9e7, 0xaa0d, 0xaa33, 0xaa5e, 0xaa8e, 0xaac4, 0xaafb,
	0xab31, 0xab68, 0xabac, 0xabf1, 0xac35, 0xac79, 0xacbe, 0xad02,
	0xad3a, 0xad72, 0xadb2, 0xadf2, 0xae26, 0xae5a, 0xae9c, 0xaede,
	0xaf01, 0xaf24, 0xaf3c, 0xaf54, 0xaf6d, 0xaf88, 0xafa8, 0xafd4,
	// Entry 69C0 - 69FF
	0xaff8, 0xb013, 0xb023, 0xb037, 0xb063, 0xb08b, 0xb0b8, 0xb0e1,
	0xb10b, 0xb12b, 0xb163, 0xb196, 0xb1d1, 0xb1f1, 0xb216, 0xb238,
	0xb260, 0xb288, 0xb2ae, 0xb2d4, 0xb2f0, 0xb30c, 0xb329, 0xb33e,
	0xb357, 0xb36e, 0xb38a, 0xb3a8, 0xb3c2, 0xb3dc, 0xb3f8, 0xb41a,
	0xb42e, 0xb446, 0xb460, 0xb480, 0xb4a6, 0xb4d3, 0xb505, 0xb52c,
	0xb55a, 0xb58d, 0xb5b1, 0xb5d6, 0xb5fc, 0xb615, 0xb62f, 0xb648,
	0xb665, 0xb684, 0xb6a0, 0xb6b0, 0xb6c8, 0xb6e0, 0xb6f9, 0xb711,
	0xb72c, 0xb746, 0xb76a, 0xb78e, 0xb7a7, 0xb7c0, 0xb7e0, 0xb800,
	// Entry 6A00 - 6A3F
	0xb820, 0xb837, 0xb857, 0xb873, 0xb88a, 0xb8aa, 0xb8c6, 0xb8e3,
	0xb901, 0xb920, 0xb93b, 0xb95f, 0xb97f, 0xb99f, 0xb9c8, 0xb9ed,
	0xba03, 0xba21, 0xba40, 0xba57, 0xba76, 0xba94, 0xbab5, 0xbad5,
	0xbaf5, 0xbb0e, 0xbb2f, 0xbb50, 0xbb73, 0xbb92, 0xbbb5, 0xbbe1,
	0xbc08, 0xbc2e, 0xbc54, 0xbc7a, 0xbc8b, 0xbca5, 0xbcc0, 0xbce4,
	0xbcfd, 0xbd1f, 0xbd3a, 0xbd5c, 0xbd7f, 0xbd8f, 0xbd9f, 0xbdb5,
	0xbdd3, 0xbdf5, 0xbe1c, 0xbe44, 0xbe6b, 0xbe97, 0xbebe, 0xbee3,
	0xbf11, 0xbf2d, 0xbf46, 0xbf5f, 0xbf78, 0xbf91, 0xbfaa, 0xbfc3,
	// Entry 6A40 - 6A7F
	0xbfdc, 0xbfee, 0xc012, 0xc037, 0xc052, 0xc06c, 0xc086, 0xc0a4,
	0xc0be, 0xc0df, 0xc0f0, 0xc105, 0xc11a, 0xc12b, 0xc142, 0xc15d,
	0xc178, 0xc193, 0xc1ae, 0xc1c9, 0xc1e8, 0xc207, 0xc226, 0xc245,
	0xc264, 0xc283, 0xc2a2, 0xc2c1, 0xc2e1, 0xc301, 0xc321, 0xc341,
	0xc361, 0xc381, 0xc3a1, 0xc3c0, 0xc3e0, 0xc400, 0xc423, 0xc444,
	0xc465, 0xc488, 0xc4aa, 0xc4ca, 0xc4f2, 0xc50f, 0xc531, 0xc551,
	0xc574, 0xc597, 0xc5b8, 0xc5d7, 0xc5f9, 0xc61a, 0xc63b, 0xc65d,
	0xc67c, 0xc69d, 0xc6bd, 0xc6dd, 0xc6fc, 0xc71e, 0xc73d, 0xc75d,
	// Entry 6A80 - 6ABF
	0xc77d, 0xc79d, 0xc7bb, 0xc7e0, 0xc7fe, 0xc82b, 0xc84e, 0xc879,
	0xc899, 0xc8b7, 0xc8d5, 0xc8f3, 0xc912, 0xc930, 0xc94f, 0xc96d,
	0xc98c, 0xc9aa, 0xc9c8, 0xc9e6, 0xca05, 0xca23, 0xca42, 0xca60,
	0xca7f, 0xca9e, 0xcabd, 0xcadc, 0xcafb, 0xcb1a, 0xcb39, 0xcb58,
	0xcb77, 0xcb96, 0xcbb6, 0xcbd6, 0xcbf4, 0xcc12, 0xcc30, 0xcc4f,
	0xcc6d, 0xcc8c, 0xccaa, 0xccc7, 0xcce4, 0xcd01, 0xcd1f, 0xcd3c,
	0xcd5a, 0xcd77, 0xcd95, 0xcdb3, 0xcdd1, 0xcdef, 0xce0d, 0xce2b,
	0xce49, 0xce67, 0xce86, 0xcea4, 0xcec3, 0xcee1, 0xcf00, 0xcf1e,
	// Entry 6AC0 - 6AFF
	0xcf3c, 0xcf5a, 0xcf79, 0xcf97, 0xcfb6, 0xcfd4, 0xcff7, 0xd015,
	0xd033, 0xd051, 0xd070, 0xd08f, 0xd0ad, 0xd0cb, 0xd0e9, 0xd107,
	0xd126, 0xd144, 0xd163, 0xd181, 0xd19f, 0xd1bd, 0xd1db, 0xd1fa,
	0xd218, 0xd237, 0xd255, 0xd278, 0xd296, 0xd2b4, 0xd2d2, 0xd2f1,
	0xd30f, 0xd32e, 0xd34c, 0xd36a, 0xd388, 0xd3a6, 0xd3c5, 0xd3e3,
	0xd402, 0xd420, 0xd43f, 0xd45e, 0xd47d, 0xd49c, 0xd4bb, 0xd4da,
	0xd4f9, 0xd517, 0xd535, 0xd553, 0xd572, 0xd590, 0xd5af, 0xd5cd,
	0xd5ed, 0xd60d, 0xd62c, 0xd64b, 0xd66a, 0xd689, 0xd6a8, 0xd6c8,
	// Entry 6B00 - 6B3F
	0xd6e8, 0xd708, 0xd728, 0xd749, 0xd769, 0xd78a, 0xd7aa, 0xd7cb,
	0xd7ec, 0xd811, 0xd837, 0xd85c, 0xd87a, 0xd898, 0xd8b6, 0xd8d5,
	0xd8f5, 0xd915, 0xd935, 0xd955, 0xd976, 0xd994, 0xd9b2, 0xd9d0,
	0xd9ef, 0xda0d, 0xda2c, 0xda4a, 0xda69, 0xda88, 0xdaa7, 0xdac7,
	0xdae7, 0xdb06, 0xdb26, 0xdb45, 0xdb65, 0xdb89, 0xdbae, 0xdbd2,
	0xdbf1, 0xdc10, 0xdc2f, 0xdc4f, 0xdc6e, 0xdc8e, 0xdcad, 0xdccc,
	0xdceb, 0xdd0a, 0xdd2a, 0xdd49, 0xdd69, 0xdd88, 0xdda6, 0xddc5,
	0xdde4, 0xde03, 0xde23, 0xde42, 0xde62, 0xde81, 0xdea0, 0xdebf,
	// Entry 6B40 - 6B7F
	0xdedf, 0xdeff, 0xdf1d, 0xdf3b, 0xdf59, 0xdf78, 0xdf96, 0xdfb5,
	0xdfd3, 0xdff3, 0xe013, 0xe033, 0xe053, 0xe073, 0xe08a, 0xe0a1,
	0xe0ba, 0xe0d2, 0xe0ea, 0xe101, 0xe11a, 0xe133, 0xe14b, 0xe16f,
	0xe192, 0xe1b9, 0xe1e1, 0xe20d, 0xe23d, 0xe264, 0xe27d, 0xe297,
	0xe2b0, 0xe2c9, 0xe2e0, 0xe2ff, 0xe316, 0xe32e, 0xe345, 0xe35b,
	0xe372, 0xe388, 0xe39e, 0xe3b6, 0xe3ce, 0xe3e6, 0xe3fe, 0xe416,
	0xe42d, 0xe443, 0xe45c, 0xe474, 0xe48b, 0xe4a4, 0xe4bb, 0xe4d3,
	0xe4ea, 0xe502, 0xe519, 0xe531, 0xe549, 0xe561, 0xe579, 0xe591,
	// Entry 6B80 - 6BBF
	0xe5a8, 0xe5c0, 0xe5d7, 0xe5ee, 0xe603, 0xe620, 0xe635, 0xe64b,
	0xe660, 0xe674, 0xe689, 0xe69d, 0xe6b1, 0xe6c7, 0xe6dd, 0xe6f3,
	0xe709, 0xe71f, 0xe734, 0xe748, 0xe75f, 0xe775, 0xe78a, 0xe7a1,
	0xe7b6, 0xe7cc, 0xe7e1, 0xe7f7, 0xe80c, 0xe822, 0xe838, 0xe84e,
	0xe864, 0xe87a, 0xe88f, 0xe8a5, 0xe8ba, 0xe8c5, 0xe8dd, 0xe8fe,
	0xe909, 0xe919, 0xe928, 0xe937, 0xe948, 0xe958, 0xe968, 0xe977,
	0xe988, 0xe999, 0xe9a9, 0xe9c7, 0xe9e2, 0xe9fa, 0xea11, 0xea29,
	0xea40, 0xea57, 0xea6f, 0xea86, 0xea9d, 0xeab4, 0xeacb, 0xeae2,
	// Entry 6BC0 - 6BFF
	0xeafa, 0xeb12, 0xeb2a, 0xeb41, 0xeb58, 0xeb6f, 0xeb86, 0xeb9d,
	0xebb6, 0xebcd, 0xebe5, 0xebfd, 0xec15, 0xec2c, 0xec43, 0xec5c,
	0xec7b, 0xec9b, 0xecba, 0xecd9, 0xecf8, 0xed18, 0xed37, 0xed56,
	0xed75, 0xed94, 0xedb3, 0xedd3, 0xedf3, 0xee13, 0xee32, 0xee51,
	0xee70, 0xee8f, 0xeeb0, 0xeecf, 0xeeef, 0xef0f, 0xef2e, 0xef4f,
	0xef6e, 0xef8c, 0xefaa, 0xefc8, 0xefe7, 0xf006, 0xf024, 0xf042,
	0xf060, 0xf080, 0xf09f, 0xf0bd, 0xf0dd, 0xf104, 0xf12a, 0xf14b,
	0xf16d, 0xf18e, 0xf1af, 0xf1d0, 0xf1f1, 0xf212, 0xf234, 0xf256,
	// Entry 6C00 - 6C3F
	0xf278, 0xf299, 0xf2ba, 0xf2db, 0xf2fc, 0xf31f, 0xf340, 0xf362,
	0xf384, 0xf3a5, 0xf3c6, 0xf3e9, 0xf412, 0xf43b, 0xf45a, 0xf478,
	0xf497, 0xf4b5, 0xf4d3, 0xf4f1, 0xf510, 0xf52e, 0xf54c, 0xf56a,
	0xf588, 0xf5a7, 0xf5c6, 0xf5e5, 0xf603, 0xf621, 0xf63f, 0xf65d,
	0xf67b, 0xf69b, 0xf6b9, 0xf6d8, 0xf6f7, 0xf716, 0xf734, 0xf752,
	0xf772, 0xf797, 0xf7bd, 0xf7e2, 0xf807, 0xf82d, 0xf852, 0xf877,
	0xf89c, 0xf8c1, 0xf8e7, 0xf90d, 0xf933, 0xf958, 0xf97d, 0xf9a2,
	0xf9c7, 0xf9ec, 0xfa13, 0xfa38, 0xfa5e, 0xfa84, 0xfaaa, 0xfacf,
	// Entry 6C40 - 6C7F
	0xfaf4, 0xfb1b, 0xfb52, 0xfb7b, 0xfb91, 0xfba8, 0xfbbe, 0xfbd5,
	0xfbec, 0xfc05, 0xfc1e, 0xfc3c, 0xfc5a, 0xfc7a, 0xfc99, 0xfcb8,
	0xfcd6, 0xfcf6, 0xfd16, 0xfd35, 0xfd50, 0xfd6b, 0xfd88, 0xfda4,
	0xfdc0, 0xfddb, 0xfdf8, 0xfe15, 0xfe31, 0xfe4c, 0xfe67, 0xfe84,
	0xfea0, 0xfebc, 0xfed7, 0xfef4, 0xff11, 0xff2d, 0xff3e, 0xff51,
	0xff64, 0xff7e, 0xff91, 0xffa4, 0xffb7, 0xffca, 0xffdc, 0xffed,
	0x0008, 0x0024, 0x0040, 0x005c, 0x0078, 0x0094, 0x00b0, 0x00cc,
	0x00e8, 0x0104, 0x0120, 0x013c, 0x0158, 0x0174, 0x0190, 0x01ac,
	// Entry 6C80 - 6CBF
	0x01c8, 0x01e4, 0x0200, 0x021c, 0x0238, 0x0254, 0x0270, 0x028c,
	0x02a8, 0x02c4, 0x02e0, 0x02fc, 0x0318, 0x0334, 0x0350, 0x036c,
	0x0388, 0x03a4, 0x03c0, 0x03dc, 0x03f8, 0x0414, 0x0430, 0x044c,
	0x0468, 0x0484, 0x04a0, 0x04bc, 0x04d8, 0x04f4, 0x0510, 0x052c,
	0x0548, 0x0564, 0x057d, 0x0597, 0x05b1, 0x05cb, 0x05e5, 0x05ff,
	0x0619, 0x0633, 0x064d, 0x0667, 0x0681, 0x069b, 0x06b5, 0x06cf,
	0x06e9, 0x0703, 0x071d, 0x0737, 0x0751, 0x076b, 0x0785, 0x079f,
	0x07b9, 0x07d3, 0x07ed, 0x0807, 0x0821, 0x083b, 0x0855, 0x086f,
	// Entry 6CC0 - 6CFF
	0x0889, 0x08a3, 0x08bd, 0x08d7, 0x08f1, 0x090b, 0x0925, 0x093f,
	0x0959, 0x0973, 0x098d, 0x09a7, 0x09c1, 0x09db, 0x09f5, 0x0a0f,
	0x0a29, 0x0a43, 0x0a5d, 0x0a77, 0x0a88, 0x0aa2, 0x0abc, 0x0ad8,
	0x0af3, 0x0b0e, 0x0b28, 0x0b44, 0x0b60, 0x0b7b, 0x0b95, 0x0bb0,
	0x0bcd, 0x0be9, 0x0c04, 0x0c1e, 0x0c38, 0x0c54, 0x0c6f, 0x0c8a,
	0x0ca4, 0x0cc0, 0x0cdc, 0x0cf7, 0x0d11, 0x0d2c, 0x0d49, 0x0d65,
	0x0d80, 0x0d96, 0x0db2, 0x0dce, 0x0dec, 0x0e09, 0x0e26, 0x0e42,
	0x0e60, 0x0e7e, 0x0e9b, 0x0eb7, 0x0ed4, 0x0ef3, 0x0f11, 0x0f2e,
	// Entry 6D00 - 6D3F
	0x0f46, 0x0f5f, 0x0f78, 0x0f93, 0x0fad, 0x0fc7, 0x0fe0, 0x0ffb,
	0x1016, 0x1030, 0x1049, 0x1063, 0x107f, 0x109a, 0x10b4, 0x10cc,
	0x10dd, 0x10f1, 0x1105, 0x1119, 0x112d, 0x1141, 0x1155, 0x1169,
	0x117d, 0x1191, 0x11a6, 0x11bb, 0x11d0, 0x11e5, 0x11fa, 0x120f,
	0x1224, 0x1239, 0x124e, 0x1263, 0x1278, 0x128d, 0x12a1, 0x12b1,
	0x12c0, 0x12cf, 0x12e0, 0x12f0, 0x1300, 0x130f, 0x1320, 0x1331,
	0x1341, 0x1366, 0x1394, 0x13b8, 0x13dc, 0x1400, 0x1424, 0x1448,
	0x146c, 0x1490, 0x14b4, 0x14d8, 0x14fc, 0x1520, 0x1544, 0x1568,
	// Entry 6D40 - 6D7F
	0x158c, 0x15b0, 0x15d4, 0x15f8, 0x161c, 0x1640, 0x1664, 0x1688,
	0x16ac, 0x16d0, 0x16f4, 0x1718, 0x173c, 0x176b, 0x1790, 0x17b5,
	0x17bf, 0x17c9, 0x17e7, 0x1805, 0x1823, 0x1841, 0x185f, 0x187d,
	0x189b, 0x18b9, 0x18d7, 0x18f5, 0x1913, 0x1931, 0x194f, 0x196d,
	0x198b, 0x19a9, 0x19c7, 0x19e5, 0x1a03, 0x1a21, 0x1a3f, 0x1a5d,
	0x1a7b, 0x1a99, 0x1ab7, 0x1ad5, 0x1adf, 0x1ae9, 0x1af3, 0x1afd,
	0x1b08, 0x1b12, 0x1b39, 0x1b60, 0x1b87, 0x1bae, 0x1bd5, 0x1bfc,
	0x1c23, 0x1c4a, 0x1c71, 0x1c98, 0x1cbf, 0x1ce6, 0x1d0d, 0x1d34,
	// Entry 6D80 - 6DBF
	0x1d5b, 0x1d82, 0x1da9, 0x1dd0, 0x1df7, 0x1e1e, 0x1e45, 0x1e6c,
	0x1e93, 0x1eba, 0x1ee1, 0x1f08, 0x1f16, 0x1f24, 0x1f4b, 0x1f72,
	0x1f99, 0x1fc0, 0x1fe7, 0x200e, 0x2035, 0x205c, 0x2083, 0x20aa,
	0x20d1, 0x20f8, 0x211f, 0x2146, 0x216d, 0x2194, 0x21bb, 0x21e2,
	0x2209, 0x2230, 0x2257, 0x227e, 0x22a5, 0x22cc, 0x22f3, 0x231a,
	0x2349, 0x235c, 0x236f, 0x2382, 0x2395, 0x23a8, 0x23b1, 0x23bb,
	0x23c7, 0x23d3, 0x23dd, 0x23e8, 0x23f2, 0x23fc, 0x2407, 0x2427,
	0x2431, 0x2440, 0x2455, 0x2462, 0x2470, 0x247f, 0x2495, 0x24ac,
	// Entry 6DC0 - 6DFF
	0x24c8, 0x24d7, 0x24f3, 0x250f, 0x2519, 0x2524, 0x2532, 0x2542,
	0x254d, 0x2558, 0x2563, 0x2585, 0x25a7, 0x25c9, 0x25eb, 0x260d,
	0x262f, 0x2651, 0x2673, 0x2695, 0x26b7, 0x26d9, 0x26fb, 0x271d,
	0x273f, 0x2761, 0x2783, 0x27a5, 0x27c7, 0x27e9, 0x280b, 0x282d,
	0x284f, 0x2871, 0x2893, 0x28b5, 0x28d7, 0x28eb, 0x2900, 0x2913,
	0x2935, 0x2957, 0x2979, 0x298c, 0x29ae, 0x29d0, 0x29f2, 0x2a14,
	0x2a36, 0x2a58, 0x2a7a, 0x2a9c, 0x2abe, 0x2ae0, 0x2b02, 0x2b24,
	0x2b46, 0x2b68, 0x2b8a, 0x2bac, 0x2bce, 0x2bf0, 0x2c12, 0x2c34,
	// Entry 6E00 - 6E3F
	0x2c56, 0x2c78, 0x2c9a, 0x2cbc, 0x2cde, 0x2d00, 0x2d22, 0x2d44,
	0x2d66, 0x2d88, 0x2daa, 0x2dcc, 0x2dee, 0x2e10, 0x2e32, 0x2e54,
	0x2e76, 0x2e98, 0x2eba, 0x2edc, 0x2f0f, 0x2f42, 0x2f75, 0x2fa8,
	0x2fdb, 0x300e, 0x3041, 0x3074, 0x30a7, 0x30c2, 0x30da, 0x30e1,
	0x30e6, 0x30f5, 0x3105, 0x311b, 0x3122, 0x3133, 0x3148, 0x314f,
	0x315e, 0x3168, 0x316f, 0x3178, 0x3191, 0x31a5, 0x31bf, 0x31d3,
	0x31e2, 0x31fd, 0x3216, 0x3230, 0x3240, 0x325a, 0x3272, 0x328d,
	0x329a, 0x32ac, 0x32c8, 0x32e3, 0x32f6, 0x3303, 0x330f, 0x331c,
	// Entry 6E40 - 6E7F
	0x3327, 0x3334, 0x333d, 0x3357, 0x336d, 0x338d, 0x339c, 0x33ab,
	0x33bf, 0x33d1, 0x33d4, 0x33e5, 0x33ec, 0x33f0, 0x33f7, 0x33ff,
	0x3407, 0x3415, 0x3423, 0x342c, 0x3432, 0x343c, 0x3441, 0x344f,
	0x3453, 0x345b, 0x3464, 0x346b, 0x3477, 0x3482, 0x3486, 0x3496,
	0x34a0, 0x34ab, 0x34c2, 0x34ca, 0x34d0, 0x34d9, 0x34df, 0x34e4,
	0x34ee, 0x34f7, 0x34fc, 0x3502, 0x350b, 0x3514, 0x351f, 0x3523,
	0x3528, 0x3530, 0x353a, 0x3543, 0x3551, 0x355d, 0x3568, 0x3574,
	0x357d, 0x3588, 0x3596, 0x35a3, 0x35ac, 0x35b1, 0x35bd, 0x35d1,
	// Entry 6E80 - 6EBF
	0x35d6, 0x35da, 0x35df, 0x35eb, 0x3606, 0x3614, 0x361e, 0x3627,
	0x362f, 0x3635, 0x3642, 0x3647, 0x364f, 0x3656, 0x365f, 0x3668,
	0x3671, 0x367c, 0x3683, 0x3691, 0x36a6, 0x36b9, 0x36c3, 0x36d1,
	0x36df, 0x36e7, 0x36f9, 0x3704, 0x371d, 0x3735, 0x373c, 0x3742,
	0x3751, 0x375e, 0x376c, 0x377a, 0x378a, 0x3793, 0x37a4, 0x37ab,
	0x37b7, 0x37c4, 0x37d1, 0x37de, 0x37ed, 0x37fb, 0x3808, 0x3812,
	0x3827, 0x3835, 0x3843, 0x385d, 0x386f, 0x387d, 0x388c, 0x38a7,
	0x38b8, 0x38c4, 0x38d1, 0x38ef, 0x390e, 0x3919, 0x392a, 0x3938,
	// Entry 6EC0 - 6EFF
	0x3944, 0x3952, 0x3967, 0x3971, 0x397d, 0x3983, 0x398c, 0x399a,
	0x39a1, 0x39ac, 0x39b2, 0x39bf, 0x39ce, 0x39d8, 0x39e2, 0x39ee,
	0x39f7, 0x39ff, 0x3a06, 0x3a1a, 0x3a26, 0x3a3c, 0x3a45, 0x3a4b,
	0x3a5b, 0x3a62, 0x3a68, 0x3a75, 0x3a8c, 0x3aa3, 0x3ab3, 0x3ac6,
	0x3ad4, 0x3adf, 0x3ae5, 0x3aeb, 0x3af7, 0x3afd, 0x3b09, 0x3b1a,
	0x3b28, 0x3b2f, 0x3b3c, 0x3b42, 0x3b53, 0x3b5d, 0x3b71, 0x3b7b,
	0x3b96, 0x3baf, 0x3bcb, 0x3bdf, 0x3be6, 0x3bf9, 0x3c0e, 0x3c1d,
	0x3c26, 0x3c3d, 0x3c4f, 0x3c55, 0x3c62, 0x3c6f, 0x3c76, 0x3c84,
	// Entry 6F00 - 6F3F
	0x3c95, 0x3ca4, 0x3cb8, 0x3ccc, 0x3cd4, 0x3cd8, 0x3cf0, 0x3cf5,
	0x3cff, 0x3d10, 0x3d16, 0x3d26, 0x3d2d, 0x3d3c, 0x3d4b, 0x3d5a,
	0x3d67, 0x3d74, 0x3d85, 0x3d96, 0x3d9d, 0x3daa, 0x3daf, 0x3dd0,
	0x3ddd, 0x3de4, 0x3e07, 0x3e28, 0x3e49, 0x3e6a, 0x3e8b, 0x3e8e,
	0x3e93, 0x3e95, 0x3ea2, 0x3ea5, 0x3eaa, 0x3eb1, 0x3eb7, 0x3eba,
	0x3ec0, 0x3ec9, 0x3ece, 0x3ed3, 0x3ed8, 0x3edd, 0x3ee0, 0x3ee4,
	0x3ee9, 0x3eef, 0x3ef6, 0x3efd, 0x3f00, 0x3f03, 0x3f07, 0x3f0f,
	0x3f16, 0x3f22, 0x3f25, 0x3f28, 0x3f30, 0x3f3b, 0x3f3f, 0x3f4c,
	// Entry 6F40 - 6F7F
	0x3f54, 0x3f5a, 0x3f68, 0x3f72, 0x3f89, 0x3f8d, 0x3f94, 0x3f99,
	0x3f9f, 0x3fae, 0x3fbc, 0x3fc3, 0x3fcd, 0x3fd5, 0x3fdf, 0x3fea,
	0x3ff2, 0x3ffd, 0x400b, 0x4015, 0x4020, 0x4028, 0x4030, 0x4039,
	0x4045, 0x404e, 0x4057, 0x4061, 0x4069, 0x4073, 0x407b, 0x407f,
	0x4082, 0x4085, 0x4089, 0x408e, 0x4094, 0x40b4, 0x40d6, 0x40f8,
	0x411b, 0x412b, 0x413b, 0x4147, 0x4155, 0x4165, 0x4178, 0x4187,
	0x418c, 0x4196, 0x41a0, 0x41a7, 0x41ae, 0x41b3, 0x41b8, 0x41be,
	0x41c4, 0x41d2, 0x41d7, 0x41de, 0x41e3, 0x41ec, 0x41f9, 0x4209,
	// Entry 6F80 - 6FBF
	0x4216, 0x4222, 0x422c, 0x423e, 0x4251, 0x4254, 0x4258, 0x425b,
	0x4260, 0x4266, 0x4281, 0x4296, 0x42ad, 0x42bb, 0x42d0, 0x42df,
	0x42f5, 0x4308, 0x4317, 0x4320, 0x432b, 0x432f, 0x4342, 0x434a,
	0x4357, 0x4366, 0x436b, 0x4375, 0x438b, 0x4398, 0x439b, 0x43a0,
	0x43b7, 0x43c0, 0x43c6, 0x43ce, 0x43d9, 0x43e5, 0x43ec, 0x43f7,
	0x43fe, 0x4402, 0x440b, 0x4416, 0x441a, 0x4423, 0x4427, 0x442e,
	0x443f, 0x4446, 0x4453, 0x445f, 0x4469, 0x4478, 0x4485, 0x4495,
	0x449f, 0x44aa, 0x44b6, 0x44c2, 0x44d3, 0x44e3, 0x44f3, 0x4512,
	// Entry 6FC0 - 6FFF
	0x4525, 0x4531, 0x4535, 0x4544, 0x4554, 0x456a, 0x4571, 0x457c,
	0x4587, 0x4594, 0x45a0, 0x45ae, 0x45bd, 0x45c9, 0x45de, 0x45e7,
	0x45f8, 0x4609, 0x4614, 0x462a, 0x4643, 0x465a, 0x4672, 0x4682,
	0x46a7, 0x46ab, 0x46bc, 0x46c5, 0x46cd, 0x46d8, 0x46e4, 0x46e7,
	0x46f2, 0x4702, 0x4710, 0x471e, 0x4726, 0x4737, 0x4741, 0x4759,
	0x4773, 0x477c, 0x4785, 0x478c, 0x4799, 0x47a2, 0x47b0, 0x47c0,
	0x47cd, 0x47d3, 0x47db, 0x47f9, 0x4804, 0x480d, 0x4817, 0x4820,
	0x482b, 0x4830, 0x483a, 0x4840, 0x4844, 0x4856, 0x485b, 0x4866,
	// Entry 7000 - 703F
	0x4877, 0x4891, 0x48a3, 0x48ae, 0x48b8, 0x48bf, 0x48cc, 0x48dd,
	0x4900, 0x4920, 0x493f, 0x495c, 0x497a, 0x4981, 0x498c, 0x4995,
	0x49a1, 0x49cb, 0x49d9, 0x49e9, 0x49f9, 0x4a0a, 0x4a10, 0x4a21,
	0x4a2d, 0x4a37, 0x4a3c, 0x4a49, 0x4a57, 0x4a66, 0x4a72, 0x4a8b,
	0x4ac0, 0x4b0e, 0x4b40, 0x4b76, 0x4b8b, 0x4ba1, 0x4bc1, 0x4bc8,
	0x4be3, 0x4c01, 0x4c08, 0x4c15, 0x4c33, 0x4c52, 0x4c63, 0x4c77,
	0x4c7a, 0x4c7e, 0x4c87, 0x4c8b, 0x4ca8, 0x4cb0, 0x4cbb, 0x4cc7,
	0x4ce6, 0x4d04, 0x4d38, 0x4d58, 0x4d74, 0x4d90, 0x4d9a, 0x4dc0,
	// Entry 7040 - 707F
	0x4de4, 0x4dfc, 0x4e14, 0x4e32, 0x4e36, 0x4e44, 0x4e4a, 0x4e50,
	0x4e5c, 0x4e61, 0x4e67, 0x4e71, 0x4e7a, 0x4e86, 0x4ea6, 0x4ec2,
	0x4ed0, 0x4ee3, 0x4ef6, 0x4f06, 0x4f17, 0x4f2b, 0x4f3d, 0x4f51,
	0x4f63, 0x4f7b, 0x4f95, 0x4fb3, 0x4fd3, 0x4ff4, 0x5015, 0x5029,
	0x504c, 0x5058, 0x507f, 0x50a7, 0x50bf, 0x50d0, 0x50e1, 0x50ed,
	0x50f6, 0x5103, 0x5108, 0x510e, 0x5117, 0x5131, 0x5140, 0x5155,
	0x516a, 0x5181, 0x5197, 0x51ad, 0x51c2, 0x51d9, 0x51f0, 0x5206,
	0x521b, 0x5233, 0x524b, 0x5260, 0x5275, 0x528c, 0x52a2, 0x52b8,
	// Entry 7080 - 70BF
	0x52cd, 0x52e4, 0x52fb, 0x5311, 0x5326, 0x533e, 0x5356, 0x5363,
	0x5384, 0x53a8, 0x53b0, 0x53c9, 0x53d5, 0x53d9, 0x53df, 0x53f0,
	0x540a, 0x5413, 0x5417, 0x5436, 0x5443, 0x5452, 0x5458, 0x5462,
	0x546a, 0x5475, 0x5491, 0x54ad, 0x54ca, 0x54e3, 0x54fc, 0x5515,
	0x552b, 0x553b, 0x554b, 0x5562, 0x5571, 0x558a, 0x559b, 0x55a8,
	0x55b9, 0x55d1, 0x55e8, 0x55fd, 0x560e, 0x561f, 0x5632, 0x5652,
	0x567b, 0x5692, 0x56ab, 0x56c0, 0x56e9, 0x571e, 0x5741, 0x5763,
	0x5786, 0x57a8, 0x57cb, 0x57ed, 0x5810, 0x5830, 0x5852, 0x5872,
	// Entry 70C0 - 70FF
	0x5894, 0x58b4, 0x58d6, 0x58e1, 0x58f1, 0x5903, 0x591c, 0x5923,
	0x5934, 0x5950, 0x596c, 0x5982, 0x5990, 0x599e, 0x59ae, 0x59be,
	0x59d0, 0x59d9, 0x59ee, 0x59f7, 0x59fd, 0x5a09, 0x5a11, 0x5a22,
	0x5a34, 0x5a52, 0x5a67, 0x5a79, 0x5a89, 0x5a98, 0x5aa4, 0x5aaa,
	0x5ab5, 0x5ac8, 0x5ad5, 0x5ae1, 0x5aeb, 0x5afa, 0x5b08, 0x5b0c,
	0x5b15, 0x5b1d, 0x5b2b, 0x5b35, 0x5b40, 0x5b48, 0x5b4c, 0x5b51,
	0x5b5c, 0x5b6b, 0x5b7e, 0x5b8c, 0x5b94, 0x5b9c, 0x5ba3, 0x5bcd,
	0x5bdb, 0x5bf4, 0x5c0d, 0x5c18, 0x5c1f, 0x5c32, 0x5c48, 0x5c53,
	// Entry 7100 - 713F
	0x5c5f, 0x5c63, 0x5c7e, 0x5c8e, 0x5c9e, 0x5cad, 0x5cbd, 0x5ccf,
	0x5ce2, 0x5cf4, 0x5d08, 0x5d1b, 0x5d2f, 0x5d40, 0x5d52, 0x5d5d,
	0x5d72, 0x5d80, 0x5d96, 0x5da5, 0x5dbd, 0x5dd1, 0x5dee, 0x5dfe,
	0x5e18, 0x5e21, 0x5e2b, 0x5e36, 0x5e47, 0x5e5a, 0x5e5f, 0x5e6c,
	0x5e8b, 0x5ea1, 0x5ebd, 0x5eea, 0x5f15, 0x5f49, 0x5f5f, 0x5f76,
	0x5f82, 0x5fa0, 0x5fbd, 0x5fca, 0x5fed, 0x6009, 0x6016, 0x6022,
	0x6035, 0x6042, 0x6056, 0x6062, 0x606f, 0x607e, 0x608a, 0x609e,
	0x60bc, 0x60d9, 0x60f3, 0x611d, 0x614f, 0x6160, 0x616c, 0x6176,
	// Entry 7140 - 717F
	0x6182, 0x618d, 0x619d, 0x61b6, 0x61d4, 0x61f1, 0x61ff, 0x620b,
	0x6215, 0x6220, 0x622a, 0x6238, 0x624a, 0x625e, 0x6269, 0x628c,
	0x62a2, 0x62b1, 0x62bd, 0x62ca, 0x62d4, 0x62e6, 0x62fc, 0x631f,
	0x6339, 0x6359, 0x6380, 0x6397, 0x63b8, 0x63c8, 0x63d7, 0x63e5,
	0x63fb, 0x6410, 0x6420, 0x6436, 0x644f, 0x6463, 0x6477, 0x6489,
	0x649c, 0x64b0, 0x64cd, 0x64f5, 0x6504, 0x651c, 0x6534, 0x654c,
	0x6564, 0x657c, 0x6594, 0x65b3, 0x65d2, 0x65f1, 0x6610, 0x662d,
	0x664a, 0x6667, 0x6684, 0x66a7, 0x66ca, 0x66ed, 0x6710, 0x6727,
	// Entry 7180 - 71BF
	0x673e, 0x6755, 0x676c, 0x6789, 0x67a6, 0x67c3, 0x67e0, 0x67fc,
	0x6828, 0x6843, 0x686e, 0x687e, 0x688c, 0x689d, 0x68ad, 0x68c8,
	0x68e9, 0x6902, 0x6921, 0x6939, 0x6951, 0x698d, 0x69c2, 0x69fb,
	0x6a15, 0x6a34, 0x6a59, 0x6a6b, 0x6a85, 0x6a92, 0x6aa7, 0x6aad,
	0x6ab7, 0x6ac7, 0x6ad2, 0x6ae2, 0x6b03, 0x6b08, 0x6b0d, 0x6b17,
	0x6b1e, 0x6b22, 0x6b2a, 0x6b2d, 0x6b39, 0x6b43, 0x6b4b, 0x6b52,
	0x6b5b, 0x6b66, 0x6b70, 0x6b83, 0x6b87, 0x6b94, 0x6b9e, 0x6bb1,
	0x6bc5, 0x6bd3, 0x6be4, 0x6beb, 0x6bf3, 0x6c03, 0x6c15, 0x6c26,
	// Entry 71C0 - 71FF
	0x6c34, 0x6c38, 0x6c3f, 0x6c48, 0x6c60, 0x6c76, 0x6c87, 0x6ca2,
	0x6cb9, 0x6cbd, 0x6cca, 0x6cd8, 0x6ce9, 0x6d07, 0x6d1b, 0x6d2f,
	0x6d47, 0x6d4e, 0x6d59, 0x6d62, 0x6d74, 0x6d7e, 0x6d8c, 0x6d9d,
	0x6da8, 0x6db5, 0x6dbd, 0x6dc8, 0x6dce, 0x6dda, 0x6de0, 0x6de4,
	0x6deb, 0x6dfb, 0x6e02, 0x6e0f, 0x6e1b, 0x6e38, 0x6e47, 0x6e61,
	0x6e6c, 0x6e78, 0x6e86, 0x6e9c, 0x6ea9, 0x6eb5, 0x6eb8, 0x6ec8,
	0x6ed6, 0x6ee6, 0x6ef7, 0x6efd, 0x6f05, 0x6f0d, 0x6f1a, 0x6f24,
	0x6f41, 0x6f55, 0x6f6f, 0x6f7d, 0x6f98, 0x6faa, 0x6fbb, 0x6fc4,
	// Entry 7200 - 723F
	0x6fd8, 0x6fe9, 0x6ff7, 0x6ffe, 0x700b, 0x7010, 0x7032, 0x704b,
	0x7065, 0x7080, 0x709b, 0x70bb, 0x70db, 0x70fd, 0x711d, 0x713f,
	0x715c, 0x717b, 0x719a, 0x71b6, 0x71df, 0x7201, 0x7228, 0x7251,
	0x727a, 0x7298, 0x72b2, 0x72cd, 0x72ea, 0x7309, 0x7328, 0x7349,
	0x7363, 0x737f, 0x739d, 0x73bd, 0x73e1, 0x7406, 0x7426, 0x744b,
	0x7474, 0x749a, 0x74c2, 0x74ea, 0x751a, 0x754b, 0x756a, 0x7587,
	0x75a5, 0x75c7, 0x75f2, 0x7618, 0x764b, 0x7674, 0x769d, 0x76c8,
	0x76e5, 0x7704, 0x7723, 0x7742, 0x775e, 0x777c, 0x779b, 0x77bd,
	// Entry 7240 - 727F
	0x77da, 0x77f7, 0x7816, 0x7837, 0x7858, 0x7874, 0x7892, 0x78b2,
	0x78cd, 0x78ea, 0x7907, 0x7921, 0x793a, 0x7956, 0x7974, 0x798d,
	0x79a6, 0x79c2, 0x79dc, 0x79f7, 0x7a1a, 0x7a3f, 0x7a5d, 0x7a7a,
	0x7a9f, 0x7abe, 0x7ad8, 0x7af3, 0x7b13, 0x7b2e, 0x7b4d, 0x7b68,
	0x7b8c, 0x7ba9, 0x7bd4, 0x7c01, 0x7c22, 0x7c43, 0x7c60, 0x7c7e,
	0x7c9e, 0x7cba, 0x7cdc, 0x7cfa, 0x7d1a, 0x7d3a, 0x7d5a, 0x7d7a,
	0x7d97, 0x7db9, 0x7dde, 0x7dfa, 0x7e14, 0x7e2f, 0x7e4e, 0x7e69,
	0x7e88, 0x7ea8, 0x7ed4, 0x7efe, 0x7f2b, 0x7f57, 0x7f72, 0x7f8a,
	// Entry 7280 - 72BF
	0x7f9b, 0x7fad, 0x7fc4, 0x7fe0, 0x800a, 0x8016, 0x8027, 0x8042,
	0x8054, 0x8067, 0x8078, 0x808a, 0x80a1, 0x80bd, 0x80ec, 0x8117,
	0x8124, 0x8136, 0x814e, 0x8168, 0x8199, 0x81c6, 0x81d4, 0x81e6,
	0x81fe, 0x8218, 0x8244, 0x8254, 0x8265, 0x8277, 0x8287, 0x829c,
	0x82b2, 0x82cd, 0x82d9, 0x82e6, 0x82f4, 0x8300, 0x830d, 0x831f,
	0x8336, 0x8350, 0x836b, 0x8384, 0x839e, 0x83bd, 0x83e1, 0x83fa,
	0x8414, 0x842c, 0x8445, 0x8463, 0x8486, 0x84a1, 0x84bd, 0x84d7,
	0x84f2, 0x8512, 0x8530, 0x854f, 0x8567, 0x8589, 0x85a6, 0x85c4,
	// Entry 72C0 - 72FF
	0x85db, 0x85fc, 0x8624, 0x8641, 0x865e, 0x867b, 0x8697, 0x86b0,
	0x86cf, 0x86ed, 0x8710, 0x8731, 0x8750, 0x876f, 0x8791, 0x87be,
	0x87e9, 0x8817, 0x8844, 0x8872, 0x889e, 0x88cd, 0x88fb, 0x8928,
	0x8953, 0x8981, 0x89ae, 0x89de, 0x8a0c, 0x8a3d, 0x8a6d, 0x8a97,
	0x8abf, 0x8aea, 0x8b14, 0x8b44, 0x8b72, 0x8ba3, 0x8bd3, 0x8c09,
	0x8c3d, 0x8c74, 0x8caa, 0x8cdb, 0x8d0a, 0x8d3c, 0x8d6d, 0x8d9e,
	0x8dcd, 0x8dff, 0x8e30, 0x8e5f, 0x8e8c, 0x8ebc, 0x8eeb, 0x8f1b,
	0x8f49, 0x8f7a, 0x8faa, 0x8fdf, 0x9012, 0x9048, 0x907d, 0x9098,
	// Entry 7300 - 733F
	0x90b1, 0x90cd, 0x90e8, 0x90ff, 0x9114, 0x912c, 0x9143, 0x915d,
	0x9175, 0x9190, 0x91aa, 0x91ca, 0x91e8, 0x9209, 0x9229, 0x923e,
	0x9251, 0x9267, 0x927c, 0x9296, 0x92ae, 0x92c9, 0x92e3, 0x92fe,
	0x9319, 0x9334, 0x934f, 0x936a, 0x9382, 0x93a8, 0x93cc, 0x93f3,
	0x9419, 0x9440, 0x9467, 0x948e, 0x94b5, 0x94d5, 0x94f3, 0x9514,
	0x9534, 0x9555, 0x9576, 0x9597, 0x95b8, 0x95df, 0x9604, 0x962c,
	0x9653, 0x967b, 0x96a3, 0x96cb, 0x96f3, 0x9719, 0x973d, 0x9764,
	0x978a, 0x97b1, 0x97d8, 0x97ff, 0x9826, 0x9851, 0x987a, 0x98a6,
	// Entry 7340 - 737F
	0x98d1, 0x98fd, 0x9929, 0x9955, 0x9981, 0x999d, 0x99b7, 0x99d4,
	0x99f0, 0x9a1f, 0x9a4c, 0x9a7c, 0x9aab, 0x9acc, 0x9aeb, 0x9b0d,
	0x9b2e, 0x9b49, 0x9b6b, 0x9b8b, 0x9bac, 0x9bcf, 0x9bf3, 0x9c13,
	0x9c34, 0x9c55, 0x9c78, 0x9c9a, 0x9cbc, 0x9ce6, 0x9d11, 0x9d3c,
	0x9d68, 0x9d83, 0x9da5, 0x9db6, 0x9dc6, 0x9ddb, 0x9de4, 0x9df1,
	0x9e07, 0x9e11, 0x9e1d, 0x9e2e, 0x9e3a, 0x9e4d, 0x9e5d, 0x9e6e,
	0x9e77, 0x9ea1, 0x9eb5, 0x9ebf, 0x9ecd, 0x9eea, 0x9ef7, 0x9f01,
	0x9f0a, 0x9f17, 0x9f25, 0x9f2b, 0x9f31, 0x9f3e, 0x9f4e, 0x9f53,
	// Entry 7380 - 73BF
	0x9f69, 0x9f71, 0x9f77, 0x9f88, 0x9f91, 0x9f9b, 0x9fa3, 0x9fb0,
	0x9fc4, 0x9fd4, 0x9fe1, 0x9fe6, 0x9fee, 0x9ff3, 0xa004, 0xa016,
	0xa027, 0xa033, 0xa047, 0xa050, 0xa057, 0xa05f, 0xa064, 0xa06a,
	0xa070, 0xa07e, 0xa089, 0xa09c, 0xa0ad, 0xa0b0, 0xa0bd, 0xa0c4,
	0xa0cd, 0xa0d5, 0xa0d9, 0xa0e2, 0xa0ea, 0xa0f0, 0xa0fc, 0xa101,
	0xa105, 0xa108, 0xa10d, 0xa110, 0xa118, 0xa121, 0xa125, 0xa12c,
	0xa132, 0xa13c, 0xa142, 0xa147, 0xa153, 0xa174, 0xa195, 0xa1b6,
	0xa1d7, 0xa1f8, 0xa219, 0xa23a, 0xa25b, 0xa27c, 0xa29d, 0xa2be,
	// Entry 73C0 - 73FF
	0xa2df, 0xa300, 0xa321, 0xa342, 0xa363, 0xa384, 0xa3a5, 0xa3c6,
	0xa3e7, 0xa408, 0xa429, 0xa44a, 0xa46b, 0xa48c, 0xa4ad, 0xa4ce,
	0xa4ef, 0xa510, 0xa531, 0xa552, 0xa573, 0xa594, 0xa5b5, 0xa5d6,
	0xa5f7, 0xa618, 0xa639, 0xa65a, 0xa67b, 0xa69c, 0xa6bd, 0xa6de,
	0xa6ff, 0xa720, 0xa741, 0xa762, 0xa783, 0xa7a4, 0xa7c5, 0xa7e6,
	0xa807, 0xa828, 0xa849, 0xa86a, 0xa88b, 0xa8ac, 0xa8cd, 0xa8ee,
	0xa90f, 0xa930, 0xa951, 0xa972, 0xa993, 0xa9b4, 0xa9d5, 0xa9f6,
	0xaa17, 0xaa38, 0xaa59, 0xaa7a, 0xaa9b, 0xaabc, 0xaadd, 0xaafe,
	// Entry 7400 - 743F
	0xab1f, 0xab40, 0xab61, 0xab82, 0xaba3, 0xabc4, 0xabe5, 0xac06,
	0xac27, 0xac48, 0xac69, 0xac8a, 0xacab, 0xaccc, 0xaced, 0xad0e,
	0xad2f, 0xad50, 0xad71, 0xad92, 0xadb3, 0xadd4, 0xadf5, 0xae16,
	0xae37, 0xae58, 0xae79, 0xae9a, 0xaebb, 0xaedc, 0xaefd, 0xaf1e,
	0xaf3f, 0xaf60, 0xaf81, 0xafa2, 0xafc3, 0xafe4, 0xb005, 0xb026,
	0xb047, 0xb068, 0xb089, 0xb0aa, 0xb0cb, 0xb0ec, 0xb10d, 0xb12e,
	0xb14f, 0xb170, 0xb191, 0xb1b2, 0xb1d3, 0xb1f4, 0xb215, 0xb236,
	0xb257, 0xb278, 0xb299, 0xb2ba, 0xb2db, 0xb2fc, 0xb31d, 0xb33e,
	// Entry 7440 - 747F
	0xb35f, 0xb380, 0xb3a1, 0xb3c2, 0xb3e3, 0xb404, 0xb425, 0xb446,
	0xb467, 0xb488, 0xb4a9, 0xb4ca, 0xb4eb, 0xb50c, 0xb52d, 0xb54e,
	0xb56f, 0xb590, 0xb5b1, 0xb5d2, 0xb5f3, 0xb614, 0xb635, 0xb656,
	0xb677, 0xb698, 0xb6b9, 0xb6da, 0xb6fb, 0xb71c, 0xb73d, 0xb75e,
	0xb77f, 0xb7a0, 0xb7c1, 0xb7e2, 0xb803, 0xb824, 0xb845, 0xb866,
	0xb887, 0xb8a8, 0xb8c9, 0xb8ea, 0xb90b, 0xb92c, 0xb94d, 0xb96e,
	0xb98f, 0xb9b0, 0xb9d1, 0xb9f2, 0xba13, 0xba34, 0xba55, 0xba76,
	0xba97, 0xbab8, 0xbad9, 0xbafa, 0xbb1b, 0xbb3c, 0xbb5d, 0xbb7e,
	// Entry 7480 - 74BF
	0xbb9f, 0xbbc0, 0xbbe1, 0xbc02, 0xbc23, 0xbc44, 0xbc65, 0xbc86,
	0xbca7, 0xbcc8, 0xbce9, 0xbd0a, 0xbd2b, 0xbd4c, 0xbd6d, 0xbd8e,
	0xbdaf, 0xbdd0, 0xbdf1, 0xbe12, 0xbe33, 0xbe54, 0xbe75, 0xbe96,
	0xbeb7, 0xbed8, 0xbef9, 0xbf1a, 0xbf3b, 0xbf5c, 0xbf7d, 0xbf9e,
	0xbfbf, 0xbfe0, 0xc001, 0xc022, 0xc043, 0xc064, 0xc085, 0xc0a6,
	0xc0c7, 0xc0e8, 0xc109, 0xc12a, 0xc14b, 0xc16c, 0xc18d, 0xc1ae,
	0xc1cf, 0xc1f0, 0xc211, 0xc232, 0xc253, 0xc274, 0xc295, 0xc2b6,
	0xc2d7, 0xc2f8, 0xc319, 0xc33a, 0xc35b, 0xc37c, 0xc39d, 0xc3be,
	// Entry 74C0 - 74FF
	0xc3df, 0xc400, 0xc421, 0xc442, 0xc463, 0xc484, 0xc4a5, 0xc4c6,
	0xc4e7, 0xc508, 0xc529, 0xc54a, 0xc56b, 0xc58c, 0xc5ad, 0xc5ce,
	0xc5ef, 0xc610, 0xc631, 0xc652, 0xc673, 0xc694, 0xc6b5, 0xc6d6,
	0xc6f7, 0xc718, 0xc739, 0xc75a, 0xc77b, 0xc79c, 0xc7bd, 0xc7de,
	0xc7ff, 0xc820, 0xc841, 0xc862, 0xc883, 0xc8a4, 0xc8c5, 0xc8e6,
	0xc907, 0xc928, 0xc949, 0xc96a, 0xc98b, 0xc9ac, 0xc9cd, 0xc9ee,
	0xca0f, 0xca30, 0xca51, 0xca72, 0xca93, 0xcab4, 0xcad5, 0xcaf6,
	0xcb17, 0xcb38, 0xcb59, 0xcb7a, 0xcb9b, 0xcbbc, 0xcbdd, 0xcbfe,
	// Entry 7500 - 753F
	0xcc1f, 0xcc40, 0xcc61, 0xcc82, 0xcca3, 0xccc4, 0xcce5, 0xcd06,
	0xcd27, 0xcd48, 0xcd69, 0xcd8a, 0xcdab, 0xcdcc, 0xcded, 0xce0e,
	0xce2f, 0xce50, 0xce71, 0xce92, 0xceb3, 0xced4, 0xcef5, 0xcf16,
	0xcf37, 0xcf58, 0xcf79, 0xcf9a, 0xcfbb, 0xcfdc, 0xcffd, 0xd01e,
	0xd03f, 0xd060, 0xd081, 0xd0a2, 0xd0c3, 0xd0e4, 0xd105, 0xd126,
	0xd147, 0xd168, 0xd189, 0xd1aa, 0xd1cb, 0xd1ec, 0xd20d, 0xd22e,
	0xd24f, 0xd270, 0xd291, 0xd2b2, 0xd2d3, 0xd2f4, 0xd315, 0xd336,
	0xd357, 0xd378, 0xd399, 0xd3ba, 0xd3db, 0xd3fc, 0xd41d, 0xd43e,
	// Entry 7540 - 757F
	0xd45f, 0xd480, 0xd4a1, 0xd4c2, 0xd4e3, 0xd504, 0xd525, 0xd546,
	0xd567, 0xd588, 0xd5a9, 0xd5ca, 0xd5eb, 0xd60c, 0xd62d, 0xd64e,
	0xd66f, 0xd690, 0xd6b1, 0xd6d2, 0xd6f3, 0xd714, 0xd735, 0xd756,
	0xd777, 0xd798, 0xd7b9, 0xd7da, 0xd7fb, 0xd81c, 0xd83d, 0xd85e,
	0xd87f, 0xd8a0, 0xd8c1, 0xd8e2, 0xd903, 0xd924, 0xd945, 0xd966,
	0xd987, 0xd9a8, 0xd9c9, 0xd9ea, 0xda0b, 0xda2c, 0xda4d, 0xda6e,
	0xda8f, 0xdab0, 0xdad1, 0xdaf2, 0xdb13, 0xdb34, 0xdb55, 0xdb76,
	0xdb97, 0xdbb8, 0xdbd9, 0xdbfa, 0xdc1b, 0xdc3c, 0xdc5d, 0xdc7e,
	// Entry 7580 - 75BF
	0xdc9f, 0xdcc0, 0xdce1, 0xdd02, 0xdd23, 0xdd44, 0xdd65, 0xdd86,
	0xdda7, 0xddc8, 0xdde9, 0xde0a, 0xde2b, 0xde4c, 0xde6d, 0xde8e,
	0xdeaf, 0xded0, 0xdef1, 0xdf12, 0xdf33, 0xdf54, 0xdf75, 0xdf96,
	0xdfb7, 0xdfd8, 0xdff9, 0xe01a, 0xe03b, 0xe05c, 0xe07d, 0xe09e,
	0xe0bf, 0xe0e0, 0xe101, 0xe122, 0xe143, 0xe164, 0xe185, 0xe1a6,
	0xe1c7, 0xe1e8, 0xe209, 0xe22a, 0xe24b, 0xe26c, 0xe28d, 0xe2ae,
	0xe2cf, 0xe2f0, 0xe311, 0xe332, 0xe353, 0xe374, 0xe395, 0xe3b6,
	0xe3d7, 0xe3f8, 0xe419, 0xe43a, 0xe45b, 0xe47c, 0xe49d, 0xe4be,
	// Entry 75C0 - 75FF
	0xe4df, 0xe500, 0xe521, 0xe542, 0xe563, 0xe584, 0xe5a5, 0xe5c6,
	0xe5e7, 0xe608, 0xe629, 0xe64a, 0xe66b, 0xe68c, 0xe6ad, 0xe6ce,
	0xe6ef, 0xe710, 0xe731, 0xe73d, 0xe746, 0xe75a, 0xe76c, 0xe77b,
	0xe78a, 0xe79a, 0xe7a7, 0xe7b5, 0xe7c9, 0xe7de, 0xe7ea, 0xe7f7,
	0xe800, 0xe810, 0xe81d, 0xe828, 0xe836, 0xe843, 0xe850, 0xe85f,
	0xe86d, 0xe87b, 0xe888, 0xe897, 0xe8a6, 0xe8b4, 0xe8bd, 0xe8ca,
	0xe8dc, 0xe8eb, 0xe900, 0xe911, 0xe922, 0xe93c, 0xe956, 0xe970,
	0xe98a, 0xe9a4, 0xe9be, 0xe9d8, 0xe9f2, 0xea0c, 0xea26, 0xea40,
	// Entry 7600 - 763F
	0xea5a, 0xea74, 0xea8e, 0xeaa8, 0xeac2, 0xeadc, 0xeaf6, 0xeb10,
	0xeb2a, 0xeb44, 0xeb5e, 0xeb78, 0xeb92, 0xebac, 0xebc6, 0xebdd,
	0xebf0, 0xec08, 0xec1d, 0xec29, 0xec39, 0xec51, 0xec69, 0xec81,
	0xec99, 0xecb1, 0xecc9, 0xece1, 0xecf9, 0xed11, 0xed29, 0xed41,
	0xed59, 0xed71, 0xed89, 0xeda1, 0xedb9, 0xedd1, 0xede9, 0xee01,
	0xee19, 0xee31, 0xee49, 0xee61, 0xee79, 0xee91, 0xeea9, 0xeebf,
	0xeed0, 0xeee7, 0xeef0, 0xeefa, 0xef0f, 0xef24, 0xef39, 0xef4e,
	0xef63, 0xef78, 0xef8d, 0xefa2, 0xefb7, 0xefcc, 0xefe1, 0xeff6,
	// Entry 7640 - 767F
	0xf00b, 0xf020, 0xf035, 0xf04a, 0xf05f, 0xf074, 0xf089, 0xf09e,
	0xf0b3, 0xf0c8, 0xf0dd, 0xf0f2, 0xf107, 0xf11c, 0xf131, 0xf146,
	0xf15b, 0xf170, 0xf185, 0xf19a, 0xf1af, 0xf1c4, 0xf1d9, 0xf1ee,
	0xf203, 0xf218, 0xf22d, 0xf242, 0xf257, 0xf26c, 0xf281, 0xf296,
	0xf2ab, 0xf2c0, 0xf2d5, 0xf2ea, 0xf2ff, 0xf314, 0xf329, 0xf33e,
	0xf353, 0xf368, 0xf37d, 0xf392, 0xf3a7, 0xf3bc, 0xf3d1, 0xf3e6,
	0xf3fb, 0xf410, 0xf425, 0xf43a, 0xf44f, 0xf464, 0xf479, 0xf48e,
	0xf4a3, 0xf4b8, 0xf4cd, 0xf4e2, 0xf4f7, 0xf50c, 0xf521, 0xf536,
	// Entry 7680 - 76BF
	0xf54b, 0xf560, 0xf575, 0xf58a, 0xf59f, 0xf5b4, 0xf5c9, 0xf5df,
	0xf5f5, 0xf60b, 0xf621, 0xf637, 0xf64d, 0xf663, 0xf679, 0xf68f,
	0xf6a5, 0xf6bb, 0xf6d1, 0xf6e7, 0xf6fd, 0xf713, 0xf729, 0xf73f,
	0xf755, 0xf76b, 0xf781, 0xf797, 0xf7ad, 0xf7c3, 0xf7d9, 0xf7ef,
	0xf805, 0xf81b, 0xf831, 0xf847, 0xf85d, 0xf873, 0xf889, 0xf89f,
	0xf8b5, 0xf8cb, 0xf8e1, 0xf8f7, 0xf90d, 0xf923, 0xf939, 0xf94f,
	0xf965, 0xf97b, 0xf991, 0xf9a7, 0xf9bd, 0xf9d3, 0xf9e9, 0xf9ff,
	0xfa15, 0xfa2b, 0xfa41, 0xfa57, 0xfa6d, 0xfa83, 0xfa99, 0xfaaf,
	// Entry 76C0 - 76FF
	0xfac5, 0xfadb, 0xfaf1, 0xfb07, 0xfb1d, 0xfb33, 0xfb49, 0xfb5f,
	0xfb75, 0xfb8b, 0xfba1, 0xfbb7, 0xfbcd, 0xfbe3, 0xfbf9, 0xfc0f,
	0xfc25, 0xfc3b, 0xfc51, 0xfc67, 0xfc7d, 0xfc93, 0xfca9, 0xfcbf,
	0xfcd5, 0xfceb, 0xfd01, 0xfd17, 0xfd2d, 0xfd43, 0xfd59, 0xfd6f,
	0xfd85, 0xfd9b, 0xfdb1, 0xfdc7, 0xfddd, 0xfdf3, 0xfe09, 0xfe1f,
	0xfe35, 0xfe4b, 0xfe61, 0xfe77, 0xfe8d, 0xfea3, 0xfeb9, 0xfecf,
	0xfee5, 0xfefb, 0xff11, 0xff27, 0xff3d, 0xff53, 0xff69, 0xff7f,
	0xff95, 0xffab, 0xffc1, 0xffd7, 0xffed, 0x0003, 0x0019, 0x002f,
	// Entry 7700 - 773F
	0x0045, 0x005b, 0x0071, 0x0087, 0x009d, 0x00b3, 0x00c9, 0x00df,
	0x00f5, 0x010b, 0x0121, 0x0137, 0x014d, 0x0163, 0x0179, 0x018f,
	0x01a5, 0x01bb, 0x01d1, 0x01e7, 0x01fd, 0x0213, 0x0229, 0x023f,
	0x0255, 0x026b, 0x0281, 0x0297, 0x02ad, 0x02c3, 0x02d9, 0x02ef,
	0x0305, 0x031b, 0x0331, 0x0347,
} // Size: 61024 bytes

const directData string = "" + // Size: 326 bytes
	"<CJK Ideograph Extension A><CJK Ideograph Extension B><CJK Ideograph Ext" +
	"ension C><CJK Ideograph Extension D><CJK Ideograph Extension E><CJK Ideo" +
	"graph><Hangul Syllable><Low Surrogate><Non Private Use High Surrogate><P" +
	"lane 15 Private Use><Plane 16 Private Use><Private Use High Surrogate><P" +
	"rivate Use><Tangut Ideograph><control>"

const singleData string = ("" + // Size: 787271 bytes; the redundant, explicit parens are for https://golang.org/issue/18078
	"SPACEEXCLAMATION MARKQUOTATION MARKNUMBER SIGNDOLLAR SIGNPERCENT SIGNAMP" +
	"ERSANDAPOSTROPHELEFT PARENTHESISRIGHT PARENTHESISASTERISKPLUS SIGNCOMMAH" +
	"YPHEN-MINUSFULL STOPSOLIDUSDIGIT ZERODIGIT ONEDIGIT TWODIGIT THREEDIGIT " +
	"FOURDIGIT FIVEDIGIT SIXDIGIT SEVENDIGIT EIGHTDIGIT NINECOLONSEMICOLONLES" +
	"S-THAN SIGNEQUALS SIGNGREATER-THAN SIGNQUESTION MARKCOMMERCIAL ATLATIN C" +
	"APITAL LETTER ALATIN CAPITAL LETTER BLATIN CAPITAL LETTER CLATIN CAPITAL" +
	" LETTER DLATIN CAPITAL LETTER ELATIN CAPITAL LETTER FLATIN CAPITAL LETTE" +
	"R GLATIN CAPITAL LETTER HLATIN CAPITAL LETTER ILATIN CAPITAL LETTER JLAT" +
	"IN CAPITAL LETTER KLATIN CAPITAL LETTER LLATIN CAPITAL LETTER MLATIN CAP" +
	"ITAL LETTER NLATIN CAPITAL LETTER OLATIN CAPITAL LETTER PLATIN CAPITAL L" +
	"ETTER QLATIN CAPITAL LETTER RLATIN CAPITAL LETTER SLATIN CAPITAL LETTER " +
	"TLATIN CAPITAL LETTER ULATIN CAPITAL LETTER VLATIN CAPITAL LETTER WLATIN" +
	" CAPITAL LETTER XLATIN CAPITAL LETTER YLATIN CAPITAL LETTER ZLEFT SQUARE" +
	" BRACKETREVERSE SOLIDUSRIGHT SQUARE BRACKETCIRCUMFLEX ACCENTLOW LINEGRAV" +
	"E ACCENTLATIN SMALL LETTER ALATIN SMALL LETTER BLATIN SMALL LETTER CLATI" +
	"N SMALL LETTER DLATIN SMALL LETTER ELATIN SMALL LETTER FLATIN SMALL LETT" +
	"ER GLATIN SMALL LETTER HLATIN SMALL LETTER ILATIN SMALL LETTER JLATIN SM" +
	"ALL LETTER KLATIN SMALL LETTER LLATIN SMALL LETTER MLATIN SMALL LETTER N" +
	"LATIN SMALL LETTER OLATIN SMALL LETTER PLATIN SMALL LETTER QLATIN SMALL " +
	"LETTER RLATIN SMALL LETTER SLATIN SMALL LETTER TLATIN SMALL LETTER ULATI" +
	"N SMALL LETTER VLATIN SMALL LETTER WLATIN SMALL LETTER XLATIN SMALL LETT" +
	"ER YLATIN SMALL LETTER ZLEFT CURLY BRACKETVERTICAL LINERIGHT CURLY BRACK" +
	"ETTILDENO-BREAK SPACEINVERTED EXCLAMATION MARKCENT SIGNPOUND SIGNCURRENC" +
	"Y SIGNYEN SIGNBROKEN BARSECTION SIGNDIAERESISCOPYRIGHT SIGNFEMININE ORDI" +
	"NAL INDICATORLEFT-POINTING DOUBLE ANGLE QUOTATION MARKNOT SIGNSOFT HYPHE" +
	"NREGISTERED SIGNMACRONDEGREE SIGNPLUS-MINUS SIGNSUPERSCRIPT TWOSUPERSCRI" +
	"PT THREEACUTE ACCENTMICRO SIGNPILCROW SIGNMIDDLE DOTCEDILLASUPERSCRIPT O" +
	"NEMASCULINE ORDINAL INDICATORRIGHT-POINTING DOUBLE ANGLE QUOTATION MARKV" +
	"ULGAR FRACTION ONE QUARTERVULGAR FRACTION ONE HALFVULGAR FRACTION THREE " +
	"QUARTERSINVERTED QUESTION MARKLATIN CAPITAL LETTER A WITH GRAVELATIN CAP" +
	"ITAL LETTER A WITH ACUTELATIN CAPITAL LETTER A WITH CIRCUMFLEXLATIN CAPI" +
	"TAL LETTER A WITH TILDELATIN CAPITAL LETTER A WITH DIAERESISLATIN CAPITA" +
	"L LETTER A WITH RING ABOVELATIN CAPITAL LETTER AELATIN CAPITAL LETTER C " +
	"WITH CEDILLALATIN CAPITAL LETTER E WITH GRAVELATIN CAPITAL LETTER E WITH" +
	" ACUTELATIN CAPITAL LETTER E WITH CIRCUMFLEXLATIN CAPITAL LETTER E WITH " +
	"DIAERESISLATIN CAPITAL LETTER I WITH GRAVELATIN CAPITAL LETTER I WITH AC" +
	"UTELATIN CAPITAL LETTER I WITH CIRCUMFLEXLATIN CAPITAL LETTER I WITH DIA" +
	"ERESISLATIN CAPITAL LETTER ETHLATIN CAPITAL LETTER N WITH TILDELATIN CAP" +
	"ITAL LETTER O WITH GRAVELATIN CAPITAL LETTER O WITH ACUTELATIN CAPITAL L" +
	"ETTER O WITH CIRCUMFLEXLATIN CAPITAL LETTER O WITH TILDELATIN CAPITAL LE" +
	"TTER O WITH DIAERESISMULTIPLICATION SIGNLATIN CAPITAL LETTER O WITH STRO" +
	"KELATIN CAPITAL LETTER U WITH GRAVELATIN CAPITAL LETTER U WITH ACUTELATI" +
	"N CAPITAL LETTER U WITH CIRCUMFLEXLATIN CAPITAL LETTER U WITH DIAERESISL" +
	"ATIN CAPITAL LETTER Y WITH ACUTELATIN CAPITAL LETTER THORNLATIN SMALL LE" +
	"TTER SHARP SLATIN SMALL LETTER A WITH GRAVELATIN SMALL LETTER A WITH ACU" +
	"TELATIN SMALL LETTER A WITH CIRCUMFLEXLATIN SMALL LETTER A WITH TILDELAT" +
	"IN SMALL LETTER A WITH DIAERESISLATIN SMALL LETTER A WITH RING ABOVELATI" +
	"N SMALL LETTER AELATIN SMALL LETTER C WITH CEDILLALATIN SMALL LETTER E W" +
	"ITH GRAVELATIN SMALL LETTER E WITH ACUTELATIN SMALL LETTER E WITH CIRCUM" +
	"FLEXLATIN SMALL LETTER E WITH DIAERESISLATIN SMALL LETTER I WITH GRAVELA" +
	"TIN SMALL LETTER I WITH ACUTELATIN SMALL LETTER I WITH CIRCUMFLEXLATIN S" +
	"MALL LETTER I WITH DIAERESISLATIN SMALL LETTER ETHLATIN SMALL LETTER N W" +
	"ITH TILDELATIN SMALL LETTER O WITH GRAVELATIN SMALL LETTER O WITH ACUTEL" +
	"ATIN SMALL LETTER O WITH CIRCUMFLEXLATIN SMALL LETTER O WITH TILDELATIN " +
	"SMALL LETTER O WITH DIAERESISDIVISION SIGNLATIN SMALL LETTER O WITH STRO" +
	"KELATIN SMALL LETTER U WITH GRAVELATIN SMALL LETTER U WITH ACUTELATIN SM" +
	"ALL LETTER U WITH CIRCUMFLEXLATIN SMALL LETTER U WITH DIAERESISLATIN SMA" +
	"LL LETTER Y WITH ACUTELATIN SMALL LETTER THORNLATIN SMALL LETTER Y WITH " +
	"DIAERESISLATIN CAPITAL LETTER A WITH MACRONLATIN SMALL LETTER A WITH MAC" +
	"RONLATIN CAPITAL LETTER A WITH BREVELATIN SMALL LETTER A WITH BREVELATIN" +
	" CAPITAL LETTER A WITH OGONEKLATIN SMALL LETTER A WITH OGONEKLATIN CAPIT" +
	"AL LETTER C WITH ACUTELATIN SMALL LETTER C WITH ACUTELATIN CAPITAL LETTE" +
	"R C WITH CIRCUMFLEXLATIN SMALL LETTER C WITH CIRCUMFLEXLATIN CAPITAL LET") + ("" +
	"TER C WITH DOT ABOVELATIN SMALL LETTER C WITH DOT ABOVELATIN CAPITAL LET" +
	"TER C WITH CARONLATIN SMALL LETTER C WITH CARONLATIN CAPITAL LETTER D WI" +
	"TH CARONLATIN SMALL LETTER D WITH CARONLATIN CAPITAL LETTER D WITH STROK" +
	"ELATIN SMALL LETTER D WITH STROKELATIN CAPITAL LETTER E WITH MACRONLATIN" +
	" SMALL LETTER E WITH MACRONLATIN CAPITAL LETTER E WITH BREVELATIN SMALL " +
	"LETTER E WITH BREVELATIN CAPITAL LETTER E WITH DOT ABOVELATIN SMALL LETT" +
	"ER E WITH DOT ABOVELATIN CAPITAL LETTER E WITH OGONEKLATIN SMALL LETTER " +
	"E WITH OGONEKLATIN CAPITAL LETTER E WITH CARONLATIN SMALL LETTER E WITH " +
	"CARONLATIN CAPITAL LETTER G WITH CIRCUMFLEXLATIN SMALL LETTER G WITH CIR" +
	"CUMFLEXLATIN CAPITAL LETTER G WITH BREVELATIN SMALL LETTER G WITH BREVEL" +
	"ATIN CAPITAL LETTER G WITH DOT ABOVELATIN SMALL LETTER G WITH DOT ABOVEL" +
	"ATIN CAPITAL LETTER G WITH CEDILLALATIN SMALL LETTER G WITH CEDILLALATIN" +
	" CAPITAL LETTER H WITH CIRCUMFLEXLATIN SMALL LETTER H WITH CIRCUMFLEXLAT" +
	"IN CAPITAL LETTER H WITH STROKELATIN SMALL LETTER H WITH STROKELATIN CAP" +
	"ITAL LETTER I WITH TILDELATIN SMALL LETTER I WITH TILDELATIN CAPITAL LET" +
	"TER I WITH MACRONLATIN SMALL LETTER I WITH MACRONLATIN CAPITAL LETTER I " +
	"WITH BREVELATIN SMALL LETTER I WITH BREVELATIN CAPITAL LETTER I WITH OGO" +
	"NEKLATIN SMALL LETTER I WITH OGONEKLATIN CAPITAL LETTER I WITH DOT ABOVE" +
	"LATIN SMALL LETTER DOTLESS ILATIN CAPITAL LIGATURE IJLATIN SMALL LIGATUR" +
	"E IJLATIN CAPITAL LETTER J WITH CIRCUMFLEXLATIN SMALL LETTER J WITH CIRC" +
	"UMFLEXLATIN CAPITAL LETTER K WITH CEDILLALATIN SMALL LETTER K WITH CEDIL" +
	"LALATIN SMALL LETTER KRALATIN CAPITAL LETTER L WITH ACUTELATIN SMALL LET" +
	"TER L WITH ACUTELATIN CAPITAL LETTER L WITH CEDILLALATIN SMALL LETTER L " +
	"WITH CEDILLALATIN CAPITAL LETTER L WITH CARONLATIN SMALL LETTER L WITH C" +
	"ARONLATIN CAPITAL LETTER L WITH MIDDLE DOTLATIN SMALL LETTER L WITH MIDD" +
	"LE DOTLATIN CAPITAL LETTER L WITH STROKELATIN SMALL LETTER L WITH STROKE" +
	"LATIN CAPITAL LETTER N WITH ACUTELATIN SMALL LETTER N WITH ACUTELATIN CA" +
	"PITAL LETTER N WITH CEDILLALATIN SMALL LETTER N WITH CEDILLALATIN CAPITA" +
	"L LETTER N WITH CARONLATIN SMALL LETTER N WITH CARONLATIN SMALL LETTER N" +
	" PRECEDED BY APOSTROPHELATIN CAPITAL LETTER ENGLATIN SMALL LETTER ENGLAT" +
	"IN CAPITAL LETTER O WITH MACRONLATIN SMALL LETTER O WITH MACRONLATIN CAP" +
	"ITAL LETTER O WITH BREVELATIN SMALL LETTER O WITH BREVELATIN CAPITAL LET" +
	"TER O WITH DOUBLE ACUTELATIN SMALL LETTER O WITH DOUBLE ACUTELATIN CAPIT" +
	"AL LIGATURE OELATIN SMALL LIGATURE OELATIN CAPITAL LETTER R WITH ACUTELA" +
	"TIN SMALL LETTER R WITH ACUTELATIN CAPITAL LETTER R WITH CEDILLALATIN SM" +
	"ALL LETTER R WITH CEDILLALATIN CAPITAL LETTER R WITH CARONLATIN SMALL LE" +
	"TTER R WITH CARONLATIN CAPITAL LETTER S WITH ACUTELATIN SMALL LETTER S W" +
	"ITH ACUTELATIN CAPITAL LETTER S WITH CIRCUMFLEXLATIN SMALL LETTER S WITH" +
	" CIRCUMFLEXLATIN CAPITAL LETTER S WITH CEDILLALATIN SMALL LETTER S WITH " +
	"CEDILLALATIN CAPITAL LETTER S WITH CARONLATIN SMALL LETTER S WITH CARONL" +
	"ATIN CAPITAL LETTER T WITH CEDILLALATIN SMALL LETTER T WITH CEDILLALATIN" +
	" CAPITAL LETTER T WITH CARONLATIN SMALL LETTER T WITH CARONLATIN CAPITAL" +
	" LETTER T WITH STROKELATIN SMALL LETTER T WITH STROKELATIN CAPITAL LETTE" +
	"R U WITH TILDELATIN SMALL LETTER U WITH TILDELATIN CAPITAL LETTER U WITH" +
	" MACRONLATIN SMALL LETTER U WITH MACRONLATIN CAPITAL LETTER U WITH BREVE" +
	"LATIN SMALL LETTER U WITH BREVELATIN CAPITAL LETTER U WITH RING ABOVELAT" +
	"IN SMALL LETTER U WITH RING ABOVELATIN CAPITAL LETTER U WITH DOUBLE ACUT" +
	"ELATIN SMALL LETTER U WITH DOUBLE ACUTELATIN CAPITAL LETTER U WITH OGONE" +
	"KLATIN SMALL LETTER U WITH OGONEKLATIN CAPITAL LETTER W WITH CIRCUMFLEXL" +
	"ATIN SMALL LETTER W WITH CIRCUMFLEXLATIN CAPITAL LETTER Y WITH CIRCUMFLE" +
	"XLATIN SMALL LETTER Y WITH CIRCUMFLEXLATIN CAPITAL LETTER Y WITH DIAERES" +
	"ISLATIN CAPITAL LETTER Z WITH ACUTELATIN SMALL LETTER Z WITH ACUTELATIN " +
	"CAPITAL LETTER Z WITH DOT ABOVELATIN SMALL LETTER Z WITH DOT ABOVELATIN " +
	"CAPITAL LETTER Z WITH CARONLATIN SMALL LETTER Z WITH CARONLATIN SMALL LE" +
	"TTER LONG SLATIN SMALL LETTER B WITH STROKELATIN CAPITAL LETTER B WITH H" +
	"OOKLATIN CAPITAL LETTER B WITH TOPBARLATIN SMALL LETTER B WITH TOPBARLAT" +
	"IN CAPITAL LETTER TONE SIXLATIN SMALL LETTER TONE SIXLATIN CAPITAL LETTE" +
	"R OPEN OLATIN CAPITAL LETTER C WITH HOOKLATIN SMALL LETTER C WITH HOOKLA" +
	"TIN CAPITAL LETTER AFRICAN DLATIN CAPITAL LETTER D WITH HOOKLATIN CAPITA" +
	"L LETTER D WITH TOPBARLATIN SMALL LETTER D WITH TOPBARLATIN SMALL LETTER" +
	" TURNED DELTALATIN CAPITAL LETTER REVERSED ELATIN CAPITAL LETTER SCHWALA" +
	"TIN CAPITAL LETTER OPEN ELATIN CAPITAL LETTER F WITH HOOKLATIN SMALL LET" +
	"TER F WITH HOOKLATIN CAPITAL LETTER G WITH HOOKLATIN CAPITAL LETTER GAMM" +
	"ALATIN SMALL LETTER HVLATIN CAPITAL LETTER IOTALATIN CAPITAL LETTER I WI") + ("" +
	"TH STROKELATIN CAPITAL LETTER K WITH HOOKLATIN SMALL LETTER K WITH HOOKL" +
	"ATIN SMALL LETTER L WITH BARLATIN SMALL LETTER LAMBDA WITH STROKELATIN C" +
	"APITAL LETTER TURNED MLATIN CAPITAL LETTER N WITH LEFT HOOKLATIN SMALL L" +
	"ETTER N WITH LONG RIGHT LEGLATIN CAPITAL LETTER O WITH MIDDLE TILDELATIN" +
	" CAPITAL LETTER O WITH HORNLATIN SMALL LETTER O WITH HORNLATIN CAPITAL L" +
	"ETTER OILATIN SMALL LETTER OILATIN CAPITAL LETTER P WITH HOOKLATIN SMALL" +
	" LETTER P WITH HOOKLATIN LETTER YRLATIN CAPITAL LETTER TONE TWOLATIN SMA" +
	"LL LETTER TONE TWOLATIN CAPITAL LETTER ESHLATIN LETTER REVERSED ESH LOOP" +
	"LATIN SMALL LETTER T WITH PALATAL HOOKLATIN CAPITAL LETTER T WITH HOOKLA" +
	"TIN SMALL LETTER T WITH HOOKLATIN CAPITAL LETTER T WITH RETROFLEX HOOKLA" +
	"TIN CAPITAL LETTER U WITH HORNLATIN SMALL LETTER U WITH HORNLATIN CAPITA" +
	"L LETTER UPSILONLATIN CAPITAL LETTER V WITH HOOKLATIN CAPITAL LETTER Y W" +
	"ITH HOOKLATIN SMALL LETTER Y WITH HOOKLATIN CAPITAL LETTER Z WITH STROKE" +
	"LATIN SMALL LETTER Z WITH STROKELATIN CAPITAL LETTER EZHLATIN CAPITAL LE" +
	"TTER EZH REVERSEDLATIN SMALL LETTER EZH REVERSEDLATIN SMALL LETTER EZH W" +
	"ITH TAILLATIN LETTER TWO WITH STROKELATIN CAPITAL LETTER TONE FIVELATIN " +
	"SMALL LETTER TONE FIVELATIN LETTER INVERTED GLOTTAL STOP WITH STROKELATI" +
	"N LETTER WYNNLATIN LETTER DENTAL CLICKLATIN LETTER LATERAL CLICKLATIN LE" +
	"TTER ALVEOLAR CLICKLATIN LETTER RETROFLEX CLICKLATIN CAPITAL LETTER DZ W" +
	"ITH CARONLATIN CAPITAL LETTER D WITH SMALL LETTER Z WITH CARONLATIN SMAL" +
	"L LETTER DZ WITH CARONLATIN CAPITAL LETTER LJLATIN CAPITAL LETTER L WITH" +
	" SMALL LETTER JLATIN SMALL LETTER LJLATIN CAPITAL LETTER NJLATIN CAPITAL" +
	" LETTER N WITH SMALL LETTER JLATIN SMALL LETTER NJLATIN CAPITAL LETTER A" +
	" WITH CARONLATIN SMALL LETTER A WITH CARONLATIN CAPITAL LETTER I WITH CA" +
	"RONLATIN SMALL LETTER I WITH CARONLATIN CAPITAL LETTER O WITH CARONLATIN" +
	" SMALL LETTER O WITH CARONLATIN CAPITAL LETTER U WITH CARONLATIN SMALL L" +
	"ETTER U WITH CARONLATIN CAPITAL LETTER U WITH DIAERESIS AND MACRONLATIN " +
	"SMALL LETTER U WITH DIAERESIS AND MACRONLATIN CAPITAL LETTER U WITH DIAE" +
	"RESIS AND ACUTELATIN SMALL LETTER U WITH DIAERESIS AND ACUTELATIN CAPITA" +
	"L LETTER U WITH DIAERESIS AND CARONLATIN SMALL LETTER U WITH DIAERESIS A" +
	"ND CARONLATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVELATIN SMALL LETTE" +
	"R U WITH DIAERESIS AND GRAVELATIN SMALL LETTER TURNED ELATIN CAPITAL LET" +
	"TER A WITH DIAERESIS AND MACRONLATIN SMALL LETTER A WITH DIAERESIS AND M" +
	"ACRONLATIN CAPITAL LETTER A WITH DOT ABOVE AND MACRONLATIN SMALL LETTER " +
	"A WITH DOT ABOVE AND MACRONLATIN CAPITAL LETTER AE WITH MACRONLATIN SMAL" +
	"L LETTER AE WITH MACRONLATIN CAPITAL LETTER G WITH STROKELATIN SMALL LET" +
	"TER G WITH STROKELATIN CAPITAL LETTER G WITH CARONLATIN SMALL LETTER G W" +
	"ITH CARONLATIN CAPITAL LETTER K WITH CARONLATIN SMALL LETTER K WITH CARO" +
	"NLATIN CAPITAL LETTER O WITH OGONEKLATIN SMALL LETTER O WITH OGONEKLATIN" +
	" CAPITAL LETTER O WITH OGONEK AND MACRONLATIN SMALL LETTER O WITH OGONEK" +
	" AND MACRONLATIN CAPITAL LETTER EZH WITH CARONLATIN SMALL LETTER EZH WIT" +
	"H CARONLATIN SMALL LETTER J WITH CARONLATIN CAPITAL LETTER DZLATIN CAPIT" +
	"AL LETTER D WITH SMALL LETTER ZLATIN SMALL LETTER DZLATIN CAPITAL LETTER" +
	" G WITH ACUTELATIN SMALL LETTER G WITH ACUTELATIN CAPITAL LETTER HWAIRLA" +
	"TIN CAPITAL LETTER WYNNLATIN CAPITAL LETTER N WITH GRAVELATIN SMALL LETT" +
	"ER N WITH GRAVELATIN CAPITAL LETTER A WITH RING ABOVE AND ACUTELATIN SMA" +
	"LL LETTER A WITH RING ABOVE AND ACUTELATIN CAPITAL LETTER AE WITH ACUTEL" +
	"ATIN SMALL LETTER AE WITH ACUTELATIN CAPITAL LETTER O WITH STROKE AND AC" +
	"UTELATIN SMALL LETTER O WITH STROKE AND ACUTELATIN CAPITAL LETTER A WITH" +
	" DOUBLE GRAVELATIN SMALL LETTER A WITH DOUBLE GRAVELATIN CAPITAL LETTER " +
	"A WITH INVERTED BREVELATIN SMALL LETTER A WITH INVERTED BREVELATIN CAPIT" +
	"AL LETTER E WITH DOUBLE GRAVELATIN SMALL LETTER E WITH DOUBLE GRAVELATIN" +
	" CAPITAL LETTER E WITH INVERTED BREVELATIN SMALL LETTER E WITH INVERTED " +
	"BREVELATIN CAPITAL LETTER I WITH DOUBLE GRAVELATIN SMALL LETTER I WITH D" +
	"OUBLE GRAVELATIN CAPITAL LETTER I WITH INVERTED BREVELATIN SMALL LETTER " +
	"I WITH INVERTED BREVELATIN CAPITAL LETTER O WITH DOUBLE GRAVELATIN SMALL" +
	" LETTER O WITH DOUBLE GRAVELATIN CAPITAL LETTER O WITH INVERTED BREVELAT" +
	"IN SMALL LETTER O WITH INVERTED BREVELATIN CAPITAL LETTER R WITH DOUBLE " +
	"GRAVELATIN SMALL LETTER R WITH DOUBLE GRAVELATIN CAPITAL LETTER R WITH I" +
	"NVERTED BREVELATIN SMALL LETTER R WITH INVERTED BREVELATIN CAPITAL LETTE" +
	"R U WITH DOUBLE GRAVELATIN SMALL LETTER U WITH DOUBLE GRAVELATIN CAPITAL" +
	" LETTER U WITH INVERTED BREVELATIN SMALL LETTER U WITH INVERTED BREVELAT" +
	"IN CAPITAL LETTER S WITH COMMA BELOWLATIN SMALL LETTER S WITH COMMA BELO" +
	"WLATIN CAPITAL LETTER T WITH COMMA BELOWLATIN SMALL LETTER T WITH COMMA ") + ("" +
	"BELOWLATIN CAPITAL LETTER YOGHLATIN SMALL LETTER YOGHLATIN CAPITAL LETTE" +
	"R H WITH CARONLATIN SMALL LETTER H WITH CARONLATIN CAPITAL LETTER N WITH" +
	" LONG RIGHT LEGLATIN SMALL LETTER D WITH CURLLATIN CAPITAL LETTER OULATI" +
	"N SMALL LETTER OULATIN CAPITAL LETTER Z WITH HOOKLATIN SMALL LETTER Z WI" +
	"TH HOOKLATIN CAPITAL LETTER A WITH DOT ABOVELATIN SMALL LETTER A WITH DO" +
	"T ABOVELATIN CAPITAL LETTER E WITH CEDILLALATIN SMALL LETTER E WITH CEDI" +
	"LLALATIN CAPITAL LETTER O WITH DIAERESIS AND MACRONLATIN SMALL LETTER O " +
	"WITH DIAERESIS AND MACRONLATIN CAPITAL LETTER O WITH TILDE AND MACRONLAT" +
	"IN SMALL LETTER O WITH TILDE AND MACRONLATIN CAPITAL LETTER O WITH DOT A" +
	"BOVELATIN SMALL LETTER O WITH DOT ABOVELATIN CAPITAL LETTER O WITH DOT A" +
	"BOVE AND MACRONLATIN SMALL LETTER O WITH DOT ABOVE AND MACRONLATIN CAPIT" +
	"AL LETTER Y WITH MACRONLATIN SMALL LETTER Y WITH MACRONLATIN SMALL LETTE" +
	"R L WITH CURLLATIN SMALL LETTER N WITH CURLLATIN SMALL LETTER T WITH CUR" +
	"LLATIN SMALL LETTER DOTLESS JLATIN SMALL LETTER DB DIGRAPHLATIN SMALL LE" +
	"TTER QP DIGRAPHLATIN CAPITAL LETTER A WITH STROKELATIN CAPITAL LETTER C " +
	"WITH STROKELATIN SMALL LETTER C WITH STROKELATIN CAPITAL LETTER L WITH B" +
	"ARLATIN CAPITAL LETTER T WITH DIAGONAL STROKELATIN SMALL LETTER S WITH S" +
	"WASH TAILLATIN SMALL LETTER Z WITH SWASH TAILLATIN CAPITAL LETTER GLOTTA" +
	"L STOPLATIN SMALL LETTER GLOTTAL STOPLATIN CAPITAL LETTER B WITH STROKEL" +
	"ATIN CAPITAL LETTER U BARLATIN CAPITAL LETTER TURNED VLATIN CAPITAL LETT" +
	"ER E WITH STROKELATIN SMALL LETTER E WITH STROKELATIN CAPITAL LETTER J W" +
	"ITH STROKELATIN SMALL LETTER J WITH STROKELATIN CAPITAL LETTER SMALL Q W" +
	"ITH HOOK TAILLATIN SMALL LETTER Q WITH HOOK TAILLATIN CAPITAL LETTER R W" +
	"ITH STROKELATIN SMALL LETTER R WITH STROKELATIN CAPITAL LETTER Y WITH ST" +
	"ROKELATIN SMALL LETTER Y WITH STROKELATIN SMALL LETTER TURNED ALATIN SMA" +
	"LL LETTER ALPHALATIN SMALL LETTER TURNED ALPHALATIN SMALL LETTER B WITH " +
	"HOOKLATIN SMALL LETTER OPEN OLATIN SMALL LETTER C WITH CURLLATIN SMALL L" +
	"ETTER D WITH TAILLATIN SMALL LETTER D WITH HOOKLATIN SMALL LETTER REVERS" +
	"ED ELATIN SMALL LETTER SCHWALATIN SMALL LETTER SCHWA WITH HOOKLATIN SMAL" +
	"L LETTER OPEN ELATIN SMALL LETTER REVERSED OPEN ELATIN SMALL LETTER REVE" +
	"RSED OPEN E WITH HOOKLATIN SMALL LETTER CLOSED REVERSED OPEN ELATIN SMAL" +
	"L LETTER DOTLESS J WITH STROKELATIN SMALL LETTER G WITH HOOKLATIN SMALL " +
	"LETTER SCRIPT GLATIN LETTER SMALL CAPITAL GLATIN SMALL LETTER GAMMALATIN" +
	" SMALL LETTER RAMS HORNLATIN SMALL LETTER TURNED HLATIN SMALL LETTER H W" +
	"ITH HOOKLATIN SMALL LETTER HENG WITH HOOKLATIN SMALL LETTER I WITH STROK" +
	"ELATIN SMALL LETTER IOTALATIN LETTER SMALL CAPITAL ILATIN SMALL LETTER L" +
	" WITH MIDDLE TILDELATIN SMALL LETTER L WITH BELTLATIN SMALL LETTER L WIT" +
	"H RETROFLEX HOOKLATIN SMALL LETTER LEZHLATIN SMALL LETTER TURNED MLATIN " +
	"SMALL LETTER TURNED M WITH LONG LEGLATIN SMALL LETTER M WITH HOOKLATIN S" +
	"MALL LETTER N WITH LEFT HOOKLATIN SMALL LETTER N WITH RETROFLEX HOOKLATI" +
	"N LETTER SMALL CAPITAL NLATIN SMALL LETTER BARRED OLATIN LETTER SMALL CA" +
	"PITAL OELATIN SMALL LETTER CLOSED OMEGALATIN SMALL LETTER PHILATIN SMALL" +
	" LETTER TURNED RLATIN SMALL LETTER TURNED R WITH LONG LEGLATIN SMALL LET" +
	"TER TURNED R WITH HOOKLATIN SMALL LETTER R WITH LONG LEGLATIN SMALL LETT" +
	"ER R WITH TAILLATIN SMALL LETTER R WITH FISHHOOKLATIN SMALL LETTER REVER" +
	"SED R WITH FISHHOOKLATIN LETTER SMALL CAPITAL RLATIN LETTER SMALL CAPITA" +
	"L INVERTED RLATIN SMALL LETTER S WITH HOOKLATIN SMALL LETTER ESHLATIN SM" +
	"ALL LETTER DOTLESS J WITH STROKE AND HOOKLATIN SMALL LETTER SQUAT REVERS" +
	"ED ESHLATIN SMALL LETTER ESH WITH CURLLATIN SMALL LETTER TURNED TLATIN S" +
	"MALL LETTER T WITH RETROFLEX HOOKLATIN SMALL LETTER U BARLATIN SMALL LET" +
	"TER UPSILONLATIN SMALL LETTER V WITH HOOKLATIN SMALL LETTER TURNED VLATI" +
	"N SMALL LETTER TURNED WLATIN SMALL LETTER TURNED YLATIN LETTER SMALL CAP" +
	"ITAL YLATIN SMALL LETTER Z WITH RETROFLEX HOOKLATIN SMALL LETTER Z WITH " +
	"CURLLATIN SMALL LETTER EZHLATIN SMALL LETTER EZH WITH CURLLATIN LETTER G" +
	"LOTTAL STOPLATIN LETTER PHARYNGEAL VOICED FRICATIVELATIN LETTER INVERTED" +
	" GLOTTAL STOPLATIN LETTER STRETCHED CLATIN LETTER BILABIAL CLICKLATIN LE" +
	"TTER SMALL CAPITAL BLATIN SMALL LETTER CLOSED OPEN ELATIN LETTER SMALL C" +
	"APITAL G WITH HOOKLATIN LETTER SMALL CAPITAL HLATIN SMALL LETTER J WITH " +
	"CROSSED-TAILLATIN SMALL LETTER TURNED KLATIN LETTER SMALL CAPITAL LLATIN" +
	" SMALL LETTER Q WITH HOOKLATIN LETTER GLOTTAL STOP WITH STROKELATIN LETT" +
	"ER REVERSED GLOTTAL STOP WITH STROKELATIN SMALL LETTER DZ DIGRAPHLATIN S" +
	"MALL LETTER DEZH DIGRAPHLATIN SMALL LETTER DZ DIGRAPH WITH CURLLATIN SMA" +
	"LL LETTER TS DIGRAPHLATIN SMALL LETTER TESH DIGRAPHLATIN SMALL LETTER TC" +
	" DIGRAPH WITH CURLLATIN SMALL LETTER FENG DIGRAPHLATIN SMALL LETTER LS D") + ("" +
	"IGRAPHLATIN SMALL LETTER LZ DIGRAPHLATIN LETTER BILABIAL PERCUSSIVELATIN" +
	" LETTER BIDENTAL PERCUSSIVELATIN SMALL LETTER TURNED H WITH FISHHOOKLATI" +
	"N SMALL LETTER TURNED H WITH FISHHOOK AND TAILMODIFIER LETTER SMALL HMOD" +
	"IFIER LETTER SMALL H WITH HOOKMODIFIER LETTER SMALL JMODIFIER LETTER SMA" +
	"LL RMODIFIER LETTER SMALL TURNED RMODIFIER LETTER SMALL TURNED R WITH HO" +
	"OKMODIFIER LETTER SMALL CAPITAL INVERTED RMODIFIER LETTER SMALL WMODIFIE" +
	"R LETTER SMALL YMODIFIER LETTER PRIMEMODIFIER LETTER DOUBLE PRIMEMODIFIE" +
	"R LETTER TURNED COMMAMODIFIER LETTER APOSTROPHEMODIFIER LETTER REVERSED " +
	"COMMAMODIFIER LETTER RIGHT HALF RINGMODIFIER LETTER LEFT HALF RINGMODIFI" +
	"ER LETTER GLOTTAL STOPMODIFIER LETTER REVERSED GLOTTAL STOPMODIFIER LETT" +
	"ER LEFT ARROWHEADMODIFIER LETTER RIGHT ARROWHEADMODIFIER LETTER UP ARROW" +
	"HEADMODIFIER LETTER DOWN ARROWHEADMODIFIER LETTER CIRCUMFLEX ACCENTCARON" +
	"MODIFIER LETTER VERTICAL LINEMODIFIER LETTER MACRONMODIFIER LETTER ACUTE" +
	" ACCENTMODIFIER LETTER GRAVE ACCENTMODIFIER LETTER LOW VERTICAL LINEMODI" +
	"FIER LETTER LOW MACRONMODIFIER LETTER LOW GRAVE ACCENTMODIFIER LETTER LO" +
	"W ACUTE ACCENTMODIFIER LETTER TRIANGULAR COLONMODIFIER LETTER HALF TRIAN" +
	"GULAR COLONMODIFIER LETTER CENTRED RIGHT HALF RINGMODIFIER LETTER CENTRE" +
	"D LEFT HALF RINGMODIFIER LETTER UP TACKMODIFIER LETTER DOWN TACKMODIFIER" +
	" LETTER PLUS SIGNMODIFIER LETTER MINUS SIGNBREVEDOT ABOVERING ABOVEOGONE" +
	"KSMALL TILDEDOUBLE ACUTE ACCENTMODIFIER LETTER RHOTIC HOOKMODIFIER LETTE" +
	"R CROSS ACCENTMODIFIER LETTER SMALL GAMMAMODIFIER LETTER SMALL LMODIFIER" +
	" LETTER SMALL SMODIFIER LETTER SMALL XMODIFIER LETTER SMALL REVERSED GLO" +
	"TTAL STOPMODIFIER LETTER EXTRA-HIGH TONE BARMODIFIER LETTER HIGH TONE BA" +
	"RMODIFIER LETTER MID TONE BARMODIFIER LETTER LOW TONE BARMODIFIER LETTER" +
	" EXTRA-LOW TONE BARMODIFIER LETTER YIN DEPARTING TONE MARKMODIFIER LETTE" +
	"R YANG DEPARTING TONE MARKMODIFIER LETTER VOICINGMODIFIER LETTER UNASPIR" +
	"ATEDMODIFIER LETTER DOUBLE APOSTROPHEMODIFIER LETTER LOW DOWN ARROWHEADM" +
	"ODIFIER LETTER LOW UP ARROWHEADMODIFIER LETTER LOW LEFT ARROWHEADMODIFIE" +
	"R LETTER LOW RIGHT ARROWHEADMODIFIER LETTER LOW RINGMODIFIER LETTER MIDD" +
	"LE GRAVE ACCENTMODIFIER LETTER MIDDLE DOUBLE GRAVE ACCENTMODIFIER LETTER" +
	" MIDDLE DOUBLE ACUTE ACCENTMODIFIER LETTER LOW TILDEMODIFIER LETTER RAIS" +
	"ED COLONMODIFIER LETTER BEGIN HIGH TONEMODIFIER LETTER END HIGH TONEMODI" +
	"FIER LETTER BEGIN LOW TONEMODIFIER LETTER END LOW TONEMODIFIER LETTER SH" +
	"ELFMODIFIER LETTER OPEN SHELFMODIFIER LETTER LOW LEFT ARROWCOMBINING GRA" +
	"VE ACCENTCOMBINING ACUTE ACCENTCOMBINING CIRCUMFLEX ACCENTCOMBINING TILD" +
	"ECOMBINING MACRONCOMBINING OVERLINECOMBINING BREVECOMBINING DOT ABOVECOM" +
	"BINING DIAERESISCOMBINING HOOK ABOVECOMBINING RING ABOVECOMBINING DOUBLE" +
	" ACUTE ACCENTCOMBINING CARONCOMBINING VERTICAL LINE ABOVECOMBINING DOUBL" +
	"E VERTICAL LINE ABOVECOMBINING DOUBLE GRAVE ACCENTCOMBINING CANDRABINDUC" +
	"OMBINING INVERTED BREVECOMBINING TURNED COMMA ABOVECOMBINING COMMA ABOVE" +
	"COMBINING REVERSED COMMA ABOVECOMBINING COMMA ABOVE RIGHTCOMBINING GRAVE" +
	" ACCENT BELOWCOMBINING ACUTE ACCENT BELOWCOMBINING LEFT TACK BELOWCOMBIN" +
	"ING RIGHT TACK BELOWCOMBINING LEFT ANGLE ABOVECOMBINING HORNCOMBINING LE" +
	"FT HALF RING BELOWCOMBINING UP TACK BELOWCOMBINING DOWN TACK BELOWCOMBIN" +
	"ING PLUS SIGN BELOWCOMBINING MINUS SIGN BELOWCOMBINING PALATALIZED HOOK " +
	"BELOWCOMBINING RETROFLEX HOOK BELOWCOMBINING DOT BELOWCOMBINING DIAERESI" +
	"S BELOWCOMBINING RING BELOWCOMBINING COMMA BELOWCOMBINING CEDILLACOMBINI" +
	"NG OGONEKCOMBINING VERTICAL LINE BELOWCOMBINING BRIDGE BELOWCOMBINING IN" +
	"VERTED DOUBLE ARCH BELOWCOMBINING CARON BELOWCOMBINING CIRCUMFLEX ACCENT" +
	" BELOWCOMBINING BREVE BELOWCOMBINING INVERTED BREVE BELOWCOMBINING TILDE" +
	" BELOWCOMBINING MACRON BELOWCOMBINING LOW LINECOMBINING DOUBLE LOW LINEC" +
	"OMBINING TILDE OVERLAYCOMBINING SHORT STROKE OVERLAYCOMBINING LONG STROK" +
	"E OVERLAYCOMBINING SHORT SOLIDUS OVERLAYCOMBINING LONG SOLIDUS OVERLAYCO" +
	"MBINING RIGHT HALF RING BELOWCOMBINING INVERTED BRIDGE BELOWCOMBINING SQ" +
	"UARE BELOWCOMBINING SEAGULL BELOWCOMBINING X ABOVECOMBINING VERTICAL TIL" +
	"DECOMBINING DOUBLE OVERLINECOMBINING GRAVE TONE MARKCOMBINING ACUTE TONE" +
	" MARKCOMBINING GREEK PERISPOMENICOMBINING GREEK KORONISCOMBINING GREEK D" +
	"IALYTIKA TONOSCOMBINING GREEK YPOGEGRAMMENICOMBINING BRIDGE ABOVECOMBINI" +
	"NG EQUALS SIGN BELOWCOMBINING DOUBLE VERTICAL LINE BELOWCOMBINING LEFT A" +
	"NGLE BELOWCOMBINING NOT TILDE ABOVECOMBINING HOMOTHETIC ABOVECOMBINING A" +
	"LMOST EQUAL TO ABOVECOMBINING LEFT RIGHT ARROW BELOWCOMBINING UPWARDS AR" +
	"ROW BELOWCOMBINING GRAPHEME JOINERCOMBINING RIGHT ARROWHEAD ABOVECOMBINI" +
	"NG LEFT HALF RING ABOVECOMBINING FERMATACOMBINING X BELOWCOMBINING LEFT " +
	"ARROWHEAD BELOWCOMBINING RIGHT ARROWHEAD BELOWCOMBINING RIGHT ARROWHEAD ") + ("" +
	"AND UP ARROWHEAD BELOWCOMBINING RIGHT HALF RING ABOVECOMBINING DOT ABOVE" +
	" RIGHTCOMBINING ASTERISK BELOWCOMBINING DOUBLE RING BELOWCOMBINING ZIGZA" +
	"G ABOVECOMBINING DOUBLE BREVE BELOWCOMBINING DOUBLE BREVECOMBINING DOUBL" +
	"E MACRONCOMBINING DOUBLE MACRON BELOWCOMBINING DOUBLE TILDECOMBINING DOU" +
	"BLE INVERTED BREVECOMBINING DOUBLE RIGHTWARDS ARROW BELOWCOMBINING LATIN" +
	" SMALL LETTER ACOMBINING LATIN SMALL LETTER ECOMBINING LATIN SMALL LETTE" +
	"R ICOMBINING LATIN SMALL LETTER OCOMBINING LATIN SMALL LETTER UCOMBINING" +
	" LATIN SMALL LETTER CCOMBINING LATIN SMALL LETTER DCOMBINING LATIN SMALL" +
	" LETTER HCOMBINING LATIN SMALL LETTER MCOMBINING LATIN SMALL LETTER RCOM" +
	"BINING LATIN SMALL LETTER TCOMBINING LATIN SMALL LETTER VCOMBINING LATIN" +
	" SMALL LETTER XGREEK CAPITAL LETTER HETAGREEK SMALL LETTER HETAGREEK CAP" +
	"ITAL LETTER ARCHAIC SAMPIGREEK SMALL LETTER ARCHAIC SAMPIGREEK NUMERAL S" +
	"IGNGREEK LOWER NUMERAL SIGNGREEK CAPITAL LETTER PAMPHYLIAN DIGAMMAGREEK " +
	"SMALL LETTER PAMPHYLIAN DIGAMMAGREEK YPOGEGRAMMENIGREEK SMALL REVERSED L" +
	"UNATE SIGMA SYMBOLGREEK SMALL DOTTED LUNATE SIGMA SYMBOLGREEK SMALL REVE" +
	"RSED DOTTED LUNATE SIGMA SYMBOLGREEK QUESTION MARKGREEK CAPITAL LETTER Y" +
	"OTGREEK TONOSGREEK DIALYTIKA TONOSGREEK CAPITAL LETTER ALPHA WITH TONOSG" +
	"REEK ANO TELEIAGREEK CAPITAL LETTER EPSILON WITH TONOSGREEK CAPITAL LETT" +
	"ER ETA WITH TONOSGREEK CAPITAL LETTER IOTA WITH TONOSGREEK CAPITAL LETTE" +
	"R OMICRON WITH TONOSGREEK CAPITAL LETTER UPSILON WITH TONOSGREEK CAPITAL" +
	" LETTER OMEGA WITH TONOSGREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS" +
	"GREEK CAPITAL LETTER ALPHAGREEK CAPITAL LETTER BETAGREEK CAPITAL LETTER " +
	"GAMMAGREEK CAPITAL LETTER DELTAGREEK CAPITAL LETTER EPSILONGREEK CAPITAL" +
	" LETTER ZETAGREEK CAPITAL LETTER ETAGREEK CAPITAL LETTER THETAGREEK CAPI" +
	"TAL LETTER IOTAGREEK CAPITAL LETTER KAPPAGREEK CAPITAL LETTER LAMDAGREEK" +
	" CAPITAL LETTER MUGREEK CAPITAL LETTER NUGREEK CAPITAL LETTER XIGREEK CA" +
	"PITAL LETTER OMICRONGREEK CAPITAL LETTER PIGREEK CAPITAL LETTER RHOGREEK" +
	" CAPITAL LETTER SIGMAGREEK CAPITAL LETTER TAUGREEK CAPITAL LETTER UPSILO" +
	"NGREEK CAPITAL LETTER PHIGREEK CAPITAL LETTER CHIGREEK CAPITAL LETTER PS" +
	"IGREEK CAPITAL LETTER OMEGAGREEK CAPITAL LETTER IOTA WITH DIALYTIKAGREEK" +
	" CAPITAL LETTER UPSILON WITH DIALYTIKAGREEK SMALL LETTER ALPHA WITH TONO" +
	"SGREEK SMALL LETTER EPSILON WITH TONOSGREEK SMALL LETTER ETA WITH TONOSG" +
	"REEK SMALL LETTER IOTA WITH TONOSGREEK SMALL LETTER UPSILON WITH DIALYTI" +
	"KA AND TONOSGREEK SMALL LETTER ALPHAGREEK SMALL LETTER BETAGREEK SMALL L" +
	"ETTER GAMMAGREEK SMALL LETTER DELTAGREEK SMALL LETTER EPSILONGREEK SMALL" +
	" LETTER ZETAGREEK SMALL LETTER ETAGREEK SMALL LETTER THETAGREEK SMALL LE" +
	"TTER IOTAGREEK SMALL LETTER KAPPAGREEK SMALL LETTER LAMDAGREEK SMALL LET" +
	"TER MUGREEK SMALL LETTER NUGREEK SMALL LETTER XIGREEK SMALL LETTER OMICR" +
	"ONGREEK SMALL LETTER PIGREEK SMALL LETTER RHOGREEK SMALL LETTER FINAL SI" +
	"GMAGREEK SMALL LETTER SIGMAGREEK SMALL LETTER TAUGREEK SMALL LETTER UPSI" +
	"LONGREEK SMALL LETTER PHIGREEK SMALL LETTER CHIGREEK SMALL LETTER PSIGRE" +
	"EK SMALL LETTER OMEGAGREEK SMALL LETTER IOTA WITH DIALYTIKAGREEK SMALL L" +
	"ETTER UPSILON WITH DIALYTIKAGREEK SMALL LETTER OMICRON WITH TONOSGREEK S" +
	"MALL LETTER UPSILON WITH TONOSGREEK SMALL LETTER OMEGA WITH TONOSGREEK C" +
	"APITAL KAI SYMBOLGREEK BETA SYMBOLGREEK THETA SYMBOLGREEK UPSILON WITH H" +
	"OOK SYMBOLGREEK UPSILON WITH ACUTE AND HOOK SYMBOLGREEK UPSILON WITH DIA" +
	"ERESIS AND HOOK SYMBOLGREEK PHI SYMBOLGREEK PI SYMBOLGREEK KAI SYMBOLGRE" +
	"EK LETTER ARCHAIC KOPPAGREEK SMALL LETTER ARCHAIC KOPPAGREEK LETTER STIG" +
	"MAGREEK SMALL LETTER STIGMAGREEK LETTER DIGAMMAGREEK SMALL LETTER DIGAMM" +
	"AGREEK LETTER KOPPAGREEK SMALL LETTER KOPPAGREEK LETTER SAMPIGREEK SMALL" +
	" LETTER SAMPICOPTIC CAPITAL LETTER SHEICOPTIC SMALL LETTER SHEICOPTIC CA" +
	"PITAL LETTER FEICOPTIC SMALL LETTER FEICOPTIC CAPITAL LETTER KHEICOPTIC " +
	"SMALL LETTER KHEICOPTIC CAPITAL LETTER HORICOPTIC SMALL LETTER HORICOPTI" +
	"C CAPITAL LETTER GANGIACOPTIC SMALL LETTER GANGIACOPTIC CAPITAL LETTER S" +
	"HIMACOPTIC SMALL LETTER SHIMACOPTIC CAPITAL LETTER DEICOPTIC SMALL LETTE" +
	"R DEIGREEK KAPPA SYMBOLGREEK RHO SYMBOLGREEK LUNATE SIGMA SYMBOLGREEK LE" +
	"TTER YOTGREEK CAPITAL THETA SYMBOLGREEK LUNATE EPSILON SYMBOLGREEK REVER" +
	"SED LUNATE EPSILON SYMBOLGREEK CAPITAL LETTER SHOGREEK SMALL LETTER SHOG" +
	"REEK CAPITAL LUNATE SIGMA SYMBOLGREEK CAPITAL LETTER SANGREEK SMALL LETT" +
	"ER SANGREEK RHO WITH STROKE SYMBOLGREEK CAPITAL REVERSED LUNATE SIGMA SY" +
	"MBOLGREEK CAPITAL DOTTED LUNATE SIGMA SYMBOLGREEK CAPITAL REVERSED DOTTE" +
	"D LUNATE SIGMA SYMBOLCYRILLIC CAPITAL LETTER IE WITH GRAVECYRILLIC CAPIT" +
	"AL LETTER IOCYRILLIC CAPITAL LETTER DJECYRILLIC CAPITAL LETTER GJECYRILL" +
	"IC CAPITAL LETTER UKRAINIAN IECYRILLIC CAPITAL LETTER DZECYRILLIC CAPITA") + ("" +
	"L LETTER BYELORUSSIAN-UKRAINIAN ICYRILLIC CAPITAL LETTER YICYRILLIC CAPI" +
	"TAL LETTER JECYRILLIC CAPITAL LETTER LJECYRILLIC CAPITAL LETTER NJECYRIL" +
	"LIC CAPITAL LETTER TSHECYRILLIC CAPITAL LETTER KJECYRILLIC CAPITAL LETTE" +
	"R I WITH GRAVECYRILLIC CAPITAL LETTER SHORT UCYRILLIC CAPITAL LETTER DZH" +
	"ECYRILLIC CAPITAL LETTER ACYRILLIC CAPITAL LETTER BECYRILLIC CAPITAL LET" +
	"TER VECYRILLIC CAPITAL LETTER GHECYRILLIC CAPITAL LETTER DECYRILLIC CAPI" +
	"TAL LETTER IECYRILLIC CAPITAL LETTER ZHECYRILLIC CAPITAL LETTER ZECYRILL" +
	"IC CAPITAL LETTER ICYRILLIC CAPITAL LETTER SHORT ICYRILLIC CAPITAL LETTE" +
	"R KACYRILLIC CAPITAL LETTER ELCYRILLIC CAPITAL LETTER EMCYRILLIC CAPITAL" +
	" LETTER ENCYRILLIC CAPITAL LETTER OCYRILLIC CAPITAL LETTER PECYRILLIC CA" +
	"PITAL LETTER ERCYRILLIC CAPITAL LETTER ESCYRILLIC CAPITAL LETTER TECYRIL" +
	"LIC CAPITAL LETTER UCYRILLIC CAPITAL LETTER EFCYRILLIC CAPITAL LETTER HA" +
	"CYRILLIC CAPITAL LETTER TSECYRILLIC CAPITAL LETTER CHECYRILLIC CAPITAL L" +
	"ETTER SHACYRILLIC CAPITAL LETTER SHCHACYRILLIC CAPITAL LETTER HARD SIGNC" +
	"YRILLIC CAPITAL LETTER YERUCYRILLIC CAPITAL LETTER SOFT SIGNCYRILLIC CAP" +
	"ITAL LETTER ECYRILLIC CAPITAL LETTER YUCYRILLIC CAPITAL LETTER YACYRILLI" +
	"C SMALL LETTER ACYRILLIC SMALL LETTER BECYRILLIC SMALL LETTER VECYRILLIC" +
	" SMALL LETTER GHECYRILLIC SMALL LETTER DECYRILLIC SMALL LETTER IECYRILLI" +
	"C SMALL LETTER ZHECYRILLIC SMALL LETTER ZECYRILLIC SMALL LETTER ICYRILLI" +
	"C SMALL LETTER SHORT ICYRILLIC SMALL LETTER KACYRILLIC SMALL LETTER ELCY" +
	"RILLIC SMALL LETTER EMCYRILLIC SMALL LETTER ENCYRILLIC SMALL LETTER OCYR" +
	"ILLIC SMALL LETTER PECYRILLIC SMALL LETTER ERCYRILLIC SMALL LETTER ESCYR" +
	"ILLIC SMALL LETTER TECYRILLIC SMALL LETTER UCYRILLIC SMALL LETTER EFCYRI" +
	"LLIC SMALL LETTER HACYRILLIC SMALL LETTER TSECYRILLIC SMALL LETTER CHECY" +
	"RILLIC SMALL LETTER SHACYRILLIC SMALL LETTER SHCHACYRILLIC SMALL LETTER " +
	"HARD SIGNCYRILLIC SMALL LETTER YERUCYRILLIC SMALL LETTER SOFT SIGNCYRILL" +
	"IC SMALL LETTER ECYRILLIC SMALL LETTER YUCYRILLIC SMALL LETTER YACYRILLI" +
	"C SMALL LETTER IE WITH GRAVECYRILLIC SMALL LETTER IOCYRILLIC SMALL LETTE" +
	"R DJECYRILLIC SMALL LETTER GJECYRILLIC SMALL LETTER UKRAINIAN IECYRILLIC" +
	" SMALL LETTER DZECYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN ICYRILLIC " +
	"SMALL LETTER YICYRILLIC SMALL LETTER JECYRILLIC SMALL LETTER LJECYRILLIC" +
	" SMALL LETTER NJECYRILLIC SMALL LETTER TSHECYRILLIC SMALL LETTER KJECYRI" +
	"LLIC SMALL LETTER I WITH GRAVECYRILLIC SMALL LETTER SHORT UCYRILLIC SMAL" +
	"L LETTER DZHECYRILLIC CAPITAL LETTER OMEGACYRILLIC SMALL LETTER OMEGACYR" +
	"ILLIC CAPITAL LETTER YATCYRILLIC SMALL LETTER YATCYRILLIC CAPITAL LETTER" +
	" IOTIFIED ECYRILLIC SMALL LETTER IOTIFIED ECYRILLIC CAPITAL LETTER LITTL" +
	"E YUSCYRILLIC SMALL LETTER LITTLE YUSCYRILLIC CAPITAL LETTER IOTIFIED LI" +
	"TTLE YUSCYRILLIC SMALL LETTER IOTIFIED LITTLE YUSCYRILLIC CAPITAL LETTER" +
	" BIG YUSCYRILLIC SMALL LETTER BIG YUSCYRILLIC CAPITAL LETTER IOTIFIED BI" +
	"G YUSCYRILLIC SMALL LETTER IOTIFIED BIG YUSCYRILLIC CAPITAL LETTER KSICY" +
	"RILLIC SMALL LETTER KSICYRILLIC CAPITAL LETTER PSICYRILLIC SMALL LETTER " +
	"PSICYRILLIC CAPITAL LETTER FITACYRILLIC SMALL LETTER FITACYRILLIC CAPITA" +
	"L LETTER IZHITSACYRILLIC SMALL LETTER IZHITSACYRILLIC CAPITAL LETTER IZH" +
	"ITSA WITH DOUBLE GRAVE ACCENTCYRILLIC SMALL LETTER IZHITSA WITH DOUBLE G" +
	"RAVE ACCENTCYRILLIC CAPITAL LETTER UKCYRILLIC SMALL LETTER UKCYRILLIC CA" +
	"PITAL LETTER ROUND OMEGACYRILLIC SMALL LETTER ROUND OMEGACYRILLIC CAPITA" +
	"L LETTER OMEGA WITH TITLOCYRILLIC SMALL LETTER OMEGA WITH TITLOCYRILLIC " +
	"CAPITAL LETTER OTCYRILLIC SMALL LETTER OTCYRILLIC CAPITAL LETTER KOPPACY" +
	"RILLIC SMALL LETTER KOPPACYRILLIC THOUSANDS SIGNCOMBINING CYRILLIC TITLO" +
	"COMBINING CYRILLIC PALATALIZATIONCOMBINING CYRILLIC DASIA PNEUMATACOMBIN" +
	"ING CYRILLIC PSILI PNEUMATACOMBINING CYRILLIC POKRYTIECOMBINING CYRILLIC" +
	" HUNDRED THOUSANDS SIGNCOMBINING CYRILLIC MILLIONS SIGNCYRILLIC CAPITAL " +
	"LETTER SHORT I WITH TAILCYRILLIC SMALL LETTER SHORT I WITH TAILCYRILLIC " +
	"CAPITAL LETTER SEMISOFT SIGNCYRILLIC SMALL LETTER SEMISOFT SIGNCYRILLIC " +
	"CAPITAL LETTER ER WITH TICKCYRILLIC SMALL LETTER ER WITH TICKCYRILLIC CA" +
	"PITAL LETTER GHE WITH UPTURNCYRILLIC SMALL LETTER GHE WITH UPTURNCYRILLI" +
	"C CAPITAL LETTER GHE WITH STROKECYRILLIC SMALL LETTER GHE WITH STROKECYR" +
	"ILLIC CAPITAL LETTER GHE WITH MIDDLE HOOKCYRILLIC SMALL LETTER GHE WITH " +
	"MIDDLE HOOKCYRILLIC CAPITAL LETTER ZHE WITH DESCENDERCYRILLIC SMALL LETT" +
	"ER ZHE WITH DESCENDERCYRILLIC CAPITAL LETTER ZE WITH DESCENDERCYRILLIC S" +
	"MALL LETTER ZE WITH DESCENDERCYRILLIC CAPITAL LETTER KA WITH DESCENDERCY" +
	"RILLIC SMALL LETTER KA WITH DESCENDERCYRILLIC CAPITAL LETTER KA WITH VER" +
	"TICAL STROKECYRILLIC SMALL LETTER KA WITH VERTICAL STROKECYRILLIC CAPITA" +
	"L LETTER KA WITH STROKECYRILLIC SMALL LETTER KA WITH STROKECYRILLIC CAPI") + ("" +
	"TAL LETTER BASHKIR KACYRILLIC SMALL LETTER BASHKIR KACYRILLIC CAPITAL LE" +
	"TTER EN WITH DESCENDERCYRILLIC SMALL LETTER EN WITH DESCENDERCYRILLIC CA" +
	"PITAL LIGATURE EN GHECYRILLIC SMALL LIGATURE EN GHECYRILLIC CAPITAL LETT" +
	"ER PE WITH MIDDLE HOOKCYRILLIC SMALL LETTER PE WITH MIDDLE HOOKCYRILLIC " +
	"CAPITAL LETTER ABKHASIAN HACYRILLIC SMALL LETTER ABKHASIAN HACYRILLIC CA" +
	"PITAL LETTER ES WITH DESCENDERCYRILLIC SMALL LETTER ES WITH DESCENDERCYR" +
	"ILLIC CAPITAL LETTER TE WITH DESCENDERCYRILLIC SMALL LETTER TE WITH DESC" +
	"ENDERCYRILLIC CAPITAL LETTER STRAIGHT UCYRILLIC SMALL LETTER STRAIGHT UC" +
	"YRILLIC CAPITAL LETTER STRAIGHT U WITH STROKECYRILLIC SMALL LETTER STRAI" +
	"GHT U WITH STROKECYRILLIC CAPITAL LETTER HA WITH DESCENDERCYRILLIC SMALL" +
	" LETTER HA WITH DESCENDERCYRILLIC CAPITAL LIGATURE TE TSECYRILLIC SMALL " +
	"LIGATURE TE TSECYRILLIC CAPITAL LETTER CHE WITH DESCENDERCYRILLIC SMALL " +
	"LETTER CHE WITH DESCENDERCYRILLIC CAPITAL LETTER CHE WITH VERTICAL STROK" +
	"ECYRILLIC SMALL LETTER CHE WITH VERTICAL STROKECYRILLIC CAPITAL LETTER S" +
	"HHACYRILLIC SMALL LETTER SHHACYRILLIC CAPITAL LETTER ABKHASIAN CHECYRILL" +
	"IC SMALL LETTER ABKHASIAN CHECYRILLIC CAPITAL LETTER ABKHASIAN CHE WITH " +
	"DESCENDERCYRILLIC SMALL LETTER ABKHASIAN CHE WITH DESCENDERCYRILLIC LETT" +
	"ER PALOCHKACYRILLIC CAPITAL LETTER ZHE WITH BREVECYRILLIC SMALL LETTER Z" +
	"HE WITH BREVECYRILLIC CAPITAL LETTER KA WITH HOOKCYRILLIC SMALL LETTER K" +
	"A WITH HOOKCYRILLIC CAPITAL LETTER EL WITH TAILCYRILLIC SMALL LETTER EL " +
	"WITH TAILCYRILLIC CAPITAL LETTER EN WITH HOOKCYRILLIC SMALL LETTER EN WI" +
	"TH HOOKCYRILLIC CAPITAL LETTER EN WITH TAILCYRILLIC SMALL LETTER EN WITH" +
	" TAILCYRILLIC CAPITAL LETTER KHAKASSIAN CHECYRILLIC SMALL LETTER KHAKASS" +
	"IAN CHECYRILLIC CAPITAL LETTER EM WITH TAILCYRILLIC SMALL LETTER EM WITH" +
	" TAILCYRILLIC SMALL LETTER PALOCHKACYRILLIC CAPITAL LETTER A WITH BREVEC" +
	"YRILLIC SMALL LETTER A WITH BREVECYRILLIC CAPITAL LETTER A WITH DIAERESI" +
	"SCYRILLIC SMALL LETTER A WITH DIAERESISCYRILLIC CAPITAL LIGATURE A IECYR" +
	"ILLIC SMALL LIGATURE A IECYRILLIC CAPITAL LETTER IE WITH BREVECYRILLIC S" +
	"MALL LETTER IE WITH BREVECYRILLIC CAPITAL LETTER SCHWACYRILLIC SMALL LET" +
	"TER SCHWACYRILLIC CAPITAL LETTER SCHWA WITH DIAERESISCYRILLIC SMALL LETT" +
	"ER SCHWA WITH DIAERESISCYRILLIC CAPITAL LETTER ZHE WITH DIAERESISCYRILLI" +
	"C SMALL LETTER ZHE WITH DIAERESISCYRILLIC CAPITAL LETTER ZE WITH DIAERES" +
	"ISCYRILLIC SMALL LETTER ZE WITH DIAERESISCYRILLIC CAPITAL LETTER ABKHASI" +
	"AN DZECYRILLIC SMALL LETTER ABKHASIAN DZECYRILLIC CAPITAL LETTER I WITH " +
	"MACRONCYRILLIC SMALL LETTER I WITH MACRONCYRILLIC CAPITAL LETTER I WITH " +
	"DIAERESISCYRILLIC SMALL LETTER I WITH DIAERESISCYRILLIC CAPITAL LETTER O" +
	" WITH DIAERESISCYRILLIC SMALL LETTER O WITH DIAERESISCYRILLIC CAPITAL LE" +
	"TTER BARRED OCYRILLIC SMALL LETTER BARRED OCYRILLIC CAPITAL LETTER BARRE" +
	"D O WITH DIAERESISCYRILLIC SMALL LETTER BARRED O WITH DIAERESISCYRILLIC " +
	"CAPITAL LETTER E WITH DIAERESISCYRILLIC SMALL LETTER E WITH DIAERESISCYR" +
	"ILLIC CAPITAL LETTER U WITH MACRONCYRILLIC SMALL LETTER U WITH MACRONCYR" +
	"ILLIC CAPITAL LETTER U WITH DIAERESISCYRILLIC SMALL LETTER U WITH DIAERE" +
	"SISCYRILLIC CAPITAL LETTER U WITH DOUBLE ACUTECYRILLIC SMALL LETTER U WI" +
	"TH DOUBLE ACUTECYRILLIC CAPITAL LETTER CHE WITH DIAERESISCYRILLIC SMALL " +
	"LETTER CHE WITH DIAERESISCYRILLIC CAPITAL LETTER GHE WITH DESCENDERCYRIL" +
	"LIC SMALL LETTER GHE WITH DESCENDERCYRILLIC CAPITAL LETTER YERU WITH DIA" +
	"ERESISCYRILLIC SMALL LETTER YERU WITH DIAERESISCYRILLIC CAPITAL LETTER G" +
	"HE WITH STROKE AND HOOKCYRILLIC SMALL LETTER GHE WITH STROKE AND HOOKCYR" +
	"ILLIC CAPITAL LETTER HA WITH HOOKCYRILLIC SMALL LETTER HA WITH HOOKCYRIL" +
	"LIC CAPITAL LETTER HA WITH STROKECYRILLIC SMALL LETTER HA WITH STROKECYR" +
	"ILLIC CAPITAL LETTER KOMI DECYRILLIC SMALL LETTER KOMI DECYRILLIC CAPITA" +
	"L LETTER KOMI DJECYRILLIC SMALL LETTER KOMI DJECYRILLIC CAPITAL LETTER K" +
	"OMI ZJECYRILLIC SMALL LETTER KOMI ZJECYRILLIC CAPITAL LETTER KOMI DZJECY" +
	"RILLIC SMALL LETTER KOMI DZJECYRILLIC CAPITAL LETTER KOMI LJECYRILLIC SM" +
	"ALL LETTER KOMI LJECYRILLIC CAPITAL LETTER KOMI NJECYRILLIC SMALL LETTER" +
	" KOMI NJECYRILLIC CAPITAL LETTER KOMI SJECYRILLIC SMALL LETTER KOMI SJEC" +
	"YRILLIC CAPITAL LETTER KOMI TJECYRILLIC SMALL LETTER KOMI TJECYRILLIC CA" +
	"PITAL LETTER REVERSED ZECYRILLIC SMALL LETTER REVERSED ZECYRILLIC CAPITA" +
	"L LETTER EL WITH HOOKCYRILLIC SMALL LETTER EL WITH HOOKCYRILLIC CAPITAL " +
	"LETTER LHACYRILLIC SMALL LETTER LHACYRILLIC CAPITAL LETTER RHACYRILLIC S" +
	"MALL LETTER RHACYRILLIC CAPITAL LETTER YAECYRILLIC SMALL LETTER YAECYRIL" +
	"LIC CAPITAL LETTER QACYRILLIC SMALL LETTER QACYRILLIC CAPITAL LETTER WEC" +
	"YRILLIC SMALL LETTER WECYRILLIC CAPITAL LETTER ALEUT KACYRILLIC SMALL LE" +
	"TTER ALEUT KACYRILLIC CAPITAL LETTER EL WITH MIDDLE HOOKCYRILLIC SMALL L") + ("" +
	"ETTER EL WITH MIDDLE HOOKCYRILLIC CAPITAL LETTER EN WITH MIDDLE HOOKCYRI" +
	"LLIC SMALL LETTER EN WITH MIDDLE HOOKCYRILLIC CAPITAL LETTER PE WITH DES" +
	"CENDERCYRILLIC SMALL LETTER PE WITH DESCENDERCYRILLIC CAPITAL LETTER SHH" +
	"A WITH DESCENDERCYRILLIC SMALL LETTER SHHA WITH DESCENDERCYRILLIC CAPITA" +
	"L LETTER EN WITH LEFT HOOKCYRILLIC SMALL LETTER EN WITH LEFT HOOKCYRILLI" +
	"C CAPITAL LETTER DZZHECYRILLIC SMALL LETTER DZZHECYRILLIC CAPITAL LETTER" +
	" DCHECYRILLIC SMALL LETTER DCHECYRILLIC CAPITAL LETTER EL WITH DESCENDER" +
	"CYRILLIC SMALL LETTER EL WITH DESCENDERARMENIAN CAPITAL LETTER AYBARMENI" +
	"AN CAPITAL LETTER BENARMENIAN CAPITAL LETTER GIMARMENIAN CAPITAL LETTER " +
	"DAARMENIAN CAPITAL LETTER ECHARMENIAN CAPITAL LETTER ZAARMENIAN CAPITAL " +
	"LETTER EHARMENIAN CAPITAL LETTER ETARMENIAN CAPITAL LETTER TOARMENIAN CA" +
	"PITAL LETTER ZHEARMENIAN CAPITAL LETTER INIARMENIAN CAPITAL LETTER LIWNA" +
	"RMENIAN CAPITAL LETTER XEHARMENIAN CAPITAL LETTER CAARMENIAN CAPITAL LET" +
	"TER KENARMENIAN CAPITAL LETTER HOARMENIAN CAPITAL LETTER JAARMENIAN CAPI" +
	"TAL LETTER GHADARMENIAN CAPITAL LETTER CHEHARMENIAN CAPITAL LETTER MENAR" +
	"MENIAN CAPITAL LETTER YIARMENIAN CAPITAL LETTER NOWARMENIAN CAPITAL LETT" +
	"ER SHAARMENIAN CAPITAL LETTER VOARMENIAN CAPITAL LETTER CHAARMENIAN CAPI" +
	"TAL LETTER PEHARMENIAN CAPITAL LETTER JHEHARMENIAN CAPITAL LETTER RAARME" +
	"NIAN CAPITAL LETTER SEHARMENIAN CAPITAL LETTER VEWARMENIAN CAPITAL LETTE" +
	"R TIWNARMENIAN CAPITAL LETTER REHARMENIAN CAPITAL LETTER COARMENIAN CAPI" +
	"TAL LETTER YIWNARMENIAN CAPITAL LETTER PIWRARMENIAN CAPITAL LETTER KEHAR" +
	"MENIAN CAPITAL LETTER OHARMENIAN CAPITAL LETTER FEHARMENIAN MODIFIER LET" +
	"TER LEFT HALF RINGARMENIAN APOSTROPHEARMENIAN EMPHASIS MARKARMENIAN EXCL" +
	"AMATION MARKARMENIAN COMMAARMENIAN QUESTION MARKARMENIAN ABBREVIATION MA" +
	"RKARMENIAN SMALL LETTER AYBARMENIAN SMALL LETTER BENARMENIAN SMALL LETTE" +
	"R GIMARMENIAN SMALL LETTER DAARMENIAN SMALL LETTER ECHARMENIAN SMALL LET" +
	"TER ZAARMENIAN SMALL LETTER EHARMENIAN SMALL LETTER ETARMENIAN SMALL LET" +
	"TER TOARMENIAN SMALL LETTER ZHEARMENIAN SMALL LETTER INIARMENIAN SMALL L" +
	"ETTER LIWNARMENIAN SMALL LETTER XEHARMENIAN SMALL LETTER CAARMENIAN SMAL" +
	"L LETTER KENARMENIAN SMALL LETTER HOARMENIAN SMALL LETTER JAARMENIAN SMA" +
	"LL LETTER GHADARMENIAN SMALL LETTER CHEHARMENIAN SMALL LETTER MENARMENIA" +
	"N SMALL LETTER YIARMENIAN SMALL LETTER NOWARMENIAN SMALL LETTER SHAARMEN" +
	"IAN SMALL LETTER VOARMENIAN SMALL LETTER CHAARMENIAN SMALL LETTER PEHARM" +
	"ENIAN SMALL LETTER JHEHARMENIAN SMALL LETTER RAARMENIAN SMALL LETTER SEH" +
	"ARMENIAN SMALL LETTER VEWARMENIAN SMALL LETTER TIWNARMENIAN SMALL LETTER" +
	" REHARMENIAN SMALL LETTER COARMENIAN SMALL LETTER YIWNARMENIAN SMALL LET" +
	"TER PIWRARMENIAN SMALL LETTER KEHARMENIAN SMALL LETTER OHARMENIAN SMALL " +
	"LETTER FEHARMENIAN SMALL LIGATURE ECH YIWNARMENIAN FULL STOPARMENIAN HYP" +
	"HENRIGHT-FACING ARMENIAN ETERNITY SIGNLEFT-FACING ARMENIAN ETERNITY SIGN" +
	"ARMENIAN DRAM SIGNHEBREW ACCENT ETNAHTAHEBREW ACCENT SEGOLHEBREW ACCENT " +
	"SHALSHELETHEBREW ACCENT ZAQEF QATANHEBREW ACCENT ZAQEF GADOLHEBREW ACCEN" +
	"T TIPEHAHEBREW ACCENT REVIAHEBREW ACCENT ZARQAHEBREW ACCENT PASHTAHEBREW" +
	" ACCENT YETIVHEBREW ACCENT TEVIRHEBREW ACCENT GERESHHEBREW ACCENT GERESH" +
	" MUQDAMHEBREW ACCENT GERSHAYIMHEBREW ACCENT QARNEY PARAHEBREW ACCENT TEL" +
	"ISHA GEDOLAHEBREW ACCENT PAZERHEBREW ACCENT ATNAH HAFUKHHEBREW ACCENT MU" +
	"NAHHEBREW ACCENT MAHAPAKHHEBREW ACCENT MERKHAHEBREW ACCENT MERKHA KEFULA" +
	"HEBREW ACCENT DARGAHEBREW ACCENT QADMAHEBREW ACCENT TELISHA QETANAHEBREW" +
	" ACCENT YERAH BEN YOMOHEBREW ACCENT OLEHEBREW ACCENT ILUYHEBREW ACCENT D" +
	"EHIHEBREW ACCENT ZINORHEBREW MARK MASORA CIRCLEHEBREW POINT SHEVAHEBREW " +
	"POINT HATAF SEGOLHEBREW POINT HATAF PATAHHEBREW POINT HATAF QAMATSHEBREW" +
	" POINT HIRIQHEBREW POINT TSEREHEBREW POINT SEGOLHEBREW POINT PATAHHEBREW" +
	" POINT QAMATSHEBREW POINT HOLAMHEBREW POINT HOLAM HASER FOR VAVHEBREW PO" +
	"INT QUBUTSHEBREW POINT DAGESH OR MAPIQHEBREW POINT METEGHEBREW PUNCTUATI" +
	"ON MAQAFHEBREW POINT RAFEHEBREW PUNCTUATION PASEQHEBREW POINT SHIN DOTHE" +
	"BREW POINT SIN DOTHEBREW PUNCTUATION SOF PASUQHEBREW MARK UPPER DOTHEBRE" +
	"W MARK LOWER DOTHEBREW PUNCTUATION NUN HAFUKHAHEBREW POINT QAMATS QATANH" +
	"EBREW LETTER ALEFHEBREW LETTER BETHEBREW LETTER GIMELHEBREW LETTER DALET" +
	"HEBREW LETTER HEHEBREW LETTER VAVHEBREW LETTER ZAYINHEBREW LETTER HETHEB" +
	"REW LETTER TETHEBREW LETTER YODHEBREW LETTER FINAL KAFHEBREW LETTER KAFH" +
	"EBREW LETTER LAMEDHEBREW LETTER FINAL MEMHEBREW LETTER MEMHEBREW LETTER " +
	"FINAL NUNHEBREW LETTER NUNHEBREW LETTER SAMEKHHEBREW LETTER AYINHEBREW L" +
	"ETTER FINAL PEHEBREW LETTER PEHEBREW LETTER FINAL TSADIHEBREW LETTER TSA" +
	"DIHEBREW LETTER QOFHEBREW LETTER RESHHEBREW LETTER SHINHEBREW LETTER TAV" +
	"HEBREW LIGATURE YIDDISH DOUBLE VAVHEBREW LIGATURE YIDDISH VAV YODHEBREW ") + ("" +
	"LIGATURE YIDDISH DOUBLE YODHEBREW PUNCTUATION GERESHHEBREW PUNCTUATION G" +
	"ERSHAYIMARABIC NUMBER SIGNARABIC SIGN SANAHARABIC FOOTNOTE MARKERARABIC " +
	"SIGN SAFHAARABIC SIGN SAMVATARABIC NUMBER MARK ABOVEARABIC-INDIC CUBE RO" +
	"OTARABIC-INDIC FOURTH ROOTARABIC RAYARABIC-INDIC PER MILLE SIGNARABIC-IN" +
	"DIC PER TEN THOUSAND SIGNAFGHANI SIGNARABIC COMMAARABIC DATE SEPARATORAR" +
	"ABIC POETIC VERSE SIGNARABIC SIGN MISRAARABIC SIGN SALLALLAHOU ALAYHE WA" +
	"SSALLAMARABIC SIGN ALAYHE ASSALLAMARABIC SIGN RAHMATULLAH ALAYHEARABIC S" +
	"IGN RADI ALLAHOU ANHUARABIC SIGN TAKHALLUSARABIC SMALL HIGH TAHARABIC SM" +
	"ALL HIGH LIGATURE ALEF WITH LAM WITH YEHARABIC SMALL HIGH ZAINARABIC SMA" +
	"LL FATHAARABIC SMALL DAMMAARABIC SMALL KASRAARABIC SEMICOLONARABIC LETTE" +
	"R MARKARABIC TRIPLE DOT PUNCTUATION MARKARABIC QUESTION MARKARABIC LETTE" +
	"R KASHMIRI YEHARABIC LETTER HAMZAARABIC LETTER ALEF WITH MADDA ABOVEARAB" +
	"IC LETTER ALEF WITH HAMZA ABOVEARABIC LETTER WAW WITH HAMZA ABOVEARABIC " +
	"LETTER ALEF WITH HAMZA BELOWARABIC LETTER YEH WITH HAMZA ABOVEARABIC LET" +
	"TER ALEFARABIC LETTER BEHARABIC LETTER TEH MARBUTAARABIC LETTER TEHARABI" +
	"C LETTER THEHARABIC LETTER JEEMARABIC LETTER HAHARABIC LETTER KHAHARABIC" +
	" LETTER DALARABIC LETTER THALARABIC LETTER REHARABIC LETTER ZAINARABIC L" +
	"ETTER SEENARABIC LETTER SHEENARABIC LETTER SADARABIC LETTER DADARABIC LE" +
	"TTER TAHARABIC LETTER ZAHARABIC LETTER AINARABIC LETTER GHAINARABIC LETT" +
	"ER KEHEH WITH TWO DOTS ABOVEARABIC LETTER KEHEH WITH THREE DOTS BELOWARA" +
	"BIC LETTER FARSI YEH WITH INVERTED VARABIC LETTER FARSI YEH WITH TWO DOT" +
	"S ABOVEARABIC LETTER FARSI YEH WITH THREE DOTS ABOVEARABIC TATWEELARABIC" +
	" LETTER FEHARABIC LETTER QAFARABIC LETTER KAFARABIC LETTER LAMARABIC LET" +
	"TER MEEMARABIC LETTER NOONARABIC LETTER HEHARABIC LETTER WAWARABIC LETTE" +
	"R ALEF MAKSURAARABIC LETTER YEHARABIC FATHATANARABIC DAMMATANARABIC KASR" +
	"ATANARABIC FATHAARABIC DAMMAARABIC KASRAARABIC SHADDAARABIC SUKUNARABIC " +
	"MADDAH ABOVEARABIC HAMZA ABOVEARABIC HAMZA BELOWARABIC SUBSCRIPT ALEFARA" +
	"BIC INVERTED DAMMAARABIC MARK NOON GHUNNAARABIC ZWARAKAYARABIC VOWEL SIG" +
	"N SMALL V ABOVEARABIC VOWEL SIGN INVERTED SMALL V ABOVEARABIC VOWEL SIGN" +
	" DOT BELOWARABIC REVERSED DAMMAARABIC FATHA WITH TWO DOTSARABIC WAVY HAM" +
	"ZA BELOWARABIC-INDIC DIGIT ZEROARABIC-INDIC DIGIT ONEARABIC-INDIC DIGIT " +
	"TWOARABIC-INDIC DIGIT THREEARABIC-INDIC DIGIT FOURARABIC-INDIC DIGIT FIV" +
	"EARABIC-INDIC DIGIT SIXARABIC-INDIC DIGIT SEVENARABIC-INDIC DIGIT EIGHTA" +
	"RABIC-INDIC DIGIT NINEARABIC PERCENT SIGNARABIC DECIMAL SEPARATORARABIC " +
	"THOUSANDS SEPARATORARABIC FIVE POINTED STARARABIC LETTER DOTLESS BEHARAB" +
	"IC LETTER DOTLESS QAFARABIC LETTER SUPERSCRIPT ALEFARABIC LETTER ALEF WA" +
	"SLAARABIC LETTER ALEF WITH WAVY HAMZA ABOVEARABIC LETTER ALEF WITH WAVY " +
	"HAMZA BELOWARABIC LETTER HIGH HAMZAARABIC LETTER HIGH HAMZA ALEFARABIC L" +
	"ETTER HIGH HAMZA WAWARABIC LETTER U WITH HAMZA ABOVEARABIC LETTER HIGH H" +
	"AMZA YEHARABIC LETTER TTEHARABIC LETTER TTEHEHARABIC LETTER BEEHARABIC L" +
	"ETTER TEH WITH RINGARABIC LETTER TEH WITH THREE DOTS ABOVE DOWNWARDSARAB" +
	"IC LETTER PEHARABIC LETTER TEHEHARABIC LETTER BEHEHARABIC LETTER HAH WIT" +
	"H HAMZA ABOVEARABIC LETTER HAH WITH TWO DOTS VERTICAL ABOVEARABIC LETTER" +
	" NYEHARABIC LETTER DYEHARABIC LETTER HAH WITH THREE DOTS ABOVEARABIC LET" +
	"TER TCHEHARABIC LETTER TCHEHEHARABIC LETTER DDALARABIC LETTER DAL WITH R" +
	"INGARABIC LETTER DAL WITH DOT BELOWARABIC LETTER DAL WITH DOT BELOW AND " +
	"SMALL TAHARABIC LETTER DAHALARABIC LETTER DDAHALARABIC LETTER DULARABIC " +
	"LETTER DAL WITH THREE DOTS ABOVE DOWNWARDSARABIC LETTER DAL WITH FOUR DO" +
	"TS ABOVEARABIC LETTER RREHARABIC LETTER REH WITH SMALL VARABIC LETTER RE" +
	"H WITH RINGARABIC LETTER REH WITH DOT BELOWARABIC LETTER REH WITH SMALL " +
	"V BELOWARABIC LETTER REH WITH DOT BELOW AND DOT ABOVEARABIC LETTER REH W" +
	"ITH TWO DOTS ABOVEARABIC LETTER JEHARABIC LETTER REH WITH FOUR DOTS ABOV" +
	"EARABIC LETTER SEEN WITH DOT BELOW AND DOT ABOVEARABIC LETTER SEEN WITH " +
	"THREE DOTS BELOWARABIC LETTER SEEN WITH THREE DOTS BELOW AND THREE DOTS " +
	"ABOVEARABIC LETTER SAD WITH TWO DOTS BELOWARABIC LETTER SAD WITH THREE D" +
	"OTS ABOVEARABIC LETTER TAH WITH THREE DOTS ABOVEARABIC LETTER AIN WITH T" +
	"HREE DOTS ABOVEARABIC LETTER DOTLESS FEHARABIC LETTER FEH WITH DOT MOVED" +
	" BELOWARABIC LETTER FEH WITH DOT BELOWARABIC LETTER VEHARABIC LETTER FEH" +
	" WITH THREE DOTS BELOWARABIC LETTER PEHEHARABIC LETTER QAF WITH DOT ABOV" +
	"EARABIC LETTER QAF WITH THREE DOTS ABOVEARABIC LETTER KEHEHARABIC LETTER" +
	" SWASH KAFARABIC LETTER KAF WITH RINGARABIC LETTER KAF WITH DOT ABOVEARA" +
	"BIC LETTER NGARABIC LETTER KAF WITH THREE DOTS BELOWARABIC LETTER GAFARA" +
	"BIC LETTER GAF WITH RINGARABIC LETTER NGOEHARABIC LETTER GAF WITH TWO DO" +
	"TS BELOWARABIC LETTER GUEHARABIC LETTER GAF WITH THREE DOTS ABOVEARABIC ") + ("" +
	"LETTER LAM WITH SMALL VARABIC LETTER LAM WITH DOT ABOVEARABIC LETTER LAM" +
	" WITH THREE DOTS ABOVEARABIC LETTER LAM WITH THREE DOTS BELOWARABIC LETT" +
	"ER NOON WITH DOT BELOWARABIC LETTER NOON GHUNNAARABIC LETTER RNOONARABIC" +
	" LETTER NOON WITH RINGARABIC LETTER NOON WITH THREE DOTS ABOVEARABIC LET" +
	"TER HEH DOACHASHMEEARABIC LETTER TCHEH WITH DOT ABOVEARABIC LETTER HEH W" +
	"ITH YEH ABOVEARABIC LETTER HEH GOALARABIC LETTER HEH GOAL WITH HAMZA ABO" +
	"VEARABIC LETTER TEH MARBUTA GOALARABIC LETTER WAW WITH RINGARABIC LETTER" +
	" KIRGHIZ OEARABIC LETTER OEARABIC LETTER UARABIC LETTER YUARABIC LETTER " +
	"KIRGHIZ YUARABIC LETTER WAW WITH TWO DOTS ABOVEARABIC LETTER VEARABIC LE" +
	"TTER FARSI YEHARABIC LETTER YEH WITH TAILARABIC LETTER YEH WITH SMALL VA" +
	"RABIC LETTER WAW WITH DOT ABOVEARABIC LETTER EARABIC LETTER YEH WITH THR" +
	"EE DOTS BELOWARABIC LETTER YEH BARREEARABIC LETTER YEH BARREE WITH HAMZA" +
	" ABOVEARABIC FULL STOPARABIC LETTER AEARABIC SMALL HIGH LIGATURE SAD WIT" +
	"H LAM WITH ALEF MAKSURAARABIC SMALL HIGH LIGATURE QAF WITH LAM WITH ALEF" +
	" MAKSURAARABIC SMALL HIGH MEEM INITIAL FORMARABIC SMALL HIGH LAM ALEFARA" +
	"BIC SMALL HIGH JEEMARABIC SMALL HIGH THREE DOTSARABIC SMALL HIGH SEENARA" +
	"BIC END OF AYAHARABIC START OF RUB EL HIZBARABIC SMALL HIGH ROUNDED ZERO" +
	"ARABIC SMALL HIGH UPRIGHT RECTANGULAR ZEROARABIC SMALL HIGH DOTLESS HEAD" +
	" OF KHAHARABIC SMALL HIGH MEEM ISOLATED FORMARABIC SMALL LOW SEENARABIC " +
	"SMALL HIGH MADDAARABIC SMALL WAWARABIC SMALL YEHARABIC SMALL HIGH YEHARA" +
	"BIC SMALL HIGH NOONARABIC PLACE OF SAJDAHARABIC EMPTY CENTRE LOW STOPARA" +
	"BIC EMPTY CENTRE HIGH STOPARABIC ROUNDED HIGH STOP WITH FILLED CENTREARA" +
	"BIC SMALL LOW MEEMARABIC LETTER DAL WITH INVERTED VARABIC LETTER REH WIT" +
	"H INVERTED VEXTENDED ARABIC-INDIC DIGIT ZEROEXTENDED ARABIC-INDIC DIGIT " +
	"ONEEXTENDED ARABIC-INDIC DIGIT TWOEXTENDED ARABIC-INDIC DIGIT THREEEXTEN" +
	"DED ARABIC-INDIC DIGIT FOUREXTENDED ARABIC-INDIC DIGIT FIVEEXTENDED ARAB" +
	"IC-INDIC DIGIT SIXEXTENDED ARABIC-INDIC DIGIT SEVENEXTENDED ARABIC-INDIC" +
	" DIGIT EIGHTEXTENDED ARABIC-INDIC DIGIT NINEARABIC LETTER SHEEN WITH DOT" +
	" BELOWARABIC LETTER DAD WITH DOT BELOWARABIC LETTER GHAIN WITH DOT BELOW" +
	"ARABIC SIGN SINDHI AMPERSANDARABIC SIGN SINDHI POSTPOSITION MENARABIC LE" +
	"TTER HEH WITH INVERTED VSYRIAC END OF PARAGRAPHSYRIAC SUPRALINEAR FULL S" +
	"TOPSYRIAC SUBLINEAR FULL STOPSYRIAC SUPRALINEAR COLONSYRIAC SUBLINEAR CO" +
	"LONSYRIAC HORIZONTAL COLONSYRIAC COLON SKEWED LEFTSYRIAC COLON SKEWED RI" +
	"GHTSYRIAC SUPRALINEAR COLON SKEWED LEFTSYRIAC SUBLINEAR COLON SKEWED RIG" +
	"HTSYRIAC CONTRACTIONSYRIAC HARKLEAN OBELUSSYRIAC HARKLEAN METOBELUSSYRIA" +
	"C HARKLEAN ASTERISCUSSYRIAC ABBREVIATION MARKSYRIAC LETTER ALAPHSYRIAC L" +
	"ETTER SUPERSCRIPT ALAPHSYRIAC LETTER BETHSYRIAC LETTER GAMALSYRIAC LETTE" +
	"R GAMAL GARSHUNISYRIAC LETTER DALATHSYRIAC LETTER DOTLESS DALATH RISHSYR" +
	"IAC LETTER HESYRIAC LETTER WAWSYRIAC LETTER ZAINSYRIAC LETTER HETHSYRIAC" +
	" LETTER TETHSYRIAC LETTER TETH GARSHUNISYRIAC LETTER YUDHSYRIAC LETTER Y" +
	"UDH HESYRIAC LETTER KAPHSYRIAC LETTER LAMADHSYRIAC LETTER MIMSYRIAC LETT" +
	"ER NUNSYRIAC LETTER SEMKATHSYRIAC LETTER FINAL SEMKATHSYRIAC LETTER ESYR" +
	"IAC LETTER PESYRIAC LETTER REVERSED PESYRIAC LETTER SADHESYRIAC LETTER Q" +
	"APHSYRIAC LETTER RISHSYRIAC LETTER SHINSYRIAC LETTER TAWSYRIAC LETTER PE" +
	"RSIAN BHETHSYRIAC LETTER PERSIAN GHAMALSYRIAC LETTER PERSIAN DHALATHSYRI" +
	"AC PTHAHA ABOVESYRIAC PTHAHA BELOWSYRIAC PTHAHA DOTTEDSYRIAC ZQAPHA ABOV" +
	"ESYRIAC ZQAPHA BELOWSYRIAC ZQAPHA DOTTEDSYRIAC RBASA ABOVESYRIAC RBASA B" +
	"ELOWSYRIAC DOTTED ZLAMA HORIZONTALSYRIAC DOTTED ZLAMA ANGULARSYRIAC HBAS" +
	"A ABOVESYRIAC HBASA BELOWSYRIAC HBASA-ESASA DOTTEDSYRIAC ESASA ABOVESYRI" +
	"AC ESASA BELOWSYRIAC RWAHASYRIAC FEMININE DOTSYRIAC QUSHSHAYASYRIAC RUKK" +
	"AKHASYRIAC TWO VERTICAL DOTS ABOVESYRIAC TWO VERTICAL DOTS BELOWSYRIAC T" +
	"HREE DOTS ABOVESYRIAC THREE DOTS BELOWSYRIAC OBLIQUE LINE ABOVESYRIAC OB" +
	"LIQUE LINE BELOWSYRIAC MUSICSYRIAC BARREKHSYRIAC LETTER SOGDIAN ZHAINSYR" +
	"IAC LETTER SOGDIAN KHAPHSYRIAC LETTER SOGDIAN FEARABIC LETTER BEH WITH T" +
	"HREE DOTS HORIZONTALLY BELOWARABIC LETTER BEH WITH DOT BELOW AND THREE D" +
	"OTS ABOVEARABIC LETTER BEH WITH THREE DOTS POINTING UPWARDS BELOWARABIC " +
	"LETTER BEH WITH THREE DOTS POINTING UPWARDS BELOW AND TWO DOTS ABOVEARAB" +
	"IC LETTER BEH WITH TWO DOTS BELOW AND DOT ABOVEARABIC LETTER BEH WITH IN" +
	"VERTED SMALL V BELOWARABIC LETTER BEH WITH SMALL VARABIC LETTER HAH WITH" +
	" TWO DOTS ABOVEARABIC LETTER HAH WITH THREE DOTS POINTING UPWARDS BELOWA" +
	"RABIC LETTER DAL WITH TWO DOTS VERTICALLY BELOW AND SMALL TAHARABIC LETT" +
	"ER DAL WITH INVERTED SMALL V BELOWARABIC LETTER REH WITH STROKEARABIC LE" +
	"TTER SEEN WITH FOUR DOTS ABOVEARABIC LETTER AIN WITH TWO DOTS ABOVEARABI" +
	"C LETTER AIN WITH THREE DOTS POINTING DOWNWARDS ABOVEARABIC LETTER AIN W") + ("" +
	"ITH TWO DOTS VERTICALLY ABOVEARABIC LETTER FEH WITH TWO DOTS BELOWARABIC" +
	" LETTER FEH WITH THREE DOTS POINTING UPWARDS BELOWARABIC LETTER KEHEH WI" +
	"TH DOT ABOVEARABIC LETTER KEHEH WITH THREE DOTS ABOVEARABIC LETTER KEHEH" +
	" WITH THREE DOTS POINTING UPWARDS BELOWARABIC LETTER MEEM WITH DOT ABOVE" +
	"ARABIC LETTER MEEM WITH DOT BELOWARABIC LETTER NOON WITH TWO DOTS BELOWA" +
	"RABIC LETTER NOON WITH SMALL TAHARABIC LETTER NOON WITH SMALL VARABIC LE" +
	"TTER LAM WITH BARARABIC LETTER REH WITH TWO DOTS VERTICALLY ABOVEARABIC " +
	"LETTER REH WITH HAMZA ABOVEARABIC LETTER SEEN WITH TWO DOTS VERTICALLY A" +
	"BOVEARABIC LETTER HAH WITH SMALL ARABIC LETTER TAH BELOWARABIC LETTER HA" +
	"H WITH SMALL ARABIC LETTER TAH AND TWO DOTSARABIC LETTER SEEN WITH SMALL" +
	" ARABIC LETTER TAH AND TWO DOTSARABIC LETTER REH WITH SMALL ARABIC LETTE" +
	"R TAH AND TWO DOTSARABIC LETTER HAH WITH SMALL ARABIC LETTER TAH ABOVEAR" +
	"ABIC LETTER ALEF WITH EXTENDED ARABIC-INDIC DIGIT TWO ABOVEARABIC LETTER" +
	" ALEF WITH EXTENDED ARABIC-INDIC DIGIT THREE ABOVEARABIC LETTER FARSI YE" +
	"H WITH EXTENDED ARABIC-INDIC DIGIT TWO ABOVEARABIC LETTER FARSI YEH WITH" +
	" EXTENDED ARABIC-INDIC DIGIT THREE ABOVEARABIC LETTER FARSI YEH WITH EXT" +
	"ENDED ARABIC-INDIC DIGIT FOUR BELOWARABIC LETTER WAW WITH EXTENDED ARABI" +
	"C-INDIC DIGIT TWO ABOVEARABIC LETTER WAW WITH EXTENDED ARABIC-INDIC DIGI" +
	"T THREE ABOVEARABIC LETTER YEH BARREE WITH EXTENDED ARABIC-INDIC DIGIT T" +
	"WO ABOVEARABIC LETTER YEH BARREE WITH EXTENDED ARABIC-INDIC DIGIT THREE " +
	"ABOVEARABIC LETTER HAH WITH EXTENDED ARABIC-INDIC DIGIT FOUR BELOWARABIC" +
	" LETTER SEEN WITH EXTENDED ARABIC-INDIC DIGIT FOUR ABOVEARABIC LETTER SE" +
	"EN WITH INVERTED VARABIC LETTER KAF WITH TWO DOTS ABOVETHAANA LETTER HAA" +
	"THAANA LETTER SHAVIYANITHAANA LETTER NOONUTHAANA LETTER RAATHAANA LETTER" +
	" BAATHAANA LETTER LHAVIYANITHAANA LETTER KAAFUTHAANA LETTER ALIFUTHAANA " +
	"LETTER VAAVUTHAANA LETTER MEEMUTHAANA LETTER FAAFUTHAANA LETTER DHAALUTH" +
	"AANA LETTER THAATHAANA LETTER LAAMUTHAANA LETTER GAAFUTHAANA LETTER GNAV" +
	"IYANITHAANA LETTER SEENUTHAANA LETTER DAVIYANITHAANA LETTER ZAVIYANITHAA" +
	"NA LETTER TAVIYANITHAANA LETTER YAATHAANA LETTER PAVIYANITHAANA LETTER J" +
	"AVIYANITHAANA LETTER CHAVIYANITHAANA LETTER TTAATHAANA LETTER HHAATHAANA" +
	" LETTER KHAATHAANA LETTER THAALUTHAANA LETTER ZAATHAANA LETTER SHEENUTHA" +
	"ANA LETTER SAADHUTHAANA LETTER DAADHUTHAANA LETTER TOTHAANA LETTER ZOTHA" +
	"ANA LETTER AINUTHAANA LETTER GHAINUTHAANA LETTER QAAFUTHAANA LETTER WAAV" +
	"UTHAANA ABAFILITHAANA AABAAFILITHAANA IBIFILITHAANA EEBEEFILITHAANA UBUF" +
	"ILITHAANA OOBOOFILITHAANA EBEFILITHAANA EYBEYFILITHAANA OBOFILITHAANA OA" +
	"BOAFILITHAANA SUKUNTHAANA LETTER NAANKO DIGIT ZERONKO DIGIT ONENKO DIGIT" +
	" TWONKO DIGIT THREENKO DIGIT FOURNKO DIGIT FIVENKO DIGIT SIXNKO DIGIT SE" +
	"VENNKO DIGIT EIGHTNKO DIGIT NINENKO LETTER ANKO LETTER EENKO LETTER INKO" +
	" LETTER ENKO LETTER UNKO LETTER OONKO LETTER ONKO LETTER DAGBASINNANKO L" +
	"ETTER NNKO LETTER BANKO LETTER PANKO LETTER TANKO LETTER JANKO LETTER CH" +
	"ANKO LETTER DANKO LETTER RANKO LETTER RRANKO LETTER SANKO LETTER GBANKO " +
	"LETTER FANKO LETTER KANKO LETTER LANKO LETTER NA WOLOSONKO LETTER MANKO " +
	"LETTER NYANKO LETTER NANKO LETTER HANKO LETTER WANKO LETTER YANKO LETTER" +
	" NYA WOLOSONKO LETTER JONA JANKO LETTER JONA CHANKO LETTER JONA RANKO CO" +
	"MBINING SHORT HIGH TONENKO COMBINING SHORT LOW TONENKO COMBINING SHORT R" +
	"ISING TONENKO COMBINING LONG DESCENDING TONENKO COMBINING LONG HIGH TONE" +
	"NKO COMBINING LONG LOW TONENKO COMBINING LONG RISING TONENKO COMBINING N" +
	"ASALIZATION MARKNKO COMBINING DOUBLE DOT ABOVENKO HIGH TONE APOSTROPHENK" +
	"O LOW TONE APOSTROPHENKO SYMBOL OO DENNENNKO SYMBOL GBAKURUNENNKO COMMAN" +
	"KO EXCLAMATION MARKNKO LAJANYALANSAMARITAN LETTER ALAFSAMARITAN LETTER B" +
	"ITSAMARITAN LETTER GAMANSAMARITAN LETTER DALATSAMARITAN LETTER IYSAMARIT" +
	"AN LETTER BAASAMARITAN LETTER ZENSAMARITAN LETTER ITSAMARITAN LETTER TIT" +
	"SAMARITAN LETTER YUTSAMARITAN LETTER KAAFSAMARITAN LETTER LABATSAMARITAN" +
	" LETTER MIMSAMARITAN LETTER NUNSAMARITAN LETTER SINGAATSAMARITAN LETTER " +
	"INSAMARITAN LETTER FISAMARITAN LETTER TSAADIYSAMARITAN LETTER QUFSAMARIT" +
	"AN LETTER RISHSAMARITAN LETTER SHANSAMARITAN LETTER TAAFSAMARITAN MARK I" +
	"NSAMARITAN MARK IN-ALAFSAMARITAN MARK OCCLUSIONSAMARITAN MARK DAGESHSAMA" +
	"RITAN MODIFIER LETTER EPENTHETIC YUTSAMARITAN MARK EPENTHETIC YUTSAMARIT" +
	"AN VOWEL SIGN LONG ESAMARITAN VOWEL SIGN ESAMARITAN VOWEL SIGN OVERLONG " +
	"AASAMARITAN VOWEL SIGN LONG AASAMARITAN VOWEL SIGN AASAMARITAN VOWEL SIG" +
	"N OVERLONG ASAMARITAN VOWEL SIGN LONG ASAMARITAN VOWEL SIGN ASAMARITAN M" +
	"ODIFIER LETTER SHORT ASAMARITAN VOWEL SIGN SHORT ASAMARITAN VOWEL SIGN L" +
	"ONG USAMARITAN VOWEL SIGN USAMARITAN MODIFIER LETTER ISAMARITAN VOWEL SI" +
	"GN LONG ISAMARITAN VOWEL SIGN ISAMARITAN VOWEL SIGN OSAMARITAN VOWEL SIG") + ("" +
	"N SUKUNSAMARITAN MARK NEQUDAASAMARITAN PUNCTUATION NEQUDAASAMARITAN PUNC" +
	"TUATION AFSAAQSAMARITAN PUNCTUATION ANGEDSAMARITAN PUNCTUATION BAUSAMARI" +
	"TAN PUNCTUATION ATMAAUSAMARITAN PUNCTUATION SHIYYAALAASAMARITAN ABBREVIA" +
	"TION MARKSAMARITAN PUNCTUATION MELODIC QITSASAMARITAN PUNCTUATION ZIQAAS" +
	"AMARITAN PUNCTUATION QITSASAMARITAN PUNCTUATION ZAEFSAMARITAN PUNCTUATIO" +
	"N TURUSAMARITAN PUNCTUATION ARKAANUSAMARITAN PUNCTUATION SOF MASHFAATSAM" +
	"ARITAN PUNCTUATION ANNAAUMANDAIC LETTER HALQAMANDAIC LETTER ABMANDAIC LE" +
	"TTER AGMANDAIC LETTER ADMANDAIC LETTER AHMANDAIC LETTER USHENNAMANDAIC L" +
	"ETTER AZMANDAIC LETTER ITMANDAIC LETTER ATTMANDAIC LETTER AKSAMANDAIC LE" +
	"TTER AKMANDAIC LETTER ALMANDAIC LETTER AMMANDAIC LETTER ANMANDAIC LETTER" +
	" ASMANDAIC LETTER INMANDAIC LETTER APMANDAIC LETTER ASZMANDAIC LETTER AQ" +
	"MANDAIC LETTER ARMANDAIC LETTER ASHMANDAIC LETTER ATMANDAIC LETTER DUSHE" +
	"NNAMANDAIC LETTER KADMANDAIC LETTER AINMANDAIC AFFRICATION MARKMANDAIC V" +
	"OCALIZATION MARKMANDAIC GEMINATION MARKMANDAIC PUNCTUATIONARABIC LETTER " +
	"BEH WITH SMALL V BELOWARABIC LETTER BEH WITH HAMZA ABOVEARABIC LETTER JE" +
	"EM WITH TWO DOTS ABOVEARABIC LETTER TAH WITH TWO DOTS ABOVEARABIC LETTER" +
	" FEH WITH DOT BELOW AND THREE DOTS ABOVEARABIC LETTER QAF WITH DOT BELOW" +
	"ARABIC LETTER LAM WITH DOUBLE BARARABIC LETTER MEEM WITH THREE DOTS ABOV" +
	"EARABIC LETTER YEH WITH TWO DOTS BELOW AND HAMZA ABOVEARABIC LETTER YEH " +
	"WITH TWO DOTS BELOW AND DOT ABOVEARABIC LETTER REH WITH LOOPARABIC LETTE" +
	"R WAW WITH DOT WITHINARABIC LETTER ROHINGYA YEHARABIC LETTER LOW ALEFARA" +
	"BIC LETTER DAL WITH THREE DOTS BELOWARABIC LETTER SAD WITH THREE DOTS BE" +
	"LOWARABIC LETTER GAF WITH INVERTED STROKEARABIC LETTER STRAIGHT WAWARABI" +
	"C LETTER ZAIN WITH INVERTED V ABOVEARABIC LETTER AIN WITH THREE DOTS BEL" +
	"OWARABIC LETTER KAF WITH DOT BELOWARABIC LETTER BEH WITH SMALL MEEM ABOV" +
	"EARABIC LETTER PEH WITH SMALL MEEM ABOVEARABIC LETTER TEH WITH SMALL TEH" +
	" ABOVEARABIC LETTER REH WITH SMALL NOON ABOVEARABIC LETTER YEH WITH TWO " +
	"DOTS BELOW AND SMALL NOON ABOVEARABIC LETTER AFRICAN FEHARABIC LETTER AF" +
	"RICAN QAFARABIC LETTER AFRICAN NOONARABIC SMALL HIGH WORD AR-RUBARABIC S" +
	"MALL HIGH SADARABIC SMALL HIGH AINARABIC SMALL HIGH QAFARABIC SMALL HIGH" +
	" NOON WITH KASRAARABIC SMALL LOW NOON WITH KASRAARABIC SMALL HIGH WORD A" +
	"TH-THALATHAARABIC SMALL HIGH WORD AS-SAJDAARABIC SMALL HIGH WORD AN-NISF" +
	"ARABIC SMALL HIGH WORD SAKTAARABIC SMALL HIGH WORD QIFARABIC SMALL HIGH " +
	"WORD WAQFAARABIC SMALL HIGH FOOTNOTE MARKERARABIC SMALL HIGH SIGN SAFHAA" +
	"RABIC DISPUTED END OF AYAHARABIC TURNED DAMMA BELOWARABIC CURLY FATHAARA" +
	"BIC CURLY DAMMAARABIC CURLY KASRAARABIC CURLY FATHATANARABIC CURLY DAMMA" +
	"TANARABIC CURLY KASRATANARABIC TONE ONE DOT ABOVEARABIC TONE TWO DOTS AB" +
	"OVEARABIC TONE LOOP ABOVEARABIC TONE ONE DOT BELOWARABIC TONE TWO DOTS B" +
	"ELOWARABIC TONE LOOP BELOWARABIC OPEN FATHATANARABIC OPEN DAMMATANARABIC" +
	" OPEN KASRATANARABIC SMALL HIGH WAWARABIC FATHA WITH RINGARABIC FATHA WI" +
	"TH DOT ABOVEARABIC KASRA WITH DOT BELOWARABIC LEFT ARROWHEAD ABOVEARABIC" +
	" RIGHT ARROWHEAD ABOVEARABIC LEFT ARROWHEAD BELOWARABIC RIGHT ARROWHEAD " +
	"BELOWARABIC DOUBLE RIGHT ARROWHEAD ABOVEARABIC DOUBLE RIGHT ARROWHEAD AB" +
	"OVE WITH DOTARABIC RIGHT ARROWHEAD ABOVE WITH DOTARABIC DAMMA WITH DOTAR" +
	"ABIC MARK SIDEWAYS NOON GHUNNADEVANAGARI SIGN INVERTED CANDRABINDUDEVANA" +
	"GARI SIGN CANDRABINDUDEVANAGARI SIGN ANUSVARADEVANAGARI SIGN VISARGADEVA" +
	"NAGARI LETTER SHORT ADEVANAGARI LETTER ADEVANAGARI LETTER AADEVANAGARI L" +
	"ETTER IDEVANAGARI LETTER IIDEVANAGARI LETTER UDEVANAGARI LETTER UUDEVANA" +
	"GARI LETTER VOCALIC RDEVANAGARI LETTER VOCALIC LDEVANAGARI LETTER CANDRA" +
	" EDEVANAGARI LETTER SHORT EDEVANAGARI LETTER EDEVANAGARI LETTER AIDEVANA" +
	"GARI LETTER CANDRA ODEVANAGARI LETTER SHORT ODEVANAGARI LETTER ODEVANAGA" +
	"RI LETTER AUDEVANAGARI LETTER KADEVANAGARI LETTER KHADEVANAGARI LETTER G" +
	"ADEVANAGARI LETTER GHADEVANAGARI LETTER NGADEVANAGARI LETTER CADEVANAGAR" +
	"I LETTER CHADEVANAGARI LETTER JADEVANAGARI LETTER JHADEVANAGARI LETTER N" +
	"YADEVANAGARI LETTER TTADEVANAGARI LETTER TTHADEVANAGARI LETTER DDADEVANA" +
	"GARI LETTER DDHADEVANAGARI LETTER NNADEVANAGARI LETTER TADEVANAGARI LETT" +
	"ER THADEVANAGARI LETTER DADEVANAGARI LETTER DHADEVANAGARI LETTER NADEVAN" +
	"AGARI LETTER NNNADEVANAGARI LETTER PADEVANAGARI LETTER PHADEVANAGARI LET" +
	"TER BADEVANAGARI LETTER BHADEVANAGARI LETTER MADEVANAGARI LETTER YADEVAN" +
	"AGARI LETTER RADEVANAGARI LETTER RRADEVANAGARI LETTER LADEVANAGARI LETTE" +
	"R LLADEVANAGARI LETTER LLLADEVANAGARI LETTER VADEVANAGARI LETTER SHADEVA" +
	"NAGARI LETTER SSADEVANAGARI LETTER SADEVANAGARI LETTER HADEVANAGARI VOWE" +
	"L SIGN OEDEVANAGARI VOWEL SIGN OOEDEVANAGARI SIGN NUKTADEVANAGARI SIGN A" +
	"VAGRAHADEVANAGARI VOWEL SIGN AADEVANAGARI VOWEL SIGN IDEVANAGARI VOWEL S") + ("" +
	"IGN IIDEVANAGARI VOWEL SIGN UDEVANAGARI VOWEL SIGN UUDEVANAGARI VOWEL SI" +
	"GN VOCALIC RDEVANAGARI VOWEL SIGN VOCALIC RRDEVANAGARI VOWEL SIGN CANDRA" +
	" EDEVANAGARI VOWEL SIGN SHORT EDEVANAGARI VOWEL SIGN EDEVANAGARI VOWEL S" +
	"IGN AIDEVANAGARI VOWEL SIGN CANDRA ODEVANAGARI VOWEL SIGN SHORT ODEVANAG" +
	"ARI VOWEL SIGN ODEVANAGARI VOWEL SIGN AUDEVANAGARI SIGN VIRAMADEVANAGARI" +
	" VOWEL SIGN PRISHTHAMATRA EDEVANAGARI VOWEL SIGN AWDEVANAGARI OMDEVANAGA" +
	"RI STRESS SIGN UDATTADEVANAGARI STRESS SIGN ANUDATTADEVANAGARI GRAVE ACC" +
	"ENTDEVANAGARI ACUTE ACCENTDEVANAGARI VOWEL SIGN CANDRA LONG EDEVANAGARI " +
	"VOWEL SIGN UEDEVANAGARI VOWEL SIGN UUEDEVANAGARI LETTER QADEVANAGARI LET" +
	"TER KHHADEVANAGARI LETTER GHHADEVANAGARI LETTER ZADEVANAGARI LETTER DDDH" +
	"ADEVANAGARI LETTER RHADEVANAGARI LETTER FADEVANAGARI LETTER YYADEVANAGAR" +
	"I LETTER VOCALIC RRDEVANAGARI LETTER VOCALIC LLDEVANAGARI VOWEL SIGN VOC" +
	"ALIC LDEVANAGARI VOWEL SIGN VOCALIC LLDEVANAGARI DANDADEVANAGARI DOUBLE " +
	"DANDADEVANAGARI DIGIT ZERODEVANAGARI DIGIT ONEDEVANAGARI DIGIT TWODEVANA" +
	"GARI DIGIT THREEDEVANAGARI DIGIT FOURDEVANAGARI DIGIT FIVEDEVANAGARI DIG" +
	"IT SIXDEVANAGARI DIGIT SEVENDEVANAGARI DIGIT EIGHTDEVANAGARI DIGIT NINED" +
	"EVANAGARI ABBREVIATION SIGNDEVANAGARI SIGN HIGH SPACING DOTDEVANAGARI LE" +
	"TTER CANDRA ADEVANAGARI LETTER OEDEVANAGARI LETTER OOEDEVANAGARI LETTER " +
	"AWDEVANAGARI LETTER UEDEVANAGARI LETTER UUEDEVANAGARI LETTER MARWARI DDA" +
	"DEVANAGARI LETTER ZHADEVANAGARI LETTER HEAVY YADEVANAGARI LETTER GGADEVA" +
	"NAGARI LETTER JJADEVANAGARI LETTER GLOTTAL STOPDEVANAGARI LETTER DDDADEV" +
	"ANAGARI LETTER BBABENGALI ANJIBENGALI SIGN CANDRABINDUBENGALI SIGN ANUSV" +
	"ARABENGALI SIGN VISARGABENGALI LETTER ABENGALI LETTER AABENGALI LETTER I" +
	"BENGALI LETTER IIBENGALI LETTER UBENGALI LETTER UUBENGALI LETTER VOCALIC" +
	" RBENGALI LETTER VOCALIC LBENGALI LETTER EBENGALI LETTER AIBENGALI LETTE" +
	"R OBENGALI LETTER AUBENGALI LETTER KABENGALI LETTER KHABENGALI LETTER GA" +
	"BENGALI LETTER GHABENGALI LETTER NGABENGALI LETTER CABENGALI LETTER CHAB" +
	"ENGALI LETTER JABENGALI LETTER JHABENGALI LETTER NYABENGALI LETTER TTABE" +
	"NGALI LETTER TTHABENGALI LETTER DDABENGALI LETTER DDHABENGALI LETTER NNA" +
	"BENGALI LETTER TABENGALI LETTER THABENGALI LETTER DABENGALI LETTER DHABE" +
	"NGALI LETTER NABENGALI LETTER PABENGALI LETTER PHABENGALI LETTER BABENGA" +
	"LI LETTER BHABENGALI LETTER MABENGALI LETTER YABENGALI LETTER RABENGALI " +
	"LETTER LABENGALI LETTER SHABENGALI LETTER SSABENGALI LETTER SABENGALI LE" +
	"TTER HABENGALI SIGN NUKTABENGALI SIGN AVAGRAHABENGALI VOWEL SIGN AABENGA" +
	"LI VOWEL SIGN IBENGALI VOWEL SIGN IIBENGALI VOWEL SIGN UBENGALI VOWEL SI" +
	"GN UUBENGALI VOWEL SIGN VOCALIC RBENGALI VOWEL SIGN VOCALIC RRBENGALI VO" +
	"WEL SIGN EBENGALI VOWEL SIGN AIBENGALI VOWEL SIGN OBENGALI VOWEL SIGN AU" +
	"BENGALI SIGN VIRAMABENGALI LETTER KHANDA TABENGALI AU LENGTH MARKBENGALI" +
	" LETTER RRABENGALI LETTER RHABENGALI LETTER YYABENGALI LETTER VOCALIC RR" +
	"BENGALI LETTER VOCALIC LLBENGALI VOWEL SIGN VOCALIC LBENGALI VOWEL SIGN " +
	"VOCALIC LLBENGALI DIGIT ZEROBENGALI DIGIT ONEBENGALI DIGIT TWOBENGALI DI" +
	"GIT THREEBENGALI DIGIT FOURBENGALI DIGIT FIVEBENGALI DIGIT SIXBENGALI DI" +
	"GIT SEVENBENGALI DIGIT EIGHTBENGALI DIGIT NINEBENGALI LETTER RA WITH MID" +
	"DLE DIAGONALBENGALI LETTER RA WITH LOWER DIAGONALBENGALI RUPEE MARKBENGA" +
	"LI RUPEE SIGNBENGALI CURRENCY NUMERATOR ONEBENGALI CURRENCY NUMERATOR TW" +
	"OBENGALI CURRENCY NUMERATOR THREEBENGALI CURRENCY NUMERATOR FOURBENGALI " +
	"CURRENCY NUMERATOR ONE LESS THAN THE DENOMINATORBENGALI CURRENCY DENOMIN" +
	"ATOR SIXTEENBENGALI ISSHARBENGALI GANDA MARKGURMUKHI SIGN ADAK BINDIGURM" +
	"UKHI SIGN BINDIGURMUKHI SIGN VISARGAGURMUKHI LETTER AGURMUKHI LETTER AAG" +
	"URMUKHI LETTER IGURMUKHI LETTER IIGURMUKHI LETTER UGURMUKHI LETTER UUGUR" +
	"MUKHI LETTER EEGURMUKHI LETTER AIGURMUKHI LETTER OOGURMUKHI LETTER AUGUR" +
	"MUKHI LETTER KAGURMUKHI LETTER KHAGURMUKHI LETTER GAGURMUKHI LETTER GHAG" +
	"URMUKHI LETTER NGAGURMUKHI LETTER CAGURMUKHI LETTER CHAGURMUKHI LETTER J" +
	"AGURMUKHI LETTER JHAGURMUKHI LETTER NYAGURMUKHI LETTER TTAGURMUKHI LETTE" +
	"R TTHAGURMUKHI LETTER DDAGURMUKHI LETTER DDHAGURMUKHI LETTER NNAGURMUKHI" +
	" LETTER TAGURMUKHI LETTER THAGURMUKHI LETTER DAGURMUKHI LETTER DHAGURMUK" +
	"HI LETTER NAGURMUKHI LETTER PAGURMUKHI LETTER PHAGURMUKHI LETTER BAGURMU" +
	"KHI LETTER BHAGURMUKHI LETTER MAGURMUKHI LETTER YAGURMUKHI LETTER RAGURM" +
	"UKHI LETTER LAGURMUKHI LETTER LLAGURMUKHI LETTER VAGURMUKHI LETTER SHAGU" +
	"RMUKHI LETTER SAGURMUKHI LETTER HAGURMUKHI SIGN NUKTAGURMUKHI VOWEL SIGN" +
	" AAGURMUKHI VOWEL SIGN IGURMUKHI VOWEL SIGN IIGURMUKHI VOWEL SIGN UGURMU" +
	"KHI VOWEL SIGN UUGURMUKHI VOWEL SIGN EEGURMUKHI VOWEL SIGN AIGURMUKHI VO" +
	"WEL SIGN OOGURMUKHI VOWEL SIGN AUGURMUKHI SIGN VIRAMAGURMUKHI SIGN UDAAT" +
	"GURMUKHI LETTER KHHAGURMUKHI LETTER GHHAGURMUKHI LETTER ZAGURMUKHI LETTE") + ("" +
	"R RRAGURMUKHI LETTER FAGURMUKHI DIGIT ZEROGURMUKHI DIGIT ONEGURMUKHI DIG" +
	"IT TWOGURMUKHI DIGIT THREEGURMUKHI DIGIT FOURGURMUKHI DIGIT FIVEGURMUKHI" +
	" DIGIT SIXGURMUKHI DIGIT SEVENGURMUKHI DIGIT EIGHTGURMUKHI DIGIT NINEGUR" +
	"MUKHI TIPPIGURMUKHI ADDAKGURMUKHI IRIGURMUKHI URAGURMUKHI EK ONKARGURMUK" +
	"HI SIGN YAKASHGUJARATI SIGN CANDRABINDUGUJARATI SIGN ANUSVARAGUJARATI SI" +
	"GN VISARGAGUJARATI LETTER AGUJARATI LETTER AAGUJARATI LETTER IGUJARATI L" +
	"ETTER IIGUJARATI LETTER UGUJARATI LETTER UUGUJARATI LETTER VOCALIC RGUJA" +
	"RATI LETTER VOCALIC LGUJARATI VOWEL CANDRA EGUJARATI LETTER EGUJARATI LE" +
	"TTER AIGUJARATI VOWEL CANDRA OGUJARATI LETTER OGUJARATI LETTER AUGUJARAT" +
	"I LETTER KAGUJARATI LETTER KHAGUJARATI LETTER GAGUJARATI LETTER GHAGUJAR" +
	"ATI LETTER NGAGUJARATI LETTER CAGUJARATI LETTER CHAGUJARATI LETTER JAGUJ" +
	"ARATI LETTER JHAGUJARATI LETTER NYAGUJARATI LETTER TTAGUJARATI LETTER TT" +
	"HAGUJARATI LETTER DDAGUJARATI LETTER DDHAGUJARATI LETTER NNAGUJARATI LET" +
	"TER TAGUJARATI LETTER THAGUJARATI LETTER DAGUJARATI LETTER DHAGUJARATI L" +
	"ETTER NAGUJARATI LETTER PAGUJARATI LETTER PHAGUJARATI LETTER BAGUJARATI " +
	"LETTER BHAGUJARATI LETTER MAGUJARATI LETTER YAGUJARATI LETTER RAGUJARATI" +
	" LETTER LAGUJARATI LETTER LLAGUJARATI LETTER VAGUJARATI LETTER SHAGUJARA" +
	"TI LETTER SSAGUJARATI LETTER SAGUJARATI LETTER HAGUJARATI SIGN NUKTAGUJA" +
	"RATI SIGN AVAGRAHAGUJARATI VOWEL SIGN AAGUJARATI VOWEL SIGN IGUJARATI VO" +
	"WEL SIGN IIGUJARATI VOWEL SIGN UGUJARATI VOWEL SIGN UUGUJARATI VOWEL SIG" +
	"N VOCALIC RGUJARATI VOWEL SIGN VOCALIC RRGUJARATI VOWEL SIGN CANDRA EGUJ" +
	"ARATI VOWEL SIGN EGUJARATI VOWEL SIGN AIGUJARATI VOWEL SIGN CANDRA OGUJA" +
	"RATI VOWEL SIGN OGUJARATI VOWEL SIGN AUGUJARATI SIGN VIRAMAGUJARATI OMGU" +
	"JARATI LETTER VOCALIC RRGUJARATI LETTER VOCALIC LLGUJARATI VOWEL SIGN VO" +
	"CALIC LGUJARATI VOWEL SIGN VOCALIC LLGUJARATI DIGIT ZEROGUJARATI DIGIT O" +
	"NEGUJARATI DIGIT TWOGUJARATI DIGIT THREEGUJARATI DIGIT FOURGUJARATI DIGI" +
	"T FIVEGUJARATI DIGIT SIXGUJARATI DIGIT SEVENGUJARATI DIGIT EIGHTGUJARATI" +
	" DIGIT NINEGUJARATI ABBREVIATION SIGNGUJARATI RUPEE SIGNGUJARATI LETTER " +
	"ZHAORIYA SIGN CANDRABINDUORIYA SIGN ANUSVARAORIYA SIGN VISARGAORIYA LETT" +
	"ER AORIYA LETTER AAORIYA LETTER IORIYA LETTER IIORIYA LETTER UORIYA LETT" +
	"ER UUORIYA LETTER VOCALIC RORIYA LETTER VOCALIC LORIYA LETTER EORIYA LET" +
	"TER AIORIYA LETTER OORIYA LETTER AUORIYA LETTER KAORIYA LETTER KHAORIYA " +
	"LETTER GAORIYA LETTER GHAORIYA LETTER NGAORIYA LETTER CAORIYA LETTER CHA" +
	"ORIYA LETTER JAORIYA LETTER JHAORIYA LETTER NYAORIYA LETTER TTAORIYA LET" +
	"TER TTHAORIYA LETTER DDAORIYA LETTER DDHAORIYA LETTER NNAORIYA LETTER TA" +
	"ORIYA LETTER THAORIYA LETTER DAORIYA LETTER DHAORIYA LETTER NAORIYA LETT" +
	"ER PAORIYA LETTER PHAORIYA LETTER BAORIYA LETTER BHAORIYA LETTER MAORIYA" +
	" LETTER YAORIYA LETTER RAORIYA LETTER LAORIYA LETTER LLAORIYA LETTER VAO" +
	"RIYA LETTER SHAORIYA LETTER SSAORIYA LETTER SAORIYA LETTER HAORIYA SIGN " +
	"NUKTAORIYA SIGN AVAGRAHAORIYA VOWEL SIGN AAORIYA VOWEL SIGN IORIYA VOWEL" +
	" SIGN IIORIYA VOWEL SIGN UORIYA VOWEL SIGN UUORIYA VOWEL SIGN VOCALIC RO" +
	"RIYA VOWEL SIGN VOCALIC RRORIYA VOWEL SIGN EORIYA VOWEL SIGN AIORIYA VOW" +
	"EL SIGN OORIYA VOWEL SIGN AUORIYA SIGN VIRAMAORIYA AI LENGTH MARKORIYA A" +
	"U LENGTH MARKORIYA LETTER RRAORIYA LETTER RHAORIYA LETTER YYAORIYA LETTE" +
	"R VOCALIC RRORIYA LETTER VOCALIC LLORIYA VOWEL SIGN VOCALIC LORIYA VOWEL" +
	" SIGN VOCALIC LLORIYA DIGIT ZEROORIYA DIGIT ONEORIYA DIGIT TWOORIYA DIGI" +
	"T THREEORIYA DIGIT FOURORIYA DIGIT FIVEORIYA DIGIT SIXORIYA DIGIT SEVENO" +
	"RIYA DIGIT EIGHTORIYA DIGIT NINEORIYA ISSHARORIYA LETTER WAORIYA FRACTIO" +
	"N ONE QUARTERORIYA FRACTION ONE HALFORIYA FRACTION THREE QUARTERSORIYA F" +
	"RACTION ONE SIXTEENTHORIYA FRACTION ONE EIGHTHORIYA FRACTION THREE SIXTE" +
	"ENTHSTAMIL SIGN ANUSVARATAMIL SIGN VISARGATAMIL LETTER ATAMIL LETTER AAT" +
	"AMIL LETTER ITAMIL LETTER IITAMIL LETTER UTAMIL LETTER UUTAMIL LETTER ET" +
	"AMIL LETTER EETAMIL LETTER AITAMIL LETTER OTAMIL LETTER OOTAMIL LETTER A" +
	"UTAMIL LETTER KATAMIL LETTER NGATAMIL LETTER CATAMIL LETTER JATAMIL LETT" +
	"ER NYATAMIL LETTER TTATAMIL LETTER NNATAMIL LETTER TATAMIL LETTER NATAMI" +
	"L LETTER NNNATAMIL LETTER PATAMIL LETTER MATAMIL LETTER YATAMIL LETTER R" +
	"ATAMIL LETTER RRATAMIL LETTER LATAMIL LETTER LLATAMIL LETTER LLLATAMIL L" +
	"ETTER VATAMIL LETTER SHATAMIL LETTER SSATAMIL LETTER SATAMIL LETTER HATA" +
	"MIL VOWEL SIGN AATAMIL VOWEL SIGN ITAMIL VOWEL SIGN IITAMIL VOWEL SIGN U" +
	"TAMIL VOWEL SIGN UUTAMIL VOWEL SIGN ETAMIL VOWEL SIGN EETAMIL VOWEL SIGN" +
	" AITAMIL VOWEL SIGN OTAMIL VOWEL SIGN OOTAMIL VOWEL SIGN AUTAMIL SIGN VI" +
	"RAMATAMIL OMTAMIL AU LENGTH MARKTAMIL DIGIT ZEROTAMIL DIGIT ONETAMIL DIG" +
	"IT TWOTAMIL DIGIT THREETAMIL DIGIT FOURTAMIL DIGIT FIVETAMIL DIGIT SIXTA" +
	"MIL DIGIT SEVENTAMIL DIGIT EIGHTTAMIL DIGIT NINETAMIL NUMBER TENTAMIL NU") + ("" +
	"MBER ONE HUNDREDTAMIL NUMBER ONE THOUSANDTAMIL DAY SIGNTAMIL MONTH SIGNT" +
	"AMIL YEAR SIGNTAMIL DEBIT SIGNTAMIL CREDIT SIGNTAMIL AS ABOVE SIGNTAMIL " +
	"RUPEE SIGNTAMIL NUMBER SIGNTELUGU SIGN COMBINING CANDRABINDU ABOVETELUGU" +
	" SIGN CANDRABINDUTELUGU SIGN ANUSVARATELUGU SIGN VISARGATELUGU LETTER AT" +
	"ELUGU LETTER AATELUGU LETTER ITELUGU LETTER IITELUGU LETTER UTELUGU LETT" +
	"ER UUTELUGU LETTER VOCALIC RTELUGU LETTER VOCALIC LTELUGU LETTER ETELUGU" +
	" LETTER EETELUGU LETTER AITELUGU LETTER OTELUGU LETTER OOTELUGU LETTER A" +
	"UTELUGU LETTER KATELUGU LETTER KHATELUGU LETTER GATELUGU LETTER GHATELUG" +
	"U LETTER NGATELUGU LETTER CATELUGU LETTER CHATELUGU LETTER JATELUGU LETT" +
	"ER JHATELUGU LETTER NYATELUGU LETTER TTATELUGU LETTER TTHATELUGU LETTER " +
	"DDATELUGU LETTER DDHATELUGU LETTER NNATELUGU LETTER TATELUGU LETTER THAT" +
	"ELUGU LETTER DATELUGU LETTER DHATELUGU LETTER NATELUGU LETTER PATELUGU L" +
	"ETTER PHATELUGU LETTER BATELUGU LETTER BHATELUGU LETTER MATELUGU LETTER " +
	"YATELUGU LETTER RATELUGU LETTER RRATELUGU LETTER LATELUGU LETTER LLATELU" +
	"GU LETTER LLLATELUGU LETTER VATELUGU LETTER SHATELUGU LETTER SSATELUGU L" +
	"ETTER SATELUGU LETTER HATELUGU SIGN AVAGRAHATELUGU VOWEL SIGN AATELUGU V" +
	"OWEL SIGN ITELUGU VOWEL SIGN IITELUGU VOWEL SIGN UTELUGU VOWEL SIGN UUTE" +
	"LUGU VOWEL SIGN VOCALIC RTELUGU VOWEL SIGN VOCALIC RRTELUGU VOWEL SIGN E" +
	"TELUGU VOWEL SIGN EETELUGU VOWEL SIGN AITELUGU VOWEL SIGN OTELUGU VOWEL " +
	"SIGN OOTELUGU VOWEL SIGN AUTELUGU SIGN VIRAMATELUGU LENGTH MARKTELUGU AI" +
	" LENGTH MARKTELUGU LETTER TSATELUGU LETTER DZATELUGU LETTER RRRATELUGU L" +
	"ETTER VOCALIC RRTELUGU LETTER VOCALIC LLTELUGU VOWEL SIGN VOCALIC LTELUG" +
	"U VOWEL SIGN VOCALIC LLTELUGU DIGIT ZEROTELUGU DIGIT ONETELUGU DIGIT TWO" +
	"TELUGU DIGIT THREETELUGU DIGIT FOURTELUGU DIGIT FIVETELUGU DIGIT SIXTELU" +
	"GU DIGIT SEVENTELUGU DIGIT EIGHTTELUGU DIGIT NINETELUGU FRACTION DIGIT Z" +
	"ERO FOR ODD POWERS OF FOURTELUGU FRACTION DIGIT ONE FOR ODD POWERS OF FO" +
	"URTELUGU FRACTION DIGIT TWO FOR ODD POWERS OF FOURTELUGU FRACTION DIGIT " +
	"THREE FOR ODD POWERS OF FOURTELUGU FRACTION DIGIT ONE FOR EVEN POWERS OF" +
	" FOURTELUGU FRACTION DIGIT TWO FOR EVEN POWERS OF FOURTELUGU FRACTION DI" +
	"GIT THREE FOR EVEN POWERS OF FOURTELUGU SIGN TUUMUKANNADA SIGN SPACING C" +
	"ANDRABINDUKANNADA SIGN CANDRABINDUKANNADA SIGN ANUSVARAKANNADA SIGN VISA" +
	"RGAKANNADA LETTER AKANNADA LETTER AAKANNADA LETTER IKANNADA LETTER IIKAN" +
	"NADA LETTER UKANNADA LETTER UUKANNADA LETTER VOCALIC RKANNADA LETTER VOC" +
	"ALIC LKANNADA LETTER EKANNADA LETTER EEKANNADA LETTER AIKANNADA LETTER O" +
	"KANNADA LETTER OOKANNADA LETTER AUKANNADA LETTER KAKANNADA LETTER KHAKAN" +
	"NADA LETTER GAKANNADA LETTER GHAKANNADA LETTER NGAKANNADA LETTER CAKANNA" +
	"DA LETTER CHAKANNADA LETTER JAKANNADA LETTER JHAKANNADA LETTER NYAKANNAD" +
	"A LETTER TTAKANNADA LETTER TTHAKANNADA LETTER DDAKANNADA LETTER DDHAKANN" +
	"ADA LETTER NNAKANNADA LETTER TAKANNADA LETTER THAKANNADA LETTER DAKANNAD" +
	"A LETTER DHAKANNADA LETTER NAKANNADA LETTER PAKANNADA LETTER PHAKANNADA " +
	"LETTER BAKANNADA LETTER BHAKANNADA LETTER MAKANNADA LETTER YAKANNADA LET" +
	"TER RAKANNADA LETTER RRAKANNADA LETTER LAKANNADA LETTER LLAKANNADA LETTE" +
	"R VAKANNADA LETTER SHAKANNADA LETTER SSAKANNADA LETTER SAKANNADA LETTER " +
	"HAKANNADA SIGN NUKTAKANNADA SIGN AVAGRAHAKANNADA VOWEL SIGN AAKANNADA VO" +
	"WEL SIGN IKANNADA VOWEL SIGN IIKANNADA VOWEL SIGN UKANNADA VOWEL SIGN UU" +
	"KANNADA VOWEL SIGN VOCALIC RKANNADA VOWEL SIGN VOCALIC RRKANNADA VOWEL S" +
	"IGN EKANNADA VOWEL SIGN EEKANNADA VOWEL SIGN AIKANNADA VOWEL SIGN OKANNA" +
	"DA VOWEL SIGN OOKANNADA VOWEL SIGN AUKANNADA SIGN VIRAMAKANNADA LENGTH M" +
	"ARKKANNADA AI LENGTH MARKKANNADA LETTER FAKANNADA LETTER VOCALIC RRKANNA" +
	"DA LETTER VOCALIC LLKANNADA VOWEL SIGN VOCALIC LKANNADA VOWEL SIGN VOCAL" +
	"IC LLKANNADA DIGIT ZEROKANNADA DIGIT ONEKANNADA DIGIT TWOKANNADA DIGIT T" +
	"HREEKANNADA DIGIT FOURKANNADA DIGIT FIVEKANNADA DIGIT SIXKANNADA DIGIT S" +
	"EVENKANNADA DIGIT EIGHTKANNADA DIGIT NINEKANNADA SIGN JIHVAMULIYAKANNADA" +
	" SIGN UPADHMANIYAMALAYALAM SIGN CANDRABINDUMALAYALAM SIGN ANUSVARAMALAYA" +
	"LAM SIGN VISARGAMALAYALAM LETTER AMALAYALAM LETTER AAMALAYALAM LETTER IM" +
	"ALAYALAM LETTER IIMALAYALAM LETTER UMALAYALAM LETTER UUMALAYALAM LETTER " +
	"VOCALIC RMALAYALAM LETTER VOCALIC LMALAYALAM LETTER EMALAYALAM LETTER EE" +
	"MALAYALAM LETTER AIMALAYALAM LETTER OMALAYALAM LETTER OOMALAYALAM LETTER" +
	" AUMALAYALAM LETTER KAMALAYALAM LETTER KHAMALAYALAM LETTER GAMALAYALAM L" +
	"ETTER GHAMALAYALAM LETTER NGAMALAYALAM LETTER CAMALAYALAM LETTER CHAMALA" +
	"YALAM LETTER JAMALAYALAM LETTER JHAMALAYALAM LETTER NYAMALAYALAM LETTER " +
	"TTAMALAYALAM LETTER TTHAMALAYALAM LETTER DDAMALAYALAM LETTER DDHAMALAYAL" +
	"AM LETTER NNAMALAYALAM LETTER TAMALAYALAM LETTER THAMALAYALAM LETTER DAM" +
	"ALAYALAM LETTER DHAMALAYALAM LETTER NAMALAYALAM LETTER NNNAMALAYALAM LET") + ("" +
	"TER PAMALAYALAM LETTER PHAMALAYALAM LETTER BAMALAYALAM LETTER BHAMALAYAL" +
	"AM LETTER MAMALAYALAM LETTER YAMALAYALAM LETTER RAMALAYALAM LETTER RRAMA" +
	"LAYALAM LETTER LAMALAYALAM LETTER LLAMALAYALAM LETTER LLLAMALAYALAM LETT" +
	"ER VAMALAYALAM LETTER SHAMALAYALAM LETTER SSAMALAYALAM LETTER SAMALAYALA" +
	"M LETTER HAMALAYALAM LETTER TTTAMALAYALAM SIGN AVAGRAHAMALAYALAM VOWEL S" +
	"IGN AAMALAYALAM VOWEL SIGN IMALAYALAM VOWEL SIGN IIMALAYALAM VOWEL SIGN " +
	"UMALAYALAM VOWEL SIGN UUMALAYALAM VOWEL SIGN VOCALIC RMALAYALAM VOWEL SI" +
	"GN VOCALIC RRMALAYALAM VOWEL SIGN EMALAYALAM VOWEL SIGN EEMALAYALAM VOWE" +
	"L SIGN AIMALAYALAM VOWEL SIGN OMALAYALAM VOWEL SIGN OOMALAYALAM VOWEL SI" +
	"GN AUMALAYALAM SIGN VIRAMAMALAYALAM LETTER DOT REPHMALAYALAM SIGN PARAMA" +
	"LAYALAM LETTER CHILLU MMALAYALAM LETTER CHILLU YMALAYALAM LETTER CHILLU " +
	"LLLMALAYALAM AU LENGTH MARKMALAYALAM FRACTION ONE ONE-HUNDRED-AND-SIXTIE" +
	"THMALAYALAM FRACTION ONE FORTIETHMALAYALAM FRACTION THREE EIGHTIETHSMALA" +
	"YALAM FRACTION ONE TWENTIETHMALAYALAM FRACTION ONE TENTHMALAYALAM FRACTI" +
	"ON THREE TWENTIETHSMALAYALAM FRACTION ONE FIFTHMALAYALAM LETTER ARCHAIC " +
	"IIMALAYALAM LETTER VOCALIC RRMALAYALAM LETTER VOCALIC LLMALAYALAM VOWEL " +
	"SIGN VOCALIC LMALAYALAM VOWEL SIGN VOCALIC LLMALAYALAM DIGIT ZEROMALAYAL" +
	"AM DIGIT ONEMALAYALAM DIGIT TWOMALAYALAM DIGIT THREEMALAYALAM DIGIT FOUR" +
	"MALAYALAM DIGIT FIVEMALAYALAM DIGIT SIXMALAYALAM DIGIT SEVENMALAYALAM DI" +
	"GIT EIGHTMALAYALAM DIGIT NINEMALAYALAM NUMBER TENMALAYALAM NUMBER ONE HU" +
	"NDREDMALAYALAM NUMBER ONE THOUSANDMALAYALAM FRACTION ONE QUARTERMALAYALA" +
	"M FRACTION ONE HALFMALAYALAM FRACTION THREE QUARTERSMALAYALAM FRACTION O" +
	"NE SIXTEENTHMALAYALAM FRACTION ONE EIGHTHMALAYALAM FRACTION THREE SIXTEE" +
	"NTHSMALAYALAM DATE MARKMALAYALAM LETTER CHILLU NNMALAYALAM LETTER CHILLU" +
	" NMALAYALAM LETTER CHILLU RRMALAYALAM LETTER CHILLU LMALAYALAM LETTER CH" +
	"ILLU LLMALAYALAM LETTER CHILLU KSINHALA SIGN ANUSVARAYASINHALA SIGN VISA" +
	"RGAYASINHALA LETTER AYANNASINHALA LETTER AAYANNASINHALA LETTER AEYANNASI" +
	"NHALA LETTER AEEYANNASINHALA LETTER IYANNASINHALA LETTER IIYANNASINHALA " +
	"LETTER UYANNASINHALA LETTER UUYANNASINHALA LETTER IRUYANNASINHALA LETTER" +
	" IRUUYANNASINHALA LETTER ILUYANNASINHALA LETTER ILUUYANNASINHALA LETTER " +
	"EYANNASINHALA LETTER EEYANNASINHALA LETTER AIYANNASINHALA LETTER OYANNAS" +
	"INHALA LETTER OOYANNASINHALA LETTER AUYANNASINHALA LETTER ALPAPRAANA KAY" +
	"ANNASINHALA LETTER MAHAAPRAANA KAYANNASINHALA LETTER ALPAPRAANA GAYANNAS" +
	"INHALA LETTER MAHAAPRAANA GAYANNASINHALA LETTER KANTAJA NAASIKYAYASINHAL" +
	"A LETTER SANYAKA GAYANNASINHALA LETTER ALPAPRAANA CAYANNASINHALA LETTER " +
	"MAHAAPRAANA CAYANNASINHALA LETTER ALPAPRAANA JAYANNASINHALA LETTER MAHAA" +
	"PRAANA JAYANNASINHALA LETTER TAALUJA NAASIKYAYASINHALA LETTER TAALUJA SA" +
	"NYOOGA NAAKSIKYAYASINHALA LETTER SANYAKA JAYANNASINHALA LETTER ALPAPRAAN" +
	"A TTAYANNASINHALA LETTER MAHAAPRAANA TTAYANNASINHALA LETTER ALPAPRAANA D" +
	"DAYANNASINHALA LETTER MAHAAPRAANA DDAYANNASINHALA LETTER MUURDHAJA NAYAN" +
	"NASINHALA LETTER SANYAKA DDAYANNASINHALA LETTER ALPAPRAANA TAYANNASINHAL" +
	"A LETTER MAHAAPRAANA TAYANNASINHALA LETTER ALPAPRAANA DAYANNASINHALA LET" +
	"TER MAHAAPRAANA DAYANNASINHALA LETTER DANTAJA NAYANNASINHALA LETTER SANY" +
	"AKA DAYANNASINHALA LETTER ALPAPRAANA PAYANNASINHALA LETTER MAHAAPRAANA P" +
	"AYANNASINHALA LETTER ALPAPRAANA BAYANNASINHALA LETTER MAHAAPRAANA BAYANN" +
	"ASINHALA LETTER MAYANNASINHALA LETTER AMBA BAYANNASINHALA LETTER YAYANNA" +
	"SINHALA LETTER RAYANNASINHALA LETTER DANTAJA LAYANNASINHALA LETTER VAYAN" +
	"NASINHALA LETTER TAALUJA SAYANNASINHALA LETTER MUURDHAJA SAYANNASINHALA " +
	"LETTER DANTAJA SAYANNASINHALA LETTER HAYANNASINHALA LETTER MUURDHAJA LAY" +
	"ANNASINHALA LETTER FAYANNASINHALA SIGN AL-LAKUNASINHALA VOWEL SIGN AELA-" +
	"PILLASINHALA VOWEL SIGN KETTI AEDA-PILLASINHALA VOWEL SIGN DIGA AEDA-PIL" +
	"LASINHALA VOWEL SIGN KETTI IS-PILLASINHALA VOWEL SIGN DIGA IS-PILLASINHA" +
	"LA VOWEL SIGN KETTI PAA-PILLASINHALA VOWEL SIGN DIGA PAA-PILLASINHALA VO" +
	"WEL SIGN GAETTA-PILLASINHALA VOWEL SIGN KOMBUVASINHALA VOWEL SIGN DIGA K" +
	"OMBUVASINHALA VOWEL SIGN KOMBU DEKASINHALA VOWEL SIGN KOMBUVA HAA AELA-P" +
	"ILLASINHALA VOWEL SIGN KOMBUVA HAA DIGA AELA-PILLASINHALA VOWEL SIGN KOM" +
	"BUVA HAA GAYANUKITTASINHALA VOWEL SIGN GAYANUKITTASINHALA LITH DIGIT ZER" +
	"OSINHALA LITH DIGIT ONESINHALA LITH DIGIT TWOSINHALA LITH DIGIT THREESIN" +
	"HALA LITH DIGIT FOURSINHALA LITH DIGIT FIVESINHALA LITH DIGIT SIXSINHALA" +
	" LITH DIGIT SEVENSINHALA LITH DIGIT EIGHTSINHALA LITH DIGIT NINESINHALA " +
	"VOWEL SIGN DIGA GAETTA-PILLASINHALA VOWEL SIGN DIGA GAYANUKITTASINHALA P" +
	"UNCTUATION KUNDDALIYATHAI CHARACTER KO KAITHAI CHARACTER KHO KHAITHAI CH" +
	"ARACTER KHO KHUATTHAI CHARACTER KHO KHWAITHAI CHARACTER KHO KHONTHAI CHA" +
	"RACTER KHO RAKHANGTHAI CHARACTER NGO NGUTHAI CHARACTER CHO CHANTHAI CHAR") + ("" +
	"ACTER CHO CHINGTHAI CHARACTER CHO CHANGTHAI CHARACTER SO SOTHAI CHARACTE" +
	"R CHO CHOETHAI CHARACTER YO YINGTHAI CHARACTER DO CHADATHAI CHARACTER TO" +
	" PATAKTHAI CHARACTER THO THANTHAI CHARACTER THO NANGMONTHOTHAI CHARACTER" +
	" THO PHUTHAOTHAI CHARACTER NO NENTHAI CHARACTER DO DEKTHAI CHARACTER TO " +
	"TAOTHAI CHARACTER THO THUNGTHAI CHARACTER THO THAHANTHAI CHARACTER THO T" +
	"HONGTHAI CHARACTER NO NUTHAI CHARACTER BO BAIMAITHAI CHARACTER PO PLATHA" +
	"I CHARACTER PHO PHUNGTHAI CHARACTER FO FATHAI CHARACTER PHO PHANTHAI CHA" +
	"RACTER FO FANTHAI CHARACTER PHO SAMPHAOTHAI CHARACTER MO MATHAI CHARACTE" +
	"R YO YAKTHAI CHARACTER RO RUATHAI CHARACTER RUTHAI CHARACTER LO LINGTHAI" +
	" CHARACTER LUTHAI CHARACTER WO WAENTHAI CHARACTER SO SALATHAI CHARACTER " +
	"SO RUSITHAI CHARACTER SO SUATHAI CHARACTER HO HIPTHAI CHARACTER LO CHULA" +
	"THAI CHARACTER O ANGTHAI CHARACTER HO NOKHUKTHAI CHARACTER PAIYANNOITHAI" +
	" CHARACTER SARA ATHAI CHARACTER MAI HAN-AKATTHAI CHARACTER SARA AATHAI C" +
	"HARACTER SARA AMTHAI CHARACTER SARA ITHAI CHARACTER SARA IITHAI CHARACTE" +
	"R SARA UETHAI CHARACTER SARA UEETHAI CHARACTER SARA UTHAI CHARACTER SARA" +
	" UUTHAI CHARACTER PHINTHUTHAI CURRENCY SYMBOL BAHTTHAI CHARACTER SARA ET" +
	"HAI CHARACTER SARA AETHAI CHARACTER SARA OTHAI CHARACTER SARA AI MAIMUAN" +
	"THAI CHARACTER SARA AI MAIMALAITHAI CHARACTER LAKKHANGYAOTHAI CHARACTER " +
	"MAIYAMOKTHAI CHARACTER MAITAIKHUTHAI CHARACTER MAI EKTHAI CHARACTER MAI " +
	"THOTHAI CHARACTER MAI TRITHAI CHARACTER MAI CHATTAWATHAI CHARACTER THANT" +
	"HAKHATTHAI CHARACTER NIKHAHITTHAI CHARACTER YAMAKKANTHAI CHARACTER FONGM" +
	"ANTHAI DIGIT ZEROTHAI DIGIT ONETHAI DIGIT TWOTHAI DIGIT THREETHAI DIGIT " +
	"FOURTHAI DIGIT FIVETHAI DIGIT SIXTHAI DIGIT SEVENTHAI DIGIT EIGHTTHAI DI" +
	"GIT NINETHAI CHARACTER ANGKHANKHUTHAI CHARACTER KHOMUTLAO LETTER KOLAO L" +
	"ETTER KHO SUNGLAO LETTER KHO TAMLAO LETTER NGOLAO LETTER COLAO LETTER SO" +
	" TAMLAO LETTER NYOLAO LETTER DOLAO LETTER TOLAO LETTER THO SUNGLAO LETTE" +
	"R THO TAMLAO LETTER NOLAO LETTER BOLAO LETTER POLAO LETTER PHO SUNGLAO L" +
	"ETTER FO TAMLAO LETTER PHO TAMLAO LETTER FO SUNGLAO LETTER MOLAO LETTER " +
	"YOLAO LETTER LO LINGLAO LETTER LO LOOTLAO LETTER WOLAO LETTER SO SUNGLAO" +
	" LETTER HO SUNGLAO LETTER OLAO LETTER HO TAMLAO ELLIPSISLAO VOWEL SIGN A" +
	"LAO VOWEL SIGN MAI KANLAO VOWEL SIGN AALAO VOWEL SIGN AMLAO VOWEL SIGN I" +
	"LAO VOWEL SIGN IILAO VOWEL SIGN YLAO VOWEL SIGN YYLAO VOWEL SIGN ULAO VO" +
	"WEL SIGN UULAO VOWEL SIGN MAI KONLAO SEMIVOWEL SIGN LOLAO SEMIVOWEL SIGN" +
	" NYOLAO VOWEL SIGN ELAO VOWEL SIGN EILAO VOWEL SIGN OLAO VOWEL SIGN AYLA" +
	"O VOWEL SIGN AILAO KO LALAO TONE MAI EKLAO TONE MAI THOLAO TONE MAI TILA" +
	"O TONE MAI CATAWALAO CANCELLATION MARKLAO NIGGAHITALAO DIGIT ZEROLAO DIG" +
	"IT ONELAO DIGIT TWOLAO DIGIT THREELAO DIGIT FOURLAO DIGIT FIVELAO DIGIT " +
	"SIXLAO DIGIT SEVENLAO DIGIT EIGHTLAO DIGIT NINELAO HO NOLAO HO MOLAO LET" +
	"TER KHMU GOLAO LETTER KHMU NYOTIBETAN SYLLABLE OMTIBETAN MARK GTER YIG M" +
	"GO TRUNCATED ATIBETAN MARK GTER YIG MGO -UM RNAM BCAD MATIBETAN MARK GTE" +
	"R YIG MGO -UM GTER TSHEG MATIBETAN MARK INITIAL YIG MGO MDUN MATIBETAN M" +
	"ARK CLOSING YIG MGO SGAB MATIBETAN MARK CARET YIG MGO PHUR SHAD MATIBETA" +
	"N MARK YIG MGO TSHEG SHAD MATIBETAN MARK SBRUL SHADTIBETAN MARK BSKUR YI" +
	"G MGOTIBETAN MARK BKA- SHOG YIG MGOTIBETAN MARK INTERSYLLABIC TSHEGTIBET" +
	"AN MARK DELIMITER TSHEG BSTARTIBETAN MARK SHADTIBETAN MARK NYIS SHADTIBE" +
	"TAN MARK TSHEG SHADTIBETAN MARK NYIS TSHEG SHADTIBETAN MARK RIN CHEN SPU" +
	"NGS SHADTIBETAN MARK RGYA GRAM SHADTIBETAN MARK CARET -DZUD RTAGS ME LON" +
	"G CANTIBETAN MARK GTER TSHEGTIBETAN LOGOTYPE SIGN CHAD RTAGSTIBETAN LOGO" +
	"TYPE SIGN LHAG RTAGSTIBETAN ASTROLOGICAL SIGN SGRA GCAN -CHAR RTAGSTIBET" +
	"AN ASTROLOGICAL SIGN -KHYUD PATIBETAN ASTROLOGICAL SIGN SDONG TSHUGSTIBE" +
	"TAN SIGN RDEL DKAR GCIGTIBETAN SIGN RDEL DKAR GNYISTIBETAN SIGN RDEL DKA" +
	"R GSUMTIBETAN SIGN RDEL NAG GCIGTIBETAN SIGN RDEL NAG GNYISTIBETAN SIGN " +
	"RDEL DKAR RDEL NAGTIBETAN DIGIT ZEROTIBETAN DIGIT ONETIBETAN DIGIT TWOTI" +
	"BETAN DIGIT THREETIBETAN DIGIT FOURTIBETAN DIGIT FIVETIBETAN DIGIT SIXTI" +
	"BETAN DIGIT SEVENTIBETAN DIGIT EIGHTTIBETAN DIGIT NINETIBETAN DIGIT HALF" +
	" ONETIBETAN DIGIT HALF TWOTIBETAN DIGIT HALF THREETIBETAN DIGIT HALF FOU" +
	"RTIBETAN DIGIT HALF FIVETIBETAN DIGIT HALF SIXTIBETAN DIGIT HALF SEVENTI" +
	"BETAN DIGIT HALF EIGHTTIBETAN DIGIT HALF NINETIBETAN DIGIT HALF ZEROTIBE" +
	"TAN MARK BSDUS RTAGSTIBETAN MARK NGAS BZUNG NYI ZLATIBETAN MARK CARET -D" +
	"ZUD RTAGS BZHI MIG CANTIBETAN MARK NGAS BZUNG SGOR RTAGSTIBETAN MARK CHE" +
	" MGOTIBETAN MARK TSA -PHRUTIBETAN MARK GUG RTAGS GYONTIBETAN MARK GUG RT" +
	"AGS GYASTIBETAN MARK ANG KHANG GYONTIBETAN MARK ANG KHANG GYASTIBETAN SI" +
	"GN YAR TSHESTIBETAN SIGN MAR TSHESTIBETAN LETTER KATIBETAN LETTER KHATIB" +
	"ETAN LETTER GATIBETAN LETTER GHATIBETAN LETTER NGATIBETAN LETTER CATIBET") + ("" +
	"AN LETTER CHATIBETAN LETTER JATIBETAN LETTER NYATIBETAN LETTER TTATIBETA" +
	"N LETTER TTHATIBETAN LETTER DDATIBETAN LETTER DDHATIBETAN LETTER NNATIBE" +
	"TAN LETTER TATIBETAN LETTER THATIBETAN LETTER DATIBETAN LETTER DHATIBETA" +
	"N LETTER NATIBETAN LETTER PATIBETAN LETTER PHATIBETAN LETTER BATIBETAN L" +
	"ETTER BHATIBETAN LETTER MATIBETAN LETTER TSATIBETAN LETTER TSHATIBETAN L" +
	"ETTER DZATIBETAN LETTER DZHATIBETAN LETTER WATIBETAN LETTER ZHATIBETAN L" +
	"ETTER ZATIBETAN LETTER -ATIBETAN LETTER YATIBETAN LETTER RATIBETAN LETTE" +
	"R LATIBETAN LETTER SHATIBETAN LETTER SSATIBETAN LETTER SATIBETAN LETTER " +
	"HATIBETAN LETTER ATIBETAN LETTER KSSATIBETAN LETTER FIXED-FORM RATIBETAN" +
	" LETTER KKATIBETAN LETTER RRATIBETAN VOWEL SIGN AATIBETAN VOWEL SIGN ITI" +
	"BETAN VOWEL SIGN IITIBETAN VOWEL SIGN UTIBETAN VOWEL SIGN UUTIBETAN VOWE" +
	"L SIGN VOCALIC RTIBETAN VOWEL SIGN VOCALIC RRTIBETAN VOWEL SIGN VOCALIC " +
	"LTIBETAN VOWEL SIGN VOCALIC LLTIBETAN VOWEL SIGN ETIBETAN VOWEL SIGN EET" +
	"IBETAN VOWEL SIGN OTIBETAN VOWEL SIGN OOTIBETAN SIGN RJES SU NGA ROTIBET" +
	"AN SIGN RNAM BCADTIBETAN VOWEL SIGN REVERSED ITIBETAN VOWEL SIGN REVERSE" +
	"D IITIBETAN SIGN NYI ZLA NAA DATIBETAN SIGN SNA LDANTIBETAN MARK HALANTA" +
	"TIBETAN MARK PALUTATIBETAN SIGN LCI RTAGSTIBETAN SIGN YANG RTAGSTIBETAN " +
	"SIGN LCE TSA CANTIBETAN SIGN MCHU CANTIBETAN SIGN GRU CAN RGYINGSTIBETAN" +
	" SIGN GRU MED RGYINGSTIBETAN SIGN INVERTED MCHU CANTIBETAN SUBJOINED SIG" +
	"N LCE TSA CANTIBETAN SUBJOINED SIGN MCHU CANTIBETAN SUBJOINED SIGN INVER" +
	"TED MCHU CANTIBETAN SUBJOINED LETTER KATIBETAN SUBJOINED LETTER KHATIBET" +
	"AN SUBJOINED LETTER GATIBETAN SUBJOINED LETTER GHATIBETAN SUBJOINED LETT" +
	"ER NGATIBETAN SUBJOINED LETTER CATIBETAN SUBJOINED LETTER CHATIBETAN SUB" +
	"JOINED LETTER JATIBETAN SUBJOINED LETTER NYATIBETAN SUBJOINED LETTER TTA" +
	"TIBETAN SUBJOINED LETTER TTHATIBETAN SUBJOINED LETTER DDATIBETAN SUBJOIN" +
	"ED LETTER DDHATIBETAN SUBJOINED LETTER NNATIBETAN SUBJOINED LETTER TATIB" +
	"ETAN SUBJOINED LETTER THATIBETAN SUBJOINED LETTER DATIBETAN SUBJOINED LE" +
	"TTER DHATIBETAN SUBJOINED LETTER NATIBETAN SUBJOINED LETTER PATIBETAN SU" +
	"BJOINED LETTER PHATIBETAN SUBJOINED LETTER BATIBETAN SUBJOINED LETTER BH" +
	"ATIBETAN SUBJOINED LETTER MATIBETAN SUBJOINED LETTER TSATIBETAN SUBJOINE" +
	"D LETTER TSHATIBETAN SUBJOINED LETTER DZATIBETAN SUBJOINED LETTER DZHATI" +
	"BETAN SUBJOINED LETTER WATIBETAN SUBJOINED LETTER ZHATIBETAN SUBJOINED L" +
	"ETTER ZATIBETAN SUBJOINED LETTER -ATIBETAN SUBJOINED LETTER YATIBETAN SU" +
	"BJOINED LETTER RATIBETAN SUBJOINED LETTER LATIBETAN SUBJOINED LETTER SHA" +
	"TIBETAN SUBJOINED LETTER SSATIBETAN SUBJOINED LETTER SATIBETAN SUBJOINED" +
	" LETTER HATIBETAN SUBJOINED LETTER ATIBETAN SUBJOINED LETTER KSSATIBETAN" +
	" SUBJOINED LETTER FIXED-FORM WATIBETAN SUBJOINED LETTER FIXED-FORM YATIB" +
	"ETAN SUBJOINED LETTER FIXED-FORM RATIBETAN KU RU KHATIBETAN KU RU KHA BZ" +
	"HI MIG CANTIBETAN CANTILLATION SIGN HEAVY BEATTIBETAN CANTILLATION SIGN " +
	"LIGHT BEATTIBETAN CANTILLATION SIGN CANG TE-UTIBETAN CANTILLATION SIGN S" +
	"BUB -CHALTIBETAN SYMBOL DRIL BUTIBETAN SYMBOL RDO RJETIBETAN SYMBOL PADM" +
	"A GDANTIBETAN SYMBOL RDO RJE RGYA GRAMTIBETAN SYMBOL PHUR PATIBETAN SYMB" +
	"OL NOR BUTIBETAN SYMBOL NOR BU NYIS -KHYILTIBETAN SYMBOL NOR BU GSUM -KH" +
	"YILTIBETAN SYMBOL NOR BU BZHI -KHYILTIBETAN SIGN RDEL NAG RDEL DKARTIBET" +
	"AN SIGN RDEL NAG GSUMTIBETAN MARK BSKA- SHOG GI MGO RGYANTIBETAN MARK MN" +
	"YAM YIG GI MGO RGYANTIBETAN MARK NYIS TSHEGTIBETAN MARK INITIAL BRDA RNY" +
	"ING YIG MGO MDUN MATIBETAN MARK CLOSING BRDA RNYING YIG MGO SGAB MARIGHT" +
	"-FACING SVASTI SIGNLEFT-FACING SVASTI SIGNRIGHT-FACING SVASTI SIGN WITH " +
	"DOTSLEFT-FACING SVASTI SIGN WITH DOTSTIBETAN MARK LEADING MCHAN RTAGSTIB" +
	"ETAN MARK TRAILING MCHAN RTAGSMYANMAR LETTER KAMYANMAR LETTER KHAMYANMAR" +
	" LETTER GAMYANMAR LETTER GHAMYANMAR LETTER NGAMYANMAR LETTER CAMYANMAR L" +
	"ETTER CHAMYANMAR LETTER JAMYANMAR LETTER JHAMYANMAR LETTER NYAMYANMAR LE" +
	"TTER NNYAMYANMAR LETTER TTAMYANMAR LETTER TTHAMYANMAR LETTER DDAMYANMAR " +
	"LETTER DDHAMYANMAR LETTER NNAMYANMAR LETTER TAMYANMAR LETTER THAMYANMAR " +
	"LETTER DAMYANMAR LETTER DHAMYANMAR LETTER NAMYANMAR LETTER PAMYANMAR LET" +
	"TER PHAMYANMAR LETTER BAMYANMAR LETTER BHAMYANMAR LETTER MAMYANMAR LETTE" +
	"R YAMYANMAR LETTER RAMYANMAR LETTER LAMYANMAR LETTER WAMYANMAR LETTER SA" +
	"MYANMAR LETTER HAMYANMAR LETTER LLAMYANMAR LETTER AMYANMAR LETTER SHAN A" +
	"MYANMAR LETTER IMYANMAR LETTER IIMYANMAR LETTER UMYANMAR LETTER UUMYANMA" +
	"R LETTER EMYANMAR LETTER MON EMYANMAR LETTER OMYANMAR LETTER AUMYANMAR V" +
	"OWEL SIGN TALL AAMYANMAR VOWEL SIGN AAMYANMAR VOWEL SIGN IMYANMAR VOWEL " +
	"SIGN IIMYANMAR VOWEL SIGN UMYANMAR VOWEL SIGN UUMYANMAR VOWEL SIGN EMYAN" +
	"MAR VOWEL SIGN AIMYANMAR VOWEL SIGN MON IIMYANMAR VOWEL SIGN MON OMYANMA" +
	"R VOWEL SIGN E ABOVEMYANMAR SIGN ANUSVARAMYANMAR SIGN DOT BELOWMYANMAR S") + ("" +
	"IGN VISARGAMYANMAR SIGN VIRAMAMYANMAR SIGN ASATMYANMAR CONSONANT SIGN ME" +
	"DIAL YAMYANMAR CONSONANT SIGN MEDIAL RAMYANMAR CONSONANT SIGN MEDIAL WAM" +
	"YANMAR CONSONANT SIGN MEDIAL HAMYANMAR LETTER GREAT SAMYANMAR DIGIT ZERO" +
	"MYANMAR DIGIT ONEMYANMAR DIGIT TWOMYANMAR DIGIT THREEMYANMAR DIGIT FOURM" +
	"YANMAR DIGIT FIVEMYANMAR DIGIT SIXMYANMAR DIGIT SEVENMYANMAR DIGIT EIGHT" +
	"MYANMAR DIGIT NINEMYANMAR SIGN LITTLE SECTIONMYANMAR SIGN SECTIONMYANMAR" +
	" SYMBOL LOCATIVEMYANMAR SYMBOL COMPLETEDMYANMAR SYMBOL AFOREMENTIONEDMYA" +
	"NMAR SYMBOL GENITIVEMYANMAR LETTER SHAMYANMAR LETTER SSAMYANMAR LETTER V" +
	"OCALIC RMYANMAR LETTER VOCALIC RRMYANMAR LETTER VOCALIC LMYANMAR LETTER " +
	"VOCALIC LLMYANMAR VOWEL SIGN VOCALIC RMYANMAR VOWEL SIGN VOCALIC RRMYANM" +
	"AR VOWEL SIGN VOCALIC LMYANMAR VOWEL SIGN VOCALIC LLMYANMAR LETTER MON N" +
	"GAMYANMAR LETTER MON JHAMYANMAR LETTER MON BBAMYANMAR LETTER MON BBEMYAN" +
	"MAR CONSONANT SIGN MON MEDIAL NAMYANMAR CONSONANT SIGN MON MEDIAL MAMYAN" +
	"MAR CONSONANT SIGN MON MEDIAL LAMYANMAR LETTER SGAW KAREN SHAMYANMAR VOW" +
	"EL SIGN SGAW KAREN EUMYANMAR TONE MARK SGAW KAREN HATHIMYANMAR TONE MARK" +
	" SGAW KAREN KE PHOMYANMAR LETTER WESTERN PWO KAREN THAMYANMAR LETTER WES" +
	"TERN PWO KAREN PWAMYANMAR VOWEL SIGN WESTERN PWO KAREN EUMYANMAR VOWEL S" +
	"IGN WESTERN PWO KAREN UEMYANMAR SIGN WESTERN PWO KAREN TONE-1MYANMAR SIG" +
	"N WESTERN PWO KAREN TONE-2MYANMAR SIGN WESTERN PWO KAREN TONE-3MYANMAR S" +
	"IGN WESTERN PWO KAREN TONE-4MYANMAR SIGN WESTERN PWO KAREN TONE-5MYANMAR" +
	" LETTER EASTERN PWO KAREN NNAMYANMAR LETTER EASTERN PWO KAREN YWAMYANMAR" +
	" LETTER EASTERN PWO KAREN GHWAMYANMAR VOWEL SIGN GEBA KAREN IMYANMAR VOW" +
	"EL SIGN KAYAH OEMYANMAR VOWEL SIGN KAYAH UMYANMAR VOWEL SIGN KAYAH EEMYA" +
	"NMAR LETTER SHAN KAMYANMAR LETTER SHAN KHAMYANMAR LETTER SHAN GAMYANMAR " +
	"LETTER SHAN CAMYANMAR LETTER SHAN ZAMYANMAR LETTER SHAN NYAMYANMAR LETTE" +
	"R SHAN DAMYANMAR LETTER SHAN NAMYANMAR LETTER SHAN PHAMYANMAR LETTER SHA" +
	"N FAMYANMAR LETTER SHAN BAMYANMAR LETTER SHAN THAMYANMAR LETTER SHAN HAM" +
	"YANMAR CONSONANT SIGN SHAN MEDIAL WAMYANMAR VOWEL SIGN SHAN AAMYANMAR VO" +
	"WEL SIGN SHAN EMYANMAR VOWEL SIGN SHAN E ABOVEMYANMAR VOWEL SIGN SHAN FI" +
	"NAL YMYANMAR SIGN SHAN TONE-2MYANMAR SIGN SHAN TONE-3MYANMAR SIGN SHAN T" +
	"ONE-5MYANMAR SIGN SHAN TONE-6MYANMAR SIGN SHAN COUNCIL TONE-2MYANMAR SIG" +
	"N SHAN COUNCIL TONE-3MYANMAR SIGN SHAN COUNCIL EMPHATIC TONEMYANMAR LETT" +
	"ER RUMAI PALAUNG FAMYANMAR SIGN RUMAI PALAUNG TONE-5MYANMAR SHAN DIGIT Z" +
	"EROMYANMAR SHAN DIGIT ONEMYANMAR SHAN DIGIT TWOMYANMAR SHAN DIGIT THREEM" +
	"YANMAR SHAN DIGIT FOURMYANMAR SHAN DIGIT FIVEMYANMAR SHAN DIGIT SIXMYANM" +
	"AR SHAN DIGIT SEVENMYANMAR SHAN DIGIT EIGHTMYANMAR SHAN DIGIT NINEMYANMA" +
	"R SIGN KHAMTI TONE-1MYANMAR SIGN KHAMTI TONE-3MYANMAR VOWEL SIGN AITON A" +
	"MYANMAR VOWEL SIGN AITON AIMYANMAR SYMBOL SHAN ONEMYANMAR SYMBOL SHAN EX" +
	"CLAMATIONGEORGIAN CAPITAL LETTER ANGEORGIAN CAPITAL LETTER BANGEORGIAN C" +
	"APITAL LETTER GANGEORGIAN CAPITAL LETTER DONGEORGIAN CAPITAL LETTER ENGE" +
	"ORGIAN CAPITAL LETTER VINGEORGIAN CAPITAL LETTER ZENGEORGIAN CAPITAL LET" +
	"TER TANGEORGIAN CAPITAL LETTER INGEORGIAN CAPITAL LETTER KANGEORGIAN CAP" +
	"ITAL LETTER LASGEORGIAN CAPITAL LETTER MANGEORGIAN CAPITAL LETTER NARGEO" +
	"RGIAN CAPITAL LETTER ONGEORGIAN CAPITAL LETTER PARGEORGIAN CAPITAL LETTE" +
	"R ZHARGEORGIAN CAPITAL LETTER RAEGEORGIAN CAPITAL LETTER SANGEORGIAN CAP" +
	"ITAL LETTER TARGEORGIAN CAPITAL LETTER UNGEORGIAN CAPITAL LETTER PHARGEO" +
	"RGIAN CAPITAL LETTER KHARGEORGIAN CAPITAL LETTER GHANGEORGIAN CAPITAL LE" +
	"TTER QARGEORGIAN CAPITAL LETTER SHINGEORGIAN CAPITAL LETTER CHINGEORGIAN" +
	" CAPITAL LETTER CANGEORGIAN CAPITAL LETTER JILGEORGIAN CAPITAL LETTER CI" +
	"LGEORGIAN CAPITAL LETTER CHARGEORGIAN CAPITAL LETTER XANGEORGIAN CAPITAL" +
	" LETTER JHANGEORGIAN CAPITAL LETTER HAEGEORGIAN CAPITAL LETTER HEGEORGIA" +
	"N CAPITAL LETTER HIEGEORGIAN CAPITAL LETTER WEGEORGIAN CAPITAL LETTER HA" +
	"RGEORGIAN CAPITAL LETTER HOEGEORGIAN CAPITAL LETTER YNGEORGIAN CAPITAL L" +
	"ETTER AENGEORGIAN LETTER ANGEORGIAN LETTER BANGEORGIAN LETTER GANGEORGIA" +
	"N LETTER DONGEORGIAN LETTER ENGEORGIAN LETTER VINGEORGIAN LETTER ZENGEOR" +
	"GIAN LETTER TANGEORGIAN LETTER INGEORGIAN LETTER KANGEORGIAN LETTER LASG" +
	"EORGIAN LETTER MANGEORGIAN LETTER NARGEORGIAN LETTER ONGEORGIAN LETTER P" +
	"ARGEORGIAN LETTER ZHARGEORGIAN LETTER RAEGEORGIAN LETTER SANGEORGIAN LET" +
	"TER TARGEORGIAN LETTER UNGEORGIAN LETTER PHARGEORGIAN LETTER KHARGEORGIA" +
	"N LETTER GHANGEORGIAN LETTER QARGEORGIAN LETTER SHINGEORGIAN LETTER CHIN" +
	"GEORGIAN LETTER CANGEORGIAN LETTER JILGEORGIAN LETTER CILGEORGIAN LETTER" +
	" CHARGEORGIAN LETTER XANGEORGIAN LETTER JHANGEORGIAN LETTER HAEGEORGIAN " +
	"LETTER HEGEORGIAN LETTER HIEGEORGIAN LETTER WEGEORGIAN LETTER HARGEORGIA" +
	"N LETTER HOEGEORGIAN LETTER FIGEORGIAN LETTER YNGEORGIAN LETTER ELIFIGEO") + ("" +
	"RGIAN LETTER TURNED GANGEORGIAN LETTER AINGEORGIAN PARAGRAPH SEPARATORMO" +
	"DIFIER LETTER GEORGIAN NARGEORGIAN LETTER AENGEORGIAN LETTER HARD SIGNGE" +
	"ORGIAN LETTER LABIAL SIGNHANGUL CHOSEONG KIYEOKHANGUL CHOSEONG SSANGKIYE" +
	"OKHANGUL CHOSEONG NIEUNHANGUL CHOSEONG TIKEUTHANGUL CHOSEONG SSANGTIKEUT" +
	"HANGUL CHOSEONG RIEULHANGUL CHOSEONG MIEUMHANGUL CHOSEONG PIEUPHANGUL CH" +
	"OSEONG SSANGPIEUPHANGUL CHOSEONG SIOSHANGUL CHOSEONG SSANGSIOSHANGUL CHO" +
	"SEONG IEUNGHANGUL CHOSEONG CIEUCHANGUL CHOSEONG SSANGCIEUCHANGUL CHOSEON" +
	"G CHIEUCHHANGUL CHOSEONG KHIEUKHHANGUL CHOSEONG THIEUTHHANGUL CHOSEONG P" +
	"HIEUPHHANGUL CHOSEONG HIEUHHANGUL CHOSEONG NIEUN-KIYEOKHANGUL CHOSEONG S" +
	"SANGNIEUNHANGUL CHOSEONG NIEUN-TIKEUTHANGUL CHOSEONG NIEUN-PIEUPHANGUL C" +
	"HOSEONG TIKEUT-KIYEOKHANGUL CHOSEONG RIEUL-NIEUNHANGUL CHOSEONG SSANGRIE" +
	"ULHANGUL CHOSEONG RIEUL-HIEUHHANGUL CHOSEONG KAPYEOUNRIEULHANGUL CHOSEON" +
	"G MIEUM-PIEUPHANGUL CHOSEONG KAPYEOUNMIEUMHANGUL CHOSEONG PIEUP-KIYEOKHA" +
	"NGUL CHOSEONG PIEUP-NIEUNHANGUL CHOSEONG PIEUP-TIKEUTHANGUL CHOSEONG PIE" +
	"UP-SIOSHANGUL CHOSEONG PIEUP-SIOS-KIYEOKHANGUL CHOSEONG PIEUP-SIOS-TIKEU" +
	"THANGUL CHOSEONG PIEUP-SIOS-PIEUPHANGUL CHOSEONG PIEUP-SSANGSIOSHANGUL C" +
	"HOSEONG PIEUP-SIOS-CIEUCHANGUL CHOSEONG PIEUP-CIEUCHANGUL CHOSEONG PIEUP" +
	"-CHIEUCHHANGUL CHOSEONG PIEUP-THIEUTHHANGUL CHOSEONG PIEUP-PHIEUPHHANGUL" +
	" CHOSEONG KAPYEOUNPIEUPHANGUL CHOSEONG KAPYEOUNSSANGPIEUPHANGUL CHOSEONG" +
	" SIOS-KIYEOKHANGUL CHOSEONG SIOS-NIEUNHANGUL CHOSEONG SIOS-TIKEUTHANGUL " +
	"CHOSEONG SIOS-RIEULHANGUL CHOSEONG SIOS-MIEUMHANGUL CHOSEONG SIOS-PIEUPH" +
	"ANGUL CHOSEONG SIOS-PIEUP-KIYEOKHANGUL CHOSEONG SIOS-SSANGSIOSHANGUL CHO" +
	"SEONG SIOS-IEUNGHANGUL CHOSEONG SIOS-CIEUCHANGUL CHOSEONG SIOS-CHIEUCHHA" +
	"NGUL CHOSEONG SIOS-KHIEUKHHANGUL CHOSEONG SIOS-THIEUTHHANGUL CHOSEONG SI" +
	"OS-PHIEUPHHANGUL CHOSEONG SIOS-HIEUHHANGUL CHOSEONG CHITUEUMSIOSHANGUL C" +
	"HOSEONG CHITUEUMSSANGSIOSHANGUL CHOSEONG CEONGCHIEUMSIOSHANGUL CHOSEONG " +
	"CEONGCHIEUMSSANGSIOSHANGUL CHOSEONG PANSIOSHANGUL CHOSEONG IEUNG-KIYEOKH" +
	"ANGUL CHOSEONG IEUNG-TIKEUTHANGUL CHOSEONG IEUNG-MIEUMHANGUL CHOSEONG IE" +
	"UNG-PIEUPHANGUL CHOSEONG IEUNG-SIOSHANGUL CHOSEONG IEUNG-PANSIOSHANGUL C" +
	"HOSEONG SSANGIEUNGHANGUL CHOSEONG IEUNG-CIEUCHANGUL CHOSEONG IEUNG-CHIEU" +
	"CHHANGUL CHOSEONG IEUNG-THIEUTHHANGUL CHOSEONG IEUNG-PHIEUPHHANGUL CHOSE" +
	"ONG YESIEUNGHANGUL CHOSEONG CIEUC-IEUNGHANGUL CHOSEONG CHITUEUMCIEUCHANG" +
	"UL CHOSEONG CHITUEUMSSANGCIEUCHANGUL CHOSEONG CEONGCHIEUMCIEUCHANGUL CHO" +
	"SEONG CEONGCHIEUMSSANGCIEUCHANGUL CHOSEONG CHIEUCH-KHIEUKHHANGUL CHOSEON" +
	"G CHIEUCH-HIEUHHANGUL CHOSEONG CHITUEUMCHIEUCHHANGUL CHOSEONG CEONGCHIEU" +
	"MCHIEUCHHANGUL CHOSEONG PHIEUPH-PIEUPHANGUL CHOSEONG KAPYEOUNPHIEUPHHANG" +
	"UL CHOSEONG SSANGHIEUHHANGUL CHOSEONG YEORINHIEUHHANGUL CHOSEONG KIYEOK-" +
	"TIKEUTHANGUL CHOSEONG NIEUN-SIOSHANGUL CHOSEONG NIEUN-CIEUCHANGUL CHOSEO" +
	"NG NIEUN-HIEUHHANGUL CHOSEONG TIKEUT-RIEULHANGUL CHOSEONG FILLERHANGUL J" +
	"UNGSEONG FILLERHANGUL JUNGSEONG AHANGUL JUNGSEONG AEHANGUL JUNGSEONG YAH" +
	"ANGUL JUNGSEONG YAEHANGUL JUNGSEONG EOHANGUL JUNGSEONG EHANGUL JUNGSEONG" +
	" YEOHANGUL JUNGSEONG YEHANGUL JUNGSEONG OHANGUL JUNGSEONG WAHANGUL JUNGS" +
	"EONG WAEHANGUL JUNGSEONG OEHANGUL JUNGSEONG YOHANGUL JUNGSEONG UHANGUL J" +
	"UNGSEONG WEOHANGUL JUNGSEONG WEHANGUL JUNGSEONG WIHANGUL JUNGSEONG YUHAN" +
	"GUL JUNGSEONG EUHANGUL JUNGSEONG YIHANGUL JUNGSEONG IHANGUL JUNGSEONG A-" +
	"OHANGUL JUNGSEONG A-UHANGUL JUNGSEONG YA-OHANGUL JUNGSEONG YA-YOHANGUL J" +
	"UNGSEONG EO-OHANGUL JUNGSEONG EO-UHANGUL JUNGSEONG EO-EUHANGUL JUNGSEONG" +
	" YEO-OHANGUL JUNGSEONG YEO-UHANGUL JUNGSEONG O-EOHANGUL JUNGSEONG O-EHAN" +
	"GUL JUNGSEONG O-YEHANGUL JUNGSEONG O-OHANGUL JUNGSEONG O-UHANGUL JUNGSEO" +
	"NG YO-YAHANGUL JUNGSEONG YO-YAEHANGUL JUNGSEONG YO-YEOHANGUL JUNGSEONG Y" +
	"O-OHANGUL JUNGSEONG YO-IHANGUL JUNGSEONG U-AHANGUL JUNGSEONG U-AEHANGUL " +
	"JUNGSEONG U-EO-EUHANGUL JUNGSEONG U-YEHANGUL JUNGSEONG U-UHANGUL JUNGSEO" +
	"NG YU-AHANGUL JUNGSEONG YU-EOHANGUL JUNGSEONG YU-EHANGUL JUNGSEONG YU-YE" +
	"OHANGUL JUNGSEONG YU-YEHANGUL JUNGSEONG YU-UHANGUL JUNGSEONG YU-IHANGUL " +
	"JUNGSEONG EU-UHANGUL JUNGSEONG EU-EUHANGUL JUNGSEONG YI-UHANGUL JUNGSEON" +
	"G I-AHANGUL JUNGSEONG I-YAHANGUL JUNGSEONG I-OHANGUL JUNGSEONG I-UHANGUL" +
	" JUNGSEONG I-EUHANGUL JUNGSEONG I-ARAEAHANGUL JUNGSEONG ARAEAHANGUL JUNG" +
	"SEONG ARAEA-EOHANGUL JUNGSEONG ARAEA-UHANGUL JUNGSEONG ARAEA-IHANGUL JUN" +
	"GSEONG SSANGARAEAHANGUL JUNGSEONG A-EUHANGUL JUNGSEONG YA-UHANGUL JUNGSE" +
	"ONG YEO-YAHANGUL JUNGSEONG O-YAHANGUL JUNGSEONG O-YAEHANGUL JONGSEONG KI" +
	"YEOKHANGUL JONGSEONG SSANGKIYEOKHANGUL JONGSEONG KIYEOK-SIOSHANGUL JONGS" +
	"EONG NIEUNHANGUL JONGSEONG NIEUN-CIEUCHANGUL JONGSEONG NIEUN-HIEUHHANGUL" +
	" JONGSEONG TIKEUTHANGUL JONGSEONG RIEULHANGUL JONGSEONG RIEUL-KIYEOKHANG" +
	"UL JONGSEONG RIEUL-MIEUMHANGUL JONGSEONG RIEUL-PIEUPHANGUL JONGSEONG RIE") + ("" +
	"UL-SIOSHANGUL JONGSEONG RIEUL-THIEUTHHANGUL JONGSEONG RIEUL-PHIEUPHHANGU" +
	"L JONGSEONG RIEUL-HIEUHHANGUL JONGSEONG MIEUMHANGUL JONGSEONG PIEUPHANGU" +
	"L JONGSEONG PIEUP-SIOSHANGUL JONGSEONG SIOSHANGUL JONGSEONG SSANGSIOSHAN" +
	"GUL JONGSEONG IEUNGHANGUL JONGSEONG CIEUCHANGUL JONGSEONG CHIEUCHHANGUL " +
	"JONGSEONG KHIEUKHHANGUL JONGSEONG THIEUTHHANGUL JONGSEONG PHIEUPHHANGUL " +
	"JONGSEONG HIEUHHANGUL JONGSEONG KIYEOK-RIEULHANGUL JONGSEONG KIYEOK-SIOS" +
	"-KIYEOKHANGUL JONGSEONG NIEUN-KIYEOKHANGUL JONGSEONG NIEUN-TIKEUTHANGUL " +
	"JONGSEONG NIEUN-SIOSHANGUL JONGSEONG NIEUN-PANSIOSHANGUL JONGSEONG NIEUN" +
	"-THIEUTHHANGUL JONGSEONG TIKEUT-KIYEOKHANGUL JONGSEONG TIKEUT-RIEULHANGU" +
	"L JONGSEONG RIEUL-KIYEOK-SIOSHANGUL JONGSEONG RIEUL-NIEUNHANGUL JONGSEON" +
	"G RIEUL-TIKEUTHANGUL JONGSEONG RIEUL-TIKEUT-HIEUHHANGUL JONGSEONG SSANGR" +
	"IEULHANGUL JONGSEONG RIEUL-MIEUM-KIYEOKHANGUL JONGSEONG RIEUL-MIEUM-SIOS" +
	"HANGUL JONGSEONG RIEUL-PIEUP-SIOSHANGUL JONGSEONG RIEUL-PIEUP-HIEUHHANGU" +
	"L JONGSEONG RIEUL-KAPYEOUNPIEUPHANGUL JONGSEONG RIEUL-SSANGSIOSHANGUL JO" +
	"NGSEONG RIEUL-PANSIOSHANGUL JONGSEONG RIEUL-KHIEUKHHANGUL JONGSEONG RIEU" +
	"L-YEORINHIEUHHANGUL JONGSEONG MIEUM-KIYEOKHANGUL JONGSEONG MIEUM-RIEULHA" +
	"NGUL JONGSEONG MIEUM-PIEUPHANGUL JONGSEONG MIEUM-SIOSHANGUL JONGSEONG MI" +
	"EUM-SSANGSIOSHANGUL JONGSEONG MIEUM-PANSIOSHANGUL JONGSEONG MIEUM-CHIEUC" +
	"HHANGUL JONGSEONG MIEUM-HIEUHHANGUL JONGSEONG KAPYEOUNMIEUMHANGUL JONGSE" +
	"ONG PIEUP-RIEULHANGUL JONGSEONG PIEUP-PHIEUPHHANGUL JONGSEONG PIEUP-HIEU" +
	"HHANGUL JONGSEONG KAPYEOUNPIEUPHANGUL JONGSEONG SIOS-KIYEOKHANGUL JONGSE" +
	"ONG SIOS-TIKEUTHANGUL JONGSEONG SIOS-RIEULHANGUL JONGSEONG SIOS-PIEUPHAN" +
	"GUL JONGSEONG PANSIOSHANGUL JONGSEONG IEUNG-KIYEOKHANGUL JONGSEONG IEUNG" +
	"-SSANGKIYEOKHANGUL JONGSEONG SSANGIEUNGHANGUL JONGSEONG IEUNG-KHIEUKHHAN" +
	"GUL JONGSEONG YESIEUNGHANGUL JONGSEONG YESIEUNG-SIOSHANGUL JONGSEONG YES" +
	"IEUNG-PANSIOSHANGUL JONGSEONG PHIEUPH-PIEUPHANGUL JONGSEONG KAPYEOUNPHIE" +
	"UPHHANGUL JONGSEONG HIEUH-NIEUNHANGUL JONGSEONG HIEUH-RIEULHANGUL JONGSE" +
	"ONG HIEUH-MIEUMHANGUL JONGSEONG HIEUH-PIEUPHANGUL JONGSEONG YEORINHIEUHH" +
	"ANGUL JONGSEONG KIYEOK-NIEUNHANGUL JONGSEONG KIYEOK-PIEUPHANGUL JONGSEON" +
	"G KIYEOK-CHIEUCHHANGUL JONGSEONG KIYEOK-KHIEUKHHANGUL JONGSEONG KIYEOK-H" +
	"IEUHHANGUL JONGSEONG SSANGNIEUNETHIOPIC SYLLABLE HAETHIOPIC SYLLABLE HUE" +
	"THIOPIC SYLLABLE HIETHIOPIC SYLLABLE HAAETHIOPIC SYLLABLE HEEETHIOPIC SY" +
	"LLABLE HEETHIOPIC SYLLABLE HOETHIOPIC SYLLABLE HOAETHIOPIC SYLLABLE LAET" +
	"HIOPIC SYLLABLE LUETHIOPIC SYLLABLE LIETHIOPIC SYLLABLE LAAETHIOPIC SYLL" +
	"ABLE LEEETHIOPIC SYLLABLE LEETHIOPIC SYLLABLE LOETHIOPIC SYLLABLE LWAETH" +
	"IOPIC SYLLABLE HHAETHIOPIC SYLLABLE HHUETHIOPIC SYLLABLE HHIETHIOPIC SYL" +
	"LABLE HHAAETHIOPIC SYLLABLE HHEEETHIOPIC SYLLABLE HHEETHIOPIC SYLLABLE H" +
	"HOETHIOPIC SYLLABLE HHWAETHIOPIC SYLLABLE MAETHIOPIC SYLLABLE MUETHIOPIC" +
	" SYLLABLE MIETHIOPIC SYLLABLE MAAETHIOPIC SYLLABLE MEEETHIOPIC SYLLABLE " +
	"MEETHIOPIC SYLLABLE MOETHIOPIC SYLLABLE MWAETHIOPIC SYLLABLE SZAETHIOPIC" +
	" SYLLABLE SZUETHIOPIC SYLLABLE SZIETHIOPIC SYLLABLE SZAAETHIOPIC SYLLABL" +
	"E SZEEETHIOPIC SYLLABLE SZEETHIOPIC SYLLABLE SZOETHIOPIC SYLLABLE SZWAET" +
	"HIOPIC SYLLABLE RAETHIOPIC SYLLABLE RUETHIOPIC SYLLABLE RIETHIOPIC SYLLA" +
	"BLE RAAETHIOPIC SYLLABLE REEETHIOPIC SYLLABLE REETHIOPIC SYLLABLE ROETHI" +
	"OPIC SYLLABLE RWAETHIOPIC SYLLABLE SAETHIOPIC SYLLABLE SUETHIOPIC SYLLAB" +
	"LE SIETHIOPIC SYLLABLE SAAETHIOPIC SYLLABLE SEEETHIOPIC SYLLABLE SEETHIO" +
	"PIC SYLLABLE SOETHIOPIC SYLLABLE SWAETHIOPIC SYLLABLE SHAETHIOPIC SYLLAB" +
	"LE SHUETHIOPIC SYLLABLE SHIETHIOPIC SYLLABLE SHAAETHIOPIC SYLLABLE SHEEE" +
	"THIOPIC SYLLABLE SHEETHIOPIC SYLLABLE SHOETHIOPIC SYLLABLE SHWAETHIOPIC " +
	"SYLLABLE QAETHIOPIC SYLLABLE QUETHIOPIC SYLLABLE QIETHIOPIC SYLLABLE QAA" +
	"ETHIOPIC SYLLABLE QEEETHIOPIC SYLLABLE QEETHIOPIC SYLLABLE QOETHIOPIC SY" +
	"LLABLE QOAETHIOPIC SYLLABLE QWAETHIOPIC SYLLABLE QWIETHIOPIC SYLLABLE QW" +
	"AAETHIOPIC SYLLABLE QWEEETHIOPIC SYLLABLE QWEETHIOPIC SYLLABLE QHAETHIOP" +
	"IC SYLLABLE QHUETHIOPIC SYLLABLE QHIETHIOPIC SYLLABLE QHAAETHIOPIC SYLLA" +
	"BLE QHEEETHIOPIC SYLLABLE QHEETHIOPIC SYLLABLE QHOETHIOPIC SYLLABLE QHWA" +
	"ETHIOPIC SYLLABLE QHWIETHIOPIC SYLLABLE QHWAAETHIOPIC SYLLABLE QHWEEETHI" +
	"OPIC SYLLABLE QHWEETHIOPIC SYLLABLE BAETHIOPIC SYLLABLE BUETHIOPIC SYLLA" +
	"BLE BIETHIOPIC SYLLABLE BAAETHIOPIC SYLLABLE BEEETHIOPIC SYLLABLE BEETHI" +
	"OPIC SYLLABLE BOETHIOPIC SYLLABLE BWAETHIOPIC SYLLABLE VAETHIOPIC SYLLAB" +
	"LE VUETHIOPIC SYLLABLE VIETHIOPIC SYLLABLE VAAETHIOPIC SYLLABLE VEEETHIO" +
	"PIC SYLLABLE VEETHIOPIC SYLLABLE VOETHIOPIC SYLLABLE VWAETHIOPIC SYLLABL" +
	"E TAETHIOPIC SYLLABLE TUETHIOPIC SYLLABLE TIETHIOPIC SYLLABLE TAAETHIOPI" +
	"C SYLLABLE TEEETHIOPIC SYLLABLE TEETHIOPIC SYLLABLE TOETHIOPIC SYLLABLE " +
	"TWAETHIOPIC SYLLABLE CAETHIOPIC SYLLABLE CUETHIOPIC SYLLABLE CIETHIOPIC ") + ("" +
	"SYLLABLE CAAETHIOPIC SYLLABLE CEEETHIOPIC SYLLABLE CEETHIOPIC SYLLABLE C" +
	"OETHIOPIC SYLLABLE CWAETHIOPIC SYLLABLE XAETHIOPIC SYLLABLE XUETHIOPIC S" +
	"YLLABLE XIETHIOPIC SYLLABLE XAAETHIOPIC SYLLABLE XEEETHIOPIC SYLLABLE XE" +
	"ETHIOPIC SYLLABLE XOETHIOPIC SYLLABLE XOAETHIOPIC SYLLABLE XWAETHIOPIC S" +
	"YLLABLE XWIETHIOPIC SYLLABLE XWAAETHIOPIC SYLLABLE XWEEETHIOPIC SYLLABLE" +
	" XWEETHIOPIC SYLLABLE NAETHIOPIC SYLLABLE NUETHIOPIC SYLLABLE NIETHIOPIC" +
	" SYLLABLE NAAETHIOPIC SYLLABLE NEEETHIOPIC SYLLABLE NEETHIOPIC SYLLABLE " +
	"NOETHIOPIC SYLLABLE NWAETHIOPIC SYLLABLE NYAETHIOPIC SYLLABLE NYUETHIOPI" +
	"C SYLLABLE NYIETHIOPIC SYLLABLE NYAAETHIOPIC SYLLABLE NYEEETHIOPIC SYLLA" +
	"BLE NYEETHIOPIC SYLLABLE NYOETHIOPIC SYLLABLE NYWAETHIOPIC SYLLABLE GLOT" +
	"TAL AETHIOPIC SYLLABLE GLOTTAL UETHIOPIC SYLLABLE GLOTTAL IETHIOPIC SYLL" +
	"ABLE GLOTTAL AAETHIOPIC SYLLABLE GLOTTAL EEETHIOPIC SYLLABLE GLOTTAL EET" +
	"HIOPIC SYLLABLE GLOTTAL OETHIOPIC SYLLABLE GLOTTAL WAETHIOPIC SYLLABLE K" +
	"AETHIOPIC SYLLABLE KUETHIOPIC SYLLABLE KIETHIOPIC SYLLABLE KAAETHIOPIC S" +
	"YLLABLE KEEETHIOPIC SYLLABLE KEETHIOPIC SYLLABLE KOETHIOPIC SYLLABLE KOA" +
	"ETHIOPIC SYLLABLE KWAETHIOPIC SYLLABLE KWIETHIOPIC SYLLABLE KWAAETHIOPIC" +
	" SYLLABLE KWEEETHIOPIC SYLLABLE KWEETHIOPIC SYLLABLE KXAETHIOPIC SYLLABL" +
	"E KXUETHIOPIC SYLLABLE KXIETHIOPIC SYLLABLE KXAAETHIOPIC SYLLABLE KXEEET" +
	"HIOPIC SYLLABLE KXEETHIOPIC SYLLABLE KXOETHIOPIC SYLLABLE KXWAETHIOPIC S" +
	"YLLABLE KXWIETHIOPIC SYLLABLE KXWAAETHIOPIC SYLLABLE KXWEEETHIOPIC SYLLA" +
	"BLE KXWEETHIOPIC SYLLABLE WAETHIOPIC SYLLABLE WUETHIOPIC SYLLABLE WIETHI" +
	"OPIC SYLLABLE WAAETHIOPIC SYLLABLE WEEETHIOPIC SYLLABLE WEETHIOPIC SYLLA" +
	"BLE WOETHIOPIC SYLLABLE WOAETHIOPIC SYLLABLE PHARYNGEAL AETHIOPIC SYLLAB" +
	"LE PHARYNGEAL UETHIOPIC SYLLABLE PHARYNGEAL IETHIOPIC SYLLABLE PHARYNGEA" +
	"L AAETHIOPIC SYLLABLE PHARYNGEAL EEETHIOPIC SYLLABLE PHARYNGEAL EETHIOPI" +
	"C SYLLABLE PHARYNGEAL OETHIOPIC SYLLABLE ZAETHIOPIC SYLLABLE ZUETHIOPIC " +
	"SYLLABLE ZIETHIOPIC SYLLABLE ZAAETHIOPIC SYLLABLE ZEEETHIOPIC SYLLABLE Z" +
	"EETHIOPIC SYLLABLE ZOETHIOPIC SYLLABLE ZWAETHIOPIC SYLLABLE ZHAETHIOPIC " +
	"SYLLABLE ZHUETHIOPIC SYLLABLE ZHIETHIOPIC SYLLABLE ZHAAETHIOPIC SYLLABLE" +
	" ZHEEETHIOPIC SYLLABLE ZHEETHIOPIC SYLLABLE ZHOETHIOPIC SYLLABLE ZHWAETH" +
	"IOPIC SYLLABLE YAETHIOPIC SYLLABLE YUETHIOPIC SYLLABLE YIETHIOPIC SYLLAB" +
	"LE YAAETHIOPIC SYLLABLE YEEETHIOPIC SYLLABLE YEETHIOPIC SYLLABLE YOETHIO" +
	"PIC SYLLABLE YOAETHIOPIC SYLLABLE DAETHIOPIC SYLLABLE DUETHIOPIC SYLLABL" +
	"E DIETHIOPIC SYLLABLE DAAETHIOPIC SYLLABLE DEEETHIOPIC SYLLABLE DEETHIOP" +
	"IC SYLLABLE DOETHIOPIC SYLLABLE DWAETHIOPIC SYLLABLE DDAETHIOPIC SYLLABL" +
	"E DDUETHIOPIC SYLLABLE DDIETHIOPIC SYLLABLE DDAAETHIOPIC SYLLABLE DDEEET" +
	"HIOPIC SYLLABLE DDEETHIOPIC SYLLABLE DDOETHIOPIC SYLLABLE DDWAETHIOPIC S" +
	"YLLABLE JAETHIOPIC SYLLABLE JUETHIOPIC SYLLABLE JIETHIOPIC SYLLABLE JAAE" +
	"THIOPIC SYLLABLE JEEETHIOPIC SYLLABLE JEETHIOPIC SYLLABLE JOETHIOPIC SYL" +
	"LABLE JWAETHIOPIC SYLLABLE GAETHIOPIC SYLLABLE GUETHIOPIC SYLLABLE GIETH" +
	"IOPIC SYLLABLE GAAETHIOPIC SYLLABLE GEEETHIOPIC SYLLABLE GEETHIOPIC SYLL" +
	"ABLE GOETHIOPIC SYLLABLE GOAETHIOPIC SYLLABLE GWAETHIOPIC SYLLABLE GWIET" +
	"HIOPIC SYLLABLE GWAAETHIOPIC SYLLABLE GWEEETHIOPIC SYLLABLE GWEETHIOPIC " +
	"SYLLABLE GGAETHIOPIC SYLLABLE GGUETHIOPIC SYLLABLE GGIETHIOPIC SYLLABLE " +
	"GGAAETHIOPIC SYLLABLE GGEEETHIOPIC SYLLABLE GGEETHIOPIC SYLLABLE GGOETHI" +
	"OPIC SYLLABLE GGWAAETHIOPIC SYLLABLE THAETHIOPIC SYLLABLE THUETHIOPIC SY" +
	"LLABLE THIETHIOPIC SYLLABLE THAAETHIOPIC SYLLABLE THEEETHIOPIC SYLLABLE " +
	"THEETHIOPIC SYLLABLE THOETHIOPIC SYLLABLE THWAETHIOPIC SYLLABLE CHAETHIO" +
	"PIC SYLLABLE CHUETHIOPIC SYLLABLE CHIETHIOPIC SYLLABLE CHAAETHIOPIC SYLL" +
	"ABLE CHEEETHIOPIC SYLLABLE CHEETHIOPIC SYLLABLE CHOETHIOPIC SYLLABLE CHW" +
	"AETHIOPIC SYLLABLE PHAETHIOPIC SYLLABLE PHUETHIOPIC SYLLABLE PHIETHIOPIC" +
	" SYLLABLE PHAAETHIOPIC SYLLABLE PHEEETHIOPIC SYLLABLE PHEETHIOPIC SYLLAB" +
	"LE PHOETHIOPIC SYLLABLE PHWAETHIOPIC SYLLABLE TSAETHIOPIC SYLLABLE TSUET" +
	"HIOPIC SYLLABLE TSIETHIOPIC SYLLABLE TSAAETHIOPIC SYLLABLE TSEEETHIOPIC " +
	"SYLLABLE TSEETHIOPIC SYLLABLE TSOETHIOPIC SYLLABLE TSWAETHIOPIC SYLLABLE" +
	" TZAETHIOPIC SYLLABLE TZUETHIOPIC SYLLABLE TZIETHIOPIC SYLLABLE TZAAETHI" +
	"OPIC SYLLABLE TZEEETHIOPIC SYLLABLE TZEETHIOPIC SYLLABLE TZOETHIOPIC SYL" +
	"LABLE TZOAETHIOPIC SYLLABLE FAETHIOPIC SYLLABLE FUETHIOPIC SYLLABLE FIET" +
	"HIOPIC SYLLABLE FAAETHIOPIC SYLLABLE FEEETHIOPIC SYLLABLE FEETHIOPIC SYL" +
	"LABLE FOETHIOPIC SYLLABLE FWAETHIOPIC SYLLABLE PAETHIOPIC SYLLABLE PUETH" +
	"IOPIC SYLLABLE PIETHIOPIC SYLLABLE PAAETHIOPIC SYLLABLE PEEETHIOPIC SYLL" +
	"ABLE PEETHIOPIC SYLLABLE POETHIOPIC SYLLABLE PWAETHIOPIC SYLLABLE RYAETH" +
	"IOPIC SYLLABLE MYAETHIOPIC SYLLABLE FYAETHIOPIC COMBINING GEMINATION AND" +
	" VOWEL LENGTH MARKETHIOPIC COMBINING VOWEL LENGTH MARKETHIOPIC COMBINING") + ("" +
	" GEMINATION MARKETHIOPIC SECTION MARKETHIOPIC WORDSPACEETHIOPIC FULL STO" +
	"PETHIOPIC COMMAETHIOPIC SEMICOLONETHIOPIC COLONETHIOPIC PREFACE COLONETH" +
	"IOPIC QUESTION MARKETHIOPIC PARAGRAPH SEPARATORETHIOPIC DIGIT ONEETHIOPI" +
	"C DIGIT TWOETHIOPIC DIGIT THREEETHIOPIC DIGIT FOURETHIOPIC DIGIT FIVEETH" +
	"IOPIC DIGIT SIXETHIOPIC DIGIT SEVENETHIOPIC DIGIT EIGHTETHIOPIC DIGIT NI" +
	"NEETHIOPIC NUMBER TENETHIOPIC NUMBER TWENTYETHIOPIC NUMBER THIRTYETHIOPI" +
	"C NUMBER FORTYETHIOPIC NUMBER FIFTYETHIOPIC NUMBER SIXTYETHIOPIC NUMBER " +
	"SEVENTYETHIOPIC NUMBER EIGHTYETHIOPIC NUMBER NINETYETHIOPIC NUMBER HUNDR" +
	"EDETHIOPIC NUMBER TEN THOUSANDETHIOPIC SYLLABLE SEBATBEIT MWAETHIOPIC SY" +
	"LLABLE MWIETHIOPIC SYLLABLE MWEEETHIOPIC SYLLABLE MWEETHIOPIC SYLLABLE S" +
	"EBATBEIT BWAETHIOPIC SYLLABLE BWIETHIOPIC SYLLABLE BWEEETHIOPIC SYLLABLE" +
	" BWEETHIOPIC SYLLABLE SEBATBEIT FWAETHIOPIC SYLLABLE FWIETHIOPIC SYLLABL" +
	"E FWEEETHIOPIC SYLLABLE FWEETHIOPIC SYLLABLE SEBATBEIT PWAETHIOPIC SYLLA" +
	"BLE PWIETHIOPIC SYLLABLE PWEEETHIOPIC SYLLABLE PWEETHIOPIC TONAL MARK YI" +
	"ZETETHIOPIC TONAL MARK DERETETHIOPIC TONAL MARK RIKRIKETHIOPIC TONAL MAR" +
	"K SHORT RIKRIKETHIOPIC TONAL MARK DIFATETHIOPIC TONAL MARK KENATETHIOPIC" +
	" TONAL MARK CHIRETETHIOPIC TONAL MARK HIDETETHIOPIC TONAL MARK DERET-HID" +
	"ETETHIOPIC TONAL MARK KURTCHEROKEE LETTER ACHEROKEE LETTER ECHEROKEE LET" +
	"TER ICHEROKEE LETTER OCHEROKEE LETTER UCHEROKEE LETTER VCHEROKEE LETTER " +
	"GACHEROKEE LETTER KACHEROKEE LETTER GECHEROKEE LETTER GICHEROKEE LETTER " +
	"GOCHEROKEE LETTER GUCHEROKEE LETTER GVCHEROKEE LETTER HACHEROKEE LETTER " +
	"HECHEROKEE LETTER HICHEROKEE LETTER HOCHEROKEE LETTER HUCHEROKEE LETTER " +
	"HVCHEROKEE LETTER LACHEROKEE LETTER LECHEROKEE LETTER LICHEROKEE LETTER " +
	"LOCHEROKEE LETTER LUCHEROKEE LETTER LVCHEROKEE LETTER MACHEROKEE LETTER " +
	"MECHEROKEE LETTER MICHEROKEE LETTER MOCHEROKEE LETTER MUCHEROKEE LETTER " +
	"NACHEROKEE LETTER HNACHEROKEE LETTER NAHCHEROKEE LETTER NECHEROKEE LETTE" +
	"R NICHEROKEE LETTER NOCHEROKEE LETTER NUCHEROKEE LETTER NVCHEROKEE LETTE" +
	"R QUACHEROKEE LETTER QUECHEROKEE LETTER QUICHEROKEE LETTER QUOCHEROKEE L" +
	"ETTER QUUCHEROKEE LETTER QUVCHEROKEE LETTER SACHEROKEE LETTER SCHEROKEE " +
	"LETTER SECHEROKEE LETTER SICHEROKEE LETTER SOCHEROKEE LETTER SUCHEROKEE " +
	"LETTER SVCHEROKEE LETTER DACHEROKEE LETTER TACHEROKEE LETTER DECHEROKEE " +
	"LETTER TECHEROKEE LETTER DICHEROKEE LETTER TICHEROKEE LETTER DOCHEROKEE " +
	"LETTER DUCHEROKEE LETTER DVCHEROKEE LETTER DLACHEROKEE LETTER TLACHEROKE" +
	"E LETTER TLECHEROKEE LETTER TLICHEROKEE LETTER TLOCHEROKEE LETTER TLUCHE" +
	"ROKEE LETTER TLVCHEROKEE LETTER TSACHEROKEE LETTER TSECHEROKEE LETTER TS" +
	"ICHEROKEE LETTER TSOCHEROKEE LETTER TSUCHEROKEE LETTER TSVCHEROKEE LETTE" +
	"R WACHEROKEE LETTER WECHEROKEE LETTER WICHEROKEE LETTER WOCHEROKEE LETTE" +
	"R WUCHEROKEE LETTER WVCHEROKEE LETTER YACHEROKEE LETTER YECHEROKEE LETTE" +
	"R YICHEROKEE LETTER YOCHEROKEE LETTER YUCHEROKEE LETTER YVCHEROKEE LETTE" +
	"R MVCHEROKEE SMALL LETTER YECHEROKEE SMALL LETTER YICHEROKEE SMALL LETTE" +
	"R YOCHEROKEE SMALL LETTER YUCHEROKEE SMALL LETTER YVCHEROKEE SMALL LETTE" +
	"R MVCANADIAN SYLLABICS HYPHENCANADIAN SYLLABICS ECANADIAN SYLLABICS AAIC" +
	"ANADIAN SYLLABICS ICANADIAN SYLLABICS IICANADIAN SYLLABICS OCANADIAN SYL" +
	"LABICS OOCANADIAN SYLLABICS Y-CREE OOCANADIAN SYLLABICS CARRIER EECANADI" +
	"AN SYLLABICS CARRIER ICANADIAN SYLLABICS ACANADIAN SYLLABICS AACANADIAN " +
	"SYLLABICS WECANADIAN SYLLABICS WEST-CREE WECANADIAN SYLLABICS WICANADIAN" +
	" SYLLABICS WEST-CREE WICANADIAN SYLLABICS WIICANADIAN SYLLABICS WEST-CRE" +
	"E WIICANADIAN SYLLABICS WOCANADIAN SYLLABICS WEST-CREE WOCANADIAN SYLLAB" +
	"ICS WOOCANADIAN SYLLABICS WEST-CREE WOOCANADIAN SYLLABICS NASKAPI WOOCAN" +
	"ADIAN SYLLABICS WACANADIAN SYLLABICS WEST-CREE WACANADIAN SYLLABICS WAAC" +
	"ANADIAN SYLLABICS WEST-CREE WAACANADIAN SYLLABICS NASKAPI WAACANADIAN SY" +
	"LLABICS AICANADIAN SYLLABICS Y-CREE WCANADIAN SYLLABICS GLOTTAL STOPCANA" +
	"DIAN SYLLABICS FINAL ACUTECANADIAN SYLLABICS FINAL GRAVECANADIAN SYLLABI" +
	"CS FINAL BOTTOM HALF RINGCANADIAN SYLLABICS FINAL TOP HALF RINGCANADIAN " +
	"SYLLABICS FINAL RIGHT HALF RINGCANADIAN SYLLABICS FINAL RINGCANADIAN SYL" +
	"LABICS FINAL DOUBLE ACUTECANADIAN SYLLABICS FINAL DOUBLE SHORT VERTICAL " +
	"STROKESCANADIAN SYLLABICS FINAL MIDDLE DOTCANADIAN SYLLABICS FINAL SHORT" +
	" HORIZONTAL STROKECANADIAN SYLLABICS FINAL PLUSCANADIAN SYLLABICS FINAL " +
	"DOWN TACKCANADIAN SYLLABICS ENCANADIAN SYLLABICS INCANADIAN SYLLABICS ON" +
	"CANADIAN SYLLABICS ANCANADIAN SYLLABICS PECANADIAN SYLLABICS PAAICANADIA" +
	"N SYLLABICS PICANADIAN SYLLABICS PIICANADIAN SYLLABICS POCANADIAN SYLLAB" +
	"ICS POOCANADIAN SYLLABICS Y-CREE POOCANADIAN SYLLABICS CARRIER HEECANADI" +
	"AN SYLLABICS CARRIER HICANADIAN SYLLABICS PACANADIAN SYLLABICS PAACANADI" +
	"AN SYLLABICS PWECANADIAN SYLLABICS WEST-CREE PWECANADIAN SYLLABICS PWICA") + ("" +
	"NADIAN SYLLABICS WEST-CREE PWICANADIAN SYLLABICS PWIICANADIAN SYLLABICS " +
	"WEST-CREE PWIICANADIAN SYLLABICS PWOCANADIAN SYLLABICS WEST-CREE PWOCANA" +
	"DIAN SYLLABICS PWOOCANADIAN SYLLABICS WEST-CREE PWOOCANADIAN SYLLABICS P" +
	"WACANADIAN SYLLABICS WEST-CREE PWACANADIAN SYLLABICS PWAACANADIAN SYLLAB" +
	"ICS WEST-CREE PWAACANADIAN SYLLABICS Y-CREE PWAACANADIAN SYLLABICS PCANA" +
	"DIAN SYLLABICS WEST-CREE PCANADIAN SYLLABICS CARRIER HCANADIAN SYLLABICS" +
	" TECANADIAN SYLLABICS TAAICANADIAN SYLLABICS TICANADIAN SYLLABICS TIICAN" +
	"ADIAN SYLLABICS TOCANADIAN SYLLABICS TOOCANADIAN SYLLABICS Y-CREE TOOCAN" +
	"ADIAN SYLLABICS CARRIER DEECANADIAN SYLLABICS CARRIER DICANADIAN SYLLABI" +
	"CS TACANADIAN SYLLABICS TAACANADIAN SYLLABICS TWECANADIAN SYLLABICS WEST" +
	"-CREE TWECANADIAN SYLLABICS TWICANADIAN SYLLABICS WEST-CREE TWICANADIAN " +
	"SYLLABICS TWIICANADIAN SYLLABICS WEST-CREE TWIICANADIAN SYLLABICS TWOCAN" +
	"ADIAN SYLLABICS WEST-CREE TWOCANADIAN SYLLABICS TWOOCANADIAN SYLLABICS W" +
	"EST-CREE TWOOCANADIAN SYLLABICS TWACANADIAN SYLLABICS WEST-CREE TWACANAD" +
	"IAN SYLLABICS TWAACANADIAN SYLLABICS WEST-CREE TWAACANADIAN SYLLABICS NA" +
	"SKAPI TWAACANADIAN SYLLABICS TCANADIAN SYLLABICS TTECANADIAN SYLLABICS T" +
	"TICANADIAN SYLLABICS TTOCANADIAN SYLLABICS TTACANADIAN SYLLABICS KECANAD" +
	"IAN SYLLABICS KAAICANADIAN SYLLABICS KICANADIAN SYLLABICS KIICANADIAN SY" +
	"LLABICS KOCANADIAN SYLLABICS KOOCANADIAN SYLLABICS Y-CREE KOOCANADIAN SY" +
	"LLABICS KACANADIAN SYLLABICS KAACANADIAN SYLLABICS KWECANADIAN SYLLABICS" +
	" WEST-CREE KWECANADIAN SYLLABICS KWICANADIAN SYLLABICS WEST-CREE KWICANA" +
	"DIAN SYLLABICS KWIICANADIAN SYLLABICS WEST-CREE KWIICANADIAN SYLLABICS K" +
	"WOCANADIAN SYLLABICS WEST-CREE KWOCANADIAN SYLLABICS KWOOCANADIAN SYLLAB" +
	"ICS WEST-CREE KWOOCANADIAN SYLLABICS KWACANADIAN SYLLABICS WEST-CREE KWA" +
	"CANADIAN SYLLABICS KWAACANADIAN SYLLABICS WEST-CREE KWAACANADIAN SYLLABI" +
	"CS NASKAPI KWAACANADIAN SYLLABICS KCANADIAN SYLLABICS KWCANADIAN SYLLABI" +
	"CS SOUTH-SLAVEY KEHCANADIAN SYLLABICS SOUTH-SLAVEY KIHCANADIAN SYLLABICS" +
	" SOUTH-SLAVEY KOHCANADIAN SYLLABICS SOUTH-SLAVEY KAHCANADIAN SYLLABICS C" +
	"ECANADIAN SYLLABICS CAAICANADIAN SYLLABICS CICANADIAN SYLLABICS CIICANAD" +
	"IAN SYLLABICS COCANADIAN SYLLABICS COOCANADIAN SYLLABICS Y-CREE COOCANAD" +
	"IAN SYLLABICS CACANADIAN SYLLABICS CAACANADIAN SYLLABICS CWECANADIAN SYL" +
	"LABICS WEST-CREE CWECANADIAN SYLLABICS CWICANADIAN SYLLABICS WEST-CREE C" +
	"WICANADIAN SYLLABICS CWIICANADIAN SYLLABICS WEST-CREE CWIICANADIAN SYLLA" +
	"BICS CWOCANADIAN SYLLABICS WEST-CREE CWOCANADIAN SYLLABICS CWOOCANADIAN " +
	"SYLLABICS WEST-CREE CWOOCANADIAN SYLLABICS CWACANADIAN SYLLABICS WEST-CR" +
	"EE CWACANADIAN SYLLABICS CWAACANADIAN SYLLABICS WEST-CREE CWAACANADIAN S" +
	"YLLABICS NASKAPI CWAACANADIAN SYLLABICS CCANADIAN SYLLABICS SAYISI THCAN" +
	"ADIAN SYLLABICS MECANADIAN SYLLABICS MAAICANADIAN SYLLABICS MICANADIAN S" +
	"YLLABICS MIICANADIAN SYLLABICS MOCANADIAN SYLLABICS MOOCANADIAN SYLLABIC" +
	"S Y-CREE MOOCANADIAN SYLLABICS MACANADIAN SYLLABICS MAACANADIAN SYLLABIC" +
	"S MWECANADIAN SYLLABICS WEST-CREE MWECANADIAN SYLLABICS MWICANADIAN SYLL" +
	"ABICS WEST-CREE MWICANADIAN SYLLABICS MWIICANADIAN SYLLABICS WEST-CREE M" +
	"WIICANADIAN SYLLABICS MWOCANADIAN SYLLABICS WEST-CREE MWOCANADIAN SYLLAB" +
	"ICS MWOOCANADIAN SYLLABICS WEST-CREE MWOOCANADIAN SYLLABICS MWACANADIAN " +
	"SYLLABICS WEST-CREE MWACANADIAN SYLLABICS MWAACANADIAN SYLLABICS WEST-CR" +
	"EE MWAACANADIAN SYLLABICS NASKAPI MWAACANADIAN SYLLABICS MCANADIAN SYLLA" +
	"BICS WEST-CREE MCANADIAN SYLLABICS MHCANADIAN SYLLABICS ATHAPASCAN MCANA" +
	"DIAN SYLLABICS SAYISI MCANADIAN SYLLABICS NECANADIAN SYLLABICS NAAICANAD" +
	"IAN SYLLABICS NICANADIAN SYLLABICS NIICANADIAN SYLLABICS NOCANADIAN SYLL" +
	"ABICS NOOCANADIAN SYLLABICS Y-CREE NOOCANADIAN SYLLABICS NACANADIAN SYLL" +
	"ABICS NAACANADIAN SYLLABICS NWECANADIAN SYLLABICS WEST-CREE NWECANADIAN " +
	"SYLLABICS NWACANADIAN SYLLABICS WEST-CREE NWACANADIAN SYLLABICS NWAACANA" +
	"DIAN SYLLABICS WEST-CREE NWAACANADIAN SYLLABICS NASKAPI NWAACANADIAN SYL" +
	"LABICS NCANADIAN SYLLABICS CARRIER NGCANADIAN SYLLABICS NHCANADIAN SYLLA" +
	"BICS LECANADIAN SYLLABICS LAAICANADIAN SYLLABICS LICANADIAN SYLLABICS LI" +
	"ICANADIAN SYLLABICS LOCANADIAN SYLLABICS LOOCANADIAN SYLLABICS Y-CREE LO" +
	"OCANADIAN SYLLABICS LACANADIAN SYLLABICS LAACANADIAN SYLLABICS LWECANADI" +
	"AN SYLLABICS WEST-CREE LWECANADIAN SYLLABICS LWICANADIAN SYLLABICS WEST-" +
	"CREE LWICANADIAN SYLLABICS LWIICANADIAN SYLLABICS WEST-CREE LWIICANADIAN" +
	" SYLLABICS LWOCANADIAN SYLLABICS WEST-CREE LWOCANADIAN SYLLABICS LWOOCAN" +
	"ADIAN SYLLABICS WEST-CREE LWOOCANADIAN SYLLABICS LWACANADIAN SYLLABICS W" +
	"EST-CREE LWACANADIAN SYLLABICS LWAACANADIAN SYLLABICS WEST-CREE LWAACANA" +
	"DIAN SYLLABICS LCANADIAN SYLLABICS WEST-CREE LCANADIAN SYLLABICS MEDIAL " +
	"LCANADIAN SYLLABICS SECANADIAN SYLLABICS SAAICANADIAN SYLLABICS SICANADI") + ("" +
	"AN SYLLABICS SIICANADIAN SYLLABICS SOCANADIAN SYLLABICS SOOCANADIAN SYLL" +
	"ABICS Y-CREE SOOCANADIAN SYLLABICS SACANADIAN SYLLABICS SAACANADIAN SYLL" +
	"ABICS SWECANADIAN SYLLABICS WEST-CREE SWECANADIAN SYLLABICS SWICANADIAN " +
	"SYLLABICS WEST-CREE SWICANADIAN SYLLABICS SWIICANADIAN SYLLABICS WEST-CR" +
	"EE SWIICANADIAN SYLLABICS SWOCANADIAN SYLLABICS WEST-CREE SWOCANADIAN SY" +
	"LLABICS SWOOCANADIAN SYLLABICS WEST-CREE SWOOCANADIAN SYLLABICS SWACANAD" +
	"IAN SYLLABICS WEST-CREE SWACANADIAN SYLLABICS SWAACANADIAN SYLLABICS WES" +
	"T-CREE SWAACANADIAN SYLLABICS NASKAPI SWAACANADIAN SYLLABICS SCANADIAN S" +
	"YLLABICS ATHAPASCAN SCANADIAN SYLLABICS SWCANADIAN SYLLABICS BLACKFOOT S" +
	"CANADIAN SYLLABICS MOOSE-CREE SKCANADIAN SYLLABICS NASKAPI SKWCANADIAN S" +
	"YLLABICS NASKAPI S-WCANADIAN SYLLABICS NASKAPI SPWACANADIAN SYLLABICS NA" +
	"SKAPI STWACANADIAN SYLLABICS NASKAPI SKWACANADIAN SYLLABICS NASKAPI SCWA" +
	"CANADIAN SYLLABICS SHECANADIAN SYLLABICS SHICANADIAN SYLLABICS SHIICANAD" +
	"IAN SYLLABICS SHOCANADIAN SYLLABICS SHOOCANADIAN SYLLABICS SHACANADIAN S" +
	"YLLABICS SHAACANADIAN SYLLABICS SHWECANADIAN SYLLABICS WEST-CREE SHWECAN" +
	"ADIAN SYLLABICS SHWICANADIAN SYLLABICS WEST-CREE SHWICANADIAN SYLLABICS " +
	"SHWIICANADIAN SYLLABICS WEST-CREE SHWIICANADIAN SYLLABICS SHWOCANADIAN S" +
	"YLLABICS WEST-CREE SHWOCANADIAN SYLLABICS SHWOOCANADIAN SYLLABICS WEST-C" +
	"REE SHWOOCANADIAN SYLLABICS SHWACANADIAN SYLLABICS WEST-CREE SHWACANADIA" +
	"N SYLLABICS SHWAACANADIAN SYLLABICS WEST-CREE SHWAACANADIAN SYLLABICS SH" +
	"CANADIAN SYLLABICS YECANADIAN SYLLABICS YAAICANADIAN SYLLABICS YICANADIA" +
	"N SYLLABICS YIICANADIAN SYLLABICS YOCANADIAN SYLLABICS YOOCANADIAN SYLLA" +
	"BICS Y-CREE YOOCANADIAN SYLLABICS YACANADIAN SYLLABICS YAACANADIAN SYLLA" +
	"BICS YWECANADIAN SYLLABICS WEST-CREE YWECANADIAN SYLLABICS YWICANADIAN S" +
	"YLLABICS WEST-CREE YWICANADIAN SYLLABICS YWIICANADIAN SYLLABICS WEST-CRE" +
	"E YWIICANADIAN SYLLABICS YWOCANADIAN SYLLABICS WEST-CREE YWOCANADIAN SYL" +
	"LABICS YWOOCANADIAN SYLLABICS WEST-CREE YWOOCANADIAN SYLLABICS YWACANADI" +
	"AN SYLLABICS WEST-CREE YWACANADIAN SYLLABICS YWAACANADIAN SYLLABICS WEST" +
	"-CREE YWAACANADIAN SYLLABICS NASKAPI YWAACANADIAN SYLLABICS YCANADIAN SY" +
	"LLABICS BIBLE-CREE YCANADIAN SYLLABICS WEST-CREE YCANADIAN SYLLABICS SAY" +
	"ISI YICANADIAN SYLLABICS RECANADIAN SYLLABICS R-CREE RECANADIAN SYLLABIC" +
	"S WEST-CREE LECANADIAN SYLLABICS RAAICANADIAN SYLLABICS RICANADIAN SYLLA" +
	"BICS RIICANADIAN SYLLABICS ROCANADIAN SYLLABICS ROOCANADIAN SYLLABICS WE" +
	"ST-CREE LOCANADIAN SYLLABICS RACANADIAN SYLLABICS RAACANADIAN SYLLABICS " +
	"WEST-CREE LACANADIAN SYLLABICS RWAACANADIAN SYLLABICS WEST-CREE RWAACANA" +
	"DIAN SYLLABICS RCANADIAN SYLLABICS WEST-CREE RCANADIAN SYLLABICS MEDIAL " +
	"RCANADIAN SYLLABICS FECANADIAN SYLLABICS FAAICANADIAN SYLLABICS FICANADI" +
	"AN SYLLABICS FIICANADIAN SYLLABICS FOCANADIAN SYLLABICS FOOCANADIAN SYLL" +
	"ABICS FACANADIAN SYLLABICS FAACANADIAN SYLLABICS FWAACANADIAN SYLLABICS " +
	"WEST-CREE FWAACANADIAN SYLLABICS FCANADIAN SYLLABICS THECANADIAN SYLLABI" +
	"CS N-CREE THECANADIAN SYLLABICS THICANADIAN SYLLABICS N-CREE THICANADIAN" +
	" SYLLABICS THIICANADIAN SYLLABICS N-CREE THIICANADIAN SYLLABICS THOCANAD" +
	"IAN SYLLABICS THOOCANADIAN SYLLABICS THACANADIAN SYLLABICS THAACANADIAN " +
	"SYLLABICS THWAACANADIAN SYLLABICS WEST-CREE THWAACANADIAN SYLLABICS THCA" +
	"NADIAN SYLLABICS TTHECANADIAN SYLLABICS TTHICANADIAN SYLLABICS TTHOCANAD" +
	"IAN SYLLABICS TTHACANADIAN SYLLABICS TTHCANADIAN SYLLABICS TYECANADIAN S" +
	"YLLABICS TYICANADIAN SYLLABICS TYOCANADIAN SYLLABICS TYACANADIAN SYLLABI" +
	"CS NUNAVIK HECANADIAN SYLLABICS NUNAVIK HICANADIAN SYLLABICS NUNAVIK HII" +
	"CANADIAN SYLLABICS NUNAVIK HOCANADIAN SYLLABICS NUNAVIK HOOCANADIAN SYLL" +
	"ABICS NUNAVIK HACANADIAN SYLLABICS NUNAVIK HAACANADIAN SYLLABICS NUNAVIK" +
	" HCANADIAN SYLLABICS NUNAVUT HCANADIAN SYLLABICS HKCANADIAN SYLLABICS QA" +
	"AICANADIAN SYLLABICS QICANADIAN SYLLABICS QIICANADIAN SYLLABICS QOCANADI" +
	"AN SYLLABICS QOOCANADIAN SYLLABICS QACANADIAN SYLLABICS QAACANADIAN SYLL" +
	"ABICS QCANADIAN SYLLABICS TLHECANADIAN SYLLABICS TLHICANADIAN SYLLABICS " +
	"TLHOCANADIAN SYLLABICS TLHACANADIAN SYLLABICS WEST-CREE RECANADIAN SYLLA" +
	"BICS WEST-CREE RICANADIAN SYLLABICS WEST-CREE ROCANADIAN SYLLABICS WEST-" +
	"CREE RACANADIAN SYLLABICS NGAAICANADIAN SYLLABICS NGICANADIAN SYLLABICS " +
	"NGIICANADIAN SYLLABICS NGOCANADIAN SYLLABICS NGOOCANADIAN SYLLABICS NGAC" +
	"ANADIAN SYLLABICS NGAACANADIAN SYLLABICS NGCANADIAN SYLLABICS NNGCANADIA" +
	"N SYLLABICS SAYISI SHECANADIAN SYLLABICS SAYISI SHICANADIAN SYLLABICS SA" +
	"YISI SHOCANADIAN SYLLABICS SAYISI SHACANADIAN SYLLABICS WOODS-CREE THECA" +
	"NADIAN SYLLABICS WOODS-CREE THICANADIAN SYLLABICS WOODS-CREE THOCANADIAN" +
	" SYLLABICS WOODS-CREE THACANADIAN SYLLABICS WOODS-CREE THCANADIAN SYLLAB" +
	"ICS LHICANADIAN SYLLABICS LHIICANADIAN SYLLABICS LHOCANADIAN SYLLABICS L") + ("" +
	"HOOCANADIAN SYLLABICS LHACANADIAN SYLLABICS LHAACANADIAN SYLLABICS LHCAN" +
	"ADIAN SYLLABICS TH-CREE THECANADIAN SYLLABICS TH-CREE THICANADIAN SYLLAB" +
	"ICS TH-CREE THIICANADIAN SYLLABICS TH-CREE THOCANADIAN SYLLABICS TH-CREE" +
	" THOOCANADIAN SYLLABICS TH-CREE THACANADIAN SYLLABICS TH-CREE THAACANADI" +
	"AN SYLLABICS TH-CREE THCANADIAN SYLLABICS AIVILIK BCANADIAN SYLLABICS BL" +
	"ACKFOOT ECANADIAN SYLLABICS BLACKFOOT ICANADIAN SYLLABICS BLACKFOOT OCAN" +
	"ADIAN SYLLABICS BLACKFOOT ACANADIAN SYLLABICS BLACKFOOT WECANADIAN SYLLA" +
	"BICS BLACKFOOT WICANADIAN SYLLABICS BLACKFOOT WOCANADIAN SYLLABICS BLACK" +
	"FOOT WACANADIAN SYLLABICS BLACKFOOT NECANADIAN SYLLABICS BLACKFOOT NICAN" +
	"ADIAN SYLLABICS BLACKFOOT NOCANADIAN SYLLABICS BLACKFOOT NACANADIAN SYLL" +
	"ABICS BLACKFOOT KECANADIAN SYLLABICS BLACKFOOT KICANADIAN SYLLABICS BLAC" +
	"KFOOT KOCANADIAN SYLLABICS BLACKFOOT KACANADIAN SYLLABICS SAYISI HECANAD" +
	"IAN SYLLABICS SAYISI HICANADIAN SYLLABICS SAYISI HOCANADIAN SYLLABICS SA" +
	"YISI HACANADIAN SYLLABICS CARRIER GHUCANADIAN SYLLABICS CARRIER GHOCANAD" +
	"IAN SYLLABICS CARRIER GHECANADIAN SYLLABICS CARRIER GHEECANADIAN SYLLABI" +
	"CS CARRIER GHICANADIAN SYLLABICS CARRIER GHACANADIAN SYLLABICS CARRIER R" +
	"UCANADIAN SYLLABICS CARRIER ROCANADIAN SYLLABICS CARRIER RECANADIAN SYLL" +
	"ABICS CARRIER REECANADIAN SYLLABICS CARRIER RICANADIAN SYLLABICS CARRIER" +
	" RACANADIAN SYLLABICS CARRIER WUCANADIAN SYLLABICS CARRIER WOCANADIAN SY" +
	"LLABICS CARRIER WECANADIAN SYLLABICS CARRIER WEECANADIAN SYLLABICS CARRI" +
	"ER WICANADIAN SYLLABICS CARRIER WACANADIAN SYLLABICS CARRIER HWUCANADIAN" +
	" SYLLABICS CARRIER HWOCANADIAN SYLLABICS CARRIER HWECANADIAN SYLLABICS C" +
	"ARRIER HWEECANADIAN SYLLABICS CARRIER HWICANADIAN SYLLABICS CARRIER HWAC" +
	"ANADIAN SYLLABICS CARRIER THUCANADIAN SYLLABICS CARRIER THOCANADIAN SYLL" +
	"ABICS CARRIER THECANADIAN SYLLABICS CARRIER THEECANADIAN SYLLABICS CARRI" +
	"ER THICANADIAN SYLLABICS CARRIER THACANADIAN SYLLABICS CARRIER TTUCANADI" +
	"AN SYLLABICS CARRIER TTOCANADIAN SYLLABICS CARRIER TTECANADIAN SYLLABICS" +
	" CARRIER TTEECANADIAN SYLLABICS CARRIER TTICANADIAN SYLLABICS CARRIER TT" +
	"ACANADIAN SYLLABICS CARRIER PUCANADIAN SYLLABICS CARRIER POCANADIAN SYLL" +
	"ABICS CARRIER PECANADIAN SYLLABICS CARRIER PEECANADIAN SYLLABICS CARRIER" +
	" PICANADIAN SYLLABICS CARRIER PACANADIAN SYLLABICS CARRIER PCANADIAN SYL" +
	"LABICS CARRIER GUCANADIAN SYLLABICS CARRIER GOCANADIAN SYLLABICS CARRIER" +
	" GECANADIAN SYLLABICS CARRIER GEECANADIAN SYLLABICS CARRIER GICANADIAN S" +
	"YLLABICS CARRIER GACANADIAN SYLLABICS CARRIER KHUCANADIAN SYLLABICS CARR" +
	"IER KHOCANADIAN SYLLABICS CARRIER KHECANADIAN SYLLABICS CARRIER KHEECANA" +
	"DIAN SYLLABICS CARRIER KHICANADIAN SYLLABICS CARRIER KHACANADIAN SYLLABI" +
	"CS CARRIER KKUCANADIAN SYLLABICS CARRIER KKOCANADIAN SYLLABICS CARRIER K" +
	"KECANADIAN SYLLABICS CARRIER KKEECANADIAN SYLLABICS CARRIER KKICANADIAN " +
	"SYLLABICS CARRIER KKACANADIAN SYLLABICS CARRIER KKCANADIAN SYLLABICS CAR" +
	"RIER NUCANADIAN SYLLABICS CARRIER NOCANADIAN SYLLABICS CARRIER NECANADIA" +
	"N SYLLABICS CARRIER NEECANADIAN SYLLABICS CARRIER NICANADIAN SYLLABICS C" +
	"ARRIER NACANADIAN SYLLABICS CARRIER MUCANADIAN SYLLABICS CARRIER MOCANAD" +
	"IAN SYLLABICS CARRIER MECANADIAN SYLLABICS CARRIER MEECANADIAN SYLLABICS" +
	" CARRIER MICANADIAN SYLLABICS CARRIER MACANADIAN SYLLABICS CARRIER YUCAN" +
	"ADIAN SYLLABICS CARRIER YOCANADIAN SYLLABICS CARRIER YECANADIAN SYLLABIC" +
	"S CARRIER YEECANADIAN SYLLABICS CARRIER YICANADIAN SYLLABICS CARRIER YAC" +
	"ANADIAN SYLLABICS CARRIER JUCANADIAN SYLLABICS SAYISI JUCANADIAN SYLLABI" +
	"CS CARRIER JOCANADIAN SYLLABICS CARRIER JECANADIAN SYLLABICS CARRIER JEE" +
	"CANADIAN SYLLABICS CARRIER JICANADIAN SYLLABICS SAYISI JICANADIAN SYLLAB" +
	"ICS CARRIER JACANADIAN SYLLABICS CARRIER JJUCANADIAN SYLLABICS CARRIER J" +
	"JOCANADIAN SYLLABICS CARRIER JJECANADIAN SYLLABICS CARRIER JJEECANADIAN " +
	"SYLLABICS CARRIER JJICANADIAN SYLLABICS CARRIER JJACANADIAN SYLLABICS CA" +
	"RRIER LUCANADIAN SYLLABICS CARRIER LOCANADIAN SYLLABICS CARRIER LECANADI" +
	"AN SYLLABICS CARRIER LEECANADIAN SYLLABICS CARRIER LICANADIAN SYLLABICS " +
	"CARRIER LACANADIAN SYLLABICS CARRIER DLUCANADIAN SYLLABICS CARRIER DLOCA" +
	"NADIAN SYLLABICS CARRIER DLECANADIAN SYLLABICS CARRIER DLEECANADIAN SYLL" +
	"ABICS CARRIER DLICANADIAN SYLLABICS CARRIER DLACANADIAN SYLLABICS CARRIE" +
	"R LHUCANADIAN SYLLABICS CARRIER LHOCANADIAN SYLLABICS CARRIER LHECANADIA" +
	"N SYLLABICS CARRIER LHEECANADIAN SYLLABICS CARRIER LHICANADIAN SYLLABICS" +
	" CARRIER LHACANADIAN SYLLABICS CARRIER TLHUCANADIAN SYLLABICS CARRIER TL" +
	"HOCANADIAN SYLLABICS CARRIER TLHECANADIAN SYLLABICS CARRIER TLHEECANADIA" +
	"N SYLLABICS CARRIER TLHICANADIAN SYLLABICS CARRIER TLHACANADIAN SYLLABIC" +
	"S CARRIER TLUCANADIAN SYLLABICS CARRIER TLOCANADIAN SYLLABICS CARRIER TL" +
	"ECANADIAN SYLLABICS CARRIER TLEECANADIAN SYLLABICS CARRIER TLICANADIAN S") + ("" +
	"YLLABICS CARRIER TLACANADIAN SYLLABICS CARRIER ZUCANADIAN SYLLABICS CARR" +
	"IER ZOCANADIAN SYLLABICS CARRIER ZECANADIAN SYLLABICS CARRIER ZEECANADIA" +
	"N SYLLABICS CARRIER ZICANADIAN SYLLABICS CARRIER ZACANADIAN SYLLABICS CA" +
	"RRIER ZCANADIAN SYLLABICS CARRIER INITIAL ZCANADIAN SYLLABICS CARRIER DZ" +
	"UCANADIAN SYLLABICS CARRIER DZOCANADIAN SYLLABICS CARRIER DZECANADIAN SY" +
	"LLABICS CARRIER DZEECANADIAN SYLLABICS CARRIER DZICANADIAN SYLLABICS CAR" +
	"RIER DZACANADIAN SYLLABICS CARRIER SUCANADIAN SYLLABICS CARRIER SOCANADI" +
	"AN SYLLABICS CARRIER SECANADIAN SYLLABICS CARRIER SEECANADIAN SYLLABICS " +
	"CARRIER SICANADIAN SYLLABICS CARRIER SACANADIAN SYLLABICS CARRIER SHUCAN" +
	"ADIAN SYLLABICS CARRIER SHOCANADIAN SYLLABICS CARRIER SHECANADIAN SYLLAB" +
	"ICS CARRIER SHEECANADIAN SYLLABICS CARRIER SHICANADIAN SYLLABICS CARRIER" +
	" SHACANADIAN SYLLABICS CARRIER SHCANADIAN SYLLABICS CARRIER TSUCANADIAN " +
	"SYLLABICS CARRIER TSOCANADIAN SYLLABICS CARRIER TSECANADIAN SYLLABICS CA" +
	"RRIER TSEECANADIAN SYLLABICS CARRIER TSICANADIAN SYLLABICS CARRIER TSACA" +
	"NADIAN SYLLABICS CARRIER CHUCANADIAN SYLLABICS CARRIER CHOCANADIAN SYLLA" +
	"BICS CARRIER CHECANADIAN SYLLABICS CARRIER CHEECANADIAN SYLLABICS CARRIE" +
	"R CHICANADIAN SYLLABICS CARRIER CHACANADIAN SYLLABICS CARRIER TTSUCANADI" +
	"AN SYLLABICS CARRIER TTSOCANADIAN SYLLABICS CARRIER TTSECANADIAN SYLLABI" +
	"CS CARRIER TTSEECANADIAN SYLLABICS CARRIER TTSICANADIAN SYLLABICS CARRIE" +
	"R TTSACANADIAN SYLLABICS CHI SIGNCANADIAN SYLLABICS FULL STOPCANADIAN SY" +
	"LLABICS QAICANADIAN SYLLABICS NGAICANADIAN SYLLABICS NNGICANADIAN SYLLAB" +
	"ICS NNGIICANADIAN SYLLABICS NNGOCANADIAN SYLLABICS NNGOOCANADIAN SYLLABI" +
	"CS NNGACANADIAN SYLLABICS NNGAACANADIAN SYLLABICS WOODS-CREE THWEECANADI" +
	"AN SYLLABICS WOODS-CREE THWICANADIAN SYLLABICS WOODS-CREE THWIICANADIAN " +
	"SYLLABICS WOODS-CREE THWOCANADIAN SYLLABICS WOODS-CREE THWOOCANADIAN SYL" +
	"LABICS WOODS-CREE THWACANADIAN SYLLABICS WOODS-CREE THWAACANADIAN SYLLAB" +
	"ICS WOODS-CREE FINAL THCANADIAN SYLLABICS BLACKFOOT WOGHAM SPACE MARKOGH" +
	"AM LETTER BEITHOGHAM LETTER LUISOGHAM LETTER FEARNOGHAM LETTER SAILOGHAM" +
	" LETTER NIONOGHAM LETTER UATHOGHAM LETTER DAIROGHAM LETTER TINNEOGHAM LE" +
	"TTER COLLOGHAM LETTER CEIRTOGHAM LETTER MUINOGHAM LETTER GORTOGHAM LETTE" +
	"R NGEADALOGHAM LETTER STRAIFOGHAM LETTER RUISOGHAM LETTER AILMOGHAM LETT" +
	"ER ONNOGHAM LETTER UROGHAM LETTER EADHADHOGHAM LETTER IODHADHOGHAM LETTE" +
	"R EABHADHOGHAM LETTER OROGHAM LETTER UILLEANNOGHAM LETTER IFINOGHAM LETT" +
	"ER EAMHANCHOLLOGHAM LETTER PEITHOGHAM FEATHER MARKOGHAM REVERSED FEATHER" +
	" MARKRUNIC LETTER FEHU FEOH FE FRUNIC LETTER VRUNIC LETTER URUZ UR URUNI" +
	"C LETTER YRRUNIC LETTER YRUNIC LETTER WRUNIC LETTER THURISAZ THURS THORN" +
	"RUNIC LETTER ETHRUNIC LETTER ANSUZ ARUNIC LETTER OS ORUNIC LETTER AC ARU" +
	"NIC LETTER AESCRUNIC LETTER LONG-BRANCH-OSS ORUNIC LETTER SHORT-TWIG-OSS" +
	" ORUNIC LETTER ORUNIC LETTER OERUNIC LETTER ONRUNIC LETTER RAIDO RAD REI" +
	"D RRUNIC LETTER KAUNARUNIC LETTER CENRUNIC LETTER KAUN KRUNIC LETTER GRU" +
	"NIC LETTER ENGRUNIC LETTER GEBO GYFU GRUNIC LETTER GARRUNIC LETTER WUNJO" +
	" WYNN WRUNIC LETTER HAGLAZ HRUNIC LETTER HAEGL HRUNIC LETTER LONG-BRANCH" +
	"-HAGALL HRUNIC LETTER SHORT-TWIG-HAGALL HRUNIC LETTER NAUDIZ NYD NAUD NR" +
	"UNIC LETTER SHORT-TWIG-NAUD NRUNIC LETTER DOTTED-NRUNIC LETTER ISAZ IS I" +
	"SS IRUNIC LETTER ERUNIC LETTER JERAN JRUNIC LETTER GERRUNIC LETTER LONG-" +
	"BRANCH-AR AERUNIC LETTER SHORT-TWIG-AR ARUNIC LETTER IWAZ EOHRUNIC LETTE" +
	"R PERTHO PEORTH PRUNIC LETTER ALGIZ EOLHXRUNIC LETTER SOWILO SRUNIC LETT" +
	"ER SIGEL LONG-BRANCH-SOL SRUNIC LETTER SHORT-TWIG-SOL SRUNIC LETTER CRUN" +
	"IC LETTER ZRUNIC LETTER TIWAZ TIR TYR TRUNIC LETTER SHORT-TWIG-TYR TRUNI" +
	"C LETTER DRUNIC LETTER BERKANAN BEORC BJARKAN BRUNIC LETTER SHORT-TWIG-B" +
	"JARKAN BRUNIC LETTER DOTTED-PRUNIC LETTER OPEN-PRUNIC LETTER EHWAZ EH ER" +
	"UNIC LETTER MANNAZ MAN MRUNIC LETTER LONG-BRANCH-MADR MRUNIC LETTER SHOR" +
	"T-TWIG-MADR MRUNIC LETTER LAUKAZ LAGU LOGR LRUNIC LETTER DOTTED-LRUNIC L" +
	"ETTER INGWAZRUNIC LETTER INGRUNIC LETTER DAGAZ DAEG DRUNIC LETTER OTHALA" +
	"N ETHEL ORUNIC LETTER EARRUNIC LETTER IORRUNIC LETTER CWEORTHRUNIC LETTE" +
	"R CALCRUNIC LETTER CEALCRUNIC LETTER STANRUNIC LETTER LONG-BRANCH-YRRUNI" +
	"C LETTER SHORT-TWIG-YRRUNIC LETTER ICELANDIC-YRRUNIC LETTER QRUNIC LETTE" +
	"R XRUNIC SINGLE PUNCTUATIONRUNIC MULTIPLE PUNCTUATIONRUNIC CROSS PUNCTUA" +
	"TIONRUNIC ARLAUG SYMBOLRUNIC TVIMADUR SYMBOLRUNIC BELGTHOR SYMBOLRUNIC L" +
	"ETTER KRUNIC LETTER SHRUNIC LETTER OORUNIC LETTER FRANKS CASKET OSRUNIC " +
	"LETTER FRANKS CASKET ISRUNIC LETTER FRANKS CASKET EHRUNIC LETTER FRANKS " +
	"CASKET ACRUNIC LETTER FRANKS CASKET AESCTAGALOG LETTER ATAGALOG LETTER I" +
	"TAGALOG LETTER UTAGALOG LETTER KATAGALOG LETTER GATAGALOG LETTER NGATAGA" +
	"LOG LETTER TATAGALOG LETTER DATAGALOG LETTER NATAGALOG LETTER PATAGALOG ") + ("" +
	"LETTER BATAGALOG LETTER MATAGALOG LETTER YATAGALOG LETTER LATAGALOG LETT" +
	"ER WATAGALOG LETTER SATAGALOG LETTER HATAGALOG VOWEL SIGN ITAGALOG VOWEL" +
	" SIGN UTAGALOG SIGN VIRAMAHANUNOO LETTER AHANUNOO LETTER IHANUNOO LETTER" +
	" UHANUNOO LETTER KAHANUNOO LETTER GAHANUNOO LETTER NGAHANUNOO LETTER TAH" +
	"ANUNOO LETTER DAHANUNOO LETTER NAHANUNOO LETTER PAHANUNOO LETTER BAHANUN" +
	"OO LETTER MAHANUNOO LETTER YAHANUNOO LETTER RAHANUNOO LETTER LAHANUNOO L" +
	"ETTER WAHANUNOO LETTER SAHANUNOO LETTER HAHANUNOO VOWEL SIGN IHANUNOO VO" +
	"WEL SIGN UHANUNOO SIGN PAMUDPODPHILIPPINE SINGLE PUNCTUATIONPHILIPPINE D" +
	"OUBLE PUNCTUATIONBUHID LETTER ABUHID LETTER IBUHID LETTER UBUHID LETTER " +
	"KABUHID LETTER GABUHID LETTER NGABUHID LETTER TABUHID LETTER DABUHID LET" +
	"TER NABUHID LETTER PABUHID LETTER BABUHID LETTER MABUHID LETTER YABUHID " +
	"LETTER RABUHID LETTER LABUHID LETTER WABUHID LETTER SABUHID LETTER HABUH" +
	"ID VOWEL SIGN IBUHID VOWEL SIGN UTAGBANWA LETTER ATAGBANWA LETTER ITAGBA" +
	"NWA LETTER UTAGBANWA LETTER KATAGBANWA LETTER GATAGBANWA LETTER NGATAGBA" +
	"NWA LETTER TATAGBANWA LETTER DATAGBANWA LETTER NATAGBANWA LETTER PATAGBA" +
	"NWA LETTER BATAGBANWA LETTER MATAGBANWA LETTER YATAGBANWA LETTER LATAGBA" +
	"NWA LETTER WATAGBANWA LETTER SATAGBANWA VOWEL SIGN ITAGBANWA VOWEL SIGN " +
	"UKHMER LETTER KAKHMER LETTER KHAKHMER LETTER KOKHMER LETTER KHOKHMER LET" +
	"TER NGOKHMER LETTER CAKHMER LETTER CHAKHMER LETTER COKHMER LETTER CHOKHM" +
	"ER LETTER NYOKHMER LETTER DAKHMER LETTER TTHAKHMER LETTER DOKHMER LETTER" +
	" TTHOKHMER LETTER NNOKHMER LETTER TAKHMER LETTER THAKHMER LETTER TOKHMER" +
	" LETTER THOKHMER LETTER NOKHMER LETTER BAKHMER LETTER PHAKHMER LETTER PO" +
	"KHMER LETTER PHOKHMER LETTER MOKHMER LETTER YOKHMER LETTER ROKHMER LETTE" +
	"R LOKHMER LETTER VOKHMER LETTER SHAKHMER LETTER SSOKHMER LETTER SAKHMER " +
	"LETTER HAKHMER LETTER LAKHMER LETTER QAKHMER INDEPENDENT VOWEL QAQKHMER " +
	"INDEPENDENT VOWEL QAAKHMER INDEPENDENT VOWEL QIKHMER INDEPENDENT VOWEL Q" +
	"IIKHMER INDEPENDENT VOWEL QUKHMER INDEPENDENT VOWEL QUKKHMER INDEPENDENT" +
	" VOWEL QUUKHMER INDEPENDENT VOWEL QUUVKHMER INDEPENDENT VOWEL RYKHMER IN" +
	"DEPENDENT VOWEL RYYKHMER INDEPENDENT VOWEL LYKHMER INDEPENDENT VOWEL LYY" +
	"KHMER INDEPENDENT VOWEL QEKHMER INDEPENDENT VOWEL QAIKHMER INDEPENDENT V" +
	"OWEL QOO TYPE ONEKHMER INDEPENDENT VOWEL QOO TYPE TWOKHMER INDEPENDENT V" +
	"OWEL QAUKHMER VOWEL INHERENT AQKHMER VOWEL INHERENT AAKHMER VOWEL SIGN A" +
	"AKHMER VOWEL SIGN IKHMER VOWEL SIGN IIKHMER VOWEL SIGN YKHMER VOWEL SIGN" +
	" YYKHMER VOWEL SIGN UKHMER VOWEL SIGN UUKHMER VOWEL SIGN UAKHMER VOWEL S" +
	"IGN OEKHMER VOWEL SIGN YAKHMER VOWEL SIGN IEKHMER VOWEL SIGN EKHMER VOWE" +
	"L SIGN AEKHMER VOWEL SIGN AIKHMER VOWEL SIGN OOKHMER VOWEL SIGN AUKHMER " +
	"SIGN NIKAHITKHMER SIGN REAHMUKKHMER SIGN YUUKALEAPINTUKHMER SIGN MUUSIKA" +
	"TOANKHMER SIGN TRIISAPKHMER SIGN BANTOCKHMER SIGN ROBATKHMER SIGN TOANDA" +
	"KHIATKHMER SIGN KAKABATKHMER SIGN AHSDAKHMER SIGN SAMYOK SANNYAKHMER SIG" +
	"N VIRIAMKHMER SIGN COENGKHMER SIGN BATHAMASATKHMER SIGN KHANKHMER SIGN B" +
	"ARIYOOSANKHMER SIGN CAMNUC PII KUUHKHMER SIGN LEK TOOKHMER SIGN BEYYALKH" +
	"MER SIGN PHNAEK MUANKHMER SIGN KOOMUUTKHMER CURRENCY SYMBOL RIELKHMER SI" +
	"GN AVAKRAHASANYAKHMER SIGN ATTHACANKHMER DIGIT ZEROKHMER DIGIT ONEKHMER " +
	"DIGIT TWOKHMER DIGIT THREEKHMER DIGIT FOURKHMER DIGIT FIVEKHMER DIGIT SI" +
	"XKHMER DIGIT SEVENKHMER DIGIT EIGHTKHMER DIGIT NINEKHMER SYMBOL LEK ATTA" +
	"K SONKHMER SYMBOL LEK ATTAK MUOYKHMER SYMBOL LEK ATTAK PIIKHMER SYMBOL L" +
	"EK ATTAK BEIKHMER SYMBOL LEK ATTAK BUONKHMER SYMBOL LEK ATTAK PRAMKHMER " +
	"SYMBOL LEK ATTAK PRAM-MUOYKHMER SYMBOL LEK ATTAK PRAM-PIIKHMER SYMBOL LE" +
	"K ATTAK PRAM-BEIKHMER SYMBOL LEK ATTAK PRAM-BUONMONGOLIAN BIRGAMONGOLIAN" +
	" ELLIPSISMONGOLIAN COMMAMONGOLIAN FULL STOPMONGOLIAN COLONMONGOLIAN FOUR" +
	" DOTSMONGOLIAN TODO SOFT HYPHENMONGOLIAN SIBE SYLLABLE BOUNDARY MARKERMO" +
	"NGOLIAN MANCHU COMMAMONGOLIAN MANCHU FULL STOPMONGOLIAN NIRUGUMONGOLIAN " +
	"FREE VARIATION SELECTOR ONEMONGOLIAN FREE VARIATION SELECTOR TWOMONGOLIA" +
	"N FREE VARIATION SELECTOR THREEMONGOLIAN VOWEL SEPARATORMONGOLIAN DIGIT " +
	"ZEROMONGOLIAN DIGIT ONEMONGOLIAN DIGIT TWOMONGOLIAN DIGIT THREEMONGOLIAN" +
	" DIGIT FOURMONGOLIAN DIGIT FIVEMONGOLIAN DIGIT SIXMONGOLIAN DIGIT SEVENM" +
	"ONGOLIAN DIGIT EIGHTMONGOLIAN DIGIT NINEMONGOLIAN LETTER AMONGOLIAN LETT" +
	"ER EMONGOLIAN LETTER IMONGOLIAN LETTER OMONGOLIAN LETTER UMONGOLIAN LETT" +
	"ER OEMONGOLIAN LETTER UEMONGOLIAN LETTER EEMONGOLIAN LETTER NAMONGOLIAN " +
	"LETTER ANGMONGOLIAN LETTER BAMONGOLIAN LETTER PAMONGOLIAN LETTER QAMONGO" +
	"LIAN LETTER GAMONGOLIAN LETTER MAMONGOLIAN LETTER LAMONGOLIAN LETTER SAM" +
	"ONGOLIAN LETTER SHAMONGOLIAN LETTER TAMONGOLIAN LETTER DAMONGOLIAN LETTE" +
	"R CHAMONGOLIAN LETTER JAMONGOLIAN LETTER YAMONGOLIAN LETTER RAMONGOLIAN " +
	"LETTER WAMONGOLIAN LETTER FAMONGOLIAN LETTER KAMONGOLIAN LETTER KHAMONGO") + ("" +
	"LIAN LETTER TSAMONGOLIAN LETTER ZAMONGOLIAN LETTER HAAMONGOLIAN LETTER Z" +
	"RAMONGOLIAN LETTER LHAMONGOLIAN LETTER ZHIMONGOLIAN LETTER CHIMONGOLIAN " +
	"LETTER TODO LONG VOWEL SIGNMONGOLIAN LETTER TODO EMONGOLIAN LETTER TODO " +
	"IMONGOLIAN LETTER TODO OMONGOLIAN LETTER TODO UMONGOLIAN LETTER TODO OEM" +
	"ONGOLIAN LETTER TODO UEMONGOLIAN LETTER TODO ANGMONGOLIAN LETTER TODO BA" +
	"MONGOLIAN LETTER TODO PAMONGOLIAN LETTER TODO QAMONGOLIAN LETTER TODO GA" +
	"MONGOLIAN LETTER TODO MAMONGOLIAN LETTER TODO TAMONGOLIAN LETTER TODO DA" +
	"MONGOLIAN LETTER TODO CHAMONGOLIAN LETTER TODO JAMONGOLIAN LETTER TODO T" +
	"SAMONGOLIAN LETTER TODO YAMONGOLIAN LETTER TODO WAMONGOLIAN LETTER TODO " +
	"KAMONGOLIAN LETTER TODO GAAMONGOLIAN LETTER TODO HAAMONGOLIAN LETTER TOD" +
	"O JIAMONGOLIAN LETTER TODO NIAMONGOLIAN LETTER TODO DZAMONGOLIAN LETTER " +
	"SIBE EMONGOLIAN LETTER SIBE IMONGOLIAN LETTER SIBE IYMONGOLIAN LETTER SI" +
	"BE UEMONGOLIAN LETTER SIBE UMONGOLIAN LETTER SIBE ANGMONGOLIAN LETTER SI" +
	"BE KAMONGOLIAN LETTER SIBE GAMONGOLIAN LETTER SIBE HAMONGOLIAN LETTER SI" +
	"BE PAMONGOLIAN LETTER SIBE SHAMONGOLIAN LETTER SIBE TAMONGOLIAN LETTER S" +
	"IBE DAMONGOLIAN LETTER SIBE JAMONGOLIAN LETTER SIBE FAMONGOLIAN LETTER S" +
	"IBE GAAMONGOLIAN LETTER SIBE HAAMONGOLIAN LETTER SIBE TSAMONGOLIAN LETTE" +
	"R SIBE ZAMONGOLIAN LETTER SIBE RAAMONGOLIAN LETTER SIBE CHAMONGOLIAN LET" +
	"TER SIBE ZHAMONGOLIAN LETTER MANCHU IMONGOLIAN LETTER MANCHU KAMONGOLIAN" +
	" LETTER MANCHU RAMONGOLIAN LETTER MANCHU FAMONGOLIAN LETTER MANCHU ZHAMO" +
	"NGOLIAN LETTER ALI GALI ANUSVARA ONEMONGOLIAN LETTER ALI GALI VISARGA ON" +
	"EMONGOLIAN LETTER ALI GALI DAMARUMONGOLIAN LETTER ALI GALI UBADAMAMONGOL" +
	"IAN LETTER ALI GALI INVERTED UBADAMAMONGOLIAN LETTER ALI GALI BALUDAMONG" +
	"OLIAN LETTER ALI GALI THREE BALUDAMONGOLIAN LETTER ALI GALI AMONGOLIAN L" +
	"ETTER ALI GALI IMONGOLIAN LETTER ALI GALI KAMONGOLIAN LETTER ALI GALI NG" +
	"AMONGOLIAN LETTER ALI GALI CAMONGOLIAN LETTER ALI GALI TTAMONGOLIAN LETT" +
	"ER ALI GALI TTHAMONGOLIAN LETTER ALI GALI DDAMONGOLIAN LETTER ALI GALI N" +
	"NAMONGOLIAN LETTER ALI GALI TAMONGOLIAN LETTER ALI GALI DAMONGOLIAN LETT" +
	"ER ALI GALI PAMONGOLIAN LETTER ALI GALI PHAMONGOLIAN LETTER ALI GALI SSA" +
	"MONGOLIAN LETTER ALI GALI ZHAMONGOLIAN LETTER ALI GALI ZAMONGOLIAN LETTE" +
	"R ALI GALI AHMONGOLIAN LETTER TODO ALI GALI TAMONGOLIAN LETTER TODO ALI " +
	"GALI ZHAMONGOLIAN LETTER MANCHU ALI GALI GHAMONGOLIAN LETTER MANCHU ALI " +
	"GALI NGAMONGOLIAN LETTER MANCHU ALI GALI CAMONGOLIAN LETTER MANCHU ALI G" +
	"ALI JHAMONGOLIAN LETTER MANCHU ALI GALI TTAMONGOLIAN LETTER MANCHU ALI G" +
	"ALI DDHAMONGOLIAN LETTER MANCHU ALI GALI TAMONGOLIAN LETTER MANCHU ALI G" +
	"ALI DHAMONGOLIAN LETTER MANCHU ALI GALI SSAMONGOLIAN LETTER MANCHU ALI G" +
	"ALI CYAMONGOLIAN LETTER MANCHU ALI GALI ZHAMONGOLIAN LETTER MANCHU ALI G" +
	"ALI ZAMONGOLIAN LETTER ALI GALI HALF UMONGOLIAN LETTER ALI GALI HALF YAM" +
	"ONGOLIAN LETTER MANCHU ALI GALI BHAMONGOLIAN LETTER ALI GALI DAGALGAMONG" +
	"OLIAN LETTER MANCHU ALI GALI LHACANADIAN SYLLABICS OYCANADIAN SYLLABICS " +
	"AYCANADIAN SYLLABICS AAYCANADIAN SYLLABICS WAYCANADIAN SYLLABICS POYCANA" +
	"DIAN SYLLABICS PAYCANADIAN SYLLABICS PWOYCANADIAN SYLLABICS TAYCANADIAN " +
	"SYLLABICS KAYCANADIAN SYLLABICS KWAYCANADIAN SYLLABICS MAYCANADIAN SYLLA" +
	"BICS NOYCANADIAN SYLLABICS NAYCANADIAN SYLLABICS LAYCANADIAN SYLLABICS S" +
	"OYCANADIAN SYLLABICS SAYCANADIAN SYLLABICS SHOYCANADIAN SYLLABICS SHAYCA" +
	"NADIAN SYLLABICS SHWOYCANADIAN SYLLABICS YOYCANADIAN SYLLABICS YAYCANADI" +
	"AN SYLLABICS RAYCANADIAN SYLLABICS NWICANADIAN SYLLABICS OJIBWAY NWICANA" +
	"DIAN SYLLABICS NWIICANADIAN SYLLABICS OJIBWAY NWIICANADIAN SYLLABICS NWO" +
	"CANADIAN SYLLABICS OJIBWAY NWOCANADIAN SYLLABICS NWOOCANADIAN SYLLABICS " +
	"OJIBWAY NWOOCANADIAN SYLLABICS RWEECANADIAN SYLLABICS RWICANADIAN SYLLAB" +
	"ICS RWIICANADIAN SYLLABICS RWOCANADIAN SYLLABICS RWOOCANADIAN SYLLABICS " +
	"RWACANADIAN SYLLABICS OJIBWAY PCANADIAN SYLLABICS OJIBWAY TCANADIAN SYLL" +
	"ABICS OJIBWAY KCANADIAN SYLLABICS OJIBWAY CCANADIAN SYLLABICS OJIBWAY MC" +
	"ANADIAN SYLLABICS OJIBWAY NCANADIAN SYLLABICS OJIBWAY SCANADIAN SYLLABIC" +
	"S OJIBWAY SHCANADIAN SYLLABICS EASTERN WCANADIAN SYLLABICS WESTERN WCANA" +
	"DIAN SYLLABICS FINAL SMALL RINGCANADIAN SYLLABICS FINAL RAISED DOTCANADI" +
	"AN SYLLABICS R-CREE RWECANADIAN SYLLABICS WEST-CREE LOOCANADIAN SYLLABIC" +
	"S WEST-CREE LAACANADIAN SYLLABICS THWECANADIAN SYLLABICS THWACANADIAN SY" +
	"LLABICS TTHWECANADIAN SYLLABICS TTHOOCANADIAN SYLLABICS TTHAACANADIAN SY" +
	"LLABICS TLHWECANADIAN SYLLABICS TLHOOCANADIAN SYLLABICS SAYISI SHWECANAD" +
	"IAN SYLLABICS SAYISI SHOOCANADIAN SYLLABICS SAYISI HOOCANADIAN SYLLABICS" +
	" CARRIER GWUCANADIAN SYLLABICS CARRIER DENE GEECANADIAN SYLLABICS CARRIE" +
	"R GAACANADIAN SYLLABICS CARRIER GWACANADIAN SYLLABICS SAYISI JUUCANADIAN" +
	" SYLLABICS CARRIER JWACANADIAN SYLLABICS BEAVER DENE LCANADIAN SYLLABICS") + ("" +
	" BEAVER DENE RCANADIAN SYLLABICS CARRIER DENTAL SLIMBU VOWEL-CARRIER LET" +
	"TERLIMBU LETTER KALIMBU LETTER KHALIMBU LETTER GALIMBU LETTER GHALIMBU L" +
	"ETTER NGALIMBU LETTER CALIMBU LETTER CHALIMBU LETTER JALIMBU LETTER JHAL" +
	"IMBU LETTER YANLIMBU LETTER TALIMBU LETTER THALIMBU LETTER DALIMBU LETTE" +
	"R DHALIMBU LETTER NALIMBU LETTER PALIMBU LETTER PHALIMBU LETTER BALIMBU " +
	"LETTER BHALIMBU LETTER MALIMBU LETTER YALIMBU LETTER RALIMBU LETTER LALI" +
	"MBU LETTER WALIMBU LETTER SHALIMBU LETTER SSALIMBU LETTER SALIMBU LETTER" +
	" HALIMBU LETTER GYANLIMBU LETTER TRALIMBU VOWEL SIGN ALIMBU VOWEL SIGN I" +
	"LIMBU VOWEL SIGN ULIMBU VOWEL SIGN EELIMBU VOWEL SIGN AILIMBU VOWEL SIGN" +
	" OOLIMBU VOWEL SIGN AULIMBU VOWEL SIGN ELIMBU VOWEL SIGN OLIMBU SUBJOINE" +
	"D LETTER YALIMBU SUBJOINED LETTER RALIMBU SUBJOINED LETTER WALIMBU SMALL" +
	" LETTER KALIMBU SMALL LETTER NGALIMBU SMALL LETTER ANUSVARALIMBU SMALL L" +
	"ETTER TALIMBU SMALL LETTER NALIMBU SMALL LETTER PALIMBU SMALL LETTER MAL" +
	"IMBU SMALL LETTER RALIMBU SMALL LETTER LALIMBU SIGN MUKPHRENGLIMBU SIGN " +
	"KEMPHRENGLIMBU SIGN SA-ILIMBU SIGN LOOLIMBU EXCLAMATION MARKLIMBU QUESTI" +
	"ON MARKLIMBU DIGIT ZEROLIMBU DIGIT ONELIMBU DIGIT TWOLIMBU DIGIT THREELI" +
	"MBU DIGIT FOURLIMBU DIGIT FIVELIMBU DIGIT SIXLIMBU DIGIT SEVENLIMBU DIGI" +
	"T EIGHTLIMBU DIGIT NINETAI LE LETTER KATAI LE LETTER XATAI LE LETTER NGA" +
	"TAI LE LETTER TSATAI LE LETTER SATAI LE LETTER YATAI LE LETTER TATAI LE " +
	"LETTER THATAI LE LETTER LATAI LE LETTER PATAI LE LETTER PHATAI LE LETTER" +
	" MATAI LE LETTER FATAI LE LETTER VATAI LE LETTER HATAI LE LETTER QATAI L" +
	"E LETTER KHATAI LE LETTER TSHATAI LE LETTER NATAI LE LETTER ATAI LE LETT" +
	"ER ITAI LE LETTER EETAI LE LETTER EHTAI LE LETTER UTAI LE LETTER OOTAI L" +
	"E LETTER OTAI LE LETTER UETAI LE LETTER ETAI LE LETTER AUETAI LE LETTER " +
	"AITAI LE LETTER TONE-2TAI LE LETTER TONE-3TAI LE LETTER TONE-4TAI LE LET" +
	"TER TONE-5TAI LE LETTER TONE-6NEW TAI LUE LETTER HIGH QANEW TAI LUE LETT" +
	"ER LOW QANEW TAI LUE LETTER HIGH KANEW TAI LUE LETTER HIGH XANEW TAI LUE" +
	" LETTER HIGH NGANEW TAI LUE LETTER LOW KANEW TAI LUE LETTER LOW XANEW TA" +
	"I LUE LETTER LOW NGANEW TAI LUE LETTER HIGH TSANEW TAI LUE LETTER HIGH S" +
	"ANEW TAI LUE LETTER HIGH YANEW TAI LUE LETTER LOW TSANEW TAI LUE LETTER " +
	"LOW SANEW TAI LUE LETTER LOW YANEW TAI LUE LETTER HIGH TANEW TAI LUE LET" +
	"TER HIGH THANEW TAI LUE LETTER HIGH NANEW TAI LUE LETTER LOW TANEW TAI L" +
	"UE LETTER LOW THANEW TAI LUE LETTER LOW NANEW TAI LUE LETTER HIGH PANEW " +
	"TAI LUE LETTER HIGH PHANEW TAI LUE LETTER HIGH MANEW TAI LUE LETTER LOW " +
	"PANEW TAI LUE LETTER LOW PHANEW TAI LUE LETTER LOW MANEW TAI LUE LETTER " +
	"HIGH FANEW TAI LUE LETTER HIGH VANEW TAI LUE LETTER HIGH LANEW TAI LUE L" +
	"ETTER LOW FANEW TAI LUE LETTER LOW VANEW TAI LUE LETTER LOW LANEW TAI LU" +
	"E LETTER HIGH HANEW TAI LUE LETTER HIGH DANEW TAI LUE LETTER HIGH BANEW " +
	"TAI LUE LETTER LOW HANEW TAI LUE LETTER LOW DANEW TAI LUE LETTER LOW BAN" +
	"EW TAI LUE LETTER HIGH KVANEW TAI LUE LETTER HIGH XVANEW TAI LUE LETTER " +
	"LOW KVANEW TAI LUE LETTER LOW XVANEW TAI LUE LETTER HIGH SUANEW TAI LUE " +
	"LETTER LOW SUANEW TAI LUE VOWEL SIGN VOWEL SHORTENERNEW TAI LUE VOWEL SI" +
	"GN AANEW TAI LUE VOWEL SIGN IINEW TAI LUE VOWEL SIGN UNEW TAI LUE VOWEL " +
	"SIGN UUNEW TAI LUE VOWEL SIGN ENEW TAI LUE VOWEL SIGN AENEW TAI LUE VOWE" +
	"L SIGN ONEW TAI LUE VOWEL SIGN OANEW TAI LUE VOWEL SIGN UENEW TAI LUE VO" +
	"WEL SIGN AYNEW TAI LUE VOWEL SIGN AAYNEW TAI LUE VOWEL SIGN UYNEW TAI LU" +
	"E VOWEL SIGN OYNEW TAI LUE VOWEL SIGN OAYNEW TAI LUE VOWEL SIGN UEYNEW T" +
	"AI LUE VOWEL SIGN IYNEW TAI LUE LETTER FINAL VNEW TAI LUE LETTER FINAL N" +
	"GNEW TAI LUE LETTER FINAL NNEW TAI LUE LETTER FINAL MNEW TAI LUE LETTER " +
	"FINAL KNEW TAI LUE LETTER FINAL DNEW TAI LUE LETTER FINAL BNEW TAI LUE T" +
	"ONE MARK-1NEW TAI LUE TONE MARK-2NEW TAI LUE DIGIT ZERONEW TAI LUE DIGIT" +
	" ONENEW TAI LUE DIGIT TWONEW TAI LUE DIGIT THREENEW TAI LUE DIGIT FOURNE" +
	"W TAI LUE DIGIT FIVENEW TAI LUE DIGIT SIXNEW TAI LUE DIGIT SEVENNEW TAI " +
	"LUE DIGIT EIGHTNEW TAI LUE DIGIT NINENEW TAI LUE THAM DIGIT ONENEW TAI L" +
	"UE SIGN LAENEW TAI LUE SIGN LAEVKHMER SYMBOL PATHAMASATKHMER SYMBOL MUOY" +
	" KOETKHMER SYMBOL PII KOETKHMER SYMBOL BEI KOETKHMER SYMBOL BUON KOETKHM" +
	"ER SYMBOL PRAM KOETKHMER SYMBOL PRAM-MUOY KOETKHMER SYMBOL PRAM-PII KOET" +
	"KHMER SYMBOL PRAM-BEI KOETKHMER SYMBOL PRAM-BUON KOETKHMER SYMBOL DAP KO" +
	"ETKHMER SYMBOL DAP-MUOY KOETKHMER SYMBOL DAP-PII KOETKHMER SYMBOL DAP-BE" +
	"I KOETKHMER SYMBOL DAP-BUON KOETKHMER SYMBOL DAP-PRAM KOETKHMER SYMBOL T" +
	"UTEYASATKHMER SYMBOL MUOY ROCKHMER SYMBOL PII ROCKHMER SYMBOL BEI ROCKHM" +
	"ER SYMBOL BUON ROCKHMER SYMBOL PRAM ROCKHMER SYMBOL PRAM-MUOY ROCKHMER S" +
	"YMBOL PRAM-PII ROCKHMER SYMBOL PRAM-BEI ROCKHMER SYMBOL PRAM-BUON ROCKHM" +
	"ER SYMBOL DAP ROCKHMER SYMBOL DAP-MUOY ROCKHMER SYMBOL DAP-PII ROCKHMER ") + ("" +
	"SYMBOL DAP-BEI ROCKHMER SYMBOL DAP-BUON ROCKHMER SYMBOL DAP-PRAM ROCBUGI" +
	"NESE LETTER KABUGINESE LETTER GABUGINESE LETTER NGABUGINESE LETTER NGKAB" +
	"UGINESE LETTER PABUGINESE LETTER BABUGINESE LETTER MABUGINESE LETTER MPA" +
	"BUGINESE LETTER TABUGINESE LETTER DABUGINESE LETTER NABUGINESE LETTER NR" +
	"ABUGINESE LETTER CABUGINESE LETTER JABUGINESE LETTER NYABUGINESE LETTER " +
	"NYCABUGINESE LETTER YABUGINESE LETTER RABUGINESE LETTER LABUGINESE LETTE" +
	"R VABUGINESE LETTER SABUGINESE LETTER ABUGINESE LETTER HABUGINESE VOWEL " +
	"SIGN IBUGINESE VOWEL SIGN UBUGINESE VOWEL SIGN EBUGINESE VOWEL SIGN OBUG" +
	"INESE VOWEL SIGN AEBUGINESE PALLAWABUGINESE END OF SECTIONTAI THAM LETTE" +
	"R HIGH KATAI THAM LETTER HIGH KHATAI THAM LETTER HIGH KXATAI THAM LETTER" +
	" LOW KATAI THAM LETTER LOW KXATAI THAM LETTER LOW KHATAI THAM LETTER NGA" +
	"TAI THAM LETTER HIGH CATAI THAM LETTER HIGH CHATAI THAM LETTER LOW CATAI" +
	" THAM LETTER LOW SATAI THAM LETTER LOW CHATAI THAM LETTER NYATAI THAM LE" +
	"TTER RATATAI THAM LETTER HIGH RATHATAI THAM LETTER DATAI THAM LETTER LOW" +
	" RATHATAI THAM LETTER RANATAI THAM LETTER HIGH TATAI THAM LETTER HIGH TH" +
	"ATAI THAM LETTER LOW TATAI THAM LETTER LOW THATAI THAM LETTER NATAI THAM" +
	" LETTER BATAI THAM LETTER HIGH PATAI THAM LETTER HIGH PHATAI THAM LETTER" +
	" HIGH FATAI THAM LETTER LOW PATAI THAM LETTER LOW FATAI THAM LETTER LOW " +
	"PHATAI THAM LETTER MATAI THAM LETTER LOW YATAI THAM LETTER HIGH YATAI TH" +
	"AM LETTER RATAI THAM LETTER RUETAI THAM LETTER LATAI THAM LETTER LUETAI " +
	"THAM LETTER WATAI THAM LETTER HIGH SHATAI THAM LETTER HIGH SSATAI THAM L" +
	"ETTER HIGH SATAI THAM LETTER HIGH HATAI THAM LETTER LLATAI THAM LETTER A" +
	"TAI THAM LETTER LOW HATAI THAM LETTER ITAI THAM LETTER IITAI THAM LETTER" +
	" UTAI THAM LETTER UUTAI THAM LETTER EETAI THAM LETTER OOTAI THAM LETTER " +
	"LAETAI THAM LETTER GREAT SATAI THAM CONSONANT SIGN MEDIAL RATAI THAM CON" +
	"SONANT SIGN MEDIAL LATAI THAM CONSONANT SIGN LA TANG LAITAI THAM SIGN MA" +
	"I KANG LAITAI THAM CONSONANT SIGN FINAL NGATAI THAM CONSONANT SIGN LOW P" +
	"ATAI THAM CONSONANT SIGN HIGH RATHA OR LOW PATAI THAM CONSONANT SIGN MAT" +
	"AI THAM CONSONANT SIGN BATAI THAM CONSONANT SIGN SATAI THAM SIGN SAKOTTA" +
	"I THAM VOWEL SIGN ATAI THAM VOWEL SIGN MAI SATTAI THAM VOWEL SIGN AATAI " +
	"THAM VOWEL SIGN TALL AATAI THAM VOWEL SIGN ITAI THAM VOWEL SIGN IITAI TH" +
	"AM VOWEL SIGN UETAI THAM VOWEL SIGN UUETAI THAM VOWEL SIGN UTAI THAM VOW" +
	"EL SIGN UUTAI THAM VOWEL SIGN OTAI THAM VOWEL SIGN OA BELOWTAI THAM VOWE" +
	"L SIGN OYTAI THAM VOWEL SIGN ETAI THAM VOWEL SIGN AETAI THAM VOWEL SIGN " +
	"OOTAI THAM VOWEL SIGN AITAI THAM VOWEL SIGN THAM AITAI THAM VOWEL SIGN O" +
	"A ABOVETAI THAM SIGN MAI KANGTAI THAM SIGN TONE-1TAI THAM SIGN TONE-2TAI" +
	" THAM SIGN KHUEN TONE-3TAI THAM SIGN KHUEN TONE-4TAI THAM SIGN KHUEN TON" +
	"E-5TAI THAM SIGN RA HAAMTAI THAM SIGN MAI SAMTAI THAM SIGN KHUEN-LUE KAR" +
	"ANTAI THAM COMBINING CRYPTOGRAMMIC DOTTAI THAM HORA DIGIT ZEROTAI THAM H" +
	"ORA DIGIT ONETAI THAM HORA DIGIT TWOTAI THAM HORA DIGIT THREETAI THAM HO" +
	"RA DIGIT FOURTAI THAM HORA DIGIT FIVETAI THAM HORA DIGIT SIXTAI THAM HOR" +
	"A DIGIT SEVENTAI THAM HORA DIGIT EIGHTTAI THAM HORA DIGIT NINETAI THAM T" +
	"HAM DIGIT ZEROTAI THAM THAM DIGIT ONETAI THAM THAM DIGIT TWOTAI THAM THA" +
	"M DIGIT THREETAI THAM THAM DIGIT FOURTAI THAM THAM DIGIT FIVETAI THAM TH" +
	"AM DIGIT SIXTAI THAM THAM DIGIT SEVENTAI THAM THAM DIGIT EIGHTTAI THAM T" +
	"HAM DIGIT NINETAI THAM SIGN WIANGTAI THAM SIGN WIANGWAAKTAI THAM SIGN SA" +
	"WANTAI THAM SIGN KEOWTAI THAM SIGN HOYTAI THAM SIGN DOKMAITAI THAM SIGN " +
	"REVERSED ROTATED RANATAI THAM SIGN MAI YAMOKTAI THAM SIGN KAANTAI THAM S" +
	"IGN KAANKUUTAI THAM SIGN SATKAANTAI THAM SIGN SATKAANKUUTAI THAM SIGN HA" +
	"NGTAI THAM SIGN CAANGCOMBINING DOUBLED CIRCUMFLEX ACCENTCOMBINING DIAERE" +
	"SIS-RINGCOMBINING INFINITYCOMBINING DOWNWARDS ARROWCOMBINING TRIPLE DOTC" +
	"OMBINING X-X BELOWCOMBINING WIGGLY LINE BELOWCOMBINING OPEN MARK BELOWCO" +
	"MBINING DOUBLE OPEN MARK BELOWCOMBINING LIGHT CENTRALIZATION STROKE BELO" +
	"WCOMBINING STRONG CENTRALIZATION STROKE BELOWCOMBINING PARENTHESES ABOVE" +
	"COMBINING DOUBLE PARENTHESES ABOVECOMBINING PARENTHESES BELOWCOMBINING P" +
	"ARENTHESES OVERLAYBALINESE SIGN ULU RICEMBALINESE SIGN ULU CANDRABALINES" +
	"E SIGN CECEKBALINESE SIGN SURANGBALINESE SIGN BISAHBALINESE LETTER AKARA" +
	"BALINESE LETTER AKARA TEDUNGBALINESE LETTER IKARABALINESE LETTER IKARA T" +
	"EDUNGBALINESE LETTER UKARABALINESE LETTER UKARA TEDUNGBALINESE LETTER RA" +
	" REPABALINESE LETTER RA REPA TEDUNGBALINESE LETTER LA LENGABALINESE LETT" +
	"ER LA LENGA TEDUNGBALINESE LETTER EKARABALINESE LETTER AIKARABALINESE LE" +
	"TTER OKARABALINESE LETTER OKARA TEDUNGBALINESE LETTER KABALINESE LETTER " +
	"KA MAHAPRANABALINESE LETTER GABALINESE LETTER GA GORABALINESE LETTER NGA" +
	"BALINESE LETTER CABALINESE LETTER CA LACABALINESE LETTER JABALINESE LETT") + ("" +
	"ER JA JERABALINESE LETTER NYABALINESE LETTER TA LATIKBALINESE LETTER TA " +
	"MURDA MAHAPRANABALINESE LETTER DA MURDA ALPAPRANABALINESE LETTER DA MURD" +
	"A MAHAPRANABALINESE LETTER NA RAMBATBALINESE LETTER TABALINESE LETTER TA" +
	" TAWABALINESE LETTER DABALINESE LETTER DA MADUBALINESE LETTER NABALINESE" +
	" LETTER PABALINESE LETTER PA KAPALBALINESE LETTER BABALINESE LETTER BA K" +
	"EMBANGBALINESE LETTER MABALINESE LETTER YABALINESE LETTER RABALINESE LET" +
	"TER LABALINESE LETTER WABALINESE LETTER SA SAGABALINESE LETTER SA SAPABA" +
	"LINESE LETTER SABALINESE LETTER HABALINESE SIGN REREKANBALINESE VOWEL SI" +
	"GN TEDUNGBALINESE VOWEL SIGN ULUBALINESE VOWEL SIGN ULU SARIBALINESE VOW" +
	"EL SIGN SUKUBALINESE VOWEL SIGN SUKU ILUTBALINESE VOWEL SIGN RA REPABALI" +
	"NESE VOWEL SIGN RA REPA TEDUNGBALINESE VOWEL SIGN LA LENGABALINESE VOWEL" +
	" SIGN LA LENGA TEDUNGBALINESE VOWEL SIGN TALINGBALINESE VOWEL SIGN TALIN" +
	"G REPABALINESE VOWEL SIGN TALING TEDUNGBALINESE VOWEL SIGN TALING REPA T" +
	"EDUNGBALINESE VOWEL SIGN PEPETBALINESE VOWEL SIGN PEPET TEDUNGBALINESE A" +
	"DEG ADEGBALINESE LETTER KAF SASAKBALINESE LETTER KHOT SASAKBALINESE LETT" +
	"ER TZIR SASAKBALINESE LETTER EF SASAKBALINESE LETTER VE SASAKBALINESE LE" +
	"TTER ZAL SASAKBALINESE LETTER ASYURA SASAKBALINESE DIGIT ZEROBALINESE DI" +
	"GIT ONEBALINESE DIGIT TWOBALINESE DIGIT THREEBALINESE DIGIT FOURBALINESE" +
	" DIGIT FIVEBALINESE DIGIT SIXBALINESE DIGIT SEVENBALINESE DIGIT EIGHTBAL" +
	"INESE DIGIT NINEBALINESE PANTIBALINESE PAMADABALINESE WINDUBALINESE CARI" +
	"K PAMUNGKAHBALINESE CARIK SIKIBALINESE CARIK PARERENBALINESE PAMENENGBAL" +
	"INESE MUSICAL SYMBOL DONGBALINESE MUSICAL SYMBOL DENGBALINESE MUSICAL SY" +
	"MBOL DUNGBALINESE MUSICAL SYMBOL DANGBALINESE MUSICAL SYMBOL DANG SURANG" +
	"BALINESE MUSICAL SYMBOL DINGBALINESE MUSICAL SYMBOL DAENGBALINESE MUSICA" +
	"L SYMBOL DEUNGBALINESE MUSICAL SYMBOL DAINGBALINESE MUSICAL SYMBOL DANG " +
	"GEDEBALINESE MUSICAL SYMBOL COMBINING TEGEHBALINESE MUSICAL SYMBOL COMBI" +
	"NING ENDEPBALINESE MUSICAL SYMBOL COMBINING KEMPULBALINESE MUSICAL SYMBO" +
	"L COMBINING KEMPLIBALINESE MUSICAL SYMBOL COMBINING JEGOGANBALINESE MUSI" +
	"CAL SYMBOL COMBINING KEMPUL WITH JEGOGANBALINESE MUSICAL SYMBOL COMBININ" +
	"G KEMPLI WITH JEGOGANBALINESE MUSICAL SYMBOL COMBINING BENDEBALINESE MUS" +
	"ICAL SYMBOL COMBINING GONGBALINESE MUSICAL SYMBOL RIGHT-HAND OPEN DUGBAL" +
	"INESE MUSICAL SYMBOL RIGHT-HAND OPEN DAGBALINESE MUSICAL SYMBOL RIGHT-HA" +
	"ND CLOSED TUKBALINESE MUSICAL SYMBOL RIGHT-HAND CLOSED TAKBALINESE MUSIC" +
	"AL SYMBOL LEFT-HAND OPEN PANGBALINESE MUSICAL SYMBOL LEFT-HAND OPEN PUNG" +
	"BALINESE MUSICAL SYMBOL LEFT-HAND CLOSED PLAKBALINESE MUSICAL SYMBOL LEF" +
	"T-HAND CLOSED PLUKBALINESE MUSICAL SYMBOL LEFT-HAND OPEN PINGSUNDANESE S" +
	"IGN PANYECEKSUNDANESE SIGN PANGLAYARSUNDANESE SIGN PANGWISADSUNDANESE LE" +
	"TTER ASUNDANESE LETTER ISUNDANESE LETTER USUNDANESE LETTER AESUNDANESE L" +
	"ETTER OSUNDANESE LETTER ESUNDANESE LETTER EUSUNDANESE LETTER KASUNDANESE" +
	" LETTER QASUNDANESE LETTER GASUNDANESE LETTER NGASUNDANESE LETTER CASUND" +
	"ANESE LETTER JASUNDANESE LETTER ZASUNDANESE LETTER NYASUNDANESE LETTER T" +
	"ASUNDANESE LETTER DASUNDANESE LETTER NASUNDANESE LETTER PASUNDANESE LETT" +
	"ER FASUNDANESE LETTER VASUNDANESE LETTER BASUNDANESE LETTER MASUNDANESE " +
	"LETTER YASUNDANESE LETTER RASUNDANESE LETTER LASUNDANESE LETTER WASUNDAN" +
	"ESE LETTER SASUNDANESE LETTER XASUNDANESE LETTER HASUNDANESE CONSONANT S" +
	"IGN PAMINGKALSUNDANESE CONSONANT SIGN PANYAKRASUNDANESE CONSONANT SIGN P" +
	"ANYIKUSUNDANESE VOWEL SIGN PANGHULUSUNDANESE VOWEL SIGN PANYUKUSUNDANESE" +
	" VOWEL SIGN PANAELAENGSUNDANESE VOWEL SIGN PANOLONGSUNDANESE VOWEL SIGN " +
	"PAMEPETSUNDANESE VOWEL SIGN PANEULEUNGSUNDANESE SIGN PAMAAEHSUNDANESE SI" +
	"GN VIRAMASUNDANESE CONSONANT SIGN PASANGAN MASUNDANESE CONSONANT SIGN PA" +
	"SANGAN WASUNDANESE LETTER KHASUNDANESE LETTER SYASUNDANESE DIGIT ZEROSUN" +
	"DANESE DIGIT ONESUNDANESE DIGIT TWOSUNDANESE DIGIT THREESUNDANESE DIGIT " +
	"FOURSUNDANESE DIGIT FIVESUNDANESE DIGIT SIXSUNDANESE DIGIT SEVENSUNDANES" +
	"E DIGIT EIGHTSUNDANESE DIGIT NINESUNDANESE AVAGRAHASUNDANESE LETTER REUS" +
	"UNDANESE LETTER LEUSUNDANESE LETTER BHASUNDANESE LETTER FINAL KSUNDANESE" +
	" LETTER FINAL MBATAK LETTER ABATAK LETTER SIMALUNGUN ABATAK LETTER HABAT" +
	"AK LETTER SIMALUNGUN HABATAK LETTER MANDAILING HABATAK LETTER BABATAK LE" +
	"TTER KARO BABATAK LETTER PABATAK LETTER SIMALUNGUN PABATAK LETTER NABATA" +
	"K LETTER MANDAILING NABATAK LETTER WABATAK LETTER SIMALUNGUN WABATAK LET" +
	"TER PAKPAK WABATAK LETTER GABATAK LETTER SIMALUNGUN GABATAK LETTER JABAT" +
	"AK LETTER DABATAK LETTER RABATAK LETTER SIMALUNGUN RABATAK LETTER MABATA" +
	"K LETTER SIMALUNGUN MABATAK LETTER SOUTHERN TABATAK LETTER NORTHERN TABA" +
	"TAK LETTER SABATAK LETTER SIMALUNGUN SABATAK LETTER MANDAILING SABATAK L" +
	"ETTER YABATAK LETTER SIMALUNGUN YABATAK LETTER NGABATAK LETTER LABATAK L") + ("" +
	"ETTER SIMALUNGUN LABATAK LETTER NYABATAK LETTER CABATAK LETTER NDABATAK " +
	"LETTER MBABATAK LETTER IBATAK LETTER UBATAK SIGN TOMPIBATAK VOWEL SIGN E" +
	"BATAK VOWEL SIGN PAKPAK EBATAK VOWEL SIGN EEBATAK VOWEL SIGN IBATAK VOWE" +
	"L SIGN KARO IBATAK VOWEL SIGN OBATAK VOWEL SIGN KARO OBATAK VOWEL SIGN U" +
	"BATAK VOWEL SIGN U FOR SIMALUNGUN SABATAK CONSONANT SIGN NGBATAK CONSONA" +
	"NT SIGN HBATAK PANGOLATBATAK PANONGONANBATAK SYMBOL BINDU NA METEKBATAK " +
	"SYMBOL BINDU PINARBORASBATAK SYMBOL BINDU JUDULBATAK SYMBOL BINDU PANGOL" +
	"ATLEPCHA LETTER KALEPCHA LETTER KLALEPCHA LETTER KHALEPCHA LETTER GALEPC" +
	"HA LETTER GLALEPCHA LETTER NGALEPCHA LETTER CALEPCHA LETTER CHALEPCHA LE" +
	"TTER JALEPCHA LETTER NYALEPCHA LETTER TALEPCHA LETTER THALEPCHA LETTER D" +
	"ALEPCHA LETTER NALEPCHA LETTER PALEPCHA LETTER PLALEPCHA LETTER PHALEPCH" +
	"A LETTER FALEPCHA LETTER FLALEPCHA LETTER BALEPCHA LETTER BLALEPCHA LETT" +
	"ER MALEPCHA LETTER MLALEPCHA LETTER TSALEPCHA LETTER TSHALEPCHA LETTER D" +
	"ZALEPCHA LETTER YALEPCHA LETTER RALEPCHA LETTER LALEPCHA LETTER HALEPCHA" +
	" LETTER HLALEPCHA LETTER VALEPCHA LETTER SALEPCHA LETTER SHALEPCHA LETTE" +
	"R WALEPCHA LETTER ALEPCHA SUBJOINED LETTER YALEPCHA SUBJOINED LETTER RAL" +
	"EPCHA VOWEL SIGN AALEPCHA VOWEL SIGN ILEPCHA VOWEL SIGN OLEPCHA VOWEL SI" +
	"GN OOLEPCHA VOWEL SIGN ULEPCHA VOWEL SIGN UULEPCHA VOWEL SIGN ELEPCHA CO" +
	"NSONANT SIGN KLEPCHA CONSONANT SIGN MLEPCHA CONSONANT SIGN LLEPCHA CONSO" +
	"NANT SIGN NLEPCHA CONSONANT SIGN PLEPCHA CONSONANT SIGN RLEPCHA CONSONAN" +
	"T SIGN TLEPCHA CONSONANT SIGN NYIN-DOLEPCHA CONSONANT SIGN KANGLEPCHA SI" +
	"GN RANLEPCHA SIGN NUKTALEPCHA PUNCTUATION TA-ROLLEPCHA PUNCTUATION NYET " +
	"THYOOM TA-ROLLEPCHA PUNCTUATION CER-WALEPCHA PUNCTUATION TSHOOK CER-WALE" +
	"PCHA PUNCTUATION TSHOOKLEPCHA DIGIT ZEROLEPCHA DIGIT ONELEPCHA DIGIT TWO" +
	"LEPCHA DIGIT THREELEPCHA DIGIT FOURLEPCHA DIGIT FIVELEPCHA DIGIT SIXLEPC" +
	"HA DIGIT SEVENLEPCHA DIGIT EIGHTLEPCHA DIGIT NINELEPCHA LETTER TTALEPCHA" +
	" LETTER TTHALEPCHA LETTER DDAOL CHIKI DIGIT ZEROOL CHIKI DIGIT ONEOL CHI" +
	"KI DIGIT TWOOL CHIKI DIGIT THREEOL CHIKI DIGIT FOUROL CHIKI DIGIT FIVEOL" +
	" CHIKI DIGIT SIXOL CHIKI DIGIT SEVENOL CHIKI DIGIT EIGHTOL CHIKI DIGIT N" +
	"INEOL CHIKI LETTER LAOL CHIKI LETTER ATOL CHIKI LETTER AGOL CHIKI LETTER" +
	" ANGOL CHIKI LETTER ALOL CHIKI LETTER LAAOL CHIKI LETTER AAKOL CHIKI LET" +
	"TER AAJOL CHIKI LETTER AAMOL CHIKI LETTER AAWOL CHIKI LETTER LIOL CHIKI " +
	"LETTER ISOL CHIKI LETTER IHOL CHIKI LETTER INYOL CHIKI LETTER IROL CHIKI" +
	" LETTER LUOL CHIKI LETTER UCOL CHIKI LETTER UDOL CHIKI LETTER UNNOL CHIK" +
	"I LETTER UYOL CHIKI LETTER LEOL CHIKI LETTER EPOL CHIKI LETTER EDDOL CHI" +
	"KI LETTER ENOL CHIKI LETTER ERROL CHIKI LETTER LOOL CHIKI LETTER OTTOL C" +
	"HIKI LETTER OBOL CHIKI LETTER OVOL CHIKI LETTER OHOL CHIKI MU TTUDDAGOL " +
	"CHIKI GAAHLAA TTUDDAAGOL CHIKI MU-GAAHLAA TTUDDAAGOL CHIKI RELAAOL CHIKI" +
	" PHAARKAAOL CHIKI AHADOL CHIKI PUNCTUATION MUCAADOL CHIKI PUNCTUATION DO" +
	"UBLE MUCAADCYRILLIC SMALL LETTER ROUNDED VECYRILLIC SMALL LETTER LONG-LE" +
	"GGED DECYRILLIC SMALL LETTER NARROW OCYRILLIC SMALL LETTER WIDE ESCYRILL" +
	"IC SMALL LETTER TALL TECYRILLIC SMALL LETTER THREE-LEGGED TECYRILLIC SMA" +
	"LL LETTER TALL HARD SIGNCYRILLIC SMALL LETTER TALL YATCYRILLIC SMALL LET" +
	"TER UNBLENDED UKSUNDANESE PUNCTUATION BINDU SURYASUNDANESE PUNCTUATION B" +
	"INDU PANGLONGSUNDANESE PUNCTUATION BINDU PURNAMASUNDANESE PUNCTUATION BI" +
	"NDU CAKRASUNDANESE PUNCTUATION BINDU LEU SATANGASUNDANESE PUNCTUATION BI" +
	"NDU KA SATANGASUNDANESE PUNCTUATION BINDU DA SATANGASUNDANESE PUNCTUATIO" +
	"N BINDU BA SATANGAVEDIC TONE KARSHANAVEDIC TONE SHARAVEDIC TONE PRENKHAV" +
	"EDIC SIGN NIHSHVASAVEDIC SIGN YAJURVEDIC MIDLINE SVARITAVEDIC TONE YAJUR" +
	"VEDIC AGGRAVATED INDEPENDENT SVARITAVEDIC TONE YAJURVEDIC INDEPENDENT SV" +
	"ARITAVEDIC TONE YAJURVEDIC KATHAKA INDEPENDENT SVARITAVEDIC TONE CANDRA " +
	"BELOWVEDIC TONE YAJURVEDIC KATHAKA INDEPENDENT SVARITA SCHROEDERVEDIC TO" +
	"NE DOUBLE SVARITAVEDIC TONE TRIPLE SVARITAVEDIC TONE KATHAKA ANUDATTAVED" +
	"IC TONE DOT BELOWVEDIC TONE TWO DOTS BELOWVEDIC TONE THREE DOTS BELOWVED" +
	"IC TONE RIGVEDIC KASHMIRI INDEPENDENT SVARITAVEDIC TONE ATHARVAVEDIC IND" +
	"EPENDENT SVARITAVEDIC SIGN VISARGA SVARITAVEDIC SIGN VISARGA UDATTAVEDIC" +
	" SIGN REVERSED VISARGA UDATTAVEDIC SIGN VISARGA ANUDATTAVEDIC SIGN REVER" +
	"SED VISARGA ANUDATTAVEDIC SIGN VISARGA UDATTA WITH TAILVEDIC SIGN VISARG" +
	"A ANUDATTA WITH TAILVEDIC SIGN ANUSVARA ANTARGOMUKHAVEDIC SIGN ANUSVARA " +
	"BAHIRGOMUKHAVEDIC SIGN ANUSVARA VAMAGOMUKHAVEDIC SIGN ANUSVARA VAMAGOMUK" +
	"HA WITH TAILVEDIC SIGN TIRYAKVEDIC SIGN HEXIFORM LONG ANUSVARAVEDIC SIGN" +
	" LONG ANUSVARAVEDIC SIGN RTHANG LONG ANUSVARAVEDIC SIGN ANUSVARA UBHAYAT" +
	"O MUKHAVEDIC SIGN ARDHAVISARGAVEDIC SIGN ROTATED ARDHAVISARGAVEDIC TONE " +
	"CANDRA ABOVEVEDIC SIGN JIHVAMULIYAVEDIC SIGN UPADHMANIYAVEDIC TONE RING ") + ("" +
	"ABOVEVEDIC TONE DOUBLE RING ABOVELATIN LETTER SMALL CAPITAL ALATIN LETTE" +
	"R SMALL CAPITAL AELATIN SMALL LETTER TURNED AELATIN LETTER SMALL CAPITAL" +
	" BARRED BLATIN LETTER SMALL CAPITAL CLATIN LETTER SMALL CAPITAL DLATIN L" +
	"ETTER SMALL CAPITAL ETHLATIN LETTER SMALL CAPITAL ELATIN SMALL LETTER TU" +
	"RNED OPEN ELATIN SMALL LETTER TURNED ILATIN LETTER SMALL CAPITAL JLATIN " +
	"LETTER SMALL CAPITAL KLATIN LETTER SMALL CAPITAL L WITH STROKELATIN LETT" +
	"ER SMALL CAPITAL MLATIN LETTER SMALL CAPITAL REVERSED NLATIN LETTER SMAL" +
	"L CAPITAL OLATIN LETTER SMALL CAPITAL OPEN OLATIN SMALL LETTER SIDEWAYS " +
	"OLATIN SMALL LETTER SIDEWAYS OPEN OLATIN SMALL LETTER SIDEWAYS O WITH ST" +
	"ROKELATIN SMALL LETTER TURNED OELATIN LETTER SMALL CAPITAL OULATIN SMALL" +
	" LETTER TOP HALF OLATIN SMALL LETTER BOTTOM HALF OLATIN LETTER SMALL CAP" +
	"ITAL PLATIN LETTER SMALL CAPITAL REVERSED RLATIN LETTER SMALL CAPITAL TU" +
	"RNED RLATIN LETTER SMALL CAPITAL TLATIN LETTER SMALL CAPITAL ULATIN SMAL" +
	"L LETTER SIDEWAYS ULATIN SMALL LETTER SIDEWAYS DIAERESIZED ULATIN SMALL " +
	"LETTER SIDEWAYS TURNED MLATIN LETTER SMALL CAPITAL VLATIN LETTER SMALL C" +
	"APITAL WLATIN LETTER SMALL CAPITAL ZLATIN LETTER SMALL CAPITAL EZHLATIN " +
	"LETTER VOICED LARYNGEAL SPIRANTLATIN LETTER AINGREEK LETTER SMALL CAPITA" +
	"L GAMMAGREEK LETTER SMALL CAPITAL LAMDAGREEK LETTER SMALL CAPITAL PIGREE" +
	"K LETTER SMALL CAPITAL RHOGREEK LETTER SMALL CAPITAL PSICYRILLIC LETTER " +
	"SMALL CAPITAL ELMODIFIER LETTER CAPITAL AMODIFIER LETTER CAPITAL AEMODIF" +
	"IER LETTER CAPITAL BMODIFIER LETTER CAPITAL BARRED BMODIFIER LETTER CAPI" +
	"TAL DMODIFIER LETTER CAPITAL EMODIFIER LETTER CAPITAL REVERSED EMODIFIER" +
	" LETTER CAPITAL GMODIFIER LETTER CAPITAL HMODIFIER LETTER CAPITAL IMODIF" +
	"IER LETTER CAPITAL JMODIFIER LETTER CAPITAL KMODIFIER LETTER CAPITAL LMO" +
	"DIFIER LETTER CAPITAL MMODIFIER LETTER CAPITAL NMODIFIER LETTER CAPITAL " +
	"REVERSED NMODIFIER LETTER CAPITAL OMODIFIER LETTER CAPITAL OUMODIFIER LE" +
	"TTER CAPITAL PMODIFIER LETTER CAPITAL RMODIFIER LETTER CAPITAL TMODIFIER" +
	" LETTER CAPITAL UMODIFIER LETTER CAPITAL WMODIFIER LETTER SMALL AMODIFIE" +
	"R LETTER SMALL TURNED AMODIFIER LETTER SMALL ALPHAMODIFIER LETTER SMALL " +
	"TURNED AEMODIFIER LETTER SMALL BMODIFIER LETTER SMALL DMODIFIER LETTER S" +
	"MALL EMODIFIER LETTER SMALL SCHWAMODIFIER LETTER SMALL OPEN EMODIFIER LE" +
	"TTER SMALL TURNED OPEN EMODIFIER LETTER SMALL GMODIFIER LETTER SMALL TUR" +
	"NED IMODIFIER LETTER SMALL KMODIFIER LETTER SMALL MMODIFIER LETTER SMALL" +
	" ENGMODIFIER LETTER SMALL OMODIFIER LETTER SMALL OPEN OMODIFIER LETTER S" +
	"MALL TOP HALF OMODIFIER LETTER SMALL BOTTOM HALF OMODIFIER LETTER SMALL " +
	"PMODIFIER LETTER SMALL TMODIFIER LETTER SMALL UMODIFIER LETTER SMALL SID" +
	"EWAYS UMODIFIER LETTER SMALL TURNED MMODIFIER LETTER SMALL VMODIFIER LET" +
	"TER SMALL AINMODIFIER LETTER SMALL BETAMODIFIER LETTER SMALL GREEK GAMMA" +
	"MODIFIER LETTER SMALL DELTAMODIFIER LETTER SMALL GREEK PHIMODIFIER LETTE" +
	"R SMALL CHILATIN SUBSCRIPT SMALL LETTER ILATIN SUBSCRIPT SMALL LETTER RL" +
	"ATIN SUBSCRIPT SMALL LETTER ULATIN SUBSCRIPT SMALL LETTER VGREEK SUBSCRI" +
	"PT SMALL LETTER BETAGREEK SUBSCRIPT SMALL LETTER GAMMAGREEK SUBSCRIPT SM" +
	"ALL LETTER RHOGREEK SUBSCRIPT SMALL LETTER PHIGREEK SUBSCRIPT SMALL LETT" +
	"ER CHILATIN SMALL LETTER UELATIN SMALL LETTER B WITH MIDDLE TILDELATIN S" +
	"MALL LETTER D WITH MIDDLE TILDELATIN SMALL LETTER F WITH MIDDLE TILDELAT" +
	"IN SMALL LETTER M WITH MIDDLE TILDELATIN SMALL LETTER N WITH MIDDLE TILD" +
	"ELATIN SMALL LETTER P WITH MIDDLE TILDELATIN SMALL LETTER R WITH MIDDLE " +
	"TILDELATIN SMALL LETTER R WITH FISHHOOK AND MIDDLE TILDELATIN SMALL LETT" +
	"ER S WITH MIDDLE TILDELATIN SMALL LETTER T WITH MIDDLE TILDELATIN SMALL " +
	"LETTER Z WITH MIDDLE TILDELATIN SMALL LETTER TURNED GMODIFIER LETTER CYR" +
	"ILLIC ENLATIN SMALL LETTER INSULAR GLATIN SMALL LETTER TH WITH STRIKETHR" +
	"OUGHLATIN SMALL CAPITAL LETTER I WITH STROKELATIN SMALL LETTER IOTA WITH" +
	" STROKELATIN SMALL LETTER P WITH STROKELATIN SMALL CAPITAL LETTER U WITH" +
	" STROKELATIN SMALL LETTER UPSILON WITH STROKELATIN SMALL LETTER B WITH P" +
	"ALATAL HOOKLATIN SMALL LETTER D WITH PALATAL HOOKLATIN SMALL LETTER F WI" +
	"TH PALATAL HOOKLATIN SMALL LETTER G WITH PALATAL HOOKLATIN SMALL LETTER " +
	"K WITH PALATAL HOOKLATIN SMALL LETTER L WITH PALATAL HOOKLATIN SMALL LET" +
	"TER M WITH PALATAL HOOKLATIN SMALL LETTER N WITH PALATAL HOOKLATIN SMALL" +
	" LETTER P WITH PALATAL HOOKLATIN SMALL LETTER R WITH PALATAL HOOKLATIN S" +
	"MALL LETTER S WITH PALATAL HOOKLATIN SMALL LETTER ESH WITH PALATAL HOOKL" +
	"ATIN SMALL LETTER V WITH PALATAL HOOKLATIN SMALL LETTER X WITH PALATAL H" +
	"OOKLATIN SMALL LETTER Z WITH PALATAL HOOKLATIN SMALL LETTER A WITH RETRO" +
	"FLEX HOOKLATIN SMALL LETTER ALPHA WITH RETROFLEX HOOKLATIN SMALL LETTER " +
	"D WITH HOOK AND TAILLATIN SMALL LETTER E WITH RETROFLEX HOOKLATIN SMALL ") + ("" +
	"LETTER OPEN E WITH RETROFLEX HOOKLATIN SMALL LETTER REVERSED OPEN E WITH" +
	" RETROFLEX HOOKLATIN SMALL LETTER SCHWA WITH RETROFLEX HOOKLATIN SMALL L" +
	"ETTER I WITH RETROFLEX HOOKLATIN SMALL LETTER OPEN O WITH RETROFLEX HOOK" +
	"LATIN SMALL LETTER ESH WITH RETROFLEX HOOKLATIN SMALL LETTER U WITH RETR" +
	"OFLEX HOOKLATIN SMALL LETTER EZH WITH RETROFLEX HOOKMODIFIER LETTER SMAL" +
	"L TURNED ALPHAMODIFIER LETTER SMALL CMODIFIER LETTER SMALL C WITH CURLMO" +
	"DIFIER LETTER SMALL ETHMODIFIER LETTER SMALL REVERSED OPEN EMODIFIER LET" +
	"TER SMALL FMODIFIER LETTER SMALL DOTLESS J WITH STROKEMODIFIER LETTER SM" +
	"ALL SCRIPT GMODIFIER LETTER SMALL TURNED HMODIFIER LETTER SMALL I WITH S" +
	"TROKEMODIFIER LETTER SMALL IOTAMODIFIER LETTER SMALL CAPITAL IMODIFIER L" +
	"ETTER SMALL CAPITAL I WITH STROKEMODIFIER LETTER SMALL J WITH CROSSED-TA" +
	"ILMODIFIER LETTER SMALL L WITH RETROFLEX HOOKMODIFIER LETTER SMALL L WIT" +
	"H PALATAL HOOKMODIFIER LETTER SMALL CAPITAL LMODIFIER LETTER SMALL M WIT" +
	"H HOOKMODIFIER LETTER SMALL TURNED M WITH LONG LEGMODIFIER LETTER SMALL " +
	"N WITH LEFT HOOKMODIFIER LETTER SMALL N WITH RETROFLEX HOOKMODIFIER LETT" +
	"ER SMALL CAPITAL NMODIFIER LETTER SMALL BARRED OMODIFIER LETTER SMALL PH" +
	"IMODIFIER LETTER SMALL S WITH HOOKMODIFIER LETTER SMALL ESHMODIFIER LETT" +
	"ER SMALL T WITH PALATAL HOOKMODIFIER LETTER SMALL U BARMODIFIER LETTER S" +
	"MALL UPSILONMODIFIER LETTER SMALL CAPITAL UMODIFIER LETTER SMALL V WITH " +
	"HOOKMODIFIER LETTER SMALL TURNED VMODIFIER LETTER SMALL ZMODIFIER LETTER" +
	" SMALL Z WITH RETROFLEX HOOKMODIFIER LETTER SMALL Z WITH CURLMODIFIER LE" +
	"TTER SMALL EZHMODIFIER LETTER SMALL THETACOMBINING DOTTED GRAVE ACCENTCO" +
	"MBINING DOTTED ACUTE ACCENTCOMBINING SNAKE BELOWCOMBINING SUSPENSION MAR" +
	"KCOMBINING MACRON-ACUTECOMBINING GRAVE-MACRONCOMBINING MACRON-GRAVECOMBI" +
	"NING ACUTE-MACRONCOMBINING GRAVE-ACUTE-GRAVECOMBINING ACUTE-GRAVE-ACUTEC" +
	"OMBINING LATIN SMALL LETTER R BELOWCOMBINING BREVE-MACRONCOMBINING MACRO" +
	"N-BREVECOMBINING DOUBLE CIRCUMFLEX ABOVECOMBINING OGONEK ABOVECOMBINING " +
	"ZIGZAG BELOWCOMBINING IS BELOWCOMBINING UR ABOVECOMBINING US ABOVECOMBIN" +
	"ING LATIN SMALL LETTER FLATTENED OPEN A ABOVECOMBINING LATIN SMALL LETTE" +
	"R AECOMBINING LATIN SMALL LETTER AOCOMBINING LATIN SMALL LETTER AVCOMBIN" +
	"ING LATIN SMALL LETTER C CEDILLACOMBINING LATIN SMALL LETTER INSULAR DCO" +
	"MBINING LATIN SMALL LETTER ETHCOMBINING LATIN SMALL LETTER GCOMBINING LA" +
	"TIN LETTER SMALL CAPITAL GCOMBINING LATIN SMALL LETTER KCOMBINING LATIN " +
	"SMALL LETTER LCOMBINING LATIN LETTER SMALL CAPITAL LCOMBINING LATIN LETT" +
	"ER SMALL CAPITAL MCOMBINING LATIN SMALL LETTER NCOMBINING LATIN LETTER S" +
	"MALL CAPITAL NCOMBINING LATIN LETTER SMALL CAPITAL RCOMBINING LATIN SMAL" +
	"L LETTER R ROTUNDACOMBINING LATIN SMALL LETTER SCOMBINING LATIN SMALL LE" +
	"TTER LONG SCOMBINING LATIN SMALL LETTER ZCOMBINING LATIN SMALL LETTER AL" +
	"PHACOMBINING LATIN SMALL LETTER BCOMBINING LATIN SMALL LETTER BETACOMBIN" +
	"ING LATIN SMALL LETTER SCHWACOMBINING LATIN SMALL LETTER FCOMBINING LATI" +
	"N SMALL LETTER L WITH DOUBLE MIDDLE TILDECOMBINING LATIN SMALL LETTER O " +
	"WITH LIGHT CENTRALIZATION STROKECOMBINING LATIN SMALL LETTER PCOMBINING " +
	"LATIN SMALL LETTER ESHCOMBINING LATIN SMALL LETTER U WITH LIGHT CENTRALI" +
	"ZATION STROKECOMBINING LATIN SMALL LETTER WCOMBINING LATIN SMALL LETTER " +
	"A WITH DIAERESISCOMBINING LATIN SMALL LETTER O WITH DIAERESISCOMBINING L" +
	"ATIN SMALL LETTER U WITH DIAERESISCOMBINING UP TACK ABOVECOMBINING DELET" +
	"ION MARKCOMBINING DOUBLE INVERTED BREVE BELOWCOMBINING ALMOST EQUAL TO B" +
	"ELOWCOMBINING LEFT ARROWHEAD ABOVECOMBINING RIGHT ARROWHEAD AND DOWN ARR" +
	"OWHEAD BELOWLATIN CAPITAL LETTER A WITH RING BELOWLATIN SMALL LETTER A W" +
	"ITH RING BELOWLATIN CAPITAL LETTER B WITH DOT ABOVELATIN SMALL LETTER B " +
	"WITH DOT ABOVELATIN CAPITAL LETTER B WITH DOT BELOWLATIN SMALL LETTER B " +
	"WITH DOT BELOWLATIN CAPITAL LETTER B WITH LINE BELOWLATIN SMALL LETTER B" +
	" WITH LINE BELOWLATIN CAPITAL LETTER C WITH CEDILLA AND ACUTELATIN SMALL" +
	" LETTER C WITH CEDILLA AND ACUTELATIN CAPITAL LETTER D WITH DOT ABOVELAT" +
	"IN SMALL LETTER D WITH DOT ABOVELATIN CAPITAL LETTER D WITH DOT BELOWLAT" +
	"IN SMALL LETTER D WITH DOT BELOWLATIN CAPITAL LETTER D WITH LINE BELOWLA" +
	"TIN SMALL LETTER D WITH LINE BELOWLATIN CAPITAL LETTER D WITH CEDILLALAT" +
	"IN SMALL LETTER D WITH CEDILLALATIN CAPITAL LETTER D WITH CIRCUMFLEX BEL" +
	"OWLATIN SMALL LETTER D WITH CIRCUMFLEX BELOWLATIN CAPITAL LETTER E WITH " +
	"MACRON AND GRAVELATIN SMALL LETTER E WITH MACRON AND GRAVELATIN CAPITAL " +
	"LETTER E WITH MACRON AND ACUTELATIN SMALL LETTER E WITH MACRON AND ACUTE" +
	"LATIN CAPITAL LETTER E WITH CIRCUMFLEX BELOWLATIN SMALL LETTER E WITH CI" +
	"RCUMFLEX BELOWLATIN CAPITAL LETTER E WITH TILDE BELOWLATIN SMALL LETTER " +
	"E WITH TILDE BELOWLATIN CAPITAL LETTER E WITH CEDILLA AND BREVELATIN SMA") + ("" +
	"LL LETTER E WITH CEDILLA AND BREVELATIN CAPITAL LETTER F WITH DOT ABOVEL" +
	"ATIN SMALL LETTER F WITH DOT ABOVELATIN CAPITAL LETTER G WITH MACRONLATI" +
	"N SMALL LETTER G WITH MACRONLATIN CAPITAL LETTER H WITH DOT ABOVELATIN S" +
	"MALL LETTER H WITH DOT ABOVELATIN CAPITAL LETTER H WITH DOT BELOWLATIN S" +
	"MALL LETTER H WITH DOT BELOWLATIN CAPITAL LETTER H WITH DIAERESISLATIN S" +
	"MALL LETTER H WITH DIAERESISLATIN CAPITAL LETTER H WITH CEDILLALATIN SMA" +
	"LL LETTER H WITH CEDILLALATIN CAPITAL LETTER H WITH BREVE BELOWLATIN SMA" +
	"LL LETTER H WITH BREVE BELOWLATIN CAPITAL LETTER I WITH TILDE BELOWLATIN" +
	" SMALL LETTER I WITH TILDE BELOWLATIN CAPITAL LETTER I WITH DIAERESIS AN" +
	"D ACUTELATIN SMALL LETTER I WITH DIAERESIS AND ACUTELATIN CAPITAL LETTER" +
	" K WITH ACUTELATIN SMALL LETTER K WITH ACUTELATIN CAPITAL LETTER K WITH " +
	"DOT BELOWLATIN SMALL LETTER K WITH DOT BELOWLATIN CAPITAL LETTER K WITH " +
	"LINE BELOWLATIN SMALL LETTER K WITH LINE BELOWLATIN CAPITAL LETTER L WIT" +
	"H DOT BELOWLATIN SMALL LETTER L WITH DOT BELOWLATIN CAPITAL LETTER L WIT" +
	"H DOT BELOW AND MACRONLATIN SMALL LETTER L WITH DOT BELOW AND MACRONLATI" +
	"N CAPITAL LETTER L WITH LINE BELOWLATIN SMALL LETTER L WITH LINE BELOWLA" +
	"TIN CAPITAL LETTER L WITH CIRCUMFLEX BELOWLATIN SMALL LETTER L WITH CIRC" +
	"UMFLEX BELOWLATIN CAPITAL LETTER M WITH ACUTELATIN SMALL LETTER M WITH A" +
	"CUTELATIN CAPITAL LETTER M WITH DOT ABOVELATIN SMALL LETTER M WITH DOT A" +
	"BOVELATIN CAPITAL LETTER M WITH DOT BELOWLATIN SMALL LETTER M WITH DOT B" +
	"ELOWLATIN CAPITAL LETTER N WITH DOT ABOVELATIN SMALL LETTER N WITH DOT A" +
	"BOVELATIN CAPITAL LETTER N WITH DOT BELOWLATIN SMALL LETTER N WITH DOT B" +
	"ELOWLATIN CAPITAL LETTER N WITH LINE BELOWLATIN SMALL LETTER N WITH LINE" +
	" BELOWLATIN CAPITAL LETTER N WITH CIRCUMFLEX BELOWLATIN SMALL LETTER N W" +
	"ITH CIRCUMFLEX BELOWLATIN CAPITAL LETTER O WITH TILDE AND ACUTELATIN SMA" +
	"LL LETTER O WITH TILDE AND ACUTELATIN CAPITAL LETTER O WITH TILDE AND DI" +
	"AERESISLATIN SMALL LETTER O WITH TILDE AND DIAERESISLATIN CAPITAL LETTER" +
	" O WITH MACRON AND GRAVELATIN SMALL LETTER O WITH MACRON AND GRAVELATIN " +
	"CAPITAL LETTER O WITH MACRON AND ACUTELATIN SMALL LETTER O WITH MACRON A" +
	"ND ACUTELATIN CAPITAL LETTER P WITH ACUTELATIN SMALL LETTER P WITH ACUTE" +
	"LATIN CAPITAL LETTER P WITH DOT ABOVELATIN SMALL LETTER P WITH DOT ABOVE" +
	"LATIN CAPITAL LETTER R WITH DOT ABOVELATIN SMALL LETTER R WITH DOT ABOVE" +
	"LATIN CAPITAL LETTER R WITH DOT BELOWLATIN SMALL LETTER R WITH DOT BELOW" +
	"LATIN CAPITAL LETTER R WITH DOT BELOW AND MACRONLATIN SMALL LETTER R WIT" +
	"H DOT BELOW AND MACRONLATIN CAPITAL LETTER R WITH LINE BELOWLATIN SMALL " +
	"LETTER R WITH LINE BELOWLATIN CAPITAL LETTER S WITH DOT ABOVELATIN SMALL" +
	" LETTER S WITH DOT ABOVELATIN CAPITAL LETTER S WITH DOT BELOWLATIN SMALL" +
	" LETTER S WITH DOT BELOWLATIN CAPITAL LETTER S WITH ACUTE AND DOT ABOVEL" +
	"ATIN SMALL LETTER S WITH ACUTE AND DOT ABOVELATIN CAPITAL LETTER S WITH " +
	"CARON AND DOT ABOVELATIN SMALL LETTER S WITH CARON AND DOT ABOVELATIN CA" +
	"PITAL LETTER S WITH DOT BELOW AND DOT ABOVELATIN SMALL LETTER S WITH DOT" +
	" BELOW AND DOT ABOVELATIN CAPITAL LETTER T WITH DOT ABOVELATIN SMALL LET" +
	"TER T WITH DOT ABOVELATIN CAPITAL LETTER T WITH DOT BELOWLATIN SMALL LET" +
	"TER T WITH DOT BELOWLATIN CAPITAL LETTER T WITH LINE BELOWLATIN SMALL LE" +
	"TTER T WITH LINE BELOWLATIN CAPITAL LETTER T WITH CIRCUMFLEX BELOWLATIN " +
	"SMALL LETTER T WITH CIRCUMFLEX BELOWLATIN CAPITAL LETTER U WITH DIAERESI" +
	"S BELOWLATIN SMALL LETTER U WITH DIAERESIS BELOWLATIN CAPITAL LETTER U W" +
	"ITH TILDE BELOWLATIN SMALL LETTER U WITH TILDE BELOWLATIN CAPITAL LETTER" +
	" U WITH CIRCUMFLEX BELOWLATIN SMALL LETTER U WITH CIRCUMFLEX BELOWLATIN " +
	"CAPITAL LETTER U WITH TILDE AND ACUTELATIN SMALL LETTER U WITH TILDE AND" +
	" ACUTELATIN CAPITAL LETTER U WITH MACRON AND DIAERESISLATIN SMALL LETTER" +
	" U WITH MACRON AND DIAERESISLATIN CAPITAL LETTER V WITH TILDELATIN SMALL" +
	" LETTER V WITH TILDELATIN CAPITAL LETTER V WITH DOT BELOWLATIN SMALL LET" +
	"TER V WITH DOT BELOWLATIN CAPITAL LETTER W WITH GRAVELATIN SMALL LETTER " +
	"W WITH GRAVELATIN CAPITAL LETTER W WITH ACUTELATIN SMALL LETTER W WITH A" +
	"CUTELATIN CAPITAL LETTER W WITH DIAERESISLATIN SMALL LETTER W WITH DIAER" +
	"ESISLATIN CAPITAL LETTER W WITH DOT ABOVELATIN SMALL LETTER W WITH DOT A" +
	"BOVELATIN CAPITAL LETTER W WITH DOT BELOWLATIN SMALL LETTER W WITH DOT B" +
	"ELOWLATIN CAPITAL LETTER X WITH DOT ABOVELATIN SMALL LETTER X WITH DOT A" +
	"BOVELATIN CAPITAL LETTER X WITH DIAERESISLATIN SMALL LETTER X WITH DIAER" +
	"ESISLATIN CAPITAL LETTER Y WITH DOT ABOVELATIN SMALL LETTER Y WITH DOT A" +
	"BOVELATIN CAPITAL LETTER Z WITH CIRCUMFLEXLATIN SMALL LETTER Z WITH CIRC" +
	"UMFLEXLATIN CAPITAL LETTER Z WITH DOT BELOWLATIN SMALL LETTER Z WITH DOT" +
	" BELOWLATIN CAPITAL LETTER Z WITH LINE BELOWLATIN SMALL LETTER Z WITH LI") + ("" +
	"NE BELOWLATIN SMALL LETTER H WITH LINE BELOWLATIN SMALL LETTER T WITH DI" +
	"AERESISLATIN SMALL LETTER W WITH RING ABOVELATIN SMALL LETTER Y WITH RIN" +
	"G ABOVELATIN SMALL LETTER A WITH RIGHT HALF RINGLATIN SMALL LETTER LONG " +
	"S WITH DOT ABOVELATIN SMALL LETTER LONG S WITH DIAGONAL STROKELATIN SMAL" +
	"L LETTER LONG S WITH HIGH STROKELATIN CAPITAL LETTER SHARP SLATIN SMALL " +
	"LETTER DELTALATIN CAPITAL LETTER A WITH DOT BELOWLATIN SMALL LETTER A WI" +
	"TH DOT BELOWLATIN CAPITAL LETTER A WITH HOOK ABOVELATIN SMALL LETTER A W" +
	"ITH HOOK ABOVELATIN CAPITAL LETTER A WITH CIRCUMFLEX AND ACUTELATIN SMAL" +
	"L LETTER A WITH CIRCUMFLEX AND ACUTELATIN CAPITAL LETTER A WITH CIRCUMFL" +
	"EX AND GRAVELATIN SMALL LETTER A WITH CIRCUMFLEX AND GRAVELATIN CAPITAL " +
	"LETTER A WITH CIRCUMFLEX AND HOOK ABOVELATIN SMALL LETTER A WITH CIRCUMF" +
	"LEX AND HOOK ABOVELATIN CAPITAL LETTER A WITH CIRCUMFLEX AND TILDELATIN " +
	"SMALL LETTER A WITH CIRCUMFLEX AND TILDELATIN CAPITAL LETTER A WITH CIRC" +
	"UMFLEX AND DOT BELOWLATIN SMALL LETTER A WITH CIRCUMFLEX AND DOT BELOWLA" +
	"TIN CAPITAL LETTER A WITH BREVE AND ACUTELATIN SMALL LETTER A WITH BREVE" +
	" AND ACUTELATIN CAPITAL LETTER A WITH BREVE AND GRAVELATIN SMALL LETTER " +
	"A WITH BREVE AND GRAVELATIN CAPITAL LETTER A WITH BREVE AND HOOK ABOVELA" +
	"TIN SMALL LETTER A WITH BREVE AND HOOK ABOVELATIN CAPITAL LETTER A WITH " +
	"BREVE AND TILDELATIN SMALL LETTER A WITH BREVE AND TILDELATIN CAPITAL LE" +
	"TTER A WITH BREVE AND DOT BELOWLATIN SMALL LETTER A WITH BREVE AND DOT B" +
	"ELOWLATIN CAPITAL LETTER E WITH DOT BELOWLATIN SMALL LETTER E WITH DOT B" +
	"ELOWLATIN CAPITAL LETTER E WITH HOOK ABOVELATIN SMALL LETTER E WITH HOOK" +
	" ABOVELATIN CAPITAL LETTER E WITH TILDELATIN SMALL LETTER E WITH TILDELA" +
	"TIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTELATIN SMALL LETTER E WITH " +
	"CIRCUMFLEX AND ACUTELATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVELATI" +
	"N SMALL LETTER E WITH CIRCUMFLEX AND GRAVELATIN CAPITAL LETTER E WITH CI" +
	"RCUMFLEX AND HOOK ABOVELATIN SMALL LETTER E WITH CIRCUMFLEX AND HOOK ABO" +
	"VELATIN CAPITAL LETTER E WITH CIRCUMFLEX AND TILDELATIN SMALL LETTER E W" +
	"ITH CIRCUMFLEX AND TILDELATIN CAPITAL LETTER E WITH CIRCUMFLEX AND DOT B" +
	"ELOWLATIN SMALL LETTER E WITH CIRCUMFLEX AND DOT BELOWLATIN CAPITAL LETT" +
	"ER I WITH HOOK ABOVELATIN SMALL LETTER I WITH HOOK ABOVELATIN CAPITAL LE" +
	"TTER I WITH DOT BELOWLATIN SMALL LETTER I WITH DOT BELOWLATIN CAPITAL LE" +
	"TTER O WITH DOT BELOWLATIN SMALL LETTER O WITH DOT BELOWLATIN CAPITAL LE" +
	"TTER O WITH HOOK ABOVELATIN SMALL LETTER O WITH HOOK ABOVELATIN CAPITAL " +
	"LETTER O WITH CIRCUMFLEX AND ACUTELATIN SMALL LETTER O WITH CIRCUMFLEX A" +
	"ND ACUTELATIN CAPITAL LETTER O WITH CIRCUMFLEX AND GRAVELATIN SMALL LETT" +
	"ER O WITH CIRCUMFLEX AND GRAVELATIN CAPITAL LETTER O WITH CIRCUMFLEX AND" +
	" HOOK ABOVELATIN SMALL LETTER O WITH CIRCUMFLEX AND HOOK ABOVELATIN CAPI" +
	"TAL LETTER O WITH CIRCUMFLEX AND TILDELATIN SMALL LETTER O WITH CIRCUMFL" +
	"EX AND TILDELATIN CAPITAL LETTER O WITH CIRCUMFLEX AND DOT BELOWLATIN SM" +
	"ALL LETTER O WITH CIRCUMFLEX AND DOT BELOWLATIN CAPITAL LETTER O WITH HO" +
	"RN AND ACUTELATIN SMALL LETTER O WITH HORN AND ACUTELATIN CAPITAL LETTER" +
	" O WITH HORN AND GRAVELATIN SMALL LETTER O WITH HORN AND GRAVELATIN CAPI" +
	"TAL LETTER O WITH HORN AND HOOK ABOVELATIN SMALL LETTER O WITH HORN AND " +
	"HOOK ABOVELATIN CAPITAL LETTER O WITH HORN AND TILDELATIN SMALL LETTER O" +
	" WITH HORN AND TILDELATIN CAPITAL LETTER O WITH HORN AND DOT BELOWLATIN " +
	"SMALL LETTER O WITH HORN AND DOT BELOWLATIN CAPITAL LETTER U WITH DOT BE" +
	"LOWLATIN SMALL LETTER U WITH DOT BELOWLATIN CAPITAL LETTER U WITH HOOK A" +
	"BOVELATIN SMALL LETTER U WITH HOOK ABOVELATIN CAPITAL LETTER U WITH HORN" +
	" AND ACUTELATIN SMALL LETTER U WITH HORN AND ACUTELATIN CAPITAL LETTER U" +
	" WITH HORN AND GRAVELATIN SMALL LETTER U WITH HORN AND GRAVELATIN CAPITA" +
	"L LETTER U WITH HORN AND HOOK ABOVELATIN SMALL LETTER U WITH HORN AND HO" +
	"OK ABOVELATIN CAPITAL LETTER U WITH HORN AND TILDELATIN SMALL LETTER U W" +
	"ITH HORN AND TILDELATIN CAPITAL LETTER U WITH HORN AND DOT BELOWLATIN SM" +
	"ALL LETTER U WITH HORN AND DOT BELOWLATIN CAPITAL LETTER Y WITH GRAVELAT" +
	"IN SMALL LETTER Y WITH GRAVELATIN CAPITAL LETTER Y WITH DOT BELOWLATIN S" +
	"MALL LETTER Y WITH DOT BELOWLATIN CAPITAL LETTER Y WITH HOOK ABOVELATIN " +
	"SMALL LETTER Y WITH HOOK ABOVELATIN CAPITAL LETTER Y WITH TILDELATIN SMA" +
	"LL LETTER Y WITH TILDELATIN CAPITAL LETTER MIDDLE-WELSH LLLATIN SMALL LE" +
	"TTER MIDDLE-WELSH LLLATIN CAPITAL LETTER MIDDLE-WELSH VLATIN SMALL LETTE" +
	"R MIDDLE-WELSH VLATIN CAPITAL LETTER Y WITH LOOPLATIN SMALL LETTER Y WIT" +
	"H LOOPGREEK SMALL LETTER ALPHA WITH PSILIGREEK SMALL LETTER ALPHA WITH D" +
	"ASIAGREEK SMALL LETTER ALPHA WITH PSILI AND VARIAGREEK SMALL LETTER ALPH" +
	"A WITH DASIA AND VARIAGREEK SMALL LETTER ALPHA WITH PSILI AND OXIAGREEK ") + ("" +
	"SMALL LETTER ALPHA WITH DASIA AND OXIAGREEK SMALL LETTER ALPHA WITH PSIL" +
	"I AND PERISPOMENIGREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENIGREE" +
	"K CAPITAL LETTER ALPHA WITH PSILIGREEK CAPITAL LETTER ALPHA WITH DASIAGR" +
	"EEK CAPITAL LETTER ALPHA WITH PSILI AND VARIAGREEK CAPITAL LETTER ALPHA " +
	"WITH DASIA AND VARIAGREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIAGREEK " +
	"CAPITAL LETTER ALPHA WITH DASIA AND OXIAGREEK CAPITAL LETTER ALPHA WITH " +
	"PSILI AND PERISPOMENIGREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOME" +
	"NIGREEK SMALL LETTER EPSILON WITH PSILIGREEK SMALL LETTER EPSILON WITH D" +
	"ASIAGREEK SMALL LETTER EPSILON WITH PSILI AND VARIAGREEK SMALL LETTER EP" +
	"SILON WITH DASIA AND VARIAGREEK SMALL LETTER EPSILON WITH PSILI AND OXIA" +
	"GREEK SMALL LETTER EPSILON WITH DASIA AND OXIAGREEK CAPITAL LETTER EPSIL" +
	"ON WITH PSILIGREEK CAPITAL LETTER EPSILON WITH DASIAGREEK CAPITAL LETTER" +
	" EPSILON WITH PSILI AND VARIAGREEK CAPITAL LETTER EPSILON WITH DASIA AND" +
	" VARIAGREEK CAPITAL LETTER EPSILON WITH PSILI AND OXIAGREEK CAPITAL LETT" +
	"ER EPSILON WITH DASIA AND OXIAGREEK SMALL LETTER ETA WITH PSILIGREEK SMA" +
	"LL LETTER ETA WITH DASIAGREEK SMALL LETTER ETA WITH PSILI AND VARIAGREEK" +
	" SMALL LETTER ETA WITH DASIA AND VARIAGREEK SMALL LETTER ETA WITH PSILI " +
	"AND OXIAGREEK SMALL LETTER ETA WITH DASIA AND OXIAGREEK SMALL LETTER ETA" +
	" WITH PSILI AND PERISPOMENIGREEK SMALL LETTER ETA WITH DASIA AND PERISPO" +
	"MENIGREEK CAPITAL LETTER ETA WITH PSILIGREEK CAPITAL LETTER ETA WITH DAS" +
	"IAGREEK CAPITAL LETTER ETA WITH PSILI AND VARIAGREEK CAPITAL LETTER ETA " +
	"WITH DASIA AND VARIAGREEK CAPITAL LETTER ETA WITH PSILI AND OXIAGREEK CA" +
	"PITAL LETTER ETA WITH DASIA AND OXIAGREEK CAPITAL LETTER ETA WITH PSILI " +
	"AND PERISPOMENIGREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENIGREEK " +
	"SMALL LETTER IOTA WITH PSILIGREEK SMALL LETTER IOTA WITH DASIAGREEK SMAL" +
	"L LETTER IOTA WITH PSILI AND VARIAGREEK SMALL LETTER IOTA WITH DASIA AND" +
	" VARIAGREEK SMALL LETTER IOTA WITH PSILI AND OXIAGREEK SMALL LETTER IOTA" +
	" WITH DASIA AND OXIAGREEK SMALL LETTER IOTA WITH PSILI AND PERISPOMENIGR" +
	"EEK SMALL LETTER IOTA WITH DASIA AND PERISPOMENIGREEK CAPITAL LETTER IOT" +
	"A WITH PSILIGREEK CAPITAL LETTER IOTA WITH DASIAGREEK CAPITAL LETTER IOT" +
	"A WITH PSILI AND VARIAGREEK CAPITAL LETTER IOTA WITH DASIA AND VARIAGREE" +
	"K CAPITAL LETTER IOTA WITH PSILI AND OXIAGREEK CAPITAL LETTER IOTA WITH " +
	"DASIA AND OXIAGREEK CAPITAL LETTER IOTA WITH PSILI AND PERISPOMENIGREEK " +
	"CAPITAL LETTER IOTA WITH DASIA AND PERISPOMENIGREEK SMALL LETTER OMICRON" +
	" WITH PSILIGREEK SMALL LETTER OMICRON WITH DASIAGREEK SMALL LETTER OMICR" +
	"ON WITH PSILI AND VARIAGREEK SMALL LETTER OMICRON WITH DASIA AND VARIAGR" +
	"EEK SMALL LETTER OMICRON WITH PSILI AND OXIAGREEK SMALL LETTER OMICRON W" +
	"ITH DASIA AND OXIAGREEK CAPITAL LETTER OMICRON WITH PSILIGREEK CAPITAL L" +
	"ETTER OMICRON WITH DASIAGREEK CAPITAL LETTER OMICRON WITH PSILI AND VARI" +
	"AGREEK CAPITAL LETTER OMICRON WITH DASIA AND VARIAGREEK CAPITAL LETTER O" +
	"MICRON WITH PSILI AND OXIAGREEK CAPITAL LETTER OMICRON WITH DASIA AND OX" +
	"IAGREEK SMALL LETTER UPSILON WITH PSILIGREEK SMALL LETTER UPSILON WITH D" +
	"ASIAGREEK SMALL LETTER UPSILON WITH PSILI AND VARIAGREEK SMALL LETTER UP" +
	"SILON WITH DASIA AND VARIAGREEK SMALL LETTER UPSILON WITH PSILI AND OXIA" +
	"GREEK SMALL LETTER UPSILON WITH DASIA AND OXIAGREEK SMALL LETTER UPSILON" +
	" WITH PSILI AND PERISPOMENIGREEK SMALL LETTER UPSILON WITH DASIA AND PER" +
	"ISPOMENIGREEK CAPITAL LETTER UPSILON WITH DASIAGREEK CAPITAL LETTER UPSI" +
	"LON WITH DASIA AND VARIAGREEK CAPITAL LETTER UPSILON WITH DASIA AND OXIA" +
	"GREEK CAPITAL LETTER UPSILON WITH DASIA AND PERISPOMENIGREEK SMALL LETTE" +
	"R OMEGA WITH PSILIGREEK SMALL LETTER OMEGA WITH DASIAGREEK SMALL LETTER " +
	"OMEGA WITH PSILI AND VARIAGREEK SMALL LETTER OMEGA WITH DASIA AND VARIAG" +
	"REEK SMALL LETTER OMEGA WITH PSILI AND OXIAGREEK SMALL LETTER OMEGA WITH" +
	" DASIA AND OXIAGREEK SMALL LETTER OMEGA WITH PSILI AND PERISPOMENIGREEK " +
	"SMALL LETTER OMEGA WITH DASIA AND PERISPOMENIGREEK CAPITAL LETTER OMEGA " +
	"WITH PSILIGREEK CAPITAL LETTER OMEGA WITH DASIAGREEK CAPITAL LETTER OMEG" +
	"A WITH PSILI AND VARIAGREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIAGRE" +
	"EK CAPITAL LETTER OMEGA WITH PSILI AND OXIAGREEK CAPITAL LETTER OMEGA WI" +
	"TH DASIA AND OXIAGREEK CAPITAL LETTER OMEGA WITH PSILI AND PERISPOMENIGR" +
	"EEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENIGREEK SMALL LETTER AL" +
	"PHA WITH VARIAGREEK SMALL LETTER ALPHA WITH OXIAGREEK SMALL LETTER EPSIL" +
	"ON WITH VARIAGREEK SMALL LETTER EPSILON WITH OXIAGREEK SMALL LETTER ETA " +
	"WITH VARIAGREEK SMALL LETTER ETA WITH OXIAGREEK SMALL LETTER IOTA WITH V" +
	"ARIAGREEK SMALL LETTER IOTA WITH OXIAGREEK SMALL LETTER OMICRON WITH VAR" +
	"IAGREEK SMALL LETTER OMICRON WITH OXIAGREEK SMALL LETTER UPSILON WITH VA") + ("" +
	"RIAGREEK SMALL LETTER UPSILON WITH OXIAGREEK SMALL LETTER OMEGA WITH VAR" +
	"IAGREEK SMALL LETTER OMEGA WITH OXIAGREEK SMALL LETTER ALPHA WITH PSILI " +
	"AND YPOGEGRAMMENIGREEK SMALL LETTER ALPHA WITH DASIA AND YPOGEGRAMMENIGR" +
	"EEK SMALL LETTER ALPHA WITH PSILI AND VARIA AND YPOGEGRAMMENIGREEK SMALL" +
	" LETTER ALPHA WITH DASIA AND VARIA AND YPOGEGRAMMENIGREEK SMALL LETTER A" +
	"LPHA WITH PSILI AND OXIA AND YPOGEGRAMMENIGREEK SMALL LETTER ALPHA WITH " +
	"DASIA AND OXIA AND YPOGEGRAMMENIGREEK SMALL LETTER ALPHA WITH PSILI AND " +
	"PERISPOMENI AND YPOGEGRAMMENIGREEK SMALL LETTER ALPHA WITH DASIA AND PER" +
	"ISPOMENI AND YPOGEGRAMMENIGREEK CAPITAL LETTER ALPHA WITH PSILI AND PROS" +
	"GEGRAMMENIGREEK CAPITAL LETTER ALPHA WITH DASIA AND PROSGEGRAMMENIGREEK " +
	"CAPITAL LETTER ALPHA WITH PSILI AND VARIA AND PROSGEGRAMMENIGREEK CAPITA" +
	"L LETTER ALPHA WITH DASIA AND VARIA AND PROSGEGRAMMENIGREEK CAPITAL LETT" +
	"ER ALPHA WITH PSILI AND OXIA AND PROSGEGRAMMENIGREEK CAPITAL LETTER ALPH" +
	"A WITH DASIA AND OXIA AND PROSGEGRAMMENIGREEK CAPITAL LETTER ALPHA WITH " +
	"PSILI AND PERISPOMENI AND PROSGEGRAMMENIGREEK CAPITAL LETTER ALPHA WITH " +
	"DASIA AND PERISPOMENI AND PROSGEGRAMMENIGREEK SMALL LETTER ETA WITH PSIL" +
	"I AND YPOGEGRAMMENIGREEK SMALL LETTER ETA WITH DASIA AND YPOGEGRAMMENIGR" +
	"EEK SMALL LETTER ETA WITH PSILI AND VARIA AND YPOGEGRAMMENIGREEK SMALL L" +
	"ETTER ETA WITH DASIA AND VARIA AND YPOGEGRAMMENIGREEK SMALL LETTER ETA W" +
	"ITH PSILI AND OXIA AND YPOGEGRAMMENIGREEK SMALL LETTER ETA WITH DASIA AN" +
	"D OXIA AND YPOGEGRAMMENIGREEK SMALL LETTER ETA WITH PSILI AND PERISPOMEN" +
	"I AND YPOGEGRAMMENIGREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENI AND" +
	" YPOGEGRAMMENIGREEK CAPITAL LETTER ETA WITH PSILI AND PROSGEGRAMMENIGREE" +
	"K CAPITAL LETTER ETA WITH DASIA AND PROSGEGRAMMENIGREEK CAPITAL LETTER E" +
	"TA WITH PSILI AND VARIA AND PROSGEGRAMMENIGREEK CAPITAL LETTER ETA WITH " +
	"DASIA AND VARIA AND PROSGEGRAMMENIGREEK CAPITAL LETTER ETA WITH PSILI AN" +
	"D OXIA AND PROSGEGRAMMENIGREEK CAPITAL LETTER ETA WITH DASIA AND OXIA AN" +
	"D PROSGEGRAMMENIGREEK CAPITAL LETTER ETA WITH PSILI AND PERISPOMENI AND " +
	"PROSGEGRAMMENIGREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI AND PR" +
	"OSGEGRAMMENIGREEK SMALL LETTER OMEGA WITH PSILI AND YPOGEGRAMMENIGREEK S" +
	"MALL LETTER OMEGA WITH DASIA AND YPOGEGRAMMENIGREEK SMALL LETTER OMEGA W" +
	"ITH PSILI AND VARIA AND YPOGEGRAMMENIGREEK SMALL LETTER OMEGA WITH DASIA" +
	" AND VARIA AND YPOGEGRAMMENIGREEK SMALL LETTER OMEGA WITH PSILI AND OXIA" +
	" AND YPOGEGRAMMENIGREEK SMALL LETTER OMEGA WITH DASIA AND OXIA AND YPOGE" +
	"GRAMMENIGREEK SMALL LETTER OMEGA WITH PSILI AND PERISPOMENI AND YPOGEGRA" +
	"MMENIGREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI AND YPOGEGRAMME" +
	"NIGREEK CAPITAL LETTER OMEGA WITH PSILI AND PROSGEGRAMMENIGREEK CAPITAL " +
	"LETTER OMEGA WITH DASIA AND PROSGEGRAMMENIGREEK CAPITAL LETTER OMEGA WIT" +
	"H PSILI AND VARIA AND PROSGEGRAMMENIGREEK CAPITAL LETTER OMEGA WITH DASI" +
	"A AND VARIA AND PROSGEGRAMMENIGREEK CAPITAL LETTER OMEGA WITH PSILI AND " +
	"OXIA AND PROSGEGRAMMENIGREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIA AN" +
	"D PROSGEGRAMMENIGREEK CAPITAL LETTER OMEGA WITH PSILI AND PERISPOMENI AN" +
	"D PROSGEGRAMMENIGREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI AN" +
	"D PROSGEGRAMMENIGREEK SMALL LETTER ALPHA WITH VRACHYGREEK SMALL LETTER A" +
	"LPHA WITH MACRONGREEK SMALL LETTER ALPHA WITH VARIA AND YPOGEGRAMMENIGRE" +
	"EK SMALL LETTER ALPHA WITH YPOGEGRAMMENIGREEK SMALL LETTER ALPHA WITH OX" +
	"IA AND YPOGEGRAMMENIGREEK SMALL LETTER ALPHA WITH PERISPOMENIGREEK SMALL" +
	" LETTER ALPHA WITH PERISPOMENI AND YPOGEGRAMMENIGREEK CAPITAL LETTER ALP" +
	"HA WITH VRACHYGREEK CAPITAL LETTER ALPHA WITH MACRONGREEK CAPITAL LETTER" +
	" ALPHA WITH VARIAGREEK CAPITAL LETTER ALPHA WITH OXIAGREEK CAPITAL LETTE" +
	"R ALPHA WITH PROSGEGRAMMENIGREEK KORONISGREEK PROSGEGRAMMENIGREEK PSILIG" +
	"REEK PERISPOMENIGREEK DIALYTIKA AND PERISPOMENIGREEK SMALL LETTER ETA WI" +
	"TH VARIA AND YPOGEGRAMMENIGREEK SMALL LETTER ETA WITH YPOGEGRAMMENIGREEK" +
	" SMALL LETTER ETA WITH OXIA AND YPOGEGRAMMENIGREEK SMALL LETTER ETA WITH" +
	" PERISPOMENIGREEK SMALL LETTER ETA WITH PERISPOMENI AND YPOGEGRAMMENIGRE" +
	"EK CAPITAL LETTER EPSILON WITH VARIAGREEK CAPITAL LETTER EPSILON WITH OX" +
	"IAGREEK CAPITAL LETTER ETA WITH VARIAGREEK CAPITAL LETTER ETA WITH OXIAG" +
	"REEK CAPITAL LETTER ETA WITH PROSGEGRAMMENIGREEK PSILI AND VARIAGREEK PS" +
	"ILI AND OXIAGREEK PSILI AND PERISPOMENIGREEK SMALL LETTER IOTA WITH VRAC" +
	"HYGREEK SMALL LETTER IOTA WITH MACRONGREEK SMALL LETTER IOTA WITH DIALYT" +
	"IKA AND VARIAGREEK SMALL LETTER IOTA WITH DIALYTIKA AND OXIAGREEK SMALL " +
	"LETTER IOTA WITH PERISPOMENIGREEK SMALL LETTER IOTA WITH DIALYTIKA AND P" +
	"ERISPOMENIGREEK CAPITAL LETTER IOTA WITH VRACHYGREEK CAPITAL LETTER IOTA" +
	" WITH MACRONGREEK CAPITAL LETTER IOTA WITH VARIAGREEK CAPITAL LETTER IOT") + ("" +
	"A WITH OXIAGREEK DASIA AND VARIAGREEK DASIA AND OXIAGREEK DASIA AND PERI" +
	"SPOMENIGREEK SMALL LETTER UPSILON WITH VRACHYGREEK SMALL LETTER UPSILON " +
	"WITH MACRONGREEK SMALL LETTER UPSILON WITH DIALYTIKA AND VARIAGREEK SMAL" +
	"L LETTER UPSILON WITH DIALYTIKA AND OXIAGREEK SMALL LETTER RHO WITH PSIL" +
	"IGREEK SMALL LETTER RHO WITH DASIAGREEK SMALL LETTER UPSILON WITH PERISP" +
	"OMENIGREEK SMALL LETTER UPSILON WITH DIALYTIKA AND PERISPOMENIGREEK CAPI" +
	"TAL LETTER UPSILON WITH VRACHYGREEK CAPITAL LETTER UPSILON WITH MACRONGR" +
	"EEK CAPITAL LETTER UPSILON WITH VARIAGREEK CAPITAL LETTER UPSILON WITH O" +
	"XIAGREEK CAPITAL LETTER RHO WITH DASIAGREEK DIALYTIKA AND VARIAGREEK DIA" +
	"LYTIKA AND OXIAGREEK VARIAGREEK SMALL LETTER OMEGA WITH VARIA AND YPOGEG" +
	"RAMMENIGREEK SMALL LETTER OMEGA WITH YPOGEGRAMMENIGREEK SMALL LETTER OME" +
	"GA WITH OXIA AND YPOGEGRAMMENIGREEK SMALL LETTER OMEGA WITH PERISPOMENIG" +
	"REEK SMALL LETTER OMEGA WITH PERISPOMENI AND YPOGEGRAMMENIGREEK CAPITAL " +
	"LETTER OMICRON WITH VARIAGREEK CAPITAL LETTER OMICRON WITH OXIAGREEK CAP" +
	"ITAL LETTER OMEGA WITH VARIAGREEK CAPITAL LETTER OMEGA WITH OXIAGREEK CA" +
	"PITAL LETTER OMEGA WITH PROSGEGRAMMENIGREEK OXIAGREEK DASIAEN QUADEM QUA" +
	"DEN SPACEEM SPACETHREE-PER-EM SPACEFOUR-PER-EM SPACESIX-PER-EM SPACEFIGU" +
	"RE SPACEPUNCTUATION SPACETHIN SPACEHAIR SPACEZERO WIDTH SPACEZERO WIDTH " +
	"NON-JOINERZERO WIDTH JOINERLEFT-TO-RIGHT MARKRIGHT-TO-LEFT MARKHYPHENNON" +
	"-BREAKING HYPHENFIGURE DASHEN DASHEM DASHHORIZONTAL BARDOUBLE VERTICAL L" +
	"INEDOUBLE LOW LINELEFT SINGLE QUOTATION MARKRIGHT SINGLE QUOTATION MARKS" +
	"INGLE LOW-9 QUOTATION MARKSINGLE HIGH-REVERSED-9 QUOTATION MARKLEFT DOUB" +
	"LE QUOTATION MARKRIGHT DOUBLE QUOTATION MARKDOUBLE LOW-9 QUOTATION MARKD" +
	"OUBLE HIGH-REVERSED-9 QUOTATION MARKDAGGERDOUBLE DAGGERBULLETTRIANGULAR " +
	"BULLETONE DOT LEADERTWO DOT LEADERHORIZONTAL ELLIPSISHYPHENATION POINTLI" +
	"NE SEPARATORPARAGRAPH SEPARATORLEFT-TO-RIGHT EMBEDDINGRIGHT-TO-LEFT EMBE" +
	"DDINGPOP DIRECTIONAL FORMATTINGLEFT-TO-RIGHT OVERRIDERIGHT-TO-LEFT OVERR" +
	"IDENARROW NO-BREAK SPACEPER MILLE SIGNPER TEN THOUSAND SIGNPRIMEDOUBLE P" +
	"RIMETRIPLE PRIMEREVERSED PRIMEREVERSED DOUBLE PRIMEREVERSED TRIPLE PRIME" +
	"CARETSINGLE LEFT-POINTING ANGLE QUOTATION MARKSINGLE RIGHT-POINTING ANGL" +
	"E QUOTATION MARKREFERENCE MARKDOUBLE EXCLAMATION MARKINTERROBANGOVERLINE" +
	"UNDERTIECHARACTER TIECARET INSERTION POINTASTERISMHYPHEN BULLETFRACTION " +
	"SLASHLEFT SQUARE BRACKET WITH QUILLRIGHT SQUARE BRACKET WITH QUILLDOUBLE" +
	" QUESTION MARKQUESTION EXCLAMATION MARKEXCLAMATION QUESTION MARKTIRONIAN" +
	" SIGN ETREVERSED PILCROW SIGNBLACK LEFTWARDS BULLETBLACK RIGHTWARDS BULL" +
	"ETLOW ASTERISKREVERSED SEMICOLONCLOSE UPTWO ASTERISKS ALIGNED VERTICALLY" +
	"COMMERCIAL MINUS SIGNSWUNG DASHINVERTED UNDERTIEFLOWER PUNCTUATION MARKT" +
	"HREE DOT PUNCTUATIONQUADRUPLE PRIMEFOUR DOT PUNCTUATIONFIVE DOT PUNCTUAT" +
	"IONTWO DOT PUNCTUATIONFOUR DOT MARKDOTTED CROSSTRICOLONVERTICAL FOUR DOT" +
	"SMEDIUM MATHEMATICAL SPACEWORD JOINERFUNCTION APPLICATIONINVISIBLE TIMES" +
	"INVISIBLE SEPARATORINVISIBLE PLUSLEFT-TO-RIGHT ISOLATERIGHT-TO-LEFT ISOL" +
	"ATEFIRST STRONG ISOLATEPOP DIRECTIONAL ISOLATEINHIBIT SYMMETRIC SWAPPING" +
	"ACTIVATE SYMMETRIC SWAPPINGINHIBIT ARABIC FORM SHAPINGACTIVATE ARABIC FO" +
	"RM SHAPINGNATIONAL DIGIT SHAPESNOMINAL DIGIT SHAPESSUPERSCRIPT ZEROSUPER" +
	"SCRIPT LATIN SMALL LETTER ISUPERSCRIPT FOURSUPERSCRIPT FIVESUPERSCRIPT S" +
	"IXSUPERSCRIPT SEVENSUPERSCRIPT EIGHTSUPERSCRIPT NINESUPERSCRIPT PLUS SIG" +
	"NSUPERSCRIPT MINUSSUPERSCRIPT EQUALS SIGNSUPERSCRIPT LEFT PARENTHESISSUP" +
	"ERSCRIPT RIGHT PARENTHESISSUPERSCRIPT LATIN SMALL LETTER NSUBSCRIPT ZERO" +
	"SUBSCRIPT ONESUBSCRIPT TWOSUBSCRIPT THREESUBSCRIPT FOURSUBSCRIPT FIVESUB" +
	"SCRIPT SIXSUBSCRIPT SEVENSUBSCRIPT EIGHTSUBSCRIPT NINESUBSCRIPT PLUS SIG" +
	"NSUBSCRIPT MINUSSUBSCRIPT EQUALS SIGNSUBSCRIPT LEFT PARENTHESISSUBSCRIPT" +
	" RIGHT PARENTHESISLATIN SUBSCRIPT SMALL LETTER ALATIN SUBSCRIPT SMALL LE" +
	"TTER ELATIN SUBSCRIPT SMALL LETTER OLATIN SUBSCRIPT SMALL LETTER XLATIN " +
	"SUBSCRIPT SMALL LETTER SCHWALATIN SUBSCRIPT SMALL LETTER HLATIN SUBSCRIP" +
	"T SMALL LETTER KLATIN SUBSCRIPT SMALL LETTER LLATIN SUBSCRIPT SMALL LETT" +
	"ER MLATIN SUBSCRIPT SMALL LETTER NLATIN SUBSCRIPT SMALL LETTER PLATIN SU" +
	"BSCRIPT SMALL LETTER SLATIN SUBSCRIPT SMALL LETTER TEURO-CURRENCY SIGNCO" +
	"LON SIGNCRUZEIRO SIGNFRENCH FRANC SIGNLIRA SIGNMILL SIGNNAIRA SIGNPESETA" +
	" SIGNRUPEE SIGNWON SIGNNEW SHEQEL SIGNDONG SIGNEURO SIGNKIP SIGNTUGRIK S" +
	"IGNDRACHMA SIGNGERMAN PENNY SIGNPESO SIGNGUARANI SIGNAUSTRAL SIGNHRYVNIA" +
	" SIGNCEDI SIGNLIVRE TOURNOIS SIGNSPESMILO SIGNTENGE SIGNINDIAN RUPEE SIG" +
	"NTURKISH LIRA SIGNNORDIC MARK SIGNMANAT SIGNRUBLE SIGNLARI SIGNCOMBINING" +
	" LEFT HARPOON ABOVECOMBINING RIGHT HARPOON ABOVECOMBINING LONG VERTICAL " +
	"LINE OVERLAYCOMBINING SHORT VERTICAL LINE OVERLAYCOMBINING ANTICLOCKWISE") + ("" +
	" ARROW ABOVECOMBINING CLOCKWISE ARROW ABOVECOMBINING LEFT ARROW ABOVECOM" +
	"BINING RIGHT ARROW ABOVECOMBINING RING OVERLAYCOMBINING CLOCKWISE RING O" +
	"VERLAYCOMBINING ANTICLOCKWISE RING OVERLAYCOMBINING THREE DOTS ABOVECOMB" +
	"INING FOUR DOTS ABOVECOMBINING ENCLOSING CIRCLECOMBINING ENCLOSING SQUAR" +
	"ECOMBINING ENCLOSING DIAMONDCOMBINING ENCLOSING CIRCLE BACKSLASHCOMBININ" +
	"G LEFT RIGHT ARROW ABOVECOMBINING ENCLOSING SCREENCOMBINING ENCLOSING KE" +
	"YCAPCOMBINING ENCLOSING UPWARD POINTING TRIANGLECOMBINING REVERSE SOLIDU" +
	"S OVERLAYCOMBINING DOUBLE VERTICAL STROKE OVERLAYCOMBINING ANNUITY SYMBO" +
	"LCOMBINING TRIPLE UNDERDOTCOMBINING WIDE BRIDGE ABOVECOMBINING LEFTWARDS" +
	" ARROW OVERLAYCOMBINING LONG DOUBLE SOLIDUS OVERLAYCOMBINING RIGHTWARDS " +
	"HARPOON WITH BARB DOWNWARDSCOMBINING LEFTWARDS HARPOON WITH BARB DOWNWAR" +
	"DSCOMBINING LEFT ARROW BELOWCOMBINING RIGHT ARROW BELOWCOMBINING ASTERIS" +
	"K ABOVEACCOUNT OFADDRESSED TO THE SUBJECTDOUBLE-STRUCK CAPITAL CDEGREE C" +
	"ELSIUSCENTRE LINE SYMBOLCARE OFCADA UNAEULER CONSTANTSCRUPLEDEGREE FAHRE" +
	"NHEITSCRIPT SMALL GSCRIPT CAPITAL HBLACK-LETTER CAPITAL HDOUBLE-STRUCK C" +
	"APITAL HPLANCK CONSTANTPLANCK CONSTANT OVER TWO PISCRIPT CAPITAL IBLACK-" +
	"LETTER CAPITAL ISCRIPT CAPITAL LSCRIPT SMALL LL B BAR SYMBOLDOUBLE-STRUC" +
	"K CAPITAL NNUMERO SIGNSOUND RECORDING COPYRIGHTSCRIPT CAPITAL PDOUBLE-ST" +
	"RUCK CAPITAL PDOUBLE-STRUCK CAPITAL QSCRIPT CAPITAL RBLACK-LETTER CAPITA" +
	"L RDOUBLE-STRUCK CAPITAL RPRESCRIPTION TAKERESPONSESERVICE MARKTELEPHONE" +
	" SIGNTRADE MARK SIGNVERSICLEDOUBLE-STRUCK CAPITAL ZOUNCE SIGNOHM SIGNINV" +
	"ERTED OHM SIGNBLACK-LETTER CAPITAL ZTURNED GREEK SMALL LETTER IOTAKELVIN" +
	" SIGNANGSTROM SIGNSCRIPT CAPITAL BBLACK-LETTER CAPITAL CESTIMATED SYMBOL" +
	"SCRIPT SMALL ESCRIPT CAPITAL ESCRIPT CAPITAL FTURNED CAPITAL FSCRIPT CAP" +
	"ITAL MSCRIPT SMALL OALEF SYMBOLBET SYMBOLGIMEL SYMBOLDALET SYMBOLINFORMA" +
	"TION SOURCEROTATED CAPITAL QFACSIMILE SIGNDOUBLE-STRUCK SMALL PIDOUBLE-S" +
	"TRUCK SMALL GAMMADOUBLE-STRUCK CAPITAL GAMMADOUBLE-STRUCK CAPITAL PIDOUB" +
	"LE-STRUCK N-ARY SUMMATIONTURNED SANS-SERIF CAPITAL GTURNED SANS-SERIF CA" +
	"PITAL LREVERSED SANS-SERIF CAPITAL LTURNED SANS-SERIF CAPITAL YDOUBLE-ST" +
	"RUCK ITALIC CAPITAL DDOUBLE-STRUCK ITALIC SMALL DDOUBLE-STRUCK ITALIC SM" +
	"ALL EDOUBLE-STRUCK ITALIC SMALL IDOUBLE-STRUCK ITALIC SMALL JPROPERTY LI" +
	"NETURNED AMPERSANDPER SIGNAKTIESELSKABTURNED SMALL FSYMBOL FOR SAMARITAN" +
	" SOURCEVULGAR FRACTION ONE SEVENTHVULGAR FRACTION ONE NINTHVULGAR FRACTI" +
	"ON ONE TENTHVULGAR FRACTION ONE THIRDVULGAR FRACTION TWO THIRDSVULGAR FR" +
	"ACTION ONE FIFTHVULGAR FRACTION TWO FIFTHSVULGAR FRACTION THREE FIFTHSVU" +
	"LGAR FRACTION FOUR FIFTHSVULGAR FRACTION ONE SIXTHVULGAR FRACTION FIVE S" +
	"IXTHSVULGAR FRACTION ONE EIGHTHVULGAR FRACTION THREE EIGHTHSVULGAR FRACT" +
	"ION FIVE EIGHTHSVULGAR FRACTION SEVEN EIGHTHSFRACTION NUMERATOR ONEROMAN" +
	" NUMERAL ONEROMAN NUMERAL TWOROMAN NUMERAL THREEROMAN NUMERAL FOURROMAN " +
	"NUMERAL FIVEROMAN NUMERAL SIXROMAN NUMERAL SEVENROMAN NUMERAL EIGHTROMAN" +
	" NUMERAL NINEROMAN NUMERAL TENROMAN NUMERAL ELEVENROMAN NUMERAL TWELVERO" +
	"MAN NUMERAL FIFTYROMAN NUMERAL ONE HUNDREDROMAN NUMERAL FIVE HUNDREDROMA" +
	"N NUMERAL ONE THOUSANDSMALL ROMAN NUMERAL ONESMALL ROMAN NUMERAL TWOSMAL" +
	"L ROMAN NUMERAL THREESMALL ROMAN NUMERAL FOURSMALL ROMAN NUMERAL FIVESMA" +
	"LL ROMAN NUMERAL SIXSMALL ROMAN NUMERAL SEVENSMALL ROMAN NUMERAL EIGHTSM" +
	"ALL ROMAN NUMERAL NINESMALL ROMAN NUMERAL TENSMALL ROMAN NUMERAL ELEVENS" +
	"MALL ROMAN NUMERAL TWELVESMALL ROMAN NUMERAL FIFTYSMALL ROMAN NUMERAL ON" +
	"E HUNDREDSMALL ROMAN NUMERAL FIVE HUNDREDSMALL ROMAN NUMERAL ONE THOUSAN" +
	"DROMAN NUMERAL ONE THOUSAND C DROMAN NUMERAL FIVE THOUSANDROMAN NUMERAL " +
	"TEN THOUSANDROMAN NUMERAL REVERSED ONE HUNDREDLATIN SMALL LETTER REVERSE" +
	"D CROMAN NUMERAL SIX LATE FORMROMAN NUMERAL FIFTY EARLY FORMROMAN NUMERA" +
	"L FIFTY THOUSANDROMAN NUMERAL ONE HUNDRED THOUSANDVULGAR FRACTION ZERO T" +
	"HIRDSTURNED DIGIT TWOTURNED DIGIT THREELEFTWARDS ARROWUPWARDS ARROWRIGHT" +
	"WARDS ARROWDOWNWARDS ARROWLEFT RIGHT ARROWUP DOWN ARROWNORTH WEST ARROWN" +
	"ORTH EAST ARROWSOUTH EAST ARROWSOUTH WEST ARROWLEFTWARDS ARROW WITH STRO" +
	"KERIGHTWARDS ARROW WITH STROKELEFTWARDS WAVE ARROWRIGHTWARDS WAVE ARROWL" +
	"EFTWARDS TWO HEADED ARROWUPWARDS TWO HEADED ARROWRIGHTWARDS TWO HEADED A" +
	"RROWDOWNWARDS TWO HEADED ARROWLEFTWARDS ARROW WITH TAILRIGHTWARDS ARROW " +
	"WITH TAILLEFTWARDS ARROW FROM BARUPWARDS ARROW FROM BARRIGHTWARDS ARROW " +
	"FROM BARDOWNWARDS ARROW FROM BARUP DOWN ARROW WITH BASELEFTWARDS ARROW W" +
	"ITH HOOKRIGHTWARDS ARROW WITH HOOKLEFTWARDS ARROW WITH LOOPRIGHTWARDS AR" +
	"ROW WITH LOOPLEFT RIGHT WAVE ARROWLEFT RIGHT ARROW WITH STROKEDOWNWARDS " +
	"ZIGZAG ARROWUPWARDS ARROW WITH TIP LEFTWARDSUPWARDS ARROW WITH TIP RIGHT" +
	"WARDSDOWNWARDS ARROW WITH TIP LEFTWARDSDOWNWARDS ARROW WITH TIP RIGHTWAR") + ("" +
	"DSRIGHTWARDS ARROW WITH CORNER DOWNWARDSDOWNWARDS ARROW WITH CORNER LEFT" +
	"WARDSANTICLOCKWISE TOP SEMICIRCLE ARROWCLOCKWISE TOP SEMICIRCLE ARROWNOR" +
	"TH WEST ARROW TO LONG BARLEFTWARDS ARROW TO BAR OVER RIGHTWARDS ARROW TO" +
	" BARANTICLOCKWISE OPEN CIRCLE ARROWCLOCKWISE OPEN CIRCLE ARROWLEFTWARDS " +
	"HARPOON WITH BARB UPWARDSLEFTWARDS HARPOON WITH BARB DOWNWARDSUPWARDS HA" +
	"RPOON WITH BARB RIGHTWARDSUPWARDS HARPOON WITH BARB LEFTWARDSRIGHTWARDS " +
	"HARPOON WITH BARB UPWARDSRIGHTWARDS HARPOON WITH BARB DOWNWARDSDOWNWARDS" +
	" HARPOON WITH BARB RIGHTWARDSDOWNWARDS HARPOON WITH BARB LEFTWARDSRIGHTW" +
	"ARDS ARROW OVER LEFTWARDS ARROWUPWARDS ARROW LEFTWARDS OF DOWNWARDS ARRO" +
	"WLEFTWARDS ARROW OVER RIGHTWARDS ARROWLEFTWARDS PAIRED ARROWSUPWARDS PAI" +
	"RED ARROWSRIGHTWARDS PAIRED ARROWSDOWNWARDS PAIRED ARROWSLEFTWARDS HARPO" +
	"ON OVER RIGHTWARDS HARPOONRIGHTWARDS HARPOON OVER LEFTWARDS HARPOONLEFTW" +
	"ARDS DOUBLE ARROW WITH STROKELEFT RIGHT DOUBLE ARROW WITH STROKERIGHTWAR" +
	"DS DOUBLE ARROW WITH STROKELEFTWARDS DOUBLE ARROWUPWARDS DOUBLE ARROWRIG" +
	"HTWARDS DOUBLE ARROWDOWNWARDS DOUBLE ARROWLEFT RIGHT DOUBLE ARROWUP DOWN" +
	" DOUBLE ARROWNORTH WEST DOUBLE ARROWNORTH EAST DOUBLE ARROWSOUTH EAST DO" +
	"UBLE ARROWSOUTH WEST DOUBLE ARROWLEFTWARDS TRIPLE ARROWRIGHTWARDS TRIPLE" +
	" ARROWLEFTWARDS SQUIGGLE ARROWRIGHTWARDS SQUIGGLE ARROWUPWARDS ARROW WIT" +
	"H DOUBLE STROKEDOWNWARDS ARROW WITH DOUBLE STROKELEFTWARDS DASHED ARROWU" +
	"PWARDS DASHED ARROWRIGHTWARDS DASHED ARROWDOWNWARDS DASHED ARROWLEFTWARD" +
	"S ARROW TO BARRIGHTWARDS ARROW TO BARLEFTWARDS WHITE ARROWUPWARDS WHITE " +
	"ARROWRIGHTWARDS WHITE ARROWDOWNWARDS WHITE ARROWUPWARDS WHITE ARROW FROM" +
	" BARUPWARDS WHITE ARROW ON PEDESTALUPWARDS WHITE ARROW ON PEDESTAL WITH " +
	"HORIZONTAL BARUPWARDS WHITE ARROW ON PEDESTAL WITH VERTICAL BARUPWARDS W" +
	"HITE DOUBLE ARROWUPWARDS WHITE DOUBLE ARROW ON PEDESTALRIGHTWARDS WHITE " +
	"ARROW FROM WALLNORTH WEST ARROW TO CORNERSOUTH EAST ARROW TO CORNERUP DO" +
	"WN WHITE ARROWRIGHT ARROW WITH SMALL CIRCLEDOWNWARDS ARROW LEFTWARDS OF " +
	"UPWARDS ARROWTHREE RIGHTWARDS ARROWSLEFTWARDS ARROW WITH VERTICAL STROKE" +
	"RIGHTWARDS ARROW WITH VERTICAL STROKELEFT RIGHT ARROW WITH VERTICAL STRO" +
	"KELEFTWARDS ARROW WITH DOUBLE VERTICAL STROKERIGHTWARDS ARROW WITH DOUBL" +
	"E VERTICAL STROKELEFT RIGHT ARROW WITH DOUBLE VERTICAL STROKELEFTWARDS O" +
	"PEN-HEADED ARROWRIGHTWARDS OPEN-HEADED ARROWLEFT RIGHT OPEN-HEADED ARROW" +
	"FOR ALLCOMPLEMENTPARTIAL DIFFERENTIALTHERE EXISTSTHERE DOES NOT EXISTEMP" +
	"TY SETINCREMENTNABLAELEMENT OFNOT AN ELEMENT OFSMALL ELEMENT OFCONTAINS " +
	"AS MEMBERDOES NOT CONTAIN AS MEMBERSMALL CONTAINS AS MEMBEREND OF PROOFN" +
	"-ARY PRODUCTN-ARY COPRODUCTN-ARY SUMMATIONMINUS SIGNMINUS-OR-PLUS SIGNDO" +
	"T PLUSDIVISION SLASHSET MINUSASTERISK OPERATORRING OPERATORBULLET OPERAT" +
	"ORSQUARE ROOTCUBE ROOTFOURTH ROOTPROPORTIONAL TOINFINITYRIGHT ANGLEANGLE" +
	"MEASURED ANGLESPHERICAL ANGLEDIVIDESDOES NOT DIVIDEPARALLEL TONOT PARALL" +
	"EL TOLOGICAL ANDLOGICAL ORINTERSECTIONUNIONINTEGRALDOUBLE INTEGRALTRIPLE" +
	" INTEGRALCONTOUR INTEGRALSURFACE INTEGRALVOLUME INTEGRALCLOCKWISE INTEGR" +
	"ALCLOCKWISE CONTOUR INTEGRALANTICLOCKWISE CONTOUR INTEGRALTHEREFOREBECAU" +
	"SERATIOPROPORTIONDOT MINUSEXCESSGEOMETRIC PROPORTIONHOMOTHETICTILDE OPER" +
	"ATORREVERSED TILDEINVERTED LAZY SSINE WAVEWREATH PRODUCTNOT TILDEMINUS T" +
	"ILDEASYMPTOTICALLY EQUAL TONOT ASYMPTOTICALLY EQUAL TOAPPROXIMATELY EQUA" +
	"L TOAPPROXIMATELY BUT NOT ACTUALLY EQUAL TONEITHER APPROXIMATELY NOR ACT" +
	"UALLY EQUAL TOALMOST EQUAL TONOT ALMOST EQUAL TOALMOST EQUAL OR EQUAL TO" +
	"TRIPLE TILDEALL EQUAL TOEQUIVALENT TOGEOMETRICALLY EQUIVALENT TODIFFEREN" +
	"CE BETWEENAPPROACHES THE LIMITGEOMETRICALLY EQUAL TOAPPROXIMATELY EQUAL " +
	"TO OR THE IMAGE OFIMAGE OF OR APPROXIMATELY EQUAL TOCOLON EQUALSEQUALS C" +
	"OLONRING IN EQUAL TORING EQUAL TOCORRESPONDS TOESTIMATESEQUIANGULAR TOST" +
	"AR EQUALSDELTA EQUAL TOEQUAL TO BY DEFINITIONMEASURED BYQUESTIONED EQUAL" +
	" TONOT EQUAL TOIDENTICAL TONOT IDENTICAL TOSTRICTLY EQUIVALENT TOLESS-TH" +
	"AN OR EQUAL TOGREATER-THAN OR EQUAL TOLESS-THAN OVER EQUAL TOGREATER-THA" +
	"N OVER EQUAL TOLESS-THAN BUT NOT EQUAL TOGREATER-THAN BUT NOT EQUAL TOMU" +
	"CH LESS-THANMUCH GREATER-THANBETWEENNOT EQUIVALENT TONOT LESS-THANNOT GR" +
	"EATER-THANNEITHER LESS-THAN NOR EQUAL TONEITHER GREATER-THAN NOR EQUAL T" +
	"OLESS-THAN OR EQUIVALENT TOGREATER-THAN OR EQUIVALENT TONEITHER LESS-THA" +
	"N NOR EQUIVALENT TONEITHER GREATER-THAN NOR EQUIVALENT TOLESS-THAN OR GR" +
	"EATER-THANGREATER-THAN OR LESS-THANNEITHER LESS-THAN NOR GREATER-THANNEI" +
	"THER GREATER-THAN NOR LESS-THANPRECEDESSUCCEEDSPRECEDES OR EQUAL TOSUCCE" +
	"EDS OR EQUAL TOPRECEDES OR EQUIVALENT TOSUCCEEDS OR EQUIVALENT TODOES NO" +
	"T PRECEDEDOES NOT SUCCEEDSUBSET OFSUPERSET OFNOT A SUBSET OFNOT A SUPERS" +
	"ET OFSUBSET OF OR EQUAL TOSUPERSET OF OR EQUAL TONEITHER A SUBSET OF NOR") + ("" +
	" EQUAL TONEITHER A SUPERSET OF NOR EQUAL TOSUBSET OF WITH NOT EQUAL TOSU" +
	"PERSET OF WITH NOT EQUAL TOMULTISETMULTISET MULTIPLICATIONMULTISET UNION" +
	"SQUARE IMAGE OFSQUARE ORIGINAL OFSQUARE IMAGE OF OR EQUAL TOSQUARE ORIGI" +
	"NAL OF OR EQUAL TOSQUARE CAPSQUARE CUPCIRCLED PLUSCIRCLED MINUSCIRCLED T" +
	"IMESCIRCLED DIVISION SLASHCIRCLED DOT OPERATORCIRCLED RING OPERATORCIRCL" +
	"ED ASTERISK OPERATORCIRCLED EQUALSCIRCLED DASHSQUARED PLUSSQUARED MINUSS" +
	"QUARED TIMESSQUARED DOT OPERATORRIGHT TACKLEFT TACKDOWN TACKUP TACKASSER" +
	"TIONMODELSTRUEFORCESTRIPLE VERTICAL BAR RIGHT TURNSTILEDOUBLE VERTICAL B" +
	"AR DOUBLE RIGHT TURNSTILEDOES NOT PROVENOT TRUEDOES NOT FORCENEGATED DOU" +
	"BLE VERTICAL BAR DOUBLE RIGHT TURNSTILEPRECEDES UNDER RELATIONSUCCEEDS U" +
	"NDER RELATIONNORMAL SUBGROUP OFCONTAINS AS NORMAL SUBGROUPNORMAL SUBGROU" +
	"P OF OR EQUAL TOCONTAINS AS NORMAL SUBGROUP OR EQUAL TOORIGINAL OFIMAGE " +
	"OFMULTIMAPHERMITIAN CONJUGATE MATRIXINTERCALATEXORNANDNORRIGHT ANGLE WIT" +
	"H ARCRIGHT TRIANGLEN-ARY LOGICAL ANDN-ARY LOGICAL ORN-ARY INTERSECTIONN-" +
	"ARY UNIONDIAMOND OPERATORDOT OPERATORSTAR OPERATORDIVISION TIMESBOWTIELE" +
	"FT NORMAL FACTOR SEMIDIRECT PRODUCTRIGHT NORMAL FACTOR SEMIDIRECT PRODUC" +
	"TLEFT SEMIDIRECT PRODUCTRIGHT SEMIDIRECT PRODUCTREVERSED TILDE EQUALSCUR" +
	"LY LOGICAL ORCURLY LOGICAL ANDDOUBLE SUBSETDOUBLE SUPERSETDOUBLE INTERSE" +
	"CTIONDOUBLE UNIONPITCHFORKEQUAL AND PARALLEL TOLESS-THAN WITH DOTGREATER" +
	"-THAN WITH DOTVERY MUCH LESS-THANVERY MUCH GREATER-THANLESS-THAN EQUAL T" +
	"O OR GREATER-THANGREATER-THAN EQUAL TO OR LESS-THANEQUAL TO OR LESS-THAN" +
	"EQUAL TO OR GREATER-THANEQUAL TO OR PRECEDESEQUAL TO OR SUCCEEDSDOES NOT" +
	" PRECEDE OR EQUALDOES NOT SUCCEED OR EQUALNOT SQUARE IMAGE OF OR EQUAL T" +
	"ONOT SQUARE ORIGINAL OF OR EQUAL TOSQUARE IMAGE OF OR NOT EQUAL TOSQUARE" +
	" ORIGINAL OF OR NOT EQUAL TOLESS-THAN BUT NOT EQUIVALENT TOGREATER-THAN " +
	"BUT NOT EQUIVALENT TOPRECEDES BUT NOT EQUIVALENT TOSUCCEEDS BUT NOT EQUI" +
	"VALENT TONOT NORMAL SUBGROUP OFDOES NOT CONTAIN AS NORMAL SUBGROUPNOT NO" +
	"RMAL SUBGROUP OF OR EQUAL TODOES NOT CONTAIN AS NORMAL SUBGROUP OR EQUAL" +
	"VERTICAL ELLIPSISMIDLINE HORIZONTAL ELLIPSISUP RIGHT DIAGONAL ELLIPSISDO" +
	"WN RIGHT DIAGONAL ELLIPSISELEMENT OF WITH LONG HORIZONTAL STROKEELEMENT " +
	"OF WITH VERTICAL BAR AT END OF HORIZONTAL STROKESMALL ELEMENT OF WITH VE" +
	"RTICAL BAR AT END OF HORIZONTAL STROKEELEMENT OF WITH DOT ABOVEELEMENT O" +
	"F WITH OVERBARSMALL ELEMENT OF WITH OVERBARELEMENT OF WITH UNDERBARELEME" +
	"NT OF WITH TWO HORIZONTAL STROKESCONTAINS WITH LONG HORIZONTAL STROKECON" +
	"TAINS WITH VERTICAL BAR AT END OF HORIZONTAL STROKESMALL CONTAINS WITH V" +
	"ERTICAL BAR AT END OF HORIZONTAL STROKECONTAINS WITH OVERBARSMALL CONTAI" +
	"NS WITH OVERBARZ NOTATION BAG MEMBERSHIPDIAMETER SIGNELECTRIC ARROWHOUSE" +
	"UP ARROWHEADDOWN ARROWHEADPROJECTIVEPERSPECTIVEWAVY LINELEFT CEILINGRIGH" +
	"T CEILINGLEFT FLOORRIGHT FLOORBOTTOM RIGHT CROPBOTTOM LEFT CROPTOP RIGHT" +
	" CROPTOP LEFT CROPREVERSED NOT SIGNSQUARE LOZENGEARCSEGMENTSECTORTELEPHO" +
	"NE RECORDERPOSITION INDICATORVIEWDATA SQUAREPLACE OF INTEREST SIGNTURNED" +
	" NOT SIGNWATCHHOURGLASSTOP LEFT CORNERTOP RIGHT CORNERBOTTOM LEFT CORNER" +
	"BOTTOM RIGHT CORNERTOP HALF INTEGRALBOTTOM HALF INTEGRALFROWNSMILEUP ARR" +
	"OWHEAD BETWEEN TWO HORIZONTAL BARSOPTION KEYERASE TO THE RIGHTX IN A REC" +
	"TANGLE BOXKEYBOARDLEFT-POINTING ANGLE BRACKETRIGHT-POINTING ANGLE BRACKE" +
	"TERASE TO THE LEFTBENZENE RINGCYLINDRICITYALL AROUND-PROFILESYMMETRYTOTA" +
	"L RUNOUTDIMENSION ORIGINCONICAL TAPERSLOPECOUNTERBORECOUNTERSINKAPL FUNC" +
	"TIONAL SYMBOL I-BEAMAPL FUNCTIONAL SYMBOL SQUISH QUADAPL FUNCTIONAL SYMB" +
	"OL QUAD EQUALAPL FUNCTIONAL SYMBOL QUAD DIVIDEAPL FUNCTIONAL SYMBOL QUAD" +
	" DIAMONDAPL FUNCTIONAL SYMBOL QUAD JOTAPL FUNCTIONAL SYMBOL QUAD CIRCLEA" +
	"PL FUNCTIONAL SYMBOL CIRCLE STILEAPL FUNCTIONAL SYMBOL CIRCLE JOTAPL FUN" +
	"CTIONAL SYMBOL SLASH BARAPL FUNCTIONAL SYMBOL BACKSLASH BARAPL FUNCTIONA" +
	"L SYMBOL QUAD SLASHAPL FUNCTIONAL SYMBOL QUAD BACKSLASHAPL FUNCTIONAL SY" +
	"MBOL QUAD LESS-THANAPL FUNCTIONAL SYMBOL QUAD GREATER-THANAPL FUNCTIONAL" +
	" SYMBOL LEFTWARDS VANEAPL FUNCTIONAL SYMBOL RIGHTWARDS VANEAPL FUNCTIONA" +
	"L SYMBOL QUAD LEFTWARDS ARROWAPL FUNCTIONAL SYMBOL QUAD RIGHTWARDS ARROW" +
	"APL FUNCTIONAL SYMBOL CIRCLE BACKSLASHAPL FUNCTIONAL SYMBOL DOWN TACK UN" +
	"DERBARAPL FUNCTIONAL SYMBOL DELTA STILEAPL FUNCTIONAL SYMBOL QUAD DOWN C" +
	"ARETAPL FUNCTIONAL SYMBOL QUAD DELTAAPL FUNCTIONAL SYMBOL DOWN TACK JOTA" +
	"PL FUNCTIONAL SYMBOL UPWARDS VANEAPL FUNCTIONAL SYMBOL QUAD UPWARDS ARRO" +
	"WAPL FUNCTIONAL SYMBOL UP TACK OVERBARAPL FUNCTIONAL SYMBOL DEL STILEAPL" +
	" FUNCTIONAL SYMBOL QUAD UP CARETAPL FUNCTIONAL SYMBOL QUAD DELAPL FUNCTI" +
	"ONAL SYMBOL UP TACK JOTAPL FUNCTIONAL SYMBOL DOWNWARDS VANEAPL FUNCTIONA" +
	"L SYMBOL QUAD DOWNWARDS ARROWAPL FUNCTIONAL SYMBOL QUOTE UNDERBARAPL FUN") + ("" +
	"CTIONAL SYMBOL DELTA UNDERBARAPL FUNCTIONAL SYMBOL DIAMOND UNDERBARAPL F" +
	"UNCTIONAL SYMBOL JOT UNDERBARAPL FUNCTIONAL SYMBOL CIRCLE UNDERBARAPL FU" +
	"NCTIONAL SYMBOL UP SHOE JOTAPL FUNCTIONAL SYMBOL QUOTE QUADAPL FUNCTIONA" +
	"L SYMBOL CIRCLE STARAPL FUNCTIONAL SYMBOL QUAD COLONAPL FUNCTIONAL SYMBO" +
	"L UP TACK DIAERESISAPL FUNCTIONAL SYMBOL DEL DIAERESISAPL FUNCTIONAL SYM" +
	"BOL STAR DIAERESISAPL FUNCTIONAL SYMBOL JOT DIAERESISAPL FUNCTIONAL SYMB" +
	"OL CIRCLE DIAERESISAPL FUNCTIONAL SYMBOL DOWN SHOE STILEAPL FUNCTIONAL S" +
	"YMBOL LEFT SHOE STILEAPL FUNCTIONAL SYMBOL TILDE DIAERESISAPL FUNCTIONAL" +
	" SYMBOL GREATER-THAN DIAERESISAPL FUNCTIONAL SYMBOL COMMA BARAPL FUNCTIO" +
	"NAL SYMBOL DEL TILDEAPL FUNCTIONAL SYMBOL ZILDEAPL FUNCTIONAL SYMBOL STI" +
	"LE TILDEAPL FUNCTIONAL SYMBOL SEMICOLON UNDERBARAPL FUNCTIONAL SYMBOL QU" +
	"AD NOT EQUALAPL FUNCTIONAL SYMBOL QUAD QUESTIONAPL FUNCTIONAL SYMBOL DOW" +
	"N CARET TILDEAPL FUNCTIONAL SYMBOL UP CARET TILDEAPL FUNCTIONAL SYMBOL I" +
	"OTAAPL FUNCTIONAL SYMBOL RHOAPL FUNCTIONAL SYMBOL OMEGAAPL FUNCTIONAL SY" +
	"MBOL ALPHA UNDERBARAPL FUNCTIONAL SYMBOL EPSILON UNDERBARAPL FUNCTIONAL " +
	"SYMBOL IOTA UNDERBARAPL FUNCTIONAL SYMBOL OMEGA UNDERBARAPL FUNCTIONAL S" +
	"YMBOL ALPHANOT CHECK MARKRIGHT ANGLE WITH DOWNWARDS ZIGZAG ARROWSHOULDER" +
	"ED OPEN BOXBELL SYMBOLVERTICAL LINE WITH MIDDLE DOTINSERTION SYMBOLCONTI" +
	"NUOUS UNDERLINE SYMBOLDISCONTINUOUS UNDERLINE SYMBOLEMPHASIS SYMBOLCOMPO" +
	"SITION SYMBOLWHITE SQUARE WITH CENTRE VERTICAL LINEENTER SYMBOLALTERNATI" +
	"VE KEY SYMBOLHELM SYMBOLCIRCLED HORIZONTAL BAR WITH NOTCHCIRCLED TRIANGL" +
	"E DOWNBROKEN CIRCLE WITH NORTHWEST ARROWUNDO SYMBOLMONOSTABLE SYMBOLHYST" +
	"ERESIS SYMBOLOPEN-CIRCUIT-OUTPUT H-TYPE SYMBOLOPEN-CIRCUIT-OUTPUT L-TYPE" +
	" SYMBOLPASSIVE-PULL-DOWN-OUTPUT SYMBOLPASSIVE-PULL-UP-OUTPUT SYMBOLDIREC" +
	"T CURRENT SYMBOL FORM TWOSOFTWARE-FUNCTION SYMBOLAPL FUNCTIONAL SYMBOL Q" +
	"UADDECIMAL SEPARATOR KEY SYMBOLPREVIOUS PAGENEXT PAGEPRINT SCREEN SYMBOL" +
	"CLEAR SCREEN SYMBOLLEFT PARENTHESIS UPPER HOOKLEFT PARENTHESIS EXTENSION" +
	"LEFT PARENTHESIS LOWER HOOKRIGHT PARENTHESIS UPPER HOOKRIGHT PARENTHESIS" +
	" EXTENSIONRIGHT PARENTHESIS LOWER HOOKLEFT SQUARE BRACKET UPPER CORNERLE" +
	"FT SQUARE BRACKET EXTENSIONLEFT SQUARE BRACKET LOWER CORNERRIGHT SQUARE " +
	"BRACKET UPPER CORNERRIGHT SQUARE BRACKET EXTENSIONRIGHT SQUARE BRACKET L" +
	"OWER CORNERLEFT CURLY BRACKET UPPER HOOKLEFT CURLY BRACKET MIDDLE PIECEL" +
	"EFT CURLY BRACKET LOWER HOOKCURLY BRACKET EXTENSIONRIGHT CURLY BRACKET U" +
	"PPER HOOKRIGHT CURLY BRACKET MIDDLE PIECERIGHT CURLY BRACKET LOWER HOOKI" +
	"NTEGRAL EXTENSIONHORIZONTAL LINE EXTENSIONUPPER LEFT OR LOWER RIGHT CURL" +
	"Y BRACKET SECTIONUPPER RIGHT OR LOWER LEFT CURLY BRACKET SECTIONSUMMATIO" +
	"N TOPSUMMATION BOTTOMTOP SQUARE BRACKETBOTTOM SQUARE BRACKETBOTTOM SQUAR" +
	"E BRACKET OVER TOP SQUARE BRACKETRADICAL SYMBOL BOTTOMLEFT VERTICAL BOX " +
	"LINERIGHT VERTICAL BOX LINEHORIZONTAL SCAN LINE-1HORIZONTAL SCAN LINE-3H" +
	"ORIZONTAL SCAN LINE-7HORIZONTAL SCAN LINE-9DENTISTRY SYMBOL LIGHT VERTIC" +
	"AL AND TOP RIGHTDENTISTRY SYMBOL LIGHT VERTICAL AND BOTTOM RIGHTDENTISTR" +
	"Y SYMBOL LIGHT VERTICAL WITH CIRCLEDENTISTRY SYMBOL LIGHT DOWN AND HORIZ" +
	"ONTAL WITH CIRCLEDENTISTRY SYMBOL LIGHT UP AND HORIZONTAL WITH CIRCLEDEN" +
	"TISTRY SYMBOL LIGHT VERTICAL WITH TRIANGLEDENTISTRY SYMBOL LIGHT DOWN AN" +
	"D HORIZONTAL WITH TRIANGLEDENTISTRY SYMBOL LIGHT UP AND HORIZONTAL WITH " +
	"TRIANGLEDENTISTRY SYMBOL LIGHT VERTICAL AND WAVEDENTISTRY SYMBOL LIGHT D" +
	"OWN AND HORIZONTAL WITH WAVEDENTISTRY SYMBOL LIGHT UP AND HORIZONTAL WIT" +
	"H WAVEDENTISTRY SYMBOL LIGHT DOWN AND HORIZONTALDENTISTRY SYMBOL LIGHT U" +
	"P AND HORIZONTALDENTISTRY SYMBOL LIGHT VERTICAL AND TOP LEFTDENTISTRY SY" +
	"MBOL LIGHT VERTICAL AND BOTTOM LEFTSQUARE FOOTRETURN SYMBOLEJECT SYMBOLV" +
	"ERTICAL LINE EXTENSIONMETRICAL BREVEMETRICAL LONG OVER SHORTMETRICAL SHO" +
	"RT OVER LONGMETRICAL LONG OVER TWO SHORTSMETRICAL TWO SHORTS OVER LONGME" +
	"TRICAL TWO SHORTS JOINEDMETRICAL TRISEMEMETRICAL TETRASEMEMETRICAL PENTA" +
	"SEMEEARTH GROUNDFUSETOP PARENTHESISBOTTOM PARENTHESISTOP CURLY BRACKETBO" +
	"TTOM CURLY BRACKETTOP TORTOISE SHELL BRACKETBOTTOM TORTOISE SHELL BRACKE" +
	"TWHITE TRAPEZIUMBENZENE RING WITH CIRCLESTRAIGHTNESSFLATNESSAC CURRENTEL" +
	"ECTRICAL INTERSECTIONDECIMAL EXPONENT SYMBOLBLACK RIGHT-POINTING DOUBLE " +
	"TRIANGLEBLACK LEFT-POINTING DOUBLE TRIANGLEBLACK UP-POINTING DOUBLE TRIA" +
	"NGLEBLACK DOWN-POINTING DOUBLE TRIANGLEBLACK RIGHT-POINTING DOUBLE TRIAN" +
	"GLE WITH VERTICAL BARBLACK LEFT-POINTING DOUBLE TRIANGLE WITH VERTICAL B" +
	"ARBLACK RIGHT-POINTING TRIANGLE WITH DOUBLE VERTICAL BARALARM CLOCKSTOPW" +
	"ATCHTIMER CLOCKHOURGLASS WITH FLOWING SANDBLACK MEDIUM LEFT-POINTING TRI" +
	"ANGLEBLACK MEDIUM RIGHT-POINTING TRIANGLEBLACK MEDIUM UP-POINTING TRIANG" +
	"LEBLACK MEDIUM DOWN-POINTING TRIANGLEDOUBLE VERTICAL BARBLACK SQUARE FOR") + ("" +
	" STOPBLACK CIRCLE FOR RECORDPOWER SYMBOLPOWER ON-OFF SYMBOLPOWER ON SYMB" +
	"OLPOWER SLEEP SYMBOLSYMBOL FOR NULLSYMBOL FOR START OF HEADINGSYMBOL FOR" +
	" START OF TEXTSYMBOL FOR END OF TEXTSYMBOL FOR END OF TRANSMISSIONSYMBOL" +
	" FOR ENQUIRYSYMBOL FOR ACKNOWLEDGESYMBOL FOR BELLSYMBOL FOR BACKSPACESYM" +
	"BOL FOR HORIZONTAL TABULATIONSYMBOL FOR LINE FEEDSYMBOL FOR VERTICAL TAB" +
	"ULATIONSYMBOL FOR FORM FEEDSYMBOL FOR CARRIAGE RETURNSYMBOL FOR SHIFT OU" +
	"TSYMBOL FOR SHIFT INSYMBOL FOR DATA LINK ESCAPESYMBOL FOR DEVICE CONTROL" +
	" ONESYMBOL FOR DEVICE CONTROL TWOSYMBOL FOR DEVICE CONTROL THREESYMBOL F" +
	"OR DEVICE CONTROL FOURSYMBOL FOR NEGATIVE ACKNOWLEDGESYMBOL FOR SYNCHRON" +
	"OUS IDLESYMBOL FOR END OF TRANSMISSION BLOCKSYMBOL FOR CANCELSYMBOL FOR " +
	"END OF MEDIUMSYMBOL FOR SUBSTITUTESYMBOL FOR ESCAPESYMBOL FOR FILE SEPAR" +
	"ATORSYMBOL FOR GROUP SEPARATORSYMBOL FOR RECORD SEPARATORSYMBOL FOR UNIT" +
	" SEPARATORSYMBOL FOR SPACESYMBOL FOR DELETEBLANK SYMBOLOPEN BOXSYMBOL FO" +
	"R NEWLINESYMBOL FOR DELETE FORM TWOSYMBOL FOR SUBSTITUTE FORM TWOOCR HOO" +
	"KOCR CHAIROCR FORKOCR INVERTED FORKOCR BELT BUCKLEOCR BOW TIEOCR BRANCH " +
	"BANK IDENTIFICATIONOCR AMOUNT OF CHECKOCR DASHOCR CUSTOMER ACCOUNT NUMBE" +
	"ROCR DOUBLE BACKSLASHCIRCLED DIGIT ONECIRCLED DIGIT TWOCIRCLED DIGIT THR" +
	"EECIRCLED DIGIT FOURCIRCLED DIGIT FIVECIRCLED DIGIT SIXCIRCLED DIGIT SEV" +
	"ENCIRCLED DIGIT EIGHTCIRCLED DIGIT NINECIRCLED NUMBER TENCIRCLED NUMBER " +
	"ELEVENCIRCLED NUMBER TWELVECIRCLED NUMBER THIRTEENCIRCLED NUMBER FOURTEE" +
	"NCIRCLED NUMBER FIFTEENCIRCLED NUMBER SIXTEENCIRCLED NUMBER SEVENTEENCIR" +
	"CLED NUMBER EIGHTEENCIRCLED NUMBER NINETEENCIRCLED NUMBER TWENTYPARENTHE" +
	"SIZED DIGIT ONEPARENTHESIZED DIGIT TWOPARENTHESIZED DIGIT THREEPARENTHES" +
	"IZED DIGIT FOURPARENTHESIZED DIGIT FIVEPARENTHESIZED DIGIT SIXPARENTHESI" +
	"ZED DIGIT SEVENPARENTHESIZED DIGIT EIGHTPARENTHESIZED DIGIT NINEPARENTHE" +
	"SIZED NUMBER TENPARENTHESIZED NUMBER ELEVENPARENTHESIZED NUMBER TWELVEPA" +
	"RENTHESIZED NUMBER THIRTEENPARENTHESIZED NUMBER FOURTEENPARENTHESIZED NU" +
	"MBER FIFTEENPARENTHESIZED NUMBER SIXTEENPARENTHESIZED NUMBER SEVENTEENPA" +
	"RENTHESIZED NUMBER EIGHTEENPARENTHESIZED NUMBER NINETEENPARENTHESIZED NU" +
	"MBER TWENTYDIGIT ONE FULL STOPDIGIT TWO FULL STOPDIGIT THREE FULL STOPDI" +
	"GIT FOUR FULL STOPDIGIT FIVE FULL STOPDIGIT SIX FULL STOPDIGIT SEVEN FUL" +
	"L STOPDIGIT EIGHT FULL STOPDIGIT NINE FULL STOPNUMBER TEN FULL STOPNUMBE" +
	"R ELEVEN FULL STOPNUMBER TWELVE FULL STOPNUMBER THIRTEEN FULL STOPNUMBER" +
	" FOURTEEN FULL STOPNUMBER FIFTEEN FULL STOPNUMBER SIXTEEN FULL STOPNUMBE" +
	"R SEVENTEEN FULL STOPNUMBER EIGHTEEN FULL STOPNUMBER NINETEEN FULL STOPN" +
	"UMBER TWENTY FULL STOPPARENTHESIZED LATIN SMALL LETTER APARENTHESIZED LA" +
	"TIN SMALL LETTER BPARENTHESIZED LATIN SMALL LETTER CPARENTHESIZED LATIN " +
	"SMALL LETTER DPARENTHESIZED LATIN SMALL LETTER EPARENTHESIZED LATIN SMAL" +
	"L LETTER FPARENTHESIZED LATIN SMALL LETTER GPARENTHESIZED LATIN SMALL LE" +
	"TTER HPARENTHESIZED LATIN SMALL LETTER IPARENTHESIZED LATIN SMALL LETTER" +
	" JPARENTHESIZED LATIN SMALL LETTER KPARENTHESIZED LATIN SMALL LETTER LPA" +
	"RENTHESIZED LATIN SMALL LETTER MPARENTHESIZED LATIN SMALL LETTER NPARENT" +
	"HESIZED LATIN SMALL LETTER OPARENTHESIZED LATIN SMALL LETTER PPARENTHESI" +
	"ZED LATIN SMALL LETTER QPARENTHESIZED LATIN SMALL LETTER RPARENTHESIZED " +
	"LATIN SMALL LETTER SPARENTHESIZED LATIN SMALL LETTER TPARENTHESIZED LATI" +
	"N SMALL LETTER UPARENTHESIZED LATIN SMALL LETTER VPARENTHESIZED LATIN SM" +
	"ALL LETTER WPARENTHESIZED LATIN SMALL LETTER XPARENTHESIZED LATIN SMALL " +
	"LETTER YPARENTHESIZED LATIN SMALL LETTER ZCIRCLED LATIN CAPITAL LETTER A" +
	"CIRCLED LATIN CAPITAL LETTER BCIRCLED LATIN CAPITAL LETTER CCIRCLED LATI" +
	"N CAPITAL LETTER DCIRCLED LATIN CAPITAL LETTER ECIRCLED LATIN CAPITAL LE" +
	"TTER FCIRCLED LATIN CAPITAL LETTER GCIRCLED LATIN CAPITAL LETTER HCIRCLE" +
	"D LATIN CAPITAL LETTER ICIRCLED LATIN CAPITAL LETTER JCIRCLED LATIN CAPI" +
	"TAL LETTER KCIRCLED LATIN CAPITAL LETTER LCIRCLED LATIN CAPITAL LETTER M" +
	"CIRCLED LATIN CAPITAL LETTER NCIRCLED LATIN CAPITAL LETTER OCIRCLED LATI" +
	"N CAPITAL LETTER PCIRCLED LATIN CAPITAL LETTER QCIRCLED LATIN CAPITAL LE" +
	"TTER RCIRCLED LATIN CAPITAL LETTER SCIRCLED LATIN CAPITAL LETTER TCIRCLE" +
	"D LATIN CAPITAL LETTER UCIRCLED LATIN CAPITAL LETTER VCIRCLED LATIN CAPI" +
	"TAL LETTER WCIRCLED LATIN CAPITAL LETTER XCIRCLED LATIN CAPITAL LETTER Y" +
	"CIRCLED LATIN CAPITAL LETTER ZCIRCLED LATIN SMALL LETTER ACIRCLED LATIN " +
	"SMALL LETTER BCIRCLED LATIN SMALL LETTER CCIRCLED LATIN SMALL LETTER DCI" +
	"RCLED LATIN SMALL LETTER ECIRCLED LATIN SMALL LETTER FCIRCLED LATIN SMAL" +
	"L LETTER GCIRCLED LATIN SMALL LETTER HCIRCLED LATIN SMALL LETTER ICIRCLE" +
	"D LATIN SMALL LETTER JCIRCLED LATIN SMALL LETTER KCIRCLED LATIN SMALL LE" +
	"TTER LCIRCLED LATIN SMALL LETTER MCIRCLED LATIN SMALL LETTER NCIRCLED LA") + ("" +
	"TIN SMALL LETTER OCIRCLED LATIN SMALL LETTER PCIRCLED LATIN SMALL LETTER" +
	" QCIRCLED LATIN SMALL LETTER RCIRCLED LATIN SMALL LETTER SCIRCLED LATIN " +
	"SMALL LETTER TCIRCLED LATIN SMALL LETTER UCIRCLED LATIN SMALL LETTER VCI" +
	"RCLED LATIN SMALL LETTER WCIRCLED LATIN SMALL LETTER XCIRCLED LATIN SMAL" +
	"L LETTER YCIRCLED LATIN SMALL LETTER ZCIRCLED DIGIT ZERONEGATIVE CIRCLED" +
	" NUMBER ELEVENNEGATIVE CIRCLED NUMBER TWELVENEGATIVE CIRCLED NUMBER THIR" +
	"TEENNEGATIVE CIRCLED NUMBER FOURTEENNEGATIVE CIRCLED NUMBER FIFTEENNEGAT" +
	"IVE CIRCLED NUMBER SIXTEENNEGATIVE CIRCLED NUMBER SEVENTEENNEGATIVE CIRC" +
	"LED NUMBER EIGHTEENNEGATIVE CIRCLED NUMBER NINETEENNEGATIVE CIRCLED NUMB" +
	"ER TWENTYDOUBLE CIRCLED DIGIT ONEDOUBLE CIRCLED DIGIT TWODOUBLE CIRCLED " +
	"DIGIT THREEDOUBLE CIRCLED DIGIT FOURDOUBLE CIRCLED DIGIT FIVEDOUBLE CIRC" +
	"LED DIGIT SIXDOUBLE CIRCLED DIGIT SEVENDOUBLE CIRCLED DIGIT EIGHTDOUBLE " +
	"CIRCLED DIGIT NINEDOUBLE CIRCLED NUMBER TENNEGATIVE CIRCLED DIGIT ZEROBO" +
	"X DRAWINGS LIGHT HORIZONTALBOX DRAWINGS HEAVY HORIZONTALBOX DRAWINGS LIG" +
	"HT VERTICALBOX DRAWINGS HEAVY VERTICALBOX DRAWINGS LIGHT TRIPLE DASH HOR" +
	"IZONTALBOX DRAWINGS HEAVY TRIPLE DASH HORIZONTALBOX DRAWINGS LIGHT TRIPL" +
	"E DASH VERTICALBOX DRAWINGS HEAVY TRIPLE DASH VERTICALBOX DRAWINGS LIGHT" +
	" QUADRUPLE DASH HORIZONTALBOX DRAWINGS HEAVY QUADRUPLE DASH HORIZONTALBO" +
	"X DRAWINGS LIGHT QUADRUPLE DASH VERTICALBOX DRAWINGS HEAVY QUADRUPLE DAS" +
	"H VERTICALBOX DRAWINGS LIGHT DOWN AND RIGHTBOX DRAWINGS DOWN LIGHT AND R" +
	"IGHT HEAVYBOX DRAWINGS DOWN HEAVY AND RIGHT LIGHTBOX DRAWINGS HEAVY DOWN" +
	" AND RIGHTBOX DRAWINGS LIGHT DOWN AND LEFTBOX DRAWINGS DOWN LIGHT AND LE" +
	"FT HEAVYBOX DRAWINGS DOWN HEAVY AND LEFT LIGHTBOX DRAWINGS HEAVY DOWN AN" +
	"D LEFTBOX DRAWINGS LIGHT UP AND RIGHTBOX DRAWINGS UP LIGHT AND RIGHT HEA" +
	"VYBOX DRAWINGS UP HEAVY AND RIGHT LIGHTBOX DRAWINGS HEAVY UP AND RIGHTBO" +
	"X DRAWINGS LIGHT UP AND LEFTBOX DRAWINGS UP LIGHT AND LEFT HEAVYBOX DRAW" +
	"INGS UP HEAVY AND LEFT LIGHTBOX DRAWINGS HEAVY UP AND LEFTBOX DRAWINGS L" +
	"IGHT VERTICAL AND RIGHTBOX DRAWINGS VERTICAL LIGHT AND RIGHT HEAVYBOX DR" +
	"AWINGS UP HEAVY AND RIGHT DOWN LIGHTBOX DRAWINGS DOWN HEAVY AND RIGHT UP" +
	" LIGHTBOX DRAWINGS VERTICAL HEAVY AND RIGHT LIGHTBOX DRAWINGS DOWN LIGHT" +
	" AND RIGHT UP HEAVYBOX DRAWINGS UP LIGHT AND RIGHT DOWN HEAVYBOX DRAWING" +
	"S HEAVY VERTICAL AND RIGHTBOX DRAWINGS LIGHT VERTICAL AND LEFTBOX DRAWIN" +
	"GS VERTICAL LIGHT AND LEFT HEAVYBOX DRAWINGS UP HEAVY AND LEFT DOWN LIGH" +
	"TBOX DRAWINGS DOWN HEAVY AND LEFT UP LIGHTBOX DRAWINGS VERTICAL HEAVY AN" +
	"D LEFT LIGHTBOX DRAWINGS DOWN LIGHT AND LEFT UP HEAVYBOX DRAWINGS UP LIG" +
	"HT AND LEFT DOWN HEAVYBOX DRAWINGS HEAVY VERTICAL AND LEFTBOX DRAWINGS L" +
	"IGHT DOWN AND HORIZONTALBOX DRAWINGS LEFT HEAVY AND RIGHT DOWN LIGHTBOX " +
	"DRAWINGS RIGHT HEAVY AND LEFT DOWN LIGHTBOX DRAWINGS DOWN LIGHT AND HORI" +
	"ZONTAL HEAVYBOX DRAWINGS DOWN HEAVY AND HORIZONTAL LIGHTBOX DRAWINGS RIG" +
	"HT LIGHT AND LEFT DOWN HEAVYBOX DRAWINGS LEFT LIGHT AND RIGHT DOWN HEAVY" +
	"BOX DRAWINGS HEAVY DOWN AND HORIZONTALBOX DRAWINGS LIGHT UP AND HORIZONT" +
	"ALBOX DRAWINGS LEFT HEAVY AND RIGHT UP LIGHTBOX DRAWINGS RIGHT HEAVY AND" +
	" LEFT UP LIGHTBOX DRAWINGS UP LIGHT AND HORIZONTAL HEAVYBOX DRAWINGS UP " +
	"HEAVY AND HORIZONTAL LIGHTBOX DRAWINGS RIGHT LIGHT AND LEFT UP HEAVYBOX " +
	"DRAWINGS LEFT LIGHT AND RIGHT UP HEAVYBOX DRAWINGS HEAVY UP AND HORIZONT" +
	"ALBOX DRAWINGS LIGHT VERTICAL AND HORIZONTALBOX DRAWINGS LEFT HEAVY AND " +
	"RIGHT VERTICAL LIGHTBOX DRAWINGS RIGHT HEAVY AND LEFT VERTICAL LIGHTBOX " +
	"DRAWINGS VERTICAL LIGHT AND HORIZONTAL HEAVYBOX DRAWINGS UP HEAVY AND DO" +
	"WN HORIZONTAL LIGHTBOX DRAWINGS DOWN HEAVY AND UP HORIZONTAL LIGHTBOX DR" +
	"AWINGS VERTICAL HEAVY AND HORIZONTAL LIGHTBOX DRAWINGS LEFT UP HEAVY AND" +
	" RIGHT DOWN LIGHTBOX DRAWINGS RIGHT UP HEAVY AND LEFT DOWN LIGHTBOX DRAW" +
	"INGS LEFT DOWN HEAVY AND RIGHT UP LIGHTBOX DRAWINGS RIGHT DOWN HEAVY AND" +
	" LEFT UP LIGHTBOX DRAWINGS DOWN LIGHT AND UP HORIZONTAL HEAVYBOX DRAWING" +
	"S UP LIGHT AND DOWN HORIZONTAL HEAVYBOX DRAWINGS RIGHT LIGHT AND LEFT VE" +
	"RTICAL HEAVYBOX DRAWINGS LEFT LIGHT AND RIGHT VERTICAL HEAVYBOX DRAWINGS" +
	" HEAVY VERTICAL AND HORIZONTALBOX DRAWINGS LIGHT DOUBLE DASH HORIZONTALB" +
	"OX DRAWINGS HEAVY DOUBLE DASH HORIZONTALBOX DRAWINGS LIGHT DOUBLE DASH V" +
	"ERTICALBOX DRAWINGS HEAVY DOUBLE DASH VERTICALBOX DRAWINGS DOUBLE HORIZO" +
	"NTALBOX DRAWINGS DOUBLE VERTICALBOX DRAWINGS DOWN SINGLE AND RIGHT DOUBL" +
	"EBOX DRAWINGS DOWN DOUBLE AND RIGHT SINGLEBOX DRAWINGS DOUBLE DOWN AND R" +
	"IGHTBOX DRAWINGS DOWN SINGLE AND LEFT DOUBLEBOX DRAWINGS DOWN DOUBLE AND" +
	" LEFT SINGLEBOX DRAWINGS DOUBLE DOWN AND LEFTBOX DRAWINGS UP SINGLE AND " +
	"RIGHT DOUBLEBOX DRAWINGS UP DOUBLE AND RIGHT SINGLEBOX DRAWINGS DOUBLE U" +
	"P AND RIGHTBOX DRAWINGS UP SINGLE AND LEFT DOUBLEBOX DRAWINGS UP DOUBLE ") + ("" +
	"AND LEFT SINGLEBOX DRAWINGS DOUBLE UP AND LEFTBOX DRAWINGS VERTICAL SING" +
	"LE AND RIGHT DOUBLEBOX DRAWINGS VERTICAL DOUBLE AND RIGHT SINGLEBOX DRAW" +
	"INGS DOUBLE VERTICAL AND RIGHTBOX DRAWINGS VERTICAL SINGLE AND LEFT DOUB" +
	"LEBOX DRAWINGS VERTICAL DOUBLE AND LEFT SINGLEBOX DRAWINGS DOUBLE VERTIC" +
	"AL AND LEFTBOX DRAWINGS DOWN SINGLE AND HORIZONTAL DOUBLEBOX DRAWINGS DO" +
	"WN DOUBLE AND HORIZONTAL SINGLEBOX DRAWINGS DOUBLE DOWN AND HORIZONTALBO" +
	"X DRAWINGS UP SINGLE AND HORIZONTAL DOUBLEBOX DRAWINGS UP DOUBLE AND HOR" +
	"IZONTAL SINGLEBOX DRAWINGS DOUBLE UP AND HORIZONTALBOX DRAWINGS VERTICAL" +
	" SINGLE AND HORIZONTAL DOUBLEBOX DRAWINGS VERTICAL DOUBLE AND HORIZONTAL" +
	" SINGLEBOX DRAWINGS DOUBLE VERTICAL AND HORIZONTALBOX DRAWINGS LIGHT ARC" +
	" DOWN AND RIGHTBOX DRAWINGS LIGHT ARC DOWN AND LEFTBOX DRAWINGS LIGHT AR" +
	"C UP AND LEFTBOX DRAWINGS LIGHT ARC UP AND RIGHTBOX DRAWINGS LIGHT DIAGO" +
	"NAL UPPER RIGHT TO LOWER LEFTBOX DRAWINGS LIGHT DIAGONAL UPPER LEFT TO L" +
	"OWER RIGHTBOX DRAWINGS LIGHT DIAGONAL CROSSBOX DRAWINGS LIGHT LEFTBOX DR" +
	"AWINGS LIGHT UPBOX DRAWINGS LIGHT RIGHTBOX DRAWINGS LIGHT DOWNBOX DRAWIN" +
	"GS HEAVY LEFTBOX DRAWINGS HEAVY UPBOX DRAWINGS HEAVY RIGHTBOX DRAWINGS H" +
	"EAVY DOWNBOX DRAWINGS LIGHT LEFT AND HEAVY RIGHTBOX DRAWINGS LIGHT UP AN" +
	"D HEAVY DOWNBOX DRAWINGS HEAVY LEFT AND LIGHT RIGHTBOX DRAWINGS HEAVY UP" +
	" AND LIGHT DOWNUPPER HALF BLOCKLOWER ONE EIGHTH BLOCKLOWER ONE QUARTER B" +
	"LOCKLOWER THREE EIGHTHS BLOCKLOWER HALF BLOCKLOWER FIVE EIGHTHS BLOCKLOW" +
	"ER THREE QUARTERS BLOCKLOWER SEVEN EIGHTHS BLOCKFULL BLOCKLEFT SEVEN EIG" +
	"HTHS BLOCKLEFT THREE QUARTERS BLOCKLEFT FIVE EIGHTHS BLOCKLEFT HALF BLOC" +
	"KLEFT THREE EIGHTHS BLOCKLEFT ONE QUARTER BLOCKLEFT ONE EIGHTH BLOCKRIGH" +
	"T HALF BLOCKLIGHT SHADEMEDIUM SHADEDARK SHADEUPPER ONE EIGHTH BLOCKRIGHT" +
	" ONE EIGHTH BLOCKQUADRANT LOWER LEFTQUADRANT LOWER RIGHTQUADRANT UPPER L" +
	"EFTQUADRANT UPPER LEFT AND LOWER LEFT AND LOWER RIGHTQUADRANT UPPER LEFT" +
	" AND LOWER RIGHTQUADRANT UPPER LEFT AND UPPER RIGHT AND LOWER LEFTQUADRA" +
	"NT UPPER LEFT AND UPPER RIGHT AND LOWER RIGHTQUADRANT UPPER RIGHTQUADRAN" +
	"T UPPER RIGHT AND LOWER LEFTQUADRANT UPPER RIGHT AND LOWER LEFT AND LOWE" +
	"R RIGHTBLACK SQUAREWHITE SQUAREWHITE SQUARE WITH ROUNDED CORNERSWHITE SQ" +
	"UARE CONTAINING BLACK SMALL SQUARESQUARE WITH HORIZONTAL FILLSQUARE WITH" +
	" VERTICAL FILLSQUARE WITH ORTHOGONAL CROSSHATCH FILLSQUARE WITH UPPER LE" +
	"FT TO LOWER RIGHT FILLSQUARE WITH UPPER RIGHT TO LOWER LEFT FILLSQUARE W" +
	"ITH DIAGONAL CROSSHATCH FILLBLACK SMALL SQUAREWHITE SMALL SQUAREBLACK RE" +
	"CTANGLEWHITE RECTANGLEBLACK VERTICAL RECTANGLEWHITE VERTICAL RECTANGLEBL" +
	"ACK PARALLELOGRAMWHITE PARALLELOGRAMBLACK UP-POINTING TRIANGLEWHITE UP-P" +
	"OINTING TRIANGLEBLACK UP-POINTING SMALL TRIANGLEWHITE UP-POINTING SMALL " +
	"TRIANGLEBLACK RIGHT-POINTING TRIANGLEWHITE RIGHT-POINTING TRIANGLEBLACK " +
	"RIGHT-POINTING SMALL TRIANGLEWHITE RIGHT-POINTING SMALL TRIANGLEBLACK RI" +
	"GHT-POINTING POINTERWHITE RIGHT-POINTING POINTERBLACK DOWN-POINTING TRIA" +
	"NGLEWHITE DOWN-POINTING TRIANGLEBLACK DOWN-POINTING SMALL TRIANGLEWHITE " +
	"DOWN-POINTING SMALL TRIANGLEBLACK LEFT-POINTING TRIANGLEWHITE LEFT-POINT" +
	"ING TRIANGLEBLACK LEFT-POINTING SMALL TRIANGLEWHITE LEFT-POINTING SMALL " +
	"TRIANGLEBLACK LEFT-POINTING POINTERWHITE LEFT-POINTING POINTERBLACK DIAM" +
	"ONDWHITE DIAMONDWHITE DIAMOND CONTAINING BLACK SMALL DIAMONDFISHEYELOZEN" +
	"GEWHITE CIRCLEDOTTED CIRCLECIRCLE WITH VERTICAL FILLBULLSEYEBLACK CIRCLE" +
	"CIRCLE WITH LEFT HALF BLACKCIRCLE WITH RIGHT HALF BLACKCIRCLE WITH LOWER" +
	" HALF BLACKCIRCLE WITH UPPER HALF BLACKCIRCLE WITH UPPER RIGHT QUADRANT " +
	"BLACKCIRCLE WITH ALL BUT UPPER LEFT QUADRANT BLACKLEFT HALF BLACK CIRCLE" +
	"RIGHT HALF BLACK CIRCLEINVERSE BULLETINVERSE WHITE CIRCLEUPPER HALF INVE" +
	"RSE WHITE CIRCLELOWER HALF INVERSE WHITE CIRCLEUPPER LEFT QUADRANT CIRCU" +
	"LAR ARCUPPER RIGHT QUADRANT CIRCULAR ARCLOWER RIGHT QUADRANT CIRCULAR AR" +
	"CLOWER LEFT QUADRANT CIRCULAR ARCUPPER HALF CIRCLELOWER HALF CIRCLEBLACK" +
	" LOWER RIGHT TRIANGLEBLACK LOWER LEFT TRIANGLEBLACK UPPER LEFT TRIANGLEB" +
	"LACK UPPER RIGHT TRIANGLEWHITE BULLETSQUARE WITH LEFT HALF BLACKSQUARE W" +
	"ITH RIGHT HALF BLACKSQUARE WITH UPPER LEFT DIAGONAL HALF BLACKSQUARE WIT" +
	"H LOWER RIGHT DIAGONAL HALF BLACKWHITE SQUARE WITH VERTICAL BISECTING LI" +
	"NEWHITE UP-POINTING TRIANGLE WITH DOTUP-POINTING TRIANGLE WITH LEFT HALF" +
	" BLACKUP-POINTING TRIANGLE WITH RIGHT HALF BLACKLARGE CIRCLEWHITE SQUARE" +
	" WITH UPPER LEFT QUADRANTWHITE SQUARE WITH LOWER LEFT QUADRANTWHITE SQUA" +
	"RE WITH LOWER RIGHT QUADRANTWHITE SQUARE WITH UPPER RIGHT QUADRANTWHITE " +
	"CIRCLE WITH UPPER LEFT QUADRANTWHITE CIRCLE WITH LOWER LEFT QUADRANTWHIT" +
	"E CIRCLE WITH LOWER RIGHT QUADRANTWHITE CIRCLE WITH UPPER RIGHT QUADRANT" +
	"UPPER LEFT TRIANGLEUPPER RIGHT TRIANGLELOWER LEFT TRIANGLEWHITE MEDIUM S") + ("" +
	"QUAREBLACK MEDIUM SQUAREWHITE MEDIUM SMALL SQUAREBLACK MEDIUM SMALL SQUA" +
	"RELOWER RIGHT TRIANGLEBLACK SUN WITH RAYSCLOUDUMBRELLASNOWMANCOMETBLACK " +
	"STARWHITE STARLIGHTNINGTHUNDERSTORMSUNASCENDING NODEDESCENDING NODECONJU" +
	"NCTIONOPPOSITIONBLACK TELEPHONEWHITE TELEPHONEBALLOT BOXBALLOT BOX WITH " +
	"CHECKBALLOT BOX WITH XSALTIREUMBRELLA WITH RAIN DROPSHOT BEVERAGEWHITE S" +
	"HOGI PIECEBLACK SHOGI PIECESHAMROCKREVERSED ROTATED FLORAL HEART BULLETB" +
	"LACK LEFT POINTING INDEXBLACK RIGHT POINTING INDEXWHITE LEFT POINTING IN" +
	"DEXWHITE UP POINTING INDEXWHITE RIGHT POINTING INDEXWHITE DOWN POINTING " +
	"INDEXSKULL AND CROSSBONESCAUTION SIGNRADIOACTIVE SIGNBIOHAZARD SIGNCADUC" +
	"EUSANKHORTHODOX CROSSCHI RHOCROSS OF LORRAINECROSS OF JERUSALEMSTAR AND " +
	"CRESCENTFARSI SYMBOLADI SHAKTIHAMMER AND SICKLEPEACE SYMBOLYIN YANGTRIGR" +
	"AM FOR HEAVENTRIGRAM FOR LAKETRIGRAM FOR FIRETRIGRAM FOR THUNDERTRIGRAM " +
	"FOR WINDTRIGRAM FOR WATERTRIGRAM FOR MOUNTAINTRIGRAM FOR EARTHWHEEL OF D" +
	"HARMAWHITE FROWNING FACEWHITE SMILING FACEBLACK SMILING FACEWHITE SUN WI" +
	"TH RAYSFIRST QUARTER MOONLAST QUARTER MOONMERCURYFEMALE SIGNEARTHMALE SI" +
	"GNJUPITERSATURNURANUSNEPTUNEPLUTOARIESTAURUSGEMINICANCERLEOVIRGOLIBRASCO" +
	"RPIUSSAGITTARIUSCAPRICORNAQUARIUSPISCESWHITE CHESS KINGWHITE CHESS QUEEN" +
	"WHITE CHESS ROOKWHITE CHESS BISHOPWHITE CHESS KNIGHTWHITE CHESS PAWNBLAC" +
	"K CHESS KINGBLACK CHESS QUEENBLACK CHESS ROOKBLACK CHESS BISHOPBLACK CHE" +
	"SS KNIGHTBLACK CHESS PAWNBLACK SPADE SUITWHITE HEART SUITWHITE DIAMOND S" +
	"UITBLACK CLUB SUITWHITE SPADE SUITBLACK HEART SUITBLACK DIAMOND SUITWHIT" +
	"E CLUB SUITHOT SPRINGSQUARTER NOTEEIGHTH NOTEBEAMED EIGHTH NOTESBEAMED S" +
	"IXTEENTH NOTESMUSIC FLAT SIGNMUSIC NATURAL SIGNMUSIC SHARP SIGNWEST SYRI" +
	"AC CROSSEAST SYRIAC CROSSUNIVERSAL RECYCLING SYMBOLRECYCLING SYMBOL FOR " +
	"TYPE-1 PLASTICSRECYCLING SYMBOL FOR TYPE-2 PLASTICSRECYCLING SYMBOL FOR " +
	"TYPE-3 PLASTICSRECYCLING SYMBOL FOR TYPE-4 PLASTICSRECYCLING SYMBOL FOR " +
	"TYPE-5 PLASTICSRECYCLING SYMBOL FOR TYPE-6 PLASTICSRECYCLING SYMBOL FOR " +
	"TYPE-7 PLASTICSRECYCLING SYMBOL FOR GENERIC MATERIALSBLACK UNIVERSAL REC" +
	"YCLING SYMBOLRECYCLED PAPER SYMBOLPARTIALLY-RECYCLED PAPER SYMBOLPERMANE" +
	"NT PAPER SIGNWHEELCHAIR SYMBOLDIE FACE-1DIE FACE-2DIE FACE-3DIE FACE-4DI" +
	"E FACE-5DIE FACE-6WHITE CIRCLE WITH DOT RIGHTWHITE CIRCLE WITH TWO DOTSB" +
	"LACK CIRCLE WITH WHITE DOT RIGHTBLACK CIRCLE WITH TWO WHITE DOTSMONOGRAM" +
	" FOR YANGMONOGRAM FOR YINDIGRAM FOR GREATER YANGDIGRAM FOR LESSER YINDIG" +
	"RAM FOR LESSER YANGDIGRAM FOR GREATER YINWHITE FLAGBLACK FLAGHAMMER AND " +
	"PICKANCHORCROSSED SWORDSSTAFF OF AESCULAPIUSSCALESALEMBICFLOWERGEARSTAFF" +
	" OF HERMESATOM SYMBOLFLEUR-DE-LISOUTLINED WHITE STARTHREE LINES CONVERGI" +
	"NG RIGHTTHREE LINES CONVERGING LEFTWARNING SIGNHIGH VOLTAGE SIGNDOUBLED " +
	"FEMALE SIGNDOUBLED MALE SIGNINTERLOCKED FEMALE AND MALE SIGNMALE AND FEM" +
	"ALE SIGNMALE WITH STROKE SIGNMALE WITH STROKE AND MALE AND FEMALE SIGNVE" +
	"RTICAL MALE WITH STROKE SIGNHORIZONTAL MALE WITH STROKE SIGNMEDIUM WHITE" +
	" CIRCLEMEDIUM BLACK CIRCLEMEDIUM SMALL WHITE CIRCLEMARRIAGE SYMBOLDIVORC" +
	"E SYMBOLUNMARRIED PARTNERSHIP SYMBOLCOFFINFUNERAL URNNEUTERCERESPALLASJU" +
	"NOVESTACHIRONBLACK MOON LILITHSEXTILESEMISEXTILEQUINCUNXSESQUIQUADRATESO" +
	"CCER BALLBASEBALLSQUARED KEYWHITE DRAUGHTS MANWHITE DRAUGHTS KINGBLACK D" +
	"RAUGHTS MANBLACK DRAUGHTS KINGSNOWMAN WITHOUT SNOWSUN BEHIND CLOUDRAINBL" +
	"ACK SNOWMANTHUNDER CLOUD AND RAINTURNED WHITE SHOGI PIECETURNED BLACK SH" +
	"OGI PIECEWHITE DIAMOND IN SQUARECROSSING LANESDISABLED CAROPHIUCHUSPICKC" +
	"AR SLIDINGHELMET WITH WHITE CROSSCIRCLED CROSSING LANESCHAINSNO ENTRYALT" +
	"ERNATE ONE-WAY LEFT WAY TRAFFICBLACK TWO-WAY LEFT WAY TRAFFICWHITE TWO-W" +
	"AY LEFT WAY TRAFFICBLACK LEFT LANE MERGEWHITE LEFT LANE MERGEDRIVE SLOW " +
	"SIGNHEAVY WHITE DOWN-POINTING TRIANGLELEFT CLOSED ENTRYSQUARED SALTIREFA" +
	"LLING DIAGONAL IN WHITE CIRCLE IN BLACK SQUAREBLACK TRUCKRESTRICTED LEFT" +
	" ENTRY-1RESTRICTED LEFT ENTRY-2ASTRONOMICAL SYMBOL FOR URANUSHEAVY CIRCL" +
	"E WITH STROKE AND TWO DOTS ABOVEPENTAGRAMRIGHT-HANDED INTERLACED PENTAGR" +
	"AMLEFT-HANDED INTERLACED PENTAGRAMINVERTED PENTAGRAMBLACK CROSS ON SHIEL" +
	"DSHINTO SHRINECHURCHCASTLEHISTORIC SITEGEAR WITHOUT HUBGEAR WITH HANDLES" +
	"MAP SYMBOL FOR LIGHTHOUSEMOUNTAINUMBRELLA ON GROUNDFOUNTAINFLAG IN HOLEF" +
	"ERRYSAILBOATSQUARE FOUR CORNERSSKIERICE SKATEPERSON WITH BALLTENTJAPANES" +
	"E BANK SYMBOLHEADSTONE GRAVEYARD SYMBOLFUEL PUMPCUP ON BLACK SQUAREWHITE" +
	" FLAG WITH HORIZONTAL MIDDLE BLACK STRIPEBLACK SAFETY SCISSORSUPPER BLAD" +
	"E SCISSORSBLACK SCISSORSLOWER BLADE SCISSORSWHITE SCISSORSWHITE HEAVY CH" +
	"ECK MARKTELEPHONE LOCATION SIGNTAPE DRIVEAIRPLANEENVELOPERAISED FISTRAIS" +
	"ED HANDVICTORY HANDWRITING HANDLOWER RIGHT PENCILPENCILUPPER RIGHT PENCI" +
	"LWHITE NIBBLACK NIBCHECK MARKHEAVY CHECK MARKMULTIPLICATION XHEAVY MULTI") + ("" +
	"PLICATION XBALLOT XHEAVY BALLOT XOUTLINED GREEK CROSSHEAVY GREEK CROSSOP" +
	"EN CENTRE CROSSHEAVY OPEN CENTRE CROSSLATIN CROSSSHADOWED WHITE LATIN CR" +
	"OSSOUTLINED LATIN CROSSMALTESE CROSSSTAR OF DAVIDFOUR TEARDROP-SPOKED AS" +
	"TERISKFOUR BALLOON-SPOKED ASTERISKHEAVY FOUR BALLOON-SPOKED ASTERISKFOUR" +
	" CLUB-SPOKED ASTERISKBLACK FOUR POINTED STARWHITE FOUR POINTED STARSPARK" +
	"LESSTRESS OUTLINED WHITE STARCIRCLED WHITE STAROPEN CENTRE BLACK STARBLA" +
	"CK CENTRE WHITE STAROUTLINED BLACK STARHEAVY OUTLINED BLACK STARPINWHEEL" +
	" STARSHADOWED WHITE STARHEAVY ASTERISKOPEN CENTRE ASTERISKEIGHT SPOKED A" +
	"STERISKEIGHT POINTED BLACK STAREIGHT POINTED PINWHEEL STARSIX POINTED BL" +
	"ACK STAREIGHT POINTED RECTILINEAR BLACK STARHEAVY EIGHT POINTED RECTILIN" +
	"EAR BLACK STARTWELVE POINTED BLACK STARSIXTEEN POINTED ASTERISKTEARDROP-" +
	"SPOKED ASTERISKOPEN CENTRE TEARDROP-SPOKED ASTERISKHEAVY TEARDROP-SPOKED" +
	" ASTERISKSIX PETALLED BLACK AND WHITE FLORETTEBLACK FLORETTEWHITE FLORET" +
	"TEEIGHT PETALLED OUTLINED BLACK FLORETTECIRCLED OPEN CENTRE EIGHT POINTE" +
	"D STARHEAVY TEARDROP-SPOKED PINWHEEL ASTERISKSNOWFLAKETIGHT TRIFOLIATE S" +
	"NOWFLAKEHEAVY CHEVRON SNOWFLAKESPARKLEHEAVY SPARKLEBALLOON-SPOKED ASTERI" +
	"SKEIGHT TEARDROP-SPOKED PROPELLER ASTERISKHEAVY EIGHT TEARDROP-SPOKED PR" +
	"OPELLER ASTERISKCROSS MARKSHADOWED WHITE CIRCLENEGATIVE SQUARED CROSS MA" +
	"RKLOWER RIGHT DROP-SHADOWED WHITE SQUAREUPPER RIGHT DROP-SHADOWED WHITE " +
	"SQUARELOWER RIGHT SHADOWED WHITE SQUAREUPPER RIGHT SHADOWED WHITE SQUARE" +
	"BLACK QUESTION MARK ORNAMENTWHITE QUESTION MARK ORNAMENTWHITE EXCLAMATIO" +
	"N MARK ORNAMENTBLACK DIAMOND MINUS WHITE XHEAVY EXCLAMATION MARK SYMBOLL" +
	"IGHT VERTICAL BARMEDIUM VERTICAL BARHEAVY VERTICAL BARHEAVY SINGLE TURNE" +
	"D COMMA QUOTATION MARK ORNAMENTHEAVY SINGLE COMMA QUOTATION MARK ORNAMEN" +
	"THEAVY DOUBLE TURNED COMMA QUOTATION MARK ORNAMENTHEAVY DOUBLE COMMA QUO" +
	"TATION MARK ORNAMENTHEAVY LOW SINGLE COMMA QUOTATION MARK ORNAMENTHEAVY " +
	"LOW DOUBLE COMMA QUOTATION MARK ORNAMENTCURVED STEM PARAGRAPH SIGN ORNAM" +
	"ENTHEAVY EXCLAMATION MARK ORNAMENTHEAVY HEART EXCLAMATION MARK ORNAMENTH" +
	"EAVY BLACK HEARTROTATED HEAVY BLACK HEART BULLETFLORAL HEARTROTATED FLOR" +
	"AL HEART BULLETMEDIUM LEFT PARENTHESIS ORNAMENTMEDIUM RIGHT PARENTHESIS " +
	"ORNAMENTMEDIUM FLATTENED LEFT PARENTHESIS ORNAMENTMEDIUM FLATTENED RIGHT" +
	" PARENTHESIS ORNAMENTMEDIUM LEFT-POINTING ANGLE BRACKET ORNAMENTMEDIUM R" +
	"IGHT-POINTING ANGLE BRACKET ORNAMENTHEAVY LEFT-POINTING ANGLE QUOTATION " +
	"MARK ORNAMENTHEAVY RIGHT-POINTING ANGLE QUOTATION MARK ORNAMENTHEAVY LEF" +
	"T-POINTING ANGLE BRACKET ORNAMENTHEAVY RIGHT-POINTING ANGLE BRACKET ORNA" +
	"MENTLIGHT LEFT TORTOISE SHELL BRACKET ORNAMENTLIGHT RIGHT TORTOISE SHELL" +
	" BRACKET ORNAMENTMEDIUM LEFT CURLY BRACKET ORNAMENTMEDIUM RIGHT CURLY BR" +
	"ACKET ORNAMENTDINGBAT NEGATIVE CIRCLED DIGIT ONEDINGBAT NEGATIVE CIRCLED" +
	" DIGIT TWODINGBAT NEGATIVE CIRCLED DIGIT THREEDINGBAT NEGATIVE CIRCLED D" +
	"IGIT FOURDINGBAT NEGATIVE CIRCLED DIGIT FIVEDINGBAT NEGATIVE CIRCLED DIG" +
	"IT SIXDINGBAT NEGATIVE CIRCLED DIGIT SEVENDINGBAT NEGATIVE CIRCLED DIGIT" +
	" EIGHTDINGBAT NEGATIVE CIRCLED DIGIT NINEDINGBAT NEGATIVE CIRCLED NUMBER" +
	" TENDINGBAT CIRCLED SANS-SERIF DIGIT ONEDINGBAT CIRCLED SANS-SERIF DIGIT" +
	" TWODINGBAT CIRCLED SANS-SERIF DIGIT THREEDINGBAT CIRCLED SANS-SERIF DIG" +
	"IT FOURDINGBAT CIRCLED SANS-SERIF DIGIT FIVEDINGBAT CIRCLED SANS-SERIF D" +
	"IGIT SIXDINGBAT CIRCLED SANS-SERIF DIGIT SEVENDINGBAT CIRCLED SANS-SERIF" +
	" DIGIT EIGHTDINGBAT CIRCLED SANS-SERIF DIGIT NINEDINGBAT CIRCLED SANS-SE" +
	"RIF NUMBER TENDINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT ONEDINGBAT NEGAT" +
	"IVE CIRCLED SANS-SERIF DIGIT TWODINGBAT NEGATIVE CIRCLED SANS-SERIF DIGI" +
	"T THREEDINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT FOURDINGBAT NEGATIVE CI" +
	"RCLED SANS-SERIF DIGIT FIVEDINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT SIX" +
	"DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT SEVENDINGBAT NEGATIVE CIRCLED " +
	"SANS-SERIF DIGIT EIGHTDINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT NINEDING" +
	"BAT NEGATIVE CIRCLED SANS-SERIF NUMBER TENHEAVY WIDE-HEADED RIGHTWARDS A" +
	"RROWHEAVY PLUS SIGNHEAVY MINUS SIGNHEAVY DIVISION SIGNHEAVY SOUTH EAST A" +
	"RROWHEAVY RIGHTWARDS ARROWHEAVY NORTH EAST ARROWDRAFTING POINT RIGHTWARD" +
	"S ARROWHEAVY ROUND-TIPPED RIGHTWARDS ARROWTRIANGLE-HEADED RIGHTWARDS ARR" +
	"OWHEAVY TRIANGLE-HEADED RIGHTWARDS ARROWDASHED TRIANGLE-HEADED RIGHTWARD" +
	"S ARROWHEAVY DASHED TRIANGLE-HEADED RIGHTWARDS ARROWBLACK RIGHTWARDS ARR" +
	"OWTHREE-D TOP-LIGHTED RIGHTWARDS ARROWHEADTHREE-D BOTTOM-LIGHTED RIGHTWA" +
	"RDS ARROWHEADBLACK RIGHTWARDS ARROWHEADHEAVY BLACK CURVED DOWNWARDS AND " +
	"RIGHTWARDS ARROWHEAVY BLACK CURVED UPWARDS AND RIGHTWARDS ARROWSQUAT BLA" +
	"CK RIGHTWARDS ARROWHEAVY CONCAVE-POINTED BLACK RIGHTWARDS ARROWRIGHT-SHA" +
	"DED WHITE RIGHTWARDS ARROWLEFT-SHADED WHITE RIGHTWARDS ARROWBACK-TILTED ") + ("" +
	"SHADOWED WHITE RIGHTWARDS ARROWFRONT-TILTED SHADOWED WHITE RIGHTWARDS AR" +
	"ROWHEAVY LOWER RIGHT-SHADOWED WHITE RIGHTWARDS ARROWHEAVY UPPER RIGHT-SH" +
	"ADOWED WHITE RIGHTWARDS ARROWNOTCHED LOWER RIGHT-SHADOWED WHITE RIGHTWAR" +
	"DS ARROWCURLY LOOPNOTCHED UPPER RIGHT-SHADOWED WHITE RIGHTWARDS ARROWCIR" +
	"CLED HEAVY WHITE RIGHTWARDS ARROWWHITE-FEATHERED RIGHTWARDS ARROWBLACK-F" +
	"EATHERED SOUTH EAST ARROWBLACK-FEATHERED RIGHTWARDS ARROWBLACK-FEATHERED" +
	" NORTH EAST ARROWHEAVY BLACK-FEATHERED SOUTH EAST ARROWHEAVY BLACK-FEATH" +
	"ERED RIGHTWARDS ARROWHEAVY BLACK-FEATHERED NORTH EAST ARROWTEARDROP-BARB" +
	"ED RIGHTWARDS ARROWHEAVY TEARDROP-SHANKED RIGHTWARDS ARROWWEDGE-TAILED R" +
	"IGHTWARDS ARROWHEAVY WEDGE-TAILED RIGHTWARDS ARROWOPEN-OUTLINED RIGHTWAR" +
	"DS ARROWDOUBLE CURLY LOOPTHREE DIMENSIONAL ANGLEWHITE TRIANGLE CONTAININ" +
	"G SMALL WHITE TRIANGLEPERPENDICULAROPEN SUBSETOPEN SUPERSETLEFT S-SHAPED" +
	" BAG DELIMITERRIGHT S-SHAPED BAG DELIMITEROR WITH DOT INSIDEREVERSE SOLI" +
	"DUS PRECEDING SUBSETSUPERSET PRECEDING SOLIDUSVERTICAL BAR WITH HORIZONT" +
	"AL STROKEMATHEMATICAL RISING DIAGONALLONG DIVISIONMATHEMATICAL FALLING D" +
	"IAGONALSQUARED LOGICAL ANDSQUARED LOGICAL ORWHITE DIAMOND WITH CENTRED D" +
	"OTAND WITH DOTELEMENT OF OPENING UPWARDSLOWER RIGHT CORNER WITH DOTUPPER" +
	" LEFT CORNER WITH DOTLEFT OUTER JOINRIGHT OUTER JOINFULL OUTER JOINLARGE" +
	" UP TACKLARGE DOWN TACKLEFT AND RIGHT DOUBLE TURNSTILELEFT AND RIGHT TAC" +
	"KLEFT MULTIMAPLONG RIGHT TACKLONG LEFT TACKUP TACK WITH CIRCLE ABOVELOZE" +
	"NGE DIVIDED BY HORIZONTAL RULEWHITE CONCAVE-SIDED DIAMONDWHITE CONCAVE-S" +
	"IDED DIAMOND WITH LEFTWARDS TICKWHITE CONCAVE-SIDED DIAMOND WITH RIGHTWA" +
	"RDS TICKWHITE SQUARE WITH LEFTWARDS TICKWHITE SQUARE WITH RIGHTWARDS TIC" +
	"KMATHEMATICAL LEFT WHITE SQUARE BRACKETMATHEMATICAL RIGHT WHITE SQUARE B" +
	"RACKETMATHEMATICAL LEFT ANGLE BRACKETMATHEMATICAL RIGHT ANGLE BRACKETMAT" +
	"HEMATICAL LEFT DOUBLE ANGLE BRACKETMATHEMATICAL RIGHT DOUBLE ANGLE BRACK" +
	"ETMATHEMATICAL LEFT WHITE TORTOISE SHELL BRACKETMATHEMATICAL RIGHT WHITE" +
	" TORTOISE SHELL BRACKETMATHEMATICAL LEFT FLATTENED PARENTHESISMATHEMATIC" +
	"AL RIGHT FLATTENED PARENTHESISUPWARDS QUADRUPLE ARROWDOWNWARDS QUADRUPLE" +
	" ARROWANTICLOCKWISE GAPPED CIRCLE ARROWCLOCKWISE GAPPED CIRCLE ARROWRIGH" +
	"T ARROW WITH CIRCLED PLUSLONG LEFTWARDS ARROWLONG RIGHTWARDS ARROWLONG L" +
	"EFT RIGHT ARROWLONG LEFTWARDS DOUBLE ARROWLONG RIGHTWARDS DOUBLE ARROWLO" +
	"NG LEFT RIGHT DOUBLE ARROWLONG LEFTWARDS ARROW FROM BARLONG RIGHTWARDS A" +
	"RROW FROM BARLONG LEFTWARDS DOUBLE ARROW FROM BARLONG RIGHTWARDS DOUBLE " +
	"ARROW FROM BARLONG RIGHTWARDS SQUIGGLE ARROWBRAILLE PATTERN BLANKBRAILLE" +
	" PATTERN DOTS-1BRAILLE PATTERN DOTS-2BRAILLE PATTERN DOTS-12BRAILLE PATT" +
	"ERN DOTS-3BRAILLE PATTERN DOTS-13BRAILLE PATTERN DOTS-23BRAILLE PATTERN " +
	"DOTS-123BRAILLE PATTERN DOTS-4BRAILLE PATTERN DOTS-14BRAILLE PATTERN DOT" +
	"S-24BRAILLE PATTERN DOTS-124BRAILLE PATTERN DOTS-34BRAILLE PATTERN DOTS-" +
	"134BRAILLE PATTERN DOTS-234BRAILLE PATTERN DOTS-1234BRAILLE PATTERN DOTS" +
	"-5BRAILLE PATTERN DOTS-15BRAILLE PATTERN DOTS-25BRAILLE PATTERN DOTS-125" +
	"BRAILLE PATTERN DOTS-35BRAILLE PATTERN DOTS-135BRAILLE PATTERN DOTS-235B" +
	"RAILLE PATTERN DOTS-1235BRAILLE PATTERN DOTS-45BRAILLE PATTERN DOTS-145B" +
	"RAILLE PATTERN DOTS-245BRAILLE PATTERN DOTS-1245BRAILLE PATTERN DOTS-345" +
	"BRAILLE PATTERN DOTS-1345BRAILLE PATTERN DOTS-2345BRAILLE PATTERN DOTS-1" +
	"2345BRAILLE PATTERN DOTS-6BRAILLE PATTERN DOTS-16BRAILLE PATTERN DOTS-26" +
	"BRAILLE PATTERN DOTS-126BRAILLE PATTERN DOTS-36BRAILLE PATTERN DOTS-136B" +
	"RAILLE PATTERN DOTS-236BRAILLE PATTERN DOTS-1236BRAILLE PATTERN DOTS-46B" +
	"RAILLE PATTERN DOTS-146BRAILLE PATTERN DOTS-246BRAILLE PATTERN DOTS-1246" +
	"BRAILLE PATTERN DOTS-346BRAILLE PATTERN DOTS-1346BRAILLE PATTERN DOTS-23" +
	"46BRAILLE PATTERN DOTS-12346BRAILLE PATTERN DOTS-56BRAILLE PATTERN DOTS-" +
	"156BRAILLE PATTERN DOTS-256BRAILLE PATTERN DOTS-1256BRAILLE PATTERN DOTS" +
	"-356BRAILLE PATTERN DOTS-1356BRAILLE PATTERN DOTS-2356BRAILLE PATTERN DO" +
	"TS-12356BRAILLE PATTERN DOTS-456BRAILLE PATTERN DOTS-1456BRAILLE PATTERN" +
	" DOTS-2456BRAILLE PATTERN DOTS-12456BRAILLE PATTERN DOTS-3456BRAILLE PAT" +
	"TERN DOTS-13456BRAILLE PATTERN DOTS-23456BRAILLE PATTERN DOTS-123456BRAI" +
	"LLE PATTERN DOTS-7BRAILLE PATTERN DOTS-17BRAILLE PATTERN DOTS-27BRAILLE " +
	"PATTERN DOTS-127BRAILLE PATTERN DOTS-37BRAILLE PATTERN DOTS-137BRAILLE P" +
	"ATTERN DOTS-237BRAILLE PATTERN DOTS-1237BRAILLE PATTERN DOTS-47BRAILLE P" +
	"ATTERN DOTS-147BRAILLE PATTERN DOTS-247BRAILLE PATTERN DOTS-1247BRAILLE " +
	"PATTERN DOTS-347BRAILLE PATTERN DOTS-1347BRAILLE PATTERN DOTS-2347BRAILL" +
	"E PATTERN DOTS-12347BRAILLE PATTERN DOTS-57BRAILLE PATTERN DOTS-157BRAIL" +
	"LE PATTERN DOTS-257BRAILLE PATTERN DOTS-1257BRAILLE PATTERN DOTS-357BRAI" +
	"LLE PATTERN DOTS-1357BRAILLE PATTERN DOTS-2357BRAILLE PATTERN DOTS-12357") + ("" +
	"BRAILLE PATTERN DOTS-457BRAILLE PATTERN DOTS-1457BRAILLE PATTERN DOTS-24" +
	"57BRAILLE PATTERN DOTS-12457BRAILLE PATTERN DOTS-3457BRAILLE PATTERN DOT" +
	"S-13457BRAILLE PATTERN DOTS-23457BRAILLE PATTERN DOTS-123457BRAILLE PATT" +
	"ERN DOTS-67BRAILLE PATTERN DOTS-167BRAILLE PATTERN DOTS-267BRAILLE PATTE" +
	"RN DOTS-1267BRAILLE PATTERN DOTS-367BRAILLE PATTERN DOTS-1367BRAILLE PAT" +
	"TERN DOTS-2367BRAILLE PATTERN DOTS-12367BRAILLE PATTERN DOTS-467BRAILLE " +
	"PATTERN DOTS-1467BRAILLE PATTERN DOTS-2467BRAILLE PATTERN DOTS-12467BRAI" +
	"LLE PATTERN DOTS-3467BRAILLE PATTERN DOTS-13467BRAILLE PATTERN DOTS-2346" +
	"7BRAILLE PATTERN DOTS-123467BRAILLE PATTERN DOTS-567BRAILLE PATTERN DOTS" +
	"-1567BRAILLE PATTERN DOTS-2567BRAILLE PATTERN DOTS-12567BRAILLE PATTERN " +
	"DOTS-3567BRAILLE PATTERN DOTS-13567BRAILLE PATTERN DOTS-23567BRAILLE PAT" +
	"TERN DOTS-123567BRAILLE PATTERN DOTS-4567BRAILLE PATTERN DOTS-14567BRAIL" +
	"LE PATTERN DOTS-24567BRAILLE PATTERN DOTS-124567BRAILLE PATTERN DOTS-345" +
	"67BRAILLE PATTERN DOTS-134567BRAILLE PATTERN DOTS-234567BRAILLE PATTERN " +
	"DOTS-1234567BRAILLE PATTERN DOTS-8BRAILLE PATTERN DOTS-18BRAILLE PATTERN" +
	" DOTS-28BRAILLE PATTERN DOTS-128BRAILLE PATTERN DOTS-38BRAILLE PATTERN D" +
	"OTS-138BRAILLE PATTERN DOTS-238BRAILLE PATTERN DOTS-1238BRAILLE PATTERN " +
	"DOTS-48BRAILLE PATTERN DOTS-148BRAILLE PATTERN DOTS-248BRAILLE PATTERN D" +
	"OTS-1248BRAILLE PATTERN DOTS-348BRAILLE PATTERN DOTS-1348BRAILLE PATTERN" +
	" DOTS-2348BRAILLE PATTERN DOTS-12348BRAILLE PATTERN DOTS-58BRAILLE PATTE" +
	"RN DOTS-158BRAILLE PATTERN DOTS-258BRAILLE PATTERN DOTS-1258BRAILLE PATT" +
	"ERN DOTS-358BRAILLE PATTERN DOTS-1358BRAILLE PATTERN DOTS-2358BRAILLE PA" +
	"TTERN DOTS-12358BRAILLE PATTERN DOTS-458BRAILLE PATTERN DOTS-1458BRAILLE" +
	" PATTERN DOTS-2458BRAILLE PATTERN DOTS-12458BRAILLE PATTERN DOTS-3458BRA" +
	"ILLE PATTERN DOTS-13458BRAILLE PATTERN DOTS-23458BRAILLE PATTERN DOTS-12" +
	"3458BRAILLE PATTERN DOTS-68BRAILLE PATTERN DOTS-168BRAILLE PATTERN DOTS-" +
	"268BRAILLE PATTERN DOTS-1268BRAILLE PATTERN DOTS-368BRAILLE PATTERN DOTS" +
	"-1368BRAILLE PATTERN DOTS-2368BRAILLE PATTERN DOTS-12368BRAILLE PATTERN " +
	"DOTS-468BRAILLE PATTERN DOTS-1468BRAILLE PATTERN DOTS-2468BRAILLE PATTER" +
	"N DOTS-12468BRAILLE PATTERN DOTS-3468BRAILLE PATTERN DOTS-13468BRAILLE P" +
	"ATTERN DOTS-23468BRAILLE PATTERN DOTS-123468BRAILLE PATTERN DOTS-568BRAI" +
	"LLE PATTERN DOTS-1568BRAILLE PATTERN DOTS-2568BRAILLE PATTERN DOTS-12568" +
	"BRAILLE PATTERN DOTS-3568BRAILLE PATTERN DOTS-13568BRAILLE PATTERN DOTS-" +
	"23568BRAILLE PATTERN DOTS-123568BRAILLE PATTERN DOTS-4568BRAILLE PATTERN" +
	" DOTS-14568BRAILLE PATTERN DOTS-24568BRAILLE PATTERN DOTS-124568BRAILLE " +
	"PATTERN DOTS-34568BRAILLE PATTERN DOTS-134568BRAILLE PATTERN DOTS-234568" +
	"BRAILLE PATTERN DOTS-1234568BRAILLE PATTERN DOTS-78BRAILLE PATTERN DOTS-" +
	"178BRAILLE PATTERN DOTS-278BRAILLE PATTERN DOTS-1278BRAILLE PATTERN DOTS" +
	"-378BRAILLE PATTERN DOTS-1378BRAILLE PATTERN DOTS-2378BRAILLE PATTERN DO" +
	"TS-12378BRAILLE PATTERN DOTS-478BRAILLE PATTERN DOTS-1478BRAILLE PATTERN" +
	" DOTS-2478BRAILLE PATTERN DOTS-12478BRAILLE PATTERN DOTS-3478BRAILLE PAT" +
	"TERN DOTS-13478BRAILLE PATTERN DOTS-23478BRAILLE PATTERN DOTS-123478BRAI" +
	"LLE PATTERN DOTS-578BRAILLE PATTERN DOTS-1578BRAILLE PATTERN DOTS-2578BR" +
	"AILLE PATTERN DOTS-12578BRAILLE PATTERN DOTS-3578BRAILLE PATTERN DOTS-13" +
	"578BRAILLE PATTERN DOTS-23578BRAILLE PATTERN DOTS-123578BRAILLE PATTERN " +
	"DOTS-4578BRAILLE PATTERN DOTS-14578BRAILLE PATTERN DOTS-24578BRAILLE PAT" +
	"TERN DOTS-124578BRAILLE PATTERN DOTS-34578BRAILLE PATTERN DOTS-134578BRA" +
	"ILLE PATTERN DOTS-234578BRAILLE PATTERN DOTS-1234578BRAILLE PATTERN DOTS" +
	"-678BRAILLE PATTERN DOTS-1678BRAILLE PATTERN DOTS-2678BRAILLE PATTERN DO" +
	"TS-12678BRAILLE PATTERN DOTS-3678BRAILLE PATTERN DOTS-13678BRAILLE PATTE" +
	"RN DOTS-23678BRAILLE PATTERN DOTS-123678BRAILLE PATTERN DOTS-4678BRAILLE" +
	" PATTERN DOTS-14678BRAILLE PATTERN DOTS-24678BRAILLE PATTERN DOTS-124678" +
	"BRAILLE PATTERN DOTS-34678BRAILLE PATTERN DOTS-134678BRAILLE PATTERN DOT" +
	"S-234678BRAILLE PATTERN DOTS-1234678BRAILLE PATTERN DOTS-5678BRAILLE PAT" +
	"TERN DOTS-15678BRAILLE PATTERN DOTS-25678BRAILLE PATTERN DOTS-125678BRAI" +
	"LLE PATTERN DOTS-35678BRAILLE PATTERN DOTS-135678BRAILLE PATTERN DOTS-23" +
	"5678BRAILLE PATTERN DOTS-1235678BRAILLE PATTERN DOTS-45678BRAILLE PATTER" +
	"N DOTS-145678BRAILLE PATTERN DOTS-245678BRAILLE PATTERN DOTS-1245678BRAI" +
	"LLE PATTERN DOTS-345678BRAILLE PATTERN DOTS-1345678BRAILLE PATTERN DOTS-" +
	"2345678BRAILLE PATTERN DOTS-12345678RIGHTWARDS TWO-HEADED ARROW WITH VER" +
	"TICAL STROKERIGHTWARDS TWO-HEADED ARROW WITH DOUBLE VERTICAL STROKELEFTW" +
	"ARDS DOUBLE ARROW WITH VERTICAL STROKERIGHTWARDS DOUBLE ARROW WITH VERTI" +
	"CAL STROKELEFT RIGHT DOUBLE ARROW WITH VERTICAL STROKERIGHTWARDS TWO-HEA" +
	"DED ARROW FROM BARLEFTWARDS DOUBLE ARROW FROM BARRIGHTWARDS DOUBLE ARROW") + ("" +
	" FROM BARDOWNWARDS ARROW WITH HORIZONTAL STROKEUPWARDS ARROW WITH HORIZO" +
	"NTAL STROKEUPWARDS TRIPLE ARROWDOWNWARDS TRIPLE ARROWLEFTWARDS DOUBLE DA" +
	"SH ARROWRIGHTWARDS DOUBLE DASH ARROWLEFTWARDS TRIPLE DASH ARROWRIGHTWARD" +
	"S TRIPLE DASH ARROWRIGHTWARDS TWO-HEADED TRIPLE DASH ARROWRIGHTWARDS ARR" +
	"OW WITH DOTTED STEMUPWARDS ARROW TO BARDOWNWARDS ARROW TO BARRIGHTWARDS " +
	"ARROW WITH TAIL WITH VERTICAL STROKERIGHTWARDS ARROW WITH TAIL WITH DOUB" +
	"LE VERTICAL STROKERIGHTWARDS TWO-HEADED ARROW WITH TAILRIGHTWARDS TWO-HE" +
	"ADED ARROW WITH TAIL WITH VERTICAL STROKERIGHTWARDS TWO-HEADED ARROW WIT" +
	"H TAIL WITH DOUBLE VERTICAL STROKELEFTWARDS ARROW-TAILRIGHTWARDS ARROW-T" +
	"AILLEFTWARDS DOUBLE ARROW-TAILRIGHTWARDS DOUBLE ARROW-TAILLEFTWARDS ARRO" +
	"W TO BLACK DIAMONDRIGHTWARDS ARROW TO BLACK DIAMONDLEFTWARDS ARROW FROM " +
	"BAR TO BLACK DIAMONDRIGHTWARDS ARROW FROM BAR TO BLACK DIAMONDNORTH WEST" +
	" AND SOUTH EAST ARROWNORTH EAST AND SOUTH WEST ARROWNORTH WEST ARROW WIT" +
	"H HOOKNORTH EAST ARROW WITH HOOKSOUTH EAST ARROW WITH HOOKSOUTH WEST ARR" +
	"OW WITH HOOKNORTH WEST ARROW AND NORTH EAST ARROWNORTH EAST ARROW AND SO" +
	"UTH EAST ARROWSOUTH EAST ARROW AND SOUTH WEST ARROWSOUTH WEST ARROW AND " +
	"NORTH WEST ARROWRISING DIAGONAL CROSSING FALLING DIAGONALFALLING DIAGONA" +
	"L CROSSING RISING DIAGONALSOUTH EAST ARROW CROSSING NORTH EAST ARROWNORT" +
	"H EAST ARROW CROSSING SOUTH EAST ARROWFALLING DIAGONAL CROSSING NORTH EA" +
	"ST ARROWRISING DIAGONAL CROSSING SOUTH EAST ARROWNORTH EAST ARROW CROSSI" +
	"NG NORTH WEST ARROWNORTH WEST ARROW CROSSING NORTH EAST ARROWWAVE ARROW " +
	"POINTING DIRECTLY RIGHTARROW POINTING RIGHTWARDS THEN CURVING UPWARDSARR" +
	"OW POINTING RIGHTWARDS THEN CURVING DOWNWARDSARROW POINTING DOWNWARDS TH" +
	"EN CURVING LEFTWARDSARROW POINTING DOWNWARDS THEN CURVING RIGHTWARDSRIGH" +
	"T-SIDE ARC CLOCKWISE ARROWLEFT-SIDE ARC ANTICLOCKWISE ARROWTOP ARC ANTIC" +
	"LOCKWISE ARROWBOTTOM ARC ANTICLOCKWISE ARROWTOP ARC CLOCKWISE ARROW WITH" +
	" MINUSTOP ARC ANTICLOCKWISE ARROW WITH PLUSLOWER RIGHT SEMICIRCULAR CLOC" +
	"KWISE ARROWLOWER LEFT SEMICIRCULAR ANTICLOCKWISE ARROWANTICLOCKWISE CLOS" +
	"ED CIRCLE ARROWCLOCKWISE CLOSED CIRCLE ARROWRIGHTWARDS ARROW ABOVE SHORT" +
	" LEFTWARDS ARROWLEFTWARDS ARROW ABOVE SHORT RIGHTWARDS ARROWSHORT RIGHTW" +
	"ARDS ARROW ABOVE LEFTWARDS ARROWRIGHTWARDS ARROW WITH PLUS BELOWLEFTWARD" +
	"S ARROW WITH PLUS BELOWRIGHTWARDS ARROW THROUGH XLEFT RIGHT ARROW THROUG" +
	"H SMALL CIRCLEUPWARDS TWO-HEADED ARROW FROM SMALL CIRCLELEFT BARB UP RIG" +
	"HT BARB DOWN HARPOONLEFT BARB DOWN RIGHT BARB UP HARPOONUP BARB RIGHT DO" +
	"WN BARB LEFT HARPOONUP BARB LEFT DOWN BARB RIGHT HARPOONLEFT BARB UP RIG" +
	"HT BARB UP HARPOONUP BARB RIGHT DOWN BARB RIGHT HARPOONLEFT BARB DOWN RI" +
	"GHT BARB DOWN HARPOONUP BARB LEFT DOWN BARB LEFT HARPOONLEFTWARDS HARPOO" +
	"N WITH BARB UP TO BARRIGHTWARDS HARPOON WITH BARB UP TO BARUPWARDS HARPO" +
	"ON WITH BARB RIGHT TO BARDOWNWARDS HARPOON WITH BARB RIGHT TO BARLEFTWAR" +
	"DS HARPOON WITH BARB DOWN TO BARRIGHTWARDS HARPOON WITH BARB DOWN TO BAR" +
	"UPWARDS HARPOON WITH BARB LEFT TO BARDOWNWARDS HARPOON WITH BARB LEFT TO" +
	" BARLEFTWARDS HARPOON WITH BARB UP FROM BARRIGHTWARDS HARPOON WITH BARB " +
	"UP FROM BARUPWARDS HARPOON WITH BARB RIGHT FROM BARDOWNWARDS HARPOON WIT" +
	"H BARB RIGHT FROM BARLEFTWARDS HARPOON WITH BARB DOWN FROM BARRIGHTWARDS" +
	" HARPOON WITH BARB DOWN FROM BARUPWARDS HARPOON WITH BARB LEFT FROM BARD" +
	"OWNWARDS HARPOON WITH BARB LEFT FROM BARLEFTWARDS HARPOON WITH BARB UP A" +
	"BOVE LEFTWARDS HARPOON WITH BARB DOWNUPWARDS HARPOON WITH BARB LEFT BESI" +
	"DE UPWARDS HARPOON WITH BARB RIGHTRIGHTWARDS HARPOON WITH BARB UP ABOVE " +
	"RIGHTWARDS HARPOON WITH BARB DOWNDOWNWARDS HARPOON WITH BARB LEFT BESIDE" +
	" DOWNWARDS HARPOON WITH BARB RIGHTLEFTWARDS HARPOON WITH BARB UP ABOVE R" +
	"IGHTWARDS HARPOON WITH BARB UPLEFTWARDS HARPOON WITH BARB DOWN ABOVE RIG" +
	"HTWARDS HARPOON WITH BARB DOWNRIGHTWARDS HARPOON WITH BARB UP ABOVE LEFT" +
	"WARDS HARPOON WITH BARB UPRIGHTWARDS HARPOON WITH BARB DOWN ABOVE LEFTWA" +
	"RDS HARPOON WITH BARB DOWNLEFTWARDS HARPOON WITH BARB UP ABOVE LONG DASH" +
	"LEFTWARDS HARPOON WITH BARB DOWN BELOW LONG DASHRIGHTWARDS HARPOON WITH " +
	"BARB UP ABOVE LONG DASHRIGHTWARDS HARPOON WITH BARB DOWN BELOW LONG DASH" +
	"UPWARDS HARPOON WITH BARB LEFT BESIDE DOWNWARDS HARPOON WITH BARB RIGHTD" +
	"OWNWARDS HARPOON WITH BARB LEFT BESIDE UPWARDS HARPOON WITH BARB RIGHTRI" +
	"GHT DOUBLE ARROW WITH ROUNDED HEADEQUALS SIGN ABOVE RIGHTWARDS ARROWTILD" +
	"E OPERATOR ABOVE RIGHTWARDS ARROWLEFTWARDS ARROW ABOVE TILDE OPERATORRIG" +
	"HTWARDS ARROW ABOVE TILDE OPERATORRIGHTWARDS ARROW ABOVE ALMOST EQUAL TO" +
	"LESS-THAN ABOVE LEFTWARDS ARROWLEFTWARDS ARROW THROUGH LESS-THANGREATER-" +
	"THAN ABOVE RIGHTWARDS ARROWSUBSET ABOVE RIGHTWARDS ARROWLEFTWARDS ARROW " +
	"THROUGH SUBSETSUPERSET ABOVE LEFTWARDS ARROWLEFT FISH TAILRIGHT FISH TAI") + ("" +
	"LUP FISH TAILDOWN FISH TAILTRIPLE VERTICAL BAR DELIMITERZ NOTATION SPOTZ" +
	" NOTATION TYPE COLONLEFT WHITE CURLY BRACKETRIGHT WHITE CURLY BRACKETLEF" +
	"T WHITE PARENTHESISRIGHT WHITE PARENTHESISZ NOTATION LEFT IMAGE BRACKETZ" +
	" NOTATION RIGHT IMAGE BRACKETZ NOTATION LEFT BINDING BRACKETZ NOTATION R" +
	"IGHT BINDING BRACKETLEFT SQUARE BRACKET WITH UNDERBARRIGHT SQUARE BRACKE" +
	"T WITH UNDERBARLEFT SQUARE BRACKET WITH TICK IN TOP CORNERRIGHT SQUARE B" +
	"RACKET WITH TICK IN BOTTOM CORNERLEFT SQUARE BRACKET WITH TICK IN BOTTOM" +
	" CORNERRIGHT SQUARE BRACKET WITH TICK IN TOP CORNERLEFT ANGLE BRACKET WI" +
	"TH DOTRIGHT ANGLE BRACKET WITH DOTLEFT ARC LESS-THAN BRACKETRIGHT ARC GR" +
	"EATER-THAN BRACKETDOUBLE LEFT ARC GREATER-THAN BRACKETDOUBLE RIGHT ARC L" +
	"ESS-THAN BRACKETLEFT BLACK TORTOISE SHELL BRACKETRIGHT BLACK TORTOISE SH" +
	"ELL BRACKETDOTTED FENCEVERTICAL ZIGZAG LINEMEASURED ANGLE OPENING LEFTRI" +
	"GHT ANGLE VARIANT WITH SQUAREMEASURED RIGHT ANGLE WITH DOTANGLE WITH S I" +
	"NSIDEACUTE ANGLESPHERICAL ANGLE OPENING LEFTSPHERICAL ANGLE OPENING UPTU" +
	"RNED ANGLEREVERSED ANGLEANGLE WITH UNDERBARREVERSED ANGLE WITH UNDERBARO" +
	"BLIQUE ANGLE OPENING UPOBLIQUE ANGLE OPENING DOWNMEASURED ANGLE WITH OPE" +
	"N ARM ENDING IN ARROW POINTING UP AND RIGHTMEASURED ANGLE WITH OPEN ARM " +
	"ENDING IN ARROW POINTING UP AND LEFTMEASURED ANGLE WITH OPEN ARM ENDING " +
	"IN ARROW POINTING DOWN AND RIGHTMEASURED ANGLE WITH OPEN ARM ENDING IN A" +
	"RROW POINTING DOWN AND LEFTMEASURED ANGLE WITH OPEN ARM ENDING IN ARROW " +
	"POINTING RIGHT AND UPMEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTI" +
	"NG LEFT AND UPMEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING RIGH" +
	"T AND DOWNMEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING LEFT AND" +
	" DOWNREVERSED EMPTY SETEMPTY SET WITH OVERBAREMPTY SET WITH SMALL CIRCLE" +
	" ABOVEEMPTY SET WITH RIGHT ARROW ABOVEEMPTY SET WITH LEFT ARROW ABOVECIR" +
	"CLE WITH HORIZONTAL BARCIRCLED VERTICAL BARCIRCLED PARALLELCIRCLED REVER" +
	"SE SOLIDUSCIRCLED PERPENDICULARCIRCLE DIVIDED BY HORIZONTAL BAR AND TOP " +
	"HALF DIVIDED BY VERTICAL BARCIRCLE WITH SUPERIMPOSED XCIRCLED ANTICLOCKW" +
	"ISE-ROTATED DIVISION SIGNUP ARROW THROUGH CIRCLECIRCLED WHITE BULLETCIRC" +
	"LED BULLETCIRCLED LESS-THANCIRCLED GREATER-THANCIRCLE WITH SMALL CIRCLE " +
	"TO THE RIGHTCIRCLE WITH TWO HORIZONTAL STROKES TO THE RIGHTSQUARED RISIN" +
	"G DIAGONAL SLASHSQUARED FALLING DIAGONAL SLASHSQUARED ASTERISKSQUARED SM" +
	"ALL CIRCLESQUARED SQUARETWO JOINED SQUARESTRIANGLE WITH DOT ABOVETRIANGL" +
	"E WITH UNDERBARS IN TRIANGLETRIANGLE WITH SERIFS AT BOTTOMRIGHT TRIANGLE" +
	" ABOVE LEFT TRIANGLELEFT TRIANGLE BESIDE VERTICAL BARVERTICAL BAR BESIDE" +
	" RIGHT TRIANGLEBOWTIE WITH LEFT HALF BLACKBOWTIE WITH RIGHT HALF BLACKBL" +
	"ACK BOWTIETIMES WITH LEFT HALF BLACKTIMES WITH RIGHT HALF BLACKWHITE HOU" +
	"RGLASSBLACK HOURGLASSLEFT WIGGLY FENCERIGHT WIGGLY FENCELEFT DOUBLE WIGG" +
	"LY FENCERIGHT DOUBLE WIGGLY FENCEINCOMPLETE INFINITYTIE OVER INFINITYINF" +
	"INITY NEGATED WITH VERTICAL BARDOUBLE-ENDED MULTIMAPSQUARE WITH CONTOURE" +
	"D OUTLINEINCREASES ASSHUFFLE PRODUCTEQUALS SIGN AND SLANTED PARALLELEQUA" +
	"LS SIGN AND SLANTED PARALLEL WITH TILDE ABOVEIDENTICAL TO AND SLANTED PA" +
	"RALLELGLEICH STARKTHERMODYNAMICDOWN-POINTING TRIANGLE WITH LEFT HALF BLA" +
	"CKDOWN-POINTING TRIANGLE WITH RIGHT HALF BLACKBLACK DIAMOND WITH DOWN AR" +
	"ROWBLACK LOZENGEWHITE CIRCLE WITH DOWN ARROWBLACK CIRCLE WITH DOWN ARROW" +
	"ERROR-BARRED WHITE SQUAREERROR-BARRED BLACK SQUAREERROR-BARRED WHITE DIA" +
	"MONDERROR-BARRED BLACK DIAMONDERROR-BARRED WHITE CIRCLEERROR-BARRED BLAC" +
	"K CIRCLERULE-DELAYEDREVERSE SOLIDUS OPERATORSOLIDUS WITH OVERBARREVERSE " +
	"SOLIDUS WITH HORIZONTAL STROKEBIG SOLIDUSBIG REVERSE SOLIDUSDOUBLE PLUST" +
	"RIPLE PLUSLEFT-POINTING CURVED ANGLE BRACKETRIGHT-POINTING CURVED ANGLE " +
	"BRACKETTINYMINYN-ARY CIRCLED DOT OPERATORN-ARY CIRCLED PLUS OPERATORN-AR" +
	"Y CIRCLED TIMES OPERATORN-ARY UNION OPERATOR WITH DOTN-ARY UNION OPERATO" +
	"R WITH PLUSN-ARY SQUARE INTERSECTION OPERATORN-ARY SQUARE UNION OPERATOR" +
	"TWO LOGICAL AND OPERATORTWO LOGICAL OR OPERATORN-ARY TIMES OPERATORMODUL" +
	"O TWO SUMSUMMATION WITH INTEGRALQUADRUPLE INTEGRAL OPERATORFINITE PART I" +
	"NTEGRALINTEGRAL WITH DOUBLE STROKEINTEGRAL AVERAGE WITH SLASHCIRCULATION" +
	" FUNCTIONANTICLOCKWISE INTEGRATIONLINE INTEGRATION WITH RECTANGULAR PATH" +
	" AROUND POLELINE INTEGRATION WITH SEMICIRCULAR PATH AROUND POLELINE INTE" +
	"GRATION NOT INCLUDING THE POLEINTEGRAL AROUND A POINT OPERATORQUATERNION" +
	" INTEGRAL OPERATORINTEGRAL WITH LEFTWARDS ARROW WITH HOOKINTEGRAL WITH T" +
	"IMES SIGNINTEGRAL WITH INTERSECTIONINTEGRAL WITH UNIONINTEGRAL WITH OVER" +
	"BARINTEGRAL WITH UNDERBARJOINLARGE LEFT TRIANGLE OPERATORZ NOTATION SCHE" +
	"MA COMPOSITIONZ NOTATION SCHEMA PIPINGZ NOTATION SCHEMA PROJECTIONPLUS S" +
	"IGN WITH SMALL CIRCLE ABOVEPLUS SIGN WITH CIRCUMFLEX ACCENT ABOVEPLUS SI") + ("" +
	"GN WITH TILDE ABOVEPLUS SIGN WITH DOT BELOWPLUS SIGN WITH TILDE BELOWPLU" +
	"S SIGN WITH SUBSCRIPT TWOPLUS SIGN WITH BLACK TRIANGLEMINUS SIGN WITH CO" +
	"MMA ABOVEMINUS SIGN WITH DOT BELOWMINUS SIGN WITH FALLING DOTSMINUS SIGN" +
	" WITH RISING DOTSPLUS SIGN IN LEFT HALF CIRCLEPLUS SIGN IN RIGHT HALF CI" +
	"RCLEVECTOR OR CROSS PRODUCTMULTIPLICATION SIGN WITH DOT ABOVEMULTIPLICAT" +
	"ION SIGN WITH UNDERBARSEMIDIRECT PRODUCT WITH BOTTOM CLOSEDSMASH PRODUCT" +
	"MULTIPLICATION SIGN IN LEFT HALF CIRCLEMULTIPLICATION SIGN IN RIGHT HALF" +
	" CIRCLECIRCLED MULTIPLICATION SIGN WITH CIRCUMFLEX ACCENTMULTIPLICATION " +
	"SIGN IN DOUBLE CIRCLECIRCLED DIVISION SIGNPLUS SIGN IN TRIANGLEMINUS SIG" +
	"N IN TRIANGLEMULTIPLICATION SIGN IN TRIANGLEINTERIOR PRODUCTRIGHTHAND IN" +
	"TERIOR PRODUCTZ NOTATION RELATIONAL COMPOSITIONAMALGAMATION OR COPRODUCT" +
	"INTERSECTION WITH DOTUNION WITH MINUS SIGNUNION WITH OVERBARINTERSECTION" +
	" WITH OVERBARINTERSECTION WITH LOGICAL ANDUNION WITH LOGICAL ORUNION ABO" +
	"VE INTERSECTIONINTERSECTION ABOVE UNIONUNION ABOVE BAR ABOVE INTERSECTIO" +
	"NINTERSECTION ABOVE BAR ABOVE UNIONUNION BESIDE AND JOINED WITH UNIONINT" +
	"ERSECTION BESIDE AND JOINED WITH INTERSECTIONCLOSED UNION WITH SERIFSCLO" +
	"SED INTERSECTION WITH SERIFSDOUBLE SQUARE INTERSECTIONDOUBLE SQUARE UNIO" +
	"NCLOSED UNION WITH SERIFS AND SMASH PRODUCTLOGICAL AND WITH DOT ABOVELOG" +
	"ICAL OR WITH DOT ABOVEDOUBLE LOGICAL ANDDOUBLE LOGICAL ORTWO INTERSECTIN" +
	"G LOGICAL ANDTWO INTERSECTING LOGICAL ORSLOPING LARGE ORSLOPING LARGE AN" +
	"DLOGICAL OR OVERLAPPING LOGICAL ANDLOGICAL AND WITH MIDDLE STEMLOGICAL O" +
	"R WITH MIDDLE STEMLOGICAL AND WITH HORIZONTAL DASHLOGICAL OR WITH HORIZO" +
	"NTAL DASHLOGICAL AND WITH DOUBLE OVERBARLOGICAL AND WITH UNDERBARLOGICAL" +
	" AND WITH DOUBLE UNDERBARSMALL VEE WITH UNDERBARLOGICAL OR WITH DOUBLE O" +
	"VERBARLOGICAL OR WITH DOUBLE UNDERBARZ NOTATION DOMAIN ANTIRESTRICTIONZ " +
	"NOTATION RANGE ANTIRESTRICTIONEQUALS SIGN WITH DOT BELOWIDENTICAL WITH D" +
	"OT ABOVETRIPLE HORIZONTAL BAR WITH DOUBLE VERTICAL STROKETRIPLE HORIZONT" +
	"AL BAR WITH TRIPLE VERTICAL STROKETILDE OPERATOR WITH DOT ABOVETILDE OPE" +
	"RATOR WITH RISING DOTSSIMILAR MINUS SIMILARCONGRUENT WITH DOT ABOVEEQUAL" +
	"S WITH ASTERISKALMOST EQUAL TO WITH CIRCUMFLEX ACCENTAPPROXIMATELY EQUAL" +
	" OR EQUAL TOEQUALS SIGN ABOVE PLUS SIGNPLUS SIGN ABOVE EQUALS SIGNEQUALS" +
	" SIGN ABOVE TILDE OPERATORDOUBLE COLON EQUALTWO CONSECUTIVE EQUALS SIGNS" +
	"THREE CONSECUTIVE EQUALS SIGNSEQUALS SIGN WITH TWO DOTS ABOVE AND TWO DO" +
	"TS BELOWEQUIVALENT WITH FOUR DOTS ABOVELESS-THAN WITH CIRCLE INSIDEGREAT" +
	"ER-THAN WITH CIRCLE INSIDELESS-THAN WITH QUESTION MARK ABOVEGREATER-THAN" +
	" WITH QUESTION MARK ABOVELESS-THAN OR SLANTED EQUAL TOGREATER-THAN OR SL" +
	"ANTED EQUAL TOLESS-THAN OR SLANTED EQUAL TO WITH DOT INSIDEGREATER-THAN " +
	"OR SLANTED EQUAL TO WITH DOT INSIDELESS-THAN OR SLANTED EQUAL TO WITH DO" +
	"T ABOVEGREATER-THAN OR SLANTED EQUAL TO WITH DOT ABOVELESS-THAN OR SLANT" +
	"ED EQUAL TO WITH DOT ABOVE RIGHTGREATER-THAN OR SLANTED EQUAL TO WITH DO" +
	"T ABOVE LEFTLESS-THAN OR APPROXIMATEGREATER-THAN OR APPROXIMATELESS-THAN" +
	" AND SINGLE-LINE NOT EQUAL TOGREATER-THAN AND SINGLE-LINE NOT EQUAL TOLE" +
	"SS-THAN AND NOT APPROXIMATEGREATER-THAN AND NOT APPROXIMATELESS-THAN ABO" +
	"VE DOUBLE-LINE EQUAL ABOVE GREATER-THANGREATER-THAN ABOVE DOUBLE-LINE EQ" +
	"UAL ABOVE LESS-THANLESS-THAN ABOVE SIMILAR OR EQUALGREATER-THAN ABOVE SI" +
	"MILAR OR EQUALLESS-THAN ABOVE SIMILAR ABOVE GREATER-THANGREATER-THAN ABO" +
	"VE SIMILAR ABOVE LESS-THANLESS-THAN ABOVE GREATER-THAN ABOVE DOUBLE-LINE" +
	" EQUALGREATER-THAN ABOVE LESS-THAN ABOVE DOUBLE-LINE EQUALLESS-THAN ABOV" +
	"E SLANTED EQUAL ABOVE GREATER-THAN ABOVE SLANTED EQUALGREATER-THAN ABOVE" +
	" SLANTED EQUAL ABOVE LESS-THAN ABOVE SLANTED EQUALSLANTED EQUAL TO OR LE" +
	"SS-THANSLANTED EQUAL TO OR GREATER-THANSLANTED EQUAL TO OR LESS-THAN WIT" +
	"H DOT INSIDESLANTED EQUAL TO OR GREATER-THAN WITH DOT INSIDEDOUBLE-LINE " +
	"EQUAL TO OR LESS-THANDOUBLE-LINE EQUAL TO OR GREATER-THANDOUBLE-LINE SLA" +
	"NTED EQUAL TO OR LESS-THANDOUBLE-LINE SLANTED EQUAL TO OR GREATER-THANSI" +
	"MILAR OR LESS-THANSIMILAR OR GREATER-THANSIMILAR ABOVE LESS-THAN ABOVE E" +
	"QUALS SIGNSIMILAR ABOVE GREATER-THAN ABOVE EQUALS SIGNDOUBLE NESTED LESS" +
	"-THANDOUBLE NESTED GREATER-THANDOUBLE NESTED LESS-THAN WITH UNDERBARGREA" +
	"TER-THAN OVERLAPPING LESS-THANGREATER-THAN BESIDE LESS-THANLESS-THAN CLO" +
	"SED BY CURVEGREATER-THAN CLOSED BY CURVELESS-THAN CLOSED BY CURVE ABOVE " +
	"SLANTED EQUALGREATER-THAN CLOSED BY CURVE ABOVE SLANTED EQUALSMALLER THA" +
	"NLARGER THANSMALLER THAN OR EQUAL TOLARGER THAN OR EQUAL TOEQUALS SIGN W" +
	"ITH BUMPY ABOVEPRECEDES ABOVE SINGLE-LINE EQUALS SIGNSUCCEEDS ABOVE SING" +
	"LE-LINE EQUALS SIGNPRECEDES ABOVE SINGLE-LINE NOT EQUAL TOSUCCEEDS ABOVE" +
	" SINGLE-LINE NOT EQUAL TOPRECEDES ABOVE EQUALS SIGNSUCCEEDS ABOVE EQUALS") + ("" +
	" SIGNPRECEDES ABOVE NOT EQUAL TOSUCCEEDS ABOVE NOT EQUAL TOPRECEDES ABOV" +
	"E ALMOST EQUAL TOSUCCEEDS ABOVE ALMOST EQUAL TOPRECEDES ABOVE NOT ALMOST" +
	" EQUAL TOSUCCEEDS ABOVE NOT ALMOST EQUAL TODOUBLE PRECEDESDOUBLE SUCCEED" +
	"SSUBSET WITH DOTSUPERSET WITH DOTSUBSET WITH PLUS SIGN BELOWSUPERSET WIT" +
	"H PLUS SIGN BELOWSUBSET WITH MULTIPLICATION SIGN BELOWSUPERSET WITH MULT" +
	"IPLICATION SIGN BELOWSUBSET OF OR EQUAL TO WITH DOT ABOVESUPERSET OF OR " +
	"EQUAL TO WITH DOT ABOVESUBSET OF ABOVE EQUALS SIGNSUPERSET OF ABOVE EQUA" +
	"LS SIGNSUBSET OF ABOVE TILDE OPERATORSUPERSET OF ABOVE TILDE OPERATORSUB" +
	"SET OF ABOVE ALMOST EQUAL TOSUPERSET OF ABOVE ALMOST EQUAL TOSUBSET OF A" +
	"BOVE NOT EQUAL TOSUPERSET OF ABOVE NOT EQUAL TOSQUARE LEFT OPEN BOX OPER" +
	"ATORSQUARE RIGHT OPEN BOX OPERATORCLOSED SUBSETCLOSED SUPERSETCLOSED SUB" +
	"SET OR EQUAL TOCLOSED SUPERSET OR EQUAL TOSUBSET ABOVE SUPERSETSUPERSET " +
	"ABOVE SUBSETSUBSET ABOVE SUBSETSUPERSET ABOVE SUPERSETSUPERSET BESIDE SU" +
	"BSETSUPERSET BESIDE AND JOINED BY DASH WITH SUBSETELEMENT OF OPENING DOW" +
	"NWARDSPITCHFORK WITH TEE TOPTRANSVERSAL INTERSECTIONFORKINGNONFORKINGSHO" +
	"RT LEFT TACKSHORT DOWN TACKSHORT UP TACKPERPENDICULAR WITH SVERTICAL BAR" +
	" TRIPLE RIGHT TURNSTILEDOUBLE VERTICAL BAR LEFT TURNSTILEVERTICAL BAR DO" +
	"UBLE LEFT TURNSTILEDOUBLE VERTICAL BAR DOUBLE LEFT TURNSTILELONG DASH FR" +
	"OM LEFT MEMBER OF DOUBLE VERTICALSHORT DOWN TACK WITH OVERBARSHORT UP TA" +
	"CK WITH UNDERBARSHORT UP TACK ABOVE SHORT DOWN TACKDOUBLE DOWN TACKDOUBL" +
	"E UP TACKDOUBLE STROKE NOT SIGNREVERSED DOUBLE STROKE NOT SIGNDOES NOT D" +
	"IVIDE WITH REVERSED NEGATION SLASHVERTICAL LINE WITH CIRCLE ABOVEVERTICA" +
	"L LINE WITH CIRCLE BELOWDOWN TACK WITH CIRCLE BELOWPARALLEL WITH HORIZON" +
	"TAL STROKEPARALLEL WITH TILDE OPERATORTRIPLE VERTICAL BAR BINARY RELATIO" +
	"NTRIPLE VERTICAL BAR WITH HORIZONTAL STROKETRIPLE COLON OPERATORTRIPLE N" +
	"ESTED LESS-THANTRIPLE NESTED GREATER-THANDOUBLE-LINE SLANTED LESS-THAN O" +
	"R EQUAL TODOUBLE-LINE SLANTED GREATER-THAN OR EQUAL TOTRIPLE SOLIDUS BIN" +
	"ARY RELATIONLARGE TRIPLE VERTICAL BAR OPERATORDOUBLE SOLIDUS OPERATORWHI" +
	"TE VERTICAL BARN-ARY WHITE VERTICAL BARNORTH EAST WHITE ARROWNORTH WEST " +
	"WHITE ARROWSOUTH EAST WHITE ARROWSOUTH WEST WHITE ARROWLEFT RIGHT WHITE " +
	"ARROWLEFTWARDS BLACK ARROWUPWARDS BLACK ARROWDOWNWARDS BLACK ARROWNORTH " +
	"EAST BLACK ARROWNORTH WEST BLACK ARROWSOUTH EAST BLACK ARROWSOUTH WEST B" +
	"LACK ARROWLEFT RIGHT BLACK ARROWUP DOWN BLACK ARROWRIGHTWARDS ARROW WITH" +
	" TIP DOWNWARDSRIGHTWARDS ARROW WITH TIP UPWARDSLEFTWARDS ARROW WITH TIP " +
	"DOWNWARDSLEFTWARDS ARROW WITH TIP UPWARDSSQUARE WITH TOP HALF BLACKSQUAR" +
	"E WITH BOTTOM HALF BLACKSQUARE WITH UPPER RIGHT DIAGONAL HALF BLACKSQUAR" +
	"E WITH LOWER LEFT DIAGONAL HALF BLACKDIAMOND WITH LEFT HALF BLACKDIAMOND" +
	" WITH RIGHT HALF BLACKDIAMOND WITH TOP HALF BLACKDIAMOND WITH BOTTOM HAL" +
	"F BLACKDOTTED SQUAREBLACK LARGE SQUAREWHITE LARGE SQUAREBLACK VERY SMALL" +
	" SQUAREWHITE VERY SMALL SQUAREBLACK PENTAGONWHITE PENTAGONWHITE HEXAGONB" +
	"LACK HEXAGONHORIZONTAL BLACK HEXAGONBLACK LARGE CIRCLEBLACK MEDIUM DIAMO" +
	"NDWHITE MEDIUM DIAMONDBLACK MEDIUM LOZENGEWHITE MEDIUM LOZENGEBLACK SMAL" +
	"L DIAMONDBLACK SMALL LOZENGEWHITE SMALL LOZENGEBLACK HORIZONTAL ELLIPSEW" +
	"HITE HORIZONTAL ELLIPSEBLACK VERTICAL ELLIPSEWHITE VERTICAL ELLIPSELEFT " +
	"ARROW WITH SMALL CIRCLETHREE LEFTWARDS ARROWSLEFT ARROW WITH CIRCLED PLU" +
	"SLONG LEFTWARDS SQUIGGLE ARROWLEFTWARDS TWO-HEADED ARROW WITH VERTICAL S" +
	"TROKELEFTWARDS TWO-HEADED ARROW WITH DOUBLE VERTICAL STROKELEFTWARDS TWO" +
	"-HEADED ARROW FROM BARLEFTWARDS TWO-HEADED TRIPLE DASH ARROWLEFTWARDS AR" +
	"ROW WITH DOTTED STEMLEFTWARDS ARROW WITH TAIL WITH VERTICAL STROKELEFTWA" +
	"RDS ARROW WITH TAIL WITH DOUBLE VERTICAL STROKELEFTWARDS TWO-HEADED ARRO" +
	"W WITH TAILLEFTWARDS TWO-HEADED ARROW WITH TAIL WITH VERTICAL STROKELEFT" +
	"WARDS TWO-HEADED ARROW WITH TAIL WITH DOUBLE VERTICAL STROKELEFTWARDS AR" +
	"ROW THROUGH XWAVE ARROW POINTING DIRECTLY LEFTEQUALS SIGN ABOVE LEFTWARD" +
	"S ARROWREVERSE TILDE OPERATOR ABOVE LEFTWARDS ARROWLEFTWARDS ARROW ABOVE" +
	" REVERSE ALMOST EQUAL TORIGHTWARDS ARROW THROUGH GREATER-THANRIGHTWARDS " +
	"ARROW THROUGH SUPERSETLEFTWARDS QUADRUPLE ARROWRIGHTWARDS QUADRUPLE ARRO" +
	"WREVERSE TILDE OPERATOR ABOVE RIGHTWARDS ARROWRIGHTWARDS ARROW ABOVE REV" +
	"ERSE ALMOST EQUAL TOTILDE OPERATOR ABOVE LEFTWARDS ARROWLEFTWARDS ARROW " +
	"ABOVE ALMOST EQUAL TOLEFTWARDS ARROW ABOVE REVERSE TILDE OPERATORRIGHTWA" +
	"RDS ARROW ABOVE REVERSE TILDE OPERATORDOWNWARDS TRIANGLE-HEADED ZIGZAG A" +
	"RROWSHORT SLANTED NORTH ARROWSHORT BACKSLANTED SOUTH ARROWWHITE MEDIUM S" +
	"TARBLACK SMALL STARWHITE SMALL STARBLACK RIGHT-POINTING PENTAGONWHITE RI" +
	"GHT-POINTING PENTAGONHEAVY LARGE CIRCLEHEAVY OVAL WITH OVAL INSIDEHEAVY " +
	"CIRCLE WITH CIRCLE INSIDEHEAVY CIRCLEHEAVY CIRCLED SALTIRESLANTED NORTH ") + ("" +
	"ARROW WITH HOOKED HEADBACKSLANTED SOUTH ARROW WITH HOOKED TAILSLANTED NO" +
	"RTH ARROW WITH HORIZONTAL TAILBACKSLANTED SOUTH ARROW WITH HORIZONTAL TA" +
	"ILBENT ARROW POINTING DOWNWARDS THEN NORTH EASTSHORT BENT ARROW POINTING" +
	" DOWNWARDS THEN NORTH EASTLEFTWARDS TRIANGLE-HEADED ARROWUPWARDS TRIANGL" +
	"E-HEADED ARROWRIGHTWARDS TRIANGLE-HEADED ARROWDOWNWARDS TRIANGLE-HEADED " +
	"ARROWLEFT RIGHT TRIANGLE-HEADED ARROWUP DOWN TRIANGLE-HEADED ARROWNORTH " +
	"WEST TRIANGLE-HEADED ARROWNORTH EAST TRIANGLE-HEADED ARROWSOUTH EAST TRI" +
	"ANGLE-HEADED ARROWSOUTH WEST TRIANGLE-HEADED ARROWLEFTWARDS TRIANGLE-HEA" +
	"DED DASHED ARROWUPWARDS TRIANGLE-HEADED DASHED ARROWRIGHTWARDS TRIANGLE-" +
	"HEADED DASHED ARROWDOWNWARDS TRIANGLE-HEADED DASHED ARROWCLOCKWISE TRIAN" +
	"GLE-HEADED OPEN CIRCLE ARROWANTICLOCKWISE TRIANGLE-HEADED OPEN CIRCLE AR" +
	"ROWLEFTWARDS TRIANGLE-HEADED ARROW TO BARUPWARDS TRIANGLE-HEADED ARROW T" +
	"O BARRIGHTWARDS TRIANGLE-HEADED ARROW TO BARDOWNWARDS TRIANGLE-HEADED AR" +
	"ROW TO BARNORTH WEST TRIANGLE-HEADED ARROW TO BARNORTH EAST TRIANGLE-HEA" +
	"DED ARROW TO BARSOUTH EAST TRIANGLE-HEADED ARROW TO BARSOUTH WEST TRIANG" +
	"LE-HEADED ARROW TO BARLEFTWARDS TRIANGLE-HEADED ARROW WITH DOUBLE HORIZO" +
	"NTAL STROKEUPWARDS TRIANGLE-HEADED ARROW WITH DOUBLE HORIZONTAL STROKERI" +
	"GHTWARDS TRIANGLE-HEADED ARROW WITH DOUBLE HORIZONTAL STROKEDOWNWARDS TR" +
	"IANGLE-HEADED ARROW WITH DOUBLE HORIZONTAL STROKEHORIZONTAL TAB KEYVERTI" +
	"CAL TAB KEYLEFTWARDS TRIANGLE-HEADED ARROW OVER RIGHTWARDS TRIANGLE-HEAD" +
	"ED ARROWUPWARDS TRIANGLE-HEADED ARROW LEFTWARDS OF DOWNWARDS TRIANGLE-HE" +
	"ADED ARROWRIGHTWARDS TRIANGLE-HEADED ARROW OVER LEFTWARDS TRIANGLE-HEADE" +
	"D ARROWDOWNWARDS TRIANGLE-HEADED ARROW LEFTWARDS OF UPWARDS TRIANGLE-HEA" +
	"DED ARROWLEFTWARDS TRIANGLE-HEADED PAIRED ARROWSUPWARDS TRIANGLE-HEADED " +
	"PAIRED ARROWSRIGHTWARDS TRIANGLE-HEADED PAIRED ARROWSDOWNWARDS TRIANGLE-" +
	"HEADED PAIRED ARROWSLEFTWARDS BLACK CIRCLED WHITE ARROWUPWARDS BLACK CIR" +
	"CLED WHITE ARROWRIGHTWARDS BLACK CIRCLED WHITE ARROWDOWNWARDS BLACK CIRC" +
	"LED WHITE ARROWANTICLOCKWISE TRIANGLE-HEADED RIGHT U-SHAPED ARROWANTICLO" +
	"CKWISE TRIANGLE-HEADED BOTTOM U-SHAPED ARROWANTICLOCKWISE TRIANGLE-HEADE" +
	"D LEFT U-SHAPED ARROWANTICLOCKWISE TRIANGLE-HEADED TOP U-SHAPED ARROWRET" +
	"URN LEFTRETURN RIGHTNEWLINE LEFTNEWLINE RIGHTFOUR CORNER ARROWS CIRCLING" +
	" ANTICLOCKWISERIGHTWARDS BLACK ARROWTHREE-D TOP-LIGHTED LEFTWARDS EQUILA" +
	"TERAL ARROWHEADTHREE-D RIGHT-LIGHTED UPWARDS EQUILATERAL ARROWHEADTHREE-" +
	"D TOP-LIGHTED RIGHTWARDS EQUILATERAL ARROWHEADTHREE-D LEFT-LIGHTED DOWNW" +
	"ARDS EQUILATERAL ARROWHEADBLACK LEFTWARDS EQUILATERAL ARROWHEADBLACK UPW" +
	"ARDS EQUILATERAL ARROWHEADBLACK RIGHTWARDS EQUILATERAL ARROWHEADBLACK DO" +
	"WNWARDS EQUILATERAL ARROWHEADDOWNWARDS TRIANGLE-HEADED ARROW WITH LONG T" +
	"IP LEFTWARDSDOWNWARDS TRIANGLE-HEADED ARROW WITH LONG TIP RIGHTWARDSUPWA" +
	"RDS TRIANGLE-HEADED ARROW WITH LONG TIP LEFTWARDSUPWARDS TRIANGLE-HEADED" +
	" ARROW WITH LONG TIP RIGHTWARDSLEFTWARDS TRIANGLE-HEADED ARROW WITH LONG" +
	" TIP UPWARDSRIGHTWARDS TRIANGLE-HEADED ARROW WITH LONG TIP UPWARDSLEFTWA" +
	"RDS TRIANGLE-HEADED ARROW WITH LONG TIP DOWNWARDSRIGHTWARDS TRIANGLE-HEA" +
	"DED ARROW WITH LONG TIP DOWNWARDSBLACK CURVED DOWNWARDS AND LEFTWARDS AR" +
	"ROWBLACK CURVED DOWNWARDS AND RIGHTWARDS ARROWBLACK CURVED UPWARDS AND L" +
	"EFTWARDS ARROWBLACK CURVED UPWARDS AND RIGHTWARDS ARROWBLACK CURVED LEFT" +
	"WARDS AND UPWARDS ARROWBLACK CURVED RIGHTWARDS AND UPWARDS ARROWBLACK CU" +
	"RVED LEFTWARDS AND DOWNWARDS ARROWBLACK CURVED RIGHTWARDS AND DOWNWARDS " +
	"ARROWRIBBON ARROW DOWN LEFTRIBBON ARROW DOWN RIGHTRIBBON ARROW UP LEFTRI" +
	"BBON ARROW UP RIGHTRIBBON ARROW LEFT UPRIBBON ARROW RIGHT UPRIBBON ARROW" +
	" LEFT DOWNRIBBON ARROW RIGHT DOWNUPWARDS WHITE ARROW FROM BAR WITH HORIZ" +
	"ONTAL BARUP ARROWHEAD IN A RECTANGLE BOXBALLOT BOX WITH LIGHT XCIRCLED X" +
	"CIRCLED BOLD XBLACK SQUARE CENTREDBLACK DIAMOND CENTREDTURNED BLACK PENT" +
	"AGONHORIZONTAL BLACK OCTAGONBLACK OCTAGONBLACK MEDIUM UP-POINTING TRIANG" +
	"LE CENTREDBLACK MEDIUM DOWN-POINTING TRIANGLE CENTREDBLACK MEDIUM LEFT-P" +
	"OINTING TRIANGLE CENTREDBLACK MEDIUM RIGHT-POINTING TRIANGLE CENTREDTOP " +
	"HALF BLACK CIRCLEBOTTOM HALF BLACK CIRCLELIGHT FOUR POINTED BLACK CUSPRO" +
	"TATED LIGHT FOUR POINTED BLACK CUSPWHITE FOUR POINTED CUSPROTATED WHITE " +
	"FOUR POINTED CUSPSQUARE POSITION INDICATORUNCERTAINTY SIGNLEFTWARDS TWO-" +
	"HEADED ARROW WITH TRIANGLE ARROWHEADSUPWARDS TWO-HEADED ARROW WITH TRIAN" +
	"GLE ARROWHEADSRIGHTWARDS TWO-HEADED ARROW WITH TRIANGLE ARROWHEADSDOWNWA" +
	"RDS TWO-HEADED ARROW WITH TRIANGLE ARROWHEADSGLAGOLITIC CAPITAL LETTER A" +
	"ZUGLAGOLITIC CAPITAL LETTER BUKYGLAGOLITIC CAPITAL LETTER VEDEGLAGOLITIC" +
	" CAPITAL LETTER GLAGOLIGLAGOLITIC CAPITAL LETTER DOBROGLAGOLITIC CAPITAL" +
	" LETTER YESTUGLAGOLITIC CAPITAL LETTER ZHIVETEGLAGOLITIC CAPITAL LETTER ") + ("" +
	"DZELOGLAGOLITIC CAPITAL LETTER ZEMLJAGLAGOLITIC CAPITAL LETTER IZHEGLAGO" +
	"LITIC CAPITAL LETTER INITIAL IZHEGLAGOLITIC CAPITAL LETTER IGLAGOLITIC C" +
	"APITAL LETTER DJERVIGLAGOLITIC CAPITAL LETTER KAKOGLAGOLITIC CAPITAL LET" +
	"TER LJUDIJEGLAGOLITIC CAPITAL LETTER MYSLITEGLAGOLITIC CAPITAL LETTER NA" +
	"SHIGLAGOLITIC CAPITAL LETTER ONUGLAGOLITIC CAPITAL LETTER POKOJIGLAGOLIT" +
	"IC CAPITAL LETTER RITSIGLAGOLITIC CAPITAL LETTER SLOVOGLAGOLITIC CAPITAL" +
	" LETTER TVRIDOGLAGOLITIC CAPITAL LETTER UKUGLAGOLITIC CAPITAL LETTER FRI" +
	"TUGLAGOLITIC CAPITAL LETTER HERUGLAGOLITIC CAPITAL LETTER OTUGLAGOLITIC " +
	"CAPITAL LETTER PEGLAGOLITIC CAPITAL LETTER SHTAGLAGOLITIC CAPITAL LETTER" +
	" TSIGLAGOLITIC CAPITAL LETTER CHRIVIGLAGOLITIC CAPITAL LETTER SHAGLAGOLI" +
	"TIC CAPITAL LETTER YERUGLAGOLITIC CAPITAL LETTER YERIGLAGOLITIC CAPITAL " +
	"LETTER YATIGLAGOLITIC CAPITAL LETTER SPIDERY HAGLAGOLITIC CAPITAL LETTER" +
	" YUGLAGOLITIC CAPITAL LETTER SMALL YUSGLAGOLITIC CAPITAL LETTER SMALL YU" +
	"S WITH TAILGLAGOLITIC CAPITAL LETTER YOGLAGOLITIC CAPITAL LETTER IOTATED" +
	" SMALL YUSGLAGOLITIC CAPITAL LETTER BIG YUSGLAGOLITIC CAPITAL LETTER IOT" +
	"ATED BIG YUSGLAGOLITIC CAPITAL LETTER FITAGLAGOLITIC CAPITAL LETTER IZHI" +
	"TSAGLAGOLITIC CAPITAL LETTER SHTAPICGLAGOLITIC CAPITAL LETTER TROKUTASTI" +
	" AGLAGOLITIC CAPITAL LETTER LATINATE MYSLITEGLAGOLITIC SMALL LETTER AZUG" +
	"LAGOLITIC SMALL LETTER BUKYGLAGOLITIC SMALL LETTER VEDEGLAGOLITIC SMALL " +
	"LETTER GLAGOLIGLAGOLITIC SMALL LETTER DOBROGLAGOLITIC SMALL LETTER YESTU" +
	"GLAGOLITIC SMALL LETTER ZHIVETEGLAGOLITIC SMALL LETTER DZELOGLAGOLITIC S" +
	"MALL LETTER ZEMLJAGLAGOLITIC SMALL LETTER IZHEGLAGOLITIC SMALL LETTER IN" +
	"ITIAL IZHEGLAGOLITIC SMALL LETTER IGLAGOLITIC SMALL LETTER DJERVIGLAGOLI" +
	"TIC SMALL LETTER KAKOGLAGOLITIC SMALL LETTER LJUDIJEGLAGOLITIC SMALL LET" +
	"TER MYSLITEGLAGOLITIC SMALL LETTER NASHIGLAGOLITIC SMALL LETTER ONUGLAGO" +
	"LITIC SMALL LETTER POKOJIGLAGOLITIC SMALL LETTER RITSIGLAGOLITIC SMALL L" +
	"ETTER SLOVOGLAGOLITIC SMALL LETTER TVRIDOGLAGOLITIC SMALL LETTER UKUGLAG" +
	"OLITIC SMALL LETTER FRITUGLAGOLITIC SMALL LETTER HERUGLAGOLITIC SMALL LE" +
	"TTER OTUGLAGOLITIC SMALL LETTER PEGLAGOLITIC SMALL LETTER SHTAGLAGOLITIC" +
	" SMALL LETTER TSIGLAGOLITIC SMALL LETTER CHRIVIGLAGOLITIC SMALL LETTER S" +
	"HAGLAGOLITIC SMALL LETTER YERUGLAGOLITIC SMALL LETTER YERIGLAGOLITIC SMA" +
	"LL LETTER YATIGLAGOLITIC SMALL LETTER SPIDERY HAGLAGOLITIC SMALL LETTER " +
	"YUGLAGOLITIC SMALL LETTER SMALL YUSGLAGOLITIC SMALL LETTER SMALL YUS WIT" +
	"H TAILGLAGOLITIC SMALL LETTER YOGLAGOLITIC SMALL LETTER IOTATED SMALL YU" +
	"SGLAGOLITIC SMALL LETTER BIG YUSGLAGOLITIC SMALL LETTER IOTATED BIG YUSG" +
	"LAGOLITIC SMALL LETTER FITAGLAGOLITIC SMALL LETTER IZHITSAGLAGOLITIC SMA" +
	"LL LETTER SHTAPICGLAGOLITIC SMALL LETTER TROKUTASTI AGLAGOLITIC SMALL LE" +
	"TTER LATINATE MYSLITELATIN CAPITAL LETTER L WITH DOUBLE BARLATIN SMALL L" +
	"ETTER L WITH DOUBLE BARLATIN CAPITAL LETTER L WITH MIDDLE TILDELATIN CAP" +
	"ITAL LETTER P WITH STROKELATIN CAPITAL LETTER R WITH TAILLATIN SMALL LET" +
	"TER A WITH STROKELATIN SMALL LETTER T WITH DIAGONAL STROKELATIN CAPITAL " +
	"LETTER H WITH DESCENDERLATIN SMALL LETTER H WITH DESCENDERLATIN CAPITAL " +
	"LETTER K WITH DESCENDERLATIN SMALL LETTER K WITH DESCENDERLATIN CAPITAL " +
	"LETTER Z WITH DESCENDERLATIN SMALL LETTER Z WITH DESCENDERLATIN CAPITAL " +
	"LETTER ALPHALATIN CAPITAL LETTER M WITH HOOKLATIN CAPITAL LETTER TURNED " +
	"ALATIN CAPITAL LETTER TURNED ALPHALATIN SMALL LETTER V WITH RIGHT HOOKLA" +
	"TIN CAPITAL LETTER W WITH HOOKLATIN SMALL LETTER W WITH HOOKLATIN SMALL " +
	"LETTER V WITH CURLLATIN CAPITAL LETTER HALF HLATIN SMALL LETTER HALF HLA" +
	"TIN SMALL LETTER TAILLESS PHILATIN SMALL LETTER E WITH NOTCHLATIN SMALL " +
	"LETTER TURNED R WITH TAILLATIN SMALL LETTER O WITH LOW RING INSIDELATIN " +
	"LETTER SMALL CAPITAL TURNED ELATIN SUBSCRIPT SMALL LETTER JMODIFIER LETT" +
	"ER CAPITAL VLATIN CAPITAL LETTER S WITH SWASH TAILLATIN CAPITAL LETTER Z" +
	" WITH SWASH TAILCOPTIC CAPITAL LETTER ALFACOPTIC SMALL LETTER ALFACOPTIC" +
	" CAPITAL LETTER VIDACOPTIC SMALL LETTER VIDACOPTIC CAPITAL LETTER GAMMAC" +
	"OPTIC SMALL LETTER GAMMACOPTIC CAPITAL LETTER DALDACOPTIC SMALL LETTER D" +
	"ALDACOPTIC CAPITAL LETTER EIECOPTIC SMALL LETTER EIECOPTIC CAPITAL LETTE" +
	"R SOUCOPTIC SMALL LETTER SOUCOPTIC CAPITAL LETTER ZATACOPTIC SMALL LETTE" +
	"R ZATACOPTIC CAPITAL LETTER HATECOPTIC SMALL LETTER HATECOPTIC CAPITAL L" +
	"ETTER THETHECOPTIC SMALL LETTER THETHECOPTIC CAPITAL LETTER IAUDACOPTIC " +
	"SMALL LETTER IAUDACOPTIC CAPITAL LETTER KAPACOPTIC SMALL LETTER KAPACOPT" +
	"IC CAPITAL LETTER LAULACOPTIC SMALL LETTER LAULACOPTIC CAPITAL LETTER MI" +
	"COPTIC SMALL LETTER MICOPTIC CAPITAL LETTER NICOPTIC SMALL LETTER NICOPT" +
	"IC CAPITAL LETTER KSICOPTIC SMALL LETTER KSICOPTIC CAPITAL LETTER OCOPTI" +
	"C SMALL LETTER OCOPTIC CAPITAL LETTER PICOPTIC SMALL LETTER PICOPTIC CAP") + ("" +
	"ITAL LETTER ROCOPTIC SMALL LETTER ROCOPTIC CAPITAL LETTER SIMACOPTIC SMA" +
	"LL LETTER SIMACOPTIC CAPITAL LETTER TAUCOPTIC SMALL LETTER TAUCOPTIC CAP" +
	"ITAL LETTER UACOPTIC SMALL LETTER UACOPTIC CAPITAL LETTER FICOPTIC SMALL" +
	" LETTER FICOPTIC CAPITAL LETTER KHICOPTIC SMALL LETTER KHICOPTIC CAPITAL" +
	" LETTER PSICOPTIC SMALL LETTER PSICOPTIC CAPITAL LETTER OOUCOPTIC SMALL " +
	"LETTER OOUCOPTIC CAPITAL LETTER DIALECT-P ALEFCOPTIC SMALL LETTER DIALEC" +
	"T-P ALEFCOPTIC CAPITAL LETTER OLD COPTIC AINCOPTIC SMALL LETTER OLD COPT" +
	"IC AINCOPTIC CAPITAL LETTER CRYPTOGRAMMIC EIECOPTIC SMALL LETTER CRYPTOG" +
	"RAMMIC EIECOPTIC CAPITAL LETTER DIALECT-P KAPACOPTIC SMALL LETTER DIALEC" +
	"T-P KAPACOPTIC CAPITAL LETTER DIALECT-P NICOPTIC SMALL LETTER DIALECT-P " +
	"NICOPTIC CAPITAL LETTER CRYPTOGRAMMIC NICOPTIC SMALL LETTER CRYPTOGRAMMI" +
	"C NICOPTIC CAPITAL LETTER OLD COPTIC OOUCOPTIC SMALL LETTER OLD COPTIC O" +
	"OUCOPTIC CAPITAL LETTER SAMPICOPTIC SMALL LETTER SAMPICOPTIC CAPITAL LET" +
	"TER CROSSED SHEICOPTIC SMALL LETTER CROSSED SHEICOPTIC CAPITAL LETTER OL" +
	"D COPTIC SHEICOPTIC SMALL LETTER OLD COPTIC SHEICOPTIC CAPITAL LETTER OL" +
	"D COPTIC ESHCOPTIC SMALL LETTER OLD COPTIC ESHCOPTIC CAPITAL LETTER AKHM" +
	"IMIC KHEICOPTIC SMALL LETTER AKHMIMIC KHEICOPTIC CAPITAL LETTER DIALECT-" +
	"P HORICOPTIC SMALL LETTER DIALECT-P HORICOPTIC CAPITAL LETTER OLD COPTIC" +
	" HORICOPTIC SMALL LETTER OLD COPTIC HORICOPTIC CAPITAL LETTER OLD COPTIC" +
	" HACOPTIC SMALL LETTER OLD COPTIC HACOPTIC CAPITAL LETTER L-SHAPED HACOP" +
	"TIC SMALL LETTER L-SHAPED HACOPTIC CAPITAL LETTER OLD COPTIC HEICOPTIC S" +
	"MALL LETTER OLD COPTIC HEICOPTIC CAPITAL LETTER OLD COPTIC HATCOPTIC SMA" +
	"LL LETTER OLD COPTIC HATCOPTIC CAPITAL LETTER OLD COPTIC GANGIACOPTIC SM" +
	"ALL LETTER OLD COPTIC GANGIACOPTIC CAPITAL LETTER OLD COPTIC DJACOPTIC S" +
	"MALL LETTER OLD COPTIC DJACOPTIC CAPITAL LETTER OLD COPTIC SHIMACOPTIC S" +
	"MALL LETTER OLD COPTIC SHIMACOPTIC CAPITAL LETTER OLD NUBIAN SHIMACOPTIC" +
	" SMALL LETTER OLD NUBIAN SHIMACOPTIC CAPITAL LETTER OLD NUBIAN NGICOPTIC" +
	" SMALL LETTER OLD NUBIAN NGICOPTIC CAPITAL LETTER OLD NUBIAN NYICOPTIC S" +
	"MALL LETTER OLD NUBIAN NYICOPTIC CAPITAL LETTER OLD NUBIAN WAUCOPTIC SMA" +
	"LL LETTER OLD NUBIAN WAUCOPTIC SYMBOL KAICOPTIC SYMBOL MI ROCOPTIC SYMBO" +
	"L PI ROCOPTIC SYMBOL STAUROSCOPTIC SYMBOL TAU ROCOPTIC SYMBOL KHI ROCOPT" +
	"IC SYMBOL SHIMA SIMACOPTIC CAPITAL LETTER CRYPTOGRAMMIC SHEICOPTIC SMALL" +
	" LETTER CRYPTOGRAMMIC SHEICOPTIC CAPITAL LETTER CRYPTOGRAMMIC GANGIACOPT" +
	"IC SMALL LETTER CRYPTOGRAMMIC GANGIACOPTIC COMBINING NI ABOVECOPTIC COMB" +
	"INING SPIRITUS ASPERCOPTIC COMBINING SPIRITUS LENISCOPTIC CAPITAL LETTER" +
	" BOHAIRIC KHEICOPTIC SMALL LETTER BOHAIRIC KHEICOPTIC OLD NUBIAN FULL ST" +
	"OPCOPTIC OLD NUBIAN DIRECT QUESTION MARKCOPTIC OLD NUBIAN INDIRECT QUEST" +
	"ION MARKCOPTIC OLD NUBIAN VERSE DIVIDERCOPTIC FRACTION ONE HALFCOPTIC FU" +
	"LL STOPCOPTIC MORPHOLOGICAL DIVIDERGEORGIAN SMALL LETTER ANGEORGIAN SMAL" +
	"L LETTER BANGEORGIAN SMALL LETTER GANGEORGIAN SMALL LETTER DONGEORGIAN S" +
	"MALL LETTER ENGEORGIAN SMALL LETTER VINGEORGIAN SMALL LETTER ZENGEORGIAN" +
	" SMALL LETTER TANGEORGIAN SMALL LETTER INGEORGIAN SMALL LETTER KANGEORGI" +
	"AN SMALL LETTER LASGEORGIAN SMALL LETTER MANGEORGIAN SMALL LETTER NARGEO" +
	"RGIAN SMALL LETTER ONGEORGIAN SMALL LETTER PARGEORGIAN SMALL LETTER ZHAR" +
	"GEORGIAN SMALL LETTER RAEGEORGIAN SMALL LETTER SANGEORGIAN SMALL LETTER " +
	"TARGEORGIAN SMALL LETTER UNGEORGIAN SMALL LETTER PHARGEORGIAN SMALL LETT" +
	"ER KHARGEORGIAN SMALL LETTER GHANGEORGIAN SMALL LETTER QARGEORGIAN SMALL" +
	" LETTER SHINGEORGIAN SMALL LETTER CHINGEORGIAN SMALL LETTER CANGEORGIAN " +
	"SMALL LETTER JILGEORGIAN SMALL LETTER CILGEORGIAN SMALL LETTER CHARGEORG" +
	"IAN SMALL LETTER XANGEORGIAN SMALL LETTER JHANGEORGIAN SMALL LETTER HAEG" +
	"EORGIAN SMALL LETTER HEGEORGIAN SMALL LETTER HIEGEORGIAN SMALL LETTER WE" +
	"GEORGIAN SMALL LETTER HARGEORGIAN SMALL LETTER HOEGEORGIAN SMALL LETTER " +
	"YNGEORGIAN SMALL LETTER AENTIFINAGH LETTER YATIFINAGH LETTER YABTIFINAGH" +
	" LETTER YABHTIFINAGH LETTER YAGTIFINAGH LETTER YAGHHTIFINAGH LETTER BERB" +
	"ER ACADEMY YAJTIFINAGH LETTER YAJTIFINAGH LETTER YADTIFINAGH LETTER YADH" +
	"TIFINAGH LETTER YADDTIFINAGH LETTER YADDHTIFINAGH LETTER YEYTIFINAGH LET" +
	"TER YAFTIFINAGH LETTER YAKTIFINAGH LETTER TUAREG YAKTIFINAGH LETTER YAKH" +
	"HTIFINAGH LETTER YAHTIFINAGH LETTER BERBER ACADEMY YAHTIFINAGH LETTER TU" +
	"AREG YAHTIFINAGH LETTER YAHHTIFINAGH LETTER YAATIFINAGH LETTER YAKHTIFIN" +
	"AGH LETTER TUAREG YAKHTIFINAGH LETTER YAQTIFINAGH LETTER TUAREG YAQTIFIN" +
	"AGH LETTER YITIFINAGH LETTER YAZHTIFINAGH LETTER AHAGGAR YAZHTIFINAGH LE" +
	"TTER TUAREG YAZHTIFINAGH LETTER YALTIFINAGH LETTER YAMTIFINAGH LETTER YA" +
	"NTIFINAGH LETTER TUAREG YAGNTIFINAGH LETTER TUAREG YANGTIFINAGH LETTER Y" +
	"APTIFINAGH LETTER YUTIFINAGH LETTER YARTIFINAGH LETTER YARRTIFINAGH LETT") + ("" +
	"ER YAGHTIFINAGH LETTER TUAREG YAGHTIFINAGH LETTER AYER YAGHTIFINAGH LETT" +
	"ER YASTIFINAGH LETTER YASSTIFINAGH LETTER YASHTIFINAGH LETTER YATTIFINAG" +
	"H LETTER YATHTIFINAGH LETTER YACHTIFINAGH LETTER YATTTIFINAGH LETTER YAV" +
	"TIFINAGH LETTER YAWTIFINAGH LETTER YAYTIFINAGH LETTER YAZTIFINAGH LETTER" +
	" TAWELLEMET YAZTIFINAGH LETTER YAZZTIFINAGH LETTER YETIFINAGH LETTER YOT" +
	"IFINAGH MODIFIER LETTER LABIALIZATION MARKTIFINAGH SEPARATOR MARKTIFINAG" +
	"H CONSONANT JOINERETHIOPIC SYLLABLE LOAETHIOPIC SYLLABLE MOAETHIOPIC SYL" +
	"LABLE ROAETHIOPIC SYLLABLE SOAETHIOPIC SYLLABLE SHOAETHIOPIC SYLLABLE BO" +
	"AETHIOPIC SYLLABLE TOAETHIOPIC SYLLABLE COAETHIOPIC SYLLABLE NOAETHIOPIC" +
	" SYLLABLE NYOAETHIOPIC SYLLABLE GLOTTAL OAETHIOPIC SYLLABLE ZOAETHIOPIC " +
	"SYLLABLE DOAETHIOPIC SYLLABLE DDOAETHIOPIC SYLLABLE JOAETHIOPIC SYLLABLE" +
	" THOAETHIOPIC SYLLABLE CHOAETHIOPIC SYLLABLE PHOAETHIOPIC SYLLABLE POAET" +
	"HIOPIC SYLLABLE GGWAETHIOPIC SYLLABLE GGWIETHIOPIC SYLLABLE GGWEEETHIOPI" +
	"C SYLLABLE GGWEETHIOPIC SYLLABLE SSAETHIOPIC SYLLABLE SSUETHIOPIC SYLLAB" +
	"LE SSIETHIOPIC SYLLABLE SSAAETHIOPIC SYLLABLE SSEEETHIOPIC SYLLABLE SSEE" +
	"THIOPIC SYLLABLE SSOETHIOPIC SYLLABLE CCAETHIOPIC SYLLABLE CCUETHIOPIC S" +
	"YLLABLE CCIETHIOPIC SYLLABLE CCAAETHIOPIC SYLLABLE CCEEETHIOPIC SYLLABLE" +
	" CCEETHIOPIC SYLLABLE CCOETHIOPIC SYLLABLE ZZAETHIOPIC SYLLABLE ZZUETHIO" +
	"PIC SYLLABLE ZZIETHIOPIC SYLLABLE ZZAAETHIOPIC SYLLABLE ZZEEETHIOPIC SYL" +
	"LABLE ZZEETHIOPIC SYLLABLE ZZOETHIOPIC SYLLABLE CCHAETHIOPIC SYLLABLE CC" +
	"HUETHIOPIC SYLLABLE CCHIETHIOPIC SYLLABLE CCHAAETHIOPIC SYLLABLE CCHEEET" +
	"HIOPIC SYLLABLE CCHEETHIOPIC SYLLABLE CCHOETHIOPIC SYLLABLE QYAETHIOPIC " +
	"SYLLABLE QYUETHIOPIC SYLLABLE QYIETHIOPIC SYLLABLE QYAAETHIOPIC SYLLABLE" +
	" QYEEETHIOPIC SYLLABLE QYEETHIOPIC SYLLABLE QYOETHIOPIC SYLLABLE KYAETHI" +
	"OPIC SYLLABLE KYUETHIOPIC SYLLABLE KYIETHIOPIC SYLLABLE KYAAETHIOPIC SYL" +
	"LABLE KYEEETHIOPIC SYLLABLE KYEETHIOPIC SYLLABLE KYOETHIOPIC SYLLABLE XY" +
	"AETHIOPIC SYLLABLE XYUETHIOPIC SYLLABLE XYIETHIOPIC SYLLABLE XYAAETHIOPI" +
	"C SYLLABLE XYEEETHIOPIC SYLLABLE XYEETHIOPIC SYLLABLE XYOETHIOPIC SYLLAB" +
	"LE GYAETHIOPIC SYLLABLE GYUETHIOPIC SYLLABLE GYIETHIOPIC SYLLABLE GYAAET" +
	"HIOPIC SYLLABLE GYEEETHIOPIC SYLLABLE GYEETHIOPIC SYLLABLE GYOCOMBINING " +
	"CYRILLIC LETTER BECOMBINING CYRILLIC LETTER VECOMBINING CYRILLIC LETTER " +
	"GHECOMBINING CYRILLIC LETTER DECOMBINING CYRILLIC LETTER ZHECOMBINING CY" +
	"RILLIC LETTER ZECOMBINING CYRILLIC LETTER KACOMBINING CYRILLIC LETTER EL" +
	"COMBINING CYRILLIC LETTER EMCOMBINING CYRILLIC LETTER ENCOMBINING CYRILL" +
	"IC LETTER OCOMBINING CYRILLIC LETTER PECOMBINING CYRILLIC LETTER ERCOMBI" +
	"NING CYRILLIC LETTER ESCOMBINING CYRILLIC LETTER TECOMBINING CYRILLIC LE" +
	"TTER HACOMBINING CYRILLIC LETTER TSECOMBINING CYRILLIC LETTER CHECOMBINI" +
	"NG CYRILLIC LETTER SHACOMBINING CYRILLIC LETTER SHCHACOMBINING CYRILLIC " +
	"LETTER FITACOMBINING CYRILLIC LETTER ES-TECOMBINING CYRILLIC LETTER ACOM" +
	"BINING CYRILLIC LETTER IECOMBINING CYRILLIC LETTER DJERVCOMBINING CYRILL" +
	"IC LETTER MONOGRAPH UKCOMBINING CYRILLIC LETTER YATCOMBINING CYRILLIC LE" +
	"TTER YUCOMBINING CYRILLIC LETTER IOTIFIED ACOMBINING CYRILLIC LETTER LIT" +
	"TLE YUSCOMBINING CYRILLIC LETTER BIG YUSCOMBINING CYRILLIC LETTER IOTIFI" +
	"ED BIG YUSRIGHT ANGLE SUBSTITUTION MARKERRIGHT ANGLE DOTTED SUBSTITUTION" +
	" MARKERLEFT SUBSTITUTION BRACKETRIGHT SUBSTITUTION BRACKETLEFT DOTTED SU" +
	"BSTITUTION BRACKETRIGHT DOTTED SUBSTITUTION BRACKETRAISED INTERPOLATION " +
	"MARKERRAISED DOTTED INTERPOLATION MARKERDOTTED TRANSPOSITION MARKERLEFT " +
	"TRANSPOSITION BRACKETRIGHT TRANSPOSITION BRACKETRAISED SQUARELEFT RAISED" +
	" OMISSION BRACKETRIGHT RAISED OMISSION BRACKETEDITORIAL CORONISPARAGRAPH" +
	"OSFORKED PARAGRAPHOSREVERSED FORKED PARAGRAPHOSHYPODIASTOLEDOTTED OBELOS" +
	"DOWNWARDS ANCORAUPWARDS ANCORADOTTED RIGHT-POINTING ANGLEDOUBLE OBLIQUE " +
	"HYPHENINVERTED INTERROBANGPALM BRANCHHYPHEN WITH DIAERESISTILDE WITH RIN" +
	"G ABOVELEFT LOW PARAPHRASE BRACKETRIGHT LOW PARAPHRASE BRACKETTILDE WITH" +
	" DOT ABOVETILDE WITH DOT BELOWLEFT VERTICAL BAR WITH QUILLRIGHT VERTICAL" +
	" BAR WITH QUILLTOP LEFT HALF BRACKETTOP RIGHT HALF BRACKETBOTTOM LEFT HA" +
	"LF BRACKETBOTTOM RIGHT HALF BRACKETLEFT SIDEWAYS U BRACKETRIGHT SIDEWAYS" +
	" U BRACKETLEFT DOUBLE PARENTHESISRIGHT DOUBLE PARENTHESISTWO DOTS OVER O" +
	"NE DOT PUNCTUATIONONE DOT OVER TWO DOTS PUNCTUATIONSQUARED FOUR DOT PUNC" +
	"TUATIONFIVE DOT MARKREVERSED QUESTION MARKVERTICAL TILDERING POINTWORD S" +
	"EPARATOR MIDDLE DOTTURNED COMMARAISED DOTRAISED COMMATURNED SEMICOLONDAG" +
	"GER WITH LEFT GUARDDAGGER WITH RIGHT GUARDTURNED DAGGERTOP HALF SECTION " +
	"SIGNTWO-EM DASHTHREE-EM DASHSTENOGRAPHIC FULL STOPVERTICAL SIX DOTSWIGGL" +
	"Y VERTICAL LINECAPITULUMDOUBLE HYPHENREVERSED COMMADOUBLE LOW-REVERSED-9" +
	" QUOTATION MARKDASH WITH LEFT UPTURNDOUBLE SUSPENSION MARKCJK RADICAL RE") + ("" +
	"PEATCJK RADICAL CLIFFCJK RADICAL SECOND ONECJK RADICAL SECOND TWOCJK RAD" +
	"ICAL SECOND THREECJK RADICAL PERSONCJK RADICAL BOXCJK RADICAL TABLECJK R" +
	"ADICAL KNIFE ONECJK RADICAL KNIFE TWOCJK RADICAL DIVINATIONCJK RADICAL S" +
	"EALCJK RADICAL SMALL ONECJK RADICAL SMALL TWOCJK RADICAL LAME ONECJK RAD" +
	"ICAL LAME TWOCJK RADICAL LAME THREECJK RADICAL LAME FOURCJK RADICAL SNAK" +
	"ECJK RADICAL THREADCJK RADICAL SNOUT ONECJK RADICAL SNOUT TWOCJK RADICAL" +
	" HEART ONECJK RADICAL HEART TWOCJK RADICAL HANDCJK RADICAL RAPCJK RADICA" +
	"L CHOKECJK RADICAL SUNCJK RADICAL MOONCJK RADICAL DEATHCJK RADICAL MOTHE" +
	"RCJK RADICAL CIVILIANCJK RADICAL WATER ONECJK RADICAL WATER TWOCJK RADIC" +
	"AL FIRECJK RADICAL PAW ONECJK RADICAL PAW TWOCJK RADICAL SIMPLIFIED HALF" +
	" TREE TRUNKCJK RADICAL COWCJK RADICAL DOGCJK RADICAL JADECJK RADICAL BOL" +
	"T OF CLOTHCJK RADICAL EYECJK RADICAL SPIRIT ONECJK RADICAL SPIRIT TWOCJK" +
	" RADICAL BAMBOOCJK RADICAL SILKCJK RADICAL C-SIMPLIFIED SILKCJK RADICAL " +
	"NET ONECJK RADICAL NET TWOCJK RADICAL NET THREECJK RADICAL NET FOURCJK R" +
	"ADICAL MESHCJK RADICAL SHEEPCJK RADICAL RAMCJK RADICAL EWECJK RADICAL OL" +
	"DCJK RADICAL BRUSH ONECJK RADICAL BRUSH TWOCJK RADICAL MEATCJK RADICAL M" +
	"ORTARCJK RADICAL GRASS ONECJK RADICAL GRASS TWOCJK RADICAL GRASS THREECJ" +
	"K RADICAL TIGERCJK RADICAL CLOTHESCJK RADICAL WEST ONECJK RADICAL WEST T" +
	"WOCJK RADICAL C-SIMPLIFIED SEECJK RADICAL SIMPLIFIED HORNCJK RADICAL HOR" +
	"NCJK RADICAL C-SIMPLIFIED SPEECHCJK RADICAL C-SIMPLIFIED SHELLCJK RADICA" +
	"L FOOTCJK RADICAL C-SIMPLIFIED CARTCJK RADICAL SIMPLIFIED WALKCJK RADICA" +
	"L WALK ONECJK RADICAL WALK TWOCJK RADICAL CITYCJK RADICAL C-SIMPLIFIED G" +
	"OLDCJK RADICAL LONG ONECJK RADICAL LONG TWOCJK RADICAL C-SIMPLIFIED LONG" +
	"CJK RADICAL C-SIMPLIFIED GATECJK RADICAL MOUND ONECJK RADICAL MOUND TWOC" +
	"JK RADICAL RAINCJK RADICAL BLUECJK RADICAL C-SIMPLIFIED TANNED LEATHERCJ" +
	"K RADICAL C-SIMPLIFIED LEAFCJK RADICAL C-SIMPLIFIED WINDCJK RADICAL C-SI" +
	"MPLIFIED FLYCJK RADICAL EAT ONECJK RADICAL EAT TWOCJK RADICAL EAT THREEC" +
	"JK RADICAL C-SIMPLIFIED EATCJK RADICAL HEADCJK RADICAL C-SIMPLIFIED HORS" +
	"ECJK RADICAL BONECJK RADICAL GHOSTCJK RADICAL C-SIMPLIFIED FISHCJK RADIC" +
	"AL C-SIMPLIFIED BIRDCJK RADICAL C-SIMPLIFIED SALTCJK RADICAL SIMPLIFIED " +
	"WHEATCJK RADICAL SIMPLIFIED YELLOWCJK RADICAL C-SIMPLIFIED FROGCJK RADIC" +
	"AL J-SIMPLIFIED EVENCJK RADICAL C-SIMPLIFIED EVENCJK RADICAL J-SIMPLIFIE" +
	"D TOOTHCJK RADICAL C-SIMPLIFIED TOOTHCJK RADICAL J-SIMPLIFIED DRAGONCJK " +
	"RADICAL C-SIMPLIFIED DRAGONCJK RADICAL TURTLECJK RADICAL J-SIMPLIFIED TU" +
	"RTLECJK RADICAL C-SIMPLIFIED TURTLEKANGXI RADICAL ONEKANGXI RADICAL LINE" +
	"KANGXI RADICAL DOTKANGXI RADICAL SLASHKANGXI RADICAL SECONDKANGXI RADICA" +
	"L HOOKKANGXI RADICAL TWOKANGXI RADICAL LIDKANGXI RADICAL MANKANGXI RADIC" +
	"AL LEGSKANGXI RADICAL ENTERKANGXI RADICAL EIGHTKANGXI RADICAL DOWN BOXKA" +
	"NGXI RADICAL COVERKANGXI RADICAL ICEKANGXI RADICAL TABLEKANGXI RADICAL O" +
	"PEN BOXKANGXI RADICAL KNIFEKANGXI RADICAL POWERKANGXI RADICAL WRAPKANGXI" +
	" RADICAL SPOONKANGXI RADICAL RIGHT OPEN BOXKANGXI RADICAL HIDING ENCLOSU" +
	"REKANGXI RADICAL TENKANGXI RADICAL DIVINATIONKANGXI RADICAL SEALKANGXI R" +
	"ADICAL CLIFFKANGXI RADICAL PRIVATEKANGXI RADICAL AGAINKANGXI RADICAL MOU" +
	"THKANGXI RADICAL ENCLOSUREKANGXI RADICAL EARTHKANGXI RADICAL SCHOLARKANG" +
	"XI RADICAL GOKANGXI RADICAL GO SLOWLYKANGXI RADICAL EVENINGKANGXI RADICA" +
	"L BIGKANGXI RADICAL WOMANKANGXI RADICAL CHILDKANGXI RADICAL ROOFKANGXI R" +
	"ADICAL INCHKANGXI RADICAL SMALLKANGXI RADICAL LAMEKANGXI RADICAL CORPSEK" +
	"ANGXI RADICAL SPROUTKANGXI RADICAL MOUNTAINKANGXI RADICAL RIVERKANGXI RA" +
	"DICAL WORKKANGXI RADICAL ONESELFKANGXI RADICAL TURBANKANGXI RADICAL DRYK" +
	"ANGXI RADICAL SHORT THREADKANGXI RADICAL DOTTED CLIFFKANGXI RADICAL LONG" +
	" STRIDEKANGXI RADICAL TWO HANDSKANGXI RADICAL SHOOTKANGXI RADICAL BOWKAN" +
	"GXI RADICAL SNOUTKANGXI RADICAL BRISTLEKANGXI RADICAL STEPKANGXI RADICAL" +
	" HEARTKANGXI RADICAL HALBERDKANGXI RADICAL DOORKANGXI RADICAL HANDKANGXI" +
	" RADICAL BRANCHKANGXI RADICAL RAPKANGXI RADICAL SCRIPTKANGXI RADICAL DIP" +
	"PERKANGXI RADICAL AXEKANGXI RADICAL SQUAREKANGXI RADICAL NOTKANGXI RADIC" +
	"AL SUNKANGXI RADICAL SAYKANGXI RADICAL MOONKANGXI RADICAL TREEKANGXI RAD" +
	"ICAL LACKKANGXI RADICAL STOPKANGXI RADICAL DEATHKANGXI RADICAL WEAPONKAN" +
	"GXI RADICAL DO NOTKANGXI RADICAL COMPAREKANGXI RADICAL FURKANGXI RADICAL" +
	" CLANKANGXI RADICAL STEAMKANGXI RADICAL WATERKANGXI RADICAL FIREKANGXI R" +
	"ADICAL CLAWKANGXI RADICAL FATHERKANGXI RADICAL DOUBLE XKANGXI RADICAL HA" +
	"LF TREE TRUNKKANGXI RADICAL SLICEKANGXI RADICAL FANGKANGXI RADICAL COWKA" +
	"NGXI RADICAL DOGKANGXI RADICAL PROFOUNDKANGXI RADICAL JADEKANGXI RADICAL" +
	" MELONKANGXI RADICAL TILEKANGXI RADICAL SWEETKANGXI RADICAL LIFEKANGXI R" +
	"ADICAL USEKANGXI RADICAL FIELDKANGXI RADICAL BOLT OF CLOTHKANGXI RADICAL") + ("" +
	" SICKNESSKANGXI RADICAL DOTTED TENTKANGXI RADICAL WHITEKANGXI RADICAL SK" +
	"INKANGXI RADICAL DISHKANGXI RADICAL EYEKANGXI RADICAL SPEARKANGXI RADICA" +
	"L ARROWKANGXI RADICAL STONEKANGXI RADICAL SPIRITKANGXI RADICAL TRACKKANG" +
	"XI RADICAL GRAINKANGXI RADICAL CAVEKANGXI RADICAL STANDKANGXI RADICAL BA" +
	"MBOOKANGXI RADICAL RICEKANGXI RADICAL SILKKANGXI RADICAL JARKANGXI RADIC" +
	"AL NETKANGXI RADICAL SHEEPKANGXI RADICAL FEATHERKANGXI RADICAL OLDKANGXI" +
	" RADICAL ANDKANGXI RADICAL PLOWKANGXI RADICAL EARKANGXI RADICAL BRUSHKAN" +
	"GXI RADICAL MEATKANGXI RADICAL MINISTERKANGXI RADICAL SELFKANGXI RADICAL" +
	" ARRIVEKANGXI RADICAL MORTARKANGXI RADICAL TONGUEKANGXI RADICAL OPPOSEKA" +
	"NGXI RADICAL BOATKANGXI RADICAL STOPPINGKANGXI RADICAL COLORKANGXI RADIC" +
	"AL GRASSKANGXI RADICAL TIGERKANGXI RADICAL INSECTKANGXI RADICAL BLOODKAN" +
	"GXI RADICAL WALK ENCLOSUREKANGXI RADICAL CLOTHESKANGXI RADICAL WESTKANGX" +
	"I RADICAL SEEKANGXI RADICAL HORNKANGXI RADICAL SPEECHKANGXI RADICAL VALL" +
	"EYKANGXI RADICAL BEANKANGXI RADICAL PIGKANGXI RADICAL BADGERKANGXI RADIC" +
	"AL SHELLKANGXI RADICAL REDKANGXI RADICAL RUNKANGXI RADICAL FOOTKANGXI RA" +
	"DICAL BODYKANGXI RADICAL CARTKANGXI RADICAL BITTERKANGXI RADICAL MORNING" +
	"KANGXI RADICAL WALKKANGXI RADICAL CITYKANGXI RADICAL WINEKANGXI RADICAL " +
	"DISTINGUISHKANGXI RADICAL VILLAGEKANGXI RADICAL GOLDKANGXI RADICAL LONGK" +
	"ANGXI RADICAL GATEKANGXI RADICAL MOUNDKANGXI RADICAL SLAVEKANGXI RADICAL" +
	" SHORT TAILED BIRDKANGXI RADICAL RAINKANGXI RADICAL BLUEKANGXI RADICAL W" +
	"RONGKANGXI RADICAL FACEKANGXI RADICAL LEATHERKANGXI RADICAL TANNED LEATH" +
	"ERKANGXI RADICAL LEEKKANGXI RADICAL SOUNDKANGXI RADICAL LEAFKANGXI RADIC" +
	"AL WINDKANGXI RADICAL FLYKANGXI RADICAL EATKANGXI RADICAL HEADKANGXI RAD" +
	"ICAL FRAGRANTKANGXI RADICAL HORSEKANGXI RADICAL BONEKANGXI RADICAL TALLK" +
	"ANGXI RADICAL HAIRKANGXI RADICAL FIGHTKANGXI RADICAL SACRIFICIAL WINEKAN" +
	"GXI RADICAL CAULDRONKANGXI RADICAL GHOSTKANGXI RADICAL FISHKANGXI RADICA" +
	"L BIRDKANGXI RADICAL SALTKANGXI RADICAL DEERKANGXI RADICAL WHEATKANGXI R" +
	"ADICAL HEMPKANGXI RADICAL YELLOWKANGXI RADICAL MILLETKANGXI RADICAL BLAC" +
	"KKANGXI RADICAL EMBROIDERYKANGXI RADICAL FROGKANGXI RADICAL TRIPODKANGXI" +
	" RADICAL DRUMKANGXI RADICAL RATKANGXI RADICAL NOSEKANGXI RADICAL EVENKAN" +
	"GXI RADICAL TOOTHKANGXI RADICAL DRAGONKANGXI RADICAL TURTLEKANGXI RADICA" +
	"L FLUTEIDEOGRAPHIC DESCRIPTION CHARACTER LEFT TO RIGHTIDEOGRAPHIC DESCRI" +
	"PTION CHARACTER ABOVE TO BELOWIDEOGRAPHIC DESCRIPTION CHARACTER LEFT TO " +
	"MIDDLE AND RIGHTIDEOGRAPHIC DESCRIPTION CHARACTER ABOVE TO MIDDLE AND BE" +
	"LOWIDEOGRAPHIC DESCRIPTION CHARACTER FULL SURROUNDIDEOGRAPHIC DESCRIPTIO" +
	"N CHARACTER SURROUND FROM ABOVEIDEOGRAPHIC DESCRIPTION CHARACTER SURROUN" +
	"D FROM BELOWIDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM LEFTIDEOGRAP" +
	"HIC DESCRIPTION CHARACTER SURROUND FROM UPPER LEFTIDEOGRAPHIC DESCRIPTIO" +
	"N CHARACTER SURROUND FROM UPPER RIGHTIDEOGRAPHIC DESCRIPTION CHARACTER S" +
	"URROUND FROM LOWER LEFTIDEOGRAPHIC DESCRIPTION CHARACTER OVERLAIDIDEOGRA" +
	"PHIC SPACEIDEOGRAPHIC COMMAIDEOGRAPHIC FULL STOPDITTO MARKJAPANESE INDUS" +
	"TRIAL STANDARD SYMBOLIDEOGRAPHIC ITERATION MARKIDEOGRAPHIC CLOSING MARKI" +
	"DEOGRAPHIC NUMBER ZEROLEFT ANGLE BRACKETRIGHT ANGLE BRACKETLEFT DOUBLE A" +
	"NGLE BRACKETRIGHT DOUBLE ANGLE BRACKETLEFT CORNER BRACKETRIGHT CORNER BR" +
	"ACKETLEFT WHITE CORNER BRACKETRIGHT WHITE CORNER BRACKETLEFT BLACK LENTI" +
	"CULAR BRACKETRIGHT BLACK LENTICULAR BRACKETPOSTAL MARKGETA MARKLEFT TORT" +
	"OISE SHELL BRACKETRIGHT TORTOISE SHELL BRACKETLEFT WHITE LENTICULAR BRAC" +
	"KETRIGHT WHITE LENTICULAR BRACKETLEFT WHITE TORTOISE SHELL BRACKETRIGHT " +
	"WHITE TORTOISE SHELL BRACKETLEFT WHITE SQUARE BRACKETRIGHT WHITE SQUARE " +
	"BRACKETWAVE DASHREVERSED DOUBLE PRIME QUOTATION MARKDOUBLE PRIME QUOTATI" +
	"ON MARKLOW DOUBLE PRIME QUOTATION MARKPOSTAL MARK FACEHANGZHOU NUMERAL O" +
	"NEHANGZHOU NUMERAL TWOHANGZHOU NUMERAL THREEHANGZHOU NUMERAL FOURHANGZHO" +
	"U NUMERAL FIVEHANGZHOU NUMERAL SIXHANGZHOU NUMERAL SEVENHANGZHOU NUMERAL" +
	" EIGHTHANGZHOU NUMERAL NINEIDEOGRAPHIC LEVEL TONE MARKIDEOGRAPHIC RISING" +
	" TONE MARKIDEOGRAPHIC DEPARTING TONE MARKIDEOGRAPHIC ENTERING TONE MARKH" +
	"ANGUL SINGLE DOT TONE MARKHANGUL DOUBLE DOT TONE MARKWAVY DASHVERTICAL K" +
	"ANA REPEAT MARKVERTICAL KANA REPEAT WITH VOICED SOUND MARKVERTICAL KANA " +
	"REPEAT MARK UPPER HALFVERTICAL KANA REPEAT WITH VOICED SOUND MARK UPPER " +
	"HALFVERTICAL KANA REPEAT MARK LOWER HALFCIRCLED POSTAL MARKIDEOGRAPHIC T" +
	"ELEGRAPH LINE FEED SEPARATOR SYMBOLHANGZHOU NUMERAL TENHANGZHOU NUMERAL " +
	"TWENTYHANGZHOU NUMERAL THIRTYVERTICAL IDEOGRAPHIC ITERATION MARKMASU MAR" +
	"KPART ALTERNATION MARKIDEOGRAPHIC VARIATION INDICATORIDEOGRAPHIC HALF FI" +
	"LL SPACEHIRAGANA LETTER SMALL AHIRAGANA LETTER AHIRAGANA LETTER SMALL IH" +
	"IRAGANA LETTER IHIRAGANA LETTER SMALL UHIRAGANA LETTER UHIRAGANA LETTER ") + ("" +
	"SMALL EHIRAGANA LETTER EHIRAGANA LETTER SMALL OHIRAGANA LETTER OHIRAGANA" +
	" LETTER KAHIRAGANA LETTER GAHIRAGANA LETTER KIHIRAGANA LETTER GIHIRAGANA" +
	" LETTER KUHIRAGANA LETTER GUHIRAGANA LETTER KEHIRAGANA LETTER GEHIRAGANA" +
	" LETTER KOHIRAGANA LETTER GOHIRAGANA LETTER SAHIRAGANA LETTER ZAHIRAGANA" +
	" LETTER SIHIRAGANA LETTER ZIHIRAGANA LETTER SUHIRAGANA LETTER ZUHIRAGANA" +
	" LETTER SEHIRAGANA LETTER ZEHIRAGANA LETTER SOHIRAGANA LETTER ZOHIRAGANA" +
	" LETTER TAHIRAGANA LETTER DAHIRAGANA LETTER TIHIRAGANA LETTER DIHIRAGANA" +
	" LETTER SMALL TUHIRAGANA LETTER TUHIRAGANA LETTER DUHIRAGANA LETTER TEHI" +
	"RAGANA LETTER DEHIRAGANA LETTER TOHIRAGANA LETTER DOHIRAGANA LETTER NAHI" +
	"RAGANA LETTER NIHIRAGANA LETTER NUHIRAGANA LETTER NEHIRAGANA LETTER NOHI" +
	"RAGANA LETTER HAHIRAGANA LETTER BAHIRAGANA LETTER PAHIRAGANA LETTER HIHI" +
	"RAGANA LETTER BIHIRAGANA LETTER PIHIRAGANA LETTER HUHIRAGANA LETTER BUHI" +
	"RAGANA LETTER PUHIRAGANA LETTER HEHIRAGANA LETTER BEHIRAGANA LETTER PEHI" +
	"RAGANA LETTER HOHIRAGANA LETTER BOHIRAGANA LETTER POHIRAGANA LETTER MAHI" +
	"RAGANA LETTER MIHIRAGANA LETTER MUHIRAGANA LETTER MEHIRAGANA LETTER MOHI" +
	"RAGANA LETTER SMALL YAHIRAGANA LETTER YAHIRAGANA LETTER SMALL YUHIRAGANA" +
	" LETTER YUHIRAGANA LETTER SMALL YOHIRAGANA LETTER YOHIRAGANA LETTER RAHI" +
	"RAGANA LETTER RIHIRAGANA LETTER RUHIRAGANA LETTER REHIRAGANA LETTER ROHI" +
	"RAGANA LETTER SMALL WAHIRAGANA LETTER WAHIRAGANA LETTER WIHIRAGANA LETTE" +
	"R WEHIRAGANA LETTER WOHIRAGANA LETTER NHIRAGANA LETTER VUHIRAGANA LETTER" +
	" SMALL KAHIRAGANA LETTER SMALL KECOMBINING KATAKANA-HIRAGANA VOICED SOUN" +
	"D MARKCOMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARKKATAKANA-HIRAGAN" +
	"A VOICED SOUND MARKKATAKANA-HIRAGANA SEMI-VOICED SOUND MARKHIRAGANA ITER" +
	"ATION MARKHIRAGANA VOICED ITERATION MARKHIRAGANA DIGRAPH YORIKATAKANA-HI" +
	"RAGANA DOUBLE HYPHENKATAKANA LETTER SMALL AKATAKANA LETTER AKATAKANA LET" +
	"TER SMALL IKATAKANA LETTER IKATAKANA LETTER SMALL UKATAKANA LETTER UKATA" +
	"KANA LETTER SMALL EKATAKANA LETTER EKATAKANA LETTER SMALL OKATAKANA LETT" +
	"ER OKATAKANA LETTER KAKATAKANA LETTER GAKATAKANA LETTER KIKATAKANA LETTE" +
	"R GIKATAKANA LETTER KUKATAKANA LETTER GUKATAKANA LETTER KEKATAKANA LETTE" +
	"R GEKATAKANA LETTER KOKATAKANA LETTER GOKATAKANA LETTER SAKATAKANA LETTE" +
	"R ZAKATAKANA LETTER SIKATAKANA LETTER ZIKATAKANA LETTER SUKATAKANA LETTE" +
	"R ZUKATAKANA LETTER SEKATAKANA LETTER ZEKATAKANA LETTER SOKATAKANA LETTE" +
	"R ZOKATAKANA LETTER TAKATAKANA LETTER DAKATAKANA LETTER TIKATAKANA LETTE" +
	"R DIKATAKANA LETTER SMALL TUKATAKANA LETTER TUKATAKANA LETTER DUKATAKANA" +
	" LETTER TEKATAKANA LETTER DEKATAKANA LETTER TOKATAKANA LETTER DOKATAKANA" +
	" LETTER NAKATAKANA LETTER NIKATAKANA LETTER NUKATAKANA LETTER NEKATAKANA" +
	" LETTER NOKATAKANA LETTER HAKATAKANA LETTER BAKATAKANA LETTER PAKATAKANA" +
	" LETTER HIKATAKANA LETTER BIKATAKANA LETTER PIKATAKANA LETTER HUKATAKANA" +
	" LETTER BUKATAKANA LETTER PUKATAKANA LETTER HEKATAKANA LETTER BEKATAKANA" +
	" LETTER PEKATAKANA LETTER HOKATAKANA LETTER BOKATAKANA LETTER POKATAKANA" +
	" LETTER MAKATAKANA LETTER MIKATAKANA LETTER MUKATAKANA LETTER MEKATAKANA" +
	" LETTER MOKATAKANA LETTER SMALL YAKATAKANA LETTER YAKATAKANA LETTER SMAL" +
	"L YUKATAKANA LETTER YUKATAKANA LETTER SMALL YOKATAKANA LETTER YOKATAKANA" +
	" LETTER RAKATAKANA LETTER RIKATAKANA LETTER RUKATAKANA LETTER REKATAKANA" +
	" LETTER ROKATAKANA LETTER SMALL WAKATAKANA LETTER WAKATAKANA LETTER WIKA" +
	"TAKANA LETTER WEKATAKANA LETTER WOKATAKANA LETTER NKATAKANA LETTER VUKAT" +
	"AKANA LETTER SMALL KAKATAKANA LETTER SMALL KEKATAKANA LETTER VAKATAKANA " +
	"LETTER VIKATAKANA LETTER VEKATAKANA LETTER VOKATAKANA MIDDLE DOTKATAKANA" +
	"-HIRAGANA PROLONGED SOUND MARKKATAKANA ITERATION MARKKATAKANA VOICED ITE" +
	"RATION MARKKATAKANA DIGRAPH KOTOBOPOMOFO LETTER BBOPOMOFO LETTER PBOPOMO" +
	"FO LETTER MBOPOMOFO LETTER FBOPOMOFO LETTER DBOPOMOFO LETTER TBOPOMOFO L" +
	"ETTER NBOPOMOFO LETTER LBOPOMOFO LETTER GBOPOMOFO LETTER KBOPOMOFO LETTE" +
	"R HBOPOMOFO LETTER JBOPOMOFO LETTER QBOPOMOFO LETTER XBOPOMOFO LETTER ZH" +
	"BOPOMOFO LETTER CHBOPOMOFO LETTER SHBOPOMOFO LETTER RBOPOMOFO LETTER ZBO" +
	"POMOFO LETTER CBOPOMOFO LETTER SBOPOMOFO LETTER ABOPOMOFO LETTER OBOPOMO" +
	"FO LETTER EBOPOMOFO LETTER EHBOPOMOFO LETTER AIBOPOMOFO LETTER EIBOPOMOF" +
	"O LETTER AUBOPOMOFO LETTER OUBOPOMOFO LETTER ANBOPOMOFO LETTER ENBOPOMOF" +
	"O LETTER ANGBOPOMOFO LETTER ENGBOPOMOFO LETTER ERBOPOMOFO LETTER IBOPOMO" +
	"FO LETTER UBOPOMOFO LETTER IUBOPOMOFO LETTER VBOPOMOFO LETTER NGBOPOMOFO" +
	" LETTER GNBOPOMOFO LETTER IHHANGUL LETTER KIYEOKHANGUL LETTER SSANGKIYEO" +
	"KHANGUL LETTER KIYEOK-SIOSHANGUL LETTER NIEUNHANGUL LETTER NIEUN-CIEUCHA" +
	"NGUL LETTER NIEUN-HIEUHHANGUL LETTER TIKEUTHANGUL LETTER SSANGTIKEUTHANG" +
	"UL LETTER RIEULHANGUL LETTER RIEUL-KIYEOKHANGUL LETTER RIEUL-MIEUMHANGUL" +
	" LETTER RIEUL-PIEUPHANGUL LETTER RIEUL-SIOSHANGUL LETTER RIEUL-THIEUTHHA") + ("" +
	"NGUL LETTER RIEUL-PHIEUPHHANGUL LETTER RIEUL-HIEUHHANGUL LETTER MIEUMHAN" +
	"GUL LETTER PIEUPHANGUL LETTER SSANGPIEUPHANGUL LETTER PIEUP-SIOSHANGUL L" +
	"ETTER SIOSHANGUL LETTER SSANGSIOSHANGUL LETTER IEUNGHANGUL LETTER CIEUCH" +
	"ANGUL LETTER SSANGCIEUCHANGUL LETTER CHIEUCHHANGUL LETTER KHIEUKHHANGUL " +
	"LETTER THIEUTHHANGUL LETTER PHIEUPHHANGUL LETTER HIEUHHANGUL LETTER AHAN" +
	"GUL LETTER AEHANGUL LETTER YAHANGUL LETTER YAEHANGUL LETTER EOHANGUL LET" +
	"TER EHANGUL LETTER YEOHANGUL LETTER YEHANGUL LETTER OHANGUL LETTER WAHAN" +
	"GUL LETTER WAEHANGUL LETTER OEHANGUL LETTER YOHANGUL LETTER UHANGUL LETT" +
	"ER WEOHANGUL LETTER WEHANGUL LETTER WIHANGUL LETTER YUHANGUL LETTER EUHA" +
	"NGUL LETTER YIHANGUL LETTER IHANGUL FILLERHANGUL LETTER SSANGNIEUNHANGUL" +
	" LETTER NIEUN-TIKEUTHANGUL LETTER NIEUN-SIOSHANGUL LETTER NIEUN-PANSIOSH" +
	"ANGUL LETTER RIEUL-KIYEOK-SIOSHANGUL LETTER RIEUL-TIKEUTHANGUL LETTER RI" +
	"EUL-PIEUP-SIOSHANGUL LETTER RIEUL-PANSIOSHANGUL LETTER RIEUL-YEORINHIEUH" +
	"HANGUL LETTER MIEUM-PIEUPHANGUL LETTER MIEUM-SIOSHANGUL LETTER MIEUM-PAN" +
	"SIOSHANGUL LETTER KAPYEOUNMIEUMHANGUL LETTER PIEUP-KIYEOKHANGUL LETTER P" +
	"IEUP-TIKEUTHANGUL LETTER PIEUP-SIOS-KIYEOKHANGUL LETTER PIEUP-SIOS-TIKEU" +
	"THANGUL LETTER PIEUP-CIEUCHANGUL LETTER PIEUP-THIEUTHHANGUL LETTER KAPYE" +
	"OUNPIEUPHANGUL LETTER KAPYEOUNSSANGPIEUPHANGUL LETTER SIOS-KIYEOKHANGUL " +
	"LETTER SIOS-NIEUNHANGUL LETTER SIOS-TIKEUTHANGUL LETTER SIOS-PIEUPHANGUL" +
	" LETTER SIOS-CIEUCHANGUL LETTER PANSIOSHANGUL LETTER SSANGIEUNGHANGUL LE" +
	"TTER YESIEUNGHANGUL LETTER YESIEUNG-SIOSHANGUL LETTER YESIEUNG-PANSIOSHA" +
	"NGUL LETTER KAPYEOUNPHIEUPHHANGUL LETTER SSANGHIEUHHANGUL LETTER YEORINH" +
	"IEUHHANGUL LETTER YO-YAHANGUL LETTER YO-YAEHANGUL LETTER YO-IHANGUL LETT" +
	"ER YU-YEOHANGUL LETTER YU-YEHANGUL LETTER YU-IHANGUL LETTER ARAEAHANGUL " +
	"LETTER ARAEAEIDEOGRAPHIC ANNOTATION LINKING MARKIDEOGRAPHIC ANNOTATION R" +
	"EVERSE MARKIDEOGRAPHIC ANNOTATION ONE MARKIDEOGRAPHIC ANNOTATION TWO MAR" +
	"KIDEOGRAPHIC ANNOTATION THREE MARKIDEOGRAPHIC ANNOTATION FOUR MARKIDEOGR" +
	"APHIC ANNOTATION TOP MARKIDEOGRAPHIC ANNOTATION MIDDLE MARKIDEOGRAPHIC A" +
	"NNOTATION BOTTOM MARKIDEOGRAPHIC ANNOTATION FIRST MARKIDEOGRAPHIC ANNOTA" +
	"TION SECOND MARKIDEOGRAPHIC ANNOTATION THIRD MARKIDEOGRAPHIC ANNOTATION " +
	"FOURTH MARKIDEOGRAPHIC ANNOTATION HEAVEN MARKIDEOGRAPHIC ANNOTATION EART" +
	"H MARKIDEOGRAPHIC ANNOTATION MAN MARKBOPOMOFO LETTER BUBOPOMOFO LETTER Z" +
	"IBOPOMOFO LETTER JIBOPOMOFO LETTER GUBOPOMOFO LETTER EEBOPOMOFO LETTER E" +
	"NNBOPOMOFO LETTER OOBOPOMOFO LETTER ONNBOPOMOFO LETTER IRBOPOMOFO LETTER" +
	" ANNBOPOMOFO LETTER INNBOPOMOFO LETTER UNNBOPOMOFO LETTER IMBOPOMOFO LET" +
	"TER NGGBOPOMOFO LETTER AINNBOPOMOFO LETTER AUNNBOPOMOFO LETTER AMBOPOMOF" +
	"O LETTER OMBOPOMOFO LETTER ONGBOPOMOFO LETTER INNNBOPOMOFO FINAL LETTER " +
	"PBOPOMOFO FINAL LETTER TBOPOMOFO FINAL LETTER KBOPOMOFO FINAL LETTER HBO" +
	"POMOFO LETTER GHBOPOMOFO LETTER LHBOPOMOFO LETTER ZYCJK STROKE TCJK STRO" +
	"KE WGCJK STROKE XGCJK STROKE BXGCJK STROKE SWCJK STROKE HZZCJK STROKE HZ" +
	"GCJK STROKE HPCJK STROKE HZWGCJK STROKE SZWGCJK STROKE HZTCJK STROKE HZZ" +
	"PCJK STROKE HPWGCJK STROKE HZWCJK STROKE HZZZCJK STROKE NCJK STROKE HCJK" +
	" STROKE SCJK STROKE PCJK STROKE SPCJK STROKE DCJK STROKE HZCJK STROKE HG" +
	"CJK STROKE SZCJK STROKE SWZCJK STROKE STCJK STROKE SGCJK STROKE PDCJK ST" +
	"ROKE PZCJK STROKE TNCJK STROKE SZZCJK STROKE SWGCJK STROKE HXWGCJK STROK" +
	"E HZZZGCJK STROKE PGCJK STROKE QKATAKANA LETTER SMALL KUKATAKANA LETTER " +
	"SMALL SIKATAKANA LETTER SMALL SUKATAKANA LETTER SMALL TOKATAKANA LETTER " +
	"SMALL NUKATAKANA LETTER SMALL HAKATAKANA LETTER SMALL HIKATAKANA LETTER " +
	"SMALL HUKATAKANA LETTER SMALL HEKATAKANA LETTER SMALL HOKATAKANA LETTER " +
	"SMALL MUKATAKANA LETTER SMALL RAKATAKANA LETTER SMALL RIKATAKANA LETTER " +
	"SMALL RUKATAKANA LETTER SMALL REKATAKANA LETTER SMALL ROPARENTHESIZED HA" +
	"NGUL KIYEOKPARENTHESIZED HANGUL NIEUNPARENTHESIZED HANGUL TIKEUTPARENTHE" +
	"SIZED HANGUL RIEULPARENTHESIZED HANGUL MIEUMPARENTHESIZED HANGUL PIEUPPA" +
	"RENTHESIZED HANGUL SIOSPARENTHESIZED HANGUL IEUNGPARENTHESIZED HANGUL CI" +
	"EUCPARENTHESIZED HANGUL CHIEUCHPARENTHESIZED HANGUL KHIEUKHPARENTHESIZED" +
	" HANGUL THIEUTHPARENTHESIZED HANGUL PHIEUPHPARENTHESIZED HANGUL HIEUHPAR" +
	"ENTHESIZED HANGUL KIYEOK APARENTHESIZED HANGUL NIEUN APARENTHESIZED HANG" +
	"UL TIKEUT APARENTHESIZED HANGUL RIEUL APARENTHESIZED HANGUL MIEUM APAREN" +
	"THESIZED HANGUL PIEUP APARENTHESIZED HANGUL SIOS APARENTHESIZED HANGUL I" +
	"EUNG APARENTHESIZED HANGUL CIEUC APARENTHESIZED HANGUL CHIEUCH APARENTHE" +
	"SIZED HANGUL KHIEUKH APARENTHESIZED HANGUL THIEUTH APARENTHESIZED HANGUL" +
	" PHIEUPH APARENTHESIZED HANGUL HIEUH APARENTHESIZED HANGUL CIEUC UPARENT" +
	"HESIZED KOREAN CHARACTER OJEONPARENTHESIZED KOREAN CHARACTER O HUPARENTH" +
	"ESIZED IDEOGRAPH ONEPARENTHESIZED IDEOGRAPH TWOPARENTHESIZED IDEOGRAPH T") + ("" +
	"HREEPARENTHESIZED IDEOGRAPH FOURPARENTHESIZED IDEOGRAPH FIVEPARENTHESIZE" +
	"D IDEOGRAPH SIXPARENTHESIZED IDEOGRAPH SEVENPARENTHESIZED IDEOGRAPH EIGH" +
	"TPARENTHESIZED IDEOGRAPH NINEPARENTHESIZED IDEOGRAPH TENPARENTHESIZED ID" +
	"EOGRAPH MOONPARENTHESIZED IDEOGRAPH FIREPARENTHESIZED IDEOGRAPH WATERPAR" +
	"ENTHESIZED IDEOGRAPH WOODPARENTHESIZED IDEOGRAPH METALPARENTHESIZED IDEO" +
	"GRAPH EARTHPARENTHESIZED IDEOGRAPH SUNPARENTHESIZED IDEOGRAPH STOCKPAREN" +
	"THESIZED IDEOGRAPH HAVEPARENTHESIZED IDEOGRAPH SOCIETYPARENTHESIZED IDEO" +
	"GRAPH NAMEPARENTHESIZED IDEOGRAPH SPECIALPARENTHESIZED IDEOGRAPH FINANCI" +
	"ALPARENTHESIZED IDEOGRAPH CONGRATULATIONPARENTHESIZED IDEOGRAPH LABORPAR" +
	"ENTHESIZED IDEOGRAPH REPRESENTPARENTHESIZED IDEOGRAPH CALLPARENTHESIZED " +
	"IDEOGRAPH STUDYPARENTHESIZED IDEOGRAPH SUPERVISEPARENTHESIZED IDEOGRAPH " +
	"ENTERPRISEPARENTHESIZED IDEOGRAPH RESOURCEPARENTHESIZED IDEOGRAPH ALLIAN" +
	"CEPARENTHESIZED IDEOGRAPH FESTIVALPARENTHESIZED IDEOGRAPH RESTPARENTHESI" +
	"ZED IDEOGRAPH SELFPARENTHESIZED IDEOGRAPH REACHCIRCLED IDEOGRAPH QUESTIO" +
	"NCIRCLED IDEOGRAPH KINDERGARTENCIRCLED IDEOGRAPH SCHOOLCIRCLED IDEOGRAPH" +
	" KOTOCIRCLED NUMBER TEN ON BLACK SQUARECIRCLED NUMBER TWENTY ON BLACK SQ" +
	"UARECIRCLED NUMBER THIRTY ON BLACK SQUARECIRCLED NUMBER FORTY ON BLACK S" +
	"QUARECIRCLED NUMBER FIFTY ON BLACK SQUARECIRCLED NUMBER SIXTY ON BLACK S" +
	"QUARECIRCLED NUMBER SEVENTY ON BLACK SQUARECIRCLED NUMBER EIGHTY ON BLAC" +
	"K SQUAREPARTNERSHIP SIGNCIRCLED NUMBER TWENTY ONECIRCLED NUMBER TWENTY T" +
	"WOCIRCLED NUMBER TWENTY THREECIRCLED NUMBER TWENTY FOURCIRCLED NUMBER TW" +
	"ENTY FIVECIRCLED NUMBER TWENTY SIXCIRCLED NUMBER TWENTY SEVENCIRCLED NUM" +
	"BER TWENTY EIGHTCIRCLED NUMBER TWENTY NINECIRCLED NUMBER THIRTYCIRCLED N" +
	"UMBER THIRTY ONECIRCLED NUMBER THIRTY TWOCIRCLED NUMBER THIRTY THREECIRC" +
	"LED NUMBER THIRTY FOURCIRCLED NUMBER THIRTY FIVECIRCLED HANGUL KIYEOKCIR" +
	"CLED HANGUL NIEUNCIRCLED HANGUL TIKEUTCIRCLED HANGUL RIEULCIRCLED HANGUL" +
	" MIEUMCIRCLED HANGUL PIEUPCIRCLED HANGUL SIOSCIRCLED HANGUL IEUNGCIRCLED" +
	" HANGUL CIEUCCIRCLED HANGUL CHIEUCHCIRCLED HANGUL KHIEUKHCIRCLED HANGUL " +
	"THIEUTHCIRCLED HANGUL PHIEUPHCIRCLED HANGUL HIEUHCIRCLED HANGUL KIYEOK A" +
	"CIRCLED HANGUL NIEUN ACIRCLED HANGUL TIKEUT ACIRCLED HANGUL RIEUL ACIRCL" +
	"ED HANGUL MIEUM ACIRCLED HANGUL PIEUP ACIRCLED HANGUL SIOS ACIRCLED HANG" +
	"UL IEUNG ACIRCLED HANGUL CIEUC ACIRCLED HANGUL CHIEUCH ACIRCLED HANGUL K" +
	"HIEUKH ACIRCLED HANGUL THIEUTH ACIRCLED HANGUL PHIEUPH ACIRCLED HANGUL H" +
	"IEUH ACIRCLED KOREAN CHARACTER CHAMKOCIRCLED KOREAN CHARACTER JUEUICIRCL" +
	"ED HANGUL IEUNG UKOREAN STANDARD SYMBOLCIRCLED IDEOGRAPH ONECIRCLED IDEO" +
	"GRAPH TWOCIRCLED IDEOGRAPH THREECIRCLED IDEOGRAPH FOURCIRCLED IDEOGRAPH " +
	"FIVECIRCLED IDEOGRAPH SIXCIRCLED IDEOGRAPH SEVENCIRCLED IDEOGRAPH EIGHTC" +
	"IRCLED IDEOGRAPH NINECIRCLED IDEOGRAPH TENCIRCLED IDEOGRAPH MOONCIRCLED " +
	"IDEOGRAPH FIRECIRCLED IDEOGRAPH WATERCIRCLED IDEOGRAPH WOODCIRCLED IDEOG" +
	"RAPH METALCIRCLED IDEOGRAPH EARTHCIRCLED IDEOGRAPH SUNCIRCLED IDEOGRAPH " +
	"STOCKCIRCLED IDEOGRAPH HAVECIRCLED IDEOGRAPH SOCIETYCIRCLED IDEOGRAPH NA" +
	"MECIRCLED IDEOGRAPH SPECIALCIRCLED IDEOGRAPH FINANCIALCIRCLED IDEOGRAPH " +
	"CONGRATULATIONCIRCLED IDEOGRAPH LABORCIRCLED IDEOGRAPH SECRETCIRCLED IDE" +
	"OGRAPH MALECIRCLED IDEOGRAPH FEMALECIRCLED IDEOGRAPH SUITABLECIRCLED IDE" +
	"OGRAPH EXCELLENTCIRCLED IDEOGRAPH PRINTCIRCLED IDEOGRAPH ATTENTIONCIRCLE" +
	"D IDEOGRAPH ITEMCIRCLED IDEOGRAPH RESTCIRCLED IDEOGRAPH COPYCIRCLED IDEO" +
	"GRAPH CORRECTCIRCLED IDEOGRAPH HIGHCIRCLED IDEOGRAPH CENTRECIRCLED IDEOG" +
	"RAPH LOWCIRCLED IDEOGRAPH LEFTCIRCLED IDEOGRAPH RIGHTCIRCLED IDEOGRAPH M" +
	"EDICINECIRCLED IDEOGRAPH RELIGIONCIRCLED IDEOGRAPH STUDYCIRCLED IDEOGRAP" +
	"H SUPERVISECIRCLED IDEOGRAPH ENTERPRISECIRCLED IDEOGRAPH RESOURCECIRCLED" +
	" IDEOGRAPH ALLIANCECIRCLED IDEOGRAPH NIGHTCIRCLED NUMBER THIRTY SIXCIRCL" +
	"ED NUMBER THIRTY SEVENCIRCLED NUMBER THIRTY EIGHTCIRCLED NUMBER THIRTY N" +
	"INECIRCLED NUMBER FORTYCIRCLED NUMBER FORTY ONECIRCLED NUMBER FORTY TWOC" +
	"IRCLED NUMBER FORTY THREECIRCLED NUMBER FORTY FOURCIRCLED NUMBER FORTY F" +
	"IVECIRCLED NUMBER FORTY SIXCIRCLED NUMBER FORTY SEVENCIRCLED NUMBER FORT" +
	"Y EIGHTCIRCLED NUMBER FORTY NINECIRCLED NUMBER FIFTYIDEOGRAPHIC TELEGRAP" +
	"H SYMBOL FOR JANUARYIDEOGRAPHIC TELEGRAPH SYMBOL FOR FEBRUARYIDEOGRAPHIC" +
	" TELEGRAPH SYMBOL FOR MARCHIDEOGRAPHIC TELEGRAPH SYMBOL FOR APRILIDEOGRA" +
	"PHIC TELEGRAPH SYMBOL FOR MAYIDEOGRAPHIC TELEGRAPH SYMBOL FOR JUNEIDEOGR" +
	"APHIC TELEGRAPH SYMBOL FOR JULYIDEOGRAPHIC TELEGRAPH SYMBOL FOR AUGUSTID" +
	"EOGRAPHIC TELEGRAPH SYMBOL FOR SEPTEMBERIDEOGRAPHIC TELEGRAPH SYMBOL FOR" +
	" OCTOBERIDEOGRAPHIC TELEGRAPH SYMBOL FOR NOVEMBERIDEOGRAPHIC TELEGRAPH S" +
	"YMBOL FOR DECEMBERSQUARE HGSQUARE ERGSQUARE EVLIMITED LIABILITY SIGNCIRC" +
	"LED KATAKANA ACIRCLED KATAKANA ICIRCLED KATAKANA UCIRCLED KATAKANA ECIRC") + ("" +
	"LED KATAKANA OCIRCLED KATAKANA KACIRCLED KATAKANA KICIRCLED KATAKANA KUC" +
	"IRCLED KATAKANA KECIRCLED KATAKANA KOCIRCLED KATAKANA SACIRCLED KATAKANA" +
	" SICIRCLED KATAKANA SUCIRCLED KATAKANA SECIRCLED KATAKANA SOCIRCLED KATA" +
	"KANA TACIRCLED KATAKANA TICIRCLED KATAKANA TUCIRCLED KATAKANA TECIRCLED " +
	"KATAKANA TOCIRCLED KATAKANA NACIRCLED KATAKANA NICIRCLED KATAKANA NUCIRC" +
	"LED KATAKANA NECIRCLED KATAKANA NOCIRCLED KATAKANA HACIRCLED KATAKANA HI" +
	"CIRCLED KATAKANA HUCIRCLED KATAKANA HECIRCLED KATAKANA HOCIRCLED KATAKAN" +
	"A MACIRCLED KATAKANA MICIRCLED KATAKANA MUCIRCLED KATAKANA MECIRCLED KAT" +
	"AKANA MOCIRCLED KATAKANA YACIRCLED KATAKANA YUCIRCLED KATAKANA YOCIRCLED" +
	" KATAKANA RACIRCLED KATAKANA RICIRCLED KATAKANA RUCIRCLED KATAKANA RECIR" +
	"CLED KATAKANA ROCIRCLED KATAKANA WACIRCLED KATAKANA WICIRCLED KATAKANA W" +
	"ECIRCLED KATAKANA WOSQUARE APAATOSQUARE ARUHUASQUARE ANPEASQUARE AARUSQU" +
	"ARE ININGUSQUARE INTISQUARE UONSQUARE ESUKUUDOSQUARE EEKAASQUARE ONSUSQU" +
	"ARE OOMUSQUARE KAIRISQUARE KARATTOSQUARE KARORIISQUARE GARONSQUARE GANMA" +
	"SQUARE GIGASQUARE GINIISQUARE KYURIISQUARE GIRUDAASQUARE KIROSQUARE KIRO" +
	"GURAMUSQUARE KIROMEETORUSQUARE KIROWATTOSQUARE GURAMUSQUARE GURAMUTONSQU" +
	"ARE KURUZEIROSQUARE KUROONESQUARE KEESUSQUARE KORUNASQUARE KOOPOSQUARE S" +
	"AIKURUSQUARE SANTIIMUSQUARE SIRINGUSQUARE SENTISQUARE SENTOSQUARE DAASUS" +
	"QUARE DESISQUARE DORUSQUARE TONSQUARE NANOSQUARE NOTTOSQUARE HAITUSQUARE" +
	" PAASENTOSQUARE PAATUSQUARE BAARERUSQUARE PIASUTORUSQUARE PIKURUSQUARE P" +
	"IKOSQUARE BIRUSQUARE HUARADDOSQUARE HUIITOSQUARE BUSSYERUSQUARE HURANSQU" +
	"ARE HEKUTAARUSQUARE PESOSQUARE PENIHISQUARE HERUTUSQUARE PENSUSQUARE PEE" +
	"ZISQUARE BEETASQUARE POINTOSQUARE BORUTOSQUARE HONSQUARE PONDOSQUARE HOO" +
	"RUSQUARE HOONSQUARE MAIKUROSQUARE MAIRUSQUARE MAHHASQUARE MARUKUSQUARE M" +
	"ANSYONSQUARE MIKURONSQUARE MIRISQUARE MIRIBAARUSQUARE MEGASQUARE MEGATON" +
	"SQUARE MEETORUSQUARE YAADOSQUARE YAARUSQUARE YUANSQUARE RITTORUSQUARE RI" +
	"RASQUARE RUPIISQUARE RUUBURUSQUARE REMUSQUARE RENTOGENSQUARE WATTOIDEOGR" +
	"APHIC TELEGRAPH SYMBOL FOR HOUR ZEROIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOU" +
	"R ONEIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWOIDEOGRAPHIC TELEGRAPH SYMB" +
	"OL FOR HOUR THREEIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FOURIDEOGRAPHIC T" +
	"ELEGRAPH SYMBOL FOR HOUR FIVEIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SIXID" +
	"EOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SEVENIDEOGRAPHIC TELEGRAPH SYMBOL FO" +
	"R HOUR EIGHTIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR NINEIDEOGRAPHIC TELEGR" +
	"APH SYMBOL FOR HOUR TENIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR ELEVENIDEOG" +
	"RAPHIC TELEGRAPH SYMBOL FOR HOUR TWELVEIDEOGRAPHIC TELEGRAPH SYMBOL FOR " +
	"HOUR THIRTEENIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FOURTEENIDEOGRAPHIC T" +
	"ELEGRAPH SYMBOL FOR HOUR FIFTEENIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SI" +
	"XTEENIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SEVENTEENIDEOGRAPHIC TELEGRAP" +
	"H SYMBOL FOR HOUR EIGHTEENIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR NINETEEN" +
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTYIDEOGRAPHIC TELEGRAPH SYMBOL" +
	" FOR HOUR TWENTY-ONEIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-TWOIDEO" +
	"GRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-THREEIDEOGRAPHIC TELEGRAPH SYMB" +
	"OL FOR HOUR TWENTY-FOURSQUARE HPASQUARE DASQUARE AUSQUARE BARSQUARE OVSQ" +
	"UARE PCSQUARE DMSQUARE DM SQUAREDSQUARE DM CUBEDSQUARE IUSQUARE ERA NAME" +
	" HEISEISQUARE ERA NAME SYOUWASQUARE ERA NAME TAISYOUSQUARE ERA NAME MEIZ" +
	"ISQUARE CORPORATIONSQUARE PA AMPSSQUARE NASQUARE MU ASQUARE MASQUARE KAS" +
	"QUARE KBSQUARE MBSQUARE GBSQUARE CALSQUARE KCALSQUARE PFSQUARE NFSQUARE " +
	"MU FSQUARE MU GSQUARE MGSQUARE KGSQUARE HZSQUARE KHZSQUARE MHZSQUARE GHZ" +
	"SQUARE THZSQUARE MU LSQUARE MLSQUARE DLSQUARE KLSQUARE FMSQUARE NMSQUARE" +
	" MU MSQUARE MMSQUARE CMSQUARE KMSQUARE MM SQUAREDSQUARE CM SQUAREDSQUARE" +
	" M SQUAREDSQUARE KM SQUAREDSQUARE MM CUBEDSQUARE CM CUBEDSQUARE M CUBEDS" +
	"QUARE KM CUBEDSQUARE M OVER SSQUARE M OVER S SQUAREDSQUARE PASQUARE KPAS" +
	"QUARE MPASQUARE GPASQUARE RADSQUARE RAD OVER SSQUARE RAD OVER S SQUAREDS" +
	"QUARE PSSQUARE NSSQUARE MU SSQUARE MSSQUARE PVSQUARE NVSQUARE MU VSQUARE" +
	" MVSQUARE KVSQUARE MV MEGASQUARE PWSQUARE NWSQUARE MU WSQUARE MWSQUARE K" +
	"WSQUARE MW MEGASQUARE K OHMSQUARE M OHMSQUARE AMSQUARE BQSQUARE CCSQUARE" +
	" CDSQUARE C OVER KGSQUARE COSQUARE DBSQUARE GYSQUARE HASQUARE HPSQUARE I" +
	"NSQUARE KKSQUARE KM CAPITALSQUARE KTSQUARE LMSQUARE LNSQUARE LOGSQUARE L" +
	"XSQUARE MB SMALLSQUARE MILSQUARE MOLSQUARE PHSQUARE PMSQUARE PPMSQUARE P" +
	"RSQUARE SRSQUARE SVSQUARE WBSQUARE V OVER MSQUARE A OVER MIDEOGRAPHIC TE" +
	"LEGRAPH SYMBOL FOR DAY ONEIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWOIDEOGR" +
	"APHIC TELEGRAPH SYMBOL FOR DAY THREEIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY" +
	" FOURIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FIVEIDEOGRAPHIC TELEGRAPH SYMB" +
	"OL FOR DAY SIXIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SEVENIDEOGRAPHIC TELE") + ("" +
	"GRAPH SYMBOL FOR DAY EIGHTIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY NINEIDEOG" +
	"RAPHIC TELEGRAPH SYMBOL FOR DAY TENIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY " +
	"ELEVENIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWELVEIDEOGRAPHIC TELEGRAPH S" +
	"YMBOL FOR DAY THIRTEENIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FOURTEENIDEOG" +
	"RAPHIC TELEGRAPH SYMBOL FOR DAY FIFTEENIDEOGRAPHIC TELEGRAPH SYMBOL FOR " +
	"DAY SIXTEENIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SEVENTEENIDEOGRAPHIC TEL" +
	"EGRAPH SYMBOL FOR DAY EIGHTEENIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY NINET" +
	"EENIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTYIDEOGRAPHIC TELEGRAPH SYMB" +
	"OL FOR DAY TWENTY-ONEIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-TWOIDEO" +
	"GRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-THREEIDEOGRAPHIC TELEGRAPH SYMBO" +
	"L FOR DAY TWENTY-FOURIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-FIVEIDE" +
	"OGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-SIXIDEOGRAPHIC TELEGRAPH SYMBOL" +
	" FOR DAY TWENTY-SEVENIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-EIGHTID" +
	"EOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-NINEIDEOGRAPHIC TELEGRAPH SYMB" +
	"OL FOR DAY THIRTYIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THIRTY-ONESQUARE G" +
	"ALHEXAGRAM FOR THE CREATIVE HEAVENHEXAGRAM FOR THE RECEPTIVE EARTHHEXAGR" +
	"AM FOR DIFFICULTY AT THE BEGINNINGHEXAGRAM FOR YOUTHFUL FOLLYHEXAGRAM FO" +
	"R WAITINGHEXAGRAM FOR CONFLICTHEXAGRAM FOR THE ARMYHEXAGRAM FOR HOLDING " +
	"TOGETHERHEXAGRAM FOR SMALL TAMINGHEXAGRAM FOR TREADINGHEXAGRAM FOR PEACE" +
	"HEXAGRAM FOR STANDSTILLHEXAGRAM FOR FELLOWSHIPHEXAGRAM FOR GREAT POSSESS" +
	"IONHEXAGRAM FOR MODESTYHEXAGRAM FOR ENTHUSIASMHEXAGRAM FOR FOLLOWINGHEXA" +
	"GRAM FOR WORK ON THE DECAYEDHEXAGRAM FOR APPROACHHEXAGRAM FOR CONTEMPLAT" +
	"IONHEXAGRAM FOR BITING THROUGHHEXAGRAM FOR GRACEHEXAGRAM FOR SPLITTING A" +
	"PARTHEXAGRAM FOR RETURNHEXAGRAM FOR INNOCENCEHEXAGRAM FOR GREAT TAMINGHE" +
	"XAGRAM FOR MOUTH CORNERSHEXAGRAM FOR GREAT PREPONDERANCEHEXAGRAM FOR THE" +
	" ABYSMAL WATERHEXAGRAM FOR THE CLINGING FIREHEXAGRAM FOR INFLUENCEHEXAGR" +
	"AM FOR DURATIONHEXAGRAM FOR RETREATHEXAGRAM FOR GREAT POWERHEXAGRAM FOR " +
	"PROGRESSHEXAGRAM FOR DARKENING OF THE LIGHTHEXAGRAM FOR THE FAMILYHEXAGR" +
	"AM FOR OPPOSITIONHEXAGRAM FOR OBSTRUCTIONHEXAGRAM FOR DELIVERANCEHEXAGRA" +
	"M FOR DECREASEHEXAGRAM FOR INCREASEHEXAGRAM FOR BREAKTHROUGHHEXAGRAM FOR" +
	" COMING TO MEETHEXAGRAM FOR GATHERING TOGETHERHEXAGRAM FOR PUSHING UPWAR" +
	"DHEXAGRAM FOR OPPRESSIONHEXAGRAM FOR THE WELLHEXAGRAM FOR REVOLUTIONHEXA" +
	"GRAM FOR THE CAULDRONHEXAGRAM FOR THE AROUSING THUNDERHEXAGRAM FOR THE K" +
	"EEPING STILL MOUNTAINHEXAGRAM FOR DEVELOPMENTHEXAGRAM FOR THE MARRYING M" +
	"AIDENHEXAGRAM FOR ABUNDANCEHEXAGRAM FOR THE WANDERERHEXAGRAM FOR THE GEN" +
	"TLE WINDHEXAGRAM FOR THE JOYOUS LAKEHEXAGRAM FOR DISPERSIONHEXAGRAM FOR " +
	"LIMITATIONHEXAGRAM FOR INNER TRUTHHEXAGRAM FOR SMALL PREPONDERANCEHEXAGR" +
	"AM FOR AFTER COMPLETIONHEXAGRAM FOR BEFORE COMPLETIONYI SYLLABLE ITYI SY" +
	"LLABLE IXYI SYLLABLE IYI SYLLABLE IPYI SYLLABLE IETYI SYLLABLE IEXYI SYL" +
	"LABLE IEYI SYLLABLE IEPYI SYLLABLE ATYI SYLLABLE AXYI SYLLABLE AYI SYLLA" +
	"BLE APYI SYLLABLE UOXYI SYLLABLE UOYI SYLLABLE UOPYI SYLLABLE OTYI SYLLA" +
	"BLE OXYI SYLLABLE OYI SYLLABLE OPYI SYLLABLE EXYI SYLLABLE EYI SYLLABLE " +
	"WUYI SYLLABLE BITYI SYLLABLE BIXYI SYLLABLE BIYI SYLLABLE BIPYI SYLLABLE" +
	" BIETYI SYLLABLE BIEXYI SYLLABLE BIEYI SYLLABLE BIEPYI SYLLABLE BATYI SY" +
	"LLABLE BAXYI SYLLABLE BAYI SYLLABLE BAPYI SYLLABLE BUOXYI SYLLABLE BUOYI" +
	" SYLLABLE BUOPYI SYLLABLE BOTYI SYLLABLE BOXYI SYLLABLE BOYI SYLLABLE BO" +
	"PYI SYLLABLE BEXYI SYLLABLE BEYI SYLLABLE BEPYI SYLLABLE BUTYI SYLLABLE " +
	"BUXYI SYLLABLE BUYI SYLLABLE BUPYI SYLLABLE BURXYI SYLLABLE BURYI SYLLAB" +
	"LE BYTYI SYLLABLE BYXYI SYLLABLE BYYI SYLLABLE BYPYI SYLLABLE BYRXYI SYL" +
	"LABLE BYRYI SYLLABLE PITYI SYLLABLE PIXYI SYLLABLE PIYI SYLLABLE PIPYI S" +
	"YLLABLE PIEXYI SYLLABLE PIEYI SYLLABLE PIEPYI SYLLABLE PATYI SYLLABLE PA" +
	"XYI SYLLABLE PAYI SYLLABLE PAPYI SYLLABLE PUOXYI SYLLABLE PUOYI SYLLABLE" +
	" PUOPYI SYLLABLE POTYI SYLLABLE POXYI SYLLABLE POYI SYLLABLE POPYI SYLLA" +
	"BLE PUTYI SYLLABLE PUXYI SYLLABLE PUYI SYLLABLE PUPYI SYLLABLE PURXYI SY" +
	"LLABLE PURYI SYLLABLE PYTYI SYLLABLE PYXYI SYLLABLE PYYI SYLLABLE PYPYI " +
	"SYLLABLE PYRXYI SYLLABLE PYRYI SYLLABLE BBITYI SYLLABLE BBIXYI SYLLABLE " +
	"BBIYI SYLLABLE BBIPYI SYLLABLE BBIETYI SYLLABLE BBIEXYI SYLLABLE BBIEYI " +
	"SYLLABLE BBIEPYI SYLLABLE BBATYI SYLLABLE BBAXYI SYLLABLE BBAYI SYLLABLE" +
	" BBAPYI SYLLABLE BBUOXYI SYLLABLE BBUOYI SYLLABLE BBUOPYI SYLLABLE BBOTY" +
	"I SYLLABLE BBOXYI SYLLABLE BBOYI SYLLABLE BBOPYI SYLLABLE BBEXYI SYLLABL" +
	"E BBEYI SYLLABLE BBEPYI SYLLABLE BBUTYI SYLLABLE BBUXYI SYLLABLE BBUYI S" +
	"YLLABLE BBUPYI SYLLABLE BBURXYI SYLLABLE BBURYI SYLLABLE BBYTYI SYLLABLE" +
	" BBYXYI SYLLABLE BBYYI SYLLABLE BBYPYI SYLLABLE NBITYI SYLLABLE NBIXYI S" +
	"YLLABLE NBIYI SYLLABLE NBIPYI SYLLABLE NBIEXYI SYLLABLE NBIEYI SYLLABLE ") + ("" +
	"NBIEPYI SYLLABLE NBATYI SYLLABLE NBAXYI SYLLABLE NBAYI SYLLABLE NBAPYI S" +
	"YLLABLE NBOTYI SYLLABLE NBOXYI SYLLABLE NBOYI SYLLABLE NBOPYI SYLLABLE N" +
	"BUTYI SYLLABLE NBUXYI SYLLABLE NBUYI SYLLABLE NBUPYI SYLLABLE NBURXYI SY" +
	"LLABLE NBURYI SYLLABLE NBYTYI SYLLABLE NBYXYI SYLLABLE NBYYI SYLLABLE NB" +
	"YPYI SYLLABLE NBYRXYI SYLLABLE NBYRYI SYLLABLE HMITYI SYLLABLE HMIXYI SY" +
	"LLABLE HMIYI SYLLABLE HMIPYI SYLLABLE HMIEXYI SYLLABLE HMIEYI SYLLABLE H" +
	"MIEPYI SYLLABLE HMATYI SYLLABLE HMAXYI SYLLABLE HMAYI SYLLABLE HMAPYI SY" +
	"LLABLE HMUOXYI SYLLABLE HMUOYI SYLLABLE HMUOPYI SYLLABLE HMOTYI SYLLABLE" +
	" HMOXYI SYLLABLE HMOYI SYLLABLE HMOPYI SYLLABLE HMUTYI SYLLABLE HMUXYI S" +
	"YLLABLE HMUYI SYLLABLE HMUPYI SYLLABLE HMURXYI SYLLABLE HMURYI SYLLABLE " +
	"HMYXYI SYLLABLE HMYYI SYLLABLE HMYPYI SYLLABLE HMYRXYI SYLLABLE HMYRYI S" +
	"YLLABLE MITYI SYLLABLE MIXYI SYLLABLE MIYI SYLLABLE MIPYI SYLLABLE MIEXY" +
	"I SYLLABLE MIEYI SYLLABLE MIEPYI SYLLABLE MATYI SYLLABLE MAXYI SYLLABLE " +
	"MAYI SYLLABLE MAPYI SYLLABLE MUOTYI SYLLABLE MUOXYI SYLLABLE MUOYI SYLLA" +
	"BLE MUOPYI SYLLABLE MOTYI SYLLABLE MOXYI SYLLABLE MOYI SYLLABLE MOPYI SY" +
	"LLABLE MEXYI SYLLABLE MEYI SYLLABLE MUTYI SYLLABLE MUXYI SYLLABLE MUYI S" +
	"YLLABLE MUPYI SYLLABLE MURXYI SYLLABLE MURYI SYLLABLE MYTYI SYLLABLE MYX" +
	"YI SYLLABLE MYYI SYLLABLE MYPYI SYLLABLE FITYI SYLLABLE FIXYI SYLLABLE F" +
	"IYI SYLLABLE FIPYI SYLLABLE FATYI SYLLABLE FAXYI SYLLABLE FAYI SYLLABLE " +
	"FAPYI SYLLABLE FOXYI SYLLABLE FOYI SYLLABLE FOPYI SYLLABLE FUTYI SYLLABL" +
	"E FUXYI SYLLABLE FUYI SYLLABLE FUPYI SYLLABLE FURXYI SYLLABLE FURYI SYLL" +
	"ABLE FYTYI SYLLABLE FYXYI SYLLABLE FYYI SYLLABLE FYPYI SYLLABLE VITYI SY" +
	"LLABLE VIXYI SYLLABLE VIYI SYLLABLE VIPYI SYLLABLE VIETYI SYLLABLE VIEXY" +
	"I SYLLABLE VIEYI SYLLABLE VIEPYI SYLLABLE VATYI SYLLABLE VAXYI SYLLABLE " +
	"VAYI SYLLABLE VAPYI SYLLABLE VOTYI SYLLABLE VOXYI SYLLABLE VOYI SYLLABLE" +
	" VOPYI SYLLABLE VEXYI SYLLABLE VEPYI SYLLABLE VUTYI SYLLABLE VUXYI SYLLA" +
	"BLE VUYI SYLLABLE VUPYI SYLLABLE VURXYI SYLLABLE VURYI SYLLABLE VYTYI SY" +
	"LLABLE VYXYI SYLLABLE VYYI SYLLABLE VYPYI SYLLABLE VYRXYI SYLLABLE VYRYI" +
	" SYLLABLE DITYI SYLLABLE DIXYI SYLLABLE DIYI SYLLABLE DIPYI SYLLABLE DIE" +
	"XYI SYLLABLE DIEYI SYLLABLE DIEPYI SYLLABLE DATYI SYLLABLE DAXYI SYLLABL" +
	"E DAYI SYLLABLE DAPYI SYLLABLE DUOXYI SYLLABLE DUOYI SYLLABLE DOTYI SYLL" +
	"ABLE DOXYI SYLLABLE DOYI SYLLABLE DOPYI SYLLABLE DEXYI SYLLABLE DEYI SYL" +
	"LABLE DEPYI SYLLABLE DUTYI SYLLABLE DUXYI SYLLABLE DUYI SYLLABLE DUPYI S" +
	"YLLABLE DURXYI SYLLABLE DURYI SYLLABLE TITYI SYLLABLE TIXYI SYLLABLE TIY" +
	"I SYLLABLE TIPYI SYLLABLE TIEXYI SYLLABLE TIEYI SYLLABLE TIEPYI SYLLABLE" +
	" TATYI SYLLABLE TAXYI SYLLABLE TAYI SYLLABLE TAPYI SYLLABLE TUOTYI SYLLA" +
	"BLE TUOXYI SYLLABLE TUOYI SYLLABLE TUOPYI SYLLABLE TOTYI SYLLABLE TOXYI " +
	"SYLLABLE TOYI SYLLABLE TOPYI SYLLABLE TEXYI SYLLABLE TEYI SYLLABLE TEPYI" +
	" SYLLABLE TUTYI SYLLABLE TUXYI SYLLABLE TUYI SYLLABLE TUPYI SYLLABLE TUR" +
	"XYI SYLLABLE TURYI SYLLABLE DDITYI SYLLABLE DDIXYI SYLLABLE DDIYI SYLLAB" +
	"LE DDIPYI SYLLABLE DDIEXYI SYLLABLE DDIEYI SYLLABLE DDIEPYI SYLLABLE DDA" +
	"TYI SYLLABLE DDAXYI SYLLABLE DDAYI SYLLABLE DDAPYI SYLLABLE DDUOXYI SYLL" +
	"ABLE DDUOYI SYLLABLE DDUOPYI SYLLABLE DDOTYI SYLLABLE DDOXYI SYLLABLE DD" +
	"OYI SYLLABLE DDOPYI SYLLABLE DDEXYI SYLLABLE DDEYI SYLLABLE DDEPYI SYLLA" +
	"BLE DDUTYI SYLLABLE DDUXYI SYLLABLE DDUYI SYLLABLE DDUPYI SYLLABLE DDURX" +
	"YI SYLLABLE DDURYI SYLLABLE NDITYI SYLLABLE NDIXYI SYLLABLE NDIYI SYLLAB" +
	"LE NDIPYI SYLLABLE NDIEXYI SYLLABLE NDIEYI SYLLABLE NDATYI SYLLABLE NDAX" +
	"YI SYLLABLE NDAYI SYLLABLE NDAPYI SYLLABLE NDOTYI SYLLABLE NDOXYI SYLLAB" +
	"LE NDOYI SYLLABLE NDOPYI SYLLABLE NDEXYI SYLLABLE NDEYI SYLLABLE NDEPYI " +
	"SYLLABLE NDUTYI SYLLABLE NDUXYI SYLLABLE NDUYI SYLLABLE NDUPYI SYLLABLE " +
	"NDURXYI SYLLABLE NDURYI SYLLABLE HNITYI SYLLABLE HNIXYI SYLLABLE HNIYI S" +
	"YLLABLE HNIPYI SYLLABLE HNIETYI SYLLABLE HNIEXYI SYLLABLE HNIEYI SYLLABL" +
	"E HNIEPYI SYLLABLE HNATYI SYLLABLE HNAXYI SYLLABLE HNAYI SYLLABLE HNAPYI" +
	" SYLLABLE HNUOXYI SYLLABLE HNUOYI SYLLABLE HNOTYI SYLLABLE HNOXYI SYLLAB" +
	"LE HNOPYI SYLLABLE HNEXYI SYLLABLE HNEYI SYLLABLE HNEPYI SYLLABLE HNUTYI" +
	" SYLLABLE NITYI SYLLABLE NIXYI SYLLABLE NIYI SYLLABLE NIPYI SYLLABLE NIE" +
	"XYI SYLLABLE NIEYI SYLLABLE NIEPYI SYLLABLE NAXYI SYLLABLE NAYI SYLLABLE" +
	" NAPYI SYLLABLE NUOXYI SYLLABLE NUOYI SYLLABLE NUOPYI SYLLABLE NOTYI SYL" +
	"LABLE NOXYI SYLLABLE NOYI SYLLABLE NOPYI SYLLABLE NEXYI SYLLABLE NEYI SY" +
	"LLABLE NEPYI SYLLABLE NUTYI SYLLABLE NUXYI SYLLABLE NUYI SYLLABLE NUPYI " +
	"SYLLABLE NURXYI SYLLABLE NURYI SYLLABLE HLITYI SYLLABLE HLIXYI SYLLABLE " +
	"HLIYI SYLLABLE HLIPYI SYLLABLE HLIEXYI SYLLABLE HLIEYI SYLLABLE HLIEPYI " +
	"SYLLABLE HLATYI SYLLABLE HLAXYI SYLLABLE HLAYI SYLLABLE HLAPYI SYLLABLE " +
	"HLUOXYI SYLLABLE HLUOYI SYLLABLE HLUOPYI SYLLABLE HLOXYI SYLLABLE HLOYI ") + ("" +
	"SYLLABLE HLOPYI SYLLABLE HLEXYI SYLLABLE HLEYI SYLLABLE HLEPYI SYLLABLE " +
	"HLUTYI SYLLABLE HLUXYI SYLLABLE HLUYI SYLLABLE HLUPYI SYLLABLE HLURXYI S" +
	"YLLABLE HLURYI SYLLABLE HLYTYI SYLLABLE HLYXYI SYLLABLE HLYYI SYLLABLE H" +
	"LYPYI SYLLABLE HLYRXYI SYLLABLE HLYRYI SYLLABLE LITYI SYLLABLE LIXYI SYL" +
	"LABLE LIYI SYLLABLE LIPYI SYLLABLE LIETYI SYLLABLE LIEXYI SYLLABLE LIEYI" +
	" SYLLABLE LIEPYI SYLLABLE LATYI SYLLABLE LAXYI SYLLABLE LAYI SYLLABLE LA" +
	"PYI SYLLABLE LUOTYI SYLLABLE LUOXYI SYLLABLE LUOYI SYLLABLE LUOPYI SYLLA" +
	"BLE LOTYI SYLLABLE LOXYI SYLLABLE LOYI SYLLABLE LOPYI SYLLABLE LEXYI SYL" +
	"LABLE LEYI SYLLABLE LEPYI SYLLABLE LUTYI SYLLABLE LUXYI SYLLABLE LUYI SY" +
	"LLABLE LUPYI SYLLABLE LURXYI SYLLABLE LURYI SYLLABLE LYTYI SYLLABLE LYXY" +
	"I SYLLABLE LYYI SYLLABLE LYPYI SYLLABLE LYRXYI SYLLABLE LYRYI SYLLABLE G" +
	"ITYI SYLLABLE GIXYI SYLLABLE GIYI SYLLABLE GIPYI SYLLABLE GIETYI SYLLABL" +
	"E GIEXYI SYLLABLE GIEYI SYLLABLE GIEPYI SYLLABLE GATYI SYLLABLE GAXYI SY" +
	"LLABLE GAYI SYLLABLE GAPYI SYLLABLE GUOTYI SYLLABLE GUOXYI SYLLABLE GUOY" +
	"I SYLLABLE GUOPYI SYLLABLE GOTYI SYLLABLE GOXYI SYLLABLE GOYI SYLLABLE G" +
	"OPYI SYLLABLE GETYI SYLLABLE GEXYI SYLLABLE GEYI SYLLABLE GEPYI SYLLABLE" +
	" GUTYI SYLLABLE GUXYI SYLLABLE GUYI SYLLABLE GUPYI SYLLABLE GURXYI SYLLA" +
	"BLE GURYI SYLLABLE KITYI SYLLABLE KIXYI SYLLABLE KIYI SYLLABLE KIPYI SYL" +
	"LABLE KIEXYI SYLLABLE KIEYI SYLLABLE KIEPYI SYLLABLE KATYI SYLLABLE KAXY" +
	"I SYLLABLE KAYI SYLLABLE KAPYI SYLLABLE KUOXYI SYLLABLE KUOYI SYLLABLE K" +
	"UOPYI SYLLABLE KOTYI SYLLABLE KOXYI SYLLABLE KOYI SYLLABLE KOPYI SYLLABL" +
	"E KETYI SYLLABLE KEXYI SYLLABLE KEYI SYLLABLE KEPYI SYLLABLE KUTYI SYLLA" +
	"BLE KUXYI SYLLABLE KUYI SYLLABLE KUPYI SYLLABLE KURXYI SYLLABLE KURYI SY" +
	"LLABLE GGITYI SYLLABLE GGIXYI SYLLABLE GGIYI SYLLABLE GGIEXYI SYLLABLE G" +
	"GIEYI SYLLABLE GGIEPYI SYLLABLE GGATYI SYLLABLE GGAXYI SYLLABLE GGAYI SY" +
	"LLABLE GGAPYI SYLLABLE GGUOTYI SYLLABLE GGUOXYI SYLLABLE GGUOYI SYLLABLE" +
	" GGUOPYI SYLLABLE GGOTYI SYLLABLE GGOXYI SYLLABLE GGOYI SYLLABLE GGOPYI " +
	"SYLLABLE GGETYI SYLLABLE GGEXYI SYLLABLE GGEYI SYLLABLE GGEPYI SYLLABLE " +
	"GGUTYI SYLLABLE GGUXYI SYLLABLE GGUYI SYLLABLE GGUPYI SYLLABLE GGURXYI S" +
	"YLLABLE GGURYI SYLLABLE MGIEXYI SYLLABLE MGIEYI SYLLABLE MGATYI SYLLABLE" +
	" MGAXYI SYLLABLE MGAYI SYLLABLE MGAPYI SYLLABLE MGUOXYI SYLLABLE MGUOYI " +
	"SYLLABLE MGUOPYI SYLLABLE MGOTYI SYLLABLE MGOXYI SYLLABLE MGOYI SYLLABLE" +
	" MGOPYI SYLLABLE MGEXYI SYLLABLE MGEYI SYLLABLE MGEPYI SYLLABLE MGUTYI S" +
	"YLLABLE MGUXYI SYLLABLE MGUYI SYLLABLE MGUPYI SYLLABLE MGURXYI SYLLABLE " +
	"MGURYI SYLLABLE HXITYI SYLLABLE HXIXYI SYLLABLE HXIYI SYLLABLE HXIPYI SY" +
	"LLABLE HXIETYI SYLLABLE HXIEXYI SYLLABLE HXIEYI SYLLABLE HXIEPYI SYLLABL" +
	"E HXATYI SYLLABLE HXAXYI SYLLABLE HXAYI SYLLABLE HXAPYI SYLLABLE HXUOTYI" +
	" SYLLABLE HXUOXYI SYLLABLE HXUOYI SYLLABLE HXUOPYI SYLLABLE HXOTYI SYLLA" +
	"BLE HXOXYI SYLLABLE HXOYI SYLLABLE HXOPYI SYLLABLE HXEXYI SYLLABLE HXEYI" +
	" SYLLABLE HXEPYI SYLLABLE NGIEXYI SYLLABLE NGIEYI SYLLABLE NGIEPYI SYLLA" +
	"BLE NGATYI SYLLABLE NGAXYI SYLLABLE NGAYI SYLLABLE NGAPYI SYLLABLE NGUOT" +
	"YI SYLLABLE NGUOXYI SYLLABLE NGUOYI SYLLABLE NGOTYI SYLLABLE NGOXYI SYLL" +
	"ABLE NGOYI SYLLABLE NGOPYI SYLLABLE NGEXYI SYLLABLE NGEYI SYLLABLE NGEPY" +
	"I SYLLABLE HITYI SYLLABLE HIEXYI SYLLABLE HIEYI SYLLABLE HATYI SYLLABLE " +
	"HAXYI SYLLABLE HAYI SYLLABLE HAPYI SYLLABLE HUOTYI SYLLABLE HUOXYI SYLLA" +
	"BLE HUOYI SYLLABLE HUOPYI SYLLABLE HOTYI SYLLABLE HOXYI SYLLABLE HOYI SY" +
	"LLABLE HOPYI SYLLABLE HEXYI SYLLABLE HEYI SYLLABLE HEPYI SYLLABLE WATYI " +
	"SYLLABLE WAXYI SYLLABLE WAYI SYLLABLE WAPYI SYLLABLE WUOXYI SYLLABLE WUO" +
	"YI SYLLABLE WUOPYI SYLLABLE WOXYI SYLLABLE WOYI SYLLABLE WOPYI SYLLABLE " +
	"WEXYI SYLLABLE WEYI SYLLABLE WEPYI SYLLABLE ZITYI SYLLABLE ZIXYI SYLLABL" +
	"E ZIYI SYLLABLE ZIPYI SYLLABLE ZIEXYI SYLLABLE ZIEYI SYLLABLE ZIEPYI SYL" +
	"LABLE ZATYI SYLLABLE ZAXYI SYLLABLE ZAYI SYLLABLE ZAPYI SYLLABLE ZUOXYI " +
	"SYLLABLE ZUOYI SYLLABLE ZUOPYI SYLLABLE ZOTYI SYLLABLE ZOXYI SYLLABLE ZO" +
	"YI SYLLABLE ZOPYI SYLLABLE ZEXYI SYLLABLE ZEYI SYLLABLE ZEPYI SYLLABLE Z" +
	"UTYI SYLLABLE ZUXYI SYLLABLE ZUYI SYLLABLE ZUPYI SYLLABLE ZURXYI SYLLABL" +
	"E ZURYI SYLLABLE ZYTYI SYLLABLE ZYXYI SYLLABLE ZYYI SYLLABLE ZYPYI SYLLA" +
	"BLE ZYRXYI SYLLABLE ZYRYI SYLLABLE CITYI SYLLABLE CIXYI SYLLABLE CIYI SY" +
	"LLABLE CIPYI SYLLABLE CIETYI SYLLABLE CIEXYI SYLLABLE CIEYI SYLLABLE CIE" +
	"PYI SYLLABLE CATYI SYLLABLE CAXYI SYLLABLE CAYI SYLLABLE CAPYI SYLLABLE " +
	"CUOXYI SYLLABLE CUOYI SYLLABLE CUOPYI SYLLABLE COTYI SYLLABLE COXYI SYLL" +
	"ABLE COYI SYLLABLE COPYI SYLLABLE CEXYI SYLLABLE CEYI SYLLABLE CEPYI SYL" +
	"LABLE CUTYI SYLLABLE CUXYI SYLLABLE CUYI SYLLABLE CUPYI SYLLABLE CURXYI " +
	"SYLLABLE CURYI SYLLABLE CYTYI SYLLABLE CYXYI SYLLABLE CYYI SYLLABLE CYPY" +
	"I SYLLABLE CYRXYI SYLLABLE CYRYI SYLLABLE ZZITYI SYLLABLE ZZIXYI SYLLABL") + ("" +
	"E ZZIYI SYLLABLE ZZIPYI SYLLABLE ZZIETYI SYLLABLE ZZIEXYI SYLLABLE ZZIEY" +
	"I SYLLABLE ZZIEPYI SYLLABLE ZZATYI SYLLABLE ZZAXYI SYLLABLE ZZAYI SYLLAB" +
	"LE ZZAPYI SYLLABLE ZZOXYI SYLLABLE ZZOYI SYLLABLE ZZOPYI SYLLABLE ZZEXYI" +
	" SYLLABLE ZZEYI SYLLABLE ZZEPYI SYLLABLE ZZUXYI SYLLABLE ZZUYI SYLLABLE " +
	"ZZUPYI SYLLABLE ZZURXYI SYLLABLE ZZURYI SYLLABLE ZZYTYI SYLLABLE ZZYXYI " +
	"SYLLABLE ZZYYI SYLLABLE ZZYPYI SYLLABLE ZZYRXYI SYLLABLE ZZYRYI SYLLABLE" +
	" NZITYI SYLLABLE NZIXYI SYLLABLE NZIYI SYLLABLE NZIPYI SYLLABLE NZIEXYI " +
	"SYLLABLE NZIEYI SYLLABLE NZIEPYI SYLLABLE NZATYI SYLLABLE NZAXYI SYLLABL" +
	"E NZAYI SYLLABLE NZAPYI SYLLABLE NZUOXYI SYLLABLE NZUOYI SYLLABLE NZOXYI" +
	" SYLLABLE NZOPYI SYLLABLE NZEXYI SYLLABLE NZEYI SYLLABLE NZUXYI SYLLABLE" +
	" NZUYI SYLLABLE NZUPYI SYLLABLE NZURXYI SYLLABLE NZURYI SYLLABLE NZYTYI " +
	"SYLLABLE NZYXYI SYLLABLE NZYYI SYLLABLE NZYPYI SYLLABLE NZYRXYI SYLLABLE" +
	" NZYRYI SYLLABLE SITYI SYLLABLE SIXYI SYLLABLE SIYI SYLLABLE SIPYI SYLLA" +
	"BLE SIEXYI SYLLABLE SIEYI SYLLABLE SIEPYI SYLLABLE SATYI SYLLABLE SAXYI " +
	"SYLLABLE SAYI SYLLABLE SAPYI SYLLABLE SUOXYI SYLLABLE SUOYI SYLLABLE SUO" +
	"PYI SYLLABLE SOTYI SYLLABLE SOXYI SYLLABLE SOYI SYLLABLE SOPYI SYLLABLE " +
	"SEXYI SYLLABLE SEYI SYLLABLE SEPYI SYLLABLE SUTYI SYLLABLE SUXYI SYLLABL" +
	"E SUYI SYLLABLE SUPYI SYLLABLE SURXYI SYLLABLE SURYI SYLLABLE SYTYI SYLL" +
	"ABLE SYXYI SYLLABLE SYYI SYLLABLE SYPYI SYLLABLE SYRXYI SYLLABLE SYRYI S" +
	"YLLABLE SSITYI SYLLABLE SSIXYI SYLLABLE SSIYI SYLLABLE SSIPYI SYLLABLE S" +
	"SIEXYI SYLLABLE SSIEYI SYLLABLE SSIEPYI SYLLABLE SSATYI SYLLABLE SSAXYI " +
	"SYLLABLE SSAYI SYLLABLE SSAPYI SYLLABLE SSOTYI SYLLABLE SSOXYI SYLLABLE " +
	"SSOYI SYLLABLE SSOPYI SYLLABLE SSEXYI SYLLABLE SSEYI SYLLABLE SSEPYI SYL" +
	"LABLE SSUTYI SYLLABLE SSUXYI SYLLABLE SSUYI SYLLABLE SSUPYI SYLLABLE SSY" +
	"TYI SYLLABLE SSYXYI SYLLABLE SSYYI SYLLABLE SSYPYI SYLLABLE SSYRXYI SYLL" +
	"ABLE SSYRYI SYLLABLE ZHATYI SYLLABLE ZHAXYI SYLLABLE ZHAYI SYLLABLE ZHAP" +
	"YI SYLLABLE ZHUOXYI SYLLABLE ZHUOYI SYLLABLE ZHUOPYI SYLLABLE ZHOTYI SYL" +
	"LABLE ZHOXYI SYLLABLE ZHOYI SYLLABLE ZHOPYI SYLLABLE ZHETYI SYLLABLE ZHE" +
	"XYI SYLLABLE ZHEYI SYLLABLE ZHEPYI SYLLABLE ZHUTYI SYLLABLE ZHUXYI SYLLA" +
	"BLE ZHUYI SYLLABLE ZHUPYI SYLLABLE ZHURXYI SYLLABLE ZHURYI SYLLABLE ZHYT" +
	"YI SYLLABLE ZHYXYI SYLLABLE ZHYYI SYLLABLE ZHYPYI SYLLABLE ZHYRXYI SYLLA" +
	"BLE ZHYRYI SYLLABLE CHATYI SYLLABLE CHAXYI SYLLABLE CHAYI SYLLABLE CHAPY" +
	"I SYLLABLE CHUOTYI SYLLABLE CHUOXYI SYLLABLE CHUOYI SYLLABLE CHUOPYI SYL" +
	"LABLE CHOTYI SYLLABLE CHOXYI SYLLABLE CHOYI SYLLABLE CHOPYI SYLLABLE CHE" +
	"TYI SYLLABLE CHEXYI SYLLABLE CHEYI SYLLABLE CHEPYI SYLLABLE CHUXYI SYLLA" +
	"BLE CHUYI SYLLABLE CHUPYI SYLLABLE CHURXYI SYLLABLE CHURYI SYLLABLE CHYT" +
	"YI SYLLABLE CHYXYI SYLLABLE CHYYI SYLLABLE CHYPYI SYLLABLE CHYRXYI SYLLA" +
	"BLE CHYRYI SYLLABLE RRAXYI SYLLABLE RRAYI SYLLABLE RRUOXYI SYLLABLE RRUO" +
	"YI SYLLABLE RROTYI SYLLABLE RROXYI SYLLABLE RROYI SYLLABLE RROPYI SYLLAB" +
	"LE RRETYI SYLLABLE RREXYI SYLLABLE RREYI SYLLABLE RREPYI SYLLABLE RRUTYI" +
	" SYLLABLE RRUXYI SYLLABLE RRUYI SYLLABLE RRUPYI SYLLABLE RRURXYI SYLLABL" +
	"E RRURYI SYLLABLE RRYTYI SYLLABLE RRYXYI SYLLABLE RRYYI SYLLABLE RRYPYI " +
	"SYLLABLE RRYRXYI SYLLABLE RRYRYI SYLLABLE NRATYI SYLLABLE NRAXYI SYLLABL" +
	"E NRAYI SYLLABLE NRAPYI SYLLABLE NROXYI SYLLABLE NROYI SYLLABLE NROPYI S" +
	"YLLABLE NRETYI SYLLABLE NREXYI SYLLABLE NREYI SYLLABLE NREPYI SYLLABLE N" +
	"RUTYI SYLLABLE NRUXYI SYLLABLE NRUYI SYLLABLE NRUPYI SYLLABLE NRURXYI SY" +
	"LLABLE NRURYI SYLLABLE NRYTYI SYLLABLE NRYXYI SYLLABLE NRYYI SYLLABLE NR" +
	"YPYI SYLLABLE NRYRXYI SYLLABLE NRYRYI SYLLABLE SHATYI SYLLABLE SHAXYI SY" +
	"LLABLE SHAYI SYLLABLE SHAPYI SYLLABLE SHUOXYI SYLLABLE SHUOYI SYLLABLE S" +
	"HUOPYI SYLLABLE SHOTYI SYLLABLE SHOXYI SYLLABLE SHOYI SYLLABLE SHOPYI SY" +
	"LLABLE SHETYI SYLLABLE SHEXYI SYLLABLE SHEYI SYLLABLE SHEPYI SYLLABLE SH" +
	"UTYI SYLLABLE SHUXYI SYLLABLE SHUYI SYLLABLE SHUPYI SYLLABLE SHURXYI SYL" +
	"LABLE SHURYI SYLLABLE SHYTYI SYLLABLE SHYXYI SYLLABLE SHYYI SYLLABLE SHY" +
	"PYI SYLLABLE SHYRXYI SYLLABLE SHYRYI SYLLABLE RATYI SYLLABLE RAXYI SYLLA" +
	"BLE RAYI SYLLABLE RAPYI SYLLABLE RUOXYI SYLLABLE RUOYI SYLLABLE RUOPYI S" +
	"YLLABLE ROTYI SYLLABLE ROXYI SYLLABLE ROYI SYLLABLE ROPYI SYLLABLE REXYI" +
	" SYLLABLE REYI SYLLABLE REPYI SYLLABLE RUTYI SYLLABLE RUXYI SYLLABLE RUY" +
	"I SYLLABLE RUPYI SYLLABLE RURXYI SYLLABLE RURYI SYLLABLE RYTYI SYLLABLE " +
	"RYXYI SYLLABLE RYYI SYLLABLE RYPYI SYLLABLE RYRXYI SYLLABLE RYRYI SYLLAB" +
	"LE JITYI SYLLABLE JIXYI SYLLABLE JIYI SYLLABLE JIPYI SYLLABLE JIETYI SYL" +
	"LABLE JIEXYI SYLLABLE JIEYI SYLLABLE JIEPYI SYLLABLE JUOTYI SYLLABLE JUO" +
	"XYI SYLLABLE JUOYI SYLLABLE JUOPYI SYLLABLE JOTYI SYLLABLE JOXYI SYLLABL" +
	"E JOYI SYLLABLE JOPYI SYLLABLE JUTYI SYLLABLE JUXYI SYLLABLE JUYI SYLLAB" +
	"LE JUPYI SYLLABLE JURXYI SYLLABLE JURYI SYLLABLE JYTYI SYLLABLE JYXYI SY") + ("" +
	"LLABLE JYYI SYLLABLE JYPYI SYLLABLE JYRXYI SYLLABLE JYRYI SYLLABLE QITYI" +
	" SYLLABLE QIXYI SYLLABLE QIYI SYLLABLE QIPYI SYLLABLE QIETYI SYLLABLE QI" +
	"EXYI SYLLABLE QIEYI SYLLABLE QIEPYI SYLLABLE QUOTYI SYLLABLE QUOXYI SYLL" +
	"ABLE QUOYI SYLLABLE QUOPYI SYLLABLE QOTYI SYLLABLE QOXYI SYLLABLE QOYI S" +
	"YLLABLE QOPYI SYLLABLE QUTYI SYLLABLE QUXYI SYLLABLE QUYI SYLLABLE QUPYI" +
	" SYLLABLE QURXYI SYLLABLE QURYI SYLLABLE QYTYI SYLLABLE QYXYI SYLLABLE Q" +
	"YYI SYLLABLE QYPYI SYLLABLE QYRXYI SYLLABLE QYRYI SYLLABLE JJITYI SYLLAB" +
	"LE JJIXYI SYLLABLE JJIYI SYLLABLE JJIPYI SYLLABLE JJIETYI SYLLABLE JJIEX" +
	"YI SYLLABLE JJIEYI SYLLABLE JJIEPYI SYLLABLE JJUOXYI SYLLABLE JJUOYI SYL" +
	"LABLE JJUOPYI SYLLABLE JJOTYI SYLLABLE JJOXYI SYLLABLE JJOYI SYLLABLE JJ" +
	"OPYI SYLLABLE JJUTYI SYLLABLE JJUXYI SYLLABLE JJUYI SYLLABLE JJUPYI SYLL" +
	"ABLE JJURXYI SYLLABLE JJURYI SYLLABLE JJYTYI SYLLABLE JJYXYI SYLLABLE JJ" +
	"YYI SYLLABLE JJYPYI SYLLABLE NJITYI SYLLABLE NJIXYI SYLLABLE NJIYI SYLLA" +
	"BLE NJIPYI SYLLABLE NJIETYI SYLLABLE NJIEXYI SYLLABLE NJIEYI SYLLABLE NJ" +
	"IEPYI SYLLABLE NJUOXYI SYLLABLE NJUOYI SYLLABLE NJOTYI SYLLABLE NJOXYI S" +
	"YLLABLE NJOYI SYLLABLE NJOPYI SYLLABLE NJUXYI SYLLABLE NJUYI SYLLABLE NJ" +
	"UPYI SYLLABLE NJURXYI SYLLABLE NJURYI SYLLABLE NJYTYI SYLLABLE NJYXYI SY" +
	"LLABLE NJYYI SYLLABLE NJYPYI SYLLABLE NJYRXYI SYLLABLE NJYRYI SYLLABLE N" +
	"YITYI SYLLABLE NYIXYI SYLLABLE NYIYI SYLLABLE NYIPYI SYLLABLE NYIETYI SY" +
	"LLABLE NYIEXYI SYLLABLE NYIEYI SYLLABLE NYIEPYI SYLLABLE NYUOXYI SYLLABL" +
	"E NYUOYI SYLLABLE NYUOPYI SYLLABLE NYOTYI SYLLABLE NYOXYI SYLLABLE NYOYI" +
	" SYLLABLE NYOPYI SYLLABLE NYUTYI SYLLABLE NYUXYI SYLLABLE NYUYI SYLLABLE" +
	" NYUPYI SYLLABLE XITYI SYLLABLE XIXYI SYLLABLE XIYI SYLLABLE XIPYI SYLLA" +
	"BLE XIETYI SYLLABLE XIEXYI SYLLABLE XIEYI SYLLABLE XIEPYI SYLLABLE XUOXY" +
	"I SYLLABLE XUOYI SYLLABLE XOTYI SYLLABLE XOXYI SYLLABLE XOYI SYLLABLE XO" +
	"PYI SYLLABLE XYTYI SYLLABLE XYXYI SYLLABLE XYYI SYLLABLE XYPYI SYLLABLE " +
	"XYRXYI SYLLABLE XYRYI SYLLABLE YITYI SYLLABLE YIXYI SYLLABLE YIYI SYLLAB" +
	"LE YIPYI SYLLABLE YIETYI SYLLABLE YIEXYI SYLLABLE YIEYI SYLLABLE YIEPYI " +
	"SYLLABLE YUOTYI SYLLABLE YUOXYI SYLLABLE YUOYI SYLLABLE YUOPYI SYLLABLE " +
	"YOTYI SYLLABLE YOXYI SYLLABLE YOYI SYLLABLE YOPYI SYLLABLE YUTYI SYLLABL" +
	"E YUXYI SYLLABLE YUYI SYLLABLE YUPYI SYLLABLE YURXYI SYLLABLE YURYI SYLL" +
	"ABLE YYTYI SYLLABLE YYXYI SYLLABLE YYYI SYLLABLE YYPYI SYLLABLE YYRXYI S" +
	"YLLABLE YYRYI RADICAL QOTYI RADICAL LIYI RADICAL KITYI RADICAL NYIPYI RA" +
	"DICAL CYPYI RADICAL SSIYI RADICAL GGOPYI RADICAL GEPYI RADICAL MIYI RADI" +
	"CAL HXITYI RADICAL LYRYI RADICAL BBUTYI RADICAL MOPYI RADICAL YOYI RADIC" +
	"AL PUTYI RADICAL HXUOYI RADICAL TATYI RADICAL GAYI RADICAL ZUPYI RADICAL" +
	" CYTYI RADICAL DDURYI RADICAL BURYI RADICAL GGUOYI RADICAL NYOPYI RADICA" +
	"L TUYI RADICAL OPYI RADICAL JJUTYI RADICAL ZOTYI RADICAL PYTYI RADICAL H" +
	"MOYI RADICAL YITYI RADICAL VURYI RADICAL SHYYI RADICAL VEPYI RADICAL ZAY" +
	"I RADICAL JOYI RADICAL NZUPYI RADICAL JJYYI RADICAL GOTYI RADICAL JJIEYI" +
	" RADICAL WOYI RADICAL DUYI RADICAL SHURYI RADICAL LIEYI RADICAL CYYI RAD" +
	"ICAL CUOPYI RADICAL CIPYI RADICAL HXOPYI RADICAL SHATYI RADICAL ZURYI RA" +
	"DICAL SHOPYI RADICAL CHEYI RADICAL ZZIETYI RADICAL NBIEYI RADICAL KELISU" +
	" LETTER BALISU LETTER PALISU LETTER PHALISU LETTER DALISU LETTER TALISU " +
	"LETTER THALISU LETTER GALISU LETTER KALISU LETTER KHALISU LETTER JALISU " +
	"LETTER CALISU LETTER CHALISU LETTER DZALISU LETTER TSALISU LETTER TSHALI" +
	"SU LETTER MALISU LETTER NALISU LETTER LALISU LETTER SALISU LETTER ZHALIS" +
	"U LETTER ZALISU LETTER NGALISU LETTER HALISU LETTER XALISU LETTER HHALIS" +
	"U LETTER FALISU LETTER WALISU LETTER SHALISU LETTER YALISU LETTER GHALIS" +
	"U LETTER ALISU LETTER AELISU LETTER ELISU LETTER EULISU LETTER ILISU LET" +
	"TER OLISU LETTER ULISU LETTER UELISU LETTER UHLISU LETTER OELISU LETTER " +
	"TONE MYA TILISU LETTER TONE NA POLISU LETTER TONE MYA CYALISU LETTER TON" +
	"E MYA BOLISU LETTER TONE MYA NALISU LETTER TONE MYA JEULISU PUNCTUATION " +
	"COMMALISU PUNCTUATION FULL STOPVAI SYLLABLE EEVAI SYLLABLE EENVAI SYLLAB" +
	"LE HEEVAI SYLLABLE WEEVAI SYLLABLE WEENVAI SYLLABLE PEEVAI SYLLABLE BHEE" +
	"VAI SYLLABLE BEEVAI SYLLABLE MBEEVAI SYLLABLE KPEEVAI SYLLABLE MGBEEVAI " +
	"SYLLABLE GBEEVAI SYLLABLE FEEVAI SYLLABLE VEEVAI SYLLABLE TEEVAI SYLLABL" +
	"E THEEVAI SYLLABLE DHEEVAI SYLLABLE DHHEEVAI SYLLABLE LEEVAI SYLLABLE RE" +
	"EVAI SYLLABLE DEEVAI SYLLABLE NDEEVAI SYLLABLE SEEVAI SYLLABLE SHEEVAI S" +
	"YLLABLE ZEEVAI SYLLABLE ZHEEVAI SYLLABLE CEEVAI SYLLABLE JEEVAI SYLLABLE" +
	" NJEEVAI SYLLABLE YEEVAI SYLLABLE KEEVAI SYLLABLE NGGEEVAI SYLLABLE GEEV" +
	"AI SYLLABLE MEEVAI SYLLABLE NEEVAI SYLLABLE NYEEVAI SYLLABLE IVAI SYLLAB" +
	"LE INVAI SYLLABLE HIVAI SYLLABLE HINVAI SYLLABLE WIVAI SYLLABLE WINVAI S" +
	"YLLABLE PIVAI SYLLABLE BHIVAI SYLLABLE BIVAI SYLLABLE MBIVAI SYLLABLE KP") + ("" +
	"IVAI SYLLABLE MGBIVAI SYLLABLE GBIVAI SYLLABLE FIVAI SYLLABLE VIVAI SYLL" +
	"ABLE TIVAI SYLLABLE THIVAI SYLLABLE DHIVAI SYLLABLE DHHIVAI SYLLABLE LIV" +
	"AI SYLLABLE RIVAI SYLLABLE DIVAI SYLLABLE NDIVAI SYLLABLE SIVAI SYLLABLE" +
	" SHIVAI SYLLABLE ZIVAI SYLLABLE ZHIVAI SYLLABLE CIVAI SYLLABLE JIVAI SYL" +
	"LABLE NJIVAI SYLLABLE YIVAI SYLLABLE KIVAI SYLLABLE NGGIVAI SYLLABLE GIV" +
	"AI SYLLABLE MIVAI SYLLABLE NIVAI SYLLABLE NYIVAI SYLLABLE AVAI SYLLABLE " +
	"ANVAI SYLLABLE NGANVAI SYLLABLE HAVAI SYLLABLE HANVAI SYLLABLE WAVAI SYL" +
	"LABLE WANVAI SYLLABLE PAVAI SYLLABLE BHAVAI SYLLABLE BAVAI SYLLABLE MBAV" +
	"AI SYLLABLE KPAVAI SYLLABLE KPANVAI SYLLABLE MGBAVAI SYLLABLE GBAVAI SYL" +
	"LABLE FAVAI SYLLABLE VAVAI SYLLABLE TAVAI SYLLABLE THAVAI SYLLABLE DHAVA" +
	"I SYLLABLE DHHAVAI SYLLABLE LAVAI SYLLABLE RAVAI SYLLABLE DAVAI SYLLABLE" +
	" NDAVAI SYLLABLE SAVAI SYLLABLE SHAVAI SYLLABLE ZAVAI SYLLABLE ZHAVAI SY" +
	"LLABLE CAVAI SYLLABLE JAVAI SYLLABLE NJAVAI SYLLABLE YAVAI SYLLABLE KAVA" +
	"I SYLLABLE KANVAI SYLLABLE NGGAVAI SYLLABLE GAVAI SYLLABLE MAVAI SYLLABL" +
	"E NAVAI SYLLABLE NYAVAI SYLLABLE OOVAI SYLLABLE OONVAI SYLLABLE HOOVAI S" +
	"YLLABLE WOOVAI SYLLABLE WOONVAI SYLLABLE POOVAI SYLLABLE BHOOVAI SYLLABL" +
	"E BOOVAI SYLLABLE MBOOVAI SYLLABLE KPOOVAI SYLLABLE MGBOOVAI SYLLABLE GB" +
	"OOVAI SYLLABLE FOOVAI SYLLABLE VOOVAI SYLLABLE TOOVAI SYLLABLE THOOVAI S" +
	"YLLABLE DHOOVAI SYLLABLE DHHOOVAI SYLLABLE LOOVAI SYLLABLE ROOVAI SYLLAB" +
	"LE DOOVAI SYLLABLE NDOOVAI SYLLABLE SOOVAI SYLLABLE SHOOVAI SYLLABLE ZOO" +
	"VAI SYLLABLE ZHOOVAI SYLLABLE COOVAI SYLLABLE JOOVAI SYLLABLE NJOOVAI SY" +
	"LLABLE YOOVAI SYLLABLE KOOVAI SYLLABLE NGGOOVAI SYLLABLE GOOVAI SYLLABLE" +
	" MOOVAI SYLLABLE NOOVAI SYLLABLE NYOOVAI SYLLABLE UVAI SYLLABLE UNVAI SY" +
	"LLABLE HUVAI SYLLABLE HUNVAI SYLLABLE WUVAI SYLLABLE WUNVAI SYLLABLE PUV" +
	"AI SYLLABLE BHUVAI SYLLABLE BUVAI SYLLABLE MBUVAI SYLLABLE KPUVAI SYLLAB" +
	"LE MGBUVAI SYLLABLE GBUVAI SYLLABLE FUVAI SYLLABLE VUVAI SYLLABLE TUVAI " +
	"SYLLABLE THUVAI SYLLABLE DHUVAI SYLLABLE DHHUVAI SYLLABLE LUVAI SYLLABLE" +
	" RUVAI SYLLABLE DUVAI SYLLABLE NDUVAI SYLLABLE SUVAI SYLLABLE SHUVAI SYL" +
	"LABLE ZUVAI SYLLABLE ZHUVAI SYLLABLE CUVAI SYLLABLE JUVAI SYLLABLE NJUVA" +
	"I SYLLABLE YUVAI SYLLABLE KUVAI SYLLABLE NGGUVAI SYLLABLE GUVAI SYLLABLE" +
	" MUVAI SYLLABLE NUVAI SYLLABLE NYUVAI SYLLABLE OVAI SYLLABLE ONVAI SYLLA" +
	"BLE NGONVAI SYLLABLE HOVAI SYLLABLE HONVAI SYLLABLE WOVAI SYLLABLE WONVA" +
	"I SYLLABLE POVAI SYLLABLE BHOVAI SYLLABLE BOVAI SYLLABLE MBOVAI SYLLABLE" +
	" KPOVAI SYLLABLE MGBOVAI SYLLABLE GBOVAI SYLLABLE GBONVAI SYLLABLE FOVAI" +
	" SYLLABLE VOVAI SYLLABLE TOVAI SYLLABLE THOVAI SYLLABLE DHOVAI SYLLABLE " +
	"DHHOVAI SYLLABLE LOVAI SYLLABLE ROVAI SYLLABLE DOVAI SYLLABLE NDOVAI SYL" +
	"LABLE SOVAI SYLLABLE SHOVAI SYLLABLE ZOVAI SYLLABLE ZHOVAI SYLLABLE COVA" +
	"I SYLLABLE JOVAI SYLLABLE NJOVAI SYLLABLE YOVAI SYLLABLE KOVAI SYLLABLE " +
	"NGGOVAI SYLLABLE GOVAI SYLLABLE MOVAI SYLLABLE NOVAI SYLLABLE NYOVAI SYL" +
	"LABLE EVAI SYLLABLE ENVAI SYLLABLE NGENVAI SYLLABLE HEVAI SYLLABLE HENVA" +
	"I SYLLABLE WEVAI SYLLABLE WENVAI SYLLABLE PEVAI SYLLABLE BHEVAI SYLLABLE" +
	" BEVAI SYLLABLE MBEVAI SYLLABLE KPEVAI SYLLABLE KPENVAI SYLLABLE MGBEVAI" +
	" SYLLABLE GBEVAI SYLLABLE GBENVAI SYLLABLE FEVAI SYLLABLE VEVAI SYLLABLE" +
	" TEVAI SYLLABLE THEVAI SYLLABLE DHEVAI SYLLABLE DHHEVAI SYLLABLE LEVAI S" +
	"YLLABLE REVAI SYLLABLE DEVAI SYLLABLE NDEVAI SYLLABLE SEVAI SYLLABLE SHE" +
	"VAI SYLLABLE ZEVAI SYLLABLE ZHEVAI SYLLABLE CEVAI SYLLABLE JEVAI SYLLABL" +
	"E NJEVAI SYLLABLE YEVAI SYLLABLE KEVAI SYLLABLE NGGEVAI SYLLABLE NGGENVA" +
	"I SYLLABLE GEVAI SYLLABLE GENVAI SYLLABLE MEVAI SYLLABLE NEVAI SYLLABLE " +
	"NYEVAI SYLLABLE NGVAI SYLLABLE LENGTHENERVAI COMMAVAI FULL STOPVAI QUEST" +
	"ION MARKVAI SYLLABLE NDOLE FAVAI SYLLABLE NDOLE KAVAI SYLLABLE NDOLE SOO" +
	"VAI SYMBOL FEENGVAI SYMBOL KEENGVAI SYMBOL TINGVAI SYMBOL NIIVAI SYMBOL " +
	"BANGVAI SYMBOL FAAVAI SYMBOL TAAVAI SYMBOL DANGVAI SYMBOL DOONGVAI SYMBO" +
	"L KUNGVAI SYMBOL TONGVAI SYMBOL DO-OVAI SYMBOL JONGVAI DIGIT ZEROVAI DIG" +
	"IT ONEVAI DIGIT TWOVAI DIGIT THREEVAI DIGIT FOURVAI DIGIT FIVEVAI DIGIT " +
	"SIXVAI DIGIT SEVENVAI DIGIT EIGHTVAI DIGIT NINEVAI SYLLABLE NDOLE MAVAI " +
	"SYLLABLE NDOLE DOCYRILLIC CAPITAL LETTER ZEMLYACYRILLIC SMALL LETTER ZEM" +
	"LYACYRILLIC CAPITAL LETTER DZELOCYRILLIC SMALL LETTER DZELOCYRILLIC CAPI" +
	"TAL LETTER REVERSED DZECYRILLIC SMALL LETTER REVERSED DZECYRILLIC CAPITA" +
	"L LETTER IOTACYRILLIC SMALL LETTER IOTACYRILLIC CAPITAL LETTER DJERVCYRI" +
	"LLIC SMALL LETTER DJERVCYRILLIC CAPITAL LETTER MONOGRAPH UKCYRILLIC SMAL" +
	"L LETTER MONOGRAPH UKCYRILLIC CAPITAL LETTER BROAD OMEGACYRILLIC SMALL L" +
	"ETTER BROAD OMEGACYRILLIC CAPITAL LETTER NEUTRAL YERCYRILLIC SMALL LETTE" +
	"R NEUTRAL YERCYRILLIC CAPITAL LETTER YERU WITH BACK YERCYRILLIC SMALL LE" +
	"TTER YERU WITH BACK YERCYRILLIC CAPITAL LETTER IOTIFIED YATCYRILLIC SMAL") + ("" +
	"L LETTER IOTIFIED YATCYRILLIC CAPITAL LETTER REVERSED YUCYRILLIC SMALL L" +
	"ETTER REVERSED YUCYRILLIC CAPITAL LETTER IOTIFIED ACYRILLIC SMALL LETTER" +
	" IOTIFIED ACYRILLIC CAPITAL LETTER CLOSED LITTLE YUSCYRILLIC SMALL LETTE" +
	"R CLOSED LITTLE YUSCYRILLIC CAPITAL LETTER BLENDED YUSCYRILLIC SMALL LET" +
	"TER BLENDED YUSCYRILLIC CAPITAL LETTER IOTIFIED CLOSED LITTLE YUSCYRILLI" +
	"C SMALL LETTER IOTIFIED CLOSED LITTLE YUSCYRILLIC CAPITAL LETTER YNCYRIL" +
	"LIC SMALL LETTER YNCYRILLIC CAPITAL LETTER REVERSED TSECYRILLIC SMALL LE" +
	"TTER REVERSED TSECYRILLIC CAPITAL LETTER SOFT DECYRILLIC SMALL LETTER SO" +
	"FT DECYRILLIC CAPITAL LETTER SOFT ELCYRILLIC SMALL LETTER SOFT ELCYRILLI" +
	"C CAPITAL LETTER SOFT EMCYRILLIC SMALL LETTER SOFT EMCYRILLIC CAPITAL LE" +
	"TTER MONOCULAR OCYRILLIC SMALL LETTER MONOCULAR OCYRILLIC CAPITAL LETTER" +
	" BINOCULAR OCYRILLIC SMALL LETTER BINOCULAR OCYRILLIC CAPITAL LETTER DOU" +
	"BLE MONOCULAR OCYRILLIC SMALL LETTER DOUBLE MONOCULAR OCYRILLIC LETTER M" +
	"ULTIOCULAR OCOMBINING CYRILLIC VZMETCOMBINING CYRILLIC TEN MILLIONS SIGN" +
	"COMBINING CYRILLIC HUNDRED MILLIONS SIGNCOMBINING CYRILLIC THOUSAND MILL" +
	"IONS SIGNSLAVONIC ASTERISKCOMBINING CYRILLIC LETTER UKRAINIAN IECOMBININ" +
	"G CYRILLIC LETTER ICOMBINING CYRILLIC LETTER YICOMBINING CYRILLIC LETTER" +
	" UCOMBINING CYRILLIC LETTER HARD SIGNCOMBINING CYRILLIC LETTER YERUCOMBI" +
	"NING CYRILLIC LETTER SOFT SIGNCOMBINING CYRILLIC LETTER OMEGACOMBINING C" +
	"YRILLIC KAVYKACOMBINING CYRILLIC PAYEROKCYRILLIC KAVYKACYRILLIC PAYEROKC" +
	"YRILLIC CAPITAL LETTER DWECYRILLIC SMALL LETTER DWECYRILLIC CAPITAL LETT" +
	"ER DZWECYRILLIC SMALL LETTER DZWECYRILLIC CAPITAL LETTER ZHWECYRILLIC SM" +
	"ALL LETTER ZHWECYRILLIC CAPITAL LETTER CCHECYRILLIC SMALL LETTER CCHECYR" +
	"ILLIC CAPITAL LETTER DZZECYRILLIC SMALL LETTER DZZECYRILLIC CAPITAL LETT" +
	"ER TE WITH MIDDLE HOOKCYRILLIC SMALL LETTER TE WITH MIDDLE HOOKCYRILLIC " +
	"CAPITAL LETTER TWECYRILLIC SMALL LETTER TWECYRILLIC CAPITAL LETTER TSWEC" +
	"YRILLIC SMALL LETTER TSWECYRILLIC CAPITAL LETTER TSSECYRILLIC SMALL LETT" +
	"ER TSSECYRILLIC CAPITAL LETTER TCHECYRILLIC SMALL LETTER TCHECYRILLIC CA" +
	"PITAL LETTER HWECYRILLIC SMALL LETTER HWECYRILLIC CAPITAL LETTER SHWECYR" +
	"ILLIC SMALL LETTER SHWECYRILLIC CAPITAL LETTER DOUBLE OCYRILLIC SMALL LE" +
	"TTER DOUBLE OCYRILLIC CAPITAL LETTER CROSSED OCYRILLIC SMALL LETTER CROS" +
	"SED OMODIFIER LETTER CYRILLIC HARD SIGNMODIFIER LETTER CYRILLIC SOFT SIG" +
	"NCOMBINING CYRILLIC LETTER EFCOMBINING CYRILLIC LETTER IOTIFIED EBAMUM L" +
	"ETTER ABAMUM LETTER KABAMUM LETTER UBAMUM LETTER KUBAMUM LETTER EEBAMUM " +
	"LETTER REEBAMUM LETTER TAEBAMUM LETTER OBAMUM LETTER NYIBAMUM LETTER IBA" +
	"MUM LETTER LABAMUM LETTER PABAMUM LETTER RIIBAMUM LETTER RIEEBAMUM LETTE" +
	"R LEEEEBAMUM LETTER MEEEEBAMUM LETTER TAABAMUM LETTER NDAABAMUM LETTER N" +
	"JAEMBAMUM LETTER MBAMUM LETTER SUUBAMUM LETTER MUBAMUM LETTER SHIIBAMUM " +
	"LETTER SIBAMUM LETTER SHEUXBAMUM LETTER SEUXBAMUM LETTER KYEEBAMUM LETTE" +
	"R KETBAMUM LETTER NUAEBAMUM LETTER NUBAMUM LETTER NJUAEBAMUM LETTER YOQB" +
	"AMUM LETTER SHUBAMUM LETTER YUQBAMUM LETTER YABAMUM LETTER NSHABAMUM LET" +
	"TER KEUXBAMUM LETTER PEUXBAMUM LETTER NJEEBAMUM LETTER NTEEBAMUM LETTER " +
	"PUEBAMUM LETTER WUEBAMUM LETTER PEEBAMUM LETTER FEEBAMUM LETTER RUBAMUM " +
	"LETTER LUBAMUM LETTER MIBAMUM LETTER NIBAMUM LETTER REUXBAMUM LETTER RAE" +
	"BAMUM LETTER KENBAMUM LETTER NGKWAENBAMUM LETTER NGGABAMUM LETTER NGABAM" +
	"UM LETTER SHOBAMUM LETTER PUAEBAMUM LETTER FUBAMUM LETTER FOMBAMUM LETTE" +
	"R WABAMUM LETTER NABAMUM LETTER LIBAMUM LETTER PIBAMUM LETTER LOQBAMUM L" +
	"ETTER KOBAMUM LETTER MBENBAMUM LETTER RENBAMUM LETTER MENBAMUM LETTER MA" +
	"BAMUM LETTER TIBAMUM LETTER KIBAMUM LETTER MOBAMUM LETTER MBAABAMUM LETT" +
	"ER TETBAMUM LETTER KPABAMUM LETTER TENBAMUM LETTER NTUUBAMUM LETTER SAMB" +
	"ABAMUM LETTER FAAMAEBAMUM LETTER KOVUUBAMUM LETTER KOGHOMBAMUM COMBINING" +
	" MARK KOQNDONBAMUM COMBINING MARK TUKWENTISBAMUM NJAEMLIBAMUM FULL STOPB" +
	"AMUM COLONBAMUM COMMABAMUM SEMICOLONBAMUM QUESTION MARKMODIFIER LETTER C" +
	"HINESE TONE YIN PINGMODIFIER LETTER CHINESE TONE YANG PINGMODIFIER LETTE" +
	"R CHINESE TONE YIN SHANGMODIFIER LETTER CHINESE TONE YANG SHANGMODIFIER " +
	"LETTER CHINESE TONE YIN QUMODIFIER LETTER CHINESE TONE YANG QUMODIFIER L" +
	"ETTER CHINESE TONE YIN RUMODIFIER LETTER CHINESE TONE YANG RUMODIFIER LE" +
	"TTER EXTRA-HIGH DOTTED TONE BARMODIFIER LETTER HIGH DOTTED TONE BARMODIF" +
	"IER LETTER MID DOTTED TONE BARMODIFIER LETTER LOW DOTTED TONE BARMODIFIE" +
	"R LETTER EXTRA-LOW DOTTED TONE BARMODIFIER LETTER EXTRA-HIGH DOTTED LEFT" +
	"-STEM TONE BARMODIFIER LETTER HIGH DOTTED LEFT-STEM TONE BARMODIFIER LET" +
	"TER MID DOTTED LEFT-STEM TONE BARMODIFIER LETTER LOW DOTTED LEFT-STEM TO" +
	"NE BARMODIFIER LETTER EXTRA-LOW DOTTED LEFT-STEM TONE BARMODIFIER LETTER" +
	" EXTRA-HIGH LEFT-STEM TONE BARMODIFIER LETTER HIGH LEFT-STEM TONE BARMOD") + ("" +
	"IFIER LETTER MID LEFT-STEM TONE BARMODIFIER LETTER LOW LEFT-STEM TONE BA" +
	"RMODIFIER LETTER EXTRA-LOW LEFT-STEM TONE BARMODIFIER LETTER DOT VERTICA" +
	"L BARMODIFIER LETTER DOT SLASHMODIFIER LETTER DOT HORIZONTAL BARMODIFIER" +
	" LETTER LOWER RIGHT CORNER ANGLEMODIFIER LETTER RAISED UP ARROWMODIFIER " +
	"LETTER RAISED DOWN ARROWMODIFIER LETTER RAISED EXCLAMATION MARKMODIFIER " +
	"LETTER RAISED INVERTED EXCLAMATION MARKMODIFIER LETTER LOW INVERTED EXCL" +
	"AMATION MARKMODIFIER LETTER STRESS AND HIGH TONEMODIFIER LETTER STRESS A" +
	"ND LOW TONELATIN CAPITAL LETTER EGYPTOLOGICAL ALEFLATIN SMALL LETTER EGY" +
	"PTOLOGICAL ALEFLATIN CAPITAL LETTER EGYPTOLOGICAL AINLATIN SMALL LETTER " +
	"EGYPTOLOGICAL AINLATIN CAPITAL LETTER HENGLATIN SMALL LETTER HENGLATIN C" +
	"APITAL LETTER TZLATIN SMALL LETTER TZLATIN CAPITAL LETTER TRESILLOLATIN " +
	"SMALL LETTER TRESILLOLATIN CAPITAL LETTER CUATRILLOLATIN SMALL LETTER CU" +
	"ATRILLOLATIN CAPITAL LETTER CUATRILLO WITH COMMALATIN SMALL LETTER CUATR" +
	"ILLO WITH COMMALATIN LETTER SMALL CAPITAL FLATIN LETTER SMALL CAPITAL SL" +
	"ATIN CAPITAL LETTER AALATIN SMALL LETTER AALATIN CAPITAL LETTER AOLATIN " +
	"SMALL LETTER AOLATIN CAPITAL LETTER AULATIN SMALL LETTER AULATIN CAPITAL" +
	" LETTER AVLATIN SMALL LETTER AVLATIN CAPITAL LETTER AV WITH HORIZONTAL B" +
	"ARLATIN SMALL LETTER AV WITH HORIZONTAL BARLATIN CAPITAL LETTER AYLATIN " +
	"SMALL LETTER AYLATIN CAPITAL LETTER REVERSED C WITH DOTLATIN SMALL LETTE" +
	"R REVERSED C WITH DOTLATIN CAPITAL LETTER K WITH STROKELATIN SMALL LETTE" +
	"R K WITH STROKELATIN CAPITAL LETTER K WITH DIAGONAL STROKELATIN SMALL LE" +
	"TTER K WITH DIAGONAL STROKELATIN CAPITAL LETTER K WITH STROKE AND DIAGON" +
	"AL STROKELATIN SMALL LETTER K WITH STROKE AND DIAGONAL STROKELATIN CAPIT" +
	"AL LETTER BROKEN LLATIN SMALL LETTER BROKEN LLATIN CAPITAL LETTER L WITH" +
	" HIGH STROKELATIN SMALL LETTER L WITH HIGH STROKELATIN CAPITAL LETTER O " +
	"WITH LONG STROKE OVERLAYLATIN SMALL LETTER O WITH LONG STROKE OVERLAYLAT" +
	"IN CAPITAL LETTER O WITH LOOPLATIN SMALL LETTER O WITH LOOPLATIN CAPITAL" +
	" LETTER OOLATIN SMALL LETTER OOLATIN CAPITAL LETTER P WITH STROKE THROUG" +
	"H DESCENDERLATIN SMALL LETTER P WITH STROKE THROUGH DESCENDERLATIN CAPIT" +
	"AL LETTER P WITH FLOURISHLATIN SMALL LETTER P WITH FLOURISHLATIN CAPITAL" +
	" LETTER P WITH SQUIRREL TAILLATIN SMALL LETTER P WITH SQUIRREL TAILLATIN" +
	" CAPITAL LETTER Q WITH STROKE THROUGH DESCENDERLATIN SMALL LETTER Q WITH" +
	" STROKE THROUGH DESCENDERLATIN CAPITAL LETTER Q WITH DIAGONAL STROKELATI" +
	"N SMALL LETTER Q WITH DIAGONAL STROKELATIN CAPITAL LETTER R ROTUNDALATIN" +
	" SMALL LETTER R ROTUNDALATIN CAPITAL LETTER RUM ROTUNDALATIN SMALL LETTE" +
	"R RUM ROTUNDALATIN CAPITAL LETTER V WITH DIAGONAL STROKELATIN SMALL LETT" +
	"ER V WITH DIAGONAL STROKELATIN CAPITAL LETTER VYLATIN SMALL LETTER VYLAT" +
	"IN CAPITAL LETTER VISIGOTHIC ZLATIN SMALL LETTER VISIGOTHIC ZLATIN CAPIT" +
	"AL LETTER THORN WITH STROKELATIN SMALL LETTER THORN WITH STROKELATIN CAP" +
	"ITAL LETTER THORN WITH STROKE THROUGH DESCENDERLATIN SMALL LETTER THORN " +
	"WITH STROKE THROUGH DESCENDERLATIN CAPITAL LETTER VENDLATIN SMALL LETTER" +
	" VENDLATIN CAPITAL LETTER ETLATIN SMALL LETTER ETLATIN CAPITAL LETTER IS" +
	"LATIN SMALL LETTER ISLATIN CAPITAL LETTER CONLATIN SMALL LETTER CONMODIF" +
	"IER LETTER USLATIN SMALL LETTER DUMLATIN SMALL LETTER LUMLATIN SMALL LET" +
	"TER MUMLATIN SMALL LETTER NUMLATIN SMALL LETTER RUMLATIN LETTER SMALL CA" +
	"PITAL RUMLATIN SMALL LETTER TUMLATIN SMALL LETTER UMLATIN CAPITAL LETTER" +
	" INSULAR DLATIN SMALL LETTER INSULAR DLATIN CAPITAL LETTER INSULAR FLATI" +
	"N SMALL LETTER INSULAR FLATIN CAPITAL LETTER INSULAR GLATIN CAPITAL LETT" +
	"ER TURNED INSULAR GLATIN SMALL LETTER TURNED INSULAR GLATIN CAPITAL LETT" +
	"ER TURNED LLATIN SMALL LETTER TURNED LLATIN CAPITAL LETTER INSULAR RLATI" +
	"N SMALL LETTER INSULAR RLATIN CAPITAL LETTER INSULAR SLATIN SMALL LETTER" +
	" INSULAR SLATIN CAPITAL LETTER INSULAR TLATIN SMALL LETTER INSULAR TMODI" +
	"FIER LETTER LOW CIRCUMFLEX ACCENTMODIFIER LETTER COLONMODIFIER LETTER SH" +
	"ORT EQUALS SIGNLATIN CAPITAL LETTER SALTILLOLATIN SMALL LETTER SALTILLOL" +
	"ATIN CAPITAL LETTER TURNED HLATIN SMALL LETTER L WITH RETROFLEX HOOK AND" +
	" BELTLATIN LETTER SINOLOGICAL DOTLATIN CAPITAL LETTER N WITH DESCENDERLA" +
	"TIN SMALL LETTER N WITH DESCENDERLATIN CAPITAL LETTER C WITH BARLATIN SM" +
	"ALL LETTER C WITH BARLATIN SMALL LETTER C WITH PALATAL HOOKLATIN SMALL L" +
	"ETTER H WITH PALATAL HOOKLATIN CAPITAL LETTER B WITH FLOURISHLATIN SMALL" +
	" LETTER B WITH FLOURISHLATIN CAPITAL LETTER F WITH STROKELATIN SMALL LET" +
	"TER F WITH STROKELATIN CAPITAL LETTER VOLAPUK AELATIN SMALL LETTER VOLAP" +
	"UK AELATIN CAPITAL LETTER VOLAPUK OELATIN SMALL LETTER VOLAPUK OELATIN C" +
	"APITAL LETTER VOLAPUK UELATIN SMALL LETTER VOLAPUK UELATIN CAPITAL LETTE" +
	"R G WITH OBLIQUE STROKELATIN SMALL LETTER G WITH OBLIQUE STROKELATIN CAP") + ("" +
	"ITAL LETTER K WITH OBLIQUE STROKELATIN SMALL LETTER K WITH OBLIQUE STROK" +
	"ELATIN CAPITAL LETTER N WITH OBLIQUE STROKELATIN SMALL LETTER N WITH OBL" +
	"IQUE STROKELATIN CAPITAL LETTER R WITH OBLIQUE STROKELATIN SMALL LETTER " +
	"R WITH OBLIQUE STROKELATIN CAPITAL LETTER S WITH OBLIQUE STROKELATIN SMA" +
	"LL LETTER S WITH OBLIQUE STROKELATIN CAPITAL LETTER H WITH HOOKLATIN CAP" +
	"ITAL LETTER REVERSED OPEN ELATIN CAPITAL LETTER SCRIPT GLATIN CAPITAL LE" +
	"TTER L WITH BELTLATIN CAPITAL LETTER SMALL CAPITAL ILATIN CAPITAL LETTER" +
	" TURNED KLATIN CAPITAL LETTER TURNED TLATIN CAPITAL LETTER J WITH CROSSE" +
	"D-TAILLATIN CAPITAL LETTER CHILATIN CAPITAL LETTER BETALATIN SMALL LETTE" +
	"R BETALATIN CAPITAL LETTER OMEGALATIN SMALL LETTER OMEGALATIN EPIGRAPHIC" +
	" LETTER SIDEWAYS IMODIFIER LETTER CAPITAL H WITH STROKEMODIFIER LETTER S" +
	"MALL LIGATURE OELATIN LETTER SMALL CAPITAL TURNED MLATIN EPIGRAPHIC LETT" +
	"ER REVERSED FLATIN EPIGRAPHIC LETTER REVERSED PLATIN EPIGRAPHIC LETTER I" +
	"NVERTED MLATIN EPIGRAPHIC LETTER I LONGALATIN EPIGRAPHIC LETTER ARCHAIC " +
	"MSYLOTI NAGRI LETTER ASYLOTI NAGRI LETTER ISYLOTI NAGRI SIGN DVISVARASYL" +
	"OTI NAGRI LETTER USYLOTI NAGRI LETTER ESYLOTI NAGRI LETTER OSYLOTI NAGRI" +
	" SIGN HASANTASYLOTI NAGRI LETTER KOSYLOTI NAGRI LETTER KHOSYLOTI NAGRI L" +
	"ETTER GOSYLOTI NAGRI LETTER GHOSYLOTI NAGRI SIGN ANUSVARASYLOTI NAGRI LE" +
	"TTER COSYLOTI NAGRI LETTER CHOSYLOTI NAGRI LETTER JOSYLOTI NAGRI LETTER " +
	"JHOSYLOTI NAGRI LETTER TTOSYLOTI NAGRI LETTER TTHOSYLOTI NAGRI LETTER DD" +
	"OSYLOTI NAGRI LETTER DDHOSYLOTI NAGRI LETTER TOSYLOTI NAGRI LETTER THOSY" +
	"LOTI NAGRI LETTER DOSYLOTI NAGRI LETTER DHOSYLOTI NAGRI LETTER NOSYLOTI " +
	"NAGRI LETTER POSYLOTI NAGRI LETTER PHOSYLOTI NAGRI LETTER BOSYLOTI NAGRI" +
	" LETTER BHOSYLOTI NAGRI LETTER MOSYLOTI NAGRI LETTER ROSYLOTI NAGRI LETT" +
	"ER LOSYLOTI NAGRI LETTER RROSYLOTI NAGRI LETTER SOSYLOTI NAGRI LETTER HO" +
	"SYLOTI NAGRI VOWEL SIGN ASYLOTI NAGRI VOWEL SIGN ISYLOTI NAGRI VOWEL SIG" +
	"N USYLOTI NAGRI VOWEL SIGN ESYLOTI NAGRI VOWEL SIGN OOSYLOTI NAGRI POETR" +
	"Y MARK-1SYLOTI NAGRI POETRY MARK-2SYLOTI NAGRI POETRY MARK-3SYLOTI NAGRI" +
	" POETRY MARK-4NORTH INDIC FRACTION ONE QUARTERNORTH INDIC FRACTION ONE H" +
	"ALFNORTH INDIC FRACTION THREE QUARTERSNORTH INDIC FRACTION ONE SIXTEENTH" +
	"NORTH INDIC FRACTION ONE EIGHTHNORTH INDIC FRACTION THREE SIXTEENTHSNORT" +
	"H INDIC QUARTER MARKNORTH INDIC PLACEHOLDER MARKNORTH INDIC RUPEE MARKNO" +
	"RTH INDIC QUANTITY MARKPHAGS-PA LETTER KAPHAGS-PA LETTER KHAPHAGS-PA LET" +
	"TER GAPHAGS-PA LETTER NGAPHAGS-PA LETTER CAPHAGS-PA LETTER CHAPHAGS-PA L" +
	"ETTER JAPHAGS-PA LETTER NYAPHAGS-PA LETTER TAPHAGS-PA LETTER THAPHAGS-PA" +
	" LETTER DAPHAGS-PA LETTER NAPHAGS-PA LETTER PAPHAGS-PA LETTER PHAPHAGS-P" +
	"A LETTER BAPHAGS-PA LETTER MAPHAGS-PA LETTER TSAPHAGS-PA LETTER TSHAPHAG" +
	"S-PA LETTER DZAPHAGS-PA LETTER WAPHAGS-PA LETTER ZHAPHAGS-PA LETTER ZAPH" +
	"AGS-PA LETTER SMALL APHAGS-PA LETTER YAPHAGS-PA LETTER RAPHAGS-PA LETTER" +
	" LAPHAGS-PA LETTER SHAPHAGS-PA LETTER SAPHAGS-PA LETTER HAPHAGS-PA LETTE" +
	"R APHAGS-PA LETTER IPHAGS-PA LETTER UPHAGS-PA LETTER EPHAGS-PA LETTER OP" +
	"HAGS-PA LETTER QAPHAGS-PA LETTER XAPHAGS-PA LETTER FAPHAGS-PA LETTER GGA" +
	"PHAGS-PA LETTER EEPHAGS-PA SUBJOINED LETTER WAPHAGS-PA SUBJOINED LETTER " +
	"YAPHAGS-PA LETTER TTAPHAGS-PA LETTER TTHAPHAGS-PA LETTER DDAPHAGS-PA LET" +
	"TER NNAPHAGS-PA LETTER ALTERNATE YAPHAGS-PA LETTER VOICELESS SHAPHAGS-PA" +
	" LETTER VOICED HAPHAGS-PA LETTER ASPIRATED FAPHAGS-PA SUBJOINED LETTER R" +
	"APHAGS-PA SUPERFIXED LETTER RAPHAGS-PA LETTER CANDRABINDUPHAGS-PA SINGLE" +
	" HEAD MARKPHAGS-PA DOUBLE HEAD MARKPHAGS-PA MARK SHADPHAGS-PA MARK DOUBL" +
	"E SHADSAURASHTRA SIGN ANUSVARASAURASHTRA SIGN VISARGASAURASHTRA LETTER A" +
	"SAURASHTRA LETTER AASAURASHTRA LETTER ISAURASHTRA LETTER IISAURASHTRA LE" +
	"TTER USAURASHTRA LETTER UUSAURASHTRA LETTER VOCALIC RSAURASHTRA LETTER V" +
	"OCALIC RRSAURASHTRA LETTER VOCALIC LSAURASHTRA LETTER VOCALIC LLSAURASHT" +
	"RA LETTER ESAURASHTRA LETTER EESAURASHTRA LETTER AISAURASHTRA LETTER OSA" +
	"URASHTRA LETTER OOSAURASHTRA LETTER AUSAURASHTRA LETTER KASAURASHTRA LET" +
	"TER KHASAURASHTRA LETTER GASAURASHTRA LETTER GHASAURASHTRA LETTER NGASAU" +
	"RASHTRA LETTER CASAURASHTRA LETTER CHASAURASHTRA LETTER JASAURASHTRA LET" +
	"TER JHASAURASHTRA LETTER NYASAURASHTRA LETTER TTASAURASHTRA LETTER TTHAS" +
	"AURASHTRA LETTER DDASAURASHTRA LETTER DDHASAURASHTRA LETTER NNASAURASHTR" +
	"A LETTER TASAURASHTRA LETTER THASAURASHTRA LETTER DASAURASHTRA LETTER DH" +
	"ASAURASHTRA LETTER NASAURASHTRA LETTER PASAURASHTRA LETTER PHASAURASHTRA" +
	" LETTER BASAURASHTRA LETTER BHASAURASHTRA LETTER MASAURASHTRA LETTER YAS" +
	"AURASHTRA LETTER RASAURASHTRA LETTER LASAURASHTRA LETTER VASAURASHTRA LE" +
	"TTER SHASAURASHTRA LETTER SSASAURASHTRA LETTER SASAURASHTRA LETTER HASAU" +
	"RASHTRA LETTER LLASAURASHTRA CONSONANT SIGN HAARUSAURASHTRA VOWEL SIGN A") + ("" +
	"ASAURASHTRA VOWEL SIGN ISAURASHTRA VOWEL SIGN IISAURASHTRA VOWEL SIGN US" +
	"AURASHTRA VOWEL SIGN UUSAURASHTRA VOWEL SIGN VOCALIC RSAURASHTRA VOWEL S" +
	"IGN VOCALIC RRSAURASHTRA VOWEL SIGN VOCALIC LSAURASHTRA VOWEL SIGN VOCAL" +
	"IC LLSAURASHTRA VOWEL SIGN ESAURASHTRA VOWEL SIGN EESAURASHTRA VOWEL SIG" +
	"N AISAURASHTRA VOWEL SIGN OSAURASHTRA VOWEL SIGN OOSAURASHTRA VOWEL SIGN" +
	" AUSAURASHTRA SIGN VIRAMASAURASHTRA SIGN CANDRABINDUSAURASHTRA DANDASAUR" +
	"ASHTRA DOUBLE DANDASAURASHTRA DIGIT ZEROSAURASHTRA DIGIT ONESAURASHTRA D" +
	"IGIT TWOSAURASHTRA DIGIT THREESAURASHTRA DIGIT FOURSAURASHTRA DIGIT FIVE" +
	"SAURASHTRA DIGIT SIXSAURASHTRA DIGIT SEVENSAURASHTRA DIGIT EIGHTSAURASHT" +
	"RA DIGIT NINECOMBINING DEVANAGARI DIGIT ZEROCOMBINING DEVANAGARI DIGIT O" +
	"NECOMBINING DEVANAGARI DIGIT TWOCOMBINING DEVANAGARI DIGIT THREECOMBININ" +
	"G DEVANAGARI DIGIT FOURCOMBINING DEVANAGARI DIGIT FIVECOMBINING DEVANAGA" +
	"RI DIGIT SIXCOMBINING DEVANAGARI DIGIT SEVENCOMBINING DEVANAGARI DIGIT E" +
	"IGHTCOMBINING DEVANAGARI DIGIT NINECOMBINING DEVANAGARI LETTER ACOMBININ" +
	"G DEVANAGARI LETTER UCOMBINING DEVANAGARI LETTER KACOMBINING DEVANAGARI " +
	"LETTER NACOMBINING DEVANAGARI LETTER PACOMBINING DEVANAGARI LETTER RACOM" +
	"BINING DEVANAGARI LETTER VICOMBINING DEVANAGARI SIGN AVAGRAHADEVANAGARI " +
	"SIGN SPACING CANDRABINDUDEVANAGARI SIGN CANDRABINDU VIRAMADEVANAGARI SIG" +
	"N DOUBLE CANDRABINDU VIRAMADEVANAGARI SIGN CANDRABINDU TWODEVANAGARI SIG" +
	"N CANDRABINDU THREEDEVANAGARI SIGN CANDRABINDU AVAGRAHADEVANAGARI SIGN P" +
	"USHPIKADEVANAGARI GAP FILLERDEVANAGARI CARETDEVANAGARI HEADSTROKEDEVANAG" +
	"ARI SIGN SIDDHAMDEVANAGARI JAIN OMKAYAH LI DIGIT ZEROKAYAH LI DIGIT ONEK" +
	"AYAH LI DIGIT TWOKAYAH LI DIGIT THREEKAYAH LI DIGIT FOURKAYAH LI DIGIT F" +
	"IVEKAYAH LI DIGIT SIXKAYAH LI DIGIT SEVENKAYAH LI DIGIT EIGHTKAYAH LI DI" +
	"GIT NINEKAYAH LI LETTER KAKAYAH LI LETTER KHAKAYAH LI LETTER GAKAYAH LI " +
	"LETTER NGAKAYAH LI LETTER SAKAYAH LI LETTER SHAKAYAH LI LETTER ZAKAYAH L" +
	"I LETTER NYAKAYAH LI LETTER TAKAYAH LI LETTER HTAKAYAH LI LETTER NAKAYAH" +
	" LI LETTER PAKAYAH LI LETTER PHAKAYAH LI LETTER MAKAYAH LI LETTER DAKAYA" +
	"H LI LETTER BAKAYAH LI LETTER RAKAYAH LI LETTER YAKAYAH LI LETTER LAKAYA" +
	"H LI LETTER WAKAYAH LI LETTER THAKAYAH LI LETTER HAKAYAH LI LETTER VAKAY" +
	"AH LI LETTER CAKAYAH LI LETTER AKAYAH LI LETTER OEKAYAH LI LETTER IKAYAH" +
	" LI LETTER OOKAYAH LI VOWEL UEKAYAH LI VOWEL EKAYAH LI VOWEL UKAYAH LI V" +
	"OWEL EEKAYAH LI VOWEL OKAYAH LI TONE PLOPHUKAYAH LI TONE CALYAKAYAH LI T" +
	"ONE CALYA PLOPHUKAYAH LI SIGN CWIKAYAH LI SIGN SHYAREJANG LETTER KAREJAN" +
	"G LETTER GAREJANG LETTER NGAREJANG LETTER TAREJANG LETTER DAREJANG LETTE" +
	"R NAREJANG LETTER PAREJANG LETTER BAREJANG LETTER MAREJANG LETTER CAREJA" +
	"NG LETTER JAREJANG LETTER NYAREJANG LETTER SAREJANG LETTER RAREJANG LETT" +
	"ER LAREJANG LETTER YAREJANG LETTER WAREJANG LETTER HAREJANG LETTER MBARE" +
	"JANG LETTER NGGAREJANG LETTER NDAREJANG LETTER NYJAREJANG LETTER AREJANG" +
	" VOWEL SIGN IREJANG VOWEL SIGN UREJANG VOWEL SIGN EREJANG VOWEL SIGN AIR" +
	"EJANG VOWEL SIGN OREJANG VOWEL SIGN AUREJANG VOWEL SIGN EUREJANG VOWEL S" +
	"IGN EAREJANG CONSONANT SIGN NGREJANG CONSONANT SIGN NREJANG CONSONANT SI" +
	"GN RREJANG CONSONANT SIGN HREJANG VIRAMAREJANG SECTION MARKHANGUL CHOSEO" +
	"NG TIKEUT-MIEUMHANGUL CHOSEONG TIKEUT-PIEUPHANGUL CHOSEONG TIKEUT-SIOSHA" +
	"NGUL CHOSEONG TIKEUT-CIEUCHANGUL CHOSEONG RIEUL-KIYEOKHANGUL CHOSEONG RI" +
	"EUL-SSANGKIYEOKHANGUL CHOSEONG RIEUL-TIKEUTHANGUL CHOSEONG RIEUL-SSANGTI" +
	"KEUTHANGUL CHOSEONG RIEUL-MIEUMHANGUL CHOSEONG RIEUL-PIEUPHANGUL CHOSEON" +
	"G RIEUL-SSANGPIEUPHANGUL CHOSEONG RIEUL-KAPYEOUNPIEUPHANGUL CHOSEONG RIE" +
	"UL-SIOSHANGUL CHOSEONG RIEUL-CIEUCHANGUL CHOSEONG RIEUL-KHIEUKHHANGUL CH" +
	"OSEONG MIEUM-KIYEOKHANGUL CHOSEONG MIEUM-TIKEUTHANGUL CHOSEONG MIEUM-SIO" +
	"SHANGUL CHOSEONG PIEUP-SIOS-THIEUTHHANGUL CHOSEONG PIEUP-KHIEUKHHANGUL C" +
	"HOSEONG PIEUP-HIEUHHANGUL CHOSEONG SSANGSIOS-PIEUPHANGUL CHOSEONG IEUNG-" +
	"RIEULHANGUL CHOSEONG IEUNG-HIEUHHANGUL CHOSEONG SSANGCIEUC-HIEUHHANGUL C" +
	"HOSEONG SSANGTHIEUTHHANGUL CHOSEONG PHIEUPH-HIEUHHANGUL CHOSEONG HIEUH-S" +
	"IOSHANGUL CHOSEONG SSANGYEORINHIEUHJAVANESE SIGN PANYANGGAJAVANESE SIGN " +
	"CECAKJAVANESE SIGN LAYARJAVANESE SIGN WIGNYANJAVANESE LETTER AJAVANESE L" +
	"ETTER I KAWIJAVANESE LETTER IJAVANESE LETTER IIJAVANESE LETTER UJAVANESE" +
	" LETTER PA CEREKJAVANESE LETTER NGA LELETJAVANESE LETTER NGA LELET RASWA" +
	"DIJAVANESE LETTER EJAVANESE LETTER AIJAVANESE LETTER OJAVANESE LETTER KA" +
	"JAVANESE LETTER KA SASAKJAVANESE LETTER KA MURDAJAVANESE LETTER GAJAVANE" +
	"SE LETTER GA MURDAJAVANESE LETTER NGAJAVANESE LETTER CAJAVANESE LETTER C" +
	"A MURDAJAVANESE LETTER JAJAVANESE LETTER NYA MURDAJAVANESE LETTER JA MAH" +
	"APRANAJAVANESE LETTER NYAJAVANESE LETTER TTAJAVANESE LETTER TTA MAHAPRAN" +
	"AJAVANESE LETTER DDAJAVANESE LETTER DDA MAHAPRANAJAVANESE LETTER NA MURD") + ("" +
	"AJAVANESE LETTER TAJAVANESE LETTER TA MURDAJAVANESE LETTER DAJAVANESE LE" +
	"TTER DA MAHAPRANAJAVANESE LETTER NAJAVANESE LETTER PAJAVANESE LETTER PA " +
	"MURDAJAVANESE LETTER BAJAVANESE LETTER BA MURDAJAVANESE LETTER MAJAVANES" +
	"E LETTER YAJAVANESE LETTER RAJAVANESE LETTER RA AGUNGJAVANESE LETTER LAJ" +
	"AVANESE LETTER WAJAVANESE LETTER SA MURDAJAVANESE LETTER SA MAHAPRANAJAV" +
	"ANESE LETTER SAJAVANESE LETTER HAJAVANESE SIGN CECAK TELUJAVANESE VOWEL " +
	"SIGN TARUNGJAVANESE VOWEL SIGN TOLONGJAVANESE VOWEL SIGN WULUJAVANESE VO" +
	"WEL SIGN WULU MELIKJAVANESE VOWEL SIGN SUKUJAVANESE VOWEL SIGN SUKU MEND" +
	"UTJAVANESE VOWEL SIGN TALINGJAVANESE VOWEL SIGN DIRGA MUREJAVANESE VOWEL" +
	" SIGN PEPETJAVANESE CONSONANT SIGN KERETJAVANESE CONSONANT SIGN PENGKALJ" +
	"AVANESE CONSONANT SIGN CAKRAJAVANESE PANGKONJAVANESE LEFT RERENGGANJAVAN" +
	"ESE RIGHT RERENGGANJAVANESE PADA ANDAPJAVANESE PADA MADYAJAVANESE PADA L" +
	"UHURJAVANESE PADA WINDUJAVANESE PADA PANGKATJAVANESE PADA LINGSAJAVANESE" +
	" PADA LUNGSIJAVANESE PADA ADEGJAVANESE PADA ADEG ADEGJAVANESE PADA PISEL" +
	"EHJAVANESE TURNED PADA PISELEHJAVANESE PANGRANGKEPJAVANESE DIGIT ZEROJAV" +
	"ANESE DIGIT ONEJAVANESE DIGIT TWOJAVANESE DIGIT THREEJAVANESE DIGIT FOUR" +
	"JAVANESE DIGIT FIVEJAVANESE DIGIT SIXJAVANESE DIGIT SEVENJAVANESE DIGIT " +
	"EIGHTJAVANESE DIGIT NINEJAVANESE PADA TIRTA TUMETESJAVANESE PADA ISEN-IS" +
	"ENMYANMAR LETTER SHAN GHAMYANMAR LETTER SHAN CHAMYANMAR LETTER SHAN JHAM" +
	"YANMAR LETTER SHAN NNAMYANMAR LETTER SHAN BHAMYANMAR SIGN SHAN SAWMYANMA" +
	"R MODIFIER LETTER SHAN REDUPLICATIONMYANMAR LETTER TAI LAING NYAMYANMAR " +
	"LETTER TAI LAING FAMYANMAR LETTER TAI LAING GAMYANMAR LETTER TAI LAING G" +
	"HAMYANMAR LETTER TAI LAING JAMYANMAR LETTER TAI LAING JHAMYANMAR LETTER " +
	"TAI LAING DDAMYANMAR LETTER TAI LAING DDHAMYANMAR LETTER TAI LAING NNAMY" +
	"ANMAR TAI LAING DIGIT ZEROMYANMAR TAI LAING DIGIT ONEMYANMAR TAI LAING D" +
	"IGIT TWOMYANMAR TAI LAING DIGIT THREEMYANMAR TAI LAING DIGIT FOURMYANMAR" +
	" TAI LAING DIGIT FIVEMYANMAR TAI LAING DIGIT SIXMYANMAR TAI LAING DIGIT " +
	"SEVENMYANMAR TAI LAING DIGIT EIGHTMYANMAR TAI LAING DIGIT NINEMYANMAR LE" +
	"TTER TAI LAING LLAMYANMAR LETTER TAI LAING DAMYANMAR LETTER TAI LAING DH" +
	"AMYANMAR LETTER TAI LAING BAMYANMAR LETTER TAI LAING BHACHAM LETTER ACHA" +
	"M LETTER ICHAM LETTER UCHAM LETTER ECHAM LETTER AICHAM LETTER OCHAM LETT" +
	"ER KACHAM LETTER KHACHAM LETTER GACHAM LETTER GHACHAM LETTER NGUECHAM LE" +
	"TTER NGACHAM LETTER CHACHAM LETTER CHHACHAM LETTER JACHAM LETTER JHACHAM" +
	" LETTER NHUECHAM LETTER NHACHAM LETTER NHJACHAM LETTER TACHAM LETTER THA" +
	"CHAM LETTER DACHAM LETTER DHACHAM LETTER NUECHAM LETTER NACHAM LETTER DD" +
	"ACHAM LETTER PACHAM LETTER PPACHAM LETTER PHACHAM LETTER BACHAM LETTER B" +
	"HACHAM LETTER MUECHAM LETTER MACHAM LETTER BBACHAM LETTER YACHAM LETTER " +
	"RACHAM LETTER LACHAM LETTER VACHAM LETTER SSACHAM LETTER SACHAM LETTER H" +
	"ACHAM VOWEL SIGN AACHAM VOWEL SIGN ICHAM VOWEL SIGN IICHAM VOWEL SIGN EI" +
	"CHAM VOWEL SIGN UCHAM VOWEL SIGN OECHAM VOWEL SIGN OCHAM VOWEL SIGN AICH" +
	"AM VOWEL SIGN AUCHAM VOWEL SIGN UECHAM CONSONANT SIGN YACHAM CONSONANT S" +
	"IGN RACHAM CONSONANT SIGN LACHAM CONSONANT SIGN WACHAM LETTER FINAL KCHA" +
	"M LETTER FINAL GCHAM LETTER FINAL NGCHAM CONSONANT SIGN FINAL NGCHAM LET" +
	"TER FINAL CHCHAM LETTER FINAL TCHAM LETTER FINAL NCHAM LETTER FINAL PCHA" +
	"M LETTER FINAL YCHAM LETTER FINAL RCHAM LETTER FINAL LCHAM LETTER FINAL " +
	"SSCHAM CONSONANT SIGN FINAL MCHAM CONSONANT SIGN FINAL HCHAM DIGIT ZEROC" +
	"HAM DIGIT ONECHAM DIGIT TWOCHAM DIGIT THREECHAM DIGIT FOURCHAM DIGIT FIV" +
	"ECHAM DIGIT SIXCHAM DIGIT SEVENCHAM DIGIT EIGHTCHAM DIGIT NINECHAM PUNCT" +
	"UATION SPIRALCHAM PUNCTUATION DANDACHAM PUNCTUATION DOUBLE DANDACHAM PUN" +
	"CTUATION TRIPLE DANDAMYANMAR LETTER KHAMTI GAMYANMAR LETTER KHAMTI CAMYA" +
	"NMAR LETTER KHAMTI CHAMYANMAR LETTER KHAMTI JAMYANMAR LETTER KHAMTI JHAM" +
	"YANMAR LETTER KHAMTI NYAMYANMAR LETTER KHAMTI TTAMYANMAR LETTER KHAMTI T" +
	"THAMYANMAR LETTER KHAMTI DDAMYANMAR LETTER KHAMTI DDHAMYANMAR LETTER KHA" +
	"MTI DHAMYANMAR LETTER KHAMTI NAMYANMAR LETTER KHAMTI SAMYANMAR LETTER KH" +
	"AMTI HAMYANMAR LETTER KHAMTI HHAMYANMAR LETTER KHAMTI FAMYANMAR MODIFIER" +
	" LETTER KHAMTI REDUPLICATIONMYANMAR LETTER KHAMTI XAMYANMAR LETTER KHAMT" +
	"I ZAMYANMAR LETTER KHAMTI RAMYANMAR LOGOGRAM KHAMTI OAYMYANMAR LOGOGRAM " +
	"KHAMTI QNMYANMAR LOGOGRAM KHAMTI HMMYANMAR SYMBOL AITON EXCLAMATIONMYANM" +
	"AR SYMBOL AITON ONEMYANMAR SYMBOL AITON TWOMYANMAR LETTER AITON RAMYANMA" +
	"R SIGN PAO KAREN TONEMYANMAR SIGN TAI LAING TONE-2MYANMAR SIGN TAI LAING" +
	" TONE-5MYANMAR LETTER SHWE PALAUNG CHAMYANMAR LETTER SHWE PALAUNG SHATAI" +
	" VIET LETTER LOW KOTAI VIET LETTER HIGH KOTAI VIET LETTER LOW KHOTAI VIE" +
	"T LETTER HIGH KHOTAI VIET LETTER LOW KHHOTAI VIET LETTER HIGH KHHOTAI VI" +
	"ET LETTER LOW GOTAI VIET LETTER HIGH GOTAI VIET LETTER LOW NGOTAI VIET L") + ("" +
	"ETTER HIGH NGOTAI VIET LETTER LOW COTAI VIET LETTER HIGH COTAI VIET LETT" +
	"ER LOW CHOTAI VIET LETTER HIGH CHOTAI VIET LETTER LOW SOTAI VIET LETTER " +
	"HIGH SOTAI VIET LETTER LOW NYOTAI VIET LETTER HIGH NYOTAI VIET LETTER LO" +
	"W DOTAI VIET LETTER HIGH DOTAI VIET LETTER LOW TOTAI VIET LETTER HIGH TO" +
	"TAI VIET LETTER LOW THOTAI VIET LETTER HIGH THOTAI VIET LETTER LOW NOTAI" +
	" VIET LETTER HIGH NOTAI VIET LETTER LOW BOTAI VIET LETTER HIGH BOTAI VIE" +
	"T LETTER LOW POTAI VIET LETTER HIGH POTAI VIET LETTER LOW PHOTAI VIET LE" +
	"TTER HIGH PHOTAI VIET LETTER LOW FOTAI VIET LETTER HIGH FOTAI VIET LETTE" +
	"R LOW MOTAI VIET LETTER HIGH MOTAI VIET LETTER LOW YOTAI VIET LETTER HIG" +
	"H YOTAI VIET LETTER LOW ROTAI VIET LETTER HIGH ROTAI VIET LETTER LOW LOT" +
	"AI VIET LETTER HIGH LOTAI VIET LETTER LOW VOTAI VIET LETTER HIGH VOTAI V" +
	"IET LETTER LOW HOTAI VIET LETTER HIGH HOTAI VIET LETTER LOW OTAI VIET LE" +
	"TTER HIGH OTAI VIET MAI KANGTAI VIET VOWEL AATAI VIET VOWEL ITAI VIET VO" +
	"WEL UETAI VIET VOWEL UTAI VIET VOWEL ETAI VIET VOWEL OTAI VIET MAI KHITT" +
	"AI VIET VOWEL IATAI VIET VOWEL UEATAI VIET VOWEL UATAI VIET VOWEL AUETAI" +
	" VIET VOWEL AYTAI VIET VOWEL ANTAI VIET VOWEL AMTAI VIET TONE MAI EKTAI " +
	"VIET TONE MAI NUENGTAI VIET TONE MAI THOTAI VIET TONE MAI SONGTAI VIET S" +
	"YMBOL KONTAI VIET SYMBOL NUENGTAI VIET SYMBOL SAMTAI VIET SYMBOL HO HOIT" +
	"AI VIET SYMBOL KOI KOIMEETEI MAYEK LETTER EMEETEI MAYEK LETTER OMEETEI M" +
	"AYEK LETTER CHAMEETEI MAYEK LETTER NYAMEETEI MAYEK LETTER TTAMEETEI MAYE" +
	"K LETTER TTHAMEETEI MAYEK LETTER DDAMEETEI MAYEK LETTER DDHAMEETEI MAYEK" +
	" LETTER NNAMEETEI MAYEK LETTER SHAMEETEI MAYEK LETTER SSAMEETEI MAYEK VO" +
	"WEL SIGN IIMEETEI MAYEK VOWEL SIGN UUMEETEI MAYEK VOWEL SIGN AAIMEETEI M" +
	"AYEK VOWEL SIGN AUMEETEI MAYEK VOWEL SIGN AAUMEETEI MAYEK CHEIKHANMEETEI" +
	" MAYEK AHANG KHUDAMMEETEI MAYEK ANJIMEETEI MAYEK SYLLABLE REPETITION MAR" +
	"KMEETEI MAYEK WORD REPETITION MARKMEETEI MAYEK VOWEL SIGN VISARGAMEETEI " +
	"MAYEK VIRAMAETHIOPIC SYLLABLE TTHUETHIOPIC SYLLABLE TTHIETHIOPIC SYLLABL" +
	"E TTHAAETHIOPIC SYLLABLE TTHEEETHIOPIC SYLLABLE TTHEETHIOPIC SYLLABLE TT" +
	"HOETHIOPIC SYLLABLE DDHUETHIOPIC SYLLABLE DDHIETHIOPIC SYLLABLE DDHAAETH" +
	"IOPIC SYLLABLE DDHEEETHIOPIC SYLLABLE DDHEETHIOPIC SYLLABLE DDHOETHIOPIC" +
	" SYLLABLE DZUETHIOPIC SYLLABLE DZIETHIOPIC SYLLABLE DZAAETHIOPIC SYLLABL" +
	"E DZEEETHIOPIC SYLLABLE DZEETHIOPIC SYLLABLE DZOETHIOPIC SYLLABLE CCHHAE" +
	"THIOPIC SYLLABLE CCHHUETHIOPIC SYLLABLE CCHHIETHIOPIC SYLLABLE CCHHAAETH" +
	"IOPIC SYLLABLE CCHHEEETHIOPIC SYLLABLE CCHHEETHIOPIC SYLLABLE CCHHOETHIO" +
	"PIC SYLLABLE BBAETHIOPIC SYLLABLE BBUETHIOPIC SYLLABLE BBIETHIOPIC SYLLA" +
	"BLE BBAAETHIOPIC SYLLABLE BBEEETHIOPIC SYLLABLE BBEETHIOPIC SYLLABLE BBO" +
	"LATIN SMALL LETTER BARRED ALPHALATIN SMALL LETTER A REVERSED-SCHWALATIN " +
	"SMALL LETTER BLACKLETTER ELATIN SMALL LETTER BARRED ELATIN SMALL LETTER " +
	"E WITH FLOURISHLATIN SMALL LETTER LENIS FLATIN SMALL LETTER SCRIPT G WIT" +
	"H CROSSED-TAILLATIN SMALL LETTER L WITH INVERTED LAZY SLATIN SMALL LETTE" +
	"R L WITH DOUBLE MIDDLE TILDELATIN SMALL LETTER L WITH MIDDLE RINGLATIN S" +
	"MALL LETTER M WITH CROSSED-TAILLATIN SMALL LETTER N WITH CROSSED-TAILLAT" +
	"IN SMALL LETTER ENG WITH CROSSED-TAILLATIN SMALL LETTER BLACKLETTER OLAT" +
	"IN SMALL LETTER BLACKLETTER O WITH STROKELATIN SMALL LETTER OPEN O WITH " +
	"STROKELATIN SMALL LETTER INVERTED OELATIN SMALL LETTER TURNED OE WITH ST" +
	"ROKELATIN SMALL LETTER TURNED OE WITH HORIZONTAL STROKELATIN SMALL LETTE" +
	"R TURNED O OPEN-OLATIN SMALL LETTER TURNED O OPEN-O WITH STROKELATIN SMA" +
	"LL LETTER STIRRUP RLATIN LETTER SMALL CAPITAL R WITH RIGHT LEGLATIN SMAL" +
	"L LETTER R WITHOUT HANDLELATIN SMALL LETTER DOUBLE RLATIN SMALL LETTER R" +
	" WITH CROSSED-TAILLATIN SMALL LETTER DOUBLE R WITH CROSSED-TAILLATIN SMA" +
	"LL LETTER SCRIPT RLATIN SMALL LETTER SCRIPT R WITH RINGLATIN SMALL LETTE" +
	"R BASELINE ESHLATIN SMALL LETTER U WITH SHORT RIGHT LEGLATIN SMALL LETTE" +
	"R U BAR WITH SHORT RIGHT LEGLATIN SMALL LETTER UILATIN SMALL LETTER TURN" +
	"ED UILATIN SMALL LETTER U WITH LEFT HOOKLATIN SMALL LETTER CHILATIN SMAL" +
	"L LETTER CHI WITH LOW RIGHT RINGLATIN SMALL LETTER CHI WITH LOW LEFT SER" +
	"IFLATIN SMALL LETTER X WITH LOW RIGHT RINGLATIN SMALL LETTER X WITH LONG" +
	" LEFT LEGLATIN SMALL LETTER X WITH LONG LEFT LEG AND LOW RIGHT RINGLATIN" +
	" SMALL LETTER X WITH LONG LEFT LEG WITH SERIFLATIN SMALL LETTER Y WITH S" +
	"HORT RIGHT LEGMODIFIER BREVE WITH INVERTED BREVEMODIFIER LETTER SMALL HE" +
	"NGMODIFIER LETTER SMALL L WITH INVERTED LAZY SMODIFIER LETTER SMALL L WI" +
	"TH MIDDLE TILDEMODIFIER LETTER SMALL U WITH LEFT HOOKLATIN SMALL LETTER " +
	"SAKHA YATLATIN SMALL LETTER IOTIFIED ELATIN SMALL LETTER OPEN OELATIN SM" +
	"ALL LETTER UOLATIN SMALL LETTER INVERTED ALPHAGREEK LETTER SMALL CAPITAL" +
	" OMEGACHEROKEE SMALL LETTER ACHEROKEE SMALL LETTER ECHEROKEE SMALL LETTE") + ("" +
	"R ICHEROKEE SMALL LETTER OCHEROKEE SMALL LETTER UCHEROKEE SMALL LETTER V" +
	"CHEROKEE SMALL LETTER GACHEROKEE SMALL LETTER KACHEROKEE SMALL LETTER GE" +
	"CHEROKEE SMALL LETTER GICHEROKEE SMALL LETTER GOCHEROKEE SMALL LETTER GU" +
	"CHEROKEE SMALL LETTER GVCHEROKEE SMALL LETTER HACHEROKEE SMALL LETTER HE" +
	"CHEROKEE SMALL LETTER HICHEROKEE SMALL LETTER HOCHEROKEE SMALL LETTER HU" +
	"CHEROKEE SMALL LETTER HVCHEROKEE SMALL LETTER LACHEROKEE SMALL LETTER LE" +
	"CHEROKEE SMALL LETTER LICHEROKEE SMALL LETTER LOCHEROKEE SMALL LETTER LU" +
	"CHEROKEE SMALL LETTER LVCHEROKEE SMALL LETTER MACHEROKEE SMALL LETTER ME" +
	"CHEROKEE SMALL LETTER MICHEROKEE SMALL LETTER MOCHEROKEE SMALL LETTER MU" +
	"CHEROKEE SMALL LETTER NACHEROKEE SMALL LETTER HNACHEROKEE SMALL LETTER N" +
	"AHCHEROKEE SMALL LETTER NECHEROKEE SMALL LETTER NICHEROKEE SMALL LETTER " +
	"NOCHEROKEE SMALL LETTER NUCHEROKEE SMALL LETTER NVCHEROKEE SMALL LETTER " +
	"QUACHEROKEE SMALL LETTER QUECHEROKEE SMALL LETTER QUICHEROKEE SMALL LETT" +
	"ER QUOCHEROKEE SMALL LETTER QUUCHEROKEE SMALL LETTER QUVCHEROKEE SMALL L" +
	"ETTER SACHEROKEE SMALL LETTER SCHEROKEE SMALL LETTER SECHEROKEE SMALL LE" +
	"TTER SICHEROKEE SMALL LETTER SOCHEROKEE SMALL LETTER SUCHEROKEE SMALL LE" +
	"TTER SVCHEROKEE SMALL LETTER DACHEROKEE SMALL LETTER TACHEROKEE SMALL LE" +
	"TTER DECHEROKEE SMALL LETTER TECHEROKEE SMALL LETTER DICHEROKEE SMALL LE" +
	"TTER TICHEROKEE SMALL LETTER DOCHEROKEE SMALL LETTER DUCHEROKEE SMALL LE" +
	"TTER DVCHEROKEE SMALL LETTER DLACHEROKEE SMALL LETTER TLACHEROKEE SMALL " +
	"LETTER TLECHEROKEE SMALL LETTER TLICHEROKEE SMALL LETTER TLOCHEROKEE SMA" +
	"LL LETTER TLUCHEROKEE SMALL LETTER TLVCHEROKEE SMALL LETTER TSACHEROKEE " +
	"SMALL LETTER TSECHEROKEE SMALL LETTER TSICHEROKEE SMALL LETTER TSOCHEROK" +
	"EE SMALL LETTER TSUCHEROKEE SMALL LETTER TSVCHEROKEE SMALL LETTER WACHER" +
	"OKEE SMALL LETTER WECHEROKEE SMALL LETTER WICHEROKEE SMALL LETTER WOCHER" +
	"OKEE SMALL LETTER WUCHEROKEE SMALL LETTER WVCHEROKEE SMALL LETTER YAMEET" +
	"EI MAYEK LETTER KOKMEETEI MAYEK LETTER SAMMEETEI MAYEK LETTER LAIMEETEI " +
	"MAYEK LETTER MITMEETEI MAYEK LETTER PAMEETEI MAYEK LETTER NAMEETEI MAYEK" +
	" LETTER CHILMEETEI MAYEK LETTER TILMEETEI MAYEK LETTER KHOUMEETEI MAYEK " +
	"LETTER NGOUMEETEI MAYEK LETTER THOUMEETEI MAYEK LETTER WAIMEETEI MAYEK L" +
	"ETTER YANGMEETEI MAYEK LETTER HUKMEETEI MAYEK LETTER UNMEETEI MAYEK LETT" +
	"ER IMEETEI MAYEK LETTER PHAMMEETEI MAYEK LETTER ATIYAMEETEI MAYEK LETTER" +
	" GOKMEETEI MAYEK LETTER JHAMMEETEI MAYEK LETTER RAIMEETEI MAYEK LETTER B" +
	"AMEETEI MAYEK LETTER JILMEETEI MAYEK LETTER DILMEETEI MAYEK LETTER GHOUM" +
	"EETEI MAYEK LETTER DHOUMEETEI MAYEK LETTER BHAMMEETEI MAYEK LETTER KOK L" +
	"ONSUMMEETEI MAYEK LETTER LAI LONSUMMEETEI MAYEK LETTER MIT LONSUMMEETEI " +
	"MAYEK LETTER PA LONSUMMEETEI MAYEK LETTER NA LONSUMMEETEI MAYEK LETTER T" +
	"IL LONSUMMEETEI MAYEK LETTER NGOU LONSUMMEETEI MAYEK LETTER I LONSUMMEET" +
	"EI MAYEK VOWEL SIGN ONAPMEETEI MAYEK VOWEL SIGN INAPMEETEI MAYEK VOWEL S" +
	"IGN ANAPMEETEI MAYEK VOWEL SIGN YENAPMEETEI MAYEK VOWEL SIGN SOUNAPMEETE" +
	"I MAYEK VOWEL SIGN UNAPMEETEI MAYEK VOWEL SIGN CHEINAPMEETEI MAYEK VOWEL" +
	" SIGN NUNGMEETEI MAYEK CHEIKHEIMEETEI MAYEK LUM IYEKMEETEI MAYEK APUN IY" +
	"EKMEETEI MAYEK DIGIT ZEROMEETEI MAYEK DIGIT ONEMEETEI MAYEK DIGIT TWOMEE" +
	"TEI MAYEK DIGIT THREEMEETEI MAYEK DIGIT FOURMEETEI MAYEK DIGIT FIVEMEETE" +
	"I MAYEK DIGIT SIXMEETEI MAYEK DIGIT SEVENMEETEI MAYEK DIGIT EIGHTMEETEI " +
	"MAYEK DIGIT NINEHANGUL JUNGSEONG O-YEOHANGUL JUNGSEONG O-O-IHANGUL JUNGS" +
	"EONG YO-AHANGUL JUNGSEONG YO-AEHANGUL JUNGSEONG YO-EOHANGUL JUNGSEONG U-" +
	"YEOHANGUL JUNGSEONG U-I-IHANGUL JUNGSEONG YU-AEHANGUL JUNGSEONG YU-OHANG" +
	"UL JUNGSEONG EU-AHANGUL JUNGSEONG EU-EOHANGUL JUNGSEONG EU-EHANGUL JUNGS" +
	"EONG EU-OHANGUL JUNGSEONG I-YA-OHANGUL JUNGSEONG I-YAEHANGUL JUNGSEONG I" +
	"-YEOHANGUL JUNGSEONG I-YEHANGUL JUNGSEONG I-O-IHANGUL JUNGSEONG I-YOHANG" +
	"UL JUNGSEONG I-YUHANGUL JUNGSEONG I-IHANGUL JUNGSEONG ARAEA-AHANGUL JUNG" +
	"SEONG ARAEA-EHANGUL JONGSEONG NIEUN-RIEULHANGUL JONGSEONG NIEUN-CHIEUCHH" +
	"ANGUL JONGSEONG SSANGTIKEUTHANGUL JONGSEONG SSANGTIKEUT-PIEUPHANGUL JONG" +
	"SEONG TIKEUT-PIEUPHANGUL JONGSEONG TIKEUT-SIOSHANGUL JONGSEONG TIKEUT-SI" +
	"OS-KIYEOKHANGUL JONGSEONG TIKEUT-CIEUCHANGUL JONGSEONG TIKEUT-CHIEUCHHAN" +
	"GUL JONGSEONG TIKEUT-THIEUTHHANGUL JONGSEONG RIEUL-SSANGKIYEOKHANGUL JON" +
	"GSEONG RIEUL-KIYEOK-HIEUHHANGUL JONGSEONG SSANGRIEUL-KHIEUKHHANGUL JONGS" +
	"EONG RIEUL-MIEUM-HIEUHHANGUL JONGSEONG RIEUL-PIEUP-TIKEUTHANGUL JONGSEON" +
	"G RIEUL-PIEUP-PHIEUPHHANGUL JONGSEONG RIEUL-YESIEUNGHANGUL JONGSEONG RIE" +
	"UL-YEORINHIEUH-HIEUHHANGUL JONGSEONG KAPYEOUNRIEULHANGUL JONGSEONG MIEUM" +
	"-NIEUNHANGUL JONGSEONG MIEUM-SSANGNIEUNHANGUL JONGSEONG SSANGMIEUMHANGUL" +
	" JONGSEONG MIEUM-PIEUP-SIOSHANGUL JONGSEONG MIEUM-CIEUCHANGUL JONGSEONG " +
	"PIEUP-TIKEUTHANGUL JONGSEONG PIEUP-RIEUL-PHIEUPHHANGUL JONGSEONG PIEUP-M") + ("" +
	"IEUMHANGUL JONGSEONG SSANGPIEUPHANGUL JONGSEONG PIEUP-SIOS-TIKEUTHANGUL " +
	"JONGSEONG PIEUP-CIEUCHANGUL JONGSEONG PIEUP-CHIEUCHHANGUL JONGSEONG SIOS" +
	"-MIEUMHANGUL JONGSEONG SIOS-KAPYEOUNPIEUPHANGUL JONGSEONG SSANGSIOS-KIYE" +
	"OKHANGUL JONGSEONG SSANGSIOS-TIKEUTHANGUL JONGSEONG SIOS-PANSIOSHANGUL J" +
	"ONGSEONG SIOS-CIEUCHANGUL JONGSEONG SIOS-CHIEUCHHANGUL JONGSEONG SIOS-TH" +
	"IEUTHHANGUL JONGSEONG SIOS-HIEUHHANGUL JONGSEONG PANSIOS-PIEUPHANGUL JON" +
	"GSEONG PANSIOS-KAPYEOUNPIEUPHANGUL JONGSEONG YESIEUNG-MIEUMHANGUL JONGSE" +
	"ONG YESIEUNG-HIEUHHANGUL JONGSEONG CIEUC-PIEUPHANGUL JONGSEONG CIEUC-SSA" +
	"NGPIEUPHANGUL JONGSEONG SSANGCIEUCHANGUL JONGSEONG PHIEUPH-SIOSHANGUL JO" +
	"NGSEONG PHIEUPH-THIEUTHCJK COMPATIBILITY IDEOGRAPH-F900CJK COMPATIBILITY" +
	" IDEOGRAPH-F901CJK COMPATIBILITY IDEOGRAPH-F902CJK COMPATIBILITY IDEOGRA" +
	"PH-F903CJK COMPATIBILITY IDEOGRAPH-F904CJK COMPATIBILITY IDEOGRAPH-F905C" +
	"JK COMPATIBILITY IDEOGRAPH-F906CJK COMPATIBILITY IDEOGRAPH-F907CJK COMPA" +
	"TIBILITY IDEOGRAPH-F908CJK COMPATIBILITY IDEOGRAPH-F909CJK COMPATIBILITY" +
	" IDEOGRAPH-F90ACJK COMPATIBILITY IDEOGRAPH-F90BCJK COMPATIBILITY IDEOGRA" +
	"PH-F90CCJK COMPATIBILITY IDEOGRAPH-F90DCJK COMPATIBILITY IDEOGRAPH-F90EC" +
	"JK COMPATIBILITY IDEOGRAPH-F90FCJK COMPATIBILITY IDEOGRAPH-F910CJK COMPA" +
	"TIBILITY IDEOGRAPH-F911CJK COMPATIBILITY IDEOGRAPH-F912CJK COMPATIBILITY" +
	" IDEOGRAPH-F913CJK COMPATIBILITY IDEOGRAPH-F914CJK COMPATIBILITY IDEOGRA" +
	"PH-F915CJK COMPATIBILITY IDEOGRAPH-F916CJK COMPATIBILITY IDEOGRAPH-F917C" +
	"JK COMPATIBILITY IDEOGRAPH-F918CJK COMPATIBILITY IDEOGRAPH-F919CJK COMPA" +
	"TIBILITY IDEOGRAPH-F91ACJK COMPATIBILITY IDEOGRAPH-F91BCJK COMPATIBILITY" +
	" IDEOGRAPH-F91CCJK COMPATIBILITY IDEOGRAPH-F91DCJK COMPATIBILITY IDEOGRA" +
	"PH-F91ECJK COMPATIBILITY IDEOGRAPH-F91FCJK COMPATIBILITY IDEOGRAPH-F920C" +
	"JK COMPATIBILITY IDEOGRAPH-F921CJK COMPATIBILITY IDEOGRAPH-F922CJK COMPA" +
	"TIBILITY IDEOGRAPH-F923CJK COMPATIBILITY IDEOGRAPH-F924CJK COMPATIBILITY" +
	" IDEOGRAPH-F925CJK COMPATIBILITY IDEOGRAPH-F926CJK COMPATIBILITY IDEOGRA" +
	"PH-F927CJK COMPATIBILITY IDEOGRAPH-F928CJK COMPATIBILITY IDEOGRAPH-F929C" +
	"JK COMPATIBILITY IDEOGRAPH-F92ACJK COMPATIBILITY IDEOGRAPH-F92BCJK COMPA" +
	"TIBILITY IDEOGRAPH-F92CCJK COMPATIBILITY IDEOGRAPH-F92DCJK COMPATIBILITY" +
	" IDEOGRAPH-F92ECJK COMPATIBILITY IDEOGRAPH-F92FCJK COMPATIBILITY IDEOGRA" +
	"PH-F930CJK COMPATIBILITY IDEOGRAPH-F931CJK COMPATIBILITY IDEOGRAPH-F932C" +
	"JK COMPATIBILITY IDEOGRAPH-F933CJK COMPATIBILITY IDEOGRAPH-F934CJK COMPA" +
	"TIBILITY IDEOGRAPH-F935CJK COMPATIBILITY IDEOGRAPH-F936CJK COMPATIBILITY" +
	" IDEOGRAPH-F937CJK COMPATIBILITY IDEOGRAPH-F938CJK COMPATIBILITY IDEOGRA" +
	"PH-F939CJK COMPATIBILITY IDEOGRAPH-F93ACJK COMPATIBILITY IDEOGRAPH-F93BC" +
	"JK COMPATIBILITY IDEOGRAPH-F93CCJK COMPATIBILITY IDEOGRAPH-F93DCJK COMPA" +
	"TIBILITY IDEOGRAPH-F93ECJK COMPATIBILITY IDEOGRAPH-F93FCJK COMPATIBILITY" +
	" IDEOGRAPH-F940CJK COMPATIBILITY IDEOGRAPH-F941CJK COMPATIBILITY IDEOGRA" +
	"PH-F942CJK COMPATIBILITY IDEOGRAPH-F943CJK COMPATIBILITY IDEOGRAPH-F944C" +
	"JK COMPATIBILITY IDEOGRAPH-F945CJK COMPATIBILITY IDEOGRAPH-F946CJK COMPA" +
	"TIBILITY IDEOGRAPH-F947CJK COMPATIBILITY IDEOGRAPH-F948CJK COMPATIBILITY" +
	" IDEOGRAPH-F949CJK COMPATIBILITY IDEOGRAPH-F94ACJK COMPATIBILITY IDEOGRA" +
	"PH-F94BCJK COMPATIBILITY IDEOGRAPH-F94CCJK COMPATIBILITY IDEOGRAPH-F94DC" +
	"JK COMPATIBILITY IDEOGRAPH-F94ECJK COMPATIBILITY IDEOGRAPH-F94FCJK COMPA" +
	"TIBILITY IDEOGRAPH-F950CJK COMPATIBILITY IDEOGRAPH-F951CJK COMPATIBILITY" +
	" IDEOGRAPH-F952CJK COMPATIBILITY IDEOGRAPH-F953CJK COMPATIBILITY IDEOGRA" +
	"PH-F954CJK COMPATIBILITY IDEOGRAPH-F955CJK COMPATIBILITY IDEOGRAPH-F956C" +
	"JK COMPATIBILITY IDEOGRAPH-F957CJK COMPATIBILITY IDEOGRAPH-F958CJK COMPA" +
	"TIBILITY IDEOGRAPH-F959CJK COMPATIBILITY IDEOGRAPH-F95ACJK COMPATIBILITY" +
	" IDEOGRAPH-F95BCJK COMPATIBILITY IDEOGRAPH-F95CCJK COMPATIBILITY IDEOGRA" +
	"PH-F95DCJK COMPATIBILITY IDEOGRAPH-F95ECJK COMPATIBILITY IDEOGRAPH-F95FC" +
	"JK COMPATIBILITY IDEOGRAPH-F960CJK COMPATIBILITY IDEOGRAPH-F961CJK COMPA" +
	"TIBILITY IDEOGRAPH-F962CJK COMPATIBILITY IDEOGRAPH-F963CJK COMPATIBILITY" +
	" IDEOGRAPH-F964CJK COMPATIBILITY IDEOGRAPH-F965CJK COMPATIBILITY IDEOGRA" +
	"PH-F966CJK COMPATIBILITY IDEOGRAPH-F967CJK COMPATIBILITY IDEOGRAPH-F968C" +
	"JK COMPATIBILITY IDEOGRAPH-F969CJK COMPATIBILITY IDEOGRAPH-F96ACJK COMPA" +
	"TIBILITY IDEOGRAPH-F96BCJK COMPATIBILITY IDEOGRAPH-F96CCJK COMPATIBILITY" +
	" IDEOGRAPH-F96DCJK COMPATIBILITY IDEOGRAPH-F96ECJK COMPATIBILITY IDEOGRA" +
	"PH-F96FCJK COMPATIBILITY IDEOGRAPH-F970CJK COMPATIBILITY IDEOGRAPH-F971C" +
	"JK COMPATIBILITY IDEOGRAPH-F972CJK COMPATIBILITY IDEOGRAPH-F973CJK COMPA" +
	"TIBILITY IDEOGRAPH-F974CJK COMPATIBILITY IDEOGRAPH-F975CJK COMPATIBILITY" +
	" IDEOGRAPH-F976CJK COMPATIBILITY IDEOGRAPH-F977CJK COMPATIBILITY IDEOGRA" +
	"PH-F978CJK COMPATIBILITY IDEOGRAPH-F979CJK COMPATIBILITY IDEOGRAPH-F97AC") + ("" +
	"JK COMPATIBILITY IDEOGRAPH-F97BCJK COMPATIBILITY IDEOGRAPH-F97CCJK COMPA" +
	"TIBILITY IDEOGRAPH-F97DCJK COMPATIBILITY IDEOGRAPH-F97ECJK COMPATIBILITY" +
	" IDEOGRAPH-F97FCJK COMPATIBILITY IDEOGRAPH-F980CJK COMPATIBILITY IDEOGRA" +
	"PH-F981CJK COMPATIBILITY IDEOGRAPH-F982CJK COMPATIBILITY IDEOGRAPH-F983C" +
	"JK COMPATIBILITY IDEOGRAPH-F984CJK COMPATIBILITY IDEOGRAPH-F985CJK COMPA" +
	"TIBILITY IDEOGRAPH-F986CJK COMPATIBILITY IDEOGRAPH-F987CJK COMPATIBILITY" +
	" IDEOGRAPH-F988CJK COMPATIBILITY IDEOGRAPH-F989CJK COMPATIBILITY IDEOGRA" +
	"PH-F98ACJK COMPATIBILITY IDEOGRAPH-F98BCJK COMPATIBILITY IDEOGRAPH-F98CC" +
	"JK COMPATIBILITY IDEOGRAPH-F98DCJK COMPATIBILITY IDEOGRAPH-F98ECJK COMPA" +
	"TIBILITY IDEOGRAPH-F98FCJK COMPATIBILITY IDEOGRAPH-F990CJK COMPATIBILITY" +
	" IDEOGRAPH-F991CJK COMPATIBILITY IDEOGRAPH-F992CJK COMPATIBILITY IDEOGRA" +
	"PH-F993CJK COMPATIBILITY IDEOGRAPH-F994CJK COMPATIBILITY IDEOGRAPH-F995C" +
	"JK COMPATIBILITY IDEOGRAPH-F996CJK COMPATIBILITY IDEOGRAPH-F997CJK COMPA" +
	"TIBILITY IDEOGRAPH-F998CJK COMPATIBILITY IDEOGRAPH-F999CJK COMPATIBILITY" +
	" IDEOGRAPH-F99ACJK COMPATIBILITY IDEOGRAPH-F99BCJK COMPATIBILITY IDEOGRA" +
	"PH-F99CCJK COMPATIBILITY IDEOGRAPH-F99DCJK COMPATIBILITY IDEOGRAPH-F99EC" +
	"JK COMPATIBILITY IDEOGRAPH-F99FCJK COMPATIBILITY IDEOGRAPH-F9A0CJK COMPA" +
	"TIBILITY IDEOGRAPH-F9A1CJK COMPATIBILITY IDEOGRAPH-F9A2CJK COMPATIBILITY" +
	" IDEOGRAPH-F9A3CJK COMPATIBILITY IDEOGRAPH-F9A4CJK COMPATIBILITY IDEOGRA" +
	"PH-F9A5CJK COMPATIBILITY IDEOGRAPH-F9A6CJK COMPATIBILITY IDEOGRAPH-F9A7C" +
	"JK COMPATIBILITY IDEOGRAPH-F9A8CJK COMPATIBILITY IDEOGRAPH-F9A9CJK COMPA" +
	"TIBILITY IDEOGRAPH-F9AACJK COMPATIBILITY IDEOGRAPH-F9ABCJK COMPATIBILITY" +
	" IDEOGRAPH-F9ACCJK COMPATIBILITY IDEOGRAPH-F9ADCJK COMPATIBILITY IDEOGRA" +
	"PH-F9AECJK COMPATIBILITY IDEOGRAPH-F9AFCJK COMPATIBILITY IDEOGRAPH-F9B0C" +
	"JK COMPATIBILITY IDEOGRAPH-F9B1CJK COMPATIBILITY IDEOGRAPH-F9B2CJK COMPA" +
	"TIBILITY IDEOGRAPH-F9B3CJK COMPATIBILITY IDEOGRAPH-F9B4CJK COMPATIBILITY" +
	" IDEOGRAPH-F9B5CJK COMPATIBILITY IDEOGRAPH-F9B6CJK COMPATIBILITY IDEOGRA" +
	"PH-F9B7CJK COMPATIBILITY IDEOGRAPH-F9B8CJK COMPATIBILITY IDEOGRAPH-F9B9C" +
	"JK COMPATIBILITY IDEOGRAPH-F9BACJK COMPATIBILITY IDEOGRAPH-F9BBCJK COMPA" +
	"TIBILITY IDEOGRAPH-F9BCCJK COMPATIBILITY IDEOGRAPH-F9BDCJK COMPATIBILITY" +
	" IDEOGRAPH-F9BECJK COMPATIBILITY IDEOGRAPH-F9BFCJK COMPATIBILITY IDEOGRA" +
	"PH-F9C0CJK COMPATIBILITY IDEOGRAPH-F9C1CJK COMPATIBILITY IDEOGRAPH-F9C2C" +
	"JK COMPATIBILITY IDEOGRAPH-F9C3CJK COMPATIBILITY IDEOGRAPH-F9C4CJK COMPA" +
	"TIBILITY IDEOGRAPH-F9C5CJK COMPATIBILITY IDEOGRAPH-F9C6CJK COMPATIBILITY" +
	" IDEOGRAPH-F9C7CJK COMPATIBILITY IDEOGRAPH-F9C8CJK COMPATIBILITY IDEOGRA" +
	"PH-F9C9CJK COMPATIBILITY IDEOGRAPH-F9CACJK COMPATIBILITY IDEOGRAPH-F9CBC" +
	"JK COMPATIBILITY IDEOGRAPH-F9CCCJK COMPATIBILITY IDEOGRAPH-F9CDCJK COMPA" +
	"TIBILITY IDEOGRAPH-F9CECJK COMPATIBILITY IDEOGRAPH-F9CFCJK COMPATIBILITY" +
	" IDEOGRAPH-F9D0CJK COMPATIBILITY IDEOGRAPH-F9D1CJK COMPATIBILITY IDEOGRA" +
	"PH-F9D2CJK COMPATIBILITY IDEOGRAPH-F9D3CJK COMPATIBILITY IDEOGRAPH-F9D4C" +
	"JK COMPATIBILITY IDEOGRAPH-F9D5CJK COMPATIBILITY IDEOGRAPH-F9D6CJK COMPA" +
	"TIBILITY IDEOGRAPH-F9D7CJK COMPATIBILITY IDEOGRAPH-F9D8CJK COMPATIBILITY" +
	" IDEOGRAPH-F9D9CJK COMPATIBILITY IDEOGRAPH-F9DACJK COMPATIBILITY IDEOGRA" +
	"PH-F9DBCJK COMPATIBILITY IDEOGRAPH-F9DCCJK COMPATIBILITY IDEOGRAPH-F9DDC" +
	"JK COMPATIBILITY IDEOGRAPH-F9DECJK COMPATIBILITY IDEOGRAPH-F9DFCJK COMPA" +
	"TIBILITY IDEOGRAPH-F9E0CJK COMPATIBILITY IDEOGRAPH-F9E1CJK COMPATIBILITY" +
	" IDEOGRAPH-F9E2CJK COMPATIBILITY IDEOGRAPH-F9E3CJK COMPATIBILITY IDEOGRA" +
	"PH-F9E4CJK COMPATIBILITY IDEOGRAPH-F9E5CJK COMPATIBILITY IDEOGRAPH-F9E6C" +
	"JK COMPATIBILITY IDEOGRAPH-F9E7CJK COMPATIBILITY IDEOGRAPH-F9E8CJK COMPA" +
	"TIBILITY IDEOGRAPH-F9E9CJK COMPATIBILITY IDEOGRAPH-F9EACJK COMPATIBILITY" +
	" IDEOGRAPH-F9EBCJK COMPATIBILITY IDEOGRAPH-F9ECCJK COMPATIBILITY IDEOGRA" +
	"PH-F9EDCJK COMPATIBILITY IDEOGRAPH-F9EECJK COMPATIBILITY IDEOGRAPH-F9EFC" +
	"JK COMPATIBILITY IDEOGRAPH-F9F0CJK COMPATIBILITY IDEOGRAPH-F9F1CJK COMPA" +
	"TIBILITY IDEOGRAPH-F9F2CJK COMPATIBILITY IDEOGRAPH-F9F3CJK COMPATIBILITY" +
	" IDEOGRAPH-F9F4CJK COMPATIBILITY IDEOGRAPH-F9F5CJK COMPATIBILITY IDEOGRA" +
	"PH-F9F6CJK COMPATIBILITY IDEOGRAPH-F9F7CJK COMPATIBILITY IDEOGRAPH-F9F8C" +
	"JK COMPATIBILITY IDEOGRAPH-F9F9CJK COMPATIBILITY IDEOGRAPH-F9FACJK COMPA" +
	"TIBILITY IDEOGRAPH-F9FBCJK COMPATIBILITY IDEOGRAPH-F9FCCJK COMPATIBILITY" +
	" IDEOGRAPH-F9FDCJK COMPATIBILITY IDEOGRAPH-F9FECJK COMPATIBILITY IDEOGRA" +
	"PH-F9FFCJK COMPATIBILITY IDEOGRAPH-FA00CJK COMPATIBILITY IDEOGRAPH-FA01C" +
	"JK COMPATIBILITY IDEOGRAPH-FA02CJK COMPATIBILITY IDEOGRAPH-FA03CJK COMPA" +
	"TIBILITY IDEOGRAPH-FA04CJK COMPATIBILITY IDEOGRAPH-FA05CJK COMPATIBILITY" +
	" IDEOGRAPH-FA06CJK COMPATIBILITY IDEOGRAPH-FA07CJK COMPATIBILITY IDEOGRA" +
	"PH-FA08CJK COMPATIBILITY IDEOGRAPH-FA09CJK COMPATIBILITY IDEOGRAPH-FA0AC") + ("" +
	"JK COMPATIBILITY IDEOGRAPH-FA0BCJK COMPATIBILITY IDEOGRAPH-FA0CCJK COMPA" +
	"TIBILITY IDEOGRAPH-FA0DCJK COMPATIBILITY IDEOGRAPH-FA0ECJK COMPATIBILITY" +
	" IDEOGRAPH-FA0FCJK COMPATIBILITY IDEOGRAPH-FA10CJK COMPATIBILITY IDEOGRA" +
	"PH-FA11CJK COMPATIBILITY IDEOGRAPH-FA12CJK COMPATIBILITY IDEOGRAPH-FA13C" +
	"JK COMPATIBILITY IDEOGRAPH-FA14CJK COMPATIBILITY IDEOGRAPH-FA15CJK COMPA" +
	"TIBILITY IDEOGRAPH-FA16CJK COMPATIBILITY IDEOGRAPH-FA17CJK COMPATIBILITY" +
	" IDEOGRAPH-FA18CJK COMPATIBILITY IDEOGRAPH-FA19CJK COMPATIBILITY IDEOGRA" +
	"PH-FA1ACJK COMPATIBILITY IDEOGRAPH-FA1BCJK COMPATIBILITY IDEOGRAPH-FA1CC" +
	"JK COMPATIBILITY IDEOGRAPH-FA1DCJK COMPATIBILITY IDEOGRAPH-FA1ECJK COMPA" +
	"TIBILITY IDEOGRAPH-FA1FCJK COMPATIBILITY IDEOGRAPH-FA20CJK COMPATIBILITY" +
	" IDEOGRAPH-FA21CJK COMPATIBILITY IDEOGRAPH-FA22CJK COMPATIBILITY IDEOGRA" +
	"PH-FA23CJK COMPATIBILITY IDEOGRAPH-FA24CJK COMPATIBILITY IDEOGRAPH-FA25C" +
	"JK COMPATIBILITY IDEOGRAPH-FA26CJK COMPATIBILITY IDEOGRAPH-FA27CJK COMPA" +
	"TIBILITY IDEOGRAPH-FA28CJK COMPATIBILITY IDEOGRAPH-FA29CJK COMPATIBILITY" +
	" IDEOGRAPH-FA2ACJK COMPATIBILITY IDEOGRAPH-FA2BCJK COMPATIBILITY IDEOGRA" +
	"PH-FA2CCJK COMPATIBILITY IDEOGRAPH-FA2DCJK COMPATIBILITY IDEOGRAPH-FA2EC" +
	"JK COMPATIBILITY IDEOGRAPH-FA2FCJK COMPATIBILITY IDEOGRAPH-FA30CJK COMPA" +
	"TIBILITY IDEOGRAPH-FA31CJK COMPATIBILITY IDEOGRAPH-FA32CJK COMPATIBILITY" +
	" IDEOGRAPH-FA33CJK COMPATIBILITY IDEOGRAPH-FA34CJK COMPATIBILITY IDEOGRA" +
	"PH-FA35CJK COMPATIBILITY IDEOGRAPH-FA36CJK COMPATIBILITY IDEOGRAPH-FA37C" +
	"JK COMPATIBILITY IDEOGRAPH-FA38CJK COMPATIBILITY IDEOGRAPH-FA39CJK COMPA" +
	"TIBILITY IDEOGRAPH-FA3ACJK COMPATIBILITY IDEOGRAPH-FA3BCJK COMPATIBILITY" +
	" IDEOGRAPH-FA3CCJK COMPATIBILITY IDEOGRAPH-FA3DCJK COMPATIBILITY IDEOGRA" +
	"PH-FA3ECJK COMPATIBILITY IDEOGRAPH-FA3FCJK COMPATIBILITY IDEOGRAPH-FA40C" +
	"JK COMPATIBILITY IDEOGRAPH-FA41CJK COMPATIBILITY IDEOGRAPH-FA42CJK COMPA" +
	"TIBILITY IDEOGRAPH-FA43CJK COMPATIBILITY IDEOGRAPH-FA44CJK COMPATIBILITY" +
	" IDEOGRAPH-FA45CJK COMPATIBILITY IDEOGRAPH-FA46CJK COMPATIBILITY IDEOGRA" +
	"PH-FA47CJK COMPATIBILITY IDEOGRAPH-FA48CJK COMPATIBILITY IDEOGRAPH-FA49C" +
	"JK COMPATIBILITY IDEOGRAPH-FA4ACJK COMPATIBILITY IDEOGRAPH-FA4BCJK COMPA" +
	"TIBILITY IDEOGRAPH-FA4CCJK COMPATIBILITY IDEOGRAPH-FA4DCJK COMPATIBILITY" +
	" IDEOGRAPH-FA4ECJK COMPATIBILITY IDEOGRAPH-FA4FCJK COMPATIBILITY IDEOGRA" +
	"PH-FA50CJK COMPATIBILITY IDEOGRAPH-FA51CJK COMPATIBILITY IDEOGRAPH-FA52C" +
	"JK COMPATIBILITY IDEOGRAPH-FA53CJK COMPATIBILITY IDEOGRAPH-FA54CJK COMPA" +
	"TIBILITY IDEOGRAPH-FA55CJK COMPATIBILITY IDEOGRAPH-FA56CJK COMPATIBILITY" +
	" IDEOGRAPH-FA57CJK COMPATIBILITY IDEOGRAPH-FA58CJK COMPATIBILITY IDEOGRA" +
	"PH-FA59CJK COMPATIBILITY IDEOGRAPH-FA5ACJK COMPATIBILITY IDEOGRAPH-FA5BC" +
	"JK COMPATIBILITY IDEOGRAPH-FA5CCJK COMPATIBILITY IDEOGRAPH-FA5DCJK COMPA" +
	"TIBILITY IDEOGRAPH-FA5ECJK COMPATIBILITY IDEOGRAPH-FA5FCJK COMPATIBILITY" +
	" IDEOGRAPH-FA60CJK COMPATIBILITY IDEOGRAPH-FA61CJK COMPATIBILITY IDEOGRA" +
	"PH-FA62CJK COMPATIBILITY IDEOGRAPH-FA63CJK COMPATIBILITY IDEOGRAPH-FA64C" +
	"JK COMPATIBILITY IDEOGRAPH-FA65CJK COMPATIBILITY IDEOGRAPH-FA66CJK COMPA" +
	"TIBILITY IDEOGRAPH-FA67CJK COMPATIBILITY IDEOGRAPH-FA68CJK COMPATIBILITY" +
	" IDEOGRAPH-FA69CJK COMPATIBILITY IDEOGRAPH-FA6ACJK COMPATIBILITY IDEOGRA" +
	"PH-FA6BCJK COMPATIBILITY IDEOGRAPH-FA6CCJK COMPATIBILITY IDEOGRAPH-FA6DC" +
	"JK COMPATIBILITY IDEOGRAPH-FA70CJK COMPATIBILITY IDEOGRAPH-FA71CJK COMPA" +
	"TIBILITY IDEOGRAPH-FA72CJK COMPATIBILITY IDEOGRAPH-FA73CJK COMPATIBILITY" +
	" IDEOGRAPH-FA74CJK COMPATIBILITY IDEOGRAPH-FA75CJK COMPATIBILITY IDEOGRA" +
	"PH-FA76CJK COMPATIBILITY IDEOGRAPH-FA77CJK COMPATIBILITY IDEOGRAPH-FA78C" +
	"JK COMPATIBILITY IDEOGRAPH-FA79CJK COMPATIBILITY IDEOGRAPH-FA7ACJK COMPA" +
	"TIBILITY IDEOGRAPH-FA7BCJK COMPATIBILITY IDEOGRAPH-FA7CCJK COMPATIBILITY" +
	" IDEOGRAPH-FA7DCJK COMPATIBILITY IDEOGRAPH-FA7ECJK COMPATIBILITY IDEOGRA" +
	"PH-FA7FCJK COMPATIBILITY IDEOGRAPH-FA80CJK COMPATIBILITY IDEOGRAPH-FA81C" +
	"JK COMPATIBILITY IDEOGRAPH-FA82CJK COMPATIBILITY IDEOGRAPH-FA83CJK COMPA" +
	"TIBILITY IDEOGRAPH-FA84CJK COMPATIBILITY IDEOGRAPH-FA85CJK COMPATIBILITY" +
	" IDEOGRAPH-FA86CJK COMPATIBILITY IDEOGRAPH-FA87CJK COMPATIBILITY IDEOGRA" +
	"PH-FA88CJK COMPATIBILITY IDEOGRAPH-FA89CJK COMPATIBILITY IDEOGRAPH-FA8AC" +
	"JK COMPATIBILITY IDEOGRAPH-FA8BCJK COMPATIBILITY IDEOGRAPH-FA8CCJK COMPA" +
	"TIBILITY IDEOGRAPH-FA8DCJK COMPATIBILITY IDEOGRAPH-FA8ECJK COMPATIBILITY" +
	" IDEOGRAPH-FA8FCJK COMPATIBILITY IDEOGRAPH-FA90CJK COMPATIBILITY IDEOGRA" +
	"PH-FA91CJK COMPATIBILITY IDEOGRAPH-FA92CJK COMPATIBILITY IDEOGRAPH-FA93C" +
	"JK COMPATIBILITY IDEOGRAPH-FA94CJK COMPATIBILITY IDEOGRAPH-FA95CJK COMPA" +
	"TIBILITY IDEOGRAPH-FA96CJK COMPATIBILITY IDEOGRAPH-FA97CJK COMPATIBILITY" +
	" IDEOGRAPH-FA98CJK COMPATIBILITY IDEOGRAPH-FA99CJK COMPATIBILITY IDEOGRA" +
	"PH-FA9ACJK COMPATIBILITY IDEOGRAPH-FA9BCJK COMPATIBILITY IDEOGRAPH-FA9CC") + ("" +
	"JK COMPATIBILITY IDEOGRAPH-FA9DCJK COMPATIBILITY IDEOGRAPH-FA9ECJK COMPA" +
	"TIBILITY IDEOGRAPH-FA9FCJK COMPATIBILITY IDEOGRAPH-FAA0CJK COMPATIBILITY" +
	" IDEOGRAPH-FAA1CJK COMPATIBILITY IDEOGRAPH-FAA2CJK COMPATIBILITY IDEOGRA" +
	"PH-FAA3CJK COMPATIBILITY IDEOGRAPH-FAA4CJK COMPATIBILITY IDEOGRAPH-FAA5C" +
	"JK COMPATIBILITY IDEOGRAPH-FAA6CJK COMPATIBILITY IDEOGRAPH-FAA7CJK COMPA" +
	"TIBILITY IDEOGRAPH-FAA8CJK COMPATIBILITY IDEOGRAPH-FAA9CJK COMPATIBILITY" +
	" IDEOGRAPH-FAAACJK COMPATIBILITY IDEOGRAPH-FAABCJK COMPATIBILITY IDEOGRA" +
	"PH-FAACCJK COMPATIBILITY IDEOGRAPH-FAADCJK COMPATIBILITY IDEOGRAPH-FAAEC" +
	"JK COMPATIBILITY IDEOGRAPH-FAAFCJK COMPATIBILITY IDEOGRAPH-FAB0CJK COMPA" +
	"TIBILITY IDEOGRAPH-FAB1CJK COMPATIBILITY IDEOGRAPH-FAB2CJK COMPATIBILITY" +
	" IDEOGRAPH-FAB3CJK COMPATIBILITY IDEOGRAPH-FAB4CJK COMPATIBILITY IDEOGRA" +
	"PH-FAB5CJK COMPATIBILITY IDEOGRAPH-FAB6CJK COMPATIBILITY IDEOGRAPH-FAB7C" +
	"JK COMPATIBILITY IDEOGRAPH-FAB8CJK COMPATIBILITY IDEOGRAPH-FAB9CJK COMPA" +
	"TIBILITY IDEOGRAPH-FABACJK COMPATIBILITY IDEOGRAPH-FABBCJK COMPATIBILITY" +
	" IDEOGRAPH-FABCCJK COMPATIBILITY IDEOGRAPH-FABDCJK COMPATIBILITY IDEOGRA" +
	"PH-FABECJK COMPATIBILITY IDEOGRAPH-FABFCJK COMPATIBILITY IDEOGRAPH-FAC0C" +
	"JK COMPATIBILITY IDEOGRAPH-FAC1CJK COMPATIBILITY IDEOGRAPH-FAC2CJK COMPA" +
	"TIBILITY IDEOGRAPH-FAC3CJK COMPATIBILITY IDEOGRAPH-FAC4CJK COMPATIBILITY" +
	" IDEOGRAPH-FAC5CJK COMPATIBILITY IDEOGRAPH-FAC6CJK COMPATIBILITY IDEOGRA" +
	"PH-FAC7CJK COMPATIBILITY IDEOGRAPH-FAC8CJK COMPATIBILITY IDEOGRAPH-FAC9C" +
	"JK COMPATIBILITY IDEOGRAPH-FACACJK COMPATIBILITY IDEOGRAPH-FACBCJK COMPA" +
	"TIBILITY IDEOGRAPH-FACCCJK COMPATIBILITY IDEOGRAPH-FACDCJK COMPATIBILITY" +
	" IDEOGRAPH-FACECJK COMPATIBILITY IDEOGRAPH-FACFCJK COMPATIBILITY IDEOGRA" +
	"PH-FAD0CJK COMPATIBILITY IDEOGRAPH-FAD1CJK COMPATIBILITY IDEOGRAPH-FAD2C" +
	"JK COMPATIBILITY IDEOGRAPH-FAD3CJK COMPATIBILITY IDEOGRAPH-FAD4CJK COMPA" +
	"TIBILITY IDEOGRAPH-FAD5CJK COMPATIBILITY IDEOGRAPH-FAD6CJK COMPATIBILITY" +
	" IDEOGRAPH-FAD7CJK COMPATIBILITY IDEOGRAPH-FAD8CJK COMPATIBILITY IDEOGRA" +
	"PH-FAD9LATIN SMALL LIGATURE FFLATIN SMALL LIGATURE FILATIN SMALL LIGATUR" +
	"E FLLATIN SMALL LIGATURE FFILATIN SMALL LIGATURE FFLLATIN SMALL LIGATURE" +
	" LONG S TLATIN SMALL LIGATURE STARMENIAN SMALL LIGATURE MEN NOWARMENIAN " +
	"SMALL LIGATURE MEN ECHARMENIAN SMALL LIGATURE MEN INIARMENIAN SMALL LIGA" +
	"TURE VEW NOWARMENIAN SMALL LIGATURE MEN XEHHEBREW LETTER YOD WITH HIRIQH" +
	"EBREW POINT JUDEO-SPANISH VARIKAHEBREW LIGATURE YIDDISH YOD YOD PATAHHEB" +
	"REW LETTER ALTERNATIVE AYINHEBREW LETTER WIDE ALEFHEBREW LETTER WIDE DAL" +
	"ETHEBREW LETTER WIDE HEHEBREW LETTER WIDE KAFHEBREW LETTER WIDE LAMEDHEB" +
	"REW LETTER WIDE FINAL MEMHEBREW LETTER WIDE RESHHEBREW LETTER WIDE TAVHE" +
	"BREW LETTER ALTERNATIVE PLUS SIGNHEBREW LETTER SHIN WITH SHIN DOTHEBREW " +
	"LETTER SHIN WITH SIN DOTHEBREW LETTER SHIN WITH DAGESH AND SHIN DOTHEBRE" +
	"W LETTER SHIN WITH DAGESH AND SIN DOTHEBREW LETTER ALEF WITH PATAHHEBREW" +
	" LETTER ALEF WITH QAMATSHEBREW LETTER ALEF WITH MAPIQHEBREW LETTER BET W" +
	"ITH DAGESHHEBREW LETTER GIMEL WITH DAGESHHEBREW LETTER DALET WITH DAGESH" +
	"HEBREW LETTER HE WITH MAPIQHEBREW LETTER VAV WITH DAGESHHEBREW LETTER ZA" +
	"YIN WITH DAGESHHEBREW LETTER TET WITH DAGESHHEBREW LETTER YOD WITH DAGES" +
	"HHEBREW LETTER FINAL KAF WITH DAGESHHEBREW LETTER KAF WITH DAGESHHEBREW " +
	"LETTER LAMED WITH DAGESHHEBREW LETTER MEM WITH DAGESHHEBREW LETTER NUN W" +
	"ITH DAGESHHEBREW LETTER SAMEKH WITH DAGESHHEBREW LETTER FINAL PE WITH DA" +
	"GESHHEBREW LETTER PE WITH DAGESHHEBREW LETTER TSADI WITH DAGESHHEBREW LE" +
	"TTER QOF WITH DAGESHHEBREW LETTER RESH WITH DAGESHHEBREW LETTER SHIN WIT" +
	"H DAGESHHEBREW LETTER TAV WITH DAGESHHEBREW LETTER VAV WITH HOLAMHEBREW " +
	"LETTER BET WITH RAFEHEBREW LETTER KAF WITH RAFEHEBREW LETTER PE WITH RAF" +
	"EHEBREW LIGATURE ALEF LAMEDARABIC LETTER ALEF WASLA ISOLATED FORMARABIC " +
	"LETTER ALEF WASLA FINAL FORMARABIC LETTER BEEH ISOLATED FORMARABIC LETTE" +
	"R BEEH FINAL FORMARABIC LETTER BEEH INITIAL FORMARABIC LETTER BEEH MEDIA" +
	"L FORMARABIC LETTER PEH ISOLATED FORMARABIC LETTER PEH FINAL FORMARABIC " +
	"LETTER PEH INITIAL FORMARABIC LETTER PEH MEDIAL FORMARABIC LETTER BEHEH " +
	"ISOLATED FORMARABIC LETTER BEHEH FINAL FORMARABIC LETTER BEHEH INITIAL F" +
	"ORMARABIC LETTER BEHEH MEDIAL FORMARABIC LETTER TTEHEH ISOLATED FORMARAB" +
	"IC LETTER TTEHEH FINAL FORMARABIC LETTER TTEHEH INITIAL FORMARABIC LETTE" +
	"R TTEHEH MEDIAL FORMARABIC LETTER TEHEH ISOLATED FORMARABIC LETTER TEHEH" +
	" FINAL FORMARABIC LETTER TEHEH INITIAL FORMARABIC LETTER TEHEH MEDIAL FO" +
	"RMARABIC LETTER TTEH ISOLATED FORMARABIC LETTER TTEH FINAL FORMARABIC LE" +
	"TTER TTEH INITIAL FORMARABIC LETTER TTEH MEDIAL FORMARABIC LETTER VEH IS" +
	"OLATED FORMARABIC LETTER VEH FINAL FORMARABIC LETTER VEH INITIAL FORMARA" +
	"BIC LETTER VEH MEDIAL FORMARABIC LETTER PEHEH ISOLATED FORMARABIC LETTER") + ("" +
	" PEHEH FINAL FORMARABIC LETTER PEHEH INITIAL FORMARABIC LETTER PEHEH MED" +
	"IAL FORMARABIC LETTER DYEH ISOLATED FORMARABIC LETTER DYEH FINAL FORMARA" +
	"BIC LETTER DYEH INITIAL FORMARABIC LETTER DYEH MEDIAL FORMARABIC LETTER " +
	"NYEH ISOLATED FORMARABIC LETTER NYEH FINAL FORMARABIC LETTER NYEH INITIA" +
	"L FORMARABIC LETTER NYEH MEDIAL FORMARABIC LETTER TCHEH ISOLATED FORMARA" +
	"BIC LETTER TCHEH FINAL FORMARABIC LETTER TCHEH INITIAL FORMARABIC LETTER" +
	" TCHEH MEDIAL FORMARABIC LETTER TCHEHEH ISOLATED FORMARABIC LETTER TCHEH" +
	"EH FINAL FORMARABIC LETTER TCHEHEH INITIAL FORMARABIC LETTER TCHEHEH MED" +
	"IAL FORMARABIC LETTER DDAHAL ISOLATED FORMARABIC LETTER DDAHAL FINAL FOR" +
	"MARABIC LETTER DAHAL ISOLATED FORMARABIC LETTER DAHAL FINAL FORMARABIC L" +
	"ETTER DUL ISOLATED FORMARABIC LETTER DUL FINAL FORMARABIC LETTER DDAL IS" +
	"OLATED FORMARABIC LETTER DDAL FINAL FORMARABIC LETTER JEH ISOLATED FORMA" +
	"RABIC LETTER JEH FINAL FORMARABIC LETTER RREH ISOLATED FORMARABIC LETTER" +
	" RREH FINAL FORMARABIC LETTER KEHEH ISOLATED FORMARABIC LETTER KEHEH FIN" +
	"AL FORMARABIC LETTER KEHEH INITIAL FORMARABIC LETTER KEHEH MEDIAL FORMAR" +
	"ABIC LETTER GAF ISOLATED FORMARABIC LETTER GAF FINAL FORMARABIC LETTER G" +
	"AF INITIAL FORMARABIC LETTER GAF MEDIAL FORMARABIC LETTER GUEH ISOLATED " +
	"FORMARABIC LETTER GUEH FINAL FORMARABIC LETTER GUEH INITIAL FORMARABIC L" +
	"ETTER GUEH MEDIAL FORMARABIC LETTER NGOEH ISOLATED FORMARABIC LETTER NGO" +
	"EH FINAL FORMARABIC LETTER NGOEH INITIAL FORMARABIC LETTER NGOEH MEDIAL " +
	"FORMARABIC LETTER NOON GHUNNA ISOLATED FORMARABIC LETTER NOON GHUNNA FIN" +
	"AL FORMARABIC LETTER RNOON ISOLATED FORMARABIC LETTER RNOON FINAL FORMAR" +
	"ABIC LETTER RNOON INITIAL FORMARABIC LETTER RNOON MEDIAL FORMARABIC LETT" +
	"ER HEH WITH YEH ABOVE ISOLATED FORMARABIC LETTER HEH WITH YEH ABOVE FINA" +
	"L FORMARABIC LETTER HEH GOAL ISOLATED FORMARABIC LETTER HEH GOAL FINAL F" +
	"ORMARABIC LETTER HEH GOAL INITIAL FORMARABIC LETTER HEH GOAL MEDIAL FORM" +
	"ARABIC LETTER HEH DOACHASHMEE ISOLATED FORMARABIC LETTER HEH DOACHASHMEE" +
	" FINAL FORMARABIC LETTER HEH DOACHASHMEE INITIAL FORMARABIC LETTER HEH D" +
	"OACHASHMEE MEDIAL FORMARABIC LETTER YEH BARREE ISOLATED FORMARABIC LETTE" +
	"R YEH BARREE FINAL FORMARABIC LETTER YEH BARREE WITH HAMZA ABOVE ISOLATE" +
	"D FORMARABIC LETTER YEH BARREE WITH HAMZA ABOVE FINAL FORMARABIC SYMBOL " +
	"DOT ABOVEARABIC SYMBOL DOT BELOWARABIC SYMBOL TWO DOTS ABOVEARABIC SYMBO" +
	"L TWO DOTS BELOWARABIC SYMBOL THREE DOTS ABOVEARABIC SYMBOL THREE DOTS B" +
	"ELOWARABIC SYMBOL THREE DOTS POINTING DOWNWARDS ABOVEARABIC SYMBOL THREE" +
	" DOTS POINTING DOWNWARDS BELOWARABIC SYMBOL FOUR DOTS ABOVEARABIC SYMBOL" +
	" FOUR DOTS BELOWARABIC SYMBOL DOUBLE VERTICAL BAR BELOWARABIC SYMBOL TWO" +
	" DOTS VERTICALLY ABOVEARABIC SYMBOL TWO DOTS VERTICALLY BELOWARABIC SYMB" +
	"OL RINGARABIC SYMBOL SMALL TAH ABOVEARABIC SYMBOL SMALL TAH BELOWARABIC " +
	"LETTER NG ISOLATED FORMARABIC LETTER NG FINAL FORMARABIC LETTER NG INITI" +
	"AL FORMARABIC LETTER NG MEDIAL FORMARABIC LETTER U ISOLATED FORMARABIC L" +
	"ETTER U FINAL FORMARABIC LETTER OE ISOLATED FORMARABIC LETTER OE FINAL F" +
	"ORMARABIC LETTER YU ISOLATED FORMARABIC LETTER YU FINAL FORMARABIC LETTE" +
	"R U WITH HAMZA ABOVE ISOLATED FORMARABIC LETTER VE ISOLATED FORMARABIC L" +
	"ETTER VE FINAL FORMARABIC LETTER KIRGHIZ OE ISOLATED FORMARABIC LETTER K" +
	"IRGHIZ OE FINAL FORMARABIC LETTER KIRGHIZ YU ISOLATED FORMARABIC LETTER " +
	"KIRGHIZ YU FINAL FORMARABIC LETTER E ISOLATED FORMARABIC LETTER E FINAL " +
	"FORMARABIC LETTER E INITIAL FORMARABIC LETTER E MEDIAL FORMARABIC LETTER" +
	" UIGHUR KAZAKH KIRGHIZ ALEF MAKSURA INITIAL FORMARABIC LETTER UIGHUR KAZ" +
	"AKH KIRGHIZ ALEF MAKSURA MEDIAL FORMARABIC LIGATURE YEH WITH HAMZA ABOVE" +
	" WITH ALEF ISOLATED FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ALEF F" +
	"INAL FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH AE ISOLATED FORMARABI" +
	"C LIGATURE YEH WITH HAMZA ABOVE WITH AE FINAL FORMARABIC LIGATURE YEH WI" +
	"TH HAMZA ABOVE WITH WAW ISOLATED FORMARABIC LIGATURE YEH WITH HAMZA ABOV" +
	"E WITH WAW FINAL FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH U ISOLATE" +
	"D FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH U FINAL FORMARABIC LIGAT" +
	"URE YEH WITH HAMZA ABOVE WITH OE ISOLATED FORMARABIC LIGATURE YEH WITH H" +
	"AMZA ABOVE WITH OE FINAL FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH Y" +
	"U ISOLATED FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH YU FINAL FORMAR" +
	"ABIC LIGATURE YEH WITH HAMZA ABOVE WITH E ISOLATED FORMARABIC LIGATURE Y" +
	"EH WITH HAMZA ABOVE WITH E FINAL FORMARABIC LIGATURE YEH WITH HAMZA ABOV" +
	"E WITH E INITIAL FORMARABIC LIGATURE UIGHUR KIRGHIZ YEH WITH HAMZA ABOVE" +
	" WITH ALEF MAKSURA ISOLATED FORMARABIC LIGATURE UIGHUR KIRGHIZ YEH WITH " +
	"HAMZA ABOVE WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE UIGHUR KIRGHIZ Y" +
	"EH WITH HAMZA ABOVE WITH ALEF MAKSURA INITIAL FORMARABIC LETTER FARSI YE") + ("" +
	"H ISOLATED FORMARABIC LETTER FARSI YEH FINAL FORMARABIC LETTER FARSI YEH" +
	" INITIAL FORMARABIC LETTER FARSI YEH MEDIAL FORMARABIC LIGATURE YEH WITH" +
	" HAMZA ABOVE WITH JEEM ISOLATED FORMARABIC LIGATURE YEH WITH HAMZA ABOVE" +
	" WITH HAH ISOLATED FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH MEEM IS" +
	"OLATED FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ALEF MAKSURA ISOLAT" +
	"ED FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH YEH ISOLATED FORMARABIC" +
	" LIGATURE BEH WITH JEEM ISOLATED FORMARABIC LIGATURE BEH WITH HAH ISOLAT" +
	"ED FORMARABIC LIGATURE BEH WITH KHAH ISOLATED FORMARABIC LIGATURE BEH WI" +
	"TH MEEM ISOLATED FORMARABIC LIGATURE BEH WITH ALEF MAKSURA ISOLATED FORM" +
	"ARABIC LIGATURE BEH WITH YEH ISOLATED FORMARABIC LIGATURE TEH WITH JEEM " +
	"ISOLATED FORMARABIC LIGATURE TEH WITH HAH ISOLATED FORMARABIC LIGATURE T" +
	"EH WITH KHAH ISOLATED FORMARABIC LIGATURE TEH WITH MEEM ISOLATED FORMARA" +
	"BIC LIGATURE TEH WITH ALEF MAKSURA ISOLATED FORMARABIC LIGATURE TEH WITH" +
	" YEH ISOLATED FORMARABIC LIGATURE THEH WITH JEEM ISOLATED FORMARABIC LIG" +
	"ATURE THEH WITH MEEM ISOLATED FORMARABIC LIGATURE THEH WITH ALEF MAKSURA" +
	" ISOLATED FORMARABIC LIGATURE THEH WITH YEH ISOLATED FORMARABIC LIGATURE" +
	" JEEM WITH HAH ISOLATED FORMARABIC LIGATURE JEEM WITH MEEM ISOLATED FORM" +
	"ARABIC LIGATURE HAH WITH JEEM ISOLATED FORMARABIC LIGATURE HAH WITH MEEM" +
	" ISOLATED FORMARABIC LIGATURE KHAH WITH JEEM ISOLATED FORMARABIC LIGATUR" +
	"E KHAH WITH HAH ISOLATED FORMARABIC LIGATURE KHAH WITH MEEM ISOLATED FOR" +
	"MARABIC LIGATURE SEEN WITH JEEM ISOLATED FORMARABIC LIGATURE SEEN WITH H" +
	"AH ISOLATED FORMARABIC LIGATURE SEEN WITH KHAH ISOLATED FORMARABIC LIGAT" +
	"URE SEEN WITH MEEM ISOLATED FORMARABIC LIGATURE SAD WITH HAH ISOLATED FO" +
	"RMARABIC LIGATURE SAD WITH MEEM ISOLATED FORMARABIC LIGATURE DAD WITH JE" +
	"EM ISOLATED FORMARABIC LIGATURE DAD WITH HAH ISOLATED FORMARABIC LIGATUR" +
	"E DAD WITH KHAH ISOLATED FORMARABIC LIGATURE DAD WITH MEEM ISOLATED FORM" +
	"ARABIC LIGATURE TAH WITH HAH ISOLATED FORMARABIC LIGATURE TAH WITH MEEM " +
	"ISOLATED FORMARABIC LIGATURE ZAH WITH MEEM ISOLATED FORMARABIC LIGATURE " +
	"AIN WITH JEEM ISOLATED FORMARABIC LIGATURE AIN WITH MEEM ISOLATED FORMAR" +
	"ABIC LIGATURE GHAIN WITH JEEM ISOLATED FORMARABIC LIGATURE GHAIN WITH ME" +
	"EM ISOLATED FORMARABIC LIGATURE FEH WITH JEEM ISOLATED FORMARABIC LIGATU" +
	"RE FEH WITH HAH ISOLATED FORMARABIC LIGATURE FEH WITH KHAH ISOLATED FORM" +
	"ARABIC LIGATURE FEH WITH MEEM ISOLATED FORMARABIC LIGATURE FEH WITH ALEF" +
	" MAKSURA ISOLATED FORMARABIC LIGATURE FEH WITH YEH ISOLATED FORMARABIC L" +
	"IGATURE QAF WITH HAH ISOLATED FORMARABIC LIGATURE QAF WITH MEEM ISOLATED" +
	" FORMARABIC LIGATURE QAF WITH ALEF MAKSURA ISOLATED FORMARABIC LIGATURE " +
	"QAF WITH YEH ISOLATED FORMARABIC LIGATURE KAF WITH ALEF ISOLATED FORMARA" +
	"BIC LIGATURE KAF WITH JEEM ISOLATED FORMARABIC LIGATURE KAF WITH HAH ISO" +
	"LATED FORMARABIC LIGATURE KAF WITH KHAH ISOLATED FORMARABIC LIGATURE KAF" +
	" WITH LAM ISOLATED FORMARABIC LIGATURE KAF WITH MEEM ISOLATED FORMARABIC" +
	" LIGATURE KAF WITH ALEF MAKSURA ISOLATED FORMARABIC LIGATURE KAF WITH YE" +
	"H ISOLATED FORMARABIC LIGATURE LAM WITH JEEM ISOLATED FORMARABIC LIGATUR" +
	"E LAM WITH HAH ISOLATED FORMARABIC LIGATURE LAM WITH KHAH ISOLATED FORMA" +
	"RABIC LIGATURE LAM WITH MEEM ISOLATED FORMARABIC LIGATURE LAM WITH ALEF " +
	"MAKSURA ISOLATED FORMARABIC LIGATURE LAM WITH YEH ISOLATED FORMARABIC LI" +
	"GATURE MEEM WITH JEEM ISOLATED FORMARABIC LIGATURE MEEM WITH HAH ISOLATE" +
	"D FORMARABIC LIGATURE MEEM WITH KHAH ISOLATED FORMARABIC LIGATURE MEEM W" +
	"ITH MEEM ISOLATED FORMARABIC LIGATURE MEEM WITH ALEF MAKSURA ISOLATED FO" +
	"RMARABIC LIGATURE MEEM WITH YEH ISOLATED FORMARABIC LIGATURE NOON WITH J" +
	"EEM ISOLATED FORMARABIC LIGATURE NOON WITH HAH ISOLATED FORMARABIC LIGAT" +
	"URE NOON WITH KHAH ISOLATED FORMARABIC LIGATURE NOON WITH MEEM ISOLATED " +
	"FORMARABIC LIGATURE NOON WITH ALEF MAKSURA ISOLATED FORMARABIC LIGATURE " +
	"NOON WITH YEH ISOLATED FORMARABIC LIGATURE HEH WITH JEEM ISOLATED FORMAR" +
	"ABIC LIGATURE HEH WITH MEEM ISOLATED FORMARABIC LIGATURE HEH WITH ALEF M" +
	"AKSURA ISOLATED FORMARABIC LIGATURE HEH WITH YEH ISOLATED FORMARABIC LIG" +
	"ATURE YEH WITH JEEM ISOLATED FORMARABIC LIGATURE YEH WITH HAH ISOLATED F" +
	"ORMARABIC LIGATURE YEH WITH KHAH ISOLATED FORMARABIC LIGATURE YEH WITH M" +
	"EEM ISOLATED FORMARABIC LIGATURE YEH WITH ALEF MAKSURA ISOLATED FORMARAB" +
	"IC LIGATURE YEH WITH YEH ISOLATED FORMARABIC LIGATURE THAL WITH SUPERSCR" +
	"IPT ALEF ISOLATED FORMARABIC LIGATURE REH WITH SUPERSCRIPT ALEF ISOLATED" +
	" FORMARABIC LIGATURE ALEF MAKSURA WITH SUPERSCRIPT ALEF ISOLATED FORMARA" +
	"BIC LIGATURE SHADDA WITH DAMMATAN ISOLATED FORMARABIC LIGATURE SHADDA WI" +
	"TH KASRATAN ISOLATED FORMARABIC LIGATURE SHADDA WITH FATHA ISOLATED FORM" +
	"ARABIC LIGATURE SHADDA WITH DAMMA ISOLATED FORMARABIC LIGATURE SHADDA WI") + ("" +
	"TH KASRA ISOLATED FORMARABIC LIGATURE SHADDA WITH SUPERSCRIPT ALEF ISOLA" +
	"TED FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH REH FINAL FORMARABIC L" +
	"IGATURE YEH WITH HAMZA ABOVE WITH ZAIN FINAL FORMARABIC LIGATURE YEH WIT" +
	"H HAMZA ABOVE WITH MEEM FINAL FORMARABIC LIGATURE YEH WITH HAMZA ABOVE W" +
	"ITH NOON FINAL FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ALEF MAKSUR" +
	"A FINAL FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH YEH FINAL FORMARAB" +
	"IC LIGATURE BEH WITH REH FINAL FORMARABIC LIGATURE BEH WITH ZAIN FINAL F" +
	"ORMARABIC LIGATURE BEH WITH MEEM FINAL FORMARABIC LIGATURE BEH WITH NOON" +
	" FINAL FORMARABIC LIGATURE BEH WITH ALEF MAKSURA FINAL FORMARABIC LIGATU" +
	"RE BEH WITH YEH FINAL FORMARABIC LIGATURE TEH WITH REH FINAL FORMARABIC " +
	"LIGATURE TEH WITH ZAIN FINAL FORMARABIC LIGATURE TEH WITH MEEM FINAL FOR" +
	"MARABIC LIGATURE TEH WITH NOON FINAL FORMARABIC LIGATURE TEH WITH ALEF M" +
	"AKSURA FINAL FORMARABIC LIGATURE TEH WITH YEH FINAL FORMARABIC LIGATURE " +
	"THEH WITH REH FINAL FORMARABIC LIGATURE THEH WITH ZAIN FINAL FORMARABIC " +
	"LIGATURE THEH WITH MEEM FINAL FORMARABIC LIGATURE THEH WITH NOON FINAL F" +
	"ORMARABIC LIGATURE THEH WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE THEH" +
	" WITH YEH FINAL FORMARABIC LIGATURE FEH WITH ALEF MAKSURA FINAL FORMARAB" +
	"IC LIGATURE FEH WITH YEH FINAL FORMARABIC LIGATURE QAF WITH ALEF MAKSURA" +
	" FINAL FORMARABIC LIGATURE QAF WITH YEH FINAL FORMARABIC LIGATURE KAF WI" +
	"TH ALEF FINAL FORMARABIC LIGATURE KAF WITH LAM FINAL FORMARABIC LIGATURE" +
	" KAF WITH MEEM FINAL FORMARABIC LIGATURE KAF WITH ALEF MAKSURA FINAL FOR" +
	"MARABIC LIGATURE KAF WITH YEH FINAL FORMARABIC LIGATURE LAM WITH MEEM FI" +
	"NAL FORMARABIC LIGATURE LAM WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE " +
	"LAM WITH YEH FINAL FORMARABIC LIGATURE MEEM WITH ALEF FINAL FORMARABIC L" +
	"IGATURE MEEM WITH MEEM FINAL FORMARABIC LIGATURE NOON WITH REH FINAL FOR" +
	"MARABIC LIGATURE NOON WITH ZAIN FINAL FORMARABIC LIGATURE NOON WITH MEEM" +
	" FINAL FORMARABIC LIGATURE NOON WITH NOON FINAL FORMARABIC LIGATURE NOON" +
	" WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE NOON WITH YEH FINAL FORMARA" +
	"BIC LIGATURE ALEF MAKSURA WITH SUPERSCRIPT ALEF FINAL FORMARABIC LIGATUR" +
	"E YEH WITH REH FINAL FORMARABIC LIGATURE YEH WITH ZAIN FINAL FORMARABIC " +
	"LIGATURE YEH WITH MEEM FINAL FORMARABIC LIGATURE YEH WITH NOON FINAL FOR" +
	"MARABIC LIGATURE YEH WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE YEH WIT" +
	"H YEH FINAL FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH JEEM INITIAL F" +
	"ORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH HAH INITIAL FORMARABIC LIGA" +
	"TURE YEH WITH HAMZA ABOVE WITH KHAH INITIAL FORMARABIC LIGATURE YEH WITH" +
	" HAMZA ABOVE WITH MEEM INITIAL FORMARABIC LIGATURE YEH WITH HAMZA ABOVE " +
	"WITH HEH INITIAL FORMARABIC LIGATURE BEH WITH JEEM INITIAL FORMARABIC LI" +
	"GATURE BEH WITH HAH INITIAL FORMARABIC LIGATURE BEH WITH KHAH INITIAL FO" +
	"RMARABIC LIGATURE BEH WITH MEEM INITIAL FORMARABIC LIGATURE BEH WITH HEH" +
	" INITIAL FORMARABIC LIGATURE TEH WITH JEEM INITIAL FORMARABIC LIGATURE T" +
	"EH WITH HAH INITIAL FORMARABIC LIGATURE TEH WITH KHAH INITIAL FORMARABIC" +
	" LIGATURE TEH WITH MEEM INITIAL FORMARABIC LIGATURE TEH WITH HEH INITIAL" +
	" FORMARABIC LIGATURE THEH WITH MEEM INITIAL FORMARABIC LIGATURE JEEM WIT" +
	"H HAH INITIAL FORMARABIC LIGATURE JEEM WITH MEEM INITIAL FORMARABIC LIGA" +
	"TURE HAH WITH JEEM INITIAL FORMARABIC LIGATURE HAH WITH MEEM INITIAL FOR" +
	"MARABIC LIGATURE KHAH WITH JEEM INITIAL FORMARABIC LIGATURE KHAH WITH ME" +
	"EM INITIAL FORMARABIC LIGATURE SEEN WITH JEEM INITIAL FORMARABIC LIGATUR" +
	"E SEEN WITH HAH INITIAL FORMARABIC LIGATURE SEEN WITH KHAH INITIAL FORMA" +
	"RABIC LIGATURE SEEN WITH MEEM INITIAL FORMARABIC LIGATURE SAD WITH HAH I" +
	"NITIAL FORMARABIC LIGATURE SAD WITH KHAH INITIAL FORMARABIC LIGATURE SAD" +
	" WITH MEEM INITIAL FORMARABIC LIGATURE DAD WITH JEEM INITIAL FORMARABIC " +
	"LIGATURE DAD WITH HAH INITIAL FORMARABIC LIGATURE DAD WITH KHAH INITIAL " +
	"FORMARABIC LIGATURE DAD WITH MEEM INITIAL FORMARABIC LIGATURE TAH WITH H" +
	"AH INITIAL FORMARABIC LIGATURE ZAH WITH MEEM INITIAL FORMARABIC LIGATURE" +
	" AIN WITH JEEM INITIAL FORMARABIC LIGATURE AIN WITH MEEM INITIAL FORMARA" +
	"BIC LIGATURE GHAIN WITH JEEM INITIAL FORMARABIC LIGATURE GHAIN WITH MEEM" +
	" INITIAL FORMARABIC LIGATURE FEH WITH JEEM INITIAL FORMARABIC LIGATURE F" +
	"EH WITH HAH INITIAL FORMARABIC LIGATURE FEH WITH KHAH INITIAL FORMARABIC" +
	" LIGATURE FEH WITH MEEM INITIAL FORMARABIC LIGATURE QAF WITH HAH INITIAL" +
	" FORMARABIC LIGATURE QAF WITH MEEM INITIAL FORMARABIC LIGATURE KAF WITH " +
	"JEEM INITIAL FORMARABIC LIGATURE KAF WITH HAH INITIAL FORMARABIC LIGATUR" +
	"E KAF WITH KHAH INITIAL FORMARABIC LIGATURE KAF WITH LAM INITIAL FORMARA" +
	"BIC LIGATURE KAF WITH MEEM INITIAL FORMARABIC LIGATURE LAM WITH JEEM INI" +
	"TIAL FORMARABIC LIGATURE LAM WITH HAH INITIAL FORMARABIC LIGATURE LAM WI") + ("" +
	"TH KHAH INITIAL FORMARABIC LIGATURE LAM WITH MEEM INITIAL FORMARABIC LIG" +
	"ATURE LAM WITH HEH INITIAL FORMARABIC LIGATURE MEEM WITH JEEM INITIAL FO" +
	"RMARABIC LIGATURE MEEM WITH HAH INITIAL FORMARABIC LIGATURE MEEM WITH KH" +
	"AH INITIAL FORMARABIC LIGATURE MEEM WITH MEEM INITIAL FORMARABIC LIGATUR" +
	"E NOON WITH JEEM INITIAL FORMARABIC LIGATURE NOON WITH HAH INITIAL FORMA" +
	"RABIC LIGATURE NOON WITH KHAH INITIAL FORMARABIC LIGATURE NOON WITH MEEM" +
	" INITIAL FORMARABIC LIGATURE NOON WITH HEH INITIAL FORMARABIC LIGATURE H" +
	"EH WITH JEEM INITIAL FORMARABIC LIGATURE HEH WITH MEEM INITIAL FORMARABI" +
	"C LIGATURE HEH WITH SUPERSCRIPT ALEF INITIAL FORMARABIC LIGATURE YEH WIT" +
	"H JEEM INITIAL FORMARABIC LIGATURE YEH WITH HAH INITIAL FORMARABIC LIGAT" +
	"URE YEH WITH KHAH INITIAL FORMARABIC LIGATURE YEH WITH MEEM INITIAL FORM" +
	"ARABIC LIGATURE YEH WITH HEH INITIAL FORMARABIC LIGATURE YEH WITH HAMZA " +
	"ABOVE WITH MEEM MEDIAL FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH HEH" +
	" MEDIAL FORMARABIC LIGATURE BEH WITH MEEM MEDIAL FORMARABIC LIGATURE BEH" +
	" WITH HEH MEDIAL FORMARABIC LIGATURE TEH WITH MEEM MEDIAL FORMARABIC LIG" +
	"ATURE TEH WITH HEH MEDIAL FORMARABIC LIGATURE THEH WITH MEEM MEDIAL FORM" +
	"ARABIC LIGATURE THEH WITH HEH MEDIAL FORMARABIC LIGATURE SEEN WITH MEEM " +
	"MEDIAL FORMARABIC LIGATURE SEEN WITH HEH MEDIAL FORMARABIC LIGATURE SHEE" +
	"N WITH MEEM MEDIAL FORMARABIC LIGATURE SHEEN WITH HEH MEDIAL FORMARABIC " +
	"LIGATURE KAF WITH LAM MEDIAL FORMARABIC LIGATURE KAF WITH MEEM MEDIAL FO" +
	"RMARABIC LIGATURE LAM WITH MEEM MEDIAL FORMARABIC LIGATURE NOON WITH MEE" +
	"M MEDIAL FORMARABIC LIGATURE NOON WITH HEH MEDIAL FORMARABIC LIGATURE YE" +
	"H WITH MEEM MEDIAL FORMARABIC LIGATURE YEH WITH HEH MEDIAL FORMARABIC LI" +
	"GATURE SHADDA WITH FATHA MEDIAL FORMARABIC LIGATURE SHADDA WITH DAMMA ME" +
	"DIAL FORMARABIC LIGATURE SHADDA WITH KASRA MEDIAL FORMARABIC LIGATURE TA" +
	"H WITH ALEF MAKSURA ISOLATED FORMARABIC LIGATURE TAH WITH YEH ISOLATED F" +
	"ORMARABIC LIGATURE AIN WITH ALEF MAKSURA ISOLATED FORMARABIC LIGATURE AI" +
	"N WITH YEH ISOLATED FORMARABIC LIGATURE GHAIN WITH ALEF MAKSURA ISOLATED" +
	" FORMARABIC LIGATURE GHAIN WITH YEH ISOLATED FORMARABIC LIGATURE SEEN WI" +
	"TH ALEF MAKSURA ISOLATED FORMARABIC LIGATURE SEEN WITH YEH ISOLATED FORM" +
	"ARABIC LIGATURE SHEEN WITH ALEF MAKSURA ISOLATED FORMARABIC LIGATURE SHE" +
	"EN WITH YEH ISOLATED FORMARABIC LIGATURE HAH WITH ALEF MAKSURA ISOLATED " +
	"FORMARABIC LIGATURE HAH WITH YEH ISOLATED FORMARABIC LIGATURE JEEM WITH " +
	"ALEF MAKSURA ISOLATED FORMARABIC LIGATURE JEEM WITH YEH ISOLATED FORMARA" +
	"BIC LIGATURE KHAH WITH ALEF MAKSURA ISOLATED FORMARABIC LIGATURE KHAH WI" +
	"TH YEH ISOLATED FORMARABIC LIGATURE SAD WITH ALEF MAKSURA ISOLATED FORMA" +
	"RABIC LIGATURE SAD WITH YEH ISOLATED FORMARABIC LIGATURE DAD WITH ALEF M" +
	"AKSURA ISOLATED FORMARABIC LIGATURE DAD WITH YEH ISOLATED FORMARABIC LIG" +
	"ATURE SHEEN WITH JEEM ISOLATED FORMARABIC LIGATURE SHEEN WITH HAH ISOLAT" +
	"ED FORMARABIC LIGATURE SHEEN WITH KHAH ISOLATED FORMARABIC LIGATURE SHEE" +
	"N WITH MEEM ISOLATED FORMARABIC LIGATURE SHEEN WITH REH ISOLATED FORMARA" +
	"BIC LIGATURE SEEN WITH REH ISOLATED FORMARABIC LIGATURE SAD WITH REH ISO" +
	"LATED FORMARABIC LIGATURE DAD WITH REH ISOLATED FORMARABIC LIGATURE TAH " +
	"WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE TAH WITH YEH FINAL FORMARABI" +
	"C LIGATURE AIN WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE AIN WITH YEH " +
	"FINAL FORMARABIC LIGATURE GHAIN WITH ALEF MAKSURA FINAL FORMARABIC LIGAT" +
	"URE GHAIN WITH YEH FINAL FORMARABIC LIGATURE SEEN WITH ALEF MAKSURA FINA" +
	"L FORMARABIC LIGATURE SEEN WITH YEH FINAL FORMARABIC LIGATURE SHEEN WITH" +
	" ALEF MAKSURA FINAL FORMARABIC LIGATURE SHEEN WITH YEH FINAL FORMARABIC " +
	"LIGATURE HAH WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE HAH WITH YEH FI" +
	"NAL FORMARABIC LIGATURE JEEM WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE" +
	" JEEM WITH YEH FINAL FORMARABIC LIGATURE KHAH WITH ALEF MAKSURA FINAL FO" +
	"RMARABIC LIGATURE KHAH WITH YEH FINAL FORMARABIC LIGATURE SAD WITH ALEF " +
	"MAKSURA FINAL FORMARABIC LIGATURE SAD WITH YEH FINAL FORMARABIC LIGATURE" +
	" DAD WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE DAD WITH YEH FINAL FORM" +
	"ARABIC LIGATURE SHEEN WITH JEEM FINAL FORMARABIC LIGATURE SHEEN WITH HAH" +
	" FINAL FORMARABIC LIGATURE SHEEN WITH KHAH FINAL FORMARABIC LIGATURE SHE" +
	"EN WITH MEEM FINAL FORMARABIC LIGATURE SHEEN WITH REH FINAL FORMARABIC L" +
	"IGATURE SEEN WITH REH FINAL FORMARABIC LIGATURE SAD WITH REH FINAL FORMA" +
	"RABIC LIGATURE DAD WITH REH FINAL FORMARABIC LIGATURE SHEEN WITH JEEM IN" +
	"ITIAL FORMARABIC LIGATURE SHEEN WITH HAH INITIAL FORMARABIC LIGATURE SHE" +
	"EN WITH KHAH INITIAL FORMARABIC LIGATURE SHEEN WITH MEEM INITIAL FORMARA" +
	"BIC LIGATURE SEEN WITH HEH INITIAL FORMARABIC LIGATURE SHEEN WITH HEH IN" +
	"ITIAL FORMARABIC LIGATURE TAH WITH MEEM INITIAL FORMARABIC LIGATURE SEEN") + ("" +
	" WITH JEEM MEDIAL FORMARABIC LIGATURE SEEN WITH HAH MEDIAL FORMARABIC LI" +
	"GATURE SEEN WITH KHAH MEDIAL FORMARABIC LIGATURE SHEEN WITH JEEM MEDIAL " +
	"FORMARABIC LIGATURE SHEEN WITH HAH MEDIAL FORMARABIC LIGATURE SHEEN WITH" +
	" KHAH MEDIAL FORMARABIC LIGATURE TAH WITH MEEM MEDIAL FORMARABIC LIGATUR" +
	"E ZAH WITH MEEM MEDIAL FORMARABIC LIGATURE ALEF WITH FATHATAN FINAL FORM" +
	"ARABIC LIGATURE ALEF WITH FATHATAN ISOLATED FORMORNATE LEFT PARENTHESISO" +
	"RNATE RIGHT PARENTHESISARABIC LIGATURE TEH WITH JEEM WITH MEEM INITIAL F" +
	"ORMARABIC LIGATURE TEH WITH HAH WITH JEEM FINAL FORMARABIC LIGATURE TEH " +
	"WITH HAH WITH JEEM INITIAL FORMARABIC LIGATURE TEH WITH HAH WITH MEEM IN" +
	"ITIAL FORMARABIC LIGATURE TEH WITH KHAH WITH MEEM INITIAL FORMARABIC LIG" +
	"ATURE TEH WITH MEEM WITH JEEM INITIAL FORMARABIC LIGATURE TEH WITH MEEM " +
	"WITH HAH INITIAL FORMARABIC LIGATURE TEH WITH MEEM WITH KHAH INITIAL FOR" +
	"MARABIC LIGATURE JEEM WITH MEEM WITH HAH FINAL FORMARABIC LIGATURE JEEM " +
	"WITH MEEM WITH HAH INITIAL FORMARABIC LIGATURE HAH WITH MEEM WITH YEH FI" +
	"NAL FORMARABIC LIGATURE HAH WITH MEEM WITH ALEF MAKSURA FINAL FORMARABIC" +
	" LIGATURE SEEN WITH HAH WITH JEEM INITIAL FORMARABIC LIGATURE SEEN WITH " +
	"JEEM WITH HAH INITIAL FORMARABIC LIGATURE SEEN WITH JEEM WITH ALEF MAKSU" +
	"RA FINAL FORMARABIC LIGATURE SEEN WITH MEEM WITH HAH FINAL FORMARABIC LI" +
	"GATURE SEEN WITH MEEM WITH HAH INITIAL FORMARABIC LIGATURE SEEN WITH MEE" +
	"M WITH JEEM INITIAL FORMARABIC LIGATURE SEEN WITH MEEM WITH MEEM FINAL F" +
	"ORMARABIC LIGATURE SEEN WITH MEEM WITH MEEM INITIAL FORMARABIC LIGATURE " +
	"SAD WITH HAH WITH HAH FINAL FORMARABIC LIGATURE SAD WITH HAH WITH HAH IN" +
	"ITIAL FORMARABIC LIGATURE SAD WITH MEEM WITH MEEM FINAL FORMARABIC LIGAT" +
	"URE SHEEN WITH HAH WITH MEEM FINAL FORMARABIC LIGATURE SHEEN WITH HAH WI" +
	"TH MEEM INITIAL FORMARABIC LIGATURE SHEEN WITH JEEM WITH YEH FINAL FORMA" +
	"RABIC LIGATURE SHEEN WITH MEEM WITH KHAH FINAL FORMARABIC LIGATURE SHEEN" +
	" WITH MEEM WITH KHAH INITIAL FORMARABIC LIGATURE SHEEN WITH MEEM WITH ME" +
	"EM FINAL FORMARABIC LIGATURE SHEEN WITH MEEM WITH MEEM INITIAL FORMARABI" +
	"C LIGATURE DAD WITH HAH WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE DAD " +
	"WITH KHAH WITH MEEM FINAL FORMARABIC LIGATURE DAD WITH KHAH WITH MEEM IN" +
	"ITIAL FORMARABIC LIGATURE TAH WITH MEEM WITH HAH FINAL FORMARABIC LIGATU" +
	"RE TAH WITH MEEM WITH HAH INITIAL FORMARABIC LIGATURE TAH WITH MEEM WITH" +
	" MEEM INITIAL FORMARABIC LIGATURE TAH WITH MEEM WITH YEH FINAL FORMARABI" +
	"C LIGATURE AIN WITH JEEM WITH MEEM FINAL FORMARABIC LIGATURE AIN WITH ME" +
	"EM WITH MEEM FINAL FORMARABIC LIGATURE AIN WITH MEEM WITH MEEM INITIAL F" +
	"ORMARABIC LIGATURE AIN WITH MEEM WITH ALEF MAKSURA FINAL FORMARABIC LIGA" +
	"TURE GHAIN WITH MEEM WITH MEEM FINAL FORMARABIC LIGATURE GHAIN WITH MEEM" +
	" WITH YEH FINAL FORMARABIC LIGATURE GHAIN WITH MEEM WITH ALEF MAKSURA FI" +
	"NAL FORMARABIC LIGATURE FEH WITH KHAH WITH MEEM FINAL FORMARABIC LIGATUR" +
	"E FEH WITH KHAH WITH MEEM INITIAL FORMARABIC LIGATURE QAF WITH MEEM WITH" +
	" HAH FINAL FORMARABIC LIGATURE QAF WITH MEEM WITH MEEM FINAL FORMARABIC " +
	"LIGATURE LAM WITH HAH WITH MEEM FINAL FORMARABIC LIGATURE LAM WITH HAH W" +
	"ITH YEH FINAL FORMARABIC LIGATURE LAM WITH HAH WITH ALEF MAKSURA FINAL F" +
	"ORMARABIC LIGATURE LAM WITH JEEM WITH JEEM INITIAL FORMARABIC LIGATURE L" +
	"AM WITH JEEM WITH JEEM FINAL FORMARABIC LIGATURE LAM WITH KHAH WITH MEEM" +
	" FINAL FORMARABIC LIGATURE LAM WITH KHAH WITH MEEM INITIAL FORMARABIC LI" +
	"GATURE LAM WITH MEEM WITH HAH FINAL FORMARABIC LIGATURE LAM WITH MEEM WI" +
	"TH HAH INITIAL FORMARABIC LIGATURE MEEM WITH HAH WITH JEEM INITIAL FORMA" +
	"RABIC LIGATURE MEEM WITH HAH WITH MEEM INITIAL FORMARABIC LIGATURE MEEM " +
	"WITH HAH WITH YEH FINAL FORMARABIC LIGATURE MEEM WITH JEEM WITH HAH INIT" +
	"IAL FORMARABIC LIGATURE MEEM WITH JEEM WITH MEEM INITIAL FORMARABIC LIGA" +
	"TURE MEEM WITH KHAH WITH JEEM INITIAL FORMARABIC LIGATURE MEEM WITH KHAH" +
	" WITH MEEM INITIAL FORMARABIC LIGATURE MEEM WITH JEEM WITH KHAH INITIAL " +
	"FORMARABIC LIGATURE HEH WITH MEEM WITH JEEM INITIAL FORMARABIC LIGATURE " +
	"HEH WITH MEEM WITH MEEM INITIAL FORMARABIC LIGATURE NOON WITH HAH WITH M" +
	"EEM INITIAL FORMARABIC LIGATURE NOON WITH HAH WITH ALEF MAKSURA FINAL FO" +
	"RMARABIC LIGATURE NOON WITH JEEM WITH MEEM FINAL FORMARABIC LIGATURE NOO" +
	"N WITH JEEM WITH MEEM INITIAL FORMARABIC LIGATURE NOON WITH JEEM WITH AL" +
	"EF MAKSURA FINAL FORMARABIC LIGATURE NOON WITH MEEM WITH YEH FINAL FORMA" +
	"RABIC LIGATURE NOON WITH MEEM WITH ALEF MAKSURA FINAL FORMARABIC LIGATUR" +
	"E YEH WITH MEEM WITH MEEM FINAL FORMARABIC LIGATURE YEH WITH MEEM WITH M" +
	"EEM INITIAL FORMARABIC LIGATURE BEH WITH KHAH WITH YEH FINAL FORMARABIC " +
	"LIGATURE TEH WITH JEEM WITH YEH FINAL FORMARABIC LIGATURE TEH WITH JEEM " +
	"WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE TEH WITH KHAH WITH YEH FINAL") + ("" +
	" FORMARABIC LIGATURE TEH WITH KHAH WITH ALEF MAKSURA FINAL FORMARABIC LI" +
	"GATURE TEH WITH MEEM WITH YEH FINAL FORMARABIC LIGATURE TEH WITH MEEM WI" +
	"TH ALEF MAKSURA FINAL FORMARABIC LIGATURE JEEM WITH MEEM WITH YEH FINAL " +
	"FORMARABIC LIGATURE JEEM WITH HAH WITH ALEF MAKSURA FINAL FORMARABIC LIG" +
	"ATURE JEEM WITH MEEM WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE SEEN WI" +
	"TH KHAH WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE SAD WITH HAH WITH YE" +
	"H FINAL FORMARABIC LIGATURE SHEEN WITH HAH WITH YEH FINAL FORMARABIC LIG" +
	"ATURE DAD WITH HAH WITH YEH FINAL FORMARABIC LIGATURE LAM WITH JEEM WITH" +
	" YEH FINAL FORMARABIC LIGATURE LAM WITH MEEM WITH YEH FINAL FORMARABIC L" +
	"IGATURE YEH WITH HAH WITH YEH FINAL FORMARABIC LIGATURE YEH WITH JEEM WI" +
	"TH YEH FINAL FORMARABIC LIGATURE YEH WITH MEEM WITH YEH FINAL FORMARABIC" +
	" LIGATURE MEEM WITH MEEM WITH YEH FINAL FORMARABIC LIGATURE QAF WITH MEE" +
	"M WITH YEH FINAL FORMARABIC LIGATURE NOON WITH HAH WITH YEH FINAL FORMAR" +
	"ABIC LIGATURE QAF WITH MEEM WITH HAH INITIAL FORMARABIC LIGATURE LAM WIT" +
	"H HAH WITH MEEM INITIAL FORMARABIC LIGATURE AIN WITH MEEM WITH YEH FINAL" +
	" FORMARABIC LIGATURE KAF WITH MEEM WITH YEH FINAL FORMARABIC LIGATURE NO" +
	"ON WITH JEEM WITH HAH INITIAL FORMARABIC LIGATURE MEEM WITH KHAH WITH YE" +
	"H FINAL FORMARABIC LIGATURE LAM WITH JEEM WITH MEEM INITIAL FORMARABIC L" +
	"IGATURE KAF WITH MEEM WITH MEEM FINAL FORMARABIC LIGATURE LAM WITH JEEM " +
	"WITH MEEM FINAL FORMARABIC LIGATURE NOON WITH JEEM WITH HAH FINAL FORMAR" +
	"ABIC LIGATURE JEEM WITH HAH WITH YEH FINAL FORMARABIC LIGATURE HAH WITH " +
	"JEEM WITH YEH FINAL FORMARABIC LIGATURE MEEM WITH JEEM WITH YEH FINAL FO" +
	"RMARABIC LIGATURE FEH WITH MEEM WITH YEH FINAL FORMARABIC LIGATURE BEH W" +
	"ITH HAH WITH YEH FINAL FORMARABIC LIGATURE KAF WITH MEEM WITH MEEM INITI" +
	"AL FORMARABIC LIGATURE AIN WITH JEEM WITH MEEM INITIAL FORMARABIC LIGATU" +
	"RE SAD WITH MEEM WITH MEEM INITIAL FORMARABIC LIGATURE SEEN WITH KHAH WI" +
	"TH YEH FINAL FORMARABIC LIGATURE NOON WITH JEEM WITH YEH FINAL FORMARABI" +
	"C LIGATURE SALLA USED AS KORANIC STOP SIGN ISOLATED FORMARABIC LIGATURE " +
	"QALA USED AS KORANIC STOP SIGN ISOLATED FORMARABIC LIGATURE ALLAH ISOLAT" +
	"ED FORMARABIC LIGATURE AKBAR ISOLATED FORMARABIC LIGATURE MOHAMMAD ISOLA" +
	"TED FORMARABIC LIGATURE SALAM ISOLATED FORMARABIC LIGATURE RASOUL ISOLAT" +
	"ED FORMARABIC LIGATURE ALAYHE ISOLATED FORMARABIC LIGATURE WASALLAM ISOL" +
	"ATED FORMARABIC LIGATURE SALLA ISOLATED FORMARABIC LIGATURE SALLALLAHOU " +
	"ALAYHE WASALLAMARABIC LIGATURE JALLAJALALOUHOURIAL SIGNARABIC LIGATURE B" +
	"ISMILLAH AR-RAHMAN AR-RAHEEMVARIATION SELECTOR-1VARIATION SELECTOR-2VARI" +
	"ATION SELECTOR-3VARIATION SELECTOR-4VARIATION SELECTOR-5VARIATION SELECT" +
	"OR-6VARIATION SELECTOR-7VARIATION SELECTOR-8VARIATION SELECTOR-9VARIATIO" +
	"N SELECTOR-10VARIATION SELECTOR-11VARIATION SELECTOR-12VARIATION SELECTO" +
	"R-13VARIATION SELECTOR-14VARIATION SELECTOR-15VARIATION SELECTOR-16PRESE" +
	"NTATION FORM FOR VERTICAL COMMAPRESENTATION FORM FOR VERTICAL IDEOGRAPHI" +
	"C COMMAPRESENTATION FORM FOR VERTICAL IDEOGRAPHIC FULL STOPPRESENTATION " +
	"FORM FOR VERTICAL COLONPRESENTATION FORM FOR VERTICAL SEMICOLONPRESENTAT" +
	"ION FORM FOR VERTICAL EXCLAMATION MARKPRESENTATION FORM FOR VERTICAL QUE" +
	"STION MARKPRESENTATION FORM FOR VERTICAL LEFT WHITE LENTICULAR BRACKETPR" +
	"ESENTATION FORM FOR VERTICAL RIGHT WHITE LENTICULAR BRAKCETPRESENTATION " +
	"FORM FOR VERTICAL HORIZONTAL ELLIPSISCOMBINING LIGATURE LEFT HALFCOMBINI" +
	"NG LIGATURE RIGHT HALFCOMBINING DOUBLE TILDE LEFT HALFCOMBINING DOUBLE T" +
	"ILDE RIGHT HALFCOMBINING MACRON LEFT HALFCOMBINING MACRON RIGHT HALFCOMB" +
	"INING CONJOINING MACRONCOMBINING LIGATURE LEFT HALF BELOWCOMBINING LIGAT" +
	"URE RIGHT HALF BELOWCOMBINING TILDE LEFT HALF BELOWCOMBINING TILDE RIGHT" +
	" HALF BELOWCOMBINING MACRON LEFT HALF BELOWCOMBINING MACRON RIGHT HALF B" +
	"ELOWCOMBINING CONJOINING MACRON BELOWCOMBINING CYRILLIC TITLO LEFT HALFC" +
	"OMBINING CYRILLIC TITLO RIGHT HALFPRESENTATION FORM FOR VERTICAL TWO DOT" +
	" LEADERPRESENTATION FORM FOR VERTICAL EM DASHPRESENTATION FORM FOR VERTI" +
	"CAL EN DASHPRESENTATION FORM FOR VERTICAL LOW LINEPRESENTATION FORM FOR " +
	"VERTICAL WAVY LOW LINEPRESENTATION FORM FOR VERTICAL LEFT PARENTHESISPRE" +
	"SENTATION FORM FOR VERTICAL RIGHT PARENTHESISPRESENTATION FORM FOR VERTI" +
	"CAL LEFT CURLY BRACKETPRESENTATION FORM FOR VERTICAL RIGHT CURLY BRACKET" +
	"PRESENTATION FORM FOR VERTICAL LEFT TORTOISE SHELL BRACKETPRESENTATION F" +
	"ORM FOR VERTICAL RIGHT TORTOISE SHELL BRACKETPRESENTATION FORM FOR VERTI" +
	"CAL LEFT BLACK LENTICULAR BRACKETPRESENTATION FORM FOR VERTICAL RIGHT BL" +
	"ACK LENTICULAR BRACKETPRESENTATION FORM FOR VERTICAL LEFT DOUBLE ANGLE B" +
	"RACKETPRESENTATION FORM FOR VERTICAL RIGHT DOUBLE ANGLE BRACKETPRESENTAT" +
	"ION FORM FOR VERTICAL LEFT ANGLE BRACKETPRESENTATION FORM FOR VERTICAL R") + ("" +
	"IGHT ANGLE BRACKETPRESENTATION FORM FOR VERTICAL LEFT CORNER BRACKETPRES" +
	"ENTATION FORM FOR VERTICAL RIGHT CORNER BRACKETPRESENTATION FORM FOR VER" +
	"TICAL LEFT WHITE CORNER BRACKETPRESENTATION FORM FOR VERTICAL RIGHT WHIT" +
	"E CORNER BRACKETSESAME DOTWHITE SESAME DOTPRESENTATION FORM FOR VERTICAL" +
	" LEFT SQUARE BRACKETPRESENTATION FORM FOR VERTICAL RIGHT SQUARE BRACKETD" +
	"ASHED OVERLINECENTRELINE OVERLINEWAVY OVERLINEDOUBLE WAVY OVERLINEDASHED" +
	" LOW LINECENTRELINE LOW LINEWAVY LOW LINESMALL COMMASMALL IDEOGRAPHIC CO" +
	"MMASMALL FULL STOPSMALL SEMICOLONSMALL COLONSMALL QUESTION MARKSMALL EXC" +
	"LAMATION MARKSMALL EM DASHSMALL LEFT PARENTHESISSMALL RIGHT PARENTHESISS" +
	"MALL LEFT CURLY BRACKETSMALL RIGHT CURLY BRACKETSMALL LEFT TORTOISE SHEL" +
	"L BRACKETSMALL RIGHT TORTOISE SHELL BRACKETSMALL NUMBER SIGNSMALL AMPERS" +
	"ANDSMALL ASTERISKSMALL PLUS SIGNSMALL HYPHEN-MINUSSMALL LESS-THAN SIGNSM" +
	"ALL GREATER-THAN SIGNSMALL EQUALS SIGNSMALL REVERSE SOLIDUSSMALL DOLLAR " +
	"SIGNSMALL PERCENT SIGNSMALL COMMERCIAL ATARABIC FATHATAN ISOLATED FORMAR" +
	"ABIC TATWEEL WITH FATHATAN ABOVEARABIC DAMMATAN ISOLATED FORMARABIC TAIL" +
	" FRAGMENTARABIC KASRATAN ISOLATED FORMARABIC FATHA ISOLATED FORMARABIC F" +
	"ATHA MEDIAL FORMARABIC DAMMA ISOLATED FORMARABIC DAMMA MEDIAL FORMARABIC" +
	" KASRA ISOLATED FORMARABIC KASRA MEDIAL FORMARABIC SHADDA ISOLATED FORMA" +
	"RABIC SHADDA MEDIAL FORMARABIC SUKUN ISOLATED FORMARABIC SUKUN MEDIAL FO" +
	"RMARABIC LETTER HAMZA ISOLATED FORMARABIC LETTER ALEF WITH MADDA ABOVE I" +
	"SOLATED FORMARABIC LETTER ALEF WITH MADDA ABOVE FINAL FORMARABIC LETTER " +
	"ALEF WITH HAMZA ABOVE ISOLATED FORMARABIC LETTER ALEF WITH HAMZA ABOVE F" +
	"INAL FORMARABIC LETTER WAW WITH HAMZA ABOVE ISOLATED FORMARABIC LETTER W" +
	"AW WITH HAMZA ABOVE FINAL FORMARABIC LETTER ALEF WITH HAMZA BELOW ISOLAT" +
	"ED FORMARABIC LETTER ALEF WITH HAMZA BELOW FINAL FORMARABIC LETTER YEH W" +
	"ITH HAMZA ABOVE ISOLATED FORMARABIC LETTER YEH WITH HAMZA ABOVE FINAL FO" +
	"RMARABIC LETTER YEH WITH HAMZA ABOVE INITIAL FORMARABIC LETTER YEH WITH " +
	"HAMZA ABOVE MEDIAL FORMARABIC LETTER ALEF ISOLATED FORMARABIC LETTER ALE" +
	"F FINAL FORMARABIC LETTER BEH ISOLATED FORMARABIC LETTER BEH FINAL FORMA" +
	"RABIC LETTER BEH INITIAL FORMARABIC LETTER BEH MEDIAL FORMARABIC LETTER " +
	"TEH MARBUTA ISOLATED FORMARABIC LETTER TEH MARBUTA FINAL FORMARABIC LETT" +
	"ER TEH ISOLATED FORMARABIC LETTER TEH FINAL FORMARABIC LETTER TEH INITIA" +
	"L FORMARABIC LETTER TEH MEDIAL FORMARABIC LETTER THEH ISOLATED FORMARABI" +
	"C LETTER THEH FINAL FORMARABIC LETTER THEH INITIAL FORMARABIC LETTER THE" +
	"H MEDIAL FORMARABIC LETTER JEEM ISOLATED FORMARABIC LETTER JEEM FINAL FO" +
	"RMARABIC LETTER JEEM INITIAL FORMARABIC LETTER JEEM MEDIAL FORMARABIC LE" +
	"TTER HAH ISOLATED FORMARABIC LETTER HAH FINAL FORMARABIC LETTER HAH INIT" +
	"IAL FORMARABIC LETTER HAH MEDIAL FORMARABIC LETTER KHAH ISOLATED FORMARA" +
	"BIC LETTER KHAH FINAL FORMARABIC LETTER KHAH INITIAL FORMARABIC LETTER K" +
	"HAH MEDIAL FORMARABIC LETTER DAL ISOLATED FORMARABIC LETTER DAL FINAL FO" +
	"RMARABIC LETTER THAL ISOLATED FORMARABIC LETTER THAL FINAL FORMARABIC LE" +
	"TTER REH ISOLATED FORMARABIC LETTER REH FINAL FORMARABIC LETTER ZAIN ISO" +
	"LATED FORMARABIC LETTER ZAIN FINAL FORMARABIC LETTER SEEN ISOLATED FORMA" +
	"RABIC LETTER SEEN FINAL FORMARABIC LETTER SEEN INITIAL FORMARABIC LETTER" +
	" SEEN MEDIAL FORMARABIC LETTER SHEEN ISOLATED FORMARABIC LETTER SHEEN FI" +
	"NAL FORMARABIC LETTER SHEEN INITIAL FORMARABIC LETTER SHEEN MEDIAL FORMA" +
	"RABIC LETTER SAD ISOLATED FORMARABIC LETTER SAD FINAL FORMARABIC LETTER " +
	"SAD INITIAL FORMARABIC LETTER SAD MEDIAL FORMARABIC LETTER DAD ISOLATED " +
	"FORMARABIC LETTER DAD FINAL FORMARABIC LETTER DAD INITIAL FORMARABIC LET" +
	"TER DAD MEDIAL FORMARABIC LETTER TAH ISOLATED FORMARABIC LETTER TAH FINA" +
	"L FORMARABIC LETTER TAH INITIAL FORMARABIC LETTER TAH MEDIAL FORMARABIC " +
	"LETTER ZAH ISOLATED FORMARABIC LETTER ZAH FINAL FORMARABIC LETTER ZAH IN" +
	"ITIAL FORMARABIC LETTER ZAH MEDIAL FORMARABIC LETTER AIN ISOLATED FORMAR" +
	"ABIC LETTER AIN FINAL FORMARABIC LETTER AIN INITIAL FORMARABIC LETTER AI" +
	"N MEDIAL FORMARABIC LETTER GHAIN ISOLATED FORMARABIC LETTER GHAIN FINAL " +
	"FORMARABIC LETTER GHAIN INITIAL FORMARABIC LETTER GHAIN MEDIAL FORMARABI" +
	"C LETTER FEH ISOLATED FORMARABIC LETTER FEH FINAL FORMARABIC LETTER FEH " +
	"INITIAL FORMARABIC LETTER FEH MEDIAL FORMARABIC LETTER QAF ISOLATED FORM" +
	"ARABIC LETTER QAF FINAL FORMARABIC LETTER QAF INITIAL FORMARABIC LETTER " +
	"QAF MEDIAL FORMARABIC LETTER KAF ISOLATED FORMARABIC LETTER KAF FINAL FO" +
	"RMARABIC LETTER KAF INITIAL FORMARABIC LETTER KAF MEDIAL FORMARABIC LETT" +
	"ER LAM ISOLATED FORMARABIC LETTER LAM FINAL FORMARABIC LETTER LAM INITIA" +
	"L FORMARABIC LETTER LAM MEDIAL FORMARABIC LETTER MEEM ISOLATED FORMARABI" +
	"C LETTER MEEM FINAL FORMARABIC LETTER MEEM INITIAL FORMARABIC LETTER MEE") + ("" +
	"M MEDIAL FORMARABIC LETTER NOON ISOLATED FORMARABIC LETTER NOON FINAL FO" +
	"RMARABIC LETTER NOON INITIAL FORMARABIC LETTER NOON MEDIAL FORMARABIC LE" +
	"TTER HEH ISOLATED FORMARABIC LETTER HEH FINAL FORMARABIC LETTER HEH INIT" +
	"IAL FORMARABIC LETTER HEH MEDIAL FORMARABIC LETTER WAW ISOLATED FORMARAB" +
	"IC LETTER WAW FINAL FORMARABIC LETTER ALEF MAKSURA ISOLATED FORMARABIC L" +
	"ETTER ALEF MAKSURA FINAL FORMARABIC LETTER YEH ISOLATED FORMARABIC LETTE" +
	"R YEH FINAL FORMARABIC LETTER YEH INITIAL FORMARABIC LETTER YEH MEDIAL F" +
	"ORMARABIC LIGATURE LAM WITH ALEF WITH MADDA ABOVE ISOLATED FORMARABIC LI" +
	"GATURE LAM WITH ALEF WITH MADDA ABOVE FINAL FORMARABIC LIGATURE LAM WITH" +
	" ALEF WITH HAMZA ABOVE ISOLATED FORMARABIC LIGATURE LAM WITH ALEF WITH H" +
	"AMZA ABOVE FINAL FORMARABIC LIGATURE LAM WITH ALEF WITH HAMZA BELOW ISOL" +
	"ATED FORMARABIC LIGATURE LAM WITH ALEF WITH HAMZA BELOW FINAL FORMARABIC" +
	" LIGATURE LAM WITH ALEF ISOLATED FORMARABIC LIGATURE LAM WITH ALEF FINAL" +
	" FORMZERO WIDTH NO-BREAK SPACEFULLWIDTH EXCLAMATION MARKFULLWIDTH QUOTAT" +
	"ION MARKFULLWIDTH NUMBER SIGNFULLWIDTH DOLLAR SIGNFULLWIDTH PERCENT SIGN" +
	"FULLWIDTH AMPERSANDFULLWIDTH APOSTROPHEFULLWIDTH LEFT PARENTHESISFULLWID" +
	"TH RIGHT PARENTHESISFULLWIDTH ASTERISKFULLWIDTH PLUS SIGNFULLWIDTH COMMA" +
	"FULLWIDTH HYPHEN-MINUSFULLWIDTH FULL STOPFULLWIDTH SOLIDUSFULLWIDTH DIGI" +
	"T ZEROFULLWIDTH DIGIT ONEFULLWIDTH DIGIT TWOFULLWIDTH DIGIT THREEFULLWID" +
	"TH DIGIT FOURFULLWIDTH DIGIT FIVEFULLWIDTH DIGIT SIXFULLWIDTH DIGIT SEVE" +
	"NFULLWIDTH DIGIT EIGHTFULLWIDTH DIGIT NINEFULLWIDTH COLONFULLWIDTH SEMIC" +
	"OLONFULLWIDTH LESS-THAN SIGNFULLWIDTH EQUALS SIGNFULLWIDTH GREATER-THAN " +
	"SIGNFULLWIDTH QUESTION MARKFULLWIDTH COMMERCIAL ATFULLWIDTH LATIN CAPITA" +
	"L LETTER AFULLWIDTH LATIN CAPITAL LETTER BFULLWIDTH LATIN CAPITAL LETTER" +
	" CFULLWIDTH LATIN CAPITAL LETTER DFULLWIDTH LATIN CAPITAL LETTER EFULLWI" +
	"DTH LATIN CAPITAL LETTER FFULLWIDTH LATIN CAPITAL LETTER GFULLWIDTH LATI" +
	"N CAPITAL LETTER HFULLWIDTH LATIN CAPITAL LETTER IFULLWIDTH LATIN CAPITA" +
	"L LETTER JFULLWIDTH LATIN CAPITAL LETTER KFULLWIDTH LATIN CAPITAL LETTER" +
	" LFULLWIDTH LATIN CAPITAL LETTER MFULLWIDTH LATIN CAPITAL LETTER NFULLWI" +
	"DTH LATIN CAPITAL LETTER OFULLWIDTH LATIN CAPITAL LETTER PFULLWIDTH LATI" +
	"N CAPITAL LETTER QFULLWIDTH LATIN CAPITAL LETTER RFULLWIDTH LATIN CAPITA" +
	"L LETTER SFULLWIDTH LATIN CAPITAL LETTER TFULLWIDTH LATIN CAPITAL LETTER" +
	" UFULLWIDTH LATIN CAPITAL LETTER VFULLWIDTH LATIN CAPITAL LETTER WFULLWI" +
	"DTH LATIN CAPITAL LETTER XFULLWIDTH LATIN CAPITAL LETTER YFULLWIDTH LATI" +
	"N CAPITAL LETTER ZFULLWIDTH LEFT SQUARE BRACKETFULLWIDTH REVERSE SOLIDUS" +
	"FULLWIDTH RIGHT SQUARE BRACKETFULLWIDTH CIRCUMFLEX ACCENTFULLWIDTH LOW L" +
	"INEFULLWIDTH GRAVE ACCENTFULLWIDTH LATIN SMALL LETTER AFULLWIDTH LATIN S" +
	"MALL LETTER BFULLWIDTH LATIN SMALL LETTER CFULLWIDTH LATIN SMALL LETTER " +
	"DFULLWIDTH LATIN SMALL LETTER EFULLWIDTH LATIN SMALL LETTER FFULLWIDTH L" +
	"ATIN SMALL LETTER GFULLWIDTH LATIN SMALL LETTER HFULLWIDTH LATIN SMALL L" +
	"ETTER IFULLWIDTH LATIN SMALL LETTER JFULLWIDTH LATIN SMALL LETTER KFULLW" +
	"IDTH LATIN SMALL LETTER LFULLWIDTH LATIN SMALL LETTER MFULLWIDTH LATIN S" +
	"MALL LETTER NFULLWIDTH LATIN SMALL LETTER OFULLWIDTH LATIN SMALL LETTER " +
	"PFULLWIDTH LATIN SMALL LETTER QFULLWIDTH LATIN SMALL LETTER RFULLWIDTH L" +
	"ATIN SMALL LETTER SFULLWIDTH LATIN SMALL LETTER TFULLWIDTH LATIN SMALL L" +
	"ETTER UFULLWIDTH LATIN SMALL LETTER VFULLWIDTH LATIN SMALL LETTER WFULLW" +
	"IDTH LATIN SMALL LETTER XFULLWIDTH LATIN SMALL LETTER YFULLWIDTH LATIN S" +
	"MALL LETTER ZFULLWIDTH LEFT CURLY BRACKETFULLWIDTH VERTICAL LINEFULLWIDT" +
	"H RIGHT CURLY BRACKETFULLWIDTH TILDEFULLWIDTH LEFT WHITE PARENTHESISFULL" +
	"WIDTH RIGHT WHITE PARENTHESISHALFWIDTH IDEOGRAPHIC FULL STOPHALFWIDTH LE" +
	"FT CORNER BRACKETHALFWIDTH RIGHT CORNER BRACKETHALFWIDTH IDEOGRAPHIC COM" +
	"MAHALFWIDTH KATAKANA MIDDLE DOTHALFWIDTH KATAKANA LETTER WOHALFWIDTH KAT" +
	"AKANA LETTER SMALL AHALFWIDTH KATAKANA LETTER SMALL IHALFWIDTH KATAKANA " +
	"LETTER SMALL UHALFWIDTH KATAKANA LETTER SMALL EHALFWIDTH KATAKANA LETTER" +
	" SMALL OHALFWIDTH KATAKANA LETTER SMALL YAHALFWIDTH KATAKANA LETTER SMAL" +
	"L YUHALFWIDTH KATAKANA LETTER SMALL YOHALFWIDTH KATAKANA LETTER SMALL TU" +
	"HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARKHALFWIDTH KATAKANA LETTE" +
	"R AHALFWIDTH KATAKANA LETTER IHALFWIDTH KATAKANA LETTER UHALFWIDTH KATAK" +
	"ANA LETTER EHALFWIDTH KATAKANA LETTER OHALFWIDTH KATAKANA LETTER KAHALFW" +
	"IDTH KATAKANA LETTER KIHALFWIDTH KATAKANA LETTER KUHALFWIDTH KATAKANA LE" +
	"TTER KEHALFWIDTH KATAKANA LETTER KOHALFWIDTH KATAKANA LETTER SAHALFWIDTH" +
	" KATAKANA LETTER SIHALFWIDTH KATAKANA LETTER SUHALFWIDTH KATAKANA LETTER" +
	" SEHALFWIDTH KATAKANA LETTER SOHALFWIDTH KATAKANA LETTER TAHALFWIDTH KAT" +
	"AKANA LETTER TIHALFWIDTH KATAKANA LETTER TUHALFWIDTH KATAKANA LETTER TEH") + ("" +
	"ALFWIDTH KATAKANA LETTER TOHALFWIDTH KATAKANA LETTER NAHALFWIDTH KATAKAN" +
	"A LETTER NIHALFWIDTH KATAKANA LETTER NUHALFWIDTH KATAKANA LETTER NEHALFW" +
	"IDTH KATAKANA LETTER NOHALFWIDTH KATAKANA LETTER HAHALFWIDTH KATAKANA LE" +
	"TTER HIHALFWIDTH KATAKANA LETTER HUHALFWIDTH KATAKANA LETTER HEHALFWIDTH" +
	" KATAKANA LETTER HOHALFWIDTH KATAKANA LETTER MAHALFWIDTH KATAKANA LETTER" +
	" MIHALFWIDTH KATAKANA LETTER MUHALFWIDTH KATAKANA LETTER MEHALFWIDTH KAT" +
	"AKANA LETTER MOHALFWIDTH KATAKANA LETTER YAHALFWIDTH KATAKANA LETTER YUH" +
	"ALFWIDTH KATAKANA LETTER YOHALFWIDTH KATAKANA LETTER RAHALFWIDTH KATAKAN" +
	"A LETTER RIHALFWIDTH KATAKANA LETTER RUHALFWIDTH KATAKANA LETTER REHALFW" +
	"IDTH KATAKANA LETTER ROHALFWIDTH KATAKANA LETTER WAHALFWIDTH KATAKANA LE" +
	"TTER NHALFWIDTH KATAKANA VOICED SOUND MARKHALFWIDTH KATAKANA SEMI-VOICED" +
	" SOUND MARKHALFWIDTH HANGUL FILLERHALFWIDTH HANGUL LETTER KIYEOKHALFWIDT" +
	"H HANGUL LETTER SSANGKIYEOKHALFWIDTH HANGUL LETTER KIYEOK-SIOSHALFWIDTH " +
	"HANGUL LETTER NIEUNHALFWIDTH HANGUL LETTER NIEUN-CIEUCHALFWIDTH HANGUL L" +
	"ETTER NIEUN-HIEUHHALFWIDTH HANGUL LETTER TIKEUTHALFWIDTH HANGUL LETTER S" +
	"SANGTIKEUTHALFWIDTH HANGUL LETTER RIEULHALFWIDTH HANGUL LETTER RIEUL-KIY" +
	"EOKHALFWIDTH HANGUL LETTER RIEUL-MIEUMHALFWIDTH HANGUL LETTER RIEUL-PIEU" +
	"PHALFWIDTH HANGUL LETTER RIEUL-SIOSHALFWIDTH HANGUL LETTER RIEUL-THIEUTH" +
	"HALFWIDTH HANGUL LETTER RIEUL-PHIEUPHHALFWIDTH HANGUL LETTER RIEUL-HIEUH" +
	"HALFWIDTH HANGUL LETTER MIEUMHALFWIDTH HANGUL LETTER PIEUPHALFWIDTH HANG" +
	"UL LETTER SSANGPIEUPHALFWIDTH HANGUL LETTER PIEUP-SIOSHALFWIDTH HANGUL L" +
	"ETTER SIOSHALFWIDTH HANGUL LETTER SSANGSIOSHALFWIDTH HANGUL LETTER IEUNG" +
	"HALFWIDTH HANGUL LETTER CIEUCHALFWIDTH HANGUL LETTER SSANGCIEUCHALFWIDTH" +
	" HANGUL LETTER CHIEUCHHALFWIDTH HANGUL LETTER KHIEUKHHALFWIDTH HANGUL LE" +
	"TTER THIEUTHHALFWIDTH HANGUL LETTER PHIEUPHHALFWIDTH HANGUL LETTER HIEUH" +
	"HALFWIDTH HANGUL LETTER AHALFWIDTH HANGUL LETTER AEHALFWIDTH HANGUL LETT" +
	"ER YAHALFWIDTH HANGUL LETTER YAEHALFWIDTH HANGUL LETTER EOHALFWIDTH HANG" +
	"UL LETTER EHALFWIDTH HANGUL LETTER YEOHALFWIDTH HANGUL LETTER YEHALFWIDT" +
	"H HANGUL LETTER OHALFWIDTH HANGUL LETTER WAHALFWIDTH HANGUL LETTER WAEHA" +
	"LFWIDTH HANGUL LETTER OEHALFWIDTH HANGUL LETTER YOHALFWIDTH HANGUL LETTE" +
	"R UHALFWIDTH HANGUL LETTER WEOHALFWIDTH HANGUL LETTER WEHALFWIDTH HANGUL" +
	" LETTER WIHALFWIDTH HANGUL LETTER YUHALFWIDTH HANGUL LETTER EUHALFWIDTH " +
	"HANGUL LETTER YIHALFWIDTH HANGUL LETTER IFULLWIDTH CENT SIGNFULLWIDTH PO" +
	"UND SIGNFULLWIDTH NOT SIGNFULLWIDTH MACRONFULLWIDTH BROKEN BARFULLWIDTH " +
	"YEN SIGNFULLWIDTH WON SIGNHALFWIDTH FORMS LIGHT VERTICALHALFWIDTH LEFTWA" +
	"RDS ARROWHALFWIDTH UPWARDS ARROWHALFWIDTH RIGHTWARDS ARROWHALFWIDTH DOWN" +
	"WARDS ARROWHALFWIDTH BLACK SQUAREHALFWIDTH WHITE CIRCLEINTERLINEAR ANNOT" +
	"ATION ANCHORINTERLINEAR ANNOTATION SEPARATORINTERLINEAR ANNOTATION TERMI" +
	"NATOROBJECT REPLACEMENT CHARACTERREPLACEMENT CHARACTERLINEAR B SYLLABLE " +
	"B008 ALINEAR B SYLLABLE B038 ELINEAR B SYLLABLE B028 ILINEAR B SYLLABLE " +
	"B061 OLINEAR B SYLLABLE B010 ULINEAR B SYLLABLE B001 DALINEAR B SYLLABLE" +
	" B045 DELINEAR B SYLLABLE B007 DILINEAR B SYLLABLE B014 DOLINEAR B SYLLA" +
	"BLE B051 DULINEAR B SYLLABLE B057 JALINEAR B SYLLABLE B046 JELINEAR B SY" +
	"LLABLE B036 JOLINEAR B SYLLABLE B065 JULINEAR B SYLLABLE B077 KALINEAR B" +
	" SYLLABLE B044 KELINEAR B SYLLABLE B067 KILINEAR B SYLLABLE B070 KOLINEA" +
	"R B SYLLABLE B081 KULINEAR B SYLLABLE B080 MALINEAR B SYLLABLE B013 MELI" +
	"NEAR B SYLLABLE B073 MILINEAR B SYLLABLE B015 MOLINEAR B SYLLABLE B023 M" +
	"ULINEAR B SYLLABLE B006 NALINEAR B SYLLABLE B024 NELINEAR B SYLLABLE B03" +
	"0 NILINEAR B SYLLABLE B052 NOLINEAR B SYLLABLE B055 NULINEAR B SYLLABLE " +
	"B003 PALINEAR B SYLLABLE B072 PELINEAR B SYLLABLE B039 PILINEAR B SYLLAB" +
	"LE B011 POLINEAR B SYLLABLE B050 PULINEAR B SYLLABLE B016 QALINEAR B SYL" +
	"LABLE B078 QELINEAR B SYLLABLE B021 QILINEAR B SYLLABLE B032 QOLINEAR B " +
	"SYLLABLE B060 RALINEAR B SYLLABLE B027 RELINEAR B SYLLABLE B053 RILINEAR" +
	" B SYLLABLE B002 ROLINEAR B SYLLABLE B026 RULINEAR B SYLLABLE B031 SALIN" +
	"EAR B SYLLABLE B009 SELINEAR B SYLLABLE B041 SILINEAR B SYLLABLE B012 SO" +
	"LINEAR B SYLLABLE B058 SULINEAR B SYLLABLE B059 TALINEAR B SYLLABLE B004" +
	" TELINEAR B SYLLABLE B037 TILINEAR B SYLLABLE B005 TOLINEAR B SYLLABLE B" +
	"069 TULINEAR B SYLLABLE B054 WALINEAR B SYLLABLE B075 WELINEAR B SYLLABL" +
	"E B040 WILINEAR B SYLLABLE B042 WOLINEAR B SYLLABLE B017 ZALINEAR B SYLL" +
	"ABLE B074 ZELINEAR B SYLLABLE B020 ZOLINEAR B SYLLABLE B025 A2LINEAR B S" +
	"YLLABLE B043 A3LINEAR B SYLLABLE B085 AULINEAR B SYLLABLE B071 DWELINEAR" +
	" B SYLLABLE B090 DWOLINEAR B SYLLABLE B048 NWALINEAR B SYLLABLE B029 PU2" +
	"LINEAR B SYLLABLE B062 PTELINEAR B SYLLABLE B076 RA2LINEAR B SYLLABLE B0" +
	"33 RA3LINEAR B SYLLABLE B068 RO2LINEAR B SYLLABLE B066 TA2LINEAR B SYLLA") + ("" +
	"BLE B087 TWELINEAR B SYLLABLE B091 TWOLINEAR B SYMBOL B018LINEAR B SYMBO" +
	"L B019LINEAR B SYMBOL B022LINEAR B SYMBOL B034LINEAR B SYMBOL B047LINEAR" +
	" B SYMBOL B049LINEAR B SYMBOL B056LINEAR B SYMBOL B063LINEAR B SYMBOL B0" +
	"64LINEAR B SYMBOL B079LINEAR B SYMBOL B082LINEAR B SYMBOL B083LINEAR B S" +
	"YMBOL B086LINEAR B SYMBOL B089LINEAR B IDEOGRAM B100 MANLINEAR B IDEOGRA" +
	"M B102 WOMANLINEAR B IDEOGRAM B104 DEERLINEAR B IDEOGRAM B105 EQUIDLINEA" +
	"R B IDEOGRAM B105F MARELINEAR B IDEOGRAM B105M STALLIONLINEAR B IDEOGRAM" +
	" B106F EWELINEAR B IDEOGRAM B106M RAMLINEAR B IDEOGRAM B107F SHE-GOATLIN" +
	"EAR B IDEOGRAM B107M HE-GOATLINEAR B IDEOGRAM B108F SOWLINEAR B IDEOGRAM" +
	" B108M BOARLINEAR B IDEOGRAM B109F COWLINEAR B IDEOGRAM B109M BULLLINEAR" +
	" B IDEOGRAM B120 WHEATLINEAR B IDEOGRAM B121 BARLEYLINEAR B IDEOGRAM B12" +
	"2 OLIVELINEAR B IDEOGRAM B123 SPICELINEAR B IDEOGRAM B125 CYPERUSLINEAR " +
	"B MONOGRAM B127 KAPOLINEAR B MONOGRAM B128 KANAKOLINEAR B IDEOGRAM B130 " +
	"OILLINEAR B IDEOGRAM B131 WINELINEAR B IDEOGRAM B132LINEAR B MONOGRAM B1" +
	"33 AREPALINEAR B MONOGRAM B135 MERILINEAR B IDEOGRAM B140 BRONZELINEAR B" +
	" IDEOGRAM B141 GOLDLINEAR B IDEOGRAM B142LINEAR B IDEOGRAM B145 WOOLLINE" +
	"AR B IDEOGRAM B146LINEAR B IDEOGRAM B150LINEAR B IDEOGRAM B151 HORNLINEA" +
	"R B IDEOGRAM B152LINEAR B IDEOGRAM B153LINEAR B IDEOGRAM B154LINEAR B MO" +
	"NOGRAM B156 TURO2LINEAR B IDEOGRAM B157LINEAR B IDEOGRAM B158LINEAR B ID" +
	"EOGRAM B159 CLOTHLINEAR B IDEOGRAM B160LINEAR B IDEOGRAM B161LINEAR B ID" +
	"EOGRAM B162 GARMENTLINEAR B IDEOGRAM B163 ARMOURLINEAR B IDEOGRAM B164LI" +
	"NEAR B IDEOGRAM B165LINEAR B IDEOGRAM B166LINEAR B IDEOGRAM B167LINEAR B" +
	" IDEOGRAM B168LINEAR B IDEOGRAM B169LINEAR B IDEOGRAM B170LINEAR B IDEOG" +
	"RAM B171LINEAR B IDEOGRAM B172LINEAR B IDEOGRAM B173 MONTHLINEAR B IDEOG" +
	"RAM B174LINEAR B IDEOGRAM B176 TREELINEAR B IDEOGRAM B177LINEAR B IDEOGR" +
	"AM B178LINEAR B IDEOGRAM B179LINEAR B IDEOGRAM B180LINEAR B IDEOGRAM B18" +
	"1LINEAR B IDEOGRAM B182LINEAR B IDEOGRAM B183LINEAR B IDEOGRAM B184LINEA" +
	"R B IDEOGRAM B185LINEAR B IDEOGRAM B189LINEAR B IDEOGRAM B190LINEAR B ID" +
	"EOGRAM B191 HELMETLINEAR B IDEOGRAM B220 FOOTSTOOLLINEAR B IDEOGRAM B225" +
	" BATHTUBLINEAR B IDEOGRAM B230 SPEARLINEAR B IDEOGRAM B231 ARROWLINEAR B" +
	" IDEOGRAM B232LINEAR B IDEOGRAM B233 SWORDLINEAR B IDEOGRAM B234LINEAR B" +
	" IDEOGRAM B236LINEAR B IDEOGRAM B240 WHEELED CHARIOTLINEAR B IDEOGRAM B2" +
	"41 CHARIOTLINEAR B IDEOGRAM B242 CHARIOT FRAMELINEAR B IDEOGRAM B243 WHE" +
	"ELLINEAR B IDEOGRAM B245LINEAR B IDEOGRAM B246LINEAR B MONOGRAM B247 DIP" +
	"TELINEAR B IDEOGRAM B248LINEAR B IDEOGRAM B249LINEAR B IDEOGRAM B251LINE" +
	"AR B IDEOGRAM B252LINEAR B IDEOGRAM B253LINEAR B IDEOGRAM B254 DARTLINEA" +
	"R B IDEOGRAM B255LINEAR B IDEOGRAM B256LINEAR B IDEOGRAM B257LINEAR B ID" +
	"EOGRAM B258LINEAR B IDEOGRAM B259LINEAR B IDEOGRAM VESSEL B155LINEAR B I" +
	"DEOGRAM VESSEL B200LINEAR B IDEOGRAM VESSEL B201LINEAR B IDEOGRAM VESSEL" +
	" B202LINEAR B IDEOGRAM VESSEL B203LINEAR B IDEOGRAM VESSEL B204LINEAR B " +
	"IDEOGRAM VESSEL B205LINEAR B IDEOGRAM VESSEL B206LINEAR B IDEOGRAM VESSE" +
	"L B207LINEAR B IDEOGRAM VESSEL B208LINEAR B IDEOGRAM VESSEL B209LINEAR B" +
	" IDEOGRAM VESSEL B210LINEAR B IDEOGRAM VESSEL B211LINEAR B IDEOGRAM VESS" +
	"EL B212LINEAR B IDEOGRAM VESSEL B213LINEAR B IDEOGRAM VESSEL B214LINEAR " +
	"B IDEOGRAM VESSEL B215LINEAR B IDEOGRAM VESSEL B216LINEAR B IDEOGRAM VES" +
	"SEL B217LINEAR B IDEOGRAM VESSEL B218LINEAR B IDEOGRAM VESSEL B219LINEAR" +
	" B IDEOGRAM VESSEL B221LINEAR B IDEOGRAM VESSEL B222LINEAR B IDEOGRAM VE" +
	"SSEL B226LINEAR B IDEOGRAM VESSEL B227LINEAR B IDEOGRAM VESSEL B228LINEA" +
	"R B IDEOGRAM VESSEL B229LINEAR B IDEOGRAM VESSEL B250LINEAR B IDEOGRAM V" +
	"ESSEL B305AEGEAN WORD SEPARATOR LINEAEGEAN WORD SEPARATOR DOTAEGEAN CHEC" +
	"K MARKAEGEAN NUMBER ONEAEGEAN NUMBER TWOAEGEAN NUMBER THREEAEGEAN NUMBER" +
	" FOURAEGEAN NUMBER FIVEAEGEAN NUMBER SIXAEGEAN NUMBER SEVENAEGEAN NUMBER" +
	" EIGHTAEGEAN NUMBER NINEAEGEAN NUMBER TENAEGEAN NUMBER TWENTYAEGEAN NUMB" +
	"ER THIRTYAEGEAN NUMBER FORTYAEGEAN NUMBER FIFTYAEGEAN NUMBER SIXTYAEGEAN" +
	" NUMBER SEVENTYAEGEAN NUMBER EIGHTYAEGEAN NUMBER NINETYAEGEAN NUMBER ONE" +
	" HUNDREDAEGEAN NUMBER TWO HUNDREDAEGEAN NUMBER THREE HUNDREDAEGEAN NUMBE" +
	"R FOUR HUNDREDAEGEAN NUMBER FIVE HUNDREDAEGEAN NUMBER SIX HUNDREDAEGEAN " +
	"NUMBER SEVEN HUNDREDAEGEAN NUMBER EIGHT HUNDREDAEGEAN NUMBER NINE HUNDRE" +
	"DAEGEAN NUMBER ONE THOUSANDAEGEAN NUMBER TWO THOUSANDAEGEAN NUMBER THREE" +
	" THOUSANDAEGEAN NUMBER FOUR THOUSANDAEGEAN NUMBER FIVE THOUSANDAEGEAN NU" +
	"MBER SIX THOUSANDAEGEAN NUMBER SEVEN THOUSANDAEGEAN NUMBER EIGHT THOUSAN" +
	"DAEGEAN NUMBER NINE THOUSANDAEGEAN NUMBER TEN THOUSANDAEGEAN NUMBER TWEN" +
	"TY THOUSANDAEGEAN NUMBER THIRTY THOUSANDAEGEAN NUMBER FORTY THOUSANDAEGE" +
	"AN NUMBER FIFTY THOUSANDAEGEAN NUMBER SIXTY THOUSANDAEGEAN NUMBER SEVENT") + ("" +
	"Y THOUSANDAEGEAN NUMBER EIGHTY THOUSANDAEGEAN NUMBER NINETY THOUSANDAEGE" +
	"AN WEIGHT BASE UNITAEGEAN WEIGHT FIRST SUBUNITAEGEAN WEIGHT SECOND SUBUN" +
	"ITAEGEAN WEIGHT THIRD SUBUNITAEGEAN WEIGHT FOURTH SUBUNITAEGEAN DRY MEAS" +
	"URE FIRST SUBUNITAEGEAN LIQUID MEASURE FIRST SUBUNITAEGEAN MEASURE SECON" +
	"D SUBUNITAEGEAN MEASURE THIRD SUBUNITGREEK ACROPHONIC ATTIC ONE QUARTERG" +
	"REEK ACROPHONIC ATTIC ONE HALFGREEK ACROPHONIC ATTIC ONE DRACHMAGREEK AC" +
	"ROPHONIC ATTIC FIVEGREEK ACROPHONIC ATTIC FIFTYGREEK ACROPHONIC ATTIC FI" +
	"VE HUNDREDGREEK ACROPHONIC ATTIC FIVE THOUSANDGREEK ACROPHONIC ATTIC FIF" +
	"TY THOUSANDGREEK ACROPHONIC ATTIC FIVE TALENTSGREEK ACROPHONIC ATTIC TEN" +
	" TALENTSGREEK ACROPHONIC ATTIC FIFTY TALENTSGREEK ACROPHONIC ATTIC ONE H" +
	"UNDRED TALENTSGREEK ACROPHONIC ATTIC FIVE HUNDRED TALENTSGREEK ACROPHONI" +
	"C ATTIC ONE THOUSAND TALENTSGREEK ACROPHONIC ATTIC FIVE THOUSAND TALENTS" +
	"GREEK ACROPHONIC ATTIC FIVE STATERSGREEK ACROPHONIC ATTIC TEN STATERSGRE" +
	"EK ACROPHONIC ATTIC FIFTY STATERSGREEK ACROPHONIC ATTIC ONE HUNDRED STAT" +
	"ERSGREEK ACROPHONIC ATTIC FIVE HUNDRED STATERSGREEK ACROPHONIC ATTIC ONE" +
	" THOUSAND STATERSGREEK ACROPHONIC ATTIC TEN THOUSAND STATERSGREEK ACROPH" +
	"ONIC ATTIC FIFTY THOUSAND STATERSGREEK ACROPHONIC ATTIC TEN MNASGREEK AC" +
	"ROPHONIC HERAEUM ONE PLETHRONGREEK ACROPHONIC THESPIAN ONEGREEK ACROPHON" +
	"IC HERMIONIAN ONEGREEK ACROPHONIC EPIDAUREAN TWOGREEK ACROPHONIC THESPIA" +
	"N TWOGREEK ACROPHONIC CYRENAIC TWO DRACHMASGREEK ACROPHONIC EPIDAUREAN T" +
	"WO DRACHMASGREEK ACROPHONIC TROEZENIAN FIVEGREEK ACROPHONIC TROEZENIAN T" +
	"ENGREEK ACROPHONIC TROEZENIAN TEN ALTERNATE FORMGREEK ACROPHONIC HERMION" +
	"IAN TENGREEK ACROPHONIC MESSENIAN TENGREEK ACROPHONIC THESPIAN TENGREEK " +
	"ACROPHONIC THESPIAN THIRTYGREEK ACROPHONIC TROEZENIAN FIFTYGREEK ACROPHO" +
	"NIC TROEZENIAN FIFTY ALTERNATE FORMGREEK ACROPHONIC HERMIONIAN FIFTYGREE" +
	"K ACROPHONIC THESPIAN FIFTYGREEK ACROPHONIC THESPIAN ONE HUNDREDGREEK AC" +
	"ROPHONIC THESPIAN THREE HUNDREDGREEK ACROPHONIC EPIDAUREAN FIVE HUNDREDG" +
	"REEK ACROPHONIC TROEZENIAN FIVE HUNDREDGREEK ACROPHONIC THESPIAN FIVE HU" +
	"NDREDGREEK ACROPHONIC CARYSTIAN FIVE HUNDREDGREEK ACROPHONIC NAXIAN FIVE" +
	" HUNDREDGREEK ACROPHONIC THESPIAN ONE THOUSANDGREEK ACROPHONIC THESPIAN " +
	"FIVE THOUSANDGREEK ACROPHONIC DELPHIC FIVE MNASGREEK ACROPHONIC STRATIAN" +
	" FIFTY MNASGREEK ONE HALF SIGNGREEK ONE HALF SIGN ALTERNATE FORMGREEK TW" +
	"O THIRDS SIGNGREEK THREE QUARTERS SIGNGREEK YEAR SIGNGREEK TALENT SIGNGR" +
	"EEK DRACHMA SIGNGREEK OBOL SIGNGREEK TWO OBOLS SIGNGREEK THREE OBOLS SIG" +
	"NGREEK FOUR OBOLS SIGNGREEK FIVE OBOLS SIGNGREEK METRETES SIGNGREEK KYAT" +
	"HOS BASE SIGNGREEK LITRA SIGNGREEK OUNKIA SIGNGREEK XESTES SIGNGREEK ART" +
	"ABE SIGNGREEK AROURA SIGNGREEK GRAMMA SIGNGREEK TRYBLION BASE SIGNGREEK " +
	"ZERO SIGNGREEK ONE QUARTER SIGNGREEK SINUSOID SIGNGREEK INDICTION SIGNNO" +
	"MISMA SIGNROMAN SEXTANS SIGNROMAN UNCIA SIGNROMAN SEMUNCIA SIGNROMAN SEX" +
	"TULA SIGNROMAN DIMIDIA SEXTULA SIGNROMAN SILIQUA SIGNROMAN DENARIUS SIGN" +
	"ROMAN QUINARIUS SIGNROMAN SESTERTIUS SIGNROMAN DUPONDIUS SIGNROMAN AS SI" +
	"GNROMAN CENTURIAL SIGNGREEK SYMBOL TAU RHOPHAISTOS DISC SIGN PEDESTRIANP" +
	"HAISTOS DISC SIGN PLUMED HEADPHAISTOS DISC SIGN TATTOOED HEADPHAISTOS DI" +
	"SC SIGN CAPTIVEPHAISTOS DISC SIGN CHILDPHAISTOS DISC SIGN WOMANPHAISTOS " +
	"DISC SIGN HELMETPHAISTOS DISC SIGN GAUNTLETPHAISTOS DISC SIGN TIARAPHAIS" +
	"TOS DISC SIGN ARROWPHAISTOS DISC SIGN BOWPHAISTOS DISC SIGN SHIELDPHAIST" +
	"OS DISC SIGN CLUBPHAISTOS DISC SIGN MANACLESPHAISTOS DISC SIGN MATTOCKPH" +
	"AISTOS DISC SIGN SAWPHAISTOS DISC SIGN LIDPHAISTOS DISC SIGN BOOMERANGPH" +
	"AISTOS DISC SIGN CARPENTRY PLANEPHAISTOS DISC SIGN DOLIUMPHAISTOS DISC S" +
	"IGN COMBPHAISTOS DISC SIGN SLINGPHAISTOS DISC SIGN COLUMNPHAISTOS DISC S" +
	"IGN BEEHIVEPHAISTOS DISC SIGN SHIPPHAISTOS DISC SIGN HORNPHAISTOS DISC S" +
	"IGN HIDEPHAISTOS DISC SIGN BULLS LEGPHAISTOS DISC SIGN CATPHAISTOS DISC " +
	"SIGN RAMPHAISTOS DISC SIGN EAGLEPHAISTOS DISC SIGN DOVEPHAISTOS DISC SIG" +
	"N TUNNYPHAISTOS DISC SIGN BEEPHAISTOS DISC SIGN PLANE TREEPHAISTOS DISC " +
	"SIGN VINEPHAISTOS DISC SIGN PAPYRUSPHAISTOS DISC SIGN ROSETTEPHAISTOS DI" +
	"SC SIGN LILYPHAISTOS DISC SIGN OX BACKPHAISTOS DISC SIGN FLUTEPHAISTOS D" +
	"ISC SIGN GRATERPHAISTOS DISC SIGN STRAINERPHAISTOS DISC SIGN SMALL AXEPH" +
	"AISTOS DISC SIGN WAVY BANDPHAISTOS DISC SIGN COMBINING OBLIQUE STROKELYC" +
	"IAN LETTER ALYCIAN LETTER ELYCIAN LETTER BLYCIAN LETTER BHLYCIAN LETTER " +
	"GLYCIAN LETTER DLYCIAN LETTER ILYCIAN LETTER WLYCIAN LETTER ZLYCIAN LETT" +
	"ER THLYCIAN LETTER JLYCIAN LETTER KLYCIAN LETTER QLYCIAN LETTER LLYCIAN " +
	"LETTER MLYCIAN LETTER NLYCIAN LETTER MMLYCIAN LETTER NNLYCIAN LETTER ULY" +
	"CIAN LETTER PLYCIAN LETTER KKLYCIAN LETTER RLYCIAN LETTER SLYCIAN LETTER" +
	" TLYCIAN LETTER TTLYCIAN LETTER ANLYCIAN LETTER ENLYCIAN LETTER HLYCIAN ") + ("" +
	"LETTER XCARIAN LETTER ACARIAN LETTER P2CARIAN LETTER DCARIAN LETTER LCAR" +
	"IAN LETTER UUUCARIAN LETTER RCARIAN LETTER LDCARIAN LETTER A2CARIAN LETT" +
	"ER QCARIAN LETTER BCARIAN LETTER MCARIAN LETTER OCARIAN LETTER D2CARIAN " +
	"LETTER TCARIAN LETTER SHCARIAN LETTER SH2CARIAN LETTER SCARIAN LETTER C-" +
	"18CARIAN LETTER UCARIAN LETTER NNCARIAN LETTER XCARIAN LETTER NCARIAN LE" +
	"TTER TT2CARIAN LETTER PCARIAN LETTER SSCARIAN LETTER ICARIAN LETTER ECAR" +
	"IAN LETTER UUUUCARIAN LETTER KCARIAN LETTER K2CARIAN LETTER NDCARIAN LET" +
	"TER UUCARIAN LETTER GCARIAN LETTER G2CARIAN LETTER STCARIAN LETTER ST2CA" +
	"RIAN LETTER NGCARIAN LETTER IICARIAN LETTER C-39CARIAN LETTER TTCARIAN L" +
	"ETTER UUU2CARIAN LETTER RRCARIAN LETTER MBCARIAN LETTER MB2CARIAN LETTER" +
	" MB3CARIAN LETTER MB4CARIAN LETTER LD2CARIAN LETTER E2CARIAN LETTER UUU3" +
	"COPTIC EPACT THOUSANDS MARKCOPTIC EPACT DIGIT ONECOPTIC EPACT DIGIT TWOC" +
	"OPTIC EPACT DIGIT THREECOPTIC EPACT DIGIT FOURCOPTIC EPACT DIGIT FIVECOP" +
	"TIC EPACT DIGIT SIXCOPTIC EPACT DIGIT SEVENCOPTIC EPACT DIGIT EIGHTCOPTI" +
	"C EPACT DIGIT NINECOPTIC EPACT NUMBER TENCOPTIC EPACT NUMBER TWENTYCOPTI" +
	"C EPACT NUMBER THIRTYCOPTIC EPACT NUMBER FORTYCOPTIC EPACT NUMBER FIFTYC" +
	"OPTIC EPACT NUMBER SIXTYCOPTIC EPACT NUMBER SEVENTYCOPTIC EPACT NUMBER E" +
	"IGHTYCOPTIC EPACT NUMBER NINETYCOPTIC EPACT NUMBER ONE HUNDREDCOPTIC EPA" +
	"CT NUMBER TWO HUNDREDCOPTIC EPACT NUMBER THREE HUNDREDCOPTIC EPACT NUMBE" +
	"R FOUR HUNDREDCOPTIC EPACT NUMBER FIVE HUNDREDCOPTIC EPACT NUMBER SIX HU" +
	"NDREDCOPTIC EPACT NUMBER SEVEN HUNDREDCOPTIC EPACT NUMBER EIGHT HUNDREDC" +
	"OPTIC EPACT NUMBER NINE HUNDREDOLD ITALIC LETTER AOLD ITALIC LETTER BEOL" +
	"D ITALIC LETTER KEOLD ITALIC LETTER DEOLD ITALIC LETTER EOLD ITALIC LETT" +
	"ER VEOLD ITALIC LETTER ZEOLD ITALIC LETTER HEOLD ITALIC LETTER THEOLD IT" +
	"ALIC LETTER IOLD ITALIC LETTER KAOLD ITALIC LETTER ELOLD ITALIC LETTER E" +
	"MOLD ITALIC LETTER ENOLD ITALIC LETTER ESHOLD ITALIC LETTER OOLD ITALIC " +
	"LETTER PEOLD ITALIC LETTER SHEOLD ITALIC LETTER KUOLD ITALIC LETTER EROL" +
	"D ITALIC LETTER ESOLD ITALIC LETTER TEOLD ITALIC LETTER UOLD ITALIC LETT" +
	"ER EKSOLD ITALIC LETTER PHEOLD ITALIC LETTER KHEOLD ITALIC LETTER EFOLD " +
	"ITALIC LETTER ERSOLD ITALIC LETTER CHEOLD ITALIC LETTER IIOLD ITALIC LET" +
	"TER UUOLD ITALIC LETTER ESSOLD ITALIC NUMERAL ONEOLD ITALIC NUMERAL FIVE" +
	"OLD ITALIC NUMERAL TENOLD ITALIC NUMERAL FIFTYGOTHIC LETTER AHSAGOTHIC L" +
	"ETTER BAIRKANGOTHIC LETTER GIBAGOTHIC LETTER DAGSGOTHIC LETTER AIHVUSGOT" +
	"HIC LETTER QAIRTHRAGOTHIC LETTER IUJAGOTHIC LETTER HAGLGOTHIC LETTER THI" +
	"UTHGOTHIC LETTER EISGOTHIC LETTER KUSMAGOTHIC LETTER LAGUSGOTHIC LETTER " +
	"MANNAGOTHIC LETTER NAUTHSGOTHIC LETTER JERGOTHIC LETTER URUSGOTHIC LETTE" +
	"R PAIRTHRAGOTHIC LETTER NINETYGOTHIC LETTER RAIDAGOTHIC LETTER SAUILGOTH" +
	"IC LETTER TEIWSGOTHIC LETTER WINJAGOTHIC LETTER FAIHUGOTHIC LETTER IGGWS" +
	"GOTHIC LETTER HWAIRGOTHIC LETTER OTHALGOTHIC LETTER NINE HUNDREDOLD PERM" +
	"IC LETTER ANOLD PERMIC LETTER BUROLD PERMIC LETTER GAIOLD PERMIC LETTER " +
	"DOIOLD PERMIC LETTER EOLD PERMIC LETTER ZHOIOLD PERMIC LETTER DZHOIOLD P" +
	"ERMIC LETTER ZATAOLD PERMIC LETTER DZITAOLD PERMIC LETTER IOLD PERMIC LE" +
	"TTER KOKEOLD PERMIC LETTER LEIOLD PERMIC LETTER MENOEOLD PERMIC LETTER N" +
	"ENOEOLD PERMIC LETTER VOOIOLD PERMIC LETTER PEEIOLD PERMIC LETTER REIOLD" +
	" PERMIC LETTER SIIOLD PERMIC LETTER TAIOLD PERMIC LETTER UOLD PERMIC LET" +
	"TER CHERYOLD PERMIC LETTER SHOOIOLD PERMIC LETTER SHCHOOIOLD PERMIC LETT" +
	"ER YRYOLD PERMIC LETTER YERUOLD PERMIC LETTER OOLD PERMIC LETTER OOOLD P" +
	"ERMIC LETTER EFOLD PERMIC LETTER HAOLD PERMIC LETTER TSIUOLD PERMIC LETT" +
	"ER VEROLD PERMIC LETTER YEROLD PERMIC LETTER YERIOLD PERMIC LETTER YATOL" +
	"D PERMIC LETTER IEOLD PERMIC LETTER YUOLD PERMIC LETTER YAOLD PERMIC LET" +
	"TER IACOMBINING OLD PERMIC LETTER ANCOMBINING OLD PERMIC LETTER DOICOMBI" +
	"NING OLD PERMIC LETTER ZATACOMBINING OLD PERMIC LETTER NENOECOMBINING OL" +
	"D PERMIC LETTER SIIUGARITIC LETTER ALPAUGARITIC LETTER BETAUGARITIC LETT" +
	"ER GAMLAUGARITIC LETTER KHAUGARITIC LETTER DELTAUGARITIC LETTER HOUGARIT" +
	"IC LETTER WOUGARITIC LETTER ZETAUGARITIC LETTER HOTAUGARITIC LETTER TETU" +
	"GARITIC LETTER YODUGARITIC LETTER KAFUGARITIC LETTER SHINUGARITIC LETTER" +
	" LAMDAUGARITIC LETTER MEMUGARITIC LETTER DHALUGARITIC LETTER NUNUGARITIC" +
	" LETTER ZUUGARITIC LETTER SAMKAUGARITIC LETTER AINUGARITIC LETTER PUUGAR" +
	"ITIC LETTER SADEUGARITIC LETTER QOPAUGARITIC LETTER RASHAUGARITIC LETTER" +
	" THANNAUGARITIC LETTER GHAINUGARITIC LETTER TOUGARITIC LETTER IUGARITIC " +
	"LETTER UUGARITIC LETTER SSUUGARITIC WORD DIVIDEROLD PERSIAN SIGN AOLD PE" +
	"RSIAN SIGN IOLD PERSIAN SIGN UOLD PERSIAN SIGN KAOLD PERSIAN SIGN KUOLD " +
	"PERSIAN SIGN GAOLD PERSIAN SIGN GUOLD PERSIAN SIGN XAOLD PERSIAN SIGN CA" +
	"OLD PERSIAN SIGN JAOLD PERSIAN SIGN JIOLD PERSIAN SIGN TAOLD PERSIAN SIG") + ("" +
	"N TUOLD PERSIAN SIGN DAOLD PERSIAN SIGN DIOLD PERSIAN SIGN DUOLD PERSIAN" +
	" SIGN THAOLD PERSIAN SIGN PAOLD PERSIAN SIGN BAOLD PERSIAN SIGN FAOLD PE" +
	"RSIAN SIGN NAOLD PERSIAN SIGN NUOLD PERSIAN SIGN MAOLD PERSIAN SIGN MIOL" +
	"D PERSIAN SIGN MUOLD PERSIAN SIGN YAOLD PERSIAN SIGN VAOLD PERSIAN SIGN " +
	"VIOLD PERSIAN SIGN RAOLD PERSIAN SIGN RUOLD PERSIAN SIGN LAOLD PERSIAN S" +
	"IGN SAOLD PERSIAN SIGN ZAOLD PERSIAN SIGN SHAOLD PERSIAN SIGN SSAOLD PER" +
	"SIAN SIGN HAOLD PERSIAN SIGN AURAMAZDAAOLD PERSIAN SIGN AURAMAZDAA-2OLD " +
	"PERSIAN SIGN AURAMAZDAAHAOLD PERSIAN SIGN XSHAAYATHIYAOLD PERSIAN SIGN D" +
	"AHYAAUSHOLD PERSIAN SIGN DAHYAAUSH-2OLD PERSIAN SIGN BAGAOLD PERSIAN SIG" +
	"N BUUMISHOLD PERSIAN WORD DIVIDEROLD PERSIAN NUMBER ONEOLD PERSIAN NUMBE" +
	"R TWOOLD PERSIAN NUMBER TENOLD PERSIAN NUMBER TWENTYOLD PERSIAN NUMBER H" +
	"UNDREDDESERET CAPITAL LETTER LONG IDESERET CAPITAL LETTER LONG EDESERET " +
	"CAPITAL LETTER LONG ADESERET CAPITAL LETTER LONG AHDESERET CAPITAL LETTE" +
	"R LONG ODESERET CAPITAL LETTER LONG OODESERET CAPITAL LETTER SHORT IDESE" +
	"RET CAPITAL LETTER SHORT EDESERET CAPITAL LETTER SHORT ADESERET CAPITAL " +
	"LETTER SHORT AHDESERET CAPITAL LETTER SHORT ODESERET CAPITAL LETTER SHOR" +
	"T OODESERET CAPITAL LETTER AYDESERET CAPITAL LETTER OWDESERET CAPITAL LE" +
	"TTER WUDESERET CAPITAL LETTER YEEDESERET CAPITAL LETTER HDESERET CAPITAL" +
	" LETTER PEEDESERET CAPITAL LETTER BEEDESERET CAPITAL LETTER TEEDESERET C" +
	"APITAL LETTER DEEDESERET CAPITAL LETTER CHEEDESERET CAPITAL LETTER JEEDE" +
	"SERET CAPITAL LETTER KAYDESERET CAPITAL LETTER GAYDESERET CAPITAL LETTER" +
	" EFDESERET CAPITAL LETTER VEEDESERET CAPITAL LETTER ETHDESERET CAPITAL L" +
	"ETTER THEEDESERET CAPITAL LETTER ESDESERET CAPITAL LETTER ZEEDESERET CAP" +
	"ITAL LETTER ESHDESERET CAPITAL LETTER ZHEEDESERET CAPITAL LETTER ERDESER" +
	"ET CAPITAL LETTER ELDESERET CAPITAL LETTER EMDESERET CAPITAL LETTER ENDE" +
	"SERET CAPITAL LETTER ENGDESERET CAPITAL LETTER OIDESERET CAPITAL LETTER " +
	"EWDESERET SMALL LETTER LONG IDESERET SMALL LETTER LONG EDESERET SMALL LE" +
	"TTER LONG ADESERET SMALL LETTER LONG AHDESERET SMALL LETTER LONG ODESERE" +
	"T SMALL LETTER LONG OODESERET SMALL LETTER SHORT IDESERET SMALL LETTER S" +
	"HORT EDESERET SMALL LETTER SHORT ADESERET SMALL LETTER SHORT AHDESERET S" +
	"MALL LETTER SHORT ODESERET SMALL LETTER SHORT OODESERET SMALL LETTER AYD" +
	"ESERET SMALL LETTER OWDESERET SMALL LETTER WUDESERET SMALL LETTER YEEDES" +
	"ERET SMALL LETTER HDESERET SMALL LETTER PEEDESERET SMALL LETTER BEEDESER" +
	"ET SMALL LETTER TEEDESERET SMALL LETTER DEEDESERET SMALL LETTER CHEEDESE" +
	"RET SMALL LETTER JEEDESERET SMALL LETTER KAYDESERET SMALL LETTER GAYDESE" +
	"RET SMALL LETTER EFDESERET SMALL LETTER VEEDESERET SMALL LETTER ETHDESER" +
	"ET SMALL LETTER THEEDESERET SMALL LETTER ESDESERET SMALL LETTER ZEEDESER" +
	"ET SMALL LETTER ESHDESERET SMALL LETTER ZHEEDESERET SMALL LETTER ERDESER" +
	"ET SMALL LETTER ELDESERET SMALL LETTER EMDESERET SMALL LETTER ENDESERET " +
	"SMALL LETTER ENGDESERET SMALL LETTER OIDESERET SMALL LETTER EWSHAVIAN LE" +
	"TTER PEEPSHAVIAN LETTER TOTSHAVIAN LETTER KICKSHAVIAN LETTER FEESHAVIAN " +
	"LETTER THIGHSHAVIAN LETTER SOSHAVIAN LETTER SURESHAVIAN LETTER CHURCHSHA" +
	"VIAN LETTER YEASHAVIAN LETTER HUNGSHAVIAN LETTER BIBSHAVIAN LETTER DEADS" +
	"HAVIAN LETTER GAGSHAVIAN LETTER VOWSHAVIAN LETTER THEYSHAVIAN LETTER ZOO" +
	"SHAVIAN LETTER MEASURESHAVIAN LETTER JUDGESHAVIAN LETTER WOESHAVIAN LETT" +
	"ER HA-HASHAVIAN LETTER LOLLSHAVIAN LETTER MIMESHAVIAN LETTER IFSHAVIAN L" +
	"ETTER EGGSHAVIAN LETTER ASHSHAVIAN LETTER ADOSHAVIAN LETTER ONSHAVIAN LE" +
	"TTER WOOLSHAVIAN LETTER OUTSHAVIAN LETTER AHSHAVIAN LETTER ROARSHAVIAN L" +
	"ETTER NUNSHAVIAN LETTER EATSHAVIAN LETTER AGESHAVIAN LETTER ICESHAVIAN L" +
	"ETTER UPSHAVIAN LETTER OAKSHAVIAN LETTER OOZESHAVIAN LETTER OILSHAVIAN L" +
	"ETTER AWESHAVIAN LETTER ARESHAVIAN LETTER ORSHAVIAN LETTER AIRSHAVIAN LE" +
	"TTER ERRSHAVIAN LETTER ARRAYSHAVIAN LETTER EARSHAVIAN LETTER IANSHAVIAN " +
	"LETTER YEWOSMANYA LETTER ALEFOSMANYA LETTER BAOSMANYA LETTER TAOSMANYA L" +
	"ETTER JAOSMANYA LETTER XAOSMANYA LETTER KHAOSMANYA LETTER DEELOSMANYA LE" +
	"TTER RAOSMANYA LETTER SAOSMANYA LETTER SHIINOSMANYA LETTER DHAOSMANYA LE" +
	"TTER CAYNOSMANYA LETTER GAOSMANYA LETTER FAOSMANYA LETTER QAAFOSMANYA LE" +
	"TTER KAAFOSMANYA LETTER LAANOSMANYA LETTER MIINOSMANYA LETTER NUUNOSMANY" +
	"A LETTER WAWOSMANYA LETTER HAOSMANYA LETTER YAOSMANYA LETTER AOSMANYA LE" +
	"TTER EOSMANYA LETTER IOSMANYA LETTER OOSMANYA LETTER UOSMANYA LETTER AAO" +
	"SMANYA LETTER EEOSMANYA LETTER OOOSMANYA DIGIT ZEROOSMANYA DIGIT ONEOSMA" +
	"NYA DIGIT TWOOSMANYA DIGIT THREEOSMANYA DIGIT FOUROSMANYA DIGIT FIVEOSMA" +
	"NYA DIGIT SIXOSMANYA DIGIT SEVENOSMANYA DIGIT EIGHTOSMANYA DIGIT NINEOSA" +
	"GE CAPITAL LETTER AOSAGE CAPITAL LETTER AIOSAGE CAPITAL LETTER AINOSAGE " +
	"CAPITAL LETTER AHOSAGE CAPITAL LETTER BRAOSAGE CAPITAL LETTER CHAOSAGE C") + ("" +
	"APITAL LETTER EHCHAOSAGE CAPITAL LETTER EOSAGE CAPITAL LETTER EINOSAGE C" +
	"APITAL LETTER HAOSAGE CAPITAL LETTER HYAOSAGE CAPITAL LETTER IOSAGE CAPI" +
	"TAL LETTER KAOSAGE CAPITAL LETTER EHKAOSAGE CAPITAL LETTER KYAOSAGE CAPI" +
	"TAL LETTER LAOSAGE CAPITAL LETTER MAOSAGE CAPITAL LETTER NAOSAGE CAPITAL" +
	" LETTER OOSAGE CAPITAL LETTER OINOSAGE CAPITAL LETTER PAOSAGE CAPITAL LE" +
	"TTER EHPAOSAGE CAPITAL LETTER SAOSAGE CAPITAL LETTER SHAOSAGE CAPITAL LE" +
	"TTER TAOSAGE CAPITAL LETTER EHTAOSAGE CAPITAL LETTER TSAOSAGE CAPITAL LE" +
	"TTER EHTSAOSAGE CAPITAL LETTER TSHAOSAGE CAPITAL LETTER DHAOSAGE CAPITAL" +
	" LETTER UOSAGE CAPITAL LETTER WAOSAGE CAPITAL LETTER KHAOSAGE CAPITAL LE" +
	"TTER GHAOSAGE CAPITAL LETTER ZAOSAGE CAPITAL LETTER ZHAOSAGE SMALL LETTE" +
	"R AOSAGE SMALL LETTER AIOSAGE SMALL LETTER AINOSAGE SMALL LETTER AHOSAGE" +
	" SMALL LETTER BRAOSAGE SMALL LETTER CHAOSAGE SMALL LETTER EHCHAOSAGE SMA" +
	"LL LETTER EOSAGE SMALL LETTER EINOSAGE SMALL LETTER HAOSAGE SMALL LETTER" +
	" HYAOSAGE SMALL LETTER IOSAGE SMALL LETTER KAOSAGE SMALL LETTER EHKAOSAG" +
	"E SMALL LETTER KYAOSAGE SMALL LETTER LAOSAGE SMALL LETTER MAOSAGE SMALL " +
	"LETTER NAOSAGE SMALL LETTER OOSAGE SMALL LETTER OINOSAGE SMALL LETTER PA" +
	"OSAGE SMALL LETTER EHPAOSAGE SMALL LETTER SAOSAGE SMALL LETTER SHAOSAGE " +
	"SMALL LETTER TAOSAGE SMALL LETTER EHTAOSAGE SMALL LETTER TSAOSAGE SMALL " +
	"LETTER EHTSAOSAGE SMALL LETTER TSHAOSAGE SMALL LETTER DHAOSAGE SMALL LET" +
	"TER UOSAGE SMALL LETTER WAOSAGE SMALL LETTER KHAOSAGE SMALL LETTER GHAOS" +
	"AGE SMALL LETTER ZAOSAGE SMALL LETTER ZHAELBASAN LETTER AELBASAN LETTER " +
	"BEELBASAN LETTER CEELBASAN LETTER CHEELBASAN LETTER DEELBASAN LETTER NDE" +
	"ELBASAN LETTER DHEELBASAN LETTER EIELBASAN LETTER EELBASAN LETTER FEELBA" +
	"SAN LETTER GEELBASAN LETTER GJEELBASAN LETTER HEELBASAN LETTER IELBASAN " +
	"LETTER JEELBASAN LETTER KEELBASAN LETTER LEELBASAN LETTER LLEELBASAN LET" +
	"TER MEELBASAN LETTER NEELBASAN LETTER NAELBASAN LETTER NJEELBASAN LETTER" +
	" OELBASAN LETTER PEELBASAN LETTER QEELBASAN LETTER REELBASAN LETTER RREE" +
	"LBASAN LETTER SEELBASAN LETTER SHEELBASAN LETTER TEELBASAN LETTER THEELB" +
	"ASAN LETTER UELBASAN LETTER VEELBASAN LETTER XEELBASAN LETTER YELBASAN L" +
	"ETTER ZEELBASAN LETTER ZHEELBASAN LETTER GHEELBASAN LETTER GHAMMAELBASAN" +
	" LETTER KHECAUCASIAN ALBANIAN LETTER ALTCAUCASIAN ALBANIAN LETTER BETCAU" +
	"CASIAN ALBANIAN LETTER GIMCAUCASIAN ALBANIAN LETTER DATCAUCASIAN ALBANIA" +
	"N LETTER EBCAUCASIAN ALBANIAN LETTER ZARLCAUCASIAN ALBANIAN LETTER EYNCA" +
	"UCASIAN ALBANIAN LETTER ZHILCAUCASIAN ALBANIAN LETTER TASCAUCASIAN ALBAN" +
	"IAN LETTER CHACAUCASIAN ALBANIAN LETTER YOWDCAUCASIAN ALBANIAN LETTER ZH" +
	"ACAUCASIAN ALBANIAN LETTER IRBCAUCASIAN ALBANIAN LETTER SHACAUCASIAN ALB" +
	"ANIAN LETTER LANCAUCASIAN ALBANIAN LETTER INYACAUCASIAN ALBANIAN LETTER " +
	"XEYNCAUCASIAN ALBANIAN LETTER DYANCAUCASIAN ALBANIAN LETTER CARCAUCASIAN" +
	" ALBANIAN LETTER JHOXCAUCASIAN ALBANIAN LETTER KARCAUCASIAN ALBANIAN LET" +
	"TER LYITCAUCASIAN ALBANIAN LETTER HEYTCAUCASIAN ALBANIAN LETTER QAYCAUCA" +
	"SIAN ALBANIAN LETTER AORCAUCASIAN ALBANIAN LETTER CHOYCAUCASIAN ALBANIAN" +
	" LETTER CHICAUCASIAN ALBANIAN LETTER CYAYCAUCASIAN ALBANIAN LETTER MAQCA" +
	"UCASIAN ALBANIAN LETTER QARCAUCASIAN ALBANIAN LETTER NOWCCAUCASIAN ALBAN" +
	"IAN LETTER DZYAYCAUCASIAN ALBANIAN LETTER SHAKCAUCASIAN ALBANIAN LETTER " +
	"JAYNCAUCASIAN ALBANIAN LETTER ONCAUCASIAN ALBANIAN LETTER TYAYCAUCASIAN " +
	"ALBANIAN LETTER FAMCAUCASIAN ALBANIAN LETTER DZAYCAUCASIAN ALBANIAN LETT" +
	"ER CHATCAUCASIAN ALBANIAN LETTER PENCAUCASIAN ALBANIAN LETTER GHEYSCAUCA" +
	"SIAN ALBANIAN LETTER RATCAUCASIAN ALBANIAN LETTER SEYKCAUCASIAN ALBANIAN" +
	" LETTER VEYZCAUCASIAN ALBANIAN LETTER TIWRCAUCASIAN ALBANIAN LETTER SHOY" +
	"CAUCASIAN ALBANIAN LETTER IWNCAUCASIAN ALBANIAN LETTER CYAWCAUCASIAN ALB" +
	"ANIAN LETTER CAYNCAUCASIAN ALBANIAN LETTER YAYDCAUCASIAN ALBANIAN LETTER" +
	" PIWRCAUCASIAN ALBANIAN LETTER KIWCAUCASIAN ALBANIAN CITATION MARKLINEAR" +
	" A SIGN AB001LINEAR A SIGN AB002LINEAR A SIGN AB003LINEAR A SIGN AB004LI" +
	"NEAR A SIGN AB005LINEAR A SIGN AB006LINEAR A SIGN AB007LINEAR A SIGN AB0" +
	"08LINEAR A SIGN AB009LINEAR A SIGN AB010LINEAR A SIGN AB011LINEAR A SIGN" +
	" AB013LINEAR A SIGN AB016LINEAR A SIGN AB017LINEAR A SIGN AB020LINEAR A " +
	"SIGN AB021LINEAR A SIGN AB021FLINEAR A SIGN AB021MLINEAR A SIGN AB022LIN" +
	"EAR A SIGN AB022FLINEAR A SIGN AB022MLINEAR A SIGN AB023LINEAR A SIGN AB" +
	"023MLINEAR A SIGN AB024LINEAR A SIGN AB026LINEAR A SIGN AB027LINEAR A SI" +
	"GN AB028LINEAR A SIGN A028BLINEAR A SIGN AB029LINEAR A SIGN AB030LINEAR " +
	"A SIGN AB031LINEAR A SIGN AB034LINEAR A SIGN AB037LINEAR A SIGN AB038LIN" +
	"EAR A SIGN AB039LINEAR A SIGN AB040LINEAR A SIGN AB041LINEAR A SIGN AB04" +
	"4LINEAR A SIGN AB045LINEAR A SIGN AB046LINEAR A SIGN AB047LINEAR A SIGN " +
	"AB048LINEAR A SIGN AB049LINEAR A SIGN AB050LINEAR A SIGN AB051LINEAR A S") + ("" +
	"IGN AB053LINEAR A SIGN AB054LINEAR A SIGN AB055LINEAR A SIGN AB056LINEAR" +
	" A SIGN AB057LINEAR A SIGN AB058LINEAR A SIGN AB059LINEAR A SIGN AB060LI" +
	"NEAR A SIGN AB061LINEAR A SIGN AB065LINEAR A SIGN AB066LINEAR A SIGN AB0" +
	"67LINEAR A SIGN AB069LINEAR A SIGN AB070LINEAR A SIGN AB073LINEAR A SIGN" +
	" AB074LINEAR A SIGN AB076LINEAR A SIGN AB077LINEAR A SIGN AB078LINEAR A " +
	"SIGN AB079LINEAR A SIGN AB080LINEAR A SIGN AB081LINEAR A SIGN AB082LINEA" +
	"R A SIGN AB085LINEAR A SIGN AB086LINEAR A SIGN AB087LINEAR A SIGN A100-1" +
	"02LINEAR A SIGN AB118LINEAR A SIGN AB120LINEAR A SIGN A120BLINEAR A SIGN" +
	" AB122LINEAR A SIGN AB123LINEAR A SIGN AB131ALINEAR A SIGN AB131BLINEAR " +
	"A SIGN A131CLINEAR A SIGN AB164LINEAR A SIGN AB171LINEAR A SIGN AB180LIN" +
	"EAR A SIGN AB188LINEAR A SIGN AB191LINEAR A SIGN A301LINEAR A SIGN A302L" +
	"INEAR A SIGN A303LINEAR A SIGN A304LINEAR A SIGN A305LINEAR A SIGN A306L" +
	"INEAR A SIGN A307LINEAR A SIGN A308LINEAR A SIGN A309ALINEAR A SIGN A309" +
	"BLINEAR A SIGN A309CLINEAR A SIGN A310LINEAR A SIGN A311LINEAR A SIGN A3" +
	"12LINEAR A SIGN A313ALINEAR A SIGN A313BLINEAR A SIGN A313CLINEAR A SIGN" +
	" A314LINEAR A SIGN A315LINEAR A SIGN A316LINEAR A SIGN A317LINEAR A SIGN" +
	" A318LINEAR A SIGN A319LINEAR A SIGN A320LINEAR A SIGN A321LINEAR A SIGN" +
	" A322LINEAR A SIGN A323LINEAR A SIGN A324LINEAR A SIGN A325LINEAR A SIGN" +
	" A326LINEAR A SIGN A327LINEAR A SIGN A328LINEAR A SIGN A329LINEAR A SIGN" +
	" A330LINEAR A SIGN A331LINEAR A SIGN A332LINEAR A SIGN A333LINEAR A SIGN" +
	" A334LINEAR A SIGN A335LINEAR A SIGN A336LINEAR A SIGN A337LINEAR A SIGN" +
	" A338LINEAR A SIGN A339LINEAR A SIGN A340LINEAR A SIGN A341LINEAR A SIGN" +
	" A342LINEAR A SIGN A343LINEAR A SIGN A344LINEAR A SIGN A345LINEAR A SIGN" +
	" A346LINEAR A SIGN A347LINEAR A SIGN A348LINEAR A SIGN A349LINEAR A SIGN" +
	" A350LINEAR A SIGN A351LINEAR A SIGN A352LINEAR A SIGN A353LINEAR A SIGN" +
	" A354LINEAR A SIGN A355LINEAR A SIGN A356LINEAR A SIGN A357LINEAR A SIGN" +
	" A358LINEAR A SIGN A359LINEAR A SIGN A360LINEAR A SIGN A361LINEAR A SIGN" +
	" A362LINEAR A SIGN A363LINEAR A SIGN A364LINEAR A SIGN A365LINEAR A SIGN" +
	" A366LINEAR A SIGN A367LINEAR A SIGN A368LINEAR A SIGN A369LINEAR A SIGN" +
	" A370LINEAR A SIGN A371LINEAR A SIGN A400-VASLINEAR A SIGN A401-VASLINEA" +
	"R A SIGN A402-VASLINEAR A SIGN A403-VASLINEAR A SIGN A404-VASLINEAR A SI" +
	"GN A405-VASLINEAR A SIGN A406-VASLINEAR A SIGN A407-VASLINEAR A SIGN A40" +
	"8-VASLINEAR A SIGN A409-VASLINEAR A SIGN A410-VASLINEAR A SIGN A411-VASL" +
	"INEAR A SIGN A412-VASLINEAR A SIGN A413-VASLINEAR A SIGN A414-VASLINEAR " +
	"A SIGN A415-VASLINEAR A SIGN A416-VASLINEAR A SIGN A417-VASLINEAR A SIGN" +
	" A418-VASLINEAR A SIGN A501LINEAR A SIGN A502LINEAR A SIGN A503LINEAR A " +
	"SIGN A504LINEAR A SIGN A505LINEAR A SIGN A506LINEAR A SIGN A508LINEAR A " +
	"SIGN A509LINEAR A SIGN A510LINEAR A SIGN A511LINEAR A SIGN A512LINEAR A " +
	"SIGN A513LINEAR A SIGN A515LINEAR A SIGN A516LINEAR A SIGN A520LINEAR A " +
	"SIGN A521LINEAR A SIGN A523LINEAR A SIGN A524LINEAR A SIGN A525LINEAR A " +
	"SIGN A526LINEAR A SIGN A527LINEAR A SIGN A528LINEAR A SIGN A529LINEAR A " +
	"SIGN A530LINEAR A SIGN A531LINEAR A SIGN A532LINEAR A SIGN A534LINEAR A " +
	"SIGN A535LINEAR A SIGN A536LINEAR A SIGN A537LINEAR A SIGN A538LINEAR A " +
	"SIGN A539LINEAR A SIGN A540LINEAR A SIGN A541LINEAR A SIGN A542LINEAR A " +
	"SIGN A545LINEAR A SIGN A547LINEAR A SIGN A548LINEAR A SIGN A549LINEAR A " +
	"SIGN A550LINEAR A SIGN A551LINEAR A SIGN A552LINEAR A SIGN A553LINEAR A " +
	"SIGN A554LINEAR A SIGN A555LINEAR A SIGN A556LINEAR A SIGN A557LINEAR A " +
	"SIGN A559LINEAR A SIGN A563LINEAR A SIGN A564LINEAR A SIGN A565LINEAR A " +
	"SIGN A566LINEAR A SIGN A568LINEAR A SIGN A569LINEAR A SIGN A570LINEAR A " +
	"SIGN A571LINEAR A SIGN A572LINEAR A SIGN A573LINEAR A SIGN A574LINEAR A " +
	"SIGN A575LINEAR A SIGN A576LINEAR A SIGN A577LINEAR A SIGN A578LINEAR A " +
	"SIGN A579LINEAR A SIGN A580LINEAR A SIGN A581LINEAR A SIGN A582LINEAR A " +
	"SIGN A583LINEAR A SIGN A584LINEAR A SIGN A585LINEAR A SIGN A586LINEAR A " +
	"SIGN A587LINEAR A SIGN A588LINEAR A SIGN A589LINEAR A SIGN A591LINEAR A " +
	"SIGN A592LINEAR A SIGN A594LINEAR A SIGN A595LINEAR A SIGN A596LINEAR A " +
	"SIGN A598LINEAR A SIGN A600LINEAR A SIGN A601LINEAR A SIGN A602LINEAR A " +
	"SIGN A603LINEAR A SIGN A604LINEAR A SIGN A606LINEAR A SIGN A608LINEAR A " +
	"SIGN A609LINEAR A SIGN A610LINEAR A SIGN A611LINEAR A SIGN A612LINEAR A " +
	"SIGN A613LINEAR A SIGN A614LINEAR A SIGN A615LINEAR A SIGN A616LINEAR A " +
	"SIGN A617LINEAR A SIGN A618LINEAR A SIGN A619LINEAR A SIGN A620LINEAR A " +
	"SIGN A621LINEAR A SIGN A622LINEAR A SIGN A623LINEAR A SIGN A624LINEAR A " +
	"SIGN A626LINEAR A SIGN A627LINEAR A SIGN A628LINEAR A SIGN A629LINEAR A " +
	"SIGN A634LINEAR A SIGN A637LINEAR A SIGN A638LINEAR A SIGN A640LINEAR A " +
	"SIGN A642LINEAR A SIGN A643LINEAR A SIGN A644LINEAR A SIGN A645LINEAR A ") + ("" +
	"SIGN A646LINEAR A SIGN A648LINEAR A SIGN A649LINEAR A SIGN A651LINEAR A " +
	"SIGN A652LINEAR A SIGN A653LINEAR A SIGN A654LINEAR A SIGN A655LINEAR A " +
	"SIGN A656LINEAR A SIGN A657LINEAR A SIGN A658LINEAR A SIGN A659LINEAR A " +
	"SIGN A660LINEAR A SIGN A661LINEAR A SIGN A662LINEAR A SIGN A663LINEAR A " +
	"SIGN A664LINEAR A SIGN A701 ALINEAR A SIGN A702 BLINEAR A SIGN A703 DLIN" +
	"EAR A SIGN A704 ELINEAR A SIGN A705 FLINEAR A SIGN A706 HLINEAR A SIGN A" +
	"707 JLINEAR A SIGN A708 KLINEAR A SIGN A709 LLINEAR A SIGN A709-2 L2LINE" +
	"AR A SIGN A709-3 L3LINEAR A SIGN A709-4 L4LINEAR A SIGN A709-6 L6LINEAR " +
	"A SIGN A710 WLINEAR A SIGN A711 XLINEAR A SIGN A712 YLINEAR A SIGN A713 " +
	"OMEGALINEAR A SIGN A714 ABBLINEAR A SIGN A715 BBLINEAR A SIGN A717 DDLIN" +
	"EAR A SIGN A726 EYYYLINEAR A SIGN A732 JELINEAR A SIGN A800LINEAR A SIGN" +
	" A801LINEAR A SIGN A802LINEAR A SIGN A803LINEAR A SIGN A804LINEAR A SIGN" +
	" A805LINEAR A SIGN A806LINEAR A SIGN A807CYPRIOT SYLLABLE ACYPRIOT SYLLA" +
	"BLE ECYPRIOT SYLLABLE ICYPRIOT SYLLABLE OCYPRIOT SYLLABLE UCYPRIOT SYLLA" +
	"BLE JACYPRIOT SYLLABLE JOCYPRIOT SYLLABLE KACYPRIOT SYLLABLE KECYPRIOT S" +
	"YLLABLE KICYPRIOT SYLLABLE KOCYPRIOT SYLLABLE KUCYPRIOT SYLLABLE LACYPRI" +
	"OT SYLLABLE LECYPRIOT SYLLABLE LICYPRIOT SYLLABLE LOCYPRIOT SYLLABLE LUC" +
	"YPRIOT SYLLABLE MACYPRIOT SYLLABLE MECYPRIOT SYLLABLE MICYPRIOT SYLLABLE" +
	" MOCYPRIOT SYLLABLE MUCYPRIOT SYLLABLE NACYPRIOT SYLLABLE NECYPRIOT SYLL" +
	"ABLE NICYPRIOT SYLLABLE NOCYPRIOT SYLLABLE NUCYPRIOT SYLLABLE PACYPRIOT " +
	"SYLLABLE PECYPRIOT SYLLABLE PICYPRIOT SYLLABLE POCYPRIOT SYLLABLE PUCYPR" +
	"IOT SYLLABLE RACYPRIOT SYLLABLE RECYPRIOT SYLLABLE RICYPRIOT SYLLABLE RO" +
	"CYPRIOT SYLLABLE RUCYPRIOT SYLLABLE SACYPRIOT SYLLABLE SECYPRIOT SYLLABL" +
	"E SICYPRIOT SYLLABLE SOCYPRIOT SYLLABLE SUCYPRIOT SYLLABLE TACYPRIOT SYL" +
	"LABLE TECYPRIOT SYLLABLE TICYPRIOT SYLLABLE TOCYPRIOT SYLLABLE TUCYPRIOT" +
	" SYLLABLE WACYPRIOT SYLLABLE WECYPRIOT SYLLABLE WICYPRIOT SYLLABLE WOCYP" +
	"RIOT SYLLABLE XACYPRIOT SYLLABLE XECYPRIOT SYLLABLE ZACYPRIOT SYLLABLE Z" +
	"OIMPERIAL ARAMAIC LETTER ALEPHIMPERIAL ARAMAIC LETTER BETHIMPERIAL ARAMA" +
	"IC LETTER GIMELIMPERIAL ARAMAIC LETTER DALETHIMPERIAL ARAMAIC LETTER HEI" +
	"MPERIAL ARAMAIC LETTER WAWIMPERIAL ARAMAIC LETTER ZAYINIMPERIAL ARAMAIC " +
	"LETTER HETHIMPERIAL ARAMAIC LETTER TETHIMPERIAL ARAMAIC LETTER YODHIMPER" +
	"IAL ARAMAIC LETTER KAPHIMPERIAL ARAMAIC LETTER LAMEDHIMPERIAL ARAMAIC LE" +
	"TTER MEMIMPERIAL ARAMAIC LETTER NUNIMPERIAL ARAMAIC LETTER SAMEKHIMPERIA" +
	"L ARAMAIC LETTER AYINIMPERIAL ARAMAIC LETTER PEIMPERIAL ARAMAIC LETTER S" +
	"ADHEIMPERIAL ARAMAIC LETTER QOPHIMPERIAL ARAMAIC LETTER RESHIMPERIAL ARA" +
	"MAIC LETTER SHINIMPERIAL ARAMAIC LETTER TAWIMPERIAL ARAMAIC SECTION SIGN" +
	"IMPERIAL ARAMAIC NUMBER ONEIMPERIAL ARAMAIC NUMBER TWOIMPERIAL ARAMAIC N" +
	"UMBER THREEIMPERIAL ARAMAIC NUMBER TENIMPERIAL ARAMAIC NUMBER TWENTYIMPE" +
	"RIAL ARAMAIC NUMBER ONE HUNDREDIMPERIAL ARAMAIC NUMBER ONE THOUSANDIMPER" +
	"IAL ARAMAIC NUMBER TEN THOUSANDPALMYRENE LETTER ALEPHPALMYRENE LETTER BE" +
	"THPALMYRENE LETTER GIMELPALMYRENE LETTER DALETHPALMYRENE LETTER HEPALMYR" +
	"ENE LETTER WAWPALMYRENE LETTER ZAYINPALMYRENE LETTER HETHPALMYRENE LETTE" +
	"R TETHPALMYRENE LETTER YODHPALMYRENE LETTER KAPHPALMYRENE LETTER LAMEDHP" +
	"ALMYRENE LETTER MEMPALMYRENE LETTER FINAL NUNPALMYRENE LETTER NUNPALMYRE" +
	"NE LETTER SAMEKHPALMYRENE LETTER AYINPALMYRENE LETTER PEPALMYRENE LETTER" +
	" SADHEPALMYRENE LETTER QOPHPALMYRENE LETTER RESHPALMYRENE LETTER SHINPAL" +
	"MYRENE LETTER TAWPALMYRENE LEFT-POINTING FLEURONPALMYRENE RIGHT-POINTING" +
	" FLEURONPALMYRENE NUMBER ONEPALMYRENE NUMBER TWOPALMYRENE NUMBER THREEPA" +
	"LMYRENE NUMBER FOURPALMYRENE NUMBER FIVEPALMYRENE NUMBER TENPALMYRENE NU" +
	"MBER TWENTYNABATAEAN LETTER FINAL ALEPHNABATAEAN LETTER ALEPHNABATAEAN L" +
	"ETTER FINAL BETHNABATAEAN LETTER BETHNABATAEAN LETTER GIMELNABATAEAN LET" +
	"TER DALETHNABATAEAN LETTER FINAL HENABATAEAN LETTER HENABATAEAN LETTER W" +
	"AWNABATAEAN LETTER ZAYINNABATAEAN LETTER HETHNABATAEAN LETTER TETHNABATA" +
	"EAN LETTER FINAL YODHNABATAEAN LETTER YODHNABATAEAN LETTER FINAL KAPHNAB" +
	"ATAEAN LETTER KAPHNABATAEAN LETTER FINAL LAMEDHNABATAEAN LETTER LAMEDHNA" +
	"BATAEAN LETTER FINAL MEMNABATAEAN LETTER MEMNABATAEAN LETTER FINAL NUNNA" +
	"BATAEAN LETTER NUNNABATAEAN LETTER SAMEKHNABATAEAN LETTER AYINNABATAEAN " +
	"LETTER PENABATAEAN LETTER SADHENABATAEAN LETTER QOPHNABATAEAN LETTER RES" +
	"HNABATAEAN LETTER FINAL SHINNABATAEAN LETTER SHINNABATAEAN LETTER TAWNAB" +
	"ATAEAN NUMBER ONENABATAEAN NUMBER TWONABATAEAN NUMBER THREENABATAEAN NUM" +
	"BER FOURNABATAEAN CRUCIFORM NUMBER FOURNABATAEAN NUMBER FIVENABATAEAN NU" +
	"MBER TENNABATAEAN NUMBER TWENTYNABATAEAN NUMBER ONE HUNDREDHATRAN LETTER" +
	" ALEPHHATRAN LETTER BETHHATRAN LETTER GIMELHATRAN LETTER DALETH-RESHHATR" +
	"AN LETTER HEHATRAN LETTER WAWHATRAN LETTER ZAYNHATRAN LETTER HETHHATRAN ") + ("" +
	"LETTER TETHHATRAN LETTER YODHHATRAN LETTER KAPHHATRAN LETTER LAMEDHHATRA" +
	"N LETTER MEMHATRAN LETTER NUNHATRAN LETTER SAMEKHHATRAN LETTER AYNHATRAN" +
	" LETTER PEHATRAN LETTER SADHEHATRAN LETTER QOPHHATRAN LETTER SHINHATRAN " +
	"LETTER TAWHATRAN NUMBER ONEHATRAN NUMBER FIVEHATRAN NUMBER TENHATRAN NUM" +
	"BER TWENTYHATRAN NUMBER ONE HUNDREDPHOENICIAN LETTER ALFPHOENICIAN LETTE" +
	"R BETPHOENICIAN LETTER GAMLPHOENICIAN LETTER DELTPHOENICIAN LETTER HEPHO" +
	"ENICIAN LETTER WAUPHOENICIAN LETTER ZAIPHOENICIAN LETTER HETPHOENICIAN L" +
	"ETTER TETPHOENICIAN LETTER YODPHOENICIAN LETTER KAFPHOENICIAN LETTER LAM" +
	"DPHOENICIAN LETTER MEMPHOENICIAN LETTER NUNPHOENICIAN LETTER SEMKPHOENIC" +
	"IAN LETTER AINPHOENICIAN LETTER PEPHOENICIAN LETTER SADEPHOENICIAN LETTE" +
	"R QOFPHOENICIAN LETTER ROSHPHOENICIAN LETTER SHINPHOENICIAN LETTER TAUPH" +
	"OENICIAN NUMBER ONEPHOENICIAN NUMBER TENPHOENICIAN NUMBER TWENTYPHOENICI" +
	"AN NUMBER ONE HUNDREDPHOENICIAN NUMBER TWOPHOENICIAN NUMBER THREEPHOENIC" +
	"IAN WORD SEPARATORLYDIAN LETTER ALYDIAN LETTER BLYDIAN LETTER GLYDIAN LE" +
	"TTER DLYDIAN LETTER ELYDIAN LETTER VLYDIAN LETTER ILYDIAN LETTER YLYDIAN" +
	" LETTER KLYDIAN LETTER LLYDIAN LETTER MLYDIAN LETTER NLYDIAN LETTER OLYD" +
	"IAN LETTER RLYDIAN LETTER SSLYDIAN LETTER TLYDIAN LETTER ULYDIAN LETTER " +
	"FLYDIAN LETTER QLYDIAN LETTER SLYDIAN LETTER TTLYDIAN LETTER ANLYDIAN LE" +
	"TTER ENLYDIAN LETTER LYLYDIAN LETTER NNLYDIAN LETTER CLYDIAN TRIANGULAR " +
	"MARKMEROITIC HIEROGLYPHIC LETTER AMEROITIC HIEROGLYPHIC LETTER EMEROITIC" +
	" HIEROGLYPHIC LETTER IMEROITIC HIEROGLYPHIC LETTER OMEROITIC HIEROGLYPHI" +
	"C LETTER YAMEROITIC HIEROGLYPHIC LETTER WAMEROITIC HIEROGLYPHIC LETTER B" +
	"AMEROITIC HIEROGLYPHIC LETTER BA-2MEROITIC HIEROGLYPHIC LETTER PAMEROITI" +
	"C HIEROGLYPHIC LETTER MAMEROITIC HIEROGLYPHIC LETTER NAMEROITIC HIEROGLY" +
	"PHIC LETTER NA-2MEROITIC HIEROGLYPHIC LETTER NEMEROITIC HIEROGLYPHIC LET" +
	"TER NE-2MEROITIC HIEROGLYPHIC LETTER RAMEROITIC HIEROGLYPHIC LETTER RA-2" +
	"MEROITIC HIEROGLYPHIC LETTER LAMEROITIC HIEROGLYPHIC LETTER KHAMEROITIC " +
	"HIEROGLYPHIC LETTER HHAMEROITIC HIEROGLYPHIC LETTER SAMEROITIC HIEROGLYP" +
	"HIC LETTER SA-2MEROITIC HIEROGLYPHIC LETTER SEMEROITIC HIEROGLYPHIC LETT" +
	"ER KAMEROITIC HIEROGLYPHIC LETTER QAMEROITIC HIEROGLYPHIC LETTER TAMEROI" +
	"TIC HIEROGLYPHIC LETTER TA-2MEROITIC HIEROGLYPHIC LETTER TEMEROITIC HIER" +
	"OGLYPHIC LETTER TE-2MEROITIC HIEROGLYPHIC LETTER TOMEROITIC HIEROGLYPHIC" +
	" LETTER DAMEROITIC HIEROGLYPHIC SYMBOL VIDJMEROITIC HIEROGLYPHIC SYMBOL " +
	"VIDJ-2MEROITIC CURSIVE LETTER AMEROITIC CURSIVE LETTER EMEROITIC CURSIVE" +
	" LETTER IMEROITIC CURSIVE LETTER OMEROITIC CURSIVE LETTER YAMEROITIC CUR" +
	"SIVE LETTER WAMEROITIC CURSIVE LETTER BAMEROITIC CURSIVE LETTER PAMEROIT" +
	"IC CURSIVE LETTER MAMEROITIC CURSIVE LETTER NAMEROITIC CURSIVE LETTER NE" +
	"MEROITIC CURSIVE LETTER RAMEROITIC CURSIVE LETTER LAMEROITIC CURSIVE LET" +
	"TER KHAMEROITIC CURSIVE LETTER HHAMEROITIC CURSIVE LETTER SAMEROITIC CUR" +
	"SIVE LETTER ARCHAIC SAMEROITIC CURSIVE LETTER SEMEROITIC CURSIVE LETTER " +
	"KAMEROITIC CURSIVE LETTER QAMEROITIC CURSIVE LETTER TAMEROITIC CURSIVE L" +
	"ETTER TEMEROITIC CURSIVE LETTER TOMEROITIC CURSIVE LETTER DAMEROITIC CUR" +
	"SIVE FRACTION ELEVEN TWELFTHSMEROITIC CURSIVE FRACTION ONE HALFMEROITIC " +
	"CURSIVE LOGOGRAM RMTMEROITIC CURSIVE LOGOGRAM IMNMEROITIC CURSIVE NUMBER" +
	" ONEMEROITIC CURSIVE NUMBER TWOMEROITIC CURSIVE NUMBER THREEMEROITIC CUR" +
	"SIVE NUMBER FOURMEROITIC CURSIVE NUMBER FIVEMEROITIC CURSIVE NUMBER SIXM" +
	"EROITIC CURSIVE NUMBER SEVENMEROITIC CURSIVE NUMBER EIGHTMEROITIC CURSIV" +
	"E NUMBER NINEMEROITIC CURSIVE NUMBER TENMEROITIC CURSIVE NUMBER TWENTYME" +
	"ROITIC CURSIVE NUMBER THIRTYMEROITIC CURSIVE NUMBER FORTYMEROITIC CURSIV" +
	"E NUMBER FIFTYMEROITIC CURSIVE NUMBER SIXTYMEROITIC CURSIVE NUMBER SEVEN" +
	"TYMEROITIC CURSIVE NUMBER ONE HUNDREDMEROITIC CURSIVE NUMBER TWO HUNDRED" +
	"MEROITIC CURSIVE NUMBER THREE HUNDREDMEROITIC CURSIVE NUMBER FOUR HUNDRE" +
	"DMEROITIC CURSIVE NUMBER FIVE HUNDREDMEROITIC CURSIVE NUMBER SIX HUNDRED" +
	"MEROITIC CURSIVE NUMBER SEVEN HUNDREDMEROITIC CURSIVE NUMBER EIGHT HUNDR" +
	"EDMEROITIC CURSIVE NUMBER NINE HUNDREDMEROITIC CURSIVE NUMBER ONE THOUSA" +
	"NDMEROITIC CURSIVE NUMBER TWO THOUSANDMEROITIC CURSIVE NUMBER THREE THOU" +
	"SANDMEROITIC CURSIVE NUMBER FOUR THOUSANDMEROITIC CURSIVE NUMBER FIVE TH" +
	"OUSANDMEROITIC CURSIVE NUMBER SIX THOUSANDMEROITIC CURSIVE NUMBER SEVEN " +
	"THOUSANDMEROITIC CURSIVE NUMBER EIGHT THOUSANDMEROITIC CURSIVE NUMBER NI" +
	"NE THOUSANDMEROITIC CURSIVE NUMBER TEN THOUSANDMEROITIC CURSIVE NUMBER T" +
	"WENTY THOUSANDMEROITIC CURSIVE NUMBER THIRTY THOUSANDMEROITIC CURSIVE NU" +
	"MBER FORTY THOUSANDMEROITIC CURSIVE NUMBER FIFTY THOUSANDMEROITIC CURSIV" +
	"E NUMBER SIXTY THOUSANDMEROITIC CURSIVE NUMBER SEVENTY THOUSANDMEROITIC " +
	"CURSIVE NUMBER EIGHTY THOUSANDMEROITIC CURSIVE NUMBER NINETY THOUSANDMER") + ("" +
	"OITIC CURSIVE NUMBER ONE HUNDRED THOUSANDMEROITIC CURSIVE NUMBER TWO HUN" +
	"DRED THOUSANDMEROITIC CURSIVE NUMBER THREE HUNDRED THOUSANDMEROITIC CURS" +
	"IVE NUMBER FOUR HUNDRED THOUSANDMEROITIC CURSIVE NUMBER FIVE HUNDRED THO" +
	"USANDMEROITIC CURSIVE NUMBER SIX HUNDRED THOUSANDMEROITIC CURSIVE NUMBER" +
	" SEVEN HUNDRED THOUSANDMEROITIC CURSIVE NUMBER EIGHT HUNDRED THOUSANDMER" +
	"OITIC CURSIVE NUMBER NINE HUNDRED THOUSANDMEROITIC CURSIVE FRACTION ONE " +
	"TWELFTHMEROITIC CURSIVE FRACTION TWO TWELFTHSMEROITIC CURSIVE FRACTION T" +
	"HREE TWELFTHSMEROITIC CURSIVE FRACTION FOUR TWELFTHSMEROITIC CURSIVE FRA" +
	"CTION FIVE TWELFTHSMEROITIC CURSIVE FRACTION SIX TWELFTHSMEROITIC CURSIV" +
	"E FRACTION SEVEN TWELFTHSMEROITIC CURSIVE FRACTION EIGHT TWELFTHSMEROITI" +
	"C CURSIVE FRACTION NINE TWELFTHSMEROITIC CURSIVE FRACTION TEN TWELFTHSKH" +
	"AROSHTHI LETTER AKHAROSHTHI VOWEL SIGN IKHAROSHTHI VOWEL SIGN UKHAROSHTH" +
	"I VOWEL SIGN VOCALIC RKHAROSHTHI VOWEL SIGN EKHAROSHTHI VOWEL SIGN OKHAR" +
	"OSHTHI VOWEL LENGTH MARKKHAROSHTHI SIGN DOUBLE RING BELOWKHAROSHTHI SIGN" +
	" ANUSVARAKHAROSHTHI SIGN VISARGAKHAROSHTHI LETTER KAKHAROSHTHI LETTER KH" +
	"AKHAROSHTHI LETTER GAKHAROSHTHI LETTER GHAKHAROSHTHI LETTER CAKHAROSHTHI" +
	" LETTER CHAKHAROSHTHI LETTER JAKHAROSHTHI LETTER NYAKHAROSHTHI LETTER TT" +
	"AKHAROSHTHI LETTER TTHAKHAROSHTHI LETTER DDAKHAROSHTHI LETTER DDHAKHAROS" +
	"HTHI LETTER NNAKHAROSHTHI LETTER TAKHAROSHTHI LETTER THAKHAROSHTHI LETTE" +
	"R DAKHAROSHTHI LETTER DHAKHAROSHTHI LETTER NAKHAROSHTHI LETTER PAKHAROSH" +
	"THI LETTER PHAKHAROSHTHI LETTER BAKHAROSHTHI LETTER BHAKHAROSHTHI LETTER" +
	" MAKHAROSHTHI LETTER YAKHAROSHTHI LETTER RAKHAROSHTHI LETTER LAKHAROSHTH" +
	"I LETTER VAKHAROSHTHI LETTER SHAKHAROSHTHI LETTER SSAKHAROSHTHI LETTER S" +
	"AKHAROSHTHI LETTER ZAKHAROSHTHI LETTER HAKHAROSHTHI LETTER KKAKHAROSHTHI" +
	" LETTER TTTHAKHAROSHTHI SIGN BAR ABOVEKHAROSHTHI SIGN CAUDAKHAROSHTHI SI" +
	"GN DOT BELOWKHAROSHTHI VIRAMAKHAROSHTHI DIGIT ONEKHAROSHTHI DIGIT TWOKHA" +
	"ROSHTHI DIGIT THREEKHAROSHTHI DIGIT FOURKHAROSHTHI NUMBER TENKHAROSHTHI " +
	"NUMBER TWENTYKHAROSHTHI NUMBER ONE HUNDREDKHAROSHTHI NUMBER ONE THOUSAND" +
	"KHAROSHTHI PUNCTUATION DOTKHAROSHTHI PUNCTUATION SMALL CIRCLEKHAROSHTHI " +
	"PUNCTUATION CIRCLEKHAROSHTHI PUNCTUATION CRESCENT BARKHAROSHTHI PUNCTUAT" +
	"ION MANGALAMKHAROSHTHI PUNCTUATION LOTUSKHAROSHTHI PUNCTUATION DANDAKHAR" +
	"OSHTHI PUNCTUATION DOUBLE DANDAKHAROSHTHI PUNCTUATION LINESOLD SOUTH ARA" +
	"BIAN LETTER HEOLD SOUTH ARABIAN LETTER LAMEDHOLD SOUTH ARABIAN LETTER HE" +
	"THOLD SOUTH ARABIAN LETTER MEMOLD SOUTH ARABIAN LETTER QOPHOLD SOUTH ARA" +
	"BIAN LETTER WAWOLD SOUTH ARABIAN LETTER SHINOLD SOUTH ARABIAN LETTER RES" +
	"HOLD SOUTH ARABIAN LETTER BETHOLD SOUTH ARABIAN LETTER TAWOLD SOUTH ARAB" +
	"IAN LETTER SATOLD SOUTH ARABIAN LETTER KAPHOLD SOUTH ARABIAN LETTER NUNO" +
	"LD SOUTH ARABIAN LETTER KHETHOLD SOUTH ARABIAN LETTER SADHEOLD SOUTH ARA" +
	"BIAN LETTER SAMEKHOLD SOUTH ARABIAN LETTER FEOLD SOUTH ARABIAN LETTER AL" +
	"EFOLD SOUTH ARABIAN LETTER AYNOLD SOUTH ARABIAN LETTER DHADHEOLD SOUTH A" +
	"RABIAN LETTER GIMELOLD SOUTH ARABIAN LETTER DALETHOLD SOUTH ARABIAN LETT" +
	"ER GHAYNOLD SOUTH ARABIAN LETTER TETHOLD SOUTH ARABIAN LETTER ZAYNOLD SO" +
	"UTH ARABIAN LETTER DHALETHOLD SOUTH ARABIAN LETTER YODHOLD SOUTH ARABIAN" +
	" LETTER THAWOLD SOUTH ARABIAN LETTER THETHOLD SOUTH ARABIAN NUMBER ONEOL" +
	"D SOUTH ARABIAN NUMBER FIFTYOLD SOUTH ARABIAN NUMERIC INDICATOROLD NORTH" +
	" ARABIAN LETTER HEHOLD NORTH ARABIAN LETTER LAMOLD NORTH ARABIAN LETTER " +
	"HAHOLD NORTH ARABIAN LETTER MEEMOLD NORTH ARABIAN LETTER QAFOLD NORTH AR" +
	"ABIAN LETTER WAWOLD NORTH ARABIAN LETTER ES-2OLD NORTH ARABIAN LETTER RE" +
	"HOLD NORTH ARABIAN LETTER BEHOLD NORTH ARABIAN LETTER TEHOLD NORTH ARABI" +
	"AN LETTER ES-1OLD NORTH ARABIAN LETTER KAFOLD NORTH ARABIAN LETTER NOONO" +
	"LD NORTH ARABIAN LETTER KHAHOLD NORTH ARABIAN LETTER SADOLD NORTH ARABIA" +
	"N LETTER ES-3OLD NORTH ARABIAN LETTER FEHOLD NORTH ARABIAN LETTER ALEFOL" +
	"D NORTH ARABIAN LETTER AINOLD NORTH ARABIAN LETTER DADOLD NORTH ARABIAN " +
	"LETTER GEEMOLD NORTH ARABIAN LETTER DALOLD NORTH ARABIAN LETTER GHAINOLD" +
	" NORTH ARABIAN LETTER TAHOLD NORTH ARABIAN LETTER ZAINOLD NORTH ARABIAN " +
	"LETTER THALOLD NORTH ARABIAN LETTER YEHOLD NORTH ARABIAN LETTER THEHOLD " +
	"NORTH ARABIAN LETTER ZAHOLD NORTH ARABIAN NUMBER ONEOLD NORTH ARABIAN NU" +
	"MBER TENOLD NORTH ARABIAN NUMBER TWENTYMANICHAEAN LETTER ALEPHMANICHAEAN" +
	" LETTER BETHMANICHAEAN LETTER BHETHMANICHAEAN LETTER GIMELMANICHAEAN LET" +
	"TER GHIMELMANICHAEAN LETTER DALETHMANICHAEAN LETTER HEMANICHAEAN LETTER " +
	"WAWMANICHAEAN SIGN UDMANICHAEAN LETTER ZAYINMANICHAEAN LETTER ZHAYINMANI" +
	"CHAEAN LETTER JAYINMANICHAEAN LETTER JHAYINMANICHAEAN LETTER HETHMANICHA" +
	"EAN LETTER TETHMANICHAEAN LETTER YODHMANICHAEAN LETTER KAPHMANICHAEAN LE" +
	"TTER XAPHMANICHAEAN LETTER KHAPHMANICHAEAN LETTER LAMEDHMANICHAEAN LETTE") + ("" +
	"R DHAMEDHMANICHAEAN LETTER THAMEDHMANICHAEAN LETTER MEMMANICHAEAN LETTER" +
	" NUNMANICHAEAN LETTER SAMEKHMANICHAEAN LETTER AYINMANICHAEAN LETTER AAYI" +
	"NMANICHAEAN LETTER PEMANICHAEAN LETTER FEMANICHAEAN LETTER SADHEMANICHAE" +
	"AN LETTER QOPHMANICHAEAN LETTER XOPHMANICHAEAN LETTER QHOPHMANICHAEAN LE" +
	"TTER RESHMANICHAEAN LETTER SHINMANICHAEAN LETTER SSHINMANICHAEAN LETTER " +
	"TAWMANICHAEAN ABBREVIATION MARK ABOVEMANICHAEAN ABBREVIATION MARK BELOWM" +
	"ANICHAEAN NUMBER ONEMANICHAEAN NUMBER FIVEMANICHAEAN NUMBER TENMANICHAEA" +
	"N NUMBER TWENTYMANICHAEAN NUMBER ONE HUNDREDMANICHAEAN PUNCTUATION STARM" +
	"ANICHAEAN PUNCTUATION FLEURONMANICHAEAN PUNCTUATION DOUBLE DOT WITHIN DO" +
	"TMANICHAEAN PUNCTUATION DOT WITHIN DOTMANICHAEAN PUNCTUATION DOTMANICHAE" +
	"AN PUNCTUATION TWO DOTSMANICHAEAN PUNCTUATION LINE FILLERAVESTAN LETTER " +
	"AAVESTAN LETTER AAAVESTAN LETTER AOAVESTAN LETTER AAOAVESTAN LETTER ANAV" +
	"ESTAN LETTER AANAVESTAN LETTER AEAVESTAN LETTER AEEAVESTAN LETTER EAVEST" +
	"AN LETTER EEAVESTAN LETTER OAVESTAN LETTER OOAVESTAN LETTER IAVESTAN LET" +
	"TER IIAVESTAN LETTER UAVESTAN LETTER UUAVESTAN LETTER KEAVESTAN LETTER X" +
	"EAVESTAN LETTER XYEAVESTAN LETTER XVEAVESTAN LETTER GEAVESTAN LETTER GGE" +
	"AVESTAN LETTER GHEAVESTAN LETTER CEAVESTAN LETTER JEAVESTAN LETTER TEAVE" +
	"STAN LETTER THEAVESTAN LETTER DEAVESTAN LETTER DHEAVESTAN LETTER TTEAVES" +
	"TAN LETTER PEAVESTAN LETTER FEAVESTAN LETTER BEAVESTAN LETTER BHEAVESTAN" +
	" LETTER NGEAVESTAN LETTER NGYEAVESTAN LETTER NGVEAVESTAN LETTER NEAVESTA" +
	"N LETTER NYEAVESTAN LETTER NNEAVESTAN LETTER MEAVESTAN LETTER HMEAVESTAN" +
	" LETTER YYEAVESTAN LETTER YEAVESTAN LETTER VEAVESTAN LETTER REAVESTAN LE" +
	"TTER LEAVESTAN LETTER SEAVESTAN LETTER ZEAVESTAN LETTER SHEAVESTAN LETTE" +
	"R ZHEAVESTAN LETTER SHYEAVESTAN LETTER SSHEAVESTAN LETTER HEAVESTAN ABBR" +
	"EVIATION MARKTINY TWO DOTS OVER ONE DOT PUNCTUATIONSMALL TWO DOTS OVER O" +
	"NE DOT PUNCTUATIONLARGE TWO DOTS OVER ONE DOT PUNCTUATIONLARGE ONE DOT O" +
	"VER TWO DOTS PUNCTUATIONLARGE TWO RINGS OVER ONE RING PUNCTUATIONLARGE O" +
	"NE RING OVER TWO RINGS PUNCTUATIONINSCRIPTIONAL PARTHIAN LETTER ALEPHINS" +
	"CRIPTIONAL PARTHIAN LETTER BETHINSCRIPTIONAL PARTHIAN LETTER GIMELINSCRI" +
	"PTIONAL PARTHIAN LETTER DALETHINSCRIPTIONAL PARTHIAN LETTER HEINSCRIPTIO" +
	"NAL PARTHIAN LETTER WAWINSCRIPTIONAL PARTHIAN LETTER ZAYININSCRIPTIONAL " +
	"PARTHIAN LETTER HETHINSCRIPTIONAL PARTHIAN LETTER TETHINSCRIPTIONAL PART" +
	"HIAN LETTER YODHINSCRIPTIONAL PARTHIAN LETTER KAPHINSCRIPTIONAL PARTHIAN" +
	" LETTER LAMEDHINSCRIPTIONAL PARTHIAN LETTER MEMINSCRIPTIONAL PARTHIAN LE" +
	"TTER NUNINSCRIPTIONAL PARTHIAN LETTER SAMEKHINSCRIPTIONAL PARTHIAN LETTE" +
	"R AYININSCRIPTIONAL PARTHIAN LETTER PEINSCRIPTIONAL PARTHIAN LETTER SADH" +
	"EINSCRIPTIONAL PARTHIAN LETTER QOPHINSCRIPTIONAL PARTHIAN LETTER RESHINS" +
	"CRIPTIONAL PARTHIAN LETTER SHININSCRIPTIONAL PARTHIAN LETTER TAWINSCRIPT" +
	"IONAL PARTHIAN NUMBER ONEINSCRIPTIONAL PARTHIAN NUMBER TWOINSCRIPTIONAL " +
	"PARTHIAN NUMBER THREEINSCRIPTIONAL PARTHIAN NUMBER FOURINSCRIPTIONAL PAR" +
	"THIAN NUMBER TENINSCRIPTIONAL PARTHIAN NUMBER TWENTYINSCRIPTIONAL PARTHI" +
	"AN NUMBER ONE HUNDREDINSCRIPTIONAL PARTHIAN NUMBER ONE THOUSANDINSCRIPTI" +
	"ONAL PAHLAVI LETTER ALEPHINSCRIPTIONAL PAHLAVI LETTER BETHINSCRIPTIONAL " +
	"PAHLAVI LETTER GIMELINSCRIPTIONAL PAHLAVI LETTER DALETHINSCRIPTIONAL PAH" +
	"LAVI LETTER HEINSCRIPTIONAL PAHLAVI LETTER WAW-AYIN-RESHINSCRIPTIONAL PA" +
	"HLAVI LETTER ZAYININSCRIPTIONAL PAHLAVI LETTER HETHINSCRIPTIONAL PAHLAVI" +
	" LETTER TETHINSCRIPTIONAL PAHLAVI LETTER YODHINSCRIPTIONAL PAHLAVI LETTE" +
	"R KAPHINSCRIPTIONAL PAHLAVI LETTER LAMEDHINSCRIPTIONAL PAHLAVI LETTER ME" +
	"M-QOPHINSCRIPTIONAL PAHLAVI LETTER NUNINSCRIPTIONAL PAHLAVI LETTER SAMEK" +
	"HINSCRIPTIONAL PAHLAVI LETTER PEINSCRIPTIONAL PAHLAVI LETTER SADHEINSCRI" +
	"PTIONAL PAHLAVI LETTER SHININSCRIPTIONAL PAHLAVI LETTER TAWINSCRIPTIONAL" +
	" PAHLAVI NUMBER ONEINSCRIPTIONAL PAHLAVI NUMBER TWOINSCRIPTIONAL PAHLAVI" +
	" NUMBER THREEINSCRIPTIONAL PAHLAVI NUMBER FOURINSCRIPTIONAL PAHLAVI NUMB" +
	"ER TENINSCRIPTIONAL PAHLAVI NUMBER TWENTYINSCRIPTIONAL PAHLAVI NUMBER ON" +
	"E HUNDREDINSCRIPTIONAL PAHLAVI NUMBER ONE THOUSANDPSALTER PAHLAVI LETTER" +
	" ALEPHPSALTER PAHLAVI LETTER BETHPSALTER PAHLAVI LETTER GIMELPSALTER PAH" +
	"LAVI LETTER DALETHPSALTER PAHLAVI LETTER HEPSALTER PAHLAVI LETTER WAW-AY" +
	"IN-RESHPSALTER PAHLAVI LETTER ZAYINPSALTER PAHLAVI LETTER HETHPSALTER PA" +
	"HLAVI LETTER YODHPSALTER PAHLAVI LETTER KAPHPSALTER PAHLAVI LETTER LAMED" +
	"HPSALTER PAHLAVI LETTER MEM-QOPHPSALTER PAHLAVI LETTER NUNPSALTER PAHLAV" +
	"I LETTER SAMEKHPSALTER PAHLAVI LETTER PEPSALTER PAHLAVI LETTER SADHEPSAL" +
	"TER PAHLAVI LETTER SHINPSALTER PAHLAVI LETTER TAWPSALTER PAHLAVI SECTION" +
	" MARKPSALTER PAHLAVI TURNED SECTION MARKPSALTER PAHLAVI FOUR DOTS WITH C" +
	"ROSSPSALTER PAHLAVI FOUR DOTS WITH DOTPSALTER PAHLAVI NUMBER ONEPSALTER ") + ("" +
	"PAHLAVI NUMBER TWOPSALTER PAHLAVI NUMBER THREEPSALTER PAHLAVI NUMBER FOU" +
	"RPSALTER PAHLAVI NUMBER TENPSALTER PAHLAVI NUMBER TWENTYPSALTER PAHLAVI " +
	"NUMBER ONE HUNDREDOLD TURKIC LETTER ORKHON AOLD TURKIC LETTER YENISEI AO" +
	"LD TURKIC LETTER YENISEI AEOLD TURKIC LETTER ORKHON IOLD TURKIC LETTER Y" +
	"ENISEI IOLD TURKIC LETTER YENISEI EOLD TURKIC LETTER ORKHON OOLD TURKIC " +
	"LETTER ORKHON OEOLD TURKIC LETTER YENISEI OEOLD TURKIC LETTER ORKHON ABO" +
	"LD TURKIC LETTER YENISEI ABOLD TURKIC LETTER ORKHON AEBOLD TURKIC LETTER" +
	" YENISEI AEBOLD TURKIC LETTER ORKHON AGOLD TURKIC LETTER YENISEI AGOLD T" +
	"URKIC LETTER ORKHON AEGOLD TURKIC LETTER YENISEI AEGOLD TURKIC LETTER OR" +
	"KHON ADOLD TURKIC LETTER YENISEI ADOLD TURKIC LETTER ORKHON AEDOLD TURKI" +
	"C LETTER ORKHON EZOLD TURKIC LETTER YENISEI EZOLD TURKIC LETTER ORKHON A" +
	"YOLD TURKIC LETTER YENISEI AYOLD TURKIC LETTER ORKHON AEYOLD TURKIC LETT" +
	"ER YENISEI AEYOLD TURKIC LETTER ORKHON AEKOLD TURKIC LETTER YENISEI AEKO" +
	"LD TURKIC LETTER ORKHON OEKOLD TURKIC LETTER YENISEI OEKOLD TURKIC LETTE" +
	"R ORKHON ALOLD TURKIC LETTER YENISEI ALOLD TURKIC LETTER ORKHON AELOLD T" +
	"URKIC LETTER ORKHON ELTOLD TURKIC LETTER ORKHON EMOLD TURKIC LETTER ORKH" +
	"ON ANOLD TURKIC LETTER ORKHON AENOLD TURKIC LETTER YENISEI AENOLD TURKIC" +
	" LETTER ORKHON ENTOLD TURKIC LETTER YENISEI ENTOLD TURKIC LETTER ORKHON " +
	"ENCOLD TURKIC LETTER YENISEI ENCOLD TURKIC LETTER ORKHON ENYOLD TURKIC L" +
	"ETTER YENISEI ENYOLD TURKIC LETTER YENISEI ANGOLD TURKIC LETTER ORKHON E" +
	"NGOLD TURKIC LETTER YENISEI AENGOLD TURKIC LETTER ORKHON EPOLD TURKIC LE" +
	"TTER ORKHON OPOLD TURKIC LETTER ORKHON ICOLD TURKIC LETTER ORKHON ECOLD " +
	"TURKIC LETTER YENISEI ECOLD TURKIC LETTER ORKHON AQOLD TURKIC LETTER YEN" +
	"ISEI AQOLD TURKIC LETTER ORKHON IQOLD TURKIC LETTER YENISEI IQOLD TURKIC" +
	" LETTER ORKHON OQOLD TURKIC LETTER YENISEI OQOLD TURKIC LETTER ORKHON AR" +
	"OLD TURKIC LETTER YENISEI AROLD TURKIC LETTER ORKHON AEROLD TURKIC LETTE" +
	"R ORKHON ASOLD TURKIC LETTER ORKHON AESOLD TURKIC LETTER ORKHON ASHOLD T" +
	"URKIC LETTER YENISEI ASHOLD TURKIC LETTER ORKHON ESHOLD TURKIC LETTER YE" +
	"NISEI ESHOLD TURKIC LETTER ORKHON ATOLD TURKIC LETTER YENISEI ATOLD TURK" +
	"IC LETTER ORKHON AETOLD TURKIC LETTER YENISEI AETOLD TURKIC LETTER ORKHO" +
	"N OTOLD TURKIC LETTER ORKHON BASHOLD HUNGARIAN CAPITAL LETTER AOLD HUNGA" +
	"RIAN CAPITAL LETTER AAOLD HUNGARIAN CAPITAL LETTER EBOLD HUNGARIAN CAPIT" +
	"AL LETTER AMBOLD HUNGARIAN CAPITAL LETTER ECOLD HUNGARIAN CAPITAL LETTER" +
	" ENCOLD HUNGARIAN CAPITAL LETTER ECSOLD HUNGARIAN CAPITAL LETTER EDOLD H" +
	"UNGARIAN CAPITAL LETTER ANDOLD HUNGARIAN CAPITAL LETTER EOLD HUNGARIAN C" +
	"APITAL LETTER CLOSE EOLD HUNGARIAN CAPITAL LETTER EEOLD HUNGARIAN CAPITA" +
	"L LETTER EFOLD HUNGARIAN CAPITAL LETTER EGOLD HUNGARIAN CAPITAL LETTER E" +
	"GYOLD HUNGARIAN CAPITAL LETTER EHOLD HUNGARIAN CAPITAL LETTER IOLD HUNGA" +
	"RIAN CAPITAL LETTER IIOLD HUNGARIAN CAPITAL LETTER EJOLD HUNGARIAN CAPIT" +
	"AL LETTER EKOLD HUNGARIAN CAPITAL LETTER AKOLD HUNGARIAN CAPITAL LETTER " +
	"UNKOLD HUNGARIAN CAPITAL LETTER ELOLD HUNGARIAN CAPITAL LETTER ELYOLD HU" +
	"NGARIAN CAPITAL LETTER EMOLD HUNGARIAN CAPITAL LETTER ENOLD HUNGARIAN CA" +
	"PITAL LETTER ENYOLD HUNGARIAN CAPITAL LETTER OOLD HUNGARIAN CAPITAL LETT" +
	"ER OOOLD HUNGARIAN CAPITAL LETTER NIKOLSBURG OEOLD HUNGARIAN CAPITAL LET" +
	"TER RUDIMENTA OEOLD HUNGARIAN CAPITAL LETTER OEEOLD HUNGARIAN CAPITAL LE" +
	"TTER EPOLD HUNGARIAN CAPITAL LETTER EMPOLD HUNGARIAN CAPITAL LETTER EROL" +
	"D HUNGARIAN CAPITAL LETTER SHORT EROLD HUNGARIAN CAPITAL LETTER ESOLD HU" +
	"NGARIAN CAPITAL LETTER ESZOLD HUNGARIAN CAPITAL LETTER ETOLD HUNGARIAN C" +
	"APITAL LETTER ENTOLD HUNGARIAN CAPITAL LETTER ETYOLD HUNGARIAN CAPITAL L" +
	"ETTER ECHOLD HUNGARIAN CAPITAL LETTER UOLD HUNGARIAN CAPITAL LETTER UUOL" +
	"D HUNGARIAN CAPITAL LETTER NIKOLSBURG UEOLD HUNGARIAN CAPITAL LETTER RUD" +
	"IMENTA UEOLD HUNGARIAN CAPITAL LETTER EVOLD HUNGARIAN CAPITAL LETTER EZO" +
	"LD HUNGARIAN CAPITAL LETTER EZSOLD HUNGARIAN CAPITAL LETTER ENT-SHAPED S" +
	"IGNOLD HUNGARIAN CAPITAL LETTER USOLD HUNGARIAN SMALL LETTER AOLD HUNGAR" +
	"IAN SMALL LETTER AAOLD HUNGARIAN SMALL LETTER EBOLD HUNGARIAN SMALL LETT" +
	"ER AMBOLD HUNGARIAN SMALL LETTER ECOLD HUNGARIAN SMALL LETTER ENCOLD HUN" +
	"GARIAN SMALL LETTER ECSOLD HUNGARIAN SMALL LETTER EDOLD HUNGARIAN SMALL " +
	"LETTER ANDOLD HUNGARIAN SMALL LETTER EOLD HUNGARIAN SMALL LETTER CLOSE E" +
	"OLD HUNGARIAN SMALL LETTER EEOLD HUNGARIAN SMALL LETTER EFOLD HUNGARIAN " +
	"SMALL LETTER EGOLD HUNGARIAN SMALL LETTER EGYOLD HUNGARIAN SMALL LETTER " +
	"EHOLD HUNGARIAN SMALL LETTER IOLD HUNGARIAN SMALL LETTER IIOLD HUNGARIAN" +
	" SMALL LETTER EJOLD HUNGARIAN SMALL LETTER EKOLD HUNGARIAN SMALL LETTER " +
	"AKOLD HUNGARIAN SMALL LETTER UNKOLD HUNGARIAN SMALL LETTER ELOLD HUNGARI" +
	"AN SMALL LETTER ELYOLD HUNGARIAN SMALL LETTER EMOLD HUNGARIAN SMALL LETT") + ("" +
	"ER ENOLD HUNGARIAN SMALL LETTER ENYOLD HUNGARIAN SMALL LETTER OOLD HUNGA" +
	"RIAN SMALL LETTER OOOLD HUNGARIAN SMALL LETTER NIKOLSBURG OEOLD HUNGARIA" +
	"N SMALL LETTER RUDIMENTA OEOLD HUNGARIAN SMALL LETTER OEEOLD HUNGARIAN S" +
	"MALL LETTER EPOLD HUNGARIAN SMALL LETTER EMPOLD HUNGARIAN SMALL LETTER E" +
	"ROLD HUNGARIAN SMALL LETTER SHORT EROLD HUNGARIAN SMALL LETTER ESOLD HUN" +
	"GARIAN SMALL LETTER ESZOLD HUNGARIAN SMALL LETTER ETOLD HUNGARIAN SMALL " +
	"LETTER ENTOLD HUNGARIAN SMALL LETTER ETYOLD HUNGARIAN SMALL LETTER ECHOL" +
	"D HUNGARIAN SMALL LETTER UOLD HUNGARIAN SMALL LETTER UUOLD HUNGARIAN SMA" +
	"LL LETTER NIKOLSBURG UEOLD HUNGARIAN SMALL LETTER RUDIMENTA UEOLD HUNGAR" +
	"IAN SMALL LETTER EVOLD HUNGARIAN SMALL LETTER EZOLD HUNGARIAN SMALL LETT" +
	"ER EZSOLD HUNGARIAN SMALL LETTER ENT-SHAPED SIGNOLD HUNGARIAN SMALL LETT" +
	"ER USOLD HUNGARIAN NUMBER ONEOLD HUNGARIAN NUMBER FIVEOLD HUNGARIAN NUMB" +
	"ER TENOLD HUNGARIAN NUMBER FIFTYOLD HUNGARIAN NUMBER ONE HUNDREDOLD HUNG" +
	"ARIAN NUMBER ONE THOUSANDRUMI DIGIT ONERUMI DIGIT TWORUMI DIGIT THREERUM" +
	"I DIGIT FOURRUMI DIGIT FIVERUMI DIGIT SIXRUMI DIGIT SEVENRUMI DIGIT EIGH" +
	"TRUMI DIGIT NINERUMI NUMBER TENRUMI NUMBER TWENTYRUMI NUMBER THIRTYRUMI " +
	"NUMBER FORTYRUMI NUMBER FIFTYRUMI NUMBER SIXTYRUMI NUMBER SEVENTYRUMI NU" +
	"MBER EIGHTYRUMI NUMBER NINETYRUMI NUMBER ONE HUNDREDRUMI NUMBER TWO HUND" +
	"REDRUMI NUMBER THREE HUNDREDRUMI NUMBER FOUR HUNDREDRUMI NUMBER FIVE HUN" +
	"DREDRUMI NUMBER SIX HUNDREDRUMI NUMBER SEVEN HUNDREDRUMI NUMBER EIGHT HU" +
	"NDREDRUMI NUMBER NINE HUNDREDRUMI FRACTION ONE HALFRUMI FRACTION ONE QUA" +
	"RTERRUMI FRACTION ONE THIRDRUMI FRACTION TWO THIRDSBRAHMI SIGN CANDRABIN" +
	"DUBRAHMI SIGN ANUSVARABRAHMI SIGN VISARGABRAHMI SIGN JIHVAMULIYABRAHMI S" +
	"IGN UPADHMANIYABRAHMI LETTER ABRAHMI LETTER AABRAHMI LETTER IBRAHMI LETT" +
	"ER IIBRAHMI LETTER UBRAHMI LETTER UUBRAHMI LETTER VOCALIC RBRAHMI LETTER" +
	" VOCALIC RRBRAHMI LETTER VOCALIC LBRAHMI LETTER VOCALIC LLBRAHMI LETTER " +
	"EBRAHMI LETTER AIBRAHMI LETTER OBRAHMI LETTER AUBRAHMI LETTER KABRAHMI L" +
	"ETTER KHABRAHMI LETTER GABRAHMI LETTER GHABRAHMI LETTER NGABRAHMI LETTER" +
	" CABRAHMI LETTER CHABRAHMI LETTER JABRAHMI LETTER JHABRAHMI LETTER NYABR" +
	"AHMI LETTER TTABRAHMI LETTER TTHABRAHMI LETTER DDABRAHMI LETTER DDHABRAH" +
	"MI LETTER NNABRAHMI LETTER TABRAHMI LETTER THABRAHMI LETTER DABRAHMI LET" +
	"TER DHABRAHMI LETTER NABRAHMI LETTER PABRAHMI LETTER PHABRAHMI LETTER BA" +
	"BRAHMI LETTER BHABRAHMI LETTER MABRAHMI LETTER YABRAHMI LETTER RABRAHMI " +
	"LETTER LABRAHMI LETTER VABRAHMI LETTER SHABRAHMI LETTER SSABRAHMI LETTER" +
	" SABRAHMI LETTER HABRAHMI LETTER LLABRAHMI LETTER OLD TAMIL LLLABRAHMI L" +
	"ETTER OLD TAMIL RRABRAHMI LETTER OLD TAMIL NNNABRAHMI VOWEL SIGN AABRAHM" +
	"I VOWEL SIGN BHATTIPROLU AABRAHMI VOWEL SIGN IBRAHMI VOWEL SIGN IIBRAHMI" +
	" VOWEL SIGN UBRAHMI VOWEL SIGN UUBRAHMI VOWEL SIGN VOCALIC RBRAHMI VOWEL" +
	" SIGN VOCALIC RRBRAHMI VOWEL SIGN VOCALIC LBRAHMI VOWEL SIGN VOCALIC LLB" +
	"RAHMI VOWEL SIGN EBRAHMI VOWEL SIGN AIBRAHMI VOWEL SIGN OBRAHMI VOWEL SI" +
	"GN AUBRAHMI VIRAMABRAHMI DANDABRAHMI DOUBLE DANDABRAHMI PUNCTUATION DOTB" +
	"RAHMI PUNCTUATION DOUBLE DOTBRAHMI PUNCTUATION LINEBRAHMI PUNCTUATION CR" +
	"ESCENT BARBRAHMI PUNCTUATION LOTUSBRAHMI NUMBER ONEBRAHMI NUMBER TWOBRAH" +
	"MI NUMBER THREEBRAHMI NUMBER FOURBRAHMI NUMBER FIVEBRAHMI NUMBER SIXBRAH" +
	"MI NUMBER SEVENBRAHMI NUMBER EIGHTBRAHMI NUMBER NINEBRAHMI NUMBER TENBRA" +
	"HMI NUMBER TWENTYBRAHMI NUMBER THIRTYBRAHMI NUMBER FORTYBRAHMI NUMBER FI" +
	"FTYBRAHMI NUMBER SIXTYBRAHMI NUMBER SEVENTYBRAHMI NUMBER EIGHTYBRAHMI NU" +
	"MBER NINETYBRAHMI NUMBER ONE HUNDREDBRAHMI NUMBER ONE THOUSANDBRAHMI DIG" +
	"IT ZEROBRAHMI DIGIT ONEBRAHMI DIGIT TWOBRAHMI DIGIT THREEBRAHMI DIGIT FO" +
	"URBRAHMI DIGIT FIVEBRAHMI DIGIT SIXBRAHMI DIGIT SEVENBRAHMI DIGIT EIGHTB" +
	"RAHMI DIGIT NINEBRAHMI NUMBER JOINERKAITHI SIGN CANDRABINDUKAITHI SIGN A" +
	"NUSVARAKAITHI SIGN VISARGAKAITHI LETTER AKAITHI LETTER AAKAITHI LETTER I" +
	"KAITHI LETTER IIKAITHI LETTER UKAITHI LETTER UUKAITHI LETTER EKAITHI LET" +
	"TER AIKAITHI LETTER OKAITHI LETTER AUKAITHI LETTER KAKAITHI LETTER KHAKA" +
	"ITHI LETTER GAKAITHI LETTER GHAKAITHI LETTER NGAKAITHI LETTER CAKAITHI L" +
	"ETTER CHAKAITHI LETTER JAKAITHI LETTER JHAKAITHI LETTER NYAKAITHI LETTER" +
	" TTAKAITHI LETTER TTHAKAITHI LETTER DDAKAITHI LETTER DDDHAKAITHI LETTER " +
	"DDHAKAITHI LETTER RHAKAITHI LETTER NNAKAITHI LETTER TAKAITHI LETTER THAK" +
	"AITHI LETTER DAKAITHI LETTER DHAKAITHI LETTER NAKAITHI LETTER PAKAITHI L" +
	"ETTER PHAKAITHI LETTER BAKAITHI LETTER BHAKAITHI LETTER MAKAITHI LETTER " +
	"YAKAITHI LETTER RAKAITHI LETTER LAKAITHI LETTER VAKAITHI LETTER SHAKAITH" +
	"I LETTER SSAKAITHI LETTER SAKAITHI LETTER HAKAITHI VOWEL SIGN AAKAITHI V" +
	"OWEL SIGN IKAITHI VOWEL SIGN IIKAITHI VOWEL SIGN UKAITHI VOWEL SIGN UUKA" +
	"ITHI VOWEL SIGN EKAITHI VOWEL SIGN AIKAITHI VOWEL SIGN OKAITHI VOWEL SIG") + ("" +
	"N AUKAITHI SIGN VIRAMAKAITHI SIGN NUKTAKAITHI ABBREVIATION SIGNKAITHI EN" +
	"UMERATION SIGNKAITHI NUMBER SIGNKAITHI SECTION MARKKAITHI DOUBLE SECTION" +
	" MARKKAITHI DANDAKAITHI DOUBLE DANDASORA SOMPENG LETTER SAHSORA SOMPENG " +
	"LETTER TAHSORA SOMPENG LETTER BAHSORA SOMPENG LETTER CAHSORA SOMPENG LET" +
	"TER DAHSORA SOMPENG LETTER GAHSORA SOMPENG LETTER MAHSORA SOMPENG LETTER" +
	" NGAHSORA SOMPENG LETTER LAHSORA SOMPENG LETTER NAHSORA SOMPENG LETTER V" +
	"AHSORA SOMPENG LETTER PAHSORA SOMPENG LETTER YAHSORA SOMPENG LETTER RAHS" +
	"ORA SOMPENG LETTER HAHSORA SOMPENG LETTER KAHSORA SOMPENG LETTER JAHSORA" +
	" SOMPENG LETTER NYAHSORA SOMPENG LETTER AHSORA SOMPENG LETTER EEHSORA SO" +
	"MPENG LETTER IHSORA SOMPENG LETTER UHSORA SOMPENG LETTER OHSORA SOMPENG " +
	"LETTER EHSORA SOMPENG LETTER MAESORA SOMPENG DIGIT ZEROSORA SOMPENG DIGI" +
	"T ONESORA SOMPENG DIGIT TWOSORA SOMPENG DIGIT THREESORA SOMPENG DIGIT FO" +
	"URSORA SOMPENG DIGIT FIVESORA SOMPENG DIGIT SIXSORA SOMPENG DIGIT SEVENS" +
	"ORA SOMPENG DIGIT EIGHTSORA SOMPENG DIGIT NINECHAKMA SIGN CANDRABINDUCHA" +
	"KMA SIGN ANUSVARACHAKMA SIGN VISARGACHAKMA LETTER AACHAKMA LETTER ICHAKM" +
	"A LETTER UCHAKMA LETTER ECHAKMA LETTER KAACHAKMA LETTER KHAACHAKMA LETTE" +
	"R GAACHAKMA LETTER GHAACHAKMA LETTER NGAACHAKMA LETTER CAACHAKMA LETTER " +
	"CHAACHAKMA LETTER JAACHAKMA LETTER JHAACHAKMA LETTER NYAACHAKMA LETTER T" +
	"TAACHAKMA LETTER TTHAACHAKMA LETTER DDAACHAKMA LETTER DDHAACHAKMA LETTER" +
	" NNAACHAKMA LETTER TAACHAKMA LETTER THAACHAKMA LETTER DAACHAKMA LETTER D" +
	"HAACHAKMA LETTER NAACHAKMA LETTER PAACHAKMA LETTER PHAACHAKMA LETTER BAA" +
	"CHAKMA LETTER BHAACHAKMA LETTER MAACHAKMA LETTER YYAACHAKMA LETTER YAACH" +
	"AKMA LETTER RAACHAKMA LETTER LAACHAKMA LETTER WAACHAKMA LETTER SAACHAKMA" +
	" LETTER HAACHAKMA VOWEL SIGN ACHAKMA VOWEL SIGN ICHAKMA VOWEL SIGN IICHA" +
	"KMA VOWEL SIGN UCHAKMA VOWEL SIGN UUCHAKMA VOWEL SIGN ECHAKMA VOWEL SIGN" +
	" AICHAKMA VOWEL SIGN OCHAKMA VOWEL SIGN AUCHAKMA VOWEL SIGN OICHAKMA O M" +
	"ARKCHAKMA AU MARKCHAKMA VIRAMACHAKMA MAAYYAACHAKMA DIGIT ZEROCHAKMA DIGI" +
	"T ONECHAKMA DIGIT TWOCHAKMA DIGIT THREECHAKMA DIGIT FOURCHAKMA DIGIT FIV" +
	"ECHAKMA DIGIT SIXCHAKMA DIGIT SEVENCHAKMA DIGIT EIGHTCHAKMA DIGIT NINECH" +
	"AKMA SECTION MARKCHAKMA DANDACHAKMA DOUBLE DANDACHAKMA QUESTION MARKMAHA" +
	"JANI LETTER AMAHAJANI LETTER IMAHAJANI LETTER UMAHAJANI LETTER EMAHAJANI" +
	" LETTER OMAHAJANI LETTER KAMAHAJANI LETTER KHAMAHAJANI LETTER GAMAHAJANI" +
	" LETTER GHAMAHAJANI LETTER CAMAHAJANI LETTER CHAMAHAJANI LETTER JAMAHAJA" +
	"NI LETTER JHAMAHAJANI LETTER NYAMAHAJANI LETTER TTAMAHAJANI LETTER TTHAM" +
	"AHAJANI LETTER DDAMAHAJANI LETTER DDHAMAHAJANI LETTER NNAMAHAJANI LETTER" +
	" TAMAHAJANI LETTER THAMAHAJANI LETTER DAMAHAJANI LETTER DHAMAHAJANI LETT" +
	"ER NAMAHAJANI LETTER PAMAHAJANI LETTER PHAMAHAJANI LETTER BAMAHAJANI LET" +
	"TER BHAMAHAJANI LETTER MAMAHAJANI LETTER RAMAHAJANI LETTER LAMAHAJANI LE" +
	"TTER VAMAHAJANI LETTER SAMAHAJANI LETTER HAMAHAJANI LETTER RRAMAHAJANI S" +
	"IGN NUKTAMAHAJANI ABBREVIATION SIGNMAHAJANI SECTION MARKMAHAJANI LIGATUR" +
	"E SHRISHARADA SIGN CANDRABINDUSHARADA SIGN ANUSVARASHARADA SIGN VISARGAS" +
	"HARADA LETTER ASHARADA LETTER AASHARADA LETTER ISHARADA LETTER IISHARADA" +
	" LETTER USHARADA LETTER UUSHARADA LETTER VOCALIC RSHARADA LETTER VOCALIC" +
	" RRSHARADA LETTER VOCALIC LSHARADA LETTER VOCALIC LLSHARADA LETTER ESHAR" +
	"ADA LETTER AISHARADA LETTER OSHARADA LETTER AUSHARADA LETTER KASHARADA L" +
	"ETTER KHASHARADA LETTER GASHARADA LETTER GHASHARADA LETTER NGASHARADA LE" +
	"TTER CASHARADA LETTER CHASHARADA LETTER JASHARADA LETTER JHASHARADA LETT" +
	"ER NYASHARADA LETTER TTASHARADA LETTER TTHASHARADA LETTER DDASHARADA LET" +
	"TER DDHASHARADA LETTER NNASHARADA LETTER TASHARADA LETTER THASHARADA LET" +
	"TER DASHARADA LETTER DHASHARADA LETTER NASHARADA LETTER PASHARADA LETTER" +
	" PHASHARADA LETTER BASHARADA LETTER BHASHARADA LETTER MASHARADA LETTER Y" +
	"ASHARADA LETTER RASHARADA LETTER LASHARADA LETTER LLASHARADA LETTER VASH" +
	"ARADA LETTER SHASHARADA LETTER SSASHARADA LETTER SASHARADA LETTER HASHAR" +
	"ADA VOWEL SIGN AASHARADA VOWEL SIGN ISHARADA VOWEL SIGN IISHARADA VOWEL " +
	"SIGN USHARADA VOWEL SIGN UUSHARADA VOWEL SIGN VOCALIC RSHARADA VOWEL SIG" +
	"N VOCALIC RRSHARADA VOWEL SIGN VOCALIC LSHARADA VOWEL SIGN VOCALIC LLSHA" +
	"RADA VOWEL SIGN ESHARADA VOWEL SIGN AISHARADA VOWEL SIGN OSHARADA VOWEL " +
	"SIGN AUSHARADA SIGN VIRAMASHARADA SIGN AVAGRAHASHARADA SIGN JIHVAMULIYAS" +
	"HARADA SIGN UPADHMANIYASHARADA OMSHARADA DANDASHARADA DOUBLE DANDASHARAD" +
	"A ABBREVIATION SIGNSHARADA SEPARATORSHARADA SANDHI MARKSHARADA SIGN NUKT" +
	"ASHARADA VOWEL MODIFIER MARKSHARADA EXTRA SHORT VOWEL MARKSHARADA SUTRA " +
	"MARKSHARADA DIGIT ZEROSHARADA DIGIT ONESHARADA DIGIT TWOSHARADA DIGIT TH" +
	"REESHARADA DIGIT FOURSHARADA DIGIT FIVESHARADA DIGIT SIXSHARADA DIGIT SE" +
	"VENSHARADA DIGIT EIGHTSHARADA DIGIT NINESHARADA EKAMSHARADA SIGN SIDDHAM") + ("" +
	"SHARADA HEADSTROKESHARADA CONTINUATION SIGNSHARADA SECTION MARK-1SHARADA" +
	" SECTION MARK-2SINHALA ARCHAIC DIGIT ONESINHALA ARCHAIC DIGIT TWOSINHALA" +
	" ARCHAIC DIGIT THREESINHALA ARCHAIC DIGIT FOURSINHALA ARCHAIC DIGIT FIVE" +
	"SINHALA ARCHAIC DIGIT SIXSINHALA ARCHAIC DIGIT SEVENSINHALA ARCHAIC DIGI" +
	"T EIGHTSINHALA ARCHAIC DIGIT NINESINHALA ARCHAIC NUMBER TENSINHALA ARCHA" +
	"IC NUMBER TWENTYSINHALA ARCHAIC NUMBER THIRTYSINHALA ARCHAIC NUMBER FORT" +
	"YSINHALA ARCHAIC NUMBER FIFTYSINHALA ARCHAIC NUMBER SIXTYSINHALA ARCHAIC" +
	" NUMBER SEVENTYSINHALA ARCHAIC NUMBER EIGHTYSINHALA ARCHAIC NUMBER NINET" +
	"YSINHALA ARCHAIC NUMBER ONE HUNDREDSINHALA ARCHAIC NUMBER ONE THOUSANDKH" +
	"OJKI LETTER AKHOJKI LETTER AAKHOJKI LETTER IKHOJKI LETTER UKHOJKI LETTER" +
	" EKHOJKI LETTER AIKHOJKI LETTER OKHOJKI LETTER AUKHOJKI LETTER KAKHOJKI " +
	"LETTER KHAKHOJKI LETTER GAKHOJKI LETTER GGAKHOJKI LETTER GHAKHOJKI LETTE" +
	"R NGAKHOJKI LETTER CAKHOJKI LETTER CHAKHOJKI LETTER JAKHOJKI LETTER JJAK" +
	"HOJKI LETTER NYAKHOJKI LETTER TTAKHOJKI LETTER TTHAKHOJKI LETTER DDAKHOJ" +
	"KI LETTER DDHAKHOJKI LETTER NNAKHOJKI LETTER TAKHOJKI LETTER THAKHOJKI L" +
	"ETTER DAKHOJKI LETTER DDDAKHOJKI LETTER DHAKHOJKI LETTER NAKHOJKI LETTER" +
	" PAKHOJKI LETTER PHAKHOJKI LETTER BAKHOJKI LETTER BBAKHOJKI LETTER BHAKH" +
	"OJKI LETTER MAKHOJKI LETTER YAKHOJKI LETTER RAKHOJKI LETTER LAKHOJKI LET" +
	"TER VAKHOJKI LETTER SAKHOJKI LETTER HAKHOJKI LETTER LLAKHOJKI VOWEL SIGN" +
	" AAKHOJKI VOWEL SIGN IKHOJKI VOWEL SIGN IIKHOJKI VOWEL SIGN UKHOJKI VOWE" +
	"L SIGN EKHOJKI VOWEL SIGN AIKHOJKI VOWEL SIGN OKHOJKI VOWEL SIGN AUKHOJK" +
	"I SIGN ANUSVARAKHOJKI SIGN VIRAMAKHOJKI SIGN NUKTAKHOJKI SIGN SHADDAKHOJ" +
	"KI DANDAKHOJKI DOUBLE DANDAKHOJKI WORD SEPARATORKHOJKI SECTION MARKKHOJK" +
	"I DOUBLE SECTION MARKKHOJKI ABBREVIATION SIGNKHOJKI SIGN SUKUNMULTANI LE" +
	"TTER AMULTANI LETTER IMULTANI LETTER UMULTANI LETTER EMULTANI LETTER KAM" +
	"ULTANI LETTER KHAMULTANI LETTER GAMULTANI LETTER GHAMULTANI LETTER CAMUL" +
	"TANI LETTER CHAMULTANI LETTER JAMULTANI LETTER JJAMULTANI LETTER NYAMULT" +
	"ANI LETTER TTAMULTANI LETTER TTHAMULTANI LETTER DDAMULTANI LETTER DDDAMU" +
	"LTANI LETTER DDHAMULTANI LETTER NNAMULTANI LETTER TAMULTANI LETTER THAMU" +
	"LTANI LETTER DAMULTANI LETTER DHAMULTANI LETTER NAMULTANI LETTER PAMULTA" +
	"NI LETTER PHAMULTANI LETTER BAMULTANI LETTER BHAMULTANI LETTER MAMULTANI" +
	" LETTER YAMULTANI LETTER RAMULTANI LETTER LAMULTANI LETTER VAMULTANI LET" +
	"TER SAMULTANI LETTER HAMULTANI LETTER RRAMULTANI LETTER RHAMULTANI SECTI" +
	"ON MARKKHUDAWADI LETTER AKHUDAWADI LETTER AAKHUDAWADI LETTER IKHUDAWADI " +
	"LETTER IIKHUDAWADI LETTER UKHUDAWADI LETTER UUKHUDAWADI LETTER EKHUDAWAD" +
	"I LETTER AIKHUDAWADI LETTER OKHUDAWADI LETTER AUKHUDAWADI LETTER KAKHUDA" +
	"WADI LETTER KHAKHUDAWADI LETTER GAKHUDAWADI LETTER GGAKHUDAWADI LETTER G" +
	"HAKHUDAWADI LETTER NGAKHUDAWADI LETTER CAKHUDAWADI LETTER CHAKHUDAWADI L" +
	"ETTER JAKHUDAWADI LETTER JJAKHUDAWADI LETTER JHAKHUDAWADI LETTER NYAKHUD" +
	"AWADI LETTER TTAKHUDAWADI LETTER TTHAKHUDAWADI LETTER DDAKHUDAWADI LETTE" +
	"R DDDAKHUDAWADI LETTER RRAKHUDAWADI LETTER DDHAKHUDAWADI LETTER NNAKHUDA" +
	"WADI LETTER TAKHUDAWADI LETTER THAKHUDAWADI LETTER DAKHUDAWADI LETTER DH" +
	"AKHUDAWADI LETTER NAKHUDAWADI LETTER PAKHUDAWADI LETTER PHAKHUDAWADI LET" +
	"TER BAKHUDAWADI LETTER BBAKHUDAWADI LETTER BHAKHUDAWADI LETTER MAKHUDAWA" +
	"DI LETTER YAKHUDAWADI LETTER RAKHUDAWADI LETTER LAKHUDAWADI LETTER VAKHU" +
	"DAWADI LETTER SHAKHUDAWADI LETTER SAKHUDAWADI LETTER HAKHUDAWADI SIGN AN" +
	"USVARAKHUDAWADI VOWEL SIGN AAKHUDAWADI VOWEL SIGN IKHUDAWADI VOWEL SIGN " +
	"IIKHUDAWADI VOWEL SIGN UKHUDAWADI VOWEL SIGN UUKHUDAWADI VOWEL SIGN EKHU" +
	"DAWADI VOWEL SIGN AIKHUDAWADI VOWEL SIGN OKHUDAWADI VOWEL SIGN AUKHUDAWA" +
	"DI SIGN NUKTAKHUDAWADI SIGN VIRAMAKHUDAWADI DIGIT ZEROKHUDAWADI DIGIT ON" +
	"EKHUDAWADI DIGIT TWOKHUDAWADI DIGIT THREEKHUDAWADI DIGIT FOURKHUDAWADI D" +
	"IGIT FIVEKHUDAWADI DIGIT SIXKHUDAWADI DIGIT SEVENKHUDAWADI DIGIT EIGHTKH" +
	"UDAWADI DIGIT NINEGRANTHA SIGN COMBINING ANUSVARA ABOVEGRANTHA SIGN CAND" +
	"RABINDUGRANTHA SIGN ANUSVARAGRANTHA SIGN VISARGAGRANTHA LETTER AGRANTHA " +
	"LETTER AAGRANTHA LETTER IGRANTHA LETTER IIGRANTHA LETTER UGRANTHA LETTER" +
	" UUGRANTHA LETTER VOCALIC RGRANTHA LETTER VOCALIC LGRANTHA LETTER EEGRAN" +
	"THA LETTER AIGRANTHA LETTER OOGRANTHA LETTER AUGRANTHA LETTER KAGRANTHA " +
	"LETTER KHAGRANTHA LETTER GAGRANTHA LETTER GHAGRANTHA LETTER NGAGRANTHA L" +
	"ETTER CAGRANTHA LETTER CHAGRANTHA LETTER JAGRANTHA LETTER JHAGRANTHA LET" +
	"TER NYAGRANTHA LETTER TTAGRANTHA LETTER TTHAGRANTHA LETTER DDAGRANTHA LE" +
	"TTER DDHAGRANTHA LETTER NNAGRANTHA LETTER TAGRANTHA LETTER THAGRANTHA LE" +
	"TTER DAGRANTHA LETTER DHAGRANTHA LETTER NAGRANTHA LETTER PAGRANTHA LETTE" +
	"R PHAGRANTHA LETTER BAGRANTHA LETTER BHAGRANTHA LETTER MAGRANTHA LETTER " +
	"YAGRANTHA LETTER RAGRANTHA LETTER LAGRANTHA LETTER LLAGRANTHA LETTER VAG") + ("" +
	"RANTHA LETTER SHAGRANTHA LETTER SSAGRANTHA LETTER SAGRANTHA LETTER HAGRA" +
	"NTHA SIGN NUKTAGRANTHA SIGN AVAGRAHAGRANTHA VOWEL SIGN AAGRANTHA VOWEL S" +
	"IGN IGRANTHA VOWEL SIGN IIGRANTHA VOWEL SIGN UGRANTHA VOWEL SIGN UUGRANT" +
	"HA VOWEL SIGN VOCALIC RGRANTHA VOWEL SIGN VOCALIC RRGRANTHA VOWEL SIGN E" +
	"EGRANTHA VOWEL SIGN AIGRANTHA VOWEL SIGN OOGRANTHA VOWEL SIGN AUGRANTHA " +
	"SIGN VIRAMAGRANTHA OMGRANTHA AU LENGTH MARKGRANTHA SIGN PLUTAGRANTHA LET" +
	"TER VEDIC ANUSVARAGRANTHA LETTER VEDIC DOUBLE ANUSVARAGRANTHA LETTER VOC" +
	"ALIC RRGRANTHA LETTER VOCALIC LLGRANTHA VOWEL SIGN VOCALIC LGRANTHA VOWE" +
	"L SIGN VOCALIC LLCOMBINING GRANTHA DIGIT ZEROCOMBINING GRANTHA DIGIT ONE" +
	"COMBINING GRANTHA DIGIT TWOCOMBINING GRANTHA DIGIT THREECOMBINING GRANTH" +
	"A DIGIT FOURCOMBINING GRANTHA DIGIT FIVECOMBINING GRANTHA DIGIT SIXCOMBI" +
	"NING GRANTHA LETTER ACOMBINING GRANTHA LETTER KACOMBINING GRANTHA LETTER" +
	" NACOMBINING GRANTHA LETTER VICOMBINING GRANTHA LETTER PANEWA LETTER ANE" +
	"WA LETTER AANEWA LETTER INEWA LETTER IINEWA LETTER UNEWA LETTER UUNEWA L" +
	"ETTER VOCALIC RNEWA LETTER VOCALIC RRNEWA LETTER VOCALIC LNEWA LETTER VO" +
	"CALIC LLNEWA LETTER ENEWA LETTER AINEWA LETTER ONEWA LETTER AUNEWA LETTE" +
	"R KANEWA LETTER KHANEWA LETTER GANEWA LETTER GHANEWA LETTER NGANEWA LETT" +
	"ER NGHANEWA LETTER CANEWA LETTER CHANEWA LETTER JANEWA LETTER JHANEWA LE" +
	"TTER NYANEWA LETTER NYHANEWA LETTER TTANEWA LETTER TTHANEWA LETTER DDANE" +
	"WA LETTER DDHANEWA LETTER NNANEWA LETTER TANEWA LETTER THANEWA LETTER DA" +
	"NEWA LETTER DHANEWA LETTER NANEWA LETTER NHANEWA LETTER PANEWA LETTER PH" +
	"ANEWA LETTER BANEWA LETTER BHANEWA LETTER MANEWA LETTER MHANEWA LETTER Y" +
	"ANEWA LETTER RANEWA LETTER RHANEWA LETTER LANEWA LETTER LHANEWA LETTER W" +
	"ANEWA LETTER SHANEWA LETTER SSANEWA LETTER SANEWA LETTER HANEWA VOWEL SI" +
	"GN AANEWA VOWEL SIGN INEWA VOWEL SIGN IINEWA VOWEL SIGN UNEWA VOWEL SIGN" +
	" UUNEWA VOWEL SIGN VOCALIC RNEWA VOWEL SIGN VOCALIC RRNEWA VOWEL SIGN VO" +
	"CALIC LNEWA VOWEL SIGN VOCALIC LLNEWA VOWEL SIGN ENEWA VOWEL SIGN AINEWA" +
	" VOWEL SIGN ONEWA VOWEL SIGN AUNEWA SIGN VIRAMANEWA SIGN CANDRABINDUNEWA" +
	" SIGN ANUSVARANEWA SIGN VISARGANEWA SIGN NUKTANEWA SIGN AVAGRAHANEWA SIG" +
	"N FINAL ANUSVARANEWA OMNEWA SIDDHINEWA DANDANEWA DOUBLE DANDANEWA COMMAN" +
	"EWA GAP FILLERNEWA ABBREVIATION SIGNNEWA DIGIT ZERONEWA DIGIT ONENEWA DI" +
	"GIT TWONEWA DIGIT THREENEWA DIGIT FOURNEWA DIGIT FIVENEWA DIGIT SIXNEWA " +
	"DIGIT SEVENNEWA DIGIT EIGHTNEWA DIGIT NINENEWA PLACEHOLDER MARKNEWA INSE" +
	"RTION SIGNTIRHUTA ANJITIRHUTA LETTER ATIRHUTA LETTER AATIRHUTA LETTER IT" +
	"IRHUTA LETTER IITIRHUTA LETTER UTIRHUTA LETTER UUTIRHUTA LETTER VOCALIC " +
	"RTIRHUTA LETTER VOCALIC RRTIRHUTA LETTER VOCALIC LTIRHUTA LETTER VOCALIC" +
	" LLTIRHUTA LETTER ETIRHUTA LETTER AITIRHUTA LETTER OTIRHUTA LETTER AUTIR" +
	"HUTA LETTER KATIRHUTA LETTER KHATIRHUTA LETTER GATIRHUTA LETTER GHATIRHU" +
	"TA LETTER NGATIRHUTA LETTER CATIRHUTA LETTER CHATIRHUTA LETTER JATIRHUTA" +
	" LETTER JHATIRHUTA LETTER NYATIRHUTA LETTER TTATIRHUTA LETTER TTHATIRHUT" +
	"A LETTER DDATIRHUTA LETTER DDHATIRHUTA LETTER NNATIRHUTA LETTER TATIRHUT" +
	"A LETTER THATIRHUTA LETTER DATIRHUTA LETTER DHATIRHUTA LETTER NATIRHUTA " +
	"LETTER PATIRHUTA LETTER PHATIRHUTA LETTER BATIRHUTA LETTER BHATIRHUTA LE" +
	"TTER MATIRHUTA LETTER YATIRHUTA LETTER RATIRHUTA LETTER LATIRHUTA LETTER" +
	" VATIRHUTA LETTER SHATIRHUTA LETTER SSATIRHUTA LETTER SATIRHUTA LETTER H" +
	"ATIRHUTA VOWEL SIGN AATIRHUTA VOWEL SIGN ITIRHUTA VOWEL SIGN IITIRHUTA V" +
	"OWEL SIGN UTIRHUTA VOWEL SIGN UUTIRHUTA VOWEL SIGN VOCALIC RTIRHUTA VOWE" +
	"L SIGN VOCALIC RRTIRHUTA VOWEL SIGN VOCALIC LTIRHUTA VOWEL SIGN VOCALIC " +
	"LLTIRHUTA VOWEL SIGN ETIRHUTA VOWEL SIGN SHORT ETIRHUTA VOWEL SIGN AITIR" +
	"HUTA VOWEL SIGN OTIRHUTA VOWEL SIGN SHORT OTIRHUTA VOWEL SIGN AUTIRHUTA " +
	"SIGN CANDRABINDUTIRHUTA SIGN ANUSVARATIRHUTA SIGN VISARGATIRHUTA SIGN VI" +
	"RAMATIRHUTA SIGN NUKTATIRHUTA SIGN AVAGRAHATIRHUTA GVANGTIRHUTA ABBREVIA" +
	"TION SIGNTIRHUTA OMTIRHUTA DIGIT ZEROTIRHUTA DIGIT ONETIRHUTA DIGIT TWOT" +
	"IRHUTA DIGIT THREETIRHUTA DIGIT FOURTIRHUTA DIGIT FIVETIRHUTA DIGIT SIXT" +
	"IRHUTA DIGIT SEVENTIRHUTA DIGIT EIGHTTIRHUTA DIGIT NINESIDDHAM LETTER AS" +
	"IDDHAM LETTER AASIDDHAM LETTER ISIDDHAM LETTER IISIDDHAM LETTER USIDDHAM" +
	" LETTER UUSIDDHAM LETTER VOCALIC RSIDDHAM LETTER VOCALIC RRSIDDHAM LETTE" +
	"R VOCALIC LSIDDHAM LETTER VOCALIC LLSIDDHAM LETTER ESIDDHAM LETTER AISID" +
	"DHAM LETTER OSIDDHAM LETTER AUSIDDHAM LETTER KASIDDHAM LETTER KHASIDDHAM" +
	" LETTER GASIDDHAM LETTER GHASIDDHAM LETTER NGASIDDHAM LETTER CASIDDHAM L" +
	"ETTER CHASIDDHAM LETTER JASIDDHAM LETTER JHASIDDHAM LETTER NYASIDDHAM LE" +
	"TTER TTASIDDHAM LETTER TTHASIDDHAM LETTER DDASIDDHAM LETTER DDHASIDDHAM " +
	"LETTER NNASIDDHAM LETTER TASIDDHAM LETTER THASIDDHAM LETTER DASIDDHAM LE" +
	"TTER DHASIDDHAM LETTER NASIDDHAM LETTER PASIDDHAM LETTER PHASIDDHAM LETT") + ("" +
	"ER BASIDDHAM LETTER BHASIDDHAM LETTER MASIDDHAM LETTER YASIDDHAM LETTER " +
	"RASIDDHAM LETTER LASIDDHAM LETTER VASIDDHAM LETTER SHASIDDHAM LETTER SSA" +
	"SIDDHAM LETTER SASIDDHAM LETTER HASIDDHAM VOWEL SIGN AASIDDHAM VOWEL SIG" +
	"N ISIDDHAM VOWEL SIGN IISIDDHAM VOWEL SIGN USIDDHAM VOWEL SIGN UUSIDDHAM" +
	" VOWEL SIGN VOCALIC RSIDDHAM VOWEL SIGN VOCALIC RRSIDDHAM VOWEL SIGN ESI" +
	"DDHAM VOWEL SIGN AISIDDHAM VOWEL SIGN OSIDDHAM VOWEL SIGN AUSIDDHAM SIGN" +
	" CANDRABINDUSIDDHAM SIGN ANUSVARASIDDHAM SIGN VISARGASIDDHAM SIGN VIRAMA" +
	"SIDDHAM SIGN NUKTASIDDHAM SIGN SIDDHAMSIDDHAM DANDASIDDHAM DOUBLE DANDAS" +
	"IDDHAM SEPARATOR DOTSIDDHAM SEPARATOR BARSIDDHAM REPETITION MARK-1SIDDHA" +
	"M REPETITION MARK-2SIDDHAM REPETITION MARK-3SIDDHAM END OF TEXT MARKSIDD" +
	"HAM SECTION MARK WITH TRIDENT AND U-SHAPED ORNAMENTSSIDDHAM SECTION MARK" +
	" WITH TRIDENT AND DOTTED CRESCENTSSIDDHAM SECTION MARK WITH RAYS AND DOT" +
	"TED CRESCENTSSIDDHAM SECTION MARK WITH RAYS AND DOTTED DOUBLE CRESCENTSS" +
	"IDDHAM SECTION MARK WITH RAYS AND DOTTED TRIPLE CRESCENTSSIDDHAM SECTION" +
	" MARK DOUBLE RINGSIDDHAM SECTION MARK DOUBLE RING WITH RAYSSIDDHAM SECTI" +
	"ON MARK WITH DOUBLE CRESCENTSSIDDHAM SECTION MARK WITH TRIPLE CRESCENTSS" +
	"IDDHAM SECTION MARK WITH QUADRUPLE CRESCENTSSIDDHAM SECTION MARK WITH SE" +
	"PTUPLE CRESCENTSSIDDHAM SECTION MARK WITH CIRCLES AND RAYSSIDDHAM SECTIO" +
	"N MARK WITH CIRCLES AND TWO ENCLOSURESSIDDHAM SECTION MARK WITH CIRCLES " +
	"AND FOUR ENCLOSURESSIDDHAM LETTER THREE-CIRCLE ALTERNATE ISIDDHAM LETTER" +
	" TWO-CIRCLE ALTERNATE ISIDDHAM LETTER TWO-CIRCLE ALTERNATE IISIDDHAM LET" +
	"TER ALTERNATE USIDDHAM VOWEL SIGN ALTERNATE USIDDHAM VOWEL SIGN ALTERNAT" +
	"E UUMODI LETTER AMODI LETTER AAMODI LETTER IMODI LETTER IIMODI LETTER UM" +
	"ODI LETTER UUMODI LETTER VOCALIC RMODI LETTER VOCALIC RRMODI LETTER VOCA" +
	"LIC LMODI LETTER VOCALIC LLMODI LETTER EMODI LETTER AIMODI LETTER OMODI " +
	"LETTER AUMODI LETTER KAMODI LETTER KHAMODI LETTER GAMODI LETTER GHAMODI " +
	"LETTER NGAMODI LETTER CAMODI LETTER CHAMODI LETTER JAMODI LETTER JHAMODI" +
	" LETTER NYAMODI LETTER TTAMODI LETTER TTHAMODI LETTER DDAMODI LETTER DDH" +
	"AMODI LETTER NNAMODI LETTER TAMODI LETTER THAMODI LETTER DAMODI LETTER D" +
	"HAMODI LETTER NAMODI LETTER PAMODI LETTER PHAMODI LETTER BAMODI LETTER B" +
	"HAMODI LETTER MAMODI LETTER YAMODI LETTER RAMODI LETTER LAMODI LETTER VA" +
	"MODI LETTER SHAMODI LETTER SSAMODI LETTER SAMODI LETTER HAMODI LETTER LL" +
	"AMODI VOWEL SIGN AAMODI VOWEL SIGN IMODI VOWEL SIGN IIMODI VOWEL SIGN UM" +
	"ODI VOWEL SIGN UUMODI VOWEL SIGN VOCALIC RMODI VOWEL SIGN VOCALIC RRMODI" +
	" VOWEL SIGN VOCALIC LMODI VOWEL SIGN VOCALIC LLMODI VOWEL SIGN EMODI VOW" +
	"EL SIGN AIMODI VOWEL SIGN OMODI VOWEL SIGN AUMODI SIGN ANUSVARAMODI SIGN" +
	" VISARGAMODI SIGN VIRAMAMODI SIGN ARDHACANDRAMODI DANDAMODI DOUBLE DANDA" +
	"MODI ABBREVIATION SIGNMODI SIGN HUVAMODI DIGIT ZEROMODI DIGIT ONEMODI DI" +
	"GIT TWOMODI DIGIT THREEMODI DIGIT FOURMODI DIGIT FIVEMODI DIGIT SIXMODI " +
	"DIGIT SEVENMODI DIGIT EIGHTMODI DIGIT NINEMONGOLIAN BIRGA WITH ORNAMENTM" +
	"ONGOLIAN ROTATED BIRGAMONGOLIAN DOUBLE BIRGA WITH ORNAMENTMONGOLIAN TRIP" +
	"LE BIRGA WITH ORNAMENTMONGOLIAN BIRGA WITH DOUBLE ORNAMENTMONGOLIAN ROTA" +
	"TED BIRGA WITH ORNAMENTMONGOLIAN ROTATED BIRGA WITH DOUBLE ORNAMENTMONGO" +
	"LIAN INVERTED BIRGAMONGOLIAN INVERTED BIRGA WITH DOUBLE ORNAMENTMONGOLIA" +
	"N SWIRL BIRGAMONGOLIAN SWIRL BIRGA WITH ORNAMENTMONGOLIAN SWIRL BIRGA WI" +
	"TH DOUBLE ORNAMENTMONGOLIAN TURNED SWIRL BIRGA WITH DOUBLE ORNAMENTTAKRI" +
	" LETTER ATAKRI LETTER AATAKRI LETTER ITAKRI LETTER IITAKRI LETTER UTAKRI" +
	" LETTER UUTAKRI LETTER ETAKRI LETTER AITAKRI LETTER OTAKRI LETTER AUTAKR" +
	"I LETTER KATAKRI LETTER KHATAKRI LETTER GATAKRI LETTER GHATAKRI LETTER N" +
	"GATAKRI LETTER CATAKRI LETTER CHATAKRI LETTER JATAKRI LETTER JHATAKRI LE" +
	"TTER NYATAKRI LETTER TTATAKRI LETTER TTHATAKRI LETTER DDATAKRI LETTER DD" +
	"HATAKRI LETTER NNATAKRI LETTER TATAKRI LETTER THATAKRI LETTER DATAKRI LE" +
	"TTER DHATAKRI LETTER NATAKRI LETTER PATAKRI LETTER PHATAKRI LETTER BATAK" +
	"RI LETTER BHATAKRI LETTER MATAKRI LETTER YATAKRI LETTER RATAKRI LETTER L" +
	"ATAKRI LETTER VATAKRI LETTER SHATAKRI LETTER SATAKRI LETTER HATAKRI LETT" +
	"ER RRATAKRI SIGN ANUSVARATAKRI SIGN VISARGATAKRI VOWEL SIGN AATAKRI VOWE" +
	"L SIGN ITAKRI VOWEL SIGN IITAKRI VOWEL SIGN UTAKRI VOWEL SIGN UUTAKRI VO" +
	"WEL SIGN ETAKRI VOWEL SIGN AITAKRI VOWEL SIGN OTAKRI VOWEL SIGN AUTAKRI " +
	"SIGN VIRAMATAKRI SIGN NUKTATAKRI DIGIT ZEROTAKRI DIGIT ONETAKRI DIGIT TW" +
	"OTAKRI DIGIT THREETAKRI DIGIT FOURTAKRI DIGIT FIVETAKRI DIGIT SIXTAKRI D" +
	"IGIT SEVENTAKRI DIGIT EIGHTTAKRI DIGIT NINEAHOM LETTER KAAHOM LETTER KHA" +
	"AHOM LETTER NGAAHOM LETTER NAAHOM LETTER TAAHOM LETTER ALTERNATE TAAHOM " +
	"LETTER PAAHOM LETTER PHAAHOM LETTER BAAHOM LETTER MAAHOM LETTER JAAHOM L" +
	"ETTER CHAAHOM LETTER THAAHOM LETTER RAAHOM LETTER LAAHOM LETTER SAAHOM L") + ("" +
	"ETTER NYAAHOM LETTER HAAHOM LETTER AAHOM LETTER DAAHOM LETTER DHAAHOM LE" +
	"TTER GAAHOM LETTER ALTERNATE GAAHOM LETTER GHAAHOM LETTER BHAAHOM LETTER" +
	" JHAAHOM CONSONANT SIGN MEDIAL LAAHOM CONSONANT SIGN MEDIAL RAAHOM CONSO" +
	"NANT SIGN MEDIAL LIGATING RAAHOM VOWEL SIGN AAHOM VOWEL SIGN AAAHOM VOWE" +
	"L SIGN IAHOM VOWEL SIGN IIAHOM VOWEL SIGN UAHOM VOWEL SIGN UUAHOM VOWEL " +
	"SIGN EAHOM VOWEL SIGN AWAHOM VOWEL SIGN OAHOM VOWEL SIGN AIAHOM VOWEL SI" +
	"GN AMAHOM SIGN KILLERAHOM DIGIT ZEROAHOM DIGIT ONEAHOM DIGIT TWOAHOM DIG" +
	"IT THREEAHOM DIGIT FOURAHOM DIGIT FIVEAHOM DIGIT SIXAHOM DIGIT SEVENAHOM" +
	" DIGIT EIGHTAHOM DIGIT NINEAHOM NUMBER TENAHOM NUMBER TWENTYAHOM SIGN SM" +
	"ALL SECTIONAHOM SIGN SECTIONAHOM SIGN RULAIAHOM SYMBOL VIWARANG CITI CAP" +
	"ITAL LETTER NGAAWARANG CITI CAPITAL LETTER AWARANG CITI CAPITAL LETTER W" +
	"IWARANG CITI CAPITAL LETTER YUWARANG CITI CAPITAL LETTER YAWARANG CITI C" +
	"APITAL LETTER YOWARANG CITI CAPITAL LETTER IIWARANG CITI CAPITAL LETTER " +
	"UUWARANG CITI CAPITAL LETTER EWARANG CITI CAPITAL LETTER OWARANG CITI CA" +
	"PITAL LETTER ANGWARANG CITI CAPITAL LETTER GAWARANG CITI CAPITAL LETTER " +
	"KOWARANG CITI CAPITAL LETTER ENYWARANG CITI CAPITAL LETTER YUJWARANG CIT" +
	"I CAPITAL LETTER UCWARANG CITI CAPITAL LETTER ENNWARANG CITI CAPITAL LET" +
	"TER ODDWARANG CITI CAPITAL LETTER TTEWARANG CITI CAPITAL LETTER NUNGWARA" +
	"NG CITI CAPITAL LETTER DAWARANG CITI CAPITAL LETTER ATWARANG CITI CAPITA" +
	"L LETTER AMWARANG CITI CAPITAL LETTER BUWARANG CITI CAPITAL LETTER PUWAR" +
	"ANG CITI CAPITAL LETTER HIYOWARANG CITI CAPITAL LETTER HOLOWARANG CITI C" +
	"APITAL LETTER HORRWARANG CITI CAPITAL LETTER HARWARANG CITI CAPITAL LETT" +
	"ER SSUUWARANG CITI CAPITAL LETTER SIIWARANG CITI CAPITAL LETTER VIYOWARA" +
	"NG CITI SMALL LETTER NGAAWARANG CITI SMALL LETTER AWARANG CITI SMALL LET" +
	"TER WIWARANG CITI SMALL LETTER YUWARANG CITI SMALL LETTER YAWARANG CITI " +
	"SMALL LETTER YOWARANG CITI SMALL LETTER IIWARANG CITI SMALL LETTER UUWAR" +
	"ANG CITI SMALL LETTER EWARANG CITI SMALL LETTER OWARANG CITI SMALL LETTE" +
	"R ANGWARANG CITI SMALL LETTER GAWARANG CITI SMALL LETTER KOWARANG CITI S" +
	"MALL LETTER ENYWARANG CITI SMALL LETTER YUJWARANG CITI SMALL LETTER UCWA" +
	"RANG CITI SMALL LETTER ENNWARANG CITI SMALL LETTER ODDWARANG CITI SMALL " +
	"LETTER TTEWARANG CITI SMALL LETTER NUNGWARANG CITI SMALL LETTER DAWARANG" +
	" CITI SMALL LETTER ATWARANG CITI SMALL LETTER AMWARANG CITI SMALL LETTER" +
	" BUWARANG CITI SMALL LETTER PUWARANG CITI SMALL LETTER HIYOWARANG CITI S" +
	"MALL LETTER HOLOWARANG CITI SMALL LETTER HORRWARANG CITI SMALL LETTER HA" +
	"RWARANG CITI SMALL LETTER SSUUWARANG CITI SMALL LETTER SIIWARANG CITI SM" +
	"ALL LETTER VIYOWARANG CITI DIGIT ZEROWARANG CITI DIGIT ONEWARANG CITI DI" +
	"GIT TWOWARANG CITI DIGIT THREEWARANG CITI DIGIT FOURWARANG CITI DIGIT FI" +
	"VEWARANG CITI DIGIT SIXWARANG CITI DIGIT SEVENWARANG CITI DIGIT EIGHTWAR" +
	"ANG CITI DIGIT NINEWARANG CITI NUMBER TENWARANG CITI NUMBER TWENTYWARANG" +
	" CITI NUMBER THIRTYWARANG CITI NUMBER FORTYWARANG CITI NUMBER FIFTYWARAN" +
	"G CITI NUMBER SIXTYWARANG CITI NUMBER SEVENTYWARANG CITI NUMBER EIGHTYWA" +
	"RANG CITI NUMBER NINETYWARANG CITI OMPAU CIN HAU LETTER PAPAU CIN HAU LE" +
	"TTER KAPAU CIN HAU LETTER LAPAU CIN HAU LETTER MAPAU CIN HAU LETTER DAPA" +
	"U CIN HAU LETTER ZAPAU CIN HAU LETTER VAPAU CIN HAU LETTER NGAPAU CIN HA" +
	"U LETTER HAPAU CIN HAU LETTER GAPAU CIN HAU LETTER KHAPAU CIN HAU LETTER" +
	" SAPAU CIN HAU LETTER BAPAU CIN HAU LETTER CAPAU CIN HAU LETTER TAPAU CI" +
	"N HAU LETTER THAPAU CIN HAU LETTER NAPAU CIN HAU LETTER PHAPAU CIN HAU L" +
	"ETTER RAPAU CIN HAU LETTER FAPAU CIN HAU LETTER CHAPAU CIN HAU LETTER AP" +
	"AU CIN HAU LETTER EPAU CIN HAU LETTER IPAU CIN HAU LETTER OPAU CIN HAU L" +
	"ETTER UPAU CIN HAU LETTER UAPAU CIN HAU LETTER IAPAU CIN HAU LETTER FINA" +
	"L PPAU CIN HAU LETTER FINAL KPAU CIN HAU LETTER FINAL TPAU CIN HAU LETTE" +
	"R FINAL MPAU CIN HAU LETTER FINAL NPAU CIN HAU LETTER FINAL LPAU CIN HAU" +
	" LETTER FINAL WPAU CIN HAU LETTER FINAL NGPAU CIN HAU LETTER FINAL YPAU " +
	"CIN HAU RISING TONE LONGPAU CIN HAU RISING TONEPAU CIN HAU SANDHI GLOTTA" +
	"L STOPPAU CIN HAU RISING TONE LONG FINALPAU CIN HAU RISING TONE FINALPAU" +
	" CIN HAU SANDHI GLOTTAL STOP FINALPAU CIN HAU SANDHI TONE LONGPAU CIN HA" +
	"U SANDHI TONEPAU CIN HAU SANDHI TONE LONG FINALPAU CIN HAU SANDHI TONE F" +
	"INALPAU CIN HAU MID-LEVEL TONEPAU CIN HAU GLOTTAL STOP VARIANTPAU CIN HA" +
	"U MID-LEVEL TONE LONG FINALPAU CIN HAU MID-LEVEL TONE FINALPAU CIN HAU L" +
	"OW-FALLING TONE LONGPAU CIN HAU LOW-FALLING TONEPAU CIN HAU GLOTTAL STOP" +
	"PAU CIN HAU LOW-FALLING TONE LONG FINALPAU CIN HAU LOW-FALLING TONE FINA" +
	"LPAU CIN HAU GLOTTAL STOP FINALBHAIKSUKI LETTER ABHAIKSUKI LETTER AABHAI" +
	"KSUKI LETTER IBHAIKSUKI LETTER IIBHAIKSUKI LETTER UBHAIKSUKI LETTER UUBH" +
	"AIKSUKI LETTER VOCALIC RBHAIKSUKI LETTER VOCALIC RRBHAIKSUKI LETTER VOCA") + ("" +
	"LIC LBHAIKSUKI LETTER EBHAIKSUKI LETTER AIBHAIKSUKI LETTER OBHAIKSUKI LE" +
	"TTER AUBHAIKSUKI LETTER KABHAIKSUKI LETTER KHABHAIKSUKI LETTER GABHAIKSU" +
	"KI LETTER GHABHAIKSUKI LETTER NGABHAIKSUKI LETTER CABHAIKSUKI LETTER CHA" +
	"BHAIKSUKI LETTER JABHAIKSUKI LETTER JHABHAIKSUKI LETTER NYABHAIKSUKI LET" +
	"TER TTABHAIKSUKI LETTER TTHABHAIKSUKI LETTER DDABHAIKSUKI LETTER DDHABHA" +
	"IKSUKI LETTER NNABHAIKSUKI LETTER TABHAIKSUKI LETTER THABHAIKSUKI LETTER" +
	" DABHAIKSUKI LETTER DHABHAIKSUKI LETTER NABHAIKSUKI LETTER PABHAIKSUKI L" +
	"ETTER PHABHAIKSUKI LETTER BABHAIKSUKI LETTER BHABHAIKSUKI LETTER MABHAIK" +
	"SUKI LETTER YABHAIKSUKI LETTER RABHAIKSUKI LETTER LABHAIKSUKI LETTER VAB" +
	"HAIKSUKI LETTER SHABHAIKSUKI LETTER SSABHAIKSUKI LETTER SABHAIKSUKI LETT" +
	"ER HABHAIKSUKI VOWEL SIGN AABHAIKSUKI VOWEL SIGN IBHAIKSUKI VOWEL SIGN I" +
	"IBHAIKSUKI VOWEL SIGN UBHAIKSUKI VOWEL SIGN UUBHAIKSUKI VOWEL SIGN VOCAL" +
	"IC RBHAIKSUKI VOWEL SIGN VOCALIC RRBHAIKSUKI VOWEL SIGN VOCALIC LBHAIKSU" +
	"KI VOWEL SIGN EBHAIKSUKI VOWEL SIGN AIBHAIKSUKI VOWEL SIGN OBHAIKSUKI VO" +
	"WEL SIGN AUBHAIKSUKI SIGN CANDRABINDUBHAIKSUKI SIGN ANUSVARABHAIKSUKI SI" +
	"GN VISARGABHAIKSUKI SIGN VIRAMABHAIKSUKI SIGN AVAGRAHABHAIKSUKI DANDABHA" +
	"IKSUKI DOUBLE DANDABHAIKSUKI WORD SEPARATORBHAIKSUKI GAP FILLER-1BHAIKSU" +
	"KI GAP FILLER-2BHAIKSUKI DIGIT ZEROBHAIKSUKI DIGIT ONEBHAIKSUKI DIGIT TW" +
	"OBHAIKSUKI DIGIT THREEBHAIKSUKI DIGIT FOURBHAIKSUKI DIGIT FIVEBHAIKSUKI " +
	"DIGIT SIXBHAIKSUKI DIGIT SEVENBHAIKSUKI DIGIT EIGHTBHAIKSUKI DIGIT NINEB" +
	"HAIKSUKI NUMBER ONEBHAIKSUKI NUMBER TWOBHAIKSUKI NUMBER THREEBHAIKSUKI N" +
	"UMBER FOURBHAIKSUKI NUMBER FIVEBHAIKSUKI NUMBER SIXBHAIKSUKI NUMBER SEVE" +
	"NBHAIKSUKI NUMBER EIGHTBHAIKSUKI NUMBER NINEBHAIKSUKI NUMBER TENBHAIKSUK" +
	"I NUMBER TWENTYBHAIKSUKI NUMBER THIRTYBHAIKSUKI NUMBER FORTYBHAIKSUKI NU" +
	"MBER FIFTYBHAIKSUKI NUMBER SIXTYBHAIKSUKI NUMBER SEVENTYBHAIKSUKI NUMBER" +
	" EIGHTYBHAIKSUKI NUMBER NINETYBHAIKSUKI HUNDREDS UNIT MARKMARCHEN HEAD M" +
	"ARKMARCHEN MARK SHADMARCHEN LETTER KAMARCHEN LETTER KHAMARCHEN LETTER GA" +
	"MARCHEN LETTER NGAMARCHEN LETTER CAMARCHEN LETTER CHAMARCHEN LETTER JAMA" +
	"RCHEN LETTER NYAMARCHEN LETTER TAMARCHEN LETTER THAMARCHEN LETTER DAMARC" +
	"HEN LETTER NAMARCHEN LETTER PAMARCHEN LETTER PHAMARCHEN LETTER BAMARCHEN" +
	" LETTER MAMARCHEN LETTER TSAMARCHEN LETTER TSHAMARCHEN LETTER DZAMARCHEN" +
	" LETTER WAMARCHEN LETTER ZHAMARCHEN LETTER ZAMARCHEN LETTER -AMARCHEN LE" +
	"TTER YAMARCHEN LETTER RAMARCHEN LETTER LAMARCHEN LETTER SHAMARCHEN LETTE" +
	"R SAMARCHEN LETTER HAMARCHEN LETTER AMARCHEN SUBJOINED LETTER KAMARCHEN " +
	"SUBJOINED LETTER KHAMARCHEN SUBJOINED LETTER GAMARCHEN SUBJOINED LETTER " +
	"NGAMARCHEN SUBJOINED LETTER CAMARCHEN SUBJOINED LETTER CHAMARCHEN SUBJOI" +
	"NED LETTER JAMARCHEN SUBJOINED LETTER NYAMARCHEN SUBJOINED LETTER TAMARC" +
	"HEN SUBJOINED LETTER THAMARCHEN SUBJOINED LETTER DAMARCHEN SUBJOINED LET" +
	"TER NAMARCHEN SUBJOINED LETTER PAMARCHEN SUBJOINED LETTER PHAMARCHEN SUB" +
	"JOINED LETTER BAMARCHEN SUBJOINED LETTER MAMARCHEN SUBJOINED LETTER TSAM" +
	"ARCHEN SUBJOINED LETTER TSHAMARCHEN SUBJOINED LETTER DZAMARCHEN SUBJOINE" +
	"D LETTER WAMARCHEN SUBJOINED LETTER ZHAMARCHEN SUBJOINED LETTER ZAMARCHE" +
	"N SUBJOINED LETTER YAMARCHEN SUBJOINED LETTER RAMARCHEN SUBJOINED LETTER" +
	" LAMARCHEN SUBJOINED LETTER SHAMARCHEN SUBJOINED LETTER SAMARCHEN SUBJOI" +
	"NED LETTER HAMARCHEN SUBJOINED LETTER AMARCHEN VOWEL SIGN AAMARCHEN VOWE" +
	"L SIGN IMARCHEN VOWEL SIGN UMARCHEN VOWEL SIGN EMARCHEN VOWEL SIGN OMARC" +
	"HEN SIGN ANUSVARAMARCHEN SIGN CANDRABINDUCUNEIFORM SIGN ACUNEIFORM SIGN " +
	"A TIMES ACUNEIFORM SIGN A TIMES BADCUNEIFORM SIGN A TIMES GAN2 TENUCUNEI" +
	"FORM SIGN A TIMES HACUNEIFORM SIGN A TIMES IGICUNEIFORM SIGN A TIMES LAG" +
	"AR GUNUCUNEIFORM SIGN A TIMES MUSHCUNEIFORM SIGN A TIMES SAGCUNEIFORM SI" +
	"GN A2CUNEIFORM SIGN ABCUNEIFORM SIGN AB TIMES ASH2CUNEIFORM SIGN AB TIME" +
	"S DUN3 GUNUCUNEIFORM SIGN AB TIMES GALCUNEIFORM SIGN AB TIMES GAN2 TENUC" +
	"UNEIFORM SIGN AB TIMES HACUNEIFORM SIGN AB TIMES IGI GUNUCUNEIFORM SIGN " +
	"AB TIMES IMINCUNEIFORM SIGN AB TIMES LAGABCUNEIFORM SIGN AB TIMES SHESHC" +
	"UNEIFORM SIGN AB TIMES U PLUS U PLUS UCUNEIFORM SIGN AB GUNUCUNEIFORM SI" +
	"GN AB2CUNEIFORM SIGN AB2 TIMES BALAGCUNEIFORM SIGN AB2 TIMES GAN2 TENUCU" +
	"NEIFORM SIGN AB2 TIMES ME PLUS ENCUNEIFORM SIGN AB2 TIMES SHA3CUNEIFORM " +
	"SIGN AB2 TIMES TAK4CUNEIFORM SIGN ADCUNEIFORM SIGN AKCUNEIFORM SIGN AK T" +
	"IMES ERIN2CUNEIFORM SIGN AK TIMES SHITA PLUS GISHCUNEIFORM SIGN ALCUNEIF" +
	"ORM SIGN AL TIMES ALCUNEIFORM SIGN AL TIMES DIM2CUNEIFORM SIGN AL TIMES " +
	"GISHCUNEIFORM SIGN AL TIMES HACUNEIFORM SIGN AL TIMES KAD3CUNEIFORM SIGN" +
	" AL TIMES KICUNEIFORM SIGN AL TIMES SHECUNEIFORM SIGN AL TIMES USHCUNEIF" +
	"ORM SIGN ALANCUNEIFORM SIGN ALEPHCUNEIFORM SIGN AMARCUNEIFORM SIGN AMAR " +
	"TIMES SHECUNEIFORM SIGN ANCUNEIFORM SIGN AN OVER ANCUNEIFORM SIGN AN THR") + ("" +
	"EE TIMESCUNEIFORM SIGN AN PLUS NAGA OPPOSING AN PLUS NAGACUNEIFORM SIGN " +
	"AN PLUS NAGA SQUAREDCUNEIFORM SIGN ANSHECUNEIFORM SIGN APINCUNEIFORM SIG" +
	"N ARADCUNEIFORM SIGN ARAD TIMES KURCUNEIFORM SIGN ARKABCUNEIFORM SIGN AS" +
	"AL2CUNEIFORM SIGN ASHCUNEIFORM SIGN ASH ZIDA TENUCUNEIFORM SIGN ASH KABA" +
	" TENUCUNEIFORM SIGN ASH OVER ASH TUG2 OVER TUG2 TUG2 OVER TUG2 PAPCUNEIF" +
	"ORM SIGN ASH OVER ASH OVER ASHCUNEIFORM SIGN ASH OVER ASH OVER ASH CROSS" +
	"ING ASH OVER ASH OVER ASHCUNEIFORM SIGN ASH2CUNEIFORM SIGN ASHGABCUNEIFO" +
	"RM SIGN BACUNEIFORM SIGN BADCUNEIFORM SIGN BAG3CUNEIFORM SIGN BAHAR2CUNE" +
	"IFORM SIGN BALCUNEIFORM SIGN BAL OVER BALCUNEIFORM SIGN BALAGCUNEIFORM S" +
	"IGN BARCUNEIFORM SIGN BARA2CUNEIFORM SIGN BICUNEIFORM SIGN BI TIMES ACUN" +
	"EIFORM SIGN BI TIMES GARCUNEIFORM SIGN BI TIMES IGI GUNUCUNEIFORM SIGN B" +
	"UCUNEIFORM SIGN BU OVER BU ABCUNEIFORM SIGN BU OVER BU UNCUNEIFORM SIGN " +
	"BU CROSSING BUCUNEIFORM SIGN BULUGCUNEIFORM SIGN BULUG OVER BULUGCUNEIFO" +
	"RM SIGN BURCUNEIFORM SIGN BUR2CUNEIFORM SIGN DACUNEIFORM SIGN DAGCUNEIFO" +
	"RM SIGN DAG KISIM5 TIMES A PLUS MASHCUNEIFORM SIGN DAG KISIM5 TIMES AMAR" +
	"CUNEIFORM SIGN DAG KISIM5 TIMES BALAGCUNEIFORM SIGN DAG KISIM5 TIMES BIC" +
	"UNEIFORM SIGN DAG KISIM5 TIMES GACUNEIFORM SIGN DAG KISIM5 TIMES GA PLUS" +
	" MASHCUNEIFORM SIGN DAG KISIM5 TIMES GICUNEIFORM SIGN DAG KISIM5 TIMES G" +
	"IR2CUNEIFORM SIGN DAG KISIM5 TIMES GUDCUNEIFORM SIGN DAG KISIM5 TIMES HA" +
	"CUNEIFORM SIGN DAG KISIM5 TIMES IRCUNEIFORM SIGN DAG KISIM5 TIMES IR PLU" +
	"S LUCUNEIFORM SIGN DAG KISIM5 TIMES KAKCUNEIFORM SIGN DAG KISIM5 TIMES L" +
	"ACUNEIFORM SIGN DAG KISIM5 TIMES LUCUNEIFORM SIGN DAG KISIM5 TIMES LU PL" +
	"US MASH2CUNEIFORM SIGN DAG KISIM5 TIMES LUMCUNEIFORM SIGN DAG KISIM5 TIM" +
	"ES NECUNEIFORM SIGN DAG KISIM5 TIMES PAP PLUS PAPCUNEIFORM SIGN DAG KISI" +
	"M5 TIMES SICUNEIFORM SIGN DAG KISIM5 TIMES TAK4CUNEIFORM SIGN DAG KISIM5" +
	" TIMES U2 PLUS GIR2CUNEIFORM SIGN DAG KISIM5 TIMES USHCUNEIFORM SIGN DAM" +
	"CUNEIFORM SIGN DARCUNEIFORM SIGN DARA3CUNEIFORM SIGN DARA4CUNEIFORM SIGN" +
	" DICUNEIFORM SIGN DIBCUNEIFORM SIGN DIMCUNEIFORM SIGN DIM TIMES SHECUNEI" +
	"FORM SIGN DIM2CUNEIFORM SIGN DINCUNEIFORM SIGN DIN KASKAL U GUNU DISHCUN" +
	"EIFORM SIGN DISHCUNEIFORM SIGN DUCUNEIFORM SIGN DU OVER DUCUNEIFORM SIGN" +
	" DU GUNUCUNEIFORM SIGN DU SHESHIGCUNEIFORM SIGN DUBCUNEIFORM SIGN DUB TI" +
	"MES ESH2CUNEIFORM SIGN DUB2CUNEIFORM SIGN DUGCUNEIFORM SIGN DUGUDCUNEIFO" +
	"RM SIGN DUHCUNEIFORM SIGN DUNCUNEIFORM SIGN DUN3CUNEIFORM SIGN DUN3 GUNU" +
	"CUNEIFORM SIGN DUN3 GUNU GUNUCUNEIFORM SIGN DUN4CUNEIFORM SIGN DUR2CUNEI" +
	"FORM SIGN ECUNEIFORM SIGN E TIMES PAPCUNEIFORM SIGN E OVER E NUN OVER NU" +
	"NCUNEIFORM SIGN E2CUNEIFORM SIGN E2 TIMES A PLUS HA PLUS DACUNEIFORM SIG" +
	"N E2 TIMES GARCUNEIFORM SIGN E2 TIMES MICUNEIFORM SIGN E2 TIMES SALCUNEI" +
	"FORM SIGN E2 TIMES SHECUNEIFORM SIGN E2 TIMES UCUNEIFORM SIGN EDINCUNEIF" +
	"ORM SIGN EGIRCUNEIFORM SIGN ELCUNEIFORM SIGN ENCUNEIFORM SIGN EN TIMES G" +
	"AN2CUNEIFORM SIGN EN TIMES GAN2 TENUCUNEIFORM SIGN EN TIMES MECUNEIFORM " +
	"SIGN EN CROSSING ENCUNEIFORM SIGN EN OPPOSING ENCUNEIFORM SIGN EN SQUARE" +
	"DCUNEIFORM SIGN ERENCUNEIFORM SIGN ERIN2CUNEIFORM SIGN ESH2CUNEIFORM SIG" +
	"N EZENCUNEIFORM SIGN EZEN TIMES ACUNEIFORM SIGN EZEN TIMES A PLUS LALCUN" +
	"EIFORM SIGN EZEN TIMES A PLUS LAL TIMES LALCUNEIFORM SIGN EZEN TIMES ANC" +
	"UNEIFORM SIGN EZEN TIMES BADCUNEIFORM SIGN EZEN TIMES DUN3 GUNUCUNEIFORM" +
	" SIGN EZEN TIMES DUN3 GUNU GUNUCUNEIFORM SIGN EZEN TIMES HACUNEIFORM SIG" +
	"N EZEN TIMES HA GUNUCUNEIFORM SIGN EZEN TIMES IGI GUNUCUNEIFORM SIGN EZE" +
	"N TIMES KASKALCUNEIFORM SIGN EZEN TIMES KASKAL SQUAREDCUNEIFORM SIGN EZE" +
	"N TIMES KU3CUNEIFORM SIGN EZEN TIMES LACUNEIFORM SIGN EZEN TIMES LAL TIM" +
	"ES LALCUNEIFORM SIGN EZEN TIMES LICUNEIFORM SIGN EZEN TIMES LUCUNEIFORM " +
	"SIGN EZEN TIMES U2CUNEIFORM SIGN EZEN TIMES UDCUNEIFORM SIGN GACUNEIFORM" +
	" SIGN GA GUNUCUNEIFORM SIGN GA2CUNEIFORM SIGN GA2 TIMES A PLUS DA PLUS H" +
	"ACUNEIFORM SIGN GA2 TIMES A PLUS HACUNEIFORM SIGN GA2 TIMES A PLUS IGICU" +
	"NEIFORM SIGN GA2 TIMES AB2 TENU PLUS TABCUNEIFORM SIGN GA2 TIMES ANCUNEI" +
	"FORM SIGN GA2 TIMES ASHCUNEIFORM SIGN GA2 TIMES ASH2 PLUS GALCUNEIFORM S" +
	"IGN GA2 TIMES BADCUNEIFORM SIGN GA2 TIMES BAR PLUS RACUNEIFORM SIGN GA2 " +
	"TIMES BURCUNEIFORM SIGN GA2 TIMES BUR PLUS RACUNEIFORM SIGN GA2 TIMES DA" +
	"CUNEIFORM SIGN GA2 TIMES DICUNEIFORM SIGN GA2 TIMES DIM TIMES SHECUNEIFO" +
	"RM SIGN GA2 TIMES DUBCUNEIFORM SIGN GA2 TIMES ELCUNEIFORM SIGN GA2 TIMES" +
	" EL PLUS LACUNEIFORM SIGN GA2 TIMES ENCUNEIFORM SIGN GA2 TIMES EN TIMES " +
	"GAN2 TENUCUNEIFORM SIGN GA2 TIMES GAN2 TENUCUNEIFORM SIGN GA2 TIMES GARC" +
	"UNEIFORM SIGN GA2 TIMES GICUNEIFORM SIGN GA2 TIMES GI4CUNEIFORM SIGN GA2" +
	" TIMES GI4 PLUS ACUNEIFORM SIGN GA2 TIMES GIR2 PLUS SUCUNEIFORM SIGN GA2" +
	" TIMES HA PLUS LU PLUS ESH2CUNEIFORM SIGN GA2 TIMES HALCUNEIFORM SIGN GA") + ("" +
	"2 TIMES HAL PLUS LACUNEIFORM SIGN GA2 TIMES HI PLUS LICUNEIFORM SIGN GA2" +
	" TIMES HUB2CUNEIFORM SIGN GA2 TIMES IGI GUNUCUNEIFORM SIGN GA2 TIMES ISH" +
	" PLUS HU PLUS ASHCUNEIFORM SIGN GA2 TIMES KAKCUNEIFORM SIGN GA2 TIMES KA" +
	"SKALCUNEIFORM SIGN GA2 TIMES KIDCUNEIFORM SIGN GA2 TIMES KID PLUS LALCUN" +
	"EIFORM SIGN GA2 TIMES KU3 PLUS ANCUNEIFORM SIGN GA2 TIMES LACUNEIFORM SI" +
	"GN GA2 TIMES ME PLUS ENCUNEIFORM SIGN GA2 TIMES MICUNEIFORM SIGN GA2 TIM" +
	"ES NUNCUNEIFORM SIGN GA2 TIMES NUN OVER NUNCUNEIFORM SIGN GA2 TIMES PACU" +
	"NEIFORM SIGN GA2 TIMES SALCUNEIFORM SIGN GA2 TIMES SARCUNEIFORM SIGN GA2" +
	" TIMES SHECUNEIFORM SIGN GA2 TIMES SHE PLUS TURCUNEIFORM SIGN GA2 TIMES " +
	"SHIDCUNEIFORM SIGN GA2 TIMES SUMCUNEIFORM SIGN GA2 TIMES TAK4CUNEIFORM S" +
	"IGN GA2 TIMES UCUNEIFORM SIGN GA2 TIMES UDCUNEIFORM SIGN GA2 TIMES UD PL" +
	"US DUCUNEIFORM SIGN GA2 OVER GA2CUNEIFORM SIGN GABACUNEIFORM SIGN GABA C" +
	"ROSSING GABACUNEIFORM SIGN GADCUNEIFORM SIGN GAD OVER GAD GAR OVER GARCU" +
	"NEIFORM SIGN GALCUNEIFORM SIGN GAL GAD OVER GAD GAR OVER GARCUNEIFORM SI" +
	"GN GALAMCUNEIFORM SIGN GAMCUNEIFORM SIGN GANCUNEIFORM SIGN GAN2CUNEIFORM" +
	" SIGN GAN2 TENUCUNEIFORM SIGN GAN2 OVER GAN2CUNEIFORM SIGN GAN2 CROSSING" +
	" GAN2CUNEIFORM SIGN GARCUNEIFORM SIGN GAR3CUNEIFORM SIGN GASHANCUNEIFORM" +
	" SIGN GESHTINCUNEIFORM SIGN GESHTIN TIMES KURCUNEIFORM SIGN GICUNEIFORM " +
	"SIGN GI TIMES ECUNEIFORM SIGN GI TIMES UCUNEIFORM SIGN GI CROSSING GICUN" +
	"EIFORM SIGN GI4CUNEIFORM SIGN GI4 OVER GI4CUNEIFORM SIGN GI4 CROSSING GI" +
	"4CUNEIFORM SIGN GIDIMCUNEIFORM SIGN GIR2CUNEIFORM SIGN GIR2 GUNUCUNEIFOR" +
	"M SIGN GIR3CUNEIFORM SIGN GIR3 TIMES A PLUS IGICUNEIFORM SIGN GIR3 TIMES" +
	" GAN2 TENUCUNEIFORM SIGN GIR3 TIMES IGICUNEIFORM SIGN GIR3 TIMES LU PLUS" +
	" IGICUNEIFORM SIGN GIR3 TIMES PACUNEIFORM SIGN GISALCUNEIFORM SIGN GISHC" +
	"UNEIFORM SIGN GISH CROSSING GISHCUNEIFORM SIGN GISH TIMES BADCUNEIFORM S" +
	"IGN GISH TIMES TAK4CUNEIFORM SIGN GISH TENUCUNEIFORM SIGN GUCUNEIFORM SI" +
	"GN GU CROSSING GUCUNEIFORM SIGN GU2CUNEIFORM SIGN GU2 TIMES KAKCUNEIFORM" +
	" SIGN GU2 TIMES KAK TIMES IGI GUNUCUNEIFORM SIGN GU2 TIMES NUNCUNEIFORM " +
	"SIGN GU2 TIMES SAL PLUS TUG2CUNEIFORM SIGN GU2 GUNUCUNEIFORM SIGN GUDCUN" +
	"EIFORM SIGN GUD TIMES A PLUS KURCUNEIFORM SIGN GUD TIMES KURCUNEIFORM SI" +
	"GN GUD OVER GUD LUGALCUNEIFORM SIGN GULCUNEIFORM SIGN GUMCUNEIFORM SIGN " +
	"GUM TIMES SHECUNEIFORM SIGN GURCUNEIFORM SIGN GUR7CUNEIFORM SIGN GURUNCU" +
	"NEIFORM SIGN GURUSHCUNEIFORM SIGN HACUNEIFORM SIGN HA TENUCUNEIFORM SIGN" +
	" HA GUNUCUNEIFORM SIGN HALCUNEIFORM SIGN HICUNEIFORM SIGN HI TIMES ASHCU" +
	"NEIFORM SIGN HI TIMES ASH2CUNEIFORM SIGN HI TIMES BADCUNEIFORM SIGN HI T" +
	"IMES DISHCUNEIFORM SIGN HI TIMES GADCUNEIFORM SIGN HI TIMES KINCUNEIFORM" +
	" SIGN HI TIMES NUNCUNEIFORM SIGN HI TIMES SHECUNEIFORM SIGN HI TIMES UCU" +
	"NEIFORM SIGN HUCUNEIFORM SIGN HUB2CUNEIFORM SIGN HUB2 TIMES ANCUNEIFORM " +
	"SIGN HUB2 TIMES HALCUNEIFORM SIGN HUB2 TIMES KASKALCUNEIFORM SIGN HUB2 T" +
	"IMES LISHCUNEIFORM SIGN HUB2 TIMES UDCUNEIFORM SIGN HUL2CUNEIFORM SIGN I" +
	"CUNEIFORM SIGN I ACUNEIFORM SIGN IBCUNEIFORM SIGN IDIMCUNEIFORM SIGN IDI" +
	"M OVER IDIM BURCUNEIFORM SIGN IDIM OVER IDIM SQUAREDCUNEIFORM SIGN IGCUN" +
	"EIFORM SIGN IGICUNEIFORM SIGN IGI DIBCUNEIFORM SIGN IGI RICUNEIFORM SIGN" +
	" IGI OVER IGI SHIR OVER SHIR UD OVER UDCUNEIFORM SIGN IGI GUNUCUNEIFORM " +
	"SIGN ILCUNEIFORM SIGN IL TIMES GAN2 TENUCUNEIFORM SIGN IL2CUNEIFORM SIGN" +
	" IMCUNEIFORM SIGN IM TIMES TAK4CUNEIFORM SIGN IM CROSSING IMCUNEIFORM SI" +
	"GN IM OPPOSING IMCUNEIFORM SIGN IM SQUAREDCUNEIFORM SIGN IMINCUNEIFORM S" +
	"IGN INCUNEIFORM SIGN IRCUNEIFORM SIGN ISHCUNEIFORM SIGN KACUNEIFORM SIGN" +
	" KA TIMES ACUNEIFORM SIGN KA TIMES ADCUNEIFORM SIGN KA TIMES AD PLUS KU3" +
	"CUNEIFORM SIGN KA TIMES ASH2CUNEIFORM SIGN KA TIMES BADCUNEIFORM SIGN KA" +
	" TIMES BALAGCUNEIFORM SIGN KA TIMES BARCUNEIFORM SIGN KA TIMES BICUNEIFO" +
	"RM SIGN KA TIMES ERIN2CUNEIFORM SIGN KA TIMES ESH2CUNEIFORM SIGN KA TIME" +
	"S GACUNEIFORM SIGN KA TIMES GALCUNEIFORM SIGN KA TIMES GAN2 TENUCUNEIFOR" +
	"M SIGN KA TIMES GARCUNEIFORM SIGN KA TIMES GAR PLUS SHA3 PLUS ACUNEIFORM" +
	" SIGN KA TIMES GICUNEIFORM SIGN KA TIMES GIR2CUNEIFORM SIGN KA TIMES GIS" +
	"H PLUS SARCUNEIFORM SIGN KA TIMES GISH CROSSING GISHCUNEIFORM SIGN KA TI" +
	"MES GUCUNEIFORM SIGN KA TIMES GUR7CUNEIFORM SIGN KA TIMES IGICUNEIFORM S" +
	"IGN KA TIMES IMCUNEIFORM SIGN KA TIMES KAKCUNEIFORM SIGN KA TIMES KICUNE" +
	"IFORM SIGN KA TIMES KIDCUNEIFORM SIGN KA TIMES LICUNEIFORM SIGN KA TIMES" +
	" LUCUNEIFORM SIGN KA TIMES MECUNEIFORM SIGN KA TIMES ME PLUS DUCUNEIFORM" +
	" SIGN KA TIMES ME PLUS GICUNEIFORM SIGN KA TIMES ME PLUS TECUNEIFORM SIG" +
	"N KA TIMES MICUNEIFORM SIGN KA TIMES MI PLUS NUNUZCUNEIFORM SIGN KA TIME" +
	"S NECUNEIFORM SIGN KA TIMES NUNCUNEIFORM SIGN KA TIMES PICUNEIFORM SIGN " +
	"KA TIMES RUCUNEIFORM SIGN KA TIMES SACUNEIFORM SIGN KA TIMES SARCUNEIFOR") + ("" +
	"M SIGN KA TIMES SHACUNEIFORM SIGN KA TIMES SHECUNEIFORM SIGN KA TIMES SH" +
	"IDCUNEIFORM SIGN KA TIMES SHUCUNEIFORM SIGN KA TIMES SIGCUNEIFORM SIGN K" +
	"A TIMES SUHURCUNEIFORM SIGN KA TIMES TARCUNEIFORM SIGN KA TIMES UCUNEIFO" +
	"RM SIGN KA TIMES U2CUNEIFORM SIGN KA TIMES UDCUNEIFORM SIGN KA TIMES UMU" +
	"M TIMES PACUNEIFORM SIGN KA TIMES USHCUNEIFORM SIGN KA TIMES ZICUNEIFORM" +
	" SIGN KA2CUNEIFORM SIGN KA2 CROSSING KA2CUNEIFORM SIGN KABCUNEIFORM SIGN" +
	" KAD2CUNEIFORM SIGN KAD3CUNEIFORM SIGN KAD4CUNEIFORM SIGN KAD5CUNEIFORM " +
	"SIGN KAD5 OVER KAD5CUNEIFORM SIGN KAKCUNEIFORM SIGN KAK TIMES IGI GUNUCU" +
	"NEIFORM SIGN KALCUNEIFORM SIGN KAL TIMES BADCUNEIFORM SIGN KAL CROSSING " +
	"KALCUNEIFORM SIGN KAM2CUNEIFORM SIGN KAM4CUNEIFORM SIGN KASKALCUNEIFORM " +
	"SIGN KASKAL LAGAB TIMES U OVER LAGAB TIMES UCUNEIFORM SIGN KASKAL OVER K" +
	"ASKAL LAGAB TIMES U OVER LAGAB TIMES UCUNEIFORM SIGN KESH2CUNEIFORM SIGN" +
	" KICUNEIFORM SIGN KI TIMES BADCUNEIFORM SIGN KI TIMES UCUNEIFORM SIGN KI" +
	" TIMES UDCUNEIFORM SIGN KIDCUNEIFORM SIGN KINCUNEIFORM SIGN KISALCUNEIFO" +
	"RM SIGN KISHCUNEIFORM SIGN KISIM5CUNEIFORM SIGN KISIM5 OVER KISIM5CUNEIF" +
	"ORM SIGN KUCUNEIFORM SIGN KU OVER HI TIMES ASH2 KU OVER HI TIMES ASH2CUN" +
	"EIFORM SIGN KU3CUNEIFORM SIGN KU4CUNEIFORM SIGN KU4 VARIANT FORMCUNEIFOR" +
	"M SIGN KU7CUNEIFORM SIGN KULCUNEIFORM SIGN KUL GUNUCUNEIFORM SIGN KUNCUN" +
	"EIFORM SIGN KURCUNEIFORM SIGN KUR OPPOSING KURCUNEIFORM SIGN KUSHU2CUNEI" +
	"FORM SIGN KWU318CUNEIFORM SIGN LACUNEIFORM SIGN LAGABCUNEIFORM SIGN LAGA" +
	"B TIMES ACUNEIFORM SIGN LAGAB TIMES A PLUS DA PLUS HACUNEIFORM SIGN LAGA" +
	"B TIMES A PLUS GARCUNEIFORM SIGN LAGAB TIMES A PLUS LALCUNEIFORM SIGN LA" +
	"GAB TIMES ALCUNEIFORM SIGN LAGAB TIMES ANCUNEIFORM SIGN LAGAB TIMES ASH " +
	"ZIDA TENUCUNEIFORM SIGN LAGAB TIMES BADCUNEIFORM SIGN LAGAB TIMES BICUNE" +
	"IFORM SIGN LAGAB TIMES DARCUNEIFORM SIGN LAGAB TIMES ENCUNEIFORM SIGN LA" +
	"GAB TIMES GACUNEIFORM SIGN LAGAB TIMES GARCUNEIFORM SIGN LAGAB TIMES GUD" +
	"CUNEIFORM SIGN LAGAB TIMES GUD PLUS GUDCUNEIFORM SIGN LAGAB TIMES HACUNE" +
	"IFORM SIGN LAGAB TIMES HALCUNEIFORM SIGN LAGAB TIMES HI TIMES NUNCUNEIFO" +
	"RM SIGN LAGAB TIMES IGI GUNUCUNEIFORM SIGN LAGAB TIMES IMCUNEIFORM SIGN " +
	"LAGAB TIMES IM PLUS HACUNEIFORM SIGN LAGAB TIMES IM PLUS LUCUNEIFORM SIG" +
	"N LAGAB TIMES KICUNEIFORM SIGN LAGAB TIMES KINCUNEIFORM SIGN LAGAB TIMES" +
	" KU3CUNEIFORM SIGN LAGAB TIMES KULCUNEIFORM SIGN LAGAB TIMES KUL PLUS HI" +
	" PLUS ACUNEIFORM SIGN LAGAB TIMES LAGABCUNEIFORM SIGN LAGAB TIMES LISHCU" +
	"NEIFORM SIGN LAGAB TIMES LUCUNEIFORM SIGN LAGAB TIMES LULCUNEIFORM SIGN " +
	"LAGAB TIMES MECUNEIFORM SIGN LAGAB TIMES ME PLUS ENCUNEIFORM SIGN LAGAB " +
	"TIMES MUSHCUNEIFORM SIGN LAGAB TIMES NECUNEIFORM SIGN LAGAB TIMES SHE PL" +
	"US SUMCUNEIFORM SIGN LAGAB TIMES SHITA PLUS GISH PLUS ERIN2CUNEIFORM SIG" +
	"N LAGAB TIMES SHITA PLUS GISH TENUCUNEIFORM SIGN LAGAB TIMES SHU2CUNEIFO" +
	"RM SIGN LAGAB TIMES SHU2 PLUS SHU2CUNEIFORM SIGN LAGAB TIMES SUMCUNEIFOR" +
	"M SIGN LAGAB TIMES TAGCUNEIFORM SIGN LAGAB TIMES TAK4CUNEIFORM SIGN LAGA" +
	"B TIMES TE PLUS A PLUS SU PLUS NACUNEIFORM SIGN LAGAB TIMES UCUNEIFORM S" +
	"IGN LAGAB TIMES U PLUS ACUNEIFORM SIGN LAGAB TIMES U PLUS U PLUS UCUNEIF" +
	"ORM SIGN LAGAB TIMES U2 PLUS ASHCUNEIFORM SIGN LAGAB TIMES UDCUNEIFORM S" +
	"IGN LAGAB TIMES USHCUNEIFORM SIGN LAGAB SQUAREDCUNEIFORM SIGN LAGARCUNEI" +
	"FORM SIGN LAGAR TIMES SHECUNEIFORM SIGN LAGAR TIMES SHE PLUS SUMCUNEIFOR" +
	"M SIGN LAGAR GUNUCUNEIFORM SIGN LAGAR GUNU OVER LAGAR GUNU SHECUNEIFORM " +
	"SIGN LAHSHUCUNEIFORM SIGN LALCUNEIFORM SIGN LAL TIMES LALCUNEIFORM SIGN " +
	"LAMCUNEIFORM SIGN LAM TIMES KURCUNEIFORM SIGN LAM TIMES KUR PLUS RUCUNEI" +
	"FORM SIGN LICUNEIFORM SIGN LILCUNEIFORM SIGN LIMMU2CUNEIFORM SIGN LISHCU" +
	"NEIFORM SIGN LUCUNEIFORM SIGN LU TIMES BADCUNEIFORM SIGN LU2CUNEIFORM SI" +
	"GN LU2 TIMES ALCUNEIFORM SIGN LU2 TIMES BADCUNEIFORM SIGN LU2 TIMES ESH2" +
	"CUNEIFORM SIGN LU2 TIMES ESH2 TENUCUNEIFORM SIGN LU2 TIMES GAN2 TENUCUNE" +
	"IFORM SIGN LU2 TIMES HI TIMES BADCUNEIFORM SIGN LU2 TIMES IMCUNEIFORM SI" +
	"GN LU2 TIMES KAD2CUNEIFORM SIGN LU2 TIMES KAD3CUNEIFORM SIGN LU2 TIMES K" +
	"AD3 PLUS ASHCUNEIFORM SIGN LU2 TIMES KICUNEIFORM SIGN LU2 TIMES LA PLUS " +
	"ASHCUNEIFORM SIGN LU2 TIMES LAGABCUNEIFORM SIGN LU2 TIMES ME PLUS ENCUNE" +
	"IFORM SIGN LU2 TIMES NECUNEIFORM SIGN LU2 TIMES NUCUNEIFORM SIGN LU2 TIM" +
	"ES SI PLUS ASHCUNEIFORM SIGN LU2 TIMES SIK2 PLUS BUCUNEIFORM SIGN LU2 TI" +
	"MES TUG2CUNEIFORM SIGN LU2 TENUCUNEIFORM SIGN LU2 CROSSING LU2CUNEIFORM " +
	"SIGN LU2 OPPOSING LU2CUNEIFORM SIGN LU2 SQUAREDCUNEIFORM SIGN LU2 SHESHI" +
	"GCUNEIFORM SIGN LU3CUNEIFORM SIGN LUGALCUNEIFORM SIGN LUGAL OVER LUGALCU" +
	"NEIFORM SIGN LUGAL OPPOSING LUGALCUNEIFORM SIGN LUGAL SHESHIGCUNEIFORM S" +
	"IGN LUHCUNEIFORM SIGN LULCUNEIFORM SIGN LUMCUNEIFORM SIGN LUM OVER LUMCU" +
	"NEIFORM SIGN LUM OVER LUM GAR OVER GARCUNEIFORM SIGN MACUNEIFORM SIGN MA") + ("" +
	" TIMES TAK4CUNEIFORM SIGN MA GUNUCUNEIFORM SIGN MA2CUNEIFORM SIGN MAHCUN" +
	"EIFORM SIGN MARCUNEIFORM SIGN MASHCUNEIFORM SIGN MASH2CUNEIFORM SIGN MEC" +
	"UNEIFORM SIGN MESCUNEIFORM SIGN MICUNEIFORM SIGN MINCUNEIFORM SIGN MUCUN" +
	"EIFORM SIGN MU OVER MUCUNEIFORM SIGN MUGCUNEIFORM SIGN MUG GUNUCUNEIFORM" +
	" SIGN MUNSUBCUNEIFORM SIGN MURGU2CUNEIFORM SIGN MUSHCUNEIFORM SIGN MUSH " +
	"TIMES ACUNEIFORM SIGN MUSH TIMES KURCUNEIFORM SIGN MUSH TIMES ZACUNEIFOR" +
	"M SIGN MUSH OVER MUSHCUNEIFORM SIGN MUSH OVER MUSH TIMES A PLUS NACUNEIF" +
	"ORM SIGN MUSH CROSSING MUSHCUNEIFORM SIGN MUSH3CUNEIFORM SIGN MUSH3 TIME" +
	"S ACUNEIFORM SIGN MUSH3 TIMES A PLUS DICUNEIFORM SIGN MUSH3 TIMES DICUNE" +
	"IFORM SIGN MUSH3 GUNUCUNEIFORM SIGN NACUNEIFORM SIGN NA2CUNEIFORM SIGN N" +
	"AGACUNEIFORM SIGN NAGA INVERTEDCUNEIFORM SIGN NAGA TIMES SHU TENUCUNEIFO" +
	"RM SIGN NAGA OPPOSING NAGACUNEIFORM SIGN NAGARCUNEIFORM SIGN NAM NUTILLU" +
	"CUNEIFORM SIGN NAMCUNEIFORM SIGN NAM2CUNEIFORM SIGN NECUNEIFORM SIGN NE " +
	"TIMES ACUNEIFORM SIGN NE TIMES UDCUNEIFORM SIGN NE SHESHIGCUNEIFORM SIGN" +
	" NICUNEIFORM SIGN NI TIMES ECUNEIFORM SIGN NI2CUNEIFORM SIGN NIMCUNEIFOR" +
	"M SIGN NIM TIMES GAN2 TENUCUNEIFORM SIGN NIM TIMES GAR PLUS GAN2 TENUCUN" +
	"EIFORM SIGN NINDA2CUNEIFORM SIGN NINDA2 TIMES ANCUNEIFORM SIGN NINDA2 TI" +
	"MES ASHCUNEIFORM SIGN NINDA2 TIMES ASH PLUS ASHCUNEIFORM SIGN NINDA2 TIM" +
	"ES GUDCUNEIFORM SIGN NINDA2 TIMES ME PLUS GAN2 TENUCUNEIFORM SIGN NINDA2" +
	" TIMES NECUNEIFORM SIGN NINDA2 TIMES NUNCUNEIFORM SIGN NINDA2 TIMES SHEC" +
	"UNEIFORM SIGN NINDA2 TIMES SHE PLUS A ANCUNEIFORM SIGN NINDA2 TIMES SHE " +
	"PLUS ASHCUNEIFORM SIGN NINDA2 TIMES SHE PLUS ASH PLUS ASHCUNEIFORM SIGN " +
	"NINDA2 TIMES U2 PLUS ASHCUNEIFORM SIGN NINDA2 TIMES USHCUNEIFORM SIGN NI" +
	"SAGCUNEIFORM SIGN NUCUNEIFORM SIGN NU11CUNEIFORM SIGN NUNCUNEIFORM SIGN " +
	"NUN LAGAR TIMES GARCUNEIFORM SIGN NUN LAGAR TIMES MASHCUNEIFORM SIGN NUN" +
	" LAGAR TIMES SALCUNEIFORM SIGN NUN LAGAR TIMES SAL OVER NUN LAGAR TIMES " +
	"SALCUNEIFORM SIGN NUN LAGAR TIMES USHCUNEIFORM SIGN NUN TENUCUNEIFORM SI" +
	"GN NUN OVER NUNCUNEIFORM SIGN NUN CROSSING NUNCUNEIFORM SIGN NUN CROSSIN" +
	"G NUN LAGAR OVER LAGARCUNEIFORM SIGN NUNUZCUNEIFORM SIGN NUNUZ AB2 TIMES" +
	" ASHGABCUNEIFORM SIGN NUNUZ AB2 TIMES BICUNEIFORM SIGN NUNUZ AB2 TIMES D" +
	"UGCUNEIFORM SIGN NUNUZ AB2 TIMES GUDCUNEIFORM SIGN NUNUZ AB2 TIMES IGI G" +
	"UNUCUNEIFORM SIGN NUNUZ AB2 TIMES KAD3CUNEIFORM SIGN NUNUZ AB2 TIMES LAC" +
	"UNEIFORM SIGN NUNUZ AB2 TIMES NECUNEIFORM SIGN NUNUZ AB2 TIMES SILA3CUNE" +
	"IFORM SIGN NUNUZ AB2 TIMES U2CUNEIFORM SIGN NUNUZ KISIM5 TIMES BICUNEIFO" +
	"RM SIGN NUNUZ KISIM5 TIMES BI UCUNEIFORM SIGN PACUNEIFORM SIGN PADCUNEIF" +
	"ORM SIGN PANCUNEIFORM SIGN PAPCUNEIFORM SIGN PESH2CUNEIFORM SIGN PICUNEI" +
	"FORM SIGN PI TIMES ACUNEIFORM SIGN PI TIMES ABCUNEIFORM SIGN PI TIMES BI" +
	"CUNEIFORM SIGN PI TIMES BUCUNEIFORM SIGN PI TIMES ECUNEIFORM SIGN PI TIM" +
	"ES ICUNEIFORM SIGN PI TIMES IBCUNEIFORM SIGN PI TIMES UCUNEIFORM SIGN PI" +
	" TIMES U2CUNEIFORM SIGN PI CROSSING PICUNEIFORM SIGN PIRIGCUNEIFORM SIGN" +
	" PIRIG TIMES KALCUNEIFORM SIGN PIRIG TIMES UDCUNEIFORM SIGN PIRIG TIMES " +
	"ZACUNEIFORM SIGN PIRIG OPPOSING PIRIGCUNEIFORM SIGN RACUNEIFORM SIGN RAB" +
	"CUNEIFORM SIGN RICUNEIFORM SIGN RUCUNEIFORM SIGN SACUNEIFORM SIGN SAG NU" +
	"TILLUCUNEIFORM SIGN SAGCUNEIFORM SIGN SAG TIMES ACUNEIFORM SIGN SAG TIME" +
	"S DUCUNEIFORM SIGN SAG TIMES DUBCUNEIFORM SIGN SAG TIMES HACUNEIFORM SIG" +
	"N SAG TIMES KAKCUNEIFORM SIGN SAG TIMES KURCUNEIFORM SIGN SAG TIMES LUMC" +
	"UNEIFORM SIGN SAG TIMES MICUNEIFORM SIGN SAG TIMES NUNCUNEIFORM SIGN SAG" +
	" TIMES SALCUNEIFORM SIGN SAG TIMES SHIDCUNEIFORM SIGN SAG TIMES TABCUNEI" +
	"FORM SIGN SAG TIMES U2CUNEIFORM SIGN SAG TIMES UBCUNEIFORM SIGN SAG TIME" +
	"S UMCUNEIFORM SIGN SAG TIMES URCUNEIFORM SIGN SAG TIMES USHCUNEIFORM SIG" +
	"N SAG OVER SAGCUNEIFORM SIGN SAG GUNUCUNEIFORM SIGN SALCUNEIFORM SIGN SA" +
	"L LAGAB TIMES ASH2CUNEIFORM SIGN SANGA2CUNEIFORM SIGN SARCUNEIFORM SIGN " +
	"SHACUNEIFORM SIGN SHA3CUNEIFORM SIGN SHA3 TIMES ACUNEIFORM SIGN SHA3 TIM" +
	"ES BADCUNEIFORM SIGN SHA3 TIMES GISHCUNEIFORM SIGN SHA3 TIMES NECUNEIFOR" +
	"M SIGN SHA3 TIMES SHU2CUNEIFORM SIGN SHA3 TIMES TURCUNEIFORM SIGN SHA3 T" +
	"IMES UCUNEIFORM SIGN SHA3 TIMES U PLUS ACUNEIFORM SIGN SHA6CUNEIFORM SIG" +
	"N SHAB6CUNEIFORM SIGN SHAR2CUNEIFORM SIGN SHECUNEIFORM SIGN SHE HUCUNEIF" +
	"ORM SIGN SHE OVER SHE GAD OVER GAD GAR OVER GARCUNEIFORM SIGN SHE OVER S" +
	"HE TAB OVER TAB GAR OVER GARCUNEIFORM SIGN SHEG9CUNEIFORM SIGN SHENCUNEI" +
	"FORM SIGN SHESHCUNEIFORM SIGN SHESH2CUNEIFORM SIGN SHESHLAMCUNEIFORM SIG" +
	"N SHIDCUNEIFORM SIGN SHID TIMES ACUNEIFORM SIGN SHID TIMES IMCUNEIFORM S" +
	"IGN SHIMCUNEIFORM SIGN SHIM TIMES ACUNEIFORM SIGN SHIM TIMES BALCUNEIFOR" +
	"M SIGN SHIM TIMES BULUGCUNEIFORM SIGN SHIM TIMES DINCUNEIFORM SIGN SHIM " +
	"TIMES GARCUNEIFORM SIGN SHIM TIMES IGICUNEIFORM SIGN SHIM TIMES IGI GUNU") + ("" +
	"CUNEIFORM SIGN SHIM TIMES KUSHU2CUNEIFORM SIGN SHIM TIMES LULCUNEIFORM S" +
	"IGN SHIM TIMES MUGCUNEIFORM SIGN SHIM TIMES SALCUNEIFORM SIGN SHINIGCUNE" +
	"IFORM SIGN SHIRCUNEIFORM SIGN SHIR TENUCUNEIFORM SIGN SHIR OVER SHIR BUR" +
	" OVER BURCUNEIFORM SIGN SHITACUNEIFORM SIGN SHUCUNEIFORM SIGN SHU OVER I" +
	"NVERTED SHUCUNEIFORM SIGN SHU2CUNEIFORM SIGN SHUBURCUNEIFORM SIGN SICUNE" +
	"IFORM SIGN SI GUNUCUNEIFORM SIGN SIGCUNEIFORM SIGN SIG4CUNEIFORM SIGN SI" +
	"G4 OVER SIG4 SHU2CUNEIFORM SIGN SIK2CUNEIFORM SIGN SILA3CUNEIFORM SIGN S" +
	"UCUNEIFORM SIGN SU OVER SUCUNEIFORM SIGN SUDCUNEIFORM SIGN SUD2CUNEIFORM" +
	" SIGN SUHURCUNEIFORM SIGN SUMCUNEIFORM SIGN SUMASHCUNEIFORM SIGN SURCUNE" +
	"IFORM SIGN SUR9CUNEIFORM SIGN TACUNEIFORM SIGN TA ASTERISKCUNEIFORM SIGN" +
	" TA TIMES HICUNEIFORM SIGN TA TIMES MICUNEIFORM SIGN TA GUNUCUNEIFORM SI" +
	"GN TABCUNEIFORM SIGN TAB OVER TAB NI OVER NI DISH OVER DISHCUNEIFORM SIG" +
	"N TAB SQUAREDCUNEIFORM SIGN TAGCUNEIFORM SIGN TAG TIMES BICUNEIFORM SIGN" +
	" TAG TIMES GUDCUNEIFORM SIGN TAG TIMES SHECUNEIFORM SIGN TAG TIMES SHUCU" +
	"NEIFORM SIGN TAG TIMES TUG2CUNEIFORM SIGN TAG TIMES UDCUNEIFORM SIGN TAK" +
	"4CUNEIFORM SIGN TARCUNEIFORM SIGN TECUNEIFORM SIGN TE GUNUCUNEIFORM SIGN" +
	" TICUNEIFORM SIGN TI TENUCUNEIFORM SIGN TILCUNEIFORM SIGN TIRCUNEIFORM S" +
	"IGN TIR TIMES TAK4CUNEIFORM SIGN TIR OVER TIRCUNEIFORM SIGN TIR OVER TIR" +
	" GAD OVER GAD GAR OVER GARCUNEIFORM SIGN TUCUNEIFORM SIGN TUG2CUNEIFORM " +
	"SIGN TUKCUNEIFORM SIGN TUMCUNEIFORM SIGN TURCUNEIFORM SIGN TUR OVER TUR " +
	"ZA OVER ZACUNEIFORM SIGN UCUNEIFORM SIGN U GUDCUNEIFORM SIGN U U UCUNEIF" +
	"ORM SIGN U OVER U PA OVER PA GAR OVER GARCUNEIFORM SIGN U OVER U SUR OVE" +
	"R SURCUNEIFORM SIGN U OVER U U REVERSED OVER U REVERSEDCUNEIFORM SIGN U2" +
	"CUNEIFORM SIGN UBCUNEIFORM SIGN UDCUNEIFORM SIGN UD KUSHU2CUNEIFORM SIGN" +
	" UD TIMES BADCUNEIFORM SIGN UD TIMES MICUNEIFORM SIGN UD TIMES U PLUS U " +
	"PLUS UCUNEIFORM SIGN UD TIMES U PLUS U PLUS U GUNUCUNEIFORM SIGN UD GUNU" +
	"CUNEIFORM SIGN UD SHESHIGCUNEIFORM SIGN UD SHESHIG TIMES BADCUNEIFORM SI" +
	"GN UDUGCUNEIFORM SIGN UMCUNEIFORM SIGN UM TIMES LAGABCUNEIFORM SIGN UM T" +
	"IMES ME PLUS DACUNEIFORM SIGN UM TIMES SHA3CUNEIFORM SIGN UM TIMES UCUNE" +
	"IFORM SIGN UMBINCUNEIFORM SIGN UMUMCUNEIFORM SIGN UMUM TIMES KASKALCUNEI" +
	"FORM SIGN UMUM TIMES PACUNEIFORM SIGN UNCUNEIFORM SIGN UN GUNUCUNEIFORM " +
	"SIGN URCUNEIFORM SIGN UR CROSSING URCUNEIFORM SIGN UR SHESHIGCUNEIFORM S" +
	"IGN UR2CUNEIFORM SIGN UR2 TIMES A PLUS HACUNEIFORM SIGN UR2 TIMES A PLUS" +
	" NACUNEIFORM SIGN UR2 TIMES ALCUNEIFORM SIGN UR2 TIMES HACUNEIFORM SIGN " +
	"UR2 TIMES NUNCUNEIFORM SIGN UR2 TIMES U2CUNEIFORM SIGN UR2 TIMES U2 PLUS" +
	" ASHCUNEIFORM SIGN UR2 TIMES U2 PLUS BICUNEIFORM SIGN UR4CUNEIFORM SIGN " +
	"URICUNEIFORM SIGN URI3CUNEIFORM SIGN URUCUNEIFORM SIGN URU TIMES ACUNEIF" +
	"ORM SIGN URU TIMES ASHGABCUNEIFORM SIGN URU TIMES BARCUNEIFORM SIGN URU " +
	"TIMES DUNCUNEIFORM SIGN URU TIMES GACUNEIFORM SIGN URU TIMES GALCUNEIFOR" +
	"M SIGN URU TIMES GAN2 TENUCUNEIFORM SIGN URU TIMES GARCUNEIFORM SIGN URU" +
	" TIMES GUCUNEIFORM SIGN URU TIMES HACUNEIFORM SIGN URU TIMES IGICUNEIFOR" +
	"M SIGN URU TIMES IMCUNEIFORM SIGN URU TIMES ISHCUNEIFORM SIGN URU TIMES " +
	"KICUNEIFORM SIGN URU TIMES LUMCUNEIFORM SIGN URU TIMES MINCUNEIFORM SIGN" +
	" URU TIMES PACUNEIFORM SIGN URU TIMES SHECUNEIFORM SIGN URU TIMES SIG4CU" +
	"NEIFORM SIGN URU TIMES TUCUNEIFORM SIGN URU TIMES U PLUS GUDCUNEIFORM SI" +
	"GN URU TIMES UDCUNEIFORM SIGN URU TIMES URUDACUNEIFORM SIGN URUDACUNEIFO" +
	"RM SIGN URUDA TIMES UCUNEIFORM SIGN USHCUNEIFORM SIGN USH TIMES ACUNEIFO" +
	"RM SIGN USH TIMES KUCUNEIFORM SIGN USH TIMES KURCUNEIFORM SIGN USH TIMES" +
	" TAK4CUNEIFORM SIGN USHXCUNEIFORM SIGN USH2CUNEIFORM SIGN USHUMXCUNEIFOR" +
	"M SIGN UTUKICUNEIFORM SIGN UZ3CUNEIFORM SIGN UZ3 TIMES KASKALCUNEIFORM S" +
	"IGN UZUCUNEIFORM SIGN ZACUNEIFORM SIGN ZA TENUCUNEIFORM SIGN ZA SQUARED " +
	"TIMES KURCUNEIFORM SIGN ZAGCUNEIFORM SIGN ZAMXCUNEIFORM SIGN ZE2CUNEIFOR" +
	"M SIGN ZICUNEIFORM SIGN ZI OVER ZICUNEIFORM SIGN ZI3CUNEIFORM SIGN ZIBCU" +
	"NEIFORM SIGN ZIB KABA TENUCUNEIFORM SIGN ZIGCUNEIFORM SIGN ZIZ2CUNEIFORM" +
	" SIGN ZUCUNEIFORM SIGN ZU5CUNEIFORM SIGN ZU5 TIMES ACUNEIFORM SIGN ZUBUR" +
	"CUNEIFORM SIGN ZUMCUNEIFORM SIGN KAP ELAMITECUNEIFORM SIGN AB TIMES NUNC" +
	"UNEIFORM SIGN AB2 TIMES ACUNEIFORM SIGN AMAR TIMES KUGCUNEIFORM SIGN DAG" +
	" KISIM5 TIMES U2 PLUS MASHCUNEIFORM SIGN DAG3CUNEIFORM SIGN DISH PLUS SH" +
	"UCUNEIFORM SIGN DUB TIMES SHECUNEIFORM SIGN EZEN TIMES GUDCUNEIFORM SIGN" +
	" EZEN TIMES SHECUNEIFORM SIGN GA2 TIMES AN PLUS KAK PLUS ACUNEIFORM SIGN" +
	" GA2 TIMES ASH2CUNEIFORM SIGN GE22CUNEIFORM SIGN GIGCUNEIFORM SIGN HUSHC" +
	"UNEIFORM SIGN KA TIMES ANSHECUNEIFORM SIGN KA TIMES ASH3CUNEIFORM SIGN K" +
	"A TIMES GISHCUNEIFORM SIGN KA TIMES GUDCUNEIFORM SIGN KA TIMES HI TIMES " +
	"ASH2CUNEIFORM SIGN KA TIMES LUMCUNEIFORM SIGN KA TIMES PACUNEIFORM SIGN ") + ("" +
	"KA TIMES SHULCUNEIFORM SIGN KA TIMES TUCUNEIFORM SIGN KA TIMES UR2CUNEIF" +
	"ORM SIGN LAGAB TIMES GICUNEIFORM SIGN LU2 SHESHIG TIMES BADCUNEIFORM SIG" +
	"N LU2 TIMES ESH2 PLUS LALCUNEIFORM SIGN LU2 TIMES SHUCUNEIFORM SIGN MESH" +
	"CUNEIFORM SIGN MUSH3 TIMES ZACUNEIFORM SIGN NA4CUNEIFORM SIGN NINCUNEIFO" +
	"RM SIGN NIN9CUNEIFORM SIGN NINDA2 TIMES BALCUNEIFORM SIGN NINDA2 TIMES G" +
	"ICUNEIFORM SIGN NU11 ROTATED NINETY DEGREESCUNEIFORM SIGN PESH2 ASTERISK" +
	"CUNEIFORM SIGN PIR2CUNEIFORM SIGN SAG TIMES IGI GUNUCUNEIFORM SIGN TI2CU" +
	"NEIFORM SIGN UM TIMES MECUNEIFORM SIGN U UCUNEIFORM NUMERIC SIGN TWO ASH" +
	"CUNEIFORM NUMERIC SIGN THREE ASHCUNEIFORM NUMERIC SIGN FOUR ASHCUNEIFORM" +
	" NUMERIC SIGN FIVE ASHCUNEIFORM NUMERIC SIGN SIX ASHCUNEIFORM NUMERIC SI" +
	"GN SEVEN ASHCUNEIFORM NUMERIC SIGN EIGHT ASHCUNEIFORM NUMERIC SIGN NINE " +
	"ASHCUNEIFORM NUMERIC SIGN THREE DISHCUNEIFORM NUMERIC SIGN FOUR DISHCUNE" +
	"IFORM NUMERIC SIGN FIVE DISHCUNEIFORM NUMERIC SIGN SIX DISHCUNEIFORM NUM" +
	"ERIC SIGN SEVEN DISHCUNEIFORM NUMERIC SIGN EIGHT DISHCUNEIFORM NUMERIC S" +
	"IGN NINE DISHCUNEIFORM NUMERIC SIGN FOUR UCUNEIFORM NUMERIC SIGN FIVE UC" +
	"UNEIFORM NUMERIC SIGN SIX UCUNEIFORM NUMERIC SIGN SEVEN UCUNEIFORM NUMER" +
	"IC SIGN EIGHT UCUNEIFORM NUMERIC SIGN NINE UCUNEIFORM NUMERIC SIGN ONE G" +
	"ESH2CUNEIFORM NUMERIC SIGN TWO GESH2CUNEIFORM NUMERIC SIGN THREE GESH2CU" +
	"NEIFORM NUMERIC SIGN FOUR GESH2CUNEIFORM NUMERIC SIGN FIVE GESH2CUNEIFOR" +
	"M NUMERIC SIGN SIX GESH2CUNEIFORM NUMERIC SIGN SEVEN GESH2CUNEIFORM NUME" +
	"RIC SIGN EIGHT GESH2CUNEIFORM NUMERIC SIGN NINE GESH2CUNEIFORM NUMERIC S" +
	"IGN ONE GESHUCUNEIFORM NUMERIC SIGN TWO GESHUCUNEIFORM NUMERIC SIGN THRE" +
	"E GESHUCUNEIFORM NUMERIC SIGN FOUR GESHUCUNEIFORM NUMERIC SIGN FIVE GESH" +
	"UCUNEIFORM NUMERIC SIGN TWO SHAR2CUNEIFORM NUMERIC SIGN THREE SHAR2CUNEI" +
	"FORM NUMERIC SIGN THREE SHAR2 VARIANT FORMCUNEIFORM NUMERIC SIGN FOUR SH" +
	"AR2CUNEIFORM NUMERIC SIGN FIVE SHAR2CUNEIFORM NUMERIC SIGN SIX SHAR2CUNE" +
	"IFORM NUMERIC SIGN SEVEN SHAR2CUNEIFORM NUMERIC SIGN EIGHT SHAR2CUNEIFOR" +
	"M NUMERIC SIGN NINE SHAR2CUNEIFORM NUMERIC SIGN ONE SHARUCUNEIFORM NUMER" +
	"IC SIGN TWO SHARUCUNEIFORM NUMERIC SIGN THREE SHARUCUNEIFORM NUMERIC SIG" +
	"N THREE SHARU VARIANT FORMCUNEIFORM NUMERIC SIGN FOUR SHARUCUNEIFORM NUM" +
	"ERIC SIGN FIVE SHARUCUNEIFORM NUMERIC SIGN SHAR2 TIMES GAL PLUS DISHCUNE" +
	"IFORM NUMERIC SIGN SHAR2 TIMES GAL PLUS MINCUNEIFORM NUMERIC SIGN ONE BU" +
	"RUCUNEIFORM NUMERIC SIGN TWO BURUCUNEIFORM NUMERIC SIGN THREE BURUCUNEIF" +
	"ORM NUMERIC SIGN THREE BURU VARIANT FORMCUNEIFORM NUMERIC SIGN FOUR BURU" +
	"CUNEIFORM NUMERIC SIGN FIVE BURUCUNEIFORM NUMERIC SIGN THREE VARIANT FOR" +
	"M ESH16CUNEIFORM NUMERIC SIGN THREE VARIANT FORM ESH21CUNEIFORM NUMERIC " +
	"SIGN FOUR VARIANT FORM LIMMUCUNEIFORM NUMERIC SIGN FOUR VARIANT FORM LIM" +
	"MU4CUNEIFORM NUMERIC SIGN FOUR VARIANT FORM LIMMU ACUNEIFORM NUMERIC SIG" +
	"N FOUR VARIANT FORM LIMMU BCUNEIFORM NUMERIC SIGN SIX VARIANT FORM ASH9C" +
	"UNEIFORM NUMERIC SIGN SEVEN VARIANT FORM IMIN3CUNEIFORM NUMERIC SIGN SEV" +
	"EN VARIANT FORM IMIN ACUNEIFORM NUMERIC SIGN SEVEN VARIANT FORM IMIN BCU" +
	"NEIFORM NUMERIC SIGN EIGHT VARIANT FORM USSUCUNEIFORM NUMERIC SIGN EIGHT" +
	" VARIANT FORM USSU3CUNEIFORM NUMERIC SIGN NINE VARIANT FORM ILIMMUCUNEIF" +
	"ORM NUMERIC SIGN NINE VARIANT FORM ILIMMU3CUNEIFORM NUMERIC SIGN NINE VA" +
	"RIANT FORM ILIMMU4CUNEIFORM NUMERIC SIGN NINE VARIANT FORM ILIMMU ACUNEI" +
	"FORM NUMERIC SIGN TWO ASH TENUCUNEIFORM NUMERIC SIGN THREE ASH TENUCUNEI" +
	"FORM NUMERIC SIGN FOUR ASH TENUCUNEIFORM NUMERIC SIGN FIVE ASH TENUCUNEI" +
	"FORM NUMERIC SIGN SIX ASH TENUCUNEIFORM NUMERIC SIGN ONE BAN2CUNEIFORM N" +
	"UMERIC SIGN TWO BAN2CUNEIFORM NUMERIC SIGN THREE BAN2CUNEIFORM NUMERIC S" +
	"IGN FOUR BAN2CUNEIFORM NUMERIC SIGN FOUR BAN2 VARIANT FORMCUNEIFORM NUME" +
	"RIC SIGN FIVE BAN2CUNEIFORM NUMERIC SIGN FIVE BAN2 VARIANT FORMCUNEIFORM" +
	" NUMERIC SIGN NIGIDAMINCUNEIFORM NUMERIC SIGN NIGIDAESHCUNEIFORM NUMERIC" +
	" SIGN ONE ESHE3CUNEIFORM NUMERIC SIGN TWO ESHE3CUNEIFORM NUMERIC SIGN ON" +
	"E THIRD DISHCUNEIFORM NUMERIC SIGN TWO THIRDS DISHCUNEIFORM NUMERIC SIGN" +
	" FIVE SIXTHS DISHCUNEIFORM NUMERIC SIGN ONE THIRD VARIANT FORM ACUNEIFOR" +
	"M NUMERIC SIGN TWO THIRDS VARIANT FORM ACUNEIFORM NUMERIC SIGN ONE EIGHT" +
	"H ASHCUNEIFORM NUMERIC SIGN ONE QUARTER ASHCUNEIFORM NUMERIC SIGN OLD AS" +
	"SYRIAN ONE SIXTHCUNEIFORM NUMERIC SIGN OLD ASSYRIAN ONE QUARTERCUNEIFORM" +
	" NUMERIC SIGN ONE QUARTER GURCUNEIFORM NUMERIC SIGN ONE HALF GURCUNEIFOR" +
	"M NUMERIC SIGN ELAMITE ONE THIRDCUNEIFORM NUMERIC SIGN ELAMITE TWO THIRD" +
	"SCUNEIFORM NUMERIC SIGN ELAMITE FORTYCUNEIFORM NUMERIC SIGN ELAMITE FIFT" +
	"YCUNEIFORM NUMERIC SIGN FOUR U VARIANT FORMCUNEIFORM NUMERIC SIGN FIVE U" +
	" VARIANT FORMCUNEIFORM NUMERIC SIGN SIX U VARIANT FORMCUNEIFORM NUMERIC " +
	"SIGN SEVEN U VARIANT FORMCUNEIFORM NUMERIC SIGN EIGHT U VARIANT FORMCUNE") + ("" +
	"IFORM NUMERIC SIGN NINE U VARIANT FORMCUNEIFORM PUNCTUATION SIGN OLD ASS" +
	"YRIAN WORD DIVIDERCUNEIFORM PUNCTUATION SIGN VERTICAL COLONCUNEIFORM PUN" +
	"CTUATION SIGN DIAGONAL COLONCUNEIFORM PUNCTUATION SIGN DIAGONAL TRICOLON" +
	"CUNEIFORM PUNCTUATION SIGN DIAGONAL QUADCOLONCUNEIFORM SIGN AB TIMES NUN" +
	" TENUCUNEIFORM SIGN AB TIMES SHU2CUNEIFORM SIGN AD TIMES ESH2CUNEIFORM S" +
	"IGN BAD TIMES DISH TENUCUNEIFORM SIGN BAHAR2 TIMES AB2CUNEIFORM SIGN BAH" +
	"AR2 TIMES NICUNEIFORM SIGN BAHAR2 TIMES ZACUNEIFORM SIGN BU OVER BU TIME" +
	"S NA2CUNEIFORM SIGN DA TIMES TAK4CUNEIFORM SIGN DAG TIMES KURCUNEIFORM S" +
	"IGN DIM TIMES IGICUNEIFORM SIGN DIM TIMES U U UCUNEIFORM SIGN DIM2 TIMES" +
	" UDCUNEIFORM SIGN DUG TIMES ANSHECUNEIFORM SIGN DUG TIMES ASHCUNEIFORM S" +
	"IGN DUG TIMES ASH AT LEFTCUNEIFORM SIGN DUG TIMES DINCUNEIFORM SIGN DUG " +
	"TIMES DUNCUNEIFORM SIGN DUG TIMES ERIN2CUNEIFORM SIGN DUG TIMES GACUNEIF" +
	"ORM SIGN DUG TIMES GICUNEIFORM SIGN DUG TIMES GIR2 GUNUCUNEIFORM SIGN DU" +
	"G TIMES GISHCUNEIFORM SIGN DUG TIMES HACUNEIFORM SIGN DUG TIMES HICUNEIF" +
	"ORM SIGN DUG TIMES IGI GUNUCUNEIFORM SIGN DUG TIMES KASKALCUNEIFORM SIGN" +
	" DUG TIMES KURCUNEIFORM SIGN DUG TIMES KUSHU2CUNEIFORM SIGN DUG TIMES KU" +
	"SHU2 PLUS KASKALCUNEIFORM SIGN DUG TIMES LAK-020CUNEIFORM SIGN DUG TIMES" +
	" LAMCUNEIFORM SIGN DUG TIMES LAM TIMES KURCUNEIFORM SIGN DUG TIMES LUH P" +
	"LUS GISHCUNEIFORM SIGN DUG TIMES MASHCUNEIFORM SIGN DUG TIMES MESCUNEIFO" +
	"RM SIGN DUG TIMES MICUNEIFORM SIGN DUG TIMES NICUNEIFORM SIGN DUG TIMES " +
	"PICUNEIFORM SIGN DUG TIMES SHECUNEIFORM SIGN DUG TIMES SI GUNUCUNEIFORM " +
	"SIGN E2 TIMES KURCUNEIFORM SIGN E2 TIMES PAPCUNEIFORM SIGN ERIN2 XCUNEIF" +
	"ORM SIGN ESH2 CROSSING ESH2CUNEIFORM SIGN EZEN SHESHIG TIMES ASHCUNEIFOR" +
	"M SIGN EZEN SHESHIG TIMES HICUNEIFORM SIGN EZEN SHESHIG TIMES IGI GUNUCU" +
	"NEIFORM SIGN EZEN SHESHIG TIMES LACUNEIFORM SIGN EZEN SHESHIG TIMES LALC" +
	"UNEIFORM SIGN EZEN SHESHIG TIMES MECUNEIFORM SIGN EZEN SHESHIG TIMES MES" +
	"CUNEIFORM SIGN EZEN SHESHIG TIMES SUCUNEIFORM SIGN EZEN TIMES SUCUNEIFOR" +
	"M SIGN GA2 TIMES BAHAR2CUNEIFORM SIGN GA2 TIMES DIM GUNUCUNEIFORM SIGN G" +
	"A2 TIMES DUG TIMES IGI GUNUCUNEIFORM SIGN GA2 TIMES DUG TIMES KASKALCUNE" +
	"IFORM SIGN GA2 TIMES ERENCUNEIFORM SIGN GA2 TIMES GACUNEIFORM SIGN GA2 T" +
	"IMES GAR PLUS DICUNEIFORM SIGN GA2 TIMES GAR PLUS NECUNEIFORM SIGN GA2 T" +
	"IMES HA PLUS ACUNEIFORM SIGN GA2 TIMES KUSHU2 PLUS KASKALCUNEIFORM SIGN " +
	"GA2 TIMES LAMCUNEIFORM SIGN GA2 TIMES LAM TIMES KURCUNEIFORM SIGN GA2 TI" +
	"MES LUHCUNEIFORM SIGN GA2 TIMES MUSHCUNEIFORM SIGN GA2 TIMES NECUNEIFORM" +
	" SIGN GA2 TIMES NE PLUS E2CUNEIFORM SIGN GA2 TIMES NE PLUS GICUNEIFORM S" +
	"IGN GA2 TIMES SHIMCUNEIFORM SIGN GA2 TIMES ZIZ2CUNEIFORM SIGN GABA ROTAT" +
	"ED NINETY DEGREESCUNEIFORM SIGN GESHTIN TIMES UCUNEIFORM SIGN GISH TIMES" +
	" GISH CROSSING GISHCUNEIFORM SIGN GU2 TIMES IGI GUNUCUNEIFORM SIGN GUD P" +
	"LUS GISH TIMES TAK4CUNEIFORM SIGN HA TENU GUNUCUNEIFORM SIGN HI TIMES AS" +
	"H OVER HI TIMES ASHCUNEIFORM SIGN KA TIMES BUCUNEIFORM SIGN KA TIMES KAC" +
	"UNEIFORM SIGN KA TIMES U U UCUNEIFORM SIGN KA TIMES URCUNEIFORM SIGN LAG" +
	"AB TIMES ZU OVER ZUCUNEIFORM SIGN LAK-003CUNEIFORM SIGN LAK-021CUNEIFORM" +
	" SIGN LAK-025CUNEIFORM SIGN LAK-030CUNEIFORM SIGN LAK-050CUNEIFORM SIGN " +
	"LAK-051CUNEIFORM SIGN LAK-062CUNEIFORM SIGN LAK-079 OVER LAK-079 GUNUCUN" +
	"EIFORM SIGN LAK-080CUNEIFORM SIGN LAK-081 OVER LAK-081CUNEIFORM SIGN LAK" +
	"-092CUNEIFORM SIGN LAK-130CUNEIFORM SIGN LAK-142CUNEIFORM SIGN LAK-210CU" +
	"NEIFORM SIGN LAK-219CUNEIFORM SIGN LAK-220CUNEIFORM SIGN LAK-225CUNEIFOR" +
	"M SIGN LAK-228CUNEIFORM SIGN LAK-238CUNEIFORM SIGN LAK-265CUNEIFORM SIGN" +
	" LAK-266CUNEIFORM SIGN LAK-343CUNEIFORM SIGN LAK-347CUNEIFORM SIGN LAK-3" +
	"48CUNEIFORM SIGN LAK-383CUNEIFORM SIGN LAK-384CUNEIFORM SIGN LAK-390CUNE" +
	"IFORM SIGN LAK-441CUNEIFORM SIGN LAK-449CUNEIFORM SIGN LAK-449 TIMES GUC" +
	"UNEIFORM SIGN LAK-449 TIMES IGICUNEIFORM SIGN LAK-449 TIMES PAP PLUS LU3" +
	"CUNEIFORM SIGN LAK-449 TIMES PAP PLUS PAP PLUS LU3CUNEIFORM SIGN LAK-449" +
	" TIMES U2 PLUS BACUNEIFORM SIGN LAK-450CUNEIFORM SIGN LAK-457CUNEIFORM S" +
	"IGN LAK-470CUNEIFORM SIGN LAK-483CUNEIFORM SIGN LAK-490CUNEIFORM SIGN LA" +
	"K-492CUNEIFORM SIGN LAK-493CUNEIFORM SIGN LAK-495CUNEIFORM SIGN LAK-550C" +
	"UNEIFORM SIGN LAK-608CUNEIFORM SIGN LAK-617CUNEIFORM SIGN LAK-617 TIMES " +
	"ASHCUNEIFORM SIGN LAK-617 TIMES BADCUNEIFORM SIGN LAK-617 TIMES DUN3 GUN" +
	"U GUNUCUNEIFORM SIGN LAK-617 TIMES KU3CUNEIFORM SIGN LAK-617 TIMES LACUN" +
	"EIFORM SIGN LAK-617 TIMES TARCUNEIFORM SIGN LAK-617 TIMES TECUNEIFORM SI" +
	"GN LAK-617 TIMES U2CUNEIFORM SIGN LAK-617 TIMES UDCUNEIFORM SIGN LAK-617" +
	" TIMES URUDACUNEIFORM SIGN LAK-636CUNEIFORM SIGN LAK-648CUNEIFORM SIGN L" +
	"AK-648 TIMES DUBCUNEIFORM SIGN LAK-648 TIMES GACUNEIFORM SIGN LAK-648 TI" +
	"MES IGICUNEIFORM SIGN LAK-648 TIMES IGI GUNUCUNEIFORM SIGN LAK-648 TIMES") + ("" +
	" NICUNEIFORM SIGN LAK-648 TIMES PAP PLUS PAP PLUS LU3CUNEIFORM SIGN LAK-" +
	"648 TIMES SHESH PLUS KICUNEIFORM SIGN LAK-648 TIMES UDCUNEIFORM SIGN LAK" +
	"-648 TIMES URUDACUNEIFORM SIGN LAK-724CUNEIFORM SIGN LAK-749CUNEIFORM SI" +
	"GN LU2 GUNU TIMES ASHCUNEIFORM SIGN LU2 TIMES DISHCUNEIFORM SIGN LU2 TIM" +
	"ES HALCUNEIFORM SIGN LU2 TIMES PAPCUNEIFORM SIGN LU2 TIMES PAP PLUS PAP " +
	"PLUS LU3CUNEIFORM SIGN LU2 TIMES TAK4CUNEIFORM SIGN MI PLUS ZA7CUNEIFORM" +
	" SIGN MUSH OVER MUSH TIMES GACUNEIFORM SIGN MUSH OVER MUSH TIMES KAKCUNE" +
	"IFORM SIGN NINDA2 TIMES DIM GUNUCUNEIFORM SIGN NINDA2 TIMES GISHCUNEIFOR" +
	"M SIGN NINDA2 TIMES GULCUNEIFORM SIGN NINDA2 TIMES HICUNEIFORM SIGN NIND" +
	"A2 TIMES KESH2CUNEIFORM SIGN NINDA2 TIMES LAK-050CUNEIFORM SIGN NINDA2 T" +
	"IMES MASHCUNEIFORM SIGN NINDA2 TIMES PAP PLUS PAPCUNEIFORM SIGN NINDA2 T" +
	"IMES UCUNEIFORM SIGN NINDA2 TIMES U PLUS UCUNEIFORM SIGN NINDA2 TIMES UR" +
	"UDACUNEIFORM SIGN SAG GUNU TIMES HACUNEIFORM SIGN SAG TIMES ENCUNEIFORM " +
	"SIGN SAG TIMES SHE AT LEFTCUNEIFORM SIGN SAG TIMES TAK4CUNEIFORM SIGN SH" +
	"A6 TENUCUNEIFORM SIGN SHE OVER SHECUNEIFORM SIGN SHE PLUS HUB2CUNEIFORM " +
	"SIGN SHE PLUS NAM2CUNEIFORM SIGN SHE PLUS SARCUNEIFORM SIGN SHU2 PLUS DU" +
	"G TIMES NICUNEIFORM SIGN SHU2 PLUS E2 TIMES ANCUNEIFORM SIGN SI TIMES TA" +
	"K4CUNEIFORM SIGN TAK4 PLUS SAGCUNEIFORM SIGN TUM TIMES GAN2 TENUCUNEIFOR" +
	"M SIGN TUM TIMES THREE DISHCUNEIFORM SIGN UR2 INVERTEDCUNEIFORM SIGN UR2" +
	" TIMES UDCUNEIFORM SIGN URU TIMES DARA3CUNEIFORM SIGN URU TIMES LAK-668C" +
	"UNEIFORM SIGN URU TIMES LU3CUNEIFORM SIGN ZA7CUNEIFORM SIGN ZU OVER ZU P" +
	"LUS SARCUNEIFORM SIGN ZU5 TIMES THREE DISH TENUEGYPTIAN HIEROGLYPH A001E" +
	"GYPTIAN HIEROGLYPH A002EGYPTIAN HIEROGLYPH A003EGYPTIAN HIEROGLYPH A004E" +
	"GYPTIAN HIEROGLYPH A005EGYPTIAN HIEROGLYPH A005AEGYPTIAN HIEROGLYPH A006" +
	"EGYPTIAN HIEROGLYPH A006AEGYPTIAN HIEROGLYPH A006BEGYPTIAN HIEROGLYPH A0" +
	"07EGYPTIAN HIEROGLYPH A008EGYPTIAN HIEROGLYPH A009EGYPTIAN HIEROGLYPH A0" +
	"10EGYPTIAN HIEROGLYPH A011EGYPTIAN HIEROGLYPH A012EGYPTIAN HIEROGLYPH A0" +
	"13EGYPTIAN HIEROGLYPH A014EGYPTIAN HIEROGLYPH A014AEGYPTIAN HIEROGLYPH A" +
	"015EGYPTIAN HIEROGLYPH A016EGYPTIAN HIEROGLYPH A017EGYPTIAN HIEROGLYPH A" +
	"017AEGYPTIAN HIEROGLYPH A018EGYPTIAN HIEROGLYPH A019EGYPTIAN HIEROGLYPH " +
	"A020EGYPTIAN HIEROGLYPH A021EGYPTIAN HIEROGLYPH A022EGYPTIAN HIEROGLYPH " +
	"A023EGYPTIAN HIEROGLYPH A024EGYPTIAN HIEROGLYPH A025EGYPTIAN HIEROGLYPH " +
	"A026EGYPTIAN HIEROGLYPH A027EGYPTIAN HIEROGLYPH A028EGYPTIAN HIEROGLYPH " +
	"A029EGYPTIAN HIEROGLYPH A030EGYPTIAN HIEROGLYPH A031EGYPTIAN HIEROGLYPH " +
	"A032EGYPTIAN HIEROGLYPH A032AEGYPTIAN HIEROGLYPH A033EGYPTIAN HIEROGLYPH" +
	" A034EGYPTIAN HIEROGLYPH A035EGYPTIAN HIEROGLYPH A036EGYPTIAN HIEROGLYPH" +
	" A037EGYPTIAN HIEROGLYPH A038EGYPTIAN HIEROGLYPH A039EGYPTIAN HIEROGLYPH" +
	" A040EGYPTIAN HIEROGLYPH A040AEGYPTIAN HIEROGLYPH A041EGYPTIAN HIEROGLYP" +
	"H A042EGYPTIAN HIEROGLYPH A042AEGYPTIAN HIEROGLYPH A043EGYPTIAN HIEROGLY" +
	"PH A043AEGYPTIAN HIEROGLYPH A044EGYPTIAN HIEROGLYPH A045EGYPTIAN HIEROGL" +
	"YPH A045AEGYPTIAN HIEROGLYPH A046EGYPTIAN HIEROGLYPH A047EGYPTIAN HIEROG" +
	"LYPH A048EGYPTIAN HIEROGLYPH A049EGYPTIAN HIEROGLYPH A050EGYPTIAN HIEROG" +
	"LYPH A051EGYPTIAN HIEROGLYPH A052EGYPTIAN HIEROGLYPH A053EGYPTIAN HIEROG" +
	"LYPH A054EGYPTIAN HIEROGLYPH A055EGYPTIAN HIEROGLYPH A056EGYPTIAN HIEROG" +
	"LYPH A057EGYPTIAN HIEROGLYPH A058EGYPTIAN HIEROGLYPH A059EGYPTIAN HIEROG" +
	"LYPH A060EGYPTIAN HIEROGLYPH A061EGYPTIAN HIEROGLYPH A062EGYPTIAN HIEROG" +
	"LYPH A063EGYPTIAN HIEROGLYPH A064EGYPTIAN HIEROGLYPH A065EGYPTIAN HIEROG" +
	"LYPH A066EGYPTIAN HIEROGLYPH A067EGYPTIAN HIEROGLYPH A068EGYPTIAN HIEROG" +
	"LYPH A069EGYPTIAN HIEROGLYPH A070EGYPTIAN HIEROGLYPH B001EGYPTIAN HIEROG" +
	"LYPH B002EGYPTIAN HIEROGLYPH B003EGYPTIAN HIEROGLYPH B004EGYPTIAN HIEROG" +
	"LYPH B005EGYPTIAN HIEROGLYPH B005AEGYPTIAN HIEROGLYPH B006EGYPTIAN HIERO" +
	"GLYPH B007EGYPTIAN HIEROGLYPH B008EGYPTIAN HIEROGLYPH B009EGYPTIAN HIERO" +
	"GLYPH C001EGYPTIAN HIEROGLYPH C002EGYPTIAN HIEROGLYPH C002AEGYPTIAN HIER" +
	"OGLYPH C002BEGYPTIAN HIEROGLYPH C002CEGYPTIAN HIEROGLYPH C003EGYPTIAN HI" +
	"EROGLYPH C004EGYPTIAN HIEROGLYPH C005EGYPTIAN HIEROGLYPH C006EGYPTIAN HI" +
	"EROGLYPH C007EGYPTIAN HIEROGLYPH C008EGYPTIAN HIEROGLYPH C009EGYPTIAN HI" +
	"EROGLYPH C010EGYPTIAN HIEROGLYPH C010AEGYPTIAN HIEROGLYPH C011EGYPTIAN H" +
	"IEROGLYPH C012EGYPTIAN HIEROGLYPH C013EGYPTIAN HIEROGLYPH C014EGYPTIAN H" +
	"IEROGLYPH C015EGYPTIAN HIEROGLYPH C016EGYPTIAN HIEROGLYPH C017EGYPTIAN H" +
	"IEROGLYPH C018EGYPTIAN HIEROGLYPH C019EGYPTIAN HIEROGLYPH C020EGYPTIAN H" +
	"IEROGLYPH C021EGYPTIAN HIEROGLYPH C022EGYPTIAN HIEROGLYPH C023EGYPTIAN H" +
	"IEROGLYPH C024EGYPTIAN HIEROGLYPH D001EGYPTIAN HIEROGLYPH D002EGYPTIAN H" +
	"IEROGLYPH D003EGYPTIAN HIEROGLYPH D004EGYPTIAN HIEROGLYPH D005EGYPTIAN H" +
	"IEROGLYPH D006EGYPTIAN HIEROGLYPH D007EGYPTIAN HIEROGLYPH D008EGYPTIAN H") + ("" +
	"IEROGLYPH D008AEGYPTIAN HIEROGLYPH D009EGYPTIAN HIEROGLYPH D010EGYPTIAN " +
	"HIEROGLYPH D011EGYPTIAN HIEROGLYPH D012EGYPTIAN HIEROGLYPH D013EGYPTIAN " +
	"HIEROGLYPH D014EGYPTIAN HIEROGLYPH D015EGYPTIAN HIEROGLYPH D016EGYPTIAN " +
	"HIEROGLYPH D017EGYPTIAN HIEROGLYPH D018EGYPTIAN HIEROGLYPH D019EGYPTIAN " +
	"HIEROGLYPH D020EGYPTIAN HIEROGLYPH D021EGYPTIAN HIEROGLYPH D022EGYPTIAN " +
	"HIEROGLYPH D023EGYPTIAN HIEROGLYPH D024EGYPTIAN HIEROGLYPH D025EGYPTIAN " +
	"HIEROGLYPH D026EGYPTIAN HIEROGLYPH D027EGYPTIAN HIEROGLYPH D027AEGYPTIAN" +
	" HIEROGLYPH D028EGYPTIAN HIEROGLYPH D029EGYPTIAN HIEROGLYPH D030EGYPTIAN" +
	" HIEROGLYPH D031EGYPTIAN HIEROGLYPH D031AEGYPTIAN HIEROGLYPH D032EGYPTIA" +
	"N HIEROGLYPH D033EGYPTIAN HIEROGLYPH D034EGYPTIAN HIEROGLYPH D034AEGYPTI" +
	"AN HIEROGLYPH D035EGYPTIAN HIEROGLYPH D036EGYPTIAN HIEROGLYPH D037EGYPTI" +
	"AN HIEROGLYPH D038EGYPTIAN HIEROGLYPH D039EGYPTIAN HIEROGLYPH D040EGYPTI" +
	"AN HIEROGLYPH D041EGYPTIAN HIEROGLYPH D042EGYPTIAN HIEROGLYPH D043EGYPTI" +
	"AN HIEROGLYPH D044EGYPTIAN HIEROGLYPH D045EGYPTIAN HIEROGLYPH D046EGYPTI" +
	"AN HIEROGLYPH D046AEGYPTIAN HIEROGLYPH D047EGYPTIAN HIEROGLYPH D048EGYPT" +
	"IAN HIEROGLYPH D048AEGYPTIAN HIEROGLYPH D049EGYPTIAN HIEROGLYPH D050EGYP" +
	"TIAN HIEROGLYPH D050AEGYPTIAN HIEROGLYPH D050BEGYPTIAN HIEROGLYPH D050CE" +
	"GYPTIAN HIEROGLYPH D050DEGYPTIAN HIEROGLYPH D050EEGYPTIAN HIEROGLYPH D05" +
	"0FEGYPTIAN HIEROGLYPH D050GEGYPTIAN HIEROGLYPH D050HEGYPTIAN HIEROGLYPH " +
	"D050IEGYPTIAN HIEROGLYPH D051EGYPTIAN HIEROGLYPH D052EGYPTIAN HIEROGLYPH" +
	" D052AEGYPTIAN HIEROGLYPH D053EGYPTIAN HIEROGLYPH D054EGYPTIAN HIEROGLYP" +
	"H D054AEGYPTIAN HIEROGLYPH D055EGYPTIAN HIEROGLYPH D056EGYPTIAN HIEROGLY" +
	"PH D057EGYPTIAN HIEROGLYPH D058EGYPTIAN HIEROGLYPH D059EGYPTIAN HIEROGLY" +
	"PH D060EGYPTIAN HIEROGLYPH D061EGYPTIAN HIEROGLYPH D062EGYPTIAN HIEROGLY" +
	"PH D063EGYPTIAN HIEROGLYPH D064EGYPTIAN HIEROGLYPH D065EGYPTIAN HIEROGLY" +
	"PH D066EGYPTIAN HIEROGLYPH D067EGYPTIAN HIEROGLYPH D067AEGYPTIAN HIEROGL" +
	"YPH D067BEGYPTIAN HIEROGLYPH D067CEGYPTIAN HIEROGLYPH D067DEGYPTIAN HIER" +
	"OGLYPH D067EEGYPTIAN HIEROGLYPH D067FEGYPTIAN HIEROGLYPH D067GEGYPTIAN H" +
	"IEROGLYPH D067HEGYPTIAN HIEROGLYPH E001EGYPTIAN HIEROGLYPH E002EGYPTIAN " +
	"HIEROGLYPH E003EGYPTIAN HIEROGLYPH E004EGYPTIAN HIEROGLYPH E005EGYPTIAN " +
	"HIEROGLYPH E006EGYPTIAN HIEROGLYPH E007EGYPTIAN HIEROGLYPH E008EGYPTIAN " +
	"HIEROGLYPH E008AEGYPTIAN HIEROGLYPH E009EGYPTIAN HIEROGLYPH E009AEGYPTIA" +
	"N HIEROGLYPH E010EGYPTIAN HIEROGLYPH E011EGYPTIAN HIEROGLYPH E012EGYPTIA" +
	"N HIEROGLYPH E013EGYPTIAN HIEROGLYPH E014EGYPTIAN HIEROGLYPH E015EGYPTIA" +
	"N HIEROGLYPH E016EGYPTIAN HIEROGLYPH E016AEGYPTIAN HIEROGLYPH E017EGYPTI" +
	"AN HIEROGLYPH E017AEGYPTIAN HIEROGLYPH E018EGYPTIAN HIEROGLYPH E019EGYPT" +
	"IAN HIEROGLYPH E020EGYPTIAN HIEROGLYPH E020AEGYPTIAN HIEROGLYPH E021EGYP" +
	"TIAN HIEROGLYPH E022EGYPTIAN HIEROGLYPH E023EGYPTIAN HIEROGLYPH E024EGYP" +
	"TIAN HIEROGLYPH E025EGYPTIAN HIEROGLYPH E026EGYPTIAN HIEROGLYPH E027EGYP" +
	"TIAN HIEROGLYPH E028EGYPTIAN HIEROGLYPH E028AEGYPTIAN HIEROGLYPH E029EGY" +
	"PTIAN HIEROGLYPH E030EGYPTIAN HIEROGLYPH E031EGYPTIAN HIEROGLYPH E032EGY" +
	"PTIAN HIEROGLYPH E033EGYPTIAN HIEROGLYPH E034EGYPTIAN HIEROGLYPH E034AEG" +
	"YPTIAN HIEROGLYPH E036EGYPTIAN HIEROGLYPH E037EGYPTIAN HIEROGLYPH E038EG" +
	"YPTIAN HIEROGLYPH F001EGYPTIAN HIEROGLYPH F001AEGYPTIAN HIEROGLYPH F002E" +
	"GYPTIAN HIEROGLYPH F003EGYPTIAN HIEROGLYPH F004EGYPTIAN HIEROGLYPH F005E" +
	"GYPTIAN HIEROGLYPH F006EGYPTIAN HIEROGLYPH F007EGYPTIAN HIEROGLYPH F008E" +
	"GYPTIAN HIEROGLYPH F009EGYPTIAN HIEROGLYPH F010EGYPTIAN HIEROGLYPH F011E" +
	"GYPTIAN HIEROGLYPH F012EGYPTIAN HIEROGLYPH F013EGYPTIAN HIEROGLYPH F013A" +
	"EGYPTIAN HIEROGLYPH F014EGYPTIAN HIEROGLYPH F015EGYPTIAN HIEROGLYPH F016" +
	"EGYPTIAN HIEROGLYPH F017EGYPTIAN HIEROGLYPH F018EGYPTIAN HIEROGLYPH F019" +
	"EGYPTIAN HIEROGLYPH F020EGYPTIAN HIEROGLYPH F021EGYPTIAN HIEROGLYPH F021" +
	"AEGYPTIAN HIEROGLYPH F022EGYPTIAN HIEROGLYPH F023EGYPTIAN HIEROGLYPH F02" +
	"4EGYPTIAN HIEROGLYPH F025EGYPTIAN HIEROGLYPH F026EGYPTIAN HIEROGLYPH F02" +
	"7EGYPTIAN HIEROGLYPH F028EGYPTIAN HIEROGLYPH F029EGYPTIAN HIEROGLYPH F03" +
	"0EGYPTIAN HIEROGLYPH F031EGYPTIAN HIEROGLYPH F031AEGYPTIAN HIEROGLYPH F0" +
	"32EGYPTIAN HIEROGLYPH F033EGYPTIAN HIEROGLYPH F034EGYPTIAN HIEROGLYPH F0" +
	"35EGYPTIAN HIEROGLYPH F036EGYPTIAN HIEROGLYPH F037EGYPTIAN HIEROGLYPH F0" +
	"37AEGYPTIAN HIEROGLYPH F038EGYPTIAN HIEROGLYPH F038AEGYPTIAN HIEROGLYPH " +
	"F039EGYPTIAN HIEROGLYPH F040EGYPTIAN HIEROGLYPH F041EGYPTIAN HIEROGLYPH " +
	"F042EGYPTIAN HIEROGLYPH F043EGYPTIAN HIEROGLYPH F044EGYPTIAN HIEROGLYPH " +
	"F045EGYPTIAN HIEROGLYPH F045AEGYPTIAN HIEROGLYPH F046EGYPTIAN HIEROGLYPH" +
	" F046AEGYPTIAN HIEROGLYPH F047EGYPTIAN HIEROGLYPH F047AEGYPTIAN HIEROGLY" +
	"PH F048EGYPTIAN HIEROGLYPH F049EGYPTIAN HIEROGLYPH F050EGYPTIAN HIEROGLY" +
	"PH F051EGYPTIAN HIEROGLYPH F051AEGYPTIAN HIEROGLYPH F051BEGYPTIAN HIEROG") + ("" +
	"LYPH F051CEGYPTIAN HIEROGLYPH F052EGYPTIAN HIEROGLYPH F053EGYPTIAN HIERO" +
	"GLYPH G001EGYPTIAN HIEROGLYPH G002EGYPTIAN HIEROGLYPH G003EGYPTIAN HIERO" +
	"GLYPH G004EGYPTIAN HIEROGLYPH G005EGYPTIAN HIEROGLYPH G006EGYPTIAN HIERO" +
	"GLYPH G006AEGYPTIAN HIEROGLYPH G007EGYPTIAN HIEROGLYPH G007AEGYPTIAN HIE" +
	"ROGLYPH G007BEGYPTIAN HIEROGLYPH G008EGYPTIAN HIEROGLYPH G009EGYPTIAN HI" +
	"EROGLYPH G010EGYPTIAN HIEROGLYPH G011EGYPTIAN HIEROGLYPH G011AEGYPTIAN H" +
	"IEROGLYPH G012EGYPTIAN HIEROGLYPH G013EGYPTIAN HIEROGLYPH G014EGYPTIAN H" +
	"IEROGLYPH G015EGYPTIAN HIEROGLYPH G016EGYPTIAN HIEROGLYPH G017EGYPTIAN H" +
	"IEROGLYPH G018EGYPTIAN HIEROGLYPH G019EGYPTIAN HIEROGLYPH G020EGYPTIAN H" +
	"IEROGLYPH G020AEGYPTIAN HIEROGLYPH G021EGYPTIAN HIEROGLYPH G022EGYPTIAN " +
	"HIEROGLYPH G023EGYPTIAN HIEROGLYPH G024EGYPTIAN HIEROGLYPH G025EGYPTIAN " +
	"HIEROGLYPH G026EGYPTIAN HIEROGLYPH G026AEGYPTIAN HIEROGLYPH G027EGYPTIAN" +
	" HIEROGLYPH G028EGYPTIAN HIEROGLYPH G029EGYPTIAN HIEROGLYPH G030EGYPTIAN" +
	" HIEROGLYPH G031EGYPTIAN HIEROGLYPH G032EGYPTIAN HIEROGLYPH G033EGYPTIAN" +
	" HIEROGLYPH G034EGYPTIAN HIEROGLYPH G035EGYPTIAN HIEROGLYPH G036EGYPTIAN" +
	" HIEROGLYPH G036AEGYPTIAN HIEROGLYPH G037EGYPTIAN HIEROGLYPH G037AEGYPTI" +
	"AN HIEROGLYPH G038EGYPTIAN HIEROGLYPH G039EGYPTIAN HIEROGLYPH G040EGYPTI" +
	"AN HIEROGLYPH G041EGYPTIAN HIEROGLYPH G042EGYPTIAN HIEROGLYPH G043EGYPTI" +
	"AN HIEROGLYPH G043AEGYPTIAN HIEROGLYPH G044EGYPTIAN HIEROGLYPH G045EGYPT" +
	"IAN HIEROGLYPH G045AEGYPTIAN HIEROGLYPH G046EGYPTIAN HIEROGLYPH G047EGYP" +
	"TIAN HIEROGLYPH G048EGYPTIAN HIEROGLYPH G049EGYPTIAN HIEROGLYPH G050EGYP" +
	"TIAN HIEROGLYPH G051EGYPTIAN HIEROGLYPH G052EGYPTIAN HIEROGLYPH G053EGYP" +
	"TIAN HIEROGLYPH G054EGYPTIAN HIEROGLYPH H001EGYPTIAN HIEROGLYPH H002EGYP" +
	"TIAN HIEROGLYPH H003EGYPTIAN HIEROGLYPH H004EGYPTIAN HIEROGLYPH H005EGYP" +
	"TIAN HIEROGLYPH H006EGYPTIAN HIEROGLYPH H006AEGYPTIAN HIEROGLYPH H007EGY" +
	"PTIAN HIEROGLYPH H008EGYPTIAN HIEROGLYPH I001EGYPTIAN HIEROGLYPH I002EGY" +
	"PTIAN HIEROGLYPH I003EGYPTIAN HIEROGLYPH I004EGYPTIAN HIEROGLYPH I005EGY" +
	"PTIAN HIEROGLYPH I005AEGYPTIAN HIEROGLYPH I006EGYPTIAN HIEROGLYPH I007EG" +
	"YPTIAN HIEROGLYPH I008EGYPTIAN HIEROGLYPH I009EGYPTIAN HIEROGLYPH I009AE" +
	"GYPTIAN HIEROGLYPH I010EGYPTIAN HIEROGLYPH I010AEGYPTIAN HIEROGLYPH I011" +
	"EGYPTIAN HIEROGLYPH I011AEGYPTIAN HIEROGLYPH I012EGYPTIAN HIEROGLYPH I01" +
	"3EGYPTIAN HIEROGLYPH I014EGYPTIAN HIEROGLYPH I015EGYPTIAN HIEROGLYPH K00" +
	"1EGYPTIAN HIEROGLYPH K002EGYPTIAN HIEROGLYPH K003EGYPTIAN HIEROGLYPH K00" +
	"4EGYPTIAN HIEROGLYPH K005EGYPTIAN HIEROGLYPH K006EGYPTIAN HIEROGLYPH K00" +
	"7EGYPTIAN HIEROGLYPH K008EGYPTIAN HIEROGLYPH L001EGYPTIAN HIEROGLYPH L00" +
	"2EGYPTIAN HIEROGLYPH L002AEGYPTIAN HIEROGLYPH L003EGYPTIAN HIEROGLYPH L0" +
	"04EGYPTIAN HIEROGLYPH L005EGYPTIAN HIEROGLYPH L006EGYPTIAN HIEROGLYPH L0" +
	"06AEGYPTIAN HIEROGLYPH L007EGYPTIAN HIEROGLYPH L008EGYPTIAN HIEROGLYPH M" +
	"001EGYPTIAN HIEROGLYPH M001AEGYPTIAN HIEROGLYPH M001BEGYPTIAN HIEROGLYPH" +
	" M002EGYPTIAN HIEROGLYPH M003EGYPTIAN HIEROGLYPH M003AEGYPTIAN HIEROGLYP" +
	"H M004EGYPTIAN HIEROGLYPH M005EGYPTIAN HIEROGLYPH M006EGYPTIAN HIEROGLYP" +
	"H M007EGYPTIAN HIEROGLYPH M008EGYPTIAN HIEROGLYPH M009EGYPTIAN HIEROGLYP" +
	"H M010EGYPTIAN HIEROGLYPH M010AEGYPTIAN HIEROGLYPH M011EGYPTIAN HIEROGLY" +
	"PH M012EGYPTIAN HIEROGLYPH M012AEGYPTIAN HIEROGLYPH M012BEGYPTIAN HIEROG" +
	"LYPH M012CEGYPTIAN HIEROGLYPH M012DEGYPTIAN HIEROGLYPH M012EEGYPTIAN HIE" +
	"ROGLYPH M012FEGYPTIAN HIEROGLYPH M012GEGYPTIAN HIEROGLYPH M012HEGYPTIAN " +
	"HIEROGLYPH M013EGYPTIAN HIEROGLYPH M014EGYPTIAN HIEROGLYPH M015EGYPTIAN " +
	"HIEROGLYPH M015AEGYPTIAN HIEROGLYPH M016EGYPTIAN HIEROGLYPH M016AEGYPTIA" +
	"N HIEROGLYPH M017EGYPTIAN HIEROGLYPH M017AEGYPTIAN HIEROGLYPH M018EGYPTI" +
	"AN HIEROGLYPH M019EGYPTIAN HIEROGLYPH M020EGYPTIAN HIEROGLYPH M021EGYPTI" +
	"AN HIEROGLYPH M022EGYPTIAN HIEROGLYPH M022AEGYPTIAN HIEROGLYPH M023EGYPT" +
	"IAN HIEROGLYPH M024EGYPTIAN HIEROGLYPH M024AEGYPTIAN HIEROGLYPH M025EGYP" +
	"TIAN HIEROGLYPH M026EGYPTIAN HIEROGLYPH M027EGYPTIAN HIEROGLYPH M028EGYP" +
	"TIAN HIEROGLYPH M028AEGYPTIAN HIEROGLYPH M029EGYPTIAN HIEROGLYPH M030EGY" +
	"PTIAN HIEROGLYPH M031EGYPTIAN HIEROGLYPH M031AEGYPTIAN HIEROGLYPH M032EG" +
	"YPTIAN HIEROGLYPH M033EGYPTIAN HIEROGLYPH M033AEGYPTIAN HIEROGLYPH M033B" +
	"EGYPTIAN HIEROGLYPH M034EGYPTIAN HIEROGLYPH M035EGYPTIAN HIEROGLYPH M036" +
	"EGYPTIAN HIEROGLYPH M037EGYPTIAN HIEROGLYPH M038EGYPTIAN HIEROGLYPH M039" +
	"EGYPTIAN HIEROGLYPH M040EGYPTIAN HIEROGLYPH M040AEGYPTIAN HIEROGLYPH M04" +
	"1EGYPTIAN HIEROGLYPH M042EGYPTIAN HIEROGLYPH M043EGYPTIAN HIEROGLYPH M04" +
	"4EGYPTIAN HIEROGLYPH N001EGYPTIAN HIEROGLYPH N002EGYPTIAN HIEROGLYPH N00" +
	"3EGYPTIAN HIEROGLYPH N004EGYPTIAN HIEROGLYPH N005EGYPTIAN HIEROGLYPH N00" +
	"6EGYPTIAN HIEROGLYPH N007EGYPTIAN HIEROGLYPH N008EGYPTIAN HIEROGLYPH N00" +
	"9EGYPTIAN HIEROGLYPH N010EGYPTIAN HIEROGLYPH N011EGYPTIAN HIEROGLYPH N01") + ("" +
	"2EGYPTIAN HIEROGLYPH N013EGYPTIAN HIEROGLYPH N014EGYPTIAN HIEROGLYPH N01" +
	"5EGYPTIAN HIEROGLYPH N016EGYPTIAN HIEROGLYPH N017EGYPTIAN HIEROGLYPH N01" +
	"8EGYPTIAN HIEROGLYPH N018AEGYPTIAN HIEROGLYPH N018BEGYPTIAN HIEROGLYPH N" +
	"019EGYPTIAN HIEROGLYPH N020EGYPTIAN HIEROGLYPH N021EGYPTIAN HIEROGLYPH N" +
	"022EGYPTIAN HIEROGLYPH N023EGYPTIAN HIEROGLYPH N024EGYPTIAN HIEROGLYPH N" +
	"025EGYPTIAN HIEROGLYPH N025AEGYPTIAN HIEROGLYPH N026EGYPTIAN HIEROGLYPH " +
	"N027EGYPTIAN HIEROGLYPH N028EGYPTIAN HIEROGLYPH N029EGYPTIAN HIEROGLYPH " +
	"N030EGYPTIAN HIEROGLYPH N031EGYPTIAN HIEROGLYPH N032EGYPTIAN HIEROGLYPH " +
	"N033EGYPTIAN HIEROGLYPH N033AEGYPTIAN HIEROGLYPH N034EGYPTIAN HIEROGLYPH" +
	" N034AEGYPTIAN HIEROGLYPH N035EGYPTIAN HIEROGLYPH N035AEGYPTIAN HIEROGLY" +
	"PH N036EGYPTIAN HIEROGLYPH N037EGYPTIAN HIEROGLYPH N037AEGYPTIAN HIEROGL" +
	"YPH N038EGYPTIAN HIEROGLYPH N039EGYPTIAN HIEROGLYPH N040EGYPTIAN HIEROGL" +
	"YPH N041EGYPTIAN HIEROGLYPH N042EGYPTIAN HIEROGLYPH NL001EGYPTIAN HIEROG" +
	"LYPH NL002EGYPTIAN HIEROGLYPH NL003EGYPTIAN HIEROGLYPH NL004EGYPTIAN HIE" +
	"ROGLYPH NL005EGYPTIAN HIEROGLYPH NL005AEGYPTIAN HIEROGLYPH NL006EGYPTIAN" +
	" HIEROGLYPH NL007EGYPTIAN HIEROGLYPH NL008EGYPTIAN HIEROGLYPH NL009EGYPT" +
	"IAN HIEROGLYPH NL010EGYPTIAN HIEROGLYPH NL011EGYPTIAN HIEROGLYPH NL012EG" +
	"YPTIAN HIEROGLYPH NL013EGYPTIAN HIEROGLYPH NL014EGYPTIAN HIEROGLYPH NL01" +
	"5EGYPTIAN HIEROGLYPH NL016EGYPTIAN HIEROGLYPH NL017EGYPTIAN HIEROGLYPH N" +
	"L017AEGYPTIAN HIEROGLYPH NL018EGYPTIAN HIEROGLYPH NL019EGYPTIAN HIEROGLY" +
	"PH NL020EGYPTIAN HIEROGLYPH NU001EGYPTIAN HIEROGLYPH NU002EGYPTIAN HIERO" +
	"GLYPH NU003EGYPTIAN HIEROGLYPH NU004EGYPTIAN HIEROGLYPH NU005EGYPTIAN HI" +
	"EROGLYPH NU006EGYPTIAN HIEROGLYPH NU007EGYPTIAN HIEROGLYPH NU008EGYPTIAN" +
	" HIEROGLYPH NU009EGYPTIAN HIEROGLYPH NU010EGYPTIAN HIEROGLYPH NU010AEGYP" +
	"TIAN HIEROGLYPH NU011EGYPTIAN HIEROGLYPH NU011AEGYPTIAN HIEROGLYPH NU012" +
	"EGYPTIAN HIEROGLYPH NU013EGYPTIAN HIEROGLYPH NU014EGYPTIAN HIEROGLYPH NU" +
	"015EGYPTIAN HIEROGLYPH NU016EGYPTIAN HIEROGLYPH NU017EGYPTIAN HIEROGLYPH" +
	" NU018EGYPTIAN HIEROGLYPH NU018AEGYPTIAN HIEROGLYPH NU019EGYPTIAN HIEROG" +
	"LYPH NU020EGYPTIAN HIEROGLYPH NU021EGYPTIAN HIEROGLYPH NU022EGYPTIAN HIE" +
	"ROGLYPH NU022AEGYPTIAN HIEROGLYPH O001EGYPTIAN HIEROGLYPH O001AEGYPTIAN " +
	"HIEROGLYPH O002EGYPTIAN HIEROGLYPH O003EGYPTIAN HIEROGLYPH O004EGYPTIAN " +
	"HIEROGLYPH O005EGYPTIAN HIEROGLYPH O005AEGYPTIAN HIEROGLYPH O006EGYPTIAN" +
	" HIEROGLYPH O006AEGYPTIAN HIEROGLYPH O006BEGYPTIAN HIEROGLYPH O006CEGYPT" +
	"IAN HIEROGLYPH O006DEGYPTIAN HIEROGLYPH O006EEGYPTIAN HIEROGLYPH O006FEG" +
	"YPTIAN HIEROGLYPH O007EGYPTIAN HIEROGLYPH O008EGYPTIAN HIEROGLYPH O009EG" +
	"YPTIAN HIEROGLYPH O010EGYPTIAN HIEROGLYPH O010AEGYPTIAN HIEROGLYPH O010B" +
	"EGYPTIAN HIEROGLYPH O010CEGYPTIAN HIEROGLYPH O011EGYPTIAN HIEROGLYPH O01" +
	"2EGYPTIAN HIEROGLYPH O013EGYPTIAN HIEROGLYPH O014EGYPTIAN HIEROGLYPH O01" +
	"5EGYPTIAN HIEROGLYPH O016EGYPTIAN HIEROGLYPH O017EGYPTIAN HIEROGLYPH O01" +
	"8EGYPTIAN HIEROGLYPH O019EGYPTIAN HIEROGLYPH O019AEGYPTIAN HIEROGLYPH O0" +
	"20EGYPTIAN HIEROGLYPH O020AEGYPTIAN HIEROGLYPH O021EGYPTIAN HIEROGLYPH O" +
	"022EGYPTIAN HIEROGLYPH O023EGYPTIAN HIEROGLYPH O024EGYPTIAN HIEROGLYPH O" +
	"024AEGYPTIAN HIEROGLYPH O025EGYPTIAN HIEROGLYPH O025AEGYPTIAN HIEROGLYPH" +
	" O026EGYPTIAN HIEROGLYPH O027EGYPTIAN HIEROGLYPH O028EGYPTIAN HIEROGLYPH" +
	" O029EGYPTIAN HIEROGLYPH O029AEGYPTIAN HIEROGLYPH O030EGYPTIAN HIEROGLYP" +
	"H O030AEGYPTIAN HIEROGLYPH O031EGYPTIAN HIEROGLYPH O032EGYPTIAN HIEROGLY" +
	"PH O033EGYPTIAN HIEROGLYPH O033AEGYPTIAN HIEROGLYPH O034EGYPTIAN HIEROGL" +
	"YPH O035EGYPTIAN HIEROGLYPH O036EGYPTIAN HIEROGLYPH O036AEGYPTIAN HIEROG" +
	"LYPH O036BEGYPTIAN HIEROGLYPH O036CEGYPTIAN HIEROGLYPH O036DEGYPTIAN HIE" +
	"ROGLYPH O037EGYPTIAN HIEROGLYPH O038EGYPTIAN HIEROGLYPH O039EGYPTIAN HIE" +
	"ROGLYPH O040EGYPTIAN HIEROGLYPH O041EGYPTIAN HIEROGLYPH O042EGYPTIAN HIE" +
	"ROGLYPH O043EGYPTIAN HIEROGLYPH O044EGYPTIAN HIEROGLYPH O045EGYPTIAN HIE" +
	"ROGLYPH O046EGYPTIAN HIEROGLYPH O047EGYPTIAN HIEROGLYPH O048EGYPTIAN HIE" +
	"ROGLYPH O049EGYPTIAN HIEROGLYPH O050EGYPTIAN HIEROGLYPH O050AEGYPTIAN HI" +
	"EROGLYPH O050BEGYPTIAN HIEROGLYPH O051EGYPTIAN HIEROGLYPH P001EGYPTIAN H" +
	"IEROGLYPH P001AEGYPTIAN HIEROGLYPH P002EGYPTIAN HIEROGLYPH P003EGYPTIAN " +
	"HIEROGLYPH P003AEGYPTIAN HIEROGLYPH P004EGYPTIAN HIEROGLYPH P005EGYPTIAN" +
	" HIEROGLYPH P006EGYPTIAN HIEROGLYPH P007EGYPTIAN HIEROGLYPH P008EGYPTIAN" +
	" HIEROGLYPH P009EGYPTIAN HIEROGLYPH P010EGYPTIAN HIEROGLYPH P011EGYPTIAN" +
	" HIEROGLYPH Q001EGYPTIAN HIEROGLYPH Q002EGYPTIAN HIEROGLYPH Q003EGYPTIAN" +
	" HIEROGLYPH Q004EGYPTIAN HIEROGLYPH Q005EGYPTIAN HIEROGLYPH Q006EGYPTIAN" +
	" HIEROGLYPH Q007EGYPTIAN HIEROGLYPH R001EGYPTIAN HIEROGLYPH R002EGYPTIAN" +
	" HIEROGLYPH R002AEGYPTIAN HIEROGLYPH R003EGYPTIAN HIEROGLYPH R003AEGYPTI" +
	"AN HIEROGLYPH R003BEGYPTIAN HIEROGLYPH R004EGYPTIAN HIEROGLYPH R005EGYPT") + ("" +
	"IAN HIEROGLYPH R006EGYPTIAN HIEROGLYPH R007EGYPTIAN HIEROGLYPH R008EGYPT" +
	"IAN HIEROGLYPH R009EGYPTIAN HIEROGLYPH R010EGYPTIAN HIEROGLYPH R010AEGYP" +
	"TIAN HIEROGLYPH R011EGYPTIAN HIEROGLYPH R012EGYPTIAN HIEROGLYPH R013EGYP" +
	"TIAN HIEROGLYPH R014EGYPTIAN HIEROGLYPH R015EGYPTIAN HIEROGLYPH R016EGYP" +
	"TIAN HIEROGLYPH R016AEGYPTIAN HIEROGLYPH R017EGYPTIAN HIEROGLYPH R018EGY" +
	"PTIAN HIEROGLYPH R019EGYPTIAN HIEROGLYPH R020EGYPTIAN HIEROGLYPH R021EGY" +
	"PTIAN HIEROGLYPH R022EGYPTIAN HIEROGLYPH R023EGYPTIAN HIEROGLYPH R024EGY" +
	"PTIAN HIEROGLYPH R025EGYPTIAN HIEROGLYPH R026EGYPTIAN HIEROGLYPH R027EGY" +
	"PTIAN HIEROGLYPH R028EGYPTIAN HIEROGLYPH R029EGYPTIAN HIEROGLYPH S001EGY" +
	"PTIAN HIEROGLYPH S002EGYPTIAN HIEROGLYPH S002AEGYPTIAN HIEROGLYPH S003EG" +
	"YPTIAN HIEROGLYPH S004EGYPTIAN HIEROGLYPH S005EGYPTIAN HIEROGLYPH S006EG" +
	"YPTIAN HIEROGLYPH S006AEGYPTIAN HIEROGLYPH S007EGYPTIAN HIEROGLYPH S008E" +
	"GYPTIAN HIEROGLYPH S009EGYPTIAN HIEROGLYPH S010EGYPTIAN HIEROGLYPH S011E" +
	"GYPTIAN HIEROGLYPH S012EGYPTIAN HIEROGLYPH S013EGYPTIAN HIEROGLYPH S014E" +
	"GYPTIAN HIEROGLYPH S014AEGYPTIAN HIEROGLYPH S014BEGYPTIAN HIEROGLYPH S01" +
	"5EGYPTIAN HIEROGLYPH S016EGYPTIAN HIEROGLYPH S017EGYPTIAN HIEROGLYPH S01" +
	"7AEGYPTIAN HIEROGLYPH S018EGYPTIAN HIEROGLYPH S019EGYPTIAN HIEROGLYPH S0" +
	"20EGYPTIAN HIEROGLYPH S021EGYPTIAN HIEROGLYPH S022EGYPTIAN HIEROGLYPH S0" +
	"23EGYPTIAN HIEROGLYPH S024EGYPTIAN HIEROGLYPH S025EGYPTIAN HIEROGLYPH S0" +
	"26EGYPTIAN HIEROGLYPH S026AEGYPTIAN HIEROGLYPH S026BEGYPTIAN HIEROGLYPH " +
	"S027EGYPTIAN HIEROGLYPH S028EGYPTIAN HIEROGLYPH S029EGYPTIAN HIEROGLYPH " +
	"S030EGYPTIAN HIEROGLYPH S031EGYPTIAN HIEROGLYPH S032EGYPTIAN HIEROGLYPH " +
	"S033EGYPTIAN HIEROGLYPH S034EGYPTIAN HIEROGLYPH S035EGYPTIAN HIEROGLYPH " +
	"S035AEGYPTIAN HIEROGLYPH S036EGYPTIAN HIEROGLYPH S037EGYPTIAN HIEROGLYPH" +
	" S038EGYPTIAN HIEROGLYPH S039EGYPTIAN HIEROGLYPH S040EGYPTIAN HIEROGLYPH" +
	" S041EGYPTIAN HIEROGLYPH S042EGYPTIAN HIEROGLYPH S043EGYPTIAN HIEROGLYPH" +
	" S044EGYPTIAN HIEROGLYPH S045EGYPTIAN HIEROGLYPH S046EGYPTIAN HIEROGLYPH" +
	" T001EGYPTIAN HIEROGLYPH T002EGYPTIAN HIEROGLYPH T003EGYPTIAN HIEROGLYPH" +
	" T003AEGYPTIAN HIEROGLYPH T004EGYPTIAN HIEROGLYPH T005EGYPTIAN HIEROGLYP" +
	"H T006EGYPTIAN HIEROGLYPH T007EGYPTIAN HIEROGLYPH T007AEGYPTIAN HIEROGLY" +
	"PH T008EGYPTIAN HIEROGLYPH T008AEGYPTIAN HIEROGLYPH T009EGYPTIAN HIEROGL" +
	"YPH T009AEGYPTIAN HIEROGLYPH T010EGYPTIAN HIEROGLYPH T011EGYPTIAN HIEROG" +
	"LYPH T011AEGYPTIAN HIEROGLYPH T012EGYPTIAN HIEROGLYPH T013EGYPTIAN HIERO" +
	"GLYPH T014EGYPTIAN HIEROGLYPH T015EGYPTIAN HIEROGLYPH T016EGYPTIAN HIERO" +
	"GLYPH T016AEGYPTIAN HIEROGLYPH T017EGYPTIAN HIEROGLYPH T018EGYPTIAN HIER" +
	"OGLYPH T019EGYPTIAN HIEROGLYPH T020EGYPTIAN HIEROGLYPH T021EGYPTIAN HIER" +
	"OGLYPH T022EGYPTIAN HIEROGLYPH T023EGYPTIAN HIEROGLYPH T024EGYPTIAN HIER" +
	"OGLYPH T025EGYPTIAN HIEROGLYPH T026EGYPTIAN HIEROGLYPH T027EGYPTIAN HIER" +
	"OGLYPH T028EGYPTIAN HIEROGLYPH T029EGYPTIAN HIEROGLYPH T030EGYPTIAN HIER" +
	"OGLYPH T031EGYPTIAN HIEROGLYPH T032EGYPTIAN HIEROGLYPH T032AEGYPTIAN HIE" +
	"ROGLYPH T033EGYPTIAN HIEROGLYPH T033AEGYPTIAN HIEROGLYPH T034EGYPTIAN HI" +
	"EROGLYPH T035EGYPTIAN HIEROGLYPH T036EGYPTIAN HIEROGLYPH U001EGYPTIAN HI" +
	"EROGLYPH U002EGYPTIAN HIEROGLYPH U003EGYPTIAN HIEROGLYPH U004EGYPTIAN HI" +
	"EROGLYPH U005EGYPTIAN HIEROGLYPH U006EGYPTIAN HIEROGLYPH U006AEGYPTIAN H" +
	"IEROGLYPH U006BEGYPTIAN HIEROGLYPH U007EGYPTIAN HIEROGLYPH U008EGYPTIAN " +
	"HIEROGLYPH U009EGYPTIAN HIEROGLYPH U010EGYPTIAN HIEROGLYPH U011EGYPTIAN " +
	"HIEROGLYPH U012EGYPTIAN HIEROGLYPH U013EGYPTIAN HIEROGLYPH U014EGYPTIAN " +
	"HIEROGLYPH U015EGYPTIAN HIEROGLYPH U016EGYPTIAN HIEROGLYPH U017EGYPTIAN " +
	"HIEROGLYPH U018EGYPTIAN HIEROGLYPH U019EGYPTIAN HIEROGLYPH U020EGYPTIAN " +
	"HIEROGLYPH U021EGYPTIAN HIEROGLYPH U022EGYPTIAN HIEROGLYPH U023EGYPTIAN " +
	"HIEROGLYPH U023AEGYPTIAN HIEROGLYPH U024EGYPTIAN HIEROGLYPH U025EGYPTIAN" +
	" HIEROGLYPH U026EGYPTIAN HIEROGLYPH U027EGYPTIAN HIEROGLYPH U028EGYPTIAN" +
	" HIEROGLYPH U029EGYPTIAN HIEROGLYPH U029AEGYPTIAN HIEROGLYPH U030EGYPTIA" +
	"N HIEROGLYPH U031EGYPTIAN HIEROGLYPH U032EGYPTIAN HIEROGLYPH U032AEGYPTI" +
	"AN HIEROGLYPH U033EGYPTIAN HIEROGLYPH U034EGYPTIAN HIEROGLYPH U035EGYPTI" +
	"AN HIEROGLYPH U036EGYPTIAN HIEROGLYPH U037EGYPTIAN HIEROGLYPH U038EGYPTI" +
	"AN HIEROGLYPH U039EGYPTIAN HIEROGLYPH U040EGYPTIAN HIEROGLYPH U041EGYPTI" +
	"AN HIEROGLYPH U042EGYPTIAN HIEROGLYPH V001EGYPTIAN HIEROGLYPH V001AEGYPT" +
	"IAN HIEROGLYPH V001BEGYPTIAN HIEROGLYPH V001CEGYPTIAN HIEROGLYPH V001DEG" +
	"YPTIAN HIEROGLYPH V001EEGYPTIAN HIEROGLYPH V001FEGYPTIAN HIEROGLYPH V001" +
	"GEGYPTIAN HIEROGLYPH V001HEGYPTIAN HIEROGLYPH V001IEGYPTIAN HIEROGLYPH V" +
	"002EGYPTIAN HIEROGLYPH V002AEGYPTIAN HIEROGLYPH V003EGYPTIAN HIEROGLYPH " +
	"V004EGYPTIAN HIEROGLYPH V005EGYPTIAN HIEROGLYPH V006EGYPTIAN HIEROGLYPH " +
	"V007EGYPTIAN HIEROGLYPH V007AEGYPTIAN HIEROGLYPH V007BEGYPTIAN HIEROGLYP") + ("" +
	"H V008EGYPTIAN HIEROGLYPH V009EGYPTIAN HIEROGLYPH V010EGYPTIAN HIEROGLYP" +
	"H V011EGYPTIAN HIEROGLYPH V011AEGYPTIAN HIEROGLYPH V011BEGYPTIAN HIEROGL" +
	"YPH V011CEGYPTIAN HIEROGLYPH V012EGYPTIAN HIEROGLYPH V012AEGYPTIAN HIERO" +
	"GLYPH V012BEGYPTIAN HIEROGLYPH V013EGYPTIAN HIEROGLYPH V014EGYPTIAN HIER" +
	"OGLYPH V015EGYPTIAN HIEROGLYPH V016EGYPTIAN HIEROGLYPH V017EGYPTIAN HIER" +
	"OGLYPH V018EGYPTIAN HIEROGLYPH V019EGYPTIAN HIEROGLYPH V020EGYPTIAN HIER" +
	"OGLYPH V020AEGYPTIAN HIEROGLYPH V020BEGYPTIAN HIEROGLYPH V020CEGYPTIAN H" +
	"IEROGLYPH V020DEGYPTIAN HIEROGLYPH V020EEGYPTIAN HIEROGLYPH V020FEGYPTIA" +
	"N HIEROGLYPH V020GEGYPTIAN HIEROGLYPH V020HEGYPTIAN HIEROGLYPH V020IEGYP" +
	"TIAN HIEROGLYPH V020JEGYPTIAN HIEROGLYPH V020KEGYPTIAN HIEROGLYPH V020LE" +
	"GYPTIAN HIEROGLYPH V021EGYPTIAN HIEROGLYPH V022EGYPTIAN HIEROGLYPH V023E" +
	"GYPTIAN HIEROGLYPH V023AEGYPTIAN HIEROGLYPH V024EGYPTIAN HIEROGLYPH V025" +
	"EGYPTIAN HIEROGLYPH V026EGYPTIAN HIEROGLYPH V027EGYPTIAN HIEROGLYPH V028" +
	"EGYPTIAN HIEROGLYPH V028AEGYPTIAN HIEROGLYPH V029EGYPTIAN HIEROGLYPH V02" +
	"9AEGYPTIAN HIEROGLYPH V030EGYPTIAN HIEROGLYPH V030AEGYPTIAN HIEROGLYPH V" +
	"031EGYPTIAN HIEROGLYPH V031AEGYPTIAN HIEROGLYPH V032EGYPTIAN HIEROGLYPH " +
	"V033EGYPTIAN HIEROGLYPH V033AEGYPTIAN HIEROGLYPH V034EGYPTIAN HIEROGLYPH" +
	" V035EGYPTIAN HIEROGLYPH V036EGYPTIAN HIEROGLYPH V037EGYPTIAN HIEROGLYPH" +
	" V037AEGYPTIAN HIEROGLYPH V038EGYPTIAN HIEROGLYPH V039EGYPTIAN HIEROGLYP" +
	"H V040EGYPTIAN HIEROGLYPH V040AEGYPTIAN HIEROGLYPH W001EGYPTIAN HIEROGLY" +
	"PH W002EGYPTIAN HIEROGLYPH W003EGYPTIAN HIEROGLYPH W003AEGYPTIAN HIEROGL" +
	"YPH W004EGYPTIAN HIEROGLYPH W005EGYPTIAN HIEROGLYPH W006EGYPTIAN HIEROGL" +
	"YPH W007EGYPTIAN HIEROGLYPH W008EGYPTIAN HIEROGLYPH W009EGYPTIAN HIEROGL" +
	"YPH W009AEGYPTIAN HIEROGLYPH W010EGYPTIAN HIEROGLYPH W010AEGYPTIAN HIERO" +
	"GLYPH W011EGYPTIAN HIEROGLYPH W012EGYPTIAN HIEROGLYPH W013EGYPTIAN HIERO" +
	"GLYPH W014EGYPTIAN HIEROGLYPH W014AEGYPTIAN HIEROGLYPH W015EGYPTIAN HIER" +
	"OGLYPH W016EGYPTIAN HIEROGLYPH W017EGYPTIAN HIEROGLYPH W017AEGYPTIAN HIE" +
	"ROGLYPH W018EGYPTIAN HIEROGLYPH W018AEGYPTIAN HIEROGLYPH W019EGYPTIAN HI" +
	"EROGLYPH W020EGYPTIAN HIEROGLYPH W021EGYPTIAN HIEROGLYPH W022EGYPTIAN HI" +
	"EROGLYPH W023EGYPTIAN HIEROGLYPH W024EGYPTIAN HIEROGLYPH W024AEGYPTIAN H" +
	"IEROGLYPH W025EGYPTIAN HIEROGLYPH X001EGYPTIAN HIEROGLYPH X002EGYPTIAN H" +
	"IEROGLYPH X003EGYPTIAN HIEROGLYPH X004EGYPTIAN HIEROGLYPH X004AEGYPTIAN " +
	"HIEROGLYPH X004BEGYPTIAN HIEROGLYPH X005EGYPTIAN HIEROGLYPH X006EGYPTIAN" +
	" HIEROGLYPH X006AEGYPTIAN HIEROGLYPH X007EGYPTIAN HIEROGLYPH X008EGYPTIA" +
	"N HIEROGLYPH X008AEGYPTIAN HIEROGLYPH Y001EGYPTIAN HIEROGLYPH Y001AEGYPT" +
	"IAN HIEROGLYPH Y002EGYPTIAN HIEROGLYPH Y003EGYPTIAN HIEROGLYPH Y004EGYPT" +
	"IAN HIEROGLYPH Y005EGYPTIAN HIEROGLYPH Y006EGYPTIAN HIEROGLYPH Y007EGYPT" +
	"IAN HIEROGLYPH Y008EGYPTIAN HIEROGLYPH Z001EGYPTIAN HIEROGLYPH Z002EGYPT" +
	"IAN HIEROGLYPH Z002AEGYPTIAN HIEROGLYPH Z002BEGYPTIAN HIEROGLYPH Z002CEG" +
	"YPTIAN HIEROGLYPH Z002DEGYPTIAN HIEROGLYPH Z003EGYPTIAN HIEROGLYPH Z003A" +
	"EGYPTIAN HIEROGLYPH Z003BEGYPTIAN HIEROGLYPH Z004EGYPTIAN HIEROGLYPH Z00" +
	"4AEGYPTIAN HIEROGLYPH Z005EGYPTIAN HIEROGLYPH Z005AEGYPTIAN HIEROGLYPH Z" +
	"006EGYPTIAN HIEROGLYPH Z007EGYPTIAN HIEROGLYPH Z008EGYPTIAN HIEROGLYPH Z" +
	"009EGYPTIAN HIEROGLYPH Z010EGYPTIAN HIEROGLYPH Z011EGYPTIAN HIEROGLYPH Z" +
	"012EGYPTIAN HIEROGLYPH Z013EGYPTIAN HIEROGLYPH Z014EGYPTIAN HIEROGLYPH Z" +
	"015EGYPTIAN HIEROGLYPH Z015AEGYPTIAN HIEROGLYPH Z015BEGYPTIAN HIEROGLYPH" +
	" Z015CEGYPTIAN HIEROGLYPH Z015DEGYPTIAN HIEROGLYPH Z015EEGYPTIAN HIEROGL" +
	"YPH Z015FEGYPTIAN HIEROGLYPH Z015GEGYPTIAN HIEROGLYPH Z015HEGYPTIAN HIER" +
	"OGLYPH Z015IEGYPTIAN HIEROGLYPH Z016EGYPTIAN HIEROGLYPH Z016AEGYPTIAN HI" +
	"EROGLYPH Z016BEGYPTIAN HIEROGLYPH Z016CEGYPTIAN HIEROGLYPH Z016DEGYPTIAN" +
	" HIEROGLYPH Z016EEGYPTIAN HIEROGLYPH Z016FEGYPTIAN HIEROGLYPH Z016GEGYPT" +
	"IAN HIEROGLYPH Z016HEGYPTIAN HIEROGLYPH AA001EGYPTIAN HIEROGLYPH AA002EG" +
	"YPTIAN HIEROGLYPH AA003EGYPTIAN HIEROGLYPH AA004EGYPTIAN HIEROGLYPH AA00" +
	"5EGYPTIAN HIEROGLYPH AA006EGYPTIAN HIEROGLYPH AA007EGYPTIAN HIEROGLYPH A" +
	"A007AEGYPTIAN HIEROGLYPH AA007BEGYPTIAN HIEROGLYPH AA008EGYPTIAN HIEROGL" +
	"YPH AA009EGYPTIAN HIEROGLYPH AA010EGYPTIAN HIEROGLYPH AA011EGYPTIAN HIER" +
	"OGLYPH AA012EGYPTIAN HIEROGLYPH AA013EGYPTIAN HIEROGLYPH AA014EGYPTIAN H" +
	"IEROGLYPH AA015EGYPTIAN HIEROGLYPH AA016EGYPTIAN HIEROGLYPH AA017EGYPTIA" +
	"N HIEROGLYPH AA018EGYPTIAN HIEROGLYPH AA019EGYPTIAN HIEROGLYPH AA020EGYP" +
	"TIAN HIEROGLYPH AA021EGYPTIAN HIEROGLYPH AA022EGYPTIAN HIEROGLYPH AA023E" +
	"GYPTIAN HIEROGLYPH AA024EGYPTIAN HIEROGLYPH AA025EGYPTIAN HIEROGLYPH AA0" +
	"26EGYPTIAN HIEROGLYPH AA027EGYPTIAN HIEROGLYPH AA028EGYPTIAN HIEROGLYPH " +
	"AA029EGYPTIAN HIEROGLYPH AA030EGYPTIAN HIEROGLYPH AA031EGYPTIAN HIEROGLY" +
	"PH AA032ANATOLIAN HIEROGLYPH A001ANATOLIAN HIEROGLYPH A002ANATOLIAN HIER") + ("" +
	"OGLYPH A003ANATOLIAN HIEROGLYPH A004ANATOLIAN HIEROGLYPH A005ANATOLIAN H" +
	"IEROGLYPH A006ANATOLIAN HIEROGLYPH A007ANATOLIAN HIEROGLYPH A008ANATOLIA" +
	"N HIEROGLYPH A009ANATOLIAN HIEROGLYPH A010ANATOLIAN HIEROGLYPH A010AANAT" +
	"OLIAN HIEROGLYPH A011ANATOLIAN HIEROGLYPH A012ANATOLIAN HIEROGLYPH A013A" +
	"NATOLIAN HIEROGLYPH A014ANATOLIAN HIEROGLYPH A015ANATOLIAN HIEROGLYPH A0" +
	"16ANATOLIAN HIEROGLYPH A017ANATOLIAN HIEROGLYPH A018ANATOLIAN HIEROGLYPH" +
	" A019ANATOLIAN HIEROGLYPH A020ANATOLIAN HIEROGLYPH A021ANATOLIAN HIEROGL" +
	"YPH A022ANATOLIAN HIEROGLYPH A023ANATOLIAN HIEROGLYPH A024ANATOLIAN HIER" +
	"OGLYPH A025ANATOLIAN HIEROGLYPH A026ANATOLIAN HIEROGLYPH A026AANATOLIAN " +
	"HIEROGLYPH A027ANATOLIAN HIEROGLYPH A028ANATOLIAN HIEROGLYPH A029ANATOLI" +
	"AN HIEROGLYPH A030ANATOLIAN HIEROGLYPH A031ANATOLIAN HIEROGLYPH A032ANAT" +
	"OLIAN HIEROGLYPH A033ANATOLIAN HIEROGLYPH A034ANATOLIAN HIEROGLYPH A035A" +
	"NATOLIAN HIEROGLYPH A036ANATOLIAN HIEROGLYPH A037ANATOLIAN HIEROGLYPH A0" +
	"38ANATOLIAN HIEROGLYPH A039ANATOLIAN HIEROGLYPH A039AANATOLIAN HIEROGLYP" +
	"H A040ANATOLIAN HIEROGLYPH A041ANATOLIAN HIEROGLYPH A041AANATOLIAN HIERO" +
	"GLYPH A042ANATOLIAN HIEROGLYPH A043ANATOLIAN HIEROGLYPH A044ANATOLIAN HI" +
	"EROGLYPH A045ANATOLIAN HIEROGLYPH A045AANATOLIAN HIEROGLYPH A046ANATOLIA" +
	"N HIEROGLYPH A046AANATOLIAN HIEROGLYPH A046BANATOLIAN HIEROGLYPH A047ANA" +
	"TOLIAN HIEROGLYPH A048ANATOLIAN HIEROGLYPH A049ANATOLIAN HIEROGLYPH A050" +
	"ANATOLIAN HIEROGLYPH A051ANATOLIAN HIEROGLYPH A052ANATOLIAN HIEROGLYPH A" +
	"053ANATOLIAN HIEROGLYPH A054ANATOLIAN HIEROGLYPH A055ANATOLIAN HIEROGLYP" +
	"H A056ANATOLIAN HIEROGLYPH A057ANATOLIAN HIEROGLYPH A058ANATOLIAN HIEROG" +
	"LYPH A059ANATOLIAN HIEROGLYPH A060ANATOLIAN HIEROGLYPH A061ANATOLIAN HIE" +
	"ROGLYPH A062ANATOLIAN HIEROGLYPH A063ANATOLIAN HIEROGLYPH A064ANATOLIAN " +
	"HIEROGLYPH A065ANATOLIAN HIEROGLYPH A066ANATOLIAN HIEROGLYPH A066AANATOL" +
	"IAN HIEROGLYPH A066BANATOLIAN HIEROGLYPH A066CANATOLIAN HIEROGLYPH A067A" +
	"NATOLIAN HIEROGLYPH A068ANATOLIAN HIEROGLYPH A069ANATOLIAN HIEROGLYPH A0" +
	"70ANATOLIAN HIEROGLYPH A071ANATOLIAN HIEROGLYPH A072ANATOLIAN HIEROGLYPH" +
	" A073ANATOLIAN HIEROGLYPH A074ANATOLIAN HIEROGLYPH A075ANATOLIAN HIEROGL" +
	"YPH A076ANATOLIAN HIEROGLYPH A077ANATOLIAN HIEROGLYPH A078ANATOLIAN HIER" +
	"OGLYPH A079ANATOLIAN HIEROGLYPH A080ANATOLIAN HIEROGLYPH A081ANATOLIAN H" +
	"IEROGLYPH A082ANATOLIAN HIEROGLYPH A083ANATOLIAN HIEROGLYPH A084ANATOLIA" +
	"N HIEROGLYPH A085ANATOLIAN HIEROGLYPH A086ANATOLIAN HIEROGLYPH A087ANATO" +
	"LIAN HIEROGLYPH A088ANATOLIAN HIEROGLYPH A089ANATOLIAN HIEROGLYPH A090AN" +
	"ATOLIAN HIEROGLYPH A091ANATOLIAN HIEROGLYPH A092ANATOLIAN HIEROGLYPH A09" +
	"3ANATOLIAN HIEROGLYPH A094ANATOLIAN HIEROGLYPH A095ANATOLIAN HIEROGLYPH " +
	"A096ANATOLIAN HIEROGLYPH A097ANATOLIAN HIEROGLYPH A097AANATOLIAN HIEROGL" +
	"YPH A098ANATOLIAN HIEROGLYPH A098AANATOLIAN HIEROGLYPH A099ANATOLIAN HIE" +
	"ROGLYPH A100ANATOLIAN HIEROGLYPH A100AANATOLIAN HIEROGLYPH A101ANATOLIAN" +
	" HIEROGLYPH A101AANATOLIAN HIEROGLYPH A102ANATOLIAN HIEROGLYPH A102AANAT" +
	"OLIAN HIEROGLYPH A103ANATOLIAN HIEROGLYPH A104ANATOLIAN HIEROGLYPH A104A" +
	"ANATOLIAN HIEROGLYPH A104BANATOLIAN HIEROGLYPH A104CANATOLIAN HIEROGLYPH" +
	" A105ANATOLIAN HIEROGLYPH A105AANATOLIAN HIEROGLYPH A105BANATOLIAN HIERO" +
	"GLYPH A106ANATOLIAN HIEROGLYPH A107ANATOLIAN HIEROGLYPH A107AANATOLIAN H" +
	"IEROGLYPH A107BANATOLIAN HIEROGLYPH A107CANATOLIAN HIEROGLYPH A108ANATOL" +
	"IAN HIEROGLYPH A109ANATOLIAN HIEROGLYPH A110ANATOLIAN HIEROGLYPH A110AAN" +
	"ATOLIAN HIEROGLYPH A110BANATOLIAN HIEROGLYPH A111ANATOLIAN HIEROGLYPH A1" +
	"12ANATOLIAN HIEROGLYPH A113ANATOLIAN HIEROGLYPH A114ANATOLIAN HIEROGLYPH" +
	" A115ANATOLIAN HIEROGLYPH A115AANATOLIAN HIEROGLYPH A116ANATOLIAN HIEROG" +
	"LYPH A117ANATOLIAN HIEROGLYPH A118ANATOLIAN HIEROGLYPH A119ANATOLIAN HIE" +
	"ROGLYPH A120ANATOLIAN HIEROGLYPH A121ANATOLIAN HIEROGLYPH A122ANATOLIAN " +
	"HIEROGLYPH A123ANATOLIAN HIEROGLYPH A124ANATOLIAN HIEROGLYPH A125ANATOLI" +
	"AN HIEROGLYPH A125AANATOLIAN HIEROGLYPH A126ANATOLIAN HIEROGLYPH A127ANA" +
	"TOLIAN HIEROGLYPH A128ANATOLIAN HIEROGLYPH A129ANATOLIAN HIEROGLYPH A130" +
	"ANATOLIAN HIEROGLYPH A131ANATOLIAN HIEROGLYPH A132ANATOLIAN HIEROGLYPH A" +
	"133ANATOLIAN HIEROGLYPH A134ANATOLIAN HIEROGLYPH A135ANATOLIAN HIEROGLYP" +
	"H A135AANATOLIAN HIEROGLYPH A136ANATOLIAN HIEROGLYPH A137ANATOLIAN HIERO" +
	"GLYPH A138ANATOLIAN HIEROGLYPH A139ANATOLIAN HIEROGLYPH A140ANATOLIAN HI" +
	"EROGLYPH A141ANATOLIAN HIEROGLYPH A142ANATOLIAN HIEROGLYPH A143ANATOLIAN" +
	" HIEROGLYPH A144ANATOLIAN HIEROGLYPH A145ANATOLIAN HIEROGLYPH A146ANATOL" +
	"IAN HIEROGLYPH A147ANATOLIAN HIEROGLYPH A148ANATOLIAN HIEROGLYPH A149ANA" +
	"TOLIAN HIEROGLYPH A150ANATOLIAN HIEROGLYPH A151ANATOLIAN HIEROGLYPH A152" +
	"ANATOLIAN HIEROGLYPH A153ANATOLIAN HIEROGLYPH A154ANATOLIAN HIEROGLYPH A" +
	"155ANATOLIAN HIEROGLYPH A156ANATOLIAN HIEROGLYPH A157ANATOLIAN HIEROGLYP") + ("" +
	"H A158ANATOLIAN HIEROGLYPH A159ANATOLIAN HIEROGLYPH A160ANATOLIAN HIEROG" +
	"LYPH A161ANATOLIAN HIEROGLYPH A162ANATOLIAN HIEROGLYPH A163ANATOLIAN HIE" +
	"ROGLYPH A164ANATOLIAN HIEROGLYPH A165ANATOLIAN HIEROGLYPH A166ANATOLIAN " +
	"HIEROGLYPH A167ANATOLIAN HIEROGLYPH A168ANATOLIAN HIEROGLYPH A169ANATOLI" +
	"AN HIEROGLYPH A170ANATOLIAN HIEROGLYPH A171ANATOLIAN HIEROGLYPH A172ANAT" +
	"OLIAN HIEROGLYPH A173ANATOLIAN HIEROGLYPH A174ANATOLIAN HIEROGLYPH A175A" +
	"NATOLIAN HIEROGLYPH A176ANATOLIAN HIEROGLYPH A177ANATOLIAN HIEROGLYPH A1" +
	"78ANATOLIAN HIEROGLYPH A179ANATOLIAN HIEROGLYPH A180ANATOLIAN HIEROGLYPH" +
	" A181ANATOLIAN HIEROGLYPH A182ANATOLIAN HIEROGLYPH A183ANATOLIAN HIEROGL" +
	"YPH A184ANATOLIAN HIEROGLYPH A185ANATOLIAN HIEROGLYPH A186ANATOLIAN HIER" +
	"OGLYPH A187ANATOLIAN HIEROGLYPH A188ANATOLIAN HIEROGLYPH A189ANATOLIAN H" +
	"IEROGLYPH A190ANATOLIAN HIEROGLYPH A191ANATOLIAN HIEROGLYPH A192ANATOLIA" +
	"N HIEROGLYPH A193ANATOLIAN HIEROGLYPH A194ANATOLIAN HIEROGLYPH A195ANATO" +
	"LIAN HIEROGLYPH A196ANATOLIAN HIEROGLYPH A197ANATOLIAN HIEROGLYPH A198AN" +
	"ATOLIAN HIEROGLYPH A199ANATOLIAN HIEROGLYPH A200ANATOLIAN HIEROGLYPH A20" +
	"1ANATOLIAN HIEROGLYPH A202ANATOLIAN HIEROGLYPH A202AANATOLIAN HIEROGLYPH" +
	" A202BANATOLIAN HIEROGLYPH A203ANATOLIAN HIEROGLYPH A204ANATOLIAN HIEROG" +
	"LYPH A205ANATOLIAN HIEROGLYPH A206ANATOLIAN HIEROGLYPH A207ANATOLIAN HIE" +
	"ROGLYPH A207AANATOLIAN HIEROGLYPH A208ANATOLIAN HIEROGLYPH A209ANATOLIAN" +
	" HIEROGLYPH A209AANATOLIAN HIEROGLYPH A210ANATOLIAN HIEROGLYPH A211ANATO" +
	"LIAN HIEROGLYPH A212ANATOLIAN HIEROGLYPH A213ANATOLIAN HIEROGLYPH A214AN" +
	"ATOLIAN HIEROGLYPH A215ANATOLIAN HIEROGLYPH A215AANATOLIAN HIEROGLYPH A2" +
	"16ANATOLIAN HIEROGLYPH A216AANATOLIAN HIEROGLYPH A217ANATOLIAN HIEROGLYP" +
	"H A218ANATOLIAN HIEROGLYPH A219ANATOLIAN HIEROGLYPH A220ANATOLIAN HIEROG" +
	"LYPH A221ANATOLIAN HIEROGLYPH A222ANATOLIAN HIEROGLYPH A223ANATOLIAN HIE" +
	"ROGLYPH A224ANATOLIAN HIEROGLYPH A225ANATOLIAN HIEROGLYPH A226ANATOLIAN " +
	"HIEROGLYPH A227ANATOLIAN HIEROGLYPH A227AANATOLIAN HIEROGLYPH A228ANATOL" +
	"IAN HIEROGLYPH A229ANATOLIAN HIEROGLYPH A230ANATOLIAN HIEROGLYPH A231ANA" +
	"TOLIAN HIEROGLYPH A232ANATOLIAN HIEROGLYPH A233ANATOLIAN HIEROGLYPH A234" +
	"ANATOLIAN HIEROGLYPH A235ANATOLIAN HIEROGLYPH A236ANATOLIAN HIEROGLYPH A" +
	"237ANATOLIAN HIEROGLYPH A238ANATOLIAN HIEROGLYPH A239ANATOLIAN HIEROGLYP" +
	"H A240ANATOLIAN HIEROGLYPH A241ANATOLIAN HIEROGLYPH A242ANATOLIAN HIEROG" +
	"LYPH A243ANATOLIAN HIEROGLYPH A244ANATOLIAN HIEROGLYPH A245ANATOLIAN HIE" +
	"ROGLYPH A246ANATOLIAN HIEROGLYPH A247ANATOLIAN HIEROGLYPH A248ANATOLIAN " +
	"HIEROGLYPH A249ANATOLIAN HIEROGLYPH A250ANATOLIAN HIEROGLYPH A251ANATOLI" +
	"AN HIEROGLYPH A252ANATOLIAN HIEROGLYPH A253ANATOLIAN HIEROGLYPH A254ANAT" +
	"OLIAN HIEROGLYPH A255ANATOLIAN HIEROGLYPH A256ANATOLIAN HIEROGLYPH A257A" +
	"NATOLIAN HIEROGLYPH A258ANATOLIAN HIEROGLYPH A259ANATOLIAN HIEROGLYPH A2" +
	"60ANATOLIAN HIEROGLYPH A261ANATOLIAN HIEROGLYPH A262ANATOLIAN HIEROGLYPH" +
	" A263ANATOLIAN HIEROGLYPH A264ANATOLIAN HIEROGLYPH A265ANATOLIAN HIEROGL" +
	"YPH A266ANATOLIAN HIEROGLYPH A267ANATOLIAN HIEROGLYPH A267AANATOLIAN HIE" +
	"ROGLYPH A268ANATOLIAN HIEROGLYPH A269ANATOLIAN HIEROGLYPH A270ANATOLIAN " +
	"HIEROGLYPH A271ANATOLIAN HIEROGLYPH A272ANATOLIAN HIEROGLYPH A273ANATOLI" +
	"AN HIEROGLYPH A274ANATOLIAN HIEROGLYPH A275ANATOLIAN HIEROGLYPH A276ANAT" +
	"OLIAN HIEROGLYPH A277ANATOLIAN HIEROGLYPH A278ANATOLIAN HIEROGLYPH A279A" +
	"NATOLIAN HIEROGLYPH A280ANATOLIAN HIEROGLYPH A281ANATOLIAN HIEROGLYPH A2" +
	"82ANATOLIAN HIEROGLYPH A283ANATOLIAN HIEROGLYPH A284ANATOLIAN HIEROGLYPH" +
	" A285ANATOLIAN HIEROGLYPH A286ANATOLIAN HIEROGLYPH A287ANATOLIAN HIEROGL" +
	"YPH A288ANATOLIAN HIEROGLYPH A289ANATOLIAN HIEROGLYPH A289AANATOLIAN HIE" +
	"ROGLYPH A290ANATOLIAN HIEROGLYPH A291ANATOLIAN HIEROGLYPH A292ANATOLIAN " +
	"HIEROGLYPH A293ANATOLIAN HIEROGLYPH A294ANATOLIAN HIEROGLYPH A294AANATOL" +
	"IAN HIEROGLYPH A295ANATOLIAN HIEROGLYPH A296ANATOLIAN HIEROGLYPH A297ANA" +
	"TOLIAN HIEROGLYPH A298ANATOLIAN HIEROGLYPH A299ANATOLIAN HIEROGLYPH A299" +
	"AANATOLIAN HIEROGLYPH A300ANATOLIAN HIEROGLYPH A301ANATOLIAN HIEROGLYPH " +
	"A302ANATOLIAN HIEROGLYPH A303ANATOLIAN HIEROGLYPH A304ANATOLIAN HIEROGLY" +
	"PH A305ANATOLIAN HIEROGLYPH A306ANATOLIAN HIEROGLYPH A307ANATOLIAN HIERO" +
	"GLYPH A308ANATOLIAN HIEROGLYPH A309ANATOLIAN HIEROGLYPH A309AANATOLIAN H" +
	"IEROGLYPH A310ANATOLIAN HIEROGLYPH A311ANATOLIAN HIEROGLYPH A312ANATOLIA" +
	"N HIEROGLYPH A313ANATOLIAN HIEROGLYPH A314ANATOLIAN HIEROGLYPH A315ANATO" +
	"LIAN HIEROGLYPH A316ANATOLIAN HIEROGLYPH A317ANATOLIAN HIEROGLYPH A318AN" +
	"ATOLIAN HIEROGLYPH A319ANATOLIAN HIEROGLYPH A320ANATOLIAN HIEROGLYPH A32" +
	"1ANATOLIAN HIEROGLYPH A322ANATOLIAN HIEROGLYPH A323ANATOLIAN HIEROGLYPH " +
	"A324ANATOLIAN HIEROGLYPH A325ANATOLIAN HIEROGLYPH A326ANATOLIAN HIEROGLY" +
	"PH A327ANATOLIAN HIEROGLYPH A328ANATOLIAN HIEROGLYPH A329ANATOLIAN HIERO") + ("" +
	"GLYPH A329AANATOLIAN HIEROGLYPH A330ANATOLIAN HIEROGLYPH A331ANATOLIAN H" +
	"IEROGLYPH A332AANATOLIAN HIEROGLYPH A332BANATOLIAN HIEROGLYPH A332CANATO" +
	"LIAN HIEROGLYPH A333ANATOLIAN HIEROGLYPH A334ANATOLIAN HIEROGLYPH A335AN" +
	"ATOLIAN HIEROGLYPH A336ANATOLIAN HIEROGLYPH A336AANATOLIAN HIEROGLYPH A3" +
	"36BANATOLIAN HIEROGLYPH A336CANATOLIAN HIEROGLYPH A337ANATOLIAN HIEROGLY" +
	"PH A338ANATOLIAN HIEROGLYPH A339ANATOLIAN HIEROGLYPH A340ANATOLIAN HIERO" +
	"GLYPH A341ANATOLIAN HIEROGLYPH A342ANATOLIAN HIEROGLYPH A343ANATOLIAN HI" +
	"EROGLYPH A344ANATOLIAN HIEROGLYPH A345ANATOLIAN HIEROGLYPH A346ANATOLIAN" +
	" HIEROGLYPH A347ANATOLIAN HIEROGLYPH A348ANATOLIAN HIEROGLYPH A349ANATOL" +
	"IAN HIEROGLYPH A350ANATOLIAN HIEROGLYPH A351ANATOLIAN HIEROGLYPH A352ANA" +
	"TOLIAN HIEROGLYPH A353ANATOLIAN HIEROGLYPH A354ANATOLIAN HIEROGLYPH A355" +
	"ANATOLIAN HIEROGLYPH A356ANATOLIAN HIEROGLYPH A357ANATOLIAN HIEROGLYPH A" +
	"358ANATOLIAN HIEROGLYPH A359ANATOLIAN HIEROGLYPH A359AANATOLIAN HIEROGLY" +
	"PH A360ANATOLIAN HIEROGLYPH A361ANATOLIAN HIEROGLYPH A362ANATOLIAN HIERO" +
	"GLYPH A363ANATOLIAN HIEROGLYPH A364ANATOLIAN HIEROGLYPH A364AANATOLIAN H" +
	"IEROGLYPH A365ANATOLIAN HIEROGLYPH A366ANATOLIAN HIEROGLYPH A367ANATOLIA" +
	"N HIEROGLYPH A368ANATOLIAN HIEROGLYPH A368AANATOLIAN HIEROGLYPH A369ANAT" +
	"OLIAN HIEROGLYPH A370ANATOLIAN HIEROGLYPH A371ANATOLIAN HIEROGLYPH A371A" +
	"ANATOLIAN HIEROGLYPH A372ANATOLIAN HIEROGLYPH A373ANATOLIAN HIEROGLYPH A" +
	"374ANATOLIAN HIEROGLYPH A375ANATOLIAN HIEROGLYPH A376ANATOLIAN HIEROGLYP" +
	"H A377ANATOLIAN HIEROGLYPH A378ANATOLIAN HIEROGLYPH A379ANATOLIAN HIEROG" +
	"LYPH A380ANATOLIAN HIEROGLYPH A381ANATOLIAN HIEROGLYPH A381AANATOLIAN HI" +
	"EROGLYPH A382ANATOLIAN HIEROGLYPH A383 RA OR RIANATOLIAN HIEROGLYPH A383" +
	"AANATOLIAN HIEROGLYPH A384ANATOLIAN HIEROGLYPH A385ANATOLIAN HIEROGLYPH " +
	"A386ANATOLIAN HIEROGLYPH A386AANATOLIAN HIEROGLYPH A387ANATOLIAN HIEROGL" +
	"YPH A388ANATOLIAN HIEROGLYPH A389ANATOLIAN HIEROGLYPH A390ANATOLIAN HIER" +
	"OGLYPH A391ANATOLIAN HIEROGLYPH A392ANATOLIAN HIEROGLYPH A393 EIGHTANATO" +
	"LIAN HIEROGLYPH A394ANATOLIAN HIEROGLYPH A395ANATOLIAN HIEROGLYPH A396AN" +
	"ATOLIAN HIEROGLYPH A397ANATOLIAN HIEROGLYPH A398ANATOLIAN HIEROGLYPH A39" +
	"9ANATOLIAN HIEROGLYPH A400ANATOLIAN HIEROGLYPH A401ANATOLIAN HIEROGLYPH " +
	"A402ANATOLIAN HIEROGLYPH A403ANATOLIAN HIEROGLYPH A404ANATOLIAN HIEROGLY" +
	"PH A405ANATOLIAN HIEROGLYPH A406ANATOLIAN HIEROGLYPH A407ANATOLIAN HIERO" +
	"GLYPH A408ANATOLIAN HIEROGLYPH A409ANATOLIAN HIEROGLYPH A410 BEGIN LOGOG" +
	"RAM MARKANATOLIAN HIEROGLYPH A410A END LOGOGRAM MARKANATOLIAN HIEROGLYPH" +
	" A411ANATOLIAN HIEROGLYPH A412ANATOLIAN HIEROGLYPH A413ANATOLIAN HIEROGL" +
	"YPH A414ANATOLIAN HIEROGLYPH A415ANATOLIAN HIEROGLYPH A416ANATOLIAN HIER" +
	"OGLYPH A417ANATOLIAN HIEROGLYPH A418ANATOLIAN HIEROGLYPH A419ANATOLIAN H" +
	"IEROGLYPH A420ANATOLIAN HIEROGLYPH A421ANATOLIAN HIEROGLYPH A422ANATOLIA" +
	"N HIEROGLYPH A423ANATOLIAN HIEROGLYPH A424ANATOLIAN HIEROGLYPH A425ANATO" +
	"LIAN HIEROGLYPH A426ANATOLIAN HIEROGLYPH A427ANATOLIAN HIEROGLYPH A428AN" +
	"ATOLIAN HIEROGLYPH A429ANATOLIAN HIEROGLYPH A430ANATOLIAN HIEROGLYPH A43" +
	"1ANATOLIAN HIEROGLYPH A432ANATOLIAN HIEROGLYPH A433ANATOLIAN HIEROGLYPH " +
	"A434ANATOLIAN HIEROGLYPH A435ANATOLIAN HIEROGLYPH A436ANATOLIAN HIEROGLY" +
	"PH A437ANATOLIAN HIEROGLYPH A438ANATOLIAN HIEROGLYPH A439ANATOLIAN HIERO" +
	"GLYPH A440ANATOLIAN HIEROGLYPH A441ANATOLIAN HIEROGLYPH A442ANATOLIAN HI" +
	"EROGLYPH A443ANATOLIAN HIEROGLYPH A444ANATOLIAN HIEROGLYPH A445ANATOLIAN" +
	" HIEROGLYPH A446ANATOLIAN HIEROGLYPH A447ANATOLIAN HIEROGLYPH A448ANATOL" +
	"IAN HIEROGLYPH A449ANATOLIAN HIEROGLYPH A450ANATOLIAN HIEROGLYPH A450AAN" +
	"ATOLIAN HIEROGLYPH A451ANATOLIAN HIEROGLYPH A452ANATOLIAN HIEROGLYPH A45" +
	"3ANATOLIAN HIEROGLYPH A454ANATOLIAN HIEROGLYPH A455ANATOLIAN HIEROGLYPH " +
	"A456ANATOLIAN HIEROGLYPH A457ANATOLIAN HIEROGLYPH A457AANATOLIAN HIEROGL" +
	"YPH A458ANATOLIAN HIEROGLYPH A459ANATOLIAN HIEROGLYPH A460ANATOLIAN HIER" +
	"OGLYPH A461ANATOLIAN HIEROGLYPH A462ANATOLIAN HIEROGLYPH A463ANATOLIAN H" +
	"IEROGLYPH A464ANATOLIAN HIEROGLYPH A465ANATOLIAN HIEROGLYPH A466ANATOLIA" +
	"N HIEROGLYPH A467ANATOLIAN HIEROGLYPH A468ANATOLIAN HIEROGLYPH A469ANATO" +
	"LIAN HIEROGLYPH A470ANATOLIAN HIEROGLYPH A471ANATOLIAN HIEROGLYPH A472AN" +
	"ATOLIAN HIEROGLYPH A473ANATOLIAN HIEROGLYPH A474ANATOLIAN HIEROGLYPH A47" +
	"5ANATOLIAN HIEROGLYPH A476ANATOLIAN HIEROGLYPH A477ANATOLIAN HIEROGLYPH " +
	"A478ANATOLIAN HIEROGLYPH A479ANATOLIAN HIEROGLYPH A480ANATOLIAN HIEROGLY" +
	"PH A481ANATOLIAN HIEROGLYPH A482ANATOLIAN HIEROGLYPH A483ANATOLIAN HIERO" +
	"GLYPH A484ANATOLIAN HIEROGLYPH A485ANATOLIAN HIEROGLYPH A486ANATOLIAN HI" +
	"EROGLYPH A487ANATOLIAN HIEROGLYPH A488ANATOLIAN HIEROGLYPH A489ANATOLIAN" +
	" HIEROGLYPH A490ANATOLIAN HIEROGLYPH A491ANATOLIAN HIEROGLYPH A492ANATOL" +
	"IAN HIEROGLYPH A493ANATOLIAN HIEROGLYPH A494ANATOLIAN HIEROGLYPH A495ANA") + ("" +
	"TOLIAN HIEROGLYPH A496ANATOLIAN HIEROGLYPH A497ANATOLIAN HIEROGLYPH A501" +
	"ANATOLIAN HIEROGLYPH A502ANATOLIAN HIEROGLYPH A503ANATOLIAN HIEROGLYPH A" +
	"504ANATOLIAN HIEROGLYPH A505ANATOLIAN HIEROGLYPH A506ANATOLIAN HIEROGLYP" +
	"H A507ANATOLIAN HIEROGLYPH A508ANATOLIAN HIEROGLYPH A509ANATOLIAN HIEROG" +
	"LYPH A510ANATOLIAN HIEROGLYPH A511ANATOLIAN HIEROGLYPH A512ANATOLIAN HIE" +
	"ROGLYPH A513ANATOLIAN HIEROGLYPH A514ANATOLIAN HIEROGLYPH A515ANATOLIAN " +
	"HIEROGLYPH A516ANATOLIAN HIEROGLYPH A517ANATOLIAN HIEROGLYPH A518ANATOLI" +
	"AN HIEROGLYPH A519ANATOLIAN HIEROGLYPH A520ANATOLIAN HIEROGLYPH A521ANAT" +
	"OLIAN HIEROGLYPH A522ANATOLIAN HIEROGLYPH A523ANATOLIAN HIEROGLYPH A524A" +
	"NATOLIAN HIEROGLYPH A525ANATOLIAN HIEROGLYPH A526ANATOLIAN HIEROGLYPH A5" +
	"27ANATOLIAN HIEROGLYPH A528ANATOLIAN HIEROGLYPH A529ANATOLIAN HIEROGLYPH" +
	" A530BAMUM LETTER PHASE-A NGKUE MFONBAMUM LETTER PHASE-A GBIEE FONBAMUM " +
	"LETTER PHASE-A PON MFON PIPAEMGBIEEBAMUM LETTER PHASE-A PON MFON PIPAEMB" +
	"ABAMUM LETTER PHASE-A NAA MFONBAMUM LETTER PHASE-A SHUENSHUETBAMUM LETTE" +
	"R PHASE-A TITA MFONBAMUM LETTER PHASE-A NZA MFONBAMUM LETTER PHASE-A SHI" +
	"NDA PA NJIBAMUM LETTER PHASE-A PON PA NJI PIPAEMGBIEEBAMUM LETTER PHASE-" +
	"A PON PA NJI PIPAEMBABAMUM LETTER PHASE-A MAEMBGBIEEBAMUM LETTER PHASE-A" +
	" TU MAEMBABAMUM LETTER PHASE-A NGANGUBAMUM LETTER PHASE-A MAEMVEUXBAMUM " +
	"LETTER PHASE-A MANSUAEBAMUM LETTER PHASE-A MVEUAENGAMBAMUM LETTER PHASE-" +
	"A SEUNYAMBAMUM LETTER PHASE-A NTOQPENBAMUM LETTER PHASE-A KEUKEUTNDABAMU" +
	"M LETTER PHASE-A NKINDIBAMUM LETTER PHASE-A SUUBAMUM LETTER PHASE-A NGKU" +
	"ENZEUMBAMUM LETTER PHASE-A LAPAQBAMUM LETTER PHASE-A LET KUTBAMUM LETTER" +
	" PHASE-A NTAP MFAABAMUM LETTER PHASE-A MAEKEUPBAMUM LETTER PHASE-A PASHA" +
	"EBAMUM LETTER PHASE-A GHEUAERAEBAMUM LETTER PHASE-A PAMSHAEBAMUM LETTER " +
	"PHASE-A MON NGGEUAETBAMUM LETTER PHASE-A NZUN MEUTBAMUM LETTER PHASE-A U" +
	" YUQ NAEBAMUM LETTER PHASE-A GHEUAEGHEUAEBAMUM LETTER PHASE-A NTAP NTAAB" +
	"AMUM LETTER PHASE-A SISABAMUM LETTER PHASE-A MGBASABAMUM LETTER PHASE-A " +
	"MEUNJOMNDEUQBAMUM LETTER PHASE-A MOOMPUQBAMUM LETTER PHASE-A KAFABAMUM L" +
	"ETTER PHASE-A PA LEERAEWABAMUM LETTER PHASE-A NDA LEERAEWABAMUM LETTER P" +
	"HASE-A PETBAMUM LETTER PHASE-A MAEMKPENBAMUM LETTER PHASE-A NIKABAMUM LE" +
	"TTER PHASE-A PUPBAMUM LETTER PHASE-A TUAEPBAMUM LETTER PHASE-A LUAEPBAMU" +
	"M LETTER PHASE-A SONJAMBAMUM LETTER PHASE-A TEUTEUWENBAMUM LETTER PHASE-" +
	"A MAENYIBAMUM LETTER PHASE-A KETBAMUM LETTER PHASE-A NDAANGGEUAETBAMUM L" +
	"ETTER PHASE-A KUOQBAMUM LETTER PHASE-A MOOMEUTBAMUM LETTER PHASE-A SHUMB" +
	"AMUM LETTER PHASE-A LOMMAEBAMUM LETTER PHASE-A FIRIBAMUM LETTER PHASE-A " +
	"ROMBAMUM LETTER PHASE-A KPOQBAMUM LETTER PHASE-A SOQBAMUM LETTER PHASE-A" +
	" MAP PIEETBAMUM LETTER PHASE-A SHIRAEBAMUM LETTER PHASE-A NTAPBAMUM LETT" +
	"ER PHASE-A SHOQ NSHUT YUMBAMUM LETTER PHASE-A NYIT MONGKEUAEQBAMUM LETTE" +
	"R PHASE-A PAARAEBAMUM LETTER PHASE-A NKAARAEBAMUM LETTER PHASE-A UNKNOWN" +
	"BAMUM LETTER PHASE-A NGGENBAMUM LETTER PHASE-A MAESIBAMUM LETTER PHASE-A" +
	" NJAMBAMUM LETTER PHASE-A MBANYIBAMUM LETTER PHASE-A NYETBAMUM LETTER PH" +
	"ASE-A TEUAENBAMUM LETTER PHASE-A SOTBAMUM LETTER PHASE-A PAAMBAMUM LETTE" +
	"R PHASE-A NSHIEEBAMUM LETTER PHASE-A MAEMBAMUM LETTER PHASE-A NYIBAMUM L" +
	"ETTER PHASE-A KAQBAMUM LETTER PHASE-A NSHABAMUM LETTER PHASE-A VEEBAMUM " +
	"LETTER PHASE-A LUBAMUM LETTER PHASE-A NENBAMUM LETTER PHASE-A NAQBAMUM L" +
	"ETTER PHASE-A MBAQBAMUM LETTER PHASE-B NSHUETBAMUM LETTER PHASE-B TU MAE" +
	"MGBIEEBAMUM LETTER PHASE-B SIEEBAMUM LETTER PHASE-B SET TUBAMUM LETTER P" +
	"HASE-B LOM NTEUMBAMUM LETTER PHASE-B MBA MAELEEBAMUM LETTER PHASE-B KIEE" +
	"MBAMUM LETTER PHASE-B YEURAEBAMUM LETTER PHASE-B MBAARAEBAMUM LETTER PHA" +
	"SE-B KAMBAMUM LETTER PHASE-B PEESHIBAMUM LETTER PHASE-B YAFU LEERAEWABAM" +
	"UM LETTER PHASE-B LAM NSHUT NYAMBAMUM LETTER PHASE-B NTIEE SHEUOQBAMUM L" +
	"ETTER PHASE-B NDU NJAABAMUM LETTER PHASE-B GHEUGHEUAEMBAMUM LETTER PHASE" +
	"-B PITBAMUM LETTER PHASE-B TU NSIEEBAMUM LETTER PHASE-B SHET NJAQBAMUM L" +
	"ETTER PHASE-B SHEUAEQTUBAMUM LETTER PHASE-B MFON TEUAEQBAMUM LETTER PHAS" +
	"E-B MBIT MBAAKETBAMUM LETTER PHASE-B NYI NTEUMBAMUM LETTER PHASE-B KEUPU" +
	"QBAMUM LETTER PHASE-B GHEUGHENBAMUM LETTER PHASE-B KEUYEUXBAMUM LETTER P" +
	"HASE-B LAANAEBAMUM LETTER PHASE-B PARUMBAMUM LETTER PHASE-B VEUMBAMUM LE" +
	"TTER PHASE-B NGKINDI MVOPBAMUM LETTER PHASE-B NGGEU MBUBAMUM LETTER PHAS" +
	"E-B WUAETBAMUM LETTER PHASE-B SAKEUAEBAMUM LETTER PHASE-B TAAMBAMUM LETT" +
	"ER PHASE-B MEUQBAMUM LETTER PHASE-B NGGUOQBAMUM LETTER PHASE-B NGGUOQ LA" +
	"RGEBAMUM LETTER PHASE-B MFIYAQBAMUM LETTER PHASE-B SUEBAMUM LETTER PHASE" +
	"-B MBEURIBAMUM LETTER PHASE-B MONTIEENBAMUM LETTER PHASE-B NYAEMAEBAMUM " +
	"LETTER PHASE-B PUNGAAMBAMUM LETTER PHASE-B MEUT NGGEETBAMUM LETTER PHASE" +
	"-B FEUXBAMUM LETTER PHASE-B MBUOQBAMUM LETTER PHASE-B FEEBAMUM LETTER PH") + ("" +
	"ASE-B KEUAEMBAMUM LETTER PHASE-B MA NJEUAENABAMUM LETTER PHASE-B MA NJUQ" +
	"ABAMUM LETTER PHASE-B LETBAMUM LETTER PHASE-B NGGAAMBAMUM LETTER PHASE-B" +
	" NSENBAMUM LETTER PHASE-B MABAMUM LETTER PHASE-B KIQBAMUM LETTER PHASE-B" +
	" NGOMBAMUM LETTER PHASE-C NGKUE MAEMBABAMUM LETTER PHASE-C NZABAMUM LETT" +
	"ER PHASE-C YUMBAMUM LETTER PHASE-C WANGKUOQBAMUM LETTER PHASE-C NGGENBAM" +
	"UM LETTER PHASE-C NDEUAEREEBAMUM LETTER PHASE-C NGKAQBAMUM LETTER PHASE-" +
	"C GHARAEBAMUM LETTER PHASE-C MBEEKEETBAMUM LETTER PHASE-C GBAYIBAMUM LET" +
	"TER PHASE-C NYIR MKPARAQ MEUNBAMUM LETTER PHASE-C NTU MBITBAMUM LETTER P" +
	"HASE-C MBEUMBAMUM LETTER PHASE-C PIRIEENBAMUM LETTER PHASE-C NDOMBUBAMUM" +
	" LETTER PHASE-C MBAA CABBAGE-TREEBAMUM LETTER PHASE-C KEUSHEUAEPBAMUM LE" +
	"TTER PHASE-C GHAPBAMUM LETTER PHASE-C KEUKAQBAMUM LETTER PHASE-C YU MUOM" +
	"AEBAMUM LETTER PHASE-C NZEUMBAMUM LETTER PHASE-C MBUEBAMUM LETTER PHASE-" +
	"C NSEUAENBAMUM LETTER PHASE-C MBITBAMUM LETTER PHASE-C YEUQBAMUM LETTER " +
	"PHASE-C KPARAQBAMUM LETTER PHASE-C KAABAMUM LETTER PHASE-C SEUXBAMUM LET" +
	"TER PHASE-C NDIDABAMUM LETTER PHASE-C TAASHAEBAMUM LETTER PHASE-C NJUEQB" +
	"AMUM LETTER PHASE-C TITA YUEBAMUM LETTER PHASE-C SUAETBAMUM LETTER PHASE" +
	"-C NGGUAEN NYAMBAMUM LETTER PHASE-C VEUXBAMUM LETTER PHASE-C NANSANAQBAM" +
	"UM LETTER PHASE-C MA KEUAERIBAMUM LETTER PHASE-C NTAABAMUM LETTER PHASE-" +
	"C NGGUONBAMUM LETTER PHASE-C LAPBAMUM LETTER PHASE-C MBIRIEENBAMUM LETTE" +
	"R PHASE-C MGBASAQBAMUM LETTER PHASE-C NTEUNGBABAMUM LETTER PHASE-C TEUTE" +
	"UXBAMUM LETTER PHASE-C NGGUMBAMUM LETTER PHASE-C FUEBAMUM LETTER PHASE-C" +
	" NDEUTBAMUM LETTER PHASE-C NSABAMUM LETTER PHASE-C NSHAQBAMUM LETTER PHA" +
	"SE-C BUNGBAMUM LETTER PHASE-C VEUAEPENBAMUM LETTER PHASE-C MBERAEBAMUM L" +
	"ETTER PHASE-C RUBAMUM LETTER PHASE-C NJAEMBAMUM LETTER PHASE-C LAMBAMUM " +
	"LETTER PHASE-C TITUAEPBAMUM LETTER PHASE-C NSUOT NGOMBAMUM LETTER PHASE-" +
	"C NJEEEEBAMUM LETTER PHASE-C KETBAMUM LETTER PHASE-C NGGUBAMUM LETTER PH" +
	"ASE-C MAESIBAMUM LETTER PHASE-C MBUAEMBAMUM LETTER PHASE-C LUBAMUM LETTE" +
	"R PHASE-C KUTBAMUM LETTER PHASE-C NJAMBAMUM LETTER PHASE-C NGOMBAMUM LET" +
	"TER PHASE-C WUPBAMUM LETTER PHASE-C NGGUEETBAMUM LETTER PHASE-C NSOMBAMU" +
	"M LETTER PHASE-C NTENBAMUM LETTER PHASE-C KUOP NKAARAEBAMUM LETTER PHASE" +
	"-C NSUNBAMUM LETTER PHASE-C NDAMBAMUM LETTER PHASE-C MA NSIEEBAMUM LETTE" +
	"R PHASE-C YAABAMUM LETTER PHASE-C NDAPBAMUM LETTER PHASE-C SHUEQBAMUM LE" +
	"TTER PHASE-C SETFONBAMUM LETTER PHASE-C MBIBAMUM LETTER PHASE-C MAEMBABA" +
	"MUM LETTER PHASE-C MBANYIBAMUM LETTER PHASE-C KEUSEUXBAMUM LETTER PHASE-" +
	"C MBEUXBAMUM LETTER PHASE-C KEUMBAMUM LETTER PHASE-C MBAA PICKETBAMUM LE" +
	"TTER PHASE-C YUWOQBAMUM LETTER PHASE-C NJEUXBAMUM LETTER PHASE-C MIEEBAM" +
	"UM LETTER PHASE-C MUAEBAMUM LETTER PHASE-C SHIQBAMUM LETTER PHASE-C KEN " +
	"LAWBAMUM LETTER PHASE-C KEN FATIGUEBAMUM LETTER PHASE-C NGAQBAMUM LETTER" +
	" PHASE-C NAQBAMUM LETTER PHASE-C LIQBAMUM LETTER PHASE-C PINBAMUM LETTER" +
	" PHASE-C PENBAMUM LETTER PHASE-C TETBAMUM LETTER PHASE-D MBUOBAMUM LETTE" +
	"R PHASE-D WAPBAMUM LETTER PHASE-D NJIBAMUM LETTER PHASE-D MFONBAMUM LETT" +
	"ER PHASE-D NJIEEBAMUM LETTER PHASE-D LIEEBAMUM LETTER PHASE-D NJEUTBAMUM" +
	" LETTER PHASE-D NSHEEBAMUM LETTER PHASE-D NGGAAMAEBAMUM LETTER PHASE-D N" +
	"YAMBAMUM LETTER PHASE-D WUAENBAMUM LETTER PHASE-D NGKUNBAMUM LETTER PHAS" +
	"E-D SHEEBAMUM LETTER PHASE-D NGKAPBAMUM LETTER PHASE-D KEUAETMEUNBAMUM L" +
	"ETTER PHASE-D TEUTBAMUM LETTER PHASE-D SHEUAEBAMUM LETTER PHASE-D NJAPBA" +
	"MUM LETTER PHASE-D SUEBAMUM LETTER PHASE-D KETBAMUM LETTER PHASE-D YAEMM" +
	"AEBAMUM LETTER PHASE-D KUOMBAMUM LETTER PHASE-D SAPBAMUM LETTER PHASE-D " +
	"MFEUTBAMUM LETTER PHASE-D NDEUXBAMUM LETTER PHASE-D MALEERIBAMUM LETTER " +
	"PHASE-D MEUTBAMUM LETTER PHASE-D SEUAEQBAMUM LETTER PHASE-D YENBAMUM LET" +
	"TER PHASE-D NJEUAEMBAMUM LETTER PHASE-D KEUOT MBUAEBAMUM LETTER PHASE-D " +
	"NGKEURIBAMUM LETTER PHASE-D TUBAMUM LETTER PHASE-D GHAABAMUM LETTER PHAS" +
	"E-D NGKYEEBAMUM LETTER PHASE-D FEUFEUAETBAMUM LETTER PHASE-D NDEEBAMUM L" +
	"ETTER PHASE-D MGBOFUMBAMUM LETTER PHASE-D LEUAEPBAMUM LETTER PHASE-D NDO" +
	"NBAMUM LETTER PHASE-D MONIBAMUM LETTER PHASE-D MGBEUNBAMUM LETTER PHASE-" +
	"D PUUTBAMUM LETTER PHASE-D MGBIEEBAMUM LETTER PHASE-D MFOBAMUM LETTER PH" +
	"ASE-D LUMBAMUM LETTER PHASE-D NSIEEPBAMUM LETTER PHASE-D MBAABAMUM LETTE" +
	"R PHASE-D KWAETBAMUM LETTER PHASE-D NYETBAMUM LETTER PHASE-D TEUAENBAMUM" +
	" LETTER PHASE-D SOTBAMUM LETTER PHASE-D YUWOQBAMUM LETTER PHASE-D KEUMBA" +
	"MUM LETTER PHASE-D RAEMBAMUM LETTER PHASE-D TEEEEBAMUM LETTER PHASE-D NG" +
	"KEUAEQBAMUM LETTER PHASE-D MFEUAEBAMUM LETTER PHASE-D NSIEETBAMUM LETTER" +
	" PHASE-D KEUPBAMUM LETTER PHASE-D PIPBAMUM LETTER PHASE-D PEUTAEBAMUM LE" +
	"TTER PHASE-D NYUEBAMUM LETTER PHASE-D LETBAMUM LETTER PHASE-D NGGAAMBAMU" +
	"M LETTER PHASE-D MFIEEBAMUM LETTER PHASE-D NGGWAENBAMUM LETTER PHASE-D Y") + ("" +
	"UOMBAMUM LETTER PHASE-D PAPBAMUM LETTER PHASE-D YUOPBAMUM LETTER PHASE-D" +
	" NDAMBAMUM LETTER PHASE-D NTEUMBAMUM LETTER PHASE-D SUAEBAMUM LETTER PHA" +
	"SE-D KUNBAMUM LETTER PHASE-D NGGEUXBAMUM LETTER PHASE-D NGKIEEBAMUM LETT" +
	"ER PHASE-D TUOTBAMUM LETTER PHASE-D MEUNBAMUM LETTER PHASE-D KUQBAMUM LE" +
	"TTER PHASE-D NSUMBAMUM LETTER PHASE-D TEUNBAMUM LETTER PHASE-D MAENJETBA" +
	"MUM LETTER PHASE-D NGGAPBAMUM LETTER PHASE-D LEUMBAMUM LETTER PHASE-D NG" +
	"GUOMBAMUM LETTER PHASE-D NSHUTBAMUM LETTER PHASE-D NJUEQBAMUM LETTER PHA" +
	"SE-D GHEUAEBAMUM LETTER PHASE-D KUBAMUM LETTER PHASE-D REN OLDBAMUM LETT" +
	"ER PHASE-D TAEBAMUM LETTER PHASE-D TOQBAMUM LETTER PHASE-D NYIBAMUM LETT" +
	"ER PHASE-D RIIBAMUM LETTER PHASE-D LEEEEBAMUM LETTER PHASE-D MEEEEBAMUM " +
	"LETTER PHASE-D MBAMUM LETTER PHASE-D SUUBAMUM LETTER PHASE-D MUBAMUM LET" +
	"TER PHASE-D SHIIBAMUM LETTER PHASE-D SHEUXBAMUM LETTER PHASE-D KYEEBAMUM" +
	" LETTER PHASE-D NUBAMUM LETTER PHASE-D SHUBAMUM LETTER PHASE-D NTEEBAMUM" +
	" LETTER PHASE-D PEEBAMUM LETTER PHASE-D NIBAMUM LETTER PHASE-D SHOQBAMUM" +
	" LETTER PHASE-D PUQBAMUM LETTER PHASE-D MVOPBAMUM LETTER PHASE-D LOQBAMU" +
	"M LETTER PHASE-D REN MUCHBAMUM LETTER PHASE-D TIBAMUM LETTER PHASE-D NTU" +
	"UBAMUM LETTER PHASE-D MBAA SEVENBAMUM LETTER PHASE-D SAQBAMUM LETTER PHA" +
	"SE-D FAABAMUM LETTER PHASE-E NDAPBAMUM LETTER PHASE-E TOONBAMUM LETTER P" +
	"HASE-E MBEUMBAMUM LETTER PHASE-E LAPBAMUM LETTER PHASE-E VOMBAMUM LETTER" +
	" PHASE-E LOONBAMUM LETTER PHASE-E PAABAMUM LETTER PHASE-E SOMBAMUM LETTE" +
	"R PHASE-E RAQBAMUM LETTER PHASE-E NSHUOPBAMUM LETTER PHASE-E NDUNBAMUM L" +
	"ETTER PHASE-E PUAEBAMUM LETTER PHASE-E TAMBAMUM LETTER PHASE-E NGKABAMUM" +
	" LETTER PHASE-E KPEUXBAMUM LETTER PHASE-E WUOBAMUM LETTER PHASE-E SEEBAM" +
	"UM LETTER PHASE-E NGGEUAETBAMUM LETTER PHASE-E PAAMBAMUM LETTER PHASE-E " +
	"TOOBAMUM LETTER PHASE-E KUOPBAMUM LETTER PHASE-E LOMBAMUM LETTER PHASE-E" +
	" NSHIEEBAMUM LETTER PHASE-E NGOPBAMUM LETTER PHASE-E MAEMBAMUM LETTER PH" +
	"ASE-E NGKEUXBAMUM LETTER PHASE-E NGOQBAMUM LETTER PHASE-E NSHUEBAMUM LET" +
	"TER PHASE-E RIMGBABAMUM LETTER PHASE-E NJEUXBAMUM LETTER PHASE-E PEEMBAM" +
	"UM LETTER PHASE-E SAABAMUM LETTER PHASE-E NGGURAEBAMUM LETTER PHASE-E MG" +
	"BABAMUM LETTER PHASE-E GHEUXBAMUM LETTER PHASE-E NGKEUAEMBAMUM LETTER PH" +
	"ASE-E NJAEMLIBAMUM LETTER PHASE-E MAPBAMUM LETTER PHASE-E LOOTBAMUM LETT" +
	"ER PHASE-E NGGEEEEBAMUM LETTER PHASE-E NDIQBAMUM LETTER PHASE-E TAEN NTE" +
	"UMBAMUM LETTER PHASE-E SETBAMUM LETTER PHASE-E PUMBAMUM LETTER PHASE-E N" +
	"DAA SOFTNESSBAMUM LETTER PHASE-E NGGUAESHAE NYAMBAMUM LETTER PHASE-E YIE" +
	"EBAMUM LETTER PHASE-E GHEUNBAMUM LETTER PHASE-E TUAEBAMUM LETTER PHASE-E" +
	" YEUAEBAMUM LETTER PHASE-E POBAMUM LETTER PHASE-E TUMAEBAMUM LETTER PHAS" +
	"E-E KEUAEBAMUM LETTER PHASE-E SUAENBAMUM LETTER PHASE-E TEUAEQBAMUM LETT" +
	"ER PHASE-E VEUAEBAMUM LETTER PHASE-E WEUXBAMUM LETTER PHASE-E LAAMBAMUM " +
	"LETTER PHASE-E PUBAMUM LETTER PHASE-E TAAQBAMUM LETTER PHASE-E GHAAMAEBA" +
	"MUM LETTER PHASE-E NGEUREUTBAMUM LETTER PHASE-E SHEUAEQBAMUM LETTER PHAS" +
	"E-E MGBENBAMUM LETTER PHASE-E MBEEBAMUM LETTER PHASE-E NZAQBAMUM LETTER " +
	"PHASE-E NKOMBAMUM LETTER PHASE-E GBETBAMUM LETTER PHASE-E TUMBAMUM LETTE" +
	"R PHASE-E KUETBAMUM LETTER PHASE-E YAPBAMUM LETTER PHASE-E NYI CLEAVERBA" +
	"MUM LETTER PHASE-E YITBAMUM LETTER PHASE-E MFEUQBAMUM LETTER PHASE-E NDI" +
	"AQBAMUM LETTER PHASE-E PIEEQBAMUM LETTER PHASE-E YUEQBAMUM LETTER PHASE-" +
	"E LEUAEMBAMUM LETTER PHASE-E FUEBAMUM LETTER PHASE-E GBEUXBAMUM LETTER P" +
	"HASE-E NGKUPBAMUM LETTER PHASE-E KETBAMUM LETTER PHASE-E MAEBAMUM LETTER" +
	" PHASE-E NGKAAMIBAMUM LETTER PHASE-E GHETBAMUM LETTER PHASE-E FABAMUM LE" +
	"TTER PHASE-E NTUMBAMUM LETTER PHASE-E PEUTBAMUM LETTER PHASE-E YEUMBAMUM" +
	" LETTER PHASE-E NGGEUAEBAMUM LETTER PHASE-E NYI BETWEENBAMUM LETTER PHAS" +
	"E-E NZUQBAMUM LETTER PHASE-E POONBAMUM LETTER PHASE-E MIEEBAMUM LETTER P" +
	"HASE-E FUETBAMUM LETTER PHASE-E NAEBAMUM LETTER PHASE-E MUAEBAMUM LETTER" +
	" PHASE-E GHEUAEBAMUM LETTER PHASE-E FU IBAMUM LETTER PHASE-E MVIBAMUM LE" +
	"TTER PHASE-E PUAQBAMUM LETTER PHASE-E NGKUMBAMUM LETTER PHASE-E KUTBAMUM" +
	" LETTER PHASE-E PIETBAMUM LETTER PHASE-E NTAPBAMUM LETTER PHASE-E YEUAET" +
	"BAMUM LETTER PHASE-E NGGUPBAMUM LETTER PHASE-E PA PEOPLEBAMUM LETTER PHA" +
	"SE-E FU CALLBAMUM LETTER PHASE-E FOMBAMUM LETTER PHASE-E NJEEBAMUM LETTE" +
	"R PHASE-E ABAMUM LETTER PHASE-E TOQBAMUM LETTER PHASE-E OBAMUM LETTER PH" +
	"ASE-E IBAMUM LETTER PHASE-E LAQBAMUM LETTER PHASE-E PA PLURALBAMUM LETTE" +
	"R PHASE-E TAABAMUM LETTER PHASE-E TAQBAMUM LETTER PHASE-E NDAA MY HOUSEB" +
	"AMUM LETTER PHASE-E SHIQBAMUM LETTER PHASE-E YEUXBAMUM LETTER PHASE-E NG" +
	"UAEBAMUM LETTER PHASE-E YUAENBAMUM LETTER PHASE-E YOQ SWIMMINGBAMUM LETT" +
	"ER PHASE-E YOQ COVERBAMUM LETTER PHASE-E YUQBAMUM LETTER PHASE-E YUNBAMU" +
	"M LETTER PHASE-E KEUXBAMUM LETTER PHASE-E PEUXBAMUM LETTER PHASE-E NJEE ") + ("" +
	"EPOCHBAMUM LETTER PHASE-E PUEBAMUM LETTER PHASE-E WUEBAMUM LETTER PHASE-" +
	"E FEEBAMUM LETTER PHASE-E VEEBAMUM LETTER PHASE-E LUBAMUM LETTER PHASE-E" +
	" MIBAMUM LETTER PHASE-E REUXBAMUM LETTER PHASE-E RAEBAMUM LETTER PHASE-E" +
	" NGUAETBAMUM LETTER PHASE-E NGABAMUM LETTER PHASE-E SHOBAMUM LETTER PHAS" +
	"E-E SHOQBAMUM LETTER PHASE-E FU REMEDYBAMUM LETTER PHASE-E NABAMUM LETTE" +
	"R PHASE-E PIBAMUM LETTER PHASE-E LOQBAMUM LETTER PHASE-E KOBAMUM LETTER " +
	"PHASE-E MENBAMUM LETTER PHASE-E MABAMUM LETTER PHASE-E MAQBAMUM LETTER P" +
	"HASE-E TEUBAMUM LETTER PHASE-E KIBAMUM LETTER PHASE-E MONBAMUM LETTER PH" +
	"ASE-E TENBAMUM LETTER PHASE-E FAQBAMUM LETTER PHASE-E GHOMBAMUM LETTER P" +
	"HASE-F KABAMUM LETTER PHASE-F UBAMUM LETTER PHASE-F KUBAMUM LETTER PHASE" +
	"-F EEBAMUM LETTER PHASE-F REEBAMUM LETTER PHASE-F TAEBAMUM LETTER PHASE-" +
	"F NYIBAMUM LETTER PHASE-F LABAMUM LETTER PHASE-F RIIBAMUM LETTER PHASE-F" +
	" RIEEBAMUM LETTER PHASE-F MEEEEBAMUM LETTER PHASE-F TAABAMUM LETTER PHAS" +
	"E-F NDAABAMUM LETTER PHASE-F NJAEMBAMUM LETTER PHASE-F MBAMUM LETTER PHA" +
	"SE-F SUUBAMUM LETTER PHASE-F SHIIBAMUM LETTER PHASE-F SIBAMUM LETTER PHA" +
	"SE-F SEUXBAMUM LETTER PHASE-F KYEEBAMUM LETTER PHASE-F KETBAMUM LETTER P" +
	"HASE-F NUAEBAMUM LETTER PHASE-F NUBAMUM LETTER PHASE-F NJUAEBAMUM LETTER" +
	" PHASE-F YOQBAMUM LETTER PHASE-F SHUBAMUM LETTER PHASE-F YABAMUM LETTER " +
	"PHASE-F NSHABAMUM LETTER PHASE-F PEUXBAMUM LETTER PHASE-F NTEEBAMUM LETT" +
	"ER PHASE-F WUEBAMUM LETTER PHASE-F PEEBAMUM LETTER PHASE-F RUBAMUM LETTE" +
	"R PHASE-F NIBAMUM LETTER PHASE-F REUXBAMUM LETTER PHASE-F KENBAMUM LETTE" +
	"R PHASE-F NGKWAENBAMUM LETTER PHASE-F NGGABAMUM LETTER PHASE-F SHOBAMUM " +
	"LETTER PHASE-F PUAEBAMUM LETTER PHASE-F FOMBAMUM LETTER PHASE-F WABAMUM " +
	"LETTER PHASE-F LIBAMUM LETTER PHASE-F LOQBAMUM LETTER PHASE-F KOBAMUM LE" +
	"TTER PHASE-F MBENBAMUM LETTER PHASE-F RENBAMUM LETTER PHASE-F MABAMUM LE" +
	"TTER PHASE-F MOBAMUM LETTER PHASE-F MBAABAMUM LETTER PHASE-F TETBAMUM LE" +
	"TTER PHASE-F KPABAMUM LETTER PHASE-F SAMBABAMUM LETTER PHASE-F VUEQMRO L" +
	"ETTER TAMRO LETTER NGIMRO LETTER YOMRO LETTER MIMMRO LETTER BAMRO LETTER" +
	" DAMRO LETTER AMRO LETTER PHIMRO LETTER KHAIMRO LETTER HAOMRO LETTER DAI" +
	"MRO LETTER CHUMRO LETTER KEAAEMRO LETTER OLMRO LETTER MAEMMRO LETTER NIN" +
	"MRO LETTER PAMRO LETTER OOMRO LETTER OMRO LETTER ROMRO LETTER SHIMRO LET" +
	"TER THEAMRO LETTER EAMRO LETTER WAMRO LETTER EMRO LETTER KOMRO LETTER LA" +
	"NMRO LETTER LAMRO LETTER HAIMRO LETTER RIMRO LETTER TEKMRO DIGIT ZEROMRO" +
	" DIGIT ONEMRO DIGIT TWOMRO DIGIT THREEMRO DIGIT FOURMRO DIGIT FIVEMRO DI" +
	"GIT SIXMRO DIGIT SEVENMRO DIGIT EIGHTMRO DIGIT NINEMRO DANDAMRO DOUBLE D" +
	"ANDABASSA VAH LETTER ENNIBASSA VAH LETTER KABASSA VAH LETTER SEBASSA VAH" +
	" LETTER FABASSA VAH LETTER MBEBASSA VAH LETTER YIEBASSA VAH LETTER GAHBA" +
	"SSA VAH LETTER DHIIBASSA VAH LETTER KPAHBASSA VAH LETTER JOBASSA VAH LET" +
	"TER HWAHBASSA VAH LETTER WABASSA VAH LETTER ZOBASSA VAH LETTER GBUBASSA " +
	"VAH LETTER DOBASSA VAH LETTER CEBASSA VAH LETTER UWUBASSA VAH LETTER TOB" +
	"ASSA VAH LETTER BABASSA VAH LETTER VUBASSA VAH LETTER YEINBASSA VAH LETT" +
	"ER PABASSA VAH LETTER WADDABASSA VAH LETTER ABASSA VAH LETTER OBASSA VAH" +
	" LETTER OOBASSA VAH LETTER UBASSA VAH LETTER EEBASSA VAH LETTER EBASSA V" +
	"AH LETTER IBASSA VAH COMBINING HIGH TONEBASSA VAH COMBINING LOW TONEBASS" +
	"A VAH COMBINING MID TONEBASSA VAH COMBINING LOW-MID TONEBASSA VAH COMBIN" +
	"ING HIGH-LOW TONEBASSA VAH FULL STOPPAHAWH HMONG VOWEL KEEBPAHAWH HMONG " +
	"VOWEL KEEVPAHAWH HMONG VOWEL KIBPAHAWH HMONG VOWEL KIVPAHAWH HMONG VOWEL" +
	" KAUBPAHAWH HMONG VOWEL KAUVPAHAWH HMONG VOWEL KUBPAHAWH HMONG VOWEL KUV" +
	"PAHAWH HMONG VOWEL KEBPAHAWH HMONG VOWEL KEVPAHAWH HMONG VOWEL KAIBPAHAW" +
	"H HMONG VOWEL KAIVPAHAWH HMONG VOWEL KOOBPAHAWH HMONG VOWEL KOOVPAHAWH H" +
	"MONG VOWEL KAWBPAHAWH HMONG VOWEL KAWVPAHAWH HMONG VOWEL KUABPAHAWH HMON" +
	"G VOWEL KUAVPAHAWH HMONG VOWEL KOBPAHAWH HMONG VOWEL KOVPAHAWH HMONG VOW" +
	"EL KIABPAHAWH HMONG VOWEL KIAVPAHAWH HMONG VOWEL KABPAHAWH HMONG VOWEL K" +
	"AVPAHAWH HMONG VOWEL KWBPAHAWH HMONG VOWEL KWVPAHAWH HMONG VOWEL KAABPAH" +
	"AWH HMONG VOWEL KAAVPAHAWH HMONG CONSONANT VAUPAHAWH HMONG CONSONANT NTS" +
	"AUPAHAWH HMONG CONSONANT LAUPAHAWH HMONG CONSONANT HAUPAHAWH HMONG CONSO" +
	"NANT NLAUPAHAWH HMONG CONSONANT RAUPAHAWH HMONG CONSONANT NKAUPAHAWH HMO" +
	"NG CONSONANT QHAUPAHAWH HMONG CONSONANT YAUPAHAWH HMONG CONSONANT HLAUPA" +
	"HAWH HMONG CONSONANT MAUPAHAWH HMONG CONSONANT CHAUPAHAWH HMONG CONSONAN" +
	"T NCHAUPAHAWH HMONG CONSONANT HNAUPAHAWH HMONG CONSONANT PLHAUPAHAWH HMO" +
	"NG CONSONANT NTHAUPAHAWH HMONG CONSONANT NAUPAHAWH HMONG CONSONANT AUPAH" +
	"AWH HMONG CONSONANT XAUPAHAWH HMONG CONSONANT CAUPAHAWH HMONG MARK CIM T" +
	"UBPAHAWH HMONG MARK CIM SOPAHAWH HMONG MARK CIM KESPAHAWH HMONG MARK CIM" +
	" KHAVPAHAWH HMONG MARK CIM SUAMPAHAWH HMONG MARK CIM HOMPAHAWH HMONG MAR") + ("" +
	"K CIM TAUMPAHAWH HMONG SIGN VOS THOMPAHAWH HMONG SIGN VOS TSHAB CEEBPAHA" +
	"WH HMONG SIGN CIM CHEEMPAHAWH HMONG SIGN VOS THIABPAHAWH HMONG SIGN VOS " +
	"FEEMPAHAWH HMONG SIGN XYEEM NTXIVPAHAWH HMONG SIGN XYEEM RHOPAHAWH HMONG" +
	" SIGN XYEEM TOVPAHAWH HMONG SIGN XYEEM FAIBPAHAWH HMONG SIGN VOS SEEVPAH" +
	"AWH HMONG SIGN MEEJ SUABPAHAWH HMONG SIGN VOS NRUAPAHAWH HMONG SIGN IB Y" +
	"AMPAHAWH HMONG SIGN XAUSPAHAWH HMONG SIGN CIM TSOV ROGPAHAWH HMONG DIGIT" +
	" ZEROPAHAWH HMONG DIGIT ONEPAHAWH HMONG DIGIT TWOPAHAWH HMONG DIGIT THRE" +
	"EPAHAWH HMONG DIGIT FOURPAHAWH HMONG DIGIT FIVEPAHAWH HMONG DIGIT SIXPAH" +
	"AWH HMONG DIGIT SEVENPAHAWH HMONG DIGIT EIGHTPAHAWH HMONG DIGIT NINEPAHA" +
	"WH HMONG NUMBER TENSPAHAWH HMONG NUMBER HUNDREDSPAHAWH HMONG NUMBER TEN " +
	"THOUSANDSPAHAWH HMONG NUMBER MILLIONSPAHAWH HMONG NUMBER HUNDRED MILLION" +
	"SPAHAWH HMONG NUMBER TEN BILLIONSPAHAWH HMONG NUMBER TRILLIONSPAHAWH HMO" +
	"NG SIGN VOS LUBPAHAWH HMONG SIGN XYOOPAHAWH HMONG SIGN HLIPAHAWH HMONG S" +
	"IGN THIRD-STAGE HLIPAHAWH HMONG SIGN ZWJ THAJPAHAWH HMONG SIGN HNUBPAHAW" +
	"H HMONG SIGN NQIGPAHAWH HMONG SIGN XIABPAHAWH HMONG SIGN NTUJPAHAWH HMON" +
	"G SIGN AVPAHAWH HMONG SIGN TXHEEJ CEEVPAHAWH HMONG SIGN MEEJ TSEEBPAHAWH" +
	" HMONG SIGN TAUPAHAWH HMONG SIGN LOSPAHAWH HMONG SIGN MUSPAHAWH HMONG SI" +
	"GN CIM HAIS LUS NTOG NTOGPAHAWH HMONG SIGN CIM CUAM TSHOOJPAHAWH HMONG S" +
	"IGN CIM TXWVPAHAWH HMONG SIGN CIM TXWV CHWVPAHAWH HMONG SIGN CIM PUB DAW" +
	"BPAHAWH HMONG SIGN CIM NRES TOSPAHAWH HMONG CLAN SIGN TSHEEJPAHAWH HMONG" +
	" CLAN SIGN YEEGPAHAWH HMONG CLAN SIGN LISPAHAWH HMONG CLAN SIGN LAUJPAHA" +
	"WH HMONG CLAN SIGN XYOOJPAHAWH HMONG CLAN SIGN KOOPAHAWH HMONG CLAN SIGN" +
	" HAWJPAHAWH HMONG CLAN SIGN MUASPAHAWH HMONG CLAN SIGN THOJPAHAWH HMONG " +
	"CLAN SIGN TSABPAHAWH HMONG CLAN SIGN PHABPAHAWH HMONG CLAN SIGN KHABPAHA" +
	"WH HMONG CLAN SIGN HAMPAHAWH HMONG CLAN SIGN VAJPAHAWH HMONG CLAN SIGN F" +
	"AJPAHAWH HMONG CLAN SIGN YAJPAHAWH HMONG CLAN SIGN TSWBPAHAWH HMONG CLAN" +
	" SIGN KWMPAHAWH HMONG CLAN SIGN VWJMIAO LETTER PAMIAO LETTER BAMIAO LETT" +
	"ER YI PAMIAO LETTER PLAMIAO LETTER MAMIAO LETTER MHAMIAO LETTER ARCHAIC " +
	"MAMIAO LETTER FAMIAO LETTER VAMIAO LETTER VFAMIAO LETTER TAMIAO LETTER D" +
	"AMIAO LETTER YI TTAMIAO LETTER YI TAMIAO LETTER TTAMIAO LETTER DDAMIAO L" +
	"ETTER NAMIAO LETTER NHAMIAO LETTER YI NNAMIAO LETTER ARCHAIC NAMIAO LETT" +
	"ER NNAMIAO LETTER NNHAMIAO LETTER LAMIAO LETTER LYAMIAO LETTER LHAMIAO L" +
	"ETTER LHYAMIAO LETTER TLHAMIAO LETTER DLHAMIAO LETTER TLHYAMIAO LETTER D" +
	"LHYAMIAO LETTER KAMIAO LETTER GAMIAO LETTER YI KAMIAO LETTER QAMIAO LETT" +
	"ER QGAMIAO LETTER NGAMIAO LETTER NGHAMIAO LETTER ARCHAIC NGAMIAO LETTER " +
	"HAMIAO LETTER XAMIAO LETTER GHAMIAO LETTER GHHAMIAO LETTER TSSAMIAO LETT" +
	"ER DZZAMIAO LETTER NYAMIAO LETTER NYHAMIAO LETTER TSHAMIAO LETTER DZHAMI" +
	"AO LETTER YI TSHAMIAO LETTER YI DZHAMIAO LETTER REFORMED TSHAMIAO LETTER" +
	" SHAMIAO LETTER SSAMIAO LETTER ZHAMIAO LETTER ZSHAMIAO LETTER TSAMIAO LE" +
	"TTER DZAMIAO LETTER YI TSAMIAO LETTER SAMIAO LETTER ZAMIAO LETTER ZSAMIA" +
	"O LETTER ZZAMIAO LETTER ZZSAMIAO LETTER ARCHAIC ZZAMIAO LETTER ZZYAMIAO " +
	"LETTER ZZSYAMIAO LETTER WAMIAO LETTER AHMIAO LETTER HHAMIAO LETTER NASAL" +
	"IZATIONMIAO SIGN ASPIRATIONMIAO SIGN REFORMED VOICINGMIAO SIGN REFORMED " +
	"ASPIRATIONMIAO VOWEL SIGN AMIAO VOWEL SIGN AAMIAO VOWEL SIGN AHHMIAO VOW" +
	"EL SIGN ANMIAO VOWEL SIGN ANGMIAO VOWEL SIGN OMIAO VOWEL SIGN OOMIAO VOW" +
	"EL SIGN WOMIAO VOWEL SIGN WMIAO VOWEL SIGN EMIAO VOWEL SIGN ENMIAO VOWEL" +
	" SIGN ENGMIAO VOWEL SIGN OEYMIAO VOWEL SIGN IMIAO VOWEL SIGN IAMIAO VOWE" +
	"L SIGN IANMIAO VOWEL SIGN IANGMIAO VOWEL SIGN IOMIAO VOWEL SIGN IEMIAO V" +
	"OWEL SIGN IIMIAO VOWEL SIGN IUMIAO VOWEL SIGN INGMIAO VOWEL SIGN UMIAO V" +
	"OWEL SIGN UAMIAO VOWEL SIGN UANMIAO VOWEL SIGN UANGMIAO VOWEL SIGN UUMIA" +
	"O VOWEL SIGN UEIMIAO VOWEL SIGN UNGMIAO VOWEL SIGN YMIAO VOWEL SIGN YIMI" +
	"AO VOWEL SIGN AEMIAO VOWEL SIGN AEEMIAO VOWEL SIGN ERRMIAO VOWEL SIGN RO" +
	"UNDED ERRMIAO VOWEL SIGN ERMIAO VOWEL SIGN ROUNDED ERMIAO VOWEL SIGN AIM" +
	"IAO VOWEL SIGN EIMIAO VOWEL SIGN AUMIAO VOWEL SIGN OUMIAO VOWEL SIGN NMI" +
	"AO VOWEL SIGN NGMIAO TONE RIGHTMIAO TONE TOP RIGHTMIAO TONE ABOVEMIAO TO" +
	"NE BELOWMIAO LETTER TONE-2MIAO LETTER TONE-3MIAO LETTER TONE-4MIAO LETTE" +
	"R TONE-5MIAO LETTER TONE-6MIAO LETTER TONE-7MIAO LETTER TONE-8MIAO LETTE" +
	"R REFORMED TONE-1MIAO LETTER REFORMED TONE-2MIAO LETTER REFORMED TONE-4M" +
	"IAO LETTER REFORMED TONE-5MIAO LETTER REFORMED TONE-6MIAO LETTER REFORME" +
	"D TONE-8TANGUT ITERATION MARKTANGUT COMPONENT-001TANGUT COMPONENT-002TAN" +
	"GUT COMPONENT-003TANGUT COMPONENT-004TANGUT COMPONENT-005TANGUT COMPONEN" +
	"T-006TANGUT COMPONENT-007TANGUT COMPONENT-008TANGUT COMPONENT-009TANGUT " +
	"COMPONENT-010TANGUT COMPONENT-011TANGUT COMPONENT-012TANGUT COMPONENT-01" +
	"3TANGUT COMPONENT-014TANGUT COMPONENT-015TANGUT COMPONENT-016TANGUT COMP") + ("" +
	"ONENT-017TANGUT COMPONENT-018TANGUT COMPONENT-019TANGUT COMPONENT-020TAN" +
	"GUT COMPONENT-021TANGUT COMPONENT-022TANGUT COMPONENT-023TANGUT COMPONEN" +
	"T-024TANGUT COMPONENT-025TANGUT COMPONENT-026TANGUT COMPONENT-027TANGUT " +
	"COMPONENT-028TANGUT COMPONENT-029TANGUT COMPONENT-030TANGUT COMPONENT-03" +
	"1TANGUT COMPONENT-032TANGUT COMPONENT-033TANGUT COMPONENT-034TANGUT COMP" +
	"ONENT-035TANGUT COMPONENT-036TANGUT COMPONENT-037TANGUT COMPONENT-038TAN" +
	"GUT COMPONENT-039TANGUT COMPONENT-040TANGUT COMPONENT-041TANGUT COMPONEN" +
	"T-042TANGUT COMPONENT-043TANGUT COMPONENT-044TANGUT COMPONENT-045TANGUT " +
	"COMPONENT-046TANGUT COMPONENT-047TANGUT COMPONENT-048TANGUT COMPONENT-04" +
	"9TANGUT COMPONENT-050TANGUT COMPONENT-051TANGUT COMPONENT-052TANGUT COMP" +
	"ONENT-053TANGUT COMPONENT-054TANGUT COMPONENT-055TANGUT COMPONENT-056TAN" +
	"GUT COMPONENT-057TANGUT COMPONENT-058TANGUT COMPONENT-059TANGUT COMPONEN" +
	"T-060TANGUT COMPONENT-061TANGUT COMPONENT-062TANGUT COMPONENT-063TANGUT " +
	"COMPONENT-064TANGUT COMPONENT-065TANGUT COMPONENT-066TANGUT COMPONENT-06" +
	"7TANGUT COMPONENT-068TANGUT COMPONENT-069TANGUT COMPONENT-070TANGUT COMP" +
	"ONENT-071TANGUT COMPONENT-072TANGUT COMPONENT-073TANGUT COMPONENT-074TAN" +
	"GUT COMPONENT-075TANGUT COMPONENT-076TANGUT COMPONENT-077TANGUT COMPONEN" +
	"T-078TANGUT COMPONENT-079TANGUT COMPONENT-080TANGUT COMPONENT-081TANGUT " +
	"COMPONENT-082TANGUT COMPONENT-083TANGUT COMPONENT-084TANGUT COMPONENT-08" +
	"5TANGUT COMPONENT-086TANGUT COMPONENT-087TANGUT COMPONENT-088TANGUT COMP" +
	"ONENT-089TANGUT COMPONENT-090TANGUT COMPONENT-091TANGUT COMPONENT-092TAN" +
	"GUT COMPONENT-093TANGUT COMPONENT-094TANGUT COMPONENT-095TANGUT COMPONEN" +
	"T-096TANGUT COMPONENT-097TANGUT COMPONENT-098TANGUT COMPONENT-099TANGUT " +
	"COMPONENT-100TANGUT COMPONENT-101TANGUT COMPONENT-102TANGUT COMPONENT-10" +
	"3TANGUT COMPONENT-104TANGUT COMPONENT-105TANGUT COMPONENT-106TANGUT COMP" +
	"ONENT-107TANGUT COMPONENT-108TANGUT COMPONENT-109TANGUT COMPONENT-110TAN" +
	"GUT COMPONENT-111TANGUT COMPONENT-112TANGUT COMPONENT-113TANGUT COMPONEN" +
	"T-114TANGUT COMPONENT-115TANGUT COMPONENT-116TANGUT COMPONENT-117TANGUT " +
	"COMPONENT-118TANGUT COMPONENT-119TANGUT COMPONENT-120TANGUT COMPONENT-12" +
	"1TANGUT COMPONENT-122TANGUT COMPONENT-123TANGUT COMPONENT-124TANGUT COMP" +
	"ONENT-125TANGUT COMPONENT-126TANGUT COMPONENT-127TANGUT COMPONENT-128TAN" +
	"GUT COMPONENT-129TANGUT COMPONENT-130TANGUT COMPONENT-131TANGUT COMPONEN" +
	"T-132TANGUT COMPONENT-133TANGUT COMPONENT-134TANGUT COMPONENT-135TANGUT " +
	"COMPONENT-136TANGUT COMPONENT-137TANGUT COMPONENT-138TANGUT COMPONENT-13" +
	"9TANGUT COMPONENT-140TANGUT COMPONENT-141TANGUT COMPONENT-142TANGUT COMP" +
	"ONENT-143TANGUT COMPONENT-144TANGUT COMPONENT-145TANGUT COMPONENT-146TAN" +
	"GUT COMPONENT-147TANGUT COMPONENT-148TANGUT COMPONENT-149TANGUT COMPONEN" +
	"T-150TANGUT COMPONENT-151TANGUT COMPONENT-152TANGUT COMPONENT-153TANGUT " +
	"COMPONENT-154TANGUT COMPONENT-155TANGUT COMPONENT-156TANGUT COMPONENT-15" +
	"7TANGUT COMPONENT-158TANGUT COMPONENT-159TANGUT COMPONENT-160TANGUT COMP" +
	"ONENT-161TANGUT COMPONENT-162TANGUT COMPONENT-163TANGUT COMPONENT-164TAN" +
	"GUT COMPONENT-165TANGUT COMPONENT-166TANGUT COMPONENT-167TANGUT COMPONEN" +
	"T-168TANGUT COMPONENT-169TANGUT COMPONENT-170TANGUT COMPONENT-171TANGUT " +
	"COMPONENT-172TANGUT COMPONENT-173TANGUT COMPONENT-174TANGUT COMPONENT-17" +
	"5TANGUT COMPONENT-176TANGUT COMPONENT-177TANGUT COMPONENT-178TANGUT COMP" +
	"ONENT-179TANGUT COMPONENT-180TANGUT COMPONENT-181TANGUT COMPONENT-182TAN" +
	"GUT COMPONENT-183TANGUT COMPONENT-184TANGUT COMPONENT-185TANGUT COMPONEN" +
	"T-186TANGUT COMPONENT-187TANGUT COMPONENT-188TANGUT COMPONENT-189TANGUT " +
	"COMPONENT-190TANGUT COMPONENT-191TANGUT COMPONENT-192TANGUT COMPONENT-19" +
	"3TANGUT COMPONENT-194TANGUT COMPONENT-195TANGUT COMPONENT-196TANGUT COMP" +
	"ONENT-197TANGUT COMPONENT-198TANGUT COMPONENT-199TANGUT COMPONENT-200TAN" +
	"GUT COMPONENT-201TANGUT COMPONENT-202TANGUT COMPONENT-203TANGUT COMPONEN" +
	"T-204TANGUT COMPONENT-205TANGUT COMPONENT-206TANGUT COMPONENT-207TANGUT " +
	"COMPONENT-208TANGUT COMPONENT-209TANGUT COMPONENT-210TANGUT COMPONENT-21" +
	"1TANGUT COMPONENT-212TANGUT COMPONENT-213TANGUT COMPONENT-214TANGUT COMP" +
	"ONENT-215TANGUT COMPONENT-216TANGUT COMPONENT-217TANGUT COMPONENT-218TAN" +
	"GUT COMPONENT-219TANGUT COMPONENT-220TANGUT COMPONENT-221TANGUT COMPONEN" +
	"T-222TANGUT COMPONENT-223TANGUT COMPONENT-224TANGUT COMPONENT-225TANGUT " +
	"COMPONENT-226TANGUT COMPONENT-227TANGUT COMPONENT-228TANGUT COMPONENT-22" +
	"9TANGUT COMPONENT-230TANGUT COMPONENT-231TANGUT COMPONENT-232TANGUT COMP" +
	"ONENT-233TANGUT COMPONENT-234TANGUT COMPONENT-235TANGUT COMPONENT-236TAN" +
	"GUT COMPONENT-237TANGUT COMPONENT-238TANGUT COMPONENT-239TANGUT COMPONEN" +
	"T-240TANGUT COMPONENT-241TANGUT COMPONENT-242TANGUT COMPONENT-243TANGUT " +
	"COMPONENT-244TANGUT COMPONENT-245TANGUT COMPONENT-246TANGUT COMPONENT-24") + ("" +
	"7TANGUT COMPONENT-248TANGUT COMPONENT-249TANGUT COMPONENT-250TANGUT COMP" +
	"ONENT-251TANGUT COMPONENT-252TANGUT COMPONENT-253TANGUT COMPONENT-254TAN" +
	"GUT COMPONENT-255TANGUT COMPONENT-256TANGUT COMPONENT-257TANGUT COMPONEN" +
	"T-258TANGUT COMPONENT-259TANGUT COMPONENT-260TANGUT COMPONENT-261TANGUT " +
	"COMPONENT-262TANGUT COMPONENT-263TANGUT COMPONENT-264TANGUT COMPONENT-26" +
	"5TANGUT COMPONENT-266TANGUT COMPONENT-267TANGUT COMPONENT-268TANGUT COMP" +
	"ONENT-269TANGUT COMPONENT-270TANGUT COMPONENT-271TANGUT COMPONENT-272TAN" +
	"GUT COMPONENT-273TANGUT COMPONENT-274TANGUT COMPONENT-275TANGUT COMPONEN" +
	"T-276TANGUT COMPONENT-277TANGUT COMPONENT-278TANGUT COMPONENT-279TANGUT " +
	"COMPONENT-280TANGUT COMPONENT-281TANGUT COMPONENT-282TANGUT COMPONENT-28" +
	"3TANGUT COMPONENT-284TANGUT COMPONENT-285TANGUT COMPONENT-286TANGUT COMP" +
	"ONENT-287TANGUT COMPONENT-288TANGUT COMPONENT-289TANGUT COMPONENT-290TAN" +
	"GUT COMPONENT-291TANGUT COMPONENT-292TANGUT COMPONENT-293TANGUT COMPONEN" +
	"T-294TANGUT COMPONENT-295TANGUT COMPONENT-296TANGUT COMPONENT-297TANGUT " +
	"COMPONENT-298TANGUT COMPONENT-299TANGUT COMPONENT-300TANGUT COMPONENT-30" +
	"1TANGUT COMPONENT-302TANGUT COMPONENT-303TANGUT COMPONENT-304TANGUT COMP" +
	"ONENT-305TANGUT COMPONENT-306TANGUT COMPONENT-307TANGUT COMPONENT-308TAN" +
	"GUT COMPONENT-309TANGUT COMPONENT-310TANGUT COMPONENT-311TANGUT COMPONEN" +
	"T-312TANGUT COMPONENT-313TANGUT COMPONENT-314TANGUT COMPONENT-315TANGUT " +
	"COMPONENT-316TANGUT COMPONENT-317TANGUT COMPONENT-318TANGUT COMPONENT-31" +
	"9TANGUT COMPONENT-320TANGUT COMPONENT-321TANGUT COMPONENT-322TANGUT COMP" +
	"ONENT-323TANGUT COMPONENT-324TANGUT COMPONENT-325TANGUT COMPONENT-326TAN" +
	"GUT COMPONENT-327TANGUT COMPONENT-328TANGUT COMPONENT-329TANGUT COMPONEN" +
	"T-330TANGUT COMPONENT-331TANGUT COMPONENT-332TANGUT COMPONENT-333TANGUT " +
	"COMPONENT-334TANGUT COMPONENT-335TANGUT COMPONENT-336TANGUT COMPONENT-33" +
	"7TANGUT COMPONENT-338TANGUT COMPONENT-339TANGUT COMPONENT-340TANGUT COMP" +
	"ONENT-341TANGUT COMPONENT-342TANGUT COMPONENT-343TANGUT COMPONENT-344TAN" +
	"GUT COMPONENT-345TANGUT COMPONENT-346TANGUT COMPONENT-347TANGUT COMPONEN" +
	"T-348TANGUT COMPONENT-349TANGUT COMPONENT-350TANGUT COMPONENT-351TANGUT " +
	"COMPONENT-352TANGUT COMPONENT-353TANGUT COMPONENT-354TANGUT COMPONENT-35" +
	"5TANGUT COMPONENT-356TANGUT COMPONENT-357TANGUT COMPONENT-358TANGUT COMP" +
	"ONENT-359TANGUT COMPONENT-360TANGUT COMPONENT-361TANGUT COMPONENT-362TAN" +
	"GUT COMPONENT-363TANGUT COMPONENT-364TANGUT COMPONENT-365TANGUT COMPONEN" +
	"T-366TANGUT COMPONENT-367TANGUT COMPONENT-368TANGUT COMPONENT-369TANGUT " +
	"COMPONENT-370TANGUT COMPONENT-371TANGUT COMPONENT-372TANGUT COMPONENT-37" +
	"3TANGUT COMPONENT-374TANGUT COMPONENT-375TANGUT COMPONENT-376TANGUT COMP" +
	"ONENT-377TANGUT COMPONENT-378TANGUT COMPONENT-379TANGUT COMPONENT-380TAN" +
	"GUT COMPONENT-381TANGUT COMPONENT-382TANGUT COMPONENT-383TANGUT COMPONEN" +
	"T-384TANGUT COMPONENT-385TANGUT COMPONENT-386TANGUT COMPONENT-387TANGUT " +
	"COMPONENT-388TANGUT COMPONENT-389TANGUT COMPONENT-390TANGUT COMPONENT-39" +
	"1TANGUT COMPONENT-392TANGUT COMPONENT-393TANGUT COMPONENT-394TANGUT COMP" +
	"ONENT-395TANGUT COMPONENT-396TANGUT COMPONENT-397TANGUT COMPONENT-398TAN" +
	"GUT COMPONENT-399TANGUT COMPONENT-400TANGUT COMPONENT-401TANGUT COMPONEN" +
	"T-402TANGUT COMPONENT-403TANGUT COMPONENT-404TANGUT COMPONENT-405TANGUT " +
	"COMPONENT-406TANGUT COMPONENT-407TANGUT COMPONENT-408TANGUT COMPONENT-40" +
	"9TANGUT COMPONENT-410TANGUT COMPONENT-411TANGUT COMPONENT-412TANGUT COMP" +
	"ONENT-413TANGUT COMPONENT-414TANGUT COMPONENT-415TANGUT COMPONENT-416TAN" +
	"GUT COMPONENT-417TANGUT COMPONENT-418TANGUT COMPONENT-419TANGUT COMPONEN" +
	"T-420TANGUT COMPONENT-421TANGUT COMPONENT-422TANGUT COMPONENT-423TANGUT " +
	"COMPONENT-424TANGUT COMPONENT-425TANGUT COMPONENT-426TANGUT COMPONENT-42" +
	"7TANGUT COMPONENT-428TANGUT COMPONENT-429TANGUT COMPONENT-430TANGUT COMP" +
	"ONENT-431TANGUT COMPONENT-432TANGUT COMPONENT-433TANGUT COMPONENT-434TAN" +
	"GUT COMPONENT-435TANGUT COMPONENT-436TANGUT COMPONENT-437TANGUT COMPONEN" +
	"T-438TANGUT COMPONENT-439TANGUT COMPONENT-440TANGUT COMPONENT-441TANGUT " +
	"COMPONENT-442TANGUT COMPONENT-443TANGUT COMPONENT-444TANGUT COMPONENT-44" +
	"5TANGUT COMPONENT-446TANGUT COMPONENT-447TANGUT COMPONENT-448TANGUT COMP" +
	"ONENT-449TANGUT COMPONENT-450TANGUT COMPONENT-451TANGUT COMPONENT-452TAN" +
	"GUT COMPONENT-453TANGUT COMPONENT-454TANGUT COMPONENT-455TANGUT COMPONEN" +
	"T-456TANGUT COMPONENT-457TANGUT COMPONENT-458TANGUT COMPONENT-459TANGUT " +
	"COMPONENT-460TANGUT COMPONENT-461TANGUT COMPONENT-462TANGUT COMPONENT-46" +
	"3TANGUT COMPONENT-464TANGUT COMPONENT-465TANGUT COMPONENT-466TANGUT COMP" +
	"ONENT-467TANGUT COMPONENT-468TANGUT COMPONENT-469TANGUT COMPONENT-470TAN" +
	"GUT COMPONENT-471TANGUT COMPONENT-472TANGUT COMPONENT-473TANGUT COMPONEN" +
	"T-474TANGUT COMPONENT-475TANGUT COMPONENT-476TANGUT COMPONENT-477TANGUT ") + ("" +
	"COMPONENT-478TANGUT COMPONENT-479TANGUT COMPONENT-480TANGUT COMPONENT-48" +
	"1TANGUT COMPONENT-482TANGUT COMPONENT-483TANGUT COMPONENT-484TANGUT COMP" +
	"ONENT-485TANGUT COMPONENT-486TANGUT COMPONENT-487TANGUT COMPONENT-488TAN" +
	"GUT COMPONENT-489TANGUT COMPONENT-490TANGUT COMPONENT-491TANGUT COMPONEN" +
	"T-492TANGUT COMPONENT-493TANGUT COMPONENT-494TANGUT COMPONENT-495TANGUT " +
	"COMPONENT-496TANGUT COMPONENT-497TANGUT COMPONENT-498TANGUT COMPONENT-49" +
	"9TANGUT COMPONENT-500TANGUT COMPONENT-501TANGUT COMPONENT-502TANGUT COMP" +
	"ONENT-503TANGUT COMPONENT-504TANGUT COMPONENT-505TANGUT COMPONENT-506TAN" +
	"GUT COMPONENT-507TANGUT COMPONENT-508TANGUT COMPONENT-509TANGUT COMPONEN" +
	"T-510TANGUT COMPONENT-511TANGUT COMPONENT-512TANGUT COMPONENT-513TANGUT " +
	"COMPONENT-514TANGUT COMPONENT-515TANGUT COMPONENT-516TANGUT COMPONENT-51" +
	"7TANGUT COMPONENT-518TANGUT COMPONENT-519TANGUT COMPONENT-520TANGUT COMP" +
	"ONENT-521TANGUT COMPONENT-522TANGUT COMPONENT-523TANGUT COMPONENT-524TAN" +
	"GUT COMPONENT-525TANGUT COMPONENT-526TANGUT COMPONENT-527TANGUT COMPONEN" +
	"T-528TANGUT COMPONENT-529TANGUT COMPONENT-530TANGUT COMPONENT-531TANGUT " +
	"COMPONENT-532TANGUT COMPONENT-533TANGUT COMPONENT-534TANGUT COMPONENT-53" +
	"5TANGUT COMPONENT-536TANGUT COMPONENT-537TANGUT COMPONENT-538TANGUT COMP" +
	"ONENT-539TANGUT COMPONENT-540TANGUT COMPONENT-541TANGUT COMPONENT-542TAN" +
	"GUT COMPONENT-543TANGUT COMPONENT-544TANGUT COMPONENT-545TANGUT COMPONEN" +
	"T-546TANGUT COMPONENT-547TANGUT COMPONENT-548TANGUT COMPONENT-549TANGUT " +
	"COMPONENT-550TANGUT COMPONENT-551TANGUT COMPONENT-552TANGUT COMPONENT-55" +
	"3TANGUT COMPONENT-554TANGUT COMPONENT-555TANGUT COMPONENT-556TANGUT COMP" +
	"ONENT-557TANGUT COMPONENT-558TANGUT COMPONENT-559TANGUT COMPONENT-560TAN" +
	"GUT COMPONENT-561TANGUT COMPONENT-562TANGUT COMPONENT-563TANGUT COMPONEN" +
	"T-564TANGUT COMPONENT-565TANGUT COMPONENT-566TANGUT COMPONENT-567TANGUT " +
	"COMPONENT-568TANGUT COMPONENT-569TANGUT COMPONENT-570TANGUT COMPONENT-57" +
	"1TANGUT COMPONENT-572TANGUT COMPONENT-573TANGUT COMPONENT-574TANGUT COMP" +
	"ONENT-575TANGUT COMPONENT-576TANGUT COMPONENT-577TANGUT COMPONENT-578TAN" +
	"GUT COMPONENT-579TANGUT COMPONENT-580TANGUT COMPONENT-581TANGUT COMPONEN" +
	"T-582TANGUT COMPONENT-583TANGUT COMPONENT-584TANGUT COMPONENT-585TANGUT " +
	"COMPONENT-586TANGUT COMPONENT-587TANGUT COMPONENT-588TANGUT COMPONENT-58" +
	"9TANGUT COMPONENT-590TANGUT COMPONENT-591TANGUT COMPONENT-592TANGUT COMP" +
	"ONENT-593TANGUT COMPONENT-594TANGUT COMPONENT-595TANGUT COMPONENT-596TAN" +
	"GUT COMPONENT-597TANGUT COMPONENT-598TANGUT COMPONENT-599TANGUT COMPONEN" +
	"T-600TANGUT COMPONENT-601TANGUT COMPONENT-602TANGUT COMPONENT-603TANGUT " +
	"COMPONENT-604TANGUT COMPONENT-605TANGUT COMPONENT-606TANGUT COMPONENT-60" +
	"7TANGUT COMPONENT-608TANGUT COMPONENT-609TANGUT COMPONENT-610TANGUT COMP" +
	"ONENT-611TANGUT COMPONENT-612TANGUT COMPONENT-613TANGUT COMPONENT-614TAN" +
	"GUT COMPONENT-615TANGUT COMPONENT-616TANGUT COMPONENT-617TANGUT COMPONEN" +
	"T-618TANGUT COMPONENT-619TANGUT COMPONENT-620TANGUT COMPONENT-621TANGUT " +
	"COMPONENT-622TANGUT COMPONENT-623TANGUT COMPONENT-624TANGUT COMPONENT-62" +
	"5TANGUT COMPONENT-626TANGUT COMPONENT-627TANGUT COMPONENT-628TANGUT COMP" +
	"ONENT-629TANGUT COMPONENT-630TANGUT COMPONENT-631TANGUT COMPONENT-632TAN" +
	"GUT COMPONENT-633TANGUT COMPONENT-634TANGUT COMPONENT-635TANGUT COMPONEN" +
	"T-636TANGUT COMPONENT-637TANGUT COMPONENT-638TANGUT COMPONENT-639TANGUT " +
	"COMPONENT-640TANGUT COMPONENT-641TANGUT COMPONENT-642TANGUT COMPONENT-64" +
	"3TANGUT COMPONENT-644TANGUT COMPONENT-645TANGUT COMPONENT-646TANGUT COMP" +
	"ONENT-647TANGUT COMPONENT-648TANGUT COMPONENT-649TANGUT COMPONENT-650TAN" +
	"GUT COMPONENT-651TANGUT COMPONENT-652TANGUT COMPONENT-653TANGUT COMPONEN" +
	"T-654TANGUT COMPONENT-655TANGUT COMPONENT-656TANGUT COMPONENT-657TANGUT " +
	"COMPONENT-658TANGUT COMPONENT-659TANGUT COMPONENT-660TANGUT COMPONENT-66" +
	"1TANGUT COMPONENT-662TANGUT COMPONENT-663TANGUT COMPONENT-664TANGUT COMP" +
	"ONENT-665TANGUT COMPONENT-666TANGUT COMPONENT-667TANGUT COMPONENT-668TAN" +
	"GUT COMPONENT-669TANGUT COMPONENT-670TANGUT COMPONENT-671TANGUT COMPONEN" +
	"T-672TANGUT COMPONENT-673TANGUT COMPONENT-674TANGUT COMPONENT-675TANGUT " +
	"COMPONENT-676TANGUT COMPONENT-677TANGUT COMPONENT-678TANGUT COMPONENT-67" +
	"9TANGUT COMPONENT-680TANGUT COMPONENT-681TANGUT COMPONENT-682TANGUT COMP" +
	"ONENT-683TANGUT COMPONENT-684TANGUT COMPONENT-685TANGUT COMPONENT-686TAN" +
	"GUT COMPONENT-687TANGUT COMPONENT-688TANGUT COMPONENT-689TANGUT COMPONEN" +
	"T-690TANGUT COMPONENT-691TANGUT COMPONENT-692TANGUT COMPONENT-693TANGUT " +
	"COMPONENT-694TANGUT COMPONENT-695TANGUT COMPONENT-696TANGUT COMPONENT-69" +
	"7TANGUT COMPONENT-698TANGUT COMPONENT-699TANGUT COMPONENT-700TANGUT COMP" +
	"ONENT-701TANGUT COMPONENT-702TANGUT COMPONENT-703TANGUT COMPONENT-704TAN" +
	"GUT COMPONENT-705TANGUT COMPONENT-706TANGUT COMPONENT-707TANGUT COMPONEN") + ("" +
	"T-708TANGUT COMPONENT-709TANGUT COMPONENT-710TANGUT COMPONENT-711TANGUT " +
	"COMPONENT-712TANGUT COMPONENT-713TANGUT COMPONENT-714TANGUT COMPONENT-71" +
	"5TANGUT COMPONENT-716TANGUT COMPONENT-717TANGUT COMPONENT-718TANGUT COMP" +
	"ONENT-719TANGUT COMPONENT-720TANGUT COMPONENT-721TANGUT COMPONENT-722TAN" +
	"GUT COMPONENT-723TANGUT COMPONENT-724TANGUT COMPONENT-725TANGUT COMPONEN" +
	"T-726TANGUT COMPONENT-727TANGUT COMPONENT-728TANGUT COMPONENT-729TANGUT " +
	"COMPONENT-730TANGUT COMPONENT-731TANGUT COMPONENT-732TANGUT COMPONENT-73" +
	"3TANGUT COMPONENT-734TANGUT COMPONENT-735TANGUT COMPONENT-736TANGUT COMP" +
	"ONENT-737TANGUT COMPONENT-738TANGUT COMPONENT-739TANGUT COMPONENT-740TAN" +
	"GUT COMPONENT-741TANGUT COMPONENT-742TANGUT COMPONENT-743TANGUT COMPONEN" +
	"T-744TANGUT COMPONENT-745TANGUT COMPONENT-746TANGUT COMPONENT-747TANGUT " +
	"COMPONENT-748TANGUT COMPONENT-749TANGUT COMPONENT-750TANGUT COMPONENT-75" +
	"1TANGUT COMPONENT-752TANGUT COMPONENT-753TANGUT COMPONENT-754TANGUT COMP" +
	"ONENT-755KATAKANA LETTER ARCHAIC EHIRAGANA LETTER ARCHAIC YEDUPLOYAN LET" +
	"TER HDUPLOYAN LETTER XDUPLOYAN LETTER PDUPLOYAN LETTER TDUPLOYAN LETTER " +
	"FDUPLOYAN LETTER KDUPLOYAN LETTER LDUPLOYAN LETTER BDUPLOYAN LETTER DDUP" +
	"LOYAN LETTER VDUPLOYAN LETTER GDUPLOYAN LETTER RDUPLOYAN LETTER P NDUPLO" +
	"YAN LETTER D SDUPLOYAN LETTER F NDUPLOYAN LETTER K MDUPLOYAN LETTER R SD" +
	"UPLOYAN LETTER THDUPLOYAN LETTER SLOAN DHDUPLOYAN LETTER DHDUPLOYAN LETT" +
	"ER KKDUPLOYAN LETTER SLOAN JDUPLOYAN LETTER HLDUPLOYAN LETTER LHDUPLOYAN" +
	" LETTER RHDUPLOYAN LETTER MDUPLOYAN LETTER NDUPLOYAN LETTER JDUPLOYAN LE" +
	"TTER SDUPLOYAN LETTER M NDUPLOYAN LETTER N MDUPLOYAN LETTER J MDUPLOYAN " +
	"LETTER S JDUPLOYAN LETTER M WITH DOTDUPLOYAN LETTER N WITH DOTDUPLOYAN L" +
	"ETTER J WITH DOTDUPLOYAN LETTER J WITH DOTS INSIDE AND ABOVEDUPLOYAN LET" +
	"TER S WITH DOTDUPLOYAN LETTER S WITH DOT BELOWDUPLOYAN LETTER M SDUPLOYA" +
	"N LETTER N SDUPLOYAN LETTER J SDUPLOYAN LETTER S SDUPLOYAN LETTER M N SD" +
	"UPLOYAN LETTER N M SDUPLOYAN LETTER J M SDUPLOYAN LETTER S J SDUPLOYAN L" +
	"ETTER J S WITH DOTDUPLOYAN LETTER J NDUPLOYAN LETTER J N SDUPLOYAN LETTE" +
	"R S TDUPLOYAN LETTER S T RDUPLOYAN LETTER S PDUPLOYAN LETTER S P RDUPLOY" +
	"AN LETTER T SDUPLOYAN LETTER T R SDUPLOYAN LETTER WDUPLOYAN LETTER WHDUP" +
	"LOYAN LETTER W RDUPLOYAN LETTER S NDUPLOYAN LETTER S MDUPLOYAN LETTER K " +
	"R SDUPLOYAN LETTER G R SDUPLOYAN LETTER S KDUPLOYAN LETTER S K RDUPLOYAN" +
	" LETTER ADUPLOYAN LETTER SLOAN OWDUPLOYAN LETTER OADUPLOYAN LETTER ODUPL" +
	"OYAN LETTER AOUDUPLOYAN LETTER IDUPLOYAN LETTER EDUPLOYAN LETTER IEDUPLO" +
	"YAN LETTER SHORT IDUPLOYAN LETTER UIDUPLOYAN LETTER EEDUPLOYAN LETTER SL" +
	"OAN EHDUPLOYAN LETTER ROMANIAN IDUPLOYAN LETTER SLOAN EEDUPLOYAN LETTER " +
	"LONG IDUPLOYAN LETTER YEDUPLOYAN LETTER UDUPLOYAN LETTER EUDUPLOYAN LETT" +
	"ER XWDUPLOYAN LETTER U NDUPLOYAN LETTER LONG UDUPLOYAN LETTER ROMANIAN U" +
	"DUPLOYAN LETTER UHDUPLOYAN LETTER SLOAN UDUPLOYAN LETTER OOHDUPLOYAN LET" +
	"TER OWDUPLOYAN LETTER OUDUPLOYAN LETTER WADUPLOYAN LETTER WODUPLOYAN LET" +
	"TER WIDUPLOYAN LETTER WEIDUPLOYAN LETTER WOWDUPLOYAN LETTER NASAL UDUPLO" +
	"YAN LETTER NASAL ODUPLOYAN LETTER NASAL IDUPLOYAN LETTER NASAL ADUPLOYAN" +
	" LETTER PERNIN ANDUPLOYAN LETTER PERNIN AMDUPLOYAN LETTER SLOAN ENDUPLOY" +
	"AN LETTER SLOAN ANDUPLOYAN LETTER SLOAN ONDUPLOYAN LETTER VOCALIC MDUPLO" +
	"YAN AFFIX LEFT HORIZONTAL SECANTDUPLOYAN AFFIX MID HORIZONTAL SECANTDUPL" +
	"OYAN AFFIX RIGHT HORIZONTAL SECANTDUPLOYAN AFFIX LOW VERTICAL SECANTDUPL" +
	"OYAN AFFIX MID VERTICAL SECANTDUPLOYAN AFFIX HIGH VERTICAL SECANTDUPLOYA" +
	"N AFFIX ATTACHED SECANTDUPLOYAN AFFIX ATTACHED LEFT-TO-RIGHT SECANTDUPLO" +
	"YAN AFFIX ATTACHED TANGENTDUPLOYAN AFFIX ATTACHED TAILDUPLOYAN AFFIX ATT" +
	"ACHED E HOOKDUPLOYAN AFFIX ATTACHED I HOOKDUPLOYAN AFFIX ATTACHED TANGEN" +
	"T HOOKDUPLOYAN AFFIX HIGH ACUTEDUPLOYAN AFFIX HIGH TIGHT ACUTEDUPLOYAN A" +
	"FFIX HIGH GRAVEDUPLOYAN AFFIX HIGH LONG GRAVEDUPLOYAN AFFIX HIGH DOTDUPL" +
	"OYAN AFFIX HIGH CIRCLEDUPLOYAN AFFIX HIGH LINEDUPLOYAN AFFIX HIGH WAVEDU" +
	"PLOYAN AFFIX HIGH VERTICALDUPLOYAN AFFIX LOW ACUTEDUPLOYAN AFFIX LOW TIG" +
	"HT ACUTEDUPLOYAN AFFIX LOW GRAVEDUPLOYAN AFFIX LOW LONG GRAVEDUPLOYAN AF" +
	"FIX LOW DOTDUPLOYAN AFFIX LOW CIRCLEDUPLOYAN AFFIX LOW LINEDUPLOYAN AFFI" +
	"X LOW WAVEDUPLOYAN AFFIX LOW VERTICALDUPLOYAN AFFIX LOW ARROWDUPLOYAN SI" +
	"GN O WITH CROSSDUPLOYAN THICK LETTER SELECTORDUPLOYAN DOUBLE MARKDUPLOYA" +
	"N PUNCTUATION CHINOOK FULL STOPSHORTHAND FORMAT LETTER OVERLAPSHORTHAND " +
	"FORMAT CONTINUING OVERLAPSHORTHAND FORMAT DOWN STEPSHORTHAND FORMAT UP S" +
	"TEPBYZANTINE MUSICAL SYMBOL PSILIBYZANTINE MUSICAL SYMBOL DASEIABYZANTIN" +
	"E MUSICAL SYMBOL PERISPOMENIBYZANTINE MUSICAL SYMBOL OXEIA EKFONITIKONBY" +
	"ZANTINE MUSICAL SYMBOL OXEIA DIPLIBYZANTINE MUSICAL SYMBOL VAREIA EKFONI" +
	"TIKONBYZANTINE MUSICAL SYMBOL VAREIA DIPLIBYZANTINE MUSICAL SYMBOL KATHI") + ("" +
	"STIBYZANTINE MUSICAL SYMBOL SYRMATIKIBYZANTINE MUSICAL SYMBOL PARAKLITIK" +
	"IBYZANTINE MUSICAL SYMBOL YPOKRISISBYZANTINE MUSICAL SYMBOL YPOKRISIS DI" +
	"PLIBYZANTINE MUSICAL SYMBOL KREMASTIBYZANTINE MUSICAL SYMBOL APESO EKFON" +
	"ITIKONBYZANTINE MUSICAL SYMBOL EXO EKFONITIKONBYZANTINE MUSICAL SYMBOL T" +
	"ELEIABYZANTINE MUSICAL SYMBOL KENTIMATABYZANTINE MUSICAL SYMBOL APOSTROF" +
	"OSBYZANTINE MUSICAL SYMBOL APOSTROFOS DIPLIBYZANTINE MUSICAL SYMBOL SYNE" +
	"VMABYZANTINE MUSICAL SYMBOL THITABYZANTINE MUSICAL SYMBOL OLIGON ARCHAIO" +
	"NBYZANTINE MUSICAL SYMBOL GORGON ARCHAIONBYZANTINE MUSICAL SYMBOL PSILON" +
	"BYZANTINE MUSICAL SYMBOL CHAMILONBYZANTINE MUSICAL SYMBOL VATHYBYZANTINE" +
	" MUSICAL SYMBOL ISON ARCHAIONBYZANTINE MUSICAL SYMBOL KENTIMA ARCHAIONBY" +
	"ZANTINE MUSICAL SYMBOL KENTIMATA ARCHAIONBYZANTINE MUSICAL SYMBOL SAXIMA" +
	"TABYZANTINE MUSICAL SYMBOL PARICHONBYZANTINE MUSICAL SYMBOL STAVROS APOD" +
	"EXIABYZANTINE MUSICAL SYMBOL OXEIAI ARCHAIONBYZANTINE MUSICAL SYMBOL VAR" +
	"EIAI ARCHAIONBYZANTINE MUSICAL SYMBOL APODERMA ARCHAIONBYZANTINE MUSICAL" +
	" SYMBOL APOTHEMABYZANTINE MUSICAL SYMBOL KLASMABYZANTINE MUSICAL SYMBOL " +
	"REVMABYZANTINE MUSICAL SYMBOL PIASMA ARCHAIONBYZANTINE MUSICAL SYMBOL TI" +
	"NAGMABYZANTINE MUSICAL SYMBOL ANATRICHISMABYZANTINE MUSICAL SYMBOL SEISM" +
	"ABYZANTINE MUSICAL SYMBOL SYNAGMA ARCHAIONBYZANTINE MUSICAL SYMBOL SYNAG" +
	"MA META STAVROUBYZANTINE MUSICAL SYMBOL OYRANISMA ARCHAIONBYZANTINE MUSI" +
	"CAL SYMBOL THEMABYZANTINE MUSICAL SYMBOL LEMOIBYZANTINE MUSICAL SYMBOL D" +
	"YOBYZANTINE MUSICAL SYMBOL TRIABYZANTINE MUSICAL SYMBOL TESSERABYZANTINE" +
	" MUSICAL SYMBOL KRATIMATABYZANTINE MUSICAL SYMBOL APESO EXO NEOBYZANTINE" +
	" MUSICAL SYMBOL FTHORA ARCHAIONBYZANTINE MUSICAL SYMBOL IMIFTHORABYZANTI" +
	"NE MUSICAL SYMBOL TROMIKON ARCHAIONBYZANTINE MUSICAL SYMBOL KATAVA TROMI" +
	"KONBYZANTINE MUSICAL SYMBOL PELASTONBYZANTINE MUSICAL SYMBOL PSIFISTONBY" +
	"ZANTINE MUSICAL SYMBOL KONTEVMABYZANTINE MUSICAL SYMBOL CHOREVMA ARCHAIO" +
	"NBYZANTINE MUSICAL SYMBOL RAPISMABYZANTINE MUSICAL SYMBOL PARAKALESMA AR" +
	"CHAIONBYZANTINE MUSICAL SYMBOL PARAKLITIKI ARCHAIONBYZANTINE MUSICAL SYM" +
	"BOL ICHADINBYZANTINE MUSICAL SYMBOL NANABYZANTINE MUSICAL SYMBOL PETASMA" +
	"BYZANTINE MUSICAL SYMBOL KONTEVMA ALLOBYZANTINE MUSICAL SYMBOL TROMIKON " +
	"ALLOBYZANTINE MUSICAL SYMBOL STRAGGISMATABYZANTINE MUSICAL SYMBOL GRONTH" +
	"ISMATABYZANTINE MUSICAL SYMBOL ISON NEOBYZANTINE MUSICAL SYMBOL OLIGON N" +
	"EOBYZANTINE MUSICAL SYMBOL OXEIA NEOBYZANTINE MUSICAL SYMBOL PETASTIBYZA" +
	"NTINE MUSICAL SYMBOL KOUFISMABYZANTINE MUSICAL SYMBOL PETASTOKOUFISMABYZ" +
	"ANTINE MUSICAL SYMBOL KRATIMOKOUFISMABYZANTINE MUSICAL SYMBOL PELASTON N" +
	"EOBYZANTINE MUSICAL SYMBOL KENTIMATA NEO ANOBYZANTINE MUSICAL SYMBOL KEN" +
	"TIMA NEO ANOBYZANTINE MUSICAL SYMBOL YPSILIBYZANTINE MUSICAL SYMBOL APOS" +
	"TROFOS NEOBYZANTINE MUSICAL SYMBOL APOSTROFOI SYNDESMOS NEOBYZANTINE MUS" +
	"ICAL SYMBOL YPORROIBYZANTINE MUSICAL SYMBOL KRATIMOYPORROONBYZANTINE MUS" +
	"ICAL SYMBOL ELAFRONBYZANTINE MUSICAL SYMBOL CHAMILIBYZANTINE MUSICAL SYM" +
	"BOL MIKRON ISONBYZANTINE MUSICAL SYMBOL VAREIA NEOBYZANTINE MUSICAL SYMB" +
	"OL PIASMA NEOBYZANTINE MUSICAL SYMBOL PSIFISTON NEOBYZANTINE MUSICAL SYM" +
	"BOL OMALONBYZANTINE MUSICAL SYMBOL ANTIKENOMABYZANTINE MUSICAL SYMBOL LY" +
	"GISMABYZANTINE MUSICAL SYMBOL PARAKLITIKI NEOBYZANTINE MUSICAL SYMBOL PA" +
	"RAKALESMA NEOBYZANTINE MUSICAL SYMBOL ETERON PARAKALESMABYZANTINE MUSICA" +
	"L SYMBOL KYLISMABYZANTINE MUSICAL SYMBOL ANTIKENOKYLISMABYZANTINE MUSICA" +
	"L SYMBOL TROMIKON NEOBYZANTINE MUSICAL SYMBOL EKSTREPTONBYZANTINE MUSICA" +
	"L SYMBOL SYNAGMA NEOBYZANTINE MUSICAL SYMBOL SYRMABYZANTINE MUSICAL SYMB" +
	"OL CHOREVMA NEOBYZANTINE MUSICAL SYMBOL EPEGERMABYZANTINE MUSICAL SYMBOL" +
	" SEISMA NEOBYZANTINE MUSICAL SYMBOL XIRON KLASMABYZANTINE MUSICAL SYMBOL" +
	" TROMIKOPSIFISTONBYZANTINE MUSICAL SYMBOL PSIFISTOLYGISMABYZANTINE MUSIC" +
	"AL SYMBOL TROMIKOLYGISMABYZANTINE MUSICAL SYMBOL TROMIKOPARAKALESMABYZAN" +
	"TINE MUSICAL SYMBOL PSIFISTOPARAKALESMABYZANTINE MUSICAL SYMBOL TROMIKOS" +
	"YNAGMABYZANTINE MUSICAL SYMBOL PSIFISTOSYNAGMABYZANTINE MUSICAL SYMBOL G" +
	"ORGOSYNTHETONBYZANTINE MUSICAL SYMBOL ARGOSYNTHETONBYZANTINE MUSICAL SYM" +
	"BOL ETERON ARGOSYNTHETONBYZANTINE MUSICAL SYMBOL OYRANISMA NEOBYZANTINE " +
	"MUSICAL SYMBOL THEMATISMOS ESOBYZANTINE MUSICAL SYMBOL THEMATISMOS EXOBY" +
	"ZANTINE MUSICAL SYMBOL THEMA APLOUNBYZANTINE MUSICAL SYMBOL THES KAI APO" +
	"THESBYZANTINE MUSICAL SYMBOL KATAVASMABYZANTINE MUSICAL SYMBOL ENDOFONON" +
	"BYZANTINE MUSICAL SYMBOL YFEN KATOBYZANTINE MUSICAL SYMBOL YFEN ANOBYZAN" +
	"TINE MUSICAL SYMBOL STAVROSBYZANTINE MUSICAL SYMBOL KLASMA ANOBYZANTINE " +
	"MUSICAL SYMBOL DIPLI ARCHAIONBYZANTINE MUSICAL SYMBOL KRATIMA ARCHAIONBY" +
	"ZANTINE MUSICAL SYMBOL KRATIMA ALLOBYZANTINE MUSICAL SYMBOL KRATIMA NEOB" +
	"YZANTINE MUSICAL SYMBOL APODERMA NEOBYZANTINE MUSICAL SYMBOL APLIBYZANTI") + ("" +
	"NE MUSICAL SYMBOL DIPLIBYZANTINE MUSICAL SYMBOL TRIPLIBYZANTINE MUSICAL " +
	"SYMBOL TETRAPLIBYZANTINE MUSICAL SYMBOL KORONISBYZANTINE MUSICAL SYMBOL " +
	"LEIMMA ENOS CHRONOUBYZANTINE MUSICAL SYMBOL LEIMMA DYO CHRONONBYZANTINE " +
	"MUSICAL SYMBOL LEIMMA TRION CHRONONBYZANTINE MUSICAL SYMBOL LEIMMA TESSA" +
	"RON CHRONONBYZANTINE MUSICAL SYMBOL LEIMMA IMISEOS CHRONOUBYZANTINE MUSI" +
	"CAL SYMBOL GORGON NEO ANOBYZANTINE MUSICAL SYMBOL GORGON PARESTIGMENON A" +
	"RISTERABYZANTINE MUSICAL SYMBOL GORGON PARESTIGMENON DEXIABYZANTINE MUSI" +
	"CAL SYMBOL DIGORGONBYZANTINE MUSICAL SYMBOL DIGORGON PARESTIGMENON ARIST" +
	"ERA KATOBYZANTINE MUSICAL SYMBOL DIGORGON PARESTIGMENON ARISTERA ANOBYZA" +
	"NTINE MUSICAL SYMBOL DIGORGON PARESTIGMENON DEXIABYZANTINE MUSICAL SYMBO" +
	"L TRIGORGONBYZANTINE MUSICAL SYMBOL ARGONBYZANTINE MUSICAL SYMBOL IMIDIA" +
	"RGONBYZANTINE MUSICAL SYMBOL DIARGONBYZANTINE MUSICAL SYMBOL AGOGI POLI " +
	"ARGIBYZANTINE MUSICAL SYMBOL AGOGI ARGOTERIBYZANTINE MUSICAL SYMBOL AGOG" +
	"I ARGIBYZANTINE MUSICAL SYMBOL AGOGI METRIABYZANTINE MUSICAL SYMBOL AGOG" +
	"I MESIBYZANTINE MUSICAL SYMBOL AGOGI GORGIBYZANTINE MUSICAL SYMBOL AGOGI" +
	" GORGOTERIBYZANTINE MUSICAL SYMBOL AGOGI POLI GORGIBYZANTINE MUSICAL SYM" +
	"BOL MARTYRIA PROTOS ICHOSBYZANTINE MUSICAL SYMBOL MARTYRIA ALLI PROTOS I" +
	"CHOSBYZANTINE MUSICAL SYMBOL MARTYRIA DEYTEROS ICHOSBYZANTINE MUSICAL SY" +
	"MBOL MARTYRIA ALLI DEYTEROS ICHOSBYZANTINE MUSICAL SYMBOL MARTYRIA TRITO" +
	"S ICHOSBYZANTINE MUSICAL SYMBOL MARTYRIA TRIFONIASBYZANTINE MUSICAL SYMB" +
	"OL MARTYRIA TETARTOS ICHOSBYZANTINE MUSICAL SYMBOL MARTYRIA TETARTOS LEG" +
	"ETOS ICHOSBYZANTINE MUSICAL SYMBOL MARTYRIA LEGETOS ICHOSBYZANTINE MUSIC" +
	"AL SYMBOL MARTYRIA PLAGIOS ICHOSBYZANTINE MUSICAL SYMBOL ISAKIA TELOUS I" +
	"CHIMATOSBYZANTINE MUSICAL SYMBOL APOSTROFOI TELOUS ICHIMATOSBYZANTINE MU" +
	"SICAL SYMBOL FANEROSIS TETRAFONIASBYZANTINE MUSICAL SYMBOL FANEROSIS MON" +
	"OFONIASBYZANTINE MUSICAL SYMBOL FANEROSIS DIFONIASBYZANTINE MUSICAL SYMB" +
	"OL MARTYRIA VARYS ICHOSBYZANTINE MUSICAL SYMBOL MARTYRIA PROTOVARYS ICHO" +
	"SBYZANTINE MUSICAL SYMBOL MARTYRIA PLAGIOS TETARTOS ICHOSBYZANTINE MUSIC" +
	"AL SYMBOL GORTHMIKON N APLOUNBYZANTINE MUSICAL SYMBOL GORTHMIKON N DIPLO" +
	"UNBYZANTINE MUSICAL SYMBOL ENARXIS KAI FTHORA VOUBYZANTINE MUSICAL SYMBO" +
	"L IMIFONONBYZANTINE MUSICAL SYMBOL IMIFTHORONBYZANTINE MUSICAL SYMBOL FT" +
	"HORA ARCHAION DEYTEROU ICHOUBYZANTINE MUSICAL SYMBOL FTHORA DIATONIKI PA" +
	"BYZANTINE MUSICAL SYMBOL FTHORA DIATONIKI NANABYZANTINE MUSICAL SYMBOL F" +
	"THORA NAOS ICHOSBYZANTINE MUSICAL SYMBOL FTHORA DIATONIKI DIBYZANTINE MU" +
	"SICAL SYMBOL FTHORA SKLIRON DIATONON DIBYZANTINE MUSICAL SYMBOL FTHORA D" +
	"IATONIKI KEBYZANTINE MUSICAL SYMBOL FTHORA DIATONIKI ZOBYZANTINE MUSICAL" +
	" SYMBOL FTHORA DIATONIKI NI KATOBYZANTINE MUSICAL SYMBOL FTHORA DIATONIK" +
	"I NI ANOBYZANTINE MUSICAL SYMBOL FTHORA MALAKON CHROMA DIFONIASBYZANTINE" +
	" MUSICAL SYMBOL FTHORA MALAKON CHROMA MONOFONIASBYZANTINE MUSICAL SYMBOL" +
	" FHTORA SKLIRON CHROMA VASISBYZANTINE MUSICAL SYMBOL FTHORA SKLIRON CHRO" +
	"MA SYNAFIBYZANTINE MUSICAL SYMBOL FTHORA NENANOBYZANTINE MUSICAL SYMBOL " +
	"CHROA ZYGOSBYZANTINE MUSICAL SYMBOL CHROA KLITONBYZANTINE MUSICAL SYMBOL" +
	" CHROA SPATHIBYZANTINE MUSICAL SYMBOL FTHORA I YFESIS TETARTIMORIONBYZAN" +
	"TINE MUSICAL SYMBOL FTHORA ENARMONIOS ANTIFONIABYZANTINE MUSICAL SYMBOL " +
	"YFESIS TRITIMORIONBYZANTINE MUSICAL SYMBOL DIESIS TRITIMORIONBYZANTINE M" +
	"USICAL SYMBOL DIESIS TETARTIMORIONBYZANTINE MUSICAL SYMBOL DIESIS APLI D" +
	"YO DODEKATABYZANTINE MUSICAL SYMBOL DIESIS MONOGRAMMOS TESSERA DODEKATAB" +
	"YZANTINE MUSICAL SYMBOL DIESIS DIGRAMMOS EX DODEKATABYZANTINE MUSICAL SY" +
	"MBOL DIESIS TRIGRAMMOS OKTO DODEKATABYZANTINE MUSICAL SYMBOL YFESIS APLI" +
	" DYO DODEKATABYZANTINE MUSICAL SYMBOL YFESIS MONOGRAMMOS TESSERA DODEKAT" +
	"ABYZANTINE MUSICAL SYMBOL YFESIS DIGRAMMOS EX DODEKATABYZANTINE MUSICAL " +
	"SYMBOL YFESIS TRIGRAMMOS OKTO DODEKATABYZANTINE MUSICAL SYMBOL GENIKI DI" +
	"ESISBYZANTINE MUSICAL SYMBOL GENIKI YFESISBYZANTINE MUSICAL SYMBOL DIAST" +
	"OLI APLI MIKRIBYZANTINE MUSICAL SYMBOL DIASTOLI APLI MEGALIBYZANTINE MUS" +
	"ICAL SYMBOL DIASTOLI DIPLIBYZANTINE MUSICAL SYMBOL DIASTOLI THESEOSBYZAN" +
	"TINE MUSICAL SYMBOL SIMANSIS THESEOSBYZANTINE MUSICAL SYMBOL SIMANSIS TH" +
	"ESEOS DISIMOUBYZANTINE MUSICAL SYMBOL SIMANSIS THESEOS TRISIMOUBYZANTINE" +
	" MUSICAL SYMBOL SIMANSIS THESEOS TETRASIMOUBYZANTINE MUSICAL SYMBOL SIMA" +
	"NSIS ARSEOSBYZANTINE MUSICAL SYMBOL SIMANSIS ARSEOS DISIMOUBYZANTINE MUS" +
	"ICAL SYMBOL SIMANSIS ARSEOS TRISIMOUBYZANTINE MUSICAL SYMBOL SIMANSIS AR" +
	"SEOS TETRASIMOUBYZANTINE MUSICAL SYMBOL DIGRAMMA GGBYZANTINE MUSICAL SYM" +
	"BOL DIFTOGGOS OUBYZANTINE MUSICAL SYMBOL STIGMABYZANTINE MUSICAL SYMBOL " +
	"ARKTIKO PABYZANTINE MUSICAL SYMBOL ARKTIKO VOUBYZANTINE MUSICAL SYMBOL A" +
	"RKTIKO GABYZANTINE MUSICAL SYMBOL ARKTIKO DIBYZANTINE MUSICAL SYMBOL ARK") + ("" +
	"TIKO KEBYZANTINE MUSICAL SYMBOL ARKTIKO ZOBYZANTINE MUSICAL SYMBOL ARKTI" +
	"KO NIBYZANTINE MUSICAL SYMBOL KENTIMATA NEO MESOBYZANTINE MUSICAL SYMBOL" +
	" KENTIMA NEO MESOBYZANTINE MUSICAL SYMBOL KENTIMATA NEO KATOBYZANTINE MU" +
	"SICAL SYMBOL KENTIMA NEO KATOBYZANTINE MUSICAL SYMBOL KLASMA KATOBYZANTI" +
	"NE MUSICAL SYMBOL GORGON NEO KATOMUSICAL SYMBOL SINGLE BARLINEMUSICAL SY" +
	"MBOL DOUBLE BARLINEMUSICAL SYMBOL FINAL BARLINEMUSICAL SYMBOL REVERSE FI" +
	"NAL BARLINEMUSICAL SYMBOL DASHED BARLINEMUSICAL SYMBOL SHORT BARLINEMUSI" +
	"CAL SYMBOL LEFT REPEAT SIGNMUSICAL SYMBOL RIGHT REPEAT SIGNMUSICAL SYMBO" +
	"L REPEAT DOTSMUSICAL SYMBOL DAL SEGNOMUSICAL SYMBOL DA CAPOMUSICAL SYMBO" +
	"L SEGNOMUSICAL SYMBOL CODAMUSICAL SYMBOL REPEATED FIGURE-1MUSICAL SYMBOL" +
	" REPEATED FIGURE-2MUSICAL SYMBOL REPEATED FIGURE-3MUSICAL SYMBOL FERMATA" +
	"MUSICAL SYMBOL FERMATA BELOWMUSICAL SYMBOL BREATH MARKMUSICAL SYMBOL CAE" +
	"SURAMUSICAL SYMBOL BRACEMUSICAL SYMBOL BRACKETMUSICAL SYMBOL ONE-LINE ST" +
	"AFFMUSICAL SYMBOL TWO-LINE STAFFMUSICAL SYMBOL THREE-LINE STAFFMUSICAL S" +
	"YMBOL FOUR-LINE STAFFMUSICAL SYMBOL FIVE-LINE STAFFMUSICAL SYMBOL SIX-LI" +
	"NE STAFFMUSICAL SYMBOL SIX-STRING FRETBOARDMUSICAL SYMBOL FOUR-STRING FR" +
	"ETBOARDMUSICAL SYMBOL G CLEFMUSICAL SYMBOL G CLEF OTTAVA ALTAMUSICAL SYM" +
	"BOL G CLEF OTTAVA BASSAMUSICAL SYMBOL C CLEFMUSICAL SYMBOL F CLEFMUSICAL" +
	" SYMBOL F CLEF OTTAVA ALTAMUSICAL SYMBOL F CLEF OTTAVA BASSAMUSICAL SYMB" +
	"OL DRUM CLEF-1MUSICAL SYMBOL DRUM CLEF-2MUSICAL SYMBOL MULTIPLE MEASURE " +
	"RESTMUSICAL SYMBOL DOUBLE SHARPMUSICAL SYMBOL DOUBLE FLATMUSICAL SYMBOL " +
	"FLAT UPMUSICAL SYMBOL FLAT DOWNMUSICAL SYMBOL NATURAL UPMUSICAL SYMBOL N" +
	"ATURAL DOWNMUSICAL SYMBOL SHARP UPMUSICAL SYMBOL SHARP DOWNMUSICAL SYMBO" +
	"L QUARTER TONE SHARPMUSICAL SYMBOL QUARTER TONE FLATMUSICAL SYMBOL COMMO" +
	"N TIMEMUSICAL SYMBOL CUT TIMEMUSICAL SYMBOL OTTAVA ALTAMUSICAL SYMBOL OT" +
	"TAVA BASSAMUSICAL SYMBOL QUINDICESIMA ALTAMUSICAL SYMBOL QUINDICESIMA BA" +
	"SSAMUSICAL SYMBOL MULTI RESTMUSICAL SYMBOL WHOLE RESTMUSICAL SYMBOL HALF" +
	" RESTMUSICAL SYMBOL QUARTER RESTMUSICAL SYMBOL EIGHTH RESTMUSICAL SYMBOL" +
	" SIXTEENTH RESTMUSICAL SYMBOL THIRTY-SECOND RESTMUSICAL SYMBOL SIXTY-FOU" +
	"RTH RESTMUSICAL SYMBOL ONE HUNDRED TWENTY-EIGHTH RESTMUSICAL SYMBOL X NO" +
	"TEHEADMUSICAL SYMBOL PLUS NOTEHEADMUSICAL SYMBOL CIRCLE X NOTEHEADMUSICA" +
	"L SYMBOL SQUARE NOTEHEAD WHITEMUSICAL SYMBOL SQUARE NOTEHEAD BLACKMUSICA" +
	"L SYMBOL TRIANGLE NOTEHEAD UP WHITEMUSICAL SYMBOL TRIANGLE NOTEHEAD UP B" +
	"LACKMUSICAL SYMBOL TRIANGLE NOTEHEAD LEFT WHITEMUSICAL SYMBOL TRIANGLE N" +
	"OTEHEAD LEFT BLACKMUSICAL SYMBOL TRIANGLE NOTEHEAD RIGHT WHITEMUSICAL SY" +
	"MBOL TRIANGLE NOTEHEAD RIGHT BLACKMUSICAL SYMBOL TRIANGLE NOTEHEAD DOWN " +
	"WHITEMUSICAL SYMBOL TRIANGLE NOTEHEAD DOWN BLACKMUSICAL SYMBOL TRIANGLE " +
	"NOTEHEAD UP RIGHT WHITEMUSICAL SYMBOL TRIANGLE NOTEHEAD UP RIGHT BLACKMU" +
	"SICAL SYMBOL MOON NOTEHEAD WHITEMUSICAL SYMBOL MOON NOTEHEAD BLACKMUSICA" +
	"L SYMBOL TRIANGLE-ROUND NOTEHEAD DOWN WHITEMUSICAL SYMBOL TRIANGLE-ROUND" +
	" NOTEHEAD DOWN BLACKMUSICAL SYMBOL PARENTHESIS NOTEHEADMUSICAL SYMBOL VO" +
	"ID NOTEHEADMUSICAL SYMBOL NOTEHEAD BLACKMUSICAL SYMBOL NULL NOTEHEADMUSI" +
	"CAL SYMBOL CLUSTER NOTEHEAD WHITEMUSICAL SYMBOL CLUSTER NOTEHEAD BLACKMU" +
	"SICAL SYMBOL BREVEMUSICAL SYMBOL WHOLE NOTEMUSICAL SYMBOL HALF NOTEMUSIC" +
	"AL SYMBOL QUARTER NOTEMUSICAL SYMBOL EIGHTH NOTEMUSICAL SYMBOL SIXTEENTH" +
	" NOTEMUSICAL SYMBOL THIRTY-SECOND NOTEMUSICAL SYMBOL SIXTY-FOURTH NOTEMU" +
	"SICAL SYMBOL ONE HUNDRED TWENTY-EIGHTH NOTEMUSICAL SYMBOL COMBINING STEM" +
	"MUSICAL SYMBOL COMBINING SPRECHGESANG STEMMUSICAL SYMBOL COMBINING TREMO" +
	"LO-1MUSICAL SYMBOL COMBINING TREMOLO-2MUSICAL SYMBOL COMBINING TREMOLO-3" +
	"MUSICAL SYMBOL FINGERED TREMOLO-1MUSICAL SYMBOL FINGERED TREMOLO-2MUSICA" +
	"L SYMBOL FINGERED TREMOLO-3MUSICAL SYMBOL COMBINING AUGMENTATION DOTMUSI" +
	"CAL SYMBOL COMBINING FLAG-1MUSICAL SYMBOL COMBINING FLAG-2MUSICAL SYMBOL" +
	" COMBINING FLAG-3MUSICAL SYMBOL COMBINING FLAG-4MUSICAL SYMBOL COMBINING" +
	" FLAG-5MUSICAL SYMBOL BEGIN BEAMMUSICAL SYMBOL END BEAMMUSICAL SYMBOL BE" +
	"GIN TIEMUSICAL SYMBOL END TIEMUSICAL SYMBOL BEGIN SLURMUSICAL SYMBOL END" +
	" SLURMUSICAL SYMBOL BEGIN PHRASEMUSICAL SYMBOL END PHRASEMUSICAL SYMBOL " +
	"COMBINING ACCENTMUSICAL SYMBOL COMBINING STACCATOMUSICAL SYMBOL COMBININ" +
	"G TENUTOMUSICAL SYMBOL COMBINING STACCATISSIMOMUSICAL SYMBOL COMBINING M" +
	"ARCATOMUSICAL SYMBOL COMBINING MARCATO-STACCATOMUSICAL SYMBOL COMBINING " +
	"ACCENT-STACCATOMUSICAL SYMBOL COMBINING LOUREMUSICAL SYMBOL ARPEGGIATO U" +
	"PMUSICAL SYMBOL ARPEGGIATO DOWNMUSICAL SYMBOL COMBINING DOITMUSICAL SYMB" +
	"OL COMBINING RIPMUSICAL SYMBOL COMBINING FLIPMUSICAL SYMBOL COMBINING SM" +
	"EARMUSICAL SYMBOL COMBINING BENDMUSICAL SYMBOL COMBINING DOUBLE TONGUEMU" +
	"SICAL SYMBOL COMBINING TRIPLE TONGUEMUSICAL SYMBOL RINFORZANDOMUSICAL SY") + ("" +
	"MBOL SUBITOMUSICAL SYMBOL ZMUSICAL SYMBOL PIANOMUSICAL SYMBOL MEZZOMUSIC" +
	"AL SYMBOL FORTEMUSICAL SYMBOL CRESCENDOMUSICAL SYMBOL DECRESCENDOMUSICAL" +
	" SYMBOL GRACE NOTE SLASHMUSICAL SYMBOL GRACE NOTE NO SLASHMUSICAL SYMBOL" +
	" TRMUSICAL SYMBOL TURNMUSICAL SYMBOL INVERTED TURNMUSICAL SYMBOL TURN SL" +
	"ASHMUSICAL SYMBOL TURN UPMUSICAL SYMBOL ORNAMENT STROKE-1MUSICAL SYMBOL " +
	"ORNAMENT STROKE-2MUSICAL SYMBOL ORNAMENT STROKE-3MUSICAL SYMBOL ORNAMENT" +
	" STROKE-4MUSICAL SYMBOL ORNAMENT STROKE-5MUSICAL SYMBOL ORNAMENT STROKE-" +
	"6MUSICAL SYMBOL ORNAMENT STROKE-7MUSICAL SYMBOL ORNAMENT STROKE-8MUSICAL" +
	" SYMBOL ORNAMENT STROKE-9MUSICAL SYMBOL ORNAMENT STROKE-10MUSICAL SYMBOL" +
	" ORNAMENT STROKE-11MUSICAL SYMBOL HAUPTSTIMMEMUSICAL SYMBOL NEBENSTIMMEM" +
	"USICAL SYMBOL END OF STIMMEMUSICAL SYMBOL DEGREE SLASHMUSICAL SYMBOL COM" +
	"BINING DOWN BOWMUSICAL SYMBOL COMBINING UP BOWMUSICAL SYMBOL COMBINING H" +
	"ARMONICMUSICAL SYMBOL COMBINING SNAP PIZZICATOMUSICAL SYMBOL PEDAL MARKM" +
	"USICAL SYMBOL PEDAL UP MARKMUSICAL SYMBOL HALF PEDAL MARKMUSICAL SYMBOL " +
	"GLISSANDO UPMUSICAL SYMBOL GLISSANDO DOWNMUSICAL SYMBOL WITH FINGERNAILS" +
	"MUSICAL SYMBOL DAMPMUSICAL SYMBOL DAMP ALLMUSICAL SYMBOL MAXIMAMUSICAL S" +
	"YMBOL LONGAMUSICAL SYMBOL BREVISMUSICAL SYMBOL SEMIBREVIS WHITEMUSICAL S" +
	"YMBOL SEMIBREVIS BLACKMUSICAL SYMBOL MINIMAMUSICAL SYMBOL MINIMA BLACKMU" +
	"SICAL SYMBOL SEMIMINIMA WHITEMUSICAL SYMBOL SEMIMINIMA BLACKMUSICAL SYMB" +
	"OL FUSA WHITEMUSICAL SYMBOL FUSA BLACKMUSICAL SYMBOL LONGA PERFECTA REST" +
	"MUSICAL SYMBOL LONGA IMPERFECTA RESTMUSICAL SYMBOL BREVIS RESTMUSICAL SY" +
	"MBOL SEMIBREVIS RESTMUSICAL SYMBOL MINIMA RESTMUSICAL SYMBOL SEMIMINIMA " +
	"RESTMUSICAL SYMBOL TEMPUS PERFECTUM CUM PROLATIONE PERFECTAMUSICAL SYMBO" +
	"L TEMPUS PERFECTUM CUM PROLATIONE IMPERFECTAMUSICAL SYMBOL TEMPUS PERFEC" +
	"TUM CUM PROLATIONE PERFECTA DIMINUTION-1MUSICAL SYMBOL TEMPUS IMPERFECTU" +
	"M CUM PROLATIONE PERFECTAMUSICAL SYMBOL TEMPUS IMPERFECTUM CUM PROLATION" +
	"E IMPERFECTAMUSICAL SYMBOL TEMPUS IMPERFECTUM CUM PROLATIONE IMPERFECTA " +
	"DIMINUTION-1MUSICAL SYMBOL TEMPUS IMPERFECTUM CUM PROLATIONE IMPERFECTA " +
	"DIMINUTION-2MUSICAL SYMBOL TEMPUS IMPERFECTUM CUM PROLATIONE IMPERFECTA " +
	"DIMINUTION-3MUSICAL SYMBOL CROIXMUSICAL SYMBOL GREGORIAN C CLEFMUSICAL S" +
	"YMBOL GREGORIAN F CLEFMUSICAL SYMBOL SQUARE BMUSICAL SYMBOL VIRGAMUSICAL" +
	" SYMBOL PODATUSMUSICAL SYMBOL CLIVISMUSICAL SYMBOL SCANDICUSMUSICAL SYMB" +
	"OL CLIMACUSMUSICAL SYMBOL TORCULUSMUSICAL SYMBOL PORRECTUSMUSICAL SYMBOL" +
	" PORRECTUS FLEXUSMUSICAL SYMBOL SCANDICUS FLEXUSMUSICAL SYMBOL TORCULUS " +
	"RESUPINUSMUSICAL SYMBOL PES SUBPUNCTISMUSICAL SYMBOL KIEVAN C CLEFMUSICA" +
	"L SYMBOL KIEVAN END OF PIECEMUSICAL SYMBOL KIEVAN FINAL NOTEMUSICAL SYMB" +
	"OL KIEVAN RECITATIVE MARKMUSICAL SYMBOL KIEVAN WHOLE NOTEMUSICAL SYMBOL " +
	"KIEVAN HALF NOTEMUSICAL SYMBOL KIEVAN QUARTER NOTE STEM DOWNMUSICAL SYMB" +
	"OL KIEVAN QUARTER NOTE STEM UPMUSICAL SYMBOL KIEVAN EIGHTH NOTE STEM DOW" +
	"NMUSICAL SYMBOL KIEVAN EIGHTH NOTE STEM UPMUSICAL SYMBOL KIEVAN FLAT SIG" +
	"NGREEK VOCAL NOTATION SYMBOL-1GREEK VOCAL NOTATION SYMBOL-2GREEK VOCAL N" +
	"OTATION SYMBOL-3GREEK VOCAL NOTATION SYMBOL-4GREEK VOCAL NOTATION SYMBOL" +
	"-5GREEK VOCAL NOTATION SYMBOL-6GREEK VOCAL NOTATION SYMBOL-7GREEK VOCAL " +
	"NOTATION SYMBOL-8GREEK VOCAL NOTATION SYMBOL-9GREEK VOCAL NOTATION SYMBO" +
	"L-10GREEK VOCAL NOTATION SYMBOL-11GREEK VOCAL NOTATION SYMBOL-12GREEK VO" +
	"CAL NOTATION SYMBOL-13GREEK VOCAL NOTATION SYMBOL-14GREEK VOCAL NOTATION" +
	" SYMBOL-15GREEK VOCAL NOTATION SYMBOL-16GREEK VOCAL NOTATION SYMBOL-17GR" +
	"EEK VOCAL NOTATION SYMBOL-18GREEK VOCAL NOTATION SYMBOL-19GREEK VOCAL NO" +
	"TATION SYMBOL-20GREEK VOCAL NOTATION SYMBOL-21GREEK VOCAL NOTATION SYMBO" +
	"L-22GREEK VOCAL NOTATION SYMBOL-23GREEK VOCAL NOTATION SYMBOL-24GREEK VO" +
	"CAL NOTATION SYMBOL-50GREEK VOCAL NOTATION SYMBOL-51GREEK VOCAL NOTATION" +
	" SYMBOL-52GREEK VOCAL NOTATION SYMBOL-53GREEK VOCAL NOTATION SYMBOL-54GR" +
	"EEK INSTRUMENTAL NOTATION SYMBOL-1GREEK INSTRUMENTAL NOTATION SYMBOL-2GR" +
	"EEK INSTRUMENTAL NOTATION SYMBOL-4GREEK INSTRUMENTAL NOTATION SYMBOL-5GR" +
	"EEK INSTRUMENTAL NOTATION SYMBOL-7GREEK INSTRUMENTAL NOTATION SYMBOL-8GR" +
	"EEK INSTRUMENTAL NOTATION SYMBOL-11GREEK INSTRUMENTAL NOTATION SYMBOL-12" +
	"GREEK INSTRUMENTAL NOTATION SYMBOL-13GREEK INSTRUMENTAL NOTATION SYMBOL-" +
	"14GREEK INSTRUMENTAL NOTATION SYMBOL-17GREEK INSTRUMENTAL NOTATION SYMBO" +
	"L-18GREEK INSTRUMENTAL NOTATION SYMBOL-19GREEK INSTRUMENTAL NOTATION SYM" +
	"BOL-23GREEK INSTRUMENTAL NOTATION SYMBOL-24GREEK INSTRUMENTAL NOTATION S" +
	"YMBOL-25GREEK INSTRUMENTAL NOTATION SYMBOL-26GREEK INSTRUMENTAL NOTATION" +
	" SYMBOL-27GREEK INSTRUMENTAL NOTATION SYMBOL-29GREEK INSTRUMENTAL NOTATI" +
	"ON SYMBOL-30GREEK INSTRUMENTAL NOTATION SYMBOL-32GREEK INSTRUMENTAL NOTA" +
	"TION SYMBOL-36GREEK INSTRUMENTAL NOTATION SYMBOL-37GREEK INSTRUMENTAL NO") + ("" +
	"TATION SYMBOL-38GREEK INSTRUMENTAL NOTATION SYMBOL-39GREEK INSTRUMENTAL " +
	"NOTATION SYMBOL-40GREEK INSTRUMENTAL NOTATION SYMBOL-42GREEK INSTRUMENTA" +
	"L NOTATION SYMBOL-43GREEK INSTRUMENTAL NOTATION SYMBOL-45GREEK INSTRUMEN" +
	"TAL NOTATION SYMBOL-47GREEK INSTRUMENTAL NOTATION SYMBOL-48GREEK INSTRUM" +
	"ENTAL NOTATION SYMBOL-49GREEK INSTRUMENTAL NOTATION SYMBOL-50GREEK INSTR" +
	"UMENTAL NOTATION SYMBOL-51GREEK INSTRUMENTAL NOTATION SYMBOL-52GREEK INS" +
	"TRUMENTAL NOTATION SYMBOL-53GREEK INSTRUMENTAL NOTATION SYMBOL-54COMBINI" +
	"NG GREEK MUSICAL TRISEMECOMBINING GREEK MUSICAL TETRASEMECOMBINING GREEK" +
	" MUSICAL PENTASEMEGREEK MUSICAL LEIMMAMONOGRAM FOR EARTHDIGRAM FOR HEAVE" +
	"NLY EARTHDIGRAM FOR HUMAN EARTHDIGRAM FOR EARTHLY HEAVENDIGRAM FOR EARTH" +
	"LY HUMANDIGRAM FOR EARTHTETRAGRAM FOR CENTRETETRAGRAM FOR FULL CIRCLETET" +
	"RAGRAM FOR MIREDTETRAGRAM FOR BARRIERTETRAGRAM FOR KEEPING SMALLTETRAGRA" +
	"M FOR CONTRARIETYTETRAGRAM FOR ASCENTTETRAGRAM FOR OPPOSITIONTETRAGRAM F" +
	"OR BRANCHING OUTTETRAGRAM FOR DEFECTIVENESS OR DISTORTIONTETRAGRAM FOR D" +
	"IVERGENCETETRAGRAM FOR YOUTHFULNESSTETRAGRAM FOR INCREASETETRAGRAM FOR P" +
	"ENETRATIONTETRAGRAM FOR REACHTETRAGRAM FOR CONTACTTETRAGRAM FOR HOLDING " +
	"BACKTETRAGRAM FOR WAITINGTETRAGRAM FOR FOLLOWINGTETRAGRAM FOR ADVANCETET" +
	"RAGRAM FOR RELEASETETRAGRAM FOR RESISTANCETETRAGRAM FOR EASETETRAGRAM FO" +
	"R JOYTETRAGRAM FOR CONTENTIONTETRAGRAM FOR ENDEAVOURTETRAGRAM FOR DUTIES" +
	"TETRAGRAM FOR CHANGETETRAGRAM FOR DECISIVENESSTETRAGRAM FOR BOLD RESOLUT" +
	"IONTETRAGRAM FOR PACKINGTETRAGRAM FOR LEGIONTETRAGRAM FOR CLOSENESSTETRA" +
	"GRAM FOR KINSHIPTETRAGRAM FOR GATHERINGTETRAGRAM FOR STRENGTHTETRAGRAM F" +
	"OR PURITYTETRAGRAM FOR FULLNESSTETRAGRAM FOR RESIDENCETETRAGRAM FOR LAW " +
	"OR MODELTETRAGRAM FOR RESPONSETETRAGRAM FOR GOING TO MEETTETRAGRAM FOR E" +
	"NCOUNTERSTETRAGRAM FOR STOVETETRAGRAM FOR GREATNESSTETRAGRAM FOR ENLARGE" +
	"MENTTETRAGRAM FOR PATTERNTETRAGRAM FOR RITUALTETRAGRAM FOR FLIGHTTETRAGR" +
	"AM FOR VASTNESS OR WASTINGTETRAGRAM FOR CONSTANCYTETRAGRAM FOR MEASURETE" +
	"TRAGRAM FOR ETERNITYTETRAGRAM FOR UNITYTETRAGRAM FOR DIMINISHMENTTETRAGR" +
	"AM FOR CLOSED MOUTHTETRAGRAM FOR GUARDEDNESSTETRAGRAM FOR GATHERING INTE" +
	"TRAGRAM FOR MASSINGTETRAGRAM FOR ACCUMULATIONTETRAGRAM FOR EMBELLISHMENT" +
	"TETRAGRAM FOR DOUBTTETRAGRAM FOR WATCHTETRAGRAM FOR SINKINGTETRAGRAM FOR" +
	" INNERTETRAGRAM FOR DEPARTURETETRAGRAM FOR DARKENINGTETRAGRAM FOR DIMMIN" +
	"GTETRAGRAM FOR EXHAUSTIONTETRAGRAM FOR SEVERANCETETRAGRAM FOR STOPPAGETE" +
	"TRAGRAM FOR HARDNESSTETRAGRAM FOR COMPLETIONTETRAGRAM FOR CLOSURETETRAGR" +
	"AM FOR FAILURETETRAGRAM FOR AGGRAVATIONTETRAGRAM FOR COMPLIANCETETRAGRAM" +
	" FOR ON THE VERGETETRAGRAM FOR DIFFICULTIESTETRAGRAM FOR LABOURINGTETRAG" +
	"RAM FOR FOSTERINGCOUNTING ROD UNIT DIGIT ONECOUNTING ROD UNIT DIGIT TWOC" +
	"OUNTING ROD UNIT DIGIT THREECOUNTING ROD UNIT DIGIT FOURCOUNTING ROD UNI" +
	"T DIGIT FIVECOUNTING ROD UNIT DIGIT SIXCOUNTING ROD UNIT DIGIT SEVENCOUN" +
	"TING ROD UNIT DIGIT EIGHTCOUNTING ROD UNIT DIGIT NINECOUNTING ROD TENS D" +
	"IGIT ONECOUNTING ROD TENS DIGIT TWOCOUNTING ROD TENS DIGIT THREECOUNTING" +
	" ROD TENS DIGIT FOURCOUNTING ROD TENS DIGIT FIVECOUNTING ROD TENS DIGIT " +
	"SIXCOUNTING ROD TENS DIGIT SEVENCOUNTING ROD TENS DIGIT EIGHTCOUNTING RO" +
	"D TENS DIGIT NINEMATHEMATICAL BOLD CAPITAL AMATHEMATICAL BOLD CAPITAL BM" +
	"ATHEMATICAL BOLD CAPITAL CMATHEMATICAL BOLD CAPITAL DMATHEMATICAL BOLD C" +
	"APITAL EMATHEMATICAL BOLD CAPITAL FMATHEMATICAL BOLD CAPITAL GMATHEMATIC" +
	"AL BOLD CAPITAL HMATHEMATICAL BOLD CAPITAL IMATHEMATICAL BOLD CAPITAL JM" +
	"ATHEMATICAL BOLD CAPITAL KMATHEMATICAL BOLD CAPITAL LMATHEMATICAL BOLD C" +
	"APITAL MMATHEMATICAL BOLD CAPITAL NMATHEMATICAL BOLD CAPITAL OMATHEMATIC" +
	"AL BOLD CAPITAL PMATHEMATICAL BOLD CAPITAL QMATHEMATICAL BOLD CAPITAL RM" +
	"ATHEMATICAL BOLD CAPITAL SMATHEMATICAL BOLD CAPITAL TMATHEMATICAL BOLD C" +
	"APITAL UMATHEMATICAL BOLD CAPITAL VMATHEMATICAL BOLD CAPITAL WMATHEMATIC" +
	"AL BOLD CAPITAL XMATHEMATICAL BOLD CAPITAL YMATHEMATICAL BOLD CAPITAL ZM" +
	"ATHEMATICAL BOLD SMALL AMATHEMATICAL BOLD SMALL BMATHEMATICAL BOLD SMALL" +
	" CMATHEMATICAL BOLD SMALL DMATHEMATICAL BOLD SMALL EMATHEMATICAL BOLD SM" +
	"ALL FMATHEMATICAL BOLD SMALL GMATHEMATICAL BOLD SMALL HMATHEMATICAL BOLD" +
	" SMALL IMATHEMATICAL BOLD SMALL JMATHEMATICAL BOLD SMALL KMATHEMATICAL B" +
	"OLD SMALL LMATHEMATICAL BOLD SMALL MMATHEMATICAL BOLD SMALL NMATHEMATICA" +
	"L BOLD SMALL OMATHEMATICAL BOLD SMALL PMATHEMATICAL BOLD SMALL QMATHEMAT" +
	"ICAL BOLD SMALL RMATHEMATICAL BOLD SMALL SMATHEMATICAL BOLD SMALL TMATHE" +
	"MATICAL BOLD SMALL UMATHEMATICAL BOLD SMALL VMATHEMATICAL BOLD SMALL WMA" +
	"THEMATICAL BOLD SMALL XMATHEMATICAL BOLD SMALL YMATHEMATICAL BOLD SMALL " +
	"ZMATHEMATICAL ITALIC CAPITAL AMATHEMATICAL ITALIC CAPITAL BMATHEMATICAL " +
	"ITALIC CAPITAL CMATHEMATICAL ITALIC CAPITAL DMATHEMATICAL ITALIC CAPITAL") + ("" +
	" EMATHEMATICAL ITALIC CAPITAL FMATHEMATICAL ITALIC CAPITAL GMATHEMATICAL" +
	" ITALIC CAPITAL HMATHEMATICAL ITALIC CAPITAL IMATHEMATICAL ITALIC CAPITA" +
	"L JMATHEMATICAL ITALIC CAPITAL KMATHEMATICAL ITALIC CAPITAL LMATHEMATICA" +
	"L ITALIC CAPITAL MMATHEMATICAL ITALIC CAPITAL NMATHEMATICAL ITALIC CAPIT" +
	"AL OMATHEMATICAL ITALIC CAPITAL PMATHEMATICAL ITALIC CAPITAL QMATHEMATIC" +
	"AL ITALIC CAPITAL RMATHEMATICAL ITALIC CAPITAL SMATHEMATICAL ITALIC CAPI" +
	"TAL TMATHEMATICAL ITALIC CAPITAL UMATHEMATICAL ITALIC CAPITAL VMATHEMATI" +
	"CAL ITALIC CAPITAL WMATHEMATICAL ITALIC CAPITAL XMATHEMATICAL ITALIC CAP" +
	"ITAL YMATHEMATICAL ITALIC CAPITAL ZMATHEMATICAL ITALIC SMALL AMATHEMATIC" +
	"AL ITALIC SMALL BMATHEMATICAL ITALIC SMALL CMATHEMATICAL ITALIC SMALL DM" +
	"ATHEMATICAL ITALIC SMALL EMATHEMATICAL ITALIC SMALL FMATHEMATICAL ITALIC" +
	" SMALL GMATHEMATICAL ITALIC SMALL IMATHEMATICAL ITALIC SMALL JMATHEMATIC" +
	"AL ITALIC SMALL KMATHEMATICAL ITALIC SMALL LMATHEMATICAL ITALIC SMALL MM" +
	"ATHEMATICAL ITALIC SMALL NMATHEMATICAL ITALIC SMALL OMATHEMATICAL ITALIC" +
	" SMALL PMATHEMATICAL ITALIC SMALL QMATHEMATICAL ITALIC SMALL RMATHEMATIC" +
	"AL ITALIC SMALL SMATHEMATICAL ITALIC SMALL TMATHEMATICAL ITALIC SMALL UM" +
	"ATHEMATICAL ITALIC SMALL VMATHEMATICAL ITALIC SMALL WMATHEMATICAL ITALIC" +
	" SMALL XMATHEMATICAL ITALIC SMALL YMATHEMATICAL ITALIC SMALL ZMATHEMATIC" +
	"AL BOLD ITALIC CAPITAL AMATHEMATICAL BOLD ITALIC CAPITAL BMATHEMATICAL B" +
	"OLD ITALIC CAPITAL CMATHEMATICAL BOLD ITALIC CAPITAL DMATHEMATICAL BOLD " +
	"ITALIC CAPITAL EMATHEMATICAL BOLD ITALIC CAPITAL FMATHEMATICAL BOLD ITAL" +
	"IC CAPITAL GMATHEMATICAL BOLD ITALIC CAPITAL HMATHEMATICAL BOLD ITALIC C" +
	"APITAL IMATHEMATICAL BOLD ITALIC CAPITAL JMATHEMATICAL BOLD ITALIC CAPIT" +
	"AL KMATHEMATICAL BOLD ITALIC CAPITAL LMATHEMATICAL BOLD ITALIC CAPITAL M" +
	"MATHEMATICAL BOLD ITALIC CAPITAL NMATHEMATICAL BOLD ITALIC CAPITAL OMATH" +
	"EMATICAL BOLD ITALIC CAPITAL PMATHEMATICAL BOLD ITALIC CAPITAL QMATHEMAT" +
	"ICAL BOLD ITALIC CAPITAL RMATHEMATICAL BOLD ITALIC CAPITAL SMATHEMATICAL" +
	" BOLD ITALIC CAPITAL TMATHEMATICAL BOLD ITALIC CAPITAL UMATHEMATICAL BOL" +
	"D ITALIC CAPITAL VMATHEMATICAL BOLD ITALIC CAPITAL WMATHEMATICAL BOLD IT" +
	"ALIC CAPITAL XMATHEMATICAL BOLD ITALIC CAPITAL YMATHEMATICAL BOLD ITALIC" +
	" CAPITAL ZMATHEMATICAL BOLD ITALIC SMALL AMATHEMATICAL BOLD ITALIC SMALL" +
	" BMATHEMATICAL BOLD ITALIC SMALL CMATHEMATICAL BOLD ITALIC SMALL DMATHEM" +
	"ATICAL BOLD ITALIC SMALL EMATHEMATICAL BOLD ITALIC SMALL FMATHEMATICAL B" +
	"OLD ITALIC SMALL GMATHEMATICAL BOLD ITALIC SMALL HMATHEMATICAL BOLD ITAL" +
	"IC SMALL IMATHEMATICAL BOLD ITALIC SMALL JMATHEMATICAL BOLD ITALIC SMALL" +
	" KMATHEMATICAL BOLD ITALIC SMALL LMATHEMATICAL BOLD ITALIC SMALL MMATHEM" +
	"ATICAL BOLD ITALIC SMALL NMATHEMATICAL BOLD ITALIC SMALL OMATHEMATICAL B" +
	"OLD ITALIC SMALL PMATHEMATICAL BOLD ITALIC SMALL QMATHEMATICAL BOLD ITAL" +
	"IC SMALL RMATHEMATICAL BOLD ITALIC SMALL SMATHEMATICAL BOLD ITALIC SMALL" +
	" TMATHEMATICAL BOLD ITALIC SMALL UMATHEMATICAL BOLD ITALIC SMALL VMATHEM" +
	"ATICAL BOLD ITALIC SMALL WMATHEMATICAL BOLD ITALIC SMALL XMATHEMATICAL B" +
	"OLD ITALIC SMALL YMATHEMATICAL BOLD ITALIC SMALL ZMATHEMATICAL SCRIPT CA" +
	"PITAL AMATHEMATICAL SCRIPT CAPITAL CMATHEMATICAL SCRIPT CAPITAL DMATHEMA" +
	"TICAL SCRIPT CAPITAL GMATHEMATICAL SCRIPT CAPITAL JMATHEMATICAL SCRIPT C" +
	"APITAL KMATHEMATICAL SCRIPT CAPITAL NMATHEMATICAL SCRIPT CAPITAL OMATHEM" +
	"ATICAL SCRIPT CAPITAL PMATHEMATICAL SCRIPT CAPITAL QMATHEMATICAL SCRIPT " +
	"CAPITAL SMATHEMATICAL SCRIPT CAPITAL TMATHEMATICAL SCRIPT CAPITAL UMATHE" +
	"MATICAL SCRIPT CAPITAL VMATHEMATICAL SCRIPT CAPITAL WMATHEMATICAL SCRIPT" +
	" CAPITAL XMATHEMATICAL SCRIPT CAPITAL YMATHEMATICAL SCRIPT CAPITAL ZMATH" +
	"EMATICAL SCRIPT SMALL AMATHEMATICAL SCRIPT SMALL BMATHEMATICAL SCRIPT SM" +
	"ALL CMATHEMATICAL SCRIPT SMALL DMATHEMATICAL SCRIPT SMALL FMATHEMATICAL " +
	"SCRIPT SMALL HMATHEMATICAL SCRIPT SMALL IMATHEMATICAL SCRIPT SMALL JMATH" +
	"EMATICAL SCRIPT SMALL KMATHEMATICAL SCRIPT SMALL LMATHEMATICAL SCRIPT SM" +
	"ALL MMATHEMATICAL SCRIPT SMALL NMATHEMATICAL SCRIPT SMALL PMATHEMATICAL " +
	"SCRIPT SMALL QMATHEMATICAL SCRIPT SMALL RMATHEMATICAL SCRIPT SMALL SMATH" +
	"EMATICAL SCRIPT SMALL TMATHEMATICAL SCRIPT SMALL UMATHEMATICAL SCRIPT SM" +
	"ALL VMATHEMATICAL SCRIPT SMALL WMATHEMATICAL SCRIPT SMALL XMATHEMATICAL " +
	"SCRIPT SMALL YMATHEMATICAL SCRIPT SMALL ZMATHEMATICAL BOLD SCRIPT CAPITA" +
	"L AMATHEMATICAL BOLD SCRIPT CAPITAL BMATHEMATICAL BOLD SCRIPT CAPITAL CM" +
	"ATHEMATICAL BOLD SCRIPT CAPITAL DMATHEMATICAL BOLD SCRIPT CAPITAL EMATHE" +
	"MATICAL BOLD SCRIPT CAPITAL FMATHEMATICAL BOLD SCRIPT CAPITAL GMATHEMATI" +
	"CAL BOLD SCRIPT CAPITAL HMATHEMATICAL BOLD SCRIPT CAPITAL IMATHEMATICAL " +
	"BOLD SCRIPT CAPITAL JMATHEMATICAL BOLD SCRIPT CAPITAL KMATHEMATICAL BOLD" +
	" SCRIPT CAPITAL LMATHEMATICAL BOLD SCRIPT CAPITAL MMATHEMATICAL BOLD SCR") + ("" +
	"IPT CAPITAL NMATHEMATICAL BOLD SCRIPT CAPITAL OMATHEMATICAL BOLD SCRIPT " +
	"CAPITAL PMATHEMATICAL BOLD SCRIPT CAPITAL QMATHEMATICAL BOLD SCRIPT CAPI" +
	"TAL RMATHEMATICAL BOLD SCRIPT CAPITAL SMATHEMATICAL BOLD SCRIPT CAPITAL " +
	"TMATHEMATICAL BOLD SCRIPT CAPITAL UMATHEMATICAL BOLD SCRIPT CAPITAL VMAT" +
	"HEMATICAL BOLD SCRIPT CAPITAL WMATHEMATICAL BOLD SCRIPT CAPITAL XMATHEMA" +
	"TICAL BOLD SCRIPT CAPITAL YMATHEMATICAL BOLD SCRIPT CAPITAL ZMATHEMATICA" +
	"L BOLD SCRIPT SMALL AMATHEMATICAL BOLD SCRIPT SMALL BMATHEMATICAL BOLD S" +
	"CRIPT SMALL CMATHEMATICAL BOLD SCRIPT SMALL DMATHEMATICAL BOLD SCRIPT SM" +
	"ALL EMATHEMATICAL BOLD SCRIPT SMALL FMATHEMATICAL BOLD SCRIPT SMALL GMAT" +
	"HEMATICAL BOLD SCRIPT SMALL HMATHEMATICAL BOLD SCRIPT SMALL IMATHEMATICA" +
	"L BOLD SCRIPT SMALL JMATHEMATICAL BOLD SCRIPT SMALL KMATHEMATICAL BOLD S" +
	"CRIPT SMALL LMATHEMATICAL BOLD SCRIPT SMALL MMATHEMATICAL BOLD SCRIPT SM" +
	"ALL NMATHEMATICAL BOLD SCRIPT SMALL OMATHEMATICAL BOLD SCRIPT SMALL PMAT" +
	"HEMATICAL BOLD SCRIPT SMALL QMATHEMATICAL BOLD SCRIPT SMALL RMATHEMATICA" +
	"L BOLD SCRIPT SMALL SMATHEMATICAL BOLD SCRIPT SMALL TMATHEMATICAL BOLD S" +
	"CRIPT SMALL UMATHEMATICAL BOLD SCRIPT SMALL VMATHEMATICAL BOLD SCRIPT SM" +
	"ALL WMATHEMATICAL BOLD SCRIPT SMALL XMATHEMATICAL BOLD SCRIPT SMALL YMAT" +
	"HEMATICAL BOLD SCRIPT SMALL ZMATHEMATICAL FRAKTUR CAPITAL AMATHEMATICAL " +
	"FRAKTUR CAPITAL BMATHEMATICAL FRAKTUR CAPITAL DMATHEMATICAL FRAKTUR CAPI" +
	"TAL EMATHEMATICAL FRAKTUR CAPITAL FMATHEMATICAL FRAKTUR CAPITAL GMATHEMA" +
	"TICAL FRAKTUR CAPITAL JMATHEMATICAL FRAKTUR CAPITAL KMATHEMATICAL FRAKTU" +
	"R CAPITAL LMATHEMATICAL FRAKTUR CAPITAL MMATHEMATICAL FRAKTUR CAPITAL NM" +
	"ATHEMATICAL FRAKTUR CAPITAL OMATHEMATICAL FRAKTUR CAPITAL PMATHEMATICAL " +
	"FRAKTUR CAPITAL QMATHEMATICAL FRAKTUR CAPITAL SMATHEMATICAL FRAKTUR CAPI" +
	"TAL TMATHEMATICAL FRAKTUR CAPITAL UMATHEMATICAL FRAKTUR CAPITAL VMATHEMA" +
	"TICAL FRAKTUR CAPITAL WMATHEMATICAL FRAKTUR CAPITAL XMATHEMATICAL FRAKTU" +
	"R CAPITAL YMATHEMATICAL FRAKTUR SMALL AMATHEMATICAL FRAKTUR SMALL BMATHE" +
	"MATICAL FRAKTUR SMALL CMATHEMATICAL FRAKTUR SMALL DMATHEMATICAL FRAKTUR " +
	"SMALL EMATHEMATICAL FRAKTUR SMALL FMATHEMATICAL FRAKTUR SMALL GMATHEMATI" +
	"CAL FRAKTUR SMALL HMATHEMATICAL FRAKTUR SMALL IMATHEMATICAL FRAKTUR SMAL" +
	"L JMATHEMATICAL FRAKTUR SMALL KMATHEMATICAL FRAKTUR SMALL LMATHEMATICAL " +
	"FRAKTUR SMALL MMATHEMATICAL FRAKTUR SMALL NMATHEMATICAL FRAKTUR SMALL OM" +
	"ATHEMATICAL FRAKTUR SMALL PMATHEMATICAL FRAKTUR SMALL QMATHEMATICAL FRAK" +
	"TUR SMALL RMATHEMATICAL FRAKTUR SMALL SMATHEMATICAL FRAKTUR SMALL TMATHE" +
	"MATICAL FRAKTUR SMALL UMATHEMATICAL FRAKTUR SMALL VMATHEMATICAL FRAKTUR " +
	"SMALL WMATHEMATICAL FRAKTUR SMALL XMATHEMATICAL FRAKTUR SMALL YMATHEMATI" +
	"CAL FRAKTUR SMALL ZMATHEMATICAL DOUBLE-STRUCK CAPITAL AMATHEMATICAL DOUB" +
	"LE-STRUCK CAPITAL BMATHEMATICAL DOUBLE-STRUCK CAPITAL DMATHEMATICAL DOUB" +
	"LE-STRUCK CAPITAL EMATHEMATICAL DOUBLE-STRUCK CAPITAL FMATHEMATICAL DOUB" +
	"LE-STRUCK CAPITAL GMATHEMATICAL DOUBLE-STRUCK CAPITAL IMATHEMATICAL DOUB" +
	"LE-STRUCK CAPITAL JMATHEMATICAL DOUBLE-STRUCK CAPITAL KMATHEMATICAL DOUB" +
	"LE-STRUCK CAPITAL LMATHEMATICAL DOUBLE-STRUCK CAPITAL MMATHEMATICAL DOUB" +
	"LE-STRUCK CAPITAL OMATHEMATICAL DOUBLE-STRUCK CAPITAL SMATHEMATICAL DOUB" +
	"LE-STRUCK CAPITAL TMATHEMATICAL DOUBLE-STRUCK CAPITAL UMATHEMATICAL DOUB" +
	"LE-STRUCK CAPITAL VMATHEMATICAL DOUBLE-STRUCK CAPITAL WMATHEMATICAL DOUB" +
	"LE-STRUCK CAPITAL XMATHEMATICAL DOUBLE-STRUCK CAPITAL YMATHEMATICAL DOUB" +
	"LE-STRUCK SMALL AMATHEMATICAL DOUBLE-STRUCK SMALL BMATHEMATICAL DOUBLE-S" +
	"TRUCK SMALL CMATHEMATICAL DOUBLE-STRUCK SMALL DMATHEMATICAL DOUBLE-STRUC" +
	"K SMALL EMATHEMATICAL DOUBLE-STRUCK SMALL FMATHEMATICAL DOUBLE-STRUCK SM" +
	"ALL GMATHEMATICAL DOUBLE-STRUCK SMALL HMATHEMATICAL DOUBLE-STRUCK SMALL " +
	"IMATHEMATICAL DOUBLE-STRUCK SMALL JMATHEMATICAL DOUBLE-STRUCK SMALL KMAT" +
	"HEMATICAL DOUBLE-STRUCK SMALL LMATHEMATICAL DOUBLE-STRUCK SMALL MMATHEMA" +
	"TICAL DOUBLE-STRUCK SMALL NMATHEMATICAL DOUBLE-STRUCK SMALL OMATHEMATICA" +
	"L DOUBLE-STRUCK SMALL PMATHEMATICAL DOUBLE-STRUCK SMALL QMATHEMATICAL DO" +
	"UBLE-STRUCK SMALL RMATHEMATICAL DOUBLE-STRUCK SMALL SMATHEMATICAL DOUBLE" +
	"-STRUCK SMALL TMATHEMATICAL DOUBLE-STRUCK SMALL UMATHEMATICAL DOUBLE-STR" +
	"UCK SMALL VMATHEMATICAL DOUBLE-STRUCK SMALL WMATHEMATICAL DOUBLE-STRUCK " +
	"SMALL XMATHEMATICAL DOUBLE-STRUCK SMALL YMATHEMATICAL DOUBLE-STRUCK SMAL" +
	"L ZMATHEMATICAL BOLD FRAKTUR CAPITAL AMATHEMATICAL BOLD FRAKTUR CAPITAL " +
	"BMATHEMATICAL BOLD FRAKTUR CAPITAL CMATHEMATICAL BOLD FRAKTUR CAPITAL DM" +
	"ATHEMATICAL BOLD FRAKTUR CAPITAL EMATHEMATICAL BOLD FRAKTUR CAPITAL FMAT" +
	"HEMATICAL BOLD FRAKTUR CAPITAL GMATHEMATICAL BOLD FRAKTUR CAPITAL HMATHE" +
	"MATICAL BOLD FRAKTUR CAPITAL IMATHEMATICAL BOLD FRAKTUR CAPITAL JMATHEMA" +
	"TICAL BOLD FRAKTUR CAPITAL KMATHEMATICAL BOLD FRAKTUR CAPITAL LMATHEMATI") + ("" +
	"CAL BOLD FRAKTUR CAPITAL MMATHEMATICAL BOLD FRAKTUR CAPITAL NMATHEMATICA" +
	"L BOLD FRAKTUR CAPITAL OMATHEMATICAL BOLD FRAKTUR CAPITAL PMATHEMATICAL " +
	"BOLD FRAKTUR CAPITAL QMATHEMATICAL BOLD FRAKTUR CAPITAL RMATHEMATICAL BO" +
	"LD FRAKTUR CAPITAL SMATHEMATICAL BOLD FRAKTUR CAPITAL TMATHEMATICAL BOLD" +
	" FRAKTUR CAPITAL UMATHEMATICAL BOLD FRAKTUR CAPITAL VMATHEMATICAL BOLD F" +
	"RAKTUR CAPITAL WMATHEMATICAL BOLD FRAKTUR CAPITAL XMATHEMATICAL BOLD FRA" +
	"KTUR CAPITAL YMATHEMATICAL BOLD FRAKTUR CAPITAL ZMATHEMATICAL BOLD FRAKT" +
	"UR SMALL AMATHEMATICAL BOLD FRAKTUR SMALL BMATHEMATICAL BOLD FRAKTUR SMA" +
	"LL CMATHEMATICAL BOLD FRAKTUR SMALL DMATHEMATICAL BOLD FRAKTUR SMALL EMA" +
	"THEMATICAL BOLD FRAKTUR SMALL FMATHEMATICAL BOLD FRAKTUR SMALL GMATHEMAT" +
	"ICAL BOLD FRAKTUR SMALL HMATHEMATICAL BOLD FRAKTUR SMALL IMATHEMATICAL B" +
	"OLD FRAKTUR SMALL JMATHEMATICAL BOLD FRAKTUR SMALL KMATHEMATICAL BOLD FR" +
	"AKTUR SMALL LMATHEMATICAL BOLD FRAKTUR SMALL MMATHEMATICAL BOLD FRAKTUR " +
	"SMALL NMATHEMATICAL BOLD FRAKTUR SMALL OMATHEMATICAL BOLD FRAKTUR SMALL " +
	"PMATHEMATICAL BOLD FRAKTUR SMALL QMATHEMATICAL BOLD FRAKTUR SMALL RMATHE" +
	"MATICAL BOLD FRAKTUR SMALL SMATHEMATICAL BOLD FRAKTUR SMALL TMATHEMATICA" +
	"L BOLD FRAKTUR SMALL UMATHEMATICAL BOLD FRAKTUR SMALL VMATHEMATICAL BOLD" +
	" FRAKTUR SMALL WMATHEMATICAL BOLD FRAKTUR SMALL XMATHEMATICAL BOLD FRAKT" +
	"UR SMALL YMATHEMATICAL BOLD FRAKTUR SMALL ZMATHEMATICAL SANS-SERIF CAPIT" +
	"AL AMATHEMATICAL SANS-SERIF CAPITAL BMATHEMATICAL SANS-SERIF CAPITAL CMA" +
	"THEMATICAL SANS-SERIF CAPITAL DMATHEMATICAL SANS-SERIF CAPITAL EMATHEMAT" +
	"ICAL SANS-SERIF CAPITAL FMATHEMATICAL SANS-SERIF CAPITAL GMATHEMATICAL S" +
	"ANS-SERIF CAPITAL HMATHEMATICAL SANS-SERIF CAPITAL IMATHEMATICAL SANS-SE" +
	"RIF CAPITAL JMATHEMATICAL SANS-SERIF CAPITAL KMATHEMATICAL SANS-SERIF CA" +
	"PITAL LMATHEMATICAL SANS-SERIF CAPITAL MMATHEMATICAL SANS-SERIF CAPITAL " +
	"NMATHEMATICAL SANS-SERIF CAPITAL OMATHEMATICAL SANS-SERIF CAPITAL PMATHE" +
	"MATICAL SANS-SERIF CAPITAL QMATHEMATICAL SANS-SERIF CAPITAL RMATHEMATICA" +
	"L SANS-SERIF CAPITAL SMATHEMATICAL SANS-SERIF CAPITAL TMATHEMATICAL SANS" +
	"-SERIF CAPITAL UMATHEMATICAL SANS-SERIF CAPITAL VMATHEMATICAL SANS-SERIF" +
	" CAPITAL WMATHEMATICAL SANS-SERIF CAPITAL XMATHEMATICAL SANS-SERIF CAPIT" +
	"AL YMATHEMATICAL SANS-SERIF CAPITAL ZMATHEMATICAL SANS-SERIF SMALL AMATH" +
	"EMATICAL SANS-SERIF SMALL BMATHEMATICAL SANS-SERIF SMALL CMATHEMATICAL S" +
	"ANS-SERIF SMALL DMATHEMATICAL SANS-SERIF SMALL EMATHEMATICAL SANS-SERIF " +
	"SMALL FMATHEMATICAL SANS-SERIF SMALL GMATHEMATICAL SANS-SERIF SMALL HMAT" +
	"HEMATICAL SANS-SERIF SMALL IMATHEMATICAL SANS-SERIF SMALL JMATHEMATICAL " +
	"SANS-SERIF SMALL KMATHEMATICAL SANS-SERIF SMALL LMATHEMATICAL SANS-SERIF" +
	" SMALL MMATHEMATICAL SANS-SERIF SMALL NMATHEMATICAL SANS-SERIF SMALL OMA" +
	"THEMATICAL SANS-SERIF SMALL PMATHEMATICAL SANS-SERIF SMALL QMATHEMATICAL" +
	" SANS-SERIF SMALL RMATHEMATICAL SANS-SERIF SMALL SMATHEMATICAL SANS-SERI" +
	"F SMALL TMATHEMATICAL SANS-SERIF SMALL UMATHEMATICAL SANS-SERIF SMALL VM" +
	"ATHEMATICAL SANS-SERIF SMALL WMATHEMATICAL SANS-SERIF SMALL XMATHEMATICA" +
	"L SANS-SERIF SMALL YMATHEMATICAL SANS-SERIF SMALL ZMATHEMATICAL SANS-SER" +
	"IF BOLD CAPITAL AMATHEMATICAL SANS-SERIF BOLD CAPITAL BMATHEMATICAL SANS" +
	"-SERIF BOLD CAPITAL CMATHEMATICAL SANS-SERIF BOLD CAPITAL DMATHEMATICAL " +
	"SANS-SERIF BOLD CAPITAL EMATHEMATICAL SANS-SERIF BOLD CAPITAL FMATHEMATI" +
	"CAL SANS-SERIF BOLD CAPITAL GMATHEMATICAL SANS-SERIF BOLD CAPITAL HMATHE" +
	"MATICAL SANS-SERIF BOLD CAPITAL IMATHEMATICAL SANS-SERIF BOLD CAPITAL JM" +
	"ATHEMATICAL SANS-SERIF BOLD CAPITAL KMATHEMATICAL SANS-SERIF BOLD CAPITA" +
	"L LMATHEMATICAL SANS-SERIF BOLD CAPITAL MMATHEMATICAL SANS-SERIF BOLD CA" +
	"PITAL NMATHEMATICAL SANS-SERIF BOLD CAPITAL OMATHEMATICAL SANS-SERIF BOL" +
	"D CAPITAL PMATHEMATICAL SANS-SERIF BOLD CAPITAL QMATHEMATICAL SANS-SERIF" +
	" BOLD CAPITAL RMATHEMATICAL SANS-SERIF BOLD CAPITAL SMATHEMATICAL SANS-S" +
	"ERIF BOLD CAPITAL TMATHEMATICAL SANS-SERIF BOLD CAPITAL UMATHEMATICAL SA" +
	"NS-SERIF BOLD CAPITAL VMATHEMATICAL SANS-SERIF BOLD CAPITAL WMATHEMATICA" +
	"L SANS-SERIF BOLD CAPITAL XMATHEMATICAL SANS-SERIF BOLD CAPITAL YMATHEMA" +
	"TICAL SANS-SERIF BOLD CAPITAL ZMATHEMATICAL SANS-SERIF BOLD SMALL AMATHE" +
	"MATICAL SANS-SERIF BOLD SMALL BMATHEMATICAL SANS-SERIF BOLD SMALL CMATHE" +
	"MATICAL SANS-SERIF BOLD SMALL DMATHEMATICAL SANS-SERIF BOLD SMALL EMATHE" +
	"MATICAL SANS-SERIF BOLD SMALL FMATHEMATICAL SANS-SERIF BOLD SMALL GMATHE" +
	"MATICAL SANS-SERIF BOLD SMALL HMATHEMATICAL SANS-SERIF BOLD SMALL IMATHE" +
	"MATICAL SANS-SERIF BOLD SMALL JMATHEMATICAL SANS-SERIF BOLD SMALL KMATHE" +
	"MATICAL SANS-SERIF BOLD SMALL LMATHEMATICAL SANS-SERIF BOLD SMALL MMATHE" +
	"MATICAL SANS-SERIF BOLD SMALL NMATHEMATICAL SANS-SERIF BOLD SMALL OMATHE" +
	"MATICAL SANS-SERIF BOLD SMALL PMATHEMATICAL SANS-SERIF BOLD SMALL QMATHE") + ("" +
	"MATICAL SANS-SERIF BOLD SMALL RMATHEMATICAL SANS-SERIF BOLD SMALL SMATHE" +
	"MATICAL SANS-SERIF BOLD SMALL TMATHEMATICAL SANS-SERIF BOLD SMALL UMATHE" +
	"MATICAL SANS-SERIF BOLD SMALL VMATHEMATICAL SANS-SERIF BOLD SMALL WMATHE" +
	"MATICAL SANS-SERIF BOLD SMALL XMATHEMATICAL SANS-SERIF BOLD SMALL YMATHE" +
	"MATICAL SANS-SERIF BOLD SMALL ZMATHEMATICAL SANS-SERIF ITALIC CAPITAL AM" +
	"ATHEMATICAL SANS-SERIF ITALIC CAPITAL BMATHEMATICAL SANS-SERIF ITALIC CA" +
	"PITAL CMATHEMATICAL SANS-SERIF ITALIC CAPITAL DMATHEMATICAL SANS-SERIF I" +
	"TALIC CAPITAL EMATHEMATICAL SANS-SERIF ITALIC CAPITAL FMATHEMATICAL SANS" +
	"-SERIF ITALIC CAPITAL GMATHEMATICAL SANS-SERIF ITALIC CAPITAL HMATHEMATI" +
	"CAL SANS-SERIF ITALIC CAPITAL IMATHEMATICAL SANS-SERIF ITALIC CAPITAL JM" +
	"ATHEMATICAL SANS-SERIF ITALIC CAPITAL KMATHEMATICAL SANS-SERIF ITALIC CA" +
	"PITAL LMATHEMATICAL SANS-SERIF ITALIC CAPITAL MMATHEMATICAL SANS-SERIF I" +
	"TALIC CAPITAL NMATHEMATICAL SANS-SERIF ITALIC CAPITAL OMATHEMATICAL SANS" +
	"-SERIF ITALIC CAPITAL PMATHEMATICAL SANS-SERIF ITALIC CAPITAL QMATHEMATI" +
	"CAL SANS-SERIF ITALIC CAPITAL RMATHEMATICAL SANS-SERIF ITALIC CAPITAL SM" +
	"ATHEMATICAL SANS-SERIF ITALIC CAPITAL TMATHEMATICAL SANS-SERIF ITALIC CA" +
	"PITAL UMATHEMATICAL SANS-SERIF ITALIC CAPITAL VMATHEMATICAL SANS-SERIF I" +
	"TALIC CAPITAL WMATHEMATICAL SANS-SERIF ITALIC CAPITAL XMATHEMATICAL SANS" +
	"-SERIF ITALIC CAPITAL YMATHEMATICAL SANS-SERIF ITALIC CAPITAL ZMATHEMATI" +
	"CAL SANS-SERIF ITALIC SMALL AMATHEMATICAL SANS-SERIF ITALIC SMALL BMATHE" +
	"MATICAL SANS-SERIF ITALIC SMALL CMATHEMATICAL SANS-SERIF ITALIC SMALL DM" +
	"ATHEMATICAL SANS-SERIF ITALIC SMALL EMATHEMATICAL SANS-SERIF ITALIC SMAL" +
	"L FMATHEMATICAL SANS-SERIF ITALIC SMALL GMATHEMATICAL SANS-SERIF ITALIC " +
	"SMALL HMATHEMATICAL SANS-SERIF ITALIC SMALL IMATHEMATICAL SANS-SERIF ITA" +
	"LIC SMALL JMATHEMATICAL SANS-SERIF ITALIC SMALL KMATHEMATICAL SANS-SERIF" +
	" ITALIC SMALL LMATHEMATICAL SANS-SERIF ITALIC SMALL MMATHEMATICAL SANS-S" +
	"ERIF ITALIC SMALL NMATHEMATICAL SANS-SERIF ITALIC SMALL OMATHEMATICAL SA" +
	"NS-SERIF ITALIC SMALL PMATHEMATICAL SANS-SERIF ITALIC SMALL QMATHEMATICA" +
	"L SANS-SERIF ITALIC SMALL RMATHEMATICAL SANS-SERIF ITALIC SMALL SMATHEMA" +
	"TICAL SANS-SERIF ITALIC SMALL TMATHEMATICAL SANS-SERIF ITALIC SMALL UMAT" +
	"HEMATICAL SANS-SERIF ITALIC SMALL VMATHEMATICAL SANS-SERIF ITALIC SMALL " +
	"WMATHEMATICAL SANS-SERIF ITALIC SMALL XMATHEMATICAL SANS-SERIF ITALIC SM" +
	"ALL YMATHEMATICAL SANS-SERIF ITALIC SMALL ZMATHEMATICAL SANS-SERIF BOLD " +
	"ITALIC CAPITAL AMATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL BMATHEMATICA" +
	"L SANS-SERIF BOLD ITALIC CAPITAL CMATHEMATICAL SANS-SERIF BOLD ITALIC CA" +
	"PITAL DMATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL EMATHEMATICAL SANS-SE" +
	"RIF BOLD ITALIC CAPITAL FMATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL GMA" +
	"THEMATICAL SANS-SERIF BOLD ITALIC CAPITAL HMATHEMATICAL SANS-SERIF BOLD " +
	"ITALIC CAPITAL IMATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL JMATHEMATICA" +
	"L SANS-SERIF BOLD ITALIC CAPITAL KMATHEMATICAL SANS-SERIF BOLD ITALIC CA" +
	"PITAL LMATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL MMATHEMATICAL SANS-SE" +
	"RIF BOLD ITALIC CAPITAL NMATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL OMA" +
	"THEMATICAL SANS-SERIF BOLD ITALIC CAPITAL PMATHEMATICAL SANS-SERIF BOLD " +
	"ITALIC CAPITAL QMATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL RMATHEMATICA" +
	"L SANS-SERIF BOLD ITALIC CAPITAL SMATHEMATICAL SANS-SERIF BOLD ITALIC CA" +
	"PITAL TMATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL UMATHEMATICAL SANS-SE" +
	"RIF BOLD ITALIC CAPITAL VMATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL WMA" +
	"THEMATICAL SANS-SERIF BOLD ITALIC CAPITAL XMATHEMATICAL SANS-SERIF BOLD " +
	"ITALIC CAPITAL YMATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL ZMATHEMATICA" +
	"L SANS-SERIF BOLD ITALIC SMALL AMATHEMATICAL SANS-SERIF BOLD ITALIC SMAL" +
	"L BMATHEMATICAL SANS-SERIF BOLD ITALIC SMALL CMATHEMATICAL SANS-SERIF BO" +
	"LD ITALIC SMALL DMATHEMATICAL SANS-SERIF BOLD ITALIC SMALL EMATHEMATICAL" +
	" SANS-SERIF BOLD ITALIC SMALL FMATHEMATICAL SANS-SERIF BOLD ITALIC SMALL" +
	" GMATHEMATICAL SANS-SERIF BOLD ITALIC SMALL HMATHEMATICAL SANS-SERIF BOL" +
	"D ITALIC SMALL IMATHEMATICAL SANS-SERIF BOLD ITALIC SMALL JMATHEMATICAL " +
	"SANS-SERIF BOLD ITALIC SMALL KMATHEMATICAL SANS-SERIF BOLD ITALIC SMALL " +
	"LMATHEMATICAL SANS-SERIF BOLD ITALIC SMALL MMATHEMATICAL SANS-SERIF BOLD" +
	" ITALIC SMALL NMATHEMATICAL SANS-SERIF BOLD ITALIC SMALL OMATHEMATICAL S" +
	"ANS-SERIF BOLD ITALIC SMALL PMATHEMATICAL SANS-SERIF BOLD ITALIC SMALL Q" +
	"MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL RMATHEMATICAL SANS-SERIF BOLD " +
	"ITALIC SMALL SMATHEMATICAL SANS-SERIF BOLD ITALIC SMALL TMATHEMATICAL SA" +
	"NS-SERIF BOLD ITALIC SMALL UMATHEMATICAL SANS-SERIF BOLD ITALIC SMALL VM" +
	"ATHEMATICAL SANS-SERIF BOLD ITALIC SMALL WMATHEMATICAL SANS-SERIF BOLD I" +
	"TALIC SMALL XMATHEMATICAL SANS-SERIF BOLD ITALIC SMALL YMATHEMATICAL SAN") + ("" +
	"S-SERIF BOLD ITALIC SMALL ZMATHEMATICAL MONOSPACE CAPITAL AMATHEMATICAL " +
	"MONOSPACE CAPITAL BMATHEMATICAL MONOSPACE CAPITAL CMATHEMATICAL MONOSPAC" +
	"E CAPITAL DMATHEMATICAL MONOSPACE CAPITAL EMATHEMATICAL MONOSPACE CAPITA" +
	"L FMATHEMATICAL MONOSPACE CAPITAL GMATHEMATICAL MONOSPACE CAPITAL HMATHE" +
	"MATICAL MONOSPACE CAPITAL IMATHEMATICAL MONOSPACE CAPITAL JMATHEMATICAL " +
	"MONOSPACE CAPITAL KMATHEMATICAL MONOSPACE CAPITAL LMATHEMATICAL MONOSPAC" +
	"E CAPITAL MMATHEMATICAL MONOSPACE CAPITAL NMATHEMATICAL MONOSPACE CAPITA" +
	"L OMATHEMATICAL MONOSPACE CAPITAL PMATHEMATICAL MONOSPACE CAPITAL QMATHE" +
	"MATICAL MONOSPACE CAPITAL RMATHEMATICAL MONOSPACE CAPITAL SMATHEMATICAL " +
	"MONOSPACE CAPITAL TMATHEMATICAL MONOSPACE CAPITAL UMATHEMATICAL MONOSPAC" +
	"E CAPITAL VMATHEMATICAL MONOSPACE CAPITAL WMATHEMATICAL MONOSPACE CAPITA" +
	"L XMATHEMATICAL MONOSPACE CAPITAL YMATHEMATICAL MONOSPACE CAPITAL ZMATHE" +
	"MATICAL MONOSPACE SMALL AMATHEMATICAL MONOSPACE SMALL BMATHEMATICAL MONO" +
	"SPACE SMALL CMATHEMATICAL MONOSPACE SMALL DMATHEMATICAL MONOSPACE SMALL " +
	"EMATHEMATICAL MONOSPACE SMALL FMATHEMATICAL MONOSPACE SMALL GMATHEMATICA" +
	"L MONOSPACE SMALL HMATHEMATICAL MONOSPACE SMALL IMATHEMATICAL MONOSPACE " +
	"SMALL JMATHEMATICAL MONOSPACE SMALL KMATHEMATICAL MONOSPACE SMALL LMATHE" +
	"MATICAL MONOSPACE SMALL MMATHEMATICAL MONOSPACE SMALL NMATHEMATICAL MONO" +
	"SPACE SMALL OMATHEMATICAL MONOSPACE SMALL PMATHEMATICAL MONOSPACE SMALL " +
	"QMATHEMATICAL MONOSPACE SMALL RMATHEMATICAL MONOSPACE SMALL SMATHEMATICA" +
	"L MONOSPACE SMALL TMATHEMATICAL MONOSPACE SMALL UMATHEMATICAL MONOSPACE " +
	"SMALL VMATHEMATICAL MONOSPACE SMALL WMATHEMATICAL MONOSPACE SMALL XMATHE" +
	"MATICAL MONOSPACE SMALL YMATHEMATICAL MONOSPACE SMALL ZMATHEMATICAL ITAL" +
	"IC SMALL DOTLESS IMATHEMATICAL ITALIC SMALL DOTLESS JMATHEMATICAL BOLD C" +
	"APITAL ALPHAMATHEMATICAL BOLD CAPITAL BETAMATHEMATICAL BOLD CAPITAL GAMM" +
	"AMATHEMATICAL BOLD CAPITAL DELTAMATHEMATICAL BOLD CAPITAL EPSILONMATHEMA" +
	"TICAL BOLD CAPITAL ZETAMATHEMATICAL BOLD CAPITAL ETAMATHEMATICAL BOLD CA" +
	"PITAL THETAMATHEMATICAL BOLD CAPITAL IOTAMATHEMATICAL BOLD CAPITAL KAPPA" +
	"MATHEMATICAL BOLD CAPITAL LAMDAMATHEMATICAL BOLD CAPITAL MUMATHEMATICAL " +
	"BOLD CAPITAL NUMATHEMATICAL BOLD CAPITAL XIMATHEMATICAL BOLD CAPITAL OMI" +
	"CRONMATHEMATICAL BOLD CAPITAL PIMATHEMATICAL BOLD CAPITAL RHOMATHEMATICA" +
	"L BOLD CAPITAL THETA SYMBOLMATHEMATICAL BOLD CAPITAL SIGMAMATHEMATICAL B" +
	"OLD CAPITAL TAUMATHEMATICAL BOLD CAPITAL UPSILONMATHEMATICAL BOLD CAPITA" +
	"L PHIMATHEMATICAL BOLD CAPITAL CHIMATHEMATICAL BOLD CAPITAL PSIMATHEMATI" +
	"CAL BOLD CAPITAL OMEGAMATHEMATICAL BOLD NABLAMATHEMATICAL BOLD SMALL ALP" +
	"HAMATHEMATICAL BOLD SMALL BETAMATHEMATICAL BOLD SMALL GAMMAMATHEMATICAL " +
	"BOLD SMALL DELTAMATHEMATICAL BOLD SMALL EPSILONMATHEMATICAL BOLD SMALL Z" +
	"ETAMATHEMATICAL BOLD SMALL ETAMATHEMATICAL BOLD SMALL THETAMATHEMATICAL " +
	"BOLD SMALL IOTAMATHEMATICAL BOLD SMALL KAPPAMATHEMATICAL BOLD SMALL LAMD" +
	"AMATHEMATICAL BOLD SMALL MUMATHEMATICAL BOLD SMALL NUMATHEMATICAL BOLD S" +
	"MALL XIMATHEMATICAL BOLD SMALL OMICRONMATHEMATICAL BOLD SMALL PIMATHEMAT" +
	"ICAL BOLD SMALL RHOMATHEMATICAL BOLD SMALL FINAL SIGMAMATHEMATICAL BOLD " +
	"SMALL SIGMAMATHEMATICAL BOLD SMALL TAUMATHEMATICAL BOLD SMALL UPSILONMAT" +
	"HEMATICAL BOLD SMALL PHIMATHEMATICAL BOLD SMALL CHIMATHEMATICAL BOLD SMA" +
	"LL PSIMATHEMATICAL BOLD SMALL OMEGAMATHEMATICAL BOLD PARTIAL DIFFERENTIA" +
	"LMATHEMATICAL BOLD EPSILON SYMBOLMATHEMATICAL BOLD THETA SYMBOLMATHEMATI" +
	"CAL BOLD KAPPA SYMBOLMATHEMATICAL BOLD PHI SYMBOLMATHEMATICAL BOLD RHO S" +
	"YMBOLMATHEMATICAL BOLD PI SYMBOLMATHEMATICAL ITALIC CAPITAL ALPHAMATHEMA" +
	"TICAL ITALIC CAPITAL BETAMATHEMATICAL ITALIC CAPITAL GAMMAMATHEMATICAL I" +
	"TALIC CAPITAL DELTAMATHEMATICAL ITALIC CAPITAL EPSILONMATHEMATICAL ITALI" +
	"C CAPITAL ZETAMATHEMATICAL ITALIC CAPITAL ETAMATHEMATICAL ITALIC CAPITAL" +
	" THETAMATHEMATICAL ITALIC CAPITAL IOTAMATHEMATICAL ITALIC CAPITAL KAPPAM" +
	"ATHEMATICAL ITALIC CAPITAL LAMDAMATHEMATICAL ITALIC CAPITAL MUMATHEMATIC" +
	"AL ITALIC CAPITAL NUMATHEMATICAL ITALIC CAPITAL XIMATHEMATICAL ITALIC CA" +
	"PITAL OMICRONMATHEMATICAL ITALIC CAPITAL PIMATHEMATICAL ITALIC CAPITAL R" +
	"HOMATHEMATICAL ITALIC CAPITAL THETA SYMBOLMATHEMATICAL ITALIC CAPITAL SI" +
	"GMAMATHEMATICAL ITALIC CAPITAL TAUMATHEMATICAL ITALIC CAPITAL UPSILONMAT" +
	"HEMATICAL ITALIC CAPITAL PHIMATHEMATICAL ITALIC CAPITAL CHIMATHEMATICAL " +
	"ITALIC CAPITAL PSIMATHEMATICAL ITALIC CAPITAL OMEGAMATHEMATICAL ITALIC N" +
	"ABLAMATHEMATICAL ITALIC SMALL ALPHAMATHEMATICAL ITALIC SMALL BETAMATHEMA" +
	"TICAL ITALIC SMALL GAMMAMATHEMATICAL ITALIC SMALL DELTAMATHEMATICAL ITAL" +
	"IC SMALL EPSILONMATHEMATICAL ITALIC SMALL ZETAMATHEMATICAL ITALIC SMALL " +
	"ETAMATHEMATICAL ITALIC SMALL THETAMATHEMATICAL ITALIC SMALL IOTAMATHEMAT" +
	"ICAL ITALIC SMALL KAPPAMATHEMATICAL ITALIC SMALL LAMDAMATHEMATICAL ITALI") + ("" +
	"C SMALL MUMATHEMATICAL ITALIC SMALL NUMATHEMATICAL ITALIC SMALL XIMATHEM" +
	"ATICAL ITALIC SMALL OMICRONMATHEMATICAL ITALIC SMALL PIMATHEMATICAL ITAL" +
	"IC SMALL RHOMATHEMATICAL ITALIC SMALL FINAL SIGMAMATHEMATICAL ITALIC SMA" +
	"LL SIGMAMATHEMATICAL ITALIC SMALL TAUMATHEMATICAL ITALIC SMALL UPSILONMA" +
	"THEMATICAL ITALIC SMALL PHIMATHEMATICAL ITALIC SMALL CHIMATHEMATICAL ITA" +
	"LIC SMALL PSIMATHEMATICAL ITALIC SMALL OMEGAMATHEMATICAL ITALIC PARTIAL " +
	"DIFFERENTIALMATHEMATICAL ITALIC EPSILON SYMBOLMATHEMATICAL ITALIC THETA " +
	"SYMBOLMATHEMATICAL ITALIC KAPPA SYMBOLMATHEMATICAL ITALIC PHI SYMBOLMATH" +
	"EMATICAL ITALIC RHO SYMBOLMATHEMATICAL ITALIC PI SYMBOLMATHEMATICAL BOLD" +
	" ITALIC CAPITAL ALPHAMATHEMATICAL BOLD ITALIC CAPITAL BETAMATHEMATICAL B" +
	"OLD ITALIC CAPITAL GAMMAMATHEMATICAL BOLD ITALIC CAPITAL DELTAMATHEMATIC" +
	"AL BOLD ITALIC CAPITAL EPSILONMATHEMATICAL BOLD ITALIC CAPITAL ZETAMATHE" +
	"MATICAL BOLD ITALIC CAPITAL ETAMATHEMATICAL BOLD ITALIC CAPITAL THETAMAT" +
	"HEMATICAL BOLD ITALIC CAPITAL IOTAMATHEMATICAL BOLD ITALIC CAPITAL KAPPA" +
	"MATHEMATICAL BOLD ITALIC CAPITAL LAMDAMATHEMATICAL BOLD ITALIC CAPITAL M" +
	"UMATHEMATICAL BOLD ITALIC CAPITAL NUMATHEMATICAL BOLD ITALIC CAPITAL XIM" +
	"ATHEMATICAL BOLD ITALIC CAPITAL OMICRONMATHEMATICAL BOLD ITALIC CAPITAL " +
	"PIMATHEMATICAL BOLD ITALIC CAPITAL RHOMATHEMATICAL BOLD ITALIC CAPITAL T" +
	"HETA SYMBOLMATHEMATICAL BOLD ITALIC CAPITAL SIGMAMATHEMATICAL BOLD ITALI" +
	"C CAPITAL TAUMATHEMATICAL BOLD ITALIC CAPITAL UPSILONMATHEMATICAL BOLD I" +
	"TALIC CAPITAL PHIMATHEMATICAL BOLD ITALIC CAPITAL CHIMATHEMATICAL BOLD I" +
	"TALIC CAPITAL PSIMATHEMATICAL BOLD ITALIC CAPITAL OMEGAMATHEMATICAL BOLD" +
	" ITALIC NABLAMATHEMATICAL BOLD ITALIC SMALL ALPHAMATHEMATICAL BOLD ITALI" +
	"C SMALL BETAMATHEMATICAL BOLD ITALIC SMALL GAMMAMATHEMATICAL BOLD ITALIC" +
	" SMALL DELTAMATHEMATICAL BOLD ITALIC SMALL EPSILONMATHEMATICAL BOLD ITAL" +
	"IC SMALL ZETAMATHEMATICAL BOLD ITALIC SMALL ETAMATHEMATICAL BOLD ITALIC " +
	"