// Copyright 2025 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package authorizedbuyersmarketplace provides access to the Authorized Buyers Marketplace API.
//
// For product documentation, see: https://developers.google.com/authorized-buyers/apis/marketplace/reference/rest/
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/authorizedbuyersmarketplace/v1beta"
//	...
//	ctx := context.Background()
//	authorizedbuyersmarketplaceService, err := authorizedbuyersmarketplace.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	authorizedbuyersmarketplaceService, err := authorizedbuyersmarketplace.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	authorizedbuyersmarketplaceService, err := authorizedbuyersmarketplace.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package authorizedbuyersmarketplace // import "google.golang.org/api/authorizedbuyersmarketplace/v1beta"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "authorizedbuyersmarketplace:v1beta"
const apiName = "authorizedbuyersmarketplace"
const apiVersion = "v1beta"
const basePath = "https://authorizedbuyersmarketplace.googleapis.com/"
const basePathTemplate = "https://authorizedbuyersmarketplace.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://authorizedbuyersmarketplace.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, create, edit, and delete your Authorized Buyers Marketplace entities.
	AuthorizedBuyersMarketplaceScope = "https://www.googleapis.com/auth/authorized-buyers-marketplace"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/authorized-buyers-marketplace",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.Curators = NewCuratorsService(s)
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.TODO(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Curators *CuratorsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewCuratorsService(s *Service) *CuratorsService {
	rs := &CuratorsService{s: s}
	rs.DataSegments = NewCuratorsDataSegmentsService(s)
	return rs
}

type CuratorsService struct {
	s *Service

	DataSegments *CuratorsDataSegmentsService
}

func NewCuratorsDataSegmentsService(s *Service) *CuratorsDataSegmentsService {
	rs := &CuratorsDataSegmentsService{s: s}
	return rs
}

type CuratorsDataSegmentsService struct {
	s *Service
}

// ActivateDataSegmentRequest: Request message for activating a data segment
type ActivateDataSegmentRequest struct {
}

// DataSegment: Defines an identifier for a segment of inventory that can be
// targeted by curators or media planners in the deals or auction packages UI.
// Curation of inventory is done by curators on external platforms.
type DataSegment struct {
	// CpmFee: Optional. A fixed fee charged per thousand impressions. Once set,
	// the currency code cannot be changed.
	CpmFee *Money `json:"cpmFee,omitempty"`
	// CreateTime: Output only. Time the data segment was created.
	CreateTime string `json:"createTime,omitempty"`
	// Name: Immutable. Identifier. The unique identifier for the data segment.
	// Account ID corresponds to the account ID that created the segment. v1alpha
	// format: `buyers/{accountId}/dataSegments/{curatorDataSegmentId}` v1beta
	// format: `curators/{curatorAccountId}/dataSegments/{curatorDataSegmentId}`
	Name string `json:"name,omitempty"`
	// State: Output only. The state of the data segment.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Default value.
	//   "ACTIVE" - The data segment is active.
	//   "INACTIVE" - The data segment is inactive.
	State string `json:"state,omitempty"`
	// UpdateTime: Output only. Time the data segment was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CpmFee") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CpmFee") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DataSegment) MarshalJSON() ([]byte, error) {
	type NoMethod DataSegment
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DeactivateDataSegmentRequest: Request message for deactivating a data
// segment
type DeactivateDataSegmentRequest struct {
}

// ListDataSegmentsResponse: Response message for listing data segments.
type ListDataSegmentsResponse struct {
	// DataSegments: The list of data segments.
	DataSegments []*DataSegment `json:"dataSegments,omitempty"`
	// NextPageToken: Continuation token for fetching the next page of results.
	// Pass this value in the ListDataSegmentsRequest.pageToken field in the
	// subsequent call to the `ListDataSegments` method to retrieve the next page
	// of results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DataSegments") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataSegments") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListDataSegmentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListDataSegmentsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Money: Represents an amount of money with its currency type.
type Money struct {
	// CurrencyCode: The three-letter currency code defined in ISO 4217.
	CurrencyCode string `json:"currencyCode,omitempty"`
	// Nanos: Number of nano (10^-9) units of the amount. The value must be between
	// -999,999,999 and +999,999,999 inclusive. If `units` is positive, `nanos`
	// must be positive or zero. If `units` is zero, `nanos` can be positive, zero,
	// or negative. If `units` is negative, `nanos` must be negative or zero. For
	// example $-1.75 is represented as `units`=-1 and `nanos`=-750,000,000.
	Nanos int64 `json:"nanos,omitempty"`
	// Units: The whole units of the amount. For example if `currencyCode` is
	// "USD", then 1 unit is one US dollar.
	Units int64 `json:"units,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "CurrencyCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CurrencyCode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Money) MarshalJSON() ([]byte, error) {
	type NoMethod Money
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type CuratorsDataSegmentsActivateCall struct {
	s                          *Service
	name                       string
	activatedatasegmentrequest *ActivateDataSegmentRequest
	urlParams_                 gensupport.URLParams
	ctx_                       context.Context
	header_                    http.Header
}

// Activate: Activates a data segment.
//
//   - name: Name of data segment to activate. v1alpha format:
//     `buyers/{accountId}/dataSegments/{curatorDataSegmentId}` v1beta format:
//     `curators/{accountId}/dataSegments/{curatorDataSegmentId}`.
func (r *CuratorsDataSegmentsService) Activate(name string, activatedatasegmentrequest *ActivateDataSegmentRequest) *CuratorsDataSegmentsActivateCall {
	c := &CuratorsDataSegmentsActivateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.activatedatasegmentrequest = activatedatasegmentrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CuratorsDataSegmentsActivateCall) Fields(s ...googleapi.Field) *CuratorsDataSegmentsActivateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CuratorsDataSegmentsActivateCall) Context(ctx context.Context) *CuratorsDataSegmentsActivateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CuratorsDataSegmentsActivateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CuratorsDataSegmentsActivateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.activatedatasegmentrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}:activate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "authorizedbuyersmarketplace.curators.dataSegments.activate", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "authorizedbuyersmarketplace.curators.dataSegments.activate" call.
// Any non-2xx status code is an error. Response headers are in either
// *DataSegment.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CuratorsDataSegmentsActivateCall) Do(opts ...googleapi.CallOption) (*DataSegment, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &DataSegment{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "authorizedbuyersmarketplace.curators.dataSegments.activate", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CuratorsDataSegmentsCreateCall struct {
	s           *Service
	parent      string
	datasegment *DataSegment
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Create: Creates a data segment owned by the listed curator. The data segment
// will be created in the `ACTIVE` state, meaning it will be immediately
// available for buyers to use in preferred deals, private auction deals, and
// auction packages.
//
//   - parent: The parent resource where this data segment will be created.
//     v1alpha format: `buyers/{accountId}` v1beta format: `curators/{accountId}`.
func (r *CuratorsDataSegmentsService) Create(parent string, datasegment *DataSegment) *CuratorsDataSegmentsCreateCall {
	c := &CuratorsDataSegmentsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.datasegment = datasegment
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CuratorsDataSegmentsCreateCall) Fields(s ...googleapi.Field) *CuratorsDataSegmentsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CuratorsDataSegmentsCreateCall) Context(ctx context.Context) *CuratorsDataSegmentsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CuratorsDataSegmentsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CuratorsDataSegmentsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.datasegment)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/dataSegments")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "authorizedbuyersmarketplace.curators.dataSegments.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "authorizedbuyersmarketplace.curators.dataSegments.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *DataSegment.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CuratorsDataSegmentsCreateCall) Do(opts ...googleapi.CallOption) (*DataSegment, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &DataSegment{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "authorizedbuyersmarketplace.curators.dataSegments.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CuratorsDataSegmentsDeactivateCall struct {
	s                            *Service
	name                         string
	deactivatedatasegmentrequest *DeactivateDataSegmentRequest
	urlParams_                   gensupport.URLParams
	ctx_                         context.Context
	header_                      http.Header
}

// Deactivate: Deactivates a data segment.
//
//   - name: Name of data segment to deactivate. v1alpha format:
//     `buyers/{accountId}/dataSegments/{curatorDataSegmentId}` v1beta format:
//     `curators/{accountId}/dataSegments/{curatorDataSegmentId}`.
func (r *CuratorsDataSegmentsService) Deactivate(name string, deactivatedatasegmentrequest *DeactivateDataSegmentRequest) *CuratorsDataSegmentsDeactivateCall {
	c := &CuratorsDataSegmentsDeactivateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.deactivatedatasegmentrequest = deactivatedatasegmentrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CuratorsDataSegmentsDeactivateCall) Fields(s ...googleapi.Field) *CuratorsDataSegmentsDeactivateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CuratorsDataSegmentsDeactivateCall) Context(ctx context.Context) *CuratorsDataSegmentsDeactivateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CuratorsDataSegmentsDeactivateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CuratorsDataSegmentsDeactivateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.deactivatedatasegmentrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}:deactivate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "authorizedbuyersmarketplace.curators.dataSegments.deactivate", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "authorizedbuyersmarketplace.curators.dataSegments.deactivate" call.
// Any non-2xx status code is an error. Response headers are in either
// *DataSegment.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CuratorsDataSegmentsDeactivateCall) Do(opts ...googleapi.CallOption) (*DataSegment, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &DataSegment{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "authorizedbuyersmarketplace.curators.dataSegments.deactivate", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CuratorsDataSegmentsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a data segment given its name.
//
//   - name: Name of data segment to get. v1alpha format:
//     `buyers/{accountId}/dataSegments/{curatorDataSegmentId}` v1beta format:
//     `curators/{accountId}/dataSegments/{curatorDataSegmentId}`.
func (r *CuratorsDataSegmentsService) Get(name string) *CuratorsDataSegmentsGetCall {
	c := &CuratorsDataSegmentsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CuratorsDataSegmentsGetCall) Fields(s ...googleapi.Field) *CuratorsDataSegmentsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CuratorsDataSegmentsGetCall) IfNoneMatch(entityTag string) *CuratorsDataSegmentsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CuratorsDataSegmentsGetCall) Context(ctx context.Context) *CuratorsDataSegmentsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CuratorsDataSegmentsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CuratorsDataSegmentsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "authorizedbuyersmarketplace.curators.dataSegments.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "authorizedbuyersmarketplace.curators.dataSegments.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *DataSegment.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CuratorsDataSegmentsGetCall) Do(opts ...googleapi.CallOption) (*DataSegment, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &DataSegment{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "authorizedbuyersmarketplace.curators.dataSegments.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type CuratorsDataSegmentsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: List the data segments owned by a curator.
//
//   - parent: Name of the parent curator that can access the data segment.
//     v1alpha format: `buyers/{accountId}` v1beta format: `curators/{accountId}`.
func (r *CuratorsDataSegmentsService) List(parent string) *CuratorsDataSegmentsListCall {
	c := &CuratorsDataSegmentsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size. The
// server may return fewer results than requested. Max allowed page size is
// 500. If unspecified, the server will default to 500.
func (c *CuratorsDataSegmentsListCall) PageSize(pageSize int64) *CuratorsDataSegmentsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The page token as
// returned. ListDataSegmentsResponse.nextPageToken
func (c *CuratorsDataSegmentsListCall) PageToken(pageToken string) *CuratorsDataSegmentsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CuratorsDataSegmentsListCall) Fields(s ...googleapi.Field) *CuratorsDataSegmentsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *CuratorsDataSegmentsListCall) IfNoneMatch(entityTag string) *CuratorsDataSegmentsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CuratorsDataSegmentsListCall) Context(ctx context.Context) *CuratorsDataSegmentsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CuratorsDataSegmentsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CuratorsDataSegmentsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/dataSegments")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "authorizedbuyersmarketplace.curators.dataSegments.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "authorizedbuyersmarketplace.curators.dataSegments.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListDataSegmentsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *CuratorsDataSegmentsListCall) Do(opts ...googleapi.CallOption) (*ListDataSegmentsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListDataSegmentsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "authorizedbuyersmarketplace.curators.dataSegments.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *CuratorsDataSegmentsListCall) Pages(ctx context.Context, f func(*ListDataSegmentsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type CuratorsDataSegmentsPatchCall struct {
	s           *Service
	nameid      string
	datasegment *DataSegment
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Patch: Updates a data segment.
//
//   - name: Immutable. Identifier. The unique identifier for the data segment.
//     Account ID corresponds to the account ID that created the segment. v1alpha
//     format: `buyers/{accountId}/dataSegments/{curatorDataSegmentId}` v1beta
//     format: `curators/{curatorAccountId}/dataSegments/{curatorDataSegmentId}`.
func (r *CuratorsDataSegmentsService) Patch(nameid string, datasegment *DataSegment) *CuratorsDataSegmentsPatchCall {
	c := &CuratorsDataSegmentsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.nameid = nameid
	c.datasegment = datasegment
	return c
}

// UpdateMask sets the optional parameter "updateMask": List of fields to be
// updated. If empty or unspecified, the service will update all fields
// populated in the update request excluding the output only fields and
// primitive fields with default value. Note that explicit field mask is
// required in order to reset a primitive field back to its default value, for
// example, false for boolean fields, 0 for integer fields. A special field
// mask consisting of a single path "*" can be used to indicate full
// replacement(the equivalent of PUT method), updatable fields unset or
// unspecified in the input will be cleared or set to default value. Output
// only fields will be ignored regardless of the value of updateMask.
func (c *CuratorsDataSegmentsPatchCall) UpdateMask(updateMask string) *CuratorsDataSegmentsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *CuratorsDataSegmentsPatchCall) Fields(s ...googleapi.Field) *CuratorsDataSegmentsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *CuratorsDataSegmentsPatchCall) Context(ctx context.Context) *CuratorsDataSegmentsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *CuratorsDataSegmentsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CuratorsDataSegmentsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.datasegment)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.nameid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "authorizedbuyersmarketplace.curators.dataSegments.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "authorizedbuyersmarketplace.curators.dataSegments.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *DataSegment.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *CuratorsDataSegmentsPatchCall) Do(opts ...googleapi.CallOption) (*DataSegment, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &DataSegment{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "authorizedbuyersmarketplace.curators.dataSegments.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}
