// Code generated by go generate. DO NOT EDIT.

package opt

import (
	"encoding/json"
	"testing"

	"github.com/algolia/algoliasearch-client-go/v3/algolia/opt"
	"github.com/stretchr/testify/require"
)

func TestHighlightPostTag(t *testing.T) {
	for _, c := range []struct {
		opts     []interface{}
		expected *opt.HighlightPostTagOption
	}{
		{
			opts:     []interface{}{nil},
			expected: opt.HighlightPostTag("</em>"),
		},
		{
			opts:     []interface{}{opt.HighlightPostTag("")},
			expected: opt.HighlightPostTag(""),
		},
		{
			opts:     []interface{}{opt.HighlightPostTag("content of the string value")},
			expected: opt.HighlightPostTag("content of the string value"),
		},
	} {
		var (
			in  = ExtractHighlightPostTag(c.opts...)
			out opt.HighlightPostTagOption
		)
		data, err := json.Marshal(&in)
		require.NoError(t, err)
		err = json.Unmarshal(data, &out)
		require.NoError(t, err)
		require.Equal(t, *c.expected, out)
	}
}
