// Code generated by go generate. DO NOT EDIT.

package opt

import "encoding/json"

// EnabledOption is a wrapper for an Enabled option parameter. It holds
// the actual value of the option that can be accessed by calling Get.
type EnabledOption struct {
	value bool
}

// Enabled wraps the given value into a EnabledOption.
func Enabled(v bool) *EnabledOption {
	return &EnabledOption{v}
}

// Get retrieves the actual value of the option parameter.
func (o *EnabledOption) Get() bool {
	if o == nil {
		return true
	}
	return o.value
}

// MarshalJSON implements the json.Marshaler interface for
// EnabledOption.
func (o EnabledOption) MarshalJSON() ([]byte, error) {
	return json.Marshal(o.value)
}

// UnmarshalJSON implements the json.Unmarshaler interface for
// EnabledOption.
func (o *EnabledOption) UnmarshalJSON(data []byte) error {
	if string(data) == "null" {
		o.value = true
		return nil
	}
	return json.Unmarshal(data, &o.value)
}

// Equal returns true if the given option is equal to the instance one. In case
// the given option is nil, we checked the instance one is set to the default
// value of the option.
func (o *EnabledOption) Equal(o2 *EnabledOption) bool {
	if o == nil {
		return o2 == nil || o2.value == true
	}
	if o2 == nil {
		return o == nil || o.value == true
	}
	return o.value == o2.value
}

// EnabledEqual returns true if the two options are equal.
// In case of one option being nil, the value of the other must be nil as well
// or be set to the default value of this option.
func EnabledEqual(o1, o2 *EnabledOption) bool {
	return o1.Equal(o2)
}
