// Code generated by go generate. DO NOT EDIT.

package opt

import "encoding/json"

// IndexSuffixOption is a wrapper for an IndexSuffix option parameter. It holds
// the actual value of the option that can be accessed by calling Get.
type IndexSuffixOption struct {
	value string
}

// IndexSuffix wraps the given value into a IndexSuffixOption.
func IndexSuffix(v string) *IndexSuffixOption {
	return &IndexSuffixOption{v}
}

// Get retrieves the actual value of the option parameter.
func (o *IndexSuffixOption) Get() string {
	if o == nil {
		return ""
	}
	return o.value
}

// MarshalJSON implements the json.Marshaler interface for
// IndexSuffixOption.
func (o IndexSuffixOption) MarshalJSON() ([]byte, error) {
	return json.Marshal(o.value)
}

// UnmarshalJSON implements the json.Unmarshaler interface for
// IndexSuffixOption.
func (o *IndexSuffixOption) UnmarshalJSON(data []byte) error {
	if string(data) == "null" {
		o.value = ""
		return nil
	}
	return json.Unmarshal(data, &o.value)
}

// Equal returns true if the given option is equal to the instance one. In case
// the given option is nil, we checked the instance one is set to the default
// value of the option.
func (o *IndexSuffixOption) Equal(o2 *IndexSuffixOption) bool {
	if o == nil {
		return o2 == nil || o2.value == ""
	}
	if o2 == nil {
		return o == nil || o.value == ""
	}
	return o.value == o2.value
}

// IndexSuffixEqual returns true if the two options are equal.
// In case of one option being nil, the value of the other must be nil as well
// or be set to the default value of this option.
func IndexSuffixEqual(o1, o2 *IndexSuffixOption) bool {
	return o1.Equal(o2)
}
