// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.6.1
// - protoc             v3.21.12
// source: yandex/cloud/baremetal/v1alpha/server_service.proto

package baremetal

import (
	context "context"
	operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.64.0 or later.
const _ = grpc.SupportPackageIsVersion9

const (
	ServerService_Get_FullMethodName               = "/yandex.cloud.baremetal.v1alpha.ServerService/Get"
	ServerService_List_FullMethodName              = "/yandex.cloud.baremetal.v1alpha.ServerService/List"
	ServerService_Create_FullMethodName            = "/yandex.cloud.baremetal.v1alpha.ServerService/Create"
	ServerService_BatchCreate_FullMethodName       = "/yandex.cloud.baremetal.v1alpha.ServerService/BatchCreate"
	ServerService_Update_FullMethodName            = "/yandex.cloud.baremetal.v1alpha.ServerService/Update"
	ServerService_PowerOff_FullMethodName          = "/yandex.cloud.baremetal.v1alpha.ServerService/PowerOff"
	ServerService_PowerOn_FullMethodName           = "/yandex.cloud.baremetal.v1alpha.ServerService/PowerOn"
	ServerService_Reboot_FullMethodName            = "/yandex.cloud.baremetal.v1alpha.ServerService/Reboot"
	ServerService_Reinstall_FullMethodName         = "/yandex.cloud.baremetal.v1alpha.ServerService/Reinstall"
	ServerService_StartProlongation_FullMethodName = "/yandex.cloud.baremetal.v1alpha.ServerService/StartProlongation"
	ServerService_StopProlongation_FullMethodName  = "/yandex.cloud.baremetal.v1alpha.ServerService/StopProlongation"
	ServerService_ListOperations_FullMethodName    = "/yandex.cloud.baremetal.v1alpha.ServerService/ListOperations"
)

// ServerServiceClient is the client API for ServerService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
//
// A set of methods for managing Server resources.
type ServerServiceClient interface {
	// Returns the specific Server resource.
	//
	// To get the list of available Server resources, make a [List] request.
	Get(ctx context.Context, in *GetServerRequest, opts ...grpc.CallOption) (*Server, error)
	// Retrieves the list of Server resources in the specified folder.
	List(ctx context.Context, in *ListServerRequest, opts ...grpc.CallOption) (*ListServerResponse, error)
	// Creates a server in the specified folder.
	Create(ctx context.Context, in *CreateServerRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Creates multiple servers in the specified folder.
	BatchCreate(ctx context.Context, in *BatchCreateServersRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Updates the specified server.
	Update(ctx context.Context, in *UpdateServerRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// (-- api-linter: yc::1702::method-verb-prefix=disabled
	//
	//	Required for backward compatibility with old clients. --)
	//
	// Powers off the specified server.
	PowerOff(ctx context.Context, in *PowerOffServerRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// (-- api-linter: yc::1702::method-verb-prefix=disabled
	//
	//	Required for backward compatibility with old clients. --)
	//
	// Powers on the specified server.
	PowerOn(ctx context.Context, in *PowerOnServerRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// (-- api-linter: yc::1702::method-verb-prefix=disabled
	//
	//	Required for backward compatibility with old clients. --)
	//
	// Reboots the specified server.
	Reboot(ctx context.Context, in *RebootServerRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// (-- api-linter: yc::1702::method-verb-prefix=disabled
	//
	//	Required for backward compatibility with old clients. --)
	//
	// Reinstalls the specified server.
	Reinstall(ctx context.Context, in *ReinstallServerRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Starts prolongation of the specified server.
	StartProlongation(ctx context.Context, in *StartProlongationRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Stops prolongation of the specified server.
	StopProlongation(ctx context.Context, in *StopProlongationRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Lists operations for the specified server.
	ListOperations(ctx context.Context, in *ListServerOperationsRequest, opts ...grpc.CallOption) (*ListServerOperationsResponse, error)
}

type serverServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewServerServiceClient(cc grpc.ClientConnInterface) ServerServiceClient {
	return &serverServiceClient{cc}
}

func (c *serverServiceClient) Get(ctx context.Context, in *GetServerRequest, opts ...grpc.CallOption) (*Server, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Server)
	err := c.cc.Invoke(ctx, ServerService_Get_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serverServiceClient) List(ctx context.Context, in *ListServerRequest, opts ...grpc.CallOption) (*ListServerResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ListServerResponse)
	err := c.cc.Invoke(ctx, ServerService_List_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serverServiceClient) Create(ctx context.Context, in *CreateServerRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, ServerService_Create_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serverServiceClient) BatchCreate(ctx context.Context, in *BatchCreateServersRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, ServerService_BatchCreate_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serverServiceClient) Update(ctx context.Context, in *UpdateServerRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, ServerService_Update_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serverServiceClient) PowerOff(ctx context.Context, in *PowerOffServerRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, ServerService_PowerOff_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serverServiceClient) PowerOn(ctx context.Context, in *PowerOnServerRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, ServerService_PowerOn_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serverServiceClient) Reboot(ctx context.Context, in *RebootServerRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, ServerService_Reboot_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serverServiceClient) Reinstall(ctx context.Context, in *ReinstallServerRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, ServerService_Reinstall_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serverServiceClient) StartProlongation(ctx context.Context, in *StartProlongationRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, ServerService_StartProlongation_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serverServiceClient) StopProlongation(ctx context.Context, in *StopProlongationRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, ServerService_StopProlongation_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serverServiceClient) ListOperations(ctx context.Context, in *ListServerOperationsRequest, opts ...grpc.CallOption) (*ListServerOperationsResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ListServerOperationsResponse)
	err := c.cc.Invoke(ctx, ServerService_ListOperations_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ServerServiceServer is the server API for ServerService service.
// All implementations should embed UnimplementedServerServiceServer
// for forward compatibility.
//
// A set of methods for managing Server resources.
type ServerServiceServer interface {
	// Returns the specific Server resource.
	//
	// To get the list of available Server resources, make a [List] request.
	Get(context.Context, *GetServerRequest) (*Server, error)
	// Retrieves the list of Server resources in the specified folder.
	List(context.Context, *ListServerRequest) (*ListServerResponse, error)
	// Creates a server in the specified folder.
	Create(context.Context, *CreateServerRequest) (*operation.Operation, error)
	// Creates multiple servers in the specified folder.
	BatchCreate(context.Context, *BatchCreateServersRequest) (*operation.Operation, error)
	// Updates the specified server.
	Update(context.Context, *UpdateServerRequest) (*operation.Operation, error)
	// (-- api-linter: yc::1702::method-verb-prefix=disabled
	//
	//	Required for backward compatibility with old clients. --)
	//
	// Powers off the specified server.
	PowerOff(context.Context, *PowerOffServerRequest) (*operation.Operation, error)
	// (-- api-linter: yc::1702::method-verb-prefix=disabled
	//
	//	Required for backward compatibility with old clients. --)
	//
	// Powers on the specified server.
	PowerOn(context.Context, *PowerOnServerRequest) (*operation.Operation, error)
	// (-- api-linter: yc::1702::method-verb-prefix=disabled
	//
	//	Required for backward compatibility with old clients. --)
	//
	// Reboots the specified server.
	Reboot(context.Context, *RebootServerRequest) (*operation.Operation, error)
	// (-- api-linter: yc::1702::method-verb-prefix=disabled
	//
	//	Required for backward compatibility with old clients. --)
	//
	// Reinstalls the specified server.
	Reinstall(context.Context, *ReinstallServerRequest) (*operation.Operation, error)
	// Starts prolongation of the specified server.
	StartProlongation(context.Context, *StartProlongationRequest) (*operation.Operation, error)
	// Stops prolongation of the specified server.
	StopProlongation(context.Context, *StopProlongationRequest) (*operation.Operation, error)
	// Lists operations for the specified server.
	ListOperations(context.Context, *ListServerOperationsRequest) (*ListServerOperationsResponse, error)
}

// UnimplementedServerServiceServer should be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedServerServiceServer struct{}

func (UnimplementedServerServiceServer) Get(context.Context, *GetServerRequest) (*Server, error) {
	return nil, status.Error(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedServerServiceServer) List(context.Context, *ListServerRequest) (*ListServerResponse, error) {
	return nil, status.Error(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedServerServiceServer) Create(context.Context, *CreateServerRequest) (*operation.Operation, error) {
	return nil, status.Error(codes.Unimplemented, "method Create not implemented")
}
func (UnimplementedServerServiceServer) BatchCreate(context.Context, *BatchCreateServersRequest) (*operation.Operation, error) {
	return nil, status.Error(codes.Unimplemented, "method BatchCreate not implemented")
}
func (UnimplementedServerServiceServer) Update(context.Context, *UpdateServerRequest) (*operation.Operation, error) {
	return nil, status.Error(codes.Unimplemented, "method Update not implemented")
}
func (UnimplementedServerServiceServer) PowerOff(context.Context, *PowerOffServerRequest) (*operation.Operation, error) {
	return nil, status.Error(codes.Unimplemented, "method PowerOff not implemented")
}
func (UnimplementedServerServiceServer) PowerOn(context.Context, *PowerOnServerRequest) (*operation.Operation, error) {
	return nil, status.Error(codes.Unimplemented, "method PowerOn not implemented")
}
func (UnimplementedServerServiceServer) Reboot(context.Context, *RebootServerRequest) (*operation.Operation, error) {
	return nil, status.Error(codes.Unimplemented, "method Reboot not implemented")
}
func (UnimplementedServerServiceServer) Reinstall(context.Context, *ReinstallServerRequest) (*operation.Operation, error) {
	return nil, status.Error(codes.Unimplemented, "method Reinstall not implemented")
}
func (UnimplementedServerServiceServer) StartProlongation(context.Context, *StartProlongationRequest) (*operation.Operation, error) {
	return nil, status.Error(codes.Unimplemented, "method StartProlongation not implemented")
}
func (UnimplementedServerServiceServer) StopProlongation(context.Context, *StopProlongationRequest) (*operation.Operation, error) {
	return nil, status.Error(codes.Unimplemented, "method StopProlongation not implemented")
}
func (UnimplementedServerServiceServer) ListOperations(context.Context, *ListServerOperationsRequest) (*ListServerOperationsResponse, error) {
	return nil, status.Error(codes.Unimplemented, "method ListOperations not implemented")
}
func (UnimplementedServerServiceServer) testEmbeddedByValue() {}

// UnsafeServerServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ServerServiceServer will
// result in compilation errors.
type UnsafeServerServiceServer interface {
	mustEmbedUnimplementedServerServiceServer()
}

func RegisterServerServiceServer(s grpc.ServiceRegistrar, srv ServerServiceServer) {
	// If the following call panics, it indicates UnimplementedServerServiceServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&ServerService_ServiceDesc, srv)
}

func _ServerService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetServerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServerServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ServerService_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServerServiceServer).Get(ctx, req.(*GetServerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServerService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListServerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServerServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ServerService_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServerServiceServer).List(ctx, req.(*ListServerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServerService_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateServerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServerServiceServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ServerService_Create_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServerServiceServer).Create(ctx, req.(*CreateServerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServerService_BatchCreate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchCreateServersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServerServiceServer).BatchCreate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ServerService_BatchCreate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServerServiceServer).BatchCreate(ctx, req.(*BatchCreateServersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServerService_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateServerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServerServiceServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ServerService_Update_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServerServiceServer).Update(ctx, req.(*UpdateServerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServerService_PowerOff_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PowerOffServerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServerServiceServer).PowerOff(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ServerService_PowerOff_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServerServiceServer).PowerOff(ctx, req.(*PowerOffServerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServerService_PowerOn_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PowerOnServerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServerServiceServer).PowerOn(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ServerService_PowerOn_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServerServiceServer).PowerOn(ctx, req.(*PowerOnServerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServerService_Reboot_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RebootServerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServerServiceServer).Reboot(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ServerService_Reboot_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServerServiceServer).Reboot(ctx, req.(*RebootServerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServerService_Reinstall_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReinstallServerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServerServiceServer).Reinstall(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ServerService_Reinstall_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServerServiceServer).Reinstall(ctx, req.(*ReinstallServerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServerService_StartProlongation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StartProlongationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServerServiceServer).StartProlongation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ServerService_StartProlongation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServerServiceServer).StartProlongation(ctx, req.(*StartProlongationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServerService_StopProlongation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StopProlongationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServerServiceServer).StopProlongation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ServerService_StopProlongation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServerServiceServer).StopProlongation(ctx, req.(*StopProlongationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServerService_ListOperations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListServerOperationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServerServiceServer).ListOperations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ServerService_ListOperations_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServerServiceServer).ListOperations(ctx, req.(*ListServerOperationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// ServerService_ServiceDesc is the grpc.ServiceDesc for ServerService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ServerService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "yandex.cloud.baremetal.v1alpha.ServerService",
	HandlerType: (*ServerServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Get",
			Handler:    _ServerService_Get_Handler,
		},
		{
			MethodName: "List",
			Handler:    _ServerService_List_Handler,
		},
		{
			MethodName: "Create",
			Handler:    _ServerService_Create_Handler,
		},
		{
			MethodName: "BatchCreate",
			Handler:    _ServerService_BatchCreate_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _ServerService_Update_Handler,
		},
		{
			MethodName: "PowerOff",
			Handler:    _ServerService_PowerOff_Handler,
		},
		{
			MethodName: "PowerOn",
			Handler:    _ServerService_PowerOn_Handler,
		},
		{
			MethodName: "Reboot",
			Handler:    _ServerService_Reboot_Handler,
		},
		{
			MethodName: "Reinstall",
			Handler:    _ServerService_Reinstall_Handler,
		},
		{
			MethodName: "StartProlongation",
			Handler:    _ServerService_StartProlongation_Handler,
		},
		{
			MethodName: "StopProlongation",
			Handler:    _ServerService_StopProlongation_Handler,
		},
		{
			MethodName: "ListOperations",
			Handler:    _ServerService_ListOperations_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "yandex/cloud/baremetal/v1alpha/server_service.proto",
}
