// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.6.1
// - protoc             v3.21.12
// source: yandex/cloud/billing/usage_records/v1/consumption_core_service.proto

package usageRecords

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.64.0 or later.
const _ = grpc.SupportPackageIsVersion9

const (
	ConsumptionCoreService_GetBillingAccountUsageReport_FullMethodName = "/yandex.cloud.billing.usage_records.v1.ConsumptionCoreService/GetBillingAccountUsageReport"
	ConsumptionCoreService_GetCloudUsageReport_FullMethodName          = "/yandex.cloud.billing.usage_records.v1.ConsumptionCoreService/GetCloudUsageReport"
	ConsumptionCoreService_GetFolderUsageReport_FullMethodName         = "/yandex.cloud.billing.usage_records.v1.ConsumptionCoreService/GetFolderUsageReport"
	ConsumptionCoreService_GetServiceUsageReport_FullMethodName        = "/yandex.cloud.billing.usage_records.v1.ConsumptionCoreService/GetServiceUsageReport"
	ConsumptionCoreService_GetSKUUsageReport_FullMethodName            = "/yandex.cloud.billing.usage_records.v1.ConsumptionCoreService/GetSKUUsageReport"
	ConsumptionCoreService_GetResourceUsageReport_FullMethodName       = "/yandex.cloud.billing.usage_records.v1.ConsumptionCoreService/GetResourceUsageReport"
	ConsumptionCoreService_GetLabelKeyUsageReport_FullMethodName       = "/yandex.cloud.billing.usage_records.v1.ConsumptionCoreService/GetLabelKeyUsageReport"
)

// ConsumptionCoreServiceClient is the client API for ConsumptionCoreService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
//
// Service for detailed consumption and usage reporting.
//
// The ConsumptionCoreService provides a comprehensive set of methods for retrieving detailed
// usage and billing information for different entities within a billing account hierarchy.
// Each method offers aggregated data for specific entity types (a billing account, clouds,
// folders, services, SKUs, resources, or labels) with support for various filtering options
// and aggregation periods. Note that each request targets a single billing account.
//
// All methods in this service follow the same three-level response structure:
//  1. Overall totals for the entire request period (cost, credits, expense)
//  2. Entity-level totals - summary data for each entity of the requested type
//  3. Time series data - periodic breakdown for each entity according to the specified aggregation period
//     (controlled by the aggregation_period request parameter: day/week/month/quarter/year)
//
// These methods help customers and internal teams analyze usage patterns, track expenses,
// monitor resource consumption, and generate detailed billing reports. The service
// supports filtering by entity IDs, date ranges, labels, and other parameters to provide
// targeted insights into cloud resource usage.
//
// Required permissions:
// All methods in this service require one of the following permissions on the specified billing account:
// - `billing.accounts.getReport`
//
// Rate limits:
// This API is limited to 1 request per minute per IP address.
type ConsumptionCoreServiceClient interface {
	// Returns aggregated usage report for a single specified billing account,
	// optionally filtered by clouds, folders, SKUs, labels, and period granularity.
	//
	// This method provides a comprehensive view of all usage and costs for a specific
	// billing account, with options to filter data by various entity types and to aggregate
	// results at different time granularities (daily, monthly, etc.).
	//
	// Implementation details:
	// - The report includes the total cost, applied credits (monetary grants, volume incentives, committed use discounts, and free credits), and final expense
	// - Results can be filtered by cloud IDs, folder IDs, service IDs, SKU IDs, resource IDs, or labels
	// - All applicable filters from the request will be applied (with AND logic between different filter types)
	// - Time-based data is grouped according to the specified aggregation period
	//
	// Error handling:
	// - Returns INVALID_ARGUMENT if the request parameters fail validation
	// - Returns UNAUTHENTICATED if the user is not authenticated or the billing account does not exist
	// - Returns PERMISSION_DENIED if the user lacks required permissions
	// - Returns INTERNAL for internal server errors
	GetBillingAccountUsageReport(ctx context.Context, in *UsageReportRequest, opts ...grpc.CallOption) (*BillingAccountUsageReportResponse, error)
	// Returns aggregated usage report for the specified clouds
	// under the specified billing account.
	//
	// This method provides detailed usage and cost information grouped by clouds
	// within the specified billing account. The data can be filtered by various
	// entity types and aggregated at different time granularities.
	//
	// Implementation details:
	// - Results are organized by cloud, with each cloud's usage, costs, and credits detailed
	// - If cloud_ids are specified, only data for those clouds is included (using OR logic)
	// - When no cloud_ids are specified, data for all clouds under the billing account is returned
	// - Other filters (folder_ids, service_ids, sku_ids, resource_ids, labels) are always applied if present
	// - Hierarchical data structure allows analyzing costs across the organization's cloud resources
	//
	// Error handling:
	// - Returns INVALID_ARGUMENT if the request parameters fail validation
	// - Returns UNAUTHENTICATED if the user is not authenticated or the billing account does not exist
	// - Returns PERMISSION_DENIED if the user lacks required permissions
	// - Returns INTERNAL for internal server errors
	GetCloudUsageReport(ctx context.Context, in *UsageReportRequest, opts ...grpc.CallOption) (*CloudUsageReportResponse, error)
	// Returns aggregated usage report for the specified folders
	// under the specified billing account.
	//
	// This method provides detailed usage and cost information grouped by folders
	// within the specified billing account. The data can be filtered by various
	// entity types and aggregated at different time granularities.
	//
	// Implementation details:
	// - Results are organized by folder, with each folder's usage, costs, and credits detailed
	// - If folder_ids are specified, only data for those folders is included (using OR logic)
	// - When no folder_ids are specified, data for all folders under the billing account is returned
	// - Other filters (cloud_ids, service_ids, sku_ids, resource_ids, labels) are always applied if present
	// - Provides visibility into costs at the project/folder level within your organization
	//
	// Error handling:
	// - Returns INVALID_ARGUMENT if the request parameters fail validation
	// - Returns UNAUTHENTICATED if the user is not authenticated or the billing account does not exist
	// - Returns PERMISSION_DENIED if the user lacks required permissions
	// - Returns INTERNAL for internal server errors
	//
	// Required permissions:
	// - `billing.accounts.getReport` on the specified billing account
	GetFolderUsageReport(ctx context.Context, in *UsageReportRequest, opts ...grpc.CallOption) (*FolderUsageReportResponse, error)
	// Returns aggregated usage report for the specified services
	// under the specified billing account.
	//
	// This method provides detailed usage and cost information grouped by services
	// within the specified billing account. Services represent broad product categories
	// (like Compute, Storage, AI, etc.) that contain multiple SKUs. The data can be
	// filtered by various entity types and aggregated at different time granularities.
	//
	// Implementation details:
	// - Results are organized by service, with each service's usage, costs, and credits detailed
	// - If service_ids are specified, only data for those services is included (using OR logic)
	// - When no service_ids are specified, data for all services under the billing account is returned
	// - Other filters (cloud_ids, folder_ids, sku_ids, resource_ids, labels) are always applied if present
	// - Service data includes the service name and description
	// - Helps identify which cloud services are driving your overall costs
	//
	// Error handling:
	// - Returns INVALID_ARGUMENT if the request parameters fail validation
	// - Returns UNAUTHENTICATED if the user is not authenticated or the billing account does not exist
	// - Returns PERMISSION_DENIED if the user lacks required permissions
	// - Returns INTERNAL for internal server errors
	GetServiceUsageReport(ctx context.Context, in *UsageReportRequest, opts ...grpc.CallOption) (*ServiceUsageReportResponse, error)
	// Returns aggregated usage report by SKU (Stock Keeping Unit)
	// under the specified billing account.
	//
	// This method provides detailed usage and cost information grouped by SKUs
	// within the specified billing account. SKUs are specific billable product offerings
	// (such as specific VM types, disk types, or AI models) that belong to a parent service.
	// The data can be filtered by various entity types and aggregated at different time granularities.
	//
	// Implementation details:
	// - Results are organized by SKU, with each SKU's usage, costs, and credits detailed
	// - If sku_ids are specified, only data for those SKUs is included (using OR logic)
	// - When no sku_ids are specified, data for all SKUs under the billing account is returned
	// - Other filters (cloud_ids, folder_ids, service_ids, resource_ids, labels) are always applied if present
	// - SKU data includes pricing quantity, unit of measurement, and translated display names
	// - Provides the most granular view of which specific product offerings are generating costs
	//
	// Error handling:
	// - Returns INVALID_ARGUMENT if the request parameters fail validation
	// - Returns UNAUTHENTICATED if the user is not authenticated or the billing account does not exist
	// - Returns PERMISSION_DENIED if the user lacks required permissions
	// - Returns INTERNAL for internal server errors
	GetSKUUsageReport(ctx context.Context, in *UsageReportRequest, opts ...grpc.CallOption) (*SKUUsageReportResponse, error)
	// Returns aggregated usage report by individual resource
	// under the specified billing account.
	//
	// This method provides detailed usage and cost information grouped by individual resources
	// within the specified billing account. The data can be filtered by various
	// entity types and aggregated at different time granularities.
	//
	// Implementation details:
	// - Results are organized by resource, with each resource's usage, costs, and credits detailed
	// - If resource_ids are specified, only data for those resources is included (using OR logic)
	// - When no resource_ids are specified, data for all resources under the billing account is returned
	// - Other filters (cloud_ids, folder_ids, service_ids, sku_ids, labels) are always applied if present
	// - This provides the most granular view of costs as it breaks down to the individual resource level
	// - Enables precise cost analysis at the individual resource instance level (specific VMs, disks, etc.)
	//
	// Error handling:
	// - Returns INVALID_ARGUMENT if the request parameters fail validation
	// - Returns UNAUTHENTICATED if the user is not authenticated or the billing account does not exist
	// - Returns PERMISSION_DENIED if the user lacks required permissions
	// - Returns INTERNAL for internal server errors
	GetResourceUsageReport(ctx context.Context, in *UsageReportRequest, opts ...grpc.CallOption) (*ResourceUsageReportResponse, error)
	// Returns aggregated usage report by label keys and values
	// under the specified billing account.
	//
	// This method provides detailed usage and cost information grouped by label key-value pairs
	// within the specified billing account. Labels are user-defined metadata tags attached to resources
	// (such as VMs, disks, etc.) in the form of key-value pairs (e.g., "env:prod", "region:us-west").
	// The data can be filtered by various entity types and aggregated at different time granularities.
	//
	// Implementation details:
	//   - Results are organized by label key-value pairs, with usage, costs, and credits detailed for each
	//   - If labels filter is specified, only data for matching labels is included
	//   - Other filters (cloud_ids, folder_ids, service_ids, sku_ids, resource_ids) are always applied if present
	//   - Resources can have multiple labels attached (e.g., a VM might have "env:prod", "team:finance", "region:us")
	//   - If a resource has multiple labels at the same point in time, the usage and cost metrics are reported for each label separately.
	//     In other words, the same resource's cost is **duplicated** across its labels rather than split. For example,
	//     if a VM costs 90 units and has 3 labels, the report will show 90 units for each label, not 30 units per label.
	//   - This allows for custom business dimensions analysis based on resource tagging
	//   - Usage data is aggregated for all resources that share the same label
	//   - Particularly useful for cost allocation and chargeback across business units, environments, or projects
	//
	// Error handling:
	// - Returns INVALID_ARGUMENT if the request parameters fail validation
	// - Returns UNAUTHENTICATED if the user is not authenticated or the billing account does not exist
	// - Returns PERMISSION_DENIED if the user lacks required permissions
	// - Returns INTERNAL for internal server errors
	GetLabelKeyUsageReport(ctx context.Context, in *UsageReportRequest, opts ...grpc.CallOption) (*LabelKeyUsageReportResponse, error)
}

type consumptionCoreServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewConsumptionCoreServiceClient(cc grpc.ClientConnInterface) ConsumptionCoreServiceClient {
	return &consumptionCoreServiceClient{cc}
}

func (c *consumptionCoreServiceClient) GetBillingAccountUsageReport(ctx context.Context, in *UsageReportRequest, opts ...grpc.CallOption) (*BillingAccountUsageReportResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(BillingAccountUsageReportResponse)
	err := c.cc.Invoke(ctx, ConsumptionCoreService_GetBillingAccountUsageReport_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *consumptionCoreServiceClient) GetCloudUsageReport(ctx context.Context, in *UsageReportRequest, opts ...grpc.CallOption) (*CloudUsageReportResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(CloudUsageReportResponse)
	err := c.cc.Invoke(ctx, ConsumptionCoreService_GetCloudUsageReport_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *consumptionCoreServiceClient) GetFolderUsageReport(ctx context.Context, in *UsageReportRequest, opts ...grpc.CallOption) (*FolderUsageReportResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(FolderUsageReportResponse)
	err := c.cc.Invoke(ctx, ConsumptionCoreService_GetFolderUsageReport_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *consumptionCoreServiceClient) GetServiceUsageReport(ctx context.Context, in *UsageReportRequest, opts ...grpc.CallOption) (*ServiceUsageReportResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ServiceUsageReportResponse)
	err := c.cc.Invoke(ctx, ConsumptionCoreService_GetServiceUsageReport_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *consumptionCoreServiceClient) GetSKUUsageReport(ctx context.Context, in *UsageReportRequest, opts ...grpc.CallOption) (*SKUUsageReportResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(SKUUsageReportResponse)
	err := c.cc.Invoke(ctx, ConsumptionCoreService_GetSKUUsageReport_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *consumptionCoreServiceClient) GetResourceUsageReport(ctx context.Context, in *UsageReportRequest, opts ...grpc.CallOption) (*ResourceUsageReportResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ResourceUsageReportResponse)
	err := c.cc.Invoke(ctx, ConsumptionCoreService_GetResourceUsageReport_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *consumptionCoreServiceClient) GetLabelKeyUsageReport(ctx context.Context, in *UsageReportRequest, opts ...grpc.CallOption) (*LabelKeyUsageReportResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(LabelKeyUsageReportResponse)
	err := c.cc.Invoke(ctx, ConsumptionCoreService_GetLabelKeyUsageReport_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ConsumptionCoreServiceServer is the server API for ConsumptionCoreService service.
// All implementations should embed UnimplementedConsumptionCoreServiceServer
// for forward compatibility.
//
// Service for detailed consumption and usage reporting.
//
// The ConsumptionCoreService provides a comprehensive set of methods for retrieving detailed
// usage and billing information for different entities within a billing account hierarchy.
// Each method offers aggregated data for specific entity types (a billing account, clouds,
// folders, services, SKUs, resources, or labels) with support for various filtering options
// and aggregation periods. Note that each request targets a single billing account.
//
// All methods in this service follow the same three-level response structure:
//  1. Overall totals for the entire request period (cost, credits, expense)
//  2. Entity-level totals - summary data for each entity of the requested type
//  3. Time series data - periodic breakdown for each entity according to the specified aggregation period
//     (controlled by the aggregation_period request parameter: day/week/month/quarter/year)
//
// These methods help customers and internal teams analyze usage patterns, track expenses,
// monitor resource consumption, and generate detailed billing reports. The service
// supports filtering by entity IDs, date ranges, labels, and other parameters to provide
// targeted insights into cloud resource usage.
//
// Required permissions:
// All methods in this service require one of the following permissions on the specified billing account:
// - `billing.accounts.getReport`
//
// Rate limits:
// This API is limited to 1 request per minute per IP address.
type ConsumptionCoreServiceServer interface {
	// Returns aggregated usage report for a single specified billing account,
	// optionally filtered by clouds, folders, SKUs, labels, and period granularity.
	//
	// This method provides a comprehensive view of all usage and costs for a specific
	// billing account, with options to filter data by various entity types and to aggregate
	// results at different time granularities (daily, monthly, etc.).
	//
	// Implementation details:
	// - The report includes the total cost, applied credits (monetary grants, volume incentives, committed use discounts, and free credits), and final expense
	// - Results can be filtered by cloud IDs, folder IDs, service IDs, SKU IDs, resource IDs, or labels
	// - All applicable filters from the request will be applied (with AND logic between different filter types)
	// - Time-based data is grouped according to the specified aggregation period
	//
	// Error handling:
	// - Returns INVALID_ARGUMENT if the request parameters fail validation
	// - Returns UNAUTHENTICATED if the user is not authenticated or the billing account does not exist
	// - Returns PERMISSION_DENIED if the user lacks required permissions
	// - Returns INTERNAL for internal server errors
	GetBillingAccountUsageReport(context.Context, *UsageReportRequest) (*BillingAccountUsageReportResponse, error)
	// Returns aggregated usage report for the specified clouds
	// under the specified billing account.
	//
	// This method provides detailed usage and cost information grouped by clouds
	// within the specified billing account. The data can be filtered by various
	// entity types and aggregated at different time granularities.
	//
	// Implementation details:
	// - Results are organized by cloud, with each cloud's usage, costs, and credits detailed
	// - If cloud_ids are specified, only data for those clouds is included (using OR logic)
	// - When no cloud_ids are specified, data for all clouds under the billing account is returned
	// - Other filters (folder_ids, service_ids, sku_ids, resource_ids, labels) are always applied if present
	// - Hierarchical data structure allows analyzing costs across the organization's cloud resources
	//
	// Error handling:
	// - Returns INVALID_ARGUMENT if the request parameters fail validation
	// - Returns UNAUTHENTICATED if the user is not authenticated or the billing account does not exist
	// - Returns PERMISSION_DENIED if the user lacks required permissions
	// - Returns INTERNAL for internal server errors
	GetCloudUsageReport(context.Context, *UsageReportRequest) (*CloudUsageReportResponse, error)
	// Returns aggregated usage report for the specified folders
	// under the specified billing account.
	//
	// This method provides detailed usage and cost information grouped by folders
	// within the specified billing account. The data can be filtered by various
	// entity types and aggregated at different time granularities.
	//
	// Implementation details:
	// - Results are organized by folder, with each folder's usage, costs, and credits detailed
	// - If folder_ids are specified, only data for those folders is included (using OR logic)
	// - When no folder_ids are specified, data for all folders under the billing account is returned
	// - Other filters (cloud_ids, service_ids, sku_ids, resource_ids, labels) are always applied if present
	// - Provides visibility into costs at the project/folder level within your organization
	//
	// Error handling:
	// - Returns INVALID_ARGUMENT if the request parameters fail validation
	// - Returns UNAUTHENTICATED if the user is not authenticated or the billing account does not exist
	// - Returns PERMISSION_DENIED if the user lacks required permissions
	// - Returns INTERNAL for internal server errors
	//
	// Required permissions:
	// - `billing.accounts.getReport` on the specified billing account
	GetFolderUsageReport(context.Context, *UsageReportRequest) (*FolderUsageReportResponse, error)
	// Returns aggregated usage report for the specified services
	// under the specified billing account.
	//
	// This method provides detailed usage and cost information grouped by services
	// within the specified billing account. Services represent broad product categories
	// (like Compute, Storage, AI, etc.) that contain multiple SKUs. The data can be
	// filtered by various entity types and aggregated at different time granularities.
	//
	// Implementation details:
	// - Results are organized by service, with each service's usage, costs, and credits detailed
	// - If service_ids are specified, only data for those services is included (using OR logic)
	// - When no service_ids are specified, data for all services under the billing account is returned
	// - Other filters (cloud_ids, folder_ids, sku_ids, resource_ids, labels) are always applied if present
	// - Service data includes the service name and description
	// - Helps identify which cloud services are driving your overall costs
	//
	// Error handling:
	// - Returns INVALID_ARGUMENT if the request parameters fail validation
	// - Returns UNAUTHENTICATED if the user is not authenticated or the billing account does not exist
	// - Returns PERMISSION_DENIED if the user lacks required permissions
	// - Returns INTERNAL for internal server errors
	GetServiceUsageReport(context.Context, *UsageReportRequest) (*ServiceUsageReportResponse, error)
	// Returns aggregated usage report by SKU (Stock Keeping Unit)
	// under the specified billing account.
	//
	// This method provides detailed usage and cost information grouped by SKUs
	// within the specified billing account. SKUs are specific billable product offerings
	// (such as specific VM types, disk types, or AI models) that belong to a parent service.
	// The data can be filtered by various entity types and aggregated at different time granularities.
	//
	// Implementation details:
	// - Results are organized by SKU, with each SKU's usage, costs, and credits detailed
	// - If sku_ids are specified, only data for those SKUs is included (using OR logic)
	// - When no sku_ids are specified, data for all SKUs under the billing account is returned
	// - Other filters (cloud_ids, folder_ids, service_ids, resource_ids, labels) are always applied if present
	// - SKU data includes pricing quantity, unit of measurement, and translated display names
	// - Provides the most granular view of which specific product offerings are generating costs
	//
	// Error handling:
	// - Returns INVALID_ARGUMENT if the request parameters fail validation
	// - Returns UNAUTHENTICATED if the user is not authenticated or the billing account does not exist
	// - Returns PERMISSION_DENIED if the user lacks required permissions
	// - Returns INTERNAL for internal server errors
	GetSKUUsageReport(context.Context, *UsageReportRequest) (*SKUUsageReportResponse, error)
	// Returns aggregated usage report by individual resource
	// under the specified billing account.
	//
	// This method provides detailed usage and cost information grouped by individual resources
	// within the specified billing account. The data can be filtered by various
	// entity types and aggregated at different time granularities.
	//
	// Implementation details:
	// - Results are organized by resource, with each resource's usage, costs, and credits detailed
	// - If resource_ids are specified, only data for those resources is included (using OR logic)
	// - When no resource_ids are specified, data for all resources under the billing account is returned
	// - Other filters (cloud_ids, folder_ids, service_ids, sku_ids, labels) are always applied if present
	// - This provides the most granular view of costs as it breaks down to the individual resource level
	// - Enables precise cost analysis at the individual resource instance level (specific VMs, disks, etc.)
	//
	// Error handling:
	// - Returns INVALID_ARGUMENT if the request parameters fail validation
	// - Returns UNAUTHENTICATED if the user is not authenticated or the billing account does not exist
	// - Returns PERMISSION_DENIED if the user lacks required permissions
	// - Returns INTERNAL for internal server errors
	GetResourceUsageReport(context.Context, *UsageReportRequest) (*ResourceUsageReportResponse, error)
	// Returns aggregated usage report by label keys and values
	// under the specified billing account.
	//
	// This method provides detailed usage and cost information grouped by label key-value pairs
	// within the specified billing account. Labels are user-defined metadata tags attached to resources
	// (such as VMs, disks, etc.) in the form of key-value pairs (e.g., "env:prod", "region:us-west").
	// The data can be filtered by various entity types and aggregated at different time granularities.
	//
	// Implementation details:
	//   - Results are organized by label key-value pairs, with usage, costs, and credits detailed for each
	//   - If labels filter is specified, only data for matching labels is included
	//   - Other filters (cloud_ids, folder_ids, service_ids, sku_ids, resource_ids) are always applied if present
	//   - Resources can have multiple labels attached (e.g., a VM might have "env:prod", "team:finance", "region:us")
	//   - If a resource has multiple labels at the same point in time, the usage and cost metrics are reported for each label separately.
	//     In other words, the same resource's cost is **duplicated** across its labels rather than split. For example,
	//     if a VM costs 90 units and has 3 labels, the report will show 90 units for each label, not 30 units per label.
	//   - This allows for custom business dimensions analysis based on resource tagging
	//   - Usage data is aggregated for all resources that share the same label
	//   - Particularly useful for cost allocation and chargeback across business units, environments, or projects
	//
	// Error handling:
	// - Returns INVALID_ARGUMENT if the request parameters fail validation
	// - Returns UNAUTHENTICATED if the user is not authenticated or the billing account does not exist
	// - Returns PERMISSION_DENIED if the user lacks required permissions
	// - Returns INTERNAL for internal server errors
	GetLabelKeyUsageReport(context.Context, *UsageReportRequest) (*LabelKeyUsageReportResponse, error)
}

// UnimplementedConsumptionCoreServiceServer should be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedConsumptionCoreServiceServer struct{}

func (UnimplementedConsumptionCoreServiceServer) GetBillingAccountUsageReport(context.Context, *UsageReportRequest) (*BillingAccountUsageReportResponse, error) {
	return nil, status.Error(codes.Unimplemented, "method GetBillingAccountUsageReport not implemented")
}
func (UnimplementedConsumptionCoreServiceServer) GetCloudUsageReport(context.Context, *UsageReportRequest) (*CloudUsageReportResponse, error) {
	return nil, status.Error(codes.Unimplemented, "method GetCloudUsageReport not implemented")
}
func (UnimplementedConsumptionCoreServiceServer) GetFolderUsageReport(context.Context, *UsageReportRequest) (*FolderUsageReportResponse, error) {
	return nil, status.Error(codes.Unimplemented, "method GetFolderUsageReport not implemented")
}
func (UnimplementedConsumptionCoreServiceServer) GetServiceUsageReport(context.Context, *UsageReportRequest) (*ServiceUsageReportResponse, error) {
	return nil, status.Error(codes.Unimplemented, "method GetServiceUsageReport not implemented")
}
func (UnimplementedConsumptionCoreServiceServer) GetSKUUsageReport(context.Context, *UsageReportRequest) (*SKUUsageReportResponse, error) {
	return nil, status.Error(codes.Unimplemented, "method GetSKUUsageReport not implemented")
}
func (UnimplementedConsumptionCoreServiceServer) GetResourceUsageReport(context.Context, *UsageReportRequest) (*ResourceUsageReportResponse, error) {
	return nil, status.Error(codes.Unimplemented, "method GetResourceUsageReport not implemented")
}
func (UnimplementedConsumptionCoreServiceServer) GetLabelKeyUsageReport(context.Context, *UsageReportRequest) (*LabelKeyUsageReportResponse, error) {
	return nil, status.Error(codes.Unimplemented, "method GetLabelKeyUsageReport not implemented")
}
func (UnimplementedConsumptionCoreServiceServer) testEmbeddedByValue() {}

// UnsafeConsumptionCoreServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ConsumptionCoreServiceServer will
// result in compilation errors.
type UnsafeConsumptionCoreServiceServer interface {
	mustEmbedUnimplementedConsumptionCoreServiceServer()
}

func RegisterConsumptionCoreServiceServer(s grpc.ServiceRegistrar, srv ConsumptionCoreServiceServer) {
	// If the following call panics, it indicates UnimplementedConsumptionCoreServiceServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&ConsumptionCoreService_ServiceDesc, srv)
}

func _ConsumptionCoreService_GetBillingAccountUsageReport_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UsageReportRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConsumptionCoreServiceServer).GetBillingAccountUsageReport(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ConsumptionCoreService_GetBillingAccountUsageReport_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConsumptionCoreServiceServer).GetBillingAccountUsageReport(ctx, req.(*UsageReportRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConsumptionCoreService_GetCloudUsageReport_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UsageReportRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConsumptionCoreServiceServer).GetCloudUsageReport(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ConsumptionCoreService_GetCloudUsageReport_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConsumptionCoreServiceServer).GetCloudUsageReport(ctx, req.(*UsageReportRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConsumptionCoreService_GetFolderUsageReport_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UsageReportRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConsumptionCoreServiceServer).GetFolderUsageReport(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ConsumptionCoreService_GetFolderUsageReport_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConsumptionCoreServiceServer).GetFolderUsageReport(ctx, req.(*UsageReportRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConsumptionCoreService_GetServiceUsageReport_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UsageReportRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConsumptionCoreServiceServer).GetServiceUsageReport(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ConsumptionCoreService_GetServiceUsageReport_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConsumptionCoreServiceServer).GetServiceUsageReport(ctx, req.(*UsageReportRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConsumptionCoreService_GetSKUUsageReport_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UsageReportRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConsumptionCoreServiceServer).GetSKUUsageReport(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ConsumptionCoreService_GetSKUUsageReport_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConsumptionCoreServiceServer).GetSKUUsageReport(ctx, req.(*UsageReportRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConsumptionCoreService_GetResourceUsageReport_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UsageReportRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConsumptionCoreServiceServer).GetResourceUsageReport(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ConsumptionCoreService_GetResourceUsageReport_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConsumptionCoreServiceServer).GetResourceUsageReport(ctx, req.(*UsageReportRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConsumptionCoreService_GetLabelKeyUsageReport_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UsageReportRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConsumptionCoreServiceServer).GetLabelKeyUsageReport(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ConsumptionCoreService_GetLabelKeyUsageReport_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConsumptionCoreServiceServer).GetLabelKeyUsageReport(ctx, req.(*UsageReportRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// ConsumptionCoreService_ServiceDesc is the grpc.ServiceDesc for ConsumptionCoreService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ConsumptionCoreService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "yandex.cloud.billing.usage_records.v1.ConsumptionCoreService",
	HandlerType: (*ConsumptionCoreServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetBillingAccountUsageReport",
			Handler:    _ConsumptionCoreService_GetBillingAccountUsageReport_Handler,
		},
		{
			MethodName: "GetCloudUsageReport",
			Handler:    _ConsumptionCoreService_GetCloudUsageReport_Handler,
		},
		{
			MethodName: "GetFolderUsageReport",
			Handler:    _ConsumptionCoreService_GetFolderUsageReport_Handler,
		},
		{
			MethodName: "GetServiceUsageReport",
			Handler:    _ConsumptionCoreService_GetServiceUsageReport_Handler,
		},
		{
			MethodName: "GetSKUUsageReport",
			Handler:    _ConsumptionCoreService_GetSKUUsageReport_Handler,
		},
		{
			MethodName: "GetResourceUsageReport",
			Handler:    _ConsumptionCoreService_GetResourceUsageReport_Handler,
		},
		{
			MethodName: "GetLabelKeyUsageReport",
			Handler:    _ConsumptionCoreService_GetLabelKeyUsageReport_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "yandex/cloud/billing/usage_records/v1/consumption_core_service.proto",
}
