// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.11
// 	protoc        v3.21.12
// source: yandex/cloud/billing/v1/budget.proto

package billing

import (
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type BudgetStatus int32

const (
	BudgetStatus_BUDGET_STATUS_UNSPECIFIED BudgetStatus = 0
	// The budget is being created.
	BudgetStatus_CREATING BudgetStatus = 1
	// The budget is active.
	BudgetStatus_ACTIVE BudgetStatus = 2
	// The budget is finished.
	BudgetStatus_FINISHED BudgetStatus = 3
)

// Enum value maps for BudgetStatus.
var (
	BudgetStatus_name = map[int32]string{
		0: "BUDGET_STATUS_UNSPECIFIED",
		1: "CREATING",
		2: "ACTIVE",
		3: "FINISHED",
	}
	BudgetStatus_value = map[string]int32{
		"BUDGET_STATUS_UNSPECIFIED": 0,
		"CREATING":                  1,
		"ACTIVE":                    2,
		"FINISHED":                  3,
	}
)

func (x BudgetStatus) Enum() *BudgetStatus {
	p := new(BudgetStatus)
	*p = x
	return p
}

func (x BudgetStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BudgetStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_billing_v1_budget_proto_enumTypes[0].Descriptor()
}

func (BudgetStatus) Type() protoreflect.EnumType {
	return &file_yandex_cloud_billing_v1_budget_proto_enumTypes[0]
}

func (x BudgetStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BudgetStatus.Descriptor instead.
func (BudgetStatus) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_billing_v1_budget_proto_rawDescGZIP(), []int{0}
}

type ResetPeriodType int32

const (
	ResetPeriodType_RESET_PERIOD_TYPE_UNSPECIFIED ResetPeriodType = 0
	// Reset budget every month.
	ResetPeriodType_MONTHLY ResetPeriodType = 1
	// Reset budget every quarter.
	ResetPeriodType_QUARTER ResetPeriodType = 2
	// Reset budget every year.
	ResetPeriodType_ANNUALLY ResetPeriodType = 3
)

// Enum value maps for ResetPeriodType.
var (
	ResetPeriodType_name = map[int32]string{
		0: "RESET_PERIOD_TYPE_UNSPECIFIED",
		1: "MONTHLY",
		2: "QUARTER",
		3: "ANNUALLY",
	}
	ResetPeriodType_value = map[string]int32{
		"RESET_PERIOD_TYPE_UNSPECIFIED": 0,
		"MONTHLY":                       1,
		"QUARTER":                       2,
		"ANNUALLY":                      3,
	}
)

func (x ResetPeriodType) Enum() *ResetPeriodType {
	p := new(ResetPeriodType)
	*p = x
	return p
}

func (x ResetPeriodType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ResetPeriodType) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_billing_v1_budget_proto_enumTypes[1].Descriptor()
}

func (ResetPeriodType) Type() protoreflect.EnumType {
	return &file_yandex_cloud_billing_v1_budget_proto_enumTypes[1]
}

func (x ResetPeriodType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ResetPeriodType.Descriptor instead.
func (ResetPeriodType) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_billing_v1_budget_proto_rawDescGZIP(), []int{1}
}

// Define the unit of the [ThesholdRule.amount].
type ThresholdType int32

const (
	ThresholdType_THRESHOLD_TYPE_UNSPECIFIED ThresholdType = 0
	// Percent.
	ThresholdType_PERCENT ThresholdType = 1
	// The same as budget amount.
	ThresholdType_AMOUNT ThresholdType = 2
)

// Enum value maps for ThresholdType.
var (
	ThresholdType_name = map[int32]string{
		0: "THRESHOLD_TYPE_UNSPECIFIED",
		1: "PERCENT",
		2: "AMOUNT",
	}
	ThresholdType_value = map[string]int32{
		"THRESHOLD_TYPE_UNSPECIFIED": 0,
		"PERCENT":                    1,
		"AMOUNT":                     2,
	}
)

func (x ThresholdType) Enum() *ThresholdType {
	p := new(ThresholdType)
	*p = x
	return p
}

func (x ThresholdType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ThresholdType) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_billing_v1_budget_proto_enumTypes[2].Descriptor()
}

func (ThresholdType) Type() protoreflect.EnumType {
	return &file_yandex_cloud_billing_v1_budget_proto_enumTypes[2]
}

func (x ThresholdType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ThresholdType.Descriptor instead.
func (ThresholdType) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_billing_v1_budget_proto_rawDescGZIP(), []int{2}
}

// A Budget resource. For more information, see [/docs/billing/concepts/budget].
type Budget struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the budget.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Name of the budget.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Creation timestamp.
	CreatedAt *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// ID of the billing account that the budget belongs to.
	BillingAccountId string `protobuf:"bytes,4,opt,name=billing_account_id,json=billingAccountId,proto3" json:"billing_account_id,omitempty"`
	// Status of the budget.
	Status BudgetStatus `protobuf:"varint,5,opt,name=status,proto3,enum=yandex.cloud.billing.v1.BudgetStatus" json:"status,omitempty"`
	// Specification of the budget.
	//
	// Types that are valid to be assigned to BudgetSpec:
	//
	//	*Budget_CostBudget
	//	*Budget_ExpenseBudget
	//	*Budget_BalanceBudget
	BudgetSpec    isBudget_BudgetSpec `protobuf_oneof:"budget_spec"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Budget) Reset() {
	*x = Budget{}
	mi := &file_yandex_cloud_billing_v1_budget_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Budget) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Budget) ProtoMessage() {}

func (x *Budget) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_billing_v1_budget_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Budget.ProtoReflect.Descriptor instead.
func (*Budget) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_billing_v1_budget_proto_rawDescGZIP(), []int{0}
}

func (x *Budget) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Budget) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Budget) GetCreatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.CreatedAt
	}
	return nil
}

func (x *Budget) GetBillingAccountId() string {
	if x != nil {
		return x.BillingAccountId
	}
	return ""
}

func (x *Budget) GetStatus() BudgetStatus {
	if x != nil {
		return x.Status
	}
	return BudgetStatus_BUDGET_STATUS_UNSPECIFIED
}

func (x *Budget) GetBudgetSpec() isBudget_BudgetSpec {
	if x != nil {
		return x.BudgetSpec
	}
	return nil
}

func (x *Budget) GetCostBudget() *CostBudgetSpec {
	if x != nil {
		if x, ok := x.BudgetSpec.(*Budget_CostBudget); ok {
			return x.CostBudget
		}
	}
	return nil
}

func (x *Budget) GetExpenseBudget() *ExpenseBudgetSpec {
	if x != nil {
		if x, ok := x.BudgetSpec.(*Budget_ExpenseBudget); ok {
			return x.ExpenseBudget
		}
	}
	return nil
}

func (x *Budget) GetBalanceBudget() *BalanceBudgetSpec {
	if x != nil {
		if x, ok := x.BudgetSpec.(*Budget_BalanceBudget); ok {
			return x.BalanceBudget
		}
	}
	return nil
}

type isBudget_BudgetSpec interface {
	isBudget_BudgetSpec()
}

type Budget_CostBudget struct {
	// Cost budget specification.
	CostBudget *CostBudgetSpec `protobuf:"bytes,6,opt,name=cost_budget,json=costBudget,proto3,oneof"`
}

type Budget_ExpenseBudget struct {
	// Expense budget specification.
	ExpenseBudget *ExpenseBudgetSpec `protobuf:"bytes,7,opt,name=expense_budget,json=expenseBudget,proto3,oneof"`
}

type Budget_BalanceBudget struct {
	// Balance budget specification.
	BalanceBudget *BalanceBudgetSpec `protobuf:"bytes,8,opt,name=balance_budget,json=balanceBudget,proto3,oneof"`
}

func (*Budget_CostBudget) isBudget_BudgetSpec() {}

func (*Budget_ExpenseBudget) isBudget_BudgetSpec() {}

func (*Budget_BalanceBudget) isBudget_BudgetSpec() {}

// Cost budget specification describes budget that can be used to control cost of cloud resources usage.
type CostBudgetSpec struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Max cost threshold of the budget. Amount currency is the same as corresponding [yandex.cloud.billing.v1.BillingAccount.currency].
	Amount string `protobuf:"bytes,1,opt,name=amount,proto3" json:"amount,omitempty"`
	// User account IDs.
	// Specified users will be be notified if the budget exceeds.
	NotificationUserAccountIds []string `protobuf:"bytes,2,rep,name=notification_user_account_ids,json=notificationUserAccountIds,proto3" json:"notification_user_account_ids,omitempty"`
	// List of the [ThresholdRule].
	// Rules define intermediate cost thresholds of the budget.
	ThresholdRules []*ThresholdRule `protobuf:"bytes,3,rep,name=threshold_rules,json=thresholdRules,proto3" json:"threshold_rules,omitempty"`
	// Filter that can be used for specific resources selection. Only consumption cost of selected resources are used for the budget calculation.
	Filter *ConsumptionFilter `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Start type of the budget.
	//
	// Types that are valid to be assigned to StartType:
	//
	//	*CostBudgetSpec_ResetPeriod
	//	*CostBudgetSpec_StartDate
	StartType isCostBudgetSpec_StartType `protobuf_oneof:"start_type"`
	// End date of the budget.
	// Must be the last day of a month and must be formatted like YYYY-MM-DD.
	EndDate       string `protobuf:"bytes,7,opt,name=end_date,json=endDate,proto3" json:"end_date,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CostBudgetSpec) Reset() {
	*x = CostBudgetSpec{}
	mi := &file_yandex_cloud_billing_v1_budget_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CostBudgetSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CostBudgetSpec) ProtoMessage() {}

func (x *CostBudgetSpec) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_billing_v1_budget_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CostBudgetSpec.ProtoReflect.Descriptor instead.
func (*CostBudgetSpec) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_billing_v1_budget_proto_rawDescGZIP(), []int{1}
}

func (x *CostBudgetSpec) GetAmount() string {
	if x != nil {
		return x.Amount
	}
	return ""
}

func (x *CostBudgetSpec) GetNotificationUserAccountIds() []string {
	if x != nil {
		return x.NotificationUserAccountIds
	}
	return nil
}

func (x *CostBudgetSpec) GetThresholdRules() []*ThresholdRule {
	if x != nil {
		return x.ThresholdRules
	}
	return nil
}

func (x *CostBudgetSpec) GetFilter() *ConsumptionFilter {
	if x != nil {
		return x.Filter
	}
	return nil
}

func (x *CostBudgetSpec) GetStartType() isCostBudgetSpec_StartType {
	if x != nil {
		return x.StartType
	}
	return nil
}

func (x *CostBudgetSpec) GetResetPeriod() ResetPeriodType {
	if x != nil {
		if x, ok := x.StartType.(*CostBudgetSpec_ResetPeriod); ok {
			return x.ResetPeriod
		}
	}
	return ResetPeriodType_RESET_PERIOD_TYPE_UNSPECIFIED
}

func (x *CostBudgetSpec) GetStartDate() string {
	if x != nil {
		if x, ok := x.StartType.(*CostBudgetSpec_StartDate); ok {
			return x.StartDate
		}
	}
	return ""
}

func (x *CostBudgetSpec) GetEndDate() string {
	if x != nil {
		return x.EndDate
	}
	return ""
}

type isCostBudgetSpec_StartType interface {
	isCostBudgetSpec_StartType()
}

type CostBudgetSpec_ResetPeriod struct {
	// Periodic start type that resets budget after specified period is finished.
	// First time budget is calculated in the current period, i.e. current month, quarter or year.
	ResetPeriod ResetPeriodType `protobuf:"varint,5,opt,name=reset_period,json=resetPeriod,proto3,enum=yandex.cloud.billing.v1.ResetPeriodType,oneof"`
}

type CostBudgetSpec_StartDate struct {
	// Custom start date of the budget.
	// Must be the first day of a month and must be formatted like YYYY-MM-DD.
	StartDate string `protobuf:"bytes,6,opt,name=start_date,json=startDate,proto3,oneof"`
}

func (*CostBudgetSpec_ResetPeriod) isCostBudgetSpec_StartType() {}

func (*CostBudgetSpec_StartDate) isCostBudgetSpec_StartType() {}

// Expense budget specification describes budget that can be used to control expense of cloud resources usage.
type ExpenseBudgetSpec struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Max expense threshold of the budget. Amount currency is the same as corresponding [yandex.cloud.billing.v1.BillingAccount.currency].
	Amount string `protobuf:"bytes,1,opt,name=amount,proto3" json:"amount,omitempty"`
	// User account IDs.
	// Specified users will be be notified if the budget exceeds.
	NotificationUserAccountIds []string `protobuf:"bytes,2,rep,name=notification_user_account_ids,json=notificationUserAccountIds,proto3" json:"notification_user_account_ids,omitempty"`
	// List of the [ThresholdRule].
	// Rules define intermediate expense thresholds of the budget.
	ThresholdRules []*ThresholdRule `protobuf:"bytes,3,rep,name=threshold_rules,json=thresholdRules,proto3" json:"threshold_rules,omitempty"`
	// Filter that can be used for specific resources selection. Only consumption expense of selected resources are used for the budget calculation.
	Filter *ConsumptionFilter `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Start type of the budget.
	//
	// Types that are valid to be assigned to StartType:
	//
	//	*ExpenseBudgetSpec_ResetPeriod
	//	*ExpenseBudgetSpec_StartDate
	StartType isExpenseBudgetSpec_StartType `protobuf_oneof:"start_type"`
	// End date of the budget.
	// Must be the last day of a month and must be formatted like YYYY-MM-DD.
	EndDate       string `protobuf:"bytes,7,opt,name=end_date,json=endDate,proto3" json:"end_date,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ExpenseBudgetSpec) Reset() {
	*x = ExpenseBudgetSpec{}
	mi := &file_yandex_cloud_billing_v1_budget_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExpenseBudgetSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExpenseBudgetSpec) ProtoMessage() {}

func (x *ExpenseBudgetSpec) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_billing_v1_budget_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExpenseBudgetSpec.ProtoReflect.Descriptor instead.
func (*ExpenseBudgetSpec) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_billing_v1_budget_proto_rawDescGZIP(), []int{2}
}

func (x *ExpenseBudgetSpec) GetAmount() string {
	if x != nil {
		return x.Amount
	}
	return ""
}

func (x *ExpenseBudgetSpec) GetNotificationUserAccountIds() []string {
	if x != nil {
		return x.NotificationUserAccountIds
	}
	return nil
}

func (x *ExpenseBudgetSpec) GetThresholdRules() []*ThresholdRule {
	if x != nil {
		return x.ThresholdRules
	}
	return nil
}

func (x *ExpenseBudgetSpec) GetFilter() *ConsumptionFilter {
	if x != nil {
		return x.Filter
	}
	return nil
}

func (x *ExpenseBudgetSpec) GetStartType() isExpenseBudgetSpec_StartType {
	if x != nil {
		return x.StartType
	}
	return nil
}

func (x *ExpenseBudgetSpec) GetResetPeriod() ResetPeriodType {
	if x != nil {
		if x, ok := x.StartType.(*ExpenseBudgetSpec_ResetPeriod); ok {
			return x.ResetPeriod
		}
	}
	return ResetPeriodType_RESET_PERIOD_TYPE_UNSPECIFIED
}

func (x *ExpenseBudgetSpec) GetStartDate() string {
	if x != nil {
		if x, ok := x.StartType.(*ExpenseBudgetSpec_StartDate); ok {
			return x.StartDate
		}
	}
	return ""
}

func (x *ExpenseBudgetSpec) GetEndDate() string {
	if x != nil {
		return x.EndDate
	}
	return ""
}

type isExpenseBudgetSpec_StartType interface {
	isExpenseBudgetSpec_StartType()
}

type ExpenseBudgetSpec_ResetPeriod struct {
	// Periodic start type that resets budget after specified period is finished.
	// First time budget is calculated in the current period, i.e. current month, quarter or year.
	ResetPeriod ResetPeriodType `protobuf:"varint,5,opt,name=reset_period,json=resetPeriod,proto3,enum=yandex.cloud.billing.v1.ResetPeriodType,oneof"`
}

type ExpenseBudgetSpec_StartDate struct {
	// Custom start date of the budget.
	// Must be the first day of a month and must be formatted like YYYY-MM-DD.
	StartDate string `protobuf:"bytes,6,opt,name=start_date,json=startDate,proto3,oneof"`
}

func (*ExpenseBudgetSpec_ResetPeriod) isExpenseBudgetSpec_StartType() {}

func (*ExpenseBudgetSpec_StartDate) isExpenseBudgetSpec_StartType() {}

// Balance budget specification describes budget that can be used to control [yandex.cloud.billing.v1.BillingAccount.balance].
type BalanceBudgetSpec struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Max balance threshold of the budget. Amount currency is the same as corresponding [yandex.cloud.billing.v1.BillingAccount.currency].
	Amount string `protobuf:"bytes,1,opt,name=amount,proto3" json:"amount,omitempty"`
	// User account IDs.
	// Specified users will be be notified if the budget exceeds.
	NotificationUserAccountIds []string `protobuf:"bytes,2,rep,name=notification_user_account_ids,json=notificationUserAccountIds,proto3" json:"notification_user_account_ids,omitempty"`
	// List of the [ThresholdRule].
	// Rules define intermediate balance thresholds of the budget.
	ThresholdRules []*ThresholdRule `protobuf:"bytes,3,rep,name=threshold_rules,json=thresholdRules,proto3" json:"threshold_rules,omitempty"`
	// Start_date of the budget.
	// Must be the first day of a month and must be formatted like YYYY-MM-DD.
	StartDate string `protobuf:"bytes,4,opt,name=start_date,json=startDate,proto3" json:"start_date,omitempty"`
	// End date of the budget.
	// Must be the last day of a month and must be formatted like YYYY-MM-DD.
	EndDate       string `protobuf:"bytes,5,opt,name=end_date,json=endDate,proto3" json:"end_date,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *BalanceBudgetSpec) Reset() {
	*x = BalanceBudgetSpec{}
	mi := &file_yandex_cloud_billing_v1_budget_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BalanceBudgetSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BalanceBudgetSpec) ProtoMessage() {}

func (x *BalanceBudgetSpec) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_billing_v1_budget_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BalanceBudgetSpec.ProtoReflect.Descriptor instead.
func (*BalanceBudgetSpec) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_billing_v1_budget_proto_rawDescGZIP(), []int{3}
}

func (x *BalanceBudgetSpec) GetAmount() string {
	if x != nil {
		return x.Amount
	}
	return ""
}

func (x *BalanceBudgetSpec) GetNotificationUserAccountIds() []string {
	if x != nil {
		return x.NotificationUserAccountIds
	}
	return nil
}

func (x *BalanceBudgetSpec) GetThresholdRules() []*ThresholdRule {
	if x != nil {
		return x.ThresholdRules
	}
	return nil
}

func (x *BalanceBudgetSpec) GetStartDate() string {
	if x != nil {
		return x.StartDate
	}
	return ""
}

func (x *BalanceBudgetSpec) GetEndDate() string {
	if x != nil {
		return x.EndDate
	}
	return ""
}

// Filter that can be used for specific resources selection.
type ConsumptionFilter struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// IDs of the [yandex.cloud.billing.v1.Service].
	// Only consumption of resources corresponding to the given services is used for the budget calculation.
	// Empty sequence means no services filters.
	ServiceIds []string `protobuf:"bytes,1,rep,name=service_ids,json=serviceIds,proto3" json:"service_ids,omitempty"`
	// Cloud and folders consumption filter.
	// Only consumption within specified clouds and folders is used for the budget calculation.
	// Empty sequence means no cloud and folders filters.
	CloudFoldersFilters []*CloudFoldersConsumptionFilter `protobuf:"bytes,2,rep,name=cloud_folders_filters,json=cloudFoldersFilters,proto3" json:"cloud_folders_filters,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *ConsumptionFilter) Reset() {
	*x = ConsumptionFilter{}
	mi := &file_yandex_cloud_billing_v1_budget_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ConsumptionFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConsumptionFilter) ProtoMessage() {}

func (x *ConsumptionFilter) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_billing_v1_budget_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConsumptionFilter.ProtoReflect.Descriptor instead.
func (*ConsumptionFilter) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_billing_v1_budget_proto_rawDescGZIP(), []int{4}
}

func (x *ConsumptionFilter) GetServiceIds() []string {
	if x != nil {
		return x.ServiceIds
	}
	return nil
}

func (x *ConsumptionFilter) GetCloudFoldersFilters() []*CloudFoldersConsumptionFilter {
	if x != nil {
		return x.CloudFoldersFilters
	}
	return nil
}

// Filter that can be used for specific cloud and its folders selection.
type CloudFoldersConsumptionFilter struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the [yandex.cloud.resourcemanager.v1.Cloud].
	// Only consumption within specified cloud is used for the budget calculation.
	CloudId string `protobuf:"bytes,1,opt,name=cloud_id,json=cloudId,proto3" json:"cloud_id,omitempty"`
	// IDs of the [yandex.cloud.resourcemanager.v1.Folder].
	// Only consumption within specified folders of the given cloud is used for the budget calculation.
	// Empty sequence means no folders filters and the whole cloud consumption will be used.
	FolderIds     []string `protobuf:"bytes,2,rep,name=folder_ids,json=folderIds,proto3" json:"folder_ids,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CloudFoldersConsumptionFilter) Reset() {
	*x = CloudFoldersConsumptionFilter{}
	mi := &file_yandex_cloud_billing_v1_budget_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CloudFoldersConsumptionFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloudFoldersConsumptionFilter) ProtoMessage() {}

func (x *CloudFoldersConsumptionFilter) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_billing_v1_budget_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloudFoldersConsumptionFilter.ProtoReflect.Descriptor instead.
func (*CloudFoldersConsumptionFilter) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_billing_v1_budget_proto_rawDescGZIP(), []int{5}
}

func (x *CloudFoldersConsumptionFilter) GetCloudId() string {
	if x != nil {
		return x.CloudId
	}
	return ""
}

func (x *CloudFoldersConsumptionFilter) GetFolderIds() []string {
	if x != nil {
		return x.FolderIds
	}
	return nil
}

// Rules that define intermediate cost thresholds of the budget.
type ThresholdRule struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Type of the rule.
	Type ThresholdType `protobuf:"varint,1,opt,name=type,proto3,enum=yandex.cloud.billing.v1.ThresholdType" json:"type,omitempty"`
	// Amount of the rule.
	//   - Must be less than 100 if type is PERCENT.
	//   - Must be less than budget's amount if type is AMOUNT.
	Amount string `protobuf:"bytes,2,opt,name=amount,proto3" json:"amount,omitempty"`
	// User account IDs.
	// Specified users will be be notified if the threshold exceeds.
	NotificationUserAccountIds []string `protobuf:"bytes,3,rep,name=notification_user_account_ids,json=notificationUserAccountIds,proto3" json:"notification_user_account_ids,omitempty"`
	unknownFields              protoimpl.UnknownFields
	sizeCache                  protoimpl.SizeCache
}

func (x *ThresholdRule) Reset() {
	*x = ThresholdRule{}
	mi := &file_yandex_cloud_billing_v1_budget_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ThresholdRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ThresholdRule) ProtoMessage() {}

func (x *ThresholdRule) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_billing_v1_budget_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ThresholdRule.ProtoReflect.Descriptor instead.
func (*ThresholdRule) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_billing_v1_budget_proto_rawDescGZIP(), []int{6}
}

func (x *ThresholdRule) GetType() ThresholdType {
	if x != nil {
		return x.Type
	}
	return ThresholdType_THRESHOLD_TYPE_UNSPECIFIED
}

func (x *ThresholdRule) GetAmount() string {
	if x != nil {
		return x.Amount
	}
	return ""
}

func (x *ThresholdRule) GetNotificationUserAccountIds() []string {
	if x != nil {
		return x.NotificationUserAccountIds
	}
	return nil
}

var File_yandex_cloud_billing_v1_budget_proto protoreflect.FileDescriptor

const file_yandex_cloud_billing_v1_budget_proto_rawDesc = "" +
	"\n" +
	"$yandex/cloud/billing/v1/budget.proto\x12\x17yandex.cloud.billing.v1\x1a\x1fgoogle/protobuf/timestamp.proto\x1a\x1dyandex/cloud/validation.proto\"\xdf\x03\n" +
	"\x06Budget\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\tR\x02id\x12\x12\n" +
	"\x04name\x18\x02 \x01(\tR\x04name\x129\n" +
	"\n" +
	"created_at\x18\x03 \x01(\v2\x1a.google.protobuf.TimestampR\tcreatedAt\x12,\n" +
	"\x12billing_account_id\x18\x04 \x01(\tR\x10billingAccountId\x12=\n" +
	"\x06status\x18\x05 \x01(\x0e2%.yandex.cloud.billing.v1.BudgetStatusR\x06status\x12J\n" +
	"\vcost_budget\x18\x06 \x01(\v2'.yandex.cloud.billing.v1.CostBudgetSpecH\x00R\n" +
	"costBudget\x12S\n" +
	"\x0eexpense_budget\x18\a \x01(\v2*.yandex.cloud.billing.v1.ExpenseBudgetSpecH\x00R\rexpenseBudget\x12S\n" +
	"\x0ebalance_budget\x18\b \x01(\v2*.yandex.cloud.billing.v1.BalanceBudgetSpecH\x00R\rbalanceBudgetB\x13\n" +
	"\vbudget_spec\x12\x04\xc0\xc11\x01\"\xb4\x03\n" +
	"\x0eCostBudgetSpec\x12\x1c\n" +
	"\x06amount\x18\x01 \x01(\tB\x04\xe8\xc71\x01R\x06amount\x12J\n" +
	"\x1dnotification_user_account_ids\x18\x02 \x03(\tB\a\x82\xc81\x03>=1R\x1anotificationUserAccountIds\x12O\n" +
	"\x0fthreshold_rules\x18\x03 \x03(\v2&.yandex.cloud.billing.v1.ThresholdRuleR\x0ethresholdRules\x12B\n" +
	"\x06filter\x18\x04 \x01(\v2*.yandex.cloud.billing.v1.ConsumptionFilterR\x06filter\x12M\n" +
	"\freset_period\x18\x05 \x01(\x0e2(.yandex.cloud.billing.v1.ResetPeriodTypeH\x00R\vresetPeriod\x12\x1f\n" +
	"\n" +
	"start_date\x18\x06 \x01(\tH\x00R\tstartDate\x12\x1f\n" +
	"\bend_date\x18\a \x01(\tB\x04\xe8\xc71\x01R\aendDateB\x12\n" +
	"\n" +
	"start_type\x12\x04\xc0\xc11\x01\"\xb7\x03\n" +
	"\x11ExpenseBudgetSpec\x12\x1c\n" +
	"\x06amount\x18\x01 \x01(\tB\x04\xe8\xc71\x01R\x06amount\x12J\n" +
	"\x1dnotification_user_account_ids\x18\x02 \x03(\tB\a\x82\xc81\x03>=1R\x1anotificationUserAccountIds\x12O\n" +
	"\x0fthreshold_rules\x18\x03 \x03(\v2&.yandex.cloud.billing.v1.ThresholdRuleR\x0ethresholdRules\x12B\n" +
	"\x06filter\x18\x04 \x01(\v2*.yandex.cloud.billing.v1.ConsumptionFilterR\x06filter\x12M\n" +
	"\freset_period\x18\x05 \x01(\x0e2(.yandex.cloud.billing.v1.ResetPeriodTypeH\x00R\vresetPeriod\x12\x1f\n" +
	"\n" +
	"start_date\x18\x06 \x01(\tH\x00R\tstartDate\x12\x1f\n" +
	"\bend_date\x18\a \x01(\tB\x04\xe8\xc71\x01R\aendDateB\x12\n" +
	"\n" +
	"start_type\x12\x04\xc0\xc11\x01\"\x8e\x02\n" +
	"\x11BalanceBudgetSpec\x12\x1c\n" +
	"\x06amount\x18\x01 \x01(\tB\x04\xe8\xc71\x01R\x06amount\x12J\n" +
	"\x1dnotification_user_account_ids\x18\x02 \x03(\tB\a\x82\xc81\x03>=1R\x1anotificationUserAccountIds\x12O\n" +
	"\x0fthreshold_rules\x18\x03 \x03(\v2&.yandex.cloud.billing.v1.ThresholdRuleR\x0ethresholdRules\x12\x1d\n" +
	"\n" +
	"start_date\x18\x04 \x01(\tR\tstartDate\x12\x1f\n" +
	"\bend_date\x18\x05 \x01(\tB\x04\xe8\xc71\x01R\aendDate\"\xa0\x01\n" +
	"\x11ConsumptionFilter\x12\x1f\n" +
	"\vservice_ids\x18\x01 \x03(\tR\n" +
	"serviceIds\x12j\n" +
	"\x15cloud_folders_filters\x18\x02 \x03(\v26.yandex.cloud.billing.v1.CloudFoldersConsumptionFilterR\x13cloudFoldersFilters\"Y\n" +
	"\x1dCloudFoldersConsumptionFilter\x12\x19\n" +
	"\bcloud_id\x18\x01 \x01(\tR\acloudId\x12\x1d\n" +
	"\n" +
	"folder_ids\x18\x02 \x03(\tR\tfolderIds\"\xb2\x01\n" +
	"\rThresholdRule\x12@\n" +
	"\x04type\x18\x01 \x01(\x0e2&.yandex.cloud.billing.v1.ThresholdTypeB\x04\xe8\xc71\x01R\x04type\x12\x1c\n" +
	"\x06amount\x18\x02 \x01(\tB\x04\xe8\xc71\x01R\x06amount\x12A\n" +
	"\x1dnotification_user_account_ids\x18\x03 \x03(\tR\x1anotificationUserAccountIds*U\n" +
	"\fBudgetStatus\x12\x1d\n" +
	"\x19BUDGET_STATUS_UNSPECIFIED\x10\x00\x12\f\n" +
	"\bCREATING\x10\x01\x12\n" +
	"\n" +
	"\x06ACTIVE\x10\x02\x12\f\n" +
	"\bFINISHED\x10\x03*\\\n" +
	"\x0fResetPeriodType\x12!\n" +
	"\x1dRESET_PERIOD_TYPE_UNSPECIFIED\x10\x00\x12\v\n" +
	"\aMONTHLY\x10\x01\x12\v\n" +
	"\aQUARTER\x10\x02\x12\f\n" +
	"\bANNUALLY\x10\x03*H\n" +
	"\rThresholdType\x12\x1e\n" +
	"\x1aTHRESHOLD_TYPE_UNSPECIFIED\x10\x00\x12\v\n" +
	"\aPERCENT\x10\x01\x12\n" +
	"\n" +
	"\x06AMOUNT\x10\x02Bb\n" +
	"\x1byandex.cloud.api.billing.v1ZCgithub.com/yandex-cloud/go-genproto/yandex/cloud/billing/v1;billingb\x06proto3"

var (
	file_yandex_cloud_billing_v1_budget_proto_rawDescOnce sync.Once
	file_yandex_cloud_billing_v1_budget_proto_rawDescData []byte
)

func file_yandex_cloud_billing_v1_budget_proto_rawDescGZIP() []byte {
	file_yandex_cloud_billing_v1_budget_proto_rawDescOnce.Do(func() {
		file_yandex_cloud_billing_v1_budget_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_yandex_cloud_billing_v1_budget_proto_rawDesc), len(file_yandex_cloud_billing_v1_budget_proto_rawDesc)))
	})
	return file_yandex_cloud_billing_v1_budget_proto_rawDescData
}

var file_yandex_cloud_billing_v1_budget_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_yandex_cloud_billing_v1_budget_proto_msgTypes = make([]protoimpl.MessageInfo, 7)
var file_yandex_cloud_billing_v1_budget_proto_goTypes = []any{
	(BudgetStatus)(0),                     // 0: yandex.cloud.billing.v1.BudgetStatus
	(ResetPeriodType)(0),                  // 1: yandex.cloud.billing.v1.ResetPeriodType
	(ThresholdType)(0),                    // 2: yandex.cloud.billing.v1.ThresholdType
	(*Budget)(nil),                        // 3: yandex.cloud.billing.v1.Budget
	(*CostBudgetSpec)(nil),                // 4: yandex.cloud.billing.v1.CostBudgetSpec
	(*ExpenseBudgetSpec)(nil),             // 5: yandex.cloud.billing.v1.ExpenseBudgetSpec
	(*BalanceBudgetSpec)(nil),             // 6: yandex.cloud.billing.v1.BalanceBudgetSpec
	(*ConsumptionFilter)(nil),             // 7: yandex.cloud.billing.v1.ConsumptionFilter
	(*CloudFoldersConsumptionFilter)(nil), // 8: yandex.cloud.billing.v1.CloudFoldersConsumptionFilter
	(*ThresholdRule)(nil),                 // 9: yandex.cloud.billing.v1.ThresholdRule
	(*timestamppb.Timestamp)(nil),         // 10: google.protobuf.Timestamp
}
var file_yandex_cloud_billing_v1_budget_proto_depIdxs = []int32{
	10, // 0: yandex.cloud.billing.v1.Budget.created_at:type_name -> google.protobuf.Timestamp
	0,  // 1: yandex.cloud.billing.v1.Budget.status:type_name -> yandex.cloud.billing.v1.BudgetStatus
	4,  // 2: yandex.cloud.billing.v1.Budget.cost_budget:type_name -> yandex.cloud.billing.v1.CostBudgetSpec
	5,  // 3: yandex.cloud.billing.v1.Budget.expense_budget:type_name -> yandex.cloud.billing.v1.ExpenseBudgetSpec
	6,  // 4: yandex.cloud.billing.v1.Budget.balance_budget:type_name -> yandex.cloud.billing.v1.BalanceBudgetSpec
	9,  // 5: yandex.cloud.billing.v1.CostBudgetSpec.threshold_rules:type_name -> yandex.cloud.billing.v1.ThresholdRule
	7,  // 6: yandex.cloud.billing.v1.CostBudgetSpec.filter:type_name -> yandex.cloud.billing.v1.ConsumptionFilter
	1,  // 7: yandex.cloud.billing.v1.CostBudgetSpec.reset_period:type_name -> yandex.cloud.billing.v1.ResetPeriodType
	9,  // 8: yandex.cloud.billing.v1.ExpenseBudgetSpec.threshold_rules:type_name -> yandex.cloud.billing.v1.ThresholdRule
	7,  // 9: yandex.cloud.billing.v1.ExpenseBudgetSpec.filter:type_name -> yandex.cloud.billing.v1.ConsumptionFilter
	1,  // 10: yandex.cloud.billing.v1.ExpenseBudgetSpec.reset_period:type_name -> yandex.cloud.billing.v1.ResetPeriodType
	9,  // 11: yandex.cloud.billing.v1.BalanceBudgetSpec.threshold_rules:type_name -> yandex.cloud.billing.v1.ThresholdRule
	8,  // 12: yandex.cloud.billing.v1.ConsumptionFilter.cloud_folders_filters:type_name -> yandex.cloud.billing.v1.CloudFoldersConsumptionFilter
	2,  // 13: yandex.cloud.billing.v1.ThresholdRule.type:type_name -> yandex.cloud.billing.v1.ThresholdType
	14, // [14:14] is the sub-list for method output_type
	14, // [14:14] is the sub-list for method input_type
	14, // [14:14] is the sub-list for extension type_name
	14, // [14:14] is the sub-list for extension extendee
	0,  // [0:14] is the sub-list for field type_name
}

func init() { file_yandex_cloud_billing_v1_budget_proto_init() }
func file_yandex_cloud_billing_v1_budget_proto_init() {
	if File_yandex_cloud_billing_v1_budget_proto != nil {
		return
	}
	file_yandex_cloud_billing_v1_budget_proto_msgTypes[0].OneofWrappers = []any{
		(*Budget_CostBudget)(nil),
		(*Budget_ExpenseBudget)(nil),
		(*Budget_BalanceBudget)(nil),
	}
	file_yandex_cloud_billing_v1_budget_proto_msgTypes[1].OneofWrappers = []any{
		(*CostBudgetSpec_ResetPeriod)(nil),
		(*CostBudgetSpec_StartDate)(nil),
	}
	file_yandex_cloud_billing_v1_budget_proto_msgTypes[2].OneofWrappers = []any{
		(*ExpenseBudgetSpec_ResetPeriod)(nil),
		(*ExpenseBudgetSpec_StartDate)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_yandex_cloud_billing_v1_budget_proto_rawDesc), len(file_yandex_cloud_billing_v1_budget_proto_rawDesc)),
			NumEnums:      3,
			NumMessages:   7,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_yandex_cloud_billing_v1_budget_proto_goTypes,
		DependencyIndexes: file_yandex_cloud_billing_v1_budget_proto_depIdxs,
		EnumInfos:         file_yandex_cloud_billing_v1_budget_proto_enumTypes,
		MessageInfos:      file_yandex_cloud_billing_v1_budget_proto_msgTypes,
	}.Build()
	File_yandex_cloud_billing_v1_budget_proto = out.File
	file_yandex_cloud_billing_v1_budget_proto_goTypes = nil
	file_yandex_cloud_billing_v1_budget_proto_depIdxs = nil
}
