// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.6.1
// - protoc             v3.21.12
// source: yandex/cloud/dataproc/v1/subcluster_service.proto

package dataproc

import (
	context "context"
	operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.64.0 or later.
const _ = grpc.SupportPackageIsVersion9

const (
	SubclusterService_Get_FullMethodName    = "/yandex.cloud.dataproc.v1.SubclusterService/Get"
	SubclusterService_List_FullMethodName   = "/yandex.cloud.dataproc.v1.SubclusterService/List"
	SubclusterService_Create_FullMethodName = "/yandex.cloud.dataproc.v1.SubclusterService/Create"
	SubclusterService_Update_FullMethodName = "/yandex.cloud.dataproc.v1.SubclusterService/Update"
	SubclusterService_Delete_FullMethodName = "/yandex.cloud.dataproc.v1.SubclusterService/Delete"
)

// SubclusterServiceClient is the client API for SubclusterService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
//
// A set of methods for managing Yandex Data Processing subclusters.
type SubclusterServiceClient interface {
	// Returns the specified subcluster.
	//
	// To get the list of all available subclusters, make a [SubclusterService.List] request.
	Get(ctx context.Context, in *GetSubclusterRequest, opts ...grpc.CallOption) (*Subcluster, error)
	// Retrieves a list of subclusters in the specified cluster.
	List(ctx context.Context, in *ListSubclustersRequest, opts ...grpc.CallOption) (*ListSubclustersResponse, error)
	// Creates a subcluster in the specified cluster.
	Create(ctx context.Context, in *CreateSubclusterRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Updates the specified subcluster.
	Update(ctx context.Context, in *UpdateSubclusterRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Deletes the specified subcluster.
	Delete(ctx context.Context, in *DeleteSubclusterRequest, opts ...grpc.CallOption) (*operation.Operation, error)
}

type subclusterServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewSubclusterServiceClient(cc grpc.ClientConnInterface) SubclusterServiceClient {
	return &subclusterServiceClient{cc}
}

func (c *subclusterServiceClient) Get(ctx context.Context, in *GetSubclusterRequest, opts ...grpc.CallOption) (*Subcluster, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Subcluster)
	err := c.cc.Invoke(ctx, SubclusterService_Get_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subclusterServiceClient) List(ctx context.Context, in *ListSubclustersRequest, opts ...grpc.CallOption) (*ListSubclustersResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ListSubclustersResponse)
	err := c.cc.Invoke(ctx, SubclusterService_List_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subclusterServiceClient) Create(ctx context.Context, in *CreateSubclusterRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, SubclusterService_Create_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subclusterServiceClient) Update(ctx context.Context, in *UpdateSubclusterRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, SubclusterService_Update_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subclusterServiceClient) Delete(ctx context.Context, in *DeleteSubclusterRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, SubclusterService_Delete_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SubclusterServiceServer is the server API for SubclusterService service.
// All implementations should embed UnimplementedSubclusterServiceServer
// for forward compatibility.
//
// A set of methods for managing Yandex Data Processing subclusters.
type SubclusterServiceServer interface {
	// Returns the specified subcluster.
	//
	// To get the list of all available subclusters, make a [SubclusterService.List] request.
	Get(context.Context, *GetSubclusterRequest) (*Subcluster, error)
	// Retrieves a list of subclusters in the specified cluster.
	List(context.Context, *ListSubclustersRequest) (*ListSubclustersResponse, error)
	// Creates a subcluster in the specified cluster.
	Create(context.Context, *CreateSubclusterRequest) (*operation.Operation, error)
	// Updates the specified subcluster.
	Update(context.Context, *UpdateSubclusterRequest) (*operation.Operation, error)
	// Deletes the specified subcluster.
	Delete(context.Context, *DeleteSubclusterRequest) (*operation.Operation, error)
}

// UnimplementedSubclusterServiceServer should be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedSubclusterServiceServer struct{}

func (UnimplementedSubclusterServiceServer) Get(context.Context, *GetSubclusterRequest) (*Subcluster, error) {
	return nil, status.Error(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedSubclusterServiceServer) List(context.Context, *ListSubclustersRequest) (*ListSubclustersResponse, error) {
	return nil, status.Error(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedSubclusterServiceServer) Create(context.Context, *CreateSubclusterRequest) (*operation.Operation, error) {
	return nil, status.Error(codes.Unimplemented, "method Create not implemented")
}
func (UnimplementedSubclusterServiceServer) Update(context.Context, *UpdateSubclusterRequest) (*operation.Operation, error) {
	return nil, status.Error(codes.Unimplemented, "method Update not implemented")
}
func (UnimplementedSubclusterServiceServer) Delete(context.Context, *DeleteSubclusterRequest) (*operation.Operation, error) {
	return nil, status.Error(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedSubclusterServiceServer) testEmbeddedByValue() {}

// UnsafeSubclusterServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to SubclusterServiceServer will
// result in compilation errors.
type UnsafeSubclusterServiceServer interface {
	mustEmbedUnimplementedSubclusterServiceServer()
}

func RegisterSubclusterServiceServer(s grpc.ServiceRegistrar, srv SubclusterServiceServer) {
	// If the following call panics, it indicates UnimplementedSubclusterServiceServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&SubclusterService_ServiceDesc, srv)
}

func _SubclusterService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSubclusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubclusterServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SubclusterService_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubclusterServiceServer).Get(ctx, req.(*GetSubclusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SubclusterService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSubclustersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubclusterServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SubclusterService_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubclusterServiceServer).List(ctx, req.(*ListSubclustersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SubclusterService_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSubclusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubclusterServiceServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SubclusterService_Create_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubclusterServiceServer).Create(ctx, req.(*CreateSubclusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SubclusterService_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSubclusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubclusterServiceServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SubclusterService_Update_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubclusterServiceServer).Update(ctx, req.(*UpdateSubclusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SubclusterService_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSubclusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubclusterServiceServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SubclusterService_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubclusterServiceServer).Delete(ctx, req.(*DeleteSubclusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// SubclusterService_ServiceDesc is the grpc.ServiceDesc for SubclusterService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var SubclusterService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "yandex.cloud.dataproc.v1.SubclusterService",
	HandlerType: (*SubclusterServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Get",
			Handler:    _SubclusterService_Get_Handler,
		},
		{
			MethodName: "List",
			Handler:    _SubclusterService_List_Handler,
		},
		{
			MethodName: "Create",
			Handler:    _SubclusterService_Create_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _SubclusterService_Update_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _SubclusterService_Delete_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "yandex/cloud/dataproc/v1/subcluster_service.proto",
}
