// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.6.1
// - protoc             v3.21.12
// source: yandex/cloud/devtools/ycvc/v1/control_service.proto

package ycvc

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.64.0 or later.
const _ = grpc.SupportPackageIsVersion9

const (
	VersionControlService_Init_FullMethodName = "/yandex.cloud.devtools.ycvc.v1.VersionControlService/Init"
)

// VersionControlServiceClient is the client API for VersionControlService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
//
// Version Control Service for managing tool version blacklists.
// This service manages obsolete (deprecated/blocked) versions only.
//
// API Behavior:
// - Supported versions: Return successful InitResponse.
// - Deprecated versions: Return successful InitResponse with deprecation_warning.
// - Blocked versions: Return FAILED_PRECONDITION error with descriptive message.
type VersionControlServiceClient interface {
	// Initializes client and checks if the provided version is obsolete.
	// Returns FAILED_PRECONDITION error for blocked versions.
	Init(ctx context.Context, in *InitRequest, opts ...grpc.CallOption) (*InitResponse, error)
}

type versionControlServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewVersionControlServiceClient(cc grpc.ClientConnInterface) VersionControlServiceClient {
	return &versionControlServiceClient{cc}
}

func (c *versionControlServiceClient) Init(ctx context.Context, in *InitRequest, opts ...grpc.CallOption) (*InitResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(InitResponse)
	err := c.cc.Invoke(ctx, VersionControlService_Init_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// VersionControlServiceServer is the server API for VersionControlService service.
// All implementations should embed UnimplementedVersionControlServiceServer
// for forward compatibility.
//
// Version Control Service for managing tool version blacklists.
// This service manages obsolete (deprecated/blocked) versions only.
//
// API Behavior:
// - Supported versions: Return successful InitResponse.
// - Deprecated versions: Return successful InitResponse with deprecation_warning.
// - Blocked versions: Return FAILED_PRECONDITION error with descriptive message.
type VersionControlServiceServer interface {
	// Initializes client and checks if the provided version is obsolete.
	// Returns FAILED_PRECONDITION error for blocked versions.
	Init(context.Context, *InitRequest) (*InitResponse, error)
}

// UnimplementedVersionControlServiceServer should be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedVersionControlServiceServer struct{}

func (UnimplementedVersionControlServiceServer) Init(context.Context, *InitRequest) (*InitResponse, error) {
	return nil, status.Error(codes.Unimplemented, "method Init not implemented")
}
func (UnimplementedVersionControlServiceServer) testEmbeddedByValue() {}

// UnsafeVersionControlServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to VersionControlServiceServer will
// result in compilation errors.
type UnsafeVersionControlServiceServer interface {
	mustEmbedUnimplementedVersionControlServiceServer()
}

func RegisterVersionControlServiceServer(s grpc.ServiceRegistrar, srv VersionControlServiceServer) {
	// If the following call panics, it indicates UnimplementedVersionControlServiceServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&VersionControlService_ServiceDesc, srv)
}

func _VersionControlService_Init_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InitRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VersionControlServiceServer).Init(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VersionControlService_Init_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VersionControlServiceServer).Init(ctx, req.(*InitRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// VersionControlService_ServiceDesc is the grpc.ServiceDesc for VersionControlService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var VersionControlService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "yandex.cloud.devtools.ycvc.v1.VersionControlService",
	HandlerType: (*VersionControlServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Init",
			Handler:    _VersionControlService_Init_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "yandex/cloud/devtools/ycvc/v1/control_service.proto",
}
