// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.11
// 	protoc        v3.21.12
// source: yandex/cloud/loadbalancer/v1/network_load_balancer.proto

package loadbalancer

import (
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// IP version of the addresses that the load balancer works with.
// Only IPv4 is currently available.
type IpVersion int32

const (
	IpVersion_IP_VERSION_UNSPECIFIED IpVersion = 0
	// IPv4
	IpVersion_IPV4 IpVersion = 1
	// IPv6
	IpVersion_IPV6 IpVersion = 2
)

// Enum value maps for IpVersion.
var (
	IpVersion_name = map[int32]string{
		0: "IP_VERSION_UNSPECIFIED",
		1: "IPV4",
		2: "IPV6",
	}
	IpVersion_value = map[string]int32{
		"IP_VERSION_UNSPECIFIED": 0,
		"IPV4":                   1,
		"IPV6":                   2,
	}
)

func (x IpVersion) Enum() *IpVersion {
	p := new(IpVersion)
	*p = x
	return p
}

func (x IpVersion) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (IpVersion) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_loadbalancer_v1_network_load_balancer_proto_enumTypes[0].Descriptor()
}

func (IpVersion) Type() protoreflect.EnumType {
	return &file_yandex_cloud_loadbalancer_v1_network_load_balancer_proto_enumTypes[0]
}

func (x IpVersion) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use IpVersion.Descriptor instead.
func (IpVersion) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_loadbalancer_v1_network_load_balancer_proto_rawDescGZIP(), []int{0}
}

type NetworkLoadBalancer_Status int32

const (
	NetworkLoadBalancer_STATUS_UNSPECIFIED NetworkLoadBalancer_Status = 0
	// Network load balancer is being created.
	NetworkLoadBalancer_CREATING NetworkLoadBalancer_Status = 1
	// Network load balancer is being started.
	NetworkLoadBalancer_STARTING NetworkLoadBalancer_Status = 2
	// Network load balancer is active and sends traffic to the targets.
	NetworkLoadBalancer_ACTIVE NetworkLoadBalancer_Status = 3
	// Network load balancer is being stopped.
	NetworkLoadBalancer_STOPPING NetworkLoadBalancer_Status = 4
	// Network load balancer is stopped and doesn't send traffic to the targets.
	NetworkLoadBalancer_STOPPED NetworkLoadBalancer_Status = 5
	// Network load balancer is being deleted.
	NetworkLoadBalancer_DELETING NetworkLoadBalancer_Status = 6
	// The load balancer doesn't have any listeners or target groups, or
	// attached target groups are empty. The load balancer doesn't perform any health checks or
	// send traffic in this state.
	NetworkLoadBalancer_INACTIVE NetworkLoadBalancer_Status = 7
)

// Enum value maps for NetworkLoadBalancer_Status.
var (
	NetworkLoadBalancer_Status_name = map[int32]string{
		0: "STATUS_UNSPECIFIED",
		1: "CREATING",
		2: "STARTING",
		3: "ACTIVE",
		4: "STOPPING",
		5: "STOPPED",
		6: "DELETING",
		7: "INACTIVE",
	}
	NetworkLoadBalancer_Status_value = map[string]int32{
		"STATUS_UNSPECIFIED": 0,
		"CREATING":           1,
		"STARTING":           2,
		"ACTIVE":             3,
		"STOPPING":           4,
		"STOPPED":            5,
		"DELETING":           6,
		"INACTIVE":           7,
	}
)

func (x NetworkLoadBalancer_Status) Enum() *NetworkLoadBalancer_Status {
	p := new(NetworkLoadBalancer_Status)
	*p = x
	return p
}

func (x NetworkLoadBalancer_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkLoadBalancer_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_loadbalancer_v1_network_load_balancer_proto_enumTypes[1].Descriptor()
}

func (NetworkLoadBalancer_Status) Type() protoreflect.EnumType {
	return &file_yandex_cloud_loadbalancer_v1_network_load_balancer_proto_enumTypes[1]
}

func (x NetworkLoadBalancer_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkLoadBalancer_Status.Descriptor instead.
func (NetworkLoadBalancer_Status) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_loadbalancer_v1_network_load_balancer_proto_rawDescGZIP(), []int{0, 0}
}

type NetworkLoadBalancer_Type int32

const (
	NetworkLoadBalancer_TYPE_UNSPECIFIED NetworkLoadBalancer_Type = 0
	// External network load balancer.
	NetworkLoadBalancer_EXTERNAL NetworkLoadBalancer_Type = 1
	// Internal network load balancer.
	NetworkLoadBalancer_INTERNAL NetworkLoadBalancer_Type = 2
)

// Enum value maps for NetworkLoadBalancer_Type.
var (
	NetworkLoadBalancer_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "EXTERNAL",
		2: "INTERNAL",
	}
	NetworkLoadBalancer_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"EXTERNAL":         1,
		"INTERNAL":         2,
	}
)

func (x NetworkLoadBalancer_Type) Enum() *NetworkLoadBalancer_Type {
	p := new(NetworkLoadBalancer_Type)
	*p = x
	return p
}

func (x NetworkLoadBalancer_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkLoadBalancer_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_loadbalancer_v1_network_load_balancer_proto_enumTypes[2].Descriptor()
}

func (NetworkLoadBalancer_Type) Type() protoreflect.EnumType {
	return &file_yandex_cloud_loadbalancer_v1_network_load_balancer_proto_enumTypes[2]
}

func (x NetworkLoadBalancer_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkLoadBalancer_Type.Descriptor instead.
func (NetworkLoadBalancer_Type) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_loadbalancer_v1_network_load_balancer_proto_rawDescGZIP(), []int{0, 1}
}

// Type of session affinity. Only 5-tuple affinity is currently available.
// For more information, see [Load Balancer concepts](/docs/network-load-balancer/concepts/).
type NetworkLoadBalancer_SessionAffinity int32

const (
	NetworkLoadBalancer_SESSION_AFFINITY_UNSPECIFIED NetworkLoadBalancer_SessionAffinity = 0
	// 5-tuple affinity.
	NetworkLoadBalancer_CLIENT_IP_PORT_PROTO NetworkLoadBalancer_SessionAffinity = 1
)

// Enum value maps for NetworkLoadBalancer_SessionAffinity.
var (
	NetworkLoadBalancer_SessionAffinity_name = map[int32]string{
		0: "SESSION_AFFINITY_UNSPECIFIED",
		1: "CLIENT_IP_PORT_PROTO",
	}
	NetworkLoadBalancer_SessionAffinity_value = map[string]int32{
		"SESSION_AFFINITY_UNSPECIFIED": 0,
		"CLIENT_IP_PORT_PROTO":         1,
	}
)

func (x NetworkLoadBalancer_SessionAffinity) Enum() *NetworkLoadBalancer_SessionAffinity {
	p := new(NetworkLoadBalancer_SessionAffinity)
	*p = x
	return p
}

func (x NetworkLoadBalancer_SessionAffinity) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkLoadBalancer_SessionAffinity) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_loadbalancer_v1_network_load_balancer_proto_enumTypes[3].Descriptor()
}

func (NetworkLoadBalancer_SessionAffinity) Type() protoreflect.EnumType {
	return &file_yandex_cloud_loadbalancer_v1_network_load_balancer_proto_enumTypes[3]
}

func (x NetworkLoadBalancer_SessionAffinity) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkLoadBalancer_SessionAffinity.Descriptor instead.
func (NetworkLoadBalancer_SessionAffinity) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_loadbalancer_v1_network_load_balancer_proto_rawDescGZIP(), []int{0, 2}
}

// Network protocol to use.
type Listener_Protocol int32

const (
	Listener_PROTOCOL_UNSPECIFIED Listener_Protocol = 0
	Listener_TCP                  Listener_Protocol = 1
	Listener_UDP                  Listener_Protocol = 2
)

// Enum value maps for Listener_Protocol.
var (
	Listener_Protocol_name = map[int32]string{
		0: "PROTOCOL_UNSPECIFIED",
		1: "TCP",
		2: "UDP",
	}
	Listener_Protocol_value = map[string]int32{
		"PROTOCOL_UNSPECIFIED": 0,
		"TCP":                  1,
		"UDP":                  2,
	}
)

func (x Listener_Protocol) Enum() *Listener_Protocol {
	p := new(Listener_Protocol)
	*p = x
	return p
}

func (x Listener_Protocol) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Listener_Protocol) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_loadbalancer_v1_network_load_balancer_proto_enumTypes[4].Descriptor()
}

func (Listener_Protocol) Type() protoreflect.EnumType {
	return &file_yandex_cloud_loadbalancer_v1_network_load_balancer_proto_enumTypes[4]
}

func (x Listener_Protocol) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Listener_Protocol.Descriptor instead.
func (Listener_Protocol) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_loadbalancer_v1_network_load_balancer_proto_rawDescGZIP(), []int{2, 0}
}

// Status of the target.
type TargetState_Status int32

const (
	TargetState_STATUS_UNSPECIFIED TargetState_Status = 0
	// The network load balancer is setting up health checks for this target.
	TargetState_INITIAL TargetState_Status = 1
	// Health check passed and the target is ready to receive traffic.
	TargetState_HEALTHY TargetState_Status = 2
	// Health check failed and the target is not receiving traffic.
	TargetState_UNHEALTHY TargetState_Status = 3
	// Target is being deleted and the network load balancer is no longer sending traffic to this target.
	TargetState_DRAINING TargetState_Status = 4
	// The network load balancer is stopped and not performing health checks on this target.
	TargetState_INACTIVE TargetState_Status = 5
)

// Enum value maps for TargetState_Status.
var (
	TargetState_Status_name = map[int32]string{
		0: "STATUS_UNSPECIFIED",
		1: "INITIAL",
		2: "HEALTHY",
		3: "UNHEALTHY",
		4: "DRAINING",
		5: "INACTIVE",
	}
	TargetState_Status_value = map[string]int32{
		"STATUS_UNSPECIFIED": 0,
		"INITIAL":            1,
		"HEALTHY":            2,
		"UNHEALTHY":          3,
		"DRAINING":           4,
		"INACTIVE":           5,
	}
)

func (x TargetState_Status) Enum() *TargetState_Status {
	p := new(TargetState_Status)
	*p = x
	return p
}

func (x TargetState_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TargetState_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_loadbalancer_v1_network_load_balancer_proto_enumTypes[5].Descriptor()
}

func (TargetState_Status) Type() protoreflect.EnumType {
	return &file_yandex_cloud_loadbalancer_v1_network_load_balancer_proto_enumTypes[5]
}

func (x TargetState_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TargetState_Status.Descriptor instead.
func (TargetState_Status) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_loadbalancer_v1_network_load_balancer_proto_rawDescGZIP(), []int{3, 0}
}

// A NetworkLoadBalancer resource. For more information, see [Network Load Balancer](/docs/network-load-balancer/concepts).
type NetworkLoadBalancer struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the network load balancer.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// ID of the folder that the network load balancer belongs to.
	FolderId string `protobuf:"bytes,2,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// Creation timestamp in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
	CreatedAt *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Name of the network load balancer. The name is unique within the folder. 3-63 characters long.
	Name string `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// Optional description of the network load balancer. 0-256 characters long.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Resource labels as “ key:value “ pairs. Maximum of 64 per resource.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// ID of the region that the network load balancer belongs to.
	RegionId string `protobuf:"bytes,7,opt,name=region_id,json=regionId,proto3" json:"region_id,omitempty"`
	// Status of the network load balancer.
	Status NetworkLoadBalancer_Status `protobuf:"varint,9,opt,name=status,proto3,enum=yandex.cloud.loadbalancer.v1.NetworkLoadBalancer_Status" json:"status,omitempty"`
	// Type of the network load balancer. Only external network load balancers are available now.
	Type NetworkLoadBalancer_Type `protobuf:"varint,10,opt,name=type,proto3,enum=yandex.cloud.loadbalancer.v1.NetworkLoadBalancer_Type" json:"type,omitempty"`
	// Type of the session affinity. Only 5-tuple affinity is available now.
	SessionAffinity NetworkLoadBalancer_SessionAffinity `protobuf:"varint,11,opt,name=session_affinity,json=sessionAffinity,proto3,enum=yandex.cloud.loadbalancer.v1.NetworkLoadBalancer_SessionAffinity" json:"session_affinity,omitempty"`
	// List of listeners for the network load balancer.
	Listeners []*Listener `protobuf:"bytes,12,rep,name=listeners,proto3" json:"listeners,omitempty"`
	// List of target groups attached to the network load balancer.
	AttachedTargetGroups []*AttachedTargetGroup `protobuf:"bytes,13,rep,name=attached_target_groups,json=attachedTargetGroups,proto3" json:"attached_target_groups,omitempty"`
	// Specifies if network load balancer protected from deletion.
	DeletionProtection bool `protobuf:"varint,14,opt,name=deletion_protection,json=deletionProtection,proto3" json:"deletion_protection,omitempty"`
	// Specifies if network load balancer available to zonal shift.
	AllowZonalShift bool `protobuf:"varint,15,opt,name=allow_zonal_shift,json=allowZonalShift,proto3" json:"allow_zonal_shift,omitempty"`
	// List of disabled zones for the network load balancer.
	DisableZoneStatuses []*DisableZoneStatus `protobuf:"bytes,18,rep,name=disable_zone_statuses,json=disableZoneStatuses,proto3" json:"disable_zone_statuses,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *NetworkLoadBalancer) Reset() {
	*x = NetworkLoadBalancer{}
	mi := &file_yandex_cloud_loadbalancer_v1_network_load_balancer_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NetworkLoadBalancer) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NetworkLoadBalancer) ProtoMessage() {}

func (x *NetworkLoadBalancer) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_loadbalancer_v1_network_load_balancer_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NetworkLoadBalancer.ProtoReflect.Descriptor instead.
func (*NetworkLoadBalancer) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_loadbalancer_v1_network_load_balancer_proto_rawDescGZIP(), []int{0}
}

func (x *NetworkLoadBalancer) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *NetworkLoadBalancer) GetFolderId() string {
	if x != nil {
		return x.FolderId
	}
	return ""
}

func (x *NetworkLoadBalancer) GetCreatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.CreatedAt
	}
	return nil
}

func (x *NetworkLoadBalancer) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *NetworkLoadBalancer) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *NetworkLoadBalancer) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *NetworkLoadBalancer) GetRegionId() string {
	if x != nil {
		return x.RegionId
	}
	return ""
}

func (x *NetworkLoadBalancer) GetStatus() NetworkLoadBalancer_Status {
	if x != nil {
		return x.Status
	}
	return NetworkLoadBalancer_STATUS_UNSPECIFIED
}

func (x *NetworkLoadBalancer) GetType() NetworkLoadBalancer_Type {
	if x != nil {
		return x.Type
	}
	return NetworkLoadBalancer_TYPE_UNSPECIFIED
}

func (x *NetworkLoadBalancer) GetSessionAffinity() NetworkLoadBalancer_SessionAffinity {
	if x != nil {
		return x.SessionAffinity
	}
	return NetworkLoadBalancer_SESSION_AFFINITY_UNSPECIFIED
}

func (x *NetworkLoadBalancer) GetListeners() []*Listener {
	if x != nil {
		return x.Listeners
	}
	return nil
}

func (x *NetworkLoadBalancer) GetAttachedTargetGroups() []*AttachedTargetGroup {
	if x != nil {
		return x.AttachedTargetGroups
	}
	return nil
}

func (x *NetworkLoadBalancer) GetDeletionProtection() bool {
	if x != nil {
		return x.DeletionProtection
	}
	return false
}

func (x *NetworkLoadBalancer) GetAllowZonalShift() bool {
	if x != nil {
		return x.AllowZonalShift
	}
	return false
}

func (x *NetworkLoadBalancer) GetDisableZoneStatuses() []*DisableZoneStatus {
	if x != nil {
		return x.DisableZoneStatuses
	}
	return nil
}

// An AttachedTargetGroup resource. For more information, see [Targets and groups](/docs/network-load-balancer/concepts/target-resources).
type AttachedTargetGroup struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the target group.
	TargetGroupId string `protobuf:"bytes,1,opt,name=target_group_id,json=targetGroupId,proto3" json:"target_group_id,omitempty"`
	// A health check to perform on the target group.
	// For now we accept only one health check per AttachedTargetGroup.
	HealthChecks  []*HealthCheck `protobuf:"bytes,2,rep,name=health_checks,json=healthChecks,proto3" json:"health_checks,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AttachedTargetGroup) Reset() {
	*x = AttachedTargetGroup{}
	mi := &file_yandex_cloud_loadbalancer_v1_network_load_balancer_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AttachedTargetGroup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AttachedTargetGroup) ProtoMessage() {}

func (x *AttachedTargetGroup) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_loadbalancer_v1_network_load_balancer_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AttachedTargetGroup.ProtoReflect.Descriptor instead.
func (*AttachedTargetGroup) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_loadbalancer_v1_network_load_balancer_proto_rawDescGZIP(), []int{1}
}

func (x *AttachedTargetGroup) GetTargetGroupId() string {
	if x != nil {
		return x.TargetGroupId
	}
	return ""
}

func (x *AttachedTargetGroup) GetHealthChecks() []*HealthCheck {
	if x != nil {
		return x.HealthChecks
	}
	return nil
}

// A Listener resource. For more information, see [Listener](/docs/network-load-balancer/concepts/listener)
type Listener struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Name of the listener. The name must be unique for each listener on a single load balancer. 3-63 characters long.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// IP address for the listener.
	Address string `protobuf:"bytes,2,opt,name=address,proto3" json:"address,omitempty"`
	// Port.
	Port int64 `protobuf:"varint,3,opt,name=port,proto3" json:"port,omitempty"`
	// Network protocol for incoming traffic.
	Protocol Listener_Protocol `protobuf:"varint,4,opt,name=protocol,proto3,enum=yandex.cloud.loadbalancer.v1.Listener_Protocol" json:"protocol,omitempty"`
	// Port of a target.
	TargetPort int64 `protobuf:"varint,5,opt,name=target_port,json=targetPort,proto3" json:"target_port,omitempty"`
	// ID of the subnet.
	SubnetId string `protobuf:"bytes,6,opt,name=subnet_id,json=subnetId,proto3" json:"subnet_id,omitempty"`
	// IP version of the external address.
	IpVersion     IpVersion `protobuf:"varint,7,opt,name=ip_version,json=ipVersion,proto3,enum=yandex.cloud.loadbalancer.v1.IpVersion" json:"ip_version,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Listener) Reset() {
	*x = Listener{}
	mi := &file_yandex_cloud_loadbalancer_v1_network_load_balancer_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Listener) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Listener) ProtoMessage() {}

func (x *Listener) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_loadbalancer_v1_network_load_balancer_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Listener.ProtoReflect.Descriptor instead.
func (*Listener) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_loadbalancer_v1_network_load_balancer_proto_rawDescGZIP(), []int{2}
}

func (x *Listener) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Listener) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

func (x *Listener) GetPort() int64 {
	if x != nil {
		return x.Port
	}
	return 0
}

func (x *Listener) GetProtocol() Listener_Protocol {
	if x != nil {
		return x.Protocol
	}
	return Listener_PROTOCOL_UNSPECIFIED
}

func (x *Listener) GetTargetPort() int64 {
	if x != nil {
		return x.TargetPort
	}
	return 0
}

func (x *Listener) GetSubnetId() string {
	if x != nil {
		return x.SubnetId
	}
	return ""
}

func (x *Listener) GetIpVersion() IpVersion {
	if x != nil {
		return x.IpVersion
	}
	return IpVersion_IP_VERSION_UNSPECIFIED
}

// State of the target that was returned after the last health check.
type TargetState struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the subnet that the target is connected to.
	SubnetId string `protobuf:"bytes,1,opt,name=subnet_id,json=subnetId,proto3" json:"subnet_id,omitempty"`
	// IP address of the target.
	Address string `protobuf:"bytes,2,opt,name=address,proto3" json:"address,omitempty"`
	// Status of the target.
	Status TargetState_Status `protobuf:"varint,3,opt,name=status,proto3,enum=yandex.cloud.loadbalancer.v1.TargetState_Status" json:"status,omitempty"`
	// Zone shifted status.
	ZoneShifted   bool `protobuf:"varint,4,opt,name=zone_shifted,json=zoneShifted,proto3" json:"zone_shifted,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TargetState) Reset() {
	*x = TargetState{}
	mi := &file_yandex_cloud_loadbalancer_v1_network_load_balancer_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TargetState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TargetState) ProtoMessage() {}

func (x *TargetState) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_loadbalancer_v1_network_load_balancer_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TargetState.ProtoReflect.Descriptor instead.
func (*TargetState) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_loadbalancer_v1_network_load_balancer_proto_rawDescGZIP(), []int{3}
}

func (x *TargetState) GetSubnetId() string {
	if x != nil {
		return x.SubnetId
	}
	return ""
}

func (x *TargetState) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

func (x *TargetState) GetStatus() TargetState_Status {
	if x != nil {
		return x.Status
	}
	return TargetState_STATUS_UNSPECIFIED
}

func (x *TargetState) GetZoneShifted() bool {
	if x != nil {
		return x.ZoneShifted
	}
	return false
}

// Status of the disabled zone.
type DisableZoneStatus struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of zone.
	ZoneId string `protobuf:"bytes,1,opt,name=zone_id,json=zoneId,proto3" json:"zone_id,omitempty"`
	// Timestamp until which the zone will be disabled.
	// If not present then zone will be disabled until it is removed through a separate call.
	DisabledUntil *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=disabled_until,json=disabledUntil,proto3" json:"disabled_until,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DisableZoneStatus) Reset() {
	*x = DisableZoneStatus{}
	mi := &file_yandex_cloud_loadbalancer_v1_network_load_balancer_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DisableZoneStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DisableZoneStatus) ProtoMessage() {}

func (x *DisableZoneStatus) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_loadbalancer_v1_network_load_balancer_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DisableZoneStatus.ProtoReflect.Descriptor instead.
func (*DisableZoneStatus) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_loadbalancer_v1_network_load_balancer_proto_rawDescGZIP(), []int{4}
}

func (x *DisableZoneStatus) GetZoneId() string {
	if x != nil {
		return x.ZoneId
	}
	return ""
}

func (x *DisableZoneStatus) GetDisabledUntil() *timestamppb.Timestamp {
	if x != nil {
		return x.DisabledUntil
	}
	return nil
}

var File_yandex_cloud_loadbalancer_v1_network_load_balancer_proto protoreflect.FileDescriptor

const file_yandex_cloud_loadbalancer_v1_network_load_balancer_proto_rawDesc = "" +
	"\n" +
	"8yandex/cloud/loadbalancer/v1/network_load_balancer.proto\x12\x1cyandex.cloud.loadbalancer.v1\x1a\x1fgoogle/protobuf/timestamp.proto\x1a/yandex/cloud/loadbalancer/v1/health_check.proto\x1a\x1dyandex/cloud/validation.proto\"\xfb\t\n" +
	"\x13NetworkLoadBalancer\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\tR\x02id\x12\x1b\n" +
	"\tfolder_id\x18\x02 \x01(\tR\bfolderId\x129\n" +
	"\n" +
	"created_at\x18\x03 \x01(\v2\x1a.google.protobuf.TimestampR\tcreatedAt\x12\x12\n" +
	"\x04name\x18\x04 \x01(\tR\x04name\x12 \n" +
	"\vdescription\x18\x05 \x01(\tR\vdescription\x12U\n" +
	"\x06labels\x18\x06 \x03(\v2=.yandex.cloud.loadbalancer.v1.NetworkLoadBalancer.LabelsEntryR\x06labels\x12\x1b\n" +
	"\tregion_id\x18\a \x01(\tR\bregionId\x12P\n" +
	"\x06status\x18\t \x01(\x0e28.yandex.cloud.loadbalancer.v1.NetworkLoadBalancer.StatusR\x06status\x12J\n" +
	"\x04type\x18\n" +
	" \x01(\x0e26.yandex.cloud.loadbalancer.v1.NetworkLoadBalancer.TypeR\x04type\x12l\n" +
	"\x10session_affinity\x18\v \x01(\x0e2A.yandex.cloud.loadbalancer.v1.NetworkLoadBalancer.SessionAffinityR\x0fsessionAffinity\x12D\n" +
	"\tlisteners\x18\f \x03(\v2&.yandex.cloud.loadbalancer.v1.ListenerR\tlisteners\x12g\n" +
	"\x16attached_target_groups\x18\r \x03(\v21.yandex.cloud.loadbalancer.v1.AttachedTargetGroupR\x14attachedTargetGroups\x12/\n" +
	"\x13deletion_protection\x18\x0e \x01(\bR\x12deletionProtection\x12*\n" +
	"\x11allow_zonal_shift\x18\x0f \x01(\bR\x0fallowZonalShift\x12c\n" +
	"\x15disable_zone_statuses\x18\x12 \x03(\v2/.yandex.cloud.loadbalancer.v1.DisableZoneStatusR\x13disableZoneStatuses\x1a9\n" +
	"\vLabelsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\"\x7f\n" +
	"\x06Status\x12\x16\n" +
	"\x12STATUS_UNSPECIFIED\x10\x00\x12\f\n" +
	"\bCREATING\x10\x01\x12\f\n" +
	"\bSTARTING\x10\x02\x12\n" +
	"\n" +
	"\x06ACTIVE\x10\x03\x12\f\n" +
	"\bSTOPPING\x10\x04\x12\v\n" +
	"\aSTOPPED\x10\x05\x12\f\n" +
	"\bDELETING\x10\x06\x12\f\n" +
	"\bINACTIVE\x10\a\"8\n" +
	"\x04Type\x12\x14\n" +
	"\x10TYPE_UNSPECIFIED\x10\x00\x12\f\n" +
	"\bEXTERNAL\x10\x01\x12\f\n" +
	"\bINTERNAL\x10\x02\"M\n" +
	"\x0fSessionAffinity\x12 \n" +
	"\x1cSESSION_AFFINITY_UNSPECIFIED\x10\x00\x12\x18\n" +
	"\x14CLIENT_IP_PORT_PROTO\x10\x01J\x04\b\b\x10\tJ\x04\b\x10\x10\x11J\x04\b\x11\x10\x12\"\xa2\x01\n" +
	"\x13AttachedTargetGroup\x124\n" +
	"\x0ftarget_group_id\x18\x01 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=50R\rtargetGroupId\x12U\n" +
	"\rhealth_checks\x18\x02 \x03(\v2).yandex.cloud.loadbalancer.v1.HealthCheckB\x05\x82\xc81\x011R\fhealthChecks\"\xd7\x02\n" +
	"\bListener\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x12\x18\n" +
	"\aaddress\x18\x02 \x01(\tR\aaddress\x12\x12\n" +
	"\x04port\x18\x03 \x01(\x03R\x04port\x12K\n" +
	"\bprotocol\x18\x04 \x01(\x0e2/.yandex.cloud.loadbalancer.v1.Listener.ProtocolR\bprotocol\x12\x1f\n" +
	"\vtarget_port\x18\x05 \x01(\x03R\n" +
	"targetPort\x12\x1b\n" +
	"\tsubnet_id\x18\x06 \x01(\tR\bsubnetId\x12F\n" +
	"\n" +
	"ip_version\x18\a \x01(\x0e2'.yandex.cloud.loadbalancer.v1.IpVersionR\tipVersion\"6\n" +
	"\bProtocol\x12\x18\n" +
	"\x14PROTOCOL_UNSPECIFIED\x10\x00\x12\a\n" +
	"\x03TCP\x10\x01\x12\a\n" +
	"\x03UDP\x10\x02\"\x98\x02\n" +
	"\vTargetState\x12\x1b\n" +
	"\tsubnet_id\x18\x01 \x01(\tR\bsubnetId\x12\x18\n" +
	"\aaddress\x18\x02 \x01(\tR\aaddress\x12H\n" +
	"\x06status\x18\x03 \x01(\x0e20.yandex.cloud.loadbalancer.v1.TargetState.StatusR\x06status\x12!\n" +
	"\fzone_shifted\x18\x04 \x01(\bR\vzoneShifted\"e\n" +
	"\x06Status\x12\x16\n" +
	"\x12STATUS_UNSPECIFIED\x10\x00\x12\v\n" +
	"\aINITIAL\x10\x01\x12\v\n" +
	"\aHEALTHY\x10\x02\x12\r\n" +
	"\tUNHEALTHY\x10\x03\x12\f\n" +
	"\bDRAINING\x10\x04\x12\f\n" +
	"\bINACTIVE\x10\x05\"u\n" +
	"\x11DisableZoneStatus\x12\x1d\n" +
	"\azone_id\x18\x01 \x01(\tB\x04\xe8\xc71\x01R\x06zoneId\x12A\n" +
	"\x0edisabled_until\x18\x02 \x01(\v2\x1a.google.protobuf.TimestampR\rdisabledUntil*;\n" +
	"\tIpVersion\x12\x1a\n" +
	"\x16IP_VERSION_UNSPECIFIED\x10\x00\x12\b\n" +
	"\x04IPV4\x10\x01\x12\b\n" +
	"\x04IPV6\x10\x02Bq\n" +
	" yandex.cloud.api.loadbalancer.v1ZMgithub.com/yandex-cloud/go-genproto/yandex/cloud/loadbalancer/v1;loadbalancerb\x06proto3"

var (
	file_yandex_cloud_loadbalancer_v1_network_load_balancer_proto_rawDescOnce sync.Once
	file_yandex_cloud_loadbalancer_v1_network_load_balancer_proto_rawDescData []byte
)

func file_yandex_cloud_loadbalancer_v1_network_load_balancer_proto_rawDescGZIP() []byte {
	file_yandex_cloud_loadbalancer_v1_network_load_balancer_proto_rawDescOnce.Do(func() {
		file_yandex_cloud_loadbalancer_v1_network_load_balancer_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_yandex_cloud_loadbalancer_v1_network_load_balancer_proto_rawDesc), len(file_yandex_cloud_loadbalancer_v1_network_load_balancer_proto_rawDesc)))
	})
	return file_yandex_cloud_loadbalancer_v1_network_load_balancer_proto_rawDescData
}

var file_yandex_cloud_loadbalancer_v1_network_load_balancer_proto_enumTypes = make([]protoimpl.EnumInfo, 6)
var file_yandex_cloud_loadbalancer_v1_network_load_balancer_proto_msgTypes = make([]protoimpl.MessageInfo, 6)
var file_yandex_cloud_loadbalancer_v1_network_load_balancer_proto_goTypes = []any{
	(IpVersion)(0),                           // 0: yandex.cloud.loadbalancer.v1.IpVersion
	(NetworkLoadBalancer_Status)(0),          // 1: yandex.cloud.loadbalancer.v1.NetworkLoadBalancer.Status
	(NetworkLoadBalancer_Type)(0),            // 2: yandex.cloud.loadbalancer.v1.NetworkLoadBalancer.Type
	(NetworkLoadBalancer_SessionAffinity)(0), // 3: yandex.cloud.loadbalancer.v1.NetworkLoadBalancer.SessionAffinity
	(Listener_Protocol)(0),                   // 4: yandex.cloud.loadbalancer.v1.Listener.Protocol
	(TargetState_Status)(0),                  // 5: yandex.cloud.loadbalancer.v1.TargetState.Status
	(*NetworkLoadBalancer)(nil),              // 6: yandex.cloud.loadbalancer.v1.NetworkLoadBalancer
	(*AttachedTargetGroup)(nil),              // 7: yandex.cloud.loadbalancer.v1.AttachedTargetGroup
	(*Listener)(nil),                         // 8: yandex.cloud.loadbalancer.v1.Listener
	(*TargetState)(nil),                      // 9: yandex.cloud.loadbalancer.v1.TargetState
	(*DisableZoneStatus)(nil),                // 10: yandex.cloud.loadbalancer.v1.DisableZoneStatus
	nil,                                      // 11: yandex.cloud.loadbalancer.v1.NetworkLoadBalancer.LabelsEntry
	(*timestamppb.Timestamp)(nil),            // 12: google.protobuf.Timestamp
	(*HealthCheck)(nil),                      // 13: yandex.cloud.loadbalancer.v1.HealthCheck
}
var file_yandex_cloud_loadbalancer_v1_network_load_balancer_proto_depIdxs = []int32{
	12, // 0: yandex.cloud.loadbalancer.v1.NetworkLoadBalancer.created_at:type_name -> google.protobuf.Timestamp
	11, // 1: yandex.cloud.loadbalancer.v1.NetworkLoadBalancer.labels:type_name -> yandex.cloud.loadbalancer.v1.NetworkLoadBalancer.LabelsEntry
	1,  // 2: yandex.cloud.loadbalancer.v1.NetworkLoadBalancer.status:type_name -> yandex.cloud.loadbalancer.v1.NetworkLoadBalancer.Status
	2,  // 3: yandex.cloud.loadbalancer.v1.NetworkLoadBalancer.type:type_name -> yandex.cloud.loadbalancer.v1.NetworkLoadBalancer.Type
	3,  // 4: yandex.cloud.loadbalancer.v1.NetworkLoadBalancer.session_affinity:type_name -> yandex.cloud.loadbalancer.v1.NetworkLoadBalancer.SessionAffinity
	8,  // 5: yandex.cloud.loadbalancer.v1.NetworkLoadBalancer.listeners:type_name -> yandex.cloud.loadbalancer.v1.Listener
	7,  // 6: yandex.cloud.loadbalancer.v1.NetworkLoadBalancer.attached_target_groups:type_name -> yandex.cloud.loadbalancer.v1.AttachedTargetGroup
	10, // 7: yandex.cloud.loadbalancer.v1.NetworkLoadBalancer.disable_zone_statuses:type_name -> yandex.cloud.loadbalancer.v1.DisableZoneStatus
	13, // 8: yandex.cloud.loadbalancer.v1.AttachedTargetGroup.health_checks:type_name -> yandex.cloud.loadbalancer.v1.HealthCheck
	4,  // 9: yandex.cloud.loadbalancer.v1.Listener.protocol:type_name -> yandex.cloud.loadbalancer.v1.Listener.Protocol
	0,  // 10: yandex.cloud.loadbalancer.v1.Listener.ip_version:type_name -> yandex.cloud.loadbalancer.v1.IpVersion
	5,  // 11: yandex.cloud.loadbalancer.v1.TargetState.status:type_name -> yandex.cloud.loadbalancer.v1.TargetState.Status
	12, // 12: yandex.cloud.loadbalancer.v1.DisableZoneStatus.disabled_until:type_name -> google.protobuf.Timestamp
	13, // [13:13] is the sub-list for method output_type
	13, // [13:13] is the sub-list for method input_type
	13, // [13:13] is the sub-list for extension type_name
	13, // [13:13] is the sub-list for extension extendee
	0,  // [0:13] is the sub-list for field type_name
}

func init() { file_yandex_cloud_loadbalancer_v1_network_load_balancer_proto_init() }
func file_yandex_cloud_loadbalancer_v1_network_load_balancer_proto_init() {
	if File_yandex_cloud_loadbalancer_v1_network_load_balancer_proto != nil {
		return
	}
	file_yandex_cloud_loadbalancer_v1_health_check_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_yandex_cloud_loadbalancer_v1_network_load_balancer_proto_rawDesc), len(file_yandex_cloud_loadbalancer_v1_network_load_balancer_proto_rawDesc)),
			NumEnums:      6,
			NumMessages:   6,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_yandex_cloud_loadbalancer_v1_network_load_balancer_proto_goTypes,
		DependencyIndexes: file_yandex_cloud_loadbalancer_v1_network_load_balancer_proto_depIdxs,
		EnumInfos:         file_yandex_cloud_loadbalancer_v1_network_load_balancer_proto_enumTypes,
		MessageInfos:      file_yandex_cloud_loadbalancer_v1_network_load_balancer_proto_msgTypes,
	}.Build()
	File_yandex_cloud_loadbalancer_v1_network_load_balancer_proto = out.File
	file_yandex_cloud_loadbalancer_v1_network_load_balancer_proto_goTypes = nil
	file_yandex_cloud_loadbalancer_v1_network_load_balancer_proto_depIdxs = nil
}
