// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.11
// 	protoc        v3.21.12
// source: yandex/cloud/logging/v1/sink_service.proto

package logging

import (
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud"
	access "github.com/yandex-cloud/go-genproto/yandex/cloud/access"
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud/api"
	operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type GetSinkRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the sink to return.
	//
	// To get a sink ID make a [SinkService.List] request.
	SinkId        string `protobuf:"bytes,1,opt,name=sink_id,json=sinkId,proto3" json:"sink_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetSinkRequest) Reset() {
	*x = GetSinkRequest{}
	mi := &file_yandex_cloud_logging_v1_sink_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetSinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSinkRequest) ProtoMessage() {}

func (x *GetSinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_logging_v1_sink_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSinkRequest.ProtoReflect.Descriptor instead.
func (*GetSinkRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_logging_v1_sink_service_proto_rawDescGZIP(), []int{0}
}

func (x *GetSinkRequest) GetSinkId() string {
	if x != nil {
		return x.SinkId
	}
	return ""
}

type ListSinksRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Folder ID of the sinks to return.
	//
	// To get a folder ID make a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than `page_size`, the service returns a [ListSinkssResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	//
	// Default value: 100.
	PageSize int64 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set `page_token` to the
	// [ListSinksResponse.next_page_token] returned by a previous list request.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter expression that filters sinks listed in the response.
	//
	// The expression must specify:
	// 1. The field name. Currently filtering can only be applied to the [Sink.name] field.
	// 2. An `=` operator.
	// 3. The value in double quotes (`"`). Must be 3-63 characters long and match the regular expression `[a-z][-a-z0-9]{1,61}[a-z0-9]`.
	// Example of a filter: `name="my-sink"`.
	Filter        string `protobuf:"bytes,5,opt,name=filter,proto3" json:"filter,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListSinksRequest) Reset() {
	*x = ListSinksRequest{}
	mi := &file_yandex_cloud_logging_v1_sink_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListSinksRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSinksRequest) ProtoMessage() {}

func (x *ListSinksRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_logging_v1_sink_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSinksRequest.ProtoReflect.Descriptor instead.
func (*ListSinksRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_logging_v1_sink_service_proto_rawDescGZIP(), []int{1}
}

func (x *ListSinksRequest) GetFolderId() string {
	if x != nil {
		return x.FolderId
	}
	return ""
}

func (x *ListSinksRequest) GetPageSize() int64 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListSinksRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListSinksRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

type ListSinksResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// List of sinks in the specified folder.
	Sinks []*Sink `protobuf:"bytes,1,rep,name=sinks,proto3" json:"sinks,omitempty"`
	// Token for getting the next page of the list. If the number of results is greater than
	// the specified [ListSinksRequest.page_size], use `next_page_token` as the value
	// for the [ListSinksRequest.page_token] parameter in the next list request.
	//
	// Each subsequent page will have its own `next_page_token` to continue paging through the results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListSinksResponse) Reset() {
	*x = ListSinksResponse{}
	mi := &file_yandex_cloud_logging_v1_sink_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListSinksResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSinksResponse) ProtoMessage() {}

func (x *ListSinksResponse) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_logging_v1_sink_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSinksResponse.ProtoReflect.Descriptor instead.
func (*ListSinksResponse) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_logging_v1_sink_service_proto_rawDescGZIP(), []int{2}
}

func (x *ListSinksResponse) GetSinks() []*Sink {
	if x != nil {
		return x.Sinks
	}
	return nil
}

func (x *ListSinksResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

type CreateSinkRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the folder to create a sink in.
	//
	// To get a folder ID make a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// Name of the sink.
	// The name must be unique within the folder.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the sink.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Sink labels as `key:value` pairs.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Logs will be written to the sink on behalf of this service account
	ServiceAccountId string `protobuf:"bytes,5,opt,name=service_account_id,json=serviceAccountId,proto3" json:"service_account_id,omitempty"`
	// Logs destination
	//
	// Types that are valid to be assigned to Sink:
	//
	//	*CreateSinkRequest_Yds
	//	*CreateSinkRequest_S3
	Sink          isCreateSinkRequest_Sink `protobuf_oneof:"sink"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CreateSinkRequest) Reset() {
	*x = CreateSinkRequest{}
	mi := &file_yandex_cloud_logging_v1_sink_service_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateSinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateSinkRequest) ProtoMessage() {}

func (x *CreateSinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_logging_v1_sink_service_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateSinkRequest.ProtoReflect.Descriptor instead.
func (*CreateSinkRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_logging_v1_sink_service_proto_rawDescGZIP(), []int{3}
}

func (x *CreateSinkRequest) GetFolderId() string {
	if x != nil {
		return x.FolderId
	}
	return ""
}

func (x *CreateSinkRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CreateSinkRequest) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *CreateSinkRequest) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *CreateSinkRequest) GetServiceAccountId() string {
	if x != nil {
		return x.ServiceAccountId
	}
	return ""
}

func (x *CreateSinkRequest) GetSink() isCreateSinkRequest_Sink {
	if x != nil {
		return x.Sink
	}
	return nil
}

func (x *CreateSinkRequest) GetYds() *Sink_Yds {
	if x != nil {
		if x, ok := x.Sink.(*CreateSinkRequest_Yds); ok {
			return x.Yds
		}
	}
	return nil
}

func (x *CreateSinkRequest) GetS3() *Sink_S3 {
	if x != nil {
		if x, ok := x.Sink.(*CreateSinkRequest_S3); ok {
			return x.S3
		}
	}
	return nil
}

type isCreateSinkRequest_Sink interface {
	isCreateSinkRequest_Sink()
}

type CreateSinkRequest_Yds struct {
	// Yandex data stream
	Yds *Sink_Yds `protobuf:"bytes,6,opt,name=yds,proto3,oneof"`
}

type CreateSinkRequest_S3 struct {
	// Object storage
	S3 *Sink_S3 `protobuf:"bytes,7,opt,name=s3,proto3,oneof"`
}

func (*CreateSinkRequest_Yds) isCreateSinkRequest_Sink() {}

func (*CreateSinkRequest_S3) isCreateSinkRequest_Sink() {}

type CreateSinkMetadata struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the sink being created.
	SinkId        string `protobuf:"bytes,1,opt,name=sink_id,json=sinkId,proto3" json:"sink_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CreateSinkMetadata) Reset() {
	*x = CreateSinkMetadata{}
	mi := &file_yandex_cloud_logging_v1_sink_service_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateSinkMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateSinkMetadata) ProtoMessage() {}

func (x *CreateSinkMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_logging_v1_sink_service_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateSinkMetadata.ProtoReflect.Descriptor instead.
func (*CreateSinkMetadata) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_logging_v1_sink_service_proto_rawDescGZIP(), []int{4}
}

func (x *CreateSinkMetadata) GetSinkId() string {
	if x != nil {
		return x.SinkId
	}
	return ""
}

type UpdateSinkRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the sink to update.
	//
	// To get a sink ID make a [SinkService.List] request.
	SinkId string `protobuf:"bytes,1,opt,name=sink_id,json=sinkId,proto3" json:"sink_id,omitempty"`
	// Field mask that specifies which attributes of the function should be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// New name of the sink.
	// The name must be unique within the folder.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// New Description of the sink.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// New sink labels as `key:value` pairs.
	Labels map[string]string `protobuf:"bytes,5,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// new service account to use for logs writing to the sink.
	ServiceAccountId string `protobuf:"bytes,6,opt,name=service_account_id,json=serviceAccountId,proto3" json:"service_account_id,omitempty"`
	// New logs destination
	//
	// Types that are valid to be assigned to Sink:
	//
	//	*UpdateSinkRequest_Yds
	//	*UpdateSinkRequest_S3
	Sink          isUpdateSinkRequest_Sink `protobuf_oneof:"sink"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpdateSinkRequest) Reset() {
	*x = UpdateSinkRequest{}
	mi := &file_yandex_cloud_logging_v1_sink_service_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateSinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateSinkRequest) ProtoMessage() {}

func (x *UpdateSinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_logging_v1_sink_service_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateSinkRequest.ProtoReflect.Descriptor instead.
func (*UpdateSinkRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_logging_v1_sink_service_proto_rawDescGZIP(), []int{5}
}

func (x *UpdateSinkRequest) GetSinkId() string {
	if x != nil {
		return x.SinkId
	}
	return ""
}

func (x *UpdateSinkRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateSinkRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *UpdateSinkRequest) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *UpdateSinkRequest) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *UpdateSinkRequest) GetServiceAccountId() string {
	if x != nil {
		return x.ServiceAccountId
	}
	return ""
}

func (x *UpdateSinkRequest) GetSink() isUpdateSinkRequest_Sink {
	if x != nil {
		return x.Sink
	}
	return nil
}

func (x *UpdateSinkRequest) GetYds() *Sink_Yds {
	if x != nil {
		if x, ok := x.Sink.(*UpdateSinkRequest_Yds); ok {
			return x.Yds
		}
	}
	return nil
}

func (x *UpdateSinkRequest) GetS3() *Sink_S3 {
	if x != nil {
		if x, ok := x.Sink.(*UpdateSinkRequest_S3); ok {
			return x.S3
		}
	}
	return nil
}

type isUpdateSinkRequest_Sink interface {
	isUpdateSinkRequest_Sink()
}

type UpdateSinkRequest_Yds struct {
	// Yandex data stream
	Yds *Sink_Yds `protobuf:"bytes,7,opt,name=yds,proto3,oneof"`
}

type UpdateSinkRequest_S3 struct {
	// Object storage
	S3 *Sink_S3 `protobuf:"bytes,8,opt,name=s3,proto3,oneof"`
}

func (*UpdateSinkRequest_Yds) isUpdateSinkRequest_Sink() {}

func (*UpdateSinkRequest_S3) isUpdateSinkRequest_Sink() {}

type UpdateSinkMetadata struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the sink being updated.
	SinkId        string `protobuf:"bytes,1,opt,name=sink_id,json=sinkId,proto3" json:"sink_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpdateSinkMetadata) Reset() {
	*x = UpdateSinkMetadata{}
	mi := &file_yandex_cloud_logging_v1_sink_service_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateSinkMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateSinkMetadata) ProtoMessage() {}

func (x *UpdateSinkMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_logging_v1_sink_service_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateSinkMetadata.ProtoReflect.Descriptor instead.
func (*UpdateSinkMetadata) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_logging_v1_sink_service_proto_rawDescGZIP(), []int{6}
}

func (x *UpdateSinkMetadata) GetSinkId() string {
	if x != nil {
		return x.SinkId
	}
	return ""
}

type DeleteSinkRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the sink to delete.
	//
	// To get a sink ID make a [SinkService.List] request.
	SinkId        string `protobuf:"bytes,1,opt,name=sink_id,json=sinkId,proto3" json:"sink_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeleteSinkRequest) Reset() {
	*x = DeleteSinkRequest{}
	mi := &file_yandex_cloud_logging_v1_sink_service_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteSinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteSinkRequest) ProtoMessage() {}

func (x *DeleteSinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_logging_v1_sink_service_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteSinkRequest.ProtoReflect.Descriptor instead.
func (*DeleteSinkRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_logging_v1_sink_service_proto_rawDescGZIP(), []int{7}
}

func (x *DeleteSinkRequest) GetSinkId() string {
	if x != nil {
		return x.SinkId
	}
	return ""
}

type DeleteSinkMetadata struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the sink being deleted.
	SinkId        string `protobuf:"bytes,1,opt,name=sink_id,json=sinkId,proto3" json:"sink_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeleteSinkMetadata) Reset() {
	*x = DeleteSinkMetadata{}
	mi := &file_yandex_cloud_logging_v1_sink_service_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteSinkMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteSinkMetadata) ProtoMessage() {}

func (x *DeleteSinkMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_logging_v1_sink_service_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteSinkMetadata.ProtoReflect.Descriptor instead.
func (*DeleteSinkMetadata) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_logging_v1_sink_service_proto_rawDescGZIP(), []int{8}
}

func (x *DeleteSinkMetadata) GetSinkId() string {
	if x != nil {
		return x.SinkId
	}
	return ""
}

type ListSinkOperationsRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the sink to list operations for.
	//
	// To get a sink ID make a [SinkService.List] request.
	SinkId string `protobuf:"bytes,1,opt,name=sink_id,json=sinkId,proto3" json:"sink_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than `page_size`, the service returns a [ListSinkOperationsResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	//
	// Default value: 100.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set `page_token` to the
	// [ListSinkOperationsResponse.next_page_token] returned by a previous list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter expression that filters resources listed in the response.
	//
	// The expression must specify:
	// 1. The field name. Currently filtering can be applied to the [operation.Operation.description], [operation.Operation.created_at], [operation.Operation.modified_at], [operation.Operation.created_by], [operation.Operation.done] fields.
	// 2. An `=` operator.
	// 3. The value in double quotes (`"`). Must be 3-63 characters long and match the regular expression `[a-z][-a-z0-9]{1,61}[a-z0-9]`.
	// Examples of a filter: `done=false`, `created_by='John.Doe'`.
	Filter        string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListSinkOperationsRequest) Reset() {
	*x = ListSinkOperationsRequest{}
	mi := &file_yandex_cloud_logging_v1_sink_service_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListSinkOperationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSinkOperationsRequest) ProtoMessage() {}

func (x *ListSinkOperationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_logging_v1_sink_service_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSinkOperationsRequest.ProtoReflect.Descriptor instead.
func (*ListSinkOperationsRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_logging_v1_sink_service_proto_rawDescGZIP(), []int{9}
}

func (x *ListSinkOperationsRequest) GetSinkId() string {
	if x != nil {
		return x.SinkId
	}
	return ""
}

func (x *ListSinkOperationsRequest) GetPageSize() int64 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListSinkOperationsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListSinkOperationsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

type ListSinkOperationsResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// List of operations for the specified sink.
	Operations []*operation.Operation `protobuf:"bytes,1,rep,name=operations,proto3" json:"operations,omitempty"`
	// Token for getting the next page of the list. If the number of results is greater than
	// the specified [ListOSinkperationsRequest.page_size], use `next_page_token` as the value
	// for the [ListSinkOperationsRequest.page_token] parameter in the next list request.
	//
	// Each subsequent page will have its own `next_page_token` to continue paging through the results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListSinkOperationsResponse) Reset() {
	*x = ListSinkOperationsResponse{}
	mi := &file_yandex_cloud_logging_v1_sink_service_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListSinkOperationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSinkOperationsResponse) ProtoMessage() {}

func (x *ListSinkOperationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_logging_v1_sink_service_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSinkOperationsResponse.ProtoReflect.Descriptor instead.
func (*ListSinkOperationsResponse) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_logging_v1_sink_service_proto_rawDescGZIP(), []int{10}
}

func (x *ListSinkOperationsResponse) GetOperations() []*operation.Operation {
	if x != nil {
		return x.Operations
	}
	return nil
}

func (x *ListSinkOperationsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

var File_yandex_cloud_logging_v1_sink_service_proto protoreflect.FileDescriptor

const file_yandex_cloud_logging_v1_sink_service_proto_rawDesc = "" +
	"\n" +
	"*yandex/cloud/logging/v1/sink_service.proto\x12\x17yandex.cloud.logging.v1\x1a\x1cgoogle/api/annotations.proto\x1a google/protobuf/field_mask.proto\x1a yandex/cloud/access/access.proto\x1a yandex/cloud/api/operation.proto\x1a\"yandex/cloud/logging/v1/sink.proto\x1a&yandex/cloud/operation/operation.proto\x1a\x1dyandex/cloud/validation.proto\"7\n" +
	"\x0eGetSinkRequest\x12%\n" +
	"\asink_id\x18\x01 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=64R\x06sinkId\"\xae\x01\n" +
	"\x10ListSinksRequest\x12)\n" +
	"\tfolder_id\x18\x01 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=64R\bfolderId\x12\x1b\n" +
	"\tpage_size\x18\x03 \x01(\x03R\bpageSize\x12(\n" +
	"\n" +
	"page_token\x18\x04 \x01(\tB\t\x8a\xc81\x05<=100R\tpageToken\x12\"\n" +
	"\x06filter\x18\x05 \x01(\tB\n" +
	"\x8a\xc81\x06<=1000R\x06filterJ\x04\b\x02\x10\x03\"p\n" +
	"\x11ListSinksResponse\x123\n" +
	"\x05sinks\x18\x01 \x03(\v2\x1d.yandex.cloud.logging.v1.SinkR\x05sinks\x12&\n" +
	"\x0fnext_page_token\x18\x02 \x01(\tR\rnextPageToken\"\x9c\x04\n" +
	"\x11CreateSinkRequest\x12)\n" +
	"\tfolder_id\x18\x01 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=64R\bfolderId\x125\n" +
	"\x04name\x18\x02 \x01(\tB!\xf2\xc71\x1d|[a-z][-a-z0-9]{1,61}[a-z0-9]R\x04name\x12+\n" +
	"\vdescription\x18\x03 \x01(\tB\t\x8a\xc81\x05<=256R\vdescription\x12\x8b\x01\n" +
	"\x06labels\x18\x04 \x03(\v26.yandex.cloud.logging.v1.CreateSinkRequest.LabelsEntryB;\xf2\xc71\v[-_0-9a-z]*\x82\xc81\x04<=64\x8a\xc81\x04<=63\xb2\xc81\x18\x12\x10[a-z][-_0-9a-z]*\x1a\x041-63R\x06labels\x126\n" +
	"\x12service_account_id\x18\x05 \x01(\tB\b\x8a\xc81\x04<=64R\x10serviceAccountId\x125\n" +
	"\x03yds\x18\x06 \x01(\v2!.yandex.cloud.logging.v1.Sink.YdsH\x00R\x03yds\x122\n" +
	"\x02s3\x18\a \x01(\v2 .yandex.cloud.logging.v1.Sink.S3H\x00R\x02s3\x1a9\n" +
	"\vLabelsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01B\f\n" +
	"\x04sink\x12\x04\xc0\xc11\x01\"-\n" +
	"\x12CreateSinkMetadata\x12\x17\n" +
	"\asink_id\x18\x01 \x01(\tR\x06sinkId\"\xd5\x04\n" +
	"\x11UpdateSinkRequest\x12%\n" +
	"\asink_id\x18\x01 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=64R\x06sinkId\x12;\n" +
	"\vupdate_mask\x18\x02 \x01(\v2\x1a.google.protobuf.FieldMaskR\n" +
	"updateMask\x125\n" +
	"\x04name\x18\x03 \x01(\tB!\xf2\xc71\x1d|[a-z][-a-z0-9]{1,61}[a-z0-9]R\x04name\x12+\n" +
	"\vdescription\x18\x04 \x01(\tB\t\x8a\xc81\x05<=256R\vdescription\x12\x8b\x01\n" +
	"\x06labels\x18\x05 \x03(\v26.yandex.cloud.logging.v1.UpdateSinkRequest.LabelsEntryB;\xf2\xc71\v[-_0-9a-z]*\x82\xc81\x04<=64\x8a\xc81\x04<=63\xb2\xc81\x18\x12\x10[a-z][-_0-9a-z]*\x1a\x041-63R\x06labels\x126\n" +
	"\x12service_account_id\x18\x06 \x01(\tB\b\x8a\xc81\x04<=64R\x10serviceAccountId\x125\n" +
	"\x03yds\x18\a \x01(\v2!.yandex.cloud.logging.v1.Sink.YdsH\x00R\x03yds\x122\n" +
	"\x02s3\x18\b \x01(\v2 .yandex.cloud.logging.v1.Sink.S3H\x00R\x02s3\x1a9\n" +
	"\vLabelsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01B\f\n" +
	"\x04sink\x12\x04\xc0\xc11\x01\"-\n" +
	"\x12UpdateSinkMetadata\x12\x17\n" +
	"\asink_id\x18\x01 \x01(\tR\x06sinkId\":\n" +
	"\x11DeleteSinkRequest\x12%\n" +
	"\asink_id\x18\x01 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=64R\x06sinkId\"-\n" +
	"\x12DeleteSinkMetadata\x12\x17\n" +
	"\asink_id\x18\x01 \x01(\tR\x06sinkId\"\xb9\x01\n" +
	"\x19ListSinkOperationsRequest\x12%\n" +
	"\asink_id\x18\x01 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=64R\x06sinkId\x12'\n" +
	"\tpage_size\x18\x02 \x01(\x03B\n" +
	"\xfa\xc71\x060-1000R\bpageSize\x12(\n" +
	"\n" +
	"page_token\x18\x03 \x01(\tB\t\x8a\xc81\x05<=100R\tpageToken\x12\"\n" +
	"\x06filter\x18\x04 \x01(\tB\n" +
	"\x8a\xc81\x06<=1000R\x06filter\"\x87\x01\n" +
	"\x1aListSinkOperationsResponse\x12A\n" +
	"\n" +
	"operations\x18\x01 \x03(\v2!.yandex.cloud.operation.OperationR\n" +
	"operations\x12&\n" +
	"\x0fnext_page_token\x18\x02 \x01(\tR\rnextPageToken2\x91\f\n" +
	"\vSinkService\x12r\n" +
	"\x03Get\x12'.yandex.cloud.logging.v1.GetSinkRequest\x1a\x1d.yandex.cloud.logging.v1.Sink\"#\x82\xd3\xe4\x93\x02\x1d\x12\x1b/logging/v1/sinks/{sink_id}\x12x\n" +
	"\x04List\x12).yandex.cloud.logging.v1.ListSinksRequest\x1a*.yandex.cloud.logging.v1.ListSinksResponse\"\x19\x82\xd3\xe4\x93\x02\x13\x12\x11/logging/v1/sinks\x12\x93\x01\n" +
	"\x06Create\x12*.yandex.cloud.logging.v1.CreateSinkRequest\x1a!.yandex.cloud.operation.Operation\":\xb2\xd2*\x1a\n" +
	"\x12CreateSinkMetadata\x12\x04Sink\x82\xd3\xe4\x93\x02\x16:\x01*\"\x11/logging/v1/sinks\x12\x9d\x01\n" +
	"\x06Update\x12*.yandex.cloud.logging.v1.UpdateSinkRequest\x1a!.yandex.cloud.operation.Operation\"D\xb2\xd2*\x1a\n" +
	"\x12UpdateSinkMetadata\x12\x04Sink\x82\xd3\xe4\x93\x02 :\x01*2\x1b/logging/v1/sinks/{sink_id}\x12\xab\x01\n" +
	"\x06Delete\x12*.yandex.cloud.logging.v1.DeleteSinkRequest\x1a!.yandex.cloud.operation.Operation\"R\xb2\xd2*+\n" +
	"\x12DeleteSinkMetadata\x12\x15google.protobuf.Empty\x82\xd3\xe4\x93\x02\x1d*\x1b/logging/v1/sinks/{sink_id}\x12\xa9\x01\n" +
	"\x0eListOperations\x122.yandex.cloud.logging.v1.ListSinkOperationsRequest\x1a3.yandex.cloud.logging.v1.ListSinkOperationsResponse\".\x82\xd3\xe4\x93\x02(\x12&/logging/v1/sinks/{sink_id}/operations\x12\xb1\x01\n" +
	"\x12ListAccessBindings\x12..yandex.cloud.access.ListAccessBindingsRequest\x1a/.yandex.cloud.access.ListAccessBindingsResponse\":\x82\xd3\xe4\x93\x024\x122/logging/v1/sinks/{resource_id}:listAccessBindings\x12\xe0\x01\n" +
	"\x11SetAccessBindings\x12-.yandex.cloud.access.SetAccessBindingsRequest\x1a!.yandex.cloud.operation.Operation\"y\xb2\xd2*9\n" +
	" access.SetAccessBindingsMetadata\x12\x15google.protobuf.Empty\x82\xd3\xe4\x93\x026:\x01*\"1/logging/v1/sinks/{resource_id}:setAccessBindings\x12\xec\x01\n" +
	"\x14UpdateAccessBindings\x120.yandex.cloud.access.UpdateAccessBindingsRequest\x1a!.yandex.cloud.operation.Operation\"\x7f\xb2\xd2*<\n" +
	"#access.UpdateAccessBindingsMetadata\x12\x15google.protobuf.Empty\x82\xd3\xe4\x93\x029:\x01*24/logging/v1/sinks/{resource_id}:updateAccessBindingsBb\n" +
	"\x1byandex.cloud.api.logging.v1ZCgithub.com/yandex-cloud/go-genproto/yandex/cloud/logging/v1;loggingb\x06proto3"

var (
	file_yandex_cloud_logging_v1_sink_service_proto_rawDescOnce sync.Once
	file_yandex_cloud_logging_v1_sink_service_proto_rawDescData []byte
)

func file_yandex_cloud_logging_v1_sink_service_proto_rawDescGZIP() []byte {
	file_yandex_cloud_logging_v1_sink_service_proto_rawDescOnce.Do(func() {
		file_yandex_cloud_logging_v1_sink_service_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_yandex_cloud_logging_v1_sink_service_proto_rawDesc), len(file_yandex_cloud_logging_v1_sink_service_proto_rawDesc)))
	})
	return file_yandex_cloud_logging_v1_sink_service_proto_rawDescData
}

var file_yandex_cloud_logging_v1_sink_service_proto_msgTypes = make([]protoimpl.MessageInfo, 13)
var file_yandex_cloud_logging_v1_sink_service_proto_goTypes = []any{
	(*GetSinkRequest)(nil),                     // 0: yandex.cloud.logging.v1.GetSinkRequest
	(*ListSinksRequest)(nil),                   // 1: yandex.cloud.logging.v1.ListSinksRequest
	(*ListSinksResponse)(nil),                  // 2: yandex.cloud.logging.v1.ListSinksResponse
	(*CreateSinkRequest)(nil),                  // 3: yandex.cloud.logging.v1.CreateSinkRequest
	(*CreateSinkMetadata)(nil),                 // 4: yandex.cloud.logging.v1.CreateSinkMetadata
	(*UpdateSinkRequest)(nil),                  // 5: yandex.cloud.logging.v1.UpdateSinkRequest
	(*UpdateSinkMetadata)(nil),                 // 6: yandex.cloud.logging.v1.UpdateSinkMetadata
	(*DeleteSinkRequest)(nil),                  // 7: yandex.cloud.logging.v1.DeleteSinkRequest
	(*DeleteSinkMetadata)(nil),                 // 8: yandex.cloud.logging.v1.DeleteSinkMetadata
	(*ListSinkOperationsRequest)(nil),          // 9: yandex.cloud.logging.v1.ListSinkOperationsRequest
	(*ListSinkOperationsResponse)(nil),         // 10: yandex.cloud.logging.v1.ListSinkOperationsResponse
	nil,                                        // 11: yandex.cloud.logging.v1.CreateSinkRequest.LabelsEntry
	nil,                                        // 12: yandex.cloud.logging.v1.UpdateSinkRequest.LabelsEntry
	(*Sink)(nil),                               // 13: yandex.cloud.logging.v1.Sink
	(*Sink_Yds)(nil),                           // 14: yandex.cloud.logging.v1.Sink.Yds
	(*Sink_S3)(nil),                            // 15: yandex.cloud.logging.v1.Sink.S3
	(*fieldmaskpb.FieldMask)(nil),              // 16: google.protobuf.FieldMask
	(*operation.Operation)(nil),                // 17: yandex.cloud.operation.Operation
	(*access.ListAccessBindingsRequest)(nil),   // 18: yandex.cloud.access.ListAccessBindingsRequest
	(*access.SetAccessBindingsRequest)(nil),    // 19: yandex.cloud.access.SetAccessBindingsRequest
	(*access.UpdateAccessBindingsRequest)(nil), // 20: yandex.cloud.access.UpdateAccessBindingsRequest
	(*access.ListAccessBindingsResponse)(nil),  // 21: yandex.cloud.access.ListAccessBindingsResponse
}
var file_yandex_cloud_logging_v1_sink_service_proto_depIdxs = []int32{
	13, // 0: yandex.cloud.logging.v1.ListSinksResponse.sinks:type_name -> yandex.cloud.logging.v1.Sink
	11, // 1: yandex.cloud.logging.v1.CreateSinkRequest.labels:type_name -> yandex.cloud.logging.v1.CreateSinkRequest.LabelsEntry
	14, // 2: yandex.cloud.logging.v1.CreateSinkRequest.yds:type_name -> yandex.cloud.logging.v1.Sink.Yds
	15, // 3: yandex.cloud.logging.v1.CreateSinkRequest.s3:type_name -> yandex.cloud.logging.v1.Sink.S3
	16, // 4: yandex.cloud.logging.v1.UpdateSinkRequest.update_mask:type_name -> google.protobuf.FieldMask
	12, // 5: yandex.cloud.logging.v1.UpdateSinkRequest.labels:type_name -> yandex.cloud.logging.v1.UpdateSinkRequest.LabelsEntry
	14, // 6: yandex.cloud.logging.v1.UpdateSinkRequest.yds:type_name -> yandex.cloud.logging.v1.Sink.Yds
	15, // 7: yandex.cloud.logging.v1.UpdateSinkRequest.s3:type_name -> yandex.cloud.logging.v1.Sink.S3
	17, // 8: yandex.cloud.logging.v1.ListSinkOperationsResponse.operations:type_name -> yandex.cloud.operation.Operation
	0,  // 9: yandex.cloud.logging.v1.SinkService.Get:input_type -> yandex.cloud.logging.v1.GetSinkRequest
	1,  // 10: yandex.cloud.logging.v1.SinkService.List:input_type -> yandex.cloud.logging.v1.ListSinksRequest
	3,  // 11: yandex.cloud.logging.v1.SinkService.Create:input_type -> yandex.cloud.logging.v1.CreateSinkRequest
	5,  // 12: yandex.cloud.logging.v1.SinkService.Update:input_type -> yandex.cloud.logging.v1.UpdateSinkRequest
	7,  // 13: yandex.cloud.logging.v1.SinkService.Delete:input_type -> yandex.cloud.logging.v1.DeleteSinkRequest
	9,  // 14: yandex.cloud.logging.v1.SinkService.ListOperations:input_type -> yandex.cloud.logging.v1.ListSinkOperationsRequest
	18, // 15: yandex.cloud.logging.v1.SinkService.ListAccessBindings:input_type -> yandex.cloud.access.ListAccessBindingsRequest
	19, // 16: yandex.cloud.logging.v1.SinkService.SetAccessBindings:input_type -> yandex.cloud.access.SetAccessBindingsRequest
	20, // 17: yandex.cloud.logging.v1.SinkService.UpdateAccessBindings:input_type -> yandex.cloud.access.UpdateAccessBindingsRequest
	13, // 18: yandex.cloud.logging.v1.SinkService.Get:output_type -> yandex.cloud.logging.v1.Sink
	2,  // 19: yandex.cloud.logging.v1.SinkService.List:output_type -> yandex.cloud.logging.v1.ListSinksResponse
	17, // 20: yandex.cloud.logging.v1.SinkService.Create:output_type -> yandex.cloud.operation.Operation
	17, // 21: yandex.cloud.logging.v1.SinkService.Update:output_type -> yandex.cloud.operation.Operation
	17, // 22: yandex.cloud.logging.v1.SinkService.Delete:output_type -> yandex.cloud.operation.Operation
	10, // 23: yandex.cloud.logging.v1.SinkService.ListOperations:output_type -> yandex.cloud.logging.v1.ListSinkOperationsResponse
	21, // 24: yandex.cloud.logging.v1.SinkService.ListAccessBindings:output_type -> yandex.cloud.access.ListAccessBindingsResponse
	17, // 25: yandex.cloud.logging.v1.SinkService.SetAccessBindings:output_type -> yandex.cloud.operation.Operation
	17, // 26: yandex.cloud.logging.v1.SinkService.UpdateAccessBindings:output_type -> yandex.cloud.operation.Operation
	18, // [18:27] is the sub-list for method output_type
	9,  // [9:18] is the sub-list for method input_type
	9,  // [9:9] is the sub-list for extension type_name
	9,  // [9:9] is the sub-list for extension extendee
	0,  // [0:9] is the sub-list for field type_name
}

func init() { file_yandex_cloud_logging_v1_sink_service_proto_init() }
func file_yandex_cloud_logging_v1_sink_service_proto_init() {
	if File_yandex_cloud_logging_v1_sink_service_proto != nil {
		return
	}
	file_yandex_cloud_logging_v1_sink_proto_init()
	file_yandex_cloud_logging_v1_sink_service_proto_msgTypes[3].OneofWrappers = []any{
		(*CreateSinkRequest_Yds)(nil),
		(*CreateSinkRequest_S3)(nil),
	}
	file_yandex_cloud_logging_v1_sink_service_proto_msgTypes[5].OneofWrappers = []any{
		(*UpdateSinkRequest_Yds)(nil),
		(*UpdateSinkRequest_S3)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_yandex_cloud_logging_v1_sink_service_proto_rawDesc), len(file_yandex_cloud_logging_v1_sink_service_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   13,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_yandex_cloud_logging_v1_sink_service_proto_goTypes,
		DependencyIndexes: file_yandex_cloud_logging_v1_sink_service_proto_depIdxs,
		MessageInfos:      file_yandex_cloud_logging_v1_sink_service_proto_msgTypes,
	}.Build()
	File_yandex_cloud_logging_v1_sink_service_proto = out.File
	file_yandex_cloud_logging_v1_sink_service_proto_goTypes = nil
	file_yandex_cloud_logging_v1_sink_service_proto_depIdxs = nil
}
