// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.11
// 	protoc        v3.21.12
// source: yandex/cloud/storage/v1/bucket.proto

package storage

import (
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type Versioning int32

const (
	// Versioning unspecified.
	Versioning_VERSIONING_UNSPECIFIED Versioning = 0
	// The bucket is unversioned, i.e. versioning has never been enabled for the bucket, including at its creation.
	// Objects that are stored in the bucket have a version ID of `null`.
	//
	// To enable versioning, change status to `VERSIONING_ENABLED` via a [BucketService.Update] request. Note that this
	// action is irreversible, and a bucket with versioning enabled can never return to `VERSIONING_DISABLED` state.
	Versioning_VERSIONING_DISABLED Versioning = 1
	// Bucket versioning is enabled, i.e. all new objects are versioned and given a unique version ID, and objects that
	// already existed at the time versioning was enabled will be versioned and given a unique version ID when modified
	// by future requests.
	//
	// To suspend versioning, change status to `VERSIONING_SUSPENDED` via a [BucketService.Update] request. You cannot
	// disable versioning altogether for a bucket that already had it enabled; objects that had version IDs will keep
	// them.
	Versioning_VERSIONING_ENABLED Versioning = 2
	// Bucket versioning is suspended, i.e. new objects are not versioned, but objects that already existed at the time
	// versioning was suspended are still versioned and keep their version IDs.
	//
	// To resume versioning, change status to `VERSIONING_ENABLED` via a [BucketService.Update] request.
	Versioning_VERSIONING_SUSPENDED Versioning = 3
)

// Enum value maps for Versioning.
var (
	Versioning_name = map[int32]string{
		0: "VERSIONING_UNSPECIFIED",
		1: "VERSIONING_DISABLED",
		2: "VERSIONING_ENABLED",
		3: "VERSIONING_SUSPENDED",
	}
	Versioning_value = map[string]int32{
		"VERSIONING_UNSPECIFIED": 0,
		"VERSIONING_DISABLED":    1,
		"VERSIONING_ENABLED":     2,
		"VERSIONING_SUSPENDED":   3,
	}
)

func (x Versioning) Enum() *Versioning {
	p := new(Versioning)
	*p = x
	return p
}

func (x Versioning) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Versioning) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_storage_v1_bucket_proto_enumTypes[0].Descriptor()
}

func (Versioning) Type() protoreflect.EnumType {
	return &file_yandex_cloud_storage_v1_bucket_proto_enumTypes[0]
}

func (x Versioning) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Versioning.Descriptor instead.
func (Versioning) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{0}
}

type ACL_Grant_Permission int32

const (
	// Permission unspecified.
	ACL_Grant_PERMISSION_UNSPECIFIED ACL_Grant_Permission = 0
	// Allows grantee the `PERMISSION_WRITE`, `PERMISSION_WRITE_ACP`, `PERMISSION_READ`, and `PERMISSION_READ_ACP`
	// on the bucket.
	//
	// Maps to `x-amz-grant-full-control` header for [bucketPutAcl](/docs/storage/s3/api-ref/acl/bucketput) method of
	// Amazon S3-compatible HTTP API.
	ACL_Grant_PERMISSION_FULL_CONTROL ACL_Grant_Permission = 1
	// Allows grantee to create new objects in the bucket. For the bucket and object owners of existing objects, also
	// allows deletions and overwrites of those objects.
	//
	// Maps to `x-amz-grant-write` header for [bucketPutAcl](/docs/storage/s3/api-ref/acl/bucketput) method of Amazon
	// S3-compatible HTTP API.
	ACL_Grant_PERMISSION_WRITE ACL_Grant_Permission = 2
	// Allows grantee to write the ACL for the bucket.
	//
	// Maps to `x-amz-grant-write-acp` header for [bucketPutAcl](/docs/storage/s3/api-ref/acl/bucketput) method of
	// Amazon S3-compatible HTTP API.
	ACL_Grant_PERMISSION_WRITE_ACP ACL_Grant_Permission = 3
	// Allows grantee to list the objects in the bucket.
	//
	// Maps to `x-amz-grant-read` header for [bucketPutAcl](/docs/storage/s3/api-ref/acl/bucketput) method of Amazon
	// S3-compatible HTTP API.
	ACL_Grant_PERMISSION_READ ACL_Grant_Permission = 4
	// Allows grantee to read the bucket ACL
	//
	// Maps to `x-amz-grant-read-acp` header for [bucketPutAcl](/docs/storage/s3/api-ref/acl/bucketput) method of
	// Amazon S3-compatible HTTP API.
	ACL_Grant_PERMISSION_READ_ACP ACL_Grant_Permission = 5
)

// Enum value maps for ACL_Grant_Permission.
var (
	ACL_Grant_Permission_name = map[int32]string{
		0: "PERMISSION_UNSPECIFIED",
		1: "PERMISSION_FULL_CONTROL",
		2: "PERMISSION_WRITE",
		3: "PERMISSION_WRITE_ACP",
		4: "PERMISSION_READ",
		5: "PERMISSION_READ_ACP",
	}
	ACL_Grant_Permission_value = map[string]int32{
		"PERMISSION_UNSPECIFIED":  0,
		"PERMISSION_FULL_CONTROL": 1,
		"PERMISSION_WRITE":        2,
		"PERMISSION_WRITE_ACP":    3,
		"PERMISSION_READ":         4,
		"PERMISSION_READ_ACP":     5,
	}
)

func (x ACL_Grant_Permission) Enum() *ACL_Grant_Permission {
	p := new(ACL_Grant_Permission)
	*p = x
	return p
}

func (x ACL_Grant_Permission) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ACL_Grant_Permission) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_storage_v1_bucket_proto_enumTypes[1].Descriptor()
}

func (ACL_Grant_Permission) Type() protoreflect.EnumType {
	return &file_yandex_cloud_storage_v1_bucket_proto_enumTypes[1]
}

func (x ACL_Grant_Permission) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ACL_Grant_Permission.Descriptor instead.
func (ACL_Grant_Permission) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{2, 0, 0}
}

type ACL_Grant_GrantType int32

const (
	// Grant type unspecified.
	ACL_Grant_GRANT_TYPE_UNSPECIFIED ACL_Grant_GrantType = 0
	// A grantee is an [account on the platform](/docs/iam/concepts/#accounts).
	//
	// For this grantee type, you need to specify the user ID in [Bucket.acl.grants.grantee_id] field. To get user ID, see
	// [instruction](/docs/iam/operations/users/get).
	//
	// Maps to using `id="*"` value for `x-amz-grant-*` header ([bucketPutAcl](/docs/storage/s3/api-ref/acl/bucketput)
	// method of Amazon S3-compatible HTTP API).
	ACL_Grant_GRANT_TYPE_ACCOUNT ACL_Grant_GrantType = 1
	// Grantees are all authenticated users, both from your clouds and other users' clouds. Access
	// permission to this group allows any account on the platform to access the resource via a signed (authenticated)
	// request.
	//
	// Maps to using `uri="http://acs.amazonaws.com/groups/global/AuthenticatedUsers"` value for `x-amz-grant-*`
	// header ([bucketPutAcl](/docs/storage/s3/api-ref/acl/bucketput) method of Amazon S3-compatible HTTP API).
	ACL_Grant_GRANT_TYPE_ALL_AUTHENTICATED_USERS ACL_Grant_GrantType = 2
	// Grantees are all internet users. Access permission to this group allows anyone in the world access to the
	// resource via signed (authenticated) or unsigned (anonymous) requests.
	//
	// Maps to using `uri="http://acs.amazonaws.com/groups/global/AllUsers"` value for `x-amz-grant-*` header
	// ([bucketPutAcl](/docs/storage/s3/api-ref/acl/bucketput) method of Amazon S3-compatible HTTP API).
	ACL_Grant_GRANT_TYPE_ALL_USERS ACL_Grant_GrantType = 3
)

// Enum value maps for ACL_Grant_GrantType.
var (
	ACL_Grant_GrantType_name = map[int32]string{
		0: "GRANT_TYPE_UNSPECIFIED",
		1: "GRANT_TYPE_ACCOUNT",
		2: "GRANT_TYPE_ALL_AUTHENTICATED_USERS",
		3: "GRANT_TYPE_ALL_USERS",
	}
	ACL_Grant_GrantType_value = map[string]int32{
		"GRANT_TYPE_UNSPECIFIED":             0,
		"GRANT_TYPE_ACCOUNT":                 1,
		"GRANT_TYPE_ALL_AUTHENTICATED_USERS": 2,
		"GRANT_TYPE_ALL_USERS":               3,
	}
)

func (x ACL_Grant_GrantType) Enum() *ACL_Grant_GrantType {
	p := new(ACL_Grant_GrantType)
	*p = x
	return p
}

func (x ACL_Grant_GrantType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ACL_Grant_GrantType) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_storage_v1_bucket_proto_enumTypes[2].Descriptor()
}

func (ACL_Grant_GrantType) Type() protoreflect.EnumType {
	return &file_yandex_cloud_storage_v1_bucket_proto_enumTypes[2]
}

func (x ACL_Grant_GrantType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ACL_Grant_GrantType.Descriptor instead.
func (ACL_Grant_GrantType) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{2, 0, 1}
}

// List of HTTP methods that are allowed by the CORS rule.
//
// When a client sends a CORS-preflight `options` request with the `Access-Control-Request-Method` header (see
// S3-compatible API reference](/docs/storage/s3/api-ref/object/options)), the specified method is checked against the
// list of the allowed methods. If there is a match, all the allowed methods are listed in the
// `Access-Control-Allow-Methods` header of the response.
type CorsRule_Method int32

const (
	// Method unspecified.
	CorsRule_METHOD_UNSPECIFIED CorsRule_Method = 0
	// HTTP `GET` method.
	CorsRule_METHOD_GET CorsRule_Method = 1
	// HTTP `HEAD` method.
	CorsRule_METHOD_HEAD CorsRule_Method = 2
	// HTTP `POST` method.
	CorsRule_METHOD_POST CorsRule_Method = 3
	// HTTP `PUT` method.
	CorsRule_METHOD_PUT CorsRule_Method = 4
	// HTTP `DELETE` method.
	CorsRule_METHOD_DELETE CorsRule_Method = 5
)

// Enum value maps for CorsRule_Method.
var (
	CorsRule_Method_name = map[int32]string{
		0: "METHOD_UNSPECIFIED",
		1: "METHOD_GET",
		2: "METHOD_HEAD",
		3: "METHOD_POST",
		4: "METHOD_PUT",
		5: "METHOD_DELETE",
	}
	CorsRule_Method_value = map[string]int32{
		"METHOD_UNSPECIFIED": 0,
		"METHOD_GET":         1,
		"METHOD_HEAD":        2,
		"METHOD_POST":        3,
		"METHOD_PUT":         4,
		"METHOD_DELETE":      5,
	}
)

func (x CorsRule_Method) Enum() *CorsRule_Method {
	p := new(CorsRule_Method)
	*p = x
	return p
}

func (x CorsRule_Method) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CorsRule_Method) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_storage_v1_bucket_proto_enumTypes[3].Descriptor()
}

func (CorsRule_Method) Type() protoreflect.EnumType {
	return &file_yandex_cloud_storage_v1_bucket_proto_enumTypes[3]
}

func (x CorsRule_Method) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CorsRule_Method.Descriptor instead.
func (CorsRule_Method) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{4, 0}
}

type WebsiteSettings_Protocol int32

const (
	// Protocol unspecified.
	WebsiteSettings_PROTOCOL_UNSPECIFIED WebsiteSettings_Protocol = 0
	// `http` scheme.
	WebsiteSettings_PROTOCOL_HTTP WebsiteSettings_Protocol = 1
	// `https` scheme.
	WebsiteSettings_PROTOCOL_HTTPS WebsiteSettings_Protocol = 2
)

// Enum value maps for WebsiteSettings_Protocol.
var (
	WebsiteSettings_Protocol_name = map[int32]string{
		0: "PROTOCOL_UNSPECIFIED",
		1: "PROTOCOL_HTTP",
		2: "PROTOCOL_HTTPS",
	}
	WebsiteSettings_Protocol_value = map[string]int32{
		"PROTOCOL_UNSPECIFIED": 0,
		"PROTOCOL_HTTP":        1,
		"PROTOCOL_HTTPS":       2,
	}
)

func (x WebsiteSettings_Protocol) Enum() *WebsiteSettings_Protocol {
	p := new(WebsiteSettings_Protocol)
	*p = x
	return p
}

func (x WebsiteSettings_Protocol) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (WebsiteSettings_Protocol) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_storage_v1_bucket_proto_enumTypes[4].Descriptor()
}

func (WebsiteSettings_Protocol) Type() protoreflect.EnumType {
	return &file_yandex_cloud_storage_v1_bucket_proto_enumTypes[4]
}

func (x WebsiteSettings_Protocol) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use WebsiteSettings_Protocol.Descriptor instead.
func (WebsiteSettings_Protocol) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{5, 0}
}

// A resource for type of TLS certificate source.
type HTTPSConfig_SourceType int32

const (
	// Source type unspecified.
	HTTPSConfig_SOURCE_TYPE_UNSPECIFIED HTTPSConfig_SourceType = 0
	// Your certificate, uploaded directly.
	HTTPSConfig_SOURCE_TYPE_SELF_MANAGED HTTPSConfig_SourceType = 1
	// Certificate managed by Certificate Manager.
	HTTPSConfig_SOURCE_TYPE_MANAGED_BY_CERTIFICATE_MANAGER HTTPSConfig_SourceType = 2
)

// Enum value maps for HTTPSConfig_SourceType.
var (
	HTTPSConfig_SourceType_name = map[int32]string{
		0: "SOURCE_TYPE_UNSPECIFIED",
		1: "SOURCE_TYPE_SELF_MANAGED",
		2: "SOURCE_TYPE_MANAGED_BY_CERTIFICATE_MANAGER",
	}
	HTTPSConfig_SourceType_value = map[string]int32{
		"SOURCE_TYPE_UNSPECIFIED":                    0,
		"SOURCE_TYPE_SELF_MANAGED":                   1,
		"SOURCE_TYPE_MANAGED_BY_CERTIFICATE_MANAGER": 2,
	}
)

func (x HTTPSConfig_SourceType) Enum() *HTTPSConfig_SourceType {
	p := new(HTTPSConfig_SourceType)
	*p = x
	return p
}

func (x HTTPSConfig_SourceType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HTTPSConfig_SourceType) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_storage_v1_bucket_proto_enumTypes[5].Descriptor()
}

func (HTTPSConfig_SourceType) Type() protoreflect.EnumType {
	return &file_yandex_cloud_storage_v1_bucket_proto_enumTypes[5]
}

func (x HTTPSConfig_SourceType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HTTPSConfig_SourceType.Descriptor instead.
func (HTTPSConfig_SourceType) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{12, 0}
}

// Activity status of the object lock settings on the bucket
type ObjectLock_ObjectLockStatus int32

const (
	// Object lock status unspecified.
	ObjectLock_OBJECT_LOCK_STATUS_UNSPECIFIED ObjectLock_ObjectLockStatus = 0
	// Object lock status disabled.
	ObjectLock_OBJECT_LOCK_STATUS_DISABLED ObjectLock_ObjectLockStatus = 1
	// Object lock status enabled.
	ObjectLock_OBJECT_LOCK_STATUS_ENABLED ObjectLock_ObjectLockStatus = 2
)

// Enum value maps for ObjectLock_ObjectLockStatus.
var (
	ObjectLock_ObjectLockStatus_name = map[int32]string{
		0: "OBJECT_LOCK_STATUS_UNSPECIFIED",
		1: "OBJECT_LOCK_STATUS_DISABLED",
		2: "OBJECT_LOCK_STATUS_ENABLED",
	}
	ObjectLock_ObjectLockStatus_value = map[string]int32{
		"OBJECT_LOCK_STATUS_UNSPECIFIED": 0,
		"OBJECT_LOCK_STATUS_DISABLED":    1,
		"OBJECT_LOCK_STATUS_ENABLED":     2,
	}
)

func (x ObjectLock_ObjectLockStatus) Enum() *ObjectLock_ObjectLockStatus {
	p := new(ObjectLock_ObjectLockStatus)
	*p = x
	return p
}

func (x ObjectLock_ObjectLockStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ObjectLock_ObjectLockStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_storage_v1_bucket_proto_enumTypes[6].Descriptor()
}

func (ObjectLock_ObjectLockStatus) Type() protoreflect.EnumType {
	return &file_yandex_cloud_storage_v1_bucket_proto_enumTypes[6]
}

func (x ObjectLock_ObjectLockStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ObjectLock_ObjectLockStatus.Descriptor instead.
func (ObjectLock_ObjectLockStatus) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{13, 0}
}

// Lock type
type ObjectLock_DefaultRetention_Mode int32

const (
	// Mode unspecified.
	ObjectLock_DefaultRetention_MODE_UNSPECIFIED ObjectLock_DefaultRetention_Mode = 0
	// Mode governance.
	ObjectLock_DefaultRetention_MODE_GOVERNANCE ObjectLock_DefaultRetention_Mode = 1
	// Mode compliance.
	ObjectLock_DefaultRetention_MODE_COMPLIANCE ObjectLock_DefaultRetention_Mode = 2
)

// Enum value maps for ObjectLock_DefaultRetention_Mode.
var (
	ObjectLock_DefaultRetention_Mode_name = map[int32]string{
		0: "MODE_UNSPECIFIED",
		1: "MODE_GOVERNANCE",
		2: "MODE_COMPLIANCE",
	}
	ObjectLock_DefaultRetention_Mode_value = map[string]int32{
		"MODE_UNSPECIFIED": 0,
		"MODE_GOVERNANCE":  1,
		"MODE_COMPLIANCE":  2,
	}
)

func (x ObjectLock_DefaultRetention_Mode) Enum() *ObjectLock_DefaultRetention_Mode {
	p := new(ObjectLock_DefaultRetention_Mode)
	*p = x
	return p
}

func (x ObjectLock_DefaultRetention_Mode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ObjectLock_DefaultRetention_Mode) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_storage_v1_bucket_proto_enumTypes[7].Descriptor()
}

func (ObjectLock_DefaultRetention_Mode) Type() protoreflect.EnumType {
	return &file_yandex_cloud_storage_v1_bucket_proto_enumTypes[7]
}

func (x ObjectLock_DefaultRetention_Mode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ObjectLock_DefaultRetention_Mode.Descriptor instead.
func (ObjectLock_DefaultRetention_Mode) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{13, 0, 0}
}

// Types of object versions to include in the inventory list.
type InventoryConfiguration_IncludedObjectVersions int32

const (
	// UNSPECIFIED
	InventoryConfiguration_INCLUDED_OBJECT_VERSIONS_UNSPECIFIED InventoryConfiguration_IncludedObjectVersions = 0
	// Include all versions.
	InventoryConfiguration_ALL InventoryConfiguration_IncludedObjectVersions = 1
	// Include only the current version.
	InventoryConfiguration_CURRENT InventoryConfiguration_IncludedObjectVersions = 2
)

// Enum value maps for InventoryConfiguration_IncludedObjectVersions.
var (
	InventoryConfiguration_IncludedObjectVersions_name = map[int32]string{
		0: "INCLUDED_OBJECT_VERSIONS_UNSPECIFIED",
		1: "ALL",
		2: "CURRENT",
	}
	InventoryConfiguration_IncludedObjectVersions_value = map[string]int32{
		"INCLUDED_OBJECT_VERSIONS_UNSPECIFIED": 0,
		"ALL":                                  1,
		"CURRENT":                              2,
	}
)

func (x InventoryConfiguration_IncludedObjectVersions) Enum() *InventoryConfiguration_IncludedObjectVersions {
	p := new(InventoryConfiguration_IncludedObjectVersions)
	*p = x
	return p
}

func (x InventoryConfiguration_IncludedObjectVersions) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InventoryConfiguration_IncludedObjectVersions) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_storage_v1_bucket_proto_enumTypes[8].Descriptor()
}

func (InventoryConfiguration_IncludedObjectVersions) Type() protoreflect.EnumType {
	return &file_yandex_cloud_storage_v1_bucket_proto_enumTypes[8]
}

func (x InventoryConfiguration_IncludedObjectVersions) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InventoryConfiguration_IncludedObjectVersions.Descriptor instead.
func (InventoryConfiguration_IncludedObjectVersions) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{16, 0}
}

// Type of optional field.
type InventoryConfiguration_OptionalField int32

const (
	// UNSPECIFIED
	InventoryConfiguration_OPTIONAL_FIELD_UNSPECIFIED InventoryConfiguration_OptionalField = 0
	// The object size in bytes.
	InventoryConfiguration_SIZE InventoryConfiguration_OptionalField = 1
	// The object creation date or the last modified date, whichever is the latest.
	InventoryConfiguration_LAST_MODIFIED_DATE InventoryConfiguration_OptionalField = 2
	// The storage class that's used for storing the object.
	InventoryConfiguration_STORAGE_CLASS InventoryConfiguration_OptionalField = 3
	// The entity tag (ETag) is a hash of the object.
	InventoryConfiguration_ETAG InventoryConfiguration_OptionalField = 4
	// Specifies that the object was uploaded as a multipart upload.
	InventoryConfiguration_IS_MULTIPART_UPLOADED InventoryConfiguration_OptionalField = 5
	// The server-side encryption type that's used to encrypt the object.
	InventoryConfiguration_ENCRYPTION_STATUS InventoryConfiguration_OptionalField = 6
	// The date until which the object is locked.
	InventoryConfiguration_OBJECT_LOCK_RETAIN_UNTIL_DATE InventoryConfiguration_OptionalField = 7
	// The level of protection applied to the object, either Governance or Compliance.
	InventoryConfiguration_OBJECT_LOCK_MODE InventoryConfiguration_OptionalField = 8
	// The legal hold status of the locked object.
	InventoryConfiguration_OBJECT_LOCK_LEGAL_HOLD_STATUS InventoryConfiguration_OptionalField = 9
	// Indicates the algorithm that is used to create the checksum for the object.
	InventoryConfiguration_CHECKSUM_ALGORITHM InventoryConfiguration_OptionalField = 10
	// An access control list (ACL) for each object.
	InventoryConfiguration_OBJECT_ACCESS_CONTROL_LIST InventoryConfiguration_OptionalField = 11
	// The owner of the object.
	InventoryConfiguration_OBJECT_OWNER InventoryConfiguration_OptionalField = 12
)

// Enum value maps for InventoryConfiguration_OptionalField.
var (
	InventoryConfiguration_OptionalField_name = map[int32]string{
		0:  "OPTIONAL_FIELD_UNSPECIFIED",
		1:  "SIZE",
		2:  "LAST_MODIFIED_DATE",
		3:  "STORAGE_CLASS",
		4:  "ETAG",
		5:  "IS_MULTIPART_UPLOADED",
		6:  "ENCRYPTION_STATUS",
		7:  "OBJECT_LOCK_RETAIN_UNTIL_DATE",
		8:  "OBJECT_LOCK_MODE",
		9:  "OBJECT_LOCK_LEGAL_HOLD_STATUS",
		10: "CHECKSUM_ALGORITHM",
		11: "OBJECT_ACCESS_CONTROL_LIST",
		12: "OBJECT_OWNER",
	}
	InventoryConfiguration_OptionalField_value = map[string]int32{
		"OPTIONAL_FIELD_UNSPECIFIED":    0,
		"SIZE":                          1,
		"LAST_MODIFIED_DATE":            2,
		"STORAGE_CLASS":                 3,
		"ETAG":                          4,
		"IS_MULTIPART_UPLOADED":         5,
		"ENCRYPTION_STATUS":             6,
		"OBJECT_LOCK_RETAIN_UNTIL_DATE": 7,
		"OBJECT_LOCK_MODE":              8,
		"OBJECT_LOCK_LEGAL_HOLD_STATUS": 9,
		"CHECKSUM_ALGORITHM":            10,
		"OBJECT_ACCESS_CONTROL_LIST":    11,
		"OBJECT_OWNER":                  12,
	}
)

func (x InventoryConfiguration_OptionalField) Enum() *InventoryConfiguration_OptionalField {
	p := new(InventoryConfiguration_OptionalField)
	*p = x
	return p
}

func (x InventoryConfiguration_OptionalField) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InventoryConfiguration_OptionalField) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_storage_v1_bucket_proto_enumTypes[9].Descriptor()
}

func (InventoryConfiguration_OptionalField) Type() protoreflect.EnumType {
	return &file_yandex_cloud_storage_v1_bucket_proto_enumTypes[9]
}

func (x InventoryConfiguration_OptionalField) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InventoryConfiguration_OptionalField.Descriptor instead.
func (InventoryConfiguration_OptionalField) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{16, 1}
}

// Output format.
type InventoryConfiguration_InventoryBucketDestination_Format int32

const (
	InventoryConfiguration_InventoryBucketDestination_FORMAT_UNSPECIFIED InventoryConfiguration_InventoryBucketDestination_Format = 0
	// CSV format.
	InventoryConfiguration_InventoryBucketDestination_CSV InventoryConfiguration_InventoryBucketDestination_Format = 1
)

// Enum value maps for InventoryConfiguration_InventoryBucketDestination_Format.
var (
	InventoryConfiguration_InventoryBucketDestination_Format_name = map[int32]string{
		0: "FORMAT_UNSPECIFIED",
		1: "CSV",
	}
	InventoryConfiguration_InventoryBucketDestination_Format_value = map[string]int32{
		"FORMAT_UNSPECIFIED": 0,
		"CSV":                1,
	}
)

func (x InventoryConfiguration_InventoryBucketDestination_Format) Enum() *InventoryConfiguration_InventoryBucketDestination_Format {
	p := new(InventoryConfiguration_InventoryBucketDestination_Format)
	*p = x
	return p
}

func (x InventoryConfiguration_InventoryBucketDestination_Format) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InventoryConfiguration_InventoryBucketDestination_Format) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_storage_v1_bucket_proto_enumTypes[10].Descriptor()
}

func (InventoryConfiguration_InventoryBucketDestination_Format) Type() protoreflect.EnumType {
	return &file_yandex_cloud_storage_v1_bucket_proto_enumTypes[10]
}

func (x InventoryConfiguration_InventoryBucketDestination_Format) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InventoryConfiguration_InventoryBucketDestination_Format.Descriptor instead.
func (InventoryConfiguration_InventoryBucketDestination_Format) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{16, 0, 0}
}

// Types of generation frequency
type InventoryConfiguration_InventorySchedule_Frequency int32

const (
	// UNSPECIFIED
	InventoryConfiguration_InventorySchedule_FREQUENCY_UNSPECIFIED InventoryConfiguration_InventorySchedule_Frequency = 0
	// Daily generation.
	InventoryConfiguration_InventorySchedule_DAILY InventoryConfiguration_InventorySchedule_Frequency = 1
	// Weekly generation.
	InventoryConfiguration_InventorySchedule_WEEKLY InventoryConfiguration_InventorySchedule_Frequency = 2
)

// Enum value maps for InventoryConfiguration_InventorySchedule_Frequency.
var (
	InventoryConfiguration_InventorySchedule_Frequency_name = map[int32]string{
		0: "FREQUENCY_UNSPECIFIED",
		1: "DAILY",
		2: "WEEKLY",
	}
	InventoryConfiguration_InventorySchedule_Frequency_value = map[string]int32{
		"FREQUENCY_UNSPECIFIED": 0,
		"DAILY":                 1,
		"WEEKLY":                2,
	}
)

func (x InventoryConfiguration_InventorySchedule_Frequency) Enum() *InventoryConfiguration_InventorySchedule_Frequency {
	p := new(InventoryConfiguration_InventorySchedule_Frequency)
	*p = x
	return p
}

func (x InventoryConfiguration_InventorySchedule_Frequency) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InventoryConfiguration_InventorySchedule_Frequency) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_storage_v1_bucket_proto_enumTypes[11].Descriptor()
}

func (InventoryConfiguration_InventorySchedule_Frequency) Type() protoreflect.EnumType {
	return &file_yandex_cloud_storage_v1_bucket_proto_enumTypes[11]
}

func (x InventoryConfiguration_InventorySchedule_Frequency) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InventoryConfiguration_InventorySchedule_Frequency.Descriptor instead.
func (InventoryConfiguration_InventorySchedule_Frequency) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{16, 2, 0}
}

// A bucket resource.
// For details about the concept, see [documentation](/docs/storage/concepts/bucket).
type Bucket struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the bucket. Always equal to [name], which has priority.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Name of the bucket.
	//
	// The name is unique within the platform. For naming limitations and rules, see
	// [documentation](/docs/storage/concepts/bucket#naming).
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// ID of the folder that the bucket belongs to.
	FolderId string `protobuf:"bytes,3,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// Flags for configuring public (anonymous) access to the bucket's content and settings.
	// For details, see [documentation](/docs/storage/concepts/bucket#bucket-access).
	AnonymousAccessFlags *AnonymousAccessFlags `protobuf:"bytes,4,opt,name=anonymous_access_flags,json=anonymousAccessFlags,proto3" json:"anonymous_access_flags,omitempty"`
	// Default storage class for objects in the bucket. Supported classes are standard storage (`STANDARD`), cold storage
	// (`COLD`, `STANDARD_IA`, `NEARLINE` all synonyms), and ice storage (`ICE` and `GLACIER` are synonyms).
	// For details, see [documentation](/docs/storage/concepts/storage-class).
	DefaultStorageClass string `protobuf:"bytes,5,opt,name=default_storage_class,json=defaultStorageClass,proto3" json:"default_storage_class,omitempty"`
	// Bucket versioning status.
	// For details, see [documentation](/docs/storage/concepts/versioning).
	Versioning Versioning `protobuf:"varint,6,opt,name=versioning,proto3,enum=yandex.cloud.storage.v1.Versioning" json:"versioning,omitempty"`
	// Maximum size of the bucket, in bytes.
	// For details, see [documentation](/docs/storage/operations/buckets/limit-max-volume).
	MaxSize int64 `protobuf:"varint,7,opt,name=max_size,json=maxSize,proto3" json:"max_size,omitempty"`
	// Bucket policies that set permissions for actions with the bucket, its objects, and groups of objects.
	// For details, see [documentation](/docs/storage/concepts/policy).
	Policy *structpb.Struct `protobuf:"bytes,8,opt,name=policy,proto3" json:"policy,omitempty"`
	// Access control list (ACL) of the bucket.
	// For details, see [documentation](/docs/storage/concepts/acl).
	Acl *ACL `protobuf:"bytes,9,opt,name=acl,proto3" json:"acl,omitempty"`
	// Creation timestamp.
	CreatedAt *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// List of rules for cross-domain requests to objects in the bucket (cross-origin resource sharing, CORS).
	// For details, see [documentation](/docs/storage/concepts/cors).
	Cors []*CorsRule `protobuf:"bytes,11,rep,name=cors,proto3" json:"cors,omitempty"`
	// Configuration for hosting a static website in the bucket.
	// For details, see [documentation](/docs/storage/concepts/hosting).
	WebsiteSettings *WebsiteSettings `protobuf:"bytes,12,opt,name=website_settings,json=websiteSettings,proto3" json:"website_settings,omitempty"`
	// List of object lifecycle rules for the bucket.
	// For details, see [documentation](/docs/storage/concepts/lifecycles).
	LifecycleRules []*LifecycleRule `protobuf:"bytes,13,rep,name=lifecycle_rules,json=lifecycleRules,proto3" json:"lifecycle_rules,omitempty"`
	// List of tags for the bucket.
	// For details, see [documentation](/docs/resource-manager/concepts/labels).
	Tags []*Tag `protobuf:"bytes,14,rep,name=tags,proto3" json:"tags,omitempty"`
	// Configuration for object lock on the bucket.
	// For details about the concept, see [documentation](/docs/storage/concepts/object-lock).
	ObjectLock *ObjectLock `protobuf:"bytes,15,opt,name=object_lock,json=objectLock,proto3" json:"object_lock,omitempty"`
	// Configuration for bucket's encryption
	// For details, see [documentation](/docs/storage/concepts/encryption)
	Encryption *Encryption `protobuf:"bytes,16,opt,name=encryption,proto3" json:"encryption,omitempty"`
	// Bucket allowed private endpoints.
	AllowedPrivateEndpoints *BucketAllowedPrivateEndpoints `protobuf:"bytes,17,opt,name=allowed_private_endpoints,json=allowedPrivateEndpoints,proto3" json:"allowed_private_endpoints,omitempty"`
	// ID of the Yandex.Cloud entity that owns the bucket.
	ResourceId string `protobuf:"bytes,18,opt,name=resource_id,json=resourceId,proto3" json:"resource_id,omitempty"`
	// An option to disable static key auth for a bucket.
	DisabledStatickeyAuth bool `protobuf:"varint,19,opt,name=disabled_statickey_auth,json=disabledStatickeyAuth,proto3" json:"disabled_statickey_auth,omitempty"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *Bucket) Reset() {
	*x = Bucket{}
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Bucket) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Bucket) ProtoMessage() {}

func (x *Bucket) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Bucket.ProtoReflect.Descriptor instead.
func (*Bucket) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{0}
}

func (x *Bucket) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Bucket) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Bucket) GetFolderId() string {
	if x != nil {
		return x.FolderId
	}
	return ""
}

func (x *Bucket) GetAnonymousAccessFlags() *AnonymousAccessFlags {
	if x != nil {
		return x.AnonymousAccessFlags
	}
	return nil
}

func (x *Bucket) GetDefaultStorageClass() string {
	if x != nil {
		return x.DefaultStorageClass
	}
	return ""
}

func (x *Bucket) GetVersioning() Versioning {
	if x != nil {
		return x.Versioning
	}
	return Versioning_VERSIONING_UNSPECIFIED
}

func (x *Bucket) GetMaxSize() int64 {
	if x != nil {
		return x.MaxSize
	}
	return 0
}

func (x *Bucket) GetPolicy() *structpb.Struct {
	if x != nil {
		return x.Policy
	}
	return nil
}

func (x *Bucket) GetAcl() *ACL {
	if x != nil {
		return x.Acl
	}
	return nil
}

func (x *Bucket) GetCreatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.CreatedAt
	}
	return nil
}

func (x *Bucket) GetCors() []*CorsRule {
	if x != nil {
		return x.Cors
	}
	return nil
}

func (x *Bucket) GetWebsiteSettings() *WebsiteSettings {
	if x != nil {
		return x.WebsiteSettings
	}
	return nil
}

func (x *Bucket) GetLifecycleRules() []*LifecycleRule {
	if x != nil {
		return x.LifecycleRules
	}
	return nil
}

func (x *Bucket) GetTags() []*Tag {
	if x != nil {
		return x.Tags
	}
	return nil
}

func (x *Bucket) GetObjectLock() *ObjectLock {
	if x != nil {
		return x.ObjectLock
	}
	return nil
}

func (x *Bucket) GetEncryption() *Encryption {
	if x != nil {
		return x.Encryption
	}
	return nil
}

func (x *Bucket) GetAllowedPrivateEndpoints() *BucketAllowedPrivateEndpoints {
	if x != nil {
		return x.AllowedPrivateEndpoints
	}
	return nil
}

func (x *Bucket) GetResourceId() string {
	if x != nil {
		return x.ResourceId
	}
	return ""
}

func (x *Bucket) GetDisabledStatickeyAuth() bool {
	if x != nil {
		return x.DisabledStatickeyAuth
	}
	return false
}

type Tag struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Key of the bucket tag.
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// Value of the bucket tag.
	Value         string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Tag) Reset() {
	*x = Tag{}
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Tag) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tag) ProtoMessage() {}

func (x *Tag) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tag.ProtoReflect.Descriptor instead.
func (*Tag) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{1}
}

func (x *Tag) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *Tag) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

type ACL struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// List of permissions granted and the grantees.
	Grants        []*ACL_Grant `protobuf:"bytes,1,rep,name=grants,proto3" json:"grants,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ACL) Reset() {
	*x = ACL{}
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ACL) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ACL) ProtoMessage() {}

func (x *ACL) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ACL.ProtoReflect.Descriptor instead.
func (*ACL) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{2}
}

func (x *ACL) GetGrants() []*ACL_Grant {
	if x != nil {
		return x.Grants
	}
	return nil
}

type AnonymousAccessFlags struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Specifies whether public (anonymous) access to read objects in the bucket is enabled.
	Read *wrapperspb.BoolValue `protobuf:"bytes,1,opt,name=read,proto3" json:"read,omitempty"`
	// Specifies whether public (anonymous) access to the list of objects in the bucket is enabled.
	List *wrapperspb.BoolValue `protobuf:"bytes,2,opt,name=list,proto3" json:"list,omitempty"`
	// Specifies whether public (anonymous) access to read [CORS](/docs/storage/concepts/cors),
	// [static website hosting](/docs/storage/concepts/hosting), and
	// [object lifecycles](/docs/storage/concepts/lifecycles) settings of the bucket is enabled.
	ConfigRead    *wrapperspb.BoolValue `protobuf:"bytes,3,opt,name=config_read,json=configRead,proto3" json:"config_read,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AnonymousAccessFlags) Reset() {
	*x = AnonymousAccessFlags{}
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AnonymousAccessFlags) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnonymousAccessFlags) ProtoMessage() {}

func (x *AnonymousAccessFlags) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnonymousAccessFlags.ProtoReflect.Descriptor instead.
func (*AnonymousAccessFlags) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{3}
}

func (x *AnonymousAccessFlags) GetRead() *wrapperspb.BoolValue {
	if x != nil {
		return x.Read
	}
	return nil
}

func (x *AnonymousAccessFlags) GetList() *wrapperspb.BoolValue {
	if x != nil {
		return x.List
	}
	return nil
}

func (x *AnonymousAccessFlags) GetConfigRead() *wrapperspb.BoolValue {
	if x != nil {
		return x.ConfigRead
	}
	return nil
}

// A CORS rule resource.
// For details about the concept, see [documentation](/docs/storage/concepts/cors).
type CorsRule struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the CORS rule.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// List of HTTP methods allowed by the CORS rule.
	//
	// When a client sends a CORS-preflight `options` request with the `Access-Control-Request-Method` header (see
	// [S3-compatible API reference](/docs/storage/s3/api-ref/object/options)), the specified method is checked against
	// the list of the allowed methods. If there is a match, all the allowed methods are listed in the
	// `Access-Control-Allow-Methods` header of the response.
	AllowedMethods []CorsRule_Method `protobuf:"varint,2,rep,packed,name=allowed_methods,json=allowedMethods,proto3,enum=yandex.cloud.storage.v1.CorsRule_Method" json:"allowed_methods,omitempty"`
	// List of HTTP headers allowed by the CORS rule.
	//
	// When a client sends a CORS-preflight `options` request with the `Access-Control-Request-Headers` header (see
	// [S3-compatible API reference](/docs/storage/s3/api-ref/object/options)), the specified headers are checked against
	// the list of the allowed headers. If there is a match, the specified headers that are allowed are listed in the
	// `Access-Control-Allow-Headers` header of the response.
	//
	// Each string in the list can contain at most one `*` wildcard character that matches 0 or more characters.
	// For example, `x-amz-*` value will allow all Amazon S3-compatible headers.
	AllowedHeaders []string `protobuf:"bytes,3,rep,name=allowed_headers,json=allowedHeaders,proto3" json:"allowed_headers,omitempty"`
	// List of request origins allowed by the CORS rule.
	//
	// Each string in the list can contain at most one `*` wildcard character that matches 0 or more characters.
	// For example, `http://*.example.com` value will allow requests originating from all subdomains of `example.com`.
	AllowedOrigins []string `protobuf:"bytes,4,rep,name=allowed_origins,json=allowedOrigins,proto3" json:"allowed_origins,omitempty"`
	// List of headers contained in responses to CORS requests that can be accessed by applications.
	ExposeHeaders []string `protobuf:"bytes,5,rep,name=expose_headers,json=exposeHeaders,proto3" json:"expose_headers,omitempty"`
	// Time in seconds that a client can cache the response to a CORS-preflight request as identified by the
	// object requested, the HTTP method, and the origin.
	MaxAgeSeconds *wrapperspb.Int64Value `protobuf:"bytes,6,opt,name=max_age_seconds,json=maxAgeSeconds,proto3" json:"max_age_seconds,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CorsRule) Reset() {
	*x = CorsRule{}
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CorsRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CorsRule) ProtoMessage() {}

func (x *CorsRule) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CorsRule.ProtoReflect.Descriptor instead.
func (*CorsRule) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{4}
}

func (x *CorsRule) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *CorsRule) GetAllowedMethods() []CorsRule_Method {
	if x != nil {
		return x.AllowedMethods
	}
	return nil
}

func (x *CorsRule) GetAllowedHeaders() []string {
	if x != nil {
		return x.AllowedHeaders
	}
	return nil
}

func (x *CorsRule) GetAllowedOrigins() []string {
	if x != nil {
		return x.AllowedOrigins
	}
	return nil
}

func (x *CorsRule) GetExposeHeaders() []string {
	if x != nil {
		return x.ExposeHeaders
	}
	return nil
}

func (x *CorsRule) GetMaxAgeSeconds() *wrapperspb.Int64Value {
	if x != nil {
		return x.MaxAgeSeconds
	}
	return nil
}

type WebsiteSettings struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Key of the index page object that is returned when a response is made to the root of the website.
	//
	// Either [index] or [redirect_all_requests] must be specified in order for the bucket to host a static website.
	//
	// If specified, the index page object must be located in the root of the bucket.
	Index string `protobuf:"bytes,1,opt,name=index,proto3" json:"index,omitempty"`
	// Key of the error page object that is returned when an error occurs.
	Error string `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	// Configuration for redirecting all requests sent to the website.
	//
	// Either [redirect_all_requests] or [index] must be specified in order for the bucket to host a static website.
	// If [redirect_all_requests] is specified, it must be the only field in [Bucket.website_settings].
	RedirectAllRequests *WebsiteSettings_Scheme `protobuf:"bytes,3,opt,name=redirect_all_requests,json=redirectAllRequests,proto3" json:"redirect_all_requests,omitempty"`
	// List of redirect rules.
	RoutingRules  []*WebsiteSettings_RoutingRule `protobuf:"bytes,4,rep,name=routing_rules,json=routingRules,proto3" json:"routing_rules,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *WebsiteSettings) Reset() {
	*x = WebsiteSettings{}
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WebsiteSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WebsiteSettings) ProtoMessage() {}

func (x *WebsiteSettings) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WebsiteSettings.ProtoReflect.Descriptor instead.
func (*WebsiteSettings) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{5}
}

func (x *WebsiteSettings) GetIndex() string {
	if x != nil {
		return x.Index
	}
	return ""
}

func (x *WebsiteSettings) GetError() string {
	if x != nil {
		return x.Error
	}
	return ""
}

func (x *WebsiteSettings) GetRedirectAllRequests() *WebsiteSettings_Scheme {
	if x != nil {
		return x.RedirectAllRequests
	}
	return nil
}

func (x *WebsiteSettings) GetRoutingRules() []*WebsiteSettings_RoutingRule {
	if x != nil {
		return x.RoutingRules
	}
	return nil
}

// An object lifecycle rule resource for the bucket.
// For details about the concept, see [documentation](/docs/storage/concepts/lifecycles).
type LifecycleRule struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the rule. Provided by the client or generated at creation time.
	Id *wrapperspb.StringValue `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Indicates whether the rule is in effect.
	Enabled bool `protobuf:"varint,2,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Filter that identifies the objects to which the rule applies.
	//
	// If not specified, the rule applies to all objects in the bucket.
	Filter *LifecycleRule_RuleFilter `protobuf:"bytes,3,opt,name=filter,proto3" json:"filter,omitempty"`
	// Expiration rule.
	//
	// The expiration of an object is described as follows.
	//
	// For the unversioned bucket ([Bucket.versioning] is `VERSIONING_DISABLED`), the object is deleted and cannot be
	// recovered.
	//
	// For the bucket with versioning enabled ([Bucket.versioning] is `VERSIONING_ENABLED`), the current version of the
	// object (if it exists and is not a delete marker) is retained as a non-current version, and a delete marker becomes
	// the current version of the object.
	//
	// For the bucket with versioning suspended ([Bucket.versioning] is `VERSIONING_SUSPENDED`), the current version of
	// the object is retained as a non-current version if it is not a delete marker, or is removed otherwise, and a
	// delete marker becomes the current version of the object.
	Expiration *LifecycleRule_Expiration `protobuf:"bytes,4,opt,name=expiration,proto3" json:"expiration,omitempty"`
	// List of transition rules.
	//
	// The transition of an object is described as follows.
	//
	// For the unversioned bucket ([Bucket.versioning] is `VERSIONING_DISABLED`), the object is transitioned to the
	// specified storage class.
	//
	// For the bucket with versioning enabled ([Bucket.versioning] is `VERSIONING_ENABLED`) or suspended
	// (`VERSIONING_SUSPENDED`), the current version of the object is transitioned to the specified storage class.
	Transitions []*LifecycleRule_Transition `protobuf:"bytes,5,rep,name=transitions,proto3" json:"transitions,omitempty"`
	// Configuration for aborting incomplete [multipart uploads](/docs/storage/concepts/multipart).
	AbortIncompleteMultipartUpload *LifecycleRule_AfterDays `protobuf:"bytes,6,opt,name=abort_incomplete_multipart_upload,json=abortIncompleteMultipartUpload,proto3" json:"abort_incomplete_multipart_upload,omitempty"`
	// Expiration rule for non-current versions of objects in a bucket with versioning enabled ([Bucket.versioning] is
	// `VERSIONING_ENABLED`) or suspended (`VERSIONING_SUSPENDED`).
	//
	// At expiration, the non-current version of the object is deleted and cannot be recovered.
	NoncurrentExpiration *LifecycleRule_NoncurrentExpiration `protobuf:"bytes,7,opt,name=noncurrent_expiration,json=noncurrentExpiration,proto3" json:"noncurrent_expiration,omitempty"`
	// List of transition rules for non-current versions of objects in a bucket with versioning enabled
	// ([Bucket.versioning] is `VERSIONING_ENABLED`) or suspended (`VERSIONING_SUSPENDED`).
	//
	// At transition, the non-current version of the object is transitioned to the specified storage class.
	NoncurrentTransitions []*LifecycleRule_NoncurrentTransition `protobuf:"bytes,8,rep,name=noncurrent_transitions,json=noncurrentTransitions,proto3" json:"noncurrent_transitions,omitempty"`
	// Expiration rule for non-current delete markers of an objects in a bucket with versioning
	// enabled ([Bucket.versioning] is `VERSIONING_ENABLED`) or suspended (`VERSIONING_SUSPENDED`).
	// Works in the same way as noncurrent_expiration rule, but only for delete markers.
	//
	// At expiration, the non-current delete marker of the object is deleted and cannot be recovered.
	NoncurrentDeleteMarkers *LifecycleRule_NoncurrentDeleteMarkers `protobuf:"bytes,9,opt,name=noncurrent_delete_markers,json=noncurrentDeleteMarkers,proto3" json:"noncurrent_delete_markers,omitempty"`
	unknownFields           protoimpl.UnknownFields
	sizeCache               protoimpl.SizeCache
}

func (x *LifecycleRule) Reset() {
	*x = LifecycleRule{}
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LifecycleRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LifecycleRule) ProtoMessage() {}

func (x *LifecycleRule) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LifecycleRule.ProtoReflect.Descriptor instead.
func (*LifecycleRule) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{6}
}

func (x *LifecycleRule) GetId() *wrapperspb.StringValue {
	if x != nil {
		return x.Id
	}
	return nil
}

func (x *LifecycleRule) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *LifecycleRule) GetFilter() *LifecycleRule_RuleFilter {
	if x != nil {
		return x.Filter
	}
	return nil
}

func (x *LifecycleRule) GetExpiration() *LifecycleRule_Expiration {
	if x != nil {
		return x.Expiration
	}
	return nil
}

func (x *LifecycleRule) GetTransitions() []*LifecycleRule_Transition {
	if x != nil {
		return x.Transitions
	}
	return nil
}

func (x *LifecycleRule) GetAbortIncompleteMultipartUpload() *LifecycleRule_AfterDays {
	if x != nil {
		return x.AbortIncompleteMultipartUpload
	}
	return nil
}

func (x *LifecycleRule) GetNoncurrentExpiration() *LifecycleRule_NoncurrentExpiration {
	if x != nil {
		return x.NoncurrentExpiration
	}
	return nil
}

func (x *LifecycleRule) GetNoncurrentTransitions() []*LifecycleRule_NoncurrentTransition {
	if x != nil {
		return x.NoncurrentTransitions
	}
	return nil
}

func (x *LifecycleRule) GetNoncurrentDeleteMarkers() *LifecycleRule_NoncurrentDeleteMarkers {
	if x != nil {
		return x.NoncurrentDeleteMarkers
	}
	return nil
}

type Counters struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Total size of objects uploaded in single operation, in bytes.
	SimpleObjectSize int64 `protobuf:"varint,1,opt,name=simple_object_size,json=simpleObjectSize,proto3" json:"simple_object_size,omitempty"`
	// Number of objects uploaded in single operation.
	SimpleObjectCount int64 `protobuf:"varint,2,opt,name=simple_object_count,json=simpleObjectCount,proto3" json:"simple_object_count,omitempty"`
	// Total size of uploaded parts in incomplete multipart uploads, in bytes.
	ObjectsPartsSize int64 `protobuf:"varint,3,opt,name=objects_parts_size,json=objectsPartsSize,proto3" json:"objects_parts_size,omitempty"`
	// Number of uploaded parts in incomplete multipart uploads.
	ObjectsPartsCount int64 `protobuf:"varint,4,opt,name=objects_parts_count,json=objectsPartsCount,proto3" json:"objects_parts_count,omitempty"`
	// Total size of objects uploaded in multiple parts, in bytes.
	MultipartObjectsSize int64 `protobuf:"varint,5,opt,name=multipart_objects_size,json=multipartObjectsSize,proto3" json:"multipart_objects_size,omitempty"`
	// Number of objects uploaded in multiple parts.
	MultipartObjectsCount int64 `protobuf:"varint,6,opt,name=multipart_objects_count,json=multipartObjectsCount,proto3" json:"multipart_objects_count,omitempty"`
	// Number of incomplete multipart uploads.
	ActiveMultipartCount int64 `protobuf:"varint,7,opt,name=active_multipart_count,json=activeMultipartCount,proto3" json:"active_multipart_count,omitempty"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *Counters) Reset() {
	*x = Counters{}
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Counters) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Counters) ProtoMessage() {}

func (x *Counters) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Counters.ProtoReflect.Descriptor instead.
func (*Counters) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{7}
}

func (x *Counters) GetSimpleObjectSize() int64 {
	if x != nil {
		return x.SimpleObjectSize
	}
	return 0
}

func (x *Counters) GetSimpleObjectCount() int64 {
	if x != nil {
		return x.SimpleObjectCount
	}
	return 0
}

func (x *Counters) GetObjectsPartsSize() int64 {
	if x != nil {
		return x.ObjectsPartsSize
	}
	return 0
}

func (x *Counters) GetObjectsPartsCount() int64 {
	if x != nil {
		return x.ObjectsPartsCount
	}
	return 0
}

func (x *Counters) GetMultipartObjectsSize() int64 {
	if x != nil {
		return x.MultipartObjectsSize
	}
	return 0
}

func (x *Counters) GetMultipartObjectsCount() int64 {
	if x != nil {
		return x.MultipartObjectsCount
	}
	return 0
}

func (x *Counters) GetActiveMultipartCount() int64 {
	if x != nil {
		return x.ActiveMultipartCount
	}
	return 0
}

// A resource for size of available space in a bucket for a storage class.
type OptionalSizeByClass struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Storage class. Supported classes are standard storage (`STANDARD`), cold storage (`COLD`, `STANDARD_IA`, `NEARLINE`
	// all synonyms), and ice storage (`ICE` and `GLACIER` are synonyms).
	// For details, see [documentation](/docs/storage/concepts/storage-class).
	StorageClass string `protobuf:"bytes,1,opt,name=storage_class,json=storageClass,proto3" json:"storage_class,omitempty"`
	// Size of available space in the bucket for the storage class.
	ClassSize     *wrapperspb.Int64Value `protobuf:"bytes,2,opt,name=class_size,json=classSize,proto3" json:"class_size,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OptionalSizeByClass) Reset() {
	*x = OptionalSizeByClass{}
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OptionalSizeByClass) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OptionalSizeByClass) ProtoMessage() {}

func (x *OptionalSizeByClass) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OptionalSizeByClass.ProtoReflect.Descriptor instead.
func (*OptionalSizeByClass) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{8}
}

func (x *OptionalSizeByClass) GetStorageClass() string {
	if x != nil {
		return x.StorageClass
	}
	return ""
}

func (x *OptionalSizeByClass) GetClassSize() *wrapperspb.Int64Value {
	if x != nil {
		return x.ClassSize
	}
	return nil
}

// A resource for size of used space in a bucket for a storage class.
type SizeByClass struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Storage class. Supported classes are standard storage (`STANDARD`), cold storage (`COLD`, `STANDARD_IA`, `NEARLINE`
	// all synonyms), and ice storage (`ICE` and `GLACIER` are synonyms).
	// For details, see [documentation](/docs/storage/concepts/storage-class).
	StorageClass string `protobuf:"bytes,1,opt,name=storage_class,json=storageClass,proto3" json:"storage_class,omitempty"`
	// Size of used space in the bucket for the storage class.
	ClassSize     int64 `protobuf:"varint,2,opt,name=class_size,json=classSize,proto3" json:"class_size,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SizeByClass) Reset() {
	*x = SizeByClass{}
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SizeByClass) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SizeByClass) ProtoMessage() {}

func (x *SizeByClass) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SizeByClass.ProtoReflect.Descriptor instead.
func (*SizeByClass) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{9}
}

func (x *SizeByClass) GetStorageClass() string {
	if x != nil {
		return x.StorageClass
	}
	return ""
}

func (x *SizeByClass) GetClassSize() int64 {
	if x != nil {
		return x.ClassSize
	}
	return 0
}

// A resource for object-related statistics for a storage class by type of upload (simple vs. multipart).
type CountersByClass struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Storage class. Supported classes are standard storage (`STANDARD`), cold storage (`COLD`, `STANDARD_IA`, `NEARLINE`
	// all synonyms), and ice storage (`ice` and `GLACIER` are synonyms).
	// For details, see [documentation](/docs/storage/concepts/storage-class).
	StorageClass string `protobuf:"bytes,1,opt,name=storage_class,json=storageClass,proto3" json:"storage_class,omitempty"`
	// Object-related statistics for the storage class by type of upload.
	Counters      *Counters `protobuf:"bytes,2,opt,name=counters,proto3" json:"counters,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CountersByClass) Reset() {
	*x = CountersByClass{}
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CountersByClass) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CountersByClass) ProtoMessage() {}

func (x *CountersByClass) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CountersByClass.ProtoReflect.Descriptor instead.
func (*CountersByClass) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{10}
}

func (x *CountersByClass) GetStorageClass() string {
	if x != nil {
		return x.StorageClass
	}
	return ""
}

func (x *CountersByClass) GetCounters() *Counters {
	if x != nil {
		return x.Counters
	}
	return nil
}

// A bucket statistics resource.
type BucketStats struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Name of the bucket.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Maximum size of the bucket, in bytes.
	MaxSize *wrapperspb.Int64Value `protobuf:"bytes,2,opt,name=max_size,json=maxSize,proto3" json:"max_size,omitempty"`
	// Size of used space in the bucket, in bytes.
	UsedSize int64 `protobuf:"varint,3,opt,name=used_size,json=usedSize,proto3" json:"used_size,omitempty"`
	// Size of available space in the bucket by storage class, in bytes.
	StorageClassMaxSizes []*OptionalSizeByClass `protobuf:"bytes,4,rep,name=storage_class_max_sizes,json=storageClassMaxSizes,proto3" json:"storage_class_max_sizes,omitempty"`
	// Size of used space in the bucket by storage class, in bytes.
	StorageClassUsedSizes []*SizeByClass `protobuf:"bytes,5,rep,name=storage_class_used_sizes,json=storageClassUsedSizes,proto3" json:"storage_class_used_sizes,omitempty"`
	// Object-related statistics by storage class and type of upload (simple vs. multipart), in bytes.
	StorageClassCounters []*CountersByClass `protobuf:"bytes,6,rep,name=storage_class_counters,json=storageClassCounters,proto3" json:"storage_class_counters,omitempty"`
	// Default storage class for objects in the bucket. Supported classes are standard storage (`STANDARD`), cold storage
	// (`COLD`, `STANDARD_IA`, `NEARLINE` all synonyms), and ice storage (`ICE` and `GLACIER` are synonyms).
	// For details, see [documentation](/docs/storage/concepts/storage-class).
	DefaultStorageClass *wrapperspb.StringValue `protobuf:"bytes,7,opt,name=default_storage_class,json=defaultStorageClass,proto3" json:"default_storage_class,omitempty"`
	// Flags for configuring public (anonymous) access to the bucket's content and settings.
	// For details, see [documentation](/docs/storage/concepts/bucket#bucket-access).
	AnonymousAccessFlags *AnonymousAccessFlags `protobuf:"bytes,8,opt,name=anonymous_access_flags,json=anonymousAccessFlags,proto3" json:"anonymous_access_flags,omitempty"`
	// Bucket creation timestamp.
	CreatedAt *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Bucket latest update timestamp.
	UpdatedAt     *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=updated_at,json=updatedAt,proto3" json:"updated_at,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *BucketStats) Reset() {
	*x = BucketStats{}
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BucketStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BucketStats) ProtoMessage() {}

func (x *BucketStats) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BucketStats.ProtoReflect.Descriptor instead.
func (*BucketStats) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{11}
}

func (x *BucketStats) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *BucketStats) GetMaxSize() *wrapperspb.Int64Value {
	if x != nil {
		return x.MaxSize
	}
	return nil
}

func (x *BucketStats) GetUsedSize() int64 {
	if x != nil {
		return x.UsedSize
	}
	return 0
}

func (x *BucketStats) GetStorageClassMaxSizes() []*OptionalSizeByClass {
	if x != nil {
		return x.StorageClassMaxSizes
	}
	return nil
}

func (x *BucketStats) GetStorageClassUsedSizes() []*SizeByClass {
	if x != nil {
		return x.StorageClassUsedSizes
	}
	return nil
}

func (x *BucketStats) GetStorageClassCounters() []*CountersByClass {
	if x != nil {
		return x.StorageClassCounters
	}
	return nil
}

func (x *BucketStats) GetDefaultStorageClass() *wrapperspb.StringValue {
	if x != nil {
		return x.DefaultStorageClass
	}
	return nil
}

func (x *BucketStats) GetAnonymousAccessFlags() *AnonymousAccessFlags {
	if x != nil {
		return x.AnonymousAccessFlags
	}
	return nil
}

func (x *BucketStats) GetCreatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.CreatedAt
	}
	return nil
}

func (x *BucketStats) GetUpdatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdatedAt
	}
	return nil
}

// A resource for HTTPS configuration of a bucket.
type HTTPSConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Name of the bucket.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Type of TLS certificate source.
	SourceType HTTPSConfig_SourceType `protobuf:"varint,2,opt,name=source_type,json=sourceType,proto3,enum=yandex.cloud.storage.v1.HTTPSConfig_SourceType" json:"source_type,omitempty"`
	// Issuer of the TLS certificate.
	Issuer *wrapperspb.StringValue `protobuf:"bytes,3,opt,name=issuer,proto3" json:"issuer,omitempty"`
	// Subject of the TLS certificate.
	Subject *wrapperspb.StringValue `protobuf:"bytes,4,opt,name=subject,proto3" json:"subject,omitempty"`
	// List of DNS names of the TLS certificate (Subject Alternative Name field).
	DnsNames []string `protobuf:"bytes,5,rep,name=dns_names,json=dnsNames,proto3" json:"dns_names,omitempty"`
	// Start of the TLS certificate validity period (Not Before field).
	NotBefore *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=not_before,json=notBefore,proto3" json:"not_before,omitempty"`
	// End of the TLS certificate validity period (Not After field)
	NotAfter *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=not_after,json=notAfter,proto3" json:"not_after,omitempty"`
	// ID of the TLS certificate in Certificate Manager.
	//
	// To get information about the certificate from Certificate Manager, make a
	// [yandex.cloud.certificatemanager.v1.CertificateService.Get] request.
	CertificateId string `protobuf:"bytes,8,opt,name=certificate_id,json=certificateId,proto3" json:"certificate_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *HTTPSConfig) Reset() {
	*x = HTTPSConfig{}
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HTTPSConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HTTPSConfig) ProtoMessage() {}

func (x *HTTPSConfig) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HTTPSConfig.ProtoReflect.Descriptor instead.
func (*HTTPSConfig) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{12}
}

func (x *HTTPSConfig) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *HTTPSConfig) GetSourceType() HTTPSConfig_SourceType {
	if x != nil {
		return x.SourceType
	}
	return HTTPSConfig_SOURCE_TYPE_UNSPECIFIED
}

func (x *HTTPSConfig) GetIssuer() *wrapperspb.StringValue {
	if x != nil {
		return x.Issuer
	}
	return nil
}

func (x *HTTPSConfig) GetSubject() *wrapperspb.StringValue {
	if x != nil {
		return x.Subject
	}
	return nil
}

func (x *HTTPSConfig) GetDnsNames() []string {
	if x != nil {
		return x.DnsNames
	}
	return nil
}

func (x *HTTPSConfig) GetNotBefore() *timestamppb.Timestamp {
	if x != nil {
		return x.NotBefore
	}
	return nil
}

func (x *HTTPSConfig) GetNotAfter() *timestamppb.Timestamp {
	if x != nil {
		return x.NotAfter
	}
	return nil
}

func (x *HTTPSConfig) GetCertificateId() string {
	if x != nil {
		return x.CertificateId
	}
	return ""
}

// A resource for Object Lock configuration of a bucket.
// For details about the concept, see [documentation](/docs/storage/concepts/object-lock).
type ObjectLock struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Status
	Status ObjectLock_ObjectLockStatus `protobuf:"varint,2,opt,name=status,proto3,enum=yandex.cloud.storage.v1.ObjectLock_ObjectLockStatus" json:"status,omitempty"`
	// Default retention
	DefaultRetention *ObjectLock_DefaultRetention `protobuf:"bytes,3,opt,name=default_retention,json=defaultRetention,proto3" json:"default_retention,omitempty"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *ObjectLock) Reset() {
	*x = ObjectLock{}
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ObjectLock) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ObjectLock) ProtoMessage() {}

func (x *ObjectLock) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ObjectLock.ProtoReflect.Descriptor instead.
func (*ObjectLock) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{13}
}

func (x *ObjectLock) GetStatus() ObjectLock_ObjectLockStatus {
	if x != nil {
		return x.Status
	}
	return ObjectLock_OBJECT_LOCK_STATUS_UNSPECIFIED
}

func (x *ObjectLock) GetDefaultRetention() *ObjectLock_DefaultRetention {
	if x != nil {
		return x.DefaultRetention
	}
	return nil
}

type Encryption struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Rules
	Rules         []*Encryption_EncryptionRule `protobuf:"bytes,1,rep,name=rules,proto3" json:"rules,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Encryption) Reset() {
	*x = Encryption{}
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Encryption) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Encryption) ProtoMessage() {}

func (x *Encryption) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Encryption.ProtoReflect.Descriptor instead.
func (*Encryption) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{14}
}

func (x *Encryption) GetRules() []*Encryption_EncryptionRule {
	if x != nil {
		return x.Rules
	}
	return nil
}

type BucketAllowedPrivateEndpoints struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// if true, private endpoints white list check is enabled
	// even if private_endpoints list is empty
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// white list of private endpoints bucket accessible from
	PrivateEndpoints []string `protobuf:"bytes,2,rep,name=private_endpoints,json=privateEndpoints,proto3" json:"private_endpoints,omitempty"`
	// if true, cloud console will be able to access a bucket
	// regardless of private_endpoints list
	ForceCloudConsoleAccess bool `protobuf:"varint,3,opt,name=force_cloud_console_access,json=forceCloudConsoleAccess,proto3" json:"force_cloud_console_access,omitempty"`
	unknownFields           protoimpl.UnknownFields
	sizeCache               protoimpl.SizeCache
}

func (x *BucketAllowedPrivateEndpoints) Reset() {
	*x = BucketAllowedPrivateEndpoints{}
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BucketAllowedPrivateEndpoints) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BucketAllowedPrivateEndpoints) ProtoMessage() {}

func (x *BucketAllowedPrivateEndpoints) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BucketAllowedPrivateEndpoints.ProtoReflect.Descriptor instead.
func (*BucketAllowedPrivateEndpoints) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{15}
}

func (x *BucketAllowedPrivateEndpoints) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *BucketAllowedPrivateEndpoints) GetPrivateEndpoints() []string {
	if x != nil {
		return x.PrivateEndpoints
	}
	return nil
}

func (x *BucketAllowedPrivateEndpoints) GetForceCloudConsoleAccess() bool {
	if x != nil {
		return x.ForceCloudConsoleAccess
	}
	return false
}

type InventoryConfiguration struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The ID used to identify the inventory configuration.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Contains information about where to publish the inventory results.
	Destination *InventoryConfiguration_InventoryDestination `protobuf:"bytes,2,opt,name=destination,proto3" json:"destination,omitempty"`
	// Object versions to include in the inventory list.
	IncludedObjectVersions InventoryConfiguration_IncludedObjectVersions `protobuf:"varint,3,opt,name=included_object_versions,json=includedObjectVersions,proto3,enum=yandex.cloud.storage.v1.InventoryConfiguration_IncludedObjectVersions" json:"included_object_versions,omitempty"`
	// Specifies whether the inventory is enabled.
	IsEnabled bool `protobuf:"varint,4,opt,name=is_enabled,json=isEnabled,proto3" json:"is_enabled,omitempty"`
	// Specifies the schedule for generating inventory results.
	Schedule *InventoryConfiguration_InventorySchedule `protobuf:"bytes,5,opt,name=schedule,proto3" json:"schedule,omitempty"`
	// Specifies the filter for objects to include in the inventory.
	Filter *InventoryConfiguration_InventoryFilter `protobuf:"bytes,6,opt,name=filter,proto3" json:"filter,omitempty"`
	// Contains the optional fields that are included in the inventory results.
	OptionalFields []InventoryConfiguration_OptionalField `protobuf:"varint,7,rep,packed,name=optional_fields,json=optionalFields,proto3,enum=yandex.cloud.storage.v1.InventoryConfiguration_OptionalField" json:"optional_fields,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *InventoryConfiguration) Reset() {
	*x = InventoryConfiguration{}
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InventoryConfiguration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InventoryConfiguration) ProtoMessage() {}

func (x *InventoryConfiguration) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InventoryConfiguration.ProtoReflect.Descriptor instead.
func (*InventoryConfiguration) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{16}
}

func (x *InventoryConfiguration) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *InventoryConfiguration) GetDestination() *InventoryConfiguration_InventoryDestination {
	if x != nil {
		return x.Destination
	}
	return nil
}

func (x *InventoryConfiguration) GetIncludedObjectVersions() InventoryConfiguration_IncludedObjectVersions {
	if x != nil {
		return x.IncludedObjectVersions
	}
	return InventoryConfiguration_INCLUDED_OBJECT_VERSIONS_UNSPECIFIED
}

func (x *InventoryConfiguration) GetIsEnabled() bool {
	if x != nil {
		return x.IsEnabled
	}
	return false
}

func (x *InventoryConfiguration) GetSchedule() *InventoryConfiguration_InventorySchedule {
	if x != nil {
		return x.Schedule
	}
	return nil
}

func (x *InventoryConfiguration) GetFilter() *InventoryConfiguration_InventoryFilter {
	if x != nil {
		return x.Filter
	}
	return nil
}

func (x *InventoryConfiguration) GetOptionalFields() []InventoryConfiguration_OptionalField {
	if x != nil {
		return x.OptionalFields
	}
	return nil
}

// A grant resource, used to specify the permission granted and the grantee.
type ACL_Grant struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Permission granted by the grant.
	Permission ACL_Grant_Permission `protobuf:"varint,1,opt,name=permission,proto3,enum=yandex.cloud.storage.v1.ACL_Grant_Permission" json:"permission,omitempty"`
	// The grantee type for the grant.
	GrantType ACL_Grant_GrantType `protobuf:"varint,2,opt,name=grant_type,json=grantType,proto3,enum=yandex.cloud.storage.v1.ACL_Grant_GrantType" json:"grant_type,omitempty"`
	// ID of the account who is a grantee. Required when the [grant_type] is `GRANT_TYPE_ACCOUNT`.
	GranteeId     string `protobuf:"bytes,3,opt,name=grantee_id,json=granteeId,proto3" json:"grantee_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ACL_Grant) Reset() {
	*x = ACL_Grant{}
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ACL_Grant) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ACL_Grant) ProtoMessage() {}

func (x *ACL_Grant) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ACL_Grant.ProtoReflect.Descriptor instead.
func (*ACL_Grant) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{2, 0}
}

func (x *ACL_Grant) GetPermission() ACL_Grant_Permission {
	if x != nil {
		return x.Permission
	}
	return ACL_Grant_PERMISSION_UNSPECIFIED
}

func (x *ACL_Grant) GetGrantType() ACL_Grant_GrantType {
	if x != nil {
		return x.GrantType
	}
	return ACL_Grant_GRANT_TYPE_UNSPECIFIED
}

func (x *ACL_Grant) GetGranteeId() string {
	if x != nil {
		return x.GranteeId
	}
	return ""
}

// A configuration resource for redirecting all requests sent to the website.
type WebsiteSettings_Scheme struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Scheme of the redirect URI.
	Protocol WebsiteSettings_Protocol `protobuf:"varint,1,opt,name=protocol,proto3,enum=yandex.cloud.storage.v1.WebsiteSettings_Protocol" json:"protocol,omitempty"`
	// Hostname of the redirect URI.
	Hostname      string `protobuf:"bytes,2,opt,name=hostname,proto3" json:"hostname,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *WebsiteSettings_Scheme) Reset() {
	*x = WebsiteSettings_Scheme{}
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WebsiteSettings_Scheme) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WebsiteSettings_Scheme) ProtoMessage() {}

func (x *WebsiteSettings_Scheme) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WebsiteSettings_Scheme.ProtoReflect.Descriptor instead.
func (*WebsiteSettings_Scheme) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{5, 0}
}

func (x *WebsiteSettings_Scheme) GetProtocol() WebsiteSettings_Protocol {
	if x != nil {
		return x.Protocol
	}
	return WebsiteSettings_PROTOCOL_UNSPECIFIED
}

func (x *WebsiteSettings_Scheme) GetHostname() string {
	if x != nil {
		return x.Hostname
	}
	return ""
}

type WebsiteSettings_Condition struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// HTTP status code (number only) that must match for the redirect to apply.
	HttpErrorCodeReturnedEquals string `protobuf:"bytes,1,opt,name=http_error_code_returned_equals,json=httpErrorCodeReturnedEquals,proto3" json:"http_error_code_returned_equals,omitempty"`
	// Prefix of the object key from which requests are redirected.
	KeyPrefixEquals string `protobuf:"bytes,2,opt,name=key_prefix_equals,json=keyPrefixEquals,proto3" json:"key_prefix_equals,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *WebsiteSettings_Condition) Reset() {
	*x = WebsiteSettings_Condition{}
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WebsiteSettings_Condition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WebsiteSettings_Condition) ProtoMessage() {}

func (x *WebsiteSettings_Condition) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WebsiteSettings_Condition.ProtoReflect.Descriptor instead.
func (*WebsiteSettings_Condition) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{5, 1}
}

func (x *WebsiteSettings_Condition) GetHttpErrorCodeReturnedEquals() string {
	if x != nil {
		return x.HttpErrorCodeReturnedEquals
	}
	return ""
}

func (x *WebsiteSettings_Condition) GetKeyPrefixEquals() string {
	if x != nil {
		return x.KeyPrefixEquals
	}
	return ""
}

type WebsiteSettings_Redirect struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Hostname of the redirect URI.
	Hostname string `protobuf:"bytes,1,opt,name=hostname,proto3" json:"hostname,omitempty"`
	// HTTP status code of the redirect response.
	//
	// Default value: `"301"`.
	HttpRedirectCode string `protobuf:"bytes,2,opt,name=http_redirect_code,json=httpRedirectCode,proto3" json:"http_redirect_code,omitempty"`
	// Scheme of the redirect URI.
	Protocol WebsiteSettings_Protocol `protobuf:"varint,3,opt,name=protocol,proto3,enum=yandex.cloud.storage.v1.WebsiteSettings_Protocol" json:"protocol,omitempty"`
	// Substitution for the prefix of the object key specified in [Condition.key_prefix_equals].
	//
	// At most one of [replace_key_prefix_with] and [replace_key_with] can be specified.
	ReplaceKeyPrefixWith string `protobuf:"bytes,4,opt,name=replace_key_prefix_with,json=replaceKeyPrefixWith,proto3" json:"replace_key_prefix_with,omitempty"`
	// New object key.
	//
	// At most one of [replace_key_with] and [replace_key_prefix_with] can be specified.
	ReplaceKeyWith string `protobuf:"bytes,5,opt,name=replace_key_with,json=replaceKeyWith,proto3" json:"replace_key_with,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *WebsiteSettings_Redirect) Reset() {
	*x = WebsiteSettings_Redirect{}
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WebsiteSettings_Redirect) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WebsiteSettings_Redirect) ProtoMessage() {}

func (x *WebsiteSettings_Redirect) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WebsiteSettings_Redirect.ProtoReflect.Descriptor instead.
func (*WebsiteSettings_Redirect) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{5, 2}
}

func (x *WebsiteSettings_Redirect) GetHostname() string {
	if x != nil {
		return x.Hostname
	}
	return ""
}

func (x *WebsiteSettings_Redirect) GetHttpRedirectCode() string {
	if x != nil {
		return x.HttpRedirectCode
	}
	return ""
}

func (x *WebsiteSettings_Redirect) GetProtocol() WebsiteSettings_Protocol {
	if x != nil {
		return x.Protocol
	}
	return WebsiteSettings_PROTOCOL_UNSPECIFIED
}

func (x *WebsiteSettings_Redirect) GetReplaceKeyPrefixWith() string {
	if x != nil {
		return x.ReplaceKeyPrefixWith
	}
	return ""
}

func (x *WebsiteSettings_Redirect) GetReplaceKeyWith() string {
	if x != nil {
		return x.ReplaceKeyWith
	}
	return ""
}

// List of redirect rules.
type WebsiteSettings_RoutingRule struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Redirect condition.
	Condition *WebsiteSettings_Condition `protobuf:"bytes,1,opt,name=condition,proto3" json:"condition,omitempty"`
	// Redirect instructions.
	Redirect      *WebsiteSettings_Redirect `protobuf:"bytes,2,opt,name=redirect,proto3" json:"redirect,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *WebsiteSettings_RoutingRule) Reset() {
	*x = WebsiteSettings_RoutingRule{}
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WebsiteSettings_RoutingRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WebsiteSettings_RoutingRule) ProtoMessage() {}

func (x *WebsiteSettings_RoutingRule) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WebsiteSettings_RoutingRule.ProtoReflect.Descriptor instead.
func (*WebsiteSettings_RoutingRule) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{5, 3}
}

func (x *WebsiteSettings_RoutingRule) GetCondition() *WebsiteSettings_Condition {
	if x != nil {
		return x.Condition
	}
	return nil
}

func (x *WebsiteSettings_RoutingRule) GetRedirect() *WebsiteSettings_Redirect {
	if x != nil {
		return x.Redirect
	}
	return nil
}

type LifecycleRule_AfterDays struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Time period, in number of days from the start of the multipart upload, after which the incomplete upload is
	// aborted.
	DaysAfterExpiration *wrapperspb.Int64Value `protobuf:"bytes,1,opt,name=days_after_expiration,json=daysAfterExpiration,proto3" json:"days_after_expiration,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *LifecycleRule_AfterDays) Reset() {
	*x = LifecycleRule_AfterDays{}
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LifecycleRule_AfterDays) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LifecycleRule_AfterDays) ProtoMessage() {}

func (x *LifecycleRule_AfterDays) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LifecycleRule_AfterDays.ProtoReflect.Descriptor instead.
func (*LifecycleRule_AfterDays) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{6, 0}
}

func (x *LifecycleRule_AfterDays) GetDaysAfterExpiration() *wrapperspb.Int64Value {
	if x != nil {
		return x.DaysAfterExpiration
	}
	return nil
}

type LifecycleRule_NoncurrentDeleteMarkers struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Time period, in number of days since the version of a delete marker was classified as non-current, after which
	// the delete marker expires.
	NoncurrentDays *wrapperspb.Int64Value `protobuf:"bytes,1,opt,name=noncurrent_days,json=noncurrentDays,proto3" json:"noncurrent_days,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *LifecycleRule_NoncurrentDeleteMarkers) Reset() {
	*x = LifecycleRule_NoncurrentDeleteMarkers{}
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LifecycleRule_NoncurrentDeleteMarkers) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LifecycleRule_NoncurrentDeleteMarkers) ProtoMessage() {}

func (x *LifecycleRule_NoncurrentDeleteMarkers) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LifecycleRule_NoncurrentDeleteMarkers.ProtoReflect.Descriptor instead.
func (*LifecycleRule_NoncurrentDeleteMarkers) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{6, 1}
}

func (x *LifecycleRule_NoncurrentDeleteMarkers) GetNoncurrentDays() *wrapperspb.Int64Value {
	if x != nil {
		return x.NoncurrentDays
	}
	return nil
}

type LifecycleRule_NoncurrentExpiration struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Time period, in number of days since the version of an object was classified as non-current, after which the
	// version expires.
	NoncurrentDays *wrapperspb.Int64Value `protobuf:"bytes,1,opt,name=noncurrent_days,json=noncurrentDays,proto3" json:"noncurrent_days,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *LifecycleRule_NoncurrentExpiration) Reset() {
	*x = LifecycleRule_NoncurrentExpiration{}
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LifecycleRule_NoncurrentExpiration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LifecycleRule_NoncurrentExpiration) ProtoMessage() {}

func (x *LifecycleRule_NoncurrentExpiration) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LifecycleRule_NoncurrentExpiration.ProtoReflect.Descriptor instead.
func (*LifecycleRule_NoncurrentExpiration) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{6, 2}
}

func (x *LifecycleRule_NoncurrentExpiration) GetNoncurrentDays() *wrapperspb.Int64Value {
	if x != nil {
		return x.NoncurrentDays
	}
	return nil
}

// List of transition rules for non-current versions of objects in a bucket with versioning enabled
// ([Bucket.versioning] is `VERSIONING_ENABLED`) or suspended (`VERSIONING_SUSPENDED`).
//
// At transition, the non-current version of the object is transitioned to the specified storage class.
type LifecycleRule_NoncurrentTransition struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Time period, in number of days since the version of an object was classified as non-current, after which the
	// version is transitioned.
	NoncurrentDays *wrapperspb.Int64Value `protobuf:"bytes,1,opt,name=noncurrent_days,json=noncurrentDays,proto3" json:"noncurrent_days,omitempty"`
	// Storage class to which a non-current version of an object is transitioned from standard storage.
	//
	// The only supported class is cold storage (`COLD`, `STANDARD_IA`, `NEARLINE` all synonyms). Transitions from cold
	// to standard storage and transitions to or from ice storage are not allowed.
	StorageClass  string `protobuf:"bytes,2,opt,name=storage_class,json=storageClass,proto3" json:"storage_class,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LifecycleRule_NoncurrentTransition) Reset() {
	*x = LifecycleRule_NoncurrentTransition{}
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LifecycleRule_NoncurrentTransition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LifecycleRule_NoncurrentTransition) ProtoMessage() {}

func (x *LifecycleRule_NoncurrentTransition) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LifecycleRule_NoncurrentTransition.ProtoReflect.Descriptor instead.
func (*LifecycleRule_NoncurrentTransition) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{6, 3}
}

func (x *LifecycleRule_NoncurrentTransition) GetNoncurrentDays() *wrapperspb.Int64Value {
	if x != nil {
		return x.NoncurrentDays
	}
	return nil
}

func (x *LifecycleRule_NoncurrentTransition) GetStorageClass() string {
	if x != nil {
		return x.StorageClass
	}
	return ""
}

// List of transition rules.
//
// The transition of an object is described as follows.
//
// For the unversioned bucket ([Bucket.versioning] is `VERSIONING_DISABLED`), the object is transitioned to the
// specified storage class.
//
// For the bucket with versioning enabled ([Bucket.versioning] is `VERSIONING_ENABLED`) or suspended
// (`VERSIONING_SUSPENDED`), the current version of the object is transitioned to the specified storage class.
type LifecycleRule_Transition struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Specific date of object transition.
	//
	// The rule continues to apply even after the date has passed, i.e. any new objects created in the bucket are
	// transitioned immediately.
	//
	// At most one of [date] and [days] fields can be specified.
	Date *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=date,proto3" json:"date,omitempty"`
	// Time period, in number of days from the creation or modification of the object, after which an object is
	// transitioned.
	//
	// At most one of [days] and [date] fields can be specified.
	Days *wrapperspb.Int64Value `protobuf:"bytes,2,opt,name=days,proto3" json:"days,omitempty"`
	// Storage class to which an object is transitioned from standard storage.
	//
	// The only supported class is cold storage (`COLD`, `STANDARD_IA`, `NEARLINE` all synonyms). Transitions from cold
	// to standard storage and transitions to or from ice storage are not allowed.
	StorageClass  string `protobuf:"bytes,4,opt,name=storage_class,json=storageClass,proto3" json:"storage_class,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LifecycleRule_Transition) Reset() {
	*x = LifecycleRule_Transition{}
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LifecycleRule_Transition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LifecycleRule_Transition) ProtoMessage() {}

func (x *LifecycleRule_Transition) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LifecycleRule_Transition.ProtoReflect.Descriptor instead.
func (*LifecycleRule_Transition) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{6, 4}
}

func (x *LifecycleRule_Transition) GetDate() *timestamppb.Timestamp {
	if x != nil {
		return x.Date
	}
	return nil
}

func (x *LifecycleRule_Transition) GetDays() *wrapperspb.Int64Value {
	if x != nil {
		return x.Days
	}
	return nil
}

func (x *LifecycleRule_Transition) GetStorageClass() string {
	if x != nil {
		return x.StorageClass
	}
	return ""
}

type LifecycleRule_Expiration struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Specific date of object expiration.
	//
	// The rule continues to apply even after the date has passed, i.e. any new objects created in the bucket expire
	// immediately.
	//
	// Exactly one of [date], [days], and [expired_object_delete_marker] fields can be specified.
	Date *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=date,proto3" json:"date,omitempty"`
	// Time period, in number of days from the creation or modification of the object, after which an object expires.
	//
	// Exactly one of [days], [date], and [expired_object_delete_marker] fields can be specified.
	Days *wrapperspb.Int64Value `protobuf:"bytes,2,opt,name=days,proto3" json:"days,omitempty"`
	// Indicates whether a delete marker of an object with no non-current versions (referred to as an expired object
	// delete marker) is removed at the object's expiration.
	//
	// Exactly one of [expired_object_delete_marker], [date], and [days] fields can be specified.
	ExpiredObjectDeleteMarker *wrapperspb.BoolValue `protobuf:"bytes,3,opt,name=expired_object_delete_marker,json=expiredObjectDeleteMarker,proto3" json:"expired_object_delete_marker,omitempty"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *LifecycleRule_Expiration) Reset() {
	*x = LifecycleRule_Expiration{}
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LifecycleRule_Expiration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LifecycleRule_Expiration) ProtoMessage() {}

func (x *LifecycleRule_Expiration) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LifecycleRule_Expiration.ProtoReflect.Descriptor instead.
func (*LifecycleRule_Expiration) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{6, 5}
}

func (x *LifecycleRule_Expiration) GetDate() *timestamppb.Timestamp {
	if x != nil {
		return x.Date
	}
	return nil
}

func (x *LifecycleRule_Expiration) GetDays() *wrapperspb.Int64Value {
	if x != nil {
		return x.Days
	}
	return nil
}

func (x *LifecycleRule_Expiration) GetExpiredObjectDeleteMarker() *wrapperspb.BoolValue {
	if x != nil {
		return x.ExpiredObjectDeleteMarker
	}
	return nil
}

type LifecycleRule_RuleFilter struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Key prefix that the object must have in order for the rule to apply.
	Prefix string `protobuf:"bytes,1,opt,name=prefix,proto3" json:"prefix,omitempty"`
	// Size that the object must be greater.
	ObjectSizeGreaterThan *wrapperspb.Int64Value `protobuf:"bytes,2,opt,name=object_size_greater_than,json=objectSizeGreaterThan,proto3" json:"object_size_greater_than,omitempty"`
	// Size that the object must be less t.
	ObjectSizeLessThan *wrapperspb.Int64Value `protobuf:"bytes,3,opt,name=object_size_less_than,json=objectSizeLessThan,proto3" json:"object_size_less_than,omitempty"`
	// Tags that the object's tag set must have for the rule to apply.
	Tag *Tag `protobuf:"bytes,4,opt,name=tag,proto3" json:"tag,omitempty"`
	// Apply a logical AND to all of the predicates configured inside the And operator.
	AndOperator   *LifecycleRule_RuleFilter_And `protobuf:"bytes,5,opt,name=and_operator,json=andOperator,proto3" json:"and_operator,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LifecycleRule_RuleFilter) Reset() {
	*x = LifecycleRule_RuleFilter{}
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LifecycleRule_RuleFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LifecycleRule_RuleFilter) ProtoMessage() {}

func (x *LifecycleRule_RuleFilter) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LifecycleRule_RuleFilter.ProtoReflect.Descriptor instead.
func (*LifecycleRule_RuleFilter) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{6, 6}
}

func (x *LifecycleRule_RuleFilter) GetPrefix() string {
	if x != nil {
		return x.Prefix
	}
	return ""
}

func (x *LifecycleRule_RuleFilter) GetObjectSizeGreaterThan() *wrapperspb.Int64Value {
	if x != nil {
		return x.ObjectSizeGreaterThan
	}
	return nil
}

func (x *LifecycleRule_RuleFilter) GetObjectSizeLessThan() *wrapperspb.Int64Value {
	if x != nil {
		return x.ObjectSizeLessThan
	}
	return nil
}

func (x *LifecycleRule_RuleFilter) GetTag() *Tag {
	if x != nil {
		return x.Tag
	}
	return nil
}

func (x *LifecycleRule_RuleFilter) GetAndOperator() *LifecycleRule_RuleFilter_And {
	if x != nil {
		return x.AndOperator
	}
	return nil
}

type LifecycleRule_RuleFilter_And struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Key prefix that the object must have in order for the rule to apply.
	Prefix string `protobuf:"bytes,1,opt,name=prefix,proto3" json:"prefix,omitempty"`
	// Size that the object must be greater.
	ObjectSizeGreaterThan *wrapperspb.Int64Value `protobuf:"bytes,2,opt,name=object_size_greater_than,json=objectSizeGreaterThan,proto3" json:"object_size_greater_than,omitempty"`
	// Size that the object must be less than.
	ObjectSizeLessThan *wrapperspb.Int64Value `protobuf:"bytes,3,opt,name=object_size_less_than,json=objectSizeLessThan,proto3" json:"object_size_less_than,omitempty"`
	// Tags that the object's tag set must have for the rule to apply.
	Tag           []*Tag `protobuf:"bytes,4,rep,name=tag,proto3" json:"tag,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LifecycleRule_RuleFilter_And) Reset() {
	*x = LifecycleRule_RuleFilter_And{}
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LifecycleRule_RuleFilter_And) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LifecycleRule_RuleFilter_And) ProtoMessage() {}

func (x *LifecycleRule_RuleFilter_And) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LifecycleRule_RuleFilter_And.ProtoReflect.Descriptor instead.
func (*LifecycleRule_RuleFilter_And) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{6, 6, 0}
}

func (x *LifecycleRule_RuleFilter_And) GetPrefix() string {
	if x != nil {
		return x.Prefix
	}
	return ""
}

func (x *LifecycleRule_RuleFilter_And) GetObjectSizeGreaterThan() *wrapperspb.Int64Value {
	if x != nil {
		return x.ObjectSizeGreaterThan
	}
	return nil
}

func (x *LifecycleRule_RuleFilter_And) GetObjectSizeLessThan() *wrapperspb.Int64Value {
	if x != nil {
		return x.ObjectSizeLessThan
	}
	return nil
}

func (x *LifecycleRule_RuleFilter_And) GetTag() []*Tag {
	if x != nil {
		return x.Tag
	}
	return nil
}

// Default lock configuration for added objects
type ObjectLock_DefaultRetention struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Mode
	Mode ObjectLock_DefaultRetention_Mode `protobuf:"varint,1,opt,name=mode,proto3,enum=yandex.cloud.storage.v1.ObjectLock_DefaultRetention_Mode" json:"mode,omitempty"`
	// Types that are valid to be assigned to Period:
	//
	//	*ObjectLock_DefaultRetention_Days
	//	*ObjectLock_DefaultRetention_Years
	Period        isObjectLock_DefaultRetention_Period `protobuf_oneof:"period"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ObjectLock_DefaultRetention) Reset() {
	*x = ObjectLock_DefaultRetention{}
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ObjectLock_DefaultRetention) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ObjectLock_DefaultRetention) ProtoMessage() {}

func (x *ObjectLock_DefaultRetention) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ObjectLock_DefaultRetention.ProtoReflect.Descriptor instead.
func (*ObjectLock_DefaultRetention) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{13, 0}
}

func (x *ObjectLock_DefaultRetention) GetMode() ObjectLock_DefaultRetention_Mode {
	if x != nil {
		return x.Mode
	}
	return ObjectLock_DefaultRetention_MODE_UNSPECIFIED
}

func (x *ObjectLock_DefaultRetention) GetPeriod() isObjectLock_DefaultRetention_Period {
	if x != nil {
		return x.Period
	}
	return nil
}

func (x *ObjectLock_DefaultRetention) GetDays() int64 {
	if x != nil {
		if x, ok := x.Period.(*ObjectLock_DefaultRetention_Days); ok {
			return x.Days
		}
	}
	return 0
}

func (x *ObjectLock_DefaultRetention) GetYears() int64 {
	if x != nil {
		if x, ok := x.Period.(*ObjectLock_DefaultRetention_Years); ok {
			return x.Years
		}
	}
	return 0
}

type isObjectLock_DefaultRetention_Period interface {
	isObjectLock_DefaultRetention_Period()
}

type ObjectLock_DefaultRetention_Days struct {
	// Number of days for locking
	Days int64 `protobuf:"varint,2,opt,name=days,proto3,oneof"`
}

type ObjectLock_DefaultRetention_Years struct {
	// Number of years for locking
	Years int64 `protobuf:"varint,3,opt,name=years,proto3,oneof"`
}

func (*ObjectLock_DefaultRetention_Days) isObjectLock_DefaultRetention_Period() {}

func (*ObjectLock_DefaultRetention_Years) isObjectLock_DefaultRetention_Period() {}

type Encryption_EncryptionRule struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// KMS master key ID
	KmsMasterKeyId string `protobuf:"bytes,1,opt,name=kms_master_key_id,json=kmsMasterKeyId,proto3" json:"kms_master_key_id,omitempty"`
	// SSE algorithm
	SseAlgorithm  string `protobuf:"bytes,2,opt,name=sse_algorithm,json=sseAlgorithm,proto3" json:"sse_algorithm,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Encryption_EncryptionRule) Reset() {
	*x = Encryption_EncryptionRule{}
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Encryption_EncryptionRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Encryption_EncryptionRule) ProtoMessage() {}

func (x *Encryption_EncryptionRule) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Encryption_EncryptionRule.ProtoReflect.Descriptor instead.
func (*Encryption_EncryptionRule) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{14, 0}
}

func (x *Encryption_EncryptionRule) GetKmsMasterKeyId() string {
	if x != nil {
		return x.KmsMasterKeyId
	}
	return ""
}

func (x *Encryption_EncryptionRule) GetSseAlgorithm() string {
	if x != nil {
		return x.SseAlgorithm
	}
	return ""
}

type InventoryConfiguration_InventoryBucketDestination struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Bucket where inventory results will be published.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Specifies the output format of the inventory results.
	Format InventoryConfiguration_InventoryBucketDestination_Format `protobuf:"varint,2,opt,name=format,proto3,enum=yandex.cloud.storage.v1.InventoryConfiguration_InventoryBucketDestination_Format" json:"format,omitempty"`
	// The prefix that is prepended to all inventory results.
	Prefix        *wrapperspb.StringValue `protobuf:"bytes,3,opt,name=prefix,proto3" json:"prefix,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *InventoryConfiguration_InventoryBucketDestination) Reset() {
	*x = InventoryConfiguration_InventoryBucketDestination{}
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InventoryConfiguration_InventoryBucketDestination) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InventoryConfiguration_InventoryBucketDestination) ProtoMessage() {}

func (x *InventoryConfiguration_InventoryBucketDestination) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InventoryConfiguration_InventoryBucketDestination.ProtoReflect.Descriptor instead.
func (*InventoryConfiguration_InventoryBucketDestination) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{16, 0}
}

func (x *InventoryConfiguration_InventoryBucketDestination) GetBucket() string {
	if x != nil {
		return x.Bucket
	}
	return ""
}

func (x *InventoryConfiguration_InventoryBucketDestination) GetFormat() InventoryConfiguration_InventoryBucketDestination_Format {
	if x != nil {
		return x.Format
	}
	return InventoryConfiguration_InventoryBucketDestination_FORMAT_UNSPECIFIED
}

func (x *InventoryConfiguration_InventoryBucketDestination) GetPrefix() *wrapperspb.StringValue {
	if x != nil {
		return x.Prefix
	}
	return nil
}

type InventoryConfiguration_InventoryDestination struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Destination bucket settings
	BucketDestination *InventoryConfiguration_InventoryBucketDestination `protobuf:"bytes,1,opt,name=bucket_destination,json=bucketDestination,proto3" json:"bucket_destination,omitempty"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *InventoryConfiguration_InventoryDestination) Reset() {
	*x = InventoryConfiguration_InventoryDestination{}
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[33]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InventoryConfiguration_InventoryDestination) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InventoryConfiguration_InventoryDestination) ProtoMessage() {}

func (x *InventoryConfiguration_InventoryDestination) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[33]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InventoryConfiguration_InventoryDestination.ProtoReflect.Descriptor instead.
func (*InventoryConfiguration_InventoryDestination) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{16, 1}
}

func (x *InventoryConfiguration_InventoryDestination) GetBucketDestination() *InventoryConfiguration_InventoryBucketDestination {
	if x != nil {
		return x.BucketDestination
	}
	return nil
}

type InventoryConfiguration_InventorySchedule struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Specifies how frequently inventory results are produced.
	Frequency     InventoryConfiguration_InventorySchedule_Frequency `protobuf:"varint,1,opt,name=frequency,proto3,enum=yandex.cloud.storage.v1.InventoryConfiguration_InventorySchedule_Frequency" json:"frequency,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *InventoryConfiguration_InventorySchedule) Reset() {
	*x = InventoryConfiguration_InventorySchedule{}
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[34]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InventoryConfiguration_InventorySchedule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InventoryConfiguration_InventorySchedule) ProtoMessage() {}

func (x *InventoryConfiguration_InventorySchedule) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[34]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InventoryConfiguration_InventorySchedule.ProtoReflect.Descriptor instead.
func (*InventoryConfiguration_InventorySchedule) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{16, 2}
}

func (x *InventoryConfiguration_InventorySchedule) GetFrequency() InventoryConfiguration_InventorySchedule_Frequency {
	if x != nil {
		return x.Frequency
	}
	return InventoryConfiguration_InventorySchedule_FREQUENCY_UNSPECIFIED
}

type InventoryConfiguration_InventoryFilter struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The prefix that an object must have to be included in the inventory results.
	Prefix        string `protobuf:"bytes,1,opt,name=prefix,proto3" json:"prefix,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *InventoryConfiguration_InventoryFilter) Reset() {
	*x = InventoryConfiguration_InventoryFilter{}
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[35]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InventoryConfiguration_InventoryFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InventoryConfiguration_InventoryFilter) ProtoMessage() {}

func (x *InventoryConfiguration_InventoryFilter) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_proto_msgTypes[35]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InventoryConfiguration_InventoryFilter.ProtoReflect.Descriptor instead.
func (*InventoryConfiguration_InventoryFilter) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP(), []int{16, 3}
}

func (x *InventoryConfiguration_InventoryFilter) GetPrefix() string {
	if x != nil {
		return x.Prefix
	}
	return ""
}

var File_yandex_cloud_storage_v1_bucket_proto protoreflect.FileDescriptor

const file_yandex_cloud_storage_v1_bucket_proto_rawDesc = "" +
	"\n" +
	"$yandex/cloud/storage/v1/bucket.proto\x12\x17yandex.cloud.storage.v1\x1a\x1cgoogle/protobuf/struct.proto\x1a\x1fgoogle/protobuf/timestamp.proto\x1a\x1egoogle/protobuf/wrappers.proto\x1a\x1dyandex/cloud/validation.proto\"\xc5\b\n" +
	"\x06Bucket\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\tR\x02id\x12\x12\n" +
	"\x04name\x18\x02 \x01(\tR\x04name\x12\x1b\n" +
	"\tfolder_id\x18\x03 \x01(\tR\bfolderId\x12c\n" +
	"\x16anonymous_access_flags\x18\x04 \x01(\v2-.yandex.cloud.storage.v1.AnonymousAccessFlagsR\x14anonymousAccessFlags\x122\n" +
	"\x15default_storage_class\x18\x05 \x01(\tR\x13defaultStorageClass\x12C\n" +
	"\n" +
	"versioning\x18\x06 \x01(\x0e2#.yandex.cloud.storage.v1.VersioningR\n" +
	"versioning\x12\x19\n" +
	"\bmax_size\x18\a \x01(\x03R\amaxSize\x12/\n" +
	"\x06policy\x18\b \x01(\v2\x17.google.protobuf.StructR\x06policy\x12.\n" +
	"\x03acl\x18\t \x01(\v2\x1c.yandex.cloud.storage.v1.ACLR\x03acl\x129\n" +
	"\n" +
	"created_at\x18\n" +
	" \x01(\v2\x1a.google.protobuf.TimestampR\tcreatedAt\x125\n" +
	"\x04cors\x18\v \x03(\v2!.yandex.cloud.storage.v1.CorsRuleR\x04cors\x12S\n" +
	"\x10website_settings\x18\f \x01(\v2(.yandex.cloud.storage.v1.WebsiteSettingsR\x0fwebsiteSettings\x12O\n" +
	"\x0flifecycle_rules\x18\r \x03(\v2&.yandex.cloud.storage.v1.LifecycleRuleR\x0elifecycleRules\x120\n" +
	"\x04tags\x18\x0e \x03(\v2\x1c.yandex.cloud.storage.v1.TagR\x04tags\x12D\n" +
	"\vobject_lock\x18\x0f \x01(\v2#.yandex.cloud.storage.v1.ObjectLockR\n" +
	"objectLock\x12C\n" +
	"\n" +
	"encryption\x18\x10 \x01(\v2#.yandex.cloud.storage.v1.EncryptionR\n" +
	"encryption\x12r\n" +
	"\x19allowed_private_endpoints\x18\x11 \x01(\v26.yandex.cloud.storage.v1.BucketAllowedPrivateEndpointsR\x17allowedPrivateEndpoints\x12\x1f\n" +
	"\vresource_id\x18\x12 \x01(\tR\n" +
	"resourceId\x126\n" +
	"\x17disabled_statickey_auth\x18\x13 \x01(\bR\x15disabledStatickeyAuth\"-\n" +
	"\x03Tag\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value\"\xc6\x04\n" +
	"\x03ACL\x12:\n" +
	"\x06grants\x18\x01 \x03(\v2\".yandex.cloud.storage.v1.ACL.GrantR\x06grants\x1a\x82\x04\n" +
	"\x05Grant\x12S\n" +
	"\n" +
	"permission\x18\x01 \x01(\x0e2-.yandex.cloud.storage.v1.ACL.Grant.PermissionB\x04\xe8\xc71\x01R\n" +
	"permission\x12Q\n" +
	"\n" +
	"grant_type\x18\x02 \x01(\x0e2,.yandex.cloud.storage.v1.ACL.Grant.GrantTypeB\x04\xe8\xc71\x01R\tgrantType\x12'\n" +
	"\n" +
	"grantee_id\x18\x03 \x01(\tB\b\x8a\xc81\x04<=50R\tgranteeId\"\xa3\x01\n" +
	"\n" +
	"Permission\x12\x1a\n" +
	"\x16PERMISSION_UNSPECIFIED\x10\x00\x12\x1b\n" +
	"\x17PERMISSION_FULL_CONTROL\x10\x01\x12\x14\n" +
	"\x10PERMISSION_WRITE\x10\x02\x12\x18\n" +
	"\x14PERMISSION_WRITE_ACP\x10\x03\x12\x13\n" +
	"\x0fPERMISSION_READ\x10\x04\x12\x17\n" +
	"\x13PERMISSION_READ_ACP\x10\x05\"\x81\x01\n" +
	"\tGrantType\x12\x1a\n" +
	"\x16GRANT_TYPE_UNSPECIFIED\x10\x00\x12\x16\n" +
	"\x12GRANT_TYPE_ACCOUNT\x10\x01\x12&\n" +
	"\"GRANT_TYPE_ALL_AUTHENTICATED_USERS\x10\x02\x12\x18\n" +
	"\x14GRANT_TYPE_ALL_USERS\x10\x03\"\xb3\x01\n" +
	"\x14AnonymousAccessFlags\x12.\n" +
	"\x04read\x18\x01 \x01(\v2\x1a.google.protobuf.BoolValueR\x04read\x12.\n" +
	"\x04list\x18\x02 \x01(\v2\x1a.google.protobuf.BoolValueR\x04list\x12;\n" +
	"\vconfig_read\x18\x03 \x01(\v2\x1a.google.protobuf.BoolValueR\n" +
	"configRead\"\xb6\x03\n" +
	"\bCorsRule\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\tR\x02id\x12]\n" +
	"\x0fallowed_methods\x18\x02 \x03(\x0e2(.yandex.cloud.storage.v1.CorsRule.MethodB\n" +
	"\x82\xc81\x02>0\x90\xc81\x01R\x0eallowedMethods\x12'\n" +
	"\x0fallowed_headers\x18\x03 \x03(\tR\x0eallowedHeaders\x12/\n" +
	"\x0fallowed_origins\x18\x04 \x03(\tB\x06\x82\xc81\x02>0R\x0eallowedOrigins\x12%\n" +
	"\x0eexpose_headers\x18\x05 \x03(\tR\rexposeHeaders\x12C\n" +
	"\x0fmax_age_seconds\x18\x06 \x01(\v2\x1b.google.protobuf.Int64ValueR\rmaxAgeSeconds\"u\n" +
	"\x06Method\x12\x16\n" +
	"\x12METHOD_UNSPECIFIED\x10\x00\x12\x0e\n" +
	"\n" +
	"METHOD_GET\x10\x01\x12\x0f\n" +
	"\vMETHOD_HEAD\x10\x02\x12\x0f\n" +
	"\vMETHOD_POST\x10\x03\x12\x0e\n" +
	"\n" +
	"METHOD_PUT\x10\x04\x12\x11\n" +
	"\rMETHOD_DELETE\x10\x05\"\x90\b\n" +
	"\x0fWebsiteSettings\x12\x14\n" +
	"\x05index\x18\x01 \x01(\tR\x05index\x12\x14\n" +
	"\x05error\x18\x02 \x01(\tR\x05error\x12c\n" +
	"\x15redirect_all_requests\x18\x03 \x01(\v2/.yandex.cloud.storage.v1.WebsiteSettings.SchemeR\x13redirectAllRequests\x12Y\n" +
	"\rrouting_rules\x18\x04 \x03(\v24.yandex.cloud.storage.v1.WebsiteSettings.RoutingRuleR\froutingRules\x1as\n" +
	"\x06Scheme\x12M\n" +
	"\bprotocol\x18\x01 \x01(\x0e21.yandex.cloud.storage.v1.WebsiteSettings.ProtocolR\bprotocol\x12\x1a\n" +
	"\bhostname\x18\x02 \x01(\tR\bhostname\x1a}\n" +
	"\tCondition\x12D\n" +
	"\x1fhttp_error_code_returned_equals\x18\x01 \x01(\tR\x1bhttpErrorCodeReturnedEquals\x12*\n" +
	"\x11key_prefix_equals\x18\x02 \x01(\tR\x0fkeyPrefixEquals\x1a\x9e\x02\n" +
	"\bRedirect\x12\x1a\n" +
	"\bhostname\x18\x01 \x01(\tR\bhostname\x12F\n" +
	"\x12http_redirect_code\x18\x02 \x01(\tB\x18\xf2\xc71\x143(0[1-9]|[1-9][0-9])R\x10httpRedirectCode\x12M\n" +
	"\bprotocol\x18\x03 \x01(\x0e21.yandex.cloud.storage.v1.WebsiteSettings.ProtocolR\bprotocol\x125\n" +
	"\x17replace_key_prefix_with\x18\x04 \x01(\tR\x14replaceKeyPrefixWith\x12(\n" +
	"\x10replace_key_with\x18\x05 \x01(\tR\x0ereplaceKeyWith\x1a\xae\x01\n" +
	"\vRoutingRule\x12P\n" +
	"\tcondition\x18\x01 \x01(\v22.yandex.cloud.storage.v1.WebsiteSettings.ConditionR\tcondition\x12M\n" +
	"\bredirect\x18\x02 \x01(\v21.yandex.cloud.storage.v1.WebsiteSettings.RedirectR\bredirect\"K\n" +
	"\bProtocol\x12\x18\n" +
	"\x14PROTOCOL_UNSPECIFIED\x10\x00\x12\x11\n" +
	"\rPROTOCOL_HTTP\x10\x01\x12\x12\n" +
	"\x0ePROTOCOL_HTTPS\x10\x02\"\x8b\x11\n" +
	"\rLifecycleRule\x12,\n" +
	"\x02id\x18\x01 \x01(\v2\x1c.google.protobuf.StringValueR\x02id\x12\x18\n" +
	"\aenabled\x18\x02 \x01(\bR\aenabled\x12I\n" +
	"\x06filter\x18\x03 \x01(\v21.yandex.cloud.storage.v1.LifecycleRule.RuleFilterR\x06filter\x12Q\n" +
	"\n" +
	"expiration\x18\x04 \x01(\v21.yandex.cloud.storage.v1.LifecycleRule.ExpirationR\n" +
	"expiration\x12S\n" +
	"\vtransitions\x18\x05 \x03(\v21.yandex.cloud.storage.v1.LifecycleRule.TransitionR\vtransitions\x12{\n" +
	"!abort_incomplete_multipart_upload\x18\x06 \x01(\v20.yandex.cloud.storage.v1.LifecycleRule.AfterDaysR\x1eabortIncompleteMultipartUpload\x12p\n" +
	"\x15noncurrent_expiration\x18\a \x01(\v2;.yandex.cloud.storage.v1.LifecycleRule.NoncurrentExpirationR\x14noncurrentExpiration\x12r\n" +
	"\x16noncurrent_transitions\x18\b \x03(\v2;.yandex.cloud.storage.v1.LifecycleRule.NoncurrentTransitionR\x15noncurrentTransitions\x12z\n" +
	"\x19noncurrent_delete_markers\x18\t \x01(\v2>.yandex.cloud.storage.v1.LifecycleRule.NoncurrentDeleteMarkersR\x17noncurrentDeleteMarkers\x1a\\\n" +
	"\tAfterDays\x12O\n" +
	"\x15days_after_expiration\x18\x01 \x01(\v2\x1b.google.protobuf.Int64ValueR\x13daysAfterExpiration\x1a_\n" +
	"\x17NoncurrentDeleteMarkers\x12D\n" +
	"\x0fnoncurrent_days\x18\x01 \x01(\v2\x1b.google.protobuf.Int64ValueR\x0enoncurrentDays\x1a\\\n" +
	"\x14NoncurrentExpiration\x12D\n" +
	"\x0fnoncurrent_days\x18\x01 \x01(\v2\x1b.google.protobuf.Int64ValueR\x0enoncurrentDays\x1a\x87\x01\n" +
	"\x14NoncurrentTransition\x12D\n" +
	"\x0fnoncurrent_days\x18\x01 \x01(\v2\x1b.google.protobuf.Int64ValueR\x0enoncurrentDays\x12)\n" +
	"\rstorage_class\x18\x02 \x01(\tB\x04\xe8\xc71\x01R\fstorageClass\x1a\x9e\x01\n" +
	"\n" +
	"Transition\x12.\n" +
	"\x04date\x18\x01 \x01(\v2\x1a.google.protobuf.TimestampR\x04date\x12/\n" +
	"\x04days\x18\x02 \x01(\v2\x1b.google.protobuf.Int64ValueR\x04days\x12)\n" +
	"\rstorage_class\x18\x04 \x01(\tB\x04\xe8\xc71\x01R\fstorageClassJ\x04\b\x03\x10\x04\x1a\xca\x01\n" +
	"\n" +
	"Expiration\x12.\n" +
	"\x04date\x18\x01 \x01(\v2\x1a.google.protobuf.TimestampR\x04date\x12/\n" +
	"\x04days\x18\x02 \x01(\v2\x1b.google.protobuf.Int64ValueR\x04days\x12[\n" +
	"\x1cexpired_object_delete_marker\x18\x03 \x01(\v2\x1a.google.protobuf.BoolValueR\x19expiredObjectDeleteMarker\x1a\xca\x04\n" +
	"\n" +
	"RuleFilter\x12\x16\n" +
	"\x06prefix\x18\x01 \x01(\tR\x06prefix\x12T\n" +
	"\x18object_size_greater_than\x18\x02 \x01(\v2\x1b.google.protobuf.Int64ValueR\x15objectSizeGreaterThan\x12N\n" +
	"\x15object_size_less_than\x18\x03 \x01(\v2\x1b.google.protobuf.Int64ValueR\x12objectSizeLessThan\x12.\n" +
	"\x03tag\x18\x04 \x01(\v2\x1c.yandex.cloud.storage.v1.TagR\x03tag\x12X\n" +
	"\fand_operator\x18\x05 \x01(\v25.yandex.cloud.storage.v1.LifecycleRule.RuleFilter.AndR\vandOperator\x1a\xf3\x01\n" +
	"\x03And\x12\x16\n" +
	"\x06prefix\x18\x01 \x01(\tR\x06prefix\x12T\n" +
	"\x18object_size_greater_than\x18\x02 \x01(\v2\x1b.google.protobuf.Int64ValueR\x15objectSizeGreaterThan\x12N\n" +
	"\x15object_size_less_than\x18\x03 \x01(\v2\x1b.google.protobuf.Int64ValueR\x12objectSizeLessThan\x12.\n" +
	"\x03tag\x18\x04 \x03(\v2\x1c.yandex.cloud.storage.v1.TagR\x03tag\"\xea\x02\n" +
	"\bCounters\x12,\n" +
	"\x12simple_object_size\x18\x01 \x01(\x03R\x10simpleObjectSize\x12.\n" +
	"\x13simple_object_count\x18\x02 \x01(\x03R\x11simpleObjectCount\x12,\n" +
	"\x12objects_parts_size\x18\x03 \x01(\x03R\x10objectsPartsSize\x12.\n" +
	"\x13objects_parts_count\x18\x04 \x01(\x03R\x11objectsPartsCount\x124\n" +
	"\x16multipart_objects_size\x18\x05 \x01(\x03R\x14multipartObjectsSize\x126\n" +
	"\x17multipart_objects_count\x18\x06 \x01(\x03R\x15multipartObjectsCount\x124\n" +
	"\x16active_multipart_count\x18\a \x01(\x03R\x14activeMultipartCount\"v\n" +
	"\x13OptionalSizeByClass\x12#\n" +
	"\rstorage_class\x18\x01 \x01(\tR\fstorageClass\x12:\n" +
	"\n" +
	"class_size\x18\x02 \x01(\v2\x1b.google.protobuf.Int64ValueR\tclassSize\"Q\n" +
	"\vSizeByClass\x12#\n" +
	"\rstorage_class\x18\x01 \x01(\tR\fstorageClass\x12\x1d\n" +
	"\n" +
	"class_size\x18\x02 \x01(\x03R\tclassSize\"u\n" +
	"\x0fCountersByClass\x12#\n" +
	"\rstorage_class\x18\x01 \x01(\tR\fstorageClass\x12=\n" +
	"\bcounters\x18\x02 \x01(\v2!.yandex.cloud.storage.v1.CountersR\bcounters\"\xc7\x05\n" +
	"\vBucketStats\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x126\n" +
	"\bmax_size\x18\x02 \x01(\v2\x1b.google.protobuf.Int64ValueR\amaxSize\x12\x1b\n" +
	"\tused_size\x18\x03 \x01(\x03R\busedSize\x12c\n" +
	"\x17storage_class_max_sizes\x18\x04 \x03(\v2,.yandex.cloud.storage.v1.OptionalSizeByClassR\x14storageClassMaxSizes\x12]\n" +
	"\x18storage_class_used_sizes\x18\x05 \x03(\v2$.yandex.cloud.storage.v1.SizeByClassR\x15storageClassUsedSizes\x12^\n" +
	"\x16storage_class_counters\x18\x06 \x03(\v2(.yandex.cloud.storage.v1.CountersByClassR\x14storageClassCounters\x12P\n" +
	"\x15default_storage_class\x18\a \x01(\v2\x1c.google.protobuf.StringValueR\x13defaultStorageClass\x12c\n" +
	"\x16anonymous_access_flags\x18\b \x01(\v2-.yandex.cloud.storage.v1.AnonymousAccessFlagsR\x14anonymousAccessFlags\x129\n" +
	"\n" +
	"created_at\x18\t \x01(\v2\x1a.google.protobuf.TimestampR\tcreatedAt\x129\n" +
	"\n" +
	"updated_at\x18\n" +
	" \x01(\v2\x1a.google.protobuf.TimestampR\tupdatedAt\"\x92\x04\n" +
	"\vHTTPSConfig\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x12P\n" +
	"\vsource_type\x18\x02 \x01(\x0e2/.yandex.cloud.storage.v1.HTTPSConfig.SourceTypeR\n" +
	"sourceType\x124\n" +
	"\x06issuer\x18\x03 \x01(\v2\x1c.google.protobuf.StringValueR\x06issuer\x126\n" +
	"\asubject\x18\x04 \x01(\v2\x1c.google.protobuf.StringValueR\asubject\x12\x1b\n" +
	"\tdns_names\x18\x05 \x03(\tR\bdnsNames\x129\n" +
	"\n" +
	"not_before\x18\x06 \x01(\v2\x1a.google.protobuf.TimestampR\tnotBefore\x127\n" +
	"\tnot_after\x18\a \x01(\v2\x1a.google.protobuf.TimestampR\bnotAfter\x12%\n" +
	"\x0ecertificate_id\x18\b \x01(\tR\rcertificateId\"w\n" +
	"\n" +
	"SourceType\x12\x1b\n" +
	"\x17SOURCE_TYPE_UNSPECIFIED\x10\x00\x12\x1c\n" +
	"\x18SOURCE_TYPE_SELF_MANAGED\x10\x01\x12.\n" +
	"*SOURCE_TYPE_MANAGED_BY_CERTIFICATE_MANAGER\x10\x02\"\xa0\x04\n" +
	"\n" +
	"ObjectLock\x12L\n" +
	"\x06status\x18\x02 \x01(\x0e24.yandex.cloud.storage.v1.ObjectLock.ObjectLockStatusR\x06status\x12a\n" +
	"\x11default_retention\x18\x03 \x01(\v24.yandex.cloud.storage.v1.ObjectLock.DefaultRetentionR\x10defaultRetention\x1a\xe7\x01\n" +
	"\x10DefaultRetention\x12M\n" +
	"\x04mode\x18\x01 \x01(\x0e29.yandex.cloud.storage.v1.ObjectLock.DefaultRetention.ModeR\x04mode\x12\x14\n" +
	"\x04days\x18\x02 \x01(\x03H\x00R\x04days\x12\x16\n" +
	"\x05years\x18\x03 \x01(\x03H\x00R\x05years\"F\n" +
	"\x04Mode\x12\x14\n" +
	"\x10MODE_UNSPECIFIED\x10\x00\x12\x13\n" +
	"\x0fMODE_GOVERNANCE\x10\x01\x12\x13\n" +
	"\x0fMODE_COMPLIANCE\x10\x02B\x0e\n" +
	"\x06period\x12\x04\xc0\xc11\x01\"w\n" +
	"\x10ObjectLockStatus\x12\"\n" +
	"\x1eOBJECT_LOCK_STATUS_UNSPECIFIED\x10\x00\x12\x1f\n" +
	"\x1bOBJECT_LOCK_STATUS_DISABLED\x10\x01\x12\x1e\n" +
	"\x1aOBJECT_LOCK_STATUS_ENABLED\x10\x02\"\xb8\x01\n" +
	"\n" +
	"Encryption\x12H\n" +
	"\x05rules\x18\x01 \x03(\v22.yandex.cloud.storage.v1.Encryption.EncryptionRuleR\x05rules\x1a`\n" +
	"\x0eEncryptionRule\x12)\n" +
	"\x11kms_master_key_id\x18\x01 \x01(\tR\x0ekmsMasterKeyId\x12#\n" +
	"\rsse_algorithm\x18\x02 \x01(\tR\fsseAlgorithm\"\xa3\x01\n" +
	"\x1dBucketAllowedPrivateEndpoints\x12\x18\n" +
	"\aenabled\x18\x01 \x01(\bR\aenabled\x12+\n" +
	"\x11private_endpoints\x18\x02 \x03(\tR\x10privateEndpoints\x12;\n" +
	"\x1aforce_cloud_console_access\x18\x03 \x01(\bR\x17forceCloudConsoleAccess\"\xad\r\n" +
	"\x16InventoryConfiguration\x12\x14\n" +
	"\x02id\x18\x01 \x01(\tB\x04\xe8\xc71\x01R\x02id\x12l\n" +
	"\vdestination\x18\x02 \x01(\v2D.yandex.cloud.storage.v1.InventoryConfiguration.InventoryDestinationB\x04\xe8\xc71\x01R\vdestination\x12\x86\x01\n" +
	"\x18included_object_versions\x18\x03 \x01(\x0e2F.yandex.cloud.storage.v1.InventoryConfiguration.IncludedObjectVersionsB\x04\xe8\xc71\x01R\x16includedObjectVersions\x12\x1d\n" +
	"\n" +
	"is_enabled\x18\x04 \x01(\bR\tisEnabled\x12c\n" +
	"\bschedule\x18\x05 \x01(\v2A.yandex.cloud.storage.v1.InventoryConfiguration.InventoryScheduleB\x04\xe8\xc71\x01R\bschedule\x12W\n" +
	"\x06filter\x18\x06 \x01(\v2?.yandex.cloud.storage.v1.InventoryConfiguration.InventoryFilterR\x06filter\x12f\n" +
	"\x0foptional_fields\x18\a \x03(\x0e2=.yandex.cloud.storage.v1.InventoryConfiguration.OptionalFieldR\x0eoptionalFields\x1a\x8c\x02\n" +
	"\x1aInventoryBucketDestination\x12\x1c\n" +
	"\x06bucket\x18\x01 \x01(\tB\x04\xe8\xc71\x01R\x06bucket\x12o\n" +
	"\x06format\x18\x02 \x01(\x0e2Q.yandex.cloud.storage.v1.InventoryConfiguration.InventoryBucketDestination.FormatB\x04\xe8\xc71\x01R\x06format\x124\n" +
	"\x06prefix\x18\x03 \x01(\v2\x1c.google.protobuf.StringValueR\x06prefix\")\n" +
	"\x06Format\x12\x16\n" +
	"\x12FORMAT_UNSPECIFIED\x10\x00\x12\a\n" +
	"\x03CSV\x10\x01\x1a\x97\x01\n" +
	"\x14InventoryDestination\x12\x7f\n" +
	"\x12bucket_destination\x18\x01 \x01(\v2J.yandex.cloud.storage.v1.InventoryConfiguration.InventoryBucketDestinationB\x04\xe8\xc71\x01R\x11bucketDestination\x1a\xc3\x01\n" +
	"\x11InventorySchedule\x12o\n" +
	"\tfrequency\x18\x01 \x01(\x0e2K.yandex.cloud.storage.v1.InventoryConfiguration.InventorySchedule.FrequencyB\x04\xe8\xc71\x01R\tfrequency\"=\n" +
	"\tFrequency\x12\x19\n" +
	"\x15FREQUENCY_UNSPECIFIED\x10\x00\x12\t\n" +
	"\x05DAILY\x10\x01\x12\n" +
	"\n" +
	"\x06WEEKLY\x10\x02\x1a/\n" +
	"\x0fInventoryFilter\x12\x1c\n" +
	"\x06prefix\x18\x01 \x01(\tB\x04\xe8\xc71\x01R\x06prefix\"X\n" +
	"\x16IncludedObjectVersions\x12(\n" +
	"$INCLUDED_OBJECT_VERSIONS_UNSPECIFIED\x10\x00\x12\a\n" +
	"\x03ALL\x10\x01\x12\v\n" +
	"\aCURRENT\x10\x02\"\xc6\x02\n" +
	"\rOptionalField\x12\x1e\n" +
	"\x1aOPTIONAL_FIELD_UNSPECIFIED\x10\x00\x12\b\n" +
	"\x04SIZE\x10\x01\x12\x16\n" +
	"\x12LAST_MODIFIED_DATE\x10\x02\x12\x11\n" +
	"\rSTORAGE_CLASS\x10\x03\x12\b\n" +
	"\x04ETAG\x10\x04\x12\x19\n" +
	"\x15IS_MULTIPART_UPLOADED\x10\x05\x12\x15\n" +
	"\x11ENCRYPTION_STATUS\x10\x06\x12!\n" +
	"\x1dOBJECT_LOCK_RETAIN_UNTIL_DATE\x10\a\x12\x14\n" +
	"\x10OBJECT_LOCK_MODE\x10\b\x12!\n" +
	"\x1dOBJECT_LOCK_LEGAL_HOLD_STATUS\x10\t\x12\x16\n" +
	"\x12CHECKSUM_ALGORITHM\x10\n" +
	"\x12\x1e\n" +
	"\x1aOBJECT_ACCESS_CONTROL_LIST\x10\v\x12\x10\n" +
	"\fOBJECT_OWNER\x10\f*s\n" +
	"\n" +
	"Versioning\x12\x1a\n" +
	"\x16VERSIONING_UNSPECIFIED\x10\x00\x12\x17\n" +
	"\x13VERSIONING_DISABLED\x10\x01\x12\x16\n" +
	"\x12VERSIONING_ENABLED\x10\x02\x12\x18\n" +
	"\x14VERSIONING_SUSPENDED\x10\x03Bb\n" +
	"\x1byandex.cloud.api.storage.v1ZCgithub.com/yandex-cloud/go-genproto/yandex/cloud/storage/v1;storageb\x06proto3"

var (
	file_yandex_cloud_storage_v1_bucket_proto_rawDescOnce sync.Once
	file_yandex_cloud_storage_v1_bucket_proto_rawDescData []byte
)

func file_yandex_cloud_storage_v1_bucket_proto_rawDescGZIP() []byte {
	file_yandex_cloud_storage_v1_bucket_proto_rawDescOnce.Do(func() {
		file_yandex_cloud_storage_v1_bucket_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_yandex_cloud_storage_v1_bucket_proto_rawDesc), len(file_yandex_cloud_storage_v1_bucket_proto_rawDesc)))
	})
	return file_yandex_cloud_storage_v1_bucket_proto_rawDescData
}

var file_yandex_cloud_storage_v1_bucket_proto_enumTypes = make([]protoimpl.EnumInfo, 12)
var file_yandex_cloud_storage_v1_bucket_proto_msgTypes = make([]protoimpl.MessageInfo, 36)
var file_yandex_cloud_storage_v1_bucket_proto_goTypes = []any{
	(Versioning)(0),                                               // 0: yandex.cloud.storage.v1.Versioning
	(ACL_Grant_Permission)(0),                                     // 1: yandex.cloud.storage.v1.ACL.Grant.Permission
	(ACL_Grant_GrantType)(0),                                      // 2: yandex.cloud.storage.v1.ACL.Grant.GrantType
	(CorsRule_Method)(0),                                          // 3: yandex.cloud.storage.v1.CorsRule.Method
	(WebsiteSettings_Protocol)(0),                                 // 4: yandex.cloud.storage.v1.WebsiteSettings.Protocol
	(HTTPSConfig_SourceType)(0),                                   // 5: yandex.cloud.storage.v1.HTTPSConfig.SourceType
	(ObjectLock_ObjectLockStatus)(0),                              // 6: yandex.cloud.storage.v1.ObjectLock.ObjectLockStatus
	(ObjectLock_DefaultRetention_Mode)(0),                         // 7: yandex.cloud.storage.v1.ObjectLock.DefaultRetention.Mode
	(InventoryConfiguration_IncludedObjectVersions)(0),            // 8: yandex.cloud.storage.v1.InventoryConfiguration.IncludedObjectVersions
	(InventoryConfiguration_OptionalField)(0),                     // 9: yandex.cloud.storage.v1.InventoryConfiguration.OptionalField
	(InventoryConfiguration_InventoryBucketDestination_Format)(0), // 10: yandex.cloud.storage.v1.InventoryConfiguration.InventoryBucketDestination.Format
	(InventoryConfiguration_InventorySchedule_Frequency)(0),       // 11: yandex.cloud.storage.v1.InventoryConfiguration.InventorySchedule.Frequency
	(*Bucket)(nil),                                                // 12: yandex.cloud.storage.v1.Bucket
	(*Tag)(nil),                                                   // 13: yandex.cloud.storage.v1.Tag
	(*ACL)(nil),                                                   // 14: yandex.cloud.storage.v1.ACL
	(*AnonymousAccessFlags)(nil),                                  // 15: yandex.cloud.storage.v1.AnonymousAccessFlags
	(*CorsRule)(nil),                                              // 16: yandex.cloud.storage.v1.CorsRule
	(*WebsiteSettings)(nil),                                       // 17: yandex.cloud.storage.v1.WebsiteSettings
	(*LifecycleRule)(nil),                                         // 18: yandex.cloud.storage.v1.LifecycleRule
	(*Counters)(nil),                                              // 19: yandex.cloud.storage.v1.Counters
	(*OptionalSizeByClass)(nil),                                   // 20: yandex.cloud.storage.v1.OptionalSizeByClass
	(*SizeByClass)(nil),                                           // 21: yandex.cloud.storage.v1.SizeByClass
	(*CountersByClass)(nil),                                       // 22: yandex.cloud.storage.v1.CountersByClass
	(*BucketStats)(nil),                                           // 23: yandex.cloud.storage.v1.BucketStats
	(*HTTPSConfig)(nil),                                           // 24: yandex.cloud.storage.v1.HTTPSConfig
	(*ObjectLock)(nil),                                            // 25: yandex.cloud.storage.v1.ObjectLock
	(*Encryption)(nil),                                            // 26: yandex.cloud.storage.v1.Encryption
	(*BucketAllowedPrivateEndpoints)(nil),                         // 27: yandex.cloud.storage.v1.BucketAllowedPrivateEndpoints
	(*InventoryConfiguration)(nil),                                // 28: yandex.cloud.storage.v1.InventoryConfiguration
	(*ACL_Grant)(nil),                                             // 29: yandex.cloud.storage.v1.ACL.Grant
	(*WebsiteSettings_Scheme)(nil),                                // 30: yandex.cloud.storage.v1.WebsiteSettings.Scheme
	(*WebsiteSettings_Condition)(nil),                             // 31: yandex.cloud.storage.v1.WebsiteSettings.Condition
	(*WebsiteSettings_Redirect)(nil),                              // 32: yandex.cloud.storage.v1.WebsiteSettings.Redirect
	(*WebsiteSettings_RoutingRule)(nil),                           // 33: yandex.cloud.storage.v1.WebsiteSettings.RoutingRule
	(*LifecycleRule_AfterDays)(nil),                               // 34: yandex.cloud.storage.v1.LifecycleRule.AfterDays
	(*LifecycleRule_NoncurrentDeleteMarkers)(nil),                 // 35: yandex.cloud.storage.v1.LifecycleRule.NoncurrentDeleteMarkers
	(*LifecycleRule_NoncurrentExpiration)(nil),                    // 36: yandex.cloud.storage.v1.LifecycleRule.NoncurrentExpiration
	(*LifecycleRule_NoncurrentTransition)(nil),                    // 37: yandex.cloud.storage.v1.LifecycleRule.NoncurrentTransition
	(*LifecycleRule_Transition)(nil),                              // 38: yandex.cloud.storage.v1.LifecycleRule.Transition
	(*LifecycleRule_Expiration)(nil),                              // 39: yandex.cloud.storage.v1.LifecycleRule.Expiration
	(*LifecycleRule_RuleFilter)(nil),                              // 40: yandex.cloud.storage.v1.LifecycleRule.RuleFilter
	(*LifecycleRule_RuleFilter_And)(nil),                          // 41: yandex.cloud.storage.v1.LifecycleRule.RuleFilter.And
	(*ObjectLock_DefaultRetention)(nil),                           // 42: yandex.cloud.storage.v1.ObjectLock.DefaultRetention
	(*Encryption_EncryptionRule)(nil),                             // 43: yandex.cloud.storage.v1.Encryption.EncryptionRule
	(*InventoryConfiguration_InventoryBucketDestination)(nil),     // 44: yandex.cloud.storage.v1.InventoryConfiguration.InventoryBucketDestination
	(*InventoryConfiguration_InventoryDestination)(nil),           // 45: yandex.cloud.storage.v1.InventoryConfiguration.InventoryDestination
	(*InventoryConfiguration_InventorySchedule)(nil),              // 46: yandex.cloud.storage.v1.InventoryConfiguration.InventorySchedule
	(*InventoryConfiguration_InventoryFilter)(nil),                // 47: yandex.cloud.storage.v1.InventoryConfiguration.InventoryFilter
	(*structpb.Struct)(nil),                                       // 48: google.protobuf.Struct
	(*timestamppb.Timestamp)(nil),                                 // 49: google.protobuf.Timestamp
	(*wrapperspb.BoolValue)(nil),                                  // 50: google.protobuf.BoolValue
	(*wrapperspb.Int64Value)(nil),                                 // 51: google.protobuf.Int64Value
	(*wrapperspb.StringValue)(nil),                                // 52: google.protobuf.StringValue
}
var file_yandex_cloud_storage_v1_bucket_proto_depIdxs = []int32{
	15, // 0: yandex.cloud.storage.v1.Bucket.anonymous_access_flags:type_name -> yandex.cloud.storage.v1.AnonymousAccessFlags
	0,  // 1: yandex.cloud.storage.v1.Bucket.versioning:type_name -> yandex.cloud.storage.v1.Versioning
	48, // 2: yandex.cloud.storage.v1.Bucket.policy:type_name -> google.protobuf.Struct
	14, // 3: yandex.cloud.storage.v1.Bucket.acl:type_name -> yandex.cloud.storage.v1.ACL
	49, // 4: yandex.cloud.storage.v1.Bucket.created_at:type_name -> google.protobuf.Timestamp
	16, // 5: yandex.cloud.storage.v1.Bucket.cors:type_name -> yandex.cloud.storage.v1.CorsRule
	17, // 6: yandex.cloud.storage.v1.Bucket.website_settings:type_name -> yandex.cloud.storage.v1.WebsiteSettings
	18, // 7: yandex.cloud.storage.v1.Bucket.lifecycle_rules:type_name -> yandex.cloud.storage.v1.LifecycleRule
	13, // 8: yandex.cloud.storage.v1.Bucket.tags:type_name -> yandex.cloud.storage.v1.Tag
	25, // 9: yandex.cloud.storage.v1.Bucket.object_lock:type_name -> yandex.cloud.storage.v1.ObjectLock
	26, // 10: yandex.cloud.storage.v1.Bucket.encryption:type_name -> yandex.cloud.storage.v1.Encryption
	27, // 11: yandex.cloud.storage.v1.Bucket.allowed_private_endpoints:type_name -> yandex.cloud.storage.v1.BucketAllowedPrivateEndpoints
	29, // 12: yandex.cloud.storage.v1.ACL.grants:type_name -> yandex.cloud.storage.v1.ACL.Grant
	50, // 13: yandex.cloud.storage.v1.AnonymousAccessFlags.read:type_name -> google.protobuf.BoolValue
	50, // 14: yandex.cloud.storage.v1.AnonymousAccessFlags.list:type_name -> google.protobuf.BoolValue
	50, // 15: yandex.cloud.storage.v1.AnonymousAccessFlags.config_read:type_name -> google.protobuf.BoolValue
	3,  // 16: yandex.cloud.storage.v1.CorsRule.allowed_methods:type_name -> yandex.cloud.storage.v1.CorsRule.Method
	51, // 17: yandex.cloud.storage.v1.CorsRule.max_age_seconds:type_name -> google.protobuf.Int64Value
	30, // 18: yandex.cloud.storage.v1.WebsiteSettings.redirect_all_requests:type_name -> yandex.cloud.storage.v1.WebsiteSettings.Scheme
	33, // 19: yandex.cloud.storage.v1.WebsiteSettings.routing_rules:type_name -> yandex.cloud.storage.v1.WebsiteSettings.RoutingRule
	52, // 20: yandex.cloud.storage.v1.LifecycleRule.id:type_name -> google.protobuf.StringValue
	40, // 21: yandex.cloud.storage.v1.LifecycleRule.filter:type_name -> yandex.cloud.storage.v1.LifecycleRule.RuleFilter
	39, // 22: yandex.cloud.storage.v1.LifecycleRule.expiration:type_name -> yandex.cloud.storage.v1.LifecycleRule.Expiration
	38, // 23: yandex.cloud.storage.v1.LifecycleRule.transitions:type_name -> yandex.cloud.storage.v1.LifecycleRule.Transition
	34, // 24: yandex.cloud.storage.v1.LifecycleRule.abort_incomplete_multipart_upload:type_name -> yandex.cloud.storage.v1.LifecycleRule.AfterDays
	36, // 25: yandex.cloud.storage.v1.LifecycleRule.noncurrent_expiration:type_name -> yandex.cloud.storage.v1.LifecycleRule.NoncurrentExpiration
	37, // 26: yandex.cloud.storage.v1.LifecycleRule.noncurrent_transitions:type_name -> yandex.cloud.storage.v1.LifecycleRule.NoncurrentTransition
	35, // 27: yandex.cloud.storage.v1.LifecycleRule.noncurrent_delete_markers:type_name -> yandex.cloud.storage.v1.LifecycleRule.NoncurrentDeleteMarkers
	51, // 28: yandex.cloud.storage.v1.OptionalSizeByClass.class_size:type_name -> google.protobuf.Int64Value
	19, // 29: yandex.cloud.storage.v1.CountersByClass.counters:type_name -> yandex.cloud.storage.v1.Counters
	51, // 30: yandex.cloud.storage.v1.BucketStats.max_size:type_name -> google.protobuf.Int64Value
	20, // 31: yandex.cloud.storage.v1.BucketStats.storage_class_max_sizes:type_name -> yandex.cloud.storage.v1.OptionalSizeByClass
	21, // 32: yandex.cloud.storage.v1.BucketStats.storage_class_used_sizes:type_name -> yandex.cloud.storage.v1.SizeByClass
	22, // 33: yandex.cloud.storage.v1.BucketStats.storage_class_counters:type_name -> yandex.cloud.storage.v1.CountersByClass
	52, // 34: yandex.cloud.storage.v1.BucketStats.default_storage_class:type_name -> google.protobuf.StringValue
	15, // 35: yandex.cloud.storage.v1.BucketStats.anonymous_access_flags:type_name -> yandex.cloud.storage.v1.AnonymousAccessFlags
	49, // 36: yandex.cloud.storage.v1.BucketStats.created_at:type_name -> google.protobuf.Timestamp
	49, // 37: yandex.cloud.storage.v1.BucketStats.updated_at:type_name -> google.protobuf.Timestamp
	5,  // 38: yandex.cloud.storage.v1.HTTPSConfig.source_type:type_name -> yandex.cloud.storage.v1.HTTPSConfig.SourceType
	52, // 39: yandex.cloud.storage.v1.HTTPSConfig.issuer:type_name -> google.protobuf.StringValue
	52, // 40: yandex.cloud.storage.v1.HTTPSConfig.subject:type_name -> google.protobuf.StringValue
	49, // 41: yandex.cloud.storage.v1.HTTPSConfig.not_before:type_name -> google.protobuf.Timestamp
	49, // 42: yandex.cloud.storage.v1.HTTPSConfig.not_after:type_name -> google.protobuf.Timestamp
	6,  // 43: yandex.cloud.storage.v1.ObjectLock.status:type_name -> yandex.cloud.storage.v1.ObjectLock.ObjectLockStatus
	42, // 44: yandex.cloud.storage.v1.ObjectLock.default_retention:type_name -> yandex.cloud.storage.v1.ObjectLock.DefaultRetention
	43, // 45: yandex.cloud.storage.v1.Encryption.rules:type_name -> yandex.cloud.storage.v1.Encryption.EncryptionRule
	45, // 46: yandex.cloud.storage.v1.InventoryConfiguration.destination:type_name -> yandex.cloud.storage.v1.InventoryConfiguration.InventoryDestination
	8,  // 47: yandex.cloud.storage.v1.InventoryConfiguration.included_object_versions:type_name -> yandex.cloud.storage.v1.InventoryConfiguration.IncludedObjectVersions
	46, // 48: yandex.cloud.storage.v1.InventoryConfiguration.schedule:type_name -> yandex.cloud.storage.v1.InventoryConfiguration.InventorySchedule
	47, // 49: yandex.cloud.storage.v1.InventoryConfiguration.filter:type_name -> yandex.cloud.storage.v1.InventoryConfiguration.InventoryFilter
	9,  // 50: yandex.cloud.storage.v1.InventoryConfiguration.optional_fields:type_name -> yandex.cloud.storage.v1.InventoryConfiguration.OptionalField
	1,  // 51: yandex.cloud.storage.v1.ACL.Grant.permission:type_name -> yandex.cloud.storage.v1.ACL.Grant.Permission
	2,  // 52: yandex.cloud.storage.v1.ACL.Grant.grant_type:type_name -> yandex.cloud.storage.v1.ACL.Grant.GrantType
	4,  // 53: yandex.cloud.storage.v1.WebsiteSettings.Scheme.protocol:type_name -> yandex.cloud.storage.v1.WebsiteSettings.Protocol
	4,  // 54: yandex.cloud.storage.v1.WebsiteSettings.Redirect.protocol:type_name -> yandex.cloud.storage.v1.WebsiteSettings.Protocol
	31, // 55: yandex.cloud.storage.v1.WebsiteSettings.RoutingRule.condition:type_name -> yandex.cloud.storage.v1.WebsiteSettings.Condition
	32, // 56: yandex.cloud.storage.v1.WebsiteSettings.RoutingRule.redirect:type_name -> yandex.cloud.storage.v1.WebsiteSettings.Redirect
	51, // 57: yandex.cloud.storage.v1.LifecycleRule.AfterDays.days_after_expiration:type_name -> google.protobuf.Int64Value
	51, // 58: yandex.cloud.storage.v1.LifecycleRule.NoncurrentDeleteMarkers.noncurrent_days:type_name -> google.protobuf.Int64Value
	51, // 59: yandex.cloud.storage.v1.LifecycleRule.NoncurrentExpiration.noncurrent_days:type_name -> google.protobuf.Int64Value
	51, // 60: yandex.cloud.storage.v1.LifecycleRule.NoncurrentTransition.noncurrent_days:type_name -> google.protobuf.Int64Value
	49, // 61: yandex.cloud.storage.v1.LifecycleRule.Transition.date:type_name -> google.protobuf.Timestamp
	51, // 62: yandex.cloud.storage.v1.LifecycleRule.Transition.days:type_name -> google.protobuf.Int64Value
	49, // 63: yandex.cloud.storage.v1.LifecycleRule.Expiration.date:type_name -> google.protobuf.Timestamp
	51, // 64: yandex.cloud.storage.v1.LifecycleRule.Expiration.days:type_name -> google.protobuf.Int64Value
	50, // 65: yandex.cloud.storage.v1.LifecycleRule.Expiration.expired_object_delete_marker:type_name -> google.protobuf.BoolValue
	51, // 66: yandex.cloud.storage.v1.LifecycleRule.RuleFilter.object_size_greater_than:type_name -> google.protobuf.Int64Value
	51, // 67: yandex.cloud.storage.v1.LifecycleRule.RuleFilter.object_size_less_than:type_name -> google.protobuf.Int64Value
	13, // 68: yandex.cloud.storage.v1.LifecycleRule.RuleFilter.tag:type_name -> yandex.cloud.storage.v1.Tag
	41, // 69: yandex.cloud.storage.v1.LifecycleRule.RuleFilter.and_operator:type_name -> yandex.cloud.storage.v1.LifecycleRule.RuleFilter.And
	51, // 70: yandex.cloud.storage.v1.LifecycleRule.RuleFilter.And.object_size_greater_than:type_name -> google.protobuf.Int64Value
	51, // 71: yandex.cloud.storage.v1.LifecycleRule.RuleFilter.And.object_size_less_than:type_name -> google.protobuf.Int64Value
	13, // 72: yandex.cloud.storage.v1.LifecycleRule.RuleFilter.And.tag:type_name -> yandex.cloud.storage.v1.Tag
	7,  // 73: yandex.cloud.storage.v1.ObjectLock.DefaultRetention.mode:type_name -> yandex.cloud.storage.v1.ObjectLock.DefaultRetention.Mode
	10, // 74: yandex.cloud.storage.v1.InventoryConfiguration.InventoryBucketDestination.format:type_name -> yandex.cloud.storage.v1.InventoryConfiguration.InventoryBucketDestination.Format
	52, // 75: yandex.cloud.storage.v1.InventoryConfiguration.InventoryBucketDestination.prefix:type_name -> google.protobuf.StringValue
	44, // 76: yandex.cloud.storage.v1.InventoryConfiguration.InventoryDestination.bucket_destination:type_name -> yandex.cloud.storage.v1.InventoryConfiguration.InventoryBucketDestination
	11, // 77: yandex.cloud.storage.v1.InventoryConfiguration.InventorySchedule.frequency:type_name -> yandex.cloud.storage.v1.InventoryConfiguration.InventorySchedule.Frequency
	78, // [78:78] is the sub-list for method output_type
	78, // [78:78] is the sub-list for method input_type
	78, // [78:78] is the sub-list for extension type_name
	78, // [78:78] is the sub-list for extension extendee
	0,  // [0:78] is the sub-list for field type_name
}

func init() { file_yandex_cloud_storage_v1_bucket_proto_init() }
func file_yandex_cloud_storage_v1_bucket_proto_init() {
	if File_yandex_cloud_storage_v1_bucket_proto != nil {
		return
	}
	file_yandex_cloud_storage_v1_bucket_proto_msgTypes[30].OneofWrappers = []any{
		(*ObjectLock_DefaultRetention_Days)(nil),
		(*ObjectLock_DefaultRetention_Years)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_yandex_cloud_storage_v1_bucket_proto_rawDesc), len(file_yandex_cloud_storage_v1_bucket_proto_rawDesc)),
			NumEnums:      12,
			NumMessages:   36,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_yandex_cloud_storage_v1_bucket_proto_goTypes,
		DependencyIndexes: file_yandex_cloud_storage_v1_bucket_proto_depIdxs,
		EnumInfos:         file_yandex_cloud_storage_v1_bucket_proto_enumTypes,
		MessageInfos:      file_yandex_cloud_storage_v1_bucket_proto_msgTypes,
	}.Build()
	File_yandex_cloud_storage_v1_bucket_proto = out.File
	file_yandex_cloud_storage_v1_bucket_proto_goTypes = nil
	file_yandex_cloud_storage_v1_bucket_proto_depIdxs = nil
}
