// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.11
// 	protoc        v3.21.12
// source: yandex/cloud/video/v1/channel.proto

package video

import (
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Root entity for content organization and separation within the video platform.
// A channel serves as a container for videos and streams, providing a way to
// group related content and apply common settings and access controls.
// Each channel belongs to a specific organization and can have its own
// configuration for advertisements, content cleanup, and embedding restrictions.
type Channel struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Unique identifier of the channel.
	// This ID is used to reference the channel in API calls and URLs.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Identifier of the organization to which this channel belongs.
	// Each channel must be associated with exactly one organization.
	OrganizationId string `protobuf:"bytes,2,opt,name=organization_id,json=organizationId,proto3" json:"organization_id,omitempty"`
	// Title of the channel displayed in interfaces.
	// This is the primary display name shown to users.
	Title string `protobuf:"bytes,3,opt,name=title,proto3" json:"title,omitempty"`
	// Detailed description of the channel's purpose and content.
	// This optional field provides additional context about the channel.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Identifier of the default style preset applied to videos in this channel.
	// Videos, episodes, and playlists created in this channel
	// inherit this preset unless explicitly overridden.
	DefaultStylePresetId string `protobuf:"bytes,5,opt,name=default_style_preset_id,json=defaultStylePresetId,proto3" json:"default_style_preset_id,omitempty"`
	// Timestamp when the channel was initially created.
	// This value is set automatically by the system and cannot be modified.
	CreatedAt *timestamppb.Timestamp `protobuf:"bytes,100,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Timestamp of the last modification to the channel or its settings.
	// This value is updated automatically whenever the channel is modified.
	UpdatedAt *timestamppb.Timestamp `protobuf:"bytes,101,opt,name=updated_at,json=updatedAt,proto3" json:"updated_at,omitempty"`
	// Custom user-defined labels as `key:value` pairs.
	// Maximum 64 labels per channel.
	// Labels can be used for organization, filtering, and metadata purposes.
	Labels map[string]string `protobuf:"bytes,200,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Configuration settings for the channel's behavior and features.
	// These settings control advertisements, content cleanup policies,
	// and embedding restrictions for all content in the channel.
	Settings      *ChannelSettings `protobuf:"bytes,201,opt,name=settings,proto3" json:"settings,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Channel) Reset() {
	*x = Channel{}
	mi := &file_yandex_cloud_video_v1_channel_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Channel) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Channel) ProtoMessage() {}

func (x *Channel) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_video_v1_channel_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Channel.ProtoReflect.Descriptor instead.
func (*Channel) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_video_v1_channel_proto_rawDescGZIP(), []int{0}
}

func (x *Channel) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Channel) GetOrganizationId() string {
	if x != nil {
		return x.OrganizationId
	}
	return ""
}

func (x *Channel) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *Channel) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Channel) GetDefaultStylePresetId() string {
	if x != nil {
		return x.DefaultStylePresetId
	}
	return ""
}

func (x *Channel) GetCreatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.CreatedAt
	}
	return nil
}

func (x *Channel) GetUpdatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdatedAt
	}
	return nil
}

func (x *Channel) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Channel) GetSettings() *ChannelSettings {
	if x != nil {
		return x.Settings
	}
	return nil
}

// Configuration settings for the channel's behavior and features.
// These settings apply to all content in the channel and control
// various aspects of how the channel and its content behave.
type ChannelSettings struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Settings for advertisement display and behavior.
	// Controls whether and how advertisements are shown with content in this channel.
	// If not specified, default advertisement settings are applied.
	Advertisement *AdvertisementSettings `protobuf:"bytes,1,opt,name=advertisement,proto3" json:"advertisement,omitempty"`
	// Settings for HTTP Referer verification to control content embedding.
	// Restricts which domains can embed content from this channel.
	// If not specified or disabled, content can be embedded on any domain.
	RefererVerification *RefererVerificationSettings `protobuf:"bytes,3,opt,name=referer_verification,json=refererVerification,proto3" json:"referer_verification,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *ChannelSettings) Reset() {
	*x = ChannelSettings{}
	mi := &file_yandex_cloud_video_v1_channel_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ChannelSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChannelSettings) ProtoMessage() {}

func (x *ChannelSettings) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_video_v1_channel_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChannelSettings.ProtoReflect.Descriptor instead.
func (*ChannelSettings) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_video_v1_channel_proto_rawDescGZIP(), []int{1}
}

func (x *ChannelSettings) GetAdvertisement() *AdvertisementSettings {
	if x != nil {
		return x.Advertisement
	}
	return nil
}

func (x *ChannelSettings) GetRefererVerification() *RefererVerificationSettings {
	if x != nil {
		return x.RefererVerification
	}
	return nil
}

// Settings for advertisement display and behavior in the channel.
// These settings control whether and how advertisements are shown
// with content in this channel, including both videos and streams.
type AdvertisementSettings struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Specifies the advertisement provider to use.
	// Only one provider can be active at a time.
	//
	// Types that are valid to be assigned to Provider:
	//
	//	*AdvertisementSettings_YandexDirect_
	Provider      isAdvertisementSettings_Provider `protobuf_oneof:"provider"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AdvertisementSettings) Reset() {
	*x = AdvertisementSettings{}
	mi := &file_yandex_cloud_video_v1_channel_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AdvertisementSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AdvertisementSettings) ProtoMessage() {}

func (x *AdvertisementSettings) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_video_v1_channel_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AdvertisementSettings.ProtoReflect.Descriptor instead.
func (*AdvertisementSettings) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_video_v1_channel_proto_rawDescGZIP(), []int{2}
}

func (x *AdvertisementSettings) GetProvider() isAdvertisementSettings_Provider {
	if x != nil {
		return x.Provider
	}
	return nil
}

func (x *AdvertisementSettings) GetYandexDirect() *AdvertisementSettings_YandexDirect {
	if x != nil {
		if x, ok := x.Provider.(*AdvertisementSettings_YandexDirect_); ok {
			return x.YandexDirect
		}
	}
	return nil
}

type isAdvertisementSettings_Provider interface {
	isAdvertisementSettings_Provider()
}

type AdvertisementSettings_YandexDirect_ struct {
	// Yandex.Direct advertisement provider settings.
	// When specified, advertisements will be served through Yandex.Direct.
	YandexDirect *AdvertisementSettings_YandexDirect `protobuf:"bytes,100,opt,name=yandex_direct,json=yandexDirect,proto3,oneof"`
}

func (*AdvertisementSettings_YandexDirect_) isAdvertisementSettings_Provider() {}

// Settings for HTTP Referer verification to control where content can be embedded.
// When enabled, the system checks the HTTP Referer request header to ensure
// that content is only embedded on allowed domains.
type RefererVerificationSettings struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Enables or disables Referer verification for this channel.
	// When set to true, only requests from allowed domains will be permitted.
	// When set to false, content can be embedded on any domain.
	Enable bool `protobuf:"varint,1,opt,name=enable,proto3" json:"enable,omitempty"`
	// List of domains allowed to embed content from this channel.
	// Only relevant when enable is set to true.
	// Supports wildcard notation (e.g., "*.example.com") to allow all subdomains.
	AllowedDomains []string `protobuf:"bytes,2,rep,name=allowed_domains,json=allowedDomains,proto3" json:"allowed_domains,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *RefererVerificationSettings) Reset() {
	*x = RefererVerificationSettings{}
	mi := &file_yandex_cloud_video_v1_channel_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RefererVerificationSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RefererVerificationSettings) ProtoMessage() {}

func (x *RefererVerificationSettings) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_video_v1_channel_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RefererVerificationSettings.ProtoReflect.Descriptor instead.
func (*RefererVerificationSettings) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_video_v1_channel_proto_rawDescGZIP(), []int{3}
}

func (x *RefererVerificationSettings) GetEnable() bool {
	if x != nil {
		return x.Enable
	}
	return false
}

func (x *RefererVerificationSettings) GetAllowedDomains() []string {
	if x != nil {
		return x.AllowedDomains
	}
	return nil
}

// Configuration for the Yandex.Direct advertisement provider.
// These settings are specific to the Yandex.Direct advertising platform.
type AdvertisementSettings_YandexDirect struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Enables or disables Partner Ad for both Live and VOD content.
	// When set to true, advertisements will be shown with content.
	// When set to false, no advertisements will be shown.
	Enable bool `protobuf:"varint,1,opt,name=enable,proto3" json:"enable,omitempty"`
	// Yandex.Direct page identifier.
	// This ID is used to associate the channel with a specific page
	// in the Yandex.Direct system for targeting and reporting.
	PageId int64 `protobuf:"varint,2,opt,name=page_id,json=pageId,proto3" json:"page_id,omitempty"`
	// Yandex.Direct category identifier.
	// This ID is used to categorize the channel's content for
	// appropriate advertisement targeting and compliance.
	Category      int64 `protobuf:"varint,3,opt,name=category,proto3" json:"category,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AdvertisementSettings_YandexDirect) Reset() {
	*x = AdvertisementSettings_YandexDirect{}
	mi := &file_yandex_cloud_video_v1_channel_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AdvertisementSettings_YandexDirect) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AdvertisementSettings_YandexDirect) ProtoMessage() {}

func (x *AdvertisementSettings_YandexDirect) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_video_v1_channel_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AdvertisementSettings_YandexDirect.ProtoReflect.Descriptor instead.
func (*AdvertisementSettings_YandexDirect) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_video_v1_channel_proto_rawDescGZIP(), []int{2, 0}
}

func (x *AdvertisementSettings_YandexDirect) GetEnable() bool {
	if x != nil {
		return x.Enable
	}
	return false
}

func (x *AdvertisementSettings_YandexDirect) GetPageId() int64 {
	if x != nil {
		return x.PageId
	}
	return 0
}

func (x *AdvertisementSettings_YandexDirect) GetCategory() int64 {
	if x != nil {
		return x.Category
	}
	return 0
}

var File_yandex_cloud_video_v1_channel_proto protoreflect.FileDescriptor

const file_yandex_cloud_video_v1_channel_proto_rawDesc = "" +
	"\n" +
	"#yandex/cloud/video/v1/channel.proto\x12\x15yandex.cloud.video.v1\x1a\x1fgoogle/protobuf/timestamp.proto\x1a\x1dyandex/cloud/validation.proto\"\xf9\x03\n" +
	"\aChannel\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\tR\x02id\x12'\n" +
	"\x0forganization_id\x18\x02 \x01(\tR\x0eorganizationId\x12\x14\n" +
	"\x05title\x18\x03 \x01(\tR\x05title\x12 \n" +
	"\vdescription\x18\x04 \x01(\tR\vdescription\x125\n" +
	"\x17default_style_preset_id\x18\x05 \x01(\tR\x14defaultStylePresetId\x129\n" +
	"\n" +
	"created_at\x18d \x01(\v2\x1a.google.protobuf.TimestampR\tcreatedAt\x129\n" +
	"\n" +
	"updated_at\x18e \x01(\v2\x1a.google.protobuf.TimestampR\tupdatedAt\x12C\n" +
	"\x06labels\x18\xc8\x01 \x03(\v2*.yandex.cloud.video.v1.Channel.LabelsEntryR\x06labels\x12C\n" +
	"\bsettings\x18\xc9\x01 \x01(\v2&.yandex.cloud.video.v1.ChannelSettingsR\bsettings\x1a9\n" +
	"\vLabelsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01J\x04\b\x06\x10dJ\x05\bf\x10\xc8\x01\"\xd2\x01\n" +
	"\x0fChannelSettings\x12R\n" +
	"\radvertisement\x18\x01 \x01(\v2,.yandex.cloud.video.v1.AdvertisementSettingsR\radvertisement\x12e\n" +
	"\x14referer_verification\x18\x03 \x01(\v22.yandex.cloud.video.v1.RefererVerificationSettingsR\x13refererVerificationJ\x04\b\x02\x10\x03\"\xe8\x01\n" +
	"\x15AdvertisementSettings\x12`\n" +
	"\ryandex_direct\x18d \x01(\v29.yandex.cloud.video.v1.AdvertisementSettings.YandexDirectH\x00R\fyandexDirect\x1a[\n" +
	"\fYandexDirect\x12\x16\n" +
	"\x06enable\x18\x01 \x01(\bR\x06enable\x12\x17\n" +
	"\apage_id\x18\x02 \x01(\x03R\x06pageId\x12\x1a\n" +
	"\bcategory\x18\x03 \x01(\x03R\bcategoryB\n" +
	"\n" +
	"\bproviderJ\x04\b\x01\x10d\"\xb4\x01\n" +
	"\x1bRefererVerificationSettings\x12\x16\n" +
	"\x06enable\x18\x01 \x01(\bR\x06enable\x12}\n" +
	"\x0fallowed_domains\x18\x02 \x03(\tBT\xf2\xc71>^(?:\\*\\.)?(?:[a-zA-Z0-9-]*\\.)+[a-zA-Z]{2,}$|^\\*\\.[a-zA-Z]{2,}$\x82\xc81\x05<=100\x8a\xc81\x054-255R\x0eallowedDomainsB\\\n" +
	"\x19yandex.cloud.api.video.v1Z?github.com/yandex-cloud/go-genproto/yandex/cloud/video/v1;videob\x06proto3"

var (
	file_yandex_cloud_video_v1_channel_proto_rawDescOnce sync.Once
	file_yandex_cloud_video_v1_channel_proto_rawDescData []byte
)

func file_yandex_cloud_video_v1_channel_proto_rawDescGZIP() []byte {
	file_yandex_cloud_video_v1_channel_proto_rawDescOnce.Do(func() {
		file_yandex_cloud_video_v1_channel_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_yandex_cloud_video_v1_channel_proto_rawDesc), len(file_yandex_cloud_video_v1_channel_proto_rawDesc)))
	})
	return file_yandex_cloud_video_v1_channel_proto_rawDescData
}

var file_yandex_cloud_video_v1_channel_proto_msgTypes = make([]protoimpl.MessageInfo, 6)
var file_yandex_cloud_video_v1_channel_proto_goTypes = []any{
	(*Channel)(nil),                     // 0: yandex.cloud.video.v1.Channel
	(*ChannelSettings)(nil),             // 1: yandex.cloud.video.v1.ChannelSettings
	(*AdvertisementSettings)(nil),       // 2: yandex.cloud.video.v1.AdvertisementSettings
	(*RefererVerificationSettings)(nil), // 3: yandex.cloud.video.v1.RefererVerificationSettings
	nil,                                 // 4: yandex.cloud.video.v1.Channel.LabelsEntry
	(*AdvertisementSettings_YandexDirect)(nil), // 5: yandex.cloud.video.v1.AdvertisementSettings.YandexDirect
	(*timestamppb.Timestamp)(nil),              // 6: google.protobuf.Timestamp
}
var file_yandex_cloud_video_v1_channel_proto_depIdxs = []int32{
	6, // 0: yandex.cloud.video.v1.Channel.created_at:type_name -> google.protobuf.Timestamp
	6, // 1: yandex.cloud.video.v1.Channel.updated_at:type_name -> google.protobuf.Timestamp
	4, // 2: yandex.cloud.video.v1.Channel.labels:type_name -> yandex.cloud.video.v1.Channel.LabelsEntry
	1, // 3: yandex.cloud.video.v1.Channel.settings:type_name -> yandex.cloud.video.v1.ChannelSettings
	2, // 4: yandex.cloud.video.v1.ChannelSettings.advertisement:type_name -> yandex.cloud.video.v1.AdvertisementSettings
	3, // 5: yandex.cloud.video.v1.ChannelSettings.referer_verification:type_name -> yandex.cloud.video.v1.RefererVerificationSettings
	5, // 6: yandex.cloud.video.v1.AdvertisementSettings.yandex_direct:type_name -> yandex.cloud.video.v1.AdvertisementSettings.YandexDirect
	7, // [7:7] is the sub-list for method output_type
	7, // [7:7] is the sub-list for method input_type
	7, // [7:7] is the sub-list for extension type_name
	7, // [7:7] is the sub-list for extension extendee
	0, // [0:7] is the sub-list for field type_name
}

func init() { file_yandex_cloud_video_v1_channel_proto_init() }
func file_yandex_cloud_video_v1_channel_proto_init() {
	if File_yandex_cloud_video_v1_channel_proto != nil {
		return
	}
	file_yandex_cloud_video_v1_channel_proto_msgTypes[2].OneofWrappers = []any{
		(*AdvertisementSettings_YandexDirect_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_yandex_cloud_video_v1_channel_proto_rawDesc), len(file_yandex_cloud_video_v1_channel_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   6,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_yandex_cloud_video_v1_channel_proto_goTypes,
		DependencyIndexes: file_yandex_cloud_video_v1_channel_proto_depIdxs,
		MessageInfos:      file_yandex_cloud_video_v1_channel_proto_msgTypes,
	}.Build()
	File_yandex_cloud_video_v1_channel_proto = out.File
	file_yandex_cloud_video_v1_channel_proto_goTypes = nil
	file_yandex_cloud_video_v1_channel_proto_depIdxs = nil
}
