// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.11
// 	protoc        v3.21.12
// source: yandex/cloud/video/v1/stream.proto

package video

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Current status of the stream.
type Stream_StreamStatus int32

const (
	// The stream status is not specified.
	Stream_STREAM_STATUS_UNSPECIFIED Stream_StreamStatus = 0
	// The stream is offline and not broadcasting.
	Stream_OFFLINE Stream_StreamStatus = 1
	// The system is preparing the infrastructure for receiving the video signal.
	Stream_PREPARING Stream_StreamStatus = 2
	// The infrastructure is ready to launch the stream.
	Stream_READY Stream_StreamStatus = 3
	// The stream is currently broadcasting live.
	Stream_ONAIR Stream_StreamStatus = 4
	// The stream has completed and is no longer broadcasting.
	Stream_FINISHED Stream_StreamStatus = 5
)

// Enum value maps for Stream_StreamStatus.
var (
	Stream_StreamStatus_name = map[int32]string{
		0: "STREAM_STATUS_UNSPECIFIED",
		1: "OFFLINE",
		2: "PREPARING",
		3: "READY",
		4: "ONAIR",
		5: "FINISHED",
	}
	Stream_StreamStatus_value = map[string]int32{
		"STREAM_STATUS_UNSPECIFIED": 0,
		"OFFLINE":                   1,
		"PREPARING":                 2,
		"READY":                     3,
		"ONAIR":                     4,
		"FINISHED":                  5,
	}
)

func (x Stream_StreamStatus) Enum() *Stream_StreamStatus {
	p := new(Stream_StreamStatus)
	*p = x
	return p
}

func (x Stream_StreamStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Stream_StreamStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_video_v1_stream_proto_enumTypes[0].Descriptor()
}

func (Stream_StreamStatus) Type() protoreflect.EnumType {
	return &file_yandex_cloud_video_v1_stream_proto_enumTypes[0]
}

func (x Stream_StreamStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Stream_StreamStatus.Descriptor instead.
func (Stream_StreamStatus) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_video_v1_stream_proto_rawDescGZIP(), []int{0, 0}
}

// Entity representing a live video stream.
// A stream is a real-time video broadcast linked to a specific stream line.
type Stream struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Unique identifier of the stream.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Identifier of the channel where the stream is created and managed.
	ChannelId string `protobuf:"bytes,2,opt,name=channel_id,json=channelId,proto3" json:"channel_id,omitempty"`
	// Identifier of the stream line to which this stream is linked.
	LineId string `protobuf:"bytes,3,opt,name=line_id,json=lineId,proto3" json:"line_id,omitempty"`
	// Title of the stream displayed in interfaces and players.
	Title string `protobuf:"bytes,4,opt,name=title,proto3" json:"title,omitempty"`
	// Detailed description of the stream content and context.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Identifier of the thumbnail image used to represent the stream visually.
	ThumbnailId string `protobuf:"bytes,6,opt,name=thumbnail_id,json=thumbnailId,proto3" json:"thumbnail_id,omitempty"`
	// Current status of the stream.
	Status Stream_StreamStatus `protobuf:"varint,8,opt,name=status,proto3,enum=yandex.cloud.video.v1.Stream_StreamStatus" json:"status,omitempty"`
	// Timestamp when the stream was initiated.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Timestamp when the stream was published (switched to ONAIR status).
	PublishTime *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=publish_time,json=publishTime,proto3" json:"publish_time,omitempty"`
	// Timestamp when the stream was completed.
	FinishTime *timestamppb.Timestamp `protobuf:"bytes,11,opt,name=finish_time,json=finishTime,proto3" json:"finish_time,omitempty"`
	// Controls automatic publishing of the stream when it's ready.
	// When set to true, automatically switches status from READY to ONAIR.
	AutoPublish *wrapperspb.BoolValue `protobuf:"bytes,12,opt,name=auto_publish,json=autoPublish,proto3" json:"auto_publish,omitempty"`
	// Specifies the stream scheduling type.
	//
	// Types that are valid to be assigned to StreamType:
	//
	//	*Stream_OnDemand
	//	*Stream_Schedule
	StreamType isStream_StreamType `protobuf_oneof:"stream_type"`
	// Timestamp when the stream was initially created in the system.
	CreatedAt *timestamppb.Timestamp `protobuf:"bytes,100,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Timestamp of the last modification to the stream or its metadata.
	UpdatedAt *timestamppb.Timestamp `protobuf:"bytes,101,opt,name=updated_at,json=updatedAt,proto3" json:"updated_at,omitempty"`
	// Custom user-defined labels as `key:value` pairs.
	// Maximum 64 labels per stream.
	// Used for organization, filtering, and metadata purposes.
	// Labels can be used for organization, filtering, and metadata purposes.
	Labels        map[string]string `protobuf:"bytes,200,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Stream) Reset() {
	*x = Stream{}
	mi := &file_yandex_cloud_video_v1_stream_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Stream) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Stream) ProtoMessage() {}

func (x *Stream) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_video_v1_stream_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Stream.ProtoReflect.Descriptor instead.
func (*Stream) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_video_v1_stream_proto_rawDescGZIP(), []int{0}
}

func (x *Stream) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Stream) GetChannelId() string {
	if x != nil {
		return x.ChannelId
	}
	return ""
}

func (x *Stream) GetLineId() string {
	if x != nil {
		return x.LineId
	}
	return ""
}

func (x *Stream) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *Stream) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Stream) GetThumbnailId() string {
	if x != nil {
		return x.ThumbnailId
	}
	return ""
}

func (x *Stream) GetStatus() Stream_StreamStatus {
	if x != nil {
		return x.Status
	}
	return Stream_STREAM_STATUS_UNSPECIFIED
}

func (x *Stream) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *Stream) GetPublishTime() *timestamppb.Timestamp {
	if x != nil {
		return x.PublishTime
	}
	return nil
}

func (x *Stream) GetFinishTime() *timestamppb.Timestamp {
	if x != nil {
		return x.FinishTime
	}
	return nil
}

func (x *Stream) GetAutoPublish() *wrapperspb.BoolValue {
	if x != nil {
		return x.AutoPublish
	}
	return nil
}

func (x *Stream) GetStreamType() isStream_StreamType {
	if x != nil {
		return x.StreamType
	}
	return nil
}

func (x *Stream) GetOnDemand() *OnDemand {
	if x != nil {
		if x, ok := x.StreamType.(*Stream_OnDemand); ok {
			return x.OnDemand
		}
	}
	return nil
}

func (x *Stream) GetSchedule() *Schedule {
	if x != nil {
		if x, ok := x.StreamType.(*Stream_Schedule); ok {
			return x.Schedule
		}
	}
	return nil
}

func (x *Stream) GetCreatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.CreatedAt
	}
	return nil
}

func (x *Stream) GetUpdatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdatedAt
	}
	return nil
}

func (x *Stream) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

type isStream_StreamType interface {
	isStream_StreamType()
}

type Stream_OnDemand struct {
	// On-demand stream starts immediately when a video signal appears.
	OnDemand *OnDemand `protobuf:"bytes,1000,opt,name=on_demand,json=onDemand,proto3,oneof"`
}

type Stream_Schedule struct {
	// Scheduled stream starts and finishes at specified time.
	Schedule *Schedule `protobuf:"bytes,1001,opt,name=schedule,proto3,oneof"`
}

func (*Stream_OnDemand) isStream_StreamType() {}

func (*Stream_Schedule) isStream_StreamType() {}

// Represents an on-demand stream type.
// This type of stream must be started and finished explicitly by the user.
// It begins broadcasting immediately when a video signal is detected.
type OnDemand struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OnDemand) Reset() {
	*x = OnDemand{}
	mi := &file_yandex_cloud_video_v1_stream_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OnDemand) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OnDemand) ProtoMessage() {}

func (x *OnDemand) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_video_v1_stream_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OnDemand.ProtoReflect.Descriptor instead.
func (*OnDemand) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_video_v1_stream_proto_rawDescGZIP(), []int{1}
}

// Represents a scheduled stream type.
// This type of stream starts and finishes automatically at specified time.
type Schedule struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Scheduled time when the stream should automatically start.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Scheduled time when the stream should automatically finish.
	FinishTime    *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=finish_time,json=finishTime,proto3" json:"finish_time,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Schedule) Reset() {
	*x = Schedule{}
	mi := &file_yandex_cloud_video_v1_stream_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Schedule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Schedule) ProtoMessage() {}

func (x *Schedule) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_video_v1_stream_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Schedule.ProtoReflect.Descriptor instead.
func (*Schedule) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_video_v1_stream_proto_rawDescGZIP(), []int{2}
}

func (x *Schedule) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *Schedule) GetFinishTime() *timestamppb.Timestamp {
	if x != nil {
		return x.FinishTime
	}
	return nil
}

var File_yandex_cloud_video_v1_stream_proto protoreflect.FileDescriptor

const file_yandex_cloud_video_v1_stream_proto_rawDesc = "" +
	"\n" +
	"\"yandex/cloud/video/v1/stream.proto\x12\x15yandex.cloud.video.v1\x1a\x1fgoogle/protobuf/timestamp.proto\x1a\x1egoogle/protobuf/wrappers.proto\"\xf4\a\n" +
	"\x06Stream\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\tR\x02id\x12\x1d\n" +
	"\n" +
	"channel_id\x18\x02 \x01(\tR\tchannelId\x12\x17\n" +
	"\aline_id\x18\x03 \x01(\tR\x06lineId\x12\x14\n" +
	"\x05title\x18\x04 \x01(\tR\x05title\x12 \n" +
	"\vdescription\x18\x05 \x01(\tR\vdescription\x12!\n" +
	"\fthumbnail_id\x18\x06 \x01(\tR\vthumbnailId\x12B\n" +
	"\x06status\x18\b \x01(\x0e2*.yandex.cloud.video.v1.Stream.StreamStatusR\x06status\x129\n" +
	"\n" +
	"start_time\x18\t \x01(\v2\x1a.google.protobuf.TimestampR\tstartTime\x12=\n" +
	"\fpublish_time\x18\n" +
	" \x01(\v2\x1a.google.protobuf.TimestampR\vpublishTime\x12;\n" +
	"\vfinish_time\x18\v \x01(\v2\x1a.google.protobuf.TimestampR\n" +
	"finishTime\x12=\n" +
	"\fauto_publish\x18\f \x01(\v2\x1a.google.protobuf.BoolValueR\vautoPublish\x12?\n" +
	"\ton_demand\x18\xe8\a \x01(\v2\x1f.yandex.cloud.video.v1.OnDemandH\x00R\bonDemand\x12>\n" +
	"\bschedule\x18\xe9\a \x01(\v2\x1f.yandex.cloud.video.v1.ScheduleH\x00R\bschedule\x129\n" +
	"\n" +
	"created_at\x18d \x01(\v2\x1a.google.protobuf.TimestampR\tcreatedAt\x129\n" +
	"\n" +
	"updated_at\x18e \x01(\v2\x1a.google.protobuf.TimestampR\tupdatedAt\x12B\n" +
	"\x06labels\x18\xc8\x01 \x03(\v2).yandex.cloud.video.v1.Stream.LabelsEntryR\x06labels\x1a9\n" +
	"\vLabelsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\"m\n" +
	"\fStreamStatus\x12\x1d\n" +
	"\x19STREAM_STATUS_UNSPECIFIED\x10\x00\x12\v\n" +
	"\aOFFLINE\x10\x01\x12\r\n" +
	"\tPREPARING\x10\x02\x12\t\n" +
	"\x05READY\x10\x03\x12\t\n" +
	"\x05ONAIR\x10\x04\x12\f\n" +
	"\bFINISHED\x10\x05B\r\n" +
	"\vstream_typeJ\x04\b\a\x10\bJ\x04\b\r\x10dJ\x05\bf\x10\xc8\x01J\x06\b\xc9\x01\x10\xe8\a\"\n" +
	"\n" +
	"\bOnDemand\"\x82\x01\n" +
	"\bSchedule\x129\n" +
	"\n" +
	"start_time\x18\x01 \x01(\v2\x1a.google.protobuf.TimestampR\tstartTime\x12;\n" +
	"\vfinish_time\x18\x02 \x01(\v2\x1a.google.protobuf.TimestampR\n" +
	"finishTimeB\\\n" +
	"\x19yandex.cloud.api.video.v1Z?github.com/yandex-cloud/go-genproto/yandex/cloud/video/v1;videob\x06proto3"

var (
	file_yandex_cloud_video_v1_stream_proto_rawDescOnce sync.Once
	file_yandex_cloud_video_v1_stream_proto_rawDescData []byte
)

func file_yandex_cloud_video_v1_stream_proto_rawDescGZIP() []byte {
	file_yandex_cloud_video_v1_stream_proto_rawDescOnce.Do(func() {
		file_yandex_cloud_video_v1_stream_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_yandex_cloud_video_v1_stream_proto_rawDesc), len(file_yandex_cloud_video_v1_stream_proto_rawDesc)))
	})
	return file_yandex_cloud_video_v1_stream_proto_rawDescData
}

var file_yandex_cloud_video_v1_stream_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_yandex_cloud_video_v1_stream_proto_msgTypes = make([]protoimpl.MessageInfo, 4)
var file_yandex_cloud_video_v1_stream_proto_goTypes = []any{
	(Stream_StreamStatus)(0),      // 0: yandex.cloud.video.v1.Stream.StreamStatus
	(*Stream)(nil),                // 1: yandex.cloud.video.v1.Stream
	(*OnDemand)(nil),              // 2: yandex.cloud.video.v1.OnDemand
	(*Schedule)(nil),              // 3: yandex.cloud.video.v1.Schedule
	nil,                           // 4: yandex.cloud.video.v1.Stream.LabelsEntry
	(*timestamppb.Timestamp)(nil), // 5: google.protobuf.Timestamp
	(*wrapperspb.BoolValue)(nil),  // 6: google.protobuf.BoolValue
}
var file_yandex_cloud_video_v1_stream_proto_depIdxs = []int32{
	0,  // 0: yandex.cloud.video.v1.Stream.status:type_name -> yandex.cloud.video.v1.Stream.StreamStatus
	5,  // 1: yandex.cloud.video.v1.Stream.start_time:type_name -> google.protobuf.Timestamp
	5,  // 2: yandex.cloud.video.v1.Stream.publish_time:type_name -> google.protobuf.Timestamp
	5,  // 3: yandex.cloud.video.v1.Stream.finish_time:type_name -> google.protobuf.Timestamp
	6,  // 4: yandex.cloud.video.v1.Stream.auto_publish:type_name -> google.protobuf.BoolValue
	2,  // 5: yandex.cloud.video.v1.Stream.on_demand:type_name -> yandex.cloud.video.v1.OnDemand
	3,  // 6: yandex.cloud.video.v1.Stream.schedule:type_name -> yandex.cloud.video.v1.Schedule
	5,  // 7: yandex.cloud.video.v1.Stream.created_at:type_name -> google.protobuf.Timestamp
	5,  // 8: yandex.cloud.video.v1.Stream.updated_at:type_name -> google.protobuf.Timestamp
	4,  // 9: yandex.cloud.video.v1.Stream.labels:type_name -> yandex.cloud.video.v1.Stream.LabelsEntry
	5,  // 10: yandex.cloud.video.v1.Schedule.start_time:type_name -> google.protobuf.Timestamp
	5,  // 11: yandex.cloud.video.v1.Schedule.finish_time:type_name -> google.protobuf.Timestamp
	12, // [12:12] is the sub-list for method output_type
	12, // [12:12] is the sub-list for method input_type
	12, // [12:12] is the sub-list for extension type_name
	12, // [12:12] is the sub-list for extension extendee
	0,  // [0:12] is the sub-list for field type_name
}

func init() { file_yandex_cloud_video_v1_stream_proto_init() }
func file_yandex_cloud_video_v1_stream_proto_init() {
	if File_yandex_cloud_video_v1_stream_proto != nil {
		return
	}
	file_yandex_cloud_video_v1_stream_proto_msgTypes[0].OneofWrappers = []any{
		(*Stream_OnDemand)(nil),
		(*Stream_Schedule)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_yandex_cloud_video_v1_stream_proto_rawDesc), len(file_yandex_cloud_video_v1_stream_proto_rawDesc)),
			NumEnums:      1,
			NumMessages:   4,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_yandex_cloud_video_v1_stream_proto_goTypes,
		DependencyIndexes: file_yandex_cloud_video_v1_stream_proto_depIdxs,
		EnumInfos:         file_yandex_cloud_video_v1_stream_proto_enumTypes,
		MessageInfos:      file_yandex_cloud_video_v1_stream_proto_msgTypes,
	}.Build()
	File_yandex_cloud_video_v1_stream_proto = out.File
	file_yandex_cloud_video_v1_stream_proto_goTypes = nil
	file_yandex_cloud_video_v1_stream_proto_depIdxs = nil
}
