# Community Projects

The following is a list of notable community-driven projects in the ecosystem related to the MCP Registry.

## Featured Projects

### Browsers 🔎

Browse the official MCP Registry in your browser!

- [MCP Bench](https://mcpbench.ai/)🔎 - Explore the MCP registry with richer filters, community stars, and LLM-generated classification tags.
- [MCP Registry Database](https://lite.datasette.io/?url=https%3A%2F%2Fraw.githubusercontent.com%2Frosmur%2Fofficial-mcp-registry-database%2Fmain%2Fofficial_mcp_registry.db#/official_mcp_registry/servers)🔎 - A minimal, web browsable, live database of the official MCP Registry [source code](https://github.com/rosmur/official-mcp-registry-database).
- [TeamSpark AI Server Registry](https://teamsparkai.github.io/ToolCatalog/registry)🔎 - Browse and discover servers from the official MCP Registry ([source code](https://github.com/TeamSparkAI/ToolCatalog)).

### MCP Registry Clients

- [REST API](modelcontextprotocol-io/registry-aggregators.mdx) - HTTP API
- [go-mcp-registry](https://github.com/leefowlercu/go-mcp-registry) - Go SDK
- [mcp-registry-spec-sdk](https://www.npmjs.com/package/mcp-registry-spec-sdk) - TypeScript client for the MCP Registry
- [LangChain4j MCP Registry Java client](https://docs.langchain4j.dev/tutorials/mcp/#mcp-registry-client) - Java API 

### Other

- [MCP Registry Cheat Sheet](https://github.com/subbyte/mcp-registry-cheatsheet) - MCP Registry Cheat Sheet for MCP server developers, client developers, and registry admin
- [MCP Registry Remote MCP Server](https://github.com/jaw9c/mcp-registry-mcp) - Open Remote MCP server for the Registry at `https://registry-mcp.remote-mcp.com`
- [MCP Server for MCP Registry](https://github.com/formulahendry/mcp-server-mcp-registry) - MCP Server to discover and search for available MCP servers in the registry
- [mcp-insights](https://github.com/joelverhagen/mcp-insights/) - Analytics and insights for the MCP Registry
- [mcp-registry-cli](https://pypi.org/project/mcp-registry-cli/) - CLI tool to navigate the MCP registry servers
- [OtherVibes/mcp-publish-action](https://github.com/OtherVibes/mcp-publish-action) - GitHub Action for publishing MCP servers to the official registry
- [ToolSDK MCP Registry](https://github.com/toolsdk-ai/toolsdk-mcp-registry) - Extends the MCP Registry with **API-based MCP execution, private deployment**, and **secure sandbox isolation**.

## Adding Your Project

To add your community project, submit a pull request adding a one-line entry above with format: `[project-name](link) - brief description`

## Disclaimer

This is not an exhaustive list, and inclusion does not imply endorsement. Projects are maintained by third parties and may not be actively
supported, secure, or compatible with the latest MCP Registry version.
Please review each project independently and use at your own risk!
