// +build go1.9

// Copyright 2019 Microsoft Corporation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package hdinsight

import original "github.com/Azure/azure-sdk-for-go/services/preview/hdinsight/2018-11-01-preview/hdinsight"

type ApplicationState = original.ApplicationState

const (
	ACCEPTED  ApplicationState = original.ACCEPTED
	FAILED    ApplicationState = original.FAILED
	FINISHED  ApplicationState = original.FINISHED
	FINISHING ApplicationState = original.FINISHING
	KILLED    ApplicationState = original.KILLED
	NEW       ApplicationState = original.NEW
	NEWSAVING ApplicationState = original.NEWSAVING
	RUNNING   ApplicationState = original.RUNNING
	SUBMITTED ApplicationState = original.SUBMITTED
)

type AppState = original.AppState
type BaseClient = original.BaseClient
type JobClient = original.JobClient
type JobDetailRootJSONObject = original.JobDetailRootJSONObject
type JobID = original.JobID
type JobListJSONObject = original.JobListJSONObject
type JobOperationsErrorResponse = original.JobOperationsErrorResponse
type JobSubmissionJSONResponse = original.JobSubmissionJSONResponse
type ListJobListJSONObject = original.ListJobListJSONObject
type Profile = original.Profile
type Status = original.Status
type Userargs = original.Userargs

func New(clusterDNSName string, userName string) BaseClient {
	return original.New(clusterDNSName, userName)
}
func NewJobClient(clusterDNSName string, userName string) JobClient {
	return original.NewJobClient(clusterDNSName, userName)
}
func NewWithoutDefaults(clusterDNSName string, userName string) BaseClient {
	return original.NewWithoutDefaults(clusterDNSName, userName)
}
func PossibleApplicationStateValues() []ApplicationState {
	return original.PossibleApplicationStateValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
