// +build go1.9

// Copyright 2019 Microsoft Corporation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package personalizer

import original "github.com/Azure/azure-sdk-for-go/services/preview/personalizer/v1.0/personalizer"

type ErrorCode = original.ErrorCode

const (
	BadRequest          ErrorCode = original.BadRequest
	InternalServerError ErrorCode = original.InternalServerError
	ResourceNotFound    ErrorCode = original.ResourceNotFound
)

type BaseClient = original.BaseClient
type Error = original.Error
type ErrorResponse = original.ErrorResponse
type EventsClient = original.EventsClient
type InternalError = original.InternalError
type RankRequest = original.RankRequest
type RankResponse = original.RankResponse
type RankableAction = original.RankableAction
type RankedAction = original.RankedAction
type RewardRequest = original.RewardRequest

func New(endpoint string) BaseClient {
	return original.New(endpoint)
}
func NewEventsClient(endpoint string) EventsClient {
	return original.NewEventsClient(endpoint)
}
func NewWithoutDefaults(endpoint string) BaseClient {
	return original.NewWithoutDefaults(endpoint)
}
func PossibleErrorCodeValues() []ErrorCode {
	return original.PossibleErrorCodeValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
