// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/resourcemanager/v3/folders.proto

package resourcemanagerpb

import (
	iampb "cloud.google.com/go/iam/apiv1/iampb"
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	Folders_GetFolder_FullMethodName          = "/google.cloud.resourcemanager.v3.Folders/GetFolder"
	Folders_ListFolders_FullMethodName        = "/google.cloud.resourcemanager.v3.Folders/ListFolders"
	Folders_SearchFolders_FullMethodName      = "/google.cloud.resourcemanager.v3.Folders/SearchFolders"
	Folders_CreateFolder_FullMethodName       = "/google.cloud.resourcemanager.v3.Folders/CreateFolder"
	Folders_UpdateFolder_FullMethodName       = "/google.cloud.resourcemanager.v3.Folders/UpdateFolder"
	Folders_MoveFolder_FullMethodName         = "/google.cloud.resourcemanager.v3.Folders/MoveFolder"
	Folders_DeleteFolder_FullMethodName       = "/google.cloud.resourcemanager.v3.Folders/DeleteFolder"
	Folders_UndeleteFolder_FullMethodName     = "/google.cloud.resourcemanager.v3.Folders/UndeleteFolder"
	Folders_GetIamPolicy_FullMethodName       = "/google.cloud.resourcemanager.v3.Folders/GetIamPolicy"
	Folders_SetIamPolicy_FullMethodName       = "/google.cloud.resourcemanager.v3.Folders/SetIamPolicy"
	Folders_TestIamPermissions_FullMethodName = "/google.cloud.resourcemanager.v3.Folders/TestIamPermissions"
)

// FoldersClient is the client API for Folders service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type FoldersClient interface {
	// Retrieves a folder identified by the supplied resource name.
	// Valid folder resource names have the format `folders/{folder_id}`
	// (for example, `folders/1234`).
	// The caller must have `resourcemanager.folders.get` permission on the
	// identified folder.
	GetFolder(ctx context.Context, in *GetFolderRequest, opts ...grpc.CallOption) (*Folder, error)
	// Lists the folders that are direct descendants of supplied parent resource.
	// `list()` provides a strongly consistent view of the folders underneath
	// the specified parent resource.
	// `list()` returns folders sorted based upon the (ascending) lexical ordering
	// of their display_name.
	// The caller must have `resourcemanager.folders.list` permission on the
	// identified parent.
	ListFolders(ctx context.Context, in *ListFoldersRequest, opts ...grpc.CallOption) (*ListFoldersResponse, error)
	// Search for folders that match specific filter criteria.
	// `search()` provides an eventually consistent view of the folders a user has
	// access to which meet the specified filter criteria.
	//
	// This will only return folders on which the caller has the
	// permission `resourcemanager.folders.get`.
	SearchFolders(ctx context.Context, in *SearchFoldersRequest, opts ...grpc.CallOption) (*SearchFoldersResponse, error)
	// Creates a folder in the resource hierarchy.
	// Returns an `Operation` which can be used to track the progress of the
	// folder creation workflow.
	// Upon success, the `Operation.response` field will be populated with the
	// created Folder.
	//
	// In order to succeed, the addition of this new folder must not violate
	// the folder naming, height, or fanout constraints.
	//
	// + The folder's `display_name` must be distinct from all other folders that
	// share its parent.
	// + The addition of the folder must not cause the active folder hierarchy
	// to exceed a height of 10. Note, the full active + deleted folder hierarchy
	// is allowed to reach a height of 20; this provides additional headroom when
	// moving folders that contain deleted folders.
	// + The addition of the folder must not cause the total number of folders
	// under its parent to exceed 300.
	//
	// If the operation fails due to a folder constraint violation, some errors
	// may be returned by the `CreateFolder` request, with status code
	// `FAILED_PRECONDITION` and an error description. Other folder constraint
	// violations will be communicated in the `Operation`, with the specific
	// `PreconditionFailure` returned in the details list in the `Operation.error`
	// field.
	//
	// The caller must have `resourcemanager.folders.create` permission on the
	// identified parent.
	CreateFolder(ctx context.Context, in *CreateFolderRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates a folder, changing its `display_name`.
	// Changes to the folder `display_name` will be rejected if they violate
	// either the `display_name` formatting rules or the naming constraints
	// described in the
	// [CreateFolder][google.cloud.resourcemanager.v3.Folders.CreateFolder]
	// documentation.
	//
	// The folder's `display_name` must start and end with a letter or digit,
	// may contain letters, digits, spaces, hyphens and underscores and can be
	// between 3 and 30 characters. This is captured by the regular expression:
	// `[\p{L}\p{N}][\p{L}\p{N}_- ]{1,28}[\p{L}\p{N}]`.
	// The caller must have `resourcemanager.folders.update` permission on the
	// identified folder.
	//
	// If the update fails due to the unique name constraint then a
	// `PreconditionFailure` explaining this violation will be returned
	// in the Status.details field.
	UpdateFolder(ctx context.Context, in *UpdateFolderRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Moves a folder under a new resource parent.
	// Returns an `Operation` which can be used to track the progress of the
	// folder move workflow.
	// Upon success, the `Operation.response` field will be populated with the
	// moved folder.
	// Upon failure, a `FolderOperationError` categorizing the failure cause will
	// be returned - if the failure occurs synchronously then the
	// `FolderOperationError` will be returned in the `Status.details` field.
	// If it occurs asynchronously, then the FolderOperation will be returned
	// in the `Operation.error` field.
	// In addition, the `Operation.metadata` field will be populated with a
	// `FolderOperation` message as an aid to stateless clients.
	// Folder moves will be rejected if they violate either the naming, height,
	// or fanout constraints described in the
	// [CreateFolder][google.cloud.resourcemanager.v3.Folders.CreateFolder]
	// documentation. The caller must have `resourcemanager.folders.move`
	// permission on the folder's current and proposed new parent.
	MoveFolder(ctx context.Context, in *MoveFolderRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Requests deletion of a folder. The folder is moved into the
	// [DELETE_REQUESTED][google.cloud.resourcemanager.v3.Folder.State.DELETE_REQUESTED]
	// state immediately, and is deleted approximately 30 days later. This method
	// may only be called on an empty folder, where a folder is empty if it
	// doesn't contain any folders or projects in the
	// [ACTIVE][google.cloud.resourcemanager.v3.Folder.State.ACTIVE] state. If
	// called on a folder in
	// [DELETE_REQUESTED][google.cloud.resourcemanager.v3.Folder.State.DELETE_REQUESTED]
	// state the operation will result in a no-op success.
	// The caller must have `resourcemanager.folders.delete` permission on the
	// identified folder.
	DeleteFolder(ctx context.Context, in *DeleteFolderRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Cancels the deletion request for a folder. This method may be called on a
	// folder in any state. If the folder is in the
	// [ACTIVE][google.cloud.resourcemanager.v3.Folder.State.ACTIVE] state the
	// result will be a no-op success. In order to succeed, the folder's parent
	// must be in the
	// [ACTIVE][google.cloud.resourcemanager.v3.Folder.State.ACTIVE] state. In
	// addition, reintroducing the folder into the tree must not violate folder
	// naming, height, and fanout constraints described in the
	// [CreateFolder][google.cloud.resourcemanager.v3.Folders.CreateFolder]
	// documentation. The caller must have `resourcemanager.folders.undelete`
	// permission on the identified folder.
	UndeleteFolder(ctx context.Context, in *UndeleteFolderRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets the access control policy for a folder. The returned policy may be
	// empty if no such policy or resource exists. The `resource` field should
	// be the folder's resource name, for example: "folders/1234".
	// The caller must have `resourcemanager.folders.getIamPolicy` permission
	// on the identified folder.
	GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Sets the access control policy on a folder, replacing any existing policy.
	// The `resource` field should be the folder's resource name, for example:
	// "folders/1234".
	// The caller must have `resourcemanager.folders.setIamPolicy` permission
	// on the identified folder.
	SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Returns permissions that a caller has on the specified folder.
	// The `resource` field should be the folder's resource name,
	// for example: "folders/1234".
	//
	// There are no permissions required for making this API call.
	TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error)
}

type foldersClient struct {
	cc grpc.ClientConnInterface
}

func NewFoldersClient(cc grpc.ClientConnInterface) FoldersClient {
	return &foldersClient{cc}
}

func (c *foldersClient) GetFolder(ctx context.Context, in *GetFolderRequest, opts ...grpc.CallOption) (*Folder, error) {
	out := new(Folder)
	err := c.cc.Invoke(ctx, Folders_GetFolder_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *foldersClient) ListFolders(ctx context.Context, in *ListFoldersRequest, opts ...grpc.CallOption) (*ListFoldersResponse, error) {
	out := new(ListFoldersResponse)
	err := c.cc.Invoke(ctx, Folders_ListFolders_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *foldersClient) SearchFolders(ctx context.Context, in *SearchFoldersRequest, opts ...grpc.CallOption) (*SearchFoldersResponse, error) {
	out := new(SearchFoldersResponse)
	err := c.cc.Invoke(ctx, Folders_SearchFolders_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *foldersClient) CreateFolder(ctx context.Context, in *CreateFolderRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Folders_CreateFolder_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *foldersClient) UpdateFolder(ctx context.Context, in *UpdateFolderRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Folders_UpdateFolder_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *foldersClient) MoveFolder(ctx context.Context, in *MoveFolderRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Folders_MoveFolder_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *foldersClient) DeleteFolder(ctx context.Context, in *DeleteFolderRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Folders_DeleteFolder_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *foldersClient) UndeleteFolder(ctx context.Context, in *UndeleteFolderRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Folders_UndeleteFolder_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *foldersClient) GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, Folders_GetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *foldersClient) SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, Folders_SetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *foldersClient) TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error) {
	out := new(iampb.TestIamPermissionsResponse)
	err := c.cc.Invoke(ctx, Folders_TestIamPermissions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// FoldersServer is the server API for Folders service.
// All implementations should embed UnimplementedFoldersServer
// for forward compatibility
type FoldersServer interface {
	// Retrieves a folder identified by the supplied resource name.
	// Valid folder resource names have the format `folders/{folder_id}`
	// (for example, `folders/1234`).
	// The caller must have `resourcemanager.folders.get` permission on the
	// identified folder.
	GetFolder(context.Context, *GetFolderRequest) (*Folder, error)
	// Lists the folders that are direct descendants of supplied parent resource.
	// `list()` provides a strongly consistent view of the folders underneath
	// the specified parent resource.
	// `list()` returns folders sorted based upon the (ascending) lexical ordering
	// of their display_name.
	// The caller must have `resourcemanager.folders.list` permission on the
	// identified parent.
	ListFolders(context.Context, *ListFoldersRequest) (*ListFoldersResponse, error)
	// Search for folders that match specific filter criteria.
	// `search()` provides an eventually consistent view of the folders a user has
	// access to which meet the specified filter criteria.
	//
	// This will only return folders on which the caller has the
	// permission `resourcemanager.folders.get`.
	SearchFolders(context.Context, *SearchFoldersRequest) (*SearchFoldersResponse, error)
	// Creates a folder in the resource hierarchy.
	// Returns an `Operation` which can be used to track the progress of the
	// folder creation workflow.
	// Upon success, the `Operation.response` field will be populated with the
	// created Folder.
	//
	// In order to succeed, the addition of this new folder must not violate
	// the folder naming, height, or fanout constraints.
	//
	// + The folder's `display_name` must be distinct from all other folders that
	// share its parent.
	// + The addition of the folder must not cause the active folder hierarchy
	// to exceed a height of 10. Note, the full active + deleted folder hierarchy
	// is allowed to reach a height of 20; this provides additional headroom when
	// moving folders that contain deleted folders.
	// + The addition of the folder must not cause the total number of folders
	// under its parent to exceed 300.
	//
	// If the operation fails due to a folder constraint violation, some errors
	// may be returned by the `CreateFolder` request, with status code
	// `FAILED_PRECONDITION` and an error description. Other folder constraint
	// violations will be communicated in the `Operation`, with the specific
	// `PreconditionFailure` returned in the details list in the `Operation.error`
	// field.
	//
	// The caller must have `resourcemanager.folders.create` permission on the
	// identified parent.
	CreateFolder(context.Context, *CreateFolderRequest) (*longrunningpb.Operation, error)
	// Updates a folder, changing its `display_name`.
	// Changes to the folder `display_name` will be rejected if they violate
	// either the `display_name` formatting rules or the naming constraints
	// described in the
	// [CreateFolder][google.cloud.resourcemanager.v3.Folders.CreateFolder]
	// documentation.
	//
	// The folder's `display_name` must start and end with a letter or digit,
	// may contain letters, digits, spaces, hyphens and underscores and can be
	// between 3 and 30 characters. This is captured by the regular expression:
	// `[\p{L}\p{N}][\p{L}\p{N}_- ]{1,28}[\p{L}\p{N}]`.
	// The caller must have `resourcemanager.folders.update` permission on the
	// identified folder.
	//
	// If the update fails due to the unique name constraint then a
	// `PreconditionFailure` explaining this violation will be returned
	// in the Status.details field.
	UpdateFolder(context.Context, *UpdateFolderRequest) (*longrunningpb.Operation, error)
	// Moves a folder under a new resource parent.
	// Returns an `Operation` which can be used to track the progress of the
	// folder move workflow.
	// Upon success, the `Operation.response` field will be populated with the
	// moved folder.
	// Upon failure, a `FolderOperationError` categorizing the failure cause will
	// be returned - if the failure occurs synchronously then the
	// `FolderOperationError` will be returned in the `Status.details` field.
	// If it occurs asynchronously, then the FolderOperation will be returned
	// in the `Operation.error` field.
	// In addition, the `Operation.metadata` field will be populated with a
	// `FolderOperation` message as an aid to stateless clients.
	// Folder moves will be rejected if they violate either the naming, height,
	// or fanout constraints described in the
	// [CreateFolder][google.cloud.resourcemanager.v3.Folders.CreateFolder]
	// documentation. The caller must have `resourcemanager.folders.move`
	// permission on the folder's current and proposed new parent.
	MoveFolder(context.Context, *MoveFolderRequest) (*longrunningpb.Operation, error)
	// Requests deletion of a folder. The folder is moved into the
	// [DELETE_REQUESTED][google.cloud.resourcemanager.v3.Folder.State.DELETE_REQUESTED]
	// state immediately, and is deleted approximately 30 days later. This method
	// may only be called on an empty folder, where a folder is empty if it
	// doesn't contain any folders or projects in the
	// [ACTIVE][google.cloud.resourcemanager.v3.Folder.State.ACTIVE] state. If
	// called on a folder in
	// [DELETE_REQUESTED][google.cloud.resourcemanager.v3.Folder.State.DELETE_REQUESTED]
	// state the operation will result in a no-op success.
	// The caller must have `resourcemanager.folders.delete` permission on the
	// identified folder.
	DeleteFolder(context.Context, *DeleteFolderRequest) (*longrunningpb.Operation, error)
	// Cancels the deletion request for a folder. This method may be called on a
	// folder in any state. If the folder is in the
	// [ACTIVE][google.cloud.resourcemanager.v3.Folder.State.ACTIVE] state the
	// result will be a no-op success. In order to succeed, the folder's parent
	// must be in the
	// [ACTIVE][google.cloud.resourcemanager.v3.Folder.State.ACTIVE] state. In
	// addition, reintroducing the folder into the tree must not violate folder
	// naming, height, and fanout constraints described in the
	// [CreateFolder][google.cloud.resourcemanager.v3.Folders.CreateFolder]
	// documentation. The caller must have `resourcemanager.folders.undelete`
	// permission on the identified folder.
	UndeleteFolder(context.Context, *UndeleteFolderRequest) (*longrunningpb.Operation, error)
	// Gets the access control policy for a folder. The returned policy may be
	// empty if no such policy or resource exists. The `resource` field should
	// be the folder's resource name, for example: "folders/1234".
	// The caller must have `resourcemanager.folders.getIamPolicy` permission
	// on the identified folder.
	GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error)
	// Sets the access control policy on a folder, replacing any existing policy.
	// The `resource` field should be the folder's resource name, for example:
	// "folders/1234".
	// The caller must have `resourcemanager.folders.setIamPolicy` permission
	// on the identified folder.
	SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error)
	// Returns permissions that a caller has on the specified folder.
	// The `resource` field should be the folder's resource name,
	// for example: "folders/1234".
	//
	// There are no permissions required for making this API call.
	TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error)
}

// UnimplementedFoldersServer should be embedded to have forward compatible implementations.
type UnimplementedFoldersServer struct {
}

func (UnimplementedFoldersServer) GetFolder(context.Context, *GetFolderRequest) (*Folder, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetFolder not implemented")
}
func (UnimplementedFoldersServer) ListFolders(context.Context, *ListFoldersRequest) (*ListFoldersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListFolders not implemented")
}
func (UnimplementedFoldersServer) SearchFolders(context.Context, *SearchFoldersRequest) (*SearchFoldersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchFolders not implemented")
}
func (UnimplementedFoldersServer) CreateFolder(context.Context, *CreateFolderRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateFolder not implemented")
}
func (UnimplementedFoldersServer) UpdateFolder(context.Context, *UpdateFolderRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateFolder not implemented")
}
func (UnimplementedFoldersServer) MoveFolder(context.Context, *MoveFolderRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MoveFolder not implemented")
}
func (UnimplementedFoldersServer) DeleteFolder(context.Context, *DeleteFolderRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteFolder not implemented")
}
func (UnimplementedFoldersServer) UndeleteFolder(context.Context, *UndeleteFolderRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UndeleteFolder not implemented")
}
func (UnimplementedFoldersServer) GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (UnimplementedFoldersServer) SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (UnimplementedFoldersServer) TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}

// UnsafeFoldersServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to FoldersServer will
// result in compilation errors.
type UnsafeFoldersServer interface {
	mustEmbedUnimplementedFoldersServer()
}

func RegisterFoldersServer(s grpc.ServiceRegistrar, srv FoldersServer) {
	s.RegisterService(&Folders_ServiceDesc, srv)
}

func _Folders_GetFolder_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFolderRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FoldersServer).GetFolder(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Folders_GetFolder_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FoldersServer).GetFolder(ctx, req.(*GetFolderRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Folders_ListFolders_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFoldersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FoldersServer).ListFolders(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Folders_ListFolders_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FoldersServer).ListFolders(ctx, req.(*ListFoldersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Folders_SearchFolders_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchFoldersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FoldersServer).SearchFolders(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Folders_SearchFolders_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FoldersServer).SearchFolders(ctx, req.(*SearchFoldersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Folders_CreateFolder_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateFolderRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FoldersServer).CreateFolder(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Folders_CreateFolder_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FoldersServer).CreateFolder(ctx, req.(*CreateFolderRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Folders_UpdateFolder_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateFolderRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FoldersServer).UpdateFolder(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Folders_UpdateFolder_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FoldersServer).UpdateFolder(ctx, req.(*UpdateFolderRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Folders_MoveFolder_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MoveFolderRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FoldersServer).MoveFolder(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Folders_MoveFolder_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FoldersServer).MoveFolder(ctx, req.(*MoveFolderRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Folders_DeleteFolder_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteFolderRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FoldersServer).DeleteFolder(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Folders_DeleteFolder_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FoldersServer).DeleteFolder(ctx, req.(*DeleteFolderRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Folders_UndeleteFolder_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UndeleteFolderRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FoldersServer).UndeleteFolder(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Folders_UndeleteFolder_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FoldersServer).UndeleteFolder(ctx, req.(*UndeleteFolderRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Folders_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FoldersServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Folders_GetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FoldersServer).GetIamPolicy(ctx, req.(*iampb.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Folders_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FoldersServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Folders_SetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FoldersServer).SetIamPolicy(ctx, req.(*iampb.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Folders_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FoldersServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Folders_TestIamPermissions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FoldersServer).TestIamPermissions(ctx, req.(*iampb.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Folders_ServiceDesc is the grpc.ServiceDesc for Folders service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Folders_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.resourcemanager.v3.Folders",
	HandlerType: (*FoldersServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetFolder",
			Handler:    _Folders_GetFolder_Handler,
		},
		{
			MethodName: "ListFolders",
			Handler:    _Folders_ListFolders_Handler,
		},
		{
			MethodName: "SearchFolders",
			Handler:    _Folders_SearchFolders_Handler,
		},
		{
			MethodName: "CreateFolder",
			Handler:    _Folders_CreateFolder_Handler,
		},
		{
			MethodName: "UpdateFolder",
			Handler:    _Folders_UpdateFolder_Handler,
		},
		{
			MethodName: "MoveFolder",
			Handler:    _Folders_MoveFolder_Handler,
		},
		{
			MethodName: "DeleteFolder",
			Handler:    _Folders_DeleteFolder_Handler,
		},
		{
			MethodName: "UndeleteFolder",
			Handler:    _Folders_UndeleteFolder_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _Folders_GetIamPolicy_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _Folders_SetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _Folders_TestIamPermissions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/resourcemanager/v3/folders.proto",
}
