/*
 * Subset of Influx API covered by Influx CLI
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * API version: 2.0.0
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package api

import (
	_context "context"
	_fmt "fmt"
	_io "io"
	_nethttp "net/http"
	_neturl "net/url"
	"strings"
)

// Linger please
var (
	_ _context.Context
)

type OrganizationsApi interface {

	/*
			 * DeleteOrgsID Delete an organization
			 * Deletes an organization.

		Deleting an organization from InfluxDB Cloud can't be undone.
		Once deleted, all data associated with the organization is removed.

		#### InfluxDB Cloud

		- Does the following when you send a delete request:

		  1. Validates the request and queues the delete.
		  2. Returns an HTTP `204` status code if queued; _error_ otherwise.
		  3. Handles the delete asynchronously.

		#### InfluxDB OSS

		- Validates the request, handles the delete synchronously,
		and then responds with success or failure.

		#### Limitations

		- Only one organization can be deleted per request.

		#### Related guides

		- [Delete organizations]({{% INFLUXDB_DOCS_URL %}}/organizations/delete-orgs/)

			 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
			 * @param orgID The ID of the organization to delete.
			 * @return ApiDeleteOrgsIDRequest
	*/
	DeleteOrgsID(ctx _context.Context, orgID string) ApiDeleteOrgsIDRequest

	/*
	 * DeleteOrgsIDExecute executes the request
	 */
	DeleteOrgsIDExecute(r ApiDeleteOrgsIDRequest) error

	/*
	 * DeleteOrgsIDExecuteWithHttpInfo executes the request with HTTP response info returned. The response body is not
	 * available on the returned HTTP response as it will have already been read and closed; access to the response body
	 * content should be achieved through the returned response model if applicable.
	 */
	DeleteOrgsIDExecuteWithHttpInfo(r ApiDeleteOrgsIDRequest) (*_nethttp.Response, error)

	/*
			 * DeleteOrgsIDMembersID Remove a member from an organization
			 * Removes a member from an organization.

		Use this endpoint to remove a user's member privileges from a bucket. This
		removes the user's `read` and `write` permissions from the organization.

		#### InfluxDB Cloud

		- Doesn't use `owner` and `member` roles.
		  Use [`/api/v2/authorizations`](#tag/Authorizations) to assign user permissions.

		#### Limitations

		- Member permissions are separate from API token permissions.
		- Member permissions are used in the context of the InfluxDB UI.

		#### Required permissions

		- `write-orgs INFLUX_ORG_ID`

		*`INFLUX_ORG_ID`* is the ID of the organization that you want to remove an
		owner from.

		#### Related guides

		- [Manage members]({{% INFLUXDB_DOCS_URL %}}/organizations/members/)

			 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
			 * @param userID The ID of the user to remove.
			 * @param orgID The ID of the organization to remove a user from.
			 * @return ApiDeleteOrgsIDMembersIDRequest
	*/
	DeleteOrgsIDMembersID(ctx _context.Context, userID string, orgID string) ApiDeleteOrgsIDMembersIDRequest

	/*
	 * DeleteOrgsIDMembersIDExecute executes the request
	 */
	DeleteOrgsIDMembersIDExecute(r ApiDeleteOrgsIDMembersIDRequest) error

	/*
	 * DeleteOrgsIDMembersIDExecuteWithHttpInfo executes the request with HTTP response info returned. The response body is not
	 * available on the returned HTTP response as it will have already been read and closed; access to the response body
	 * content should be achieved through the returned response model if applicable.
	 */
	DeleteOrgsIDMembersIDExecuteWithHttpInfo(r ApiDeleteOrgsIDMembersIDRequest) (*_nethttp.Response, error)

	/*
			 * DeleteOrgsIDOwnersID Remove an owner from an organization
			 * Removes an [owner]({{% INFLUXDB_DOCS_URL %}}/reference/glossary/#owner) from
		the organization.

		Organization owners have permission to delete organizations and remove user and member
		permissions from the organization.

		#### InfluxDB Cloud
		- Doesn't use `owner` and `member` roles.
		  Use [`/api/v2/authorizations`](#tag/Authorizations) to assign user permissions.

		#### Limitations

		- Owner permissions are separate from API token permissions.
		- Owner permissions are used in the context of the InfluxDB UI.

		#### Required permissions

		- `write-orgs INFLUX_ORG_ID`

		*`INFLUX_ORG_ID`* is the ID of the organization that you want to
		remove an owner from.

		#### Related endpoints
		- [Authorizations](#tag/Authorizations)

			 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
			 * @param userID The ID of the user to remove.
			 * @param orgID The ID of the organization to remove an owner from.
			 * @return ApiDeleteOrgsIDOwnersIDRequest
	*/
	DeleteOrgsIDOwnersID(ctx _context.Context, userID string, orgID string) ApiDeleteOrgsIDOwnersIDRequest

	/*
	 * DeleteOrgsIDOwnersIDExecute executes the request
	 */
	DeleteOrgsIDOwnersIDExecute(r ApiDeleteOrgsIDOwnersIDRequest) error

	/*
	 * DeleteOrgsIDOwnersIDExecuteWithHttpInfo executes the request with HTTP response info returned. The response body is not
	 * available on the returned HTTP response as it will have already been read and closed; access to the response body
	 * content should be achieved through the returned response model if applicable.
	 */
	DeleteOrgsIDOwnersIDExecuteWithHttpInfo(r ApiDeleteOrgsIDOwnersIDRequest) (*_nethttp.Response, error)

	/*
			 * GetOrgs List organizations
			 * Retrieves a list of [organizations]({{% INFLUXDB_DOCS_URL %}}/reference/glossary/#organization/).

		To limit which organizations are returned, pass query parameters in your request.
		If no query parameters are passed, InfluxDB returns all organizations up to the default `limit`.

		#### InfluxDB Cloud

		- Only returns the organization that owns the token passed in the request.

		#### Related guides

		- [View organizations]({{% INFLUXDB_DOCS_URL %}}/organizations/view-orgs/)

			 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
			 * @return ApiGetOrgsRequest
	*/
	GetOrgs(ctx _context.Context) ApiGetOrgsRequest

	/*
	 * GetOrgsExecute executes the request
	 * @return Organizations
	 */
	GetOrgsExecute(r ApiGetOrgsRequest) (Organizations, error)

	/*
	 * GetOrgsExecuteWithHttpInfo executes the request with HTTP response info returned. The response body is not
	 * available on the returned HTTP response as it will have already been read and closed; access to the response body
	 * content should be achieved through the returned response model if applicable.
	 * @return Organizations
	 */
	GetOrgsExecuteWithHttpInfo(r ApiGetOrgsRequest) (Organizations, *_nethttp.Response, error)

	/*
			 * GetOrgsID Retrieve an organization
			 * Retrieves an organization.

		Use this endpoint to retrieve information for a specific organization.

		#### Related guides

		- [View organizations]({{% INFLUXDB_DOCS_URL %}}/organizations/view-orgs/)

			 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
			 * @param orgID The ID of the organization to retrieve.
			 * @return ApiGetOrgsIDRequest
	*/
	GetOrgsID(ctx _context.Context, orgID string) ApiGetOrgsIDRequest

	/*
	 * GetOrgsIDExecute executes the request
	 * @return Organization
	 */
	GetOrgsIDExecute(r ApiGetOrgsIDRequest) (Organization, error)

	/*
	 * GetOrgsIDExecuteWithHttpInfo executes the request with HTTP response info returned. The response body is not
	 * available on the returned HTTP response as it will have already been read and closed; access to the response body
	 * content should be achieved through the returned response model if applicable.
	 * @return Organization
	 */
	GetOrgsIDExecuteWithHttpInfo(r ApiGetOrgsIDRequest) (Organization, *_nethttp.Response, error)

	/*
			 * GetOrgsIDMembers List all members of an organization
			 * Retrieves a list of all users that belong to an organization.

		InfluxDB [users]({{% INFLUXDB_DOCS_URL %}}/reference/glossary/#user) have
		permission to access InfluxDB.

		[Members]({{% INFLUXDB_DOCS_URL %}}/reference/glossary/#member) are users
		within the organization.

		#### InfluxDB Cloud

		- Doesn't use `owner` and `member` roles.
		  Use [`/api/v2/authorizations`](#tag/Authorizations) to assign user permissions.

		#### Limitations

		- Member permissions are separate from API token permissions.
		- Member permissions are used in the context of the InfluxDB UI.

		#### Required permissions

		- `read-orgs INFLUX_ORG_ID`

		*`INFLUX_ORG_ID`* is the ID of the organization that you want to retrieve
		members for.

		#### Related guides

		- [Manage users]({{% INFLUXDB_DOCS_URL %}}/users/)
		- [Manage members]({{% INFLUXDB_DOCS_URL %}}/organizations/members/)

			 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
			 * @param orgID The ID of the organization to retrieve users for.
			 * @return ApiGetOrgsIDMembersRequest
	*/
	GetOrgsIDMembers(ctx _context.Context, orgID string) ApiGetOrgsIDMembersRequest

	/*
	 * GetOrgsIDMembersExecute executes the request
	 * @return ResourceMembers
	 */
	GetOrgsIDMembersExecute(r ApiGetOrgsIDMembersRequest) (ResourceMembers, error)

	/*
	 * GetOrgsIDMembersExecuteWithHttpInfo executes the request with HTTP response info returned. The response body is not
	 * available on the returned HTTP response as it will have already been read and closed; access to the response body
	 * content should be achieved through the returned response model if applicable.
	 * @return ResourceMembers
	 */
	GetOrgsIDMembersExecuteWithHttpInfo(r ApiGetOrgsIDMembersRequest) (ResourceMembers, *_nethttp.Response, error)

	/*
			 * GetOrgsIDOwners List all owners of an organization
			 * Retrieves a list of all owners of an organization.

		#### InfluxDB Cloud

		- Doesn't use `owner` and `member` roles.
		  Use [`/api/v2/authorizations`](#tag/Authorizations) to assign user permissions.

		#### Required permissions

		- `read-orgs INFLUX_ORG_ID`

		*`INFLUX_ORG_ID`* is the ID of the organization that you want to retrieve a
		list of owners from.

			 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
			 * @param orgID The ID of the organization to list owners for.
			 * @return ApiGetOrgsIDOwnersRequest
	*/
	GetOrgsIDOwners(ctx _context.Context, orgID string) ApiGetOrgsIDOwnersRequest

	/*
	 * GetOrgsIDOwnersExecute executes the request
	 * @return ResourceOwners
	 */
	GetOrgsIDOwnersExecute(r ApiGetOrgsIDOwnersRequest) (ResourceOwners, error)

	/*
	 * GetOrgsIDOwnersExecuteWithHttpInfo executes the request with HTTP response info returned. The response body is not
	 * available on the returned HTTP response as it will have already been read and closed; access to the response body
	 * content should be achieved through the returned response model if applicable.
	 * @return ResourceOwners
	 */
	GetOrgsIDOwnersExecuteWithHttpInfo(r ApiGetOrgsIDOwnersRequest) (ResourceOwners, *_nethttp.Response, error)

	/*
			 * PatchOrgsID Update an organization
			 * Updates an organization.

		Use this endpoint to update properties
		(`name`, `description`) of an organization.

		Updating an organization’s name affects all resources that reference the
		organization by name, including the following:

		- Queries
		- Dashboards
		- Tasks
		- Telegraf configurations
		- Templates

		If you change an organization name, be sure to update the organization name
		in these resources as well.

		#### Related Guides

		- [Update an organization]({{% INFLUXDB_DOCS_URL %}}/organizations/update-org/)

			 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
			 * @param orgID The ID of the organization to update.
			 * @return ApiPatchOrgsIDRequest
	*/
	PatchOrgsID(ctx _context.Context, orgID string) ApiPatchOrgsIDRequest

	/*
	 * PatchOrgsIDExecute executes the request
	 * @return Organization
	 */
	PatchOrgsIDExecute(r ApiPatchOrgsIDRequest) (Organization, error)

	/*
	 * PatchOrgsIDExecuteWithHttpInfo executes the request with HTTP response info returned. The response body is not
	 * available on the returned HTTP response as it will have already been read and closed; access to the response body
	 * content should be achieved through the returned response model if applicable.
	 * @return Organization
	 */
	PatchOrgsIDExecuteWithHttpInfo(r ApiPatchOrgsIDRequest) (Organization, *_nethttp.Response, error)

	/*
			 * PostOrgs Create an organization
			 * Creates an [organization]({{% INFLUXDB_DOCS_URL %}}/reference/glossary/#organization)
		and returns the newly created organization.

		#### InfluxDB Cloud

		- Doesn't allow you to use this endpoint to create organizations.

		#### Related guides

		- [Manage organizations]({{% INFLUXDB_DOCS_URL %}}/organizations)

			 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
			 * @return ApiPostOrgsRequest
	*/
	PostOrgs(ctx _context.Context) ApiPostOrgsRequest

	/*
	 * PostOrgsExecute executes the request
	 * @return Organization
	 */
	PostOrgsExecute(r ApiPostOrgsRequest) (Organization, error)

	/*
	 * PostOrgsExecuteWithHttpInfo executes the request with HTTP response info returned. The response body is not
	 * available on the returned HTTP response as it will have already been read and closed; access to the response body
	 * content should be achieved through the returned response model if applicable.
	 * @return Organization
	 */
	PostOrgsExecuteWithHttpInfo(r ApiPostOrgsRequest) (Organization, *_nethttp.Response, error)

	/*
			 * PostOrgsIDMembers Add a member to an organization
			 * Add a user to an organization.

		InfluxDB [users]({{% INFLUXDB_DOCS_URL %}}/reference/glossary/#user) have
		permission to access InfluxDB.

		[Members]({{% INFLUXDB_DOCS_URL %}}/reference/glossary/#member) are users
		within the organization.

		#### InfluxDB Cloud
		- Doesn't use `owner` and `member` roles.
		  Use [`/api/v2/authorizations`](#tag/Authorizations) to assign user permissions.

		#### Limitations

		- Member permissions are separate from API token permissions.
		- Member permissions are used in the context of the InfluxDB UI.

		#### Required permissions

		- `write-orgs INFLUX_ORG_ID`

		*`INFLUX_ORG_ID`* is the ID of the organization that you want to add a member to.

		#### Related guides

		- [Manage users]({{% INFLUXDB_DOCS_URL %}}/users/)
		- [Manage members]({{% INFLUXDB_DOCS_URL %}}/organizations/members/)

			 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
			 * @param orgID The ID of the organization.
			 * @return ApiPostOrgsIDMembersRequest
	*/
	PostOrgsIDMembers(ctx _context.Context, orgID string) ApiPostOrgsIDMembersRequest

	/*
	 * PostOrgsIDMembersExecute executes the request
	 * @return ResourceMember
	 */
	PostOrgsIDMembersExecute(r ApiPostOrgsIDMembersRequest) (ResourceMember, error)

	/*
	 * PostOrgsIDMembersExecuteWithHttpInfo executes the request with HTTP response info returned. The response body is not
	 * available on the returned HTTP response as it will have already been read and closed; access to the response body
	 * content should be achieved through the returned response model if applicable.
	 * @return ResourceMember
	 */
	PostOrgsIDMembersExecuteWithHttpInfo(r ApiPostOrgsIDMembersRequest) (ResourceMember, *_nethttp.Response, error)

	/*
			 * PostOrgsIDOwners Add an owner to an organization
			 * Adds an owner to an organization.

		Use this endpoint to assign the organization `owner` role to a user.

		#### InfluxDB Cloud

		- Doesn't use `owner` and `member` roles.
		  Use [`/api/v2/authorizations`](#tag/Authorizations) to assign user permissions.

		#### Required permissions

		- `write-orgs INFLUX_ORG_ID`

		*`INFLUX_ORG_ID`* is the ID of the organization that you want to add an owner for.

		#### Related endpoints

		- [Authorizations](#tag/Authorizations)

			 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
			 * @param orgID The ID of the organization that you want to add an owner for.
			 * @return ApiPostOrgsIDOwnersRequest
	*/
	PostOrgsIDOwners(ctx _context.Context, orgID string) ApiPostOrgsIDOwnersRequest

	/*
	 * PostOrgsIDOwnersExecute executes the request
	 * @return ResourceOwner
	 */
	PostOrgsIDOwnersExecute(r ApiPostOrgsIDOwnersRequest) (ResourceOwner, error)

	/*
	 * PostOrgsIDOwnersExecuteWithHttpInfo executes the request with HTTP response info returned. The response body is not
	 * available on the returned HTTP response as it will have already been read and closed; access to the response body
	 * content should be achieved through the returned response model if applicable.
	 * @return ResourceOwner
	 */
	PostOrgsIDOwnersExecuteWithHttpInfo(r ApiPostOrgsIDOwnersRequest) (ResourceOwner, *_nethttp.Response, error)
}

// OrganizationsApiService OrganizationsApi service
type OrganizationsApiService service

type ApiDeleteOrgsIDRequest struct {
	ctx          _context.Context
	ApiService   OrganizationsApi
	orgID        string
	zapTraceSpan *string
}

func (r ApiDeleteOrgsIDRequest) OrgID(orgID string) ApiDeleteOrgsIDRequest {
	r.orgID = orgID
	return r
}
func (r ApiDeleteOrgsIDRequest) GetOrgID() string {
	return r.orgID
}

func (r ApiDeleteOrgsIDRequest) ZapTraceSpan(zapTraceSpan string) ApiDeleteOrgsIDRequest {
	r.zapTraceSpan = &zapTraceSpan
	return r
}
func (r ApiDeleteOrgsIDRequest) GetZapTraceSpan() *string {
	return r.zapTraceSpan
}

func (r ApiDeleteOrgsIDRequest) Execute() error {
	return r.ApiService.DeleteOrgsIDExecute(r)
}

func (r ApiDeleteOrgsIDRequest) ExecuteWithHttpInfo() (*_nethttp.Response, error) {
	return r.ApiService.DeleteOrgsIDExecuteWithHttpInfo(r)
}

/*
 * DeleteOrgsID Delete an organization
 * Deletes an organization.

Deleting an organization from InfluxDB Cloud can't be undone.
Once deleted, all data associated with the organization is removed.

#### InfluxDB Cloud

- Does the following when you send a delete request:

  1. Validates the request and queues the delete.
  2. Returns an HTTP `204` status code if queued; _error_ otherwise.
  3. Handles the delete asynchronously.

#### InfluxDB OSS

- Validates the request, handles the delete synchronously,
and then responds with success or failure.

#### Limitations

- Only one organization can be deleted per request.

#### Related guides

- [Delete organizations]({{% INFLUXDB_DOCS_URL %}}/organizations/delete-orgs/)

 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param orgID The ID of the organization to delete.
 * @return ApiDeleteOrgsIDRequest
*/
func (a *OrganizationsApiService) DeleteOrgsID(ctx _context.Context, orgID string) ApiDeleteOrgsIDRequest {
	return ApiDeleteOrgsIDRequest{
		ApiService: a,
		ctx:        ctx,
		orgID:      orgID,
	}
}

/*
 * Execute executes the request
 */
func (a *OrganizationsApiService) DeleteOrgsIDExecute(r ApiDeleteOrgsIDRequest) error {
	_, err := a.DeleteOrgsIDExecuteWithHttpInfo(r)
	return err
}

/*
 * ExecuteWithHttpInfo executes the request with HTTP response info returned. The response body is not available on the
 * returned HTTP response as it will have already been read and closed; access to the response body content should be
 * achieved through the returned response model if applicable.
 */
func (a *OrganizationsApiService) DeleteOrgsIDExecuteWithHttpInfo(r ApiDeleteOrgsIDRequest) (*_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodDelete
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "OrganizationsApiService.DeleteOrgsID")
	if err != nil {
		return nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/api/v2/orgs/{orgID}"
	localVarPath = strings.Replace(localVarPath, "{"+"orgID"+"}", _neturl.PathEscape(parameterToString(r.orgID, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.zapTraceSpan != nil {
		localVarHeaderParams["Zap-Trace-Span"] = parameterToString(*r.zapTraceSpan, "")
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarHTTPResponse, err
	}

	newErr := GenericOpenAPIError{
		buildHeader: localVarHTTPResponse.Header.Get("X-Influxdb-Build"),
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		body, err := GunzipIfNeeded(localVarHTTPResponse)
		if err != nil {
			body.Close()
			newErr.error = err.Error()
			return localVarHTTPResponse, newErr
		}
		localVarBody, err := _io.ReadAll(body)
		body.Close()
		if err != nil {
			newErr.error = err.Error()
			return localVarHTTPResponse, newErr
		}
		newErr.body = localVarBody
		newErr.error = localVarHTTPResponse.Status
		if localVarHTTPResponse.StatusCode == 401 {
			var v UnauthorizedRequestError
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
				return localVarHTTPResponse, newErr
			}
			v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
			newErr.model = &v
			return localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 404 {
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
				return localVarHTTPResponse, newErr
			}
			v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
			newErr.model = &v
			return localVarHTTPResponse, newErr
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
			return localVarHTTPResponse, newErr
		}
		v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
		newErr.model = &v
		return localVarHTTPResponse, newErr
	}

	return localVarHTTPResponse, nil
}

type ApiDeleteOrgsIDMembersIDRequest struct {
	ctx          _context.Context
	ApiService   OrganizationsApi
	userID       string
	orgID        string
	zapTraceSpan *string
}

func (r ApiDeleteOrgsIDMembersIDRequest) UserID(userID string) ApiDeleteOrgsIDMembersIDRequest {
	r.userID = userID
	return r
}
func (r ApiDeleteOrgsIDMembersIDRequest) GetUserID() string {
	return r.userID
}

func (r ApiDeleteOrgsIDMembersIDRequest) OrgID(orgID string) ApiDeleteOrgsIDMembersIDRequest {
	r.orgID = orgID
	return r
}
func (r ApiDeleteOrgsIDMembersIDRequest) GetOrgID() string {
	return r.orgID
}

func (r ApiDeleteOrgsIDMembersIDRequest) ZapTraceSpan(zapTraceSpan string) ApiDeleteOrgsIDMembersIDRequest {
	r.zapTraceSpan = &zapTraceSpan
	return r
}
func (r ApiDeleteOrgsIDMembersIDRequest) GetZapTraceSpan() *string {
	return r.zapTraceSpan
}

func (r ApiDeleteOrgsIDMembersIDRequest) Execute() error {
	return r.ApiService.DeleteOrgsIDMembersIDExecute(r)
}

func (r ApiDeleteOrgsIDMembersIDRequest) ExecuteWithHttpInfo() (*_nethttp.Response, error) {
	return r.ApiService.DeleteOrgsIDMembersIDExecuteWithHttpInfo(r)
}

/*
 * DeleteOrgsIDMembersID Remove a member from an organization
 * Removes a member from an organization.

Use this endpoint to remove a user's member privileges from a bucket. This
removes the user's `read` and `write` permissions from the organization.

#### InfluxDB Cloud

- Doesn't use `owner` and `member` roles.
  Use [`/api/v2/authorizations`](#tag/Authorizations) to assign user permissions.

#### Limitations

- Member permissions are separate from API token permissions.
- Member permissions are used in the context of the InfluxDB UI.

#### Required permissions

- `write-orgs INFLUX_ORG_ID`

*`INFLUX_ORG_ID`* is the ID of the organization that you want to remove an
owner from.

#### Related guides

- [Manage members]({{% INFLUXDB_DOCS_URL %}}/organizations/members/)

 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param userID The ID of the user to remove.
 * @param orgID The ID of the organization to remove a user from.
 * @return ApiDeleteOrgsIDMembersIDRequest
*/
func (a *OrganizationsApiService) DeleteOrgsIDMembersID(ctx _context.Context, userID string, orgID string) ApiDeleteOrgsIDMembersIDRequest {
	return ApiDeleteOrgsIDMembersIDRequest{
		ApiService: a,
		ctx:        ctx,
		userID:     userID,
		orgID:      orgID,
	}
}

/*
 * Execute executes the request
 */
func (a *OrganizationsApiService) DeleteOrgsIDMembersIDExecute(r ApiDeleteOrgsIDMembersIDRequest) error {
	_, err := a.DeleteOrgsIDMembersIDExecuteWithHttpInfo(r)
	return err
}

/*
 * ExecuteWithHttpInfo executes the request with HTTP response info returned. The response body is not available on the
 * returned HTTP response as it will have already been read and closed; access to the response body content should be
 * achieved through the returned response model if applicable.
 */
func (a *OrganizationsApiService) DeleteOrgsIDMembersIDExecuteWithHttpInfo(r ApiDeleteOrgsIDMembersIDRequest) (*_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodDelete
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "OrganizationsApiService.DeleteOrgsIDMembersID")
	if err != nil {
		return nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/api/v2/orgs/{orgID}/members/{userID}"
	localVarPath = strings.Replace(localVarPath, "{"+"userID"+"}", _neturl.PathEscape(parameterToString(r.userID, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"orgID"+"}", _neturl.PathEscape(parameterToString(r.orgID, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.zapTraceSpan != nil {
		localVarHeaderParams["Zap-Trace-Span"] = parameterToString(*r.zapTraceSpan, "")
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarHTTPResponse, err
	}

	newErr := GenericOpenAPIError{
		buildHeader: localVarHTTPResponse.Header.Get("X-Influxdb-Build"),
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		body, err := GunzipIfNeeded(localVarHTTPResponse)
		if err != nil {
			body.Close()
			newErr.error = err.Error()
			return localVarHTTPResponse, newErr
		}
		localVarBody, err := _io.ReadAll(body)
		body.Close()
		if err != nil {
			newErr.error = err.Error()
			return localVarHTTPResponse, newErr
		}
		newErr.body = localVarBody
		newErr.error = localVarHTTPResponse.Status
		if localVarHTTPResponse.StatusCode == 401 {
			var v UnauthorizedRequestError
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
				return localVarHTTPResponse, newErr
			}
			v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
			newErr.model = &v
			return localVarHTTPResponse, newErr
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
			return localVarHTTPResponse, newErr
		}
		v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
		newErr.model = &v
		return localVarHTTPResponse, newErr
	}

	return localVarHTTPResponse, nil
}

type ApiDeleteOrgsIDOwnersIDRequest struct {
	ctx          _context.Context
	ApiService   OrganizationsApi
	userID       string
	orgID        string
	zapTraceSpan *string
}

func (r ApiDeleteOrgsIDOwnersIDRequest) UserID(userID string) ApiDeleteOrgsIDOwnersIDRequest {
	r.userID = userID
	return r
}
func (r ApiDeleteOrgsIDOwnersIDRequest) GetUserID() string {
	return r.userID
}

func (r ApiDeleteOrgsIDOwnersIDRequest) OrgID(orgID string) ApiDeleteOrgsIDOwnersIDRequest {
	r.orgID = orgID
	return r
}
func (r ApiDeleteOrgsIDOwnersIDRequest) GetOrgID() string {
	return r.orgID
}

func (r ApiDeleteOrgsIDOwnersIDRequest) ZapTraceSpan(zapTraceSpan string) ApiDeleteOrgsIDOwnersIDRequest {
	r.zapTraceSpan = &zapTraceSpan
	return r
}
func (r ApiDeleteOrgsIDOwnersIDRequest) GetZapTraceSpan() *string {
	return r.zapTraceSpan
}

func (r ApiDeleteOrgsIDOwnersIDRequest) Execute() error {
	return r.ApiService.DeleteOrgsIDOwnersIDExecute(r)
}

func (r ApiDeleteOrgsIDOwnersIDRequest) ExecuteWithHttpInfo() (*_nethttp.Response, error) {
	return r.ApiService.DeleteOrgsIDOwnersIDExecuteWithHttpInfo(r)
}

/*
 * DeleteOrgsIDOwnersID Remove an owner from an organization
 * Removes an [owner]({{% INFLUXDB_DOCS_URL %}}/reference/glossary/#owner) from
the organization.

Organization owners have permission to delete organizations and remove user and member
permissions from the organization.

#### InfluxDB Cloud
- Doesn't use `owner` and `member` roles.
  Use [`/api/v2/authorizations`](#tag/Authorizations) to assign user permissions.

#### Limitations

- Owner permissions are separate from API token permissions.
- Owner permissions are used in the context of the InfluxDB UI.

#### Required permissions

- `write-orgs INFLUX_ORG_ID`

*`INFLUX_ORG_ID`* is the ID of the organization that you want to
remove an owner from.

#### Related endpoints
- [Authorizations](#tag/Authorizations)

 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param userID The ID of the user to remove.
 * @param orgID The ID of the organization to remove an owner from.
 * @return ApiDeleteOrgsIDOwnersIDRequest
*/
func (a *OrganizationsApiService) DeleteOrgsIDOwnersID(ctx _context.Context, userID string, orgID string) ApiDeleteOrgsIDOwnersIDRequest {
	return ApiDeleteOrgsIDOwnersIDRequest{
		ApiService: a,
		ctx:        ctx,
		userID:     userID,
		orgID:      orgID,
	}
}

/*
 * Execute executes the request
 */
func (a *OrganizationsApiService) DeleteOrgsIDOwnersIDExecute(r ApiDeleteOrgsIDOwnersIDRequest) error {
	_, err := a.DeleteOrgsIDOwnersIDExecuteWithHttpInfo(r)
	return err
}

/*
 * ExecuteWithHttpInfo executes the request with HTTP response info returned. The response body is not available on the
 * returned HTTP response as it will have already been read and closed; access to the response body content should be
 * achieved through the returned response model if applicable.
 */
func (a *OrganizationsApiService) DeleteOrgsIDOwnersIDExecuteWithHttpInfo(r ApiDeleteOrgsIDOwnersIDRequest) (*_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodDelete
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "OrganizationsApiService.DeleteOrgsIDOwnersID")
	if err != nil {
		return nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/api/v2/orgs/{orgID}/owners/{userID}"
	localVarPath = strings.Replace(localVarPath, "{"+"userID"+"}", _neturl.PathEscape(parameterToString(r.userID, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"orgID"+"}", _neturl.PathEscape(parameterToString(r.orgID, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.zapTraceSpan != nil {
		localVarHeaderParams["Zap-Trace-Span"] = parameterToString(*r.zapTraceSpan, "")
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarHTTPResponse, err
	}

	newErr := GenericOpenAPIError{
		buildHeader: localVarHTTPResponse.Header.Get("X-Influxdb-Build"),
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		body, err := GunzipIfNeeded(localVarHTTPResponse)
		if err != nil {
			body.Close()
			newErr.error = err.Error()
			return localVarHTTPResponse, newErr
		}
		localVarBody, err := _io.ReadAll(body)
		body.Close()
		if err != nil {
			newErr.error = err.Error()
			return localVarHTTPResponse, newErr
		}
		newErr.body = localVarBody
		newErr.error = localVarHTTPResponse.Status
		if localVarHTTPResponse.StatusCode == 401 {
			var v UnauthorizedRequestError
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
				return localVarHTTPResponse, newErr
			}
			v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
			newErr.model = &v
			return localVarHTTPResponse, newErr
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
			return localVarHTTPResponse, newErr
		}
		v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
		newErr.model = &v
		return localVarHTTPResponse, newErr
	}

	return localVarHTTPResponse, nil
}

type ApiGetOrgsRequest struct {
	ctx          _context.Context
	ApiService   OrganizationsApi
	zapTraceSpan *string
	offset       *int32
	limit        *int32
	descending   *bool
	org          *string
	orgID        *string
	userID       *string
}

func (r ApiGetOrgsRequest) ZapTraceSpan(zapTraceSpan string) ApiGetOrgsRequest {
	r.zapTraceSpan = &zapTraceSpan
	return r
}
func (r ApiGetOrgsRequest) GetZapTraceSpan() *string {
	return r.zapTraceSpan
}

func (r ApiGetOrgsRequest) Offset(offset int32) ApiGetOrgsRequest {
	r.offset = &offset
	return r
}
func (r ApiGetOrgsRequest) GetOffset() *int32 {
	return r.offset
}

func (r ApiGetOrgsRequest) Limit(limit int32) ApiGetOrgsRequest {
	r.limit = &limit
	return r
}
func (r ApiGetOrgsRequest) GetLimit() *int32 {
	return r.limit
}

func (r ApiGetOrgsRequest) Descending(descending bool) ApiGetOrgsRequest {
	r.descending = &descending
	return r
}
func (r ApiGetOrgsRequest) GetDescending() *bool {
	return r.descending
}

func (r ApiGetOrgsRequest) Org(org string) ApiGetOrgsRequest {
	r.org = &org
	return r
}
func (r ApiGetOrgsRequest) GetOrg() *string {
	return r.org
}

func (r ApiGetOrgsRequest) OrgID(orgID string) ApiGetOrgsRequest {
	r.orgID = &orgID
	return r
}
func (r ApiGetOrgsRequest) GetOrgID() *string {
	return r.orgID
}

func (r ApiGetOrgsRequest) UserID(userID string) ApiGetOrgsRequest {
	r.userID = &userID
	return r
}
func (r ApiGetOrgsRequest) GetUserID() *string {
	return r.userID
}

func (r ApiGetOrgsRequest) Execute() (Organizations, error) {
	return r.ApiService.GetOrgsExecute(r)
}

func (r ApiGetOrgsRequest) ExecuteWithHttpInfo() (Organizations, *_nethttp.Response, error) {
	return r.ApiService.GetOrgsExecuteWithHttpInfo(r)
}

/*
 * GetOrgs List organizations
 * Retrieves a list of [organizations]({{% INFLUXDB_DOCS_URL %}}/reference/glossary/#organization/).

To limit which organizations are returned, pass query parameters in your request.
If no query parameters are passed, InfluxDB returns all organizations up to the default `limit`.

#### InfluxDB Cloud

- Only returns the organization that owns the token passed in the request.

#### Related guides

- [View organizations]({{% INFLUXDB_DOCS_URL %}}/organizations/view-orgs/)

 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @return ApiGetOrgsRequest
*/
func (a *OrganizationsApiService) GetOrgs(ctx _context.Context) ApiGetOrgsRequest {
	return ApiGetOrgsRequest{
		ApiService: a,
		ctx:        ctx,
	}
}

/*
 * Execute executes the request
 * @return Organizations
 */
func (a *OrganizationsApiService) GetOrgsExecute(r ApiGetOrgsRequest) (Organizations, error) {
	returnVal, _, err := a.GetOrgsExecuteWithHttpInfo(r)
	return returnVal, err
}

/*
 * ExecuteWithHttpInfo executes the request with HTTP response info returned. The response body is not available on the
 * returned HTTP response as it will have already been read and closed; access to the response body content should be
 * achieved through the returned response model if applicable.
 * @return Organizations
 */
func (a *OrganizationsApiService) GetOrgsExecuteWithHttpInfo(r ApiGetOrgsRequest) (Organizations, *_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  Organizations
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "OrganizationsApiService.GetOrgs")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/api/v2/orgs"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.offset != nil {
		localVarQueryParams.Add("offset", parameterToString(*r.offset, ""))
	}
	if r.limit != nil {
		localVarQueryParams.Add("limit", parameterToString(*r.limit, ""))
	}
	if r.descending != nil {
		localVarQueryParams.Add("descending", parameterToString(*r.descending, ""))
	}
	if r.org != nil {
		localVarQueryParams.Add("org", parameterToString(*r.org, ""))
	}
	if r.orgID != nil {
		localVarQueryParams.Add("orgID", parameterToString(*r.orgID, ""))
	}
	if r.userID != nil {
		localVarQueryParams.Add("userID", parameterToString(*r.userID, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.zapTraceSpan != nil {
		localVarHeaderParams["Zap-Trace-Span"] = parameterToString(*r.zapTraceSpan, "")
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	newErr := GenericOpenAPIError{
		buildHeader: localVarHTTPResponse.Header.Get("X-Influxdb-Build"),
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		body, err := GunzipIfNeeded(localVarHTTPResponse)
		if err != nil {
			body.Close()
			newErr.error = err.Error()
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		localVarBody, err := _io.ReadAll(body)
		body.Close()
		if err != nil {
			newErr.error = err.Error()
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		newErr.body = localVarBody
		newErr.error = localVarHTTPResponse.Status
		if localVarHTTPResponse.StatusCode == 400 {
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
			newErr.model = &v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 401 {
			var v UnauthorizedRequestError
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
			newErr.model = &v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 404 {
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
			newErr.model = &v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 500 {
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
			newErr.model = &v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
		newErr.model = &v
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	body, err := GunzipIfNeeded(localVarHTTPResponse)
	if err != nil {
		body.Close()
		newErr.error = err.Error()
		return localVarReturnValue, localVarHTTPResponse, newErr
	}
	localVarBody, err := _io.ReadAll(body)
	body.Close()
	if err != nil {
		newErr.error = err.Error()
		return localVarReturnValue, localVarHTTPResponse, newErr
	}
	newErr.body = localVarBody
	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr.error = err.Error()
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiGetOrgsIDRequest struct {
	ctx          _context.Context
	ApiService   OrganizationsApi
	orgID        string
	zapTraceSpan *string
}

func (r ApiGetOrgsIDRequest) OrgID(orgID string) ApiGetOrgsIDRequest {
	r.orgID = orgID
	return r
}
func (r ApiGetOrgsIDRequest) GetOrgID() string {
	return r.orgID
}

func (r ApiGetOrgsIDRequest) ZapTraceSpan(zapTraceSpan string) ApiGetOrgsIDRequest {
	r.zapTraceSpan = &zapTraceSpan
	return r
}
func (r ApiGetOrgsIDRequest) GetZapTraceSpan() *string {
	return r.zapTraceSpan
}

func (r ApiGetOrgsIDRequest) Execute() (Organization, error) {
	return r.ApiService.GetOrgsIDExecute(r)
}

func (r ApiGetOrgsIDRequest) ExecuteWithHttpInfo() (Organization, *_nethttp.Response, error) {
	return r.ApiService.GetOrgsIDExecuteWithHttpInfo(r)
}

/*
 * GetOrgsID Retrieve an organization
 * Retrieves an organization.

Use this endpoint to retrieve information for a specific organization.

#### Related guides

- [View organizations]({{% INFLUXDB_DOCS_URL %}}/organizations/view-orgs/)

 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param orgID The ID of the organization to retrieve.
 * @return ApiGetOrgsIDRequest
*/
func (a *OrganizationsApiService) GetOrgsID(ctx _context.Context, orgID string) ApiGetOrgsIDRequest {
	return ApiGetOrgsIDRequest{
		ApiService: a,
		ctx:        ctx,
		orgID:      orgID,
	}
}

/*
 * Execute executes the request
 * @return Organization
 */
func (a *OrganizationsApiService) GetOrgsIDExecute(r ApiGetOrgsIDRequest) (Organization, error) {
	returnVal, _, err := a.GetOrgsIDExecuteWithHttpInfo(r)
	return returnVal, err
}

/*
 * ExecuteWithHttpInfo executes the request with HTTP response info returned. The response body is not available on the
 * returned HTTP response as it will have already been read and closed; access to the response body content should be
 * achieved through the returned response model if applicable.
 * @return Organization
 */
func (a *OrganizationsApiService) GetOrgsIDExecuteWithHttpInfo(r ApiGetOrgsIDRequest) (Organization, *_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  Organization
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "OrganizationsApiService.GetOrgsID")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/api/v2/orgs/{orgID}"
	localVarPath = strings.Replace(localVarPath, "{"+"orgID"+"}", _neturl.PathEscape(parameterToString(r.orgID, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.zapTraceSpan != nil {
		localVarHeaderParams["Zap-Trace-Span"] = parameterToString(*r.zapTraceSpan, "")
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	newErr := GenericOpenAPIError{
		buildHeader: localVarHTTPResponse.Header.Get("X-Influxdb-Build"),
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		body, err := GunzipIfNeeded(localVarHTTPResponse)
		if err != nil {
			body.Close()
			newErr.error = err.Error()
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		localVarBody, err := _io.ReadAll(body)
		body.Close()
		if err != nil {
			newErr.error = err.Error()
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		newErr.body = localVarBody
		newErr.error = localVarHTTPResponse.Status
		if localVarHTTPResponse.StatusCode == 401 {
			var v UnauthorizedRequestError
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
			newErr.model = &v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 404 {
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
			newErr.model = &v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
		newErr.model = &v
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	body, err := GunzipIfNeeded(localVarHTTPResponse)
	if err != nil {
		body.Close()
		newErr.error = err.Error()
		return localVarReturnValue, localVarHTTPResponse, newErr
	}
	localVarBody, err := _io.ReadAll(body)
	body.Close()
	if err != nil {
		newErr.error = err.Error()
		return localVarReturnValue, localVarHTTPResponse, newErr
	}
	newErr.body = localVarBody
	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr.error = err.Error()
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiGetOrgsIDMembersRequest struct {
	ctx          _context.Context
	ApiService   OrganizationsApi
	orgID        string
	zapTraceSpan *string
}

func (r ApiGetOrgsIDMembersRequest) OrgID(orgID string) ApiGetOrgsIDMembersRequest {
	r.orgID = orgID
	return r
}
func (r ApiGetOrgsIDMembersRequest) GetOrgID() string {
	return r.orgID
}

func (r ApiGetOrgsIDMembersRequest) ZapTraceSpan(zapTraceSpan string) ApiGetOrgsIDMembersRequest {
	r.zapTraceSpan = &zapTraceSpan
	return r
}
func (r ApiGetOrgsIDMembersRequest) GetZapTraceSpan() *string {
	return r.zapTraceSpan
}

func (r ApiGetOrgsIDMembersRequest) Execute() (ResourceMembers, error) {
	return r.ApiService.GetOrgsIDMembersExecute(r)
}

func (r ApiGetOrgsIDMembersRequest) ExecuteWithHttpInfo() (ResourceMembers, *_nethttp.Response, error) {
	return r.ApiService.GetOrgsIDMembersExecuteWithHttpInfo(r)
}

/*
 * GetOrgsIDMembers List all members of an organization
 * Retrieves a list of all users that belong to an organization.

InfluxDB [users]({{% INFLUXDB_DOCS_URL %}}/reference/glossary/#user) have
permission to access InfluxDB.

[Members]({{% INFLUXDB_DOCS_URL %}}/reference/glossary/#member) are users
within the organization.

#### InfluxDB Cloud

- Doesn't use `owner` and `member` roles.
  Use [`/api/v2/authorizations`](#tag/Authorizations) to assign user permissions.

#### Limitations

- Member permissions are separate from API token permissions.
- Member permissions are used in the context of the InfluxDB UI.

#### Required permissions

- `read-orgs INFLUX_ORG_ID`

*`INFLUX_ORG_ID`* is the ID of the organization that you want to retrieve
members for.

#### Related guides

- [Manage users]({{% INFLUXDB_DOCS_URL %}}/users/)
- [Manage members]({{% INFLUXDB_DOCS_URL %}}/organizations/members/)

 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param orgID The ID of the organization to retrieve users for.
 * @return ApiGetOrgsIDMembersRequest
*/
func (a *OrganizationsApiService) GetOrgsIDMembers(ctx _context.Context, orgID string) ApiGetOrgsIDMembersRequest {
	return ApiGetOrgsIDMembersRequest{
		ApiService: a,
		ctx:        ctx,
		orgID:      orgID,
	}
}

/*
 * Execute executes the request
 * @return ResourceMembers
 */
func (a *OrganizationsApiService) GetOrgsIDMembersExecute(r ApiGetOrgsIDMembersRequest) (ResourceMembers, error) {
	returnVal, _, err := a.GetOrgsIDMembersExecuteWithHttpInfo(r)
	return returnVal, err
}

/*
 * ExecuteWithHttpInfo executes the request with HTTP response info returned. The response body is not available on the
 * returned HTTP response as it will have already been read and closed; access to the response body content should be
 * achieved through the returned response model if applicable.
 * @return ResourceMembers
 */
func (a *OrganizationsApiService) GetOrgsIDMembersExecuteWithHttpInfo(r ApiGetOrgsIDMembersRequest) (ResourceMembers, *_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  ResourceMembers
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "OrganizationsApiService.GetOrgsIDMembers")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/api/v2/orgs/{orgID}/members"
	localVarPath = strings.Replace(localVarPath, "{"+"orgID"+"}", _neturl.PathEscape(parameterToString(r.orgID, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.zapTraceSpan != nil {
		localVarHeaderParams["Zap-Trace-Span"] = parameterToString(*r.zapTraceSpan, "")
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	newErr := GenericOpenAPIError{
		buildHeader: localVarHTTPResponse.Header.Get("X-Influxdb-Build"),
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		body, err := GunzipIfNeeded(localVarHTTPResponse)
		if err != nil {
			body.Close()
			newErr.error = err.Error()
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		localVarBody, err := _io.ReadAll(body)
		body.Close()
		if err != nil {
			newErr.error = err.Error()
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		newErr.body = localVarBody
		newErr.error = localVarHTTPResponse.Status
		if localVarHTTPResponse.StatusCode == 401 {
			var v UnauthorizedRequestError
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
			newErr.model = &v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		if localVarHTTPResponse.StatusCode == 404 {
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
			newErr.model = &v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
		newErr.model = &v
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	body, err := GunzipIfNeeded(localVarHTTPResponse)
	if err != nil {
		body.Close()
		newErr.error = err.Error()
		return localVarReturnValue, localVarHTTPResponse, newErr
	}
	localVarBody, err := _io.ReadAll(body)
	body.Close()
	if err != nil {
		newErr.error = err.Error()
		return localVarReturnValue, localVarHTTPResponse, newErr
	}
	newErr.body = localVarBody
	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr.error = err.Error()
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiGetOrgsIDOwnersRequest struct {
	ctx          _context.Context
	ApiService   OrganizationsApi
	orgID        string
	zapTraceSpan *string
}

func (r ApiGetOrgsIDOwnersRequest) OrgID(orgID string) ApiGetOrgsIDOwnersRequest {
	r.orgID = orgID
	return r
}
func (r ApiGetOrgsIDOwnersRequest) GetOrgID() string {
	return r.orgID
}

func (r ApiGetOrgsIDOwnersRequest) ZapTraceSpan(zapTraceSpan string) ApiGetOrgsIDOwnersRequest {
	r.zapTraceSpan = &zapTraceSpan
	return r
}
func (r ApiGetOrgsIDOwnersRequest) GetZapTraceSpan() *string {
	return r.zapTraceSpan
}

func (r ApiGetOrgsIDOwnersRequest) Execute() (ResourceOwners, error) {
	return r.ApiService.GetOrgsIDOwnersExecute(r)
}

func (r ApiGetOrgsIDOwnersRequest) ExecuteWithHttpInfo() (ResourceOwners, *_nethttp.Response, error) {
	return r.ApiService.GetOrgsIDOwnersExecuteWithHttpInfo(r)
}

/*
 * GetOrgsIDOwners List all owners of an organization
 * Retrieves a list of all owners of an organization.

#### InfluxDB Cloud

- Doesn't use `owner` and `member` roles.
  Use [`/api/v2/authorizations`](#tag/Authorizations) to assign user permissions.

#### Required permissions

- `read-orgs INFLUX_ORG_ID`

*`INFLUX_ORG_ID`* is the ID of the organization that you want to retrieve a
list of owners from.

 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param orgID The ID of the organization to list owners for.
 * @return ApiGetOrgsIDOwnersRequest
*/
func (a *OrganizationsApiService) GetOrgsIDOwners(ctx _context.Context, orgID string) ApiGetOrgsIDOwnersRequest {
	return ApiGetOrgsIDOwnersRequest{
		ApiService: a,
		ctx:        ctx,
		orgID:      orgID,
	}
}

/*
 * Execute executes the request
 * @return ResourceOwners
 */
func (a *OrganizationsApiService) GetOrgsIDOwnersExecute(r ApiGetOrgsIDOwnersRequest) (ResourceOwners, error) {
	returnVal, _, err := a.GetOrgsIDOwnersExecuteWithHttpInfo(r)
	return returnVal, err
}

/*
 * ExecuteWithHttpInfo executes the request with HTTP response info returned. The response body is not available on the
 * returned HTTP response as it will have already been read and closed; access to the response body content should be
 * achieved through the returned response model if applicable.
 * @return ResourceOwners
 */
func (a *OrganizationsApiService) GetOrgsIDOwnersExecuteWithHttpInfo(r ApiGetOrgsIDOwnersRequest) (ResourceOwners, *_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  ResourceOwners
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "OrganizationsApiService.GetOrgsIDOwners")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/api/v2/orgs/{orgID}/owners"
	localVarPath = strings.Replace(localVarPath, "{"+"orgID"+"}", _neturl.PathEscape(parameterToString(r.orgID, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.zapTraceSpan != nil {
		localVarHeaderParams["Zap-Trace-Span"] = parameterToString(*r.zapTraceSpan, "")
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	newErr := GenericOpenAPIError{
		buildHeader: localVarHTTPResponse.Header.Get("X-Influxdb-Build"),
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		body, err := GunzipIfNeeded(localVarHTTPResponse)
		if err != nil {
			body.Close()
			newErr.error = err.Error()
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		localVarBody, err := _io.ReadAll(body)
		body.Close()
		if err != nil {
			newErr.error = err.Error()
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		newErr.body = localVarBody
		newErr.error = localVarHTTPResponse.Status
		if localVarHTTPResponse.StatusCode == 404 {
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
			newErr.model = &v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
		newErr.model = &v
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	body, err := GunzipIfNeeded(localVarHTTPResponse)
	if err != nil {
		body.Close()
		newErr.error = err.Error()
		return localVarReturnValue, localVarHTTPResponse, newErr
	}
	localVarBody, err := _io.ReadAll(body)
	body.Close()
	if err != nil {
		newErr.error = err.Error()
		return localVarReturnValue, localVarHTTPResponse, newErr
	}
	newErr.body = localVarBody
	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr.error = err.Error()
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiPatchOrgsIDRequest struct {
	ctx                      _context.Context
	ApiService               OrganizationsApi
	orgID                    string
	patchOrganizationRequest *PatchOrganizationRequest
	zapTraceSpan             *string
}

func (r ApiPatchOrgsIDRequest) OrgID(orgID string) ApiPatchOrgsIDRequest {
	r.orgID = orgID
	return r
}
func (r ApiPatchOrgsIDRequest) GetOrgID() string {
	return r.orgID
}

func (r ApiPatchOrgsIDRequest) PatchOrganizationRequest(patchOrganizationRequest PatchOrganizationRequest) ApiPatchOrgsIDRequest {
	r.patchOrganizationRequest = &patchOrganizationRequest
	return r
}
func (r ApiPatchOrgsIDRequest) GetPatchOrganizationRequest() *PatchOrganizationRequest {
	return r.patchOrganizationRequest
}

func (r ApiPatchOrgsIDRequest) ZapTraceSpan(zapTraceSpan string) ApiPatchOrgsIDRequest {
	r.zapTraceSpan = &zapTraceSpan
	return r
}
func (r ApiPatchOrgsIDRequest) GetZapTraceSpan() *string {
	return r.zapTraceSpan
}

func (r ApiPatchOrgsIDRequest) Execute() (Organization, error) {
	return r.ApiService.PatchOrgsIDExecute(r)
}

func (r ApiPatchOrgsIDRequest) ExecuteWithHttpInfo() (Organization, *_nethttp.Response, error) {
	return r.ApiService.PatchOrgsIDExecuteWithHttpInfo(r)
}

/*
 * PatchOrgsID Update an organization
 * Updates an organization.

Use this endpoint to update properties
(`name`, `description`) of an organization.

Updating an organization’s name affects all resources that reference the
organization by name, including the following:

- Queries
- Dashboards
- Tasks
- Telegraf configurations
- Templates

If you change an organization name, be sure to update the organization name
in these resources as well.

#### Related Guides

- [Update an organization]({{% INFLUXDB_DOCS_URL %}}/organizations/update-org/)

 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param orgID The ID of the organization to update.
 * @return ApiPatchOrgsIDRequest
*/
func (a *OrganizationsApiService) PatchOrgsID(ctx _context.Context, orgID string) ApiPatchOrgsIDRequest {
	return ApiPatchOrgsIDRequest{
		ApiService: a,
		ctx:        ctx,
		orgID:      orgID,
	}
}

/*
 * Execute executes the request
 * @return Organization
 */
func (a *OrganizationsApiService) PatchOrgsIDExecute(r ApiPatchOrgsIDRequest) (Organization, error) {
	returnVal, _, err := a.PatchOrgsIDExecuteWithHttpInfo(r)
	return returnVal, err
}

/*
 * ExecuteWithHttpInfo executes the request with HTTP response info returned. The response body is not available on the
 * returned HTTP response as it will have already been read and closed; access to the response body content should be
 * achieved through the returned response model if applicable.
 * @return Organization
 */
func (a *OrganizationsApiService) PatchOrgsIDExecuteWithHttpInfo(r ApiPatchOrgsIDRequest) (Organization, *_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPatch
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  Organization
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "OrganizationsApiService.PatchOrgsID")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/api/v2/orgs/{orgID}"
	localVarPath = strings.Replace(localVarPath, "{"+"orgID"+"}", _neturl.PathEscape(parameterToString(r.orgID, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.patchOrganizationRequest == nil {
		return localVarReturnValue, nil, reportError("patchOrganizationRequest is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.zapTraceSpan != nil {
		localVarHeaderParams["Zap-Trace-Span"] = parameterToString(*r.zapTraceSpan, "")
	}
	// body params
	localVarPostBody = r.patchOrganizationRequest
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	newErr := GenericOpenAPIError{
		buildHeader: localVarHTTPResponse.Header.Get("X-Influxdb-Build"),
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		body, err := GunzipIfNeeded(localVarHTTPResponse)
		if err != nil {
			body.Close()
			newErr.error = err.Error()
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		localVarBody, err := _io.ReadAll(body)
		body.Close()
		if err != nil {
			newErr.error = err.Error()
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		newErr.body = localVarBody
		newErr.error = localVarHTTPResponse.Status
		if localVarHTTPResponse.StatusCode == 401 {
			var v UnauthorizedRequestError
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
			newErr.model = &v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
		newErr.model = &v
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	body, err := GunzipIfNeeded(localVarHTTPResponse)
	if err != nil {
		body.Close()
		newErr.error = err.Error()
		return localVarReturnValue, localVarHTTPResponse, newErr
	}
	localVarBody, err := _io.ReadAll(body)
	body.Close()
	if err != nil {
		newErr.error = err.Error()
		return localVarReturnValue, localVarHTTPResponse, newErr
	}
	newErr.body = localVarBody
	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr.error = err.Error()
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiPostOrgsRequest struct {
	ctx                     _context.Context
	ApiService              OrganizationsApi
	postOrganizationRequest *PostOrganizationRequest
	zapTraceSpan            *string
}

func (r ApiPostOrgsRequest) PostOrganizationRequest(postOrganizationRequest PostOrganizationRequest) ApiPostOrgsRequest {
	r.postOrganizationRequest = &postOrganizationRequest
	return r
}
func (r ApiPostOrgsRequest) GetPostOrganizationRequest() *PostOrganizationRequest {
	return r.postOrganizationRequest
}

func (r ApiPostOrgsRequest) ZapTraceSpan(zapTraceSpan string) ApiPostOrgsRequest {
	r.zapTraceSpan = &zapTraceSpan
	return r
}
func (r ApiPostOrgsRequest) GetZapTraceSpan() *string {
	return r.zapTraceSpan
}

func (r ApiPostOrgsRequest) Execute() (Organization, error) {
	return r.ApiService.PostOrgsExecute(r)
}

func (r ApiPostOrgsRequest) ExecuteWithHttpInfo() (Organization, *_nethttp.Response, error) {
	return r.ApiService.PostOrgsExecuteWithHttpInfo(r)
}

/*
 * PostOrgs Create an organization
 * Creates an [organization]({{% INFLUXDB_DOCS_URL %}}/reference/glossary/#organization)
and returns the newly created organization.

#### InfluxDB Cloud

- Doesn't allow you to use this endpoint to create organizations.

#### Related guides

- [Manage organizations]({{% INFLUXDB_DOCS_URL %}}/organizations)

 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @return ApiPostOrgsRequest
*/
func (a *OrganizationsApiService) PostOrgs(ctx _context.Context) ApiPostOrgsRequest {
	return ApiPostOrgsRequest{
		ApiService: a,
		ctx:        ctx,
	}
}

/*
 * Execute executes the request
 * @return Organization
 */
func (a *OrganizationsApiService) PostOrgsExecute(r ApiPostOrgsRequest) (Organization, error) {
	returnVal, _, err := a.PostOrgsExecuteWithHttpInfo(r)
	return returnVal, err
}

/*
 * ExecuteWithHttpInfo executes the request with HTTP response info returned. The response body is not available on the
 * returned HTTP response as it will have already been read and closed; access to the response body content should be
 * achieved through the returned response model if applicable.
 * @return Organization
 */
func (a *OrganizationsApiService) PostOrgsExecuteWithHttpInfo(r ApiPostOrgsRequest) (Organization, *_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPost
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  Organization
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "OrganizationsApiService.PostOrgs")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/api/v2/orgs"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.postOrganizationRequest == nil {
		return localVarReturnValue, nil, reportError("postOrganizationRequest is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.zapTraceSpan != nil {
		localVarHeaderParams["Zap-Trace-Span"] = parameterToString(*r.zapTraceSpan, "")
	}
	// body params
	localVarPostBody = r.postOrganizationRequest
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	newErr := GenericOpenAPIError{
		buildHeader: localVarHTTPResponse.Header.Get("X-Influxdb-Build"),
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		body, err := GunzipIfNeeded(localVarHTTPResponse)
		if err != nil {
			body.Close()
			newErr.error = err.Error()
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		localVarBody, err := _io.ReadAll(body)
		body.Close()
		if err != nil {
			newErr.error = err.Error()
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		newErr.body = localVarBody
		newErr.error = localVarHTTPResponse.Status
		if localVarHTTPResponse.StatusCode == 401 {
			var v UnauthorizedRequestError
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
			newErr.model = &v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
		newErr.model = &v
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	body, err := GunzipIfNeeded(localVarHTTPResponse)
	if err != nil {
		body.Close()
		newErr.error = err.Error()
		return localVarReturnValue, localVarHTTPResponse, newErr
	}
	localVarBody, err := _io.ReadAll(body)
	body.Close()
	if err != nil {
		newErr.error = err.Error()
		return localVarReturnValue, localVarHTTPResponse, newErr
	}
	newErr.body = localVarBody
	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr.error = err.Error()
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiPostOrgsIDMembersRequest struct {
	ctx                          _context.Context
	ApiService                   OrganizationsApi
	orgID                        string
	addResourceMemberRequestBody *AddResourceMemberRequestBody
	zapTraceSpan                 *string
}

func (r ApiPostOrgsIDMembersRequest) OrgID(orgID string) ApiPostOrgsIDMembersRequest {
	r.orgID = orgID
	return r
}
func (r ApiPostOrgsIDMembersRequest) GetOrgID() string {
	return r.orgID
}

func (r ApiPostOrgsIDMembersRequest) AddResourceMemberRequestBody(addResourceMemberRequestBody AddResourceMemberRequestBody) ApiPostOrgsIDMembersRequest {
	r.addResourceMemberRequestBody = &addResourceMemberRequestBody
	return r
}
func (r ApiPostOrgsIDMembersRequest) GetAddResourceMemberRequestBody() *AddResourceMemberRequestBody {
	return r.addResourceMemberRequestBody
}

func (r ApiPostOrgsIDMembersRequest) ZapTraceSpan(zapTraceSpan string) ApiPostOrgsIDMembersRequest {
	r.zapTraceSpan = &zapTraceSpan
	return r
}
func (r ApiPostOrgsIDMembersRequest) GetZapTraceSpan() *string {
	return r.zapTraceSpan
}

func (r ApiPostOrgsIDMembersRequest) Execute() (ResourceMember, error) {
	return r.ApiService.PostOrgsIDMembersExecute(r)
}

func (r ApiPostOrgsIDMembersRequest) ExecuteWithHttpInfo() (ResourceMember, *_nethttp.Response, error) {
	return r.ApiService.PostOrgsIDMembersExecuteWithHttpInfo(r)
}

/*
 * PostOrgsIDMembers Add a member to an organization
 * Add a user to an organization.

InfluxDB [users]({{% INFLUXDB_DOCS_URL %}}/reference/glossary/#user) have
permission to access InfluxDB.

[Members]({{% INFLUXDB_DOCS_URL %}}/reference/glossary/#member) are users
within the organization.

#### InfluxDB Cloud
- Doesn't use `owner` and `member` roles.
  Use [`/api/v2/authorizations`](#tag/Authorizations) to assign user permissions.

#### Limitations

- Member permissions are separate from API token permissions.
- Member permissions are used in the context of the InfluxDB UI.

#### Required permissions

- `write-orgs INFLUX_ORG_ID`

*`INFLUX_ORG_ID`* is the ID of the organization that you want to add a member to.

#### Related guides

- [Manage users]({{% INFLUXDB_DOCS_URL %}}/users/)
- [Manage members]({{% INFLUXDB_DOCS_URL %}}/organizations/members/)

 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param orgID The ID of the organization.
 * @return ApiPostOrgsIDMembersRequest
*/
func (a *OrganizationsApiService) PostOrgsIDMembers(ctx _context.Context, orgID string) ApiPostOrgsIDMembersRequest {
	return ApiPostOrgsIDMembersRequest{
		ApiService: a,
		ctx:        ctx,
		orgID:      orgID,
	}
}

/*
 * Execute executes the request
 * @return ResourceMember
 */
func (a *OrganizationsApiService) PostOrgsIDMembersExecute(r ApiPostOrgsIDMembersRequest) (ResourceMember, error) {
	returnVal, _, err := a.PostOrgsIDMembersExecuteWithHttpInfo(r)
	return returnVal, err
}

/*
 * ExecuteWithHttpInfo executes the request with HTTP response info returned. The response body is not available on the
 * returned HTTP response as it will have already been read and closed; access to the response body content should be
 * achieved through the returned response model if applicable.
 * @return ResourceMember
 */
func (a *OrganizationsApiService) PostOrgsIDMembersExecuteWithHttpInfo(r ApiPostOrgsIDMembersRequest) (ResourceMember, *_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPost
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  ResourceMember
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "OrganizationsApiService.PostOrgsIDMembers")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/api/v2/orgs/{orgID}/members"
	localVarPath = strings.Replace(localVarPath, "{"+"orgID"+"}", _neturl.PathEscape(parameterToString(r.orgID, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.addResourceMemberRequestBody == nil {
		return localVarReturnValue, nil, reportError("addResourceMemberRequestBody is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.zapTraceSpan != nil {
		localVarHeaderParams["Zap-Trace-Span"] = parameterToString(*r.zapTraceSpan, "")
	}
	// body params
	localVarPostBody = r.addResourceMemberRequestBody
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	newErr := GenericOpenAPIError{
		buildHeader: localVarHTTPResponse.Header.Get("X-Influxdb-Build"),
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		body, err := GunzipIfNeeded(localVarHTTPResponse)
		if err != nil {
			body.Close()
			newErr.error = err.Error()
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		localVarBody, err := _io.ReadAll(body)
		body.Close()
		if err != nil {
			newErr.error = err.Error()
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		newErr.body = localVarBody
		newErr.error = localVarHTTPResponse.Status
		if localVarHTTPResponse.StatusCode == 401 {
			var v UnauthorizedRequestError
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
			newErr.model = &v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
		newErr.model = &v
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	body, err := GunzipIfNeeded(localVarHTTPResponse)
	if err != nil {
		body.Close()
		newErr.error = err.Error()
		return localVarReturnValue, localVarHTTPResponse, newErr
	}
	localVarBody, err := _io.ReadAll(body)
	body.Close()
	if err != nil {
		newErr.error = err.Error()
		return localVarReturnValue, localVarHTTPResponse, newErr
	}
	newErr.body = localVarBody
	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr.error = err.Error()
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiPostOrgsIDOwnersRequest struct {
	ctx                          _context.Context
	ApiService                   OrganizationsApi
	orgID                        string
	addResourceMemberRequestBody *AddResourceMemberRequestBody
	zapTraceSpan                 *string
}

func (r ApiPostOrgsIDOwnersRequest) OrgID(orgID string) ApiPostOrgsIDOwnersRequest {
	r.orgID = orgID
	return r
}
func (r ApiPostOrgsIDOwnersRequest) GetOrgID() string {
	return r.orgID
}

func (r ApiPostOrgsIDOwnersRequest) AddResourceMemberRequestBody(addResourceMemberRequestBody AddResourceMemberRequestBody) ApiPostOrgsIDOwnersRequest {
	r.addResourceMemberRequestBody = &addResourceMemberRequestBody
	return r
}
func (r ApiPostOrgsIDOwnersRequest) GetAddResourceMemberRequestBody() *AddResourceMemberRequestBody {
	return r.addResourceMemberRequestBody
}

func (r ApiPostOrgsIDOwnersRequest) ZapTraceSpan(zapTraceSpan string) ApiPostOrgsIDOwnersRequest {
	r.zapTraceSpan = &zapTraceSpan
	return r
}
func (r ApiPostOrgsIDOwnersRequest) GetZapTraceSpan() *string {
	return r.zapTraceSpan
}

func (r ApiPostOrgsIDOwnersRequest) Execute() (ResourceOwner, error) {
	return r.ApiService.PostOrgsIDOwnersExecute(r)
}

func (r ApiPostOrgsIDOwnersRequest) ExecuteWithHttpInfo() (ResourceOwner, *_nethttp.Response, error) {
	return r.ApiService.PostOrgsIDOwnersExecuteWithHttpInfo(r)
}

/*
 * PostOrgsIDOwners Add an owner to an organization
 * Adds an owner to an organization.

Use this endpoint to assign the organization `owner` role to a user.

#### InfluxDB Cloud

- Doesn't use `owner` and `member` roles.
  Use [`/api/v2/authorizations`](#tag/Authorizations) to assign user permissions.

#### Required permissions

- `write-orgs INFLUX_ORG_ID`

*`INFLUX_ORG_ID`* is the ID of the organization that you want to add an owner for.

#### Related endpoints

- [Authorizations](#tag/Authorizations)

 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param orgID The ID of the organization that you want to add an owner for.
 * @return ApiPostOrgsIDOwnersRequest
*/
func (a *OrganizationsApiService) PostOrgsIDOwners(ctx _context.Context, orgID string) ApiPostOrgsIDOwnersRequest {
	return ApiPostOrgsIDOwnersRequest{
		ApiService: a,
		ctx:        ctx,
		orgID:      orgID,
	}
}

/*
 * Execute executes the request
 * @return ResourceOwner
 */
func (a *OrganizationsApiService) PostOrgsIDOwnersExecute(r ApiPostOrgsIDOwnersRequest) (ResourceOwner, error) {
	returnVal, _, err := a.PostOrgsIDOwnersExecuteWithHttpInfo(r)
	return returnVal, err
}

/*
 * ExecuteWithHttpInfo executes the request with HTTP response info returned. The response body is not available on the
 * returned HTTP response as it will have already been read and closed; access to the response body content should be
 * achieved through the returned response model if applicable.
 * @return ResourceOwner
 */
func (a *OrganizationsApiService) PostOrgsIDOwnersExecuteWithHttpInfo(r ApiPostOrgsIDOwnersRequest) (ResourceOwner, *_nethttp.Response, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPost
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  ResourceOwner
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "OrganizationsApiService.PostOrgsIDOwners")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/api/v2/orgs/{orgID}/owners"
	localVarPath = strings.Replace(localVarPath, "{"+"orgID"+"}", _neturl.PathEscape(parameterToString(r.orgID, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.addResourceMemberRequestBody == nil {
		return localVarReturnValue, nil, reportError("addResourceMemberRequestBody is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.zapTraceSpan != nil {
		localVarHeaderParams["Zap-Trace-Span"] = parameterToString(*r.zapTraceSpan, "")
	}
	// body params
	localVarPostBody = r.addResourceMemberRequestBody
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	newErr := GenericOpenAPIError{
		buildHeader: localVarHTTPResponse.Header.Get("X-Influxdb-Build"),
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		body, err := GunzipIfNeeded(localVarHTTPResponse)
		if err != nil {
			body.Close()
			newErr.error = err.Error()
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		localVarBody, err := _io.ReadAll(body)
		body.Close()
		if err != nil {
			newErr.error = err.Error()
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		newErr.body = localVarBody
		newErr.error = localVarHTTPResponse.Status
		if localVarHTTPResponse.StatusCode == 401 {
			var v UnauthorizedRequestError
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
			newErr.model = &v
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = _fmt.Sprintf("%s: %s", newErr.Error(), err.Error())
			return localVarReturnValue, localVarHTTPResponse, newErr
		}
		v.SetMessage(_fmt.Sprintf("%s: %s", newErr.Error(), v.GetMessage()))
		newErr.model = &v
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	body, err := GunzipIfNeeded(localVarHTTPResponse)
	if err != nil {
		body.Close()
		newErr.error = err.Error()
		return localVarReturnValue, localVarHTTPResponse, newErr
	}
	localVarBody, err := _io.ReadAll(body)
	body.Close()
	if err != nil {
		newErr.error = err.Error()
		return localVarReturnValue, localVarHTTPResponse, newErr
	}
	newErr.body = localVarBody
	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr.error = err.Error()
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}
