// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/dataplex/v1/business_glossary.proto

package dataplexpb

import (
	context "context"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	BusinessGlossaryService_CreateGlossary_FullMethodName         = "/google.cloud.dataplex.v1.BusinessGlossaryService/CreateGlossary"
	BusinessGlossaryService_UpdateGlossary_FullMethodName         = "/google.cloud.dataplex.v1.BusinessGlossaryService/UpdateGlossary"
	BusinessGlossaryService_DeleteGlossary_FullMethodName         = "/google.cloud.dataplex.v1.BusinessGlossaryService/DeleteGlossary"
	BusinessGlossaryService_GetGlossary_FullMethodName            = "/google.cloud.dataplex.v1.BusinessGlossaryService/GetGlossary"
	BusinessGlossaryService_ListGlossaries_FullMethodName         = "/google.cloud.dataplex.v1.BusinessGlossaryService/ListGlossaries"
	BusinessGlossaryService_CreateGlossaryCategory_FullMethodName = "/google.cloud.dataplex.v1.BusinessGlossaryService/CreateGlossaryCategory"
	BusinessGlossaryService_UpdateGlossaryCategory_FullMethodName = "/google.cloud.dataplex.v1.BusinessGlossaryService/UpdateGlossaryCategory"
	BusinessGlossaryService_DeleteGlossaryCategory_FullMethodName = "/google.cloud.dataplex.v1.BusinessGlossaryService/DeleteGlossaryCategory"
	BusinessGlossaryService_GetGlossaryCategory_FullMethodName    = "/google.cloud.dataplex.v1.BusinessGlossaryService/GetGlossaryCategory"
	BusinessGlossaryService_ListGlossaryCategories_FullMethodName = "/google.cloud.dataplex.v1.BusinessGlossaryService/ListGlossaryCategories"
	BusinessGlossaryService_CreateGlossaryTerm_FullMethodName     = "/google.cloud.dataplex.v1.BusinessGlossaryService/CreateGlossaryTerm"
	BusinessGlossaryService_UpdateGlossaryTerm_FullMethodName     = "/google.cloud.dataplex.v1.BusinessGlossaryService/UpdateGlossaryTerm"
	BusinessGlossaryService_DeleteGlossaryTerm_FullMethodName     = "/google.cloud.dataplex.v1.BusinessGlossaryService/DeleteGlossaryTerm"
	BusinessGlossaryService_GetGlossaryTerm_FullMethodName        = "/google.cloud.dataplex.v1.BusinessGlossaryService/GetGlossaryTerm"
	BusinessGlossaryService_ListGlossaryTerms_FullMethodName      = "/google.cloud.dataplex.v1.BusinessGlossaryService/ListGlossaryTerms"
)

// BusinessGlossaryServiceClient is the client API for BusinessGlossaryService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type BusinessGlossaryServiceClient interface {
	// Creates a new Glossary resource.
	CreateGlossary(ctx context.Context, in *CreateGlossaryRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates a Glossary resource.
	UpdateGlossary(ctx context.Context, in *UpdateGlossaryRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a Glossary resource. All the categories and terms within the
	// Glossary must be deleted before the Glossary can be deleted.
	DeleteGlossary(ctx context.Context, in *DeleteGlossaryRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets a Glossary resource.
	GetGlossary(ctx context.Context, in *GetGlossaryRequest, opts ...grpc.CallOption) (*Glossary, error)
	// Lists Glossary resources in a project and location.
	ListGlossaries(ctx context.Context, in *ListGlossariesRequest, opts ...grpc.CallOption) (*ListGlossariesResponse, error)
	// Creates a new GlossaryCategory resource.
	CreateGlossaryCategory(ctx context.Context, in *CreateGlossaryCategoryRequest, opts ...grpc.CallOption) (*GlossaryCategory, error)
	// Updates a GlossaryCategory resource.
	UpdateGlossaryCategory(ctx context.Context, in *UpdateGlossaryCategoryRequest, opts ...grpc.CallOption) (*GlossaryCategory, error)
	// Deletes a GlossaryCategory resource. All the GlossaryCategories and
	// GlossaryTerms nested directly under the specified GlossaryCategory will be
	// moved one level up to the parent in the hierarchy.
	DeleteGlossaryCategory(ctx context.Context, in *DeleteGlossaryCategoryRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Gets a GlossaryCategory resource.
	GetGlossaryCategory(ctx context.Context, in *GetGlossaryCategoryRequest, opts ...grpc.CallOption) (*GlossaryCategory, error)
	// Lists GlossaryCategory resources in a Glossary.
	ListGlossaryCategories(ctx context.Context, in *ListGlossaryCategoriesRequest, opts ...grpc.CallOption) (*ListGlossaryCategoriesResponse, error)
	// Creates a new GlossaryTerm resource.
	CreateGlossaryTerm(ctx context.Context, in *CreateGlossaryTermRequest, opts ...grpc.CallOption) (*GlossaryTerm, error)
	// Updates a GlossaryTerm resource.
	UpdateGlossaryTerm(ctx context.Context, in *UpdateGlossaryTermRequest, opts ...grpc.CallOption) (*GlossaryTerm, error)
	// Deletes a GlossaryTerm resource.
	DeleteGlossaryTerm(ctx context.Context, in *DeleteGlossaryTermRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Gets a GlossaryTerm resource.
	GetGlossaryTerm(ctx context.Context, in *GetGlossaryTermRequest, opts ...grpc.CallOption) (*GlossaryTerm, error)
	// Lists GlossaryTerm resources in a Glossary.
	ListGlossaryTerms(ctx context.Context, in *ListGlossaryTermsRequest, opts ...grpc.CallOption) (*ListGlossaryTermsResponse, error)
}

type businessGlossaryServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewBusinessGlossaryServiceClient(cc grpc.ClientConnInterface) BusinessGlossaryServiceClient {
	return &businessGlossaryServiceClient{cc}
}

func (c *businessGlossaryServiceClient) CreateGlossary(ctx context.Context, in *CreateGlossaryRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, BusinessGlossaryService_CreateGlossary_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *businessGlossaryServiceClient) UpdateGlossary(ctx context.Context, in *UpdateGlossaryRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, BusinessGlossaryService_UpdateGlossary_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *businessGlossaryServiceClient) DeleteGlossary(ctx context.Context, in *DeleteGlossaryRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, BusinessGlossaryService_DeleteGlossary_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *businessGlossaryServiceClient) GetGlossary(ctx context.Context, in *GetGlossaryRequest, opts ...grpc.CallOption) (*Glossary, error) {
	out := new(Glossary)
	err := c.cc.Invoke(ctx, BusinessGlossaryService_GetGlossary_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *businessGlossaryServiceClient) ListGlossaries(ctx context.Context, in *ListGlossariesRequest, opts ...grpc.CallOption) (*ListGlossariesResponse, error) {
	out := new(ListGlossariesResponse)
	err := c.cc.Invoke(ctx, BusinessGlossaryService_ListGlossaries_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *businessGlossaryServiceClient) CreateGlossaryCategory(ctx context.Context, in *CreateGlossaryCategoryRequest, opts ...grpc.CallOption) (*GlossaryCategory, error) {
	out := new(GlossaryCategory)
	err := c.cc.Invoke(ctx, BusinessGlossaryService_CreateGlossaryCategory_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *businessGlossaryServiceClient) UpdateGlossaryCategory(ctx context.Context, in *UpdateGlossaryCategoryRequest, opts ...grpc.CallOption) (*GlossaryCategory, error) {
	out := new(GlossaryCategory)
	err := c.cc.Invoke(ctx, BusinessGlossaryService_UpdateGlossaryCategory_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *businessGlossaryServiceClient) DeleteGlossaryCategory(ctx context.Context, in *DeleteGlossaryCategoryRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, BusinessGlossaryService_DeleteGlossaryCategory_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *businessGlossaryServiceClient) GetGlossaryCategory(ctx context.Context, in *GetGlossaryCategoryRequest, opts ...grpc.CallOption) (*GlossaryCategory, error) {
	out := new(GlossaryCategory)
	err := c.cc.Invoke(ctx, BusinessGlossaryService_GetGlossaryCategory_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *businessGlossaryServiceClient) ListGlossaryCategories(ctx context.Context, in *ListGlossaryCategoriesRequest, opts ...grpc.CallOption) (*ListGlossaryCategoriesResponse, error) {
	out := new(ListGlossaryCategoriesResponse)
	err := c.cc.Invoke(ctx, BusinessGlossaryService_ListGlossaryCategories_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *businessGlossaryServiceClient) CreateGlossaryTerm(ctx context.Context, in *CreateGlossaryTermRequest, opts ...grpc.CallOption) (*GlossaryTerm, error) {
	out := new(GlossaryTerm)
	err := c.cc.Invoke(ctx, BusinessGlossaryService_CreateGlossaryTerm_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *businessGlossaryServiceClient) UpdateGlossaryTerm(ctx context.Context, in *UpdateGlossaryTermRequest, opts ...grpc.CallOption) (*GlossaryTerm, error) {
	out := new(GlossaryTerm)
	err := c.cc.Invoke(ctx, BusinessGlossaryService_UpdateGlossaryTerm_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *businessGlossaryServiceClient) DeleteGlossaryTerm(ctx context.Context, in *DeleteGlossaryTermRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, BusinessGlossaryService_DeleteGlossaryTerm_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *businessGlossaryServiceClient) GetGlossaryTerm(ctx context.Context, in *GetGlossaryTermRequest, opts ...grpc.CallOption) (*GlossaryTerm, error) {
	out := new(GlossaryTerm)
	err := c.cc.Invoke(ctx, BusinessGlossaryService_GetGlossaryTerm_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *businessGlossaryServiceClient) ListGlossaryTerms(ctx context.Context, in *ListGlossaryTermsRequest, opts ...grpc.CallOption) (*ListGlossaryTermsResponse, error) {
	out := new(ListGlossaryTermsResponse)
	err := c.cc.Invoke(ctx, BusinessGlossaryService_ListGlossaryTerms_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// BusinessGlossaryServiceServer is the server API for BusinessGlossaryService service.
// All implementations should embed UnimplementedBusinessGlossaryServiceServer
// for forward compatibility
type BusinessGlossaryServiceServer interface {
	// Creates a new Glossary resource.
	CreateGlossary(context.Context, *CreateGlossaryRequest) (*longrunningpb.Operation, error)
	// Updates a Glossary resource.
	UpdateGlossary(context.Context, *UpdateGlossaryRequest) (*longrunningpb.Operation, error)
	// Deletes a Glossary resource. All the categories and terms within the
	// Glossary must be deleted before the Glossary can be deleted.
	DeleteGlossary(context.Context, *DeleteGlossaryRequest) (*longrunningpb.Operation, error)
	// Gets a Glossary resource.
	GetGlossary(context.Context, *GetGlossaryRequest) (*Glossary, error)
	// Lists Glossary resources in a project and location.
	ListGlossaries(context.Context, *ListGlossariesRequest) (*ListGlossariesResponse, error)
	// Creates a new GlossaryCategory resource.
	CreateGlossaryCategory(context.Context, *CreateGlossaryCategoryRequest) (*GlossaryCategory, error)
	// Updates a GlossaryCategory resource.
	UpdateGlossaryCategory(context.Context, *UpdateGlossaryCategoryRequest) (*GlossaryCategory, error)
	// Deletes a GlossaryCategory resource. All the GlossaryCategories and
	// GlossaryTerms nested directly under the specified GlossaryCategory will be
	// moved one level up to the parent in the hierarchy.
	DeleteGlossaryCategory(context.Context, *DeleteGlossaryCategoryRequest) (*emptypb.Empty, error)
	// Gets a GlossaryCategory resource.
	GetGlossaryCategory(context.Context, *GetGlossaryCategoryRequest) (*GlossaryCategory, error)
	// Lists GlossaryCategory resources in a Glossary.
	ListGlossaryCategories(context.Context, *ListGlossaryCategoriesRequest) (*ListGlossaryCategoriesResponse, error)
	// Creates a new GlossaryTerm resource.
	CreateGlossaryTerm(context.Context, *CreateGlossaryTermRequest) (*GlossaryTerm, error)
	// Updates a GlossaryTerm resource.
	UpdateGlossaryTerm(context.Context, *UpdateGlossaryTermRequest) (*GlossaryTerm, error)
	// Deletes a GlossaryTerm resource.
	DeleteGlossaryTerm(context.Context, *DeleteGlossaryTermRequest) (*emptypb.Empty, error)
	// Gets a GlossaryTerm resource.
	GetGlossaryTerm(context.Context, *GetGlossaryTermRequest) (*GlossaryTerm, error)
	// Lists GlossaryTerm resources in a Glossary.
	ListGlossaryTerms(context.Context, *ListGlossaryTermsRequest) (*ListGlossaryTermsResponse, error)
}

// UnimplementedBusinessGlossaryServiceServer should be embedded to have forward compatible implementations.
type UnimplementedBusinessGlossaryServiceServer struct {
}

func (UnimplementedBusinessGlossaryServiceServer) CreateGlossary(context.Context, *CreateGlossaryRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateGlossary not implemented")
}
func (UnimplementedBusinessGlossaryServiceServer) UpdateGlossary(context.Context, *UpdateGlossaryRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateGlossary not implemented")
}
func (UnimplementedBusinessGlossaryServiceServer) DeleteGlossary(context.Context, *DeleteGlossaryRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteGlossary not implemented")
}
func (UnimplementedBusinessGlossaryServiceServer) GetGlossary(context.Context, *GetGlossaryRequest) (*Glossary, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetGlossary not implemented")
}
func (UnimplementedBusinessGlossaryServiceServer) ListGlossaries(context.Context, *ListGlossariesRequest) (*ListGlossariesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListGlossaries not implemented")
}
func (UnimplementedBusinessGlossaryServiceServer) CreateGlossaryCategory(context.Context, *CreateGlossaryCategoryRequest) (*GlossaryCategory, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateGlossaryCategory not implemented")
}
func (UnimplementedBusinessGlossaryServiceServer) UpdateGlossaryCategory(context.Context, *UpdateGlossaryCategoryRequest) (*GlossaryCategory, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateGlossaryCategory not implemented")
}
func (UnimplementedBusinessGlossaryServiceServer) DeleteGlossaryCategory(context.Context, *DeleteGlossaryCategoryRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteGlossaryCategory not implemented")
}
func (UnimplementedBusinessGlossaryServiceServer) GetGlossaryCategory(context.Context, *GetGlossaryCategoryRequest) (*GlossaryCategory, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetGlossaryCategory not implemented")
}
func (UnimplementedBusinessGlossaryServiceServer) ListGlossaryCategories(context.Context, *ListGlossaryCategoriesRequest) (*ListGlossaryCategoriesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListGlossaryCategories not implemented")
}
func (UnimplementedBusinessGlossaryServiceServer) CreateGlossaryTerm(context.Context, *CreateGlossaryTermRequest) (*GlossaryTerm, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateGlossaryTerm not implemented")
}
func (UnimplementedBusinessGlossaryServiceServer) UpdateGlossaryTerm(context.Context, *UpdateGlossaryTermRequest) (*GlossaryTerm, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateGlossaryTerm not implemented")
}
func (UnimplementedBusinessGlossaryServiceServer) DeleteGlossaryTerm(context.Context, *DeleteGlossaryTermRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteGlossaryTerm not implemented")
}
func (UnimplementedBusinessGlossaryServiceServer) GetGlossaryTerm(context.Context, *GetGlossaryTermRequest) (*GlossaryTerm, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetGlossaryTerm not implemented")
}
func (UnimplementedBusinessGlossaryServiceServer) ListGlossaryTerms(context.Context, *ListGlossaryTermsRequest) (*ListGlossaryTermsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListGlossaryTerms not implemented")
}

// UnsafeBusinessGlossaryServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to BusinessGlossaryServiceServer will
// result in compilation errors.
type UnsafeBusinessGlossaryServiceServer interface {
	mustEmbedUnimplementedBusinessGlossaryServiceServer()
}

func RegisterBusinessGlossaryServiceServer(s grpc.ServiceRegistrar, srv BusinessGlossaryServiceServer) {
	s.RegisterService(&BusinessGlossaryService_ServiceDesc, srv)
}

func _BusinessGlossaryService_CreateGlossary_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateGlossaryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BusinessGlossaryServiceServer).CreateGlossary(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BusinessGlossaryService_CreateGlossary_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BusinessGlossaryServiceServer).CreateGlossary(ctx, req.(*CreateGlossaryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BusinessGlossaryService_UpdateGlossary_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateGlossaryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BusinessGlossaryServiceServer).UpdateGlossary(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BusinessGlossaryService_UpdateGlossary_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BusinessGlossaryServiceServer).UpdateGlossary(ctx, req.(*UpdateGlossaryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BusinessGlossaryService_DeleteGlossary_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteGlossaryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BusinessGlossaryServiceServer).DeleteGlossary(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BusinessGlossaryService_DeleteGlossary_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BusinessGlossaryServiceServer).DeleteGlossary(ctx, req.(*DeleteGlossaryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BusinessGlossaryService_GetGlossary_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetGlossaryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BusinessGlossaryServiceServer).GetGlossary(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BusinessGlossaryService_GetGlossary_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BusinessGlossaryServiceServer).GetGlossary(ctx, req.(*GetGlossaryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BusinessGlossaryService_ListGlossaries_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListGlossariesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BusinessGlossaryServiceServer).ListGlossaries(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BusinessGlossaryService_ListGlossaries_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BusinessGlossaryServiceServer).ListGlossaries(ctx, req.(*ListGlossariesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BusinessGlossaryService_CreateGlossaryCategory_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateGlossaryCategoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BusinessGlossaryServiceServer).CreateGlossaryCategory(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BusinessGlossaryService_CreateGlossaryCategory_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BusinessGlossaryServiceServer).CreateGlossaryCategory(ctx, req.(*CreateGlossaryCategoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BusinessGlossaryService_UpdateGlossaryCategory_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateGlossaryCategoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BusinessGlossaryServiceServer).UpdateGlossaryCategory(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BusinessGlossaryService_UpdateGlossaryCategory_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BusinessGlossaryServiceServer).UpdateGlossaryCategory(ctx, req.(*UpdateGlossaryCategoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BusinessGlossaryService_DeleteGlossaryCategory_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteGlossaryCategoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BusinessGlossaryServiceServer).DeleteGlossaryCategory(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BusinessGlossaryService_DeleteGlossaryCategory_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BusinessGlossaryServiceServer).DeleteGlossaryCategory(ctx, req.(*DeleteGlossaryCategoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BusinessGlossaryService_GetGlossaryCategory_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetGlossaryCategoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BusinessGlossaryServiceServer).GetGlossaryCategory(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BusinessGlossaryService_GetGlossaryCategory_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BusinessGlossaryServiceServer).GetGlossaryCategory(ctx, req.(*GetGlossaryCategoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BusinessGlossaryService_ListGlossaryCategories_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListGlossaryCategoriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BusinessGlossaryServiceServer).ListGlossaryCategories(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BusinessGlossaryService_ListGlossaryCategories_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BusinessGlossaryServiceServer).ListGlossaryCategories(ctx, req.(*ListGlossaryCategoriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BusinessGlossaryService_CreateGlossaryTerm_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateGlossaryTermRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BusinessGlossaryServiceServer).CreateGlossaryTerm(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BusinessGlossaryService_CreateGlossaryTerm_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BusinessGlossaryServiceServer).CreateGlossaryTerm(ctx, req.(*CreateGlossaryTermRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BusinessGlossaryService_UpdateGlossaryTerm_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateGlossaryTermRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BusinessGlossaryServiceServer).UpdateGlossaryTerm(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BusinessGlossaryService_UpdateGlossaryTerm_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BusinessGlossaryServiceServer).UpdateGlossaryTerm(ctx, req.(*UpdateGlossaryTermRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BusinessGlossaryService_DeleteGlossaryTerm_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteGlossaryTermRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BusinessGlossaryServiceServer).DeleteGlossaryTerm(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BusinessGlossaryService_DeleteGlossaryTerm_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BusinessGlossaryServiceServer).DeleteGlossaryTerm(ctx, req.(*DeleteGlossaryTermRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BusinessGlossaryService_GetGlossaryTerm_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetGlossaryTermRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BusinessGlossaryServiceServer).GetGlossaryTerm(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BusinessGlossaryService_GetGlossaryTerm_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BusinessGlossaryServiceServer).GetGlossaryTerm(ctx, req.(*GetGlossaryTermRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BusinessGlossaryService_ListGlossaryTerms_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListGlossaryTermsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BusinessGlossaryServiceServer).ListGlossaryTerms(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BusinessGlossaryService_ListGlossaryTerms_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BusinessGlossaryServiceServer).ListGlossaryTerms(ctx, req.(*ListGlossaryTermsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// BusinessGlossaryService_ServiceDesc is the grpc.ServiceDesc for BusinessGlossaryService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var BusinessGlossaryService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dataplex.v1.BusinessGlossaryService",
	HandlerType: (*BusinessGlossaryServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateGlossary",
			Handler:    _BusinessGlossaryService_CreateGlossary_Handler,
		},
		{
			MethodName: "UpdateGlossary",
			Handler:    _BusinessGlossaryService_UpdateGlossary_Handler,
		},
		{
			MethodName: "DeleteGlossary",
			Handler:    _BusinessGlossaryService_DeleteGlossary_Handler,
		},
		{
			MethodName: "GetGlossary",
			Handler:    _BusinessGlossaryService_GetGlossary_Handler,
		},
		{
			MethodName: "ListGlossaries",
			Handler:    _BusinessGlossaryService_ListGlossaries_Handler,
		},
		{
			MethodName: "CreateGlossaryCategory",
			Handler:    _BusinessGlossaryService_CreateGlossaryCategory_Handler,
		},
		{
			MethodName: "UpdateGlossaryCategory",
			Handler:    _BusinessGlossaryService_UpdateGlossaryCategory_Handler,
		},
		{
			MethodName: "DeleteGlossaryCategory",
			Handler:    _BusinessGlossaryService_DeleteGlossaryCategory_Handler,
		},
		{
			MethodName: "GetGlossaryCategory",
			Handler:    _BusinessGlossaryService_GetGlossaryCategory_Handler,
		},
		{
			MethodName: "ListGlossaryCategories",
			Handler:    _BusinessGlossaryService_ListGlossaryCategories_Handler,
		},
		{
			MethodName: "CreateGlossaryTerm",
			Handler:    _BusinessGlossaryService_CreateGlossaryTerm_Handler,
		},
		{
			MethodName: "UpdateGlossaryTerm",
			Handler:    _BusinessGlossaryService_UpdateGlossaryTerm_Handler,
		},
		{
			MethodName: "DeleteGlossaryTerm",
			Handler:    _BusinessGlossaryService_DeleteGlossaryTerm_Handler,
		},
		{
			MethodName: "GetGlossaryTerm",
			Handler:    _BusinessGlossaryService_GetGlossaryTerm_Handler,
		},
		{
			MethodName: "ListGlossaryTerms",
			Handler:    _BusinessGlossaryService_ListGlossaryTerms_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dataplex/v1/business_glossary.proto",
}
