// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/dataplex/v1/data_profile.proto

package dataplexpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Execution state for the exporting.
type DataProfileResult_PostScanActionsResult_BigQueryExportResult_State int32

const (
	// The exporting state is unspecified.
	DataProfileResult_PostScanActionsResult_BigQueryExportResult_STATE_UNSPECIFIED DataProfileResult_PostScanActionsResult_BigQueryExportResult_State = 0
	// The exporting completed successfully.
	DataProfileResult_PostScanActionsResult_BigQueryExportResult_SUCCEEDED DataProfileResult_PostScanActionsResult_BigQueryExportResult_State = 1
	// The exporting is no longer running due to an error.
	DataProfileResult_PostScanActionsResult_BigQueryExportResult_FAILED DataProfileResult_PostScanActionsResult_BigQueryExportResult_State = 2
	// The exporting is skipped due to no valid scan result to export
	// (usually caused by scan failed).
	DataProfileResult_PostScanActionsResult_BigQueryExportResult_SKIPPED DataProfileResult_PostScanActionsResult_BigQueryExportResult_State = 3
)

// Enum value maps for DataProfileResult_PostScanActionsResult_BigQueryExportResult_State.
var (
	DataProfileResult_PostScanActionsResult_BigQueryExportResult_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "SUCCEEDED",
		2: "FAILED",
		3: "SKIPPED",
	}
	DataProfileResult_PostScanActionsResult_BigQueryExportResult_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"SUCCEEDED":         1,
		"FAILED":            2,
		"SKIPPED":           3,
	}
)

func (x DataProfileResult_PostScanActionsResult_BigQueryExportResult_State) Enum() *DataProfileResult_PostScanActionsResult_BigQueryExportResult_State {
	p := new(DataProfileResult_PostScanActionsResult_BigQueryExportResult_State)
	*p = x
	return p
}

func (x DataProfileResult_PostScanActionsResult_BigQueryExportResult_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DataProfileResult_PostScanActionsResult_BigQueryExportResult_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataplex_v1_data_profile_proto_enumTypes[0].Descriptor()
}

func (DataProfileResult_PostScanActionsResult_BigQueryExportResult_State) Type() protoreflect.EnumType {
	return &file_google_cloud_dataplex_v1_data_profile_proto_enumTypes[0]
}

func (x DataProfileResult_PostScanActionsResult_BigQueryExportResult_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DataProfileResult_PostScanActionsResult_BigQueryExportResult_State.Descriptor instead.
func (DataProfileResult_PostScanActionsResult_BigQueryExportResult_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_data_profile_proto_rawDescGZIP(), []int{1, 1, 0, 0}
}

// DataProfileScan related setting.
type DataProfileSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The percentage of the records to be selected from the dataset for
	// DataScan.
	//
	// * Value can range between 0.0 and 100.0 with up to 3 significant decimal
	// digits.
	// * Sampling is not applied if `sampling_percent` is not specified, 0 or
	// 100.
	SamplingPercent float32 `protobuf:"fixed32,2,opt,name=sampling_percent,json=samplingPercent,proto3" json:"sampling_percent,omitempty"`
	// Optional. A filter applied to all rows in a single DataScan job.
	// The filter needs to be a valid SQL expression for a WHERE clause in
	// BigQuery standard SQL syntax.
	// Example: col1 >= 0 AND col2 < 10
	RowFilter string `protobuf:"bytes,3,opt,name=row_filter,json=rowFilter,proto3" json:"row_filter,omitempty"`
	// Optional. Actions to take upon job completion..
	PostScanActions *DataProfileSpec_PostScanActions `protobuf:"bytes,4,opt,name=post_scan_actions,json=postScanActions,proto3" json:"post_scan_actions,omitempty"`
	// Optional. The fields to include in data profile.
	//
	// If not specified, all fields at the time of profile scan job execution are
	// included, except for ones listed in `exclude_fields`.
	IncludeFields *DataProfileSpec_SelectedFields `protobuf:"bytes,5,opt,name=include_fields,json=includeFields,proto3" json:"include_fields,omitempty"`
	// Optional. The fields to exclude from data profile.
	//
	// If specified, the fields will be excluded from data profile, regardless of
	// `include_fields` value.
	ExcludeFields *DataProfileSpec_SelectedFields `protobuf:"bytes,6,opt,name=exclude_fields,json=excludeFields,proto3" json:"exclude_fields,omitempty"`
	// Optional. If set, the latest DataScan job result will be published as
	// Dataplex Universal Catalog metadata.
	CatalogPublishingEnabled bool `protobuf:"varint,8,opt,name=catalog_publishing_enabled,json=catalogPublishingEnabled,proto3" json:"catalog_publishing_enabled,omitempty"`
}

func (x *DataProfileSpec) Reset() {
	*x = DataProfileSpec{}
	mi := &file_google_cloud_dataplex_v1_data_profile_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataProfileSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataProfileSpec) ProtoMessage() {}

func (x *DataProfileSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_data_profile_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataProfileSpec.ProtoReflect.Descriptor instead.
func (*DataProfileSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_data_profile_proto_rawDescGZIP(), []int{0}
}

func (x *DataProfileSpec) GetSamplingPercent() float32 {
	if x != nil {
		return x.SamplingPercent
	}
	return 0
}

func (x *DataProfileSpec) GetRowFilter() string {
	if x != nil {
		return x.RowFilter
	}
	return ""
}

func (x *DataProfileSpec) GetPostScanActions() *DataProfileSpec_PostScanActions {
	if x != nil {
		return x.PostScanActions
	}
	return nil
}

func (x *DataProfileSpec) GetIncludeFields() *DataProfileSpec_SelectedFields {
	if x != nil {
		return x.IncludeFields
	}
	return nil
}

func (x *DataProfileSpec) GetExcludeFields() *DataProfileSpec_SelectedFields {
	if x != nil {
		return x.ExcludeFields
	}
	return nil
}

func (x *DataProfileSpec) GetCatalogPublishingEnabled() bool {
	if x != nil {
		return x.CatalogPublishingEnabled
	}
	return false
}

// DataProfileResult defines the output of DataProfileScan. Each field of the
// table will have field type specific profile result.
type DataProfileResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The count of rows scanned.
	RowCount int64 `protobuf:"varint,3,opt,name=row_count,json=rowCount,proto3" json:"row_count,omitempty"`
	// Output only. The profile information per field.
	Profile *DataProfileResult_Profile `protobuf:"bytes,4,opt,name=profile,proto3" json:"profile,omitempty"`
	// Output only. The data scanned for this result.
	ScannedData *ScannedData `protobuf:"bytes,5,opt,name=scanned_data,json=scannedData,proto3" json:"scanned_data,omitempty"`
	// Output only. The result of post scan actions.
	PostScanActionsResult *DataProfileResult_PostScanActionsResult `protobuf:"bytes,6,opt,name=post_scan_actions_result,json=postScanActionsResult,proto3" json:"post_scan_actions_result,omitempty"`
	// Output only. The status of publishing the data scan as Dataplex Universal
	// Catalog metadata.
	CatalogPublishingStatus *DataScanCatalogPublishingStatus `protobuf:"bytes,7,opt,name=catalog_publishing_status,json=catalogPublishingStatus,proto3" json:"catalog_publishing_status,omitempty"`
}

func (x *DataProfileResult) Reset() {
	*x = DataProfileResult{}
	mi := &file_google_cloud_dataplex_v1_data_profile_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataProfileResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataProfileResult) ProtoMessage() {}

func (x *DataProfileResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_data_profile_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataProfileResult.ProtoReflect.Descriptor instead.
func (*DataProfileResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_data_profile_proto_rawDescGZIP(), []int{1}
}

func (x *DataProfileResult) GetRowCount() int64 {
	if x != nil {
		return x.RowCount
	}
	return 0
}

func (x *DataProfileResult) GetProfile() *DataProfileResult_Profile {
	if x != nil {
		return x.Profile
	}
	return nil
}

func (x *DataProfileResult) GetScannedData() *ScannedData {
	if x != nil {
		return x.ScannedData
	}
	return nil
}

func (x *DataProfileResult) GetPostScanActionsResult() *DataProfileResult_PostScanActionsResult {
	if x != nil {
		return x.PostScanActionsResult
	}
	return nil
}

func (x *DataProfileResult) GetCatalogPublishingStatus() *DataScanCatalogPublishingStatus {
	if x != nil {
		return x.CatalogPublishingStatus
	}
	return nil
}

// The configuration of post scan actions of DataProfileScan job.
type DataProfileSpec_PostScanActions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. If set, results will be exported to the provided BigQuery
	// table.
	BigqueryExport *DataProfileSpec_PostScanActions_BigQueryExport `protobuf:"bytes,1,opt,name=bigquery_export,json=bigqueryExport,proto3" json:"bigquery_export,omitempty"`
}

func (x *DataProfileSpec_PostScanActions) Reset() {
	*x = DataProfileSpec_PostScanActions{}
	mi := &file_google_cloud_dataplex_v1_data_profile_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataProfileSpec_PostScanActions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataProfileSpec_PostScanActions) ProtoMessage() {}

func (x *DataProfileSpec_PostScanActions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_data_profile_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataProfileSpec_PostScanActions.ProtoReflect.Descriptor instead.
func (*DataProfileSpec_PostScanActions) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_data_profile_proto_rawDescGZIP(), []int{0, 0}
}

func (x *DataProfileSpec_PostScanActions) GetBigqueryExport() *DataProfileSpec_PostScanActions_BigQueryExport {
	if x != nil {
		return x.BigqueryExport
	}
	return nil
}

// The specification for fields to include or exclude in data profile scan.
type DataProfileSpec_SelectedFields struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Expected input is a list of fully qualified names of fields as
	// in the schema.
	//
	// Only top-level field names for nested fields are supported.
	// For instance, if 'x' is of nested field type, listing 'x' is supported
	// but 'x.y.z' is not supported. Here 'y' and 'y.z' are nested fields of
	// 'x'.
	FieldNames []string `protobuf:"bytes,1,rep,name=field_names,json=fieldNames,proto3" json:"field_names,omitempty"`
}

func (x *DataProfileSpec_SelectedFields) Reset() {
	*x = DataProfileSpec_SelectedFields{}
	mi := &file_google_cloud_dataplex_v1_data_profile_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataProfileSpec_SelectedFields) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataProfileSpec_SelectedFields) ProtoMessage() {}

func (x *DataProfileSpec_SelectedFields) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_data_profile_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataProfileSpec_SelectedFields.ProtoReflect.Descriptor instead.
func (*DataProfileSpec_SelectedFields) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_data_profile_proto_rawDescGZIP(), []int{0, 1}
}

func (x *DataProfileSpec_SelectedFields) GetFieldNames() []string {
	if x != nil {
		return x.FieldNames
	}
	return nil
}

// The configuration of BigQuery export post scan action.
type DataProfileSpec_PostScanActions_BigQueryExport struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The BigQuery table to export DataProfileScan results to.
	// Format:
	// //bigquery.googleapis.com/projects/PROJECT_ID/datasets/DATASET_ID/tables/TABLE_ID
	ResultsTable string `protobuf:"bytes,1,opt,name=results_table,json=resultsTable,proto3" json:"results_table,omitempty"`
}

func (x *DataProfileSpec_PostScanActions_BigQueryExport) Reset() {
	*x = DataProfileSpec_PostScanActions_BigQueryExport{}
	mi := &file_google_cloud_dataplex_v1_data_profile_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataProfileSpec_PostScanActions_BigQueryExport) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataProfileSpec_PostScanActions_BigQueryExport) ProtoMessage() {}

func (x *DataProfileSpec_PostScanActions_BigQueryExport) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_data_profile_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataProfileSpec_PostScanActions_BigQueryExport.ProtoReflect.Descriptor instead.
func (*DataProfileSpec_PostScanActions_BigQueryExport) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_data_profile_proto_rawDescGZIP(), []int{0, 0, 0}
}

func (x *DataProfileSpec_PostScanActions_BigQueryExport) GetResultsTable() string {
	if x != nil {
		return x.ResultsTable
	}
	return ""
}

// Contains name, type, mode and field type specific profile information.
type DataProfileResult_Profile struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. List of fields with structural and profile information for
	// each field.
	Fields []*DataProfileResult_Profile_Field `protobuf:"bytes,2,rep,name=fields,proto3" json:"fields,omitempty"`
}

func (x *DataProfileResult_Profile) Reset() {
	*x = DataProfileResult_Profile{}
	mi := &file_google_cloud_dataplex_v1_data_profile_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataProfileResult_Profile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataProfileResult_Profile) ProtoMessage() {}

func (x *DataProfileResult_Profile) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_data_profile_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataProfileResult_Profile.ProtoReflect.Descriptor instead.
func (*DataProfileResult_Profile) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_data_profile_proto_rawDescGZIP(), []int{1, 0}
}

func (x *DataProfileResult_Profile) GetFields() []*DataProfileResult_Profile_Field {
	if x != nil {
		return x.Fields
	}
	return nil
}

// The result of post scan actions of DataProfileScan job.
type DataProfileResult_PostScanActionsResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The result of BigQuery export post scan action.
	BigqueryExportResult *DataProfileResult_PostScanActionsResult_BigQueryExportResult `protobuf:"bytes,1,opt,name=bigquery_export_result,json=bigqueryExportResult,proto3" json:"bigquery_export_result,omitempty"`
}

func (x *DataProfileResult_PostScanActionsResult) Reset() {
	*x = DataProfileResult_PostScanActionsResult{}
	mi := &file_google_cloud_dataplex_v1_data_profile_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataProfileResult_PostScanActionsResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataProfileResult_PostScanActionsResult) ProtoMessage() {}

func (x *DataProfileResult_PostScanActionsResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_data_profile_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataProfileResult_PostScanActionsResult.ProtoReflect.Descriptor instead.
func (*DataProfileResult_PostScanActionsResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_data_profile_proto_rawDescGZIP(), []int{1, 1}
}

func (x *DataProfileResult_PostScanActionsResult) GetBigqueryExportResult() *DataProfileResult_PostScanActionsResult_BigQueryExportResult {
	if x != nil {
		return x.BigqueryExportResult
	}
	return nil
}

// A field within a table.
type DataProfileResult_Profile_Field struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The name of the field.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The data type retrieved from the schema of the data
	// source. For instance, for a BigQuery native table, it is the [BigQuery
	// Table
	// Schema](https://cloud.google.com/bigquery/docs/reference/rest/v2/tables#tablefieldschema).
	// For a Dataplex Universal Catalog Entity, it is the [Entity
	// Schema](https://cloud.google.com/dataplex/docs/reference/rpc/google.cloud.dataplex.v1#type_3).
	Type string `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	// Output only. The mode of the field. Possible values include:
	//
	// * REQUIRED, if it is a required field.
	// * NULLABLE, if it is an optional field.
	// * REPEATED, if it is a repeated field.
	Mode string `protobuf:"bytes,3,opt,name=mode,proto3" json:"mode,omitempty"`
	// Output only. Profile information for the corresponding field.
	Profile *DataProfileResult_Profile_Field_ProfileInfo `protobuf:"bytes,4,opt,name=profile,proto3" json:"profile,omitempty"`
}

func (x *DataProfileResult_Profile_Field) Reset() {
	*x = DataProfileResult_Profile_Field{}
	mi := &file_google_cloud_dataplex_v1_data_profile_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataProfileResult_Profile_Field) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataProfileResult_Profile_Field) ProtoMessage() {}

func (x *DataProfileResult_Profile_Field) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_data_profile_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataProfileResult_Profile_Field.ProtoReflect.Descriptor instead.
func (*DataProfileResult_Profile_Field) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_data_profile_proto_rawDescGZIP(), []int{1, 0, 0}
}

func (x *DataProfileResult_Profile_Field) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DataProfileResult_Profile_Field) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *DataProfileResult_Profile_Field) GetMode() string {
	if x != nil {
		return x.Mode
	}
	return ""
}

func (x *DataProfileResult_Profile_Field) GetProfile() *DataProfileResult_Profile_Field_ProfileInfo {
	if x != nil {
		return x.Profile
	}
	return nil
}

// The profile information for each field type.
type DataProfileResult_Profile_Field_ProfileInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Ratio of rows with null value against total scanned
	// rows.
	NullRatio float64 `protobuf:"fixed64,2,opt,name=null_ratio,json=nullRatio,proto3" json:"null_ratio,omitempty"`
	// Output only. Ratio of rows with distinct values against total scanned
	// rows. Not available for complex non-groupable field type, including
	// RECORD, ARRAY, GEOGRAPHY, and JSON, as well as fields with REPEATABLE
	// mode.
	DistinctRatio float64 `protobuf:"fixed64,3,opt,name=distinct_ratio,json=distinctRatio,proto3" json:"distinct_ratio,omitempty"`
	// Output only. The list of top N non-null values, frequency and ratio
	// with which they occur in the scanned data. N is 10 or equal to the
	// number of distinct values in the field, whichever is smaller. Not
	// available for complex non-groupable field type, including RECORD,
	// ARRAY, GEOGRAPHY, and JSON, as well as fields with REPEATABLE mode.
	TopNValues []*DataProfileResult_Profile_Field_ProfileInfo_TopNValue `protobuf:"bytes,4,rep,name=top_n_values,json=topNValues,proto3" json:"top_n_values,omitempty"`
	// Structural and profile information for specific field type. Not
	// available, if mode is REPEATABLE.
	//
	// Types that are assignable to FieldInfo:
	//
	//	*DataProfileResult_Profile_Field_ProfileInfo_StringProfile
	//	*DataProfileResult_Profile_Field_ProfileInfo_IntegerProfile
	//	*DataProfileResult_Profile_Field_ProfileInfo_DoubleProfile
	FieldInfo isDataProfileResult_Profile_Field_ProfileInfo_FieldInfo `protobuf_oneof:"field_info"`
}

func (x *DataProfileResult_Profile_Field_ProfileInfo) Reset() {
	*x = DataProfileResult_Profile_Field_ProfileInfo{}
	mi := &file_google_cloud_dataplex_v1_data_profile_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataProfileResult_Profile_Field_ProfileInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataProfileResult_Profile_Field_ProfileInfo) ProtoMessage() {}

func (x *DataProfileResult_Profile_Field_ProfileInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_data_profile_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataProfileResult_Profile_Field_ProfileInfo.ProtoReflect.Descriptor instead.
func (*DataProfileResult_Profile_Field_ProfileInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_data_profile_proto_rawDescGZIP(), []int{1, 0, 0, 0}
}

func (x *DataProfileResult_Profile_Field_ProfileInfo) GetNullRatio() float64 {
	if x != nil {
		return x.NullRatio
	}
	return 0
}

func (x *DataProfileResult_Profile_Field_ProfileInfo) GetDistinctRatio() float64 {
	if x != nil {
		return x.DistinctRatio
	}
	return 0
}

func (x *DataProfileResult_Profile_Field_ProfileInfo) GetTopNValues() []*DataProfileResult_Profile_Field_ProfileInfo_TopNValue {
	if x != nil {
		return x.TopNValues
	}
	return nil
}

func (m *DataProfileResult_Profile_Field_ProfileInfo) GetFieldInfo() isDataProfileResult_Profile_Field_ProfileInfo_FieldInfo {
	if m != nil {
		return m.FieldInfo
	}
	return nil
}

func (x *DataProfileResult_Profile_Field_ProfileInfo) GetStringProfile() *DataProfileResult_Profile_Field_ProfileInfo_StringFieldInfo {
	if x, ok := x.GetFieldInfo().(*DataProfileResult_Profile_Field_ProfileInfo_StringProfile); ok {
		return x.StringProfile
	}
	return nil
}

func (x *DataProfileResult_Profile_Field_ProfileInfo) GetIntegerProfile() *DataProfileResult_Profile_Field_ProfileInfo_IntegerFieldInfo {
	if x, ok := x.GetFieldInfo().(*DataProfileResult_Profile_Field_ProfileInfo_IntegerProfile); ok {
		return x.IntegerProfile
	}
	return nil
}

func (x *DataProfileResult_Profile_Field_ProfileInfo) GetDoubleProfile() *DataProfileResult_Profile_Field_ProfileInfo_DoubleFieldInfo {
	if x, ok := x.GetFieldInfo().(*DataProfileResult_Profile_Field_ProfileInfo_DoubleProfile); ok {
		return x.DoubleProfile
	}
	return nil
}

type isDataProfileResult_Profile_Field_ProfileInfo_FieldInfo interface {
	isDataProfileResult_Profile_Field_ProfileInfo_FieldInfo()
}

type DataProfileResult_Profile_Field_ProfileInfo_StringProfile struct {
	// String type field information.
	StringProfile *DataProfileResult_Profile_Field_ProfileInfo_StringFieldInfo `protobuf:"bytes,101,opt,name=string_profile,json=stringProfile,proto3,oneof"`
}

type DataProfileResult_Profile_Field_ProfileInfo_IntegerProfile struct {
	// Integer type field information.
	IntegerProfile *DataProfileResult_Profile_Field_ProfileInfo_IntegerFieldInfo `protobuf:"bytes,102,opt,name=integer_profile,json=integerProfile,proto3,oneof"`
}

type DataProfileResult_Profile_Field_ProfileInfo_DoubleProfile struct {
	// Double type field information.
	DoubleProfile *DataProfileResult_Profile_Field_ProfileInfo_DoubleFieldInfo `protobuf:"bytes,103,opt,name=double_profile,json=doubleProfile,proto3,oneof"`
}

func (*DataProfileResult_Profile_Field_ProfileInfo_StringProfile) isDataProfileResult_Profile_Field_ProfileInfo_FieldInfo() {
}

func (*DataProfileResult_Profile_Field_ProfileInfo_IntegerProfile) isDataProfileResult_Profile_Field_ProfileInfo_FieldInfo() {
}

func (*DataProfileResult_Profile_Field_ProfileInfo_DoubleProfile) isDataProfileResult_Profile_Field_ProfileInfo_FieldInfo() {
}

// The profile information for a string type field.
type DataProfileResult_Profile_Field_ProfileInfo_StringFieldInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Minimum length of non-null values in the scanned data.
	MinLength int64 `protobuf:"varint,1,opt,name=min_length,json=minLength,proto3" json:"min_length,omitempty"`
	// Output only. Maximum length of non-null values in the scanned data.
	MaxLength int64 `protobuf:"varint,2,opt,name=max_length,json=maxLength,proto3" json:"max_length,omitempty"`
	// Output only. Average length of non-null values in the scanned data.
	AverageLength float64 `protobuf:"fixed64,3,opt,name=average_length,json=averageLength,proto3" json:"average_length,omitempty"`
}

func (x *DataProfileResult_Profile_Field_ProfileInfo_StringFieldInfo) Reset() {
	*x = DataProfileResult_Profile_Field_ProfileInfo_StringFieldInfo{}
	mi := &file_google_cloud_dataplex_v1_data_profile_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataProfileResult_Profile_Field_ProfileInfo_StringFieldInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataProfileResult_Profile_Field_ProfileInfo_StringFieldInfo) ProtoMessage() {}

func (x *DataProfileResult_Profile_Field_ProfileInfo_StringFieldInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_data_profile_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataProfileResult_Profile_Field_ProfileInfo_StringFieldInfo.ProtoReflect.Descriptor instead.
func (*DataProfileResult_Profile_Field_ProfileInfo_StringFieldInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_data_profile_proto_rawDescGZIP(), []int{1, 0, 0, 0, 0}
}

func (x *DataProfileResult_Profile_Field_ProfileInfo_StringFieldInfo) GetMinLength() int64 {
	if x != nil {
		return x.MinLength
	}
	return 0
}

func (x *DataProfileResult_Profile_Field_ProfileInfo_StringFieldInfo) GetMaxLength() int64 {
	if x != nil {
		return x.MaxLength
	}
	return 0
}

func (x *DataProfileResult_Profile_Field_ProfileInfo_StringFieldInfo) GetAverageLength() float64 {
	if x != nil {
		return x.AverageLength
	}
	return 0
}

// The profile information for an integer type field.
type DataProfileResult_Profile_Field_ProfileInfo_IntegerFieldInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Average of non-null values in the scanned data. NaN,
	// if the field has a NaN.
	Average float64 `protobuf:"fixed64,1,opt,name=average,proto3" json:"average,omitempty"`
	// Output only. Standard deviation of non-null values in the scanned
	// data. NaN, if the field has a NaN.
	StandardDeviation float64 `protobuf:"fixed64,3,opt,name=standard_deviation,json=standardDeviation,proto3" json:"standard_deviation,omitempty"`
	// Output only. Minimum of non-null values in the scanned data. NaN,
	// if the field has a NaN.
	Min int64 `protobuf:"varint,4,opt,name=min,proto3" json:"min,omitempty"`
	// Output only. A quartile divides the number of data points into four
	// parts, or quarters, of more-or-less equal size. Three main
	// quartiles used are: The first quartile (Q1) splits off the lowest
	// 25% of data from the highest 75%. It is also known as the lower or
	// 25th empirical quartile, as 25% of the data is below this point.
	// The second quartile (Q2) is the median of a data set. So, 50% of
	// the data lies below this point. The third quartile (Q3) splits off
	// the highest 25% of data from the lowest 75%. It is known as the
	// upper or 75th empirical quartile, as 75% of the data lies below
	// this point. Here, the quartiles is provided as an ordered list of
	// approximate quartile values for the scanned data, occurring in
	// order Q1, median, Q3.
	Quartiles []int64 `protobuf:"varint,6,rep,packed,name=quartiles,proto3" json:"quartiles,omitempty"`
	// Output only. Maximum of non-null values in the scanned data. NaN,
	// if the field has a NaN.
	Max int64 `protobuf:"varint,5,opt,name=max,proto3" json:"max,omitempty"`
}

func (x *DataProfileResult_Profile_Field_ProfileInfo_IntegerFieldInfo) Reset() {
	*x = DataProfileResult_Profile_Field_ProfileInfo_IntegerFieldInfo{}
	mi := &file_google_cloud_dataplex_v1_data_profile_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataProfileResult_Profile_Field_ProfileInfo_IntegerFieldInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataProfileResult_Profile_Field_ProfileInfo_IntegerFieldInfo) ProtoMessage() {}

func (x *DataProfileResult_Profile_Field_ProfileInfo_IntegerFieldInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_data_profile_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataProfileResult_Profile_Field_ProfileInfo_IntegerFieldInfo.ProtoReflect.Descriptor instead.
func (*DataProfileResult_Profile_Field_ProfileInfo_IntegerFieldInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_data_profile_proto_rawDescGZIP(), []int{1, 0, 0, 0, 1}
}

func (x *DataProfileResult_Profile_Field_ProfileInfo_IntegerFieldInfo) GetAverage() float64 {
	if x != nil {
		return x.Average
	}
	return 0
}

func (x *DataProfileResult_Profile_Field_ProfileInfo_IntegerFieldInfo) GetStandardDeviation() float64 {
	if x != nil {
		return x.StandardDeviation
	}
	return 0
}

func (x *DataProfileResult_Profile_Field_ProfileInfo_IntegerFieldInfo) GetMin() int64 {
	if x != nil {
		return x.Min
	}
	return 0
}

func (x *DataProfileResult_Profile_Field_ProfileInfo_IntegerFieldInfo) GetQuartiles() []int64 {
	if x != nil {
		return x.Quartiles
	}
	return nil
}

func (x *DataProfileResult_Profile_Field_ProfileInfo_IntegerFieldInfo) GetMax() int64 {
	if x != nil {
		return x.Max
	}
	return 0
}

// The profile information for a double type field.
type DataProfileResult_Profile_Field_ProfileInfo_DoubleFieldInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Average of non-null values in the scanned data. NaN,
	// if the field has a NaN.
	Average float64 `protobuf:"fixed64,1,opt,name=average,proto3" json:"average,omitempty"`
	// Output only. Standard deviation of non-null values in the scanned
	// data. NaN, if the field has a NaN.
	StandardDeviation float64 `protobuf:"fixed64,3,opt,name=standard_deviation,json=standardDeviation,proto3" json:"standard_deviation,omitempty"`
	// Output only. Minimum of non-null values in the scanned data. NaN,
	// if the field has a NaN.
	Min float64 `protobuf:"fixed64,4,opt,name=min,proto3" json:"min,omitempty"`
	// Output only. A quartile divides the number of data points into four
	// parts, or quarters, of more-or-less equal size. Three main
	// quartiles used are: The first quartile (Q1) splits off the lowest
	// 25% of data from the highest 75%. It is also known as the lower or
	// 25th empirical quartile, as 25% of the data is below this point.
	// The second quartile (Q2) is the median of a data set. So, 50% of
	// the data lies below this point. The third quartile (Q3) splits off
	// the highest 25% of data from the lowest 75%. It is known as the
	// upper or 75th empirical quartile, as 75% of the data lies below
	// this point. Here, the quartiles is provided as an ordered list of
	// quartile values for the scanned data, occurring in order Q1,
	// median, Q3.
	Quartiles []float64 `protobuf:"fixed64,6,rep,packed,name=quartiles,proto3" json:"quartiles,omitempty"`
	// Output only. Maximum of non-null values in the scanned data. NaN,
	// if the field has a NaN.
	Max float64 `protobuf:"fixed64,5,opt,name=max,proto3" json:"max,omitempty"`
}

func (x *DataProfileResult_Profile_Field_ProfileInfo_DoubleFieldInfo) Reset() {
	*x = DataProfileResult_Profile_Field_ProfileInfo_DoubleFieldInfo{}
	mi := &file_google_cloud_dataplex_v1_data_profile_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataProfileResult_Profile_Field_ProfileInfo_DoubleFieldInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataProfileResult_Profile_Field_ProfileInfo_DoubleFieldInfo) ProtoMessage() {}

func (x *DataProfileResult_Profile_Field_ProfileInfo_DoubleFieldInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_data_profile_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataProfileResult_Profile_Field_ProfileInfo_DoubleFieldInfo.ProtoReflect.Descriptor instead.
func (*DataProfileResult_Profile_Field_ProfileInfo_DoubleFieldInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_data_profile_proto_rawDescGZIP(), []int{1, 0, 0, 0, 2}
}

func (x *DataProfileResult_Profile_Field_ProfileInfo_DoubleFieldInfo) GetAverage() float64 {
	if x != nil {
		return x.Average
	}
	return 0
}

func (x *DataProfileResult_Profile_Field_ProfileInfo_DoubleFieldInfo) GetStandardDeviation() float64 {
	if x != nil {
		return x.StandardDeviation
	}
	return 0
}

func (x *DataProfileResult_Profile_Field_ProfileInfo_DoubleFieldInfo) GetMin() float64 {
	if x != nil {
		return x.Min
	}
	return 0
}

func (x *DataProfileResult_Profile_Field_ProfileInfo_DoubleFieldInfo) GetQuartiles() []float64 {
	if x != nil {
		return x.Quartiles
	}
	return nil
}

func (x *DataProfileResult_Profile_Field_ProfileInfo_DoubleFieldInfo) GetMax() float64 {
	if x != nil {
		return x.Max
	}
	return 0
}

// Top N non-null values in the scanned data.
type DataProfileResult_Profile_Field_ProfileInfo_TopNValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. String value of a top N non-null value.
	Value string `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	// Output only. Count of the corresponding value in the scanned data.
	Count int64 `protobuf:"varint,2,opt,name=count,proto3" json:"count,omitempty"`
	// Output only. Ratio of the corresponding value in the field against
	// the total number of rows in the scanned data.
	Ratio float64 `protobuf:"fixed64,3,opt,name=ratio,proto3" json:"ratio,omitempty"`
}

func (x *DataProfileResult_Profile_Field_ProfileInfo_TopNValue) Reset() {
	*x = DataProfileResult_Profile_Field_ProfileInfo_TopNValue{}
	mi := &file_google_cloud_dataplex_v1_data_profile_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataProfileResult_Profile_Field_ProfileInfo_TopNValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataProfileResult_Profile_Field_ProfileInfo_TopNValue) ProtoMessage() {}

func (x *DataProfileResult_Profile_Field_ProfileInfo_TopNValue) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_data_profile_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataProfileResult_Profile_Field_ProfileInfo_TopNValue.ProtoReflect.Descriptor instead.
func (*DataProfileResult_Profile_Field_ProfileInfo_TopNValue) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_data_profile_proto_rawDescGZIP(), []int{1, 0, 0, 0, 3}
}

func (x *DataProfileResult_Profile_Field_ProfileInfo_TopNValue) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

func (x *DataProfileResult_Profile_Field_ProfileInfo_TopNValue) GetCount() int64 {
	if x != nil {
		return x.Count
	}
	return 0
}

func (x *DataProfileResult_Profile_Field_ProfileInfo_TopNValue) GetRatio() float64 {
	if x != nil {
		return x.Ratio
	}
	return 0
}

// The result of BigQuery export post scan action.
type DataProfileResult_PostScanActionsResult_BigQueryExportResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Execution state for the BigQuery exporting.
	State DataProfileResult_PostScanActionsResult_BigQueryExportResult_State `protobuf:"varint,1,opt,name=state,proto3,enum=google.cloud.dataplex.v1.DataProfileResult_PostScanActionsResult_BigQueryExportResult_State" json:"state,omitempty"`
	// Output only. Additional information about the BigQuery exporting.
	Message string `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
}

func (x *DataProfileResult_PostScanActionsResult_BigQueryExportResult) Reset() {
	*x = DataProfileResult_PostScanActionsResult_BigQueryExportResult{}
	mi := &file_google_cloud_dataplex_v1_data_profile_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataProfileResult_PostScanActionsResult_BigQueryExportResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataProfileResult_PostScanActionsResult_BigQueryExportResult) ProtoMessage() {}

func (x *DataProfileResult_PostScanActionsResult_BigQueryExportResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_data_profile_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataProfileResult_PostScanActionsResult_BigQueryExportResult.ProtoReflect.Descriptor instead.
func (*DataProfileResult_PostScanActionsResult_BigQueryExportResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_data_profile_proto_rawDescGZIP(), []int{1, 1, 0}
}

func (x *DataProfileResult_PostScanActionsResult_BigQueryExportResult) GetState() DataProfileResult_PostScanActionsResult_BigQueryExportResult_State {
	if x != nil {
		return x.State
	}
	return DataProfileResult_PostScanActionsResult_BigQueryExportResult_STATE_UNSPECIFIED
}

func (x *DataProfileResult_PostScanActionsResult_BigQueryExportResult) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

var File_google_cloud_dataplex_v1_data_profile_proto protoreflect.FileDescriptor

var file_google_cloud_dataplex_v1_data_profile_proto_rawDesc = []byte{
	0x0a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2f, 0x76, 0x31, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x5f,
	0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x18, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69,
	0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2f,
	0x76, 0x31, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x63, 0x61, 0x6e, 0x73, 0x5f, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78,
	0x2f, 0x76, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0xe0, 0x05, 0x0a, 0x0f, 0x44, 0x61, 0x74, 0x61, 0x50, 0x72, 0x6f,
	0x66, 0x69, 0x6c, 0x65, 0x53, 0x70, 0x65, 0x63, 0x12, 0x2e, 0x0a, 0x10, 0x73, 0x61, 0x6d, 0x70,
	0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x02, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x69, 0x6e,
	0x67, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x6f, 0x77, 0x5f,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x09, 0x72, 0x6f, 0x77, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x6a, 0x0a, 0x11,
	0x70, 0x6f, 0x73, 0x74, 0x5f, 0x73, 0x63, 0x61, 0x6e, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x53, 0x70,
	0x65, 0x63, 0x2e, 0x50, 0x6f, 0x73, 0x74, 0x53, 0x63, 0x61, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x70, 0x6f, 0x73, 0x74, 0x53, 0x63, 0x61,
	0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x64, 0x0a, 0x0e, 0x69, 0x6e, 0x63, 0x6c,
	0x75, 0x64, 0x65, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61,
	0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x53, 0x65, 0x6c, 0x65,
	0x63, 0x74, 0x65, 0x64, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0d, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x12, 0x64,
	0x0a, 0x0e, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x53, 0x70, 0x65,
	0x63, 0x2e, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x65, 0x64, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x73,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x73, 0x12, 0x41, 0x0a, 0x1a, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x5f,
	0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x69, 0x6e, 0x67, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x64, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x18, 0x63,
	0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x69, 0x6e, 0x67,
	0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x1a, 0xc5, 0x01, 0x0a, 0x0f, 0x50, 0x6f, 0x73, 0x74,
	0x53, 0x63, 0x61, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x76, 0x0a, 0x0f, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x61, 0x74, 0x61, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x53, 0x70, 0x65, 0x63, 0x2e,
	0x50, 0x6f, 0x73, 0x74, 0x53, 0x63, 0x61, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70,
	0x6f, 0x72, 0x74, 0x1a, 0x3a, 0x0a, 0x0e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45,
	0x78, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x28, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73,
	0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0c, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x1a,
	0x36, 0x0a, 0x0e, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x65, 0x64, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x73, 0x12, 0x24, 0x0a, 0x0b, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x22, 0xdc, 0x12, 0x0a, 0x11, 0x44, 0x61, 0x74, 0x61,
	0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x20, 0x0a,
	0x09, 0x72, 0x6f, 0x77, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x72, 0x6f, 0x77, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12,
	0x52, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61,
	0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x50, 0x72,
	0x6f, 0x66, 0x69, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x66,
	0x69, 0x6c, 0x65, 0x12, 0x4d, 0x0a, 0x0c, 0x73, 0x63, 0x61, 0x6e, 0x6e, 0x65, 0x64, 0x5f, 0x64,
	0x61, 0x74, 0x61, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65,
	0x78, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x63, 0x61, 0x6e, 0x6e, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x73, 0x63, 0x61, 0x6e, 0x6e, 0x65, 0x64, 0x44, 0x61,
	0x74, 0x61, 0x12, 0x7f, 0x0a, 0x18, 0x70, 0x6f, 0x73, 0x74, 0x5f, 0x73, 0x63, 0x61, 0x6e, 0x5f,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x61, 0x74, 0x61, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x2e, 0x50, 0x6f, 0x73, 0x74, 0x53, 0x63, 0x61, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x15, 0x70, 0x6f,
	0x73, 0x74, 0x53, 0x63, 0x61, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x12, 0x7a, 0x0a, 0x19, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x5f, 0x70,
	0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x61, 0x6e, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f,
	0x67, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x17, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x50,
	0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x1a,
	0xdd, 0x0b, 0x0a, 0x07, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x56, 0x0a, 0x06, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70,
	0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x50, 0x72, 0x6f, 0x66, 0x69,
	0x6c, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65,
	0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x73, 0x1a, 0xf9, 0x0a, 0x0a, 0x05, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x12, 0x17, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12,
	0x17, 0x0a, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x12, 0x64, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x66,
	0x69, 0x6c, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65,
	0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x2e, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x2e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x49, 0x6e, 0x66, 0x6f,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x1a, 0xbe,
	0x09, 0x0a, 0x0b, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x22,
	0x0a, 0x0a, 0x6e, 0x75, 0x6c, 0x6c, 0x5f, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x01, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x6e, 0x75, 0x6c, 0x6c, 0x52, 0x61, 0x74,
	0x69, 0x6f, 0x12, 0x2a, 0x0a, 0x0e, 0x64, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x63, 0x74, 0x5f, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0d, 0x64, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x63, 0x74, 0x52, 0x61, 0x74, 0x69, 0x6f, 0x12, 0x76,
	0x0a, 0x0c, 0x74, 0x6f, 0x70, 0x5f, 0x6e, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x04,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x4f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x61, 0x74, 0x61, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x2e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x2e,
	0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x54, 0x6f, 0x70, 0x4e,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x74, 0x6f, 0x70, 0x4e,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x7e, 0x0a, 0x0e, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67,
	0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x65, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x55,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x50, 0x72,
	0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x50, 0x72, 0x6f, 0x66,
	0x69, 0x6c, 0x65, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x2e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c,
	0x65, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x46, 0x69, 0x65, 0x6c,
	0x64, 0x49, 0x6e, 0x66, 0x6f, 0x48, 0x00, 0x52, 0x0d, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x50,
	0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x81, 0x01, 0x0a, 0x0f, 0x69, 0x6e, 0x74, 0x65, 0x67,
	0x65, 0x72, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x66, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x56, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61,
	0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x50, 0x72,
	0x6f, 0x66, 0x69, 0x6c, 0x65, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x2e, 0x50, 0x72, 0x6f, 0x66,
	0x69, 0x6c, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x67, 0x65, 0x72, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x48, 0x00, 0x52, 0x0e, 0x69, 0x6e, 0x74, 0x65,
	0x67, 0x65, 0x72, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x7e, 0x0a, 0x0e, 0x64, 0x6f,
	0x75, 0x62, 0x6c, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x67, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x55, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61,
	0x74, 0x61, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e,
	0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x2e, 0x50, 0x72,
	0x6f, 0x66, 0x69, 0x6c, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65,
	0x46, 0x69, 0x65, 0x6c, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x48, 0x00, 0x52, 0x0d, 0x64, 0x6f, 0x75,
	0x62, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x1a, 0x85, 0x01, 0x0a, 0x0f, 0x53,
	0x74, 0x72, 0x69, 0x6e, 0x67, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x22,
	0x0a, 0x0a, 0x6d, 0x69, 0x6e, 0x5f, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x6d, 0x69, 0x6e, 0x4c, 0x65, 0x6e, 0x67,
	0x74, 0x68, 0x12, 0x22, 0x0a, 0x0a, 0x6d, 0x61, 0x78, 0x5f, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x6d, 0x61, 0x78,
	0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x12, 0x2a, 0x0a, 0x0e, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67,
	0x65, 0x5f, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0d, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x4c, 0x65, 0x6e, 0x67,
	0x74, 0x68, 0x1a, 0xb6, 0x01, 0x0a, 0x10, 0x49, 0x6e, 0x74, 0x65, 0x67, 0x65, 0x72, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x1d, 0x0a, 0x07, 0x61, 0x76, 0x65, 0x72, 0x61,
	0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x01, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x61,
	0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x12, 0x32, 0x0a, 0x12, 0x73, 0x74, 0x61, 0x6e, 0x64, 0x61,
	0x72, 0x64, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x01, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11, 0x73, 0x74, 0x61, 0x6e, 0x64, 0x61, 0x72,
	0x64, 0x44, 0x65, 0x76, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x15, 0x0a, 0x03, 0x6d, 0x69,
	0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x6d, 0x69,
	0x6e, 0x12, 0x21, 0x0a, 0x09, 0x71, 0x75, 0x61, 0x72, 0x74, 0x69, 0x6c, 0x65, 0x73, 0x18, 0x06,
	0x20, 0x03, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x71, 0x75, 0x61, 0x72, 0x74,
	0x69, 0x6c, 0x65, 0x73, 0x12, 0x15, 0x0a, 0x03, 0x6d, 0x61, 0x78, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x6d, 0x61, 0x78, 0x1a, 0xb5, 0x01, 0x0a, 0x0f,
	0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x12,
	0x1d, 0x0a, 0x07, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x01,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x12, 0x32,
	0x0a, 0x12, 0x73, 0x74, 0x61, 0x6e, 0x64, 0x61, 0x72, 0x64, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x11, 0x73, 0x74, 0x61, 0x6e, 0x64, 0x61, 0x72, 0x64, 0x44, 0x65, 0x76, 0x69, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x15, 0x0a, 0x03, 0x6d, 0x69, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x01, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x6d, 0x69, 0x6e, 0x12, 0x21, 0x0a, 0x09, 0x71, 0x75, 0x61,
	0x72, 0x74, 0x69, 0x6c, 0x65, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x01, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x09, 0x71, 0x75, 0x61, 0x72, 0x74, 0x69, 0x6c, 0x65, 0x73, 0x12, 0x15, 0x0a, 0x03,
	0x6d, 0x61, 0x78, 0x18, 0x05, 0x20, 0x01, 0x28, 0x01, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x03,
	0x6d, 0x61, 0x78, 0x1a, 0x5c, 0x0a, 0x09, 0x54, 0x6f, 0x70, 0x4e, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x12, 0x19, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x19, 0x0a, 0x05, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x19, 0x0a, 0x05, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x01, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x42, 0x0c, 0x0a, 0x0a, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x1a,
	0xa4, 0x03, 0x0a, 0x15, 0x50, 0x6f, 0x73, 0x74, 0x53, 0x63, 0x61, 0x6e, 0x41, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x91, 0x01, 0x0a, 0x16, 0x62, 0x69,
	0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x72, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x56, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c,
	0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c,
	0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x50, 0x6f, 0x73, 0x74, 0x53, 0x63, 0x61, 0x6e,
	0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x42, 0x69,
	0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x14, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x1a, 0xf6, 0x01,
	0x0a, 0x14, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x77, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x5c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x61, 0x74, 0x61, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x2e, 0x50, 0x6f, 0x73, 0x74, 0x53, 0x63, 0x61, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72,
	0x79, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x1d, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0x46,
	0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d,
	0x0a, 0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0a, 0x0a,
	0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x4b, 0x49,
	0x50, 0x50, 0x45, 0x44, 0x10, 0x03, 0x42, 0x6c, 0x0a, 0x1c, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70,
	0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x42, 0x10, 0x44, 0x61, 0x74, 0x61, 0x50, 0x72, 0x6f, 0x66,
	0x69, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x38, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f,
	0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x70, 0x62, 0x3b, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c,
	0x65, 0x78, 0x70, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_dataplex_v1_data_profile_proto_rawDescOnce sync.Once
	file_google_cloud_dataplex_v1_data_profile_proto_rawDescData = file_google_cloud_dataplex_v1_data_profile_proto_rawDesc
)

func file_google_cloud_dataplex_v1_data_profile_proto_rawDescGZIP() []byte {
	file_google_cloud_dataplex_v1_data_profile_proto_rawDescOnce.Do(func() {
		file_google_cloud_dataplex_v1_data_profile_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_dataplex_v1_data_profile_proto_rawDescData)
	})
	return file_google_cloud_dataplex_v1_data_profile_proto_rawDescData
}

var file_google_cloud_dataplex_v1_data_profile_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_dataplex_v1_data_profile_proto_msgTypes = make([]protoimpl.MessageInfo, 14)
var file_google_cloud_dataplex_v1_data_profile_proto_goTypes = []any{
	(DataProfileResult_PostScanActionsResult_BigQueryExportResult_State)(0), // 0: google.cloud.dataplex.v1.DataProfileResult.PostScanActionsResult.BigQueryExportResult.State
	(*DataProfileSpec)(nil),                                              // 1: google.cloud.dataplex.v1.DataProfileSpec
	(*DataProfileResult)(nil),                                            // 2: google.cloud.dataplex.v1.DataProfileResult
	(*DataProfileSpec_PostScanActions)(nil),                              // 3: google.cloud.dataplex.v1.DataProfileSpec.PostScanActions
	(*DataProfileSpec_SelectedFields)(nil),                               // 4: google.cloud.dataplex.v1.DataProfileSpec.SelectedFields
	(*DataProfileSpec_PostScanActions_BigQueryExport)(nil),               // 5: google.cloud.dataplex.v1.DataProfileSpec.PostScanActions.BigQueryExport
	(*DataProfileResult_Profile)(nil),                                    // 6: google.cloud.dataplex.v1.DataProfileResult.Profile
	(*DataProfileResult_PostScanActionsResult)(nil),                      // 7: google.cloud.dataplex.v1.DataProfileResult.PostScanActionsResult
	(*DataProfileResult_Profile_Field)(nil),                              // 8: google.cloud.dataplex.v1.DataProfileResult.Profile.Field
	(*DataProfileResult_Profile_Field_ProfileInfo)(nil),                  // 9: google.cloud.dataplex.v1.DataProfileResult.Profile.Field.ProfileInfo
	(*DataProfileResult_Profile_Field_ProfileInfo_StringFieldInfo)(nil),  // 10: google.cloud.dataplex.v1.DataProfileResult.Profile.Field.ProfileInfo.StringFieldInfo
	(*DataProfileResult_Profile_Field_ProfileInfo_IntegerFieldInfo)(nil), // 11: google.cloud.dataplex.v1.DataProfileResult.Profile.Field.ProfileInfo.IntegerFieldInfo
	(*DataProfileResult_Profile_Field_ProfileInfo_DoubleFieldInfo)(nil),  // 12: google.cloud.dataplex.v1.DataProfileResult.Profile.Field.ProfileInfo.DoubleFieldInfo
	(*DataProfileResult_Profile_Field_ProfileInfo_TopNValue)(nil),        // 13: google.cloud.dataplex.v1.DataProfileResult.Profile.Field.ProfileInfo.TopNValue
	(*DataProfileResult_PostScanActionsResult_BigQueryExportResult)(nil), // 14: google.cloud.dataplex.v1.DataProfileResult.PostScanActionsResult.BigQueryExportResult
	(*ScannedData)(nil),                                                  // 15: google.cloud.dataplex.v1.ScannedData
	(*DataScanCatalogPublishingStatus)(nil),                              // 16: google.cloud.dataplex.v1.DataScanCatalogPublishingStatus
}
var file_google_cloud_dataplex_v1_data_profile_proto_depIdxs = []int32{
	3,  // 0: google.cloud.dataplex.v1.DataProfileSpec.post_scan_actions:type_name -> google.cloud.dataplex.v1.DataProfileSpec.PostScanActions
	4,  // 1: google.cloud.dataplex.v1.DataProfileSpec.include_fields:type_name -> google.cloud.dataplex.v1.DataProfileSpec.SelectedFields
	4,  // 2: google.cloud.dataplex.v1.DataProfileSpec.exclude_fields:type_name -> google.cloud.dataplex.v1.DataProfileSpec.SelectedFields
	6,  // 3: google.cloud.dataplex.v1.DataProfileResult.profile:type_name -> google.cloud.dataplex.v1.DataProfileResult.Profile
	15, // 4: google.cloud.dataplex.v1.DataProfileResult.scanned_data:type_name -> google.cloud.dataplex.v1.ScannedData
	7,  // 5: google.cloud.dataplex.v1.DataProfileResult.post_scan_actions_result:type_name -> google.cloud.dataplex.v1.DataProfileResult.PostScanActionsResult
	16, // 6: google.cloud.dataplex.v1.DataProfileResult.catalog_publishing_status:type_name -> google.cloud.dataplex.v1.DataScanCatalogPublishingStatus
	5,  // 7: google.cloud.dataplex.v1.DataProfileSpec.PostScanActions.bigquery_export:type_name -> google.cloud.dataplex.v1.DataProfileSpec.PostScanActions.BigQueryExport
	8,  // 8: google.cloud.dataplex.v1.DataProfileResult.Profile.fields:type_name -> google.cloud.dataplex.v1.DataProfileResult.Profile.Field
	14, // 9: google.cloud.dataplex.v1.DataProfileResult.PostScanActionsResult.bigquery_export_result:type_name -> google.cloud.dataplex.v1.DataProfileResult.PostScanActionsResult.BigQueryExportResult
	9,  // 10: google.cloud.dataplex.v1.DataProfileResult.Profile.Field.profile:type_name -> google.cloud.dataplex.v1.DataProfileResult.Profile.Field.ProfileInfo
	13, // 11: google.cloud.dataplex.v1.DataProfileResult.Profile.Field.ProfileInfo.top_n_values:type_name -> google.cloud.dataplex.v1.DataProfileResult.Profile.Field.ProfileInfo.TopNValue
	10, // 12: google.cloud.dataplex.v1.DataProfileResult.Profile.Field.ProfileInfo.string_profile:type_name -> google.cloud.dataplex.v1.DataProfileResult.Profile.Field.ProfileInfo.StringFieldInfo
	11, // 13: google.cloud.dataplex.v1.DataProfileResult.Profile.Field.ProfileInfo.integer_profile:type_name -> google.cloud.dataplex.v1.DataProfileResult.Profile.Field.ProfileInfo.IntegerFieldInfo
	12, // 14: google.cloud.dataplex.v1.DataProfileResult.Profile.Field.ProfileInfo.double_profile:type_name -> google.cloud.dataplex.v1.DataProfileResult.Profile.Field.ProfileInfo.DoubleFieldInfo
	0,  // 15: google.cloud.dataplex.v1.DataProfileResult.PostScanActionsResult.BigQueryExportResult.state:type_name -> google.cloud.dataplex.v1.DataProfileResult.PostScanActionsResult.BigQueryExportResult.State
	16, // [16:16] is the sub-list for method output_type
	16, // [16:16] is the sub-list for method input_type
	16, // [16:16] is the sub-list for extension type_name
	16, // [16:16] is the sub-list for extension extendee
	0,  // [0:16] is the sub-list for field type_name
}

func init() { file_google_cloud_dataplex_v1_data_profile_proto_init() }
func file_google_cloud_dataplex_v1_data_profile_proto_init() {
	if File_google_cloud_dataplex_v1_data_profile_proto != nil {
		return
	}
	file_google_cloud_dataplex_v1_datascans_common_proto_init()
	file_google_cloud_dataplex_v1_processing_proto_init()
	file_google_cloud_dataplex_v1_data_profile_proto_msgTypes[8].OneofWrappers = []any{
		(*DataProfileResult_Profile_Field_ProfileInfo_StringProfile)(nil),
		(*DataProfileResult_Profile_Field_ProfileInfo_IntegerProfile)(nil),
		(*DataProfileResult_Profile_Field_ProfileInfo_DoubleProfile)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_dataplex_v1_data_profile_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   14,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_dataplex_v1_data_profile_proto_goTypes,
		DependencyIndexes: file_google_cloud_dataplex_v1_data_profile_proto_depIdxs,
		EnumInfos:         file_google_cloud_dataplex_v1_data_profile_proto_enumTypes,
		MessageInfos:      file_google_cloud_dataplex_v1_data_profile_proto_msgTypes,
	}.Build()
	File_google_cloud_dataplex_v1_data_profile_proto = out.File
	file_google_cloud_dataplex_v1_data_profile_proto_rawDesc = nil
	file_google_cloud_dataplex_v1_data_profile_proto_goTypes = nil
	file_google_cloud_dataplex_v1_data_profile_proto_depIdxs = nil
}
