// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.31.0
// 	protoc        v4.23.2
// source: google/cloud/optimization/v1/fleet_routing.proto

package optimizationpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	latlng "google.golang.org/genproto/googleapis/type/latlng"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Defines how the solver should handle the request. In all modes but
// `VALIDATE_ONLY`, if the request is invalid, you will receive an
// `INVALID_REQUEST` error. See
// [max_validation_errors][google.cloud.optimization.v1.OptimizeToursRequest.max_validation_errors]
// to cap the number of errors returned.
type OptimizeToursRequest_SolvingMode int32

const (
	// Solve the model.
	OptimizeToursRequest_DEFAULT_SOLVE OptimizeToursRequest_SolvingMode = 0
	// Only validates the model without solving it: populates as many
	// [OptimizeToursResponse.validation_errors][google.cloud.optimization.v1.OptimizeToursResponse.validation_errors]
	// as possible.
	OptimizeToursRequest_VALIDATE_ONLY OptimizeToursRequest_SolvingMode = 1
	// Only populates
	// [OptimizeToursResponse.validation_errors][google.cloud.optimization.v1.OptimizeToursResponse.validation_errors]
	// or
	// [OptimizeToursResponse.skipped_shipments][google.cloud.optimization.v1.OptimizeToursResponse.skipped_shipments],
	// and doesn't actually solve the rest of the request (`status` and `routes`
	// are unset in the response).
	// If infeasibilities in `injected_solution_constraint` routes are detected
	// they are populated in the
	// [OptimizeToursResponse.validation_errors][google.cloud.optimization.v1.OptimizeToursResponse.validation_errors]
	// field and
	// [OptimizeToursResponse.skipped_shipments][google.cloud.optimization.v1.OptimizeToursResponse.skipped_shipments]
	// is left empty.
	//
	// *IMPORTANT*: not all infeasible shipments are returned here, but only the
	// ones that are detected as infeasible during preprocessing.
	OptimizeToursRequest_DETECT_SOME_INFEASIBLE_SHIPMENTS OptimizeToursRequest_SolvingMode = 2
)

// Enum value maps for OptimizeToursRequest_SolvingMode.
var (
	OptimizeToursRequest_SolvingMode_name = map[int32]string{
		0: "DEFAULT_SOLVE",
		1: "VALIDATE_ONLY",
		2: "DETECT_SOME_INFEASIBLE_SHIPMENTS",
	}
	OptimizeToursRequest_SolvingMode_value = map[string]int32{
		"DEFAULT_SOLVE":                    0,
		"VALIDATE_ONLY":                    1,
		"DETECT_SOME_INFEASIBLE_SHIPMENTS": 2,
	}
)

func (x OptimizeToursRequest_SolvingMode) Enum() *OptimizeToursRequest_SolvingMode {
	p := new(OptimizeToursRequest_SolvingMode)
	*p = x
	return p
}

func (x OptimizeToursRequest_SolvingMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OptimizeToursRequest_SolvingMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_optimization_v1_fleet_routing_proto_enumTypes[0].Descriptor()
}

func (OptimizeToursRequest_SolvingMode) Type() protoreflect.EnumType {
	return &file_google_cloud_optimization_v1_fleet_routing_proto_enumTypes[0]
}

func (x OptimizeToursRequest_SolvingMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OptimizeToursRequest_SolvingMode.Descriptor instead.
func (OptimizeToursRequest_SolvingMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_optimization_v1_fleet_routing_proto_rawDescGZIP(), []int{0, 0}
}

// Mode defining the behavior of the search, trading off latency versus
// solution quality. In all modes, the global request deadline is enforced.
type OptimizeToursRequest_SearchMode int32

const (
	// Unspecified search mode, equivalent to `RETURN_FAST`.
	OptimizeToursRequest_SEARCH_MODE_UNSPECIFIED OptimizeToursRequest_SearchMode = 0
	// Stop the search after finding the first good solution.
	OptimizeToursRequest_RETURN_FAST OptimizeToursRequest_SearchMode = 1
	// Spend all the available time to search for better solutions.
	OptimizeToursRequest_CONSUME_ALL_AVAILABLE_TIME OptimizeToursRequest_SearchMode = 2
)

// Enum value maps for OptimizeToursRequest_SearchMode.
var (
	OptimizeToursRequest_SearchMode_name = map[int32]string{
		0: "SEARCH_MODE_UNSPECIFIED",
		1: "RETURN_FAST",
		2: "CONSUME_ALL_AVAILABLE_TIME",
	}
	OptimizeToursRequest_SearchMode_value = map[string]int32{
		"SEARCH_MODE_UNSPECIFIED":    0,
		"RETURN_FAST":                1,
		"CONSUME_ALL_AVAILABLE_TIME": 2,
	}
)

func (x OptimizeToursRequest_SearchMode) Enum() *OptimizeToursRequest_SearchMode {
	p := new(OptimizeToursRequest_SearchMode)
	*p = x
	return p
}

func (x OptimizeToursRequest_SearchMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OptimizeToursRequest_SearchMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_optimization_v1_fleet_routing_proto_enumTypes[1].Descriptor()
}

func (OptimizeToursRequest_SearchMode) Type() protoreflect.EnumType {
	return &file_google_cloud_optimization_v1_fleet_routing_proto_enumTypes[1]
}

func (x OptimizeToursRequest_SearchMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OptimizeToursRequest_SearchMode.Descriptor instead.
func (OptimizeToursRequest_SearchMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_optimization_v1_fleet_routing_proto_rawDescGZIP(), []int{0, 1}
}

// Modes defining how the appearance of incompatible shipments are restricted
// on the same route.
type ShipmentTypeIncompatibility_IncompatibilityMode int32

const (
	// Unspecified incompatibility mode. This value should never be used.
	ShipmentTypeIncompatibility_INCOMPATIBILITY_MODE_UNSPECIFIED ShipmentTypeIncompatibility_IncompatibilityMode = 0
	// In this mode, two shipments with incompatible types can never share the
	// same vehicle.
	ShipmentTypeIncompatibility_NOT_PERFORMED_BY_SAME_VEHICLE ShipmentTypeIncompatibility_IncompatibilityMode = 1
	// For two shipments with incompatible types with the
	// `NOT_IN_SAME_VEHICLE_SIMULTANEOUSLY` incompatibility mode:
	//
	// * If both are pickups only (no deliveries) or deliveries only (no
	//   pickups), they cannot share the same vehicle at all.
	// * If one of the shipments has a delivery and the other a pickup, the two
	//   shipments can share the same vehicle iff the former shipment is
	//   delivered before the latter is picked up.
	ShipmentTypeIncompatibility_NOT_IN_SAME_VEHICLE_SIMULTANEOUSLY ShipmentTypeIncompatibility_IncompatibilityMode = 2
)

// Enum value maps for ShipmentTypeIncompatibility_IncompatibilityMode.
var (
	ShipmentTypeIncompatibility_IncompatibilityMode_name = map[int32]string{
		0: "INCOMPATIBILITY_MODE_UNSPECIFIED",
		1: "NOT_PERFORMED_BY_SAME_VEHICLE",
		2: "NOT_IN_SAME_VEHICLE_SIMULTANEOUSLY",
	}
	ShipmentTypeIncompatibility_IncompatibilityMode_value = map[string]int32{
		"INCOMPATIBILITY_MODE_UNSPECIFIED":   0,
		"NOT_PERFORMED_BY_SAME_VEHICLE":      1,
		"NOT_IN_SAME_VEHICLE_SIMULTANEOUSLY": 2,
	}
)

func (x ShipmentTypeIncompatibility_IncompatibilityMode) Enum() *ShipmentTypeIncompatibility_IncompatibilityMode {
	p := new(ShipmentTypeIncompatibility_IncompatibilityMode)
	*p = x
	return p
}

func (x ShipmentTypeIncompatibility_IncompatibilityMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ShipmentTypeIncompatibility_IncompatibilityMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_optimization_v1_fleet_routing_proto_enumTypes[2].Descriptor()
}

func (ShipmentTypeIncompatibility_IncompatibilityMode) Type() protoreflect.EnumType {
	return &file_google_cloud_optimization_v1_fleet_routing_proto_enumTypes[2]
}

func (x ShipmentTypeIncompatibility_IncompatibilityMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ShipmentTypeIncompatibility_IncompatibilityMode.Descriptor instead.
func (ShipmentTypeIncompatibility_IncompatibilityMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_optimization_v1_fleet_routing_proto_rawDescGZIP(), []int{6, 0}
}

// Modes defining the appearance of dependent shipments on a route.
type ShipmentTypeRequirement_RequirementMode int32

const (
	// Unspecified requirement mode. This value should never be used.
	ShipmentTypeRequirement_REQUIREMENT_MODE_UNSPECIFIED ShipmentTypeRequirement_RequirementMode = 0
	// In this mode, all "dependent" shipments must share the same vehicle as at
	// least one of their "required" shipments.
	ShipmentTypeRequirement_PERFORMED_BY_SAME_VEHICLE ShipmentTypeRequirement_RequirementMode = 1
	// With the `IN_SAME_VEHICLE_AT_PICKUP_TIME` mode, all "dependent"
	// shipments need to have at least one "required" shipment on their vehicle
	// at the time of their pickup.
	//
	// A "dependent" shipment pickup must therefore have either:
	//
	// * A delivery-only "required" shipment delivered on the route after, or
	// * A "required" shipment picked up on the route before it, and if the
	//   "required" shipment has a delivery, this delivery must be performed
	//   after the "dependent" shipment's pickup.
	ShipmentTypeRequirement_IN_SAME_VEHICLE_AT_PICKUP_TIME ShipmentTypeRequirement_RequirementMode = 2
	// Same as before, except the "dependent" shipments need to have a
	// "required" shipment on their vehicle at the time of their *delivery*.
	ShipmentTypeRequirement_IN_SAME_VEHICLE_AT_DELIVERY_TIME ShipmentTypeRequirement_RequirementMode = 3
)

// Enum value maps for ShipmentTypeRequirement_RequirementMode.
var (
	ShipmentTypeRequirement_RequirementMode_name = map[int32]string{
		0: "REQUIREMENT_MODE_UNSPECIFIED",
		1: "PERFORMED_BY_SAME_VEHICLE",
		2: "IN_SAME_VEHICLE_AT_PICKUP_TIME",
		3: "IN_SAME_VEHICLE_AT_DELIVERY_TIME",
	}
	ShipmentTypeRequirement_RequirementMode_value = map[string]int32{
		"REQUIREMENT_MODE_UNSPECIFIED":     0,
		"PERFORMED_BY_SAME_VEHICLE":        1,
		"IN_SAME_VEHICLE_AT_PICKUP_TIME":   2,
		"IN_SAME_VEHICLE_AT_DELIVERY_TIME": 3,
	}
)

func (x ShipmentTypeRequirement_RequirementMode) Enum() *ShipmentTypeRequirement_RequirementMode {
	p := new(ShipmentTypeRequirement_RequirementMode)
	*p = x
	return p
}

func (x ShipmentTypeRequirement_RequirementMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ShipmentTypeRequirement_RequirementMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_optimization_v1_fleet_routing_proto_enumTypes[3].Descriptor()
}

func (ShipmentTypeRequirement_RequirementMode) Type() protoreflect.EnumType {
	return &file_google_cloud_optimization_v1_fleet_routing_proto_enumTypes[3]
}

func (x ShipmentTypeRequirement_RequirementMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ShipmentTypeRequirement_RequirementMode.Descriptor instead.
func (ShipmentTypeRequirement_RequirementMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_optimization_v1_fleet_routing_proto_rawDescGZIP(), []int{7, 0}
}

// Travel modes which can be used by vehicles.
//
// These should be a subset of the Google Maps Platform Routes Preferred API
// travel modes, see:
// https://developers.google.com/maps/documentation/routes_preferred/reference/rest/Shared.Types/RouteTravelMode.
type Vehicle_TravelMode int32

const (
	// Unspecified travel mode, equivalent to `DRIVING`.
	Vehicle_TRAVEL_MODE_UNSPECIFIED Vehicle_TravelMode = 0
	// Travel mode corresponding to driving directions (car, ...).
	Vehicle_DRIVING Vehicle_TravelMode = 1
	// Travel mode corresponding to walking directions.
	Vehicle_WALKING Vehicle_TravelMode = 2
)

// Enum value maps for Vehicle_TravelMode.
var (
	Vehicle_TravelMode_name = map[int32]string{
		0: "TRAVEL_MODE_UNSPECIFIED",
		1: "DRIVING",
		2: "WALKING",
	}
	Vehicle_TravelMode_value = map[string]int32{
		"TRAVEL_MODE_UNSPECIFIED": 0,
		"DRIVING":                 1,
		"WALKING":                 2,
	}
)

func (x Vehicle_TravelMode) Enum() *Vehicle_TravelMode {
	p := new(Vehicle_TravelMode)
	*p = x
	return p
}

func (x Vehicle_TravelMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Vehicle_TravelMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_optimization_v1_fleet_routing_proto_enumTypes[4].Descriptor()
}

func (Vehicle_TravelMode) Type() protoreflect.EnumType {
	return &file_google_cloud_optimization_v1_fleet_routing_proto_enumTypes[4]
}

func (x Vehicle_TravelMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Vehicle_TravelMode.Descriptor instead.
func (Vehicle_TravelMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_optimization_v1_fleet_routing_proto_rawDescGZIP(), []int{8, 0}
}

// Policy on how a vehicle can be unloaded. Applies only to shipments having
// both a pickup and a delivery.
//
// Other shipments are free to occur anywhere on the route independent of
// `unloading_policy`.
type Vehicle_UnloadingPolicy int32

const (
	// Unspecified unloading policy; deliveries must just occur after their
	// corresponding pickups.
	Vehicle_UNLOADING_POLICY_UNSPECIFIED Vehicle_UnloadingPolicy = 0
	// Deliveries must occur in reverse order of pickups
	Vehicle_LAST_IN_FIRST_OUT Vehicle_UnloadingPolicy = 1
	// Deliveries must occur in the same order as pickups
	Vehicle_FIRST_IN_FIRST_OUT Vehicle_UnloadingPolicy = 2
)

// Enum value maps for Vehicle_UnloadingPolicy.
var (
	Vehicle_UnloadingPolicy_name = map[int32]string{
		0: "UNLOADING_POLICY_UNSPECIFIED",
		1: "LAST_IN_FIRST_OUT",
		2: "FIRST_IN_FIRST_OUT",
	}
	Vehicle_UnloadingPolicy_value = map[string]int32{
		"UNLOADING_POLICY_UNSPECIFIED": 0,
		"LAST_IN_FIRST_OUT":            1,
		"FIRST_IN_FIRST_OUT":           2,
	}
)

func (x Vehicle_UnloadingPolicy) Enum() *Vehicle_UnloadingPolicy {
	p := new(Vehicle_UnloadingPolicy)
	*p = x
	return p
}

func (x Vehicle_UnloadingPolicy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Vehicle_UnloadingPolicy) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_optimization_v1_fleet_routing_proto_enumTypes[5].Descriptor()
}

func (Vehicle_UnloadingPolicy) Type() protoreflect.EnumType {
	return &file_google_cloud_optimization_v1_fleet_routing_proto_enumTypes[5]
}

func (x Vehicle_UnloadingPolicy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Vehicle_UnloadingPolicy.Descriptor instead.
func (Vehicle_UnloadingPolicy) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_optimization_v1_fleet_routing_proto_rawDescGZIP(), []int{8, 1}
}

// Code identifying the reason type. The order here is meaningless. In
// particular, it gives no indication of whether a given reason will
// appear before another in the solution, if both apply.
type SkippedShipment_Reason_Code int32

const (
	// This should never be used. If we are unable to understand why a
	// shipment was skipped, we simply return an empty set of reasons.
	SkippedShipment_Reason_CODE_UNSPECIFIED SkippedShipment_Reason_Code = 0
	// There is no vehicle in the model making all shipments infeasible.
	SkippedShipment_Reason_NO_VEHICLE SkippedShipment_Reason_Code = 1
	// The demand of the shipment exceeds a vehicle's capacity for some
	// capacity types, one of which is `example_exceeded_capacity_type`.
	SkippedShipment_Reason_DEMAND_EXCEEDS_VEHICLE_CAPACITY SkippedShipment_Reason_Code = 2
	// The minimum distance necessary to perform this shipment, i.e. from
	// the vehicle's `start_location` to the shipment's pickup and/or delivery
	// locations and to the vehicle's end location exceeds the vehicle's
	// `route_distance_limit`.
	//
	// Note that for this computation we use the geodesic distances.
	SkippedShipment_Reason_CANNOT_BE_PERFORMED_WITHIN_VEHICLE_DISTANCE_LIMIT SkippedShipment_Reason_Code = 3
	// The minimum time necessary to perform this shipment, including travel
	// time, wait time and service time exceeds the vehicle's
	// `route_duration_limit`.
	//
	// Note: travel time is computed in the best-case scenario, namely as
	// geodesic distance x 36 m/s (roughly 130 km/hour).
	SkippedShipment_Reason_CANNOT_BE_PERFORMED_WITHIN_VEHICLE_DURATION_LIMIT SkippedShipment_Reason_Code = 4
	// Same as above but we only compare minimum travel time and the
	// vehicle's `travel_duration_limit`.
	SkippedShipment_Reason_CANNOT_BE_PERFORMED_WITHIN_VEHICLE_TRAVEL_DURATION_LIMIT SkippedShipment_Reason_Code = 5
	// The vehicle cannot perform this shipment in the best-case scenario
	// (see `CANNOT_BE_PERFORMED_WITHIN_VEHICLE_DURATION_LIMIT` for time
	// computation) if it starts at its earliest start time: the total time
	// would make the vehicle end after its latest end time.
	SkippedShipment_Reason_CANNOT_BE_PERFORMED_WITHIN_VEHICLE_TIME_WINDOWS SkippedShipment_Reason_Code = 6
	// The `allowed_vehicle_indices` field of the shipment is not empty and
	// this vehicle does not belong to it.
	SkippedShipment_Reason_VEHICLE_NOT_ALLOWED SkippedShipment_Reason_Code = 7
)

// Enum value maps for SkippedShipment_Reason_Code.
var (
	SkippedShipment_Reason_Code_name = map[int32]string{
		0: "CODE_UNSPECIFIED",
		1: "NO_VEHICLE",
		2: "DEMAND_EXCEEDS_VEHICLE_CAPACITY",
		3: "CANNOT_BE_PERFORMED_WITHIN_VEHICLE_DISTANCE_LIMIT",
		4: "CANNOT_BE_PERFORMED_WITHIN_VEHICLE_DURATION_LIMIT",
		5: "CANNOT_BE_PERFORMED_WITHIN_VEHICLE_TRAVEL_DURATION_LIMIT",
		6: "CANNOT_BE_PERFORMED_WITHIN_VEHICLE_TIME_WINDOWS",
		7: "VEHICLE_NOT_ALLOWED",
	}
	SkippedShipment_Reason_Code_value = map[string]int32{
		"CODE_UNSPECIFIED":                0,
		"NO_VEHICLE":                      1,
		"DEMAND_EXCEEDS_VEHICLE_CAPACITY": 2,
		"CANNOT_BE_PERFORMED_WITHIN_VEHICLE_DISTANCE_LIMIT":        3,
		"CANNOT_BE_PERFORMED_WITHIN_VEHICLE_DURATION_LIMIT":        4,
		"CANNOT_BE_PERFORMED_WITHIN_VEHICLE_TRAVEL_DURATION_LIMIT": 5,
		"CANNOT_BE_PERFORMED_WITHIN_VEHICLE_TIME_WINDOWS":          6,
		"VEHICLE_NOT_ALLOWED":                                      7,
	}
)

func (x SkippedShipment_Reason_Code) Enum() *SkippedShipment_Reason_Code {
	p := new(SkippedShipment_Reason_Code)
	*p = x
	return p
}

func (x SkippedShipment_Reason_Code) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SkippedShipment_Reason_Code) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_optimization_v1_fleet_routing_proto_enumTypes[6].Descriptor()
}

func (SkippedShipment_Reason_Code) Type() protoreflect.EnumType {
	return &file_google_cloud_optimization_v1_fleet_routing_proto_enumTypes[6]
}

func (x SkippedShipment_Reason_Code) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SkippedShipment_Reason_Code.Descriptor instead.
func (SkippedShipment_Reason_Code) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_optimization_v1_fleet_routing_proto_rawDescGZIP(), []int{18, 0, 0}
}

// Expresses the different constraint relaxation levels, which are
// applied for a visit and those that follow when it satisfies the
// threshold conditions.
//
// The enumeration below is in order of increasing relaxation.
type InjectedSolutionConstraint_ConstraintRelaxation_Relaxation_Level int32

const (
	// Implicit default relaxation level: no constraints are relaxed,
	// i.e., all visits are fully constrained.
	//
	// This value must not be explicitly used in `level`.
	InjectedSolutionConstraint_ConstraintRelaxation_Relaxation_LEVEL_UNSPECIFIED InjectedSolutionConstraint_ConstraintRelaxation_Relaxation_Level = 0
	// Visit start times and vehicle start/end times will be relaxed, but
	// each visit remains bound to the same vehicle and the visit sequence
	// must be observed: no visit can be inserted between them or before
	// them.
	InjectedSolutionConstraint_ConstraintRelaxation_Relaxation_RELAX_VISIT_TIMES_AFTER_THRESHOLD InjectedSolutionConstraint_ConstraintRelaxation_Relaxation_Level = 1
	// Same as `RELAX_VISIT_TIMES_AFTER_THRESHOLD`, but the visit sequence
	// is also relaxed: visits can only be performed by this vehicle, but
	// can potentially become unperformed.
	InjectedSolutionConstraint_ConstraintRelaxation_Relaxation_RELAX_VISIT_TIMES_AND_SEQUENCE_AFTER_THRESHOLD InjectedSolutionConstraint_ConstraintRelaxation_Relaxation_Level = 2
	// Same as `RELAX_VISIT_TIMES_AND_SEQUENCE_AFTER_THRESHOLD`, but the
	// vehicle is also relaxed: visits are completely free at or after the
	// threshold time and can potentially become unperformed.
	InjectedSolutionConstraint_ConstraintRelaxation_Relaxation_RELAX_ALL_AFTER_THRESHOLD InjectedSolutionConstraint_ConstraintRelaxation_Relaxation_Level = 3
)

// Enum value maps for InjectedSolutionConstraint_ConstraintRelaxation_Relaxation_Level.
var (
	InjectedSolutionConstraint_ConstraintRelaxation_Relaxation_Level_name = map[int32]string{
		0: "LEVEL_UNSPECIFIED",
		1: "RELAX_VISIT_TIMES_AFTER_THRESHOLD",
		2: "RELAX_VISIT_TIMES_AND_SEQUENCE_AFTER_THRESHOLD",
		3: "RELAX_ALL_AFTER_THRESHOLD",
	}
	InjectedSolutionConstraint_ConstraintRelaxation_Relaxation_Level_value = map[string]int32{
		"LEVEL_UNSPECIFIED":                              0,
		"RELAX_VISIT_TIMES_AFTER_THRESHOLD":              1,
		"RELAX_VISIT_TIMES_AND_SEQUENCE_AFTER_THRESHOLD": 2,
		"RELAX_ALL_AFTER_THRESHOLD":                      3,
	}
)

func (x InjectedSolutionConstraint_ConstraintRelaxation_Relaxation_Level) Enum() *InjectedSolutionConstraint_ConstraintRelaxation_Relaxation_Level {
	p := new(InjectedSolutionConstraint_ConstraintRelaxation_Relaxation_Level)
	*p = x
	return p
}

func (x InjectedSolutionConstraint_ConstraintRelaxation_Relaxation_Level) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InjectedSolutionConstraint_ConstraintRelaxation_Relaxation_Level) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_optimization_v1_fleet_routing_proto_enumTypes[7].Descriptor()
}

func (InjectedSolutionConstraint_ConstraintRelaxation_Relaxation_Level) Type() protoreflect.EnumType {
	return &file_google_cloud_optimization_v1_fleet_routing_proto_enumTypes[7]
}

func (x InjectedSolutionConstraint_ConstraintRelaxation_Relaxation_Level) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InjectedSolutionConstraint_ConstraintRelaxation_Relaxation_Level.Descriptor instead.
func (InjectedSolutionConstraint_ConstraintRelaxation_Relaxation_Level) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_optimization_v1_fleet_routing_proto_rawDescGZIP(), []int{20, 0, 0, 0}
}

// Request to be given to a tour optimization solver which defines the
// shipment model to solve as well as optimization parameters.
type OptimizeToursRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Target project and location to make a call.
	//
	// Format: `projects/{project-id}/locations/{location-id}`.
	//
	// If no location is specified, a region will be chosen automatically.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// If this timeout is set, the server returns a response before the timeout
	// period has elapsed or the server deadline for synchronous requests is
	// reached, whichever is sooner.
	//
	// For asynchronous requests, the server will generate a solution (if
	// possible) before the timeout has elapsed.
	Timeout *durationpb.Duration `protobuf:"bytes,2,opt,name=timeout,proto3" json:"timeout,omitempty"`
	// Shipment model to solve.
	Model *ShipmentModel `protobuf:"bytes,3,opt,name=model,proto3" json:"model,omitempty"`
	// By default, the solving mode is `DEFAULT_SOLVE` (0).
	SolvingMode OptimizeToursRequest_SolvingMode `protobuf:"varint,4,opt,name=solving_mode,json=solvingMode,proto3,enum=google.cloud.optimization.v1.OptimizeToursRequest_SolvingMode" json:"solving_mode,omitempty"`
	// Search mode used to solve the request.
	SearchMode OptimizeToursRequest_SearchMode `protobuf:"varint,6,opt,name=search_mode,json=searchMode,proto3,enum=google.cloud.optimization.v1.OptimizeToursRequest_SearchMode" json:"search_mode,omitempty"`
	// Guide the optimization algorithm in finding a first solution that is
	// similar to a previous solution.
	//
	// The model is constrained when the first solution is built.
	// Any shipments not performed on a route are implicitly skipped in the first
	// solution, but they may be performed in successive solutions.
	//
	// The solution must satisfy some basic validity assumptions:
	//
	//   * for all routes, `vehicle_index` must be in range and not be duplicated.
	//   * for all visits, `shipment_index` and `visit_request_index` must be
	//     in range.
	//   * a shipment may only be referenced on one route.
	//   * the pickup of a pickup-delivery shipment must be performed before
	//     the delivery.
	//   * no more than one pickup alternative or delivery alternative of
	//     a shipment may be performed.
	//   * for all routes, times are increasing (i.e., `vehicle_start_time
	//     <= visits[0].start_time <= visits[1].start_time ...
	//     <= vehicle_end_time`).
	//   * a shipment may only be performed on a vehicle that is allowed. A
	//     vehicle is allowed if
	//     [Shipment.allowed_vehicle_indices][google.cloud.optimization.v1.Shipment.allowed_vehicle_indices]
	//     is empty or its `vehicle_index` is included in
	//     [Shipment.allowed_vehicle_indices][google.cloud.optimization.v1.Shipment.allowed_vehicle_indices].
	//
	// If the injected solution is not feasible, a validation error is not
	// necessarily returned and an error indicating infeasibility may be returned
	// instead.
	InjectedFirstSolutionRoutes []*ShipmentRoute `protobuf:"bytes,7,rep,name=injected_first_solution_routes,json=injectedFirstSolutionRoutes,proto3" json:"injected_first_solution_routes,omitempty"`
	// Constrain the optimization algorithm to find a final solution that is
	// similar to a previous solution. For example, this may be used to freeze
	// portions of routes which have already been completed or which are to be
	// completed but must not be modified.
	//
	// If the injected solution is not feasible, a validation error is not
	// necessarily returned and an error indicating infeasibility may be returned
	// instead.
	InjectedSolutionConstraint *InjectedSolutionConstraint `protobuf:"bytes,8,opt,name=injected_solution_constraint,json=injectedSolutionConstraint,proto3" json:"injected_solution_constraint,omitempty"`
	// If non-empty, the given routes will be refreshed, without modifying their
	// underlying sequence of visits or travel times: only other details will be
	// updated. This does not solve the model.
	//
	// As of 2020/11, this only populates the polylines of non-empty routes and
	// requires that `populate_polylines` is true.
	//
	// The `route_polyline` fields of the passed-in routes may be inconsistent
	// with route `transitions`.
	//
	// This field must not be used together with `injected_first_solution_routes`
	// or `injected_solution_constraint`.
	//
	// `Shipment.ignore` and `Vehicle.ignore` have no effect on the behavior.
	// Polylines are still populated between all visits in all non-empty routes
	// regardless of whether the related shipments or vehicles are ignored.
	RefreshDetailsRoutes []*ShipmentRoute `protobuf:"bytes,9,rep,name=refresh_details_routes,json=refreshDetailsRoutes,proto3" json:"refresh_details_routes,omitempty"`
	// If true:
	//
	//   * uses
	//   [ShipmentRoute.vehicle_label][google.cloud.optimization.v1.ShipmentRoute.vehicle_label]
	//   instead of `vehicle_index` to
	//     match routes in an injected solution with vehicles in the request;
	//     reuses the mapping of original
	//     [ShipmentRoute.vehicle_index][google.cloud.optimization.v1.ShipmentRoute.vehicle_index]
	//     to new
	//     [ShipmentRoute.vehicle_index][google.cloud.optimization.v1.ShipmentRoute.vehicle_index]
	//     to update
	//     [ConstraintRelaxation.vehicle_indices][google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation.vehicle_indices]
	//     if non-empty, but the mapping must be unambiguous (i.e., multiple
	//     `ShipmentRoute`s must not share the same original `vehicle_index`).
	//   * uses
	//   [ShipmentRoute.Visit.shipment_label][google.cloud.optimization.v1.ShipmentRoute.Visit.shipment_label]
	//   instead of `shipment_index`
	//     to match visits in an injected solution with shipments in the request;
	//   * uses
	//   [SkippedShipment.label][google.cloud.optimization.v1.SkippedShipment.label]
	//   instead of
	//   [SkippedShipment.index][google.cloud.optimization.v1.SkippedShipment.index]
	//   to
	//     match skipped shipments in the injected solution with request
	//     shipments.
	//
	// This interpretation applies to the `injected_first_solution_routes`,
	// `injected_solution_constraint`, and `refresh_details_routes` fields.
	// It can be used when shipment or vehicle indices in the request have
	// changed since the solution was created, perhaps because shipments or
	// vehicles have been removed from or added to the request.
	//
	// If true, labels in the following categories must appear at most once in
	// their category:
	//
	//   * [Vehicle.label][google.cloud.optimization.v1.Vehicle.label] in the
	//   request;
	//   * [Shipment.label][google.cloud.optimization.v1.Shipment.label] in the
	//   request;
	//   * [ShipmentRoute.vehicle_label][google.cloud.optimization.v1.ShipmentRoute.vehicle_label] in the injected solution;
	//   * [SkippedShipment.label][google.cloud.optimization.v1.SkippedShipment.label] and [ShipmentRoute.Visit.shipment_label][google.cloud.optimization.v1.ShipmentRoute.Visit.shipment_label] in
	//     the injected solution (except pickup/delivery visit pairs, whose
	//     `shipment_label` must appear twice).
	//
	// If a `vehicle_label` in the injected solution does not correspond to a
	// request vehicle, the corresponding route is removed from the solution
	// along with its visits. If a `shipment_label` in the injected solution does
	// not correspond to a request shipment, the corresponding visit is removed
	// from the solution. If a
	// [SkippedShipment.label][google.cloud.optimization.v1.SkippedShipment.label]
	// in the injected solution does not correspond to a request shipment, the
	// `SkippedShipment` is removed from the solution.
	//
	// Removing route visits or entire routes from an injected solution may
	// have an effect on the implied constraints, which may lead to change in
	// solution, validation errors, or infeasibility.
	//
	// NOTE: The caller must ensure that each
	// [Vehicle.label][google.cloud.optimization.v1.Vehicle.label] (resp.
	// [Shipment.label][google.cloud.optimization.v1.Shipment.label]) uniquely
	// identifies a vehicle (resp. shipment) entity used across the two relevant
	// requests: the past request that produced the `OptimizeToursResponse` used
	// in the injected solution and the current request that includes the injected
	// solution. The uniqueness checks described above are not enough to guarantee
	// this requirement.
	InterpretInjectedSolutionsUsingLabels bool `protobuf:"varint,10,opt,name=interpret_injected_solutions_using_labels,json=interpretInjectedSolutionsUsingLabels,proto3" json:"interpret_injected_solutions_using_labels,omitempty"`
	// Consider traffic estimation in calculating `ShipmentRoute` fields
	// [Transition.travel_duration][google.cloud.optimization.v1.ShipmentRoute.Transition.travel_duration],
	// [Visit.start_time][google.cloud.optimization.v1.ShipmentRoute.Visit.start_time],
	// and `vehicle_end_time`; in setting the
	// [ShipmentRoute.has_traffic_infeasibilities][google.cloud.optimization.v1.ShipmentRoute.has_traffic_infeasibilities]
	// field, and in calculating the
	// [OptimizeToursResponse.total_cost][google.cloud.optimization.v1.OptimizeToursResponse.total_cost]
	// field.
	ConsiderRoadTraffic bool `protobuf:"varint,11,opt,name=consider_road_traffic,json=considerRoadTraffic,proto3" json:"consider_road_traffic,omitempty"`
	// If true, polylines will be populated in response `ShipmentRoute`s.
	PopulatePolylines bool `protobuf:"varint,12,opt,name=populate_polylines,json=populatePolylines,proto3" json:"populate_polylines,omitempty"`
	// If true, polylines will be populated in response
	// [ShipmentRoute.transitions][google.cloud.optimization.v1.ShipmentRoute.transitions].
	// Note that in this case, the polylines will also be populated in the
	// deprecated `travel_steps`.
	PopulateTransitionPolylines bool `protobuf:"varint,13,opt,name=populate_transition_polylines,json=populateTransitionPolylines,proto3" json:"populate_transition_polylines,omitempty"`
	// If this is set, then the request can have a deadline
	// (see https://grpc.io/blog/deadlines) of up to 60 minutes.
	// Otherwise, the maximum deadline is only 30 minutes.
	// Note that long-lived requests have a significantly larger (but still small)
	// risk of interruption.
	AllowLargeDeadlineDespiteInterruptionRisk bool `protobuf:"varint,14,opt,name=allow_large_deadline_despite_interruption_risk,json=allowLargeDeadlineDespiteInterruptionRisk,proto3" json:"allow_large_deadline_despite_interruption_risk,omitempty"`
	// If true, travel distances will be computed using geodesic distances instead
	// of Google Maps distances, and travel times will be computed using geodesic
	// distances with a speed defined by `geodesic_meters_per_second`.
	UseGeodesicDistances bool `protobuf:"varint,15,opt,name=use_geodesic_distances,json=useGeodesicDistances,proto3" json:"use_geodesic_distances,omitempty"`
	// When `use_geodesic_distances` is true, this field must be set and defines
	// the speed applied to compute travel times. Its value must be at least 1.0
	// meters/seconds.
	GeodesicMetersPerSecond *float64 `protobuf:"fixed64,16,opt,name=geodesic_meters_per_second,json=geodesicMetersPerSecond,proto3,oneof" json:"geodesic_meters_per_second,omitempty"`
	// Truncates the number of validation errors returned. These errors are
	// typically attached to an INVALID_ARGUMENT error payload as a BadRequest
	// error detail (https://cloud.google.com/apis/design/errors#error_details),
	// unless solving_mode=VALIDATE_ONLY: see the
	// [OptimizeToursResponse.validation_errors][google.cloud.optimization.v1.OptimizeToursResponse.validation_errors]
	// field.
	// This defaults to 100 and is capped at 10,000.
	MaxValidationErrors *int32 `protobuf:"varint,5,opt,name=max_validation_errors,json=maxValidationErrors,proto3,oneof" json:"max_validation_errors,omitempty"`
	// Label that may be used to identify this request, reported back in the
	// [OptimizeToursResponse.request_label][google.cloud.optimization.v1.OptimizeToursResponse.request_label].
	Label string `protobuf:"bytes,17,opt,name=label,proto3" json:"label,omitempty"`
	// Deprecated: Use
	// [OptimizeToursRequest.populate_transition_polylines][google.cloud.optimization.v1.OptimizeToursRequest.populate_transition_polylines]
	// instead. If true, polylines will be populated in response
	// [ShipmentRoute.transitions][google.cloud.optimization.v1.ShipmentRoute.transitions].
	// Note that in this case, the polylines will also be populated in the
	// deprecated `travel_steps`.
	//
	// Deprecated: Marked as deprecated in google/cloud/optimization/v1/fleet_routing.proto.
	PopulateTravelStepPolylines bool `protobuf:"varint,20,opt,name=populate_travel_step_polylines,json=populateTravelStepPolylines,proto3" json:"populate_travel_step_polylines,omitempty"`
}

func (x *OptimizeToursRequest) Reset() {
	*x = OptimizeToursRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OptimizeToursRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OptimizeToursRequest) ProtoMessage() {}

func (x *OptimizeToursRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OptimizeToursRequest.ProtoReflect.Descriptor instead.
func (*OptimizeToursRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_optimization_v1_fleet_routing_proto_rawDescGZIP(), []int{0}
}

func (x *OptimizeToursRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *OptimizeToursRequest) GetTimeout() *durationpb.Duration {
	if x != nil {
		return x.Timeout
	}
	return nil
}

func (x *OptimizeToursRequest) GetModel() *ShipmentModel {
	if x != nil {
		return x.Model
	}
	return nil
}

func (x *OptimizeToursRequest) GetSolvingMode() OptimizeToursRequest_SolvingMode {
	if x != nil {
		return x.SolvingMode
	}
	return OptimizeToursRequest_DEFAULT_SOLVE
}

func (x *OptimizeToursRequest) GetSearchMode() OptimizeToursRequest_SearchMode {
	if x != nil {
		return x.SearchMode
	}
	return OptimizeToursRequest_SEARCH_MODE_UNSPECIFIED
}

func (x *OptimizeToursRequest) GetInjectedFirstSolutionRoutes() []*ShipmentRoute {
	if x != nil {
		return x.InjectedFirstSolutionRoutes
	}
	return nil
}

func (x *OptimizeToursRequest) GetInjectedSolutionConstraint() *InjectedSolutionConstraint {
	if x != nil {
		return x.InjectedSolutionConstraint
	}
	return nil
}

func (x *OptimizeToursRequest) GetRefreshDetailsRoutes() []*ShipmentRoute {
	if x != nil {
		return x.RefreshDetailsRoutes
	}
	return nil
}

func (x *OptimizeToursRequest) GetInterpretInjectedSolutionsUsingLabels() bool {
	if x != nil {
		return x.InterpretInjectedSolutionsUsingLabels
	}
	return false
}

func (x *OptimizeToursRequest) GetConsiderRoadTraffic() bool {
	if x != nil {
		return x.ConsiderRoadTraffic
	}
	return false
}

func (x *OptimizeToursRequest) GetPopulatePolylines() bool {
	if x != nil {
		return x.PopulatePolylines
	}
	return false
}

func (x *OptimizeToursRequest) GetPopulateTransitionPolylines() bool {
	if x != nil {
		return x.PopulateTransitionPolylines
	}
	return false
}

func (x *OptimizeToursRequest) GetAllowLargeDeadlineDespiteInterruptionRisk() bool {
	if x != nil {
		return x.AllowLargeDeadlineDespiteInterruptionRisk
	}
	return false
}

func (x *OptimizeToursRequest) GetUseGeodesicDistances() bool {
	if x != nil {
		return x.UseGeodesicDistances
	}
	return false
}

func (x *OptimizeToursRequest) GetGeodesicMetersPerSecond() float64 {
	if x != nil && x.GeodesicMetersPerSecond != nil {
		return *x.GeodesicMetersPerSecond
	}
	return 0
}

func (x *OptimizeToursRequest) GetMaxValidationErrors() int32 {
	if x != nil && x.MaxValidationErrors != nil {
		return *x.MaxValidationErrors
	}
	return 0
}

func (x *OptimizeToursRequest) GetLabel() string {
	if x != nil {
		return x.Label
	}
	return ""
}

// Deprecated: Marked as deprecated in google/cloud/optimization/v1/fleet_routing.proto.
func (x *OptimizeToursRequest) GetPopulateTravelStepPolylines() bool {
	if x != nil {
		return x.PopulateTravelStepPolylines
	}
	return false
}

// Response after solving a tour optimization problem containing the routes
// followed by each vehicle, the shipments which have been skipped and the
// overall cost of the solution.
type OptimizeToursResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Routes computed for each vehicle; the i-th route corresponds to the i-th
	// vehicle in the model.
	Routes []*ShipmentRoute `protobuf:"bytes,1,rep,name=routes,proto3" json:"routes,omitempty"`
	// Copy of the
	// [OptimizeToursRequest.label][google.cloud.optimization.v1.OptimizeToursRequest.label],
	// if a label was specified in the request.
	RequestLabel string `protobuf:"bytes,3,opt,name=request_label,json=requestLabel,proto3" json:"request_label,omitempty"`
	// The list of all shipments skipped.
	SkippedShipments []*SkippedShipment `protobuf:"bytes,4,rep,name=skipped_shipments,json=skippedShipments,proto3" json:"skipped_shipments,omitempty"`
	// List of all the validation errors that we were able to detect
	// independently. See the "MULTIPLE ERRORS" explanation for the
	// [OptimizeToursValidationError][google.cloud.optimization.v1.OptimizeToursValidationError]
	// message.
	ValidationErrors []*OptimizeToursValidationError `protobuf:"bytes,5,rep,name=validation_errors,json=validationErrors,proto3" json:"validation_errors,omitempty"`
	// Duration, distance and usage metrics for this solution.
	Metrics *OptimizeToursResponse_Metrics `protobuf:"bytes,6,opt,name=metrics,proto3" json:"metrics,omitempty"`
	// Deprecated: Use
	// [Metrics.total_cost][google.cloud.optimization.v1.OptimizeToursResponse.Metrics.total_cost]
	// instead. Total cost of the solution. This takes into account all costs:
	// costs per per hour and travel hour, fixed vehicle costs, unperformed
	// shipment penalty costs, global duration cost, etc.
	//
	// Deprecated: Marked as deprecated in google/cloud/optimization/v1/fleet_routing.proto.
	TotalCost float64 `protobuf:"fixed64,2,opt,name=total_cost,json=totalCost,proto3" json:"total_cost,omitempty"`
}

func (x *OptimizeToursResponse) Reset() {
	*x = OptimizeToursResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OptimizeToursResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OptimizeToursResponse) ProtoMessage() {}

func (x *OptimizeToursResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OptimizeToursResponse.ProtoReflect.Descriptor instead.
func (*OptimizeToursResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_optimization_v1_fleet_routing_proto_rawDescGZIP(), []int{1}
}

func (x *OptimizeToursResponse) GetRoutes() []*ShipmentRoute {
	if x != nil {
		return x.Routes
	}
	return nil
}

func (x *OptimizeToursResponse) GetRequestLabel() string {
	if x != nil {
		return x.RequestLabel
	}
	return ""
}

func (x *OptimizeToursResponse) GetSkippedShipments() []*SkippedShipment {
	if x != nil {
		return x.SkippedShipments
	}
	return nil
}

func (x *OptimizeToursResponse) GetValidationErrors() []*OptimizeToursValidationError {
	if x != nil {
		return x.ValidationErrors
	}
	return nil
}

func (x *OptimizeToursResponse) GetMetrics() *OptimizeToursResponse_Metrics {
	if x != nil {
		return x.Metrics
	}
	return nil
}

// Deprecated: Marked as deprecated in google/cloud/optimization/v1/fleet_routing.proto.
func (x *OptimizeToursResponse) GetTotalCost() float64 {
	if x != nil {
		return x.TotalCost
	}
	return 0
}

// Request to batch optimize tours as an asynchronous operation.
// Each input file should contain one `OptimizeToursRequest`, and each output
// file will contain one `OptimizeToursResponse`. The request contains
// information to read/write and parse the files. All the input and output files
// should be under the same project.
type BatchOptimizeToursRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Target project and location to make a call.
	//
	// Format: `projects/{project-id}/locations/{location-id}`.
	//
	// If no location is specified, a region will be chosen automatically.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Input/Output information each purchase model, such as file paths
	// and data formats.
	ModelConfigs []*BatchOptimizeToursRequest_AsyncModelConfig `protobuf:"bytes,2,rep,name=model_configs,json=modelConfigs,proto3" json:"model_configs,omitempty"`
}

func (x *BatchOptimizeToursRequest) Reset() {
	*x = BatchOptimizeToursRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchOptimizeToursRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchOptimizeToursRequest) ProtoMessage() {}

func (x *BatchOptimizeToursRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchOptimizeToursRequest.ProtoReflect.Descriptor instead.
func (*BatchOptimizeToursRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_optimization_v1_fleet_routing_proto_rawDescGZIP(), []int{2}
}

func (x *BatchOptimizeToursRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BatchOptimizeToursRequest) GetModelConfigs() []*BatchOptimizeToursRequest_AsyncModelConfig {
	if x != nil {
		return x.ModelConfigs
	}
	return nil
}

// Response to a `BatchOptimizeToursRequest`. This is returned in
// the LRO Operation after the operation is complete.
type BatchOptimizeToursResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *BatchOptimizeToursResponse) Reset() {
	*x = BatchOptimizeToursResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchOptimizeToursResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchOptimizeToursResponse) ProtoMessage() {}

func (x *BatchOptimizeToursResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchOptimizeToursResponse.ProtoReflect.Descriptor instead.
func (*BatchOptimizeToursResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_optimization_v1_fleet_routing_proto_rawDescGZIP(), []int{3}
}

// A shipment model contains a set of shipments which must be performed by a
// set of vehicles, while minimizing the overall cost, which is the sum of:
//
//   - the cost of routing the vehicles (sum of cost per total time, cost per
//     travel time, and fixed cost over all vehicles).
//   - the unperformed shipment penalties.
//   - the cost of the global duration of the shipments
type ShipmentModel struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Set of shipments which must be performed in the model.
	Shipments []*Shipment `protobuf:"bytes,1,rep,name=shipments,proto3" json:"shipments,omitempty"`
	// Set of vehicles which can be used to perform visits.
	Vehicles []*Vehicle `protobuf:"bytes,2,rep,name=vehicles,proto3" json:"vehicles,omitempty"`
	// Constrains the maximum number of active vehicles. A vehicle is active if
	// its route performs at least one shipment. This can be used to limit the
	// number of routes in the case where there are fewer drivers than
	// vehicles and that the fleet of vehicles is heterogeneous. The optimization
	// will then select the best subset of vehicles to use.
	// Must be strictly positive.
	MaxActiveVehicles *int32 `protobuf:"varint,4,opt,name=max_active_vehicles,json=maxActiveVehicles,proto3,oneof" json:"max_active_vehicles,omitempty"`
	// Global start and end time of the model: no times outside of this range
	// can be considered valid.
	//
	// The model's time span must be less than a year, i.e. the `global_end_time`
	// and the `global_start_time` must be within 31536000 seconds of each other.
	//
	// When using `cost_per_*hour` fields, you might want to set this window to a
	// smaller interval to increase performance (eg. if you model a single day,
	// you should set the global time limits to that day).
	// If unset, 00:00:00 UTC, January 1, 1970 (i.e. seconds: 0, nanos: 0) is used
	// as default.
	GlobalStartTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=global_start_time,json=globalStartTime,proto3" json:"global_start_time,omitempty"`
	// If unset, 00:00:00 UTC, January 1, 1971 (i.e. seconds: 31536000, nanos: 0)
	// is used as default.
	GlobalEndTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=global_end_time,json=globalEndTime,proto3" json:"global_end_time,omitempty"`
	// The "global duration" of the overall plan is the difference between the
	// earliest effective start time and the latest effective end time of
	// all vehicles. Users can assign a cost per hour to that quantity to try
	// and optimize for earliest job completion, for example. This cost must be in
	// the same unit as
	// [Shipment.penalty_cost][google.cloud.optimization.v1.Shipment.penalty_cost].
	GlobalDurationCostPerHour float64 `protobuf:"fixed64,7,opt,name=global_duration_cost_per_hour,json=globalDurationCostPerHour,proto3" json:"global_duration_cost_per_hour,omitempty"`
	// Specifies duration and distance matrices used in the model. If this field
	// is empty, Google Maps or geodesic distances will be used instead, depending
	// on the value of the `use_geodesic_distances` field. If it is not empty,
	// `use_geodesic_distances` cannot be true and neither
	// `duration_distance_matrix_src_tags` nor `duration_distance_matrix_dst_tags`
	// can be empty.
	//
	// Usage examples:
	//
	// * There are two locations: locA and locB.
	// * 1 vehicle starting its route at locA and ending it at locA.
	// * 1 pickup visit request at locB.
	//
	// ```
	// model {
	//   vehicles { start_tags: "locA"  end_tags: "locA" }
	//   shipments { pickups { tags: "locB" } }
	//   duration_distance_matrix_src_tags: "locA"
	//   duration_distance_matrix_src_tags: "locB"
	//   duration_distance_matrix_dst_tags: "locA"
	//   duration_distance_matrix_dst_tags: "locB"
	//   duration_distance_matrices {
	//     rows {  # from: locA
	//       durations { seconds: 0 }   meters: 0    # to: locA
	//       durations { seconds: 100 } meters: 1000 # to: locB
	//     }
	//     rows {  # from: locB
	//       durations { seconds: 102 } meters: 990 # to: locA
	//       durations { seconds: 0 }   meters: 0   # to: locB
	//     }
	//   }
	// }
	// ```
	//
	//
	// * There are three locations: locA, locB and locC.
	// * 1 vehicle starting its route at locA and ending it at locB, using
	//   matrix "fast".
	// * 1 vehicle starting its route at locB and ending it at locB, using
	//   matrix "slow".
	// * 1 vehicle starting its route at locB and ending it at locB, using
	//   matrix "fast".
	// * 1 pickup visit request at locC.
	//
	// ```
	// model {
	//   vehicles { start_tags: "locA" end_tags: "locB" start_tags: "fast" }
	//   vehicles { start_tags: "locB" end_tags: "locB" start_tags: "slow" }
	//   vehicles { start_tags: "locB" end_tags: "locB" start_tags: "fast" }
	//   shipments { pickups { tags: "locC" } }
	//   duration_distance_matrix_src_tags: "locA"
	//   duration_distance_matrix_src_tags: "locB"
	//   duration_distance_matrix_src_tags: "locC"
	//   duration_distance_matrix_dst_tags: "locB"
	//   duration_distance_matrix_dst_tags: "locC"
	//   duration_distance_matrices {
	//     vehicle_start_tag: "fast"
	//     rows {  # from: locA
	//       durations { seconds: 1000 } meters: 2000 # to: locB
	//       durations { seconds: 600 }  meters: 1000 # to: locC
	//     }
	//     rows {  # from: locB
	//       durations { seconds: 0 }   meters: 0    # to: locB
	//       durations { seconds: 700 } meters: 1200 # to: locC
	//     }
	//     rows {  # from: locC
	//       durations { seconds: 702 } meters: 1190 # to: locB
	//       durations { seconds: 0 }   meters: 0    # to: locC
	//     }
	//   }
	//   duration_distance_matrices {
	//     vehicle_start_tag: "slow"
	//     rows {  # from: locA
	//       durations { seconds: 1800 } meters: 2001 # to: locB
	//       durations { seconds: 900 }  meters: 1002 # to: locC
	//     }
	//     rows {  # from: locB
	//       durations { seconds: 0 }    meters: 0    # to: locB
	//       durations { seconds: 1000 } meters: 1202 # to: locC
	//     }
	//     rows {  # from: locC
	//       durations { seconds: 1001 } meters: 1195 # to: locB
	//       durations { seconds: 0 }    meters: 0    # to: locC
	//     }
	//   }
	// }
	// ```
	DurationDistanceMatrices []*ShipmentModel_DurationDistanceMatrix `protobuf:"bytes,8,rep,name=duration_distance_matrices,json=durationDistanceMatrices,proto3" json:"duration_distance_matrices,omitempty"`
	// Tags defining the sources of the duration and distance matrices;
	// `duration_distance_matrices(i).rows(j)` defines durations and distances
	// from visits with tag `duration_distance_matrix_src_tags(j)` to other visits
	// in matrix i.
	//
	// Tags correspond to
	// [VisitRequest.tags][google.cloud.optimization.v1.Shipment.VisitRequest.tags]
	// or [Vehicle.start_tags][google.cloud.optimization.v1.Vehicle.start_tags].
	// A given `VisitRequest` or `Vehicle` must match exactly one tag in this
	// field. Note that a `Vehicle`'s source, destination and matrix tags may be
	// the same; similarly a `VisitRequest`'s source and destination tags may be
	// the same. All tags must be different and cannot be empty strings. If this
	// field is not empty, then `duration_distance_matrices` must not be empty.
	DurationDistanceMatrixSrcTags []string `protobuf:"bytes,9,rep,name=duration_distance_matrix_src_tags,json=durationDistanceMatrixSrcTags,proto3" json:"duration_distance_matrix_src_tags,omitempty"`
	// Tags defining the destinations of the duration and distance matrices;
	// `duration_distance_matrices(i).rows(j).durations(k)` (resp.
	// `duration_distance_matrices(i).rows(j).meters(k))` defines the duration
	// (resp. the distance) of the travel from visits with tag
	// `duration_distance_matrix_src_tags(j)` to visits with tag
	// `duration_distance_matrix_dst_tags(k)` in matrix i.
	//
	// Tags correspond to
	// [VisitRequest.tags][google.cloud.optimization.v1.Shipment.VisitRequest.tags]
	// or [Vehicle.start_tags][google.cloud.optimization.v1.Vehicle.start_tags].
	// A given `VisitRequest` or `Vehicle` must match exactly one tag in this
	// field. Note that a `Vehicle`'s source, destination and matrix tags may be
	// the same; similarly a `VisitRequest`'s source and destination tags may be
	// the same. All tags must be different and cannot be empty strings. If this
	// field is not empty, then `duration_distance_matrices` must not be empty.
	DurationDistanceMatrixDstTags []string `protobuf:"bytes,10,rep,name=duration_distance_matrix_dst_tags,json=durationDistanceMatrixDstTags,proto3" json:"duration_distance_matrix_dst_tags,omitempty"`
	// Transition attributes added to the model.
	TransitionAttributes []*TransitionAttributes `protobuf:"bytes,11,rep,name=transition_attributes,json=transitionAttributes,proto3" json:"transition_attributes,omitempty"`
	// Sets of incompatible shipment_types (see `ShipmentTypeIncompatibility`).
	ShipmentTypeIncompatibilities []*ShipmentTypeIncompatibility `protobuf:"bytes,12,rep,name=shipment_type_incompatibilities,json=shipmentTypeIncompatibilities,proto3" json:"shipment_type_incompatibilities,omitempty"`
	// Sets of `shipment_type` requirements (see `ShipmentTypeRequirement`).
	ShipmentTypeRequirements []*ShipmentTypeRequirement `protobuf:"bytes,13,rep,name=shipment_type_requirements,json=shipmentTypeRequirements,proto3" json:"shipment_type_requirements,omitempty"`
	// Set of precedence rules which must be enforced in the model.
	PrecedenceRules []*ShipmentModel_PrecedenceRule `protobuf:"bytes,14,rep,name=precedence_rules,json=precedenceRules,proto3" json:"precedence_rules,omitempty"`
	// Deprecated: No longer used.
	// Set of break rules used in the model.
	// Each vehicle specifies the `BreakRule` that applies to it via the
	// [Vehicle.break_rule_indices][google.cloud.optimization.v1.Vehicle.break_rule_indices]
	// field (which must be a singleton).
	//
	// Deprecated: Marked as deprecated in google/cloud/optimization/v1/fleet_routing.proto.
	BreakRules []*ShipmentModel_BreakRule `protobuf:"bytes,15,rep,name=break_rules,json=breakRules,proto3" json:"break_rules,omitempty"`
}

func (x *ShipmentModel) Reset() {
	*x = ShipmentModel{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ShipmentModel) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ShipmentModel) ProtoMessage() {}

func (x *ShipmentModel) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ShipmentModel.ProtoReflect.Descriptor instead.
func (*ShipmentModel) Descriptor() ([]byte, []int) {
	return file_google_cloud_optimization_v1_fleet_routing_proto_rawDescGZIP(), []int{4}
}

func (x *ShipmentModel) GetShipments() []*Shipment {
	if x != nil {
		return x.Shipments
	}
	return nil
}

func (x *ShipmentModel) GetVehicles() []*Vehicle {
	if x != nil {
		return x.Vehicles
	}
	return nil
}

func (x *ShipmentModel) GetMaxActiveVehicles() int32 {
	if x != nil && x.MaxActiveVehicles != nil {
		return *x.MaxActiveVehicles
	}
	return 0
}

func (x *ShipmentModel) GetGlobalStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.GlobalStartTime
	}
	return nil
}

func (x *ShipmentModel) GetGlobalEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.GlobalEndTime
	}
	return nil
}

func (x *ShipmentModel) GetGlobalDurationCostPerHour() float64 {
	if x != nil {
		return x.GlobalDurationCostPerHour
	}
	return 0
}

func (x *ShipmentModel) GetDurationDistanceMatrices() []*ShipmentModel_DurationDistanceMatrix {
	if x != nil {
		return x.DurationDistanceMatrices
	}
	return nil
}

func (x *ShipmentModel) GetDurationDistanceMatrixSrcTags() []string {
	if x != nil {
		return x.DurationDistanceMatrixSrcTags
	}
	return nil
}

func (x *ShipmentModel) GetDurationDistanceMatrixDstTags() []string {
	if x != nil {
		return x.DurationDistanceMatrixDstTags
	}
	return nil
}

func (x *ShipmentModel) GetTransitionAttributes() []*TransitionAttributes {
	if x != nil {
		return x.TransitionAttributes
	}
	return nil
}

func (x *ShipmentModel) GetShipmentTypeIncompatibilities() []*ShipmentTypeIncompatibility {
	if x != nil {
		return x.ShipmentTypeIncompatibilities
	}
	return nil
}

func (x *ShipmentModel) GetShipmentTypeRequirements() []*ShipmentTypeRequirement {
	if x != nil {
		return x.ShipmentTypeRequirements
	}
	return nil
}

func (x *ShipmentModel) GetPrecedenceRules() []*ShipmentModel_PrecedenceRule {
	if x != nil {
		return x.PrecedenceRules
	}
	return nil
}

// Deprecated: Marked as deprecated in google/cloud/optimization/v1/fleet_routing.proto.
func (x *ShipmentModel) GetBreakRules() []*ShipmentModel_BreakRule {
	if x != nil {
		return x.BreakRules
	}
	return nil
}

// The shipment of a single item, from one of its pickups to one of its
// deliveries. For the shipment to be considered as performed, a unique vehicle
// must visit one of its pickup locations (and decrease its spare capacities
// accordingly), then visit one of its delivery locations later on (and
// therefore re-increase its spare capacities accordingly).
type Shipment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Set of pickup alternatives associated to the shipment. If not specified,
	// the vehicle only needs to visit a location corresponding to the deliveries.
	Pickups []*Shipment_VisitRequest `protobuf:"bytes,1,rep,name=pickups,proto3" json:"pickups,omitempty"`
	// Set of delivery alternatives associated to the shipment. If not specified,
	// the vehicle only needs to visit a location corresponding to the pickups.
	Deliveries []*Shipment_VisitRequest `protobuf:"bytes,2,rep,name=deliveries,proto3" json:"deliveries,omitempty"`
	// Load demands of the shipment (for example weight, volume, number of
	// pallets etc). The keys in the map should be identifiers describing the type
	// of the corresponding load, ideally also including the units.
	// For example: "weight_kg", "volume_gallons", "pallet_count", etc.
	// If a given key does not appear in the map, the corresponding load is
	// considered as null.
	LoadDemands map[string]*Shipment_Load `protobuf:"bytes,14,rep,name=load_demands,json=loadDemands,proto3" json:"load_demands,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// If the shipment is not completed, this penalty is added to the overall
	// cost of the routes. A shipment is considered completed if one of its pickup
	// and delivery alternatives is visited. The cost may be expressed in the
	// same unit used for all other cost-related fields in the model and must be
	// positive.
	//
	// *IMPORTANT*: If this penalty is not specified, it is considered infinite,
	// i.e. the shipment must be completed.
	PenaltyCost *float64 `protobuf:"fixed64,4,opt,name=penalty_cost,json=penaltyCost,proto3,oneof" json:"penalty_cost,omitempty"`
	// The set of vehicles that may perform this shipment. If empty, all vehicles
	// may perform it. Vehicles are given by their index in the `ShipmentModel`'s
	// `vehicles` list.
	AllowedVehicleIndices []int32 `protobuf:"varint,5,rep,packed,name=allowed_vehicle_indices,json=allowedVehicleIndices,proto3" json:"allowed_vehicle_indices,omitempty"`
	// Specifies the cost that is incurred when this shipment is delivered by each
	// vehicle. If specified, it must have EITHER:
	//
	//   * the same number of elements as `costs_per_vehicle_indices`.
	//     `costs_per_vehicle[i]` corresponds to vehicle
	//     `costs_per_vehicle_indices[i]` of the model.
	//   * the same number of elements as there are vehicles in the model. The
	//     i-th element corresponds to vehicle #i of the model.
	//
	// These costs must be in the same unit as `penalty_cost` and must not be
	// negative. Leave this field empty, if there are no such costs.
	CostsPerVehicle []float64 `protobuf:"fixed64,6,rep,packed,name=costs_per_vehicle,json=costsPerVehicle,proto3" json:"costs_per_vehicle,omitempty"`
	// Indices of the vehicles to which `costs_per_vehicle` applies. If non-empty,
	// it must have the same number of elements as `costs_per_vehicle`. A vehicle
	// index may not be specified more than once. If a vehicle is excluded from
	// `costs_per_vehicle_indices`, its cost is zero.
	CostsPerVehicleIndices []int32 `protobuf:"varint,7,rep,packed,name=costs_per_vehicle_indices,json=costsPerVehicleIndices,proto3" json:"costs_per_vehicle_indices,omitempty"`
	// Specifies the maximum relative detour time compared to the shortest path
	// from pickup to delivery. If specified, it must be nonnegative, and the
	// shipment must contain at least a pickup and a delivery.
	//
	// For example, let t be the shortest time taken to go from the selected
	// pickup alternative directly to the selected delivery alternative. Then
	// setting `pickup_to_delivery_relative_detour_limit` enforces:
	//
	// ```
	// start_time(delivery) - start_time(pickup) <=
	// std::ceil(t * (1.0 + pickup_to_delivery_relative_detour_limit))
	// ```
	//
	// If both relative and absolute limits are specified on the same shipment,
	// the more constraining limit is used for each possible pickup/delivery pair.
	// As of 2017/10, detours are only supported when travel durations do not
	// depend on vehicles.
	PickupToDeliveryRelativeDetourLimit *float64 `protobuf:"fixed64,8,opt,name=pickup_to_delivery_relative_detour_limit,json=pickupToDeliveryRelativeDetourLimit,proto3,oneof" json:"pickup_to_delivery_relative_detour_limit,omitempty"`
	// Specifies the maximum absolute detour time compared to the shortest path
	// from pickup to delivery. If specified, it must be nonnegative, and the
	// shipment must contain at least a pickup and a delivery.
	//
	// For example, let t be the shortest time taken to go from the selected
	// pickup alternative directly to the selected delivery alternative. Then
	// setting `pickup_to_delivery_absolute_detour_limit` enforces:
	//
	// ```
	// start_time(delivery) - start_time(pickup) <=
	// t + pickup_to_delivery_absolute_detour_limit
	// ```
	//
	// If both relative and absolute limits are specified on the same shipment,
	// the more constraining limit is used for each possible pickup/delivery pair.
	// As of 2017/10, detours are only supported when travel durations do not
	// depend on vehicles.
	PickupToDeliveryAbsoluteDetourLimit *durationpb.Duration `protobuf:"bytes,9,opt,name=pickup_to_delivery_absolute_detour_limit,json=pickupToDeliveryAbsoluteDetourLimit,proto3" json:"pickup_to_delivery_absolute_detour_limit,omitempty"`
	// Specifies the maximum duration from start of pickup to start of delivery of
	// a shipment. If specified, it must be nonnegative, and the shipment must
	// contain at least a pickup and a delivery. This does not depend on which
	// alternatives are selected for pickup and delivery, nor on vehicle speed.
	// This can be specified alongside maximum detour constraints: the solution
	// will respect both specifications.
	PickupToDeliveryTimeLimit *durationpb.Duration `protobuf:"bytes,10,opt,name=pickup_to_delivery_time_limit,json=pickupToDeliveryTimeLimit,proto3" json:"pickup_to_delivery_time_limit,omitempty"`
	// Non-empty string specifying a "type" for this shipment.
	// This feature can be used to define incompatibilities or requirements
	// between `shipment_types` (see `shipment_type_incompatibilities` and
	// `shipment_type_requirements` in `ShipmentModel`).
	//
	// Differs from `visit_types` which is specified for a single visit: All
	// pickup/deliveries belonging to the same shipment share the same
	// `shipment_type`.
	ShipmentType string `protobuf:"bytes,11,opt,name=shipment_type,json=shipmentType,proto3" json:"shipment_type,omitempty"`
	// Specifies a label for this shipment. This label is reported in the response
	// in the `shipment_label` of the corresponding
	// [ShipmentRoute.Visit][google.cloud.optimization.v1.ShipmentRoute.Visit].
	Label string `protobuf:"bytes,12,opt,name=label,proto3" json:"label,omitempty"`
	// If true, skip this shipment, but don't apply a `penalty_cost`.
	//
	// Ignoring a shipment results in a validation error when there are any
	// `shipment_type_requirements` in the model.
	//
	// Ignoring a shipment that is performed in `injected_first_solution_routes`
	// or `injected_solution_constraint` is permitted; the solver removes the
	// related pickup/delivery visits from the performing route.
	// `precedence_rules` that reference ignored shipments will also be ignored.
	Ignore bool `protobuf:"varint,13,opt,name=ignore,proto3" json:"ignore,omitempty"`
	// Deprecated: Use
	// [Shipment.load_demands][google.cloud.optimization.v1.Shipment.load_demands]
	// instead.
	//
	// Deprecated: Marked as deprecated in google/cloud/optimization/v1/fleet_routing.proto.
	Demands []*CapacityQuantity `protobuf:"bytes,3,rep,name=demands,proto3" json:"demands,omitempty"`
}

func (x *Shipment) Reset() {
	*x = Shipment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Shipment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Shipment) ProtoMessage() {}

func (x *Shipment) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Shipment.ProtoReflect.Descriptor instead.
func (*Shipment) Descriptor() ([]byte, []int) {
	return file_google_cloud_optimization_v1_fleet_routing_proto_rawDescGZIP(), []int{5}
}

func (x *Shipment) GetPickups() []*Shipment_VisitRequest {
	if x != nil {
		return x.Pickups
	}
	return nil
}

func (x *Shipment) GetDeliveries() []*Shipment_VisitRequest {
	if x != nil {
		return x.Deliveries
	}
	return nil
}

func (x *Shipment) GetLoadDemands() map[string]*Shipment_Load {
	if x != nil {
		return x.LoadDemands
	}
	return nil
}

func (x *Shipment) GetPenaltyCost() float64 {
	if x != nil && x.PenaltyCost != nil {
		return *x.PenaltyCost
	}
	return 0
}

func (x *Shipment) GetAllowedVehicleIndices() []int32 {
	if x != nil {
		return x.AllowedVehicleIndices
	}
	return nil
}

func (x *Shipment) GetCostsPerVehicle() []float64 {
	if x != nil {
		return x.CostsPerVehicle
	}
	return nil
}

func (x *Shipment) GetCostsPerVehicleIndices() []int32 {
	if x != nil {
		return x.CostsPerVehicleIndices
	}
	return nil
}

func (x *Shipment) GetPickupToDeliveryRelativeDetourLimit() float64 {
	if x != nil && x.PickupToDeliveryRelativeDetourLimit != nil {
		return *x.PickupToDeliveryRelativeDetourLimit
	}
	return 0
}

func (x *Shipment) GetPickupToDeliveryAbsoluteDetourLimit() *durationpb.Duration {
	if x != nil {
		return x.PickupToDeliveryAbsoluteDetourLimit
	}
	return nil
}

func (x *Shipment) GetPickupToDeliveryTimeLimit() *durationpb.Duration {
	if x != nil {
		return x.PickupToDeliveryTimeLimit
	}
	return nil
}

func (x *Shipment) GetShipmentType() string {
	if x != nil {
		return x.ShipmentType
	}
	return ""
}

func (x *Shipment) GetLabel() string {
	if x != nil {
		return x.Label
	}
	return ""
}

func (x *Shipment) GetIgnore() bool {
	if x != nil {
		return x.Ignore
	}
	return false
}

// Deprecated: Marked as deprecated in google/cloud/optimization/v1/fleet_routing.proto.
func (x *Shipment) GetDemands() []*CapacityQuantity {
	if x != nil {
		return x.Demands
	}
	return nil
}

// Specifies incompatibilties between shipments depending on their
// shipment_type. The appearance of incompatible shipments on the same route is
// restricted based on the incompatibility mode.
type ShipmentTypeIncompatibility struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of incompatible types. Two shipments having different `shipment_types`
	// among those listed are "incompatible".
	Types []string `protobuf:"bytes,1,rep,name=types,proto3" json:"types,omitempty"`
	// Mode applied to the incompatibility.
	IncompatibilityMode ShipmentTypeIncompatibility_IncompatibilityMode `protobuf:"varint,2,opt,name=incompatibility_mode,json=incompatibilityMode,proto3,enum=google.cloud.optimization.v1.ShipmentTypeIncompatibility_IncompatibilityMode" json:"incompatibility_mode,omitempty"`
}

func (x *ShipmentTypeIncompatibility) Reset() {
	*x = ShipmentTypeIncompatibility{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ShipmentTypeIncompatibility) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ShipmentTypeIncompatibility) ProtoMessage() {}

func (x *ShipmentTypeIncompatibility) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ShipmentTypeIncompatibility.ProtoReflect.Descriptor instead.
func (*ShipmentTypeIncompatibility) Descriptor() ([]byte, []int) {
	return file_google_cloud_optimization_v1_fleet_routing_proto_rawDescGZIP(), []int{6}
}

func (x *ShipmentTypeIncompatibility) GetTypes() []string {
	if x != nil {
		return x.Types
	}
	return nil
}

func (x *ShipmentTypeIncompatibility) GetIncompatibilityMode() ShipmentTypeIncompatibility_IncompatibilityMode {
	if x != nil {
		return x.IncompatibilityMode
	}
	return ShipmentTypeIncompatibility_INCOMPATIBILITY_MODE_UNSPECIFIED
}

// Specifies requirements between shipments based on their shipment_type.
// The specifics of the requirement are defined by the requirement mode.
type ShipmentTypeRequirement struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of alternative shipment types required by the
	// `dependent_shipment_types`.
	RequiredShipmentTypeAlternatives []string `protobuf:"bytes,1,rep,name=required_shipment_type_alternatives,json=requiredShipmentTypeAlternatives,proto3" json:"required_shipment_type_alternatives,omitempty"`
	// All shipments with a type in the `dependent_shipment_types` field require
	// at least one shipment of type `required_shipment_type_alternatives` to be
	// visited on the same route.
	//
	// NOTE: Chains of requirements such that a `shipment_type` depends on itself
	// are not allowed.
	DependentShipmentTypes []string `protobuf:"bytes,2,rep,name=dependent_shipment_types,json=dependentShipmentTypes,proto3" json:"dependent_shipment_types,omitempty"`
	// Mode applied to the requirement.
	RequirementMode ShipmentTypeRequirement_RequirementMode `protobuf:"varint,3,opt,name=requirement_mode,json=requirementMode,proto3,enum=google.cloud.optimization.v1.ShipmentTypeRequirement_RequirementMode" json:"requirement_mode,omitempty"`
}

func (x *ShipmentTypeRequirement) Reset() {
	*x = ShipmentTypeRequirement{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ShipmentTypeRequirement) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ShipmentTypeRequirement) ProtoMessage() {}

func (x *ShipmentTypeRequirement) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ShipmentTypeRequirement.ProtoReflect.Descriptor instead.
func (*ShipmentTypeRequirement) Descriptor() ([]byte, []int) {
	return file_google_cloud_optimization_v1_fleet_routing_proto_rawDescGZIP(), []int{7}
}

func (x *ShipmentTypeRequirement) GetRequiredShipmentTypeAlternatives() []string {
	if x != nil {
		return x.RequiredShipmentTypeAlternatives
	}
	return nil
}

func (x *ShipmentTypeRequirement) GetDependentShipmentTypes() []string {
	if x != nil {
		return x.DependentShipmentTypes
	}
	return nil
}

func (x *ShipmentTypeRequirement) GetRequirementMode() ShipmentTypeRequirement_RequirementMode {
	if x != nil {
		return x.RequirementMode
	}
	return ShipmentTypeRequirement_REQUIREMENT_MODE_UNSPECIFIED
}

// Models a vehicle in a shipment problem. Solving a shipment problem will
// build a route starting from `start_location` and ending at `end_location`
// for this vehicle. A route is a sequence of visits (see `ShipmentRoute`).
type Vehicle struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The travel mode which affects the roads usable by the vehicle and its
	// speed. See also `travel_duration_multiple`.
	TravelMode Vehicle_TravelMode `protobuf:"varint,1,opt,name=travel_mode,json=travelMode,proto3,enum=google.cloud.optimization.v1.Vehicle_TravelMode" json:"travel_mode,omitempty"`
	// Geographic location where the vehicle starts before picking up any
	// shipments. If not specified, the vehicle starts at its first pickup.
	// If the shipment model has duration and distance matrices, `start_location`
	// must not be specified.
	StartLocation *latlng.LatLng `protobuf:"bytes,3,opt,name=start_location,json=startLocation,proto3" json:"start_location,omitempty"`
	// Waypoint representing a geographic location where the vehicle starts before
	// picking up any shipments. If neither `start_waypoint` nor `start_location`
	// is specified, the vehicle starts at its first pickup.
	// If the shipment model has duration and distance matrices, `start_waypoint`
	// must not be specified.
	StartWaypoint *Waypoint `protobuf:"bytes,4,opt,name=start_waypoint,json=startWaypoint,proto3" json:"start_waypoint,omitempty"`
	// Geographic location where the vehicle ends after it has completed its last
	// `VisitRequest`. If not specified the vehicle's `ShipmentRoute` ends
	// immediately when it completes its last `VisitRequest`.
	// If the shipment model has duration and distance matrices, `end_location`
	// must not be specified.
	EndLocation *latlng.LatLng `protobuf:"bytes,5,opt,name=end_location,json=endLocation,proto3" json:"end_location,omitempty"`
	// Waypoint representing a geographic location where the vehicle ends after
	// it has completed its last `VisitRequest`. If neither `end_waypoint` nor
	// `end_location` is specified, the vehicle's `ShipmentRoute` ends immediately
	// when it completes its last `VisitRequest`.
	// If the shipment model has duration and distance matrices, `end_waypoint`
	// must not be specified.
	EndWaypoint *Waypoint `protobuf:"bytes,6,opt,name=end_waypoint,json=endWaypoint,proto3" json:"end_waypoint,omitempty"`
	// Specifies tags attached to the start of the vehicle's route.
	//
	// Empty or duplicate strings are not allowed.
	StartTags []string `protobuf:"bytes,7,rep,name=start_tags,json=startTags,proto3" json:"start_tags,omitempty"`
	// Specifies tags attached to the end of the vehicle's route.
	//
	// Empty or duplicate strings are not allowed.
	EndTags []string `protobuf:"bytes,8,rep,name=end_tags,json=endTags,proto3" json:"end_tags,omitempty"`
	// Time windows during which the vehicle may depart its start location.
	// They must be within the global time limits (see
	// [ShipmentModel.global_*][google.cloud.optimization.v1.ShipmentModel.global_start_time]
	// fields). If unspecified, there is no limitation besides those global time
	// limits.
	//
	// Time windows belonging to the same repeated field must be disjoint, i.e. no
	// time window can overlap with or be adjacent to another, and they must be in
	// chronological order.
	//
	// `cost_per_hour_after_soft_end_time` and `soft_end_time` can only be set if
	// there is a single time window.
	StartTimeWindows []*TimeWindow `protobuf:"bytes,9,rep,name=start_time_windows,json=startTimeWindows,proto3" json:"start_time_windows,omitempty"`
	// Time windows during which the vehicle may arrive at its end location.
	// They must be within the global time limits (see
	// [ShipmentModel.global_*][google.cloud.optimization.v1.ShipmentModel.global_start_time]
	// fields). If unspecified, there is no limitation besides those global time
	// limits.
	//
	// Time windows belonging to the same repeated field must be disjoint, i.e. no
	// time window can overlap with or be adjacent to another, and they must be in
	// chronological order.
	//
	// `cost_per_hour_after_soft_end_time` and `soft_end_time` can only be set if
	// there is a single time window.
	EndTimeWindows []*TimeWindow `protobuf:"bytes,10,rep,name=end_time_windows,json=endTimeWindows,proto3" json:"end_time_windows,omitempty"`
	// Specifies a multiplicative factor that can be used to increase or decrease
	// travel times of this vehicle. For example, setting this to 2.0 means
	// that this vehicle is slower and has travel times that are twice what they
	// are for standard vehicles. This multiple does not affect visit durations.
	// It does affect cost if `cost_per_hour` or `cost_per_traveled_hour` are
	// specified. This must be in the range [0.001, 1000.0]. If unset, the vehicle
	// is standard, and this multiple is considered 1.0.
	//
	// WARNING: Travel times will be rounded to the nearest second after this
	// multiple is applied but before performing any numerical operations, thus,
	// a small multiple may result in a loss of precision.
	//
	// See also `extra_visit_duration_for_visit_type` below.
	TravelDurationMultiple *float64 `protobuf:"fixed64,11,opt,name=travel_duration_multiple,json=travelDurationMultiple,proto3,oneof" json:"travel_duration_multiple,omitempty"`
	// Unloading policy enforced on the vehicle.
	UnloadingPolicy Vehicle_UnloadingPolicy `protobuf:"varint,12,opt,name=unloading_policy,json=unloadingPolicy,proto3,enum=google.cloud.optimization.v1.Vehicle_UnloadingPolicy" json:"unloading_policy,omitempty"`
	// Capacities of the vehicle (weight, volume, # of pallets for example).
	// The keys in the map are the identifiers of the type of load, consistent
	// with the keys of the
	// [Shipment.load_demands][google.cloud.optimization.v1.Shipment.load_demands]
	// field. If a given key is absent from this map, the corresponding capacity
	// is considered to be limitless.
	LoadLimits map[string]*Vehicle_LoadLimit `protobuf:"bytes,30,rep,name=load_limits,json=loadLimits,proto3" json:"load_limits,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Vehicle costs: all costs add up and must be in the same unit as
	// [Shipment.penalty_cost][google.cloud.optimization.v1.Shipment.penalty_cost].
	//
	// Cost per hour of the vehicle route. This cost is applied to the total time
	// taken by the route, and includes travel time, waiting time, and visit time.
	// Using `cost_per_hour` instead of just `cost_per_traveled_hour` may result
	// in additional latency.
	CostPerHour float64 `protobuf:"fixed64,16,opt,name=cost_per_hour,json=costPerHour,proto3" json:"cost_per_hour,omitempty"`
	// Cost per traveled hour of the vehicle route. This cost is applied only to
	// travel time taken by the route (i.e., that reported in
	// [ShipmentRoute.transitions][google.cloud.optimization.v1.ShipmentRoute.transitions]),
	// and excludes waiting time and visit time.
	CostPerTraveledHour float64 `protobuf:"fixed64,17,opt,name=cost_per_traveled_hour,json=costPerTraveledHour,proto3" json:"cost_per_traveled_hour,omitempty"`
	// Cost per kilometer of the vehicle route. This cost is applied to the
	// distance reported in the
	// [ShipmentRoute.transitions][google.cloud.optimization.v1.ShipmentRoute.transitions]
	// and does not apply to any distance implicitly traveled from the
	// `arrival_location` to the `departure_location` of a single `VisitRequest`.
	CostPerKilometer float64 `protobuf:"fixed64,18,opt,name=cost_per_kilometer,json=costPerKilometer,proto3" json:"cost_per_kilometer,omitempty"`
	// Fixed cost applied if this vehicle is used to handle a shipment.
	FixedCost float64 `protobuf:"fixed64,19,opt,name=fixed_cost,json=fixedCost,proto3" json:"fixed_cost,omitempty"`
	// This field only applies to vehicles when their route does not serve any
	// shipments. It indicates if the vehicle should be considered as used or not
	// in this case.
	//
	// If true, the vehicle goes from its start to its end location even if it
	// doesn't serve any shipments, and time and distance costs resulting from its
	// start --> end travel are taken into account.
	//
	// Otherwise, it doesn't travel from its start to its end location, and no
	// `break_rule` or delay (from `TransitionAttributes`) are scheduled for this
	// vehicle. In this case, the vehicle's `ShipmentRoute` doesn't contain any
	// information except for the vehicle index and label.
	UsedIfRouteIsEmpty bool `protobuf:"varint,20,opt,name=used_if_route_is_empty,json=usedIfRouteIsEmpty,proto3" json:"used_if_route_is_empty,omitempty"`
	// Limit applied to the total duration of the vehicle's route. In a given
	// `OptimizeToursResponse`, the route duration of a vehicle is the
	// difference between its `vehicle_end_time` and `vehicle_start_time`.
	RouteDurationLimit *Vehicle_DurationLimit `protobuf:"bytes,21,opt,name=route_duration_limit,json=routeDurationLimit,proto3" json:"route_duration_limit,omitempty"`
	// Limit applied to the travel duration of the vehicle's route. In a given
	// `OptimizeToursResponse`, the route travel duration is the sum of all its
	// [transitions.travel_duration][google.cloud.optimization.v1.ShipmentRoute.Transition.travel_duration].
	TravelDurationLimit *Vehicle_DurationLimit `protobuf:"bytes,22,opt,name=travel_duration_limit,json=travelDurationLimit,proto3" json:"travel_duration_limit,omitempty"`
	// Limit applied to the total distance of the vehicle's route. In a given
	// `OptimizeToursResponse`, the route distance is the sum of all its
	// [transitions.travel_distance_meters][google.cloud.optimization.v1.ShipmentRoute.Transition.travel_distance_meters].
	RouteDistanceLimit *DistanceLimit `protobuf:"bytes,23,opt,name=route_distance_limit,json=routeDistanceLimit,proto3" json:"route_distance_limit,omitempty"`
	// Specifies a map from visit_types strings to durations. The duration is time
	// in addition to
	// [VisitRequest.duration][google.cloud.optimization.v1.Shipment.VisitRequest.duration]
	// to be taken at visits with the specified `visit_types`. This extra visit
	// duration adds cost if `cost_per_hour` is specified. Keys (i.e.
	// `visit_types`) cannot be empty strings.
	//
	// If a visit request has multiple types, a duration will be added for each
	// type in the map.
	ExtraVisitDurationForVisitType map[string]*durationpb.Duration `protobuf:"bytes,24,rep,name=extra_visit_duration_for_visit_type,json=extraVisitDurationForVisitType,proto3" json:"extra_visit_duration_for_visit_type,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Describes the break schedule to be enforced on this vehicle.
	// If empty, no breaks will be scheduled for this vehicle.
	BreakRule *BreakRule `protobuf:"bytes,25,opt,name=break_rule,json=breakRule,proto3" json:"break_rule,omitempty"`
	// Specifies a label for this vehicle. This label is reported in the response
	// as the `vehicle_label` of the corresponding
	// [ShipmentRoute][google.cloud.optimization.v1.ShipmentRoute].
	Label string `protobuf:"bytes,27,opt,name=label,proto3" json:"label,omitempty"`
	// If true, `used_if_route_is_empty` must be false, and this vehicle will
	// remain unused.
	//
	// If a shipment is performed by an ignored vehicle in
	// `injected_first_solution_routes`, it is skipped in the first solution but
	// is free to be performed in the response.
	//
	// If a shipment is performed by an ignored vehicle in
	// `injected_solution_constraint` and any related pickup/delivery is
	// constrained to remain on the vehicle (i.e., not relaxed to level
	// `RELAX_ALL_AFTER_THRESHOLD`), it is skipped in the response.
	// If a shipment has a non-empty `allowed_vehicle_indices` field and all of
	// the allowed vehicles are ignored, it is skipped in the response.
	Ignore bool `protobuf:"varint,28,opt,name=ignore,proto3" json:"ignore,omitempty"`
	// Deprecated: No longer used.
	// Indices in the `break_rule` field in the source
	// [ShipmentModel][google.cloud.optimization.v1.ShipmentModel]. They
	// correspond to break rules enforced on the vehicle.
	//
	// As of 2018/03, at most one rule index per vehicle can be specified.
	//
	// Deprecated: Marked as deprecated in google/cloud/optimization/v1/fleet_routing.proto.
	BreakRuleIndices []int32 `protobuf:"varint,29,rep,packed,name=break_rule_indices,json=breakRuleIndices,proto3" json:"break_rule_indices,omitempty"`
	// Deprecated: Use
	// [Vehicle.load_limits][google.cloud.optimization.v1.Vehicle.load_limits]
	// instead.
	//
	// Deprecated: Marked as deprecated in google/cloud/optimization/v1/fleet_routing.proto.
	Capacities []*CapacityQuantity `protobuf:"bytes,13,rep,name=capacities,proto3" json:"capacities,omitempty"`
	// Deprecated: Use
	// [Vehicle.LoadLimit.start_load_interval][google.cloud.optimization.v1.Vehicle.LoadLimit.start_load_interval]
	// instead.
	//
	// Deprecated: Marked as deprecated in google/cloud/optimization/v1/fleet_routing.proto.
	StartLoadIntervals []*CapacityQuantityInterval `protobuf:"bytes,14,rep,name=start_load_intervals,json=startLoadIntervals,proto3" json:"start_load_intervals,omitempty"`
	// Deprecated: Use
	// [Vehicle.LoadLimit.end_load_interval][google.cloud.optimization.v1.Vehicle.LoadLimit.end_load_interval]
	// instead.
	//
	// Deprecated: Marked as deprecated in google/cloud/optimization/v1/fleet_routing.proto.
	EndLoadIntervals []*CapacityQuantityInterval `protobuf:"bytes,15,rep,name=end_load_intervals,json=endLoadIntervals,proto3" json:"end_load_intervals,omitempty"`
}

func (x *Vehicle) Reset() {
	*x = Vehicle{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Vehicle) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Vehicle) ProtoMessage() {}

func (x *Vehicle) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Vehicle.ProtoReflect.Descriptor instead.
func (*Vehicle) Descriptor() ([]byte, []int) {
	return file_google_cloud_optimization_v1_fleet_routing_proto_rawDescGZIP(), []int{8}
}

func (x *Vehicle) GetTravelMode() Vehicle_TravelMode {
	if x != nil {
		return x.TravelMode
	}
	return Vehicle_TRAVEL_MODE_UNSPECIFIED
}

func (x *Vehicle) GetStartLocation() *latlng.LatLng {
	if x != nil {
		return x.StartLocation
	}
	return nil
}

func (x *Vehicle) GetStartWaypoint() *Waypoint {
	if x != nil {
		return x.StartWaypoint
	}
	return nil
}

func (x *Vehicle) GetEndLocation() *latlng.LatLng {
	if x != nil {
		return x.EndLocation
	}
	return nil
}

func (x *Vehicle) GetEndWaypoint() *Waypoint {
	if x != nil {
		return x.EndWaypoint
	}
	return nil
}

func (x *Vehicle) GetStartTags() []string {
	if x != nil {
		return x.StartTags
	}
	return nil
}

func (x *Vehicle) GetEndTags() []string {
	if x != nil {
		return x.EndTags
	}
	return nil
}

func (x *Vehicle) GetStartTimeWindows() []*TimeWindow {
	if x != nil {
		return x.StartTimeWindows
	}
	return nil
}

func (x *Vehicle) GetEndTimeWindows() []*TimeWindow {
	if x != nil {
		return x.EndTimeWindows
	}
	return nil
}

func (x *Vehicle) GetTravelDurationMultiple() float64 {
	if x != nil && x.TravelDurationMultiple != nil {
		return *x.TravelDurationMultiple
	}
	return 0
}

func (x *Vehicle) GetUnloadingPolicy() Vehicle_UnloadingPolicy {
	if x != nil {
		return x.UnloadingPolicy
	}
	return Vehicle_UNLOADING_POLICY_UNSPECIFIED
}

func (x *Vehicle) GetLoadLimits() map[string]*Vehicle_LoadLimit {
	if x != nil {
		return x.LoadLimits
	}
	return nil
}

func (x *Vehicle) GetCostPerHour() float64 {
	if x != nil {
		return x.CostPerHour
	}
	return 0
}

func (x *Vehicle) GetCostPerTraveledHour() float64 {
	if x != nil {
		return x.CostPerTraveledHour
	}
	return 0
}

func (x *Vehicle) GetCostPerKilometer() float64 {
	if x != nil {
		return x.CostPerKilometer
	}
	return 0
}

func (x *Vehicle) GetFixedCost() float64 {
	if x != nil {
		return x.FixedCost
	}
	return 0
}

func (x *Vehicle) GetUsedIfRouteIsEmpty() bool {
	if x != nil {
		return x.UsedIfRouteIsEmpty
	}
	return false
}

func (x *Vehicle) GetRouteDurationLimit() *Vehicle_DurationLimit {
	if x != nil {
		return x.RouteDurationLimit
	}
	return nil
}

func (x *Vehicle) GetTravelDurationLimit() *Vehicle_DurationLimit {
	if x != nil {
		return x.TravelDurationLimit
	}
	return nil
}

func (x *Vehicle) GetRouteDistanceLimit() *DistanceLimit {
	if x != nil {
		return x.RouteDistanceLimit
	}
	return nil
}

func (x *Vehicle) GetExtraVisitDurationForVisitType() map[string]*durationpb.Duration {
	if x != nil {
		return x.ExtraVisitDurationForVisitType
	}
	return nil
}

func (x *Vehicle) GetBreakRule() *BreakRule {
	if x != nil {
		return x.BreakRule
	}
	return nil
}

func (x *Vehicle) GetLabel() string {
	if x != nil {
		return x.Label
	}
	return ""
}

func (x *Vehicle) GetIgnore() bool {
	if x != nil {
		return x.Ignore
	}
	return false
}

// Deprecated: Marked as deprecated in google/cloud/optimization/v1/fleet_routing.proto.
func (x *Vehicle) GetBreakRuleIndices() []int32 {
	if x != nil {
		return x.BreakRuleIndices
	}
	return nil
}

// Deprecated: Marked as deprecated in google/cloud/optimization/v1/fleet_routing.proto.
func (x *Vehicle) GetCapacities() []*CapacityQuantity {
	if x != nil {
		return x.Capacities
	}
	return nil
}

// Deprecated: Marked as deprecated in google/cloud/optimization/v1/fleet_routing.proto.
func (x *Vehicle) GetStartLoadIntervals() []*CapacityQuantityInterval {
	if x != nil {
		return x.StartLoadIntervals
	}
	return nil
}

// Deprecated: Marked as deprecated in google/cloud/optimization/v1/fleet_routing.proto.
func (x *Vehicle) GetEndLoadIntervals() []*CapacityQuantityInterval {
	if x != nil {
		return x.EndLoadIntervals
	}
	return nil
}

// Time windows constrain the time of an event, such as the arrival time at a
// visit, or the start and end time of a vehicle.
//
// Hard time window bounds, `start_time` and `end_time`, enforce the earliest
// and latest time of the event, such that `start_time <= event_time <=
// end_time`. The soft time window lower bound, `soft_start_time`, expresses a
// preference for the event to happen at or after `soft_start_time` by incurring
// a cost proportional to how long before soft_start_time the event occurs. The
// soft time window upper bound, `soft_end_time`, expresses a preference for the
// event to happen at or before `soft_end_time` by incurring a cost proportional
// to how long after `soft_end_time` the event occurs. `start_time`, `end_time`,
// `soft_start_time` and `soft_end_time` should be within the global time limits
// (see
// [ShipmentModel.global_start_time][google.cloud.optimization.v1.ShipmentModel.global_start_time]
// and
// [ShipmentModel.global_end_time][google.cloud.optimization.v1.ShipmentModel.global_end_time])
// and should respect:
// ```
//
//	0 <= `start_time` <= `soft_start_time` <= `end_time` and
//	0 <= `start_time` <= `soft_end_time` <= `end_time`.
//
// ```
type TimeWindow struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The hard time window start time. If unspecified it will be set to
	// `ShipmentModel.global_start_time`.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The hard time window end time. If unspecified it will be set to
	// `ShipmentModel.global_end_time`.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// The soft start time of the time window.
	SoftStartTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=soft_start_time,json=softStartTime,proto3" json:"soft_start_time,omitempty"`
	// The soft end time of the time window.
	SoftEndTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=soft_end_time,json=softEndTime,proto3" json:"soft_end_time,omitempty"`
	// A cost per hour added to other costs in the model if the event occurs
	// before soft_start_time, computed as:
	//
	// ```
	//    max(0, soft_start_time - t.seconds)
	//                           * cost_per_hour_before_soft_start_time / 3600,
	// t being the time of the event.
	// ```
	//
	// This cost must be positive, and the field can only be set if
	// soft_start_time has been set.
	CostPerHourBeforeSoftStartTime *float64 `protobuf:"fixed64,5,opt,name=cost_per_hour_before_soft_start_time,json=costPerHourBeforeSoftStartTime,proto3,oneof" json:"cost_per_hour_before_soft_start_time,omitempty"`
	// A cost per hour added to other costs in the model if the event occurs after
	// `soft_end_time`, computed as:
	//
	// ```
	//    max(0, t.seconds - soft_end_time.seconds)
	//                     * cost_per_hour_after_soft_end_time / 3600,
	// t being the time of the event.
	// ```
	//
	// This cost must be positive, and the field can only be set if
	// `soft_end_time` has been set.
	CostPerHourAfterSoftEndTime *float64 `protobuf:"fixed64,6,opt,name=cost_per_hour_after_soft_end_time,json=costPerHourAfterSoftEndTime,proto3,oneof" json:"cost_per_hour_after_soft_end_time,omitempty"`
}

func (x *TimeWindow) Reset() {
	*x = TimeWindow{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TimeWindow) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TimeWindow) ProtoMessage() {}

func (x *TimeWindow) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TimeWindow.ProtoReflect.Descriptor instead.
func (*TimeWindow) Descriptor() ([]byte, []int) {
	return file_google_cloud_optimization_v1_fleet_routing_proto_rawDescGZIP(), []int{9}
}

func (x *TimeWindow) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *TimeWindow) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *TimeWindow) GetSoftStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.SoftStartTime
	}
	return nil
}

func (x *TimeWindow) GetSoftEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.SoftEndTime
	}
	return nil
}

func (x *TimeWindow) GetCostPerHourBeforeSoftStartTime() float64 {
	if x != nil && x.CostPerHourBeforeSoftStartTime != nil {
		return *x.CostPerHourBeforeSoftStartTime
	}
	return 0
}

func (x *TimeWindow) GetCostPerHourAfterSoftEndTime() float64 {
	if x != nil && x.CostPerHourAfterSoftEndTime != nil {
		return *x.CostPerHourAfterSoftEndTime
	}
	return 0
}

// Deprecated: Use
// [Vehicle.LoadLimit.Interval][google.cloud.optimization.v1.Vehicle.LoadLimit.Interval]
// instead.
//
// Deprecated: Marked as deprecated in google/cloud/optimization/v1/fleet_routing.proto.
type CapacityQuantity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Type  string `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	Value int64  `protobuf:"varint,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *CapacityQuantity) Reset() {
	*x = CapacityQuantity{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CapacityQuantity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CapacityQuantity) ProtoMessage() {}

func (x *CapacityQuantity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CapacityQuantity.ProtoReflect.Descriptor instead.
func (*CapacityQuantity) Descriptor() ([]byte, []int) {
	return file_google_cloud_optimization_v1_fleet_routing_proto_rawDescGZIP(), []int{10}
}

func (x *CapacityQuantity) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *CapacityQuantity) GetValue() int64 {
	if x != nil {
		return x.Value
	}
	return 0
}

// Deprecated: Use
// [Vehicle.LoadLimit.Interval][google.cloud.optimization.v1.Vehicle.LoadLimit.Interval]
// instead.
//
// Deprecated: Marked as deprecated in google/cloud/optimization/v1/fleet_routing.proto.
type CapacityQuantityInterval struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Type     string `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	MinValue *int64 `protobuf:"varint,2,opt,name=min_value,json=minValue,proto3,oneof" json:"min_value,omitempty"`
	MaxValue *int64 `protobuf:"varint,3,opt,name=max_value,json=maxValue,proto3,oneof" json:"max_value,omitempty"`
}

func (x *CapacityQuantityInterval) Reset() {
	*x = CapacityQuantityInterval{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CapacityQuantityInterval) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CapacityQuantityInterval) ProtoMessage() {}

func (x *CapacityQuantityInterval) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CapacityQuantityInterval.ProtoReflect.Descriptor instead.
func (*CapacityQuantityInterval) Descriptor() ([]byte, []int) {
	return file_google_cloud_optimization_v1_fleet_routing_proto_rawDescGZIP(), []int{11}
}

func (x *CapacityQuantityInterval) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *CapacityQuantityInterval) GetMinValue() int64 {
	if x != nil && x.MinValue != nil {
		return *x.MinValue
	}
	return 0
}

func (x *CapacityQuantityInterval) GetMaxValue() int64 {
	if x != nil && x.MaxValue != nil {
		return *x.MaxValue
	}
	return 0
}

// A limit defining a maximum distance which can be traveled. It can be either
// hard or soft.
//
// If a soft limit is defined, both `soft_max_meters` and
// `cost_per_kilometer_above_soft_max` must be defined and be nonnegative.
type DistanceLimit struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A hard limit constraining the distance to be at most max_meters. The limit
	// must be nonnegative.
	MaxMeters *int64 `protobuf:"varint,1,opt,name=max_meters,json=maxMeters,proto3,oneof" json:"max_meters,omitempty"`
	// A soft limit not enforcing a maximum distance limit, but when violated
	// results in a cost which adds up to other costs defined in the model,
	// with the same unit.
	//
	// If defined soft_max_meters must be less than max_meters and must be
	// nonnegative.
	SoftMaxMeters *int64 `protobuf:"varint,2,opt,name=soft_max_meters,json=softMaxMeters,proto3,oneof" json:"soft_max_meters,omitempty"`
	// Cost per kilometer incurred, increasing up to `soft_max_meters`, with
	// formula:
	// ```
	//   min(distance_meters, soft_max_meters) / 1000.0 *
	//   cost_per_kilometer_below_soft_max.
	// ```
	// This cost is not supported in `route_distance_limit`.
	CostPerKilometerBelowSoftMax *float64 `protobuf:"fixed64,4,opt,name=cost_per_kilometer_below_soft_max,json=costPerKilometerBelowSoftMax,proto3,oneof" json:"cost_per_kilometer_below_soft_max,omitempty"`
	// Cost per kilometer incurred if distance is above `soft_max_meters` limit.
	// The additional cost is 0 if the distance is under the limit, otherwise the
	// formula used to compute the cost is the following:
	// ```
	//   (distance_meters - soft_max_meters) / 1000.0 *
	//   cost_per_kilometer_above_soft_max.
	// ```
	// The cost must be nonnegative.
	CostPerKilometerAboveSoftMax *float64 `protobuf:"fixed64,3,opt,name=cost_per_kilometer_above_soft_max,json=costPerKilometerAboveSoftMax,proto3,oneof" json:"cost_per_kilometer_above_soft_max,omitempty"`
}

func (x *DistanceLimit) Reset() {
	*x = DistanceLimit{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DistanceLimit) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DistanceLimit) ProtoMessage() {}

func (x *DistanceLimit) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DistanceLimit.ProtoReflect.Descriptor instead.
func (*DistanceLimit) Descriptor() ([]byte, []int) {
	return file_google_cloud_optimization_v1_fleet_routing_proto_rawDescGZIP(), []int{12}
}

func (x *DistanceLimit) GetMaxMeters() int64 {
	if x != nil && x.MaxMeters != nil {
		return *x.MaxMeters
	}
	return 0
}

func (x *DistanceLimit) GetSoftMaxMeters() int64 {
	if x != nil && x.SoftMaxMeters != nil {
		return *x.SoftMaxMeters
	}
	return 0
}

func (x *DistanceLimit) GetCostPerKilometerBelowSoftMax() float64 {
	if x != nil && x.CostPerKilometerBelowSoftMax != nil {
		return *x.CostPerKilometerBelowSoftMax
	}
	return 0
}

func (x *DistanceLimit) GetCostPerKilometerAboveSoftMax() float64 {
	if x != nil && x.CostPerKilometerAboveSoftMax != nil {
		return *x.CostPerKilometerAboveSoftMax
	}
	return 0
}

// Specifies attributes of transitions between two consecutive visits on a
// route. Several `TransitionAttributes` may apply to the same transition: in
// that case, all extra costs add up and the strictest constraint or limit
// applies (following natural "AND" semantics).
type TransitionAttributes struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Tags defining the set of (src->dst) transitions these attributes apply to.
	//
	// A source visit or vehicle start matches iff its
	// [VisitRequest.tags][google.cloud.optimization.v1.Shipment.VisitRequest.tags]
	// or [Vehicle.start_tags][google.cloud.optimization.v1.Vehicle.start_tags]
	// either contains `src_tag` or does not contain `excluded_src_tag` (depending
	// on which of these two fields is non-empty).
	SrcTag string `protobuf:"bytes,1,opt,name=src_tag,json=srcTag,proto3" json:"src_tag,omitempty"`
	// See `src_tag`. Exactly one of `src_tag` and `excluded_src_tag` must be
	// non-empty.
	ExcludedSrcTag string `protobuf:"bytes,2,opt,name=excluded_src_tag,json=excludedSrcTag,proto3" json:"excluded_src_tag,omitempty"`
	// A destination visit or vehicle end matches iff its
	// [VisitRequest.tags][google.cloud.optimization.v1.Shipment.VisitRequest.tags]
	// or [Vehicle.end_tags][google.cloud.optimization.v1.Vehicle.end_tags] either
	// contains `dst_tag` or does not contain `excluded_dst_tag` (depending on
	// which of these two fields is non-empty).
	DstTag string `protobuf:"bytes,3,opt,name=dst_tag,json=dstTag,proto3" json:"dst_tag,omitempty"`
	// See `dst_tag`. Exactly one of `dst_tag` and `excluded_dst_tag` must be
	// non-empty.
	ExcludedDstTag string `protobuf:"bytes,4,opt,name=excluded_dst_tag,json=excludedDstTag,proto3" json:"excluded_dst_tag,omitempty"`
	// Specifies a cost for performing this transition. This is in the same unit
	// as all other costs in the model and must not be negative. It is applied on
	// top of all other existing costs.
	Cost float64 `protobuf:"fixed64,5,opt,name=cost,proto3" json:"cost,omitempty"`
	// Specifies a cost per kilometer applied to the distance traveled while
	// performing this transition. It adds up to any
	// [Vehicle.cost_per_kilometer][google.cloud.optimization.v1.Vehicle.cost_per_kilometer]
	// specified on vehicles.
	CostPerKilometer float64 `protobuf:"fixed64,6,opt,name=cost_per_kilometer,json=costPerKilometer,proto3" json:"cost_per_kilometer,omitempty"`
	// Specifies a limit on the distance traveled while performing this
	// transition.
	//
	// As of 2021/06, only soft limits are supported.
	DistanceLimit *DistanceLimit `protobuf:"bytes,7,opt,name=distance_limit,json=distanceLimit,proto3" json:"distance_limit,omitempty"`
	// Specifies a delay incurred when performing this transition.
	//
	// This delay always occurs *after* finishing the source visit and *before*
	// starting the destination visit.
	Delay *durationpb.Duration `protobuf:"bytes,8,opt,name=delay,proto3" json:"delay,omitempty"`
}

func (x *TransitionAttributes) Reset() {
	*x = TransitionAttributes{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransitionAttributes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransitionAttributes) ProtoMessage() {}

func (x *TransitionAttributes) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransitionAttributes.ProtoReflect.Descriptor instead.
func (*TransitionAttributes) Descriptor() ([]byte, []int) {
	return file_google_cloud_optimization_v1_fleet_routing_proto_rawDescGZIP(), []int{13}
}

func (x *TransitionAttributes) GetSrcTag() string {
	if x != nil {
		return x.SrcTag
	}
	return ""
}

func (x *TransitionAttributes) GetExcludedSrcTag() string {
	if x != nil {
		return x.ExcludedSrcTag
	}
	return ""
}

func (x *TransitionAttributes) GetDstTag() string {
	if x != nil {
		return x.DstTag
	}
	return ""
}

func (x *TransitionAttributes) GetExcludedDstTag() string {
	if x != nil {
		return x.ExcludedDstTag
	}
	return ""
}

func (x *TransitionAttributes) GetCost() float64 {
	if x != nil {
		return x.Cost
	}
	return 0
}

func (x *TransitionAttributes) GetCostPerKilometer() float64 {
	if x != nil {
		return x.CostPerKilometer
	}
	return 0
}

func (x *TransitionAttributes) GetDistanceLimit() *DistanceLimit {
	if x != nil {
		return x.DistanceLimit
	}
	return nil
}

func (x *TransitionAttributes) GetDelay() *durationpb.Duration {
	if x != nil {
		return x.Delay
	}
	return nil
}

// Encapsulates a waypoint. Waypoints mark arrival and departure locations of
// VisitRequests, and start and end locations of Vehicles.
type Waypoint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Different ways to represent a location.
	//
	// Types that are assignable to LocationType:
	//	*Waypoint_Location
	//	*Waypoint_PlaceId
	LocationType isWaypoint_LocationType `protobuf_oneof:"location_type"`
	// Indicates that the location of this waypoint is meant to have a preference
	// for the vehicle to stop at a particular side of road. When you set this
	// value, the route will pass through the location so that the vehicle can
	// stop at the side of road that the location is biased towards from the
	// center of the road. This option works only for the 'DRIVING' travel mode,
	// and when the 'location_type' is set to 'location'.
	SideOfRoad bool `protobuf:"varint,3,opt,name=side_of_road,json=sideOfRoad,proto3" json:"side_of_road,omitempty"`
}

func (x *Waypoint) Reset() {
	*x = Waypoint{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Waypoint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Waypoint) ProtoMessage() {}

func (x *Waypoint) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Waypoint.ProtoReflect.Descriptor instead.
func (*Waypoint) Descriptor() ([]byte, []int) {
	return file_google_cloud_optimization_v1_fleet_routing_proto_rawDescGZIP(), []int{14}
}

func (m *Waypoint) GetLocationType() isWaypoint_LocationType {
	if m != nil {
		return m.LocationType
	}
	return nil
}

func (x *Waypoint) GetLocation() *Location {
	if x, ok := x.GetLocationType().(*Waypoint_Location); ok {
		return x.Location
	}
	return nil
}

func (x *Waypoint) GetPlaceId() string {
	if x, ok := x.GetLocationType().(*Waypoint_PlaceId); ok {
		return x.PlaceId
	}
	return ""
}

func (x *Waypoint) GetSideOfRoad() bool {
	if x != nil {
		return x.SideOfRoad
	}
	return false
}

type isWaypoint_LocationType interface {
	isWaypoint_LocationType()
}

type Waypoint_Location struct {
	// A point specified using geographic coordinates, including an optional
	// heading.
	Location *Location `protobuf:"bytes,1,opt,name=location,proto3,oneof"`
}

type Waypoint_PlaceId struct {
	// The POI Place ID associated with the waypoint.
	PlaceId string `protobuf:"bytes,2,opt,name=place_id,json=placeId,proto3,oneof"`
}

func (*Waypoint_Location) isWaypoint_LocationType() {}

func (*Waypoint_PlaceId) isWaypoint_LocationType() {}

// Encapsulates a location (a geographic point, and an optional heading).
type Location struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The waypoint's geographic coordinates.
	LatLng *latlng.LatLng `protobuf:"bytes,1,opt,name=lat_lng,json=latLng,proto3" json:"lat_lng,omitempty"`
	// The compass heading associated with the direction of the flow of traffic.
	// This value is used to specify the side of the road to use for pickup and
	// drop-off. Heading values can be from 0 to 360, where 0 specifies a heading
	// of due North, 90 specifies a heading of due East, etc.
	Heading *int32 `protobuf:"varint,2,opt,name=heading,proto3,oneof" json:"heading,omitempty"`
}

func (x *Location) Reset() {
	*x = Location{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Location) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Location) ProtoMessage() {}

func (x *Location) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Location.ProtoReflect.Descriptor instead.
func (*Location) Descriptor() ([]byte, []int) {
	return file_google_cloud_optimization_v1_fleet_routing_proto_rawDescGZIP(), []int{15}
}

func (x *Location) GetLatLng() *latlng.LatLng {
	if x != nil {
		return x.LatLng
	}
	return nil
}

func (x *Location) GetHeading() int32 {
	if x != nil && x.Heading != nil {
		return *x.Heading
	}
	return 0
}

// Rules to generate time breaks for a vehicle (e.g. lunch breaks). A break
// is a contiguous period of time during which the vehicle remains idle at its
// current position and cannot perform any visit. A break may occur:
//
//   - during the travel between two visits (which includes the time right
//     before or right after a visit, but not in the middle of a visit), in
//     which case it extends the corresponding transit time between the visits,
//   - or before the vehicle start (the vehicle may not start in the middle of
//     a break), in which case it does not affect the vehicle start time.
//   - or after the vehicle end (ditto, with the vehicle end time).
type BreakRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Sequence of breaks. See the `BreakRequest` message.
	BreakRequests []*BreakRule_BreakRequest `protobuf:"bytes,1,rep,name=break_requests,json=breakRequests,proto3" json:"break_requests,omitempty"`
	// Several `FrequencyConstraint` may apply. They must all be satisfied by
	// the `BreakRequest`s of this `BreakRule`. See `FrequencyConstraint`.
	FrequencyConstraints []*BreakRule_FrequencyConstraint `protobuf:"bytes,2,rep,name=frequency_constraints,json=frequencyConstraints,proto3" json:"frequency_constraints,omitempty"`
}

func (x *BreakRule) Reset() {
	*x = BreakRule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BreakRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BreakRule) ProtoMessage() {}

func (x *BreakRule) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BreakRule.ProtoReflect.Descriptor instead.
func (*BreakRule) Descriptor() ([]byte, []int) {
	return file_google_cloud_optimization_v1_fleet_routing_proto_rawDescGZIP(), []int{16}
}

func (x *BreakRule) GetBreakRequests() []*BreakRule_BreakRequest {
	if x != nil {
		return x.BreakRequests
	}
	return nil
}

func (x *BreakRule) GetFrequencyConstraints() []*BreakRule_FrequencyConstraint {
	if x != nil {
		return x.FrequencyConstraints
	}
	return nil
}

// A vehicle's route can be decomposed, along the time axis, like this (we
// assume there are n visits):
// ```
//
//	|            |            |          |       |  T[2], |        |      |
//	| Transition |  Visit #0  |          |       |  V[2], |        |      |
//	|     #0     |    aka     |   T[1]   |  V[1] |  ...   | V[n-1] | T[n] |
//	|  aka T[0]  |    V[0]    |          |       | V[n-2],|        |      |
//	|            |            |          |       | T[n-1] |        |      |
//	^            ^            ^          ^       ^        ^        ^      ^
//
// vehicle    V[0].start   V[0].end     V[1].   V[1].    V[n].    V[n]. vehicle
//
//	start     (arrival)   (departure)   start   end      start    end     end
//
// ```
// Note that we make a difference between:
//
//   - "punctual events", such as the vehicle start and end and each visit's start
//     and end (aka arrival and departure). They happen at a given second.
//   - "time intervals", such as the visits themselves, and the transition between
//     visits. Though time intervals can sometimes have zero duration, i.e. start
//     and end at the same second, they often have a positive duration.
//
// Invariants:
//
//   - If there are n visits, there are n+1 transitions.
//   - A visit is always surrounded by a transition before it (same index) and a
//     transition after it (index + 1).
//   - The vehicle start is always followed by transition #0.
//   - The vehicle end is always preceded by transition #n.
//
// Zooming in, here is what happens during a `Transition` and a `Visit`:
// ```
// ---+-------------------------------------+-----------------------------+-->
//
//	|           TRANSITION[i]             |           VISIT[i]          |
//	|                                     |                             |
//	|  * TRAVEL: the vehicle moves from   |      PERFORM the visit:     |
//	|    VISIT[i-1].departure_location to |                             |
//	|    VISIT[i].arrival_location, which |  * Spend some time:         |
//	|    takes a given travel duration    |    the "visit duration".    |
//	|    and distance                     |                             |
//	|                                     |  * Load or unload           |
//	|  * BREAKS: the driver may have      |    some quantities from the |
//	|    breaks (e.g. lunch break).       |    vehicle: the "demand".   |
//	|                                     |                             |
//	|  * WAIT: the driver/vehicle does    |                             |
//	|    nothing. This can happen for     |                             |
//	|    many reasons, for example when   |                             |
//	|    the vehicle reaches the next     |                             |
//	|    event's destination before the   |                             |
//	|    start of its time window         |                             |
//	|                                     |                             |
//	|  * DELAY: *right before* the next   |                             |
//	|    arrival. E.g. the vehicle and/or |                             |
//	|    driver spends time unloading.    |                             |
//	|                                     |                             |
//
// ---+-------------------------------------+-----------------------------+-->
//
//	^                                     ^                             ^
//
// V[i-1].end                           V[i].start                    V[i].end
// ```
// Lastly, here is how the TRAVEL, BREAKS, DELAY and WAIT can be arranged
// during a transition.
//
//   - They don't overlap.
//   - The DELAY is unique and *must* be a contiguous period of time right
//     before the next visit (or vehicle end). Thus, it suffice to know the
//     delay duration to know its start and end time.
//   - The BREAKS are contiguous, non-overlapping periods of time. The
//     response specifies the start time and duration of each break.
//   - TRAVEL and WAIT are "preemptable": they can be interrupted several times
//     during this transition. Clients can assume that travel happens "as soon as
//     possible" and that "wait" fills the remaining time.
//
// A (complex) example:
// ```
//
//	TRANSITION[i]
//
// --++-----+-----------------------------------------------------------++-->
//
//	||     |       |           |       |           |         |         ||
//	||  T  |   B   |     T     |       |     B     |         |    D    ||
//	||  r  |   r   |     r     |   W   |     r     |    W    |    e    ||
//	||  a  |   e   |     a     |   a   |     e     |    a    |    l    ||
//	||  v  |   a   |     v     |   i   |     a     |    i    |    a    ||
//	||  e  |   k   |     e     |   t   |     k     |    t    |    y    ||
//	||  l  |       |     l     |       |           |         |         ||
//	||     |       |           |       |           |         |         ||
//
// --++-----------------------------------------------------------------++-->
// ```
type ShipmentRoute struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Vehicle performing the route, identified by its index in the source
	// `ShipmentModel`.
	VehicleIndex int32 `protobuf:"varint,1,opt,name=vehicle_index,json=vehicleIndex,proto3" json:"vehicle_index,omitempty"`
	// Label of the vehicle performing this route, equal to
	// `ShipmentModel.vehicles(vehicle_index).label`, if specified.
	VehicleLabel string `protobuf:"bytes,2,opt,name=vehicle_label,json=vehicleLabel,proto3" json:"vehicle_label,omitempty"`
	// Time at which the vehicle starts its route.
	VehicleStartTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=vehicle_start_time,json=vehicleStartTime,proto3" json:"vehicle_start_time,omitempty"`
	// Time at which the vehicle finishes its route.
	VehicleEndTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=vehicle_end_time,json=vehicleEndTime,proto3" json:"vehicle_end_time,omitempty"`
	// Ordered sequence of visits representing a route.
	// visits[i] is the i-th visit in the route.
	// If this field is empty, the vehicle is considered as unused.
	Visits []*ShipmentRoute_Visit `protobuf:"bytes,7,rep,name=visits,proto3" json:"visits,omitempty"`
	// Ordered list of transitions for the route.
	Transitions []*ShipmentRoute_Transition `protobuf:"bytes,8,rep,name=transitions,proto3" json:"transitions,omitempty"`
	// When
	// [OptimizeToursRequest.consider_road_traffic][google.cloud.optimization.v1.OptimizeToursRequest.consider_road_traffic],
	// is set to true, this field indicates that inconsistencies in route timings
	// are predicted using traffic-based travel duration estimates. There may be
	// insufficient time to complete traffic-adjusted travel, delays, and breaks
	// between visits, before the first visit, or after the last visit, while
	// still satisfying the visit and vehicle time windows. For example,
	//
	// ```
	//   start_time(previous_visit) + duration(previous_visit) +
	//   travel_duration(previous_visit, next_visit) > start_time(next_visit)
	// ```
	//
	// Arrival at next_visit will likely happen later than its current
	// time window due the increased estimate of travel time
	// `travel_duration(previous_visit, next_visit)` due to traffic. Also, a break
	// may be forced to overlap with a visit due to an increase in travel time
	// estimates and visit or break time window restrictions.
	HasTrafficInfeasibilities bool `protobuf:"varint,9,opt,name=has_traffic_infeasibilities,json=hasTrafficInfeasibilities,proto3" json:"has_traffic_infeasibilities,omitempty"`
	// The encoded polyline representation of the route.
	// This field is only populated if
	// [OptimizeToursRequest.populate_polylines][google.cloud.optimization.v1.OptimizeToursRequest.populate_polylines]
	// is set to true.
	RoutePolyline *ShipmentRoute_EncodedPolyline `protobuf:"bytes,10,opt,name=route_polyline,json=routePolyline,proto3" json:"route_polyline,omitempty"`
	// Breaks scheduled for the vehicle performing this route.
	// The `breaks` sequence represents time intervals, each starting at the
	// corresponding `start_time` and lasting `duration` seconds.
	Breaks []*ShipmentRoute_Break `protobuf:"bytes,11,rep,name=breaks,proto3" json:"breaks,omitempty"`
	// Duration, distance and load metrics for this route. The fields of
	// [AggregatedMetrics][google.cloud.optimization.v1.AggregatedMetrics] are
	// summed over all
	// [ShipmentRoute.transitions][google.cloud.optimization.v1.ShipmentRoute.transitions]
	// or
	// [ShipmentRoute.visits][google.cloud.optimization.v1.ShipmentRoute.visits],
	// depending on the context.
	Metrics *AggregatedMetrics `protobuf:"bytes,12,opt,name=metrics,proto3" json:"metrics,omitempty"`
	// Cost of the route, broken down by cost-related request fields.
	// The keys are proto paths, relative to the input OptimizeToursRequest, e.g.
	// "model.shipments.pickups.cost", and the values are the total cost
	// generated by the corresponding cost field, aggregated over the whole route.
	// In other words, costs["model.shipments.pickups.cost"] is the sum of all
	// pickup costs over the route. All costs defined in the model are reported in
	// detail here with the exception of costs related to TransitionAttributes
	// that are only reported in an aggregated way as of 2022/01.
	RouteCosts map[string]float64 `protobuf:"bytes,17,rep,name=route_costs,json=routeCosts,proto3" json:"route_costs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"fixed64,2,opt,name=value,proto3"`
	// Total cost of the route. The sum of all costs in the cost map.
	RouteTotalCost float64 `protobuf:"fixed64,18,opt,name=route_total_cost,json=routeTotalCost,proto3" json:"route_total_cost,omitempty"`
	// Deprecated: Use
	// [Transition.vehicle_loads][google.cloud.optimization.v1.ShipmentRoute.Transition.vehicle_loads]
	// instead. Vehicle loads upon arrival at its end location, for each type
	// specified in
	// [Vehicle.capacities][google.cloud.optimization.v1.Vehicle.capacities],
	// `start_load_intervals`, `end_load_intervals` or demands. Exception: we omit
	// loads for quantity types unconstrained by intervals and that don't have any
	// non-zero demand on the route.
	//
	// Deprecated: Marked as deprecated in google/cloud/optimization/v1/fleet_routing.proto.
	EndLoads []*CapacityQuantity `protobuf:"bytes,13,rep,name=end_loads,json=endLoads,proto3" json:"end_loads,omitempty"`
	// Deprecated: Use
	// [ShipmentRoute.transitions][google.cloud.optimization.v1.ShipmentRoute.transitions]
	// instead. Ordered list of travel steps for the route.
	//
	// Deprecated: Marked as deprecated in google/cloud/optimization/v1/fleet_routing.proto.
	TravelSteps []*ShipmentRoute_TravelStep `protobuf:"bytes,14,rep,name=travel_steps,json=travelSteps,proto3" json:"travel_steps,omitempty"`
	// Deprecated: No longer used.
	// This field will only be populated at the
	// [ShipmentRoute.Visit][google.cloud.optimization.v1.ShipmentRoute.Visit]
	// level.
	//
	// This field is the extra detour time due to the shipments visited on the
	// route.
	//
	// It is equal to `vehicle_end_time` - `vehicle_start_time` - travel duration
	// from the vehicle's start_location to its `end_location`.
	//
	// Deprecated: Marked as deprecated in google/cloud/optimization/v1/fleet_routing.proto.
	VehicleDetour *durationpb.Duration `protobuf:"bytes,15,opt,name=vehicle_detour,json=vehicleDetour,proto3" json:"vehicle_detour,omitempty"`
	// Deprecated: Delay occurring before the vehicle end. See
	// [TransitionAttributes.delay][google.cloud.optimization.v1.TransitionAttributes.delay].
	//
	// Deprecated: Marked as deprecated in google/cloud/optimization/v1/fleet_routing.proto.
	DelayBeforeVehicleEnd *ShipmentRoute_Delay `protobuf:"bytes,16,opt,name=delay_before_vehicle_end,json=delayBeforeVehicleEnd,proto3" json:"delay_before_vehicle_end,omitempty"`
}

func (x *ShipmentRoute) Reset() {
	*x = ShipmentRoute{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ShipmentRoute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ShipmentRoute) ProtoMessage() {}

func (x *ShipmentRoute) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ShipmentRoute.ProtoReflect.Descriptor instead.
func (*ShipmentRoute) Descriptor() ([]byte, []int) {
	return file_google_cloud_optimization_v1_fleet_routing_proto_rawDescGZIP(), []int{17}
}

func (x *ShipmentRoute) GetVehicleIndex() int32 {
	if x != nil {
		return x.VehicleIndex
	}
	return 0
}

func (x *ShipmentRoute) GetVehicleLabel() string {
	if x != nil {
		return x.VehicleLabel
	}
	return ""
}

func (x *ShipmentRoute) GetVehicleStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.VehicleStartTime
	}
	return nil
}

func (x *ShipmentRoute) GetVehicleEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.VehicleEndTime
	}
	return nil
}

func (x *ShipmentRoute) GetVisits() []*ShipmentRoute_Visit {
	if x != nil {
		return x.Visits
	}
	return nil
}

func (x *ShipmentRoute) GetTransitions() []*ShipmentRoute_Transition {
	if x != nil {
		return x.Transitions
	}
	return nil
}

func (x *ShipmentRoute) GetHasTrafficInfeasibilities() bool {
	if x != nil {
		return x.HasTrafficInfeasibilities
	}
	return false
}

func (x *ShipmentRoute) GetRoutePolyline() *ShipmentRoute_EncodedPolyline {
	if x != nil {
		return x.RoutePolyline
	}
	return nil
}

func (x *ShipmentRoute) GetBreaks() []*ShipmentRoute_Break {
	if x != nil {
		return x.Breaks
	}
	return nil
}

func (x *ShipmentRoute) GetMetrics() *AggregatedMetrics {
	if x != nil {
		return x.Metrics
	}
	return nil
}

func (x *ShipmentRoute) GetRouteCosts() map[string]float64 {
	if x != nil {
		return x.RouteCosts
	}
	return nil
}

func (x *ShipmentRoute) GetRouteTotalCost() float64 {
	if x != nil {
		return x.RouteTotalCost
	}
	return 0
}

// Deprecated: Marked as deprecated in google/cloud/optimization/v1/fleet_routing.proto.
func (x *ShipmentRoute) GetEndLoads() []*CapacityQuantity {
	if x != nil {
		return x.EndLoads
	}
	return nil
}

// Deprecated: Marked as deprecated in google/cloud/optimization/v1/fleet_routing.proto.
func (x *ShipmentRoute) GetTravelSteps() []*ShipmentRoute_TravelStep {
	if x != nil {
		return x.TravelSteps
	}
	return nil
}

// Deprecated: Marked as deprecated in google/cloud/optimization/v1/fleet_routing.proto.
func (x *ShipmentRoute) GetVehicleDetour() *durationpb.Duration {
	if x != nil {
		return x.VehicleDetour
	}
	return nil
}

// Deprecated: Marked as deprecated in google/cloud/optimization/v1/fleet_routing.proto.
func (x *ShipmentRoute) GetDelayBeforeVehicleEnd() *ShipmentRoute_Delay {
	if x != nil {
		return x.DelayBeforeVehicleEnd
	}
	return nil
}

// Specifies details of unperformed shipments in a solution. For trivial cases
// and/or if we are able to identify the cause for skipping, we report the
// reason here.
type SkippedShipment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The index corresponds to the index of the shipment in the source
	// `ShipmentModel`.
	Index int32 `protobuf:"varint,1,opt,name=index,proto3" json:"index,omitempty"`
	// Copy of the corresponding
	// [Shipment.label][google.cloud.optimization.v1.Shipment.label], if specified
	// in the `Shipment`.
	Label string `protobuf:"bytes,2,opt,name=label,proto3" json:"label,omitempty"`
	// A list of reasons that explain why the shipment was skipped. See comment
	// above `Reason`.
	Reasons []*SkippedShipment_Reason `protobuf:"bytes,3,rep,name=reasons,proto3" json:"reasons,omitempty"`
}

func (x *SkippedShipment) Reset() {
	*x = SkippedShipment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SkippedShipment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SkippedShipment) ProtoMessage() {}

func (x *SkippedShipment) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SkippedShipment.ProtoReflect.Descriptor instead.
func (*SkippedShipment) Descriptor() ([]byte, []int) {
	return file_google_cloud_optimization_v1_fleet_routing_proto_rawDescGZIP(), []int{18}
}

func (x *SkippedShipment) GetIndex() int32 {
	if x != nil {
		return x.Index
	}
	return 0
}

func (x *SkippedShipment) GetLabel() string {
	if x != nil {
		return x.Label
	}
	return ""
}

func (x *SkippedShipment) GetReasons() []*SkippedShipment_Reason {
	if x != nil {
		return x.Reasons
	}
	return nil
}

// Aggregated metrics for
// [ShipmentRoute][google.cloud.optimization.v1.ShipmentRoute] (resp. for
// [OptimizeToursResponse][google.cloud.optimization.v1.OptimizeToursResponse]
// over all [Transition][google.cloud.optimization.v1.ShipmentRoute.Transition]
// and/or [Visit][google.cloud.optimization.v1.ShipmentRoute.Visit] (resp. over
// all [ShipmentRoute][google.cloud.optimization.v1.ShipmentRoute]) elements.
type AggregatedMetrics struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Number of shipments performed. Note that a pickup and delivery pair only
	// counts once.
	PerformedShipmentCount int32 `protobuf:"varint,1,opt,name=performed_shipment_count,json=performedShipmentCount,proto3" json:"performed_shipment_count,omitempty"`
	// Total travel duration for a route or a solution.
	TravelDuration *durationpb.Duration `protobuf:"bytes,2,opt,name=travel_duration,json=travelDuration,proto3" json:"travel_duration,omitempty"`
	// Total wait duration for a route or a solution.
	WaitDuration *durationpb.Duration `protobuf:"bytes,3,opt,name=wait_duration,json=waitDuration,proto3" json:"wait_duration,omitempty"`
	// Total delay duration for a route or a solution.
	DelayDuration *durationpb.Duration `protobuf:"bytes,4,opt,name=delay_duration,json=delayDuration,proto3" json:"delay_duration,omitempty"`
	// Total break duration for a route or a solution.
	BreakDuration *durationpb.Duration `protobuf:"bytes,5,opt,name=break_duration,json=breakDuration,proto3" json:"break_duration,omitempty"`
	// Total visit duration for a route or a solution.
	VisitDuration *durationpb.Duration `protobuf:"bytes,6,opt,name=visit_duration,json=visitDuration,proto3" json:"visit_duration,omitempty"`
	// The total duration should be equal to the sum of all durations above.
	// For routes, it also corresponds to:
	// [ShipmentRoute.vehicle_end_time][google.cloud.optimization.v1.ShipmentRoute.vehicle_end_time]
	// `-`
	// [ShipmentRoute.vehicle_start_time][google.cloud.optimization.v1.ShipmentRoute.vehicle_start_time]
	TotalDuration *durationpb.Duration `protobuf:"bytes,7,opt,name=total_duration,json=totalDuration,proto3" json:"total_duration,omitempty"`
	// Total travel distance for a route or a solution.
	TravelDistanceMeters float64 `protobuf:"fixed64,8,opt,name=travel_distance_meters,json=travelDistanceMeters,proto3" json:"travel_distance_meters,omitempty"`
	// Maximum load achieved over the entire route (resp. solution), for each of
	// the quantities on this route (resp. solution), computed as the maximum over
	// all
	// [Transition.vehicle_loads][google.cloud.optimization.v1.ShipmentRoute.Transition.vehicle_loads]
	// (resp.
	// [ShipmentRoute.metrics.max_loads][google.cloud.optimization.v1.AggregatedMetrics.max_loads].
	MaxLoads map[string]*ShipmentRoute_VehicleLoad `protobuf:"bytes,9,rep,name=max_loads,json=maxLoads,proto3" json:"max_loads,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Deprecated: Use
	// [ShipmentRoute.route_costs][google.cloud.optimization.v1.ShipmentRoute.route_costs]
	// and
	// [OptimizeToursResponse.Metrics.costs][google.cloud.optimization.v1.OptimizeToursResponse.Metrics.costs]
	// instead.
	//
	// Deprecated: Marked as deprecated in google/cloud/optimization/v1/fleet_routing.proto.
	Costs map[string]float64 `protobuf:"bytes,10,rep,name=costs,proto3" json:"costs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"fixed64,2,opt,name=value,proto3"`
	// Deprecated: Use
	// [ShipmentRoute.route_total_cost][google.cloud.optimization.v1.ShipmentRoute.route_total_cost]
	// and
	// [OptimizeToursResponse.Metrics.total_cost][google.cloud.optimization.v1.OptimizeToursResponse.Metrics.total_cost]
	// instead.
	//
	// Deprecated: Marked as deprecated in google/cloud/optimization/v1/fleet_routing.proto.
	TotalCost float64 `protobuf:"fixed64,11,opt,name=total_cost,json=totalCost,proto3" json:"total_cost,omitempty"`
}

func (x *AggregatedMetrics) Reset() {
	*x = AggregatedMetrics{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AggregatedMetrics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AggregatedMetrics) ProtoMessage() {}

func (x *AggregatedMetrics) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AggregatedMetrics.ProtoReflect.Descriptor instead.
func (*AggregatedMetrics) Descriptor() ([]byte, []int) {
	return file_google_cloud_optimization_v1_fleet_routing_proto_rawDescGZIP(), []int{19}
}

func (x *AggregatedMetrics) GetPerformedShipmentCount() int32 {
	if x != nil {
		return x.PerformedShipmentCount
	}
	return 0
}

func (x *AggregatedMetrics) GetTravelDuration() *durationpb.Duration {
	if x != nil {
		return x.TravelDuration
	}
	return nil
}

func (x *AggregatedMetrics) GetWaitDuration() *durationpb.Duration {
	if x != nil {
		return x.WaitDuration
	}
	return nil
}

func (x *AggregatedMetrics) GetDelayDuration() *durationpb.Duration {
	if x != nil {
		return x.DelayDuration
	}
	return nil
}

func (x *AggregatedMetrics) GetBreakDuration() *durationpb.Duration {
	if x != nil {
		return x.BreakDuration
	}
	return nil
}

func (x *AggregatedMetrics) GetVisitDuration() *durationpb.Duration {
	if x != nil {
		return x.VisitDuration
	}
	return nil
}

func (x *AggregatedMetrics) GetTotalDuration() *durationpb.Duration {
	if x != nil {
		return x.TotalDuration
	}
	return nil
}

func (x *AggregatedMetrics) GetTravelDistanceMeters() float64 {
	if x != nil {
		return x.TravelDistanceMeters
	}
	return 0
}

func (x *AggregatedMetrics) GetMaxLoads() map[string]*ShipmentRoute_VehicleLoad {
	if x != nil {
		return x.MaxLoads
	}
	return nil
}

// Deprecated: Marked as deprecated in google/cloud/optimization/v1/fleet_routing.proto.
func (x *AggregatedMetrics) GetCosts() map[string]float64 {
	if x != nil {
		return x.Costs
	}
	return nil
}

// Deprecated: Marked as deprecated in google/cloud/optimization/v1/fleet_routing.proto.
func (x *AggregatedMetrics) GetTotalCost() float64 {
	if x != nil {
		return x.TotalCost
	}
	return 0
}

// Solution injected in the request including information about which visits
// must be constrained and how they must be constrained.
type InjectedSolutionConstraint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Routes of the solution to inject. Some routes may be omitted from the
	// original solution. The routes and skipped shipments must satisfy the basic
	// validity assumptions listed for `injected_first_solution_routes`.
	Routes []*ShipmentRoute `protobuf:"bytes,1,rep,name=routes,proto3" json:"routes,omitempty"`
	// Skipped shipments of the solution to inject. Some may be omitted from the
	// original solution. See the `routes` field.
	SkippedShipments []*SkippedShipment `protobuf:"bytes,2,rep,name=skipped_shipments,json=skippedShipments,proto3" json:"skipped_shipments,omitempty"`
	// For zero or more groups of vehicles, specifies when and how much to relax
	// constraints. If this field is empty, all non-empty vehicle routes are
	// fully constrained.
	ConstraintRelaxations []*InjectedSolutionConstraint_ConstraintRelaxation `protobuf:"bytes,3,rep,name=constraint_relaxations,json=constraintRelaxations,proto3" json:"constraint_relaxations,omitempty"`
}

func (x *InjectedSolutionConstraint) Reset() {
	*x = InjectedSolutionConstraint{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InjectedSolutionConstraint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InjectedSolutionConstraint) ProtoMessage() {}

func (x *InjectedSolutionConstraint) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InjectedSolutionConstraint.ProtoReflect.Descriptor instead.
func (*InjectedSolutionConstraint) Descriptor() ([]byte, []int) {
	return file_google_cloud_optimization_v1_fleet_routing_proto_rawDescGZIP(), []int{20}
}

func (x *InjectedSolutionConstraint) GetRoutes() []*ShipmentRoute {
	if x != nil {
		return x.Routes
	}
	return nil
}

func (x *InjectedSolutionConstraint) GetSkippedShipments() []*SkippedShipment {
	if x != nil {
		return x.SkippedShipments
	}
	return nil
}

func (x *InjectedSolutionConstraint) GetConstraintRelaxations() []*InjectedSolutionConstraint_ConstraintRelaxation {
	if x != nil {
		return x.ConstraintRelaxations
	}
	return nil
}

// Describes an error encountered when validating an `OptimizeToursRequest`.
type OptimizeToursValidationError struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A validation error is defined by the pair (`code`, `display_name`) which
	// are always present.
	//
	// Other fields (below) provide more context about the error.
	//
	// *MULTIPLE ERRORS*:
	// When there are multiple errors, the validation process tries to output
	// several of them. Much like a compiler, this is an imperfect process. Some
	// validation errors will be "fatal", meaning that they stop the entire
	// validation process. This is the case for `display_name="UNSPECIFIED"`
	// errors, among others. Some may cause the validation process to skip other
	// errors.
	//
	// *STABILITY*:
	// `code` and `display_name` should be very stable. But new codes and
	// display names may appear over time, which may cause a given (invalid)
	// request to yield a different (`code`, `display_name`) pair because the new
	// error hid the old one (see "MULTIPLE ERRORS").
	//
	// *REFERENCE*: A list of all (code, name) pairs:
	//
	// * UNSPECIFIED = 0;
	// * VALIDATION_TIMEOUT_ERROR = 10; Validation couldn't be completed within
	// the deadline.
	//
	// * REQUEST_OPTIONS_ERROR = 12;
	//     * REQUEST_OPTIONS_INVALID_SOLVING_MODE = 1201;
	//     * REQUEST_OPTIONS_INVALID_MAX_VALIDATION_ERRORS = 1203;
	//     * REQUEST_OPTIONS_INVALID_GEODESIC_METERS_PER_SECOND = 1204;
	//     * REQUEST_OPTIONS_GEODESIC_METERS_PER_SECOND_TOO_SMALL = 1205;
	//     * REQUEST_OPTIONS_MISSING_GEODESIC_METERS_PER_SECOND = 1206;
	//     * REQUEST_OPTIONS_POPULATE_PATHFINDER_TRIPS_AND_GEODESIC_DISTANCE
	//       = 1207;
	//     * REQUEST_OPTIONS_COST_MODEL_OPTIONS_AND_GEODESIC_DISTANCE = 1208;
	//     * REQUEST_OPTIONS_TRAVEL_MODE_INCOMPATIBLE_WITH_TRAFFIC = 1211;
	//     * REQUEST_OPTIONS_MULTIPLE_TRAFFIC_FLAVORS = 1212;
	//     * REQUEST_OPTIONS_INVALID_TRAFFIC_FLAVOR = 1213;
	//     * REQUEST_OPTIONS_TRAFFIC_ENABLED_WITHOUT_GLOBAL_START_TIME = 1214;
	//     * REQUEST_OPTIONS_TRAFFIC_ENABLED_WITH_PRECEDENCES = 1215;
	//     * REQUEST_OPTIONS_TRAFFIC_PREFILL_MODE_INVALID = 1216;
	//     * REQUEST_OPTIONS_TRAFFIC_PREFILL_ENABLED_WITHOUT_TRAFFIC = 1217;
	// * INJECTED_SOLUTION_ERROR = 20;
	//     * INJECTED_SOLUTION_MISSING_LABEL = 2000;
	//     * INJECTED_SOLUTION_DUPLICATE_LABEL = 2001;
	//     * INJECTED_SOLUTION_AMBIGUOUS_INDEX = 2002;
	//     * INJECTED_SOLUTION_INFEASIBLE_AFTER_GETTING_TRAVEL_TIMES = 2003;
	//     * INJECTED_SOLUTION_TRANSITION_INCONSISTENT_WITH_ACTUAL_TRAVEL = 2004;
	//     * INJECTED_SOLUTION_CONCURRENT_SOLUTION_TYPES = 2005;
	//     * INJECTED_SOLUTION_MORE_THAN_ONE_PER_TYPE = 2006;
	//     * INJECTED_SOLUTION_REFRESH_WITHOUT_POPULATE = 2008;
	//     * INJECTED_SOLUTION_CONSTRAINED_ROUTE_PORTION_INFEASIBLE = 2010;
	// * SHIPMENT_MODEL_ERROR = 22;
	//     * SHIPMENT_MODEL_TOO_LARGE = 2200;
	//     * SHIPMENT_MODEL_TOO_MANY_CAPACITY_TYPES = 2201;
	//     * SHIPMENT_MODEL_GLOBAL_START_TIME_NEGATIVE_OR_NAN = 2202;
	//     * SHIPMENT_MODEL_GLOBAL_END_TIME_TOO_LARGE_OR_NAN = 2203;
	//     * SHIPMENT_MODEL_GLOBAL_START_TIME_AFTER_GLOBAL_END_TIME = 2204;
	//     * SHIPMENT_MODEL_GLOBAL_DURATION_TOO_LONG = 2205;
	//     * SHIPMENT_MODEL_MAX_ACTIVE_VEHICLES_NOT_POSITIVE = 2206;
	//     * SHIPMENT_MODEL_DURATION_MATRIX_TOO_LARGE = 2207;
	// * INDEX_ERROR = 24;
	// * TAG_ERROR = 26;
	// * TIME_WINDOW_ERROR = 28;
	//     * TIME_WINDOW_INVALID_START_TIME = 2800;
	//     * TIME_WINDOW_INVALID_END_TIME = 2801;
	//     * TIME_WINDOW_INVALID_SOFT_START_TIME = 2802;
	//     * TIME_WINDOW_INVALID_SOFT_END_TIME = 2803;
	//     * TIME_WINDOW_OUTSIDE_GLOBAL_TIME_WINDOW = 2804;
	//     * TIME_WINDOW_START_TIME_AFTER_END_TIME = 2805;
	//     * TIME_WINDOW_INVALID_COST_PER_HOUR_BEFORE_SOFT_START_TIME = 2806;
	//     * TIME_WINDOW_INVALID_COST_PER_HOUR_AFTER_SOFT_END_TIME = 2807;
	//     * TIME_WINDOW_COST_BEFORE_SOFT_START_TIME_WITHOUT_SOFT_START_TIME
	//       = 2808;
	//     * TIME_WINDOW_COST_AFTER_SOFT_END_TIME_WITHOUT_SOFT_END_TIME = 2809;
	//     * TIME_WINDOW_SOFT_START_TIME_WITHOUT_COST_BEFORE_SOFT_START_TIME
	//       = 2810;
	//     * TIME_WINDOW_SOFT_END_TIME_WITHOUT_COST_AFTER_SOFT_END_TIME = 2811;
	//     * TIME_WINDOW_OVERLAPPING_ADJACENT_OR_EARLIER_THAN_PREVIOUS = 2812;
	//     * TIME_WINDOW_START_TIME_AFTER_SOFT_START_TIME = 2813;
	//     * TIME_WINDOW_SOFT_START_TIME_AFTER_END_TIME = 2814;
	//     * TIME_WINDOW_START_TIME_AFTER_SOFT_END_TIME = 2815;
	//     * TIME_WINDOW_SOFT_END_TIME_AFTER_END_TIME = 2816;
	//     * TIME_WINDOW_COST_BEFORE_SOFT_START_TIME_SET_AND_MULTIPLE_WINDOWS
	//       = 2817;
	//     * TIME_WINDOW_COST_AFTER_SOFT_END_TIME_SET_AND_MULTIPLE_WINDOWS = 2818;
	//     * TRANSITION_ATTRIBUTES_ERROR = 30;
	//     * TRANSITION_ATTRIBUTES_INVALID_COST = 3000;
	//     * TRANSITION_ATTRIBUTES_INVALID_COST_PER_KILOMETER = 3001;
	//     * TRANSITION_ATTRIBUTES_DUPLICATE_TAG_PAIR = 3002;
	//     * TRANSITION_ATTRIBUTES_DISTANCE_LIMIT_MAX_METERS_UNSUPPORTED = 3003;
	//     * TRANSITION_ATTRIBUTES_UNSPECIFIED_SOURCE_TAGS = 3004;
	//     * TRANSITION_ATTRIBUTES_CONFLICTING_SOURCE_TAGS_FIELDS = 3005;
	//     * TRANSITION_ATTRIBUTES_UNSPECIFIED_DESTINATION_TAGS = 3006;
	//     * TRANSITION_ATTRIBUTES_CONFLICTING_DESTINATION_TAGS_FIELDS = 3007;
	//     * TRANSITION_ATTRIBUTES_DELAY_DURATION_NEGATIVE_OR_NAN = 3008;
	//     * TRANSITION_ATTRIBUTES_DELAY_DURATION_EXCEEDS_GLOBAL_DURATION = 3009;
	// * AMOUNT_ERROR = 31;
	//     * AMOUNT_NEGATIVE_VALUE = 3100;
	// * LOAD_LIMIT_ERROR = 33;
	//     * LOAD_LIMIT_INVALID_COST_ABOVE_SOFT_MAX = 3303;
	//     * LOAD_LIMIT_SOFT_MAX_WITHOUT_COST_ABOVE_SOFT_MAX = 3304;
	//     * LOAD_LIMIT_COST_ABOVE_SOFT_MAX_WITHOUT_SOFT_MAX = 3305;
	//     * LOAD_LIMIT_NEGATIVE_SOFT_MAX = 3306;
	//     * LOAD_LIMIT_MIXED_DEMAND_TYPE = 3307;
	//     * LOAD_LIMIT_MAX_LOAD_NEGATIVE_VALUE = 3308;
	//     * LOAD_LIMIT_SOFT_MAX_ABOVE_MAX = 3309;
	// * INTERVAL_ERROR = 34;
	//     * INTERVAL_MIN_EXCEEDS_MAX = 3401;
	//     * INTERVAL_NEGATIVE_MIN = 3402;
	//     * INTERVAL_NEGATIVE_MAX = 3403;
	//     * INTERVAL_MIN_EXCEEDS_CAPACITY = 3404;
	//     * INTERVAL_MAX_EXCEEDS_CAPACITY = 3405;
	// * DISTANCE_LIMIT_ERROR = 36;
	//     * DISTANCE_LIMIT_INVALID_COST_AFTER_SOFT_MAX = 3601;
	//     * DISTANCE_LIMIT_SOFT_MAX_WITHOUT_COST_AFTER_SOFT_MAX = 3602;
	//     * DISTANCE_LIMIT_COST_AFTER_SOFT_MAX_WITHOUT_SOFT_MAX = 3603;
	//     * DISTANCE_LIMIT_NEGATIVE_MAX = 3604;
	//     * DISTANCE_LIMIT_NEGATIVE_SOFT_MAX = 3605;
	//     * DISTANCE_LIMIT_SOFT_MAX_LARGER_THAN_MAX = 3606;
	// * DURATION_LIMIT_ERROR = 38;
	//     * DURATION_LIMIT_MAX_DURATION_NEGATIVE_OR_NAN = 3800;
	//     * DURATION_LIMIT_SOFT_MAX_DURATION_NEGATIVE_OR_NAN = 3801;
	//     * DURATION_LIMIT_INVALID_COST_PER_HOUR_AFTER_SOFT_MAX = 3802;
	//     * DURATION_LIMIT_SOFT_MAX_WITHOUT_COST_AFTER_SOFT_MAX = 3803;
	//     * DURATION_LIMIT_COST_AFTER_SOFT_MAX_WITHOUT_SOFT_MAX = 3804;
	//     * DURATION_LIMIT_QUADRATIC_SOFT_MAX_DURATION_NEGATIVE_OR_NAN = 3805;
	//     * DURATION_LIMIT_INVALID_COST_AFTER_QUADRATIC_SOFT_MAX = 3806;
	//     * DURATION_LIMIT_QUADRATIC_SOFT_MAX_WITHOUT_COST_PER_SQUARE_HOUR
	//       = 3807;
	//     * DURATION_LIMIT_COST_PER_SQUARE_HOUR_WITHOUT_QUADRATIC_SOFT_MAX
	//       = 3808;
	//     * DURATION_LIMIT_QUADRATIC_SOFT_MAX_WITHOUT_MAX = 3809;
	//     * DURATION_LIMIT_SOFT_MAX_LARGER_THAN_MAX = 3810;
	//     * DURATION_LIMIT_QUADRATIC_SOFT_MAX_LARGER_THAN_MAX = 3811;
	//     * DURATION_LIMIT_DIFF_BETWEEN_MAX_AND_QUADRATIC_SOFT_MAX_TOO_LARGE
	//       = 3812;
	//     * DURATION_LIMIT_MAX_DURATION_EXCEEDS_GLOBAL_DURATION = 3813;
	//     * DURATION_LIMIT_SOFT_MAX_DURATION_EXCEEDS_GLOBAL_DURATION = 3814;
	//     * DURATION_LIMIT_QUADRATIC_SOFT_MAX_DURATION_EXCEEDS_GLOBAL_DURATION
	//       = 3815;
	// * SHIPMENT_ERROR = 40;
	//     * SHIPMENT_PD_LIMIT_WITHOUT_PICKUP_AND_DELIVERY = 4014;
	//     * SHIPMENT_PD_ABSOLUTE_DETOUR_LIMIT_DURATION_NEGATIVE_OR_NAN = 4000;
	//     * SHIPMENT_PD_ABSOLUTE_DETOUR_LIMIT_DURATION_EXCEEDS_GLOBAL_DURATION
	//       = 4001;
	//     * SHIPMENT_PD_RELATIVE_DETOUR_LIMIT_INVALID = 4015;
	//     * SHIPMENT_PD_DETOUR_LIMIT_AND_EXTRA_VISIT_DURATION = 4016;
	//     * SHIPMENT_PD_TIME_LIMIT_DURATION_NEGATIVE_OR_NAN = 4002;
	//     * SHIPMENT_PD_TIME_LIMIT_DURATION_EXCEEDS_GLOBAL_DURATION = 4003;
	//     * SHIPMENT_EMPTY_SHIPMENT_TYPE = 4004;
	//     * SHIPMENT_NO_PICKUP_NO_DELIVERY = 4005;
	//     * SHIPMENT_INVALID_PENALTY_COST = 4006;
	//     * SHIPMENT_ALLOWED_VEHICLE_INDEX_OUT_OF_BOUNDS = 4007;
	//     * SHIPMENT_DUPLICATE_ALLOWED_VEHICLE_INDEX = 4008;
	//     * SHIPMENT_INCONSISTENT_COST_FOR_VEHICLE_SIZE_WITHOUT_INDEX = 4009;
	//     * SHIPMENT_INCONSISTENT_COST_FOR_VEHICLE_SIZE_WITH_INDEX = 4010;
	//     * SHIPMENT_INVALID_COST_FOR_VEHICLE = 4011;
	//     * SHIPMENT_COST_FOR_VEHICLE_INDEX_OUT_OF_BOUNDS = 4012;
	//     * SHIPMENT_DUPLICATE_COST_FOR_VEHICLE_INDEX = 4013;
	// * VEHICLE_ERROR = 42;
	//     * VEHICLE_EMPTY_REQUIRED_OPERATOR_TYPE = 4200;
	//     * VEHICLE_DUPLICATE_REQUIRED_OPERATOR_TYPE = 4201;
	//     * VEHICLE_NO_OPERATOR_WITH_REQUIRED_OPERATOR_TYPE = 4202;
	//     * VEHICLE_EMPTY_START_TAG = 4203;
	//     * VEHICLE_DUPLICATE_START_TAG = 4204;
	//     * VEHICLE_EMPTY_END_TAG = 4205;
	//     * VEHICLE_DUPLICATE_END_TAG = 4206;
	//     * VEHICLE_EXTRA_VISIT_DURATION_NEGATIVE_OR_NAN = 4207;
	//     * VEHICLE_EXTRA_VISIT_DURATION_EXCEEDS_GLOBAL_DURATION = 4208;
	//     * VEHICLE_EXTRA_VISIT_DURATION_EMPTY_KEY = 4209;
	//     * VEHICLE_FIRST_SHIPMENT_INDEX_OUT_OF_BOUNDS = 4210;
	//     * VEHICLE_FIRST_SHIPMENT_IGNORED = 4211;
	//     * VEHICLE_FIRST_SHIPMENT_NOT_BOUND = 4212;
	//     * VEHICLE_LAST_SHIPMENT_INDEX_OUT_OF_BOUNDS = 4213;
	//     * VEHICLE_LAST_SHIPMENT_IGNORED = 4214;
	//     * VEHICLE_LAST_SHIPMENT_NOT_BOUND = 4215;
	//     * VEHICLE_IGNORED_WITH_USED_IF_ROUTE_IS_EMPTY = 4216;
	//     * VEHICLE_INVALID_COST_PER_KILOMETER = 4217;
	//     * VEHICLE_INVALID_COST_PER_HOUR = 4218;
	//     * VEHICLE_INVALID_COST_PER_TRAVELED_HOUR = 4219;
	//     * VEHICLE_INVALID_FIXED_COST = 4220;
	//     * VEHICLE_INVALID_TRAVEL_DURATION_MULTIPLE = 4221;
	//     * VEHICLE_TRAVEL_DURATION_MULTIPLE_WITH_SHIPMENT_PD_DETOUR_LIMITS
	//       = 4223;
	//     * VEHICLE_MATRIX_INDEX_WITH_SHIPMENT_PD_DETOUR_LIMITS = 4224;
	//     * VEHICLE_MINIMUM_DURATION_LONGER_THAN_DURATION_LIMIT = 4222;
	// * VISIT_REQUEST_ERROR = 44;
	//     * VISIT_REQUEST_EMPTY_TAG = 4400;
	//     * VISIT_REQUEST_DUPLICATE_TAG = 4401;
	//     * VISIT_REQUEST_DURATION_NEGATIVE_OR_NAN = 4404;
	//     * VISIT_REQUEST_DURATION_EXCEEDS_GLOBAL_DURATION = 4405;
	// * PRECEDENCE_ERROR = 46;
	// * BREAK_ERROR = 48;
	//     * BREAK_RULE_EMPTY = 4800;
	//     * BREAK_REQUEST_UNSPECIFIED_DURATION = 4801;
	//     * BREAK_REQUEST_UNSPECIFIED_EARLIEST_START_TIME = 4802;
	//     * BREAK_REQUEST_UNSPECIFIED_LATEST_START_TIME = 4803;
	//     * BREAK_REQUEST_DURATION_NEGATIVE_OR_NAN = 4804; = 4804;
	//     * BREAK_REQUEST_LATEST_START_TIME_BEFORE_EARLIEST_START_TIME = 4805;
	//     * BREAK_REQUEST_EARLIEST_START_TIME_BEFORE_GLOBAL_START_TIME = 4806;
	//     * BREAK_REQUEST_LATEST_END_TIME_AFTER_GLOBAL_END_TIME = 4807;
	//     * BREAK_REQUEST_NON_SCHEDULABLE = 4808;
	//     * BREAK_FREQUENCY_MAX_INTER_BREAK_DURATION_NEGATIVE_OR_NAN = 4809;
	//     * BREAK_FREQUENCY_MIN_BREAK_DURATION_NEGATIVE_OR_NAN = 4810;
	//     * BREAK_FREQUENCY_MIN_BREAK_DURATION_EXCEEDS_GLOBAL_DURATION = 4811;
	//     * BREAK_FREQUENCY_MAX_INTER_BREAK_DURATION_EXCEEDS_GLOBAL_DURATION
	//       = 4812;
	//     * BREAK_REQUEST_DURATION_EXCEEDS_GLOBAL_DURATION = 4813;
	//     * BREAK_FREQUENCY_MISSING_MAX_INTER_BREAK_DURATION = 4814;
	//     * BREAK_FREQUENCY_MISSING_MIN_BREAK_DURATION = 4815;
	// * SHIPMENT_TYPE_INCOMPATIBILITY_ERROR = 50;
	//     * SHIPMENT_TYPE_INCOMPATIBILITY_EMPTY_TYPE = 5001;
	//     * SHIPMENT_TYPE_INCOMPATIBILITY_LESS_THAN_TWO_TYPES = 5002;
	//     * SHIPMENT_TYPE_INCOMPATIBILITY_DUPLICATE_TYPE = 5003;
	//     * SHIPMENT_TYPE_INCOMPATIBILITY_INVALID_INCOMPATIBILITY_MODE = 5004;
	//     * SHIPMENT_TYPE_INCOMPATIBILITY_TOO_MANY_INCOMPATIBILITIES = 5005;
	// * SHIPMENT_TYPE_REQUIREMENT_ERROR = 52;
	//     * SHIPMENT_TYPE_REQUIREMENT_NO_REQUIRED_TYPE = 52001;
	//     * SHIPMENT_TYPE_REQUIREMENT_NO_DEPENDENT_TYPE = 52002;
	//     * SHIPMENT_TYPE_REQUIREMENT_INVALID_REQUIREMENT_MODE = 52003;
	//     * SHIPMENT_TYPE_REQUIREMENT_TOO_MANY_REQUIREMENTS = 52004;
	//     * SHIPMENT_TYPE_REQUIREMENT_EMPTY_REQUIRED_TYPE = 52005;
	//     * SHIPMENT_TYPE_REQUIREMENT_DUPLICATE_REQUIRED_TYPE = 52006;
	//     * SHIPMENT_TYPE_REQUIREMENT_NO_REQUIRED_TYPE_FOUND = 52007;
	//     * SHIPMENT_TYPE_REQUIREMENT_EMPTY_DEPENDENT_TYPE = 52008;
	//     * SHIPMENT_TYPE_REQUIREMENT_DUPLICATE_DEPENDENT_TYPE = 52009;
	//     * SHIPMENT_TYPE_REQUIREMENT_SELF_DEPENDENT_TYPE = 52010;
	//     * SHIPMENT_TYPE_REQUIREMENT_GRAPH_HAS_CYCLES = 52011;
	// * VEHICLE_OPERATOR_ERROR = 54;
	//     * VEHICLE_OPERATOR_EMPTY_TYPE = 5400;
	//     * VEHICLE_OPERATOR_MULTIPLE_START_TIME_WINDOWS = 5401;
	//     * VEHICLE_OPERATOR_SOFT_START_TIME_WINDOW = 5402;
	//     * VEHICLE_OPERATOR_MULTIPLE_END_TIME_WINDOWS = 5403;
	//     * VEHICLE_OPERATOR_SOFT_END_TIME_WINDOW = 5404;
	// * DURATION_SECONDS_MATRIX_ERROR = 56;
	//     * DURATION_SECONDS_MATRIX_DURATION_NEGATIVE_OR_NAN = 5600;
	//     * DURATION_SECONDS_MATRIX_DURATION_EXCEEDS_GLOBAL_DURATION = 5601;
	Code int32 `protobuf:"varint,1,opt,name=code,proto3" json:"code,omitempty"`
	// The error display name.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// An error context may involve 0, 1 (most of the time) or more fields. For
	// example, referring to vehicle #4 and shipment #2's first pickup can be
	// done as follows:
	// ```
	// fields { name: "vehicles" index: 4}
	// fields { name: "shipments" index: 2 sub_field {name: "pickups" index: 0} }
	// ```
	// Note, however, that the cardinality of `fields` should not change for a
	// given error code.
	Fields []*OptimizeToursValidationError_FieldReference `protobuf:"bytes,3,rep,name=fields,proto3" json:"fields,omitempty"`
	// Human-readable string describing the error. There is a 1:1 mapping
	// between `code` and `error_message` (when code != "UNSPECIFIED").
	//
	// *STABILITY*: Not stable: the error message associated to a given `code` may
	// change (hopefully to clarify it) over time. Please rely on the
	// `display_name` and `code` instead.
	ErrorMessage string `protobuf:"bytes,4,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
	// May contain the value(s) of the field(s). This is not always available. You
	// should absolutely not rely on it and use it only for manual model
	// debugging.
	OffendingValues string `protobuf:"bytes,5,opt,name=offending_values,json=offendingValues,proto3" json:"offending_values,omitempty"`
}

func (x *OptimizeToursValidationError) Reset() {
	*x = OptimizeToursValidationError{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OptimizeToursValidationError) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OptimizeToursValidationError) ProtoMessage() {}

func (x *OptimizeToursValidationError) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OptimizeToursValidationError.ProtoReflect.Descriptor instead.
func (*OptimizeToursValidationError) Descriptor() ([]byte, []int) {
	return file_google_cloud_optimization_v1_fleet_routing_proto_rawDescGZIP(), []int{21}
}

func (x *OptimizeToursValidationError) GetCode() int32 {
	if x != nil {
		return x.Code
	}
	return 0
}

func (x *OptimizeToursValidationError) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *OptimizeToursValidationError) GetFields() []*OptimizeToursValidationError_FieldReference {
	if x != nil {
		return x.Fields
	}
	return nil
}

func (x *OptimizeToursValidationError) GetErrorMessage() string {
	if x != nil {
		return x.ErrorMessage
	}
	return ""
}

func (x *OptimizeToursValidationError) GetOffendingValues() string {
	if x != nil {
		return x.OffendingValues
	}
	return ""
}

// Overall metrics, aggregated over all routes.
type OptimizeToursResponse_Metrics struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Aggregated over the routes. Each metric is the sum (or max, for loads)
	// over all
	// [ShipmentRoute.metrics][google.cloud.optimization.v1.ShipmentRoute.metrics]
	// fields of the same name.
	AggregatedRouteMetrics *AggregatedMetrics `protobuf:"bytes,1,opt,name=aggregated_route_metrics,json=aggregatedRouteMetrics,proto3" json:"aggregated_route_metrics,omitempty"`
	// Number of mandatory shipments skipped.
	SkippedMandatoryShipmentCount int32 `protobuf:"varint,2,opt,name=skipped_mandatory_shipment_count,json=skippedMandatoryShipmentCount,proto3" json:"skipped_mandatory_shipment_count,omitempty"`
	// Number of vehicles used. Note: if a vehicle route is empty and
	// [Vehicle.used_if_route_is_empty][google.cloud.optimization.v1.Vehicle.used_if_route_is_empty]
	// is true, the vehicle is considered used.
	UsedVehicleCount int32 `protobuf:"varint,3,opt,name=used_vehicle_count,json=usedVehicleCount,proto3" json:"used_vehicle_count,omitempty"`
	// The earliest start time for a used vehicle, computed as the minimum over
	// all used vehicles of
	// [ShipmentRoute.vehicle_start_time][google.cloud.optimization.v1.ShipmentRoute.vehicle_start_time].
	EarliestVehicleStartTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=earliest_vehicle_start_time,json=earliestVehicleStartTime,proto3" json:"earliest_vehicle_start_time,omitempty"`
	// The latest end time for a used vehicle, computed as the maximum over all
	// used vehicles of
	// [ShipmentRoute.vehicle_end_time][google.cloud.optimization.v1.ShipmentRoute.vehicle_end_time].
	LatestVehicleEndTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=latest_vehicle_end_time,json=latestVehicleEndTime,proto3" json:"latest_vehicle_end_time,omitempty"`
	// Cost of the solution, broken down by cost-related request fields.
	// The keys are proto paths, relative to the input OptimizeToursRequest,
	// e.g. "model.shipments.pickups.cost", and the values are the total cost
	// generated by the corresponding cost field, aggregated over the whole
	// solution. In other words, costs["model.shipments.pickups.cost"] is the
	// sum of all pickup costs over the solution. All costs defined in the model
	// are reported in detail here with the exception of costs related to
	// TransitionAttributes that are only reported in an aggregated way as of
	// 2022/01.
	Costs map[string]float64 `protobuf:"bytes,10,rep,name=costs,proto3" json:"costs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"fixed64,2,opt,name=value,proto3"`
	// Total cost of the solution. The sum of all values in the costs map.
	TotalCost float64 `protobuf:"fixed64,6,opt,name=total_cost,json=totalCost,proto3" json:"total_cost,omitempty"`
}

func (x *OptimizeToursResponse_Metrics) Reset() {
	*x = OptimizeToursResponse_Metrics{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OptimizeToursResponse_Metrics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OptimizeToursResponse_Metrics) ProtoMessage() {}

func (x *OptimizeToursResponse_Metrics) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OptimizeToursResponse_Metrics.ProtoReflect.Descriptor instead.
func (*OptimizeToursResponse_Metrics) Descriptor() ([]byte, []int) {
	return file_google_cloud_optimization_v1_fleet_routing_proto_rawDescGZIP(), []int{1, 0}
}

func (x *OptimizeToursResponse_Metrics) GetAggregatedRouteMetrics() *AggregatedMetrics {
	if x != nil {
		return x.AggregatedRouteMetrics
	}
	return nil
}

func (x *OptimizeToursResponse_Metrics) GetSkippedMandatoryShipmentCount() int32 {
	if x != nil {
		return x.SkippedMandatoryShipmentCount
	}
	return 0
}

func (x *OptimizeToursResponse_Metrics) GetUsedVehicleCount() int32 {
	if x != nil {
		return x.UsedVehicleCount
	}
	return 0
}

func (x *OptimizeToursResponse_Metrics) GetEarliestVehicleStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EarliestVehicleStartTime
	}
	return nil
}

func (x *OptimizeToursResponse_Metrics) GetLatestVehicleEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LatestVehicleEndTime
	}
	return nil
}

func (x *OptimizeToursResponse_Metrics) GetCosts() map[string]float64 {
	if x != nil {
		return x.Costs
	}
	return nil
}

func (x *OptimizeToursResponse_Metrics) GetTotalCost() float64 {
	if x != nil {
		return x.TotalCost
	}
	return 0
}

// Information for solving one optimization model asynchronously.
type BatchOptimizeToursRequest_AsyncModelConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// User defined model name, can be used as alias by users to keep track of
	// models.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Required. Information about the input model.
	InputConfig *InputConfig `protobuf:"bytes,2,opt,name=input_config,json=inputConfig,proto3" json:"input_config,omitempty"`
	// Required. The desired output location information.
	OutputConfig *OutputConfig `protobuf:"bytes,3,opt,name=output_config,json=outputConfig,proto3" json:"output_config,omitempty"`
	// If this is set, the model will be solved in the checkpoint mode. In this
	// mode, the input model can have a deadline longer than 30 mins without the
	// risk of interruption. The model will be solved in multiple short-running
	// stages. Each stage generates an intermediate checkpoint
	// and stores it in the user's Cloud Storage buckets. The checkpoint
	// mode should be preferred over
	// allow_large_deadline_despite_interruption_risk since it prevents the risk
	// of interruption.
	EnableCheckpoints bool `protobuf:"varint,4,opt,name=enable_checkpoints,json=enableCheckpoints,proto3" json:"enable_checkpoints,omitempty"`
}

func (x *BatchOptimizeToursRequest_AsyncModelConfig) Reset() {
	*x = BatchOptimizeToursRequest_AsyncModelConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchOptimizeToursRequest_AsyncModelConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchOptimizeToursRequest_AsyncModelConfig) ProtoMessage() {}

func (x *BatchOptimizeToursRequest_AsyncModelConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchOptimizeToursRequest_AsyncModelConfig.ProtoReflect.Descriptor instead.
func (*BatchOptimizeToursRequest_AsyncModelConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_optimization_v1_fleet_routing_proto_rawDescGZIP(), []int{2, 0}
}

func (x *BatchOptimizeToursRequest_AsyncModelConfig) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *BatchOptimizeToursRequest_AsyncModelConfig) GetInputConfig() *InputConfig {
	if x != nil {
		return x.InputConfig
	}
	return nil
}

func (x *BatchOptimizeToursRequest_AsyncModelConfig) GetOutputConfig() *OutputConfig {
	if x != nil {
		return x.OutputConfig
	}
	return nil
}

func (x *BatchOptimizeToursRequest_AsyncModelConfig) GetEnableCheckpoints() bool {
	if x != nil {
		return x.EnableCheckpoints
	}
	return false
}

// Specifies a duration and distance matrix from visit and vehicle start
// locations to visit and vehicle end locations.
type ShipmentModel_DurationDistanceMatrix struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specifies the rows of the duration and distance matrix. It must have as
	// many elements as
	// [ShipmentModel.duration_distance_matrix_src_tags][google.cloud.optimization.v1.ShipmentModel.duration_distance_matrix_src_tags].
	Rows []*ShipmentModel_DurationDistanceMatrix_Row `protobuf:"bytes,1,rep,name=rows,proto3" json:"rows,omitempty"`
	// Tag defining to which vehicles this duration and distance matrix applies.
	// If empty, this applies to all vehicles, and there can only be a single
	// matrix.
	//
	// Each vehicle start must match exactly one matrix, i.e. exactly one of
	// their `start_tags` field must match the `vehicle_start_tag` of a matrix
	// (and of that matrix only).
	//
	// All matrices must have a different `vehicle_start_tag`.
	VehicleStartTag string `protobuf:"bytes,2,opt,name=vehicle_start_tag,json=vehicleStartTag,proto3" json:"vehicle_start_tag,omitempty"`
}

func (x *ShipmentModel_DurationDistanceMatrix) Reset() {
	*x = ShipmentModel_DurationDistanceMatrix{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ShipmentModel_DurationDistanceMatrix) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ShipmentModel_DurationDistanceMatrix) ProtoMessage() {}

func (x *ShipmentModel_DurationDistanceMatrix) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ShipmentModel_DurationDistanceMatrix.ProtoReflect.Descriptor instead.
func (*ShipmentModel_DurationDistanceMatrix) Descriptor() ([]byte, []int) {
	return file_google_cloud_optimization_v1_fleet_routing_proto_rawDescGZIP(), []int{4, 0}
}

func (x *ShipmentModel_DurationDistanceMatrix) GetRows() []*ShipmentModel_DurationDistanceMatrix_Row {
	if x != nil {
		return x.Rows
	}
	return nil
}

func (x *ShipmentModel_DurationDistanceMatrix) GetVehicleStartTag() string {
	if x != nil {
		return x.VehicleStartTag
	}
	return ""
}

// A precedence rule between two events (each event is the pickup or the
// delivery of a shipment): the "second" event has to start at least
// `offset_duration` after "first" has started.
//
// Several precedences can refer to the same (or related) events, e.g.,
// "pickup of B happens after delivery of A" and "pickup of C happens after
// pickup of B".
//
// Furthermore, precedences only apply when both shipments are performed and
// are otherwise ignored.
type ShipmentModel_PrecedenceRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Shipment index of the "first" event. This field must be specified.
	FirstIndex *int32 `protobuf:"varint,1,opt,name=first_index,json=firstIndex,proto3,oneof" json:"first_index,omitempty"`
	// Indicates if the "first" event is a delivery.
	FirstIsDelivery bool `protobuf:"varint,3,opt,name=first_is_delivery,json=firstIsDelivery,proto3" json:"first_is_delivery,omitempty"`
	// Shipment index of the "second" event. This field must be specified.
	SecondIndex *int32 `protobuf:"varint,2,opt,name=second_index,json=secondIndex,proto3,oneof" json:"second_index,omitempty"`
	// Indicates if the "second" event is a delivery.
	SecondIsDelivery bool `protobuf:"varint,4,opt,name=second_is_delivery,json=secondIsDelivery,proto3" json:"second_is_delivery,omitempty"`
	// The offset between the "first" and "second" event. It can be negative.
	OffsetDuration *durationpb.Duration `protobuf:"bytes,5,opt,name=offset_duration,json=offsetDuration,proto3" json:"offset_duration,omitempty"`
}

func (x *ShipmentModel_PrecedenceRule) Reset() {
	*x = ShipmentModel_PrecedenceRule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ShipmentModel_PrecedenceRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ShipmentModel_PrecedenceRule) ProtoMessage() {}

func (x *ShipmentModel_PrecedenceRule) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ShipmentModel_PrecedenceRule.ProtoReflect.Descriptor instead.
func (*ShipmentModel_PrecedenceRule) Descriptor() ([]byte, []int) {
	return file_google_cloud_optimization_v1_fleet_routing_proto_rawDescGZIP(), []int{4, 1}
}

func (x *ShipmentModel_PrecedenceRule) GetFirstIndex() int32 {
	if x != nil && x.FirstIndex != nil {
		return *x.FirstIndex
	}
	return 0
}

func (x *ShipmentModel_PrecedenceRule) GetFirstIsDelivery() bool {
	if x != nil {
		return x.FirstIsDelivery
	}
	return false
}

func (x *ShipmentModel_PrecedenceRule) GetSecondIndex() int32 {
	if x != nil && x.SecondIndex != nil {
		return *x.SecondIndex
	}
	return 0
}

func (x *ShipmentModel_PrecedenceRule) GetSecondIsDelivery() bool {
	if x != nil {
		return x.SecondIsDelivery
	}
	return false
}

func (x *ShipmentModel_PrecedenceRule) GetOffsetDuration() *durationpb.Duration {
	if x != nil {
		return x.OffsetDuration
	}
	return nil
}

// Deprecated: Use top level
// [BreakRule][google.cloud.optimization.v1.ShipmentModel.BreakRule] instead.
// Rules to generate time breaks for a vehicle (e.g. lunch
// breaks). A break is a contiguous period of time during which the vehicle
// remains idle at its current position and cannot perform any visit. A break
// may occur:
//
//   - during the travel between two visits (which includes the time right
//     before or right after a visit, but not in the middle of a visit), in
//     which case it extends the corresponding transit time between the visits
//   - before the vehicle start (the vehicle may not start in the middle of
//     a break), in which case it does not affect the vehicle start time.
//   - after the vehicle end (ditto, with the vehicle end time).
//
// Deprecated: Marked as deprecated in google/cloud/optimization/v1/fleet_routing.proto.
type ShipmentModel_BreakRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Sequence of breaks. See the `BreakRequest` message.
	BreakRequests []*ShipmentModel_BreakRule_BreakRequest `protobuf:"bytes,1,rep,name=break_requests,json=breakRequests,proto3" json:"break_requests,omitempty"`
	// Several `FrequencyConstraint` may apply. They must all be satisfied by
	// the `BreakRequest`s of this `BreakRule`. See `FrequencyConstraint`.
	FrequencyConstraints []*ShipmentModel_BreakRule_FrequencyConstraint `protobuf:"bytes,2,rep,name=frequency_constraints,json=frequencyConstraints,proto3" json:"frequency_constraints,omitempty"`
}

func (x *ShipmentModel_BreakRule) Reset() {
	*x = ShipmentModel_BreakRule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ShipmentModel_BreakRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ShipmentModel_BreakRule) ProtoMessage() {}

func (x *ShipmentModel_BreakRule) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ShipmentModel_BreakRule.ProtoReflect.Descriptor instead.
func (*ShipmentModel_BreakRule) Descriptor() ([]byte, []int) {
	return file_google_cloud_optimization_v1_fleet_routing_proto_rawDescGZIP(), []int{4, 2}
}

func (x *ShipmentModel_BreakRule) GetBreakRequests() []*ShipmentModel_BreakRule_BreakRequest {
	if x != nil {
		return x.BreakRequests
	}
	return nil
}

func (x *ShipmentModel_BreakRule) GetFrequencyConstraints() []*ShipmentModel_BreakRule_FrequencyConstraint {
	if x != nil {
		return x.FrequencyConstraints
	}
	return nil
}

// Specifies a row of the duration and distance matrix.
type ShipmentModel_DurationDistanceMatrix_Row struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Duration values for a given row. It must have as many elements as
	// [ShipmentModel.duration_distance_matrix_dst_tags][google.cloud.optimization.v1.ShipmentModel.duration_distance_matrix_dst_tags].
	Durations []*durationpb.Duration `protobuf:"bytes,1,rep,name=durations,proto3" json:"durations,omitempty"`
	// Distance values for a given row. If no costs or constraints refer to
	// distances in the model, this can be left empty; otherwise it must have
	// as many elements as `durations`.
	Meters []float64 `protobuf:"fixed64,2,rep,packed,name=meters,proto3" json:"meters,omitempty"`
}

func (x *ShipmentModel_DurationDistanceMatrix_Row) Reset() {
	*x = ShipmentModel_DurationDistanceMatrix_Row{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ShipmentModel_DurationDistanceMatrix_Row) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ShipmentModel_DurationDistanceMatrix_Row) ProtoMessage() {}

func (x *ShipmentModel_DurationDistanceMatrix_Row) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ShipmentModel_DurationDistanceMatrix_Row.ProtoReflect.Descriptor instead.
func (*ShipmentModel_DurationDistanceMatrix_Row) Descriptor() ([]byte, []int) {
	return file_google_cloud_optimization_v1_fleet_routing_proto_rawDescGZIP(), []int{4, 0, 0}
}

func (x *ShipmentModel_DurationDistanceMatrix_Row) GetDurations() []*durationpb.Duration {
	if x != nil {
		return x.Durations
	}
	return nil
}

func (x *ShipmentModel_DurationDistanceMatrix_Row) GetMeters() []float64 {
	if x != nil {
		return x.Meters
	}
	return nil
}

// The sequence of breaks (i.e. their number and order) that apply to each
// vehicle must be known beforehand. The repeated `BreakRequest`s define
// that sequence, in the order in which they must occur. Their time windows
// (`earliest_start_time` / `latest_start_time`) may overlap, but they must
// be compatible with the order (this is checked).
type ShipmentModel_BreakRule_BreakRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Lower bound (inclusive) on the start of the break.
	EarliestStartTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=earliest_start_time,json=earliestStartTime,proto3" json:"earliest_start_time,omitempty"`
	// Required. Upper bound (inclusive) on the start of the break.
	LatestStartTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=latest_start_time,json=latestStartTime,proto3" json:"latest_start_time,omitempty"`
	// Required. Minimum duration of the break. Must be positive.
	MinDuration *durationpb.Duration `protobuf:"bytes,3,opt,name=min_duration,json=minDuration,proto3" json:"min_duration,omitempty"`
}

func (x *ShipmentModel_BreakRule_BreakRequest) Reset() {
	*x = ShipmentModel_BreakRule_BreakRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ShipmentModel_BreakRule_BreakRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ShipmentModel_BreakRule_BreakRequest) ProtoMessage() {}

func (x *ShipmentModel_BreakRule_BreakRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ShipmentModel_BreakRule_BreakRequest.ProtoReflect.Descriptor instead.
func (*ShipmentModel_BreakRule_BreakRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_optimization_v1_fleet_routing_proto_rawDescGZIP(), []int{4, 2, 0}
}

func (x *ShipmentModel_BreakRule_BreakRequest) GetEarliestStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EarliestStartTime
	}
	return nil
}

func (x *ShipmentModel_BreakRule_BreakRequest) GetLatestStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LatestStartTime
	}
	return nil
}

func (x *ShipmentModel_BreakRule_BreakRequest) GetMinDuration() *durationpb.Duration {
	if x != nil {
		return x.MinDuration
	}
	return nil
}

// One may further constrain the frequency and duration of the breaks
// specified above, by enforcing a minimum break frequency, such as
// "There must be a break of at least 1 hour every 12 hours". Assuming that
// this can be interpreted as "Within any sliding time window of 12h, there
// must be at least one break of at least one hour", that example would
// translate to the following `FrequencyConstraint`:
// ```
//
//	{
//	   min_break_duration { seconds: 3600 }         # 1 hour.
//	   max_inter_break_duration { seconds: 39600 }  # 11 hours (12 - 1 = 11).
//	}
//
// ```
//
// The timing and duration of the breaks in the solution will respect all
// such constraints, in addition to the time windows and minimum durations
// already specified in the `BreakRequest`.
//
// A `FrequencyConstraint` may in practice apply to non-consecutive breaks.
// For example, the following schedule honors the "1h every 12h" example:
// ```
//
//	04:00 vehicle start
//	 .. performing travel and visits ..
//	09:00 1 hour break
//	10:00 end of the break
//	 .. performing travel and visits ..
//	12:00 20-min lunch break
//	12:20 end of the break
//	 .. performing travel and visits ..
//	21:00 1 hour break
//	22:00 end of the break
//	 .. performing travel and visits ..
//	23:59 vehicle end
//
// ```
type ShipmentModel_BreakRule_FrequencyConstraint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Minimum break duration for this constraint. Nonnegative.
	// See description of `FrequencyConstraint`.
	MinBreakDuration *durationpb.Duration `protobuf:"bytes,1,opt,name=min_break_duration,json=minBreakDuration,proto3" json:"min_break_duration,omitempty"`
	// Required. Maximum allowed span of any interval of time in the route
	// that does not include at least partially a break of `duration >=
	// min_break_duration`. Must be positive.
	MaxInterBreakDuration *durationpb.Duration `protobuf:"bytes,2,opt,name=max_inter_break_duration,json=maxInterBreakDuration,proto3" json:"max_inter_break_duration,omitempty"`
}

func (x *ShipmentModel_BreakRule_FrequencyConstraint) Reset() {
	*x = ShipmentModel_BreakRule_FrequencyConstraint{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ShipmentModel_BreakRule_FrequencyConstraint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ShipmentModel_BreakRule_FrequencyConstraint) ProtoMessage() {}

func (x *ShipmentModel_BreakRule_FrequencyConstraint) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ShipmentModel_BreakRule_FrequencyConstraint.ProtoReflect.Descriptor instead.
func (*ShipmentModel_BreakRule_FrequencyConstraint) Descriptor() ([]byte, []int) {
	return file_google_cloud_optimization_v1_fleet_routing_proto_rawDescGZIP(), []int{4, 2, 1}
}

func (x *ShipmentModel_BreakRule_FrequencyConstraint) GetMinBreakDuration() *durationpb.Duration {
	if x != nil {
		return x.MinBreakDuration
	}
	return nil
}

func (x *ShipmentModel_BreakRule_FrequencyConstraint) GetMaxInterBreakDuration() *durationpb.Duration {
	if x != nil {
		return x.MaxInterBreakDuration
	}
	return nil
}

// Request for a visit which can be done by a vehicle: it has a geo-location
// (or two, see below), opening and closing times represented by time windows,
// and a service duration time (time spent by the vehicle once it has arrived
// to pickup or drop off goods).
type Shipment_VisitRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The geo-location where the vehicle arrives when performing this
	// `VisitRequest`. If the shipment model has duration distance matrices,
	// `arrival_location` must not be specified.
	ArrivalLocation *latlng.LatLng `protobuf:"bytes,1,opt,name=arrival_location,json=arrivalLocation,proto3" json:"arrival_location,omitempty"`
	// The waypoint where the vehicle arrives when performing this
	// `VisitRequest`. If the shipment model has duration distance matrices,
	// `arrival_waypoint` must not be specified.
	ArrivalWaypoint *Waypoint `protobuf:"bytes,2,opt,name=arrival_waypoint,json=arrivalWaypoint,proto3" json:"arrival_waypoint,omitempty"`
	// The geo-location where the vehicle departs after completing this
	// `VisitRequest`. Can be omitted if it is the same as `arrival_location`.
	// If the shipment model has duration distance matrices,
	// `departure_location` must not be specified.
	DepartureLocation *latlng.LatLng `protobuf:"bytes,3,opt,name=departure_location,json=departureLocation,proto3" json:"departure_location,omitempty"`
	// The waypoint where the vehicle departs after completing this
	// `VisitRequest`. Can be omitted if it is the same as `arrival_waypoint`.
	// If the shipment model has duration distance matrices,
	// `departure_waypoint` must not be specified.
	DepartureWaypoint *Waypoint `protobuf:"bytes,4,opt,name=departure_waypoint,json=departureWaypoint,proto3" json:"departure_waypoint,omitempty"`
	// Specifies tags attached to the visit request.
	// Empty or duplicate strings are not allowed.
	Tags []string `protobuf:"bytes,5,rep,name=tags,proto3" json:"tags,omitempty"`
	// Time windows which constrain the arrival time at a visit.
	// Note that a vehicle may depart outside of the arrival time window, i.e.
	// arrival time + duration do not need to be inside a time window. This can
	// result in waiting time if the vehicle arrives before
	// [TimeWindow.start_time][google.cloud.optimization.v1.TimeWindow.start_time].
	//
	// The absence of `TimeWindow` means that the vehicle can perform this visit
	// at any time.
	//
	// Time windows must be disjoint, i.e. no time window must overlap with or
	// be adjacent to another, and they must be in increasing order.
	//
	// `cost_per_hour_after_soft_end_time` and `soft_end_time` can only
	// be set if there is a single time window.
	TimeWindows []*TimeWindow `protobuf:"bytes,6,rep,name=time_windows,json=timeWindows,proto3" json:"time_windows,omitempty"`
	// Duration of the visit, i.e. time spent by the vehicle between arrival
	// and departure (to be added to the possible waiting time; see
	// `time_windows`).
	Duration *durationpb.Duration `protobuf:"bytes,7,opt,name=duration,proto3" json:"duration,omitempty"`
	// Cost to service this visit request on a vehicle route. This can be used
	// to pay different costs for each alternative pickup or delivery of a
	// shipment. This cost must be in the same unit as `Shipment.penalty_cost`
	// and must not be negative.
	Cost float64 `protobuf:"fixed64,8,opt,name=cost,proto3" json:"cost,omitempty"`
	// Load demands of this visit request. This is just like
	// [Shipment.load_demands][google.cloud.optimization.v1.Shipment.load_demands]
	// field, except that it only applies to this
	// [VisitRequest][google.cloud.optimization.v1.Shipment.VisitRequest]
	// instead of the whole [Shipment][google.cloud.optimization.v1.Shipment].
	// The demands listed here are added to the demands listed in
	// [Shipment.load_demands][google.cloud.optimization.v1.Shipment.load_demands].
	LoadDemands map[string]*Shipment_Load `protobuf:"bytes,12,rep,name=load_demands,json=loadDemands,proto3" json:"load_demands,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Specifies the types of the visit. This may be used to allocate additional
	// time required for a vehicle to complete this visit (see
	// [Vehicle.extra_visit_duration_for_visit_type][google.cloud.optimization.v1.Vehicle.extra_visit_duration_for_visit_type]).
	//
	// A type can only appear once.
	VisitTypes []string `protobuf:"bytes,10,rep,name=visit_types,json=visitTypes,proto3" json:"visit_types,omitempty"`
	// Specifies a label for this `VisitRequest`. This label is reported in the
	// response as `visit_label` in the corresponding
	// [ShipmentRoute.Visit][google.cloud.optimization.v1.ShipmentRoute.Visit].
	Label string `protobuf:"bytes,11,opt,name=label,proto3" json:"label,omitempty"`
	// Deprecated: Use
	// [VisitRequest.load_demands][google.cloud.optimization.v1.Shipment.VisitRequest.load_demands]
	// instead.
	//
	// Deprecated: Marked as deprecated in google/cloud/optimization/v1/fleet_routing.proto.
	Demands []*CapacityQuantity `protobuf:"bytes,9,rep,name=demands,proto3" json:"demands,omitempty"`
}

func (x *Shipment_VisitRequest) Reset() {
	*x = Shipment_VisitRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Shipment_VisitRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Shipment_VisitRequest) ProtoMessage() {}

func (x *Shipment_VisitRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Shipment_VisitRequest.ProtoReflect.Descriptor instead.
func (*Shipment_VisitRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_optimization_v1_fleet_routing_proto_rawDescGZIP(), []int{5, 0}
}

func (x *Shipment_VisitRequest) GetArrivalLocation() *latlng.LatLng {
	if x != nil {
		return x.ArrivalLocation
	}
	return nil
}

func (x *Shipment_VisitRequest) GetArrivalWaypoint() *Waypoint {
	if x != nil {
		return x.ArrivalWaypoint
	}
	return nil
}

func (x *Shipment_VisitRequest) GetDepartureLocation() *latlng.LatLng {
	if x != nil {
		return x.DepartureLocation
	}
	return nil
}

func (x *Shipment_VisitRequest) GetDepartureWaypoint() *Waypoint {
	if x != nil {
		return x.DepartureWaypoint
	}
	return nil
}

func (x *Shipment_VisitRequest) GetTags() []string {
	if x != nil {
		return x.Tags
	}
	return nil
}

func (x *Shipment_VisitRequest) GetTimeWindows() []*TimeWindow {
	if x != nil {
		return x.TimeWindows
	}
	return nil
}

func (x *Shipment_VisitRequest) GetDuration() *durationpb.Duration {
	if x != nil {
		return x.Duration
	}
	return nil
}

func (x *Shipment_VisitRequest) GetCost() float64 {
	if x != nil {
		return x.Cost
	}
	return 0
}

func (x *Shipment_VisitRequest) GetLoadDemands() map[string]*Shipment_Load {
	if x != nil {
		return x.LoadDemands
	}
	return nil
}

func (x *Shipment_VisitRequest) GetVisitTypes() []string {
	if x != nil {
		return x.VisitTypes
	}
	return nil
}

func (x *Shipment_VisitRequest) GetLabel() string {
	if x != nil {
		return x.Label
	}
	return ""
}

// Deprecated: Marked as deprecated in google/cloud/optimization/v1/fleet_routing.proto.
func (x *Shipment_VisitRequest) GetDemands() []*CapacityQuantity {
	if x != nil {
		return x.Demands
	}
	return nil
}

// When performing a visit, a predefined amount may be added to the vehicle
// load if it's a pickup, or subtracted if it's a delivery. This message
// defines such amount. See
// [load_demands][google.cloud.optimization.v1.Shipment.load_demands].
type Shipment_Load struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The amount by which the load of the vehicle performing the corresponding
	// visit will vary. Since it is an integer, users are advised to choose an
	// appropriate unit to avoid loss of precision. Must be ≥ 0.
	Amount int64 `protobuf:"varint,2,opt,name=amount,proto3" json:"amount,omitempty"`
}

func (x *Shipment_Load) Reset() {
	*x = Shipment_Load{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Shipment_Load) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Shipment_Load) ProtoMessage() {}

func (x *Shipment_Load) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Shipment_Load.ProtoReflect.Descriptor instead.
func (*Shipment_Load) Descriptor() ([]byte, []int) {
	return file_google_cloud_optimization_v1_fleet_routing_proto_rawDescGZIP(), []int{5, 1}
}

func (x *Shipment_Load) GetAmount() int64 {
	if x != nil {
		return x.Amount
	}
	return 0
}

// Defines a load limit applying to a vehicle, e.g. "this truck may only
// carry up to 3500 kg". See
// [load_limits][google.cloud.optimization.v1.Vehicle.load_limits].
type Vehicle_LoadLimit struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The maximum acceptable amount of load.
	MaxLoad *int64 `protobuf:"varint,1,opt,name=max_load,json=maxLoad,proto3,oneof" json:"max_load,omitempty"`
	// A soft limit of the load. See
	// [cost_per_unit_above_soft_max][google.cloud.optimization.v1.Vehicle.LoadLimit.cost_per_unit_above_soft_max].
	SoftMaxLoad int64 `protobuf:"varint,2,opt,name=soft_max_load,json=softMaxLoad,proto3" json:"soft_max_load,omitempty"`
	// If the load ever exceeds
	// [soft_max_load][google.cloud.optimization.v1.Vehicle.LoadLimit.soft_max_load]
	// along this vehicle's route, the following cost penalty applies (only once
	// per vehicle): (load -
	// [soft_max_load][google.cloud.optimization.v1.Vehicle.LoadLimit.soft_max_load])
	// * [cost_per_unit_above_soft_max][google.cloud.optimization.v1.Vehicle.LoadLimit.cost_per_unit_above_soft_max]. All costs
	// add up and must be in the same unit as
	// [Shipment.penalty_cost][google.cloud.optimization.v1.Shipment.penalty_cost].
	CostPerUnitAboveSoftMax float64 `protobuf:"fixed64,3,opt,name=cost_per_unit_above_soft_max,json=costPerUnitAboveSoftMax,proto3" json:"cost_per_unit_above_soft_max,omitempty"`
	// The acceptable load interval of the vehicle at the start of the route.
	StartLoadInterval *Vehicle_LoadLimit_Interval `protobuf:"bytes,4,opt,name=start_load_interval,json=startLoadInterval,proto3" json:"start_load_interval,omitempty"`
	// The acceptable load interval of the vehicle at the end of the route.
	EndLoadInterval *Vehicle_LoadLimit_Interval `protobuf:"bytes,5,opt,name=end_load_interval,json=endLoadInterval,proto3" json:"end_load_interval,omitempty"`
}

func (x *Vehicle_LoadLimit) Reset() {
	*x = Vehicle_LoadLimit{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Vehicle_LoadLimit) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Vehicle_LoadLimit) ProtoMessage() {}

func (x *Vehicle_LoadLimit) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Vehicle_LoadLimit.ProtoReflect.Descriptor instead.
func (*Vehicle_LoadLimit) Descriptor() ([]byte, []int) {
	return file_google_cloud_optimization_v1_fleet_routing_proto_rawDescGZIP(), []int{8, 0}
}

func (x *Vehicle_LoadLimit) GetMaxLoad() int64 {
	if x != nil && x.MaxLoad != nil {
		return *x.MaxLoad
	}
	return 0
}

func (x *Vehicle_LoadLimit) GetSoftMaxLoad() int64 {
	if x != nil {
		return x.SoftMaxLoad
	}
	return 0
}

func (x *Vehicle_LoadLimit) GetCostPerUnitAboveSoftMax() float64 {
	if x != nil {
		return x.CostPerUnitAboveSoftMax
	}
	return 0
}

func (x *Vehicle_LoadLimit) GetStartLoadInterval() *Vehicle_LoadLimit_Interval {
	if x != nil {
		return x.StartLoadInterval
	}
	return nil
}

func (x *Vehicle_LoadLimit) GetEndLoadInterval() *Vehicle_LoadLimit_Interval {
	if x != nil {
		return x.EndLoadInterval
	}
	return nil
}

// A limit defining a maximum duration of the route of a vehicle. It can be
// either hard or soft.
//
// When a soft limit field is defined, both the soft max threshold and its
// associated cost must be defined together.
type Vehicle_DurationLimit struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A hard limit constraining the duration to be at most max_duration.
	MaxDuration *durationpb.Duration `protobuf:"bytes,1,opt,name=max_duration,json=maxDuration,proto3" json:"max_duration,omitempty"`
	// A soft limit not enforcing a maximum duration limit, but when violated
	// makes the route incur a cost. This cost adds up to other costs defined in
	// the model, with the same unit.
	//
	// If defined, `soft_max_duration` must be nonnegative. If max_duration is
	// also defined, `soft_max_duration` must be less than max_duration.
	SoftMaxDuration *durationpb.Duration `protobuf:"bytes,2,opt,name=soft_max_duration,json=softMaxDuration,proto3" json:"soft_max_duration,omitempty"`
	// Cost per hour incurred if the `soft_max_duration` threshold is violated.
	// The additional cost is 0 if the duration is under the threshold,
	// otherwise the cost depends on the duration as follows:
	// ```
	//   cost_per_hour_after_soft_max * (duration - soft_max_duration)
	// ```
	// The cost must be nonnegative.
	CostPerHourAfterSoftMax *float64 `protobuf:"fixed64,3,opt,name=cost_per_hour_after_soft_max,json=costPerHourAfterSoftMax,proto3,oneof" json:"cost_per_hour_after_soft_max,omitempty"`
	// A soft limit not enforcing a maximum duration limit, but when violated
	// makes the route incur a cost, quadratic in the duration. This cost adds
	// up to other costs defined in the model, with the same unit.
	//
	// If defined, `quadratic_soft_max_duration` must be nonnegative. If
	// `max_duration` is also defined, `quadratic_soft_max_duration` must be
	// less than `max_duration`, and the difference must be no larger than one
	// day:
	//
	//    `max_duration - quadratic_soft_max_duration <= 86400 seconds`
	QuadraticSoftMaxDuration *durationpb.Duration `protobuf:"bytes,4,opt,name=quadratic_soft_max_duration,json=quadraticSoftMaxDuration,proto3" json:"quadratic_soft_max_duration,omitempty"`
	// Cost per square hour incurred if the
	// `quadratic_soft_max_duration` threshold is violated.
	//
	// The additional cost is 0 if the duration is under the threshold,
	// otherwise the cost depends on the duration as follows:
	//
	// ```
	//   cost_per_square_hour_after_quadratic_soft_max *
	//   (duration - quadratic_soft_max_duration)^2
	// ```
	//
	// The cost must be nonnegative.
	CostPerSquareHourAfterQuadraticSoftMax *float64 `protobuf:"fixed64,5,opt,name=cost_per_square_hour_after_quadratic_soft_max,json=costPerSquareHourAfterQuadraticSoftMax,proto3,oneof" json:"cost_per_square_hour_after_quadratic_soft_max,omitempty"`
}

func (x *Vehicle_DurationLimit) Reset() {
	*x = Vehicle_DurationLimit{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Vehicle_DurationLimit) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Vehicle_DurationLimit) ProtoMessage() {}

func (x *Vehicle_DurationLimit) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Vehicle_DurationLimit.ProtoReflect.Descriptor instead.
func (*Vehicle_DurationLimit) Descriptor() ([]byte, []int) {
	return file_google_cloud_optimization_v1_fleet_routing_proto_rawDescGZIP(), []int{8, 1}
}

func (x *Vehicle_DurationLimit) GetMaxDuration() *durationpb.Duration {
	if x != nil {
		return x.MaxDuration
	}
	return nil
}

func (x *Vehicle_DurationLimit) GetSoftMaxDuration() *durationpb.Duration {
	if x != nil {
		return x.SoftMaxDuration
	}
	return nil
}

func (x *Vehicle_DurationLimit) GetCostPerHourAfterSoftMax() float64 {
	if x != nil && x.CostPerHourAfterSoftMax != nil {
		return *x.CostPerHourAfterSoftMax
	}
	return 0
}

func (x *Vehicle_DurationLimit) GetQuadraticSoftMaxDuration() *durationpb.Duration {
	if x != nil {
		return x.QuadraticSoftMaxDuration
	}
	return nil
}

func (x *Vehicle_DurationLimit) GetCostPerSquareHourAfterQuadraticSoftMax() float64 {
	if x != nil && x.CostPerSquareHourAfterQuadraticSoftMax != nil {
		return *x.CostPerSquareHourAfterQuadraticSoftMax
	}
	return 0
}

// Interval of acceptable load amounts.
type Vehicle_LoadLimit_Interval struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A minimum acceptable load. Must be ≥ 0.
	// If they're both specified,
	// [min][google.cloud.optimization.v1.Vehicle.LoadLimit.Interval.min] must
	// be ≤
	// [max][google.cloud.optimization.v1.Vehicle.LoadLimit.Interval.max].
	Min int64 `protobuf:"varint,1,opt,name=min,proto3" json:"min,omitempty"`
	// A maximum acceptable load. Must be ≥ 0. If unspecified, the maximum
	// load is unrestricted by this message.
	// If they're both specified,
	// [min][google.cloud.optimization.v1.Vehicle.LoadLimit.Interval.min] must
	// be ≤
	// [max][google.cloud.optimization.v1.Vehicle.LoadLimit.Interval.max].
	Max *int64 `protobuf:"varint,2,opt,name=max,proto3,oneof" json:"max,omitempty"`
}

func (x *Vehicle_LoadLimit_Interval) Reset() {
	*x = Vehicle_LoadLimit_Interval{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Vehicle_LoadLimit_Interval) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Vehicle_LoadLimit_Interval) ProtoMessage() {}

func (x *Vehicle_LoadLimit_Interval) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Vehicle_LoadLimit_Interval.ProtoReflect.Descriptor instead.
func (*Vehicle_LoadLimit_Interval) Descriptor() ([]byte, []int) {
	return file_google_cloud_optimization_v1_fleet_routing_proto_rawDescGZIP(), []int{8, 0, 0}
}

func (x *Vehicle_LoadLimit_Interval) GetMin() int64 {
	if x != nil {
		return x.Min
	}
	return 0
}

func (x *Vehicle_LoadLimit_Interval) GetMax() int64 {
	if x != nil && x.Max != nil {
		return *x.Max
	}
	return 0
}

// The sequence of breaks (i.e. their number and order) that apply to each
// vehicle must be known beforehand. The repeated `BreakRequest`s define
// that sequence, in the order in which they must occur. Their time windows
// (`earliest_start_time` / `latest_start_time`) may overlap, but they must
// be compatible with the order (this is checked).
type BreakRule_BreakRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Lower bound (inclusive) on the start of the break.
	EarliestStartTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=earliest_start_time,json=earliestStartTime,proto3" json:"earliest_start_time,omitempty"`
	// Required. Upper bound (inclusive) on the start of the break.
	LatestStartTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=latest_start_time,json=latestStartTime,proto3" json:"latest_start_time,omitempty"`
	// Required. Minimum duration of the break. Must be positive.
	MinDuration *durationpb.Duration `protobuf:"bytes,3,opt,name=min_duration,json=minDuration,proto3" json:"min_duration,omitempty"`
}

func (x *BreakRule_BreakRequest) Reset() {
	*x = BreakRule_BreakRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BreakRule_BreakRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BreakRule_BreakRequest) ProtoMessage() {}

func (x *BreakRule_BreakRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BreakRule_BreakRequest.ProtoReflect.Descriptor instead.
func (*BreakRule_BreakRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_optimization_v1_fleet_routing_proto_rawDescGZIP(), []int{16, 0}
}

func (x *BreakRule_BreakRequest) GetEarliestStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EarliestStartTime
	}
	return nil
}

func (x *BreakRule_BreakRequest) GetLatestStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LatestStartTime
	}
	return nil
}

func (x *BreakRule_BreakRequest) GetMinDuration() *durationpb.Duration {
	if x != nil {
		return x.MinDuration
	}
	return nil
}

// One may further constrain the frequency and duration of the breaks
// specified above, by enforcing a minimum break frequency, such as
// "There must be a break of at least 1 hour every 12 hours". Assuming that
// this can be interpreted as "Within any sliding time window of 12h, there
// must be at least one break of at least one hour", that example would
// translate to the following `FrequencyConstraint`:
// ```
//
//	{
//	   min_break_duration { seconds: 3600 }         # 1 hour.
//	   max_inter_break_duration { seconds: 39600 }  # 11 hours (12 - 1 = 11).
//	}
//
// ```
//
// The timing and duration of the breaks in the solution will respect all
// such constraints, in addition to the time windows and minimum durations
// already specified in the `BreakRequest`.
//
// A `FrequencyConstraint` may in practice apply to non-consecutive breaks.
// For example, the following schedule honors the "1h every 12h" example:
// ```
//
//	04:00 vehicle start
//	 .. performing travel and visits ..
//	09:00 1 hour break
//	10:00 end of the break
//	 .. performing travel and visits ..
//	12:00 20-min lunch break
//	12:20 end of the break
//	 .. performing travel and visits ..
//	21:00 1 hour break
//	22:00 end of the break
//	 .. performing travel and visits ..
//	23:59 vehicle end
//
// ```
type BreakRule_FrequencyConstraint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Minimum break duration for this constraint. Nonnegative.
	// See description of `FrequencyConstraint`.
	MinBreakDuration *durationpb.Duration `protobuf:"bytes,1,opt,name=min_break_duration,json=minBreakDuration,proto3" json:"min_break_duration,omitempty"`
	// Required. Maximum allowed span of any interval of time in the route that
	// does not include at least partially a break of `duration >=
	// min_break_duration`. Must be positive.
	MaxInterBreakDuration *durationpb.Duration `protobuf:"bytes,2,opt,name=max_inter_break_duration,json=maxInterBreakDuration,proto3" json:"max_inter_break_duration,omitempty"`
}

func (x *BreakRule_FrequencyConstraint) Reset() {
	*x = BreakRule_FrequencyConstraint{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BreakRule_FrequencyConstraint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BreakRule_FrequencyConstraint) ProtoMessage() {}

func (x *BreakRule_FrequencyConstraint) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BreakRule_FrequencyConstraint.ProtoReflect.Descriptor instead.
func (*BreakRule_FrequencyConstraint) Descriptor() ([]byte, []int) {
	return file_google_cloud_optimization_v1_fleet_routing_proto_rawDescGZIP(), []int{16, 1}
}

func (x *BreakRule_FrequencyConstraint) GetMinBreakDuration() *durationpb.Duration {
	if x != nil {
		return x.MinBreakDuration
	}
	return nil
}

func (x *BreakRule_FrequencyConstraint) GetMaxInterBreakDuration() *durationpb.Duration {
	if x != nil {
		return x.MaxInterBreakDuration
	}
	return nil
}

// Deprecated: Use
// [ShipmentRoute.Transition.delay_duration][google.cloud.optimization.v1.ShipmentRoute.Transition.delay_duration]
// instead. Time interval spent on the route resulting from a
// [TransitionAttributes.delay][google.cloud.optimization.v1.TransitionAttributes.delay].
//
// Deprecated: Marked as deprecated in google/cloud/optimization/v1/fleet_routing.proto.
type ShipmentRoute_Delay struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Start of the delay.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Duration of the delay.
	Duration *durationpb.Duration `protobuf:"bytes,2,opt,name=duration,proto3" json:"duration,omitempty"`
}

func (x *ShipmentRoute_Delay) Reset() {
	*x = ShipmentRoute_Delay{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ShipmentRoute_Delay) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ShipmentRoute_Delay) ProtoMessage() {}

func (x *ShipmentRoute_Delay) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ShipmentRoute_Delay.ProtoReflect.Descriptor instead.
func (*ShipmentRoute_Delay) Descriptor() ([]byte, []int) {
	return file_google_cloud_optimization_v1_fleet_routing_proto_rawDescGZIP(), []int{17, 0}
}

func (x *ShipmentRoute_Delay) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *ShipmentRoute_Delay) GetDuration() *durationpb.Duration {
	if x != nil {
		return x.Duration
	}
	return nil
}

// A visit performed during a route. This visit corresponds to a pickup or a
// delivery of a `Shipment`.
type ShipmentRoute_Visit struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Index of the `shipments` field in the source
	// [ShipmentModel][google.cloud.optimization.v1.ShipmentModel].
	ShipmentIndex int32 `protobuf:"varint,1,opt,name=shipment_index,json=shipmentIndex,proto3" json:"shipment_index,omitempty"`
	// If true the visit corresponds to a pickup of a `Shipment`. Otherwise, it
	// corresponds to a delivery.
	IsPickup bool `protobuf:"varint,2,opt,name=is_pickup,json=isPickup,proto3" json:"is_pickup,omitempty"`
	// Index of `VisitRequest` in either the pickup or delivery field of the
	// `Shipment` (see `is_pickup`).
	VisitRequestIndex int32 `protobuf:"varint,3,opt,name=visit_request_index,json=visitRequestIndex,proto3" json:"visit_request_index,omitempty"`
	// Time at which the visit starts. Note that the vehicle may arrive earlier
	// than this at the visit location. Times are consistent with the
	// `ShipmentModel`.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Total visit load demand as the sum of the shipment and the visit request
	// `load_demands`. The values are negative if the visit is a delivery.
	// Demands are reported for the same types as the
	// [Transition.loads][google.cloud.optimization.v1.ShipmentRoute.Transition]
	// (see this field).
	LoadDemands map[string]*Shipment_Load `protobuf:"bytes,11,rep,name=load_demands,json=loadDemands,proto3" json:"load_demands,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Extra detour time due to the shipments visited on the route before the
	// visit and to the potential waiting time induced by time windows.
	// If the visit is a delivery, the detour is computed from the corresponding
	// pickup visit and is equal to:
	// ```
	// start_time(delivery) - start_time(pickup)
	// - (duration(pickup) + travel duration from the pickup location
	// to the delivery location).
	// ```
	// Otherwise, it is computed from the vehicle `start_location` and is equal
	// to:
	// ```
	// start_time - vehicle_start_time - travel duration from
	// the vehicle's `start_location` to the visit.
	// ```
	Detour *durationpb.Duration `protobuf:"bytes,6,opt,name=detour,proto3" json:"detour,omitempty"`
	// Copy of the corresponding `Shipment.label`, if specified in the
	// `Shipment`.
	ShipmentLabel string `protobuf:"bytes,7,opt,name=shipment_label,json=shipmentLabel,proto3" json:"shipment_label,omitempty"`
	// Copy of the corresponding
	// [VisitRequest.label][google.cloud.optimization.v1.Shipment.VisitRequest.label],
	// if specified in the `VisitRequest`.
	VisitLabel string `protobuf:"bytes,8,opt,name=visit_label,json=visitLabel,proto3" json:"visit_label,omitempty"`
	// Deprecated: Use
	// [Transition.vehicle_loads][google.cloud.optimization.v1.ShipmentRoute.Transition.vehicle_loads]
	// instead. Vehicle loads upon arrival at the visit location, for each type
	// specified in
	// [Vehicle.capacities][google.cloud.optimization.v1.Vehicle.capacities],
	// `start_load_intervals`, `end_load_intervals` or `demands`.
	//
	// Exception: we omit loads for quantity types unconstrained by intervals
	// and that don't have any non-zero demand on the route.
	//
	// Deprecated: Marked as deprecated in google/cloud/optimization/v1/fleet_routing.proto.
	ArrivalLoads []*CapacityQuantity `protobuf:"bytes,9,rep,name=arrival_loads,json=arrivalLoads,proto3" json:"arrival_loads,omitempty"`
	// Deprecated: Use
	// [ShipmentRoute.Transition.delay_duration][google.cloud.optimization.v1.ShipmentRoute.Transition.delay_duration]
	// instead. Delay occurring before the visit starts.
	//
	// Deprecated: Marked as deprecated in google/cloud/optimization/v1/fleet_routing.proto.
	DelayBeforeStart *ShipmentRoute_Delay `protobuf:"bytes,10,opt,name=delay_before_start,json=delayBeforeStart,proto3" json:"delay_before_start,omitempty"`
	// Deprecated: Use
	// [Visit.load_demands][google.cloud.optimization.v1.ShipmentRoute.Visit.load_demands]
	// instead.
	//
	// Deprecated: Marked as deprecated in google/cloud/optimization/v1/fleet_routing.proto.
	Demands []*CapacityQuantity `protobuf:"bytes,5,rep,name=demands,proto3" json:"demands,omitempty"`
}

func (x *ShipmentRoute_Visit) Reset() {
	*x = ShipmentRoute_Visit{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ShipmentRoute_Visit) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ShipmentRoute_Visit) ProtoMessage() {}

func (x *ShipmentRoute_Visit) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ShipmentRoute_Visit.ProtoReflect.Descriptor instead.
func (*ShipmentRoute_Visit) Descriptor() ([]byte, []int) {
	return file_google_cloud_optimization_v1_fleet_routing_proto_rawDescGZIP(), []int{17, 1}
}

func (x *ShipmentRoute_Visit) GetShipmentIndex() int32 {
	if x != nil {
		return x.ShipmentIndex
	}
	return 0
}

func (x *ShipmentRoute_Visit) GetIsPickup() bool {
	if x != nil {
		return x.IsPickup
	}
	return false
}

func (x *ShipmentRoute_Visit) GetVisitRequestIndex() int32 {
	if x != nil {
		return x.VisitRequestIndex
	}
	return 0
}

func (x *ShipmentRoute_Visit) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *ShipmentRoute_Visit) GetLoadDemands() map[string]*Shipment_Load {
	if x != nil {
		return x.LoadDemands
	}
	return nil
}

func (x *ShipmentRoute_Visit) GetDetour() *durationpb.Duration {
	if x != nil {
		return x.Detour
	}
	return nil
}

func (x *ShipmentRoute_Visit) GetShipmentLabel() string {
	if x != nil {
		return x.ShipmentLabel
	}
	return ""
}

func (x *ShipmentRoute_Visit) GetVisitLabel() string {
	if x != nil {
		return x.VisitLabel
	}
	return ""
}

// Deprecated: Marked as deprecated in google/cloud/optimization/v1/fleet_routing.proto.
func (x *ShipmentRoute_Visit) GetArrivalLoads() []*CapacityQuantity {
	if x != nil {
		return x.ArrivalLoads
	}
	return nil
}

// Deprecated: Marked as deprecated in google/cloud/optimization/v1/fleet_routing.proto.
func (x *ShipmentRoute_Visit) GetDelayBeforeStart() *ShipmentRoute_Delay {
	if x != nil {
		return x.DelayBeforeStart
	}
	return nil
}

// Deprecated: Marked as deprecated in google/cloud/optimization/v1/fleet_routing.proto.
func (x *ShipmentRoute_Visit) GetDemands() []*CapacityQuantity {
	if x != nil {
		return x.Demands
	}
	return nil
}

// Transition between two events on the route. See the description of
// [ShipmentRoute][google.cloud.optimization.v1.ShipmentRoute].
//
// If the vehicle does not have a `start_location` and/or `end_location`, the
// corresponding travel metrics are 0.
type ShipmentRoute_Transition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Travel duration during this transition.
	TravelDuration *durationpb.Duration `protobuf:"bytes,1,opt,name=travel_duration,json=travelDuration,proto3" json:"travel_duration,omitempty"`
	// Distance traveled during the transition.
	TravelDistanceMeters float64 `protobuf:"fixed64,2,opt,name=travel_distance_meters,json=travelDistanceMeters,proto3" json:"travel_distance_meters,omitempty"`
	// When traffic is requested via
	// [OptimizeToursRequest.consider_road_traffic]
	// [google.cloud.optimization.v1.OptimizeToursRequest.consider_road_traffic],
	// and the traffic info couldn't be retrieved for a `Transition`, this
	// boolean is set to true. This may be temporary (rare hiccup in the
	// realtime traffic servers) or permanent (no data for this location).
	TrafficInfoUnavailable bool `protobuf:"varint,3,opt,name=traffic_info_unavailable,json=trafficInfoUnavailable,proto3" json:"traffic_info_unavailable,omitempty"`
	// Sum of the delay durations applied to this transition. If any, the delay
	// starts exactly `delay_duration` seconds before the next event (visit or
	// vehicle end). See
	// [TransitionAttributes.delay][google.cloud.optimization.v1.TransitionAttributes.delay].
	DelayDuration *durationpb.Duration `protobuf:"bytes,4,opt,name=delay_duration,json=delayDuration,proto3" json:"delay_duration,omitempty"`
	// Sum of the duration of the breaks occurring during this transition, if
	// any. Details about each break's start time and duration are stored in
	// [ShipmentRoute.breaks][google.cloud.optimization.v1.ShipmentRoute.breaks].
	BreakDuration *durationpb.Duration `protobuf:"bytes,5,opt,name=break_duration,json=breakDuration,proto3" json:"break_duration,omitempty"`
	// Time spent waiting during this transition. Wait duration corresponds to
	// idle time and does not include break time. Also note that this wait time
	// may be split into several non-contiguous intervals.
	WaitDuration *durationpb.Duration `protobuf:"bytes,6,opt,name=wait_duration,json=waitDuration,proto3" json:"wait_duration,omitempty"`
	// Total duration of the transition, provided for convenience. It is equal
	// to:
	//
	// * next visit `start_time` (or `vehicle_end_time` if this is the last
	// transition) - this transition's `start_time`;
	// * if `ShipmentRoute.has_traffic_infeasibilities` is false, the following
	// additionally holds: `total_duration = travel_duration + delay_duration
	// + break_duration + wait_duration`.
	TotalDuration *durationpb.Duration `protobuf:"bytes,7,opt,name=total_duration,json=totalDuration,proto3" json:"total_duration,omitempty"`
	// Start time of this transition.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The encoded polyline representation of the route followed during the
	// transition.
	// This field is only populated if [populate_transition_polylines]
	// [google.cloud.optimization.v1.OptimizeToursRequest.populate_transition_polylines]
	// is set to true.
	RoutePolyline *ShipmentRoute_EncodedPolyline `protobuf:"bytes,9,opt,name=route_polyline,json=routePolyline,proto3" json:"route_polyline,omitempty"`
	// Vehicle loads during this transition, for each type that either appears
	// in this vehicle's
	// [Vehicle.load_limits][google.cloud.optimization.v1.Vehicle.load_limits],
	// or that have non-zero
	// [Shipment.load_demands][google.cloud.optimization.v1.Shipment.load_demands]
	// on some shipment performed on this route.
	//
	// The loads during the first transition are the starting loads of the
	// vehicle route. Then, after each visit, the visit's `load_demands` are
	// either added or subtracted to get the next transition's loads, depending
	// on whether the visit was a pickup or a delivery.
	VehicleLoads map[string]*ShipmentRoute_VehicleLoad `protobuf:"bytes,11,rep,name=vehicle_loads,json=vehicleLoads,proto3" json:"vehicle_loads,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Deprecated: Use
	// [Transition.vehicle_loads][google.cloud.optimization.v1.ShipmentRoute.Transition.vehicle_loads]
	// instead.
	//
	// Deprecated: Marked as deprecated in google/cloud/optimization/v1/fleet_routing.proto.
	Loads []*CapacityQuantity `protobuf:"bytes,10,rep,name=loads,proto3" json:"loads,omitempty"`
}

func (x *ShipmentRoute_Transition) Reset() {
	*x = ShipmentRoute_Transition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[44]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ShipmentRoute_Transition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ShipmentRoute_Transition) ProtoMessage() {}

func (x *ShipmentRoute_Transition) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[44]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ShipmentRoute_Transition.ProtoReflect.Descriptor instead.
func (*ShipmentRoute_Transition) Descriptor() ([]byte, []int) {
	return file_google_cloud_optimization_v1_fleet_routing_proto_rawDescGZIP(), []int{17, 2}
}

func (x *ShipmentRoute_Transition) GetTravelDuration() *durationpb.Duration {
	if x != nil {
		return x.TravelDuration
	}
	return nil
}

func (x *ShipmentRoute_Transition) GetTravelDistanceMeters() float64 {
	if x != nil {
		return x.TravelDistanceMeters
	}
	return 0
}

func (x *ShipmentRoute_Transition) GetTrafficInfoUnavailable() bool {
	if x != nil {
		return x.TrafficInfoUnavailable
	}
	return false
}

func (x *ShipmentRoute_Transition) GetDelayDuration() *durationpb.Duration {
	if x != nil {
		return x.DelayDuration
	}
	return nil
}

func (x *ShipmentRoute_Transition) GetBreakDuration() *durationpb.Duration {
	if x != nil {
		return x.BreakDuration
	}
	return nil
}

func (x *ShipmentRoute_Transition) GetWaitDuration() *durationpb.Duration {
	if x != nil {
		return x.WaitDuration
	}
	return nil
}

func (x *ShipmentRoute_Transition) GetTotalDuration() *durationpb.Duration {
	if x != nil {
		return x.TotalDuration
	}
	return nil
}

func (x *ShipmentRoute_Transition) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *ShipmentRoute_Transition) GetRoutePolyline() *ShipmentRoute_EncodedPolyline {
	if x != nil {
		return x.RoutePolyline
	}
	return nil
}

func (x *ShipmentRoute_Transition) GetVehicleLoads() map[string]*ShipmentRoute_VehicleLoad {
	if x != nil {
		return x.VehicleLoads
	}
	return nil
}

// Deprecated: Marked as deprecated in google/cloud/optimization/v1/fleet_routing.proto.
func (x *ShipmentRoute_Transition) GetLoads() []*CapacityQuantity {
	if x != nil {
		return x.Loads
	}
	return nil
}

// Reports the actual load of the vehicle at some point along the route,
// for a given type (see
// [Transition.vehicle_loads][google.cloud.optimization.v1.ShipmentRoute.Transition.vehicle_loads]).
type ShipmentRoute_VehicleLoad struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The amount of load on the vehicle, for the given type. The unit of load
	// is usually indicated by the type. See
	// [Transition.vehicle_loads][google.cloud.optimization.v1.ShipmentRoute.Transition.vehicle_loads].
	Amount int64 `protobuf:"varint,1,opt,name=amount,proto3" json:"amount,omitempty"`
}

func (x *ShipmentRoute_VehicleLoad) Reset() {
	*x = ShipmentRoute_VehicleLoad{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[45]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ShipmentRoute_VehicleLoad) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ShipmentRoute_VehicleLoad) ProtoMessage() {}

func (x *ShipmentRoute_VehicleLoad) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[45]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ShipmentRoute_VehicleLoad.ProtoReflect.Descriptor instead.
func (*ShipmentRoute_VehicleLoad) Descriptor() ([]byte, []int) {
	return file_google_cloud_optimization_v1_fleet_routing_proto_rawDescGZIP(), []int{17, 3}
}

func (x *ShipmentRoute_VehicleLoad) GetAmount() int64 {
	if x != nil {
		return x.Amount
	}
	return 0
}

// The encoded representation of a polyline. More information on polyline
// encoding can be found here:
// https://developers.google.com/maps/documentation/utilities/polylinealgorithm
// https://developers.google.com/maps/documentation/javascript/reference/geometry#encoding.
type ShipmentRoute_EncodedPolyline struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// String representing encoded points of the polyline.
	Points string `protobuf:"bytes,1,opt,name=points,proto3" json:"points,omitempty"`
}

func (x *ShipmentRoute_EncodedPolyline) Reset() {
	*x = ShipmentRoute_EncodedPolyline{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[46]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ShipmentRoute_EncodedPolyline) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ShipmentRoute_EncodedPolyline) ProtoMessage() {}

func (x *ShipmentRoute_EncodedPolyline) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[46]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ShipmentRoute_EncodedPolyline.ProtoReflect.Descriptor instead.
func (*ShipmentRoute_EncodedPolyline) Descriptor() ([]byte, []int) {
	return file_google_cloud_optimization_v1_fleet_routing_proto_rawDescGZIP(), []int{17, 4}
}

func (x *ShipmentRoute_EncodedPolyline) GetPoints() string {
	if x != nil {
		return x.Points
	}
	return ""
}

// Data representing the execution of a break.
type ShipmentRoute_Break struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Start time of a break.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Duration of a break.
	Duration *durationpb.Duration `protobuf:"bytes,2,opt,name=duration,proto3" json:"duration,omitempty"`
}

func (x *ShipmentRoute_Break) Reset() {
	*x = ShipmentRoute_Break{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[47]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ShipmentRoute_Break) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ShipmentRoute_Break) ProtoMessage() {}

func (x *ShipmentRoute_Break) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[47]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ShipmentRoute_Break.ProtoReflect.Descriptor instead.
func (*ShipmentRoute_Break) Descriptor() ([]byte, []int) {
	return file_google_cloud_optimization_v1_fleet_routing_proto_rawDescGZIP(), []int{17, 5}
}

func (x *ShipmentRoute_Break) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *ShipmentRoute_Break) GetDuration() *durationpb.Duration {
	if x != nil {
		return x.Duration
	}
	return nil
}

// Deprecated: Use
// [ShipmentRoute.Transition][google.cloud.optimization.v1.ShipmentRoute.Transition]
// instead. Travel between each visit along the route: from the vehicle's
// `start_location` to the first visit's `arrival_location`, then from the
// first visit's `departure_location` to the second visit's
// `arrival_location`, and so on until the vehicle's `end_location`. This
// accounts only for the actual travel between visits, not counting the
// waiting time, the time spent performing a visit, nor the distance covered
// during a visit.
//
// Invariant: `travel_steps_size() == visits_size() + 1`.
//
// If the vehicle does not have a start_ and/or end_location, the
// corresponding travel metrics are 0 and/or empty.
//
// Deprecated: Marked as deprecated in google/cloud/optimization/v1/fleet_routing.proto.
type ShipmentRoute_TravelStep struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Duration of the travel step.
	Duration *durationpb.Duration `protobuf:"bytes,1,opt,name=duration,proto3" json:"duration,omitempty"`
	// Distance traveled during the step.
	DistanceMeters float64 `protobuf:"fixed64,2,opt,name=distance_meters,json=distanceMeters,proto3" json:"distance_meters,omitempty"`
	// When traffic is requested via
	// [OptimizeToursRequest.consider_road_traffic][google.cloud.optimization.v1.OptimizeToursRequest.consider_road_traffic],
	// and the traffic info couldn't be retrieved for a TravelStep, this boolean
	// is set to true. This may be temporary (rare hiccup in the realtime
	// traffic servers) or permanent (no data for this location).
	TrafficInfoUnavailable bool `protobuf:"varint,3,opt,name=traffic_info_unavailable,json=trafficInfoUnavailable,proto3" json:"traffic_info_unavailable,omitempty"`
	// The encoded polyline representation of the route followed during the
	// step.
	//
	// This field is only populated if
	// [OptimizeToursRequest.populate_travel_step_polylines][google.cloud.optimization.v1.OptimizeToursRequest.populate_travel_step_polylines]
	// is set to true.
	RoutePolyline *ShipmentRoute_EncodedPolyline `protobuf:"bytes,4,opt,name=route_polyline,json=routePolyline,proto3" json:"route_polyline,omitempty"`
}

func (x *ShipmentRoute_TravelStep) Reset() {
	*x = ShipmentRoute_TravelStep{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[48]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ShipmentRoute_TravelStep) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ShipmentRoute_TravelStep) ProtoMessage() {}

func (x *ShipmentRoute_TravelStep) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[48]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ShipmentRoute_TravelStep.ProtoReflect.Descriptor instead.
func (*ShipmentRoute_TravelStep) Descriptor() ([]byte, []int) {
	return file_google_cloud_optimization_v1_fleet_routing_proto_rawDescGZIP(), []int{17, 6}
}

func (x *ShipmentRoute_TravelStep) GetDuration() *durationpb.Duration {
	if x != nil {
		return x.Duration
	}
	return nil
}

func (x *ShipmentRoute_TravelStep) GetDistanceMeters() float64 {
	if x != nil {
		return x.DistanceMeters
	}
	return 0
}

func (x *ShipmentRoute_TravelStep) GetTrafficInfoUnavailable() bool {
	if x != nil {
		return x.TrafficInfoUnavailable
	}
	return false
}

func (x *ShipmentRoute_TravelStep) GetRoutePolyline() *ShipmentRoute_EncodedPolyline {
	if x != nil {
		return x.RoutePolyline
	}
	return nil
}

// If we can explain why the shipment was skipped, reasons will be listed
// here. If the reason is not the same for all vehicles, `reason` will have
// more than 1 element. A skipped shipment cannot have duplicate reasons,
// i.e. where all fields are the same except for `example_vehicle_index`.
// Example:
// ```
//
//	reasons {
//	  code: DEMAND_EXCEEDS_VEHICLE_CAPACITY
//	  example_vehicle_index: 1
//	  example_exceeded_capacity_type: "Apples"
//	}
//
//	reasons {
//	  code: DEMAND_EXCEEDS_VEHICLE_CAPACITY
//	  example_vehicle_index: 3
//	  example_exceeded_capacity_type: "Pears"
//	}
//
//	reasons {
//	  code: CANNOT_BE_PERFORMED_WITHIN_VEHICLE_DISTANCE_LIMIT
//	  example_vehicle_index: 1
//	}
//
// ```
// The skipped shipment is incompatible with all vehicles. The reasons may
// be different for all vehicles but at least one vehicle's "Apples"
// capacity would be exceeded (including vehicle 1), at least one vehicle's
// "Pears" capacity would be exceeded (including vehicle 3) and at least one
// vehicle's distance limit would be exceeded (including vehicle 1).
type SkippedShipment_Reason struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Refer to the comments of Code.
	Code SkippedShipment_Reason_Code `protobuf:"varint,1,opt,name=code,proto3,enum=google.cloud.optimization.v1.SkippedShipment_Reason_Code" json:"code,omitempty"`
	// If the reason is related to a shipment-vehicle incompatibility, this
	// field provides the index of one relevant vehicle.
	ExampleVehicleIndex *int32 `protobuf:"varint,2,opt,name=example_vehicle_index,json=exampleVehicleIndex,proto3,oneof" json:"example_vehicle_index,omitempty"`
	// If the reason code is `DEMAND_EXCEEDS_VEHICLE_CAPACITY`, documents one
	// capacity type that is exceeded.
	ExampleExceededCapacityType string `protobuf:"bytes,3,opt,name=example_exceeded_capacity_type,json=exampleExceededCapacityType,proto3" json:"example_exceeded_capacity_type,omitempty"`
}

func (x *SkippedShipment_Reason) Reset() {
	*x = SkippedShipment_Reason{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[52]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SkippedShipment_Reason) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SkippedShipment_Reason) ProtoMessage() {}

func (x *SkippedShipment_Reason) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[52]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SkippedShipment_Reason.ProtoReflect.Descriptor instead.
func (*SkippedShipment_Reason) Descriptor() ([]byte, []int) {
	return file_google_cloud_optimization_v1_fleet_routing_proto_rawDescGZIP(), []int{18, 0}
}

func (x *SkippedShipment_Reason) GetCode() SkippedShipment_Reason_Code {
	if x != nil {
		return x.Code
	}
	return SkippedShipment_Reason_CODE_UNSPECIFIED
}

func (x *SkippedShipment_Reason) GetExampleVehicleIndex() int32 {
	if x != nil && x.ExampleVehicleIndex != nil {
		return *x.ExampleVehicleIndex
	}
	return 0
}

func (x *SkippedShipment_Reason) GetExampleExceededCapacityType() string {
	if x != nil {
		return x.ExampleExceededCapacityType
	}
	return ""
}

// For a group of vehicles, specifies at what threshold(s) constraints on
// visits will be relaxed and to which level. Shipments listed in
// the `skipped_shipment` field are constrained to be skipped; i.e., they
// cannot be performed.
type InjectedSolutionConstraint_ConstraintRelaxation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// All the visit constraint relaxations that will apply to visits on
	// routes with vehicles in `vehicle_indices`.
	Relaxations []*InjectedSolutionConstraint_ConstraintRelaxation_Relaxation `protobuf:"bytes,1,rep,name=relaxations,proto3" json:"relaxations,omitempty"`
	// Specifies the vehicle indices to which the visit constraint
	// `relaxations` apply. If empty, this is considered the default and the
	// `relaxations` apply to all vehicles that are not specified in other
	// `constraint_relaxations`. There can be at most one default, i.e., at
	// most one constraint relaxation field is allowed empty
	// `vehicle_indices`. A vehicle index can only be listed once, even within
	// several `constraint_relaxations`.
	//
	// A vehicle index is mapped the same as
	// [ShipmentRoute.vehicle_index][google.cloud.optimization.v1.ShipmentRoute.vehicle_index],
	// if `interpret_injected_solutions_using_labels` is true (see `fields`
	// comment).
	VehicleIndices []int32 `protobuf:"varint,2,rep,packed,name=vehicle_indices,json=vehicleIndices,proto3" json:"vehicle_indices,omitempty"`
}

func (x *InjectedSolutionConstraint_ConstraintRelaxation) Reset() {
	*x = InjectedSolutionConstraint_ConstraintRelaxation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[55]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InjectedSolutionConstraint_ConstraintRelaxation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InjectedSolutionConstraint_ConstraintRelaxation) ProtoMessage() {}

func (x *InjectedSolutionConstraint_ConstraintRelaxation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[55]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InjectedSolutionConstraint_ConstraintRelaxation.ProtoReflect.Descriptor instead.
func (*InjectedSolutionConstraint_ConstraintRelaxation) Descriptor() ([]byte, []int) {
	return file_google_cloud_optimization_v1_fleet_routing_proto_rawDescGZIP(), []int{20, 0}
}

func (x *InjectedSolutionConstraint_ConstraintRelaxation) GetRelaxations() []*InjectedSolutionConstraint_ConstraintRelaxation_Relaxation {
	if x != nil {
		return x.Relaxations
	}
	return nil
}

func (x *InjectedSolutionConstraint_ConstraintRelaxation) GetVehicleIndices() []int32 {
	if x != nil {
		return x.VehicleIndices
	}
	return nil
}

// If `relaxations` is empty, the start time and sequence of all visits
// on `routes` are fully constrained and no new visits may be inserted or
// added to those routes. Also, a vehicle's start and end time in
// `routes` is fully constrained, unless the vehicle is empty (i.e., has no
// visits and has `used_if_route_is_empty` set to false in the model).
//
// `relaxations(i).level` specifies the constraint relaxation level applied
// to a visit #j that satisfies:
//
//   - `route.visits(j).start_time >= relaxations(i).threshold_time` AND
//   - `j + 1 >= relaxations(i).threshold_visit_count`
//
// Similarly, the vehicle start is relaxed to `relaxations(i).level` if it
// satisfies:
//
//   - `vehicle_start_time >= relaxations(i).threshold_time` AND
//   - `relaxations(i).threshold_visit_count == 0`
//
// and the vehicle end is relaxed to `relaxations(i).level` if it satisfies:
//   - `vehicle_end_time >= relaxations(i).threshold_time` AND
//   - `route.visits_size() + 1 >= relaxations(i).threshold_visit_count`
//
// To apply a relaxation level if a visit meets the `threshold_visit_count`
// OR the `threshold_time` add two `relaxations` with the same `level`:
// one with only `threshold_visit_count` set and the other with only
// `threshold_time` set. If a visit satisfies the conditions of multiple
// `relaxations`, the most relaxed level applies. As a result, from the
// vehicle start through the route visits in order to the vehicle end, the
// relaxation level becomes more relaxed: i.e., the relaxation level is
// non-decreasing as the route progresses.
//
// The timing and sequence of route visits that do not satisfy the
// threshold conditions of any `relaxations` are fully constrained
// and no visits may be inserted into these sequences. Also, if a
// vehicle start or end does not satisfy the conditions of any
// relaxation the time is fixed, unless the vehicle is empty.
type InjectedSolutionConstraint_ConstraintRelaxation_Relaxation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The constraint relaxation level that applies when the conditions
	// at or after `threshold_time` AND at least `threshold_visit_count` are
	// satisfied.
	Level InjectedSolutionConstraint_ConstraintRelaxation_Relaxation_Level `protobuf:"varint,1,opt,name=level,proto3,enum=google.cloud.optimization.v1.InjectedSolutionConstraint_ConstraintRelaxation_Relaxation_Level" json:"level,omitempty"`
	// The time at or after which the relaxation `level` may be applied.
	ThresholdTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=threshold_time,json=thresholdTime,proto3" json:"threshold_time,omitempty"`
	// The number of visits at or after which the relaxation `level` may be
	// applied. If `threshold_visit_count` is 0 (or unset), the `level` may be
	// applied directly at the vehicle start.
	//
	// If it is `route.visits_size() + 1`, the `level` may only be applied to
	// the vehicle end. If it is more than `route.visits_size() + 1`,
	// `level` is not applied at all for that route.
	ThresholdVisitCount int32 `protobuf:"varint,3,opt,name=threshold_visit_count,json=thresholdVisitCount,proto3" json:"threshold_visit_count,omitempty"`
}

func (x *InjectedSolutionConstraint_ConstraintRelaxation_Relaxation) Reset() {
	*x = InjectedSolutionConstraint_ConstraintRelaxation_Relaxation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[56]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InjectedSolutionConstraint_ConstraintRelaxation_Relaxation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InjectedSolutionConstraint_ConstraintRelaxation_Relaxation) ProtoMessage() {}

func (x *InjectedSolutionConstraint_ConstraintRelaxation_Relaxation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[56]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InjectedSolutionConstraint_ConstraintRelaxation_Relaxation.ProtoReflect.Descriptor instead.
func (*InjectedSolutionConstraint_ConstraintRelaxation_Relaxation) Descriptor() ([]byte, []int) {
	return file_google_cloud_optimization_v1_fleet_routing_proto_rawDescGZIP(), []int{20, 0, 0}
}

func (x *InjectedSolutionConstraint_ConstraintRelaxation_Relaxation) GetLevel() InjectedSolutionConstraint_ConstraintRelaxation_Relaxation_Level {
	if x != nil {
		return x.Level
	}
	return InjectedSolutionConstraint_ConstraintRelaxation_Relaxation_LEVEL_UNSPECIFIED
}

func (x *InjectedSolutionConstraint_ConstraintRelaxation_Relaxation) GetThresholdTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ThresholdTime
	}
	return nil
}

func (x *InjectedSolutionConstraint_ConstraintRelaxation_Relaxation) GetThresholdVisitCount() int32 {
	if x != nil {
		return x.ThresholdVisitCount
	}
	return 0
}

// Specifies a context for the validation error. A `FieldReference` always
// refers to a given field in this file and follows the same hierarchical
// structure. For example, we may specify element #2 of `start_time_windows`
// of vehicle #5 using:
// ```
// name: "vehicles" index: 5 sub_field { name: "end_time_windows" index: 2 }
// ```
// We however omit top-level entities such as `OptimizeToursRequest` or
// `ShipmentModel` to avoid crowding the message.
type OptimizeToursValidationError_FieldReference struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the field, e.g., "vehicles".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Types that are assignable to IndexOrKey:
	//	*OptimizeToursValidationError_FieldReference_Index
	//	*OptimizeToursValidationError_FieldReference_Key
	IndexOrKey isOptimizeToursValidationError_FieldReference_IndexOrKey `protobuf_oneof:"index_or_key"`
	// Recursively nested sub-field, if needed.
	SubField *OptimizeToursValidationError_FieldReference `protobuf:"bytes,3,opt,name=sub_field,json=subField,proto3" json:"sub_field,omitempty"`
}

func (x *OptimizeToursValidationError_FieldReference) Reset() {
	*x = OptimizeToursValidationError_FieldReference{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[57]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OptimizeToursValidationError_FieldReference) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OptimizeToursValidationError_FieldReference) ProtoMessage() {}

func (x *OptimizeToursValidationError_FieldReference) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[57]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OptimizeToursValidationError_FieldReference.ProtoReflect.Descriptor instead.
func (*OptimizeToursValidationError_FieldReference) Descriptor() ([]byte, []int) {
	return file_google_cloud_optimization_v1_fleet_routing_proto_rawDescGZIP(), []int{21, 0}
}

func (x *OptimizeToursValidationError_FieldReference) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (m *OptimizeToursValidationError_FieldReference) GetIndexOrKey() isOptimizeToursValidationError_FieldReference_IndexOrKey {
	if m != nil {
		return m.IndexOrKey
	}
	return nil
}

func (x *OptimizeToursValidationError_FieldReference) GetIndex() int32 {
	if x, ok := x.GetIndexOrKey().(*OptimizeToursValidationError_FieldReference_Index); ok {
		return x.Index
	}
	return 0
}

func (x *OptimizeToursValidationError_FieldReference) GetKey() string {
	if x, ok := x.GetIndexOrKey().(*OptimizeToursValidationError_FieldReference_Key); ok {
		return x.Key
	}
	return ""
}

func (x *OptimizeToursValidationError_FieldReference) GetSubField() *OptimizeToursValidationError_FieldReference {
	if x != nil {
		return x.SubField
	}
	return nil
}

type isOptimizeToursValidationError_FieldReference_IndexOrKey interface {
	isOptimizeToursValidationError_FieldReference_IndexOrKey()
}

type OptimizeToursValidationError_FieldReference_Index struct {
	// Index of the field if repeated.
	Index int32 `protobuf:"varint,2,opt,name=index,proto3,oneof"`
}

type OptimizeToursValidationError_FieldReference_Key struct {
	// Key if the field is a map.
	Key string `protobuf:"bytes,4,opt,name=key,proto3,oneof"`
}

func (*OptimizeToursValidationError_FieldReference_Index) isOptimizeToursValidationError_FieldReference_IndexOrKey() {
}

func (*OptimizeToursValidationError_FieldReference_Key) isOptimizeToursValidationError_FieldReference_IndexOrKey() {
}

var File_google_cloud_optimization_v1_fleet_routing_proto protoreflect.FileDescriptor

var file_google_cloud_optimization_v1_fleet_routing_proto_rawDesc = []byte{
	0x0a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6f,
	0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x76, 0x31, 0x2f, 0x66,
	0x6c, 0x65, 0x65, 0x74, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69,
	0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2f, 0x76, 0x31, 0x2f, 0x61, 0x73, 0x79, 0x6e, 0x63, 0x5f, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x18,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x6c, 0x61, 0x74, 0x6c,
	0x6e, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xa3, 0x0c, 0x0a, 0x14, 0x4f, 0x70, 0x74,
	0x69, 0x6d, 0x69, 0x7a, 0x65, 0x54, 0x6f, 0x75, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x33,
	0x0a, 0x07, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x74, 0x69, 0x6d, 0x65,
	0x6f, 0x75, 0x74, 0x12, 0x41, 0x0a, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x68, 0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52,
	0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x61, 0x0a, 0x0c, 0x73, 0x6f, 0x6c, 0x76, 0x69, 0x6e,
	0x67, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x70, 0x74, 0x69,
	0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x74, 0x69,
	0x6d, 0x69, 0x7a, 0x65, 0x54, 0x6f, 0x75, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x2e, 0x53, 0x6f, 0x6c, 0x76, 0x69, 0x6e, 0x67, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x0b, 0x73, 0x6f,
	0x6c, 0x76, 0x69, 0x6e, 0x67, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x5e, 0x0a, 0x0b, 0x73, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x70,
	0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70,
	0x74, 0x69, 0x6d, 0x69, 0x7a, 0x65, 0x54, 0x6f, 0x75, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x0a, 0x73,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x70, 0x0a, 0x1e, 0x69, 0x6e, 0x6a,
	0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x66, 0x69, 0x72, 0x73, 0x74, 0x5f, 0x73, 0x6f, 0x6c, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x68, 0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x52, 0x1b,
	0x69, 0x6e, 0x6a, 0x65, 0x63, 0x74, 0x65, 0x64, 0x46, 0x69, 0x72, 0x73, 0x74, 0x53, 0x6f, 0x6c,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x12, 0x7a, 0x0a, 0x1c, 0x69,
	0x6e, 0x6a, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x49, 0x6e, 0x6a, 0x65, 0x63, 0x74, 0x65, 0x64, 0x53, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x52, 0x1a, 0x69, 0x6e, 0x6a,
	0x65, 0x63, 0x74, 0x65, 0x64, 0x53, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e,
	0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x12, 0x61, 0x0a, 0x16, 0x72, 0x65, 0x66, 0x72, 0x65,
	0x73, 0x68, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65,
	0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x68, 0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x52,
	0x6f, 0x75, 0x74, 0x65, 0x52, 0x14, 0x72, 0x65, 0x66, 0x72, 0x65, 0x73, 0x68, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x12, 0x58, 0x0a, 0x29, 0x69, 0x6e,
	0x74, 0x65, 0x72, 0x70, 0x72, 0x65, 0x74, 0x5f, 0x69, 0x6e, 0x6a, 0x65, 0x63, 0x74, 0x65, 0x64,
	0x5f, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x75, 0x73, 0x69, 0x6e, 0x67,
	0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x08, 0x52, 0x25, 0x69,
	0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x65, 0x74, 0x49, 0x6e, 0x6a, 0x65, 0x63, 0x74, 0x65, 0x64,
	0x53, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x55, 0x73, 0x69, 0x6e, 0x67, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x12, 0x32, 0x0a, 0x15, 0x63, 0x6f, 0x6e, 0x73, 0x69, 0x64, 0x65, 0x72,
	0x5f, 0x72, 0x6f, 0x61, 0x64, 0x5f, 0x74, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x18, 0x0b, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x13, 0x63, 0x6f, 0x6e, 0x73, 0x69, 0x64, 0x65, 0x72, 0x52, 0x6f, 0x61,
	0x64, 0x54, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x12, 0x2d, 0x0a, 0x12, 0x70, 0x6f, 0x70, 0x75,
	0x6c, 0x61, 0x74, 0x65, 0x5f, 0x70, 0x6f, 0x6c, 0x79, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x18, 0x0c,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x11, 0x70, 0x6f, 0x70, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x50, 0x6f,
	0x6c, 0x79, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x12, 0x42, 0x0a, 0x1d, 0x70, 0x6f, 0x70, 0x75, 0x6c,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70,
	0x6f, 0x6c, 0x79, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x08, 0x52, 0x1b,
	0x70, 0x6f, 0x70, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x79, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x12, 0x61, 0x0a, 0x2e, 0x61,
	0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x6c, 0x61, 0x72, 0x67, 0x65, 0x5f, 0x64, 0x65, 0x61, 0x64, 0x6c,
	0x69, 0x6e, 0x65, 0x5f, 0x64, 0x65, 0x73, 0x70, 0x69, 0x74, 0x65, 0x5f, 0x69, 0x6e, 0x74, 0x65,
	0x72, 0x72, 0x75, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x69, 0x73, 0x6b, 0x18, 0x0e, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x29, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x4c, 0x61, 0x72, 0x67, 0x65, 0x44,
	0x65, 0x61, 0x64, 0x6c, 0x69, 0x6e, 0x65, 0x44, 0x65, 0x73, 0x70, 0x69, 0x74, 0x65, 0x49, 0x6e,
	0x74, 0x65, 0x72, 0x72, 0x75, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x69, 0x73, 0x6b, 0x12, 0x34,
	0x0a, 0x16, 0x75, 0x73, 0x65, 0x5f, 0x67, 0x65, 0x6f, 0x64, 0x65, 0x73, 0x69, 0x63, 0x5f, 0x64,
	0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x08, 0x52, 0x14,
	0x75, 0x73, 0x65, 0x47, 0x65, 0x6f, 0x64, 0x65, 0x73, 0x69, 0x63, 0x44, 0x69, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x73, 0x12, 0x40, 0x0a, 0x1a, 0x67, 0x65, 0x6f, 0x64, 0x65, 0x73, 0x69, 0x63,
	0x5f, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x73, 0x65, 0x63, 0x6f,
	0x6e, 0x64, 0x18, 0x10, 0x20, 0x01, 0x28, 0x01, 0x48, 0x00, 0x52, 0x17, 0x67, 0x65, 0x6f, 0x64,
	0x65, 0x73, 0x69, 0x63, 0x4d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x50, 0x65, 0x72, 0x53, 0x65, 0x63,
	0x6f, 0x6e, 0x64, 0x88, 0x01, 0x01, 0x12, 0x37, 0x0a, 0x15, 0x6d, 0x61, 0x78, 0x5f, 0x76, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x05, 0x48, 0x01, 0x52, 0x13, 0x6d, 0x61, 0x78, 0x56, 0x61, 0x6c, 0x69,
	0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x88, 0x01, 0x01, 0x12,
	0x14, 0x0a, 0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x11, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x12, 0x47, 0x0a, 0x1e, 0x70, 0x6f, 0x70, 0x75, 0x6c, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x72, 0x61, 0x76, 0x65, 0x6c, 0x5f, 0x73, 0x74, 0x65, 0x70, 0x5f, 0x70, 0x6f,
	0x6c, 0x79, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x18, 0x14, 0x20, 0x01, 0x28, 0x08, 0x42, 0x02, 0x18,
	0x01, 0x52, 0x1b, 0x70, 0x6f, 0x70, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x54, 0x72, 0x61, 0x76, 0x65,
	0x6c, 0x53, 0x74, 0x65, 0x70, 0x50, 0x6f, 0x6c, 0x79, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x22, 0x59,
	0x0a, 0x0b, 0x53, 0x6f, 0x6c, 0x76, 0x69, 0x6e, 0x67, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x11, 0x0a,
	0x0d, 0x44, 0x45, 0x46, 0x41, 0x55, 0x4c, 0x54, 0x5f, 0x53, 0x4f, 0x4c, 0x56, 0x45, 0x10, 0x00,
	0x12, 0x11, 0x0a, 0x0d, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x41, 0x54, 0x45, 0x5f, 0x4f, 0x4e, 0x4c,
	0x59, 0x10, 0x01, 0x12, 0x24, 0x0a, 0x20, 0x44, 0x45, 0x54, 0x45, 0x43, 0x54, 0x5f, 0x53, 0x4f,
	0x4d, 0x45, 0x5f, 0x49, 0x4e, 0x46, 0x45, 0x41, 0x53, 0x49, 0x42, 0x4c, 0x45, 0x5f, 0x53, 0x48,
	0x49, 0x50, 0x4d, 0x45, 0x4e, 0x54, 0x53, 0x10, 0x02, 0x22, 0x5a, 0x0a, 0x0a, 0x53, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x1b, 0x0a, 0x17, 0x53, 0x45, 0x41, 0x52, 0x43,
	0x48, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x52, 0x45, 0x54, 0x55, 0x52, 0x4e, 0x5f, 0x46,
	0x41, 0x53, 0x54, 0x10, 0x01, 0x12, 0x1e, 0x0a, 0x1a, 0x43, 0x4f, 0x4e, 0x53, 0x55, 0x4d, 0x45,
	0x5f, 0x41, 0x4c, 0x4c, 0x5f, 0x41, 0x56, 0x41, 0x49, 0x4c, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x54,
	0x49, 0x4d, 0x45, 0x10, 0x02, 0x42, 0x1d, 0x0a, 0x1b, 0x5f, 0x67, 0x65, 0x6f, 0x64, 0x65, 0x73,
	0x69, 0x63, 0x5f, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x73, 0x65,
	0x63, 0x6f, 0x6e, 0x64, 0x42, 0x18, 0x0a, 0x16, 0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x76, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x22, 0x93,
	0x08, 0x0a, 0x15, 0x4f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x65, 0x54, 0x6f, 0x75, 0x72, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x43, 0x0a, 0x06, 0x72, 0x6f, 0x75, 0x74,
	0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x68, 0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74,
	0x52, 0x6f, 0x75, 0x74, 0x65, 0x52, 0x06, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x12, 0x23, 0x0a,
	0x0d, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x12, 0x5a, 0x0a, 0x11, 0x73, 0x6b, 0x69, 0x70, 0x70, 0x65, 0x64, 0x5f, 0x73, 0x68,
	0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x70, 0x74,
	0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6b, 0x69,
	0x70, 0x70, 0x65, 0x64, 0x53, 0x68, 0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x10, 0x73, 0x6b,
	0x69, 0x70, 0x70, 0x65, 0x64, 0x53, 0x68, 0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x67,
	0x0a, 0x11, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x72, 0x72,
	0x6f, 0x72, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a,
	0x65, 0x54, 0x6f, 0x75, 0x72, 0x73, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x45, 0x72, 0x72, 0x6f, 0x72, 0x52, 0x10, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x12, 0x55, 0x0a, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x65,
	0x54, 0x6f, 0x75, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x4d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x21,
	0x0a, 0x0a, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x63, 0x6f, 0x73, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x01, 0x42, 0x02, 0x18, 0x01, 0x52, 0x09, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x43, 0x6f, 0x73,
	0x74, 0x1a, 0xd0, 0x04, 0x0a, 0x07, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x69, 0x0a,
	0x18, 0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x72, 0x6f, 0x75, 0x74,
	0x65, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f,
	0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x65, 0x64, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73,
	0x52, 0x16, 0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x65, 0x64, 0x52, 0x6f, 0x75, 0x74,
	0x65, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x47, 0x0a, 0x20, 0x73, 0x6b, 0x69, 0x70,
	0x70, 0x65, 0x64, 0x5f, 0x6d, 0x61, 0x6e, 0x64, 0x61, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x73, 0x68,
	0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x1d, 0x73, 0x6b, 0x69, 0x70, 0x70, 0x65, 0x64, 0x4d, 0x61, 0x6e, 0x64, 0x61,
	0x74, 0x6f, 0x72, 0x79, 0x53, 0x68, 0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x75, 0x6e,
	0x74, 0x12, 0x2c, 0x0a, 0x12, 0x75, 0x73, 0x65, 0x64, 0x5f, 0x76, 0x65, 0x68, 0x69, 0x63, 0x6c,
	0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x10, 0x75,
	0x73, 0x65, 0x64, 0x56, 0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12,
	0x59, 0x0a, 0x1b, 0x65, 0x61, 0x72, 0x6c, 0x69, 0x65, 0x73, 0x74, 0x5f, 0x76, 0x65, 0x68, 0x69,
	0x63, 0x6c, 0x65, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x18, 0x65, 0x61, 0x72, 0x6c, 0x69, 0x65, 0x73, 0x74, 0x56, 0x65, 0x68, 0x69, 0x63, 0x6c,
	0x65, 0x53, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x51, 0x0a, 0x17, 0x6c, 0x61,
	0x74, 0x65, 0x73, 0x74, 0x5f, 0x76, 0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x5f, 0x65, 0x6e, 0x64,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x14, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x56,
	0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x45, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x5c, 0x0a,
	0x05, 0x63, 0x6f, 0x73, 0x74, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x70, 0x74, 0x69,
	0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x74, 0x69,
	0x6d, 0x69, 0x7a, 0x65, 0x54, 0x6f, 0x75, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x43, 0x6f, 0x73, 0x74, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x52, 0x05, 0x63, 0x6f, 0x73, 0x74, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x74,
	0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x63, 0x6f, 0x73, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x01, 0x52,
	0x09, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x43, 0x6f, 0x73, 0x74, 0x1a, 0x38, 0x0a, 0x0a, 0x43, 0x6f,
	0x73, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x22, 0xbc, 0x03, 0x0a, 0x19, 0x42, 0x61, 0x74, 0x63, 0x68, 0x4f, 0x70,
	0x74, 0x69, 0x6d, 0x69, 0x7a, 0x65, 0x54, 0x6f, 0x75, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x72, 0x0a, 0x0d, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x4f, 0x70, 0x74, 0x69, 0x6d,
	0x69, 0x7a, 0x65, 0x54, 0x6f, 0x75, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e,
	0x41, 0x73, 0x79, 0x6e, 0x63, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x73, 0x1a, 0x8d, 0x02, 0x0a, 0x10, 0x41, 0x73, 0x79, 0x6e, 0x63, 0x4d, 0x6f, 0x64,
	0x65, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x51, 0x0a, 0x0c, 0x69,
	0x6e, 0x70, 0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0b, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x54,
	0x0a, 0x0d, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x2d, 0x0a, 0x12, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63,
	0x68, 0x65, 0x63, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x11, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x70, 0x6f, 0x69,
	0x6e, 0x74, 0x73, 0x22, 0x1c, 0x0a, 0x1a, 0x42, 0x61, 0x74, 0x63, 0x68, 0x4f, 0x70, 0x74, 0x69,
	0x6d, 0x69, 0x7a, 0x65, 0x54, 0x6f, 0x75, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0xb8, 0x13, 0x0a, 0x0d, 0x53, 0x68, 0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x4d, 0x6f,
	0x64, 0x65, 0x6c, 0x12, 0x44, 0x0a, 0x09, 0x73, 0x68, 0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x68, 0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x09,
	0x73, 0x68, 0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x41, 0x0a, 0x08, 0x76, 0x65, 0x68,
	0x69, 0x63, 0x6c, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x70, 0x74, 0x69, 0x6d,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x65, 0x68, 0x69, 0x63,
	0x6c, 0x65, 0x52, 0x08, 0x76, 0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x73, 0x12, 0x33, 0x0a, 0x13,
	0x6d, 0x61, 0x78, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x76, 0x65, 0x68, 0x69, 0x63,
	0x6c, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x48, 0x00, 0x52, 0x11, 0x6d, 0x61, 0x78,
	0x41, 0x63, 0x74, 0x69, 0x76, 0x65, 0x56, 0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x73, 0x88, 0x01,
	0x01, 0x12, 0x46, 0x0a, 0x11, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x5f, 0x73, 0x74, 0x61, 0x72,
	0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0f, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c,
	0x53, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x42, 0x0a, 0x0f, 0x67, 0x6c, 0x6f,
	0x62, 0x61, 0x6c, 0x5f, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0d,
	0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x45, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a,
	0x1d, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x63, 0x6f, 0x73, 0x74, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x68, 0x6f, 0x75, 0x72, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x01, 0x52, 0x19, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x44, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x73, 0x74, 0x50, 0x65, 0x72, 0x48, 0x6f, 0x75, 0x72, 0x12,
	0x80, 0x01, 0x0a, 0x1a, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x69, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6d, 0x61, 0x74, 0x72, 0x69, 0x63, 0x65, 0x73, 0x18, 0x08,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x68, 0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x69, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x4d, 0x61, 0x74, 0x72, 0x69, 0x78, 0x52, 0x18, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x44, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4d, 0x61, 0x74, 0x72, 0x69, 0x63,
	0x65, 0x73, 0x12, 0x48, 0x0a, 0x21, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64,
	0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6d, 0x61, 0x74, 0x72, 0x69, 0x78, 0x5f, 0x73,
	0x72, 0x63, 0x5f, 0x74, 0x61, 0x67, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x09, 0x52, 0x1d, 0x64,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4d,
	0x61, 0x74, 0x72, 0x69, 0x78, 0x53, 0x72, 0x63, 0x54, 0x61, 0x67, 0x73, 0x12, 0x48, 0x0a, 0x21,
	0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x5f, 0x6d, 0x61, 0x74, 0x72, 0x69, 0x78, 0x5f, 0x64, 0x73, 0x74, 0x5f, 0x74, 0x61, 0x67,
	0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x09, 0x52, 0x1d, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x44, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4d, 0x61, 0x74, 0x72, 0x69, 0x78, 0x44,
	0x73, 0x74, 0x54, 0x61, 0x67, 0x73, 0x12, 0x67, 0x0a, 0x15, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18,
	0x0b, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x41,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x52, 0x14, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12,
	0x81, 0x01, 0x0a, 0x1f, 0x73, 0x68, 0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x5f, 0x69, 0x6e, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x74, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74,
	0x69, 0x65, 0x73, 0x18, 0x0c, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x68, 0x69, 0x70, 0x6d, 0x65, 0x6e,
	0x74, 0x54, 0x79, 0x70, 0x65, 0x49, 0x6e, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x74, 0x69, 0x62, 0x69,
	0x6c, 0x69, 0x74, 0x79, 0x52, 0x1d, 0x73, 0x68, 0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x54, 0x79,
	0x70, 0x65, 0x49, 0x6e, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x74, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74,
	0x69, 0x65, 0x73, 0x12, 0x73, 0x0a, 0x1a, 0x73, 0x68, 0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x18, 0x0d, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x68, 0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x54,
	0x79, 0x70, 0x65, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x18,
	0x73, 0x68, 0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x65, 0x0a, 0x10, 0x70, 0x72, 0x65, 0x63,
	0x65, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x0e, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x68, 0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e,
	0x50, 0x72, 0x65, 0x63, 0x65, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x0f,
	0x70, 0x72, 0x65, 0x63, 0x65, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x12,
	0x5a, 0x0a, 0x0b, 0x62, 0x72, 0x65, 0x61, 0x6b, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x0f,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x68, 0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x2e, 0x42, 0x72, 0x65, 0x61, 0x6b, 0x52, 0x75, 0x6c, 0x65, 0x42, 0x02, 0x18, 0x01, 0x52,
	0x0a, 0x62, 0x72, 0x65, 0x61, 0x6b, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x1a, 0xf8, 0x01, 0x0a, 0x16,
	0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x4d, 0x61, 0x74, 0x72, 0x69, 0x78, 0x12, 0x5a, 0x0a, 0x04, 0x72, 0x6f, 0x77, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x68, 0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x69, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x4d, 0x61, 0x74, 0x72, 0x69, 0x78, 0x2e, 0x52, 0x6f, 0x77, 0x52, 0x04, 0x72, 0x6f,
	0x77, 0x73, 0x12, 0x2a, 0x0a, 0x11, 0x76, 0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x5f, 0x73, 0x74,
	0x61, 0x72, 0x74, 0x5f, 0x74, 0x61, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x76,
	0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x53, 0x74, 0x61, 0x72, 0x74, 0x54, 0x61, 0x67, 0x1a, 0x56,
	0x0a, 0x03, 0x52, 0x6f, 0x77, 0x12, 0x37, 0x0a, 0x09, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x09, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x16,
	0x0a, 0x06, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x01, 0x52, 0x06,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x1a, 0x9d, 0x02, 0x0a, 0x0e, 0x50, 0x72, 0x65, 0x63, 0x65,
	0x64, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x24, 0x0a, 0x0b, 0x66, 0x69, 0x72,
	0x73, 0x74, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x48, 0x00,
	0x52, 0x0a, 0x66, 0x69, 0x72, 0x73, 0x74, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x88, 0x01, 0x01, 0x12,
	0x2a, 0x0a, 0x11, 0x66, 0x69, 0x72, 0x73, 0x74, 0x5f, 0x69, 0x73, 0x5f, 0x64, 0x65, 0x6c, 0x69,
	0x76, 0x65, 0x72, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f, 0x66, 0x69, 0x72, 0x73,
	0x74, 0x49, 0x73, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x12, 0x26, 0x0a, 0x0c, 0x73,
	0x65, 0x63, 0x6f, 0x6e, 0x64, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x48, 0x01, 0x52, 0x0b, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x49, 0x6e, 0x64, 0x65, 0x78,
	0x88, 0x01, 0x01, 0x12, 0x2c, 0x0a, 0x12, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x5f, 0x69, 0x73,
	0x5f, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x10, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x49, 0x73, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72,
	0x79, 0x12, 0x42, 0x0a, 0x0f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x5f, 0x64, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0e, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x44, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x66, 0x69, 0x72, 0x73, 0x74, 0x5f,
	0x69, 0x6e, 0x64, 0x65, 0x78, 0x42, 0x0f, 0x0a, 0x0d, 0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64,
	0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x1a, 0xab, 0x05, 0x0a, 0x09, 0x42, 0x72, 0x65, 0x61, 0x6b,
	0x52, 0x75, 0x6c, 0x65, 0x12, 0x69, 0x0a, 0x0e, 0x62, 0x72, 0x65, 0x61, 0x6b, 0x5f, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x70, 0x74, 0x69,
	0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x68, 0x69, 0x70,
	0x6d, 0x65, 0x6e, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x42, 0x72, 0x65, 0x61, 0x6b, 0x52,
	0x75, 0x6c, 0x65, 0x2e, 0x42, 0x72, 0x65, 0x61, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x52, 0x0d, 0x62, 0x72, 0x65, 0x61, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x12,
	0x7e, 0x0a, 0x15, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x63, 0x6f, 0x6e,
	0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x49,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x70,
	0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x68,
	0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x42, 0x72, 0x65, 0x61,
	0x6b, 0x52, 0x75, 0x6c, 0x65, 0x2e, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x43,
	0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x52, 0x14, 0x66, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x6e, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x73, 0x1a,
	0xef, 0x01, 0x0a, 0x0c, 0x42, 0x72, 0x65, 0x61, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x4f, 0x0a, 0x13, 0x65, 0x61, 0x72, 0x6c, 0x69, 0x65, 0x73, 0x74, 0x5f, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x11,
	0x65, 0x61, 0x72, 0x6c, 0x69, 0x65, 0x73, 0x74, 0x53, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x4b, 0x0a, 0x11, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x72,
	0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x6c,
	0x61, 0x74, 0x65, 0x73, 0x74, 0x53, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x41,
	0x0a, 0x0c, 0x6d, 0x69, 0x6e, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x6d, 0x69, 0x6e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x1a, 0xbc, 0x01, 0x0a, 0x13, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x43,
	0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x12, 0x4c, 0x0a, 0x12, 0x6d, 0x69, 0x6e,
	0x5f, 0x62, 0x72, 0x65, 0x61, 0x6b, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x6d, 0x69, 0x6e, 0x42, 0x72, 0x65, 0x61, 0x6b, 0x44,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x57, 0x0a, 0x18, 0x6d, 0x61, 0x78, 0x5f, 0x69,
	0x6e, 0x74, 0x65, 0x72, 0x5f, 0x62, 0x72, 0x65, 0x61, 0x6b, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x15, 0x6d, 0x61, 0x78, 0x49, 0x6e,
	0x74, 0x65, 0x72, 0x42, 0x72, 0x65, 0x61, 0x6b, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x3a, 0x02, 0x18, 0x01, 0x42, 0x16, 0x0a, 0x14, 0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x61, 0x63, 0x74,
	0x69, 0x76, 0x65, 0x5f, 0x76, 0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x73, 0x22, 0xae, 0x0f, 0x0a,
	0x08, 0x53, 0x68, 0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x4d, 0x0a, 0x07, 0x70, 0x69, 0x63,
	0x6b, 0x75, 0x70, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x68, 0x69, 0x70, 0x6d, 0x65,
	0x6e, 0x74, 0x2e, 0x56, 0x69, 0x73, 0x69, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52,
	0x07, 0x70, 0x69, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x12, 0x53, 0x0a, 0x0a, 0x64, 0x65, 0x6c, 0x69,
	0x76, 0x65, 0x72, 0x69, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x70, 0x74, 0x69,
	0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x68, 0x69, 0x70,
	0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x56, 0x69, 0x73, 0x69, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x52, 0x0a, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x69, 0x65, 0x73, 0x12, 0x5a, 0x0a,
	0x0c, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x64, 0x65, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x18, 0x0e, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x68, 0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x4c, 0x6f, 0x61, 0x64,
	0x44, 0x65, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0b, 0x6c, 0x6f,
	0x61, 0x64, 0x44, 0x65, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x12, 0x26, 0x0a, 0x0c, 0x70, 0x65, 0x6e,
	0x61, 0x6c, 0x74, 0x79, 0x5f, 0x63, 0x6f, 0x73, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x01, 0x48,
	0x00, 0x52, 0x0b, 0x70, 0x65, 0x6e, 0x61, 0x6c, 0x74, 0x79, 0x43, 0x6f, 0x73, 0x74, 0x88, 0x01,
	0x01, 0x12, 0x36, 0x0a, 0x17, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x5f, 0x76, 0x65, 0x68,
	0x69, 0x63, 0x6c, 0x65, 0x5f, 0x69, 0x6e, 0x64, 0x69, 0x63, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03,
	0x28, 0x05, 0x52, 0x15, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x56, 0x65, 0x68, 0x69, 0x63,
	0x6c, 0x65, 0x49, 0x6e, 0x64, 0x69, 0x63, 0x65, 0x73, 0x12, 0x2a, 0x0a, 0x11, 0x63, 0x6f, 0x73,
	0x74, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x76, 0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x18, 0x06,
	0x20, 0x03, 0x28, 0x01, 0x52, 0x0f, 0x63, 0x6f, 0x73, 0x74, 0x73, 0x50, 0x65, 0x72, 0x56, 0x65,
	0x68, 0x69, 0x63, 0x6c, 0x65, 0x12, 0x39, 0x0a, 0x19, 0x63, 0x6f, 0x73, 0x74, 0x73, 0x5f, 0x70,
	0x65, 0x72, 0x5f, 0x76, 0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x5f, 0x69, 0x6e, 0x64, 0x69, 0x63,
	0x65, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x05, 0x52, 0x16, 0x63, 0x6f, 0x73, 0x74, 0x73, 0x50,
	0x65, 0x72, 0x56, 0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x49, 0x6e, 0x64, 0x69, 0x63, 0x65, 0x73,
	0x12, 0x5a, 0x0a, 0x28, 0x70, 0x69, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x74, 0x6f, 0x5f, 0x64, 0x65,
	0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x5f, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f,
	0x64, 0x65, 0x74, 0x6f, 0x75, 0x72, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x01, 0x48, 0x01, 0x52, 0x23, 0x70, 0x69, 0x63, 0x6b, 0x75, 0x70, 0x54, 0x6f, 0x44, 0x65,
	0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65, 0x44, 0x65,
	0x74, 0x6f, 0x75, 0x72, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x88, 0x01, 0x01, 0x12, 0x70, 0x0a, 0x28,
	0x70, 0x69, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x74, 0x6f, 0x5f, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65,
	0x72, 0x79, 0x5f, 0x61, 0x62, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x65, 0x5f, 0x64, 0x65, 0x74, 0x6f,
	0x75, 0x72, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x23, 0x70, 0x69, 0x63, 0x6b, 0x75,
	0x70, 0x54, 0x6f, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x41, 0x62, 0x73, 0x6f, 0x6c,
	0x75, 0x74, 0x65, 0x44, 0x65, 0x74, 0x6f, 0x75, 0x72, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x12, 0x5b,
	0x0a, 0x1d, 0x70, 0x69, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x74, 0x6f, 0x5f, 0x64, 0x65, 0x6c, 0x69,
	0x76, 0x65, 0x72, 0x79, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18,
	0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x19, 0x70, 0x69, 0x63, 0x6b, 0x75, 0x70, 0x54, 0x6f, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65,
	0x72, 0x79, 0x54, 0x69, 0x6d, 0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x73,
	0x68, 0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0b, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0c, 0x73, 0x68, 0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x14, 0x0a, 0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x12, 0x16, 0x0a, 0x06, 0x69, 0x67, 0x6e, 0x6f, 0x72, 0x65,
	0x18, 0x0d, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x69, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x12, 0x4c,
	0x0a, 0x07, 0x64, 0x65, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f,
	0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x51, 0x75, 0x61, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x42,
	0x02, 0x18, 0x01, 0x52, 0x07, 0x64, 0x65, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x1a, 0xc3, 0x06, 0x0a,
	0x0c, 0x56, 0x69, 0x73, 0x69, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a,
	0x10, 0x61, 0x72, 0x72, 0x69, 0x76, 0x61, 0x6c, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x4c, 0x61, 0x74, 0x4c, 0x6e, 0x67, 0x52, 0x0f, 0x61, 0x72,
	0x72, 0x69, 0x76, 0x61, 0x6c, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x51, 0x0a,
	0x10, 0x61, 0x72, 0x72, 0x69, 0x76, 0x61, 0x6c, 0x5f, 0x77, 0x61, 0x79, 0x70, 0x6f, 0x69, 0x6e,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x61, 0x79, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x52,
	0x0f, 0x61, 0x72, 0x72, 0x69, 0x76, 0x61, 0x6c, 0x57, 0x61, 0x79, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x12, 0x42, 0x0a, 0x12, 0x64, 0x65, 0x70, 0x61, 0x72, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x4c, 0x61, 0x74, 0x4c, 0x6e,
	0x67, 0x52, 0x11, 0x64, 0x65, 0x70, 0x61, 0x72, 0x74, 0x75, 0x72, 0x65, 0x4c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x55, 0x0a, 0x12, 0x64, 0x65, 0x70, 0x61, 0x72, 0x74, 0x75, 0x72,
	0x65, 0x5f, 0x77, 0x61, 0x79, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x57, 0x61, 0x79, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x11, 0x64, 0x65, 0x70, 0x61, 0x72, 0x74,
	0x75, 0x72, 0x65, 0x57, 0x61, 0x79, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x74,
	0x61, 0x67, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x04, 0x74, 0x61, 0x67, 0x73, 0x12,
	0x4b, 0x0a, 0x0c, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x18,
	0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x52,
	0x0b, 0x74, 0x69, 0x6d, 0x65, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x12, 0x35, 0x0a, 0x08,
	0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x64, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x63, 0x6f, 0x73, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x01, 0x52, 0x04, 0x63, 0x6f, 0x73, 0x74, 0x12, 0x67, 0x0a, 0x0c, 0x6c, 0x6f, 0x61, 0x64, 0x5f,
	0x64, 0x65, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x18, 0x0c, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x44, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x70, 0x74,
	0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x68, 0x69,
	0x70, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x56, 0x69, 0x73, 0x69, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x2e, 0x4c, 0x6f, 0x61, 0x64, 0x44, 0x65, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x0b, 0x6c, 0x6f, 0x61, 0x64, 0x44, 0x65, 0x6d, 0x61, 0x6e, 0x64, 0x73,
	0x12, 0x1f, 0x0a, 0x0b, 0x76, 0x69, 0x73, 0x69, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18,
	0x0a, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x76, 0x69, 0x73, 0x69, 0x74, 0x54, 0x79, 0x70, 0x65,
	0x73, 0x12, 0x14, 0x0a, 0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x12, 0x4c, 0x0a, 0x07, 0x64, 0x65, 0x6d, 0x61, 0x6e,
	0x64, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79,
	0x51, 0x75, 0x61, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x42, 0x02, 0x18, 0x01, 0x52, 0x07, 0x64, 0x65,
	0x6d, 0x61, 0x6e, 0x64, 0x73, 0x1a, 0x6b, 0x0a, 0x10, 0x4c, 0x6f, 0x61, 0x64, 0x44, 0x65, 0x6d,
	0x61, 0x6e, 0x64, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x41, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x68, 0x69, 0x70, 0x6d, 0x65,
	0x6e, 0x74, 0x2e, 0x4c, 0x6f, 0x61, 0x64, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x1a, 0x1e, 0x0a, 0x04, 0x4c, 0x6f, 0x61, 0x64, 0x12, 0x16, 0x0a, 0x06, 0x61, 0x6d,
	0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x06, 0x61, 0x6d, 0x6f, 0x75,
	0x6e, 0x74, 0x1a, 0x6b, 0x0a, 0x10, 0x4c, 0x6f, 0x61, 0x64, 0x44, 0x65, 0x6d, 0x61, 0x6e, 0x64,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x41, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x68, 0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x2e,
	0x4c, 0x6f, 0x61, 0x64, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x42,
	0x0f, 0x0a, 0x0d, 0x5f, 0x70, 0x65, 0x6e, 0x61, 0x6c, 0x74, 0x79, 0x5f, 0x63, 0x6f, 0x73, 0x74,
	0x42, 0x2b, 0x0a, 0x29, 0x5f, 0x70, 0x69, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x74, 0x6f, 0x5f, 0x64,
	0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x5f, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65,
	0x5f, 0x64, 0x65, 0x74, 0x6f, 0x75, 0x72, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x22, 0xbf, 0x02,
	0x0a, 0x1b, 0x53, 0x68, 0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x49, 0x6e,
	0x63, 0x6f, 0x6d, 0x70, 0x61, 0x74, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x14, 0x0a,
	0x05, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x05, 0x74, 0x79,
	0x70, 0x65, 0x73, 0x12, 0x80, 0x01, 0x0a, 0x14, 0x69, 0x6e, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x74,
	0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x68, 0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x49, 0x6e,
	0x63, 0x6f, 0x6d, 0x70, 0x61, 0x74, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x2e, 0x49, 0x6e,
	0x63, 0x6f, 0x6d, 0x70, 0x61, 0x74, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x4d, 0x6f, 0x64,
	0x65, 0x52, 0x13, 0x69, 0x6e, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x74, 0x69, 0x62, 0x69, 0x6c, 0x69,
	0x74, 0x79, 0x4d, 0x6f, 0x64, 0x65, 0x22, 0x86, 0x01, 0x0a, 0x13, 0x49, 0x6e, 0x63, 0x6f, 0x6d,
	0x70, 0x61, 0x74, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x24,
	0x0a, 0x20, 0x49, 0x4e, 0x43, 0x4f, 0x4d, 0x50, 0x41, 0x54, 0x49, 0x42, 0x49, 0x4c, 0x49, 0x54,
	0x59, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x21, 0x0a, 0x1d, 0x4e, 0x4f, 0x54, 0x5f, 0x50, 0x45, 0x52, 0x46,
	0x4f, 0x52, 0x4d, 0x45, 0x44, 0x5f, 0x42, 0x59, 0x5f, 0x53, 0x41, 0x4d, 0x45, 0x5f, 0x56, 0x45,
	0x48, 0x49, 0x43, 0x4c, 0x45, 0x10, 0x01, 0x12, 0x26, 0x0a, 0x22, 0x4e, 0x4f, 0x54, 0x5f, 0x49,
	0x4e, 0x5f, 0x53, 0x41, 0x4d, 0x45, 0x5f, 0x56, 0x45, 0x48, 0x49, 0x43, 0x4c, 0x45, 0x5f, 0x53,
	0x49, 0x4d, 0x55, 0x4c, 0x54, 0x41, 0x4e, 0x45, 0x4f, 0x55, 0x53, 0x4c, 0x59, 0x10, 0x02, 0x22,
	0xb3, 0x03, 0x0a, 0x17, 0x53, 0x68, 0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x4d, 0x0a, 0x23, 0x72,
	0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x73, 0x68, 0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x61, 0x6c, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x74, 0x69, 0x76,
	0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x20, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72,
	0x65, 0x64, 0x53, 0x68, 0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x41, 0x6c,
	0x74, 0x65, 0x72, 0x6e, 0x61, 0x74, 0x69, 0x76, 0x65, 0x73, 0x12, 0x38, 0x0a, 0x18, 0x64, 0x65,
	0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x68, 0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x16, 0x64, 0x65,
	0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x74, 0x53, 0x68, 0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x54,
	0x79, 0x70, 0x65, 0x73, 0x12, 0x70, 0x0a, 0x10, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x45,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x70,
	0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x68,
	0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x0f, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x22, 0x9c, 0x01, 0x0a, 0x0f, 0x52, 0x65, 0x71, 0x75, 0x69,
	0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x20, 0x0a, 0x1c, 0x52, 0x45,
	0x51, 0x55, 0x49, 0x52, 0x45, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1d, 0x0a, 0x19,
	0x50, 0x45, 0x52, 0x46, 0x4f, 0x52, 0x4d, 0x45, 0x44, 0x5f, 0x42, 0x59, 0x5f, 0x53, 0x41, 0x4d,
	0x45, 0x5f, 0x56, 0x45, 0x48, 0x49, 0x43, 0x4c, 0x45, 0x10, 0x01, 0x12, 0x22, 0x0a, 0x1e, 0x49,
	0x4e, 0x5f, 0x53, 0x41, 0x4d, 0x45, 0x5f, 0x56, 0x45, 0x48, 0x49, 0x43, 0x4c, 0x45, 0x5f, 0x41,
	0x54, 0x5f, 0x50, 0x49, 0x43, 0x4b, 0x55, 0x50, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x10, 0x02, 0x12,
	0x24, 0x0a, 0x20, 0x49, 0x4e, 0x5f, 0x53, 0x41, 0x4d, 0x45, 0x5f, 0x56, 0x45, 0x48, 0x49, 0x43,
	0x4c, 0x45, 0x5f, 0x41, 0x54, 0x5f, 0x44, 0x45, 0x4c, 0x49, 0x56, 0x45, 0x52, 0x59, 0x5f, 0x54,
	0x49, 0x4d, 0x45, 0x10, 0x03, 0x22, 0xfa, 0x19, 0x0a, 0x07, 0x56, 0x65, 0x68, 0x69, 0x63, 0x6c,
	0x65, 0x12, 0x51, 0x0a, 0x0b, 0x74, 0x72, 0x61, 0x76, 0x65, 0x6c, 0x5f, 0x6d, 0x6f, 0x64, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x2e, 0x54, 0x72,
	0x61, 0x76, 0x65, 0x6c, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x0a, 0x74, 0x72, 0x61, 0x76, 0x65, 0x6c,
	0x4d, 0x6f, 0x64, 0x65, 0x12, 0x3a, 0x0a, 0x0e, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x4c, 0x61, 0x74, 0x4c, 0x6e,
	0x67, 0x52, 0x0d, 0x73, 0x74, 0x61, 0x72, 0x74, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x4d, 0x0a, 0x0e, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x77, 0x61, 0x79, 0x70, 0x6f, 0x69,
	0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x61, 0x79, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x52, 0x0d, 0x73, 0x74, 0x61, 0x72, 0x74, 0x57, 0x61, 0x79, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12,
	0x36, 0x0a, 0x0c, 0x65, 0x6e, 0x64, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74,
	0x79, 0x70, 0x65, 0x2e, 0x4c, 0x61, 0x74, 0x4c, 0x6e, 0x67, 0x52, 0x0b, 0x65, 0x6e, 0x64, 0x4c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x49, 0x0a, 0x0c, 0x65, 0x6e, 0x64, 0x5f, 0x77,
	0x61, 0x79, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x70, 0x74,
	0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x61, 0x79,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x0b, 0x65, 0x6e, 0x64, 0x57, 0x61, 0x79, 0x70, 0x6f, 0x69,
	0x6e, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x61, 0x67, 0x73,
	0x18, 0x07, 0x20, 0x03, 0x28, 0x09, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x61, 0x67,
	0x73, 0x12, 0x19, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x61, 0x67, 0x73, 0x18, 0x08, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x61, 0x67, 0x73, 0x12, 0x56, 0x0a, 0x12,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x77, 0x69, 0x6e, 0x64, 0x6f,
	0x77, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x57, 0x69, 0x6e, 0x64,
	0x6f, 0x77, 0x52, 0x10, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x57, 0x69, 0x6e,
	0x64, 0x6f, 0x77, 0x73, 0x12, 0x52, 0x0a, 0x10, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x5f, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x70,
	0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x52, 0x0e, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d,
	0x65, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x12, 0x3d, 0x0a, 0x18, 0x74, 0x72, 0x61, 0x76,
	0x65, 0x6c, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x75, 0x6c, 0x74,
	0x69, 0x70, 0x6c, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x01, 0x48, 0x00, 0x52, 0x16, 0x74, 0x72,
	0x61, 0x76, 0x65, 0x6c, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x75, 0x6c, 0x74,
	0x69, 0x70, 0x6c, 0x65, 0x88, 0x01, 0x01, 0x12, 0x60, 0x0a, 0x10, 0x75, 0x6e, 0x6c, 0x6f, 0x61,
	0x64, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x0c, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x56, 0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x2e, 0x55, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x69,
	0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x0f, 0x75, 0x6e, 0x6c, 0x6f, 0x61, 0x64,
	0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x56, 0x0a, 0x0b, 0x6c, 0x6f, 0x61,
	0x64, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x18, 0x1e, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x70,
	0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x65,
	0x68, 0x69, 0x63, 0x6c, 0x65, 0x2e, 0x4c, 0x6f, 0x61, 0x64, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0a, 0x6c, 0x6f, 0x61, 0x64, 0x4c, 0x69, 0x6d, 0x69, 0x74,
	0x73, 0x12, 0x22, 0x0a, 0x0d, 0x63, 0x6f, 0x73, 0x74, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x68, 0x6f,
	0x75, 0x72, 0x18, 0x10, 0x20, 0x01, 0x28, 0x01, 0x52, 0x0b, 0x63, 0x6f, 0x73, 0x74, 0x50, 0x65,
	0x72, 0x48, 0x6f, 0x75, 0x72, 0x12, 0x33, 0x0a, 0x16, 0x63, 0x6f, 0x73, 0x74, 0x5f, 0x70, 0x65,
	0x72, 0x5f, 0x74, 0x72, 0x61, 0x76, 0x65, 0x6c, 0x65, 0x64, 0x5f, 0x68, 0x6f, 0x75, 0x72, 0x18,
	0x11, 0x20, 0x01, 0x28, 0x01, 0x52, 0x13, 0x63, 0x6f, 0x73, 0x74, 0x50, 0x65, 0x72, 0x54, 0x72,
	0x61, 0x76, 0x65, 0x6c, 0x65, 0x64, 0x48, 0x6f, 0x75, 0x72, 0x12, 0x2c, 0x0a, 0x12, 0x63, 0x6f,
	0x73, 0x74, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x6b, 0x69, 0x6c, 0x6f, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x18, 0x12, 0x20, 0x01, 0x28, 0x01, 0x52, 0x10, 0x63, 0x6f, 0x73, 0x74, 0x50, 0x65, 0x72, 0x4b,
	0x69, 0x6c, 0x6f, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x12, 0x1d, 0x0a, 0x0a, 0x66, 0x69, 0x78, 0x65,
	0x64, 0x5f, 0x63, 0x6f, 0x73, 0x74, 0x18, 0x13, 0x20, 0x01, 0x28, 0x01, 0x52, 0x09, 0x66, 0x69,
	0x78, 0x65, 0x64, 0x43, 0x6f, 0x73, 0x74, 0x12, 0x32, 0x0a, 0x16, 0x75, 0x73, 0x65, 0x64, 0x5f,
	0x69, 0x66, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x5f, 0x69, 0x73, 0x5f, 0x65, 0x6d, 0x70, 0x74,
	0x79, 0x18, 0x14, 0x20, 0x01, 0x28, 0x08, 0x52, 0x12, 0x75, 0x73, 0x65, 0x64, 0x49, 0x66, 0x52,
	0x6f, 0x75, 0x74, 0x65, 0x49, 0x73, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x65, 0x0a, 0x14, 0x72,
	0x6f, 0x75, 0x74, 0x65, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6c, 0x69,
	0x6d, 0x69, 0x74, 0x18, 0x15, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x65, 0x68, 0x69, 0x63, 0x6c, 0x65,
	0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x52, 0x12,
	0x72, 0x6f, 0x75, 0x74, 0x65, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x69, 0x6d,
	0x69, 0x74, 0x12, 0x67, 0x0a, 0x15, 0x74, 0x72, 0x61, 0x76, 0x65, 0x6c, 0x5f, 0x64, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18, 0x16, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x56, 0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x52, 0x13, 0x74, 0x72, 0x61, 0x76, 0x65, 0x6c, 0x44, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x12, 0x5d, 0x0a, 0x14, 0x72,
	0x6f, 0x75, 0x74, 0x65, 0x5f, 0x64, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6c, 0x69,
	0x6d, 0x69, 0x74, 0x18, 0x17, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x52, 0x12, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x44, 0x69, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x12, 0x96, 0x01, 0x0a, 0x23, 0x65,
	0x78, 0x74, 0x72, 0x61, 0x5f, 0x76, 0x69, 0x73, 0x69, 0x74, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x6f, 0x72, 0x5f, 0x76, 0x69, 0x73, 0x69, 0x74, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x18, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x2e,
	0x45, 0x78, 0x74, 0x72, 0x61, 0x56, 0x69, 0x73, 0x69, 0x74, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x46, 0x6f, 0x72, 0x56, 0x69, 0x73, 0x69, 0x74, 0x54, 0x79, 0x70, 0x65, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x1e, 0x65, 0x78, 0x74, 0x72, 0x61, 0x56, 0x69, 0x73, 0x69, 0x74, 0x44,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x6f, 0x72, 0x56, 0x69, 0x73, 0x69, 0x74, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x46, 0x0a, 0x0a, 0x62, 0x72, 0x65, 0x61, 0x6b, 0x5f, 0x72, 0x75, 0x6c,
	0x65, 0x18, 0x19, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x72, 0x65, 0x61, 0x6b, 0x52, 0x75, 0x6c, 0x65,
	0x52, 0x09, 0x62, 0x72, 0x65, 0x61, 0x6b, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x18, 0x1b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x12, 0x16, 0x0a, 0x06, 0x69, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x18, 0x1c, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x06, 0x69, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x12, 0x30, 0x0a, 0x12, 0x62, 0x72, 0x65,
	0x61, 0x6b, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x5f, 0x69, 0x6e, 0x64, 0x69, 0x63, 0x65, 0x73, 0x18,
	0x1d, 0x20, 0x03, 0x28, 0x05, 0x42, 0x02, 0x18, 0x01, 0x52, 0x10, 0x62, 0x72, 0x65, 0x61, 0x6b,
	0x52, 0x75, 0x6c, 0x65, 0x49, 0x6e, 0x64, 0x69, 0x63, 0x65, 0x73, 0x12, 0x52, 0x0a, 0x0a, 0x63,
	0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x69, 0x65, 0x73, 0x18, 0x0d, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f,
	0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x51, 0x75, 0x61, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x42,
	0x02, 0x18, 0x01, 0x52, 0x0a, 0x63, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x69, 0x65, 0x73, 0x12,
	0x6c, 0x0a, 0x14, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x69, 0x6e,
	0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x73, 0x18, 0x0e, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x70, 0x74,
	0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61, 0x70,
	0x61, 0x63, 0x69, 0x74, 0x79, 0x51, 0x75, 0x61, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x49, 0x6e, 0x74,
	0x65, 0x72, 0x76, 0x61, 0x6c, 0x42, 0x02, 0x18, 0x01, 0x52, 0x12, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x4c, 0x6f, 0x61, 0x64, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x73, 0x12, 0x68, 0x0a,
	0x12, 0x65, 0x6e, 0x64, 0x5f, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76,
	0x61, 0x6c, 0x73, 0x18, 0x0f, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74,
	0x79, 0x51, 0x75, 0x61, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61,
	0x6c, 0x42, 0x02, 0x18, 0x01, 0x52, 0x10, 0x65, 0x6e, 0x64, 0x4c, 0x6f, 0x61, 0x64, 0x49, 0x6e,
	0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x73, 0x1a, 0xa8, 0x03, 0x0a, 0x09, 0x4c, 0x6f, 0x61, 0x64,
	0x4c, 0x69, 0x6d, 0x69, 0x74, 0x12, 0x1e, 0x0a, 0x08, 0x6d, 0x61, 0x78, 0x5f, 0x6c, 0x6f, 0x61,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x48, 0x00, 0x52, 0x07, 0x6d, 0x61, 0x78, 0x4c, 0x6f,
	0x61, 0x64, 0x88, 0x01, 0x01, 0x12, 0x22, 0x0a, 0x0d, 0x73, 0x6f, 0x66, 0x74, 0x5f, 0x6d, 0x61,
	0x78, 0x5f, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0b, 0x73, 0x6f,
	0x66, 0x74, 0x4d, 0x61, 0x78, 0x4c, 0x6f, 0x61, 0x64, 0x12, 0x3d, 0x0a, 0x1c, 0x63, 0x6f, 0x73,
	0x74, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x75, 0x6e, 0x69, 0x74, 0x5f, 0x61, 0x62, 0x6f, 0x76, 0x65,
	0x5f, 0x73, 0x6f, 0x66, 0x74, 0x5f, 0x6d, 0x61, 0x78, 0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x52,
	0x17, 0x63, 0x6f, 0x73, 0x74, 0x50, 0x65, 0x72, 0x55, 0x6e, 0x69, 0x74, 0x41, 0x62, 0x6f, 0x76,
	0x65, 0x53, 0x6f, 0x66, 0x74, 0x4d, 0x61, 0x78, 0x12, 0x68, 0x0a, 0x13, 0x73, 0x74, 0x61, 0x72,
	0x74, 0x5f, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x2e, 0x4c, 0x6f, 0x61,
	0x64, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x52,
	0x11, 0x73, 0x74, 0x61, 0x72, 0x74, 0x4c, 0x6f, 0x61, 0x64, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76,
	0x61, 0x6c, 0x12, 0x64, 0x0a, 0x11, 0x65, 0x6e, 0x64, 0x5f, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x69,
	0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x70, 0x74,
	0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x65, 0x68,
	0x69, 0x63, 0x6c, 0x65, 0x2e, 0x4c, 0x6f, 0x61, 0x64, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x2e, 0x49,
	0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x52, 0x0f, 0x65, 0x6e, 0x64, 0x4c, 0x6f, 0x61, 0x64,
	0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x1a, 0x3b, 0x0a, 0x08, 0x49, 0x6e, 0x74, 0x65,
	0x72, 0x76, 0x61, 0x6c, 0x12, 0x10, 0x0a, 0x03, 0x6d, 0x69, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x03, 0x6d, 0x69, 0x6e, 0x12, 0x15, 0x0a, 0x03, 0x6d, 0x61, 0x78, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x03, 0x48, 0x00, 0x52, 0x03, 0x6d, 0x61, 0x78, 0x88, 0x01, 0x01, 0x42, 0x06, 0x0a,
	0x04, 0x5f, 0x6d, 0x61, 0x78, 0x42, 0x0b, 0x0a, 0x09, 0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x6c, 0x6f,
	0x61, 0x64, 0x1a, 0xe9, 0x03, 0x0a, 0x0d, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c,
	0x69, 0x6d, 0x69, 0x74, 0x12, 0x3c, 0x0a, 0x0c, 0x6d, 0x61, 0x78, 0x5f, 0x64, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x6d, 0x61, 0x78, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x45, 0x0a, 0x11, 0x73, 0x6f, 0x66, 0x74, 0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x64,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x73, 0x6f, 0x66, 0x74, 0x4d, 0x61,
	0x78, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x42, 0x0a, 0x1c, 0x63, 0x6f, 0x73,
	0x74, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x68, 0x6f, 0x75, 0x72, 0x5f, 0x61, 0x66, 0x74, 0x65, 0x72,
	0x5f, 0x73, 0x6f, 0x66, 0x74, 0x5f, 0x6d, 0x61, 0x78, 0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x48,
	0x00, 0x52, 0x17, 0x63, 0x6f, 0x73, 0x74, 0x50, 0x65, 0x72, 0x48, 0x6f, 0x75, 0x72, 0x41, 0x66,
	0x74, 0x65, 0x72, 0x53, 0x6f, 0x66, 0x74, 0x4d, 0x61, 0x78, 0x88, 0x01, 0x01, 0x12, 0x58, 0x0a,
	0x1b, 0x71, 0x75, 0x61, 0x64, 0x72, 0x61, 0x74, 0x69, 0x63, 0x5f, 0x73, 0x6f, 0x66, 0x74, 0x5f,
	0x6d, 0x61, 0x78, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x18, 0x71,
	0x75, 0x61, 0x64, 0x72, 0x61, 0x74, 0x69, 0x63, 0x53, 0x6f, 0x66, 0x74, 0x4d, 0x61, 0x78, 0x44,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x62, 0x0a, 0x2d, 0x63, 0x6f, 0x73, 0x74, 0x5f,
	0x70, 0x65, 0x72, 0x5f, 0x73, 0x71, 0x75, 0x61, 0x72, 0x65, 0x5f, 0x68, 0x6f, 0x75, 0x72, 0x5f,
	0x61, 0x66, 0x74, 0x65, 0x72, 0x5f, 0x71, 0x75, 0x61, 0x64, 0x72, 0x61, 0x74, 0x69, 0x63, 0x5f,
	0x73, 0x6f, 0x66, 0x74, 0x5f, 0x6d, 0x61, 0x78, 0x18, 0x05, 0x20, 0x01, 0x28, 0x01, 0x48, 0x01,
	0x52, 0x26, 0x63, 0x6f, 0x73, 0x74, 0x50, 0x65, 0x72, 0x53, 0x71, 0x75, 0x61, 0x72, 0x65, 0x48,
	0x6f, 0x75, 0x72, 0x41, 0x66, 0x74, 0x65, 0x72, 0x51, 0x75, 0x61, 0x64, 0x72, 0x61, 0x74, 0x69,
	0x63, 0x53, 0x6f, 0x66, 0x74, 0x4d, 0x61, 0x78, 0x88, 0x01, 0x01, 0x42, 0x1f, 0x0a, 0x1d, 0x5f,
	0x63, 0x6f, 0x73, 0x74, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x68, 0x6f, 0x75, 0x72, 0x5f, 0x61, 0x66,
	0x74, 0x65, 0x72, 0x5f, 0x73, 0x6f, 0x66, 0x74, 0x5f, 0x6d, 0x61, 0x78, 0x42, 0x30, 0x0a, 0x2e,
	0x5f, 0x63, 0x6f, 0x73, 0x74, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x73, 0x71, 0x75, 0x61, 0x72, 0x65,
	0x5f, 0x68, 0x6f, 0x75, 0x72, 0x5f, 0x61, 0x66, 0x74, 0x65, 0x72, 0x5f, 0x71, 0x75, 0x61, 0x64,
	0x72, 0x61, 0x74, 0x69, 0x63, 0x5f, 0x73, 0x6f, 0x66, 0x74, 0x5f, 0x6d, 0x61, 0x78, 0x1a, 0x6e,
	0x0a, 0x0f, 0x4c, 0x6f, 0x61, 0x64, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x45, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x56, 0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x2e, 0x4c, 0x6f, 0x61, 0x64, 0x4c, 0x69,
	0x6d, 0x69, 0x74, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x6c,
	0x0a, 0x23, 0x45, 0x78, 0x74, 0x72, 0x61, 0x56, 0x69, 0x73, 0x69, 0x74, 0x44, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x46, 0x6f, 0x72, 0x56, 0x69, 0x73, 0x69, 0x74, 0x54, 0x79, 0x70, 0x65,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x2f, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x43, 0x0a, 0x0a,
	0x54, 0x72, 0x61, 0x76, 0x65, 0x6c, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x1b, 0x0a, 0x17, 0x54, 0x52,
	0x41, 0x56, 0x45, 0x4c, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x52, 0x49, 0x56, 0x49,
	0x4e, 0x47, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x57, 0x41, 0x4c, 0x4b, 0x49, 0x4e, 0x47, 0x10,
	0x02, 0x22, 0x62, 0x0a, 0x0f, 0x55, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x12, 0x20, 0x0a, 0x1c, 0x55, 0x4e, 0x4c, 0x4f, 0x41, 0x44, 0x49, 0x4e,
	0x47, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x15, 0x0a, 0x11, 0x4c, 0x41, 0x53, 0x54, 0x5f, 0x49,
	0x4e, 0x5f, 0x46, 0x49, 0x52, 0x53, 0x54, 0x5f, 0x4f, 0x55, 0x54, 0x10, 0x01, 0x12, 0x16, 0x0a,
	0x12, 0x46, 0x49, 0x52, 0x53, 0x54, 0x5f, 0x49, 0x4e, 0x5f, 0x46, 0x49, 0x52, 0x53, 0x54, 0x5f,
	0x4f, 0x55, 0x54, 0x10, 0x02, 0x42, 0x1b, 0x0a, 0x19, 0x5f, 0x74, 0x72, 0x61, 0x76, 0x65, 0x6c,
	0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x70,
	0x6c, 0x65, 0x22, 0xf1, 0x03, 0x0a, 0x0a, 0x54, 0x69, 0x6d, 0x65, 0x57, 0x69, 0x6e, 0x64, 0x6f,
	0x77, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08,
	0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x42, 0x0a, 0x0f, 0x73, 0x6f, 0x66, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x72,
	0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0d, 0x73, 0x6f, 0x66, 0x74, 0x53, 0x74,
	0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3e, 0x0a, 0x0d, 0x73, 0x6f, 0x66, 0x74, 0x5f,
	0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0b, 0x73, 0x6f, 0x66, 0x74,
	0x45, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x51, 0x0a, 0x24, 0x63, 0x6f, 0x73, 0x74, 0x5f,
	0x70, 0x65, 0x72, 0x5f, 0x68, 0x6f, 0x75, 0x72, 0x5f, 0x62, 0x65, 0x66, 0x6f, 0x72, 0x65, 0x5f,
	0x73, 0x6f, 0x66, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x01, 0x48, 0x00, 0x52, 0x1e, 0x63, 0x6f, 0x73, 0x74, 0x50, 0x65, 0x72,
	0x48, 0x6f, 0x75, 0x72, 0x42, 0x65, 0x66, 0x6f, 0x72, 0x65, 0x53, 0x6f, 0x66, 0x74, 0x53, 0x74,
	0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x88, 0x01, 0x01, 0x12, 0x4b, 0x0a, 0x21, 0x63, 0x6f,
	0x73, 0x74, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x68, 0x6f, 0x75, 0x72, 0x5f, 0x61, 0x66, 0x74, 0x65,
	0x72, 0x5f, 0x73, 0x6f, 0x66, 0x74, 0x5f, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x01, 0x48, 0x01, 0x52, 0x1b, 0x63, 0x6f, 0x73, 0x74, 0x50, 0x65, 0x72,
	0x48, 0x6f, 0x75, 0x72, 0x41, 0x66, 0x74, 0x65, 0x72, 0x53, 0x6f, 0x66, 0x74, 0x45, 0x6e, 0x64,
	0x54, 0x69, 0x6d, 0x65, 0x88, 0x01, 0x01, 0x42, 0x27, 0x0a, 0x25, 0x5f, 0x63, 0x6f, 0x73, 0x74,
	0x5f, 0x70, 0x65, 0x72, 0x5f, 0x68, 0x6f, 0x75, 0x72, 0x5f, 0x62, 0x65, 0x66, 0x6f, 0x72, 0x65,
	0x5f, 0x73, 0x6f, 0x66, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x42, 0x24, 0x0a, 0x22, 0x5f, 0x63, 0x6f, 0x73, 0x74, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x68, 0x6f,
	0x75, 0x72, 0x5f, 0x61, 0x66, 0x74, 0x65, 0x72, 0x5f, 0x73, 0x6f, 0x66, 0x74, 0x5f, 0x65, 0x6e,
	0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x22, 0x40, 0x0a, 0x10, 0x43, 0x61, 0x70, 0x61, 0x63, 0x69,
	0x74, 0x79, 0x51, 0x75, 0x61, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x14,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x18, 0x01, 0x22, 0x92, 0x01, 0x0a, 0x18, 0x43, 0x61, 0x70,
	0x61, 0x63, 0x69, 0x74, 0x79, 0x51, 0x75, 0x61, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x49, 0x6e, 0x74,
	0x65, 0x72, 0x76, 0x61, 0x6c, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x20, 0x0a, 0x09, 0x6d, 0x69, 0x6e,
	0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x48, 0x00, 0x52, 0x08,
	0x6d, 0x69, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x88, 0x01, 0x01, 0x12, 0x20, 0x0a, 0x09, 0x6d,
	0x61, 0x78, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x48, 0x01,
	0x52, 0x08, 0x6d, 0x61, 0x78, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x88, 0x01, 0x01, 0x3a, 0x02, 0x18,
	0x01, 0x42, 0x0c, 0x0a, 0x0a, 0x5f, 0x6d, 0x69, 0x6e, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x42,
	0x0c, 0x0a, 0x0a, 0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0xeb, 0x02,
	0x0a, 0x0d, 0x44, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x12,
	0x22, 0x0a, 0x0a, 0x6d, 0x61, 0x78, 0x5f, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x03, 0x48, 0x00, 0x52, 0x09, 0x6d, 0x61, 0x78, 0x4d, 0x65, 0x74, 0x65, 0x72, 0x73,
	0x88, 0x01, 0x01, 0x12, 0x2b, 0x0a, 0x0f, 0x73, 0x6f, 0x66, 0x74, 0x5f, 0x6d, 0x61, 0x78, 0x5f,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x48, 0x01, 0x52, 0x0d,
	0x73, 0x6f, 0x66, 0x74, 0x4d, 0x61, 0x78, 0x4d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x88, 0x01, 0x01,
	0x12, 0x4c, 0x0a, 0x21, 0x63, 0x6f, 0x73, 0x74, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x6b, 0x69, 0x6c,
	0x6f, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x5f, 0x62, 0x65, 0x6c, 0x6f, 0x77, 0x5f, 0x73, 0x6f, 0x66,
	0x74, 0x5f, 0x6d, 0x61, 0x78, 0x18, 0x04, 0x20, 0x01, 0x28, 0x01, 0x48, 0x02, 0x52, 0x1c, 0x63,
	0x6f, 0x73, 0x74, 0x50, 0x65, 0x72, 0x4b, 0x69, 0x6c, 0x6f, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x42,
	0x65, 0x6c, 0x6f, 0x77, 0x53, 0x6f, 0x66, 0x74, 0x4d, 0x61, 0x78, 0x88, 0x01, 0x01, 0x12, 0x4c,
	0x0a, 0x21, 0x63, 0x6f, 0x73, 0x74, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x6b, 0x69, 0x6c, 0x6f, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x5f, 0x61, 0x62, 0x6f, 0x76, 0x65, 0x5f, 0x73, 0x6f, 0x66, 0x74, 0x5f,
	0x6d, 0x61, 0x78, 0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x48, 0x03, 0x52, 0x1c, 0x63, 0x6f, 0x73,
	0x74, 0x50, 0x65, 0x72, 0x4b, 0x69, 0x6c, 0x6f, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x41, 0x62, 0x6f,
	0x76, 0x65, 0x53, 0x6f, 0x66, 0x74, 0x4d, 0x61, 0x78, 0x88, 0x01, 0x01, 0x42, 0x0d, 0x0a, 0x0b,
	0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x42, 0x12, 0x0a, 0x10, 0x5f,
	0x73, 0x6f, 0x66, 0x74, 0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x42,
	0x24, 0x0a, 0x22, 0x5f, 0x63, 0x6f, 0x73, 0x74, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x6b, 0x69, 0x6c,
	0x6f, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x5f, 0x62, 0x65, 0x6c, 0x6f, 0x77, 0x5f, 0x73, 0x6f, 0x66,
	0x74, 0x5f, 0x6d, 0x61, 0x78, 0x42, 0x24, 0x0a, 0x22, 0x5f, 0x63, 0x6f, 0x73, 0x74, 0x5f, 0x70,
	0x65, 0x72, 0x5f, 0x6b, 0x69, 0x6c, 0x6f, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x5f, 0x61, 0x62, 0x6f,
	0x76, 0x65, 0x5f, 0x73, 0x6f, 0x66, 0x74, 0x5f, 0x6d, 0x61, 0x78, 0x22, 0xe3, 0x02, 0x0a, 0x14,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x65, 0x73, 0x12, 0x17, 0x0a, 0x07, 0x73, 0x72, 0x63, 0x5f, 0x74, 0x61, 0x67, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x72, 0x63, 0x54, 0x61, 0x67, 0x12, 0x28, 0x0a,
	0x10, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x5f, 0x73, 0x72, 0x63, 0x5f, 0x74, 0x61,
	0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65,
	0x64, 0x53, 0x72, 0x63, 0x54, 0x61, 0x67, 0x12, 0x17, 0x0a, 0x07, 0x64, 0x73, 0x74, 0x5f, 0x74,
	0x61, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x64, 0x73, 0x74, 0x54, 0x61, 0x67,
	0x12, 0x28, 0x0a, 0x10, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x5f, 0x64, 0x73, 0x74,
	0x5f, 0x74, 0x61, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x65, 0x78, 0x63, 0x6c,
	0x75, 0x64, 0x65, 0x64, 0x44, 0x73, 0x74, 0x54, 0x61, 0x67, 0x12, 0x12, 0x0a, 0x04, 0x63, 0x6f,
	0x73, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x01, 0x52, 0x04, 0x63, 0x6f, 0x73, 0x74, 0x12, 0x2c,
	0x0a, 0x12, 0x63, 0x6f, 0x73, 0x74, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x6b, 0x69, 0x6c, 0x6f, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x01, 0x52, 0x10, 0x63, 0x6f, 0x73, 0x74,
	0x50, 0x65, 0x72, 0x4b, 0x69, 0x6c, 0x6f, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x12, 0x52, 0x0a, 0x0e,
	0x64, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4c, 0x69, 0x6d, 0x69,
	0x74, 0x52, 0x0d, 0x64, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74,
	0x12, 0x2f, 0x0a, 0x05, 0x64, 0x65, 0x6c, 0x61, 0x79, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x05, 0x64, 0x65, 0x6c, 0x61,
	0x79, 0x22, 0xa0, 0x01, 0x0a, 0x08, 0x57, 0x61, 0x79, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x44,
	0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1b, 0x0a, 0x08, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x5f, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x07, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x49,
	0x64, 0x12, 0x20, 0x0a, 0x0c, 0x73, 0x69, 0x64, 0x65, 0x5f, 0x6f, 0x66, 0x5f, 0x72, 0x6f, 0x61,
	0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x73, 0x69, 0x64, 0x65, 0x4f, 0x66, 0x52,
	0x6f, 0x61, 0x64, 0x42, 0x0f, 0x0a, 0x0d, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x22, 0x63, 0x0a, 0x08, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x2c, 0x0a, 0x07, 0x6c, 0x61, 0x74, 0x5f, 0x6c, 0x6e, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x13, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e,
	0x4c, 0x61, 0x74, 0x4c, 0x6e, 0x67, 0x52, 0x06, 0x6c, 0x61, 0x74, 0x4c, 0x6e, 0x67, 0x12, 0x1d,
	0x0a, 0x07, 0x68, 0x65, 0x61, 0x64, 0x69, 0x6e, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x48,
	0x00, 0x52, 0x07, 0x68, 0x65, 0x61, 0x64, 0x69, 0x6e, 0x67, 0x88, 0x01, 0x01, 0x42, 0x0a, 0x0a,
	0x08, 0x5f, 0x68, 0x65, 0x61, 0x64, 0x69, 0x6e, 0x67, 0x22, 0x8b, 0x05, 0x0a, 0x09, 0x42, 0x72,
	0x65, 0x61, 0x6b, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x5b, 0x0a, 0x0e, 0x62, 0x72, 0x65, 0x61, 0x6b,
	0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f,
	0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x42,
	0x72, 0x65, 0x61, 0x6b, 0x52, 0x75, 0x6c, 0x65, 0x2e, 0x42, 0x72, 0x65, 0x61, 0x6b, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x0d, 0x62, 0x72, 0x65, 0x61, 0x6b, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x73, 0x12, 0x70, 0x0a, 0x15, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63,
	0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x42, 0x72, 0x65, 0x61, 0x6b, 0x52, 0x75, 0x6c, 0x65, 0x2e, 0x46, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74,
	0x52, 0x14, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x73, 0x74,
	0x72, 0x61, 0x69, 0x6e, 0x74, 0x73, 0x1a, 0xef, 0x01, 0x0a, 0x0c, 0x42, 0x72, 0x65, 0x61, 0x6b,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4f, 0x0a, 0x13, 0x65, 0x61, 0x72, 0x6c, 0x69,
	0x65, 0x73, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x11, 0x65, 0x61, 0x72, 0x6c, 0x69, 0x65, 0x73, 0x74, 0x53,
	0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4b, 0x0a, 0x11, 0x6c, 0x61, 0x74, 0x65,
	0x73, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x53, 0x74, 0x61, 0x72,
	0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x41, 0x0a, 0x0c, 0x6d, 0x69, 0x6e, 0x5f, 0x64, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x6d, 0x69, 0x6e,
	0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0xbc, 0x01, 0x0a, 0x13, 0x46, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74,
	0x12, 0x4c, 0x0a, 0x12, 0x6d, 0x69, 0x6e, 0x5f, 0x62, 0x72, 0x65, 0x61, 0x6b, 0x5f, 0x64, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x6d, 0x69,
	0x6e, 0x42, 0x72, 0x65, 0x61, 0x6b, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x57,
	0x0a, 0x18, 0x6d, 0x61, 0x78, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x5f, 0x62, 0x72, 0x65, 0x61,
	0x6b, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x15, 0x6d, 0x61, 0x78, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x42, 0x72, 0x65, 0x61, 0x6b, 0x44,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x81, 0x1c, 0x0a, 0x0d, 0x53, 0x68, 0x69, 0x70,
	0x6d, 0x65, 0x6e, 0x74, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x76, 0x65, 0x68,
	0x69, 0x63, 0x6c, 0x65, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x0c, 0x76, 0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x23,
	0x0a, 0x0d, 0x76, 0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x76, 0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x12, 0x48, 0x0a, 0x12, 0x76, 0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x5f, 0x73,
	0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x10, 0x76, 0x65, 0x68,
	0x69, 0x63, 0x6c, 0x65, 0x53, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x44, 0x0a,
	0x10, 0x76, 0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x5f, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x0e, 0x76, 0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x45, 0x6e, 0x64, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x49, 0x0a, 0x06, 0x76, 0x69, 0x73, 0x69, 0x74, 0x73, 0x18, 0x07, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x68, 0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x6f, 0x75, 0x74, 0x65,
	0x2e, 0x56, 0x69, 0x73, 0x69, 0x74, 0x52, 0x06, 0x76, 0x69, 0x73, 0x69, 0x74, 0x73, 0x12, 0x58,
	0x0a, 0x0b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x08, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x68, 0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x6f, 0x75, 0x74, 0x65,
	0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x3e, 0x0a, 0x1b, 0x68, 0x61, 0x73, 0x5f,
	0x74, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x5f, 0x69, 0x6e, 0x66, 0x65, 0x61, 0x73, 0x69, 0x62,
	0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x08, 0x52, 0x19, 0x68,
	0x61, 0x73, 0x54, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x49, 0x6e, 0x66, 0x65, 0x61, 0x73, 0x69,
	0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x12, 0x62, 0x0a, 0x0e, 0x72, 0x6f, 0x75, 0x74,
	0x65, 0x5f, 0x70, 0x6f, 0x6c, 0x79, 0x6c, 0x69, 0x6e, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x68, 0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x2e, 0x45, 0x6e,
	0x63, 0x6f, 0x64, 0x65, 0x64, 0x50, 0x6f, 0x6c, 0x79, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x0d, 0x72,
	0x6f, 0x75, 0x74, 0x65, 0x50, 0x6f, 0x6c, 0x79, 0x6c, 0x69, 0x6e, 0x65, 0x12, 0x49, 0x0a, 0x06,
	0x62, 0x72, 0x65, 0x61, 0x6b, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x70, 0x74, 0x69,
	0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x68, 0x69, 0x70,
	0x6d, 0x65, 0x6e, 0x74, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x2e, 0x42, 0x72, 0x65, 0x61, 0x6b, 0x52,
	0x06, 0x62, 0x72, 0x65, 0x61, 0x6b, 0x73, 0x12, 0x49, 0x0a, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x73, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74,
	0x65, 0x64, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x73, 0x12, 0x5c, 0x0a, 0x0b, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x73, 0x74,
	0x73, 0x18, 0x11, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x68, 0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x52,
	0x6f, 0x75, 0x74, 0x65, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x73, 0x74, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x52, 0x0a, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x73, 0x74, 0x73,
	0x12, 0x28, 0x0a, 0x10, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x5f, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f,
	0x63, 0x6f, 0x73, 0x74, 0x18, 0x12, 0x20, 0x01, 0x28, 0x01, 0x52, 0x0e, 0x72, 0x6f, 0x75, 0x74,
	0x65, 0x54, 0x6f, 0x74, 0x61, 0x6c, 0x43, 0x6f, 0x73, 0x74, 0x12, 0x4f, 0x0a, 0x09, 0x65, 0x6e,
	0x64, 0x5f, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x18, 0x0d, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x70, 0x74,
	0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61, 0x70,
	0x61, 0x63, 0x69, 0x74, 0x79, 0x51, 0x75, 0x61, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x42, 0x02, 0x18,
	0x01, 0x52, 0x08, 0x65, 0x6e, 0x64, 0x4c, 0x6f, 0x61, 0x64, 0x73, 0x12, 0x5d, 0x0a, 0x0c, 0x74,
	0x72, 0x61, 0x76, 0x65, 0x6c, 0x5f, 0x73, 0x74, 0x65, 0x70, 0x73, 0x18, 0x0e, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x68, 0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x2e, 0x54,
	0x72, 0x61, 0x76, 0x65, 0x6c, 0x53, 0x74, 0x65, 0x70, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0b, 0x74,
	0x72, 0x61, 0x76, 0x65, 0x6c, 0x53, 0x74, 0x65, 0x70, 0x73, 0x12, 0x44, 0x0a, 0x0e, 0x76, 0x65,
	0x68, 0x69, 0x63, 0x6c, 0x65, 0x5f, 0x64, 0x65, 0x74, 0x6f, 0x75, 0x72, 0x18, 0x0f, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x02, 0x18,
	0x01, 0x52, 0x0d, 0x76, 0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x44, 0x65, 0x74, 0x6f, 0x75, 0x72,
	0x12, 0x6e, 0x0a, 0x18, 0x64, 0x65, 0x6c, 0x61, 0x79, 0x5f, 0x62, 0x65, 0x66, 0x6f, 0x72, 0x65,
	0x5f, 0x76, 0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x5f, 0x65, 0x6e, 0x64, 0x18, 0x10, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x68, 0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x2e,
	0x44, 0x65, 0x6c, 0x61, 0x79, 0x42, 0x02, 0x18, 0x01, 0x52, 0x15, 0x64, 0x65, 0x6c, 0x61, 0x79,
	0x42, 0x65, 0x66, 0x6f, 0x72, 0x65, 0x56, 0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x45, 0x6e, 0x64,
	0x1a, 0x7d, 0x0a, 0x05, 0x44, 0x65, 0x6c, 0x61, 0x79, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x08, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x02, 0x18, 0x01, 0x1a,
	0x91, 0x06, 0x0a, 0x05, 0x56, 0x69, 0x73, 0x69, 0x74, 0x12, 0x25, 0x0a, 0x0e, 0x73, 0x68, 0x69,
	0x70, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x0d, 0x73, 0x68, 0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x64, 0x65, 0x78,
	0x12, 0x1b, 0x0a, 0x09, 0x69, 0x73, 0x5f, 0x70, 0x69, 0x63, 0x6b, 0x75, 0x70, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x08, 0x69, 0x73, 0x50, 0x69, 0x63, 0x6b, 0x75, 0x70, 0x12, 0x2e, 0x0a,
	0x13, 0x76, 0x69, 0x73, 0x69, 0x74, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69,
	0x6e, 0x64, 0x65, 0x78, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x11, 0x76, 0x69, 0x73, 0x69,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x39, 0x0a,
	0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73,
	0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x65, 0x0a, 0x0c, 0x6c, 0x6f, 0x61, 0x64,
	0x5f, 0x64, 0x65, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x42,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x70,
	0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x68,
	0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x2e, 0x56, 0x69, 0x73, 0x69,
	0x74, 0x2e, 0x4c, 0x6f, 0x61, 0x64, 0x44, 0x65, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x52, 0x0b, 0x6c, 0x6f, 0x61, 0x64, 0x44, 0x65, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x12,
	0x31, 0x0a, 0x06, 0x64, 0x65, 0x74, 0x6f, 0x75, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x64, 0x65, 0x74, 0x6f,
	0x75, 0x72, 0x12, 0x25, 0x0a, 0x0e, 0x73, 0x68, 0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x73, 0x68, 0x69, 0x70,
	0x6d, 0x65, 0x6e, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x12, 0x1f, 0x0a, 0x0b, 0x76, 0x69, 0x73,
	0x69, 0x74, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a,
	0x76, 0x69, 0x73, 0x69, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x12, 0x57, 0x0a, 0x0d, 0x61, 0x72,
	0x72, 0x69, 0x76, 0x61, 0x6c, 0x5f, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x51, 0x75, 0x61, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0c, 0x61, 0x72, 0x72, 0x69, 0x76, 0x61, 0x6c, 0x4c, 0x6f,
	0x61, 0x64, 0x73, 0x12, 0x63, 0x0a, 0x12, 0x64, 0x65, 0x6c, 0x61, 0x79, 0x5f, 0x62, 0x65, 0x66,
	0x6f, 0x72, 0x65, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f,
	0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x68, 0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x2e, 0x44, 0x65, 0x6c,
	0x61, 0x79, 0x42, 0x02, 0x18, 0x01, 0x52, 0x10, 0x64, 0x65, 0x6c, 0x61, 0x79, 0x42, 0x65, 0x66,
	0x6f, 0x72, 0x65, 0x53, 0x74, 0x61, 0x72, 0x74, 0x12, 0x4c, 0x0a, 0x07, 0x64, 0x65, 0x6d, 0x61,
	0x6e, 0x64, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74,
	0x79, 0x51, 0x75, 0x61, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x42, 0x02, 0x18, 0x01, 0x52, 0x07, 0x64,
	0x65, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x1a, 0x6b, 0x0a, 0x10, 0x4c, 0x6f, 0x61, 0x64, 0x44, 0x65,
	0x6d, 0x61, 0x6e, 0x64, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x41, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x70, 0x74, 0x69, 0x6d,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x68, 0x69, 0x70, 0x6d,
	0x65, 0x6e, 0x74, 0x2e, 0x4c, 0x6f, 0x61, 0x64, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x1a, 0x98, 0x07, 0x0a, 0x0a, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x42, 0x0a, 0x0f, 0x74, 0x72, 0x61, 0x76, 0x65, 0x6c, 0x5f, 0x64, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0e, 0x74, 0x72, 0x61, 0x76, 0x65, 0x6c, 0x44, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x34, 0x0a, 0x16, 0x74, 0x72, 0x61, 0x76, 0x65, 0x6c,
	0x5f, 0x64, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x52, 0x14, 0x74, 0x72, 0x61, 0x76, 0x65, 0x6c, 0x44, 0x69,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x38, 0x0a, 0x18,
	0x74, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x5f, 0x75, 0x6e, 0x61,
	0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x16,
	0x74, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x49, 0x6e, 0x66, 0x6f, 0x55, 0x6e, 0x61, 0x76, 0x61,
	0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x40, 0x0a, 0x0e, 0x64, 0x65, 0x6c, 0x61, 0x79, 0x5f,
	0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x64, 0x65, 0x6c, 0x61, 0x79,
	0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x0a, 0x0e, 0x62, 0x72, 0x65, 0x61,
	0x6b, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x62, 0x72, 0x65,
	0x61, 0x6b, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3e, 0x0a, 0x0d, 0x77, 0x61,
	0x69, 0x74, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x77, 0x61,
	0x69, 0x74, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x0a, 0x0e, 0x74, 0x6f,
	0x74, 0x61, 0x6c, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x74,
	0x6f, 0x74, 0x61, 0x6c, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x39, 0x0a, 0x0a,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74,
	0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x62, 0x0a, 0x0e, 0x72, 0x6f, 0x75, 0x74, 0x65,
	0x5f, 0x70, 0x6f, 0x6c, 0x79, 0x6c, 0x69, 0x6e, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f,
	0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x68, 0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x2e, 0x45, 0x6e, 0x63,
	0x6f, 0x64, 0x65, 0x64, 0x50, 0x6f, 0x6c, 0x79, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x0d, 0x72, 0x6f,
	0x75, 0x74, 0x65, 0x50, 0x6f, 0x6c, 0x79, 0x6c, 0x69, 0x6e, 0x65, 0x12, 0x6d, 0x0a, 0x0d, 0x76,
	0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x5f, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x18, 0x0b, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x68, 0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x2e,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x56, 0x65, 0x68, 0x69, 0x63,
	0x6c, 0x65, 0x4c, 0x6f, 0x61, 0x64, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0c, 0x76, 0x65,
	0x68, 0x69, 0x63, 0x6c, 0x65, 0x4c, 0x6f, 0x61, 0x64, 0x73, 0x12, 0x48, 0x0a, 0x05, 0x6c, 0x6f,
	0x61, 0x64, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74,
	0x79, 0x51, 0x75, 0x61, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x42, 0x02, 0x18, 0x01, 0x52, 0x05, 0x6c,
	0x6f, 0x61, 0x64, 0x73, 0x1a, 0x78, 0x0a, 0x11, 0x56, 0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x4c,
	0x6f, 0x61, 0x64, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x4d, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x68, 0x69, 0x70, 0x6d, 0x65,
	0x6e, 0x74, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x2e, 0x56, 0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x4c,
	0x6f, 0x61, 0x64, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x25,
	0x0a, 0x0b, 0x56, 0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x4c, 0x6f, 0x61, 0x64, 0x12, 0x16, 0x0a,
	0x06, 0x61, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x06, 0x61,
	0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x1a, 0x29, 0x0a, 0x0f, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x65, 0x64,
	0x50, 0x6f, 0x6c, 0x79, 0x6c, 0x69, 0x6e, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x6f, 0x69, 0x6e,
	0x74, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73,
	0x1a, 0x79, 0x0a, 0x05, 0x42, 0x72, 0x65, 0x61, 0x6b, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x08, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x8e, 0x02, 0x0a, 0x0a,
	0x54, 0x72, 0x61, 0x76, 0x65, 0x6c, 0x53, 0x74, 0x65, 0x70, 0x12, 0x35, 0x0a, 0x08, 0x64, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x27, 0x0a, 0x0f, 0x64, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x52, 0x0e, 0x64, 0x69, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x4d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x38, 0x0a, 0x18, 0x74, 0x72,
	0x61, 0x66, 0x66, 0x69, 0x63, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x5f, 0x75, 0x6e, 0x61, 0x76, 0x61,
	0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x16, 0x74, 0x72,
	0x61, 0x66, 0x66, 0x69, 0x63, 0x49, 0x6e, 0x66, 0x6f, 0x55, 0x6e, 0x61, 0x76, 0x61, 0x69, 0x6c,
	0x61, 0x62, 0x6c, 0x65, 0x12, 0x62, 0x0a, 0x0e, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x5f, 0x70, 0x6f,
	0x6c, 0x79, 0x6c, 0x69, 0x6e, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x70, 0x74, 0x69,
	0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x68, 0x69, 0x70,
	0x6d, 0x65, 0x6e, 0x74, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x2e, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x65,
	0x64, 0x50, 0x6f, 0x6c, 0x79, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x0d, 0x72, 0x6f, 0x75, 0x74, 0x65,
	0x50, 0x6f, 0x6c, 0x79, 0x6c, 0x69, 0x6e, 0x65, 0x3a, 0x02, 0x18, 0x01, 0x1a, 0x3d, 0x0a, 0x0f,
	0x52, 0x6f, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x73, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xcd, 0x05, 0x0a, 0x0f,
	0x53, 0x6b, 0x69, 0x70, 0x70, 0x65, 0x64, 0x53, 0x68, 0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x12,
	0x14, 0x0a, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x05,
	0x69, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x14, 0x0a, 0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x12, 0x4e, 0x0a, 0x07, 0x72,
	0x65, 0x61, 0x73, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x70, 0x74, 0x69,
	0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6b, 0x69, 0x70,
	0x70, 0x65, 0x64, 0x53, 0x68, 0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x52, 0x65, 0x61, 0x73,
	0x6f, 0x6e, 0x52, 0x07, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x73, 0x1a, 0xbd, 0x04, 0x0a, 0x06,
	0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x4d, 0x0a, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6b, 0x69, 0x70, 0x70, 0x65, 0x64, 0x53, 0x68, 0x69, 0x70, 0x6d,
	0x65, 0x6e, 0x74, 0x2e, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x2e, 0x43, 0x6f, 0x64, 0x65, 0x52,
	0x04, 0x63, 0x6f, 0x64, 0x65, 0x12, 0x37, 0x0a, 0x15, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65,
	0x5f, 0x76, 0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x05, 0x48, 0x00, 0x52, 0x13, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x56,
	0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x88, 0x01, 0x01, 0x12, 0x43,
	0x0a, 0x1e, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x65, 0x78, 0x63, 0x65, 0x65, 0x64,
	0x65, 0x64, 0x5f, 0x63, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x1b, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x45,
	0x78, 0x63, 0x65, 0x65, 0x64, 0x65, 0x64, 0x43, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x54,
	0x79, 0x70, 0x65, 0x22, 0xcb, 0x02, 0x0a, 0x04, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x14, 0x0a, 0x10,
	0x43, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x4e, 0x4f, 0x5f, 0x56, 0x45, 0x48, 0x49, 0x43, 0x4c, 0x45,
	0x10, 0x01, 0x12, 0x23, 0x0a, 0x1f, 0x44, 0x45, 0x4d, 0x41, 0x4e, 0x44, 0x5f, 0x45, 0x58, 0x43,
	0x45, 0x45, 0x44, 0x53, 0x5f, 0x56, 0x45, 0x48, 0x49, 0x43, 0x4c, 0x45, 0x5f, 0x43, 0x41, 0x50,
	0x41, 0x43, 0x49, 0x54, 0x59, 0x10, 0x02, 0x12, 0x35, 0x0a, 0x31, 0x43, 0x41, 0x4e, 0x4e, 0x4f,
	0x54, 0x5f, 0x42, 0x45, 0x5f, 0x50, 0x45, 0x52, 0x46, 0x4f, 0x52, 0x4d, 0x45, 0x44, 0x5f, 0x57,
	0x49, 0x54, 0x48, 0x49, 0x4e, 0x5f, 0x56, 0x45, 0x48, 0x49, 0x43, 0x4c, 0x45, 0x5f, 0x44, 0x49,
	0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x4c, 0x49, 0x4d, 0x49, 0x54, 0x10, 0x03, 0x12, 0x35,
	0x0a, 0x31, 0x43, 0x41, 0x4e, 0x4e, 0x4f, 0x54, 0x5f, 0x42, 0x45, 0x5f, 0x50, 0x45, 0x52, 0x46,
	0x4f, 0x52, 0x4d, 0x45, 0x44, 0x5f, 0x57, 0x49, 0x54, 0x48, 0x49, 0x4e, 0x5f, 0x56, 0x45, 0x48,
	0x49, 0x43, 0x4c, 0x45, 0x5f, 0x44, 0x55, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4c, 0x49,
	0x4d, 0x49, 0x54, 0x10, 0x04, 0x12, 0x3c, 0x0a, 0x38, 0x43, 0x41, 0x4e, 0x4e, 0x4f, 0x54, 0x5f,
	0x42, 0x45, 0x5f, 0x50, 0x45, 0x52, 0x46, 0x4f, 0x52, 0x4d, 0x45, 0x44, 0x5f, 0x57, 0x49, 0x54,
	0x48, 0x49, 0x4e, 0x5f, 0x56, 0x45, 0x48, 0x49, 0x43, 0x4c, 0x45, 0x5f, 0x54, 0x52, 0x41, 0x56,
	0x45, 0x4c, 0x5f, 0x44, 0x55, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4c, 0x49, 0x4d, 0x49,
	0x54, 0x10, 0x05, 0x12, 0x33, 0x0a, 0x2f, 0x43, 0x41, 0x4e, 0x4e, 0x4f, 0x54, 0x5f, 0x42, 0x45,
	0x5f, 0x50, 0x45, 0x52, 0x46, 0x4f, 0x52, 0x4d, 0x45, 0x44, 0x5f, 0x57, 0x49, 0x54, 0x48, 0x49,
	0x4e, 0x5f, 0x56, 0x45, 0x48, 0x49, 0x43, 0x4c, 0x45, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x5f, 0x57,
	0x49, 0x4e, 0x44, 0x4f, 0x57, 0x53, 0x10, 0x06, 0x12, 0x17, 0x0a, 0x13, 0x56, 0x45, 0x48, 0x49,
	0x43, 0x4c, 0x45, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x41, 0x4c, 0x4c, 0x4f, 0x57, 0x45, 0x44, 0x10,
	0x07, 0x42, 0x18, 0x0a, 0x16, 0x5f, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x76, 0x65,
	0x68, 0x69, 0x63, 0x6c, 0x65, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x22, 0x94, 0x07, 0x0a, 0x11,
	0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x65, 0x64, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x12, 0x38, 0x0a, 0x18, 0x70, 0x65, 0x72, 0x66, 0x6f, 0x72, 0x6d, 0x65, 0x64, 0x5f, 0x73,
	0x68, 0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x16, 0x70, 0x65, 0x72, 0x66, 0x6f, 0x72, 0x6d, 0x65, 0x64, 0x53, 0x68,
	0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x42, 0x0a, 0x0f, 0x74,
	0x72, 0x61, 0x76, 0x65, 0x6c, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x0e, 0x74, 0x72, 0x61, 0x76, 0x65, 0x6c, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x3e, 0x0a, 0x0d, 0x77, 0x61, 0x69, 0x74, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x0c, 0x77, 0x61, 0x69, 0x74, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x40, 0x0a, 0x0e, 0x64, 0x65, 0x6c, 0x61, 0x79, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x0d, 0x64, 0x65, 0x6c, 0x61, 0x79, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x40, 0x0a, 0x0e, 0x62, 0x72, 0x65, 0x61, 0x6b, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x62, 0x72, 0x65, 0x61, 0x6b, 0x44, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x40, 0x0a, 0x0e, 0x76, 0x69, 0x73, 0x69, 0x74, 0x5f, 0x64, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x76, 0x69, 0x73, 0x69, 0x74, 0x44, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x0a, 0x0e, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x64,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x44,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x34, 0x0a, 0x16, 0x74, 0x72, 0x61, 0x76, 0x65,
	0x6c, 0x5f, 0x64, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x01, 0x52, 0x14, 0x74, 0x72, 0x61, 0x76, 0x65, 0x6c, 0x44,
	0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x5a, 0x0a,
	0x09, 0x6d, 0x61, 0x78, 0x5f, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x65, 0x64, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x2e, 0x4d, 0x61, 0x78, 0x4c, 0x6f, 0x61, 0x64, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52,
	0x08, 0x6d, 0x61, 0x78, 0x4c, 0x6f, 0x61, 0x64, 0x73, 0x12, 0x54, 0x0a, 0x05, 0x63, 0x6f, 0x73,
	0x74, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74,
	0x65, 0x64, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x43, 0x6f, 0x73, 0x74, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x42, 0x02, 0x18, 0x01, 0x52, 0x05, 0x63, 0x6f, 0x73, 0x74, 0x73, 0x12,
	0x21, 0x0a, 0x0a, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x63, 0x6f, 0x73, 0x74, 0x18, 0x0b, 0x20,
	0x01, 0x28, 0x01, 0x42, 0x02, 0x18, 0x01, 0x52, 0x09, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x43, 0x6f,
	0x73, 0x74, 0x1a, 0x74, 0x0a, 0x0d, 0x4d, 0x61, 0x78, 0x4c, 0x6f, 0x61, 0x64, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x4d, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x68, 0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x6f, 0x75, 0x74,
	0x65, 0x2e, 0x56, 0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x4c, 0x6f, 0x61, 0x64, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x38, 0x0a, 0x0a, 0x43, 0x6f, 0x73, 0x74,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x22, 0x99, 0x07, 0x0a, 0x1a, 0x49, 0x6e, 0x6a, 0x65, 0x63, 0x74, 0x65, 0x64, 0x53,
	0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e,
	0x74, 0x12, 0x43, 0x0a, 0x06, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x68, 0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x52, 0x06,
	0x72, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x12, 0x5a, 0x0a, 0x11, 0x73, 0x6b, 0x69, 0x70, 0x70, 0x65,
	0x64, 0x5f, 0x73, 0x68, 0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x6b, 0x69, 0x70, 0x70, 0x65, 0x64, 0x53, 0x68, 0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74,
	0x52, 0x10, 0x73, 0x6b, 0x69, 0x70, 0x70, 0x65, 0x64, 0x53, 0x68, 0x69, 0x70, 0x6d, 0x65, 0x6e,
	0x74, 0x73, 0x12, 0x84, 0x01, 0x0a, 0x16, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e,
	0x74, 0x5f, 0x72, 0x65, 0x6c, 0x61, 0x78, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x49, 0x6e, 0x6a, 0x65, 0x63, 0x74, 0x65, 0x64, 0x53, 0x6f, 0x6c, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x2e, 0x43, 0x6f,
	0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x52, 0x65, 0x6c, 0x61, 0x78, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x15, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x52, 0x65,
	0x6c, 0x61, 0x78, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0xd2, 0x04, 0x0a, 0x14, 0x43, 0x6f,
	0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x52, 0x65, 0x6c, 0x61, 0x78, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x7a, 0x0a, 0x0b, 0x72, 0x65, 0x6c, 0x61, 0x78, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x58, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x6a, 0x65, 0x63, 0x74, 0x65, 0x64, 0x53,
	0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e,
	0x74, 0x2e, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x52, 0x65, 0x6c, 0x61,
	0x78, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x78, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x0b, 0x72, 0x65, 0x6c, 0x61, 0x78, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x27,
	0x0a, 0x0f, 0x76, 0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x5f, 0x69, 0x6e, 0x64, 0x69, 0x63, 0x65,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x05, 0x52, 0x0e, 0x76, 0x65, 0x68, 0x69, 0x63, 0x6c, 0x65,
	0x49, 0x6e, 0x64, 0x69, 0x63, 0x65, 0x73, 0x1a, 0x94, 0x03, 0x0a, 0x0a, 0x52, 0x65, 0x6c, 0x61,
	0x78, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x74, 0x0a, 0x05, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x5e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x6a, 0x65, 0x63, 0x74, 0x65, 0x64, 0x53, 0x6f, 0x6c,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x2e,
	0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x52, 0x65, 0x6c, 0x61, 0x78, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x78, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x4c, 0x65, 0x76, 0x65, 0x6c, 0x52, 0x05, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x41, 0x0a, 0x0e,
	0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x0d, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x32, 0x0a, 0x15, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x5f, 0x76, 0x69, 0x73,
	0x69, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x13,
	0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x56, 0x69, 0x73, 0x69, 0x74, 0x43, 0x6f,
	0x75, 0x6e, 0x74, 0x22, 0x98, 0x01, 0x0a, 0x05, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x15, 0x0a,
	0x11, 0x4c, 0x45, 0x56, 0x45, 0x4c, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x25, 0x0a, 0x21, 0x52, 0x45, 0x4c, 0x41, 0x58, 0x5f, 0x56, 0x49,
	0x53, 0x49, 0x54, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x53, 0x5f, 0x41, 0x46, 0x54, 0x45, 0x52, 0x5f,
	0x54, 0x48, 0x52, 0x45, 0x53, 0x48, 0x4f, 0x4c, 0x44, 0x10, 0x01, 0x12, 0x32, 0x0a, 0x2e, 0x52,
	0x45, 0x4c, 0x41, 0x58, 0x5f, 0x56, 0x49, 0x53, 0x49, 0x54, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x53,
	0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x53, 0x45, 0x51, 0x55, 0x45, 0x4e, 0x43, 0x45, 0x5f, 0x41, 0x46,
	0x54, 0x45, 0x52, 0x5f, 0x54, 0x48, 0x52, 0x45, 0x53, 0x48, 0x4f, 0x4c, 0x44, 0x10, 0x02, 0x12,
	0x1d, 0x0a, 0x19, 0x52, 0x45, 0x4c, 0x41, 0x58, 0x5f, 0x41, 0x4c, 0x4c, 0x5f, 0x41, 0x46, 0x54,
	0x45, 0x52, 0x5f, 0x54, 0x48, 0x52, 0x45, 0x53, 0x48, 0x4f, 0x4c, 0x44, 0x10, 0x03, 0x22, 0xd3,
	0x03, 0x0a, 0x1c, 0x4f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x65, 0x54, 0x6f, 0x75, 0x72, 0x73,
	0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x12,
	0x12, 0x0a, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x04, 0x63,
	0x6f, 0x64, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x61, 0x0a, 0x06, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x65, 0x54, 0x6f,
	0x75, 0x72, 0x73, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x72, 0x72,
	0x6f, 0x72, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x52, 0x06, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x65, 0x72, 0x72,
	0x6f, 0x72, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x29,
	0x0a, 0x10, 0x6f, 0x66, 0x66, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x6f, 0x66, 0x66, 0x65, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x1a, 0xc8, 0x01, 0x0a, 0x0e, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x12, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x16, 0x0a, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x48,
	0x00, 0x52, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x12, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x66, 0x0a, 0x09,
	0x73, 0x75, 0x62, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f,
	0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4f,
	0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x65, 0x54, 0x6f, 0x75, 0x72, 0x73, 0x56, 0x61, 0x6c, 0x69,
	0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x2e, 0x46, 0x69, 0x65, 0x6c,
	0x64, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x08, 0x73, 0x75, 0x62, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x42, 0x0e, 0x0a, 0x0c, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x5f, 0x6f, 0x72,
	0x5f, 0x6b, 0x65, 0x79, 0x32, 0xe0, 0x04, 0x0a, 0x0c, 0x46, 0x6c, 0x65, 0x65, 0x74, 0x52, 0x6f,
	0x75, 0x74, 0x69, 0x6e, 0x67, 0x12, 0xe2, 0x01, 0x0a, 0x0d, 0x4f, 0x70, 0x74, 0x69, 0x6d, 0x69,
	0x7a, 0x65, 0x54, 0x6f, 0x75, 0x72, 0x73, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x65, 0x54,
	0x6f, 0x75, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x70, 0x74, 0x69, 0x6d,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x74, 0x69, 0x6d,
	0x69, 0x7a, 0x65, 0x54, 0x6f, 0x75, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x68, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x62, 0x3a, 0x01, 0x2a, 0x5a, 0x2a, 0x3a, 0x01, 0x2a,
	0x22, 0x25, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69,
	0x7a, 0x65, 0x54, 0x6f, 0x75, 0x72, 0x73, 0x22, 0x31, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x6f, 0x70, 0x74,
	0x69, 0x6d, 0x69, 0x7a, 0x65, 0x54, 0x6f, 0x75, 0x72, 0x73, 0x12, 0x94, 0x02, 0x0a, 0x12, 0x42,
	0x61, 0x74, 0x63, 0x68, 0x4f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x65, 0x54, 0x6f, 0x75, 0x72,
	0x73, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x4f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x65, 0x54, 0x6f,
	0x75, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xa5, 0x01, 0xca, 0x41, 0x30, 0x0a,
	0x1a, 0x42, 0x61, 0x74, 0x63, 0x68, 0x4f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x65, 0x54, 0x6f,
	0x75, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x12, 0x41, 0x73, 0x79,
	0x6e, 0x63, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x6c, 0x3a, 0x01, 0x2a, 0x5a, 0x2f, 0x3a, 0x01, 0x2a, 0x22, 0x2a, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x4f, 0x70, 0x74, 0x69,
	0x6d, 0x69, 0x7a, 0x65, 0x54, 0x6f, 0x75, 0x72, 0x73, 0x22, 0x36, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x62,
	0x61, 0x74, 0x63, 0x68, 0x4f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x65, 0x54, 0x6f, 0x75, 0x72,
	0x73, 0x1a, 0x54, 0xca, 0x41, 0x20, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x6f, 0x70, 0x74, 0x69, 0x6d,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f,
	0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0x7d, 0x0a, 0x20, 0x63, 0x6f, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x70, 0x74, 0x69,
	0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x42, 0x11, 0x46, 0x6c, 0x65,
	0x65, 0x74, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01,
	0x5a, 0x44, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x70, 0x62, 0x3b, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x70, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_optimization_v1_fleet_routing_proto_rawDescOnce sync.Once
	file_google_cloud_optimization_v1_fleet_routing_proto_rawDescData = file_google_cloud_optimization_v1_fleet_routing_proto_rawDesc
)

func file_google_cloud_optimization_v1_fleet_routing_proto_rawDescGZIP() []byte {
	file_google_cloud_optimization_v1_fleet_routing_proto_rawDescOnce.Do(func() {
		file_google_cloud_optimization_v1_fleet_routing_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_optimization_v1_fleet_routing_proto_rawDescData)
	})
	return file_google_cloud_optimization_v1_fleet_routing_proto_rawDescData
}

var file_google_cloud_optimization_v1_fleet_routing_proto_enumTypes = make([]protoimpl.EnumInfo, 8)
var file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes = make([]protoimpl.MessageInfo, 58)
var file_google_cloud_optimization_v1_fleet_routing_proto_goTypes = []interface{}{
	(OptimizeToursRequest_SolvingMode)(0),                                 // 0: google.cloud.optimization.v1.OptimizeToursRequest.SolvingMode
	(OptimizeToursRequest_SearchMode)(0),                                  // 1: google.cloud.optimization.v1.OptimizeToursRequest.SearchMode
	(ShipmentTypeIncompatibility_IncompatibilityMode)(0),                  // 2: google.cloud.optimization.v1.ShipmentTypeIncompatibility.IncompatibilityMode
	(ShipmentTypeRequirement_RequirementMode)(0),                          // 3: google.cloud.optimization.v1.ShipmentTypeRequirement.RequirementMode
	(Vehicle_TravelMode)(0),                                               // 4: google.cloud.optimization.v1.Vehicle.TravelMode
	(Vehicle_UnloadingPolicy)(0),                                          // 5: google.cloud.optimization.v1.Vehicle.UnloadingPolicy
	(SkippedShipment_Reason_Code)(0),                                      // 6: google.cloud.optimization.v1.SkippedShipment.Reason.Code
	(InjectedSolutionConstraint_ConstraintRelaxation_Relaxation_Level)(0), // 7: google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation.Relaxation.Level
	(*OptimizeToursRequest)(nil),                                          // 8: google.cloud.optimization.v1.OptimizeToursRequest
	(*OptimizeToursResponse)(nil),                                         // 9: google.cloud.optimization.v1.OptimizeToursResponse
	(*BatchOptimizeToursRequest)(nil),                                     // 10: google.cloud.optimization.v1.BatchOptimizeToursRequest
	(*BatchOptimizeToursResponse)(nil),                                    // 11: google.cloud.optimization.v1.BatchOptimizeToursResponse
	(*ShipmentModel)(nil),                                                 // 12: google.cloud.optimization.v1.ShipmentModel
	(*Shipment)(nil),                                                      // 13: google.cloud.optimization.v1.Shipment
	(*ShipmentTypeIncompatibility)(nil),                                   // 14: google.cloud.optimization.v1.ShipmentTypeIncompatibility
	(*ShipmentTypeRequirement)(nil),                                       // 15: google.cloud.optimization.v1.ShipmentTypeRequirement
	(*Vehicle)(nil),                                                       // 16: google.cloud.optimization.v1.Vehicle
	(*TimeWindow)(nil),                                                    // 17: google.cloud.optimization.v1.TimeWindow
	(*CapacityQuantity)(nil),                                              // 18: google.cloud.optimization.v1.CapacityQuantity
	(*CapacityQuantityInterval)(nil),                                      // 19: google.cloud.optimization.v1.CapacityQuantityInterval
	(*DistanceLimit)(nil),                                                 // 20: google.cloud.optimization.v1.DistanceLimit
	(*TransitionAttributes)(nil),                                          // 21: google.cloud.optimization.v1.TransitionAttributes
	(*Waypoint)(nil),                                                      // 22: google.cloud.optimization.v1.Waypoint
	(*Location)(nil),                                                      // 23: google.cloud.optimization.v1.Location
	(*BreakRule)(nil),                                                     // 24: google.cloud.optimization.v1.BreakRule
	(*ShipmentRoute)(nil),                                                 // 25: google.cloud.optimization.v1.ShipmentRoute
	(*SkippedShipment)(nil),                                               // 26: google.cloud.optimization.v1.SkippedShipment
	(*AggregatedMetrics)(nil),                                             // 27: google.cloud.optimization.v1.AggregatedMetrics
	(*InjectedSolutionConstraint)(nil),                                    // 28: google.cloud.optimization.v1.InjectedSolutionConstraint
	(*OptimizeToursValidationError)(nil),                                  // 29: google.cloud.optimization.v1.OptimizeToursValidationError
	(*OptimizeToursResponse_Metrics)(nil),                                 // 30: google.cloud.optimization.v1.OptimizeToursResponse.Metrics
	nil,                                                                   // 31: google.cloud.optimization.v1.OptimizeToursResponse.Metrics.CostsEntry
	(*BatchOptimizeToursRequest_AsyncModelConfig)(nil),                    // 32: google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig
	(*ShipmentModel_DurationDistanceMatrix)(nil),                          // 33: google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix
	(*ShipmentModel_PrecedenceRule)(nil),                                  // 34: google.cloud.optimization.v1.ShipmentModel.PrecedenceRule
	(*ShipmentModel_BreakRule)(nil),                                       // 35: google.cloud.optimization.v1.ShipmentModel.BreakRule
	(*ShipmentModel_DurationDistanceMatrix_Row)(nil),                      // 36: google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row
	(*ShipmentModel_BreakRule_BreakRequest)(nil),                          // 37: google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest
	(*ShipmentModel_BreakRule_FrequencyConstraint)(nil),                   // 38: google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint
	(*Shipment_VisitRequest)(nil),                                         // 39: google.cloud.optimization.v1.Shipment.VisitRequest
	(*Shipment_Load)(nil),                                                 // 40: google.cloud.optimization.v1.Shipment.Load
	nil,                                                                   // 41: google.cloud.optimization.v1.Shipment.LoadDemandsEntry
	nil,                                                                   // 42: google.cloud.optimization.v1.Shipment.VisitRequest.LoadDemandsEntry
	(*Vehicle_LoadLimit)(nil),                                             // 43: google.cloud.optimization.v1.Vehicle.LoadLimit
	(*Vehicle_DurationLimit)(nil),                                         // 44: google.cloud.optimization.v1.Vehicle.DurationLimit
	nil,                                                                   // 45: google.cloud.optimization.v1.Vehicle.LoadLimitsEntry
	nil,                                                                   // 46: google.cloud.optimization.v1.Vehicle.ExtraVisitDurationForVisitTypeEntry
	(*Vehicle_LoadLimit_Interval)(nil),                                    // 47: google.cloud.optimization.v1.Vehicle.LoadLimit.Interval
	(*BreakRule_BreakRequest)(nil),                                        // 48: google.cloud.optimization.v1.BreakRule.BreakRequest
	(*BreakRule_FrequencyConstraint)(nil),                                 // 49: google.cloud.optimization.v1.BreakRule.FrequencyConstraint
	(*ShipmentRoute_Delay)(nil),                                           // 50: google.cloud.optimization.v1.ShipmentRoute.Delay
	(*ShipmentRoute_Visit)(nil),                                           // 51: google.cloud.optimization.v1.ShipmentRoute.Visit
	(*ShipmentRoute_Transition)(nil),                                      // 52: google.cloud.optimization.v1.ShipmentRoute.Transition
	(*ShipmentRoute_VehicleLoad)(nil),                                     // 53: google.cloud.optimization.v1.ShipmentRoute.VehicleLoad
	(*ShipmentRoute_EncodedPolyline)(nil),                                 // 54: google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline
	(*ShipmentRoute_Break)(nil),                                           // 55: google.cloud.optimization.v1.ShipmentRoute.Break
	(*ShipmentRoute_TravelStep)(nil),                                      // 56: google.cloud.optimization.v1.ShipmentRoute.TravelStep
	nil,                                                                   // 57: google.cloud.optimization.v1.ShipmentRoute.RouteCostsEntry
	nil,                                                                   // 58: google.cloud.optimization.v1.ShipmentRoute.Visit.LoadDemandsEntry
	nil,                                                                   // 59: google.cloud.optimization.v1.ShipmentRoute.Transition.VehicleLoadsEntry
	(*SkippedShipment_Reason)(nil),                                        // 60: google.cloud.optimization.v1.SkippedShipment.Reason
	nil,                                                                   // 61: google.cloud.optimization.v1.AggregatedMetrics.MaxLoadsEntry
	nil,                                                                   // 62: google.cloud.optimization.v1.AggregatedMetrics.CostsEntry
	(*InjectedSolutionConstraint_ConstraintRelaxation)(nil),            // 63: google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
	(*InjectedSolutionConstraint_ConstraintRelaxation_Relaxation)(nil), // 64: google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation.Relaxation
	(*OptimizeToursValidationError_FieldReference)(nil),                // 65: google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference
	(*durationpb.Duration)(nil),                                        // 66: google.protobuf.Duration
	(*timestamppb.Timestamp)(nil),                                      // 67: google.protobuf.Timestamp
	(*latlng.LatLng)(nil),                                              // 68: google.type.LatLng
	(*InputConfig)(nil),                                                // 69: google.cloud.optimization.v1.InputConfig
	(*OutputConfig)(nil),                                               // 70: google.cloud.optimization.v1.OutputConfig
	(*longrunningpb.Operation)(nil),                                    // 71: google.longrunning.Operation
}
var file_google_cloud_optimization_v1_fleet_routing_proto_depIdxs = []int32{
	66,  // 0: google.cloud.optimization.v1.OptimizeToursRequest.timeout:type_name -> google.protobuf.Duration
	12,  // 1: google.cloud.optimization.v1.OptimizeToursRequest.model:type_name -> google.cloud.optimization.v1.ShipmentModel
	0,   // 2: google.cloud.optimization.v1.OptimizeToursRequest.solving_mode:type_name -> google.cloud.optimization.v1.OptimizeToursRequest.SolvingMode
	1,   // 3: google.cloud.optimization.v1.OptimizeToursRequest.search_mode:type_name -> google.cloud.optimization.v1.OptimizeToursRequest.SearchMode
	25,  // 4: google.cloud.optimization.v1.OptimizeToursRequest.injected_first_solution_routes:type_name -> google.cloud.optimization.v1.ShipmentRoute
	28,  // 5: google.cloud.optimization.v1.OptimizeToursRequest.injected_solution_constraint:type_name -> google.cloud.optimization.v1.InjectedSolutionConstraint
	25,  // 6: google.cloud.optimization.v1.OptimizeToursRequest.refresh_details_routes:type_name -> google.cloud.optimization.v1.ShipmentRoute
	25,  // 7: google.cloud.optimization.v1.OptimizeToursResponse.routes:type_name -> google.cloud.optimization.v1.ShipmentRoute
	26,  // 8: google.cloud.optimization.v1.OptimizeToursResponse.skipped_shipments:type_name -> google.cloud.optimization.v1.SkippedShipment
	29,  // 9: google.cloud.optimization.v1.OptimizeToursResponse.validation_errors:type_name -> google.cloud.optimization.v1.OptimizeToursValidationError
	30,  // 10: google.cloud.optimization.v1.OptimizeToursResponse.metrics:type_name -> google.cloud.optimization.v1.OptimizeToursResponse.Metrics
	32,  // 11: google.cloud.optimization.v1.BatchOptimizeToursRequest.model_configs:type_name -> google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig
	13,  // 12: google.cloud.optimization.v1.ShipmentModel.shipments:type_name -> google.cloud.optimization.v1.Shipment
	16,  // 13: google.cloud.optimization.v1.ShipmentModel.vehicles:type_name -> google.cloud.optimization.v1.Vehicle
	67,  // 14: google.cloud.optimization.v1.ShipmentModel.global_start_time:type_name -> google.protobuf.Timestamp
	67,  // 15: google.cloud.optimization.v1.ShipmentModel.global_end_time:type_name -> google.protobuf.Timestamp
	33,  // 16: google.cloud.optimization.v1.ShipmentModel.duration_distance_matrices:type_name -> google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix
	21,  // 17: google.cloud.optimization.v1.ShipmentModel.transition_attributes:type_name -> google.cloud.optimization.v1.TransitionAttributes
	14,  // 18: google.cloud.optimization.v1.ShipmentModel.shipment_type_incompatibilities:type_name -> google.cloud.optimization.v1.ShipmentTypeIncompatibility
	15,  // 19: google.cloud.optimization.v1.ShipmentModel.shipment_type_requirements:type_name -> google.cloud.optimization.v1.ShipmentTypeRequirement
	34,  // 20: google.cloud.optimization.v1.ShipmentModel.precedence_rules:type_name -> google.cloud.optimization.v1.ShipmentModel.PrecedenceRule
	35,  // 21: google.cloud.optimization.v1.ShipmentModel.break_rules:type_name -> google.cloud.optimization.v1.ShipmentModel.BreakRule
	39,  // 22: google.cloud.optimization.v1.Shipment.pickups:type_name -> google.cloud.optimization.v1.Shipment.VisitRequest
	39,  // 23: google.cloud.optimization.v1.Shipment.deliveries:type_name -> google.cloud.optimization.v1.Shipment.VisitRequest
	41,  // 24: google.cloud.optimization.v1.Shipment.load_demands:type_name -> google.cloud.optimization.v1.Shipment.LoadDemandsEntry
	66,  // 25: google.cloud.optimization.v1.Shipment.pickup_to_delivery_absolute_detour_limit:type_name -> google.protobuf.Duration
	66,  // 26: google.cloud.optimization.v1.Shipment.pickup_to_delivery_time_limit:type_name -> google.protobuf.Duration
	18,  // 27: google.cloud.optimization.v1.Shipment.demands:type_name -> google.cloud.optimization.v1.CapacityQuantity
	2,   // 28: google.cloud.optimization.v1.ShipmentTypeIncompatibility.incompatibility_mode:type_name -> google.cloud.optimization.v1.ShipmentTypeIncompatibility.IncompatibilityMode
	3,   // 29: google.cloud.optimization.v1.ShipmentTypeRequirement.requirement_mode:type_name -> google.cloud.optimization.v1.ShipmentTypeRequirement.RequirementMode
	4,   // 30: google.cloud.optimization.v1.Vehicle.travel_mode:type_name -> google.cloud.optimization.v1.Vehicle.TravelMode
	68,  // 31: google.cloud.optimization.v1.Vehicle.start_location:type_name -> google.type.LatLng
	22,  // 32: google.cloud.optimization.v1.Vehicle.start_waypoint:type_name -> google.cloud.optimization.v1.Waypoint
	68,  // 33: google.cloud.optimization.v1.Vehicle.end_location:type_name -> google.type.LatLng
	22,  // 34: google.cloud.optimization.v1.Vehicle.end_waypoint:type_name -> google.cloud.optimization.v1.Waypoint
	17,  // 35: google.cloud.optimization.v1.Vehicle.start_time_windows:type_name -> google.cloud.optimization.v1.TimeWindow
	17,  // 36: google.cloud.optimization.v1.Vehicle.end_time_windows:type_name -> google.cloud.optimization.v1.TimeWindow
	5,   // 37: google.cloud.optimization.v1.Vehicle.unloading_policy:type_name -> google.cloud.optimization.v1.Vehicle.UnloadingPolicy
	45,  // 38: google.cloud.optimization.v1.Vehicle.load_limits:type_name -> google.cloud.optimization.v1.Vehicle.LoadLimitsEntry
	44,  // 39: google.cloud.optimization.v1.Vehicle.route_duration_limit:type_name -> google.cloud.optimization.v1.Vehicle.DurationLimit
	44,  // 40: google.cloud.optimization.v1.Vehicle.travel_duration_limit:type_name -> google.cloud.optimization.v1.Vehicle.DurationLimit
	20,  // 41: google.cloud.optimization.v1.Vehicle.route_distance_limit:type_name -> google.cloud.optimization.v1.DistanceLimit
	46,  // 42: google.cloud.optimization.v1.Vehicle.extra_visit_duration_for_visit_type:type_name -> google.cloud.optimization.v1.Vehicle.ExtraVisitDurationForVisitTypeEntry
	24,  // 43: google.cloud.optimization.v1.Vehicle.break_rule:type_name -> google.cloud.optimization.v1.BreakRule
	18,  // 44: google.cloud.optimization.v1.Vehicle.capacities:type_name -> google.cloud.optimization.v1.CapacityQuantity
	19,  // 45: google.cloud.optimization.v1.Vehicle.start_load_intervals:type_name -> google.cloud.optimization.v1.CapacityQuantityInterval
	19,  // 46: google.cloud.optimization.v1.Vehicle.end_load_intervals:type_name -> google.cloud.optimization.v1.CapacityQuantityInterval
	67,  // 47: google.cloud.optimization.v1.TimeWindow.start_time:type_name -> google.protobuf.Timestamp
	67,  // 48: google.cloud.optimization.v1.TimeWindow.end_time:type_name -> google.protobuf.Timestamp
	67,  // 49: google.cloud.optimization.v1.TimeWindow.soft_start_time:type_name -> google.protobuf.Timestamp
	67,  // 50: google.cloud.optimization.v1.TimeWindow.soft_end_time:type_name -> google.protobuf.Timestamp
	20,  // 51: google.cloud.optimization.v1.TransitionAttributes.distance_limit:type_name -> google.cloud.optimization.v1.DistanceLimit
	66,  // 52: google.cloud.optimization.v1.TransitionAttributes.delay:type_name -> google.protobuf.Duration
	23,  // 53: google.cloud.optimization.v1.Waypoint.location:type_name -> google.cloud.optimization.v1.Location
	68,  // 54: google.cloud.optimization.v1.Location.lat_lng:type_name -> google.type.LatLng
	48,  // 55: google.cloud.optimization.v1.BreakRule.break_requests:type_name -> google.cloud.optimization.v1.BreakRule.BreakRequest
	49,  // 56: google.cloud.optimization.v1.BreakRule.frequency_constraints:type_name -> google.cloud.optimization.v1.BreakRule.FrequencyConstraint
	67,  // 57: google.cloud.optimization.v1.ShipmentRoute.vehicle_start_time:type_name -> google.protobuf.Timestamp
	67,  // 58: google.cloud.optimization.v1.ShipmentRoute.vehicle_end_time:type_name -> google.protobuf.Timestamp
	51,  // 59: google.cloud.optimization.v1.ShipmentRoute.visits:type_name -> google.cloud.optimization.v1.ShipmentRoute.Visit
	52,  // 60: google.cloud.optimization.v1.ShipmentRoute.transitions:type_name -> google.cloud.optimization.v1.ShipmentRoute.Transition
	54,  // 61: google.cloud.optimization.v1.ShipmentRoute.route_polyline:type_name -> google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline
	55,  // 62: google.cloud.optimization.v1.ShipmentRoute.breaks:type_name -> google.cloud.optimization.v1.ShipmentRoute.Break
	27,  // 63: google.cloud.optimization.v1.ShipmentRoute.metrics:type_name -> google.cloud.optimization.v1.AggregatedMetrics
	57,  // 64: google.cloud.optimization.v1.ShipmentRoute.route_costs:type_name -> google.cloud.optimization.v1.ShipmentRoute.RouteCostsEntry
	18,  // 65: google.cloud.optimization.v1.ShipmentRoute.end_loads:type_name -> google.cloud.optimization.v1.CapacityQuantity
	56,  // 66: google.cloud.optimization.v1.ShipmentRoute.travel_steps:type_name -> google.cloud.optimization.v1.ShipmentRoute.TravelStep
	66,  // 67: google.cloud.optimization.v1.ShipmentRoute.vehicle_detour:type_name -> google.protobuf.Duration
	50,  // 68: google.cloud.optimization.v1.ShipmentRoute.delay_before_vehicle_end:type_name -> google.cloud.optimization.v1.ShipmentRoute.Delay
	60,  // 69: google.cloud.optimization.v1.SkippedShipment.reasons:type_name -> google.cloud.optimization.v1.SkippedShipment.Reason
	66,  // 70: google.cloud.optimization.v1.AggregatedMetrics.travel_duration:type_name -> google.protobuf.Duration
	66,  // 71: google.cloud.optimization.v1.AggregatedMetrics.wait_duration:type_name -> google.protobuf.Duration
	66,  // 72: google.cloud.optimization.v1.AggregatedMetrics.delay_duration:type_name -> google.protobuf.Duration
	66,  // 73: google.cloud.optimization.v1.AggregatedMetrics.break_duration:type_name -> google.protobuf.Duration
	66,  // 74: google.cloud.optimization.v1.AggregatedMetrics.visit_duration:type_name -> google.protobuf.Duration
	66,  // 75: google.cloud.optimization.v1.AggregatedMetrics.total_duration:type_name -> google.protobuf.Duration
	61,  // 76: google.cloud.optimization.v1.AggregatedMetrics.max_loads:type_name -> google.cloud.optimization.v1.AggregatedMetrics.MaxLoadsEntry
	62,  // 77: google.cloud.optimization.v1.AggregatedMetrics.costs:type_name -> google.cloud.optimization.v1.AggregatedMetrics.CostsEntry
	25,  // 78: google.cloud.optimization.v1.InjectedSolutionConstraint.routes:type_name -> google.cloud.optimization.v1.ShipmentRoute
	26,  // 79: google.cloud.optimization.v1.InjectedSolutionConstraint.skipped_shipments:type_name -> google.cloud.optimization.v1.SkippedShipment
	63,  // 80: google.cloud.optimization.v1.InjectedSolutionConstraint.constraint_relaxations:type_name -> google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation
	65,  // 81: google.cloud.optimization.v1.OptimizeToursValidationError.fields:type_name -> google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference
	27,  // 82: google.cloud.optimization.v1.OptimizeToursResponse.Metrics.aggregated_route_metrics:type_name -> google.cloud.optimization.v1.AggregatedMetrics
	67,  // 83: google.cloud.optimization.v1.OptimizeToursResponse.Metrics.earliest_vehicle_start_time:type_name -> google.protobuf.Timestamp
	67,  // 84: google.cloud.optimization.v1.OptimizeToursResponse.Metrics.latest_vehicle_end_time:type_name -> google.protobuf.Timestamp
	31,  // 85: google.cloud.optimization.v1.OptimizeToursResponse.Metrics.costs:type_name -> google.cloud.optimization.v1.OptimizeToursResponse.Metrics.CostsEntry
	69,  // 86: google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig.input_config:type_name -> google.cloud.optimization.v1.InputConfig
	70,  // 87: google.cloud.optimization.v1.BatchOptimizeToursRequest.AsyncModelConfig.output_config:type_name -> google.cloud.optimization.v1.OutputConfig
	36,  // 88: google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.rows:type_name -> google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row
	66,  // 89: google.cloud.optimization.v1.ShipmentModel.PrecedenceRule.offset_duration:type_name -> google.protobuf.Duration
	37,  // 90: google.cloud.optimization.v1.ShipmentModel.BreakRule.break_requests:type_name -> google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest
	38,  // 91: google.cloud.optimization.v1.ShipmentModel.BreakRule.frequency_constraints:type_name -> google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint
	66,  // 92: google.cloud.optimization.v1.ShipmentModel.DurationDistanceMatrix.Row.durations:type_name -> google.protobuf.Duration
	67,  // 93: google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest.earliest_start_time:type_name -> google.protobuf.Timestamp
	67,  // 94: google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest.latest_start_time:type_name -> google.protobuf.Timestamp
	66,  // 95: google.cloud.optimization.v1.ShipmentModel.BreakRule.BreakRequest.min_duration:type_name -> google.protobuf.Duration
	66,  // 96: google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint.min_break_duration:type_name -> google.protobuf.Duration
	66,  // 97: google.cloud.optimization.v1.ShipmentModel.BreakRule.FrequencyConstraint.max_inter_break_duration:type_name -> google.protobuf.Duration
	68,  // 98: google.cloud.optimization.v1.Shipment.VisitRequest.arrival_location:type_name -> google.type.LatLng
	22,  // 99: google.cloud.optimization.v1.Shipment.VisitRequest.arrival_waypoint:type_name -> google.cloud.optimization.v1.Waypoint
	68,  // 100: google.cloud.optimization.v1.Shipment.VisitRequest.departure_location:type_name -> google.type.LatLng
	22,  // 101: google.cloud.optimization.v1.Shipment.VisitRequest.departure_waypoint:type_name -> google.cloud.optimization.v1.Waypoint
	17,  // 102: google.cloud.optimization.v1.Shipment.VisitRequest.time_windows:type_name -> google.cloud.optimization.v1.TimeWindow
	66,  // 103: google.cloud.optimization.v1.Shipment.VisitRequest.duration:type_name -> google.protobuf.Duration
	42,  // 104: google.cloud.optimization.v1.Shipment.VisitRequest.load_demands:type_name -> google.cloud.optimization.v1.Shipment.VisitRequest.LoadDemandsEntry
	18,  // 105: google.cloud.optimization.v1.Shipment.VisitRequest.demands:type_name -> google.cloud.optimization.v1.CapacityQuantity
	40,  // 106: google.cloud.optimization.v1.Shipment.LoadDemandsEntry.value:type_name -> google.cloud.optimization.v1.Shipment.Load
	40,  // 107: google.cloud.optimization.v1.Shipment.VisitRequest.LoadDemandsEntry.value:type_name -> google.cloud.optimization.v1.Shipment.Load
	47,  // 108: google.cloud.optimization.v1.Vehicle.LoadLimit.start_load_interval:type_name -> google.cloud.optimization.v1.Vehicle.LoadLimit.Interval
	47,  // 109: google.cloud.optimization.v1.Vehicle.LoadLimit.end_load_interval:type_name -> google.cloud.optimization.v1.Vehicle.LoadLimit.Interval
	66,  // 110: google.cloud.optimization.v1.Vehicle.DurationLimit.max_duration:type_name -> google.protobuf.Duration
	66,  // 111: google.cloud.optimization.v1.Vehicle.DurationLimit.soft_max_duration:type_name -> google.protobuf.Duration
	66,  // 112: google.cloud.optimization.v1.Vehicle.DurationLimit.quadratic_soft_max_duration:type_name -> google.protobuf.Duration
	43,  // 113: google.cloud.optimization.v1.Vehicle.LoadLimitsEntry.value:type_name -> google.cloud.optimization.v1.Vehicle.LoadLimit
	66,  // 114: google.cloud.optimization.v1.Vehicle.ExtraVisitDurationForVisitTypeEntry.value:type_name -> google.protobuf.Duration
	67,  // 115: google.cloud.optimization.v1.BreakRule.BreakRequest.earliest_start_time:type_name -> google.protobuf.Timestamp
	67,  // 116: google.cloud.optimization.v1.BreakRule.BreakRequest.latest_start_time:type_name -> google.protobuf.Timestamp
	66,  // 117: google.cloud.optimization.v1.BreakRule.BreakRequest.min_duration:type_name -> google.protobuf.Duration
	66,  // 118: google.cloud.optimization.v1.BreakRule.FrequencyConstraint.min_break_duration:type_name -> google.protobuf.Duration
	66,  // 119: google.cloud.optimization.v1.BreakRule.FrequencyConstraint.max_inter_break_duration:type_name -> google.protobuf.Duration
	67,  // 120: google.cloud.optimization.v1.ShipmentRoute.Delay.start_time:type_name -> google.protobuf.Timestamp
	66,  // 121: google.cloud.optimization.v1.ShipmentRoute.Delay.duration:type_name -> google.protobuf.Duration
	67,  // 122: google.cloud.optimization.v1.ShipmentRoute.Visit.start_time:type_name -> google.protobuf.Timestamp
	58,  // 123: google.cloud.optimization.v1.ShipmentRoute.Visit.load_demands:type_name -> google.cloud.optimization.v1.ShipmentRoute.Visit.LoadDemandsEntry
	66,  // 124: google.cloud.optimization.v1.ShipmentRoute.Visit.detour:type_name -> google.protobuf.Duration
	18,  // 125: google.cloud.optimization.v1.ShipmentRoute.Visit.arrival_loads:type_name -> google.cloud.optimization.v1.CapacityQuantity
	50,  // 126: google.cloud.optimization.v1.ShipmentRoute.Visit.delay_before_start:type_name -> google.cloud.optimization.v1.ShipmentRoute.Delay
	18,  // 127: google.cloud.optimization.v1.ShipmentRoute.Visit.demands:type_name -> google.cloud.optimization.v1.CapacityQuantity
	66,  // 128: google.cloud.optimization.v1.ShipmentRoute.Transition.travel_duration:type_name -> google.protobuf.Duration
	66,  // 129: google.cloud.optimization.v1.ShipmentRoute.Transition.delay_duration:type_name -> google.protobuf.Duration
	66,  // 130: google.cloud.optimization.v1.ShipmentRoute.Transition.break_duration:type_name -> google.protobuf.Duration
	66,  // 131: google.cloud.optimization.v1.ShipmentRoute.Transition.wait_duration:type_name -> google.protobuf.Duration
	66,  // 132: google.cloud.optimization.v1.ShipmentRoute.Transition.total_duration:type_name -> google.protobuf.Duration
	67,  // 133: google.cloud.optimization.v1.ShipmentRoute.Transition.start_time:type_name -> google.protobuf.Timestamp
	54,  // 134: google.cloud.optimization.v1.ShipmentRoute.Transition.route_polyline:type_name -> google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline
	59,  // 135: google.cloud.optimization.v1.ShipmentRoute.Transition.vehicle_loads:type_name -> google.cloud.optimization.v1.ShipmentRoute.Transition.VehicleLoadsEntry
	18,  // 136: google.cloud.optimization.v1.ShipmentRoute.Transition.loads:type_name -> google.cloud.optimization.v1.CapacityQuantity
	67,  // 137: google.cloud.optimization.v1.ShipmentRoute.Break.start_time:type_name -> google.protobuf.Timestamp
	66,  // 138: google.cloud.optimization.v1.ShipmentRoute.Break.duration:type_name -> google.protobuf.Duration
	66,  // 139: google.cloud.optimization.v1.ShipmentRoute.TravelStep.duration:type_name -> google.protobuf.Duration
	54,  // 140: google.cloud.optimization.v1.ShipmentRoute.TravelStep.route_polyline:type_name -> google.cloud.optimization.v1.ShipmentRoute.EncodedPolyline
	40,  // 141: google.cloud.optimization.v1.ShipmentRoute.Visit.LoadDemandsEntry.value:type_name -> google.cloud.optimization.v1.Shipment.Load
	53,  // 142: google.cloud.optimization.v1.ShipmentRoute.Transition.VehicleLoadsEntry.value:type_name -> google.cloud.optimization.v1.ShipmentRoute.VehicleLoad
	6,   // 143: google.cloud.optimization.v1.SkippedShipment.Reason.code:type_name -> google.cloud.optimization.v1.SkippedShipment.Reason.Code
	53,  // 144: google.cloud.optimization.v1.AggregatedMetrics.MaxLoadsEntry.value:type_name -> google.cloud.optimization.v1.ShipmentRoute.VehicleLoad
	64,  // 145: google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation.relaxations:type_name -> google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation.Relaxation
	7,   // 146: google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation.Relaxation.level:type_name -> google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation.Relaxation.Level
	67,  // 147: google.cloud.optimization.v1.InjectedSolutionConstraint.ConstraintRelaxation.Relaxation.threshold_time:type_name -> google.protobuf.Timestamp
	65,  // 148: google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference.sub_field:type_name -> google.cloud.optimization.v1.OptimizeToursValidationError.FieldReference
	8,   // 149: google.cloud.optimization.v1.FleetRouting.OptimizeTours:input_type -> google.cloud.optimization.v1.OptimizeToursRequest
	10,  // 150: google.cloud.optimization.v1.FleetRouting.BatchOptimizeTours:input_type -> google.cloud.optimization.v1.BatchOptimizeToursRequest
	9,   // 151: google.cloud.optimization.v1.FleetRouting.OptimizeTours:output_type -> google.cloud.optimization.v1.OptimizeToursResponse
	71,  // 152: google.cloud.optimization.v1.FleetRouting.BatchOptimizeTours:output_type -> google.longrunning.Operation
	151, // [151:153] is the sub-list for method output_type
	149, // [149:151] is the sub-list for method input_type
	149, // [149:149] is the sub-list for extension type_name
	149, // [149:149] is the sub-list for extension extendee
	0,   // [0:149] is the sub-list for field type_name
}

func init() { file_google_cloud_optimization_v1_fleet_routing_proto_init() }
func file_google_cloud_optimization_v1_fleet_routing_proto_init() {
	if File_google_cloud_optimization_v1_fleet_routing_proto != nil {
		return
	}
	file_google_cloud_optimization_v1_async_model_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OptimizeToursRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OptimizeToursResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchOptimizeToursRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchOptimizeToursResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ShipmentModel); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Shipment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ShipmentTypeIncompatibility); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ShipmentTypeRequirement); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Vehicle); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TimeWindow); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CapacityQuantity); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CapacityQuantityInterval); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DistanceLimit); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TransitionAttributes); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Waypoint); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Location); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BreakRule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ShipmentRoute); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SkippedShipment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AggregatedMetrics); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InjectedSolutionConstraint); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OptimizeToursValidationError); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OptimizeToursResponse_Metrics); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchOptimizeToursRequest_AsyncModelConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ShipmentModel_DurationDistanceMatrix); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ShipmentModel_PrecedenceRule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ShipmentModel_BreakRule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ShipmentModel_DurationDistanceMatrix_Row); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ShipmentModel_BreakRule_BreakRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ShipmentModel_BreakRule_FrequencyConstraint); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Shipment_VisitRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Shipment_Load); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Vehicle_LoadLimit); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Vehicle_DurationLimit); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Vehicle_LoadLimit_Interval); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BreakRule_BreakRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[41].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BreakRule_FrequencyConstraint); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[42].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ShipmentRoute_Delay); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[43].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ShipmentRoute_Visit); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[44].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ShipmentRoute_Transition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[45].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ShipmentRoute_VehicleLoad); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[46].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ShipmentRoute_EncodedPolyline); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[47].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ShipmentRoute_Break); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[48].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ShipmentRoute_TravelStep); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[52].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SkippedShipment_Reason); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[55].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InjectedSolutionConstraint_ConstraintRelaxation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[56].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InjectedSolutionConstraint_ConstraintRelaxation_Relaxation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[57].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OptimizeToursValidationError_FieldReference); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[0].OneofWrappers = []interface{}{}
	file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[4].OneofWrappers = []interface{}{}
	file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[5].OneofWrappers = []interface{}{}
	file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[8].OneofWrappers = []interface{}{}
	file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[9].OneofWrappers = []interface{}{}
	file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[11].OneofWrappers = []interface{}{}
	file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[12].OneofWrappers = []interface{}{}
	file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[14].OneofWrappers = []interface{}{
		(*Waypoint_Location)(nil),
		(*Waypoint_PlaceId)(nil),
	}
	file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[15].OneofWrappers = []interface{}{}
	file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[26].OneofWrappers = []interface{}{}
	file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[35].OneofWrappers = []interface{}{}
	file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[36].OneofWrappers = []interface{}{}
	file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[39].OneofWrappers = []interface{}{}
	file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[52].OneofWrappers = []interface{}{}
	file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes[57].OneofWrappers = []interface{}{
		(*OptimizeToursValidationError_FieldReference_Index)(nil),
		(*OptimizeToursValidationError_FieldReference_Key)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_optimization_v1_fleet_routing_proto_rawDesc,
			NumEnums:      8,
			NumMessages:   58,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_optimization_v1_fleet_routing_proto_goTypes,
		DependencyIndexes: file_google_cloud_optimization_v1_fleet_routing_proto_depIdxs,
		EnumInfos:         file_google_cloud_optimization_v1_fleet_routing_proto_enumTypes,
		MessageInfos:      file_google_cloud_optimization_v1_fleet_routing_proto_msgTypes,
	}.Build()
	File_google_cloud_optimization_v1_fleet_routing_proto = out.File
	file_google_cloud_optimization_v1_fleet_routing_proto_rawDesc = nil
	file_google_cloud_optimization_v1_fleet_routing_proto_goTypes = nil
	file_google_cloud_optimization_v1_fleet_routing_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// FleetRoutingClient is the client API for FleetRouting service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type FleetRoutingClient interface {
	// Sends an `OptimizeToursRequest` containing a `ShipmentModel` and returns an
	// `OptimizeToursResponse` containing `ShipmentRoute`s, which are a set of
	// routes to be performed by vehicles minimizing the overall cost.
	//
	// A `ShipmentModel` model consists mainly of `Shipment`s that need to be
	// carried out and `Vehicle`s that can be used to transport the `Shipment`s.
	// The `ShipmentRoute`s assign `Shipment`s to `Vehicle`s. More specifically,
	// they assign a series of `Visit`s to each vehicle, where a `Visit`
	// corresponds to a `VisitRequest`, which is a pickup or delivery for a
	// `Shipment`.
	//
	// The goal is to provide an assignment of `ShipmentRoute`s to `Vehicle`s that
	// minimizes the total cost where cost has many components defined in the
	// `ShipmentModel`.
	OptimizeTours(ctx context.Context, in *OptimizeToursRequest, opts ...grpc.CallOption) (*OptimizeToursResponse, error)
	// Optimizes vehicle tours for one or more `OptimizeToursRequest`
	// messages as a batch.
	//
	// This method is a Long Running Operation (LRO). The inputs for optimization
	// (`OptimizeToursRequest` messages) and outputs (`OptimizeToursResponse`
	// messages) are read/written from/to Cloud Storage in user-specified
	// format. Like the `OptimizeTours` method, each `OptimizeToursRequest`
	// contains a `ShipmentModel` and returns an `OptimizeToursResponse`
	// containing `ShipmentRoute`s, which are a set of routes to be performed by
	// vehicles minimizing the overall cost.
	BatchOptimizeTours(ctx context.Context, in *BatchOptimizeToursRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type fleetRoutingClient struct {
	cc grpc.ClientConnInterface
}

func NewFleetRoutingClient(cc grpc.ClientConnInterface) FleetRoutingClient {
	return &fleetRoutingClient{cc}
}

func (c *fleetRoutingClient) OptimizeTours(ctx context.Context, in *OptimizeToursRequest, opts ...grpc.CallOption) (*OptimizeToursResponse, error) {
	out := new(OptimizeToursResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.optimization.v1.FleetRouting/OptimizeTours", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *fleetRoutingClient) BatchOptimizeTours(ctx context.Context, in *BatchOptimizeToursRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.optimization.v1.FleetRouting/BatchOptimizeTours", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// FleetRoutingServer is the server API for FleetRouting service.
type FleetRoutingServer interface {
	// Sends an `OptimizeToursRequest` containing a `ShipmentModel` and returns an
	// `OptimizeToursResponse` containing `ShipmentRoute`s, which are a set of
	// routes to be performed by vehicles minimizing the overall cost.
	//
	// A `ShipmentModel` model consists mainly of `Shipment`s that need to be
	// carried out and `Vehicle`s that can be used to transport the `Shipment`s.
	// The `ShipmentRoute`s assign `Shipment`s to `Vehicle`s. More specifically,
	// they assign a series of `Visit`s to each vehicle, where a `Visit`
	// corresponds to a `VisitRequest`, which is a pickup or delivery for a
	// `Shipment`.
	//
	// The goal is to provide an assignment of `ShipmentRoute`s to `Vehicle`s that
	// minimizes the total cost where cost has many components defined in the
	// `ShipmentModel`.
	OptimizeTours(context.Context, *OptimizeToursRequest) (*OptimizeToursResponse, error)
	// Optimizes vehicle tours for one or more `OptimizeToursRequest`
	// messages as a batch.
	//
	// This method is a Long Running Operation (LRO). The inputs for optimization
	// (`OptimizeToursRequest` messages) and outputs (`OptimizeToursResponse`
	// messages) are read/written from/to Cloud Storage in user-specified
	// format. Like the `OptimizeTours` method, each `OptimizeToursRequest`
	// contains a `ShipmentModel` and returns an `OptimizeToursResponse`
	// containing `ShipmentRoute`s, which are a set of routes to be performed by
	// vehicles minimizing the overall cost.
	BatchOptimizeTours(context.Context, *BatchOptimizeToursRequest) (*longrunningpb.Operation, error)
}

// UnimplementedFleetRoutingServer can be embedded to have forward compatible implementations.
type UnimplementedFleetRoutingServer struct {
}

func (*UnimplementedFleetRoutingServer) OptimizeTours(context.Context, *OptimizeToursRequest) (*OptimizeToursResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method OptimizeTours not implemented")
}
func (*UnimplementedFleetRoutingServer) BatchOptimizeTours(context.Context, *BatchOptimizeToursRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchOptimizeTours not implemented")
}

func RegisterFleetRoutingServer(s *grpc.Server, srv FleetRoutingServer) {
	s.RegisterService(&_FleetRouting_serviceDesc, srv)
}

func _FleetRouting_OptimizeTours_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(OptimizeToursRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FleetRoutingServer).OptimizeTours(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.optimization.v1.FleetRouting/OptimizeTours",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FleetRoutingServer).OptimizeTours(ctx, req.(*OptimizeToursRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FleetRouting_BatchOptimizeTours_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchOptimizeToursRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FleetRoutingServer).BatchOptimizeTours(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.optimization.v1.FleetRouting/BatchOptimizeTours",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FleetRoutingServer).BatchOptimizeTours(ctx, req.(*BatchOptimizeToursRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _FleetRouting_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.optimization.v1.FleetRouting",
	HandlerType: (*FleetRoutingServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "OptimizeTours",
			Handler:    _FleetRouting_OptimizeTours_Handler,
		},
		{
			MethodName: "BatchOptimizeTours",
			Handler:    _FleetRouting_BatchOptimizeTours_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/optimization/v1/fleet_routing.proto",
}
