// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/gkebackup/v1/gkebackup.proto

package gkebackuppb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	_ "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Represents the metadata of the long-running operation.
type OperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the operation finished running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. Server-defined resource path for the target of the operation.
	Target string `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	// Output only. Name of the verb executed by the operation.
	Verb string `protobuf:"bytes,4,opt,name=verb,proto3" json:"verb,omitempty"`
	// Output only. Human-readable status of the operation, if any.
	StatusMessage string `protobuf:"bytes,5,opt,name=status_message,json=statusMessage,proto3" json:"status_message,omitempty"`
	// Output only. Identifies whether the user has requested cancellation
	// of the operation. Operations that have successfully been cancelled
	// have
	// [google.longrunning.Operation.error][google.longrunning.Operation.error]
	// value with a [google.rpc.Status.code][google.rpc.Status.code] of 1,
	// corresponding to `Code.CANCELLED`.
	RequestedCancellation bool `protobuf:"varint,6,opt,name=requested_cancellation,json=requestedCancellation,proto3" json:"requested_cancellation,omitempty"`
	// Output only. API version used to start the operation.
	ApiVersion string `protobuf:"bytes,7,opt,name=api_version,json=apiVersion,proto3" json:"api_version,omitempty"`
}

func (x *OperationMetadata) Reset() {
	*x = OperationMetadata{}
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperationMetadata) ProtoMessage() {}

func (x *OperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperationMetadata.ProtoReflect.Descriptor instead.
func (*OperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{0}
}

func (x *OperationMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *OperationMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *OperationMetadata) GetTarget() string {
	if x != nil {
		return x.Target
	}
	return ""
}

func (x *OperationMetadata) GetVerb() string {
	if x != nil {
		return x.Verb
	}
	return ""
}

func (x *OperationMetadata) GetStatusMessage() string {
	if x != nil {
		return x.StatusMessage
	}
	return ""
}

func (x *OperationMetadata) GetRequestedCancellation() bool {
	if x != nil {
		return x.RequestedCancellation
	}
	return false
}

func (x *OperationMetadata) GetApiVersion() string {
	if x != nil {
		return x.ApiVersion
	}
	return ""
}

// Request message for CreateBackupPlan.
type CreateBackupPlanRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The location within which to create the BackupPlan.
	// Format: `projects/*/locations/*`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The BackupPlan resource object to create.
	BackupPlan *BackupPlan `protobuf:"bytes,2,opt,name=backup_plan,json=backupPlan,proto3" json:"backup_plan,omitempty"`
	// Required. The client-provided short name for the BackupPlan resource.
	// This name must:
	//
	// - be between 1 and 63 characters long (inclusive)
	// - consist of only lower-case ASCII letters, numbers, and dashes
	// - start with a lower-case letter
	// - end with a lower-case letter or number
	// - be unique within the set of BackupPlans in this location
	BackupPlanId string `protobuf:"bytes,3,opt,name=backup_plan_id,json=backupPlanId,proto3" json:"backup_plan_id,omitempty"`
}

func (x *CreateBackupPlanRequest) Reset() {
	*x = CreateBackupPlanRequest{}
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateBackupPlanRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateBackupPlanRequest) ProtoMessage() {}

func (x *CreateBackupPlanRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateBackupPlanRequest.ProtoReflect.Descriptor instead.
func (*CreateBackupPlanRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{1}
}

func (x *CreateBackupPlanRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateBackupPlanRequest) GetBackupPlan() *BackupPlan {
	if x != nil {
		return x.BackupPlan
	}
	return nil
}

func (x *CreateBackupPlanRequest) GetBackupPlanId() string {
	if x != nil {
		return x.BackupPlanId
	}
	return ""
}

// Request message for ListBackupPlans.
type ListBackupPlansRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The location that contains the BackupPlans to list.
	// Format: `projects/*/locations/*`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The target number of results to return in a single response.
	// If not specified, a default value will be chosen by the service.
	// Note that the response may include a partial list and a caller should
	// only rely on the response's
	// [next_page_token][google.cloud.gkebackup.v1.ListBackupPlansResponse.next_page_token]
	// to determine if there are more instances left to be queried.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The value of
	// [next_page_token][google.cloud.gkebackup.v1.ListBackupPlansResponse.next_page_token]
	// received from a previous `ListBackupPlans` call.
	// Provide this to retrieve the subsequent page in a multi-page list of
	// results. When paginating, all other parameters provided to
	// `ListBackupPlans` must match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Field match expression used to filter the results.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Field by which to sort the results.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListBackupPlansRequest) Reset() {
	*x = ListBackupPlansRequest{}
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListBackupPlansRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBackupPlansRequest) ProtoMessage() {}

func (x *ListBackupPlansRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBackupPlansRequest.ProtoReflect.Descriptor instead.
func (*ListBackupPlansRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{2}
}

func (x *ListBackupPlansRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListBackupPlansRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListBackupPlansRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListBackupPlansRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListBackupPlansRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for ListBackupPlans.
type ListBackupPlansResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of BackupPlans matching the given criteria.
	BackupPlans []*BackupPlan `protobuf:"bytes,1,rep,name=backup_plans,json=backupPlans,proto3" json:"backup_plans,omitempty"`
	// A token which may be sent as
	// [page_token][google.cloud.gkebackup.v1.ListBackupPlansRequest.page_token]
	// in a subsequent `ListBackupPlans` call to retrieve the next page of
	// results. If this field is omitted or empty, then there are no more results
	// to return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListBackupPlansResponse) Reset() {
	*x = ListBackupPlansResponse{}
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListBackupPlansResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBackupPlansResponse) ProtoMessage() {}

func (x *ListBackupPlansResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBackupPlansResponse.ProtoReflect.Descriptor instead.
func (*ListBackupPlansResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{3}
}

func (x *ListBackupPlansResponse) GetBackupPlans() []*BackupPlan {
	if x != nil {
		return x.BackupPlans
	}
	return nil
}

func (x *ListBackupPlansResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListBackupPlansResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for GetBackupPlan.
type GetBackupPlanRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Fully qualified BackupPlan name.
	// Format: `projects/*/locations/*/backupPlans/*`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetBackupPlanRequest) Reset() {
	*x = GetBackupPlanRequest{}
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetBackupPlanRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetBackupPlanRequest) ProtoMessage() {}

func (x *GetBackupPlanRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetBackupPlanRequest.ProtoReflect.Descriptor instead.
func (*GetBackupPlanRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{4}
}

func (x *GetBackupPlanRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for UpdateBackupPlan.
type UpdateBackupPlanRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A new version of the BackupPlan resource that contains updated
	// fields. This may be sparsely populated if an `update_mask` is provided.
	BackupPlan *BackupPlan `protobuf:"bytes,1,opt,name=backup_plan,json=backupPlan,proto3" json:"backup_plan,omitempty"`
	// Optional. This is used to specify the fields to be overwritten in the
	// BackupPlan targeted for update. The values for each of these
	// updated fields will be taken from the `backup_plan` provided
	// with this request. Field names are relative to the root of the resource
	// (e.g., `description`, `backup_config.include_volume_data`, etc.)
	// If no `update_mask` is provided, all fields in `backup_plan` will be
	// written to the target BackupPlan resource.
	// Note that OUTPUT_ONLY and IMMUTABLE fields in `backup_plan` are ignored
	// and are not used to update the target BackupPlan.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateBackupPlanRequest) Reset() {
	*x = UpdateBackupPlanRequest{}
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateBackupPlanRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateBackupPlanRequest) ProtoMessage() {}

func (x *UpdateBackupPlanRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateBackupPlanRequest.ProtoReflect.Descriptor instead.
func (*UpdateBackupPlanRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{5}
}

func (x *UpdateBackupPlanRequest) GetBackupPlan() *BackupPlan {
	if x != nil {
		return x.BackupPlan
	}
	return nil
}

func (x *UpdateBackupPlanRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for DeleteBackupPlan.
type DeleteBackupPlanRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Fully qualified BackupPlan name.
	// Format: `projects/*/locations/*/backupPlans/*`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. If provided, this value must match the current value of the
	// target BackupPlan's [etag][google.cloud.gkebackup.v1.BackupPlan.etag] field
	// or the request is rejected.
	Etag string `protobuf:"bytes,2,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *DeleteBackupPlanRequest) Reset() {
	*x = DeleteBackupPlanRequest{}
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteBackupPlanRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteBackupPlanRequest) ProtoMessage() {}

func (x *DeleteBackupPlanRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteBackupPlanRequest.ProtoReflect.Descriptor instead.
func (*DeleteBackupPlanRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{6}
}

func (x *DeleteBackupPlanRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteBackupPlanRequest) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

// Request message for CreateBackupChannel.
type CreateBackupChannelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The location within which to create the BackupChannel.
	// Format: `projects/*/locations/*`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The BackupChannel resource object to create.
	BackupChannel *BackupChannel `protobuf:"bytes,2,opt,name=backup_channel,json=backupChannel,proto3" json:"backup_channel,omitempty"`
	// Optional. The client-provided short name for the BackupChannel resource.
	// This name must:
	//
	// - be between 1 and 63 characters long (inclusive)
	// - consist of only lower-case ASCII letters, numbers, and dashes
	// - start with a lower-case letter
	// - end with a lower-case letter or number
	// - be unique within the set of BackupChannels in this location
	// If the user does not provide a name, a uuid will be used as the name.
	BackupChannelId string `protobuf:"bytes,3,opt,name=backup_channel_id,json=backupChannelId,proto3" json:"backup_channel_id,omitempty"`
}

func (x *CreateBackupChannelRequest) Reset() {
	*x = CreateBackupChannelRequest{}
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateBackupChannelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateBackupChannelRequest) ProtoMessage() {}

func (x *CreateBackupChannelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateBackupChannelRequest.ProtoReflect.Descriptor instead.
func (*CreateBackupChannelRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{7}
}

func (x *CreateBackupChannelRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateBackupChannelRequest) GetBackupChannel() *BackupChannel {
	if x != nil {
		return x.BackupChannel
	}
	return nil
}

func (x *CreateBackupChannelRequest) GetBackupChannelId() string {
	if x != nil {
		return x.BackupChannelId
	}
	return ""
}

// Request message for ListBackupChannels.
type ListBackupChannelsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The location that contains the BackupChannels to list.
	// Format: `projects/*/locations/*`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The target number of results to return in a single response.
	// If not specified, a default value will be chosen by the service.
	// Note that the response may include a partial list and a caller should
	// only rely on the response's
	// [next_page_token][google.cloud.gkebackup.v1.ListBackupChannelsResponse.next_page_token]
	// to determine if there are more instances left to be queried.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The value of
	// [next_page_token][google.cloud.gkebackup.v1.ListBackupChannelsResponse.next_page_token]
	// received from a previous `ListBackupChannels` call.
	// Provide this to retrieve the subsequent page in a multi-page list of
	// results. When paginating, all other parameters provided to
	// `ListBackupChannels` must match the call that provided the page
	// token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Field match expression used to filter the results.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Field by which to sort the results.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListBackupChannelsRequest) Reset() {
	*x = ListBackupChannelsRequest{}
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListBackupChannelsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBackupChannelsRequest) ProtoMessage() {}

func (x *ListBackupChannelsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBackupChannelsRequest.ProtoReflect.Descriptor instead.
func (*ListBackupChannelsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{8}
}

func (x *ListBackupChannelsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListBackupChannelsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListBackupChannelsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListBackupChannelsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListBackupChannelsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for ListBackupChannels.
type ListBackupChannelsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of BackupChannels matching the given criteria.
	BackupChannels []*BackupChannel `protobuf:"bytes,1,rep,name=backup_channels,json=backupChannels,proto3" json:"backup_channels,omitempty"`
	// A token which may be sent as
	// [page_token][google.cloud.gkebackup.v1.ListBackupChannelsRequest.page_token]
	// in a subsequent `ListBackupChannels` call to retrieve the next page of
	// results. If this field is omitted or empty, then there are no more results
	// to return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListBackupChannelsResponse) Reset() {
	*x = ListBackupChannelsResponse{}
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListBackupChannelsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBackupChannelsResponse) ProtoMessage() {}

func (x *ListBackupChannelsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBackupChannelsResponse.ProtoReflect.Descriptor instead.
func (*ListBackupChannelsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{9}
}

func (x *ListBackupChannelsResponse) GetBackupChannels() []*BackupChannel {
	if x != nil {
		return x.BackupChannels
	}
	return nil
}

func (x *ListBackupChannelsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListBackupChannelsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for GetBackupChannel.
type GetBackupChannelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Fully qualified BackupChannel name.
	// Format: `projects/*/locations/*/backupChannels/*`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetBackupChannelRequest) Reset() {
	*x = GetBackupChannelRequest{}
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetBackupChannelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetBackupChannelRequest) ProtoMessage() {}

func (x *GetBackupChannelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetBackupChannelRequest.ProtoReflect.Descriptor instead.
func (*GetBackupChannelRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{10}
}

func (x *GetBackupChannelRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for UpdateBackupChannel.
type UpdateBackupChannelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A new version of the BackupChannel resource that contains updated
	// fields. This may be sparsely populated if an `update_mask` is provided.
	BackupChannel *BackupChannel `protobuf:"bytes,1,opt,name=backup_channel,json=backupChannel,proto3" json:"backup_channel,omitempty"`
	// Optional. This is used to specify the fields to be overwritten in the
	// BackupChannel targeted for update. The values for each of these
	// updated fields will be taken from the `backup_channel` provided
	// with this request. Field names are relative to the root of the resource
	// (e.g., `description`, `labels`, etc.)
	// If no `update_mask` is provided, all fields in `backup_channel` will
	// be written to the target BackupChannel resource. Note that
	// OUTPUT_ONLY and IMMUTABLE fields in `backup_channel` are ignored and
	// are not used to update the target BackupChannel.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateBackupChannelRequest) Reset() {
	*x = UpdateBackupChannelRequest{}
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateBackupChannelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateBackupChannelRequest) ProtoMessage() {}

func (x *UpdateBackupChannelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateBackupChannelRequest.ProtoReflect.Descriptor instead.
func (*UpdateBackupChannelRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{11}
}

func (x *UpdateBackupChannelRequest) GetBackupChannel() *BackupChannel {
	if x != nil {
		return x.BackupChannel
	}
	return nil
}

func (x *UpdateBackupChannelRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for DeleteBackupChannel.
type DeleteBackupChannelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Fully qualified BackupChannel name.
	// Format: `projects/*/locations/*/backupChannels/*`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. If provided, this value must match the current value of the
	// target BackupChannel's [etag][google.cloud.gkebackup.v1.BackupChannel.etag]
	// field or the request is rejected.
	Etag string `protobuf:"bytes,2,opt,name=etag,proto3" json:"etag,omitempty"`
	// Optional. If set to true, any BackupPlanAssociations below this
	// BackupChannel will also be deleted. Otherwise, the request will only
	// succeed if the BackupChannel has no BackupPlanAssociations.
	Force bool `protobuf:"varint,3,opt,name=force,proto3" json:"force,omitempty"`
}

func (x *DeleteBackupChannelRequest) Reset() {
	*x = DeleteBackupChannelRequest{}
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteBackupChannelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteBackupChannelRequest) ProtoMessage() {}

func (x *DeleteBackupChannelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteBackupChannelRequest.ProtoReflect.Descriptor instead.
func (*DeleteBackupChannelRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{12}
}

func (x *DeleteBackupChannelRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteBackupChannelRequest) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *DeleteBackupChannelRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

// Request message for ListBackupPlanBindings.
type ListBackupPlanBindingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The BackupChannel that contains the BackupPlanBindings to list.
	// Format: `projects/*/locations/*/backupChannels/*`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The target number of results to return in a single response.
	// If not specified, a default value will be chosen by the service.
	// Note that the response may include a partial list and a caller should
	// only rely on the response's
	// [next_page_token][google.cloud.gkebackup.v1.ListBackupPlanBindingsResponse.next_page_token]
	// to determine if there are more instances left to be queried.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The value of
	// [next_page_token][google.cloud.gkebackup.v1.ListBackupPlanBindingsResponse.next_page_token]
	// received from a previous `ListBackupPlanBindings` call.
	// Provide this to retrieve the subsequent page in a multi-page list of
	// results. When paginating, all other parameters provided to
	// `ListBackupPlanBindings` must match the call that provided the page
	// token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Field match expression used to filter the results.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Field by which to sort the results.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListBackupPlanBindingsRequest) Reset() {
	*x = ListBackupPlanBindingsRequest{}
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListBackupPlanBindingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBackupPlanBindingsRequest) ProtoMessage() {}

func (x *ListBackupPlanBindingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBackupPlanBindingsRequest.ProtoReflect.Descriptor instead.
func (*ListBackupPlanBindingsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{13}
}

func (x *ListBackupPlanBindingsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListBackupPlanBindingsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListBackupPlanBindingsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListBackupPlanBindingsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListBackupPlanBindingsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for ListBackupPlanBindings.
type ListBackupPlanBindingsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of BackupPlanBindings matching the given criteria.
	BackupPlanBindings []*BackupPlanBinding `protobuf:"bytes,1,rep,name=backup_plan_bindings,json=backupPlanBindings,proto3" json:"backup_plan_bindings,omitempty"`
	// A token which may be sent as
	// [page_token][google.cloud.gkebackup.v1.ListBackupPlanBindingsRequest.page_token]
	// in a subsequent `ListBackupPlanBindingss` call to retrieve the next page of
	// results. If this field is omitted or empty, then there are no more results
	// to return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListBackupPlanBindingsResponse) Reset() {
	*x = ListBackupPlanBindingsResponse{}
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListBackupPlanBindingsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBackupPlanBindingsResponse) ProtoMessage() {}

func (x *ListBackupPlanBindingsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBackupPlanBindingsResponse.ProtoReflect.Descriptor instead.
func (*ListBackupPlanBindingsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{14}
}

func (x *ListBackupPlanBindingsResponse) GetBackupPlanBindings() []*BackupPlanBinding {
	if x != nil {
		return x.BackupPlanBindings
	}
	return nil
}

func (x *ListBackupPlanBindingsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListBackupPlanBindingsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for GetBackupPlanBinding.
type GetBackupPlanBindingRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Fully qualified BackupPlanBinding name.
	// Format:
	// `projects/*/locations/*/backupChannels/*/backupPlanBindings/*`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetBackupPlanBindingRequest) Reset() {
	*x = GetBackupPlanBindingRequest{}
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetBackupPlanBindingRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetBackupPlanBindingRequest) ProtoMessage() {}

func (x *GetBackupPlanBindingRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetBackupPlanBindingRequest.ProtoReflect.Descriptor instead.
func (*GetBackupPlanBindingRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{15}
}

func (x *GetBackupPlanBindingRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for CreateBackup.
type CreateBackupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The BackupPlan within which to create the Backup.
	// Format: `projects/*/locations/*/backupPlans/*`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The Backup resource to create.
	Backup *Backup `protobuf:"bytes,2,opt,name=backup,proto3" json:"backup,omitempty"`
	// Optional. The client-provided short name for the Backup resource.
	// This name must:
	//
	// - be between 1 and 63 characters long (inclusive)
	// - consist of only lower-case ASCII letters, numbers, and dashes
	// - start with a lower-case letter
	// - end with a lower-case letter or number
	// - be unique within the set of Backups in this BackupPlan
	BackupId string `protobuf:"bytes,3,opt,name=backup_id,json=backupId,proto3" json:"backup_id,omitempty"`
}

func (x *CreateBackupRequest) Reset() {
	*x = CreateBackupRequest{}
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateBackupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateBackupRequest) ProtoMessage() {}

func (x *CreateBackupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateBackupRequest.ProtoReflect.Descriptor instead.
func (*CreateBackupRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{16}
}

func (x *CreateBackupRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateBackupRequest) GetBackup() *Backup {
	if x != nil {
		return x.Backup
	}
	return nil
}

func (x *CreateBackupRequest) GetBackupId() string {
	if x != nil {
		return x.BackupId
	}
	return ""
}

// Request message for ListBackups.
type ListBackupsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The BackupPlan that contains the Backups to list.
	// Format: `projects/*/locations/*/backupPlans/*`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The target number of results to return in a single response.
	// If not specified, a default value will be chosen by the service.
	// Note that the response may include a partial list and a caller should
	// only rely on the response's
	// [next_page_token][google.cloud.gkebackup.v1.ListBackupsResponse.next_page_token]
	// to determine if there are more instances left to be queried.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The value of
	// [next_page_token][google.cloud.gkebackup.v1.ListBackupsResponse.next_page_token]
	// received from a previous `ListBackups` call.
	// Provide this to retrieve the subsequent page in a multi-page list of
	// results. When paginating, all other parameters provided to
	// `ListBackups` must match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Field match expression used to filter the results.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Field by which to sort the results.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// Optional. If set to true, the response will return partial results when
	// some regions are unreachable and the unreachable field will be populated.
	ReturnPartialSuccess bool `protobuf:"varint,6,opt,name=return_partial_success,json=returnPartialSuccess,proto3" json:"return_partial_success,omitempty"`
}

func (x *ListBackupsRequest) Reset() {
	*x = ListBackupsRequest{}
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListBackupsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBackupsRequest) ProtoMessage() {}

func (x *ListBackupsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBackupsRequest.ProtoReflect.Descriptor instead.
func (*ListBackupsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{17}
}

func (x *ListBackupsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListBackupsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListBackupsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListBackupsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListBackupsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

func (x *ListBackupsRequest) GetReturnPartialSuccess() bool {
	if x != nil {
		return x.ReturnPartialSuccess
	}
	return false
}

// Response message for ListBackups.
type ListBackupsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of Backups matching the given criteria.
	Backups []*Backup `protobuf:"bytes,1,rep,name=backups,proto3" json:"backups,omitempty"`
	// A token which may be sent as
	// [page_token][google.cloud.gkebackup.v1.ListBackupsRequest.page_token] in a
	// subsequent `ListBackups` call to retrieve the next page of results. If this
	// field is omitted or empty, then there are no more results to return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListBackupsResponse) Reset() {
	*x = ListBackupsResponse{}
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListBackupsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBackupsResponse) ProtoMessage() {}

func (x *ListBackupsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBackupsResponse.ProtoReflect.Descriptor instead.
func (*ListBackupsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{18}
}

func (x *ListBackupsResponse) GetBackups() []*Backup {
	if x != nil {
		return x.Backups
	}
	return nil
}

func (x *ListBackupsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListBackupsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for GetBackup.
type GetBackupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Full name of the Backup resource.
	// Format: `projects/*/locations/*/backupPlans/*/backups/*`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetBackupRequest) Reset() {
	*x = GetBackupRequest{}
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetBackupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetBackupRequest) ProtoMessage() {}

func (x *GetBackupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetBackupRequest.ProtoReflect.Descriptor instead.
func (*GetBackupRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{19}
}

func (x *GetBackupRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for UpdateBackup.
type UpdateBackupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A new version of the Backup resource that contains updated
	// fields. This may be sparsely populated if an `update_mask` is provided.
	Backup *Backup `protobuf:"bytes,1,opt,name=backup,proto3" json:"backup,omitempty"`
	// Optional. This is used to specify the fields to be overwritten in the
	// Backup targeted for update. The values for each of these
	// updated fields will be taken from the `backup_plan` provided
	// with this request. Field names are relative to the root of the resource.
	// If no `update_mask` is provided, all fields in `backup` will be
	// written to the target Backup resource.
	// Note that OUTPUT_ONLY and IMMUTABLE fields in `backup` are ignored
	// and are not used to update the target Backup.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateBackupRequest) Reset() {
	*x = UpdateBackupRequest{}
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateBackupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateBackupRequest) ProtoMessage() {}

func (x *UpdateBackupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateBackupRequest.ProtoReflect.Descriptor instead.
func (*UpdateBackupRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{20}
}

func (x *UpdateBackupRequest) GetBackup() *Backup {
	if x != nil {
		return x.Backup
	}
	return nil
}

func (x *UpdateBackupRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for DeleteBackup.
type DeleteBackupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the Backup resource.
	// Format: `projects/*/locations/*/backupPlans/*/backups/*`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. If provided, this value must match the current value of the
	// target Backup's [etag][google.cloud.gkebackup.v1.Backup.etag] field or the
	// request is rejected.
	Etag string `protobuf:"bytes,2,opt,name=etag,proto3" json:"etag,omitempty"`
	// Optional. If set to true, any VolumeBackups below this Backup will also be
	// deleted. Otherwise, the request will only succeed if the Backup has no
	// VolumeBackups.
	Force bool `protobuf:"varint,3,opt,name=force,proto3" json:"force,omitempty"`
}

func (x *DeleteBackupRequest) Reset() {
	*x = DeleteBackupRequest{}
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteBackupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteBackupRequest) ProtoMessage() {}

func (x *DeleteBackupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteBackupRequest.ProtoReflect.Descriptor instead.
func (*DeleteBackupRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{21}
}

func (x *DeleteBackupRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteBackupRequest) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *DeleteBackupRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

// Request message for ListVolumeBackups.
type ListVolumeBackupsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Backup that contains the VolumeBackups to list.
	// Format: `projects/*/locations/*/backupPlans/*/backups/*`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The target number of results to return in a single response.
	// If not specified, a default value will be chosen by the service.
	// Note that the response may include a partial list and a caller should
	// only rely on the response's
	// [next_page_token][google.cloud.gkebackup.v1.ListVolumeBackupsResponse.next_page_token]
	// to determine if there are more instances left to be queried.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The value of
	// [next_page_token][google.cloud.gkebackup.v1.ListVolumeBackupsResponse.next_page_token]
	// received from a previous `ListVolumeBackups` call.
	// Provide this to retrieve the subsequent page in a multi-page list of
	// results. When paginating, all other parameters provided to
	// `ListVolumeBackups` must match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Field match expression used to filter the results.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Field by which to sort the results.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListVolumeBackupsRequest) Reset() {
	*x = ListVolumeBackupsRequest{}
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListVolumeBackupsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListVolumeBackupsRequest) ProtoMessage() {}

func (x *ListVolumeBackupsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListVolumeBackupsRequest.ProtoReflect.Descriptor instead.
func (*ListVolumeBackupsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{22}
}

func (x *ListVolumeBackupsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListVolumeBackupsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListVolumeBackupsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListVolumeBackupsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListVolumeBackupsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for ListVolumeBackups.
type ListVolumeBackupsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of VolumeBackups matching the given criteria.
	VolumeBackups []*VolumeBackup `protobuf:"bytes,1,rep,name=volume_backups,json=volumeBackups,proto3" json:"volume_backups,omitempty"`
	// A token which may be sent as
	// [page_token][google.cloud.gkebackup.v1.ListVolumeBackupsRequest.page_token]
	// in a subsequent `ListVolumeBackups` call to retrieve the next page of
	// results. If this field is omitted or empty, then there are no more results
	// to return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListVolumeBackupsResponse) Reset() {
	*x = ListVolumeBackupsResponse{}
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListVolumeBackupsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListVolumeBackupsResponse) ProtoMessage() {}

func (x *ListVolumeBackupsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListVolumeBackupsResponse.ProtoReflect.Descriptor instead.
func (*ListVolumeBackupsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{23}
}

func (x *ListVolumeBackupsResponse) GetVolumeBackups() []*VolumeBackup {
	if x != nil {
		return x.VolumeBackups
	}
	return nil
}

func (x *ListVolumeBackupsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for GetVolumeBackup.
type GetVolumeBackupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Full name of the VolumeBackup resource.
	// Format: `projects/*/locations/*/backupPlans/*/backups/*/volumeBackups/*`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetVolumeBackupRequest) Reset() {
	*x = GetVolumeBackupRequest{}
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetVolumeBackupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetVolumeBackupRequest) ProtoMessage() {}

func (x *GetVolumeBackupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetVolumeBackupRequest.ProtoReflect.Descriptor instead.
func (*GetVolumeBackupRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{24}
}

func (x *GetVolumeBackupRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for CreateRestorePlan.
type CreateRestorePlanRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The location within which to create the RestorePlan.
	// Format: `projects/*/locations/*`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The RestorePlan resource object to create.
	RestorePlan *RestorePlan `protobuf:"bytes,2,opt,name=restore_plan,json=restorePlan,proto3" json:"restore_plan,omitempty"`
	// Required. The client-provided short name for the RestorePlan resource.
	// This name must:
	//
	// - be between 1 and 63 characters long (inclusive)
	// - consist of only lower-case ASCII letters, numbers, and dashes
	// - start with a lower-case letter
	// - end with a lower-case letter or number
	// - be unique within the set of RestorePlans in this location
	RestorePlanId string `protobuf:"bytes,3,opt,name=restore_plan_id,json=restorePlanId,proto3" json:"restore_plan_id,omitempty"`
}

func (x *CreateRestorePlanRequest) Reset() {
	*x = CreateRestorePlanRequest{}
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateRestorePlanRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateRestorePlanRequest) ProtoMessage() {}

func (x *CreateRestorePlanRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateRestorePlanRequest.ProtoReflect.Descriptor instead.
func (*CreateRestorePlanRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{25}
}

func (x *CreateRestorePlanRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateRestorePlanRequest) GetRestorePlan() *RestorePlan {
	if x != nil {
		return x.RestorePlan
	}
	return nil
}

func (x *CreateRestorePlanRequest) GetRestorePlanId() string {
	if x != nil {
		return x.RestorePlanId
	}
	return ""
}

// Request message for ListRestorePlans.
type ListRestorePlansRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The location that contains the RestorePlans to list.
	// Format: `projects/*/locations/*`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The target number of results to return in a single response.
	// If not specified, a default value will be chosen by the service.
	// Note that the response may include a partial list and a caller should
	// only rely on the response's
	// [next_page_token][google.cloud.gkebackup.v1.ListRestorePlansResponse.next_page_token]
	// to determine if there are more instances left to be queried.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The value of
	// [next_page_token][google.cloud.gkebackup.v1.ListRestorePlansResponse.next_page_token]
	// received from a previous `ListRestorePlans` call.
	// Provide this to retrieve the subsequent page in a multi-page list of
	// results. When paginating, all other parameters provided to
	// `ListRestorePlans` must match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Field match expression used to filter the results.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Field by which to sort the results.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListRestorePlansRequest) Reset() {
	*x = ListRestorePlansRequest{}
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListRestorePlansRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRestorePlansRequest) ProtoMessage() {}

func (x *ListRestorePlansRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRestorePlansRequest.ProtoReflect.Descriptor instead.
func (*ListRestorePlansRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{26}
}

func (x *ListRestorePlansRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListRestorePlansRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListRestorePlansRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListRestorePlansRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListRestorePlansRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for ListRestorePlans.
type ListRestorePlansResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of RestorePlans matching the given criteria.
	RestorePlans []*RestorePlan `protobuf:"bytes,1,rep,name=restore_plans,json=restorePlans,proto3" json:"restore_plans,omitempty"`
	// A token which may be sent as
	// [page_token][google.cloud.gkebackup.v1.ListRestorePlansRequest.page_token]
	// in a subsequent `ListRestorePlans` call to retrieve the next page of
	// results. If this field is omitted or empty, then there are no more results
	// to return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListRestorePlansResponse) Reset() {
	*x = ListRestorePlansResponse{}
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListRestorePlansResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRestorePlansResponse) ProtoMessage() {}

func (x *ListRestorePlansResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRestorePlansResponse.ProtoReflect.Descriptor instead.
func (*ListRestorePlansResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{27}
}

func (x *ListRestorePlansResponse) GetRestorePlans() []*RestorePlan {
	if x != nil {
		return x.RestorePlans
	}
	return nil
}

func (x *ListRestorePlansResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListRestorePlansResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for GetRestorePlan.
type GetRestorePlanRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Fully qualified RestorePlan name.
	// Format: `projects/*/locations/*/restorePlans/*`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetRestorePlanRequest) Reset() {
	*x = GetRestorePlanRequest{}
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetRestorePlanRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRestorePlanRequest) ProtoMessage() {}

func (x *GetRestorePlanRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetRestorePlanRequest.ProtoReflect.Descriptor instead.
func (*GetRestorePlanRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{28}
}

func (x *GetRestorePlanRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for UpdateRestorePlan.
type UpdateRestorePlanRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A new version of the RestorePlan resource that contains updated
	// fields. This may be sparsely populated if an `update_mask` is provided.
	RestorePlan *RestorePlan `protobuf:"bytes,1,opt,name=restore_plan,json=restorePlan,proto3" json:"restore_plan,omitempty"`
	// Optional. This is used to specify the fields to be overwritten in the
	// RestorePlan targeted for update. The values for each of these
	// updated fields will be taken from the `restore_plan` provided
	// with this request. Field names are relative to the root of the resource.
	// If no `update_mask` is provided, all fields in `restore_plan` will be
	// written to the target RestorePlan resource.
	// Note that OUTPUT_ONLY and IMMUTABLE fields in `restore_plan` are ignored
	// and are not used to update the target RestorePlan.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateRestorePlanRequest) Reset() {
	*x = UpdateRestorePlanRequest{}
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateRestorePlanRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateRestorePlanRequest) ProtoMessage() {}

func (x *UpdateRestorePlanRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateRestorePlanRequest.ProtoReflect.Descriptor instead.
func (*UpdateRestorePlanRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{29}
}

func (x *UpdateRestorePlanRequest) GetRestorePlan() *RestorePlan {
	if x != nil {
		return x.RestorePlan
	}
	return nil
}

func (x *UpdateRestorePlanRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for DeleteRestorePlan.
type DeleteRestorePlanRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Fully qualified RestorePlan name.
	// Format: `projects/*/locations/*/restorePlans/*`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. If provided, this value must match the current value of the
	// target RestorePlan's [etag][google.cloud.gkebackup.v1.RestorePlan.etag]
	// field or the request is rejected.
	Etag string `protobuf:"bytes,2,opt,name=etag,proto3" json:"etag,omitempty"`
	// Optional. If set to true, any Restores below this RestorePlan will also be
	// deleted. Otherwise, the request will only succeed if the RestorePlan has no
	// Restores.
	Force bool `protobuf:"varint,3,opt,name=force,proto3" json:"force,omitempty"`
}

func (x *DeleteRestorePlanRequest) Reset() {
	*x = DeleteRestorePlanRequest{}
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteRestorePlanRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteRestorePlanRequest) ProtoMessage() {}

func (x *DeleteRestorePlanRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteRestorePlanRequest.ProtoReflect.Descriptor instead.
func (*DeleteRestorePlanRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{30}
}

func (x *DeleteRestorePlanRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteRestorePlanRequest) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *DeleteRestorePlanRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

// Request message for CreateRestoreChannel.
type CreateRestoreChannelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The location within which to create the RestoreChannel.
	// Format: `projects/*/locations/*`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The RestoreChannel resource object to create.
	RestoreChannel *RestoreChannel `protobuf:"bytes,2,opt,name=restore_channel,json=restoreChannel,proto3" json:"restore_channel,omitempty"`
	// Optional. The client-provided short name for the RestoreChannel resource.
	// This name must:
	//
	// - be between 1 and 63 characters long (inclusive)
	// - consist of only lower-case ASCII letters, numbers, and dashes
	// - start with a lower-case letter
	// - end with a lower-case letter or number
	// - be unique within the set of RestoreChannels in this location
	// If the user does not provide a name, a uuid will be used as the name.
	RestoreChannelId string `protobuf:"bytes,3,opt,name=restore_channel_id,json=restoreChannelId,proto3" json:"restore_channel_id,omitempty"`
}

func (x *CreateRestoreChannelRequest) Reset() {
	*x = CreateRestoreChannelRequest{}
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateRestoreChannelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateRestoreChannelRequest) ProtoMessage() {}

func (x *CreateRestoreChannelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateRestoreChannelRequest.ProtoReflect.Descriptor instead.
func (*CreateRestoreChannelRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{31}
}

func (x *CreateRestoreChannelRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateRestoreChannelRequest) GetRestoreChannel() *RestoreChannel {
	if x != nil {
		return x.RestoreChannel
	}
	return nil
}

func (x *CreateRestoreChannelRequest) GetRestoreChannelId() string {
	if x != nil {
		return x.RestoreChannelId
	}
	return ""
}

// Request message for ListRestoreChannels.
type ListRestoreChannelsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The location that contains the RestoreChannels to list.
	// Format: `projects/*/locations/*`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The target number of results to return in a single response.
	// If not specified, a default value will be chosen by the service.
	// Note that the response may include a partial list and a caller should
	// only rely on the response's
	// [next_page_token][google.cloud.gkebackup.v1.ListRestoreChannelsResponse.next_page_token]
	// to determine if there are more instances left to be queried.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The value of
	// [next_page_token][google.cloud.gkebackup.v1.ListRestoreChannelsResponse.next_page_token]
	// received from a previous `ListRestoreChannels` call.
	// Provide this to retrieve the subsequent page in a multi-page list of
	// results. When paginating, all other parameters provided to
	// `ListRestoreChannels` must match the call that provided the page
	// token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Field match expression used to filter the results.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Field by which to sort the results.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListRestoreChannelsRequest) Reset() {
	*x = ListRestoreChannelsRequest{}
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListRestoreChannelsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRestoreChannelsRequest) ProtoMessage() {}

func (x *ListRestoreChannelsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRestoreChannelsRequest.ProtoReflect.Descriptor instead.
func (*ListRestoreChannelsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{32}
}

func (x *ListRestoreChannelsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListRestoreChannelsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListRestoreChannelsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListRestoreChannelsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListRestoreChannelsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for ListRestoreChannels.
type ListRestoreChannelsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of RestoreChannels matching the given criteria.
	RestoreChannels []*RestoreChannel `protobuf:"bytes,1,rep,name=restore_channels,json=restoreChannels,proto3" json:"restore_channels,omitempty"`
	// A token which may be sent as
	// [page_token][google.cloud.gkebackup.v1.ListRestoreChannelsRequest.page_token]
	// in a subsequent `ListRestoreChannels` call to retrieve the next page of
	// results. If this field is omitted or empty, then there are no more results
	// to return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListRestoreChannelsResponse) Reset() {
	*x = ListRestoreChannelsResponse{}
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[33]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListRestoreChannelsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRestoreChannelsResponse) ProtoMessage() {}

func (x *ListRestoreChannelsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[33]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRestoreChannelsResponse.ProtoReflect.Descriptor instead.
func (*ListRestoreChannelsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{33}
}

func (x *ListRestoreChannelsResponse) GetRestoreChannels() []*RestoreChannel {
	if x != nil {
		return x.RestoreChannels
	}
	return nil
}

func (x *ListRestoreChannelsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListRestoreChannelsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for GetRestoreChannel.
type GetRestoreChannelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Fully qualified RestoreChannel name.
	// Format: `projects/*/locations/*/restoreChannels/*`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetRestoreChannelRequest) Reset() {
	*x = GetRestoreChannelRequest{}
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[34]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetRestoreChannelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRestoreChannelRequest) ProtoMessage() {}

func (x *GetRestoreChannelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[34]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetRestoreChannelRequest.ProtoReflect.Descriptor instead.
func (*GetRestoreChannelRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{34}
}

func (x *GetRestoreChannelRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for UpdateRestoreChannel.
type UpdateRestoreChannelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A new version of the RestoreChannel resource that contains
	// updated fields. This may be sparsely populated if an `update_mask` is
	// provided.
	RestoreChannel *RestoreChannel `protobuf:"bytes,1,opt,name=restore_channel,json=restoreChannel,proto3" json:"restore_channel,omitempty"`
	// Optional. This is used to specify the fields to be overwritten in the
	// RestoreChannel targeted for update. The values for each of these
	// updated fields will be taken from the `restore_channel` provided
	// with this request. Field names are relative to the root of the resource
	// (e.g., `description`, `destination_project_id`, etc.)
	// If no `update_mask` is provided, all fields in `restore_channel` will
	// be written to the target RestoreChannel resource. Note that
	// OUTPUT_ONLY and IMMUTABLE fields in `restore_channel` are ignored and
	// are not used to update the target RestoreChannel.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateRestoreChannelRequest) Reset() {
	*x = UpdateRestoreChannelRequest{}
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[35]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateRestoreChannelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateRestoreChannelRequest) ProtoMessage() {}

func (x *UpdateRestoreChannelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[35]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateRestoreChannelRequest.ProtoReflect.Descriptor instead.
func (*UpdateRestoreChannelRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{35}
}

func (x *UpdateRestoreChannelRequest) GetRestoreChannel() *RestoreChannel {
	if x != nil {
		return x.RestoreChannel
	}
	return nil
}

func (x *UpdateRestoreChannelRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for DeleteRestoreChannel.
type DeleteRestoreChannelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Fully qualified RestoreChannel name.
	// Format: `projects/*/locations/*/restoreChannels/*`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. If provided, this value must match the current value of the
	// target RestoreChannel's
	// [etag][google.cloud.gkebackup.v1.RestoreChannel.etag] field or the request
	// is rejected.
	Etag string `protobuf:"bytes,2,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *DeleteRestoreChannelRequest) Reset() {
	*x = DeleteRestoreChannelRequest{}
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[36]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteRestoreChannelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteRestoreChannelRequest) ProtoMessage() {}

func (x *DeleteRestoreChannelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[36]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteRestoreChannelRequest.ProtoReflect.Descriptor instead.
func (*DeleteRestoreChannelRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{36}
}

func (x *DeleteRestoreChannelRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteRestoreChannelRequest) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

// Request message for ListRestorePlanBindings.
type ListRestorePlanBindingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The RestoreChannel that contains the ListRestorePlanBindings to
	// list. Format: `projects/*/locations/*/restoreChannels/*`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The target number of results to return in a single response.
	// If not specified, a default value will be chosen by the service.
	// Note that the response may include a partial list and a caller should
	// only rely on the response's
	// [next_page_token][google.cloud.gkebackup.v1.ListRestorePlanBindingsResponse.next_page_token]
	// to determine if there are more instances left to be queried.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The value of
	// [next_page_token][google.cloud.gkebackup.v1.ListRestorePlanBindingsResponse.next_page_token]
	// received from a previous `ListRestorePlanBindings` call.
	// Provide this to retrieve the subsequent page in a multi-page list of
	// results. When paginating, all other parameters provided to
	// `ListRestorePlanBindings` must match the call that provided the page
	// token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Field match expression used to filter the results.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Field by which to sort the results.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListRestorePlanBindingsRequest) Reset() {
	*x = ListRestorePlanBindingsRequest{}
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[37]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListRestorePlanBindingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRestorePlanBindingsRequest) ProtoMessage() {}

func (x *ListRestorePlanBindingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[37]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRestorePlanBindingsRequest.ProtoReflect.Descriptor instead.
func (*ListRestorePlanBindingsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{37}
}

func (x *ListRestorePlanBindingsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListRestorePlanBindingsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListRestorePlanBindingsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListRestorePlanBindingsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListRestorePlanBindingsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for ListRestorePlanBindings.
type ListRestorePlanBindingsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of RestorePlanBindings matching the given criteria.
	RestorePlanBindings []*RestorePlanBinding `protobuf:"bytes,1,rep,name=restore_plan_bindings,json=restorePlanBindings,proto3" json:"restore_plan_bindings,omitempty"`
	// A token which may be sent as
	// [page_token][google.cloud.gkebackup.v1.ListRestorePlanBindingsRequest.page_token]
	// in a subsequent `ListRestorePlanBindings` call to retrieve the next page of
	// results. If this field is omitted or empty, then there are no more results
	// to return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Unordered list. Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListRestorePlanBindingsResponse) Reset() {
	*x = ListRestorePlanBindingsResponse{}
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[38]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListRestorePlanBindingsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRestorePlanBindingsResponse) ProtoMessage() {}

func (x *ListRestorePlanBindingsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[38]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRestorePlanBindingsResponse.ProtoReflect.Descriptor instead.
func (*ListRestorePlanBindingsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{38}
}

func (x *ListRestorePlanBindingsResponse) GetRestorePlanBindings() []*RestorePlanBinding {
	if x != nil {
		return x.RestorePlanBindings
	}
	return nil
}

func (x *ListRestorePlanBindingsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListRestorePlanBindingsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for GetRestorePlanBinding.
type GetRestorePlanBindingRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Fully qualified RestorePlanBinding name.
	// Format:
	// `projects/*/locations/*/restoreChannels/*/restorePlanBindings/*`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetRestorePlanBindingRequest) Reset() {
	*x = GetRestorePlanBindingRequest{}
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[39]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetRestorePlanBindingRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRestorePlanBindingRequest) ProtoMessage() {}

func (x *GetRestorePlanBindingRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[39]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetRestorePlanBindingRequest.ProtoReflect.Descriptor instead.
func (*GetRestorePlanBindingRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{39}
}

func (x *GetRestorePlanBindingRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for CreateRestore.
type CreateRestoreRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The RestorePlan within which to create the Restore.
	// Format: `projects/*/locations/*/restorePlans/*`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The restore resource to create.
	Restore *Restore `protobuf:"bytes,2,opt,name=restore,proto3" json:"restore,omitempty"`
	// Required. The client-provided short name for the Restore resource.
	// This name must:
	//
	// - be between 1 and 63 characters long (inclusive)
	// - consist of only lower-case ASCII letters, numbers, and dashes
	// - start with a lower-case letter
	// - end with a lower-case letter or number
	// - be unique within the set of Restores in this RestorePlan.
	RestoreId string `protobuf:"bytes,3,opt,name=restore_id,json=restoreId,proto3" json:"restore_id,omitempty"`
}

func (x *CreateRestoreRequest) Reset() {
	*x = CreateRestoreRequest{}
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[40]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateRestoreRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateRestoreRequest) ProtoMessage() {}

func (x *CreateRestoreRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[40]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateRestoreRequest.ProtoReflect.Descriptor instead.
func (*CreateRestoreRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{40}
}

func (x *CreateRestoreRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateRestoreRequest) GetRestore() *Restore {
	if x != nil {
		return x.Restore
	}
	return nil
}

func (x *CreateRestoreRequest) GetRestoreId() string {
	if x != nil {
		return x.RestoreId
	}
	return ""
}

// Request message for ListRestores.
type ListRestoresRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The RestorePlan that contains the Restores to list.
	// Format: `projects/*/locations/*/restorePlans/*`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The target number of results to return in a single response.
	// If not specified, a default value will be chosen by the service.
	// Note that the response may include a partial list and a caller should
	// only rely on the response's
	// [next_page_token][google.cloud.gkebackup.v1.ListRestoresResponse.next_page_token]
	// to determine if there are more instances left to be queried.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The value of
	// [next_page_token][google.cloud.gkebackup.v1.ListRestoresResponse.next_page_token]
	// received from a previous `ListRestores` call.
	// Provide this to retrieve the subsequent page in a multi-page list of
	// results. When paginating, all other parameters provided to `ListRestores`
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Field match expression used to filter the results.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Field by which to sort the results.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListRestoresRequest) Reset() {
	*x = ListRestoresRequest{}
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[41]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListRestoresRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRestoresRequest) ProtoMessage() {}

func (x *ListRestoresRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[41]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRestoresRequest.ProtoReflect.Descriptor instead.
func (*ListRestoresRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{41}
}

func (x *ListRestoresRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListRestoresRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListRestoresRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListRestoresRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListRestoresRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for ListRestores.
type ListRestoresResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of Restores matching the given criteria.
	Restores []*Restore `protobuf:"bytes,1,rep,name=restores,proto3" json:"restores,omitempty"`
	// A token which may be sent as
	// [page_token][google.cloud.gkebackup.v1.ListRestoresRequest.page_token] in a
	// subsequent `ListRestores` call to retrieve the next page of results. If
	// this field is omitted or empty, then there are no more results to return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListRestoresResponse) Reset() {
	*x = ListRestoresResponse{}
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[42]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListRestoresResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRestoresResponse) ProtoMessage() {}

func (x *ListRestoresResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[42]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRestoresResponse.ProtoReflect.Descriptor instead.
func (*ListRestoresResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{42}
}

func (x *ListRestoresResponse) GetRestores() []*Restore {
	if x != nil {
		return x.Restores
	}
	return nil
}

func (x *ListRestoresResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListRestoresResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for GetRestore.
type GetRestoreRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the restore resource.
	// Format: `projects/*/locations/*/restorePlans/*/restores/*`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetRestoreRequest) Reset() {
	*x = GetRestoreRequest{}
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[43]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetRestoreRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRestoreRequest) ProtoMessage() {}

func (x *GetRestoreRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[43]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetRestoreRequest.ProtoReflect.Descriptor instead.
func (*GetRestoreRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{43}
}

func (x *GetRestoreRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for UpdateRestore.
type UpdateRestoreRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A new version of the Restore resource that contains updated
	// fields. This may be sparsely populated if an `update_mask` is provided.
	Restore *Restore `protobuf:"bytes,1,opt,name=restore,proto3" json:"restore,omitempty"`
	// Optional. This is used to specify the fields to be overwritten in the
	// Restore targeted for update. The values for each of these
	// updated fields will be taken from the `restore` provided
	// with this request. Field names are relative to the root of the resource.
	// If no `update_mask` is provided, all fields in `restore` will be
	// written to the target Restore resource.
	// Note that OUTPUT_ONLY and IMMUTABLE fields in `restore` are ignored
	// and are not used to update the target Restore.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateRestoreRequest) Reset() {
	*x = UpdateRestoreRequest{}
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[44]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateRestoreRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateRestoreRequest) ProtoMessage() {}

func (x *UpdateRestoreRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[44]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateRestoreRequest.ProtoReflect.Descriptor instead.
func (*UpdateRestoreRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{44}
}

func (x *UpdateRestoreRequest) GetRestore() *Restore {
	if x != nil {
		return x.Restore
	}
	return nil
}

func (x *UpdateRestoreRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for DeleteRestore.
type DeleteRestoreRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Full name of the Restore
	// Format: `projects/*/locations/*/restorePlans/*/restores/*`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. If provided, this value must match the current value of the
	// target Restore's [etag][google.cloud.gkebackup.v1.Restore.etag] field or
	// the request is rejected.
	Etag string `protobuf:"bytes,2,opt,name=etag,proto3" json:"etag,omitempty"`
	// Optional. If set to true, any VolumeRestores below this restore will also
	// be deleted. Otherwise, the request will only succeed if the restore has no
	// VolumeRestores.
	Force bool `protobuf:"varint,3,opt,name=force,proto3" json:"force,omitempty"`
}

func (x *DeleteRestoreRequest) Reset() {
	*x = DeleteRestoreRequest{}
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[45]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteRestoreRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteRestoreRequest) ProtoMessage() {}

func (x *DeleteRestoreRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[45]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteRestoreRequest.ProtoReflect.Descriptor instead.
func (*DeleteRestoreRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{45}
}

func (x *DeleteRestoreRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteRestoreRequest) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *DeleteRestoreRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

// Request message for ListVolumeRestores.
type ListVolumeRestoresRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Restore that contains the VolumeRestores to list.
	// Format: `projects/*/locations/*/restorePlans/*/restores/*`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The target number of results to return in a single response.
	// If not specified, a default value will be chosen by the service.
	// Note that the response may include a partial list and a caller should
	// only rely on the response's
	// [next_page_token][google.cloud.gkebackup.v1.ListVolumeRestoresResponse.next_page_token]
	// to determine if there are more instances left to be queried.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The value of
	// [next_page_token][google.cloud.gkebackup.v1.ListVolumeRestoresResponse.next_page_token]
	// received from a previous `ListVolumeRestores` call.
	// Provide this to retrieve the subsequent page in a multi-page list of
	// results. When paginating, all other parameters provided to
	// `ListVolumeRestores` must match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Field match expression used to filter the results.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Field by which to sort the results.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListVolumeRestoresRequest) Reset() {
	*x = ListVolumeRestoresRequest{}
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[46]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListVolumeRestoresRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListVolumeRestoresRequest) ProtoMessage() {}

func (x *ListVolumeRestoresRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[46]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListVolumeRestoresRequest.ProtoReflect.Descriptor instead.
func (*ListVolumeRestoresRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{46}
}

func (x *ListVolumeRestoresRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListVolumeRestoresRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListVolumeRestoresRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListVolumeRestoresRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListVolumeRestoresRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for ListVolumeRestores.
type ListVolumeRestoresResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of VolumeRestores matching the given criteria.
	VolumeRestores []*VolumeRestore `protobuf:"bytes,1,rep,name=volume_restores,json=volumeRestores,proto3" json:"volume_restores,omitempty"`
	// A token which may be sent as
	// [page_token][google.cloud.gkebackup.v1.ListVolumeRestoresRequest.page_token]
	// in a subsequent `ListVolumeRestores` call to retrieve the next page of
	// results. If this field is omitted or empty, then there are no more results
	// to return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListVolumeRestoresResponse) Reset() {
	*x = ListVolumeRestoresResponse{}
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[47]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListVolumeRestoresResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListVolumeRestoresResponse) ProtoMessage() {}

func (x *ListVolumeRestoresResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[47]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListVolumeRestoresResponse.ProtoReflect.Descriptor instead.
func (*ListVolumeRestoresResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{47}
}

func (x *ListVolumeRestoresResponse) GetVolumeRestores() []*VolumeRestore {
	if x != nil {
		return x.VolumeRestores
	}
	return nil
}

func (x *ListVolumeRestoresResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for GetVolumeRestore.
type GetVolumeRestoreRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Full name of the VolumeRestore resource.
	// Format: `projects/*/locations/*/restorePlans/*/restores/*/volumeRestores/*`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetVolumeRestoreRequest) Reset() {
	*x = GetVolumeRestoreRequest{}
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[48]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetVolumeRestoreRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetVolumeRestoreRequest) ProtoMessage() {}

func (x *GetVolumeRestoreRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[48]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetVolumeRestoreRequest.ProtoReflect.Descriptor instead.
func (*GetVolumeRestoreRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{48}
}

func (x *GetVolumeRestoreRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for GetBackupIndexDownloadUrl.
type GetBackupIndexDownloadUrlRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Full name of Backup resource.
	// Format:
	// projects/{project}/locations/{location}/backupPlans/{backup_plan}/backups/{backup}
	Backup string `protobuf:"bytes,1,opt,name=backup,proto3" json:"backup,omitempty"`
}

func (x *GetBackupIndexDownloadUrlRequest) Reset() {
	*x = GetBackupIndexDownloadUrlRequest{}
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[49]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetBackupIndexDownloadUrlRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetBackupIndexDownloadUrlRequest) ProtoMessage() {}

func (x *GetBackupIndexDownloadUrlRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[49]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetBackupIndexDownloadUrlRequest.ProtoReflect.Descriptor instead.
func (*GetBackupIndexDownloadUrlRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{49}
}

func (x *GetBackupIndexDownloadUrlRequest) GetBackup() string {
	if x != nil {
		return x.Backup
	}
	return ""
}

// Response message for GetBackupIndexDownloadUrl.
type GetBackupIndexDownloadUrlResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The signed URL for downloading the backup index.
	SignedUrl string `protobuf:"bytes,1,opt,name=signed_url,json=signedUrl,proto3" json:"signed_url,omitempty"`
}

func (x *GetBackupIndexDownloadUrlResponse) Reset() {
	*x = GetBackupIndexDownloadUrlResponse{}
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[50]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetBackupIndexDownloadUrlResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetBackupIndexDownloadUrlResponse) ProtoMessage() {}

func (x *GetBackupIndexDownloadUrlResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes[50]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetBackupIndexDownloadUrlResponse.ProtoReflect.Descriptor instead.
func (*GetBackupIndexDownloadUrlResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP(), []int{50}
}

func (x *GetBackupIndexDownloadUrlResponse) GetSignedUrl() string {
	if x != nil {
		return x.SignedUrl
	}
	return ""
}

var File_google_cloud_gkebackup_v1_gkebackup_proto protoreflect.FileDescriptor

var file_google_cloud_gkebackup_v1_gkebackup_proto_rawDesc = []byte{
	0x0a, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67,
	0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2f, 0x76, 0x31, 0x2f, 0x67, 0x6b, 0x65, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x19, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x26, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x2f, 0x76, 0x31, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2f, 0x76, 0x31, 0x2f, 0x62, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2f, 0x76, 0x31, 0x2f, 0x62, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x33,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67, 0x6b, 0x65,
	0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2f, 0x76, 0x31, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x5f, 0x62, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x27, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2f, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2f, 0x76, 0x31, 0x2f, 0x72,
	0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67, 0x6b, 0x65, 0x62, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f,
	0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2c, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67, 0x6b, 0x65, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x34, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x70,
	0x6c, 0x61, 0x6e, 0x5f, 0x62, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x26, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2f, 0x76, 0x31, 0x2f, 0x76, 0x6f, 0x6c,
	0x75, 0x6d, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xd5,
	0x02, 0x0a, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12,
	0x17, 0x0a, 0x04, 0x76, 0x65, 0x72, 0x62, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x04, 0x76, 0x65, 0x72, 0x62, 0x12, 0x2a, 0x0a, 0x0e, 0x73, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x4d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x12, 0x3a, 0x0a, 0x16, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65,
	0x64, 0x5f, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x15, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x65, 0x64, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x24, 0x0a, 0x0b, 0x61, 0x70, 0x69, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x61, 0x70, 0x69, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xd4, 0x01, 0x0a, 0x17, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x4b, 0x0a, 0x0b, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f,
	0x70, 0x6c, 0x61, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61,
	0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c,
	0x61, 0x6e, 0x12, 0x29, 0x0a, 0x0e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x70, 0x6c, 0x61,
	0x6e, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0c, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x49, 0x64, 0x22, 0xde, 0x01,
	0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23,
	0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a,
	0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1e,
	0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xad,
	0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61,
	0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x48, 0x0a, 0x0c, 0x62, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x52, 0x0b, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50,
	0x6c, 0x61, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e,
	0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b,
	0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x57,
	0x0a, 0x14, 0x47, 0x65, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x67, 0x6b,
	0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61,
	0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa8, 0x01, 0x0a, 0x17, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x0b, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x70, 0x6c,
	0x61, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e,
	0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73,
	0x6b, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61,
	0x73, 0x6b, 0x22, 0x73, 0x0a, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x42, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x25, 0x0a, 0x23, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x17,
	0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x22, 0xe6, 0x01, 0x0a, 0x1a, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x54, 0x0a, 0x0e, 0x62, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0d, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x12,
	0x2f, 0x0a, 0x11, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x49, 0x64,
	0x22, 0xe1, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x43,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53,
	0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x72, 0x64,
	0x65, 0x72, 0x42, 0x79, 0x22, 0xb9, 0x01, 0x0a, 0x1a, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x51, 0x0a, 0x0f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x63, 0x68,
	0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x43,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x52, 0x0e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x43, 0x68,
	0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20,
	0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65,
	0x22, 0x5d, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x43, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x28, 0x0a, 0x26, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0xb4, 0x01, 0x0a, 0x1a, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x54,
	0x0a, 0x0e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e,
	0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x43, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c,
	0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x94, 0x01, 0x0a, 0x1a, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x67, 0x6b, 0x65,
	0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x43, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x65, 0x74, 0x61,
	0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x65, 0x74,
	0x61, 0x67, 0x12, 0x19, 0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x22, 0xea, 0x01,
	0x0a, 0x1d, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e,
	0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x46, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a,
	0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x72,
	0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xca, 0x01, 0x0a, 0x1e, 0x4c,
	0x69, 0x73, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x42, 0x69, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5e, 0x0a,
	0x14, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x5f, 0x62, 0x69, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c,
	0x61, 0x6e, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x12, 0x62, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x50, 0x6c, 0x61, 0x6e, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x26, 0x0a,
	0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68,
	0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65,
	0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x65, 0x0a, 0x1b, 0x47, 0x65, 0x74, 0x42, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x67, 0x6b,
	0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61,
	0x6e, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xbc,
	0x01, 0x0a, 0x13, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x0a, 0x23,
	0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50,
	0x6c, 0x61, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x3e, 0x0a, 0x06, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x06, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x12, 0x20, 0x0a, 0x09, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x08, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x49, 0x64, 0x22, 0x97, 0x02,
	0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x67, 0x6b,
	0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61,
	0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12,
	0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1e, 0x0a, 0x08,
	0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x12, 0x39, 0x0a, 0x16,
	0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x73,
	0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x14, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c,
	0x53, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x22, 0x9c, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74,
	0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x3b, 0x0a, 0x07, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x52, 0x07, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x12, 0x26, 0x0a, 0x0f,
	0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61,
	0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61,
	0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x4f, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x42, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3b, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21,
	0x0a, 0x1f, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x97, 0x01, 0x0a, 0x13, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x3e, 0x0a, 0x06, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x12,
	0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73,
	0x6b, 0x22, 0x86, 0x01, 0x0a, 0x13, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x42, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3b, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21, 0x0a,
	0x1f, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12,
	0x19, 0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x22, 0xde, 0x01, 0x0a, 0x18, 0x4c,
	0x69, 0x73, 0x74, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21, 0x0a,
	0x1f, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b,
	0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1e, 0x0a, 0x08, 0x6f,
	0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0x93, 0x01, 0x0a, 0x19,
	0x4c, 0x69, 0x73, 0x74, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4e, 0x0a, 0x0e, 0x76, 0x6f, 0x6c,
	0x75, 0x6d, 0x65, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6f,
	0x6c, 0x75, 0x6d, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x0d, 0x76, 0x6f, 0x6c, 0x75,
	0x6d, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78,
	0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0x5b, 0x0a, 0x16, 0x47, 0x65, 0x74, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x42, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x27, 0x0a, 0x25, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x6f, 0x6c, 0x75,
	0x6d, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xda,
	0x01, 0x0a, 0x18, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x50, 0x6c, 0x61, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x4e,
	0x0a, 0x0c, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31,
	0x2e, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61, 0x6e, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0b, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61, 0x6e, 0x12, 0x2b,
	0x0a, 0x0f, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x5f, 0x69,
	0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x72, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61, 0x6e, 0x49, 0x64, 0x22, 0xdf, 0x01, 0x0a, 0x17,
	0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61, 0x6e, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a,
	0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1e, 0x0a,
	0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xb1, 0x01,
	0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61,
	0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4b, 0x0a, 0x0d, 0x72, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61, 0x6e, 0x52, 0x0c, 0x72, 0x65, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x50, 0x6c, 0x61, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12,
	0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c,
	0x65, 0x22, 0x59, 0x0a, 0x15, 0x47, 0x65, 0x74, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50,
	0x6c, 0x61, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26,
	0x0a, 0x24, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x50, 0x6c, 0x61, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xac, 0x01, 0x0a,
	0x18, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c,
	0x61, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4e, 0x0a, 0x0c, 0x72, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x72, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61, 0x6e, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x90, 0x01, 0x0a, 0x18,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24,
	0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x50, 0x6c, 0x61, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x65, 0x74,
	0x61, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x65,
	0x74, 0x61, 0x67, 0x12, 0x19, 0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x22, 0xec,
	0x01, 0x0a, 0x1b, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x57, 0x0a, 0x0f, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x63, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x68,
	0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x72, 0x65, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x12, 0x31, 0x0a, 0x12, 0x72, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x69, 0x64,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x72, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x49, 0x64, 0x22, 0xe2, 0x01,
	0x0a, 0x1a, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72,
	0x42, 0x79, 0x22, 0xbd, 0x01, 0x0a, 0x1b, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x54, 0x0a, 0x10, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x63, 0x68,
	0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x52, 0x0f, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74,
	0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62,
	0x6c, 0x65, 0x22, 0x5f, 0x0a, 0x18, 0x47, 0x65, 0x74, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52,
	0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0xb8, 0x01, 0x0a, 0x1b, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x57, 0x0a, 0x0f, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x63,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x72, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x12, 0x40, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x7b,
	0x0a, 0x1b, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x43,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x29, 0x0a, 0x27, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x22, 0xec, 0x01, 0x0a, 0x1e,
	0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61, 0x6e, 0x42,
	0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a,
	0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x72,
	0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xd3, 0x01, 0x0a, 0x1f, 0x4c,
	0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61, 0x6e, 0x42, 0x69,
	0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x61,
	0x0a, 0x15, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x5f, 0x62,
	0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65,
	0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x50, 0x6c, 0x61, 0x6e, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x13, 0x72, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61, 0x6e, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74,
	0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x25, 0x0a, 0x0b, 0x75, 0x6e, 0x72,
	0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x06, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65,
	0x22, 0x67, 0x0a, 0x1c, 0x47, 0x65, 0x74, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c,
	0x61, 0x6e, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x47, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61, 0x6e, 0x42, 0x69, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xc3, 0x01, 0x0a, 0x14, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x44, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x67, 0x6b, 0x65, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61, 0x6e,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x41, 0x0a, 0x07, 0x72, 0x65, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x07, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72,
	0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x49, 0x64, 0x22,
	0xde, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a,
	0x24, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x50, 0x6c, 0x61, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79,
	0x22, 0xa0, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3e, 0x0a, 0x08, 0x72, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x52,
	0x08, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78,
	0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61,
	0x62, 0x6c, 0x65, 0x22, 0x51, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x0a, 0x20,
	0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x9b, 0x01, 0x0a, 0x14, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x41, 0x0a, 0x07, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x72, 0x65, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d,
	0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x4d, 0x61, 0x73, 0x6b, 0x22, 0x88, 0x01, 0x0a, 0x14, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52,
	0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3c, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x22, 0x0a, 0x20, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x65,
	0x74, 0x61, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04,
	0x65, 0x74, 0x61, 0x67, 0x12, 0x19, 0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x22,
	0xe0, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x52, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72,
	0x42, 0x79, 0x22, 0x97, 0x01, 0x0a, 0x1a, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x6f, 0x6c, 0x75, 0x6d,
	0x65, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x51, 0x0a, 0x0f, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x52, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x52, 0x0e, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x52, 0x65, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e,
	0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x5d, 0x0a, 0x17,
	0x47, 0x65, 0x74, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x67,
	0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x52, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x63, 0x0a, 0x20, 0x47,
	0x65, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x44, 0x6f, 0x77,
	0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x55, 0x72, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x3f, 0x0a, 0x06, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x06, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x22, 0x47, 0x0a, 0x21, 0x47, 0x65, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x49, 0x6e, 0x64,
	0x65, 0x78, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x55, 0x72, 0x6c, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x5f,
	0x75, 0x72, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09,
	0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x55, 0x72, 0x6c, 0x32, 0xd1, 0x43, 0x0a, 0x0c, 0x42, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x46, 0x6f, 0x72, 0x47, 0x4b, 0x45, 0x12, 0xf2, 0x01, 0x0a, 0x10, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x12,
	0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e,
	0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x8a, 0x01, 0xca, 0x41, 0x1f, 0x0a, 0x0a, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x50, 0x6c, 0x61, 0x6e, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x21, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x2c, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x2c, 0x62, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x3e, 0x3a, 0x0b, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x22, 0x2f,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x73, 0x12,
	0xba, 0x01, 0x0a, 0x0f, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c,
	0x61, 0x6e, 0x73, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61,
	0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x40, 0xda, 0x41, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x12, 0x2f, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x73, 0x12, 0xa7, 0x01, 0x0a,
	0x0d, 0x47, 0x65, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x12, 0x2f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b,
	0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x42, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x22, 0x3e, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x31, 0x12, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c,
	0x61, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xf4, 0x01, 0x0a, 0x10, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x12, 0x32, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x42, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x8c,
	0x01, 0xca, 0x41, 0x1f, 0x0a, 0x0a, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e,
	0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0xda, 0x41, 0x17, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x70, 0x6c, 0x61,
	0x6e, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x4a, 0x3a, 0x0b, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x70, 0x6c, 0x61, 0x6e,
	0x32, 0x3b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x70, 0x6c,
	0x61, 0x6e, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xd2, 0x01,
	0x0a, 0x10, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c,
	0x61, 0x6e, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6b, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74,
	0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x31, 0x2a, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x73, 0x2f,
	0x2a, 0x7d, 0x12, 0x87, 0x02, 0x0a, 0x13, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x42, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x42, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72,
	0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0x99, 0x01, 0xca, 0x41, 0x22, 0x0a, 0x0d, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x43, 0x68,
	0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x27, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x2c, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x2c, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f,
	0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x44, 0x3a, 0x0e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x22, 0x32, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x62, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x12, 0xc6, 0x01, 0x0a,
	0x12, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x43, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x73, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x43, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x34, 0x12, 0x32, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x43, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x12, 0xb3, 0x01, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x42, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b,
	0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x22, 0x41, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x34, 0x12, 0x32, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x89, 0x02, 0x0a, 0x13,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x43, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x43, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x9b, 0x01, 0xca, 0x41, 0x22, 0x0a,
	0x0d, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x12, 0x11,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0xda, 0x41, 0x1a, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x53, 0x3a, 0x0e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x63, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x32, 0x41, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x62, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x43, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xdb, 0x01, 0x0a, 0x13, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x12,
	0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6e, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74,
	0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x34, 0x2a, 0x32, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xe7, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73,
	0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x42, 0x69, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x39, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x50, 0x6c, 0x61, 0x6e, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x58, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x49, 0x12, 0x47, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x62, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x12,
	0xd4, 0x01, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61,
	0x6e, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c,
	0x61, 0x6e, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x22, 0x56,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x49, 0x12, 0x47, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x2f, 0x2a,
	0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x42, 0x69, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xe1, 0x01, 0x0a, 0x0c, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x81, 0x01, 0xca, 0x41, 0x1b, 0x0a, 0x06, 0x42, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x17, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x2c, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2c, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x69,
	0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x43, 0x3a, 0x06, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x22,
	0x39, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x12, 0xb8, 0x01, 0x0a, 0x0b, 0x4c,
	0x69, 0x73, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4a, 0xda, 0x41, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3b, 0x12, 0x39, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x62, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x73, 0x12, 0xa5, 0x01, 0x0a, 0x09, 0x47, 0x65, 0x74, 0x42, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x12, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e,
	0x47, 0x65, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x22, 0x48, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x3b, 0x12, 0x39, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xe3, 0x01,
	0x0a, 0x0c, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x12, 0x2e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b,
	0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x83, 0x01,
	0xca, 0x41, 0x1b, 0x0a, 0x06, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x12, 0x11, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41,
	0x12, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4a, 0x3a, 0x06, 0x62, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x32, 0x40, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x50, 0x6c, 0x61, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0xd4, 0x01, 0x0a, 0x0c, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x42, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f,
	0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0x75, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12,
	0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3b, 0x2a,
	0x39, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xda, 0x01, 0x0a, 0x11, 0x4c,
	0x69, 0x73, 0x74, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73,
	0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x42, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x5a, 0xda, 0x41, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4b, 0x12, 0x49, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65,
	0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x12, 0xc7, 0x01, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x56,
	0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x12, 0x31, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x56, 0x6f, 0x6c, 0x75, 0x6d,
	0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x27,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b,
	0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6f, 0x6c, 0x75, 0x6d,
	0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x22, 0x58, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4b, 0x12, 0x49, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50,
	0x6c, 0x61, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x2f, 0x2a,
	0x2f, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x2f, 0x2a,
	0x7d, 0x12, 0xf9, 0x01, 0x0a, 0x11, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61, 0x6e, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x50, 0x6c, 0x61, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x8f, 0x01, 0xca, 0x41,
	0x20, 0x0a, 0x0b, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61, 0x6e, 0x12, 0x11,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0xda, 0x41, 0x23, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x72, 0x65, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x2c, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f,
	0x70, 0x6c, 0x61, 0x6e, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x40, 0x3a, 0x0c, 0x72,
	0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x22, 0x30, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61, 0x6e, 0x73, 0x12, 0xbe, 0x01,
	0x0a, 0x10, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61,
	0x6e, 0x73, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61, 0x6e, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c,
	0x61, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x41, 0xda, 0x41, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x32, 0x12, 0x30, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61, 0x6e, 0x73, 0x12, 0xab,
	0x01, 0x0a, 0x0e, 0x47, 0x65, 0x74, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61,
	0x6e, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65,
	0x74, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61, 0x6e, 0x22, 0x3f, 0xda, 0x41, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x32, 0x12, 0x30, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xfb, 0x01, 0x0a,
	0x11, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c,
	0x61, 0x6e, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61, 0x6e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x91, 0x01, 0xca, 0x41, 0x20, 0x0a, 0x0b, 0x52, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61, 0x6e, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x18, 0x72,
	0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x2c, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4d, 0x3a, 0x0c, 0x72,
	0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x32, 0x3d, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x2e, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x50, 0x6c, 0x61, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xd5, 0x01, 0x0a, 0x11, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61, 0x6e,
	0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6c, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79,
	0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x32,
	0x2a, 0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61, 0x6e, 0x73, 0x2f,
	0x2a, 0x7d, 0x12, 0x8e, 0x02, 0x0a, 0x14, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x12, 0x36, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e,
	0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x9e, 0x01, 0xca, 0x41, 0x23, 0x0a, 0x0e, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x29, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x2c, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x63, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x2c, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x63, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x46, 0x3a, 0x0f, 0x72,
	0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x22, 0x33,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x73, 0x12, 0xca, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x12, 0x35, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x44, 0xda, 0x41, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x35, 0x12, 0x33, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73,
	0x12, 0xb7, 0x01, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x43,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e,
	0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x43,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x22, 0x42, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x35, 0x12, 0x33, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x43,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x90, 0x02, 0x0a, 0x14, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67,
	0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xa0, 0x01, 0xca, 0x41, 0x23,
	0x0a, 0x0e, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0xda, 0x41, 0x1b, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x63, 0x68,
	0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x56, 0x3a, 0x0f, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x32, 0x43, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x72,
	0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xde, 0x01,
	0x0a, 0x14, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x43,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6f, 0xca,
	0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x35, 0x2a, 0x33, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xec,
	0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c,
	0x61, 0x6e, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x50, 0x6c, 0x61, 0x6e, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61,
	0x6e, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x5a, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x4b, 0x12, 0x49, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x68,
	0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x50, 0x6c, 0x61, 0x6e, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x12, 0xd9, 0x01,
	0x0a, 0x15, 0x47, 0x65, 0x74, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61, 0x6e,
	0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c,
	0x61, 0x6e, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61, 0x6e, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x22,
	0x58, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4b, 0x12, 0x49,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73,
	0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61, 0x6e, 0x42, 0x69,
	0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xe9, 0x01, 0x0a, 0x0d, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x12, 0x2f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x87, 0x01, 0xca, 0x41,
	0x1c, 0x0a, 0x07, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x19,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2c, 0x72,
	0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x46, 0x3a,
	0x07, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x22, 0x3b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x73, 0x12, 0xbd, 0x01, 0x0a, 0x0c, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4c, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x12, 0x3b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x73, 0x12, 0xaa, 0x01, 0x0a, 0x0a, 0x47, 0x65, 0x74, 0x52, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31,
	0x2e, 0x47, 0x65, 0x74, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x52,
	0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x22, 0x4a, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x12, 0x3b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50,
	0x6c, 0x61, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f,
	0x2a, 0x7d, 0x12, 0xeb, 0x01, 0x0a, 0x0d, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31,
	0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x89, 0x01, 0xca, 0x41, 0x1c, 0x0a, 0x07, 0x52, 0x65, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x13, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x4e, 0x3a, 0x07, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x32, 0x43, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x7d,
	0x12, 0xd8, 0x01, 0x0a, 0x0d, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e,
	0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x77, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x11,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x2a, 0x3b,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xe0, 0x01, 0x0a, 0x12,
	0x4c, 0x69, 0x73, 0x74, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x73, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x52,
	0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x5d, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4e,
	0x12, 0x4c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x12, 0xcd,
	0x01, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x52, 0x65, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e,
	0x47, 0x65, 0x74, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x22, 0x5b, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4e,
	0x12, 0x4c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x6f, 0x6c,
	0x75, 0x6d, 0x65, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xfe,
	0x01, 0x0a, 0x19, 0x47, 0x65, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x49, 0x6e, 0x64, 0x65,
	0x78, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x55, 0x72, 0x6c, 0x12, 0x3b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x42, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x55,
	0x72, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x49,
	0x6e, 0x64, 0x65, 0x78, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x55, 0x72, 0x6c, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x66, 0xda, 0x41, 0x06, 0x62, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x57, 0x12, 0x55, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x67, 0x65, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x49,
	0x6e, 0x64, 0x65, 0x78, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x55, 0x72, 0x6c, 0x1a,
	0x4c, 0xca, 0x41, 0x18, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68,
	0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xa1, 0x03,
	0xea, 0x41, 0x5e, 0x0a, 0x20, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x3a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x7d, 0xea, 0x41, 0x78, 0x0a, 0x21, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x6b, 0x6d, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x72,
	0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x12, 0x53, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d,
	0x2f, 0x6b, 0x65, 0x79, 0x52, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x7b, 0x6b, 0x65, 0x79, 0x5f, 0x72,
	0x69, 0x6e, 0x67, 0x7d, 0x2f, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x73, 0x2f,
	0x7b, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x5f, 0x6b, 0x65, 0x79, 0x7d, 0x0a, 0x1d, 0x63, 0x6f,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x42, 0x0e, 0x47, 0x4b, 0x45,
	0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3b, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x67, 0x6f, 0x2f, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2f, 0x61, 0x70, 0x69,
	0x76, 0x31, 0x2f, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x70, 0x62, 0x3b, 0x67,
	0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x70, 0x62, 0xaa, 0x02, 0x19, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x47, 0x6b, 0x65, 0x42, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x19, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x47, 0x6b, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5c,
	0x56, 0x31, 0xea, 0x02, 0x1c, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x3a, 0x3a, 0x47, 0x6b, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x3a, 0x3a, 0x56,
	0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescOnce sync.Once
	file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescData = file_google_cloud_gkebackup_v1_gkebackup_proto_rawDesc
)

func file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescGZIP() []byte {
	file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescOnce.Do(func() {
		file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescData)
	})
	return file_google_cloud_gkebackup_v1_gkebackup_proto_rawDescData
}

var file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes = make([]protoimpl.MessageInfo, 51)
var file_google_cloud_gkebackup_v1_gkebackup_proto_goTypes = []any{
	(*OperationMetadata)(nil),                 // 0: google.cloud.gkebackup.v1.OperationMetadata
	(*CreateBackupPlanRequest)(nil),           // 1: google.cloud.gkebackup.v1.CreateBackupPlanRequest
	(*ListBackupPlansRequest)(nil),            // 2: google.cloud.gkebackup.v1.ListBackupPlansRequest
	(*ListBackupPlansResponse)(nil),           // 3: google.cloud.gkebackup.v1.ListBackupPlansResponse
	(*GetBackupPlanRequest)(nil),              // 4: google.cloud.gkebackup.v1.GetBackupPlanRequest
	(*UpdateBackupPlanRequest)(nil),           // 5: google.cloud.gkebackup.v1.UpdateBackupPlanRequest
	(*DeleteBackupPlanRequest)(nil),           // 6: google.cloud.gkebackup.v1.DeleteBackupPlanRequest
	(*CreateBackupChannelRequest)(nil),        // 7: google.cloud.gkebackup.v1.CreateBackupChannelRequest
	(*ListBackupChannelsRequest)(nil),         // 8: google.cloud.gkebackup.v1.ListBackupChannelsRequest
	(*ListBackupChannelsResponse)(nil),        // 9: google.cloud.gkebackup.v1.ListBackupChannelsResponse
	(*GetBackupChannelRequest)(nil),           // 10: google.cloud.gkebackup.v1.GetBackupChannelRequest
	(*UpdateBackupChannelRequest)(nil),        // 11: google.cloud.gkebackup.v1.UpdateBackupChannelRequest
	(*DeleteBackupChannelRequest)(nil),        // 12: google.cloud.gkebackup.v1.DeleteBackupChannelRequest
	(*ListBackupPlanBindingsRequest)(nil),     // 13: google.cloud.gkebackup.v1.ListBackupPlanBindingsRequest
	(*ListBackupPlanBindingsResponse)(nil),    // 14: google.cloud.gkebackup.v1.ListBackupPlanBindingsResponse
	(*GetBackupPlanBindingRequest)(nil),       // 15: google.cloud.gkebackup.v1.GetBackupPlanBindingRequest
	(*CreateBackupRequest)(nil),               // 16: google.cloud.gkebackup.v1.CreateBackupRequest
	(*ListBackupsRequest)(nil),                // 17: google.cloud.gkebackup.v1.ListBackupsRequest
	(*ListBackupsResponse)(nil),               // 18: google.cloud.gkebackup.v1.ListBackupsResponse
	(*GetBackupRequest)(nil),                  // 19: google.cloud.gkebackup.v1.GetBackupRequest
	(*UpdateBackupRequest)(nil),               // 20: google.cloud.gkebackup.v1.UpdateBackupRequest
	(*DeleteBackupRequest)(nil),               // 21: google.cloud.gkebackup.v1.DeleteBackupRequest
	(*ListVolumeBackupsRequest)(nil),          // 22: google.cloud.gkebackup.v1.ListVolumeBackupsRequest
	(*ListVolumeBackupsResponse)(nil),         // 23: google.cloud.gkebackup.v1.ListVolumeBackupsResponse
	(*GetVolumeBackupRequest)(nil),            // 24: google.cloud.gkebackup.v1.GetVolumeBackupRequest
	(*CreateRestorePlanRequest)(nil),          // 25: google.cloud.gkebackup.v1.CreateRestorePlanRequest
	(*ListRestorePlansRequest)(nil),           // 26: google.cloud.gkebackup.v1.ListRestorePlansRequest
	(*ListRestorePlansResponse)(nil),          // 27: google.cloud.gkebackup.v1.ListRestorePlansResponse
	(*GetRestorePlanRequest)(nil),             // 28: google.cloud.gkebackup.v1.GetRestorePlanRequest
	(*UpdateRestorePlanRequest)(nil),          // 29: google.cloud.gkebackup.v1.UpdateRestorePlanRequest
	(*DeleteRestorePlanRequest)(nil),          // 30: google.cloud.gkebackup.v1.DeleteRestorePlanRequest
	(*CreateRestoreChannelRequest)(nil),       // 31: google.cloud.gkebackup.v1.CreateRestoreChannelRequest
	(*ListRestoreChannelsRequest)(nil),        // 32: google.cloud.gkebackup.v1.ListRestoreChannelsRequest
	(*ListRestoreChannelsResponse)(nil),       // 33: google.cloud.gkebackup.v1.ListRestoreChannelsResponse
	(*GetRestoreChannelRequest)(nil),          // 34: google.cloud.gkebackup.v1.GetRestoreChannelRequest
	(*UpdateRestoreChannelRequest)(nil),       // 35: google.cloud.gkebackup.v1.UpdateRestoreChannelRequest
	(*DeleteRestoreChannelRequest)(nil),       // 36: google.cloud.gkebackup.v1.DeleteRestoreChannelRequest
	(*ListRestorePlanBindingsRequest)(nil),    // 37: google.cloud.gkebackup.v1.ListRestorePlanBindingsRequest
	(*ListRestorePlanBindingsResponse)(nil),   // 38: google.cloud.gkebackup.v1.ListRestorePlanBindingsResponse
	(*GetRestorePlanBindingRequest)(nil),      // 39: google.cloud.gkebackup.v1.GetRestorePlanBindingRequest
	(*CreateRestoreRequest)(nil),              // 40: google.cloud.gkebackup.v1.CreateRestoreRequest
	(*ListRestoresRequest)(nil),               // 41: google.cloud.gkebackup.v1.ListRestoresRequest
	(*ListRestoresResponse)(nil),              // 42: google.cloud.gkebackup.v1.ListRestoresResponse
	(*GetRestoreRequest)(nil),                 // 43: google.cloud.gkebackup.v1.GetRestoreRequest
	(*UpdateRestoreRequest)(nil),              // 44: google.cloud.gkebackup.v1.UpdateRestoreRequest
	(*DeleteRestoreRequest)(nil),              // 45: google.cloud.gkebackup.v1.DeleteRestoreRequest
	(*ListVolumeRestoresRequest)(nil),         // 46: google.cloud.gkebackup.v1.ListVolumeRestoresRequest
	(*ListVolumeRestoresResponse)(nil),        // 47: google.cloud.gkebackup.v1.ListVolumeRestoresResponse
	(*GetVolumeRestoreRequest)(nil),           // 48: google.cloud.gkebackup.v1.GetVolumeRestoreRequest
	(*GetBackupIndexDownloadUrlRequest)(nil),  // 49: google.cloud.gkebackup.v1.GetBackupIndexDownloadUrlRequest
	(*GetBackupIndexDownloadUrlResponse)(nil), // 50: google.cloud.gkebackup.v1.GetBackupIndexDownloadUrlResponse
	(*timestamppb.Timestamp)(nil),             // 51: google.protobuf.Timestamp
	(*BackupPlan)(nil),                        // 52: google.cloud.gkebackup.v1.BackupPlan
	(*fieldmaskpb.FieldMask)(nil),             // 53: google.protobuf.FieldMask
	(*BackupChannel)(nil),                     // 54: google.cloud.gkebackup.v1.BackupChannel
	(*BackupPlanBinding)(nil),                 // 55: google.cloud.gkebackup.v1.BackupPlanBinding
	(*Backup)(nil),                            // 56: google.cloud.gkebackup.v1.Backup
	(*VolumeBackup)(nil),                      // 57: google.cloud.gkebackup.v1.VolumeBackup
	(*RestorePlan)(nil),                       // 58: google.cloud.gkebackup.v1.RestorePlan
	(*RestoreChannel)(nil),                    // 59: google.cloud.gkebackup.v1.RestoreChannel
	(*RestorePlanBinding)(nil),                // 60: google.cloud.gkebackup.v1.RestorePlanBinding
	(*Restore)(nil),                           // 61: google.cloud.gkebackup.v1.Restore
	(*VolumeRestore)(nil),                     // 62: google.cloud.gkebackup.v1.VolumeRestore
	(*longrunningpb.Operation)(nil),           // 63: google.longrunning.Operation
}
var file_google_cloud_gkebackup_v1_gkebackup_proto_depIdxs = []int32{
	51, // 0: google.cloud.gkebackup.v1.OperationMetadata.create_time:type_name -> google.protobuf.Timestamp
	51, // 1: google.cloud.gkebackup.v1.OperationMetadata.end_time:type_name -> google.protobuf.Timestamp
	52, // 2: google.cloud.gkebackup.v1.CreateBackupPlanRequest.backup_plan:type_name -> google.cloud.gkebackup.v1.BackupPlan
	52, // 3: google.cloud.gkebackup.v1.ListBackupPlansResponse.backup_plans:type_name -> google.cloud.gkebackup.v1.BackupPlan
	52, // 4: google.cloud.gkebackup.v1.UpdateBackupPlanRequest.backup_plan:type_name -> google.cloud.gkebackup.v1.BackupPlan
	53, // 5: google.cloud.gkebackup.v1.UpdateBackupPlanRequest.update_mask:type_name -> google.protobuf.FieldMask
	54, // 6: google.cloud.gkebackup.v1.CreateBackupChannelRequest.backup_channel:type_name -> google.cloud.gkebackup.v1.BackupChannel
	54, // 7: google.cloud.gkebackup.v1.ListBackupChannelsResponse.backup_channels:type_name -> google.cloud.gkebackup.v1.BackupChannel
	54, // 8: google.cloud.gkebackup.v1.UpdateBackupChannelRequest.backup_channel:type_name -> google.cloud.gkebackup.v1.BackupChannel
	53, // 9: google.cloud.gkebackup.v1.UpdateBackupChannelRequest.update_mask:type_name -> google.protobuf.FieldMask
	55, // 10: google.cloud.gkebackup.v1.ListBackupPlanBindingsResponse.backup_plan_bindings:type_name -> google.cloud.gkebackup.v1.BackupPlanBinding
	56, // 11: google.cloud.gkebackup.v1.CreateBackupRequest.backup:type_name -> google.cloud.gkebackup.v1.Backup
	56, // 12: google.cloud.gkebackup.v1.ListBackupsResponse.backups:type_name -> google.cloud.gkebackup.v1.Backup
	56, // 13: google.cloud.gkebackup.v1.UpdateBackupRequest.backup:type_name -> google.cloud.gkebackup.v1.Backup
	53, // 14: google.cloud.gkebackup.v1.UpdateBackupRequest.update_mask:type_name -> google.protobuf.FieldMask
	57, // 15: google.cloud.gkebackup.v1.ListVolumeBackupsResponse.volume_backups:type_name -> google.cloud.gkebackup.v1.VolumeBackup
	58, // 16: google.cloud.gkebackup.v1.CreateRestorePlanRequest.restore_plan:type_name -> google.cloud.gkebackup.v1.RestorePlan
	58, // 17: google.cloud.gkebackup.v1.ListRestorePlansResponse.restore_plans:type_name -> google.cloud.gkebackup.v1.RestorePlan
	58, // 18: google.cloud.gkebackup.v1.UpdateRestorePlanRequest.restore_plan:type_name -> google.cloud.gkebackup.v1.RestorePlan
	53, // 19: google.cloud.gkebackup.v1.UpdateRestorePlanRequest.update_mask:type_name -> google.protobuf.FieldMask
	59, // 20: google.cloud.gkebackup.v1.CreateRestoreChannelRequest.restore_channel:type_name -> google.cloud.gkebackup.v1.RestoreChannel
	59, // 21: google.cloud.gkebackup.v1.ListRestoreChannelsResponse.restore_channels:type_name -> google.cloud.gkebackup.v1.RestoreChannel
	59, // 22: google.cloud.gkebackup.v1.UpdateRestoreChannelRequest.restore_channel:type_name -> google.cloud.gkebackup.v1.RestoreChannel
	53, // 23: google.cloud.gkebackup.v1.UpdateRestoreChannelRequest.update_mask:type_name -> google.protobuf.FieldMask
	60, // 24: google.cloud.gkebackup.v1.ListRestorePlanBindingsResponse.restore_plan_bindings:type_name -> google.cloud.gkebackup.v1.RestorePlanBinding
	61, // 25: google.cloud.gkebackup.v1.CreateRestoreRequest.restore:type_name -> google.cloud.gkebackup.v1.Restore
	61, // 26: google.cloud.gkebackup.v1.ListRestoresResponse.restores:type_name -> google.cloud.gkebackup.v1.Restore
	61, // 27: google.cloud.gkebackup.v1.UpdateRestoreRequest.restore:type_name -> google.cloud.gkebackup.v1.Restore
	53, // 28: google.cloud.gkebackup.v1.UpdateRestoreRequest.update_mask:type_name -> google.protobuf.FieldMask
	62, // 29: google.cloud.gkebackup.v1.ListVolumeRestoresResponse.volume_restores:type_name -> google.cloud.gkebackup.v1.VolumeRestore
	1,  // 30: google.cloud.gkebackup.v1.BackupForGKE.CreateBackupPlan:input_type -> google.cloud.gkebackup.v1.CreateBackupPlanRequest
	2,  // 31: google.cloud.gkebackup.v1.BackupForGKE.ListBackupPlans:input_type -> google.cloud.gkebackup.v1.ListBackupPlansRequest
	4,  // 32: google.cloud.gkebackup.v1.BackupForGKE.GetBackupPlan:input_type -> google.cloud.gkebackup.v1.GetBackupPlanRequest
	5,  // 33: google.cloud.gkebackup.v1.BackupForGKE.UpdateBackupPlan:input_type -> google.cloud.gkebackup.v1.UpdateBackupPlanRequest
	6,  // 34: google.cloud.gkebackup.v1.BackupForGKE.DeleteBackupPlan:input_type -> google.cloud.gkebackup.v1.DeleteBackupPlanRequest
	7,  // 35: google.cloud.gkebackup.v1.BackupForGKE.CreateBackupChannel:input_type -> google.cloud.gkebackup.v1.CreateBackupChannelRequest
	8,  // 36: google.cloud.gkebackup.v1.BackupForGKE.ListBackupChannels:input_type -> google.cloud.gkebackup.v1.ListBackupChannelsRequest
	10, // 37: google.cloud.gkebackup.v1.BackupForGKE.GetBackupChannel:input_type -> google.cloud.gkebackup.v1.GetBackupChannelRequest
	11, // 38: google.cloud.gkebackup.v1.BackupForGKE.UpdateBackupChannel:input_type -> google.cloud.gkebackup.v1.UpdateBackupChannelRequest
	12, // 39: google.cloud.gkebackup.v1.BackupForGKE.DeleteBackupChannel:input_type -> google.cloud.gkebackup.v1.DeleteBackupChannelRequest
	13, // 40: google.cloud.gkebackup.v1.BackupForGKE.ListBackupPlanBindings:input_type -> google.cloud.gkebackup.v1.ListBackupPlanBindingsRequest
	15, // 41: google.cloud.gkebackup.v1.BackupForGKE.GetBackupPlanBinding:input_type -> google.cloud.gkebackup.v1.GetBackupPlanBindingRequest
	16, // 42: google.cloud.gkebackup.v1.BackupForGKE.CreateBackup:input_type -> google.cloud.gkebackup.v1.CreateBackupRequest
	17, // 43: google.cloud.gkebackup.v1.BackupForGKE.ListBackups:input_type -> google.cloud.gkebackup.v1.ListBackupsRequest
	19, // 44: google.cloud.gkebackup.v1.BackupForGKE.GetBackup:input_type -> google.cloud.gkebackup.v1.GetBackupRequest
	20, // 45: google.cloud.gkebackup.v1.BackupForGKE.UpdateBackup:input_type -> google.cloud.gkebackup.v1.UpdateBackupRequest
	21, // 46: google.cloud.gkebackup.v1.BackupForGKE.DeleteBackup:input_type -> google.cloud.gkebackup.v1.DeleteBackupRequest
	22, // 47: google.cloud.gkebackup.v1.BackupForGKE.ListVolumeBackups:input_type -> google.cloud.gkebackup.v1.ListVolumeBackupsRequest
	24, // 48: google.cloud.gkebackup.v1.BackupForGKE.GetVolumeBackup:input_type -> google.cloud.gkebackup.v1.GetVolumeBackupRequest
	25, // 49: google.cloud.gkebackup.v1.BackupForGKE.CreateRestorePlan:input_type -> google.cloud.gkebackup.v1.CreateRestorePlanRequest
	26, // 50: google.cloud.gkebackup.v1.BackupForGKE.ListRestorePlans:input_type -> google.cloud.gkebackup.v1.ListRestorePlansRequest
	28, // 51: google.cloud.gkebackup.v1.BackupForGKE.GetRestorePlan:input_type -> google.cloud.gkebackup.v1.GetRestorePlanRequest
	29, // 52: google.cloud.gkebackup.v1.BackupForGKE.UpdateRestorePlan:input_type -> google.cloud.gkebackup.v1.UpdateRestorePlanRequest
	30, // 53: google.cloud.gkebackup.v1.BackupForGKE.DeleteRestorePlan:input_type -> google.cloud.gkebackup.v1.DeleteRestorePlanRequest
	31, // 54: google.cloud.gkebackup.v1.BackupForGKE.CreateRestoreChannel:input_type -> google.cloud.gkebackup.v1.CreateRestoreChannelRequest
	32, // 55: google.cloud.gkebackup.v1.BackupForGKE.ListRestoreChannels:input_type -> google.cloud.gkebackup.v1.ListRestoreChannelsRequest
	34, // 56: google.cloud.gkebackup.v1.BackupForGKE.GetRestoreChannel:input_type -> google.cloud.gkebackup.v1.GetRestoreChannelRequest
	35, // 57: google.cloud.gkebackup.v1.BackupForGKE.UpdateRestoreChannel:input_type -> google.cloud.gkebackup.v1.UpdateRestoreChannelRequest
	36, // 58: google.cloud.gkebackup.v1.BackupForGKE.DeleteRestoreChannel:input_type -> google.cloud.gkebackup.v1.DeleteRestoreChannelRequest
	37, // 59: google.cloud.gkebackup.v1.BackupForGKE.ListRestorePlanBindings:input_type -> google.cloud.gkebackup.v1.ListRestorePlanBindingsRequest
	39, // 60: google.cloud.gkebackup.v1.BackupForGKE.GetRestorePlanBinding:input_type -> google.cloud.gkebackup.v1.GetRestorePlanBindingRequest
	40, // 61: google.cloud.gkebackup.v1.BackupForGKE.CreateRestore:input_type -> google.cloud.gkebackup.v1.CreateRestoreRequest
	41, // 62: google.cloud.gkebackup.v1.BackupForGKE.ListRestores:input_type -> google.cloud.gkebackup.v1.ListRestoresRequest
	43, // 63: google.cloud.gkebackup.v1.BackupForGKE.GetRestore:input_type -> google.cloud.gkebackup.v1.GetRestoreRequest
	44, // 64: google.cloud.gkebackup.v1.BackupForGKE.UpdateRestore:input_type -> google.cloud.gkebackup.v1.UpdateRestoreRequest
	45, // 65: google.cloud.gkebackup.v1.BackupForGKE.DeleteRestore:input_type -> google.cloud.gkebackup.v1.DeleteRestoreRequest
	46, // 66: google.cloud.gkebackup.v1.BackupForGKE.ListVolumeRestores:input_type -> google.cloud.gkebackup.v1.ListVolumeRestoresRequest
	48, // 67: google.cloud.gkebackup.v1.BackupForGKE.GetVolumeRestore:input_type -> google.cloud.gkebackup.v1.GetVolumeRestoreRequest
	49, // 68: google.cloud.gkebackup.v1.BackupForGKE.GetBackupIndexDownloadUrl:input_type -> google.cloud.gkebackup.v1.GetBackupIndexDownloadUrlRequest
	63, // 69: google.cloud.gkebackup.v1.BackupForGKE.CreateBackupPlan:output_type -> google.longrunning.Operation
	3,  // 70: google.cloud.gkebackup.v1.BackupForGKE.ListBackupPlans:output_type -> google.cloud.gkebackup.v1.ListBackupPlansResponse
	52, // 71: google.cloud.gkebackup.v1.BackupForGKE.GetBackupPlan:output_type -> google.cloud.gkebackup.v1.BackupPlan
	63, // 72: google.cloud.gkebackup.v1.BackupForGKE.UpdateBackupPlan:output_type -> google.longrunning.Operation
	63, // 73: google.cloud.gkebackup.v1.BackupForGKE.DeleteBackupPlan:output_type -> google.longrunning.Operation
	63, // 74: google.cloud.gkebackup.v1.BackupForGKE.CreateBackupChannel:output_type -> google.longrunning.Operation
	9,  // 75: google.cloud.gkebackup.v1.BackupForGKE.ListBackupChannels:output_type -> google.cloud.gkebackup.v1.ListBackupChannelsResponse
	54, // 76: google.cloud.gkebackup.v1.BackupForGKE.GetBackupChannel:output_type -> google.cloud.gkebackup.v1.BackupChannel
	63, // 77: google.cloud.gkebackup.v1.BackupForGKE.UpdateBackupChannel:output_type -> google.longrunning.Operation
	63, // 78: google.cloud.gkebackup.v1.BackupForGKE.DeleteBackupChannel:output_type -> google.longrunning.Operation
	14, // 79: google.cloud.gkebackup.v1.BackupForGKE.ListBackupPlanBindings:output_type -> google.cloud.gkebackup.v1.ListBackupPlanBindingsResponse
	55, // 80: google.cloud.gkebackup.v1.BackupForGKE.GetBackupPlanBinding:output_type -> google.cloud.gkebackup.v1.BackupPlanBinding
	63, // 81: google.cloud.gkebackup.v1.BackupForGKE.CreateBackup:output_type -> google.longrunning.Operation
	18, // 82: google.cloud.gkebackup.v1.BackupForGKE.ListBackups:output_type -> google.cloud.gkebackup.v1.ListBackupsResponse
	56, // 83: google.cloud.gkebackup.v1.BackupForGKE.GetBackup:output_type -> google.cloud.gkebackup.v1.Backup
	63, // 84: google.cloud.gkebackup.v1.BackupForGKE.UpdateBackup:output_type -> google.longrunning.Operation
	63, // 85: google.cloud.gkebackup.v1.BackupForGKE.DeleteBackup:output_type -> google.longrunning.Operation
	23, // 86: google.cloud.gkebackup.v1.BackupForGKE.ListVolumeBackups:output_type -> google.cloud.gkebackup.v1.ListVolumeBackupsResponse
	57, // 87: google.cloud.gkebackup.v1.BackupForGKE.GetVolumeBackup:output_type -> google.cloud.gkebackup.v1.VolumeBackup
	63, // 88: google.cloud.gkebackup.v1.BackupForGKE.CreateRestorePlan:output_type -> google.longrunning.Operation
	27, // 89: google.cloud.gkebackup.v1.BackupForGKE.ListRestorePlans:output_type -> google.cloud.gkebackup.v1.ListRestorePlansResponse
	58, // 90: google.cloud.gkebackup.v1.BackupForGKE.GetRestorePlan:output_type -> google.cloud.gkebackup.v1.RestorePlan
	63, // 91: google.cloud.gkebackup.v1.BackupForGKE.UpdateRestorePlan:output_type -> google.longrunning.Operation
	63, // 92: google.cloud.gkebackup.v1.BackupForGKE.DeleteRestorePlan:output_type -> google.longrunning.Operation
	63, // 93: google.cloud.gkebackup.v1.BackupForGKE.CreateRestoreChannel:output_type -> google.longrunning.Operation
	33, // 94: google.cloud.gkebackup.v1.BackupForGKE.ListRestoreChannels:output_type -> google.cloud.gkebackup.v1.ListRestoreChannelsResponse
	59, // 95: google.cloud.gkebackup.v1.BackupForGKE.GetRestoreChannel:output_type -> google.cloud.gkebackup.v1.RestoreChannel
	63, // 96: google.cloud.gkebackup.v1.BackupForGKE.UpdateRestoreChannel:output_type -> google.longrunning.Operation
	63, // 97: google.cloud.gkebackup.v1.BackupForGKE.DeleteRestoreChannel:output_type -> google.longrunning.Operation
	38, // 98: google.cloud.gkebackup.v1.BackupForGKE.ListRestorePlanBindings:output_type -> google.cloud.gkebackup.v1.ListRestorePlanBindingsResponse
	60, // 99: google.cloud.gkebackup.v1.BackupForGKE.GetRestorePlanBinding:output_type -> google.cloud.gkebackup.v1.RestorePlanBinding
	63, // 100: google.cloud.gkebackup.v1.BackupForGKE.CreateRestore:output_type -> google.longrunning.Operation
	42, // 101: google.cloud.gkebackup.v1.BackupForGKE.ListRestores:output_type -> google.cloud.gkebackup.v1.ListRestoresResponse
	61, // 102: google.cloud.gkebackup.v1.BackupForGKE.GetRestore:output_type -> google.cloud.gkebackup.v1.Restore
	63, // 103: google.cloud.gkebackup.v1.BackupForGKE.UpdateRestore:output_type -> google.longrunning.Operation
	63, // 104: google.cloud.gkebackup.v1.BackupForGKE.DeleteRestore:output_type -> google.longrunning.Operation
	47, // 105: google.cloud.gkebackup.v1.BackupForGKE.ListVolumeRestores:output_type -> google.cloud.gkebackup.v1.ListVolumeRestoresResponse
	62, // 106: google.cloud.gkebackup.v1.BackupForGKE.GetVolumeRestore:output_type -> google.cloud.gkebackup.v1.VolumeRestore
	50, // 107: google.cloud.gkebackup.v1.BackupForGKE.GetBackupIndexDownloadUrl:output_type -> google.cloud.gkebackup.v1.GetBackupIndexDownloadUrlResponse
	69, // [69:108] is the sub-list for method output_type
	30, // [30:69] is the sub-list for method input_type
	30, // [30:30] is the sub-list for extension type_name
	30, // [30:30] is the sub-list for extension extendee
	0,  // [0:30] is the sub-list for field type_name
}

func init() { file_google_cloud_gkebackup_v1_gkebackup_proto_init() }
func file_google_cloud_gkebackup_v1_gkebackup_proto_init() {
	if File_google_cloud_gkebackup_v1_gkebackup_proto != nil {
		return
	}
	file_google_cloud_gkebackup_v1_backup_proto_init()
	file_google_cloud_gkebackup_v1_backup_channel_proto_init()
	file_google_cloud_gkebackup_v1_backup_plan_proto_init()
	file_google_cloud_gkebackup_v1_backup_plan_binding_proto_init()
	file_google_cloud_gkebackup_v1_restore_proto_init()
	file_google_cloud_gkebackup_v1_restore_channel_proto_init()
	file_google_cloud_gkebackup_v1_restore_plan_proto_init()
	file_google_cloud_gkebackup_v1_restore_plan_binding_proto_init()
	file_google_cloud_gkebackup_v1_volume_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_gkebackup_v1_gkebackup_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   51,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_gkebackup_v1_gkebackup_proto_goTypes,
		DependencyIndexes: file_google_cloud_gkebackup_v1_gkebackup_proto_depIdxs,
		MessageInfos:      file_google_cloud_gkebackup_v1_gkebackup_proto_msgTypes,
	}.Build()
	File_google_cloud_gkebackup_v1_gkebackup_proto = out.File
	file_google_cloud_gkebackup_v1_gkebackup_proto_rawDesc = nil
	file_google_cloud_gkebackup_v1_gkebackup_proto_goTypes = nil
	file_google_cloud_gkebackup_v1_gkebackup_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// BackupForGKEClient is the client API for BackupForGKE service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type BackupForGKEClient interface {
	// Creates a new BackupPlan in a given location.
	CreateBackupPlan(ctx context.Context, in *CreateBackupPlanRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists BackupPlans in a given location.
	ListBackupPlans(ctx context.Context, in *ListBackupPlansRequest, opts ...grpc.CallOption) (*ListBackupPlansResponse, error)
	// Retrieve the details of a single BackupPlan.
	GetBackupPlan(ctx context.Context, in *GetBackupPlanRequest, opts ...grpc.CallOption) (*BackupPlan, error)
	// Update a BackupPlan.
	UpdateBackupPlan(ctx context.Context, in *UpdateBackupPlanRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes an existing BackupPlan.
	DeleteBackupPlan(ctx context.Context, in *DeleteBackupPlanRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates a new BackupChannel in a given location.
	CreateBackupChannel(ctx context.Context, in *CreateBackupChannelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists BackupChannels in a given location.
	ListBackupChannels(ctx context.Context, in *ListBackupChannelsRequest, opts ...grpc.CallOption) (*ListBackupChannelsResponse, error)
	// Retrieve the details of a single BackupChannel.
	GetBackupChannel(ctx context.Context, in *GetBackupChannelRequest, opts ...grpc.CallOption) (*BackupChannel, error)
	// Update a BackupChannel.
	UpdateBackupChannel(ctx context.Context, in *UpdateBackupChannelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes an existing BackupChannel.
	DeleteBackupChannel(ctx context.Context, in *DeleteBackupChannelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists BackupPlanBindings in a given location.
	ListBackupPlanBindings(ctx context.Context, in *ListBackupPlanBindingsRequest, opts ...grpc.CallOption) (*ListBackupPlanBindingsResponse, error)
	// Retrieve the details of a single BackupPlanBinding.
	GetBackupPlanBinding(ctx context.Context, in *GetBackupPlanBindingRequest, opts ...grpc.CallOption) (*BackupPlanBinding, error)
	// Creates a Backup for the given BackupPlan.
	CreateBackup(ctx context.Context, in *CreateBackupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists the Backups for a given BackupPlan.
	ListBackups(ctx context.Context, in *ListBackupsRequest, opts ...grpc.CallOption) (*ListBackupsResponse, error)
	// Retrieve the details of a single Backup.
	GetBackup(ctx context.Context, in *GetBackupRequest, opts ...grpc.CallOption) (*Backup, error)
	// Update a Backup.
	UpdateBackup(ctx context.Context, in *UpdateBackupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes an existing Backup.
	DeleteBackup(ctx context.Context, in *DeleteBackupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists the VolumeBackups for a given Backup.
	ListVolumeBackups(ctx context.Context, in *ListVolumeBackupsRequest, opts ...grpc.CallOption) (*ListVolumeBackupsResponse, error)
	// Retrieve the details of a single VolumeBackup.
	GetVolumeBackup(ctx context.Context, in *GetVolumeBackupRequest, opts ...grpc.CallOption) (*VolumeBackup, error)
	// Creates a new RestorePlan in a given location.
	CreateRestorePlan(ctx context.Context, in *CreateRestorePlanRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists RestorePlans in a given location.
	ListRestorePlans(ctx context.Context, in *ListRestorePlansRequest, opts ...grpc.CallOption) (*ListRestorePlansResponse, error)
	// Retrieve the details of a single RestorePlan.
	GetRestorePlan(ctx context.Context, in *GetRestorePlanRequest, opts ...grpc.CallOption) (*RestorePlan, error)
	// Update a RestorePlan.
	UpdateRestorePlan(ctx context.Context, in *UpdateRestorePlanRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes an existing RestorePlan.
	DeleteRestorePlan(ctx context.Context, in *DeleteRestorePlanRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates a new RestoreChannel in a given location.
	CreateRestoreChannel(ctx context.Context, in *CreateRestoreChannelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists RestoreChannels in a given location.
	ListRestoreChannels(ctx context.Context, in *ListRestoreChannelsRequest, opts ...grpc.CallOption) (*ListRestoreChannelsResponse, error)
	// Retrieve the details of a single RestoreChannel.
	GetRestoreChannel(ctx context.Context, in *GetRestoreChannelRequest, opts ...grpc.CallOption) (*RestoreChannel, error)
	// Update a RestoreChannel.
	UpdateRestoreChannel(ctx context.Context, in *UpdateRestoreChannelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes an existing RestoreChannel.
	DeleteRestoreChannel(ctx context.Context, in *DeleteRestoreChannelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists RestorePlanBindings in a given location.
	ListRestorePlanBindings(ctx context.Context, in *ListRestorePlanBindingsRequest, opts ...grpc.CallOption) (*ListRestorePlanBindingsResponse, error)
	// Retrieve the details of a single RestorePlanBinding.
	GetRestorePlanBinding(ctx context.Context, in *GetRestorePlanBindingRequest, opts ...grpc.CallOption) (*RestorePlanBinding, error)
	// Creates a new Restore for the given RestorePlan.
	CreateRestore(ctx context.Context, in *CreateRestoreRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists the Restores for a given RestorePlan.
	ListRestores(ctx context.Context, in *ListRestoresRequest, opts ...grpc.CallOption) (*ListRestoresResponse, error)
	// Retrieves the details of a single Restore.
	GetRestore(ctx context.Context, in *GetRestoreRequest, opts ...grpc.CallOption) (*Restore, error)
	// Update a Restore.
	UpdateRestore(ctx context.Context, in *UpdateRestoreRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes an existing Restore.
	DeleteRestore(ctx context.Context, in *DeleteRestoreRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists the VolumeRestores for a given Restore.
	ListVolumeRestores(ctx context.Context, in *ListVolumeRestoresRequest, opts ...grpc.CallOption) (*ListVolumeRestoresResponse, error)
	// Retrieve the details of a single VolumeRestore.
	GetVolumeRestore(ctx context.Context, in *GetVolumeRestoreRequest, opts ...grpc.CallOption) (*VolumeRestore, error)
	// Retrieve the link to the backupIndex.
	GetBackupIndexDownloadUrl(ctx context.Context, in *GetBackupIndexDownloadUrlRequest, opts ...grpc.CallOption) (*GetBackupIndexDownloadUrlResponse, error)
}

type backupForGKEClient struct {
	cc grpc.ClientConnInterface
}

func NewBackupForGKEClient(cc grpc.ClientConnInterface) BackupForGKEClient {
	return &backupForGKEClient{cc}
}

func (c *backupForGKEClient) CreateBackupPlan(ctx context.Context, in *CreateBackupPlanRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.gkebackup.v1.BackupForGKE/CreateBackupPlan", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) ListBackupPlans(ctx context.Context, in *ListBackupPlansRequest, opts ...grpc.CallOption) (*ListBackupPlansResponse, error) {
	out := new(ListBackupPlansResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.gkebackup.v1.BackupForGKE/ListBackupPlans", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) GetBackupPlan(ctx context.Context, in *GetBackupPlanRequest, opts ...grpc.CallOption) (*BackupPlan, error) {
	out := new(BackupPlan)
	err := c.cc.Invoke(ctx, "/google.cloud.gkebackup.v1.BackupForGKE/GetBackupPlan", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) UpdateBackupPlan(ctx context.Context, in *UpdateBackupPlanRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.gkebackup.v1.BackupForGKE/UpdateBackupPlan", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) DeleteBackupPlan(ctx context.Context, in *DeleteBackupPlanRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.gkebackup.v1.BackupForGKE/DeleteBackupPlan", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) CreateBackupChannel(ctx context.Context, in *CreateBackupChannelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.gkebackup.v1.BackupForGKE/CreateBackupChannel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) ListBackupChannels(ctx context.Context, in *ListBackupChannelsRequest, opts ...grpc.CallOption) (*ListBackupChannelsResponse, error) {
	out := new(ListBackupChannelsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.gkebackup.v1.BackupForGKE/ListBackupChannels", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) GetBackupChannel(ctx context.Context, in *GetBackupChannelRequest, opts ...grpc.CallOption) (*BackupChannel, error) {
	out := new(BackupChannel)
	err := c.cc.Invoke(ctx, "/google.cloud.gkebackup.v1.BackupForGKE/GetBackupChannel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) UpdateBackupChannel(ctx context.Context, in *UpdateBackupChannelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.gkebackup.v1.BackupForGKE/UpdateBackupChannel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) DeleteBackupChannel(ctx context.Context, in *DeleteBackupChannelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.gkebackup.v1.BackupForGKE/DeleteBackupChannel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) ListBackupPlanBindings(ctx context.Context, in *ListBackupPlanBindingsRequest, opts ...grpc.CallOption) (*ListBackupPlanBindingsResponse, error) {
	out := new(ListBackupPlanBindingsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.gkebackup.v1.BackupForGKE/ListBackupPlanBindings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) GetBackupPlanBinding(ctx context.Context, in *GetBackupPlanBindingRequest, opts ...grpc.CallOption) (*BackupPlanBinding, error) {
	out := new(BackupPlanBinding)
	err := c.cc.Invoke(ctx, "/google.cloud.gkebackup.v1.BackupForGKE/GetBackupPlanBinding", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) CreateBackup(ctx context.Context, in *CreateBackupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.gkebackup.v1.BackupForGKE/CreateBackup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) ListBackups(ctx context.Context, in *ListBackupsRequest, opts ...grpc.CallOption) (*ListBackupsResponse, error) {
	out := new(ListBackupsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.gkebackup.v1.BackupForGKE/ListBackups", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) GetBackup(ctx context.Context, in *GetBackupRequest, opts ...grpc.CallOption) (*Backup, error) {
	out := new(Backup)
	err := c.cc.Invoke(ctx, "/google.cloud.gkebackup.v1.BackupForGKE/GetBackup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) UpdateBackup(ctx context.Context, in *UpdateBackupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.gkebackup.v1.BackupForGKE/UpdateBackup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) DeleteBackup(ctx context.Context, in *DeleteBackupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.gkebackup.v1.BackupForGKE/DeleteBackup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) ListVolumeBackups(ctx context.Context, in *ListVolumeBackupsRequest, opts ...grpc.CallOption) (*ListVolumeBackupsResponse, error) {
	out := new(ListVolumeBackupsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.gkebackup.v1.BackupForGKE/ListVolumeBackups", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) GetVolumeBackup(ctx context.Context, in *GetVolumeBackupRequest, opts ...grpc.CallOption) (*VolumeBackup, error) {
	out := new(VolumeBackup)
	err := c.cc.Invoke(ctx, "/google.cloud.gkebackup.v1.BackupForGKE/GetVolumeBackup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) CreateRestorePlan(ctx context.Context, in *CreateRestorePlanRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.gkebackup.v1.BackupForGKE/CreateRestorePlan", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) ListRestorePlans(ctx context.Context, in *ListRestorePlansRequest, opts ...grpc.CallOption) (*ListRestorePlansResponse, error) {
	out := new(ListRestorePlansResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.gkebackup.v1.BackupForGKE/ListRestorePlans", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) GetRestorePlan(ctx context.Context, in *GetRestorePlanRequest, opts ...grpc.CallOption) (*RestorePlan, error) {
	out := new(RestorePlan)
	err := c.cc.Invoke(ctx, "/google.cloud.gkebackup.v1.BackupForGKE/GetRestorePlan", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) UpdateRestorePlan(ctx context.Context, in *UpdateRestorePlanRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.gkebackup.v1.BackupForGKE/UpdateRestorePlan", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) DeleteRestorePlan(ctx context.Context, in *DeleteRestorePlanRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.gkebackup.v1.BackupForGKE/DeleteRestorePlan", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) CreateRestoreChannel(ctx context.Context, in *CreateRestoreChannelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.gkebackup.v1.BackupForGKE/CreateRestoreChannel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) ListRestoreChannels(ctx context.Context, in *ListRestoreChannelsRequest, opts ...grpc.CallOption) (*ListRestoreChannelsResponse, error) {
	out := new(ListRestoreChannelsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.gkebackup.v1.BackupForGKE/ListRestoreChannels", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) GetRestoreChannel(ctx context.Context, in *GetRestoreChannelRequest, opts ...grpc.CallOption) (*RestoreChannel, error) {
	out := new(RestoreChannel)
	err := c.cc.Invoke(ctx, "/google.cloud.gkebackup.v1.BackupForGKE/GetRestoreChannel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) UpdateRestoreChannel(ctx context.Context, in *UpdateRestoreChannelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.gkebackup.v1.BackupForGKE/UpdateRestoreChannel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) DeleteRestoreChannel(ctx context.Context, in *DeleteRestoreChannelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.gkebackup.v1.BackupForGKE/DeleteRestoreChannel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) ListRestorePlanBindings(ctx context.Context, in *ListRestorePlanBindingsRequest, opts ...grpc.CallOption) (*ListRestorePlanBindingsResponse, error) {
	out := new(ListRestorePlanBindingsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.gkebackup.v1.BackupForGKE/ListRestorePlanBindings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) GetRestorePlanBinding(ctx context.Context, in *GetRestorePlanBindingRequest, opts ...grpc.CallOption) (*RestorePlanBinding, error) {
	out := new(RestorePlanBinding)
	err := c.cc.Invoke(ctx, "/google.cloud.gkebackup.v1.BackupForGKE/GetRestorePlanBinding", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) CreateRestore(ctx context.Context, in *CreateRestoreRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.gkebackup.v1.BackupForGKE/CreateRestore", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) ListRestores(ctx context.Context, in *ListRestoresRequest, opts ...grpc.CallOption) (*ListRestoresResponse, error) {
	out := new(ListRestoresResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.gkebackup.v1.BackupForGKE/ListRestores", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) GetRestore(ctx context.Context, in *GetRestoreRequest, opts ...grpc.CallOption) (*Restore, error) {
	out := new(Restore)
	err := c.cc.Invoke(ctx, "/google.cloud.gkebackup.v1.BackupForGKE/GetRestore", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) UpdateRestore(ctx context.Context, in *UpdateRestoreRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.gkebackup.v1.BackupForGKE/UpdateRestore", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) DeleteRestore(ctx context.Context, in *DeleteRestoreRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.gkebackup.v1.BackupForGKE/DeleteRestore", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) ListVolumeRestores(ctx context.Context, in *ListVolumeRestoresRequest, opts ...grpc.CallOption) (*ListVolumeRestoresResponse, error) {
	out := new(ListVolumeRestoresResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.gkebackup.v1.BackupForGKE/ListVolumeRestores", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) GetVolumeRestore(ctx context.Context, in *GetVolumeRestoreRequest, opts ...grpc.CallOption) (*VolumeRestore, error) {
	out := new(VolumeRestore)
	err := c.cc.Invoke(ctx, "/google.cloud.gkebackup.v1.BackupForGKE/GetVolumeRestore", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backupForGKEClient) GetBackupIndexDownloadUrl(ctx context.Context, in *GetBackupIndexDownloadUrlRequest, opts ...grpc.CallOption) (*GetBackupIndexDownloadUrlResponse, error) {
	out := new(GetBackupIndexDownloadUrlResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.gkebackup.v1.BackupForGKE/GetBackupIndexDownloadUrl", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// BackupForGKEServer is the server API for BackupForGKE service.
type BackupForGKEServer interface {
	// Creates a new BackupPlan in a given location.
	CreateBackupPlan(context.Context, *CreateBackupPlanRequest) (*longrunningpb.Operation, error)
	// Lists BackupPlans in a given location.
	ListBackupPlans(context.Context, *ListBackupPlansRequest) (*ListBackupPlansResponse, error)
	// Retrieve the details of a single BackupPlan.
	GetBackupPlan(context.Context, *GetBackupPlanRequest) (*BackupPlan, error)
	// Update a BackupPlan.
	UpdateBackupPlan(context.Context, *UpdateBackupPlanRequest) (*longrunningpb.Operation, error)
	// Deletes an existing BackupPlan.
	DeleteBackupPlan(context.Context, *DeleteBackupPlanRequest) (*longrunningpb.Operation, error)
	// Creates a new BackupChannel in a given location.
	CreateBackupChannel(context.Context, *CreateBackupChannelRequest) (*longrunningpb.Operation, error)
	// Lists BackupChannels in a given location.
	ListBackupChannels(context.Context, *ListBackupChannelsRequest) (*ListBackupChannelsResponse, error)
	// Retrieve the details of a single BackupChannel.
	GetBackupChannel(context.Context, *GetBackupChannelRequest) (*BackupChannel, error)
	// Update a BackupChannel.
	UpdateBackupChannel(context.Context, *UpdateBackupChannelRequest) (*longrunningpb.Operation, error)
	// Deletes an existing BackupChannel.
	DeleteBackupChannel(context.Context, *DeleteBackupChannelRequest) (*longrunningpb.Operation, error)
	// Lists BackupPlanBindings in a given location.
	ListBackupPlanBindings(context.Context, *ListBackupPlanBindingsRequest) (*ListBackupPlanBindingsResponse, error)
	// Retrieve the details of a single BackupPlanBinding.
	GetBackupPlanBinding(context.Context, *GetBackupPlanBindingRequest) (*BackupPlanBinding, error)
	// Creates a Backup for the given BackupPlan.
	CreateBackup(context.Context, *CreateBackupRequest) (*longrunningpb.Operation, error)
	// Lists the Backups for a given BackupPlan.
	ListBackups(context.Context, *ListBackupsRequest) (*ListBackupsResponse, error)
	// Retrieve the details of a single Backup.
	GetBackup(context.Context, *GetBackupRequest) (*Backup, error)
	// Update a Backup.
	UpdateBackup(context.Context, *UpdateBackupRequest) (*longrunningpb.Operation, error)
	// Deletes an existing Backup.
	DeleteBackup(context.Context, *DeleteBackupRequest) (*longrunningpb.Operation, error)
	// Lists the VolumeBackups for a given Backup.
	ListVolumeBackups(context.Context, *ListVolumeBackupsRequest) (*ListVolumeBackupsResponse, error)
	// Retrieve the details of a single VolumeBackup.
	GetVolumeBackup(context.Context, *GetVolumeBackupRequest) (*VolumeBackup, error)
	// Creates a new RestorePlan in a given location.
	CreateRestorePlan(context.Context, *CreateRestorePlanRequest) (*longrunningpb.Operation, error)
	// Lists RestorePlans in a given location.
	ListRestorePlans(context.Context, *ListRestorePlansRequest) (*ListRestorePlansResponse, error)
	// Retrieve the details of a single RestorePlan.
	GetRestorePlan(context.Context, *GetRestorePlanRequest) (*RestorePlan, error)
	// Update a RestorePlan.
	UpdateRestorePlan(context.Context, *UpdateRestorePlanRequest) (*longrunningpb.Operation, error)
	// Deletes an existing RestorePlan.
	DeleteRestorePlan(context.Context, *DeleteRestorePlanRequest) (*longrunningpb.Operation, error)
	// Creates a new RestoreChannel in a given location.
	CreateRestoreChannel(context.Context, *CreateRestoreChannelRequest) (*longrunningpb.Operation, error)
	// Lists RestoreChannels in a given location.
	ListRestoreChannels(context.Context, *ListRestoreChannelsRequest) (*ListRestoreChannelsResponse, error)
	// Retrieve the details of a single RestoreChannel.
	GetRestoreChannel(context.Context, *GetRestoreChannelRequest) (*RestoreChannel, error)
	// Update a RestoreChannel.
	UpdateRestoreChannel(context.Context, *UpdateRestoreChannelRequest) (*longrunningpb.Operation, error)
	// Deletes an existing RestoreChannel.
	DeleteRestoreChannel(context.Context, *DeleteRestoreChannelRequest) (*longrunningpb.Operation, error)
	// Lists RestorePlanBindings in a given location.
	ListRestorePlanBindings(context.Context, *ListRestorePlanBindingsRequest) (*ListRestorePlanBindingsResponse, error)
	// Retrieve the details of a single RestorePlanBinding.
	GetRestorePlanBinding(context.Context, *GetRestorePlanBindingRequest) (*RestorePlanBinding, error)
	// Creates a new Restore for the given RestorePlan.
	CreateRestore(context.Context, *CreateRestoreRequest) (*longrunningpb.Operation, error)
	// Lists the Restores for a given RestorePlan.
	ListRestores(context.Context, *ListRestoresRequest) (*ListRestoresResponse, error)
	// Retrieves the details of a single Restore.
	GetRestore(context.Context, *GetRestoreRequest) (*Restore, error)
	// Update a Restore.
	UpdateRestore(context.Context, *UpdateRestoreRequest) (*longrunningpb.Operation, error)
	// Deletes an existing Restore.
	DeleteRestore(context.Context, *DeleteRestoreRequest) (*longrunningpb.Operation, error)
	// Lists the VolumeRestores for a given Restore.
	ListVolumeRestores(context.Context, *ListVolumeRestoresRequest) (*ListVolumeRestoresResponse, error)
	// Retrieve the details of a single VolumeRestore.
	GetVolumeRestore(context.Context, *GetVolumeRestoreRequest) (*VolumeRestore, error)
	// Retrieve the link to the backupIndex.
	GetBackupIndexDownloadUrl(context.Context, *GetBackupIndexDownloadUrlRequest) (*GetBackupIndexDownloadUrlResponse, error)
}

// UnimplementedBackupForGKEServer can be embedded to have forward compatible implementations.
type UnimplementedBackupForGKEServer struct {
}

func (*UnimplementedBackupForGKEServer) CreateBackupPlan(context.Context, *CreateBackupPlanRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateBackupPlan not implemented")
}
func (*UnimplementedBackupForGKEServer) ListBackupPlans(context.Context, *ListBackupPlansRequest) (*ListBackupPlansResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListBackupPlans not implemented")
}
func (*UnimplementedBackupForGKEServer) GetBackupPlan(context.Context, *GetBackupPlanRequest) (*BackupPlan, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetBackupPlan not implemented")
}
func (*UnimplementedBackupForGKEServer) UpdateBackupPlan(context.Context, *UpdateBackupPlanRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateBackupPlan not implemented")
}
func (*UnimplementedBackupForGKEServer) DeleteBackupPlan(context.Context, *DeleteBackupPlanRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteBackupPlan not implemented")
}
func (*UnimplementedBackupForGKEServer) CreateBackupChannel(context.Context, *CreateBackupChannelRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateBackupChannel not implemented")
}
func (*UnimplementedBackupForGKEServer) ListBackupChannels(context.Context, *ListBackupChannelsRequest) (*ListBackupChannelsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListBackupChannels not implemented")
}
func (*UnimplementedBackupForGKEServer) GetBackupChannel(context.Context, *GetBackupChannelRequest) (*BackupChannel, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetBackupChannel not implemented")
}
func (*UnimplementedBackupForGKEServer) UpdateBackupChannel(context.Context, *UpdateBackupChannelRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateBackupChannel not implemented")
}
func (*UnimplementedBackupForGKEServer) DeleteBackupChannel(context.Context, *DeleteBackupChannelRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteBackupChannel not implemented")
}
func (*UnimplementedBackupForGKEServer) ListBackupPlanBindings(context.Context, *ListBackupPlanBindingsRequest) (*ListBackupPlanBindingsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListBackupPlanBindings not implemented")
}
func (*UnimplementedBackupForGKEServer) GetBackupPlanBinding(context.Context, *GetBackupPlanBindingRequest) (*BackupPlanBinding, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetBackupPlanBinding not implemented")
}
func (*UnimplementedBackupForGKEServer) CreateBackup(context.Context, *CreateBackupRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateBackup not implemented")
}
func (*UnimplementedBackupForGKEServer) ListBackups(context.Context, *ListBackupsRequest) (*ListBackupsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListBackups not implemented")
}
func (*UnimplementedBackupForGKEServer) GetBackup(context.Context, *GetBackupRequest) (*Backup, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetBackup not implemented")
}
func (*UnimplementedBackupForGKEServer) UpdateBackup(context.Context, *UpdateBackupRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateBackup not implemented")
}
func (*UnimplementedBackupForGKEServer) DeleteBackup(context.Context, *DeleteBackupRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteBackup not implemented")
}
func (*UnimplementedBackupForGKEServer) ListVolumeBackups(context.Context, *ListVolumeBackupsRequest) (*ListVolumeBackupsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListVolumeBackups not implemented")
}
func (*UnimplementedBackupForGKEServer) GetVolumeBackup(context.Context, *GetVolumeBackupRequest) (*VolumeBackup, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetVolumeBackup not implemented")
}
func (*UnimplementedBackupForGKEServer) CreateRestorePlan(context.Context, *CreateRestorePlanRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateRestorePlan not implemented")
}
func (*UnimplementedBackupForGKEServer) ListRestorePlans(context.Context, *ListRestorePlansRequest) (*ListRestorePlansResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListRestorePlans not implemented")
}
func (*UnimplementedBackupForGKEServer) GetRestorePlan(context.Context, *GetRestorePlanRequest) (*RestorePlan, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRestorePlan not implemented")
}
func (*UnimplementedBackupForGKEServer) UpdateRestorePlan(context.Context, *UpdateRestorePlanRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateRestorePlan not implemented")
}
func (*UnimplementedBackupForGKEServer) DeleteRestorePlan(context.Context, *DeleteRestorePlanRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteRestorePlan not implemented")
}
func (*UnimplementedBackupForGKEServer) CreateRestoreChannel(context.Context, *CreateRestoreChannelRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateRestoreChannel not implemented")
}
func (*UnimplementedBackupForGKEServer) ListRestoreChannels(context.Context, *ListRestoreChannelsRequest) (*ListRestoreChannelsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListRestoreChannels not implemented")
}
func (*UnimplementedBackupForGKEServer) GetRestoreChannel(context.Context, *GetRestoreChannelRequest) (*RestoreChannel, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRestoreChannel not implemented")
}
func (*UnimplementedBackupForGKEServer) UpdateRestoreChannel(context.Context, *UpdateRestoreChannelRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateRestoreChannel not implemented")
}
func (*UnimplementedBackupForGKEServer) DeleteRestoreChannel(context.Context, *DeleteRestoreChannelRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteRestoreChannel not implemented")
}
func (*UnimplementedBackupForGKEServer) ListRestorePlanBindings(context.Context, *ListRestorePlanBindingsRequest) (*ListRestorePlanBindingsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListRestorePlanBindings not implemented")
}
func (*UnimplementedBackupForGKEServer) GetRestorePlanBinding(context.Context, *GetRestorePlanBindingRequest) (*RestorePlanBinding, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRestorePlanBinding not implemented")
}
func (*UnimplementedBackupForGKEServer) CreateRestore(context.Context, *CreateRestoreRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateRestore not implemented")
}
func (*UnimplementedBackupForGKEServer) ListRestores(context.Context, *ListRestoresRequest) (*ListRestoresResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListRestores not implemented")
}
func (*UnimplementedBackupForGKEServer) GetRestore(context.Context, *GetRestoreRequest) (*Restore, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRestore not implemented")
}
func (*UnimplementedBackupForGKEServer) UpdateRestore(context.Context, *UpdateRestoreRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateRestore not implemented")
}
func (*UnimplementedBackupForGKEServer) DeleteRestore(context.Context, *DeleteRestoreRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteRestore not implemented")
}
func (*UnimplementedBackupForGKEServer) ListVolumeRestores(context.Context, *ListVolumeRestoresRequest) (*ListVolumeRestoresResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListVolumeRestores not implemented")
}
func (*UnimplementedBackupForGKEServer) GetVolumeRestore(context.Context, *GetVolumeRestoreRequest) (*VolumeRestore, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetVolumeRestore not implemented")
}
func (*UnimplementedBackupForGKEServer) GetBackupIndexDownloadUrl(context.Context, *GetBackupIndexDownloadUrlRequest) (*GetBackupIndexDownloadUrlResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetBackupIndexDownloadUrl not implemented")
}

func RegisterBackupForGKEServer(s *grpc.Server, srv BackupForGKEServer) {
	s.RegisterService(&_BackupForGKE_serviceDesc, srv)
}

func _BackupForGKE_CreateBackupPlan_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateBackupPlanRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).CreateBackupPlan(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkebackup.v1.BackupForGKE/CreateBackupPlan",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).CreateBackupPlan(ctx, req.(*CreateBackupPlanRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_ListBackupPlans_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBackupPlansRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).ListBackupPlans(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkebackup.v1.BackupForGKE/ListBackupPlans",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).ListBackupPlans(ctx, req.(*ListBackupPlansRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_GetBackupPlan_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBackupPlanRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).GetBackupPlan(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkebackup.v1.BackupForGKE/GetBackupPlan",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).GetBackupPlan(ctx, req.(*GetBackupPlanRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_UpdateBackupPlan_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateBackupPlanRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).UpdateBackupPlan(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkebackup.v1.BackupForGKE/UpdateBackupPlan",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).UpdateBackupPlan(ctx, req.(*UpdateBackupPlanRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_DeleteBackupPlan_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteBackupPlanRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).DeleteBackupPlan(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkebackup.v1.BackupForGKE/DeleteBackupPlan",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).DeleteBackupPlan(ctx, req.(*DeleteBackupPlanRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_CreateBackupChannel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateBackupChannelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).CreateBackupChannel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkebackup.v1.BackupForGKE/CreateBackupChannel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).CreateBackupChannel(ctx, req.(*CreateBackupChannelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_ListBackupChannels_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBackupChannelsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).ListBackupChannels(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkebackup.v1.BackupForGKE/ListBackupChannels",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).ListBackupChannels(ctx, req.(*ListBackupChannelsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_GetBackupChannel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBackupChannelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).GetBackupChannel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkebackup.v1.BackupForGKE/GetBackupChannel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).GetBackupChannel(ctx, req.(*GetBackupChannelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_UpdateBackupChannel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateBackupChannelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).UpdateBackupChannel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkebackup.v1.BackupForGKE/UpdateBackupChannel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).UpdateBackupChannel(ctx, req.(*UpdateBackupChannelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_DeleteBackupChannel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteBackupChannelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).DeleteBackupChannel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkebackup.v1.BackupForGKE/DeleteBackupChannel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).DeleteBackupChannel(ctx, req.(*DeleteBackupChannelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_ListBackupPlanBindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBackupPlanBindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).ListBackupPlanBindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkebackup.v1.BackupForGKE/ListBackupPlanBindings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).ListBackupPlanBindings(ctx, req.(*ListBackupPlanBindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_GetBackupPlanBinding_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBackupPlanBindingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).GetBackupPlanBinding(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkebackup.v1.BackupForGKE/GetBackupPlanBinding",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).GetBackupPlanBinding(ctx, req.(*GetBackupPlanBindingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_CreateBackup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateBackupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).CreateBackup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkebackup.v1.BackupForGKE/CreateBackup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).CreateBackup(ctx, req.(*CreateBackupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_ListBackups_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBackupsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).ListBackups(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkebackup.v1.BackupForGKE/ListBackups",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).ListBackups(ctx, req.(*ListBackupsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_GetBackup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBackupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).GetBackup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkebackup.v1.BackupForGKE/GetBackup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).GetBackup(ctx, req.(*GetBackupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_UpdateBackup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateBackupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).UpdateBackup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkebackup.v1.BackupForGKE/UpdateBackup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).UpdateBackup(ctx, req.(*UpdateBackupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_DeleteBackup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteBackupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).DeleteBackup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkebackup.v1.BackupForGKE/DeleteBackup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).DeleteBackup(ctx, req.(*DeleteBackupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_ListVolumeBackups_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListVolumeBackupsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).ListVolumeBackups(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkebackup.v1.BackupForGKE/ListVolumeBackups",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).ListVolumeBackups(ctx, req.(*ListVolumeBackupsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_GetVolumeBackup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetVolumeBackupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).GetVolumeBackup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkebackup.v1.BackupForGKE/GetVolumeBackup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).GetVolumeBackup(ctx, req.(*GetVolumeBackupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_CreateRestorePlan_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateRestorePlanRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).CreateRestorePlan(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkebackup.v1.BackupForGKE/CreateRestorePlan",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).CreateRestorePlan(ctx, req.(*CreateRestorePlanRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_ListRestorePlans_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRestorePlansRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).ListRestorePlans(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkebackup.v1.BackupForGKE/ListRestorePlans",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).ListRestorePlans(ctx, req.(*ListRestorePlansRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_GetRestorePlan_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRestorePlanRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).GetRestorePlan(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkebackup.v1.BackupForGKE/GetRestorePlan",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).GetRestorePlan(ctx, req.(*GetRestorePlanRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_UpdateRestorePlan_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateRestorePlanRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).UpdateRestorePlan(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkebackup.v1.BackupForGKE/UpdateRestorePlan",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).UpdateRestorePlan(ctx, req.(*UpdateRestorePlanRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_DeleteRestorePlan_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteRestorePlanRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).DeleteRestorePlan(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkebackup.v1.BackupForGKE/DeleteRestorePlan",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).DeleteRestorePlan(ctx, req.(*DeleteRestorePlanRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_CreateRestoreChannel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateRestoreChannelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).CreateRestoreChannel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkebackup.v1.BackupForGKE/CreateRestoreChannel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).CreateRestoreChannel(ctx, req.(*CreateRestoreChannelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_ListRestoreChannels_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRestoreChannelsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).ListRestoreChannels(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkebackup.v1.BackupForGKE/ListRestoreChannels",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).ListRestoreChannels(ctx, req.(*ListRestoreChannelsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_GetRestoreChannel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRestoreChannelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).GetRestoreChannel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkebackup.v1.BackupForGKE/GetRestoreChannel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).GetRestoreChannel(ctx, req.(*GetRestoreChannelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_UpdateRestoreChannel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateRestoreChannelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).UpdateRestoreChannel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkebackup.v1.BackupForGKE/UpdateRestoreChannel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).UpdateRestoreChannel(ctx, req.(*UpdateRestoreChannelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_DeleteRestoreChannel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteRestoreChannelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).DeleteRestoreChannel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkebackup.v1.BackupForGKE/DeleteRestoreChannel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).DeleteRestoreChannel(ctx, req.(*DeleteRestoreChannelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_ListRestorePlanBindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRestorePlanBindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).ListRestorePlanBindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkebackup.v1.BackupForGKE/ListRestorePlanBindings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).ListRestorePlanBindings(ctx, req.(*ListRestorePlanBindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_GetRestorePlanBinding_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRestorePlanBindingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).GetRestorePlanBinding(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkebackup.v1.BackupForGKE/GetRestorePlanBinding",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).GetRestorePlanBinding(ctx, req.(*GetRestorePlanBindingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_CreateRestore_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateRestoreRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).CreateRestore(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkebackup.v1.BackupForGKE/CreateRestore",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).CreateRestore(ctx, req.(*CreateRestoreRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_ListRestores_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRestoresRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).ListRestores(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkebackup.v1.BackupForGKE/ListRestores",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).ListRestores(ctx, req.(*ListRestoresRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_GetRestore_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRestoreRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).GetRestore(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkebackup.v1.BackupForGKE/GetRestore",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).GetRestore(ctx, req.(*GetRestoreRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_UpdateRestore_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateRestoreRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).UpdateRestore(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkebackup.v1.BackupForGKE/UpdateRestore",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).UpdateRestore(ctx, req.(*UpdateRestoreRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_DeleteRestore_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteRestoreRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).DeleteRestore(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkebackup.v1.BackupForGKE/DeleteRestore",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).DeleteRestore(ctx, req.(*DeleteRestoreRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_ListVolumeRestores_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListVolumeRestoresRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).ListVolumeRestores(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkebackup.v1.BackupForGKE/ListVolumeRestores",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).ListVolumeRestores(ctx, req.(*ListVolumeRestoresRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_GetVolumeRestore_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetVolumeRestoreRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).GetVolumeRestore(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkebackup.v1.BackupForGKE/GetVolumeRestore",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).GetVolumeRestore(ctx, req.(*GetVolumeRestoreRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackupForGKE_GetBackupIndexDownloadUrl_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBackupIndexDownloadUrlRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackupForGKEServer).GetBackupIndexDownloadUrl(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkebackup.v1.BackupForGKE/GetBackupIndexDownloadUrl",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackupForGKEServer).GetBackupIndexDownloadUrl(ctx, req.(*GetBackupIndexDownloadUrlRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _BackupForGKE_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.gkebackup.v1.BackupForGKE",
	HandlerType: (*BackupForGKEServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateBackupPlan",
			Handler:    _BackupForGKE_CreateBackupPlan_Handler,
		},
		{
			MethodName: "ListBackupPlans",
			Handler:    _BackupForGKE_ListBackupPlans_Handler,
		},
		{
			MethodName: "GetBackupPlan",
			Handler:    _BackupForGKE_GetBackupPlan_Handler,
		},
		{
			MethodName: "UpdateBackupPlan",
			Handler:    _BackupForGKE_UpdateBackupPlan_Handler,
		},
		{
			MethodName: "DeleteBackupPlan",
			Handler:    _BackupForGKE_DeleteBackupPlan_Handler,
		},
		{
			MethodName: "CreateBackupChannel",
			Handler:    _BackupForGKE_CreateBackupChannel_Handler,
		},
		{
			MethodName: "ListBackupChannels",
			Handler:    _BackupForGKE_ListBackupChannels_Handler,
		},
		{
			MethodName: "GetBackupChannel",
			Handler:    _BackupForGKE_GetBackupChannel_Handler,
		},
		{
			MethodName: "UpdateBackupChannel",
			Handler:    _BackupForGKE_UpdateBackupChannel_Handler,
		},
		{
			MethodName: "DeleteBackupChannel",
			Handler:    _BackupForGKE_DeleteBackupChannel_Handler,
		},
		{
			MethodName: "ListBackupPlanBindings",
			Handler:    _BackupForGKE_ListBackupPlanBindings_Handler,
		},
		{
			MethodName: "GetBackupPlanBinding",
			Handler:    _BackupForGKE_GetBackupPlanBinding_Handler,
		},
		{
			MethodName: "CreateBackup",
			Handler:    _BackupForGKE_CreateBackup_Handler,
		},
		{
			MethodName: "ListBackups",
			Handler:    _BackupForGKE_ListBackups_Handler,
		},
		{
			MethodName: "GetBackup",
			Handler:    _BackupForGKE_GetBackup_Handler,
		},
		{
			MethodName: "UpdateBackup",
			Handler:    _BackupForGKE_UpdateBackup_Handler,
		},
		{
			MethodName: "DeleteBackup",
			Handler:    _BackupForGKE_DeleteBackup_Handler,
		},
		{
			MethodName: "ListVolumeBackups",
			Handler:    _BackupForGKE_ListVolumeBackups_Handler,
		},
		{
			MethodName: "GetVolumeBackup",
			Handler:    _BackupForGKE_GetVolumeBackup_Handler,
		},
		{
			MethodName: "CreateRestorePlan",
			Handler:    _BackupForGKE_CreateRestorePlan_Handler,
		},
		{
			MethodName: "ListRestorePlans",
			Handler:    _BackupForGKE_ListRestorePlans_Handler,
		},
		{
			MethodName: "GetRestorePlan",
			Handler:    _BackupForGKE_GetRestorePlan_Handler,
		},
		{
			MethodName: "UpdateRestorePlan",
			Handler:    _BackupForGKE_UpdateRestorePlan_Handler,
		},
		{
			MethodName: "DeleteRestorePlan",
			Handler:    _BackupForGKE_DeleteRestorePlan_Handler,
		},
		{
			MethodName: "CreateRestoreChannel",
			Handler:    _BackupForGKE_CreateRestoreChannel_Handler,
		},
		{
			MethodName: "ListRestoreChannels",
			Handler:    _BackupForGKE_ListRestoreChannels_Handler,
		},
		{
			MethodName: "GetRestoreChannel",
			Handler:    _BackupForGKE_GetRestoreChannel_Handler,
		},
		{
			MethodName: "UpdateRestoreChannel",
			Handler:    _BackupForGKE_UpdateRestoreChannel_Handler,
		},
		{
			MethodName: "DeleteRestoreChannel",
			Handler:    _BackupForGKE_DeleteRestoreChannel_Handler,
		},
		{
			MethodName: "ListRestorePlanBindings",
			Handler:    _BackupForGKE_ListRestorePlanBindings_Handler,
		},
		{
			MethodName: "GetRestorePlanBinding",
			Handler:    _BackupForGKE_GetRestorePlanBinding_Handler,
		},
		{
			MethodName: "CreateRestore",
			Handler:    _BackupForGKE_CreateRestore_Handler,
		},
		{
			MethodName: "ListRestores",
			Handler:    _BackupForGKE_ListRestores_Handler,
		},
		{
			MethodName: "GetRestore",
			Handler:    _BackupForGKE_GetRestore_Handler,
		},
		{
			MethodName: "UpdateRestore",
			Handler:    _BackupForGKE_UpdateRestore_Handler,
		},
		{
			MethodName: "DeleteRestore",
			Handler:    _BackupForGKE_DeleteRestore_Handler,
		},
		{
			MethodName: "ListVolumeRestores",
			Handler:    _BackupForGKE_ListVolumeRestores_Handler,
		},
		{
			MethodName: "GetVolumeRestore",
			Handler:    _BackupForGKE_GetVolumeRestore_Handler,
		},
		{
			MethodName: "GetBackupIndexDownloadUrl",
			Handler:    _BackupForGKE_GetBackupIndexDownloadUrl_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/gkebackup/v1/gkebackup.proto",
}
