// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/aiplatform/v1/data_foundry_service.proto

package aiplatformpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The data type of the field.
type OutputFieldSpec_FieldType int32

const (
	// Field type is unspecified.
	OutputFieldSpec_FIELD_TYPE_UNSPECIFIED OutputFieldSpec_FieldType = 0
	// Arbitrary content field type.
	OutputFieldSpec_CONTENT OutputFieldSpec_FieldType = 1
	// Text field type.
	OutputFieldSpec_TEXT OutputFieldSpec_FieldType = 2
	// Image field type.
	OutputFieldSpec_IMAGE OutputFieldSpec_FieldType = 3
	// Audio field type.
	OutputFieldSpec_AUDIO OutputFieldSpec_FieldType = 4
)

// Enum value maps for OutputFieldSpec_FieldType.
var (
	OutputFieldSpec_FieldType_name = map[int32]string{
		0: "FIELD_TYPE_UNSPECIFIED",
		1: "CONTENT",
		2: "TEXT",
		3: "IMAGE",
		4: "AUDIO",
	}
	OutputFieldSpec_FieldType_value = map[string]int32{
		"FIELD_TYPE_UNSPECIFIED": 0,
		"CONTENT":                1,
		"TEXT":                   2,
		"IMAGE":                  3,
		"AUDIO":                  4,
	}
)

func (x OutputFieldSpec_FieldType) Enum() *OutputFieldSpec_FieldType {
	p := new(OutputFieldSpec_FieldType)
	*p = x
	return p
}

func (x OutputFieldSpec_FieldType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OutputFieldSpec_FieldType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1_data_foundry_service_proto_enumTypes[0].Descriptor()
}

func (OutputFieldSpec_FieldType) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1_data_foundry_service_proto_enumTypes[0]
}

func (x OutputFieldSpec_FieldType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OutputFieldSpec_FieldType.Descriptor instead.
func (OutputFieldSpec_FieldType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_data_foundry_service_proto_rawDescGZIP(), []int{3, 0}
}

// Request message for DataFoundryService.GenerateSyntheticData.
type GenerateSyntheticDataRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The generation strategy to use.
	//
	// Types that are assignable to Strategy:
	//
	//	*GenerateSyntheticDataRequest_TaskDescription
	Strategy isGenerateSyntheticDataRequest_Strategy `protobuf_oneof:"strategy"`
	// Required. The resource name of the Location to run the job.
	// Format: `projects/{project}/locations/{location}`
	Location string `protobuf:"bytes,1,opt,name=location,proto3" json:"location,omitempty"`
	// Required. The number of synthetic examples to generate.
	// For this stateless API, the count is limited to a small number.
	Count int32 `protobuf:"varint,2,opt,name=count,proto3" json:"count,omitempty"`
	// Required. The schema of the desired output, defined by a list of fields.
	OutputFieldSpecs []*OutputFieldSpec `protobuf:"bytes,4,rep,name=output_field_specs,json=outputFieldSpecs,proto3" json:"output_field_specs,omitempty"`
	// Optional. A list of few-shot examples to guide the model's output style
	// and format.
	Examples []*SyntheticExample `protobuf:"bytes,5,rep,name=examples,proto3" json:"examples,omitempty"`
}

func (x *GenerateSyntheticDataRequest) Reset() {
	*x = GenerateSyntheticDataRequest{}
	mi := &file_google_cloud_aiplatform_v1_data_foundry_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerateSyntheticDataRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateSyntheticDataRequest) ProtoMessage() {}

func (x *GenerateSyntheticDataRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_data_foundry_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateSyntheticDataRequest.ProtoReflect.Descriptor instead.
func (*GenerateSyntheticDataRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_data_foundry_service_proto_rawDescGZIP(), []int{0}
}

func (m *GenerateSyntheticDataRequest) GetStrategy() isGenerateSyntheticDataRequest_Strategy {
	if m != nil {
		return m.Strategy
	}
	return nil
}

func (x *GenerateSyntheticDataRequest) GetTaskDescription() *TaskDescriptionStrategy {
	if x, ok := x.GetStrategy().(*GenerateSyntheticDataRequest_TaskDescription); ok {
		return x.TaskDescription
	}
	return nil
}

func (x *GenerateSyntheticDataRequest) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

func (x *GenerateSyntheticDataRequest) GetCount() int32 {
	if x != nil {
		return x.Count
	}
	return 0
}

func (x *GenerateSyntheticDataRequest) GetOutputFieldSpecs() []*OutputFieldSpec {
	if x != nil {
		return x.OutputFieldSpecs
	}
	return nil
}

func (x *GenerateSyntheticDataRequest) GetExamples() []*SyntheticExample {
	if x != nil {
		return x.Examples
	}
	return nil
}

type isGenerateSyntheticDataRequest_Strategy interface {
	isGenerateSyntheticDataRequest_Strategy()
}

type GenerateSyntheticDataRequest_TaskDescription struct {
	// Generate data from a high-level task description.
	TaskDescription *TaskDescriptionStrategy `protobuf:"bytes,3,opt,name=task_description,json=taskDescription,proto3,oneof"`
}

func (*GenerateSyntheticDataRequest_TaskDescription) isGenerateSyntheticDataRequest_Strategy() {}

// Represents a single named field within a SyntheticExample.
type SyntheticField struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The name of the field.
	FieldName string `protobuf:"bytes,1,opt,name=field_name,json=fieldName,proto3" json:"field_name,omitempty"`
	// Required. The content of the field.
	Content *Content `protobuf:"bytes,2,opt,name=content,proto3" json:"content,omitempty"`
}

func (x *SyntheticField) Reset() {
	*x = SyntheticField{}
	mi := &file_google_cloud_aiplatform_v1_data_foundry_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SyntheticField) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SyntheticField) ProtoMessage() {}

func (x *SyntheticField) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_data_foundry_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SyntheticField.ProtoReflect.Descriptor instead.
func (*SyntheticField) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_data_foundry_service_proto_rawDescGZIP(), []int{1}
}

func (x *SyntheticField) GetFieldName() string {
	if x != nil {
		return x.FieldName
	}
	return ""
}

func (x *SyntheticField) GetContent() *Content {
	if x != nil {
		return x.Content
	}
	return nil
}

// Represents a single synthetic example, composed of multiple fields.
// Used for providing few-shot examples in the request and for returning
// generated examples in the response.
type SyntheticExample struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A list of fields that constitute an example.
	Fields []*SyntheticField `protobuf:"bytes,1,rep,name=fields,proto3" json:"fields,omitempty"`
}

func (x *SyntheticExample) Reset() {
	*x = SyntheticExample{}
	mi := &file_google_cloud_aiplatform_v1_data_foundry_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SyntheticExample) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SyntheticExample) ProtoMessage() {}

func (x *SyntheticExample) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_data_foundry_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SyntheticExample.ProtoReflect.Descriptor instead.
func (*SyntheticExample) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_data_foundry_service_proto_rawDescGZIP(), []int{2}
}

func (x *SyntheticExample) GetFields() []*SyntheticField {
	if x != nil {
		return x.Fields
	}
	return nil
}

// Defines a specification for a single output field.
type OutputFieldSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the output field.
	FieldName string `protobuf:"bytes,1,opt,name=field_name,json=fieldName,proto3" json:"field_name,omitempty"`
	// Optional. Optional, but recommended. Additional guidance specific to this
	// field to provide targeted instructions for the LLM to generate the content
	// of a single output field. While the LLM can sometimes infer content from
	// the field name, providing explicit guidance is preferred.
	Guidance string `protobuf:"bytes,2,opt,name=guidance,proto3" json:"guidance,omitempty"`
	// Optional. The data type of the field. Defaults to CONTENT if not set.
	FieldType OutputFieldSpec_FieldType `protobuf:"varint,3,opt,name=field_type,json=fieldType,proto3,enum=google.cloud.aiplatform.v1.OutputFieldSpec_FieldType" json:"field_type,omitempty"`
}

func (x *OutputFieldSpec) Reset() {
	*x = OutputFieldSpec{}
	mi := &file_google_cloud_aiplatform_v1_data_foundry_service_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OutputFieldSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OutputFieldSpec) ProtoMessage() {}

func (x *OutputFieldSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_data_foundry_service_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OutputFieldSpec.ProtoReflect.Descriptor instead.
func (*OutputFieldSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_data_foundry_service_proto_rawDescGZIP(), []int{3}
}

func (x *OutputFieldSpec) GetFieldName() string {
	if x != nil {
		return x.FieldName
	}
	return ""
}

func (x *OutputFieldSpec) GetGuidance() string {
	if x != nil {
		return x.Guidance
	}
	return ""
}

func (x *OutputFieldSpec) GetFieldType() OutputFieldSpec_FieldType {
	if x != nil {
		return x.FieldType
	}
	return OutputFieldSpec_FIELD_TYPE_UNSPECIFIED
}

// Defines a generation strategy based on a high-level task description.
type TaskDescriptionStrategy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A high-level description of the synthetic data to be generated.
	TaskDescription string `protobuf:"bytes,1,opt,name=task_description,json=taskDescription,proto3" json:"task_description,omitempty"`
}

func (x *TaskDescriptionStrategy) Reset() {
	*x = TaskDescriptionStrategy{}
	mi := &file_google_cloud_aiplatform_v1_data_foundry_service_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TaskDescriptionStrategy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TaskDescriptionStrategy) ProtoMessage() {}

func (x *TaskDescriptionStrategy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_data_foundry_service_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TaskDescriptionStrategy.ProtoReflect.Descriptor instead.
func (*TaskDescriptionStrategy) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_data_foundry_service_proto_rawDescGZIP(), []int{4}
}

func (x *TaskDescriptionStrategy) GetTaskDescription() string {
	if x != nil {
		return x.TaskDescription
	}
	return ""
}

// The response containing the generated data.
type GenerateSyntheticDataResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of generated synthetic examples.
	SyntheticExamples []*SyntheticExample `protobuf:"bytes,1,rep,name=synthetic_examples,json=syntheticExamples,proto3" json:"synthetic_examples,omitempty"`
}

func (x *GenerateSyntheticDataResponse) Reset() {
	*x = GenerateSyntheticDataResponse{}
	mi := &file_google_cloud_aiplatform_v1_data_foundry_service_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerateSyntheticDataResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateSyntheticDataResponse) ProtoMessage() {}

func (x *GenerateSyntheticDataResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_data_foundry_service_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateSyntheticDataResponse.ProtoReflect.Descriptor instead.
func (*GenerateSyntheticDataResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_data_foundry_service_proto_rawDescGZIP(), []int{5}
}

func (x *GenerateSyntheticDataResponse) GetSyntheticExamples() []*SyntheticExample {
	if x != nil {
		return x.SyntheticExamples
	}
	return nil
}

var File_google_cloud_aiplatform_v1_data_foundry_service_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1_data_foundry_service_proto_rawDesc = []byte{
	0x0a, 0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x64, 0x61, 0x74,
	0x61, 0x5f, 0x66, 0x6f, 0x75, 0x6e, 0x64, 0x72, 0x79, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68,
	0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f,
	0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x22, 0x9d, 0x03, 0x0a, 0x1c, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x53, 0x79, 0x6e,
	0x74, 0x68, 0x65, 0x74, 0x69, 0x63, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x60, 0x0a, 0x10, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x73, 0x6b, 0x44, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79,
	0x48, 0x00, 0x52, 0x0f, 0x74, 0x61, 0x73, 0x6b, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x45, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x19, 0x0a, 0x05, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x5e, 0x0a, 0x12, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x53, 0x70, 0x65, 0x63, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x10, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x53, 0x70, 0x65, 0x63, 0x73, 0x12, 0x4d, 0x0a, 0x08, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65,
	0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x79, 0x6e, 0x74, 0x68, 0x65, 0x74, 0x69, 0x63, 0x45, 0x78,
	0x61, 0x6d, 0x70, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x65, 0x78, 0x61, 0x6d,
	0x70, 0x6c, 0x65, 0x73, 0x42, 0x0a, 0x0a, 0x08, 0x73, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79,
	0x22, 0x78, 0x0a, 0x0e, 0x53, 0x79, 0x6e, 0x74, 0x68, 0x65, 0x74, 0x69, 0x63, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x12, 0x22, 0x0a, 0x0a, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x42, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x22, 0x5b, 0x0a, 0x10, 0x53, 0x79,
	0x6e, 0x74, 0x68, 0x65, 0x74, 0x69, 0x63, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x12, 0x47,
	0x0a, 0x06, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x79, 0x6e, 0x74,
	0x68, 0x65, 0x74, 0x69, 0x63, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x06, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x22, 0x87, 0x02, 0x0a, 0x0f, 0x4f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x53, 0x70, 0x65, 0x63, 0x12, 0x22, 0x0a, 0x0a, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x1f, 0x0a, 0x08, 0x67, 0x75, 0x69, 0x64, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x67, 0x75, 0x69, 0x64, 0x61, 0x6e, 0x63, 0x65,
	0x12, 0x59, 0x0a, 0x0a, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x53, 0x70, 0x65,
	0x63, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x09, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x54, 0x79, 0x70, 0x65, 0x22, 0x54, 0x0a, 0x09, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a, 0x16, 0x46, 0x49, 0x45, 0x4c,
	0x44, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x43, 0x4f, 0x4e, 0x54, 0x45, 0x4e, 0x54, 0x10,
	0x01, 0x12, 0x08, 0x0a, 0x04, 0x54, 0x45, 0x58, 0x54, 0x10, 0x02, 0x12, 0x09, 0x0a, 0x05, 0x49,
	0x4d, 0x41, 0x47, 0x45, 0x10, 0x03, 0x12, 0x09, 0x0a, 0x05, 0x41, 0x55, 0x44, 0x49, 0x4f, 0x10,
	0x04, 0x22, 0x49, 0x0a, 0x17, 0x54, 0x61, 0x73, 0x6b, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x12, 0x2e, 0x0a, 0x10,
	0x74, 0x61, 0x73, 0x6b, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x74, 0x61, 0x73,
	0x6b, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x7c, 0x0a, 0x1d,
	0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x53, 0x79, 0x6e, 0x74, 0x68, 0x65, 0x74, 0x69,
	0x63, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5b, 0x0a,
	0x12, 0x73, 0x79, 0x6e, 0x74, 0x68, 0x65, 0x74, 0x69, 0x63, 0x5f, 0x65, 0x78, 0x61, 0x6d, 0x70,
	0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x79, 0x6e, 0x74, 0x68, 0x65, 0x74, 0x69, 0x63,
	0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x52, 0x11, 0x73, 0x79, 0x6e, 0x74, 0x68, 0x65, 0x74,
	0x69, 0x63, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x32, 0xba, 0x02, 0x0a, 0x12, 0x44,
	0x61, 0x74, 0x61, 0x46, 0x6f, 0x75, 0x6e, 0x64, 0x72, 0x79, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x12, 0xd4, 0x01, 0x0a, 0x15, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x53, 0x79,
	0x6e, 0x74, 0x68, 0x65, 0x74, 0x69, 0x63, 0x44, 0x61, 0x74, 0x61, 0x12, 0x38, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74,
	0x65, 0x53, 0x79, 0x6e, 0x74, 0x68, 0x65, 0x74, 0x69, 0x63, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x53, 0x79, 0x6e, 0x74, 0x68,
	0x65, 0x74, 0x69, 0x63, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x46, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x40, 0x3a, 0x01, 0x2a, 0x22, 0x3b, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x7d, 0x3a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x53, 0x79, 0x6e, 0x74, 0x68,
	0x65, 0x74, 0x69, 0x63, 0x44, 0x61, 0x74, 0x61, 0x1a, 0x4d, 0xca, 0x41, 0x19, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f,
	0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xd5, 0x01, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x42, 0x17, 0x44, 0x61, 0x74, 0x61,
	0x46, 0x6f, 0x75, 0x6e, 0x64, 0x72, 0x79, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62, 0x3b, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x70, 0x62, 0xaa, 0x02, 0x1a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x56, 0x31, 0xca, 0x02, 0x1a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x5c, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x5c, 0x56, 0x31, 0xea,
	0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a,
	0x3a, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x3a, 0x3a, 0x56, 0x31, 0x62,
	0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_aiplatform_v1_data_foundry_service_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1_data_foundry_service_proto_rawDescData = file_google_cloud_aiplatform_v1_data_foundry_service_proto_rawDesc
)

func file_google_cloud_aiplatform_v1_data_foundry_service_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1_data_foundry_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1_data_foundry_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1_data_foundry_service_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1_data_foundry_service_proto_rawDescData
}

var file_google_cloud_aiplatform_v1_data_foundry_service_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_aiplatform_v1_data_foundry_service_proto_msgTypes = make([]protoimpl.MessageInfo, 6)
var file_google_cloud_aiplatform_v1_data_foundry_service_proto_goTypes = []any{
	(OutputFieldSpec_FieldType)(0),        // 0: google.cloud.aiplatform.v1.OutputFieldSpec.FieldType
	(*GenerateSyntheticDataRequest)(nil),  // 1: google.cloud.aiplatform.v1.GenerateSyntheticDataRequest
	(*SyntheticField)(nil),                // 2: google.cloud.aiplatform.v1.SyntheticField
	(*SyntheticExample)(nil),              // 3: google.cloud.aiplatform.v1.SyntheticExample
	(*OutputFieldSpec)(nil),               // 4: google.cloud.aiplatform.v1.OutputFieldSpec
	(*TaskDescriptionStrategy)(nil),       // 5: google.cloud.aiplatform.v1.TaskDescriptionStrategy
	(*GenerateSyntheticDataResponse)(nil), // 6: google.cloud.aiplatform.v1.GenerateSyntheticDataResponse
	(*Content)(nil),                       // 7: google.cloud.aiplatform.v1.Content
}
var file_google_cloud_aiplatform_v1_data_foundry_service_proto_depIdxs = []int32{
	5, // 0: google.cloud.aiplatform.v1.GenerateSyntheticDataRequest.task_description:type_name -> google.cloud.aiplatform.v1.TaskDescriptionStrategy
	4, // 1: google.cloud.aiplatform.v1.GenerateSyntheticDataRequest.output_field_specs:type_name -> google.cloud.aiplatform.v1.OutputFieldSpec
	3, // 2: google.cloud.aiplatform.v1.GenerateSyntheticDataRequest.examples:type_name -> google.cloud.aiplatform.v1.SyntheticExample
	7, // 3: google.cloud.aiplatform.v1.SyntheticField.content:type_name -> google.cloud.aiplatform.v1.Content
	2, // 4: google.cloud.aiplatform.v1.SyntheticExample.fields:type_name -> google.cloud.aiplatform.v1.SyntheticField
	0, // 5: google.cloud.aiplatform.v1.OutputFieldSpec.field_type:type_name -> google.cloud.aiplatform.v1.OutputFieldSpec.FieldType
	3, // 6: google.cloud.aiplatform.v1.GenerateSyntheticDataResponse.synthetic_examples:type_name -> google.cloud.aiplatform.v1.SyntheticExample
	1, // 7: google.cloud.aiplatform.v1.DataFoundryService.GenerateSyntheticData:input_type -> google.cloud.aiplatform.v1.GenerateSyntheticDataRequest
	6, // 8: google.cloud.aiplatform.v1.DataFoundryService.GenerateSyntheticData:output_type -> google.cloud.aiplatform.v1.GenerateSyntheticDataResponse
	8, // [8:9] is the sub-list for method output_type
	7, // [7:8] is the sub-list for method input_type
	7, // [7:7] is the sub-list for extension type_name
	7, // [7:7] is the sub-list for extension extendee
	0, // [0:7] is the sub-list for field type_name
}

func init() { file_google_cloud_aiplatform_v1_data_foundry_service_proto_init() }
func file_google_cloud_aiplatform_v1_data_foundry_service_proto_init() {
	if File_google_cloud_aiplatform_v1_data_foundry_service_proto != nil {
		return
	}
	file_google_cloud_aiplatform_v1_content_proto_init()
	file_google_cloud_aiplatform_v1_data_foundry_service_proto_msgTypes[0].OneofWrappers = []any{
		(*GenerateSyntheticDataRequest_TaskDescription)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1_data_foundry_service_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   6,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_aiplatform_v1_data_foundry_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1_data_foundry_service_proto_depIdxs,
		EnumInfos:         file_google_cloud_aiplatform_v1_data_foundry_service_proto_enumTypes,
		MessageInfos:      file_google_cloud_aiplatform_v1_data_foundry_service_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1_data_foundry_service_proto = out.File
	file_google_cloud_aiplatform_v1_data_foundry_service_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1_data_foundry_service_proto_goTypes = nil
	file_google_cloud_aiplatform_v1_data_foundry_service_proto_depIdxs = nil
}
