package cfclient

// Code generated by go generate. DO NOT EDIT.
// This file was generated by robots at
// 2017-11-23 06:47:40.143734 +1100 AEDT m=+2.237010727

import "github.com/pkg/errors"

// IsInvalidAuthTokenError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 1000
// - HTTP code: 401
// - message: "Invalid Auth Token"
func IsInvalidAuthTokenError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 1000
}

// IsMessageParseError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 1001
// - HTTP code: 400
// - message: "Request invalid due to parse error: %s"
func IsMessageParseError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 1001
}

// IsInvalidRelationError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 1002
// - HTTP code: 400
// - message: "%s"
func IsInvalidRelationError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 1002
}

// IsInvalidContentTypeError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 1003
// - HTTP code: 400
// - message: "Invalid content type, expected: %s"
func IsInvalidContentTypeError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 1003
}

// IsNotFoundError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 10000
// - HTTP code: 404
// - message: "Unknown request"
func IsNotFoundError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 10000
}

// IsServerError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 10001
// - HTTP code: 500
// - message: "Server error"
func IsServerError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 10001
}

// IsNotAuthenticatedError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 10002
// - HTTP code: 401
// - message: "Authentication error"
func IsNotAuthenticatedError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 10002
}

// IsNotAuthorizedError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 10003
// - HTTP code: 403
// - message: "You are not authorized to perform the requested action"
func IsNotAuthorizedError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 10003
}

// IsInvalidRequestError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 10004
// - HTTP code: 400
// - message: "The request is invalid"
func IsInvalidRequestError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 10004
}

// IsBadQueryParameterError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 10005
// - HTTP code: 400
// - message: "The query parameter is invalid: %s"
func IsBadQueryParameterError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 10005
}

// IsAssociationNotEmptyError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 10006
// - HTTP code: 400
// - message: "Please delete the %s associations for your %s."
func IsAssociationNotEmptyError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 10006
}

// IsInsufficientScopeError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 10007
// - HTTP code: 403
// - message: "Your token lacks the necessary scopes to access this resource."
func IsInsufficientScopeError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 10007
}

// IsUnprocessableEntityError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 10008
// - HTTP code: 422
// - message: "%s"
func IsUnprocessableEntityError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 10008
}

// IsUnableToPerformError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 10009
// - HTTP code: 400
// - message: "%s could not be completed: %s"
func IsUnableToPerformError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 10009
}

// IsResourceNotFoundError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 10010
// - HTTP code: 404
// - message: "%s"
func IsResourceNotFoundError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 10010
}

// IsDatabaseError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 10011
// - HTTP code: 500
// - message: "Database error"
func IsDatabaseError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 10011
}

// IsOrderByParameterInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 10012
// - HTTP code: 500
// - message: "Cannot order by: %s"
func IsOrderByParameterInvalidError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 10012
}

// IsRateLimitExceededError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 10013
// - HTTP code: 429
// - message: "Rate Limit Exceeded"
func IsRateLimitExceededError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 10013
}

// IsUserInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 20001
// - HTTP code: 400
// - message: "The user info is invalid: %s"
func IsUserInvalidError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 20001
}

// IsUaaIdTakenError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 20002
// - HTTP code: 400
// - message: "The UAA ID is taken: %s"
func IsUaaIdTakenError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 20002
}

// IsUserNotFoundError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 20003
// - HTTP code: 404
// - message: "The user could not be found: %s"
func IsUserNotFoundError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 20003
}

// IsUaaUnavailableError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 20004
// - HTTP code: 503
// - message: "The UAA service is currently unavailable"
func IsUaaUnavailableError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 20004
}

// IsUaaEndpointDisabledError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 20005
// - HTTP code: 501
// - message: "The UAA endpoint needed is disabled"
func IsUaaEndpointDisabledError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 20005
}

// IsUserIsInMultipleOriginsError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 20006
// - HTTP code: 400
// - message: "The user exists in multiple origins. Specify an origin for the requested user from: %s"
func IsUserIsInMultipleOriginsError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 20006
}

// IsUserWithOriginNotFoundError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 20007
// - HTTP code: 404
// - message: "The user could not be found, %s"
func IsUserWithOriginNotFoundError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 20007
}

// IsOutOfRouterGroupPortsError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 21008
// - HTTP code: 403
// - message: "There are no more ports available for router group: %s. Please contact your administrator for more information."
func IsOutOfRouterGroupPortsError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 21008
}

// IsOrganizationInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 30001
// - HTTP code: 400
// - message: "The organization info is invalid: %s"
func IsOrganizationInvalidError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 30001
}

// IsOrganizationNameTakenError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 30002
// - HTTP code: 400
// - message: "The organization name is taken: %s"
func IsOrganizationNameTakenError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 30002
}

// IsOrganizationNotFoundError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 30003
// - HTTP code: 404
// - message: "The organization could not be found: %s"
func IsOrganizationNotFoundError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 30003
}

// IsLastManagerInOrgError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 30004
// - HTTP code: 403
// - message: "Cannot remove last Org Manager in org"
func IsLastManagerInOrgError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 30004
}

// IsLastBillingManagerInOrgError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 30005
// - HTTP code: 403
// - message: "Cannot remove last Billing Manager in org"
func IsLastBillingManagerInOrgError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 30005
}

// IsLastUserInOrgError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 30006
// - HTTP code: 403
// - message: "Cannot remove last User in org"
func IsLastUserInOrgError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 30006
}

// IsOrganizationAlreadySetError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 30007
// - HTTP code: 400
// - message: "Cannot change organization"
func IsOrganizationAlreadySetError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 30007
}

// IsSpaceInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 40001
// - HTTP code: 400
// - message: "The app space info is invalid: %s"
func IsSpaceInvalidError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 40001
}

// IsSpaceNameTakenError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 40002
// - HTTP code: 400
// - message: "The app space name is taken: %s"
func IsSpaceNameTakenError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 40002
}

// IsSpaceUserNotInOrgError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 40003
// - HTTP code: 400
// - message: "The app space and the user are not in the same org: %s"
func IsSpaceUserNotInOrgError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 40003
}

// IsSpaceNotFoundError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 40004
// - HTTP code: 404
// - message: "The app space could not be found: %s"
func IsSpaceNotFoundError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 40004
}

// IsServiceInstanceNameEmptyError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 60001
// - HTTP code: 400
// - message: "Service instance name is required."
func IsServiceInstanceNameEmptyError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 60001
}

// IsServiceInstanceNameTakenError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 60002
// - HTTP code: 400
// - message: "The service instance name is taken: %s"
func IsServiceInstanceNameTakenError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 60002
}

// IsServiceInstanceInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 60003
// - HTTP code: 400
// - message: "The service instance is invalid: %s"
func IsServiceInstanceInvalidError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 60003
}

// IsServiceInstanceNotFoundError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 60004
// - HTTP code: 404
// - message: "The service instance could not be found: %s"
func IsServiceInstanceNotFoundError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 60004
}

// IsServiceInstanceQuotaExceededError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 60005
// - HTTP code: 400
// - message: "You have exceeded your organization's services limit."
func IsServiceInstanceQuotaExceededError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 60005
}

// IsPreviouslyUsedAs_ServiceInstancePaidQuotaExceededError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 60006
// - HTTP code: 400
// - message: "You have exceeded your organization's services limit."
func IsPreviouslyUsedAs_ServiceInstancePaidQuotaExceededError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 60006
}

// IsServiceInstanceServicePlanNotAllowedError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 60007
// - HTTP code: 400
// - message: "The service instance cannot be created because paid service plans are not allowed."
func IsServiceInstanceServicePlanNotAllowedError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 60007
}

// IsServiceInstanceDuplicateNotAllowedError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 60008
// - HTTP code: 400
// - message: "An instance of this service is already present in this space. Some services only support one instance per space."
func IsServiceInstanceDuplicateNotAllowedError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 60008
}

// IsServiceInstanceNameTooLongError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 60009
// - HTTP code: 400
// - message: "You have requested an invalid service instance name. Names are limited to 50 characters."
func IsServiceInstanceNameTooLongError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 60009
}

// IsServiceInstanceOrganizationNotAuthorizedError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 60010
// - HTTP code: 403
// - message: "A service instance for the selected plan cannot be created in this organization. The plan is visible because another organization you belong to has access to it."
func IsServiceInstanceOrganizationNotAuthorizedError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 60010
}

// IsServiceInstanceDeprovisionFailedError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 60011
// - HTTP code: 409
// - message: "The service broker reported an error during deprovisioning: %s"
func IsServiceInstanceDeprovisionFailedError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 60011
}

// IsServiceInstanceSpaceQuotaExceededError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 60012
// - HTTP code: 400
// - message: "You have exceeded your space's services limit."
func IsServiceInstanceSpaceQuotaExceededError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 60012
}

// IsServiceInstanceServicePlanNotAllowedBySpaceQuotaError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 60013
// - HTTP code: 400
// - message: "The service instance cannot be created because paid service plans are not allowed for your space."
func IsServiceInstanceServicePlanNotAllowedBySpaceQuotaError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 60013
}

// IsServiceInstanceSpaceChangeNotAllowedError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 60014
// - HTTP code: 400
// - message: "Cannot update space for service instance."
func IsServiceInstanceSpaceChangeNotAllowedError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 60014
}

// IsServiceInstanceTagsTooLongError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 60015
// - HTTP code: 400
// - message: "Combined length of tags for service %s must be 2048 characters or less."
func IsServiceInstanceTagsTooLongError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 60015
}

// IsAsyncServiceInstanceOperationInProgressError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 60016
// - HTTP code: 409
// - message: "An operation for service instance %s is in progress."
func IsAsyncServiceInstanceOperationInProgressError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 60016
}

// IsServiceInstanceRouteBindingSpaceMismatchError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 60017
// - HTTP code: 400
// - message: "The service instance and the route are in different spaces."
func IsServiceInstanceRouteBindingSpaceMismatchError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 60017
}

// IsServiceInstanceSpaceNotAuthorizedError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 60018
// - HTTP code: 403
// - message: "A service instance for the selected plan cannot be created in this space."
func IsServiceInstanceSpaceNotAuthorizedError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 60018
}

// IsServiceInstanceRouteServiceURLInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 60019
// - HTTP code: 400
// - message: "The route service URL is invalid: %s"
func IsServiceInstanceRouteServiceURLInvalidError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 60019
}

// IsServiceInstanceRouteServiceRequiresDiegoError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 60020
// - HTTP code: 400
// - message: "Route services are only supported for apps on Diego. Unbind the service instance from the route or enable Diego for the app."
func IsServiceInstanceRouteServiceRequiresDiegoError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 60020
}

// IsServiceInstanceRouteServiceDisabledError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 60021
// - HTTP code: 403
// - message: "Support for route services is disabled"
func IsServiceInstanceRouteServiceDisabledError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 60021
}

// IsAppPortMappingRequiresDiegoError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 60022
// - HTTP code: 400
// - message: "App ports are supported for Diego apps only."
func IsAppPortMappingRequiresDiegoError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 60022
}

// IsRoutePortNotEnabledOnAppError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 60023
// - HTTP code: 400
// - message: "Routes can only be mapped to ports already enabled for the application."
func IsRoutePortNotEnabledOnAppError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 60023
}

// IsMultipleAppPortsMappedDiegoToDeaError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 60024
// - HTTP code: 400
// - message: "The app has routes mapped to multiple ports. Multiple ports are supported for Diego only. Please unmap routes from all but one app port. Multiple routes can be mapped to the same port if desired."
func IsMultipleAppPortsMappedDiegoToDeaError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 60024
}

// IsVolumeMountServiceDisabledError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 60025
// - HTTP code: 403
// - message: "Support for volume mount services is disabled"
func IsVolumeMountServiceDisabledError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 60025
}

// IsDockerAppToDeaError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 60026
// - HTTP code: 400
// - message: "Docker apps cannot run on DEAs"
func IsDockerAppToDeaError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 60026
}

// IsRuntimeInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 70001
// - HTTP code: 400
// - message: "The runtime is invalid: %s"
func IsRuntimeInvalidError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 70001
}

// IsRuntimeNameTakenError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 70002
// - HTTP code: 400
// - message: "The runtime name is taken: %s"
func IsRuntimeNameTakenError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 70002
}

// IsRuntimeNotFoundError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 70003
// - HTTP code: 404
// - message: "The runtime could not be found: %s"
func IsRuntimeNotFoundError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 70003
}

// IsFrameworkInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 80001
// - HTTP code: 400
// - message: "The framework is invalid: %s"
func IsFrameworkInvalidError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 80001
}

// IsFrameworkNameTakenError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 80002
// - HTTP code: 400
// - message: "The framework name is taken: %s"
func IsFrameworkNameTakenError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 80002
}

// IsFrameworkNotFoundError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 80003
// - HTTP code: 404
// - message: "The framework could not be found: %s"
func IsFrameworkNotFoundError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 80003
}

// IsServiceBindingInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 90001
// - HTTP code: 400
// - message: "The service binding is invalid: %s"
func IsServiceBindingInvalidError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 90001
}

// IsServiceBindingDifferentSpacesError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 90002
// - HTTP code: 400
// - message: "The app and the service are not in the same app space: %s"
func IsServiceBindingDifferentSpacesError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 90002
}

// IsServiceBindingAppServiceTakenError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 90003
// - HTTP code: 400
// - message: "%s"
func IsServiceBindingAppServiceTakenError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 90003
}

// IsServiceBindingNotFoundError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 90004
// - HTTP code: 404
// - message: "The service binding could not be found: %s"
func IsServiceBindingNotFoundError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 90004
}

// IsUnbindableServiceError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 90005
// - HTTP code: 400
// - message: "The service instance doesn't support binding."
func IsUnbindableServiceError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 90005
}

// IsInvalidLoggingServiceBindingError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 90006
// - HTTP code: 502
// - message: "The service is attempting to stream logs from your application, but is not registered as a logging service. Please contact the service provider."
func IsInvalidLoggingServiceBindingError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 90006
}

// IsAppInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 100001
// - HTTP code: 400
// - message: "The app is invalid: %s"
func IsAppInvalidError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 100001
}

// IsAppNameTakenError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 100002
// - HTTP code: 400
// - message: "The app name is taken: %s"
func IsAppNameTakenError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 100002
}

// IsAppNotFoundError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 100004
// - HTTP code: 404
// - message: "The app could not be found: %s"
func IsAppNotFoundError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 100004
}

// IsAppMemoryQuotaExceededError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 100005
// - HTTP code: 400
// - message: "You have exceeded your organization's memory limit: %s"
func IsAppMemoryQuotaExceededError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 100005
}

// IsAppMemoryInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 100006
// - HTTP code: 400
// - message: "You have specified an invalid amount of memory for your application."
func IsAppMemoryInvalidError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 100006
}

// IsQuotaInstanceMemoryLimitExceededError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 100007
// - HTTP code: 400
// - message: "You have exceeded the instance memory limit for your organization's quota."
func IsQuotaInstanceMemoryLimitExceededError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 100007
}

// IsQuotaInstanceLimitExceededError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 100008
// - HTTP code: 400
// - message: "You have exceeded the instance limit for your organization's quota."
func IsQuotaInstanceLimitExceededError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 100008
}

// IsServicePlanInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 110001
// - HTTP code: 400
// - message: "The service plan is invalid: %s"
func IsServicePlanInvalidError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 110001
}

// IsServicePlanNameTakenError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 110002
// - HTTP code: 400
// - message: "The service plan name is taken: %s"
func IsServicePlanNameTakenError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 110002
}

// IsServicePlanNotFoundError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 110003
// - HTTP code: 404
// - message: "The service plan could not be found: %s"
func IsServicePlanNotFoundError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 110003
}

// IsServicePlanNotUpdateableError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 110004
// - HTTP code: 400
// - message: "The service does not support changing plans."
func IsServicePlanNotUpdateableError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 110004
}

// IsServiceInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 120001
// - HTTP code: 400
// - message: "The service is invalid: %s"
func IsServiceInvalidError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 120001
}

// IsServiceLabelTakenError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 120002
// - HTTP code: 400
// - message: "The service label is taken: %s"
func IsServiceLabelTakenError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 120002
}

// IsServiceNotFoundError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 120003
// - HTTP code: 404
// - message: "The service could not be found: %s"
func IsServiceNotFoundError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 120003
}

// IsDomainInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 130001
// - HTTP code: 400
// - message: "The domain is invalid: %s"
func IsDomainInvalidError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 130001
}

// IsDomainNotFoundError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 130002
// - HTTP code: 404
// - message: "The domain could not be found: %s"
func IsDomainNotFoundError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 130002
}

// IsDomainNameTakenError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 130003
// - HTTP code: 400
// - message: "The domain name is taken: %s"
func IsDomainNameTakenError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 130003
}

// IsPathInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 130004
// - HTTP code: 400
// - message: "The path is invalid: %s"
func IsPathInvalidError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 130004
}

// IsTotalPrivateDomainsExceededError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 130005
// - HTTP code: 400
// - message: "The number of private domains exceeds the quota for organization: %s"
func IsTotalPrivateDomainsExceededError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 130005
}

// IsServiceDoesNotSupportRoutesError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 130006
// - HTTP code: 400
// - message: "This service does not support route binding."
func IsServiceDoesNotSupportRoutesError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 130006
}

// IsRouteAlreadyBoundToServiceInstanceError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 130007
// - HTTP code: 400
// - message: "A route may only be bound to a single service instance"
func IsRouteAlreadyBoundToServiceInstanceError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 130007
}

// IsServiceInstanceAlreadyBoundToSameRouteError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 130008
// - HTTP code: 400
// - message: "The route and service instance are already bound."
func IsServiceInstanceAlreadyBoundToSameRouteError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 130008
}

// IsLegacyApiWithoutDefaultSpaceError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 140001
// - HTTP code: 400
// - message: "A legacy api call requiring a default app space was called, but no default app space is set for the user."
func IsLegacyApiWithoutDefaultSpaceError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 140001
}

// IsAppPackageInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 150001
// - HTTP code: 400
// - message: "The app package is invalid: %s"
func IsAppPackageInvalidError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 150001
}

// IsAppPackageNotFoundError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 150002
// - HTTP code: 404
// - message: "The app package could not be found: %s"
func IsAppPackageNotFoundError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 150002
}

// IsInsufficientRunningResourcesAvailableError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 150003
// - HTTP code: 503
// - message: "One or more instances could not be started because of insufficient running resources."
func IsInsufficientRunningResourcesAvailableError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 150003
}

// IsPackageBitsAlreadyUploadedError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 150004
// - HTTP code: 400
// - message: "Bits may be uploaded only once. Create a new package to upload different bits."
func IsPackageBitsAlreadyUploadedError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 150004
}

// IsBlobstoreNotLocalError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 150005
// - HTTP code: 400
// - message: "Downloading blobs can only be done directly to the blobstore."
func IsBlobstoreNotLocalError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 150005
}

// IsBlobstoreUnavailableError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 150006
// - HTTP code: 502
// - message: "Failed to perform operation due to blobstore unavailability."
func IsBlobstoreUnavailableError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 150006
}

// IsBlobstoreError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 150007
// - HTTP code: 500
// - message: "Failed to perform blobstore operation after three retries."
func IsBlobstoreError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 150007
}

// IsDockerImageMissingError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 150008
// - HTTP code: 400
// - message: "Docker credentials can only be supplied for apps with a 'docker_image'"
func IsDockerImageMissingError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 150008
}

// IsAppBitsUploadInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 160001
// - HTTP code: 400
// - message: "The app upload is invalid: %s"
func IsAppBitsUploadInvalidError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 160001
}

// IsAppBitsCopyInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 160002
// - HTTP code: 400
// - message: "The app copy is invalid: %s"
func IsAppBitsCopyInvalidError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 160002
}

// IsAppResourcesFileModeInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 160003
// - HTTP code: 400
// - message: "The resource file mode is invalid: %s"
func IsAppResourcesFileModeInvalidError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 160003
}

// IsAppResourcesFilePathInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 160004
// - HTTP code: 400
// - message: "The resource file path is invalid: %s"
func IsAppResourcesFilePathInvalidError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 160004
}

// IsStagingError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 170001
// - HTTP code: 400
// - message: "Staging error: %s"
func IsStagingError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 170001
}

// IsNotStagedError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 170002
// - HTTP code: 400
// - message: "App has not finished staging"
func IsNotStagedError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 170002
}

// IsNoAppDetectedError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 170003
// - HTTP code: 400
// - message: "An app was not successfully detected by any available buildpack"
func IsNoAppDetectedError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 170003
}

// IsBuildpackCompileFailedError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 170004
// - HTTP code: 400
// - message: "App staging failed in the buildpack compile phase"
func IsBuildpackCompileFailedError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 170004
}

// IsBuildpackReleaseFailedError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 170005
// - HTTP code: 400
// - message: "App staging failed in the buildpack release phase"
func IsBuildpackReleaseFailedError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 170005
}

// IsNoBuildpacksFoundError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 170006
// - HTTP code: 400
// - message: "There are no buildpacks available"
func IsNoBuildpacksFoundError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 170006
}

// IsStagingTimeExpiredError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 170007
// - HTTP code: 504
// - message: "Staging time expired: %s"
func IsStagingTimeExpiredError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 170007
}

// IsInsufficientResourcesError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 170008
// - HTTP code: 400
// - message: "Insufficient resources"
func IsInsufficientResourcesError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 170008
}

// IsNoCompatibleCellError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 170009
// - HTTP code: 400
// - message: "Found no compatible cell"
func IsNoCompatibleCellError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 170009
}

// IsStagerUnavailableError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 170010
// - HTTP code: 503
// - message: "Stager is unavailable: %s"
func IsStagerUnavailableError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 170010
}

// IsStagerError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 170011
// - HTTP code: 500
// - message: "Stager error: %s"
func IsStagerError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 170011
}

// IsRunnerInvalidRequestError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 170014
// - HTTP code: 500
// - message: "Runner invalid request: %s"
func IsRunnerInvalidRequestError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 170014
}

// IsRunnerUnavailableError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 170015
// - HTTP code: 503
// - message: "Runner is unavailable: %s"
func IsRunnerUnavailableError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 170015
}

// IsRunnerError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 170016
// - HTTP code: 500
// - message: "Runner error: %s"
func IsRunnerError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 170016
}

// IsStagingInProgressError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 170017
// - HTTP code: 422
// - message: "Only one build can be STAGING at a time per application."
func IsStagingInProgressError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 170017
}

// IsInvalidTaskAddressError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 170018
// - HTTP code: 500
// - message: "Invalid config: %s"
func IsInvalidTaskAddressError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 170018
}

// IsTaskError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 170019
// - HTTP code: 500
// - message: "Task failed: %s"
func IsTaskError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 170019
}

// IsTaskWorkersUnavailableError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 170020
// - HTTP code: 503
// - message: "Task workers are unavailable: %s"
func IsTaskWorkersUnavailableError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 170020
}

// IsInvalidTaskRequestError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 170021
// - HTTP code: 422
// - message: "The task request is invalid: %s"
func IsInvalidTaskRequestError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 170021
}

// IsServiceGatewayError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 180002
// - HTTP code: 503
// - message: "Service gateway internal error: %s"
func IsServiceGatewayError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 180002
}

// IsServiceNotImplementedError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 180003
// - HTTP code: 501
// - message: "Operation not supported for service"
func IsServiceNotImplementedError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 180003
}

// IsSDSNotAvailableError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 180004
// - HTTP code: 501
// - message: "No serialization service backends available"
func IsSDSNotAvailableError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 180004
}

// IsFileError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 190001
// - HTTP code: 400
// - message: "File error: %s"
func IsFileError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 190001
}

// IsStatsError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 200001
// - HTTP code: 400
// - message: "Stats error: %s"
func IsStatsError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 200001
}

// IsStatsUnavailableError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 200002
// - HTTP code: 503
// - message: "Stats unavailable: %s"
func IsStatsUnavailableError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 200002
}

// IsAppStoppedStatsError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 200003
// - HTTP code: 400
// - message: "Could not fetch stats for stopped app: %s"
func IsAppStoppedStatsError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 200003
}

// IsRouteInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 210001
// - HTTP code: 400
// - message: "The route is invalid: %s"
func IsRouteInvalidError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 210001
}

// IsRouteNotFoundError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 210002
// - HTTP code: 404
// - message: "The route could not be found: %s"
func IsRouteNotFoundError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 210002
}

// IsRouteHostTakenError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 210003
// - HTTP code: 400
// - message: "The host is taken: %s"
func IsRouteHostTakenError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 210003
}

// IsRoutePathTakenError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 210004
// - HTTP code: 400
// - message: "The path is taken: %s"
func IsRoutePathTakenError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 210004
}

// IsRoutePortTakenError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 210005
// - HTTP code: 400
// - message: "The port is taken: %s"
func IsRoutePortTakenError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 210005
}

// IsRouteMappingTakenError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 210006
// - HTTP code: 400
// - message: "The route mapping is taken: %s"
func IsRouteMappingTakenError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 210006
}

// IsRouteMappingNotFoundError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 210007
// - HTTP code: 404
// - message: "The route mapping could not be found: %s"
func IsRouteMappingNotFoundError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 210007
}

// IsRouterGroupNotFoundError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 210009
// - HTTP code: 404
// - message: "The router group could not be found: %s"
func IsRouterGroupNotFoundError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 210009
}

// IsInstancesError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 220001
// - HTTP code: 400
// - message: "Instances error: %s"
func IsInstancesError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 220001
}

// IsInstancesUnavailableError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 220002
// - HTTP code: 503
// - message: "Instances information unavailable: %s"
func IsInstancesUnavailableError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 220002
}

// IsEventNotFoundError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 230002
// - HTTP code: 404
// - message: "Event could not be found: %s"
func IsEventNotFoundError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 230002
}

// IsQuotaDefinitionNotFoundError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 240001
// - HTTP code: 404
// - message: "Quota Definition could not be found: %s"
func IsQuotaDefinitionNotFoundError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 240001
}

// IsQuotaDefinitionNameTakenError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 240002
// - HTTP code: 400
// - message: "Quota Definition is taken: %s"
func IsQuotaDefinitionNameTakenError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 240002
}

// IsQuotaDefinitionInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 240003
// - HTTP code: 400
// - message: "Quota Definition is invalid: %s"
func IsQuotaDefinitionInvalidError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 240003
}

// IsQuotaDefinitionMemoryLimitNegativeError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 240004
// - HTTP code: 400
// - message: "Quota Definition memory limit cannot be negative"
func IsQuotaDefinitionMemoryLimitNegativeError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 240004
}

// IsStackInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 250001
// - HTTP code: 400
// - message: "The stack is invalid: %s"
func IsStackInvalidError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 250001
}

// IsStackNameTakenError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 250002
// - HTTP code: 400
// - message: "The stack name is taken: %s"
func IsStackNameTakenError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 250002
}

// IsStackNotFoundError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 250003
// - HTTP code: 404
// - message: "The stack could not be found: %s"
func IsStackNotFoundError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 250003
}

// IsServicePlanVisibilityInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 260001
// - HTTP code: 400
// - message: "Service Plan Visibility is invalid: %s"
func IsServicePlanVisibilityInvalidError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 260001
}

// IsServicePlanVisibilityAlreadyExistsError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 260002
// - HTTP code: 400
// - message: "This combination of ServicePlan and Organization is already taken: %s"
func IsServicePlanVisibilityAlreadyExistsError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 260002
}

// IsServicePlanVisibilityNotFoundError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 260003
// - HTTP code: 404
// - message: "The service plan visibility could not be found: %s"
func IsServicePlanVisibilityNotFoundError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 260003
}

// IsServiceBrokerInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 270001
// - HTTP code: 400
// - message: "Service broker is invalid: %s"
func IsServiceBrokerInvalidError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 270001
}

// IsServiceBrokerNameTakenError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 270002
// - HTTP code: 400
// - message: "The service broker name is taken"
func IsServiceBrokerNameTakenError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 270002
}

// IsServiceBrokerUrlTakenError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 270003
// - HTTP code: 400
// - message: "The service broker url is taken: %s"
func IsServiceBrokerUrlTakenError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 270003
}

// IsServiceBrokerNotFoundError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 270004
// - HTTP code: 404
// - message: "The service broker was not found: %s"
func IsServiceBrokerNotFoundError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 270004
}

// IsServiceBrokerNotRemovableError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 270010
// - HTTP code: 400
// - message: "Can not remove brokers that have associated service instances: %s"
func IsServiceBrokerNotRemovableError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 270010
}

// IsServiceBrokerUrlInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 270011
// - HTTP code: 400
// - message: "%s is not a valid URL"
func IsServiceBrokerUrlInvalidError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 270011
}

// IsServiceBrokerCatalogInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 270012
// - HTTP code: 502
// - message: "Service broker catalog is invalid: %s"
func IsServiceBrokerCatalogInvalidError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 270012
}

// IsServiceBrokerDashboardClientFailureError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 270013
// - HTTP code: 502
// - message: "Service broker dashboard clients could not be modified: %s"
func IsServiceBrokerDashboardClientFailureError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 270013
}

// IsServiceBrokerAsyncRequiredError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 270014
// - HTTP code: 400
// - message: "This service plan requires client support for asynchronous service operations."
func IsServiceBrokerAsyncRequiredError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 270014
}

// IsServiceDashboardClientMissingUrlError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 270015
// - HTTP code: 502
// - message: "Service broker returned dashboard client configuration without a dashboard URL"
func IsServiceDashboardClientMissingUrlError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 270015
}

// IsBuildpackNameTakenError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 290001
// - HTTP code: 400
// - message: "The buildpack name is already in use: %s"
func IsBuildpackNameTakenError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 290001
}

// IsBuildpackBitsUploadInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 290002
// - HTTP code: 400
// - message: "The buildpack upload is invalid: %s"
func IsBuildpackBitsUploadInvalidError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 290002
}

// IsBuildpackInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 290003
// - HTTP code: 400
// - message: "Buildpack is invalid: %s"
func IsBuildpackInvalidError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 290003
}

// IsCustomBuildpacksDisabledError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 290004
// - HTTP code: 400
// - message: "Custom buildpacks are disabled"
func IsCustomBuildpacksDisabledError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 290004
}

// IsBuildpackLockedError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 290005
// - HTTP code: 409
// - message: "The buildpack is locked"
func IsBuildpackLockedError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 290005
}

// IsJobTimeoutError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 290006
// - HTTP code: 524
// - message: "The job execution has timed out."
func IsJobTimeoutError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 290006
}

// IsSpaceDeleteTimeoutError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 290007
// - HTTP code: 524
// - message: "Deletion of space %s timed out before all resources within could be deleted"
func IsSpaceDeleteTimeoutError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 290007
}

// IsSpaceDeletionFailedError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 290008
// - HTTP code: 502
// - message: "Deletion of space %s failed because one or more resources within could not be deleted.\n\n%s"
func IsSpaceDeletionFailedError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 290008
}

// IsOrganizationDeleteTimeoutError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 290009
// - HTTP code: 524
// - message: "Delete of organization %s timed out before all resources within could be deleted"
func IsOrganizationDeleteTimeoutError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 290009
}

// IsOrganizationDeletionFailedError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 290010
// - HTTP code: 502
// - message: "Deletion of organization %s failed because one or more resources within could not be deleted.\n\n%s"
func IsOrganizationDeletionFailedError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 290010
}

// IsNonrecursiveSpaceDeletionFailedError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 290011
// - HTTP code: 400
// - message: "Resource inside space %s must first be deleted, or specify recursive delete."
func IsNonrecursiveSpaceDeletionFailedError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 290011
}

// IsBitsServiceError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 290012
// - HTTP code: 500
// - message: "The bits service returned an error: %s"
func IsBitsServiceError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 290012
}

// IsSpaceRolesDeletionTimeoutError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 290013
// - HTTP code: 524
// - message: "Deletion of roles for space %s timed out before all roles could be deleted"
func IsSpaceRolesDeletionTimeoutError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 290013
}

// IsOrganizationRolesDeletionFailedError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 290014
// - HTTP code: 502
// - message: "Failed to delete one or more roles for organization %s"
func IsOrganizationRolesDeletionFailedError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 290014
}

// IsSpaceRolesDeletionFailedError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 290016
// - HTTP code: 502
// - message: "Failed to delete one or more roles for space %s"
func IsSpaceRolesDeletionFailedError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 290016
}

// IsSecurityGroupInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 300001
// - HTTP code: 400
// - message: "The security group is invalid: %s"
func IsSecurityGroupInvalidError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 300001
}

// IsSecurityGroupNotFoundError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 300002
// - HTTP code: 404
// - message: "The security group could not be found: %s"
func IsSecurityGroupNotFoundError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 300002
}

// IsSecurityGroupStagingDefaultInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 300003
// - HTTP code: 400
// - message: "The security group could not be found: %s"
func IsSecurityGroupStagingDefaultInvalidError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 300003
}

// IsSecurityGroupRunningDefaultInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 300004
// - HTTP code: 400
// - message: "The security group could not be found: %s"
func IsSecurityGroupRunningDefaultInvalidError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 300004
}

// IsSecurityGroupNameTakenError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 300005
// - HTTP code: 400
// - message: "The security group name is taken: %s"
func IsSecurityGroupNameTakenError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 300005
}

// IsSpaceQuotaDefinitionInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 310001
// - HTTP code: 400
// - message: "Space Quota Definition is invalid: %s"
func IsSpaceQuotaDefinitionInvalidError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 310001
}

// IsSpaceQuotaDefinitionNameTakenError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 310002
// - HTTP code: 400
// - message: "The space quota definition name is taken: %s"
func IsSpaceQuotaDefinitionNameTakenError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 310002
}

// IsSpaceQuotaMemoryLimitExceededError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 310003
// - HTTP code: 400
// - message: "You have exceeded your space's memory limit: %s"
func IsSpaceQuotaMemoryLimitExceededError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 310003
}

// IsSpaceQuotaInstanceMemoryLimitExceededError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 310004
// - HTTP code: 400
// - message: "You have exceeded the instance memory limit for your space's quota."
func IsSpaceQuotaInstanceMemoryLimitExceededError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 310004
}

// IsSpaceQuotaTotalRoutesExceededError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 310005
// - HTTP code: 400
// - message: "You have exceeded the total routes for your space's quota."
func IsSpaceQuotaTotalRoutesExceededError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 310005
}

// IsOrgQuotaTotalRoutesExceededError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 310006
// - HTTP code: 400
// - message: "You have exceeded the total routes for your organization's quota."
func IsOrgQuotaTotalRoutesExceededError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 310006
}

// IsSpaceQuotaDefinitionNotFoundError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 310007
// - HTTP code: 404
// - message: "Space Quota Definition could not be found: %s"
func IsSpaceQuotaDefinitionNotFoundError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 310007
}

// IsSpaceQuotaInstanceLimitExceededError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 310008
// - HTTP code: 400
// - message: "You have exceeded the instance limit for your space's quota."
func IsSpaceQuotaInstanceLimitExceededError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 310008
}

// IsOrgQuotaTotalReservedRoutePortsExceededError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 310009
// - HTTP code: 400
// - message: "You have exceeded the total reserved route ports for your organization's quota."
func IsOrgQuotaTotalReservedRoutePortsExceededError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 310009
}

// IsSpaceQuotaTotalReservedRoutePortsExceededError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 310010
// - HTTP code: 400
// - message: "You have exceeded the total reserved route ports for your space's quota."
func IsSpaceQuotaTotalReservedRoutePortsExceededError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 310010
}

// IsDiegoDisabledError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 320001
// - HTTP code: 400
// - message: "Diego has not been enabled."
func IsDiegoDisabledError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 320001
}

// IsDiegoDockerBuildpackConflictError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 320002
// - HTTP code: 400
// - message: "You cannot specify a custom buildpack and a docker image at the same time."
func IsDiegoDockerBuildpackConflictError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 320002
}

// IsDockerDisabledError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 320003
// - HTTP code: 400
// - message: "Docker support has not been enabled."
func IsDockerDisabledError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 320003
}

// IsStagingBackendInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 320004
// - HTTP code: 403
// - message: "The request staging completion endpoint only handles apps desired to stage on the Diego backend."
func IsStagingBackendInvalidError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 320004
}

// IsBackendSelectionNotAuthorizedError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 320005
// - HTTP code: 403
// - message: "You cannot select the backend on which to run this application"
func IsBackendSelectionNotAuthorizedError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 320005
}

// IsFeatureFlagNotFoundError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 330000
// - HTTP code: 404
// - message: "The feature flag could not be found: %s"
func IsFeatureFlagNotFoundError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 330000
}

// IsFeatureFlagInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 330001
// - HTTP code: 400
// - message: "The feature flag is invalid: %s"
func IsFeatureFlagInvalidError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 330001
}

// IsFeatureDisabledError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 330002
// - HTTP code: 403
// - message: "Feature Disabled: %s"
func IsFeatureDisabledError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 330002
}

// IsUserProvidedServiceInstanceNotFoundError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 340001
// - HTTP code: 404
// - message: "The service instance could not be found: %s"
func IsUserProvidedServiceInstanceNotFoundError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 340001
}

// IsUserProvidedServiceInstanceHandlerNeededError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 340002
// - HTTP code: 400
// - message: "Please use the User Provided Services API to manage this resource."
func IsUserProvidedServiceInstanceHandlerNeededError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 340002
}

// IsProcessInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 350001
// - HTTP code: 400
// - message: "The process is invalid: %s"
func IsProcessInvalidError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 350001
}

// IsUnableToDeleteError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 350002
// - HTTP code: 400
// - message: "Unable to perform delete action: %s"
func IsUnableToDeleteError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 350002
}

// IsProcessNotFoundError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 350003
// - HTTP code: 404
// - message: "The process could not be found: %s"
func IsProcessNotFoundError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 350003
}

// IsServiceKeyNameTakenError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 360001
// - HTTP code: 400
// - message: "The service key name is taken: %s"
func IsServiceKeyNameTakenError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 360001
}

// IsServiceKeyInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 360002
// - HTTP code: 400
// - message: "The service key is invalid: %s"
func IsServiceKeyInvalidError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 360002
}

// IsServiceKeyNotFoundError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 360003
// - HTTP code: 404
// - message: "The service key could not be found: %s"
func IsServiceKeyNotFoundError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 360003
}

// IsServiceKeyNotSupportedError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 360004
// - HTTP code: 400
// - message: "%s"
func IsServiceKeyNotSupportedError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 360004
}

// IsServiceKeyCredentialStoreUnavailableError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 360005
// - HTTP code: 503
// - message: "Credential store is unavailable"
func IsServiceKeyCredentialStoreUnavailableError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 360005
}

// IsRoutingApiUnavailableError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 370001
// - HTTP code: 503
// - message: "The Routing API is currently unavailable"
func IsRoutingApiUnavailableError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 370001
}

// IsRoutingApiDisabledError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 370003
// - HTTP code: 403
// - message: "Routing API is disabled"
func IsRoutingApiDisabledError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 370003
}

// IsEnvironmentVariableGroupInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 380001
// - HTTP code: 400
// - message: "The Environment Variable Group is invalid: %s"
func IsEnvironmentVariableGroupInvalidError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 380001
}

// IsDropletUploadInvalidError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 380002
// - HTTP code: 400
// - message: "The droplet upload is invalid: %s"
func IsDropletUploadInvalidError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 380002
}

// IsServiceInstanceUnshareFailedError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 390001
// - HTTP code: 502
// - message: "Unshare of service instance failed because one or more bindings could not be deleted.\n\n%s"
func IsServiceInstanceUnshareFailedError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 390001
}

// IsServiceInstanceDeletionSharesExistsError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 390002
// - HTTP code: 400
// - message: "Service instances must be unshared before they can be deleted. Unsharing %s will automatically delete any bindings that have been made to applications in other spaces."
func IsServiceInstanceDeletionSharesExistsError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 390002
}

// IsServiceShareIsDisabledError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 390003
// - HTTP code: 400
// - message: "The %s service does not support service instance sharing."
func IsServiceShareIsDisabledError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 390003
}

// IsUserProvidedServiceInstanceSharingNotSupportedError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 390004
// - HTTP code: 400
// - message: "User-provided services cannot be shared"
func IsUserProvidedServiceInstanceSharingNotSupportedError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 390004
}

// IsRouteServiceInstanceSharingNotSupportedError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 390005
// - HTTP code: 400
// - message: "Route services cannot be shared"
func IsRouteServiceInstanceSharingNotSupportedError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 390005
}

// IsSharedServiceInstanceNameTakenError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 390006
// - HTTP code: 400
// - message: "A service instance called %s already exists in %s"
func IsSharedServiceInstanceNameTakenError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 390006
}

// IsInvalidServiceInstanceSharingTargetSpaceError returns a boolean indicating whether
// the error is known to report the Cloud Foundry error:
// - Cloud Foundry code: 390007
// - HTTP code: 422
// - message: "Service instances cannot be shared into the space where they were created"
func IsInvalidServiceInstanceSharingTargetSpaceError(err error) bool {
	cause := errors.Cause(err)
	cferr, ok := cause.(CloudFoundryError)
	if !ok {
		return false
	}
	return cferr.Code == 390007
}
