// Code generated by smithy-go-codegen DO NOT EDIT.

package ec2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ec2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves version information for an IPAM prefix list resolver.
//
// Each version is a snapshot of what CIDRs matched your rules at that moment in
// time. The version number increments every time the CIDR list changes due to
// infrastructure changes.
//
// Version example:
//
// Initial State (Version 1)
//
// Production environment:
//
//   - vpc-prod-web (10.1.0.0/16) - tagged env=prod
//
//   - vpc-prod-db (10.2.0.0/16) - tagged env=prod
//
// Resolver rule: Include all VPCs tagged env=prod
//
// Version 1 CIDRs: 10.1.0.0/16, 10.2.0.0/16
//
// Infrastructure Change (Version 2)
//
// New VPC added:
//
//   - vpc-prod-api (10.3.0.0/16) - tagged env=prod
//
// IPAM automatically detects the change and creates a new version.
//
// Version 2 CIDRs: 10.1.0.0/16, 10.2.0.0/16, 10.3.0.0/16
func (c *Client) GetIpamPrefixListResolverVersions(ctx context.Context, params *GetIpamPrefixListResolverVersionsInput, optFns ...func(*Options)) (*GetIpamPrefixListResolverVersionsOutput, error) {
	if params == nil {
		params = &GetIpamPrefixListResolverVersionsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetIpamPrefixListResolverVersions", params, optFns, c.addOperationGetIpamPrefixListResolverVersionsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetIpamPrefixListResolverVersionsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetIpamPrefixListResolverVersionsInput struct {

	// The ID of the IPAM prefix list resolver whose versions you want to retrieve.
	//
	// This member is required.
	IpamPrefixListResolverId *string

	// A check for whether you have the required permissions for the action without
	// actually making the request and provides an error response. If you have the
	// required permissions, the error response is DryRunOperation . Otherwise, it is
	// UnauthorizedOperation .
	DryRun *bool

	// One or more filters to limit the results.
	Filters []types.Filter

	// Specific version numbers to retrieve. If not specified, all versions are
	// returned.
	IpamPrefixListResolverVersions []int64

	// The maximum number of items to return for this request. To get the next page of
	// items, make another request with the token returned in the output. For more
	// information, see [Pagination].
	//
	// [Pagination]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination
	MaxResults *int32

	// The token for the next page of results.
	NextToken *string

	noSmithyDocumentSerde
}

type GetIpamPrefixListResolverVersionsOutput struct {

	// Information about the IPAM prefix list resolver versions.
	IpamPrefixListResolverVersions []types.IpamPrefixListResolverVersion

	// The token to use to retrieve the next page of results. This value is null when
	// there are no more results to return.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetIpamPrefixListResolverVersionsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsEc2query_serializeOpGetIpamPrefixListResolverVersions{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpGetIpamPrefixListResolverVersions{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetIpamPrefixListResolverVersions"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetIpamPrefixListResolverVersionsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetIpamPrefixListResolverVersions(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// GetIpamPrefixListResolverVersionsPaginatorOptions is the paginator options for
// GetIpamPrefixListResolverVersions
type GetIpamPrefixListResolverVersionsPaginatorOptions struct {
	// The maximum number of items to return for this request. To get the next page of
	// items, make another request with the token returned in the output. For more
	// information, see [Pagination].
	//
	// [Pagination]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// GetIpamPrefixListResolverVersionsPaginator is a paginator for
// GetIpamPrefixListResolverVersions
type GetIpamPrefixListResolverVersionsPaginator struct {
	options   GetIpamPrefixListResolverVersionsPaginatorOptions
	client    GetIpamPrefixListResolverVersionsAPIClient
	params    *GetIpamPrefixListResolverVersionsInput
	nextToken *string
	firstPage bool
}

// NewGetIpamPrefixListResolverVersionsPaginator returns a new
// GetIpamPrefixListResolverVersionsPaginator
func NewGetIpamPrefixListResolverVersionsPaginator(client GetIpamPrefixListResolverVersionsAPIClient, params *GetIpamPrefixListResolverVersionsInput, optFns ...func(*GetIpamPrefixListResolverVersionsPaginatorOptions)) *GetIpamPrefixListResolverVersionsPaginator {
	if params == nil {
		params = &GetIpamPrefixListResolverVersionsInput{}
	}

	options := GetIpamPrefixListResolverVersionsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &GetIpamPrefixListResolverVersionsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *GetIpamPrefixListResolverVersionsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next GetIpamPrefixListResolverVersions page.
func (p *GetIpamPrefixListResolverVersionsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*GetIpamPrefixListResolverVersionsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.GetIpamPrefixListResolverVersions(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// GetIpamPrefixListResolverVersionsAPIClient is a client that implements the
// GetIpamPrefixListResolverVersions operation.
type GetIpamPrefixListResolverVersionsAPIClient interface {
	GetIpamPrefixListResolverVersions(context.Context, *GetIpamPrefixListResolverVersionsInput, ...func(*Options)) (*GetIpamPrefixListResolverVersionsOutput, error)
}

var _ GetIpamPrefixListResolverVersionsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opGetIpamPrefixListResolverVersions(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetIpamPrefixListResolverVersions",
	}
}
