// Code generated by smithy-go-codegen DO NOT EDIT.

package ec2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ec2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

//	Modifies the number of instances allocated to an interruptible reservation,
//
// allowing you to add more capacity or reclaim capacity to your source Capacity
// Reservation.
func (c *Client) UpdateInterruptibleCapacityReservationAllocation(ctx context.Context, params *UpdateInterruptibleCapacityReservationAllocationInput, optFns ...func(*Options)) (*UpdateInterruptibleCapacityReservationAllocationOutput, error) {
	if params == nil {
		params = &UpdateInterruptibleCapacityReservationAllocationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateInterruptibleCapacityReservationAllocation", params, optFns, c.addOperationUpdateInterruptibleCapacityReservationAllocationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateInterruptibleCapacityReservationAllocationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateInterruptibleCapacityReservationAllocationInput struct {

	//  The ID of the source Capacity Reservation containing the interruptible
	// allocation to modify.
	//
	// This member is required.
	CapacityReservationId *string

	//  The new number of instances to allocate. Enter a higher number to add more
	// capacity to share, or a lower number to reclaim capacity to your source Capacity
	// Reservation.
	//
	// This member is required.
	TargetInstanceCount *int32

	//  Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response.
	DryRun *bool

	noSmithyDocumentSerde
}

type UpdateInterruptibleCapacityReservationAllocationOutput struct {

	//  The current number of instances allocated to the interruptible reservation.
	InstanceCount *int32

	//  The ID of the interruptible Capacity Reservation that was modified.
	InterruptibleCapacityReservationId *string

	//  The interruption type for the interruptible reservation.
	InterruptionType types.InterruptionType

	//  The ID of the source Capacity Reservation to which capacity was reclaimed or
	// from which capacity was allocated.
	SourceCapacityReservationId *string

	//  The current status of the allocation (updating during reclamation, active when
	// complete).
	Status types.InterruptibleCapacityReservationAllocationStatus

	//  The requested number of instances for the interruptible Capacity Reservation.
	TargetInstanceCount *int32

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateInterruptibleCapacityReservationAllocationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsEc2query_serializeOpUpdateInterruptibleCapacityReservationAllocation{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpUpdateInterruptibleCapacityReservationAllocation{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateInterruptibleCapacityReservationAllocation"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateInterruptibleCapacityReservationAllocationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateInterruptibleCapacityReservationAllocation(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateInterruptibleCapacityReservationAllocation(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateInterruptibleCapacityReservationAllocation",
	}
}
